<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Sul on võimalik seda testi eelvaadelda, aga kui sa prooviks seda testi praegu sooritada, siis ei oleks see võimalik järgmis(t)el põhjus(t)el:';
$string['action'] = 'Tegevus';
$string['activityoverview'] = 'Sul on teste, mille täitmise tähtaeg läheneb lõpule';
$string['adaptive'] = 'Kohanemisvõimeline režiim';
$string['adaptive_help'] = 'Kui sisse lülitatud, siis mitu vastust küsimusele on lubatud testi samas soorituses. Seega näiteks kui vastus on märgitud kui vale, siis õpilasel on lubatud proovida kohe uuesti. Siiski sõltudes "Rakenda trahvid" seadetest, karistus võidakse tavaliselt olla lahutatud iga vale soorituse eest.';
$string['addaquestion'] = 'Lisa küsimus...';
$string['addarandomquestion'] = 'Lisa juhuslik küsimus...';
$string['addarandomquestion_help'] = 'Kui juhuslik küsimus on lisatud, siis selle tulemusena võetakse juhuslik küsimus valitud kategooriast ja lisatakse testi. See tähendab seda, et erinevatele tudengitele antakse erinevad küsimused, erinevas järjekorras. Kui testi on võimalik sooritada mitu korda, siis suure tõenäosusega saavad igakord õppijad erinevad küsimused, erinevas järjekorras.';
$string['adddescriptionlabel'] = 'Lisa kirjeldus/silt';
$string['addingquestion'] = 'Küsimuse lisamine';
$string['addingquestions'] = 'Lehekülje selles osas saate hallata oma küsimuste andmebaasi. Küsimused on salvestatud kategooriate kaupa, et hoida neid organiseeritult, ja Te saate kasutada neid küsimusi igas oma kuruse testis ning ka teiste kursuste testides, kui olete otustanud küsimused avalikustada.<br /><br />Pärast seda, kui olete valinud või lisanud küsimuse kategooria, saate lisada või muuta küsimusi. Võite valida ükskõik millised neist küsimustest, et lisada need oma testi, mis asub lehekülje teises osas.';
$string['addmoreoverallfeedbacks'] = 'Lisa veel {no} tagasiside välja';
$string['addnewgroupoverride'] = 'Lisa grupi ümber kehtestamine';
$string['addnewpagesafterselected'] = 'Lisa uued lehed peale valitud küsimusi';
$string['addnewquestionsqbank'] = 'Lisa küsimusi kategooriasse {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Lisa kasutaja ümber kehtestamine';
$string['addpagehere'] = 'Lisa leht siia';
$string['addquestion'] = 'Lisa küsimus';
$string['addquestions'] = 'Lisa küsimusi';
$string['addquestionstoquiz'] = 'Lisa küsimusi käesolevasse testi';
$string['addrandom'] = 'Lisa {$a} juhuslikku küsimust';
$string['addrandom1'] = '<< Lisa';
$string['addrandom2'] = 'juhuslikud küsimused';
$string['addrandomfromcategory'] = 'Lisa juhuslikud küsimused kategooriast:';
$string['addrandomquestion'] = 'Lisa juhuslik küsimus';
$string['addrandomquestiontoquiz'] = 'Lisa juhuslik küsimus testi {$a}';
$string['addselectedtoquiz'] = 'Lisa valitud küsimused testi';
$string['addtoquiz'] = 'Lisa testi';
$string['affectedstudents'] = 'Mõjutatud {$a}';
$string['aftereachquestion'] = 'Pärast iga küsimuse lisamist';
$string['afternquestions'] = 'Peale {$a} küsimuse lisamist';
$string['age'] = 'vanus';
$string['allattempts'] = 'Kõik katsed';
$string['allinone'] = 'Piiramatu';
$string['allowreview'] = 'Luba tagasivaadet';
$string['alreadysubmitted'] = 'Tõenäoliselt oled selle katse kord juba esitanud.';
$string['alternativeunits'] = 'Alternatiivsed ühikud';
$string['alwaysavailable'] = 'Alati saadaval';
$string['analysisoptions'] = 'Analüüsi valikud';
$string['analysistitle'] = 'Küsimuste analüüsi tabel';
$string['answer'] = 'Vastus';
$string['answered'] = 'Vastatud';
$string['answerhowmany'] = 'Üks või mitu vastust?';
$string['answers'] = 'Vastused';
$string['answersingleno'] = 'Lubatud mitu õiget vastust';
$string['answersingleyes'] = 'Ainult üks vastus';
$string['answertoolong'] = 'Vastus on liiga pikk peale rida {$a} (255 tähemärki max.)';
$string['aon'] = 'AON formaat';
$string['areyousureremoveselected'] = 'Oled sa kindel, et soovid eemaldada kõik valitud küsimused?';
$string['asshownoneditscreen'] = 'Nagu kuvatud muutmise aknas';
$string['attempt'] = '{$a} katse';
$string['attemptalreadyclosed'] = 'See katse on nüüdseks lõpetatud.';
$string['attemptclosed'] = 'Katse ei ole veel suletud';
$string['attemptduration'] = 'Aega kulunud';
$string['attemptedon'] = 'Katsetatud';
$string['attempterror'] = 'Sul ei ole lubatud teha seda testi praegu, sest: {$a}';
$string['attemptfirst'] = 'Esimene katse';
$string['attemptincomplete'] = 'Katse ({$a} poolt) pole veel lõpetatud';
$string['attemptlast'] = 'Viimane katse';
$string['attemptnumber'] = 'Katse';
$string['attemptquiznow'] = 'Vasta testile';
$string['attempts'] = 'Katsed';
$string['attemptsallowed'] = 'Katseid lubatud';
$string['attemptsdeleted'] = 'Testi aktsed on kustutatud';
$string['attemptselection'] = 'Vali, millist kasutaja katset analüüsida';
$string['attemptsexist'] = 'Seda testi on juba täidetud.<br/>Te ei saa enam küsimusi lisada või eemaldada.';
$string['attemptsnum'] = 'Katseid: {$a}';
$string['attemptsnumthisgroup'] = 'Katseid: {$a->total} (grupist {$a->group})';
$string['attemptsnumyourgroups'] = 'Katseid: {$a->total} ({$a->group} sinu gruppidest)';
$string['attemptsonly'] = 'Näita ainult õppureid, kes on katsetanud';
$string['attemptstate'] = 'Olek';
$string['attemptstillinprogress'] = 'Katse on ikka pooleli';
$string['attemptsunlimited'] = 'Piiramatu katsete arv';
$string['autosaveperiod'] = 'Automaatse salvestamise periood';
$string['back'] = 'Tagasi küsimuse eelvaatamisele';
$string['backtocourse'] = 'Tagasi kursuse juurde';
$string['backtoquestionlist'] = 'Tagasi küsimuste lehele';
$string['backtoquiz'] = 'Tagasi testi muutma';
$string['basicideasofquiz'] = 'Testide loomise peamised juhtnöörid';
$string['bestgrade'] = 'Kõrgeim hinne';
$string['bothattempts'] = 'Näita katsetanud ja mittekatsetanud õppureid';
$string['browsersecurity'] = 'Näita testi turvalises aknas';
$string['browsersecurity_help'] = 'Kui on valitud "Täisekraanis hüpikaken koos mõningase SvaScript turvalisusega":

* Test alustub ainult siis kui õpilased on võimaldatud JavaScriptiga brauser
* Test avaneb täisekraani hüpikaknas, mis katab kõik muud aknad ja millel pole navigeerimiskontrolle
* Õpilasel on piiratud nii palju kui võimalik kasutada abivahendeid nagu kopeerimine ja kleepimine';
$string['calculated'] = 'Kalkuleeritud';
$string['calculatedquestion'] = 'Kalkuleeritud küsimust real {$a} ei toetata. Seda küsimust ignoreeritakse.';
$string['cannotcreatepath'] = 'Kausta loomine ei õnnestunud  ({$a})';
$string['cannoteditafterattempts'] = 'Te ei saa lisada või kustutada küsimusi, sest osa õppijaid on juba testi sooritanud.';
$string['cannotfindprevattempt'] = 'Ei leidnud eelmist katset kuhu ehitada.';
$string['cannotinsert'] = 'Küsimuse sisestamine ebaõnnestus';
$string['cannotinsertrandomquestion'] = 'Uue juhusliku küsimuse lisamine ebaõnnestus!';
$string['cannotloadquestion'] = 'Ei saanud laadida küsimuse valikuid';
$string['cannotloadtypeinfo'] = 'Ei saa laadida küsimusetüübi spetsiifilist küsimuse infot';
$string['cannotopen'] = 'Ei saanud avada eksporditud faili ({$a})';
$string['cannotrestore'] = 'Ei saa taastada küsimuste seanssi';
$string['cannotreviewopen'] = 'Sa ei saa üle vaadata seda katsed, sest ta on veel avatud.';
$string['cannotsavelayout'] = 'Ei saanud salvestada paigutust';
$string['cannotstartmissingquestion'] = 'Ei saa alustada selle testi katsega. Testi definitsoo sisaldab küsimust, mida ei eksisteeri.';
$string['cannotwrite'] = 'Ei saa kirjutada eksporditud faili ({$a})';
$string['caseno'] = 'Ei, suured/ väikesed tähed pole olulised';
$string['casesensitive'] = 'Tundlikkus suurtele/väikestele tähtedele';
$string['caseyes'] = 'Jah, suur/ väike täht on oluline';
$string['categories'] = 'Kategooriad';
$string['category'] = 'Kategooria';
$string['categoryadded'] = 'Kategooria \'{$a}\'  lisatud';
$string['categorydeleted'] = 'Kategooria \'{$a}\'  kustutatud';
$string['categorynoedit'] = 'Teil ei ole muutmisõigust kategooriale \'{$a}\'.';
$string['categoryupdated'] = 'Kategooria edukalt uuendatud.';
$string['close'] = 'Sulge aken';
$string['closebeforeopen'] = 'Testi uuendamine ebaõnnestus. Olete sulgemise kuupäeva määranud enne avamise kuupäeva.';
$string['closed'] = 'Suletud';
$string['closepreview'] = 'Sulge eelvaade';
$string['closereview'] = 'Sulge ülevaade';
$string['comment'] = 'Kommentaar';
$string['commentorgrade'] = 'Kirjuta kommentaar või uuenda hinnet';
$string['comments'] = 'Kommentaarid';
$string['completedon'] = 'Lõpetatud';
$string['configadaptive'] = 'Kui valid Jah selle valiku, siis õpilane lubatakse mitu korda vastata küsimusele, isegi samas testisoorituses.';
$string['configattemptsallowed'] = 'Piirang, mitu katsed on õpilasel lubatud testi teha.';
$string['configdecimalplaces'] = 'Mitu komakohta peaks olema kuvatud pärast, mil kuvatakse testi hindeid.';
$string['configdecimalplacesquestion'] = 'Mitu komakohta peaks olema kuvatud pärast, mil kuvatakse üksikute küsimuste hinnet.';
$string['configdelay1st2nd'] = 'Kui sead viitaja siia, siis õpilane ei saa alustada nende teist katset kuni siin määratud aeg ei ole möödunud esimesest katsest.';
$string['configdelaylater'] = 'Kui sead viitaja siia, siis õpilane ei saa alustada nende kolmandat, neljandat, ... katset kuni siin määratud aeg ei ole möödunud eelmisest katsest.';
$string['configeachattemptbuildsonthelast'] = 'Kui mitu katsed on lubatud, siis iga uus katse sisaldab eelmise soorituse tulemusi.';
$string['configgrademethod'] = 'Kui on lubatud mitu katset, siis mis meetodit peaks kasutama arvutamaks õpilase testi lõpphinne.';
$string['configintro'] = 'Need väärtused mis siin määrad, hakkavad olema vaikimisi väärtused, kui hakatakse uut testi looma. Saate ära seadistada ka millised testi seaded on vaikimisi peidetud.';
$string['configmaximumgrade'] = 'Vaikimisi hinne, mis testi hinne on skaalast väljas.';
$string['confignewpageevery'] = 'Kui lisatakse küsimusi testilehele, siis katkestused automaatselt sisestatakse vastavalt sinu valitud seadetele siin.';
$string['configpenaltyscheme'] = 'Karistus lahutatakse iga vale vastuse kohta kohanduvas laadis.';
$string['configpopup'] = 'Sunni katseid avama hüpikaknas ja kasutaj JavaScripti trikke proovimaks vältida kopeerimist ja kleepimist jne. testi katsete ajal.';
$string['configrequirepassword'] = 'Õpilased peavad sisestama parooli enne kui saavad teha testikatset.';
$string['configrequiresubnet'] = 'Õpilased saada teha testikatset ainult nendest arvutitest.';
$string['configreviewoptions'] = 'Need valikud kontrollivad, mis informatsiooni kasutajad saavad näha, mil nad vaatavad üle testi katse või vaatavad testi raporteid.';
$string['configshowblocks'] = 'Kuva plokid testikatse ajal.';
$string['configshowuserpicture'] = 'Kuva testikatsete ajal ekraanil kasutaja pilti.';
$string['configshufflequestions'] = 'Kui sisse lülitatud see valik, siis küsimuste järjekord testis juhuslikult segi aetud iga õpilase testi katse korral.';
$string['configshufflewithin'] = 'Kui sisse lülitatud see valik, siis osad, mis moodustavad iseseisvad küsimused segatakse juhuslikult iga kord, kui õpilane alustab testi katset. See võimalus on võimalik, kui võimaldatud samuti küsimuste seadetes.';
$string['configtimelimit'] = 'Testide vaikimisi ajapiirang minutites. 0 tähendab, et piirangut pole.';
$string['configtimelimitsec'] = 'Testide vaikimisi ajalimiit sekundites. 0 tähendab ajalimiidi puudumist.';
$string['configurerandomquestion'] = 'Seadista küsimus';
$string['confirmclose'] = 'Sa oled seda katset sulgemas. Kui Sa selle katse suled, ei saa Sa oma vastuseid enam muuta.';
$string['confirmserverdelete'] = 'Kas olete kindel, et soovite kustutada serveri <b>{$a} </b> nimekirjast?';
$string['confirmstartattemptlimit'] = 'See test on piiratud {$a} katsega. Oled alustamas uut katset. Kas soovid jätkata?';
$string['confirmstartattempttimelimit'] = 'Sellel testil on ajapiirang ja on piiratud {$a} katsega. Oled alustamas uut katset. Kas soovid jätkata?';
$string['confirmstarttimelimit'] = 'Sellel testil on ajapiirang. Kas oled kindel, et soovid alustada?';
$string['connectionok'] = 'Võrguühendus on taastunud. Sa võid rahulikult jätkata.';
$string['containercategorycreated'] = 'See kategooria on loodud majutamaks kõiki originaalseid kategooriaid, mis on viidud õpikeskkonna tasemele allpool toodud põhjustel';
$string['continueattemptquiz'] = 'Jätka viimast katset';
$string['continuepreview'] = 'Jätka viimase eelvaatega';
$string['copyingfrom'] = 'Küsimusest  \'{$a}\' koopia tegemine';
$string['copyingquestion'] = 'Kopeeri küsimus';
$string['correct'] = 'Õige';
$string['correctanswer'] = 'Õige vastus';
$string['correctanswerformula'] = 'Õige vastuse valem';
$string['correctansweris'] = 'Õige vastus: {$a}';
$string['correctanswerlength'] = 'Olulisi numbrikohti';
$string['correctanswers'] = 'Õiged vastused';
$string['correctanswershows'] = 'Korrektne vastus näitab';
$string['corrresp'] = 'Reageering õigele vastusele';
$string['countdown'] = 'Stardiloendus';
$string['countdownfinished'] = 'Test sulgub, Sa pead oma vastused kohe esitama.';
$string['countdowntenminutes'] = 'Test sulgub 10 minuti pärast.';
$string['coursetestmanager'] = 'Kursuse testide haldamise formaat';
$string['createcategoryandaddrandomquestion'] = 'Loo kategooria ja lisa juhuslik küsimus';
$string['createfirst'] = 'Te peate looma esmalt mõned lühivastustega küsimused.';
$string['createmultiple'] = 'Lisa testi mõned juhuslikud küsimused';
$string['createnewquestion'] = 'Loo uus küsimus';
$string['createquestionandadd'] = 'Lisa uued küsimused ja lisa see testile.';
$string['custom'] = 'Omatehtud formaat';
$string['datasetdefinitions'] = 'Korduvkasutatavate andmestike definitsioonid kategooria {$a} jaoks';
$string['datasetnumber'] = 'Number';
$string['daysavailable'] = 'Mitu päeva avatud:';
$string['decimaldigits'] = 'Kümnendkohti hindes';
$string['decimalplaces'] = 'Komakohtasid hinnetes';
$string['decimalplaces_help'] = 'See seadistus määrab mitu komakohta kuvatakse kuvatakse hindeid või hineid. See avaldab efekti ainult hinnete kuvamisel, mitte andmebaasis hoitavatele hinnetele ega sisestele arvutustele, milles kasutatakse täit täpsust.';
$string['decimalplacesquestion'] = 'Komakohtasid küsimuste hinnetes.';
$string['decimalplacesquestion_help'] = 'See seadistus määrab mitu komakohta peaks olema kuvatud pärast, mil kuvatakse üksikute küsimuste hindeid.';
$string['decimalpoints'] = 'Kümnendkohti';
$string['default'] = 'Vaikimisi';
$string['defaultgrade'] = 'Küsimuse hinde vaikeväärtus';
$string['defaultinfo'] = 'Vaikimisi kategooria küsimuste jaoks';
$string['delay1'] = 'Ajavahe esimese ja teise katse vahel';
$string['delay1st2nd'] = 'Sunnitud viitaeg 1. ja 2. katse vahel';
$string['delay1st2nd_help'] = 'Kui sisse lülitatud, siis õpilane peab ootama määratud aja, enne kui saab hakata tegema testi teist katset';
$string['delay2'] = 'Ajavahe viimaste katsete vahel';
$string['delaylater'] = 'Sunnitud viitaeg katsete vahel';
$string['delaylater_help'] = 'Kui sisse lülitatud, siis õpilane peab ootama määratud aja enne kui saab sooritada testi kolmandat ja rohkemat korda.';
$string['deleteattemptcheck'] = 'Kas olete täiesti kindel, et soovite need katsed täielikult kustutada?';
$string['deleteselected'] = 'Kustutamiseks valitud';
$string['deletingquestionattempts'] = 'Kustutan testi katseid';
$string['description'] = 'Kirjeldus';
$string['disabled'] = 'Keelatud';
$string['displayoptions'] = 'Kuvamise seaded';
$string['donotuseautosave'] = 'Ära kasuta automaatset salvestamist';
$string['download'] = 'Kliki siia, et alla laadida eksporditud kategooria fail.';
$string['downloadextra'] = '(fail on salvestatud ka kursuse failide juurde testi kausta)';
$string['duplicateresponse'] = 'Seda esitust ei arvestata, sest selle vastused ühtivad eelmise esituse omadega.';
$string['eachattemptbuildsonthelast'] = 'Iga katse põhineb eelmisel';
$string['eachattemptbuildsonthelast_help'] = 'Kui on võimalik testi sooritatada mitu korda, siis igas test sisaldab, eelnevaid tulemusi. Selle tulemusena on võimalik test täielikult sooritada, kui mitu korda tehakse samat testi.';
$string['editcategories'] = 'Muuda kategooriaid';
$string['editcategory'] = 'Muuda kategooriat';
$string['editcatquestions'] = 'Muuda kategooria küsimusi';
$string['editingquestion'] = 'Küsimuse muutmine';
$string['editingquiz'] = 'Testi muutmine';
$string['editingquiz_help'] = 'Kui testi lood põhiliselt koosneb see:

* Testist, kus saavad olla küsimused ühel või mitmel lehel
* Küsimuste pank, mille sees hoitakse küsimusi kategooriates.
* Juhuslikud küsimused - Õppijad saavad igal sooritusel erinevad küsimused.';
$string['editingquizx'] = 'Testi {$a} muutmine';
$string['editoverride'] = 'Muuda ümber kehtestamist';
$string['editqcats'] = 'Muuda küsimuste kategooriaid';
$string['editquestions'] = 'Muuda küsimusi';
$string['editquiz'] = 'Muuda testi';
$string['editquizquestions'] = 'Muuda testi küsimusi';
$string['emailconfirmbody'] = 'Austatud {$a->username},

Täname sind oma vastust postitamaks testile \'{$a->quizname}\'
kursuses \'{$a->coursename}\'
kell {$a->submissiontime}.

See teade kinnitab, et me oleme saanud kätte su vastused.

Sa saad ligi pääseda selle testi poole {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Täname esitamast \'{$a->quizname}\' oma vastused';
$string['emailconfirmsubject'] = 'Testi esitamise kinnitus: {$a->quizname}';
$string['emailnotifybody'] = 'Lugupeetud {$a->username},

{$a->studentname} on lõpetanud testi \'{$a->quizname}\' ({$a->quizurl}) kursusel \'{$a->coursename}\'

Saad edastatud katse üle vaadata aadressil {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} on lõpetanud testi {$a->quizname}. Vaata {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} on lõpetanud testi {$a->quizname}';
$string['emailoverduesubject'] = 'Katse on tähtaja ületanud: {$a->quizname}';
$string['empty'] = 'Tühi';
$string['enabled'] = 'Lubatud';
$string['endtest'] = 'Lõpeta katse...';
$string['erroraccessingreport'] = 'Sul ei ole raportile ligipääsu';
$string['errorinquestion'] = 'Viga küsimuses';
$string['errormissingquestion'] = 'Viga: süsteemis pole küsimust IDga {$a}';
$string['errornotnumbers'] = 'Viga: vastus peab olema arvuline';
$string['errorunexpectedevent'] = 'Ootamatu sündmuse kood {$a->event} leiti küsimuse {$a->questionid} kohta katses {$a->attemptid}.';
$string['essay'] = 'Essee';
$string['essayquestions'] = 'Küsimused';
$string['eventquizattemptabandoned'] = 'Testi katse on hüljatud';
$string['eventquizattemptstarted'] = 'Testi katset on alustatud';
$string['eventquizattemptsubmitted'] = 'Testi katse on edastatud';
$string['eventquizattempttimelimitexceeded'] = 'Testi ajalimiit on saavutatud';
$string['everynquestions'] = 'Iga {$a} küsimus';
$string['everyquestion'] = 'Iga küsimus';
$string['everythingon'] = 'Kõik sisse';
$string['export'] = 'Ekspordi';
$string['exportcategory'] = 'ekspordi kategooria';
$string['exporterror'] = 'Eksportimisel tekkis viga';
$string['exportingquestions'] = 'Küsimus eksporditakse faili';
$string['exportname'] = 'Faili nimi';
$string['exportquestions'] = 'Ekspordi küsimused faili';
$string['extraattemptrestrictions'] = 'Ekstra piirangud katsetele';
$string['false'] = 'Väär';
$string['feedback'] = 'Tagasiside';
$string['feedbackerrorboundaryformat'] = 'Tagasiside hinne piirid peavad olema kas protsent või number. Piiriks sisestatud väärtus {$a} ei ole vastuvõetav';
$string['feedbackerrorboundaryoutofrange'] = 'Tagasiside hinde piirid peavad olema vahemikus 0% ja 100%. Sisestatud piiride väärtus {$a} on sellest väljapool.';
$string['feedbackerrorjunkinboundary'] = 'Sa pead täitma tagasiside hinde piiride kastid, jätmata lahknevusi.';
$string['feedbackerrorjunkinfeedback'] = 'Sa pead täitma tagasiside kastid, jätmata ühtegi täitmata.';
$string['feedbackerrororder'] = 'Tagasiside hinde piirid peavad olema järjekorras, kõrgeid esimesena. Sinu sisestatud väärtuste piir {$a} ei ole järjekorras.';
$string['file'] = 'Fail';
$string['fileformat'] = 'Faili formaat';
$string['fillcorrect'] = 'Täida õige';
$string['filloutoneanswer'] = 'Vähemalt üks võimalik vastus peab olema antud. Tühjaks jäetud lahtreid ei kasutata.';
$string['filloutthreequestions'] = 'Pead sisestama vähemalt kolm küsimust. Tühjaks jäetud lahtreid ei kasutata.';
$string['fillouttwochoices'] = 'Vähemalt kaks valikuvarianti peab olema antud. Tühjaks jäetud lahtreid ei kasutata.';
$string['finishattemptdots'] = 'Lõpeta katse...';
$string['finishreview'] = 'Lõpeta ülevaatus';
$string['forceregeneration'] = 'sunni regenereerimine';
$string['formatnotfound'] = 'Import/eksport formaati {$a} ei leitud';
$string['formatnotimplemented'] = 'See formaat ei ole korrektselt implementeeritud, palun saada puugiraport';
$string['formulaerror'] = 'Valemi viga';
$string['fractionsaddwrong'] = 'Teie valitud positiivsete hinnete summa ei anna kokku 100%<br />See on hoopiski {$a}%<br />Kas soovite minna tagasi ja parandada küsimust?';
$string['fractionsnomax'] = 'Üks vastustest peaks olema 100%, nii et selle küsimuse eest<br />oleks
võimalik saada täishinne.
<br />Kas soovite minna tagasi ja parandada küsimust?';
$string['fromfile'] = 'failist:';
$string['functiondisabledbysecuremode'] = 'See funktsionaalsus on praegu välja lülitatud';
$string['generalfeedback'] = 'Üldine tagasiside';
$string['generalfeedback_help'] = 'Üldine tagasiside on tekst, mis kuvatakse pärast seda kui küsimus on sooritatud. Erinevalt tagasisidest konkreetsele küsimusele, mis sõltub antud vastusest, siis alati kuvatakse sama üldine tagasiside.';
$string['grade'] = 'Hinne';
$string['gradeall'] = 'Hinda kõiki';
$string['gradeaverage'] = 'Keskmine hinne';
$string['gradeboundary'] = 'Hinde piirväärtus';
$string['gradeessays'] = 'Hinda esseesid';
$string['gradehighest'] = 'Kõrgeim hinne';
$string['grademethod'] = 'Hindamise meetod';
$string['grademethod_help'] = 'Kui mitu katset on lubatud, siis järgnevad meetodid on kättesaadaval arvutamaks lõplikku testi hinnet:

* Kõrgeim kõikide soorituste hinne
* Keskmine kõikide soorituste hinne
* Esimene sooritus (teisi sooritusi ignoreeritakse)
* Viimane sooritus (kõiki teisi sooritusi ignoreeritakse)';
$string['gradesdeleted'] = 'Testi hinded on kustutatud';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Selle esituse hinded {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Eelnevate trahvidega kokku teeb see <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Selle esituse eest said trahvi {$a}.';
$string['gradingdetailszeropenalty'] = 'Selle esituse eest Sa trahvi ei saanud.';
$string['gradingmethod'] = 'Hindamise meetod: {$a}';
$string['groupoverrides'] = 'Grupi ümber kehtestamised';
$string['groupsnone'] = 'Sellel kursusel pole rühmi';
$string['guestsno'] = 'Vabandust, külalised ei saa teste vaadata ega täita.';
$string['history'] = 'Tagasiside ajalugu:';
$string['howquestionsbehave_desc'] = 'Vaikimisi seadistus, kuidas küsimused toimivad testis.';
$string['imagedisplay'] = 'Pilt näitamiseks';
$string['import'] = 'Impordi';
$string['importcategory'] = 'impordi kategooria';
$string['importerror'] = 'Importimise käigus ilmnes viga';
$string['importfilearea'] = 'Impordi olemasolevast kursuse failist...';
$string['importfileupload'] = 'Impordi üleslaetavast failist...';
$string['importfromthisfile'] = 'Impordi sellest failist';
$string['import_help'] = 'See funktsioon võimaldab importida küsimusi välisest tekstifailist.

Kui su fail sisaldab mitte ASCII märke, siis sa pead kasutama UTF-8 kodeeringut. Ole eriti ettevaatlik failidega, mis loodud Microsoft Office rakendustega, sest nad kasutavad sisemist kodeeringut, mida võidakse mitte korrektselt käsitleda.

Import- ja eksportformaadid on poogitavad ressursid. Muud fakultatiivsed formaadid võivad olla kättesaadavad moodulite ja pluginate (Modules and Plugins) andmebaasis';
$string['importingquestions'] = '{$a} küsimuste importimine failist';
$string['importmax10error'] = 'Küsimuses on viga. Teil ei tohi olla üle kümne vastuse.';
$string['importmaxerror'] = 'Küsimuses on viga. Teil liiga palju vastuseid.';
$string['importquestions'] = 'Impordi küsimused failist';
$string['inactiveoverridehelp'] = '* Õpilasel ei ole Student does not have the correct group or role to attempt the quiz';
$string['incorrect'] = 'Väär';
$string['indivresp'] = 'Iga õppija igale küsimusele antud reageering';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['inprogress'] = 'Pooleli';
$string['introduction'] = 'Sissejuhatus';
$string['invalidattemptid'] = 'Ei ole sellise ID-ga katset';
$string['invalidcategory'] = 'Kategooria ID on vigane';
$string['invalidnumericanswer'] = 'Üks sisestatud vastustest polnud sobiv number';
$string['invalidnumerictolerance'] = 'Sisestatud tolerantsidest üks polnud korrektne number.';
$string['invalidoverrideid'] = 'Vigane ümber kehtestamise ID';
$string['invalidquestionid'] = 'Vigane küsimuse ID';
$string['invalidquizid'] = 'Vigane testi ID';
$string['invalidsource'] = 'Seda allikat ei aktsepteerita.';
$string['invalidsourcetype'] = 'Vigane allika tüüp';
$string['invalidstateid'] = 'Vigane seisu ID';
$string['lastanswer'] = 'Sinu viimane vastus oli';
$string['layout'] = 'Paigutus';
$string['layoutasshown'] = 'Lehe paigutus nagu kuvatud';
$string['layoutasshownwithpages'] = 'Lehe paigutus nagu kuvatud. <small>(Automaatne uus leht iga {$a} küsimuse kohta.)</small>';
$string['layoutshuffledandpaged'] = 'Küsimused juhuslikus järjekorras, {$a} lehe kohta.';
$string['layoutshuffledsinglepage'] = 'Küsimused juhuslikus järjekorras, kõik ühel lehel.';
$string['link'] = 'Viide';
$string['listitems'] = 'Testi küsimuste nimekiri';
$string['literal'] = 'Täht';
$string['loadingquestionsfailed'] = 'Küsimuste laadimine ebaõnnestus: {$a}';
$string['makecopy'] = 'Salvesta uue küsimusena';
$string['managetypes'] = 'Halda küsimuste tüüpe ja servereid';
$string['manualgrading'] = 'Hindamine';
$string['mark'] = 'Esita';
$string['markall'] = 'Esituse lehekülg';
$string['marks'] = 'Punktid';
$string['match'] = 'Vastavusse seadmine';
$string['matchanswer'] = 'Sobiv vastus';
$string['matchanswerno'] = 'Sobiv vastus {$a}';
$string['max'] = 'maksimum';
$string['messageprovider:attempt_overdue'] = 'Hoiatus, mis kuvatakse siis, kui testi esitamise tähtaeg täitub';
$string['messageprovider:confirmation'] = 'Sinu oma esituste kinnitamine';
$string['messageprovider:submission'] = 'Testi esitamiste teavitus';
$string['min'] = 'miinimum';
$string['minutes'] = 'Minutit';
$string['missingcorrectanswer'] = 'Õige vastus peab olema antud';
$string['missingitemtypename'] = 'Puudub nimi';
$string['missingquestion'] = 'Seda küsimust ei ole enam';
$string['modulename'] = 'Test';
$string['modulenameplural'] = 'Testid';
$string['moveselectedonpage'] = 'Teisalda valitud küsimused lehele: {$a}';
$string['multichoice'] = 'Valikvastused';
$string['multipleanswers'] = 'Vali üks või enam vastust.';
$string['multiplier'] = 'Kordaja';
$string['mustbesubmittedby'] = 'See katse tuleb esitada {$a}';
$string['name'] = 'Nimi';
$string['navmethod'] = 'Navigeerimise meetod';
$string['navmethod_free'] = 'Vaba';
$string['navmethod_help'] = 'Järjestikuse navigeerimise meetodi korral peab õppija testi küsimustele vastava määratud järjekorras ja ei saa küsimustes tagasi minna ega edasi hüpata.';
$string['navmethod_seq'] = 'Järjest';
$string['navnojswarning'] = 'Hoiatus: need lingid ei salvesta su vastuseid. Kasuta lehe all olevat nuppu järgmine.';
$string['neverallononepage'] = 'Ei iial, kõik küsimused ühel lehel';
$string['newattemptfail'] = 'Viga: ei saanud alustada uue testikatsega';
$string['newpage'] = 'Uus leht';
$string['newpageevery'] = 'Automaatselt alusta uue lehega';
$string['newpage_help'] = 'Pikemate testide puhul on mõtekas jagada test üle mitme lehe, piirates küsimuste arvu lehe kohta. Mil lisatakse küsimus testi, lehed lisatakse automaatselt vastavalt sellele seadistusele siin. Siiski lehe piiri võib hiljem nihutada käsitsi lehte muutes.';
$string['noanswers'] = 'Ühtegi vastust pole valitud!';
$string['noattempts'] = 'Seda testi pole veel täidetud';
$string['noattemptsfound'] = 'Katseid ei leitud.';
$string['noattemptstoshow'] = 'Pole ühtegi katset, mida näidata';
$string['nocategory'] = 'Vigane või kategooria määramata';
$string['noclose'] = 'Pole sulgemise kuupäeva';
$string['nocommentsyet'] = 'Kommentaare pole veel.';
$string['noconnection'] = 'Hetkel pole ühendust seda küsimust töötleva veebiteenusega. Palun pöördu oma administraatori poole.';
$string['nodataset'] = 'mitte midagi - see ei ole muutuja';
$string['nodatasubmitted'] = 'Andmeid ei esitatud.';
$string['noessayquestionsfound'] = 'Käsitsi hinnatud küsimusi ei leitud';
$string['nogradewarning'] = 'See test ei ole hinnatud, mistõttu pole sul võimalik määrata hindest sõltuvat koondtagasisidet.';
$string['nomoreattempts'] = 'Rohkem katseid pole lubatud';
$string['none'] = 'Pole';
$string['noopen'] = 'Pole avamise kuupäeva';
$string['nooverridedata'] = 'Sa pead ümber kehtestama vähemalt ühe testi seadetest.';
$string['nopossibledatasets'] = 'Mitte ühtegi võimalikku andmestikku';
$string['noquestionintext'] = 'See küsimuse tekst ei sisalda ühtegi lünka';
$string['noquestions'] = 'Ühtegi küsimust pole veel lisatud';
$string['noquestionsfound'] = 'Ühtegi küsimust ei leitud';
$string['noquestionsinquiz'] = 'Selles testis pole ühtegi küsimust';
$string['noquestionsnotinuse'] = 'See juhuslik küsimus ei ole kasutusel, kuni kategooria on tühi.';
$string['noquestionsonpage'] = 'Tühi leht';
$string['noresponse'] = 'Vastus puudub';
$string['noreview'] = 'Sul pole lubatud seda testi üle vaadata';
$string['noreviewattempt'] = 'Sul pole õigust üle vaadata seda katset.';
$string['noreviewshort'] = 'Pole lubatud';
$string['noreviewuntil'] = 'Sul pole lubatud seda testi üle vaadata enne {$a}';
$string['noreviewuntilshort'] = 'Saadaval kuni {$a}';
$string['noscript'] = 'Jätkamiseks peab JavaScript olema lubatud!';
$string['notavailabletostudents'] = 'Pange tähele: see test ei ole hetkel Teie õppijatele avatud';
$string['notenoughrandomquestions'] = 'Seal pole piisavalt küsimusi kategoorias {$a->category} loomaks küsimust {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Pole defineeritud piisavalt alaküsimusi!<br />Kas soovite tagasi minna ja küsimust parandada?';
$string['notimedependentitems'] = 'Praegune testimoodul ei toeta ajast sõltuvaid küsimusi. Te võite seada ajalimiidi kogu testile. Kas soovite valida teistsuguse küsimuse või (või sellest hoolimata kasutada praegust küsimust)?';
$string['notyetgraded'] = 'Pole veel hinnatud';
$string['notyetviewed'] = 'Pole veel vaadatud';
$string['notyourattempt'] = 'See ei ole sinu katse!';
$string['noview'] = 'Sisse loginud kasutajal ei ole lubatud näha seda testi';
$string['numattempts'] = '{$a->studentnum} kasutajat ({$a->studentstring}) on teinud {$a->attemptnum} katset';
$string['numattemptsmade'] = '{$a} katset on tehtud selle testiga';
$string['numberabbr'] = '#';
$string['numerical'] = 'Arvuline';
$string['numquestionsx'] = 'Küsimusi: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Ainult õpetajad võivad eksportida küsimusi';
$string['onlyteachersimport'] = 'Ainult toimetamisõigusega õpetajad võivad importida küsimusi';
$string['onthispage'] = 'See leht';
$string['open'] = 'Pole vastatud';
$string['openclosedatesupdated'] = 'Testi avamise ja sulgemise kuupäevad uuendatud';
$string['optional'] = 'valikuline';
$string['orderandpaging'] = 'Järjestus ja nummerdamine';
$string['orderandpaging_help'] = 'Numbrid 10, 20, 30, ... iga küsimuse vastas viitavad küsimuste järjekorrale. Numbrite suurendamise samm 10 jätab ruumi lisanduvatele küsimustele. Küsimuste ümber järjestamiseks muuda numbrid ja siis kliki nupul "Järjeste küsimused ümber".

Lisamaks lehe piiri pärast konkreetset küsimust, pane linnuke kasti küsimuse järel ja siis kliki nupul "Lisa uued lehed peale valitud küsimusi".

Järjestamaks küsimusi üle mitme lehel kliki nupul "Lehekülgedeks jaotamine" ja vali soovitud küsimuste arv lehe kohta.';
$string['orderingquiz'] = 'Järjestus ja nummerdamine';
$string['orderingquizx'] = 'Järjestus ja nummerdamine: {$a}';
$string['outof'] = '{$a->grade} maksimumist {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade}, maksimaalne: {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Koondtagasiside';
$string['overallfeedback_help'] = 'Koondtagasiside on tekst, mis kuvatakse pärast testi sooritust. Määrates lisaks hinde piirajad (protsentides või numbrites), sõltub kuvatav tagasiside saadud hindest.';
$string['overdue'] = 'Hilinenud';
$string['overduehandling'] = 'Kui aeg saab otsa';
$string['overduehandlingautoabandon'] = 'Katsed peavad olema enne ajalimiidi täitumist esitatud ja vastasel juhul katset ei arvestata';
$string['overduehandlingautosubmit'] = 'Avatud katsed esitatakse automaatselt';
$string['overduehandling_desc'] = 'Mis peaks vaikimisi toimuma, kui õppija ei ole enne ajalimiidi täitumist testi katset esitanud.';
$string['override'] = 'Kehtesta ümber';
$string['overridedeletegroupsure'] = 'Oled sa kindel, et soovid kustutada grupi {$a} ümber kehtestamise?';
$string['overridedeleteusersure'] = 'Oled sa kindel, et soovid kustutada ümber kehtestuse kasutaja {$a} kohta?';
$string['overridegroup'] = 'Kehtesta ümber grupp';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Ümber kehtestamised';
$string['overrideuser'] = 'Kehtesta ümber kasutaja';
$string['overrideusereventname'] = '{$a->quiz} - Ümber kehtestamine';
$string['page-mod-quiz-edit'] = 'Muuda testi lehte';
$string['page-mod-quiz-x'] = 'Iga testi mooduli leht';
$string['pagesize'] = 'Katseid ühel lehel:';
$string['parent'] = 'Näita algatajat';
$string['parentcategory'] = 'Ülemkategooria';
$string['parsingquestions'] = 'Küsimuste parsimine importfailist';
$string['partiallycorrect'] = 'Osaliselt õige';
$string['penalty'] = 'Trahv';
$string['penaltyscheme'] = 'Rakenda trahvid';
$string['penaltyscheme_help'] = 'Kui sisse lülitatud, siis karistus on lahutatud maha lõpphindest valesti vastatud küsimuse eest. Karistuse määr on määratud küsimuse seadetes. See seadistus rakendub ainult kui kohanduv laad on sisse lülitatud.';
$string['percentcorrect'] = 'Õigete vastuste protsent';
$string['pleaseclose'] = 'Sinu päring on töödeldud. Võid nüüd akna sulgeda.';
$string['pluginadministration'] = 'Testide administreerimine';
$string['pluginname'] = 'Test';
$string['popup'] = 'Näita testi "turvalises" aknas';
$string['popupnotice'] = 'Õppijad näevad seda testi turvalises aknas';
$string['preprocesserror'] = 'Juhtus viga eeltöötluse käigus!';
$string['preview'] = 'Eelvaade';
$string['previewquestion'] = 'Küsimuse eelvaade';
$string['previewquiz'] = '{$a} eelvaade';
$string['previewquiznow'] = 'Testi eelvaade';
$string['previous'] = 'Eelmine seisund';
$string['publish'] = 'Avalikusta';
$string['publishedit'] = 'Teil peab olema publitseeriva kursuse luba lisada ja muuta selle kategooria küsimusi';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'nimi';
$string['qti'] = 'IMS QTI formaat';
$string['qtypename'] = 'tüüp, nimi';
$string['question'] = 'Küsimus';
$string['questionbankcontents'] = 'Küsimustepanga sisu';
$string['questionbankmanagement'] = 'Küsimustepanga haldamine';
$string['questionbehaviour'] = 'Küsimuse toimimine';
$string['questioncats'] = 'Küsimuse kategooriad';
$string['questiondeleted'] = 'See küsimus on kustutatud. Palun võta ühendust oma õpetajaga';
$string['questioninuse'] = 'Küsimust \'{$a->questionname}\' kasutatakse hetkel: <br />{$a->quiznames}<br />Küsimust ei kustutata nendest testidest, vaid ainult kategooriast.';
$string['questionname'] = 'Küsimuse nimi';
$string['questionnonav'] = '<span class="accesshide">Küsimus </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Info </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Küsimust {$a} ei laaditud andmebaasist';
$string['questionorder'] = 'Küsimuse järjekord';
$string['questions'] = 'Küsimused';
$string['questionsinclhidden'] = 'Küsimused (kaasaarvatud peidetud)';
$string['questionsinthisquiz'] = 'Küsimused selles testis';
$string['questionsperpage'] = 'Maksimaalne küsimuste arv ühel lehel';
$string['questionsperpagex'] = 'Küsimusi lehekülje kohta: {$a}';
$string['questiontext'] = 'Küsimuse tekst';
$string['questiontextisempty'] = '[Tühi küsimuse tekst]';
$string['questiontype'] = 'Küsimuse tüüp {$a}';
$string['questiontypesetupoptions'] = 'Küsimuste tüüpide seadistused:';
$string['quiz:addinstance'] = 'Lisa uus test';
$string['quiz:attempt'] = 'Katsetada teste';
$string['quizavailable'] = 'Test on avatud kuni: {$a}';
$string['quizclose'] = 'Sulge test';
$string['quizclosed'] = 'See test suletakse {$a}';
$string['quizcloses'] = 'Test sulgub';
$string['quizcloseson'] = 'Testi sulgumise aeg: {$a}';
$string['quiz:deleteattempts'] = 'Kustutada  testide katseid';
$string['quiz:emailconfirmsubmission'] = 'Saa kinnituse aken kui esitatakse';
$string['quiz:emailnotifysubmission'] = 'Saa teavitussõnum, mil katse on esitatud';
$string['quiz:emailwarnoverdue'] = 'Saa teavitussõnum, mil katse sooritamise aeg on läbi saanud ja katse vajab esitamist.';
$string['quiz:grade'] = 'Hinnata teste käsitsi';
$string['quiz:ignoretimelimits'] = 'Ignoreerida testide ajapiirangut';
$string['quizisclosed'] = 'See test on suletud';
$string['quizisclosedwillopen'] = 'Test suletud (avatakse {$a})';
$string['quizisopen'] = 'See test on avatud';
$string['quizisopenwillclose'] = 'Test avatud (suletakse {$a})';
$string['quiz:manage'] = 'Hallata teste';
$string['quiz:manageoverrides'] = 'Halda testide ümber kehtestamisi';
$string['quiznavigation'] = 'Testi navigatsioon';
$string['quizopen'] = 'Ava test';
$string['quizopenclose'] = 'Avamise ja sulgemise kuupäevad';
$string['quizopenclose_help'] = 'Õpilased saavad alustada katse(te)ga peale avamisaega ja nad peavad olema lõpetanud oma katsed enne sulgemisaega.';
$string['quizopened'] = 'See test on avatud.';
$string['quizopenedon'] = 'Testi avamise aeg: {$a}';
$string['quizopens'] = 'Test avaneb';
$string['quizopenwillclose'] = 'See test on avatud ja sulgub {$a} kell';
$string['quiz:preview'] = 'Vaadata eelvaadet';
$string['quiz:regrade'] = 'Taashinda testi katseid';
$string['quiz:reviewmyattempts'] = 'Vaata üle oma katseid';
$string['quizsettings'] = 'Testi seaded';
$string['quiztimer'] = 'Testi taimer';
$string['quiz:view'] = 'Vaadata testi andmeid';
$string['quiz:viewreports'] = 'Vaadata testi ülevaateid';
$string['quizwillopen'] = 'See test avatakse {$a}';
$string['random'] = 'Juhuslik küsimus';
$string['randomcreate'] = 'Loo juhuslikke küsimusi';
$string['randomfromcategory'] = 'Juhuslik küsimus kategooriast:';
$string['randomfromexistingcategory'] = 'Juhuslik küsimus olemas olevast kategooriast';
$string['randomnosubcat'] = 'Küsimused ainult sellest kategooriast, mitte alamkategooriatest.';
$string['randomquestionusinganewcategory'] = 'Juhuslik küsimus kasutades uut kategooriat';
$string['randomwithsubcat'] = 'Küsimused sellest kategooriast ja alamkategooriatest.';
$string['readytosend'] = 'Oled saatmas kogu oma testi hindamisele. Kas oled veendunud, et soovid jätkata?';
$string['reattemptquiz'] = 'Tee test uuesti';
$string['recentlyaddedquestion'] = 'Hiljuti lisatud küsimus!';
$string['recurse'] = 'Näita ka alamkategoorias asuvaid küsimusi';
$string['regrade'] = 'Hinda kõik katsed uuesti';
$string['regradecomplete'] = 'Kõik katsed on uuesti hinnatud';
$string['regradecount'] = '{$a->changed} hinnet {$a->attempt} hindest muudetud';
$string['regradedisplayexplanation'] = 'Hindamise ajal muutunud katseid kuvatakse hüperlinkidena küsimuste ülevaatamise aknasse.';
$string['regradenotallowed'] = 'Sul ei ole õigusi uuesti hinnata seda testi';
$string['regradingquestion'] = 'Hindan uuesti "{$a}".';
$string['regradingquiz'] = 'Hindan uuesti testi "{$a}"';
$string['remove'] = 'Kustuta';
$string['removeallquizattempts'] = 'Kustuta kõik sooritused';
$string['removeemptypage'] = 'Eemalda tühi leht';
$string['removeselected'] = 'Eemalda valitud';
$string['rename'] = 'Nimeta ümber';
$string['renderingserverconnectfailed'] = 'Server {$a} ei suutnud RQP päringut töödelda. Kontrolli, kas URL on õige.';
$string['reorderquestions'] = 'Järjeste küsimused ümber';
$string['reordertool'] = 'Näita ümberkorraldamise vahendit';
$string['repaginate'] = 'Loo leheküljed ümber, nii et igal lehel on {$a} küsimust';
$string['repaginatecommand'] = 'Lehekülgedeks jaotamine';
$string['repaginatenow'] = 'Jaota lehekülgedeks nüüd';
$string['replace'] = 'Asenda';
$string['replacementoptions'] = 'Asenduse valikud';
$string['report'] = 'Aruanded';
$string['reportanalysis'] = 'Küsimuste analüüs';
$string['reportattemptsfrom'] = 'Katsed alates';
$string['reportattemptsthatare'] = 'Katsed, mis on';
$string['reportdisplayoptions'] = 'Kuvamise valikud';
$string['reportfullstat'] = 'Detailne statistika';
$string['reportmulti_percent'] = 'Multi-protsendid';
$string['reportmulti_q_x_student'] = 'Mitme-õppija valikud';
$string['reportmulti_resp'] = 'Individuaalsed reageeringud';
$string['reportmustselectstate'] = 'Pead valima vähemalt ühe oleku.';
$string['reportnotfound'] = 'Raportit ei teata ({$a})';
$string['reportoverview'] = 'Ülevaade';
$string['reportregrade'] = 'Hinda katseid uuesti';
$string['reportresponses'] = 'Reageeringute detailid';
$string['reports'] = 'Aruanded';
$string['reportshowonly'] = 'Näita vaid katseid';
$string['reportsimplestat'] = 'Lihtne statistika';
$string['reportusersall'] = 'kõik kasutajad, kes on proovinud testi lahendada';
$string['reportuserswith'] = 'registreerunud kasutajad, kes on proovinud testi lahendada';
$string['reportuserswithorwithout'] = 'registreerunud kasutajad, kes on (või pole) proovinud testi lahendada';
$string['reportuserswithout'] = 'registreerunud kasutajad, kes pole proovinud testi lahendada';
$string['reportwhattoinclude'] = 'Mida kaasata raportisse';
$string['requirepassword'] = 'Nõua salasõna';
$string['requirepassword_help'] = 'Kui parool on määratud, siis õpilane peab sisestama parooli, et saada avada testi.';
$string['requiresubnet'] = 'Nõua võrguaadressi';
$string['requiresubnet_help'] = 'Testi ligipääs võib olla piiratud konkreetsetesse alamvõrkudesse LAN-s (kohtvõrgus) või Internetis määrates osalise või täis-IP-aadressi numbrid komadega eraldatud nimekirjana. See saab olla kasutatav valvatud testide puhul, tagamaks, et inimesed kindlatest kohtadest omavad ligipääsu testile.';
$string['response'] = 'Reageering';
$string['responses'] = 'Reageeringud';
$string['results'] = 'Tulemused';
$string['returnattempt'] = 'Pöördu tagasi katse juurde';
$string['reuseifpossible'] = 'taaskasuta hiljuti eemaldatud';
$string['reverttodefaults'] = 'Tagasi testi vaikeväärtusteks';
$string['review'] = 'Ülevaade';
$string['reviewafter'] = 'Luba üle vaadata peale testi sulgemist';
$string['reviewalways'] = 'Luba üle vaadata igal ajal';
$string['reviewattempt'] = 'Vaata üle katse';
$string['reviewbefore'] = 'Luba üle vaadata, kui test on avatud';
$string['reviewclosed'] = 'Pärast testi sulgemist';
$string['reviewduring'] = 'Katse keskel';
$string['reviewimmediately'] = 'Kohe peale katset';
$string['reviewnever'] = 'Ära kunagi luba ülevaadet';
$string['reviewofattempt'] = 'Katse {$a} ülevaade';
$string['reviewofpreview'] = 'Eelvaatuse ülevaatus';
$string['reviewopen'] = 'Hiljem, kui test on veel avatud';
$string['reviewoptions'] = 'Õppijad võivad üle vaadata';
$string['reviewoptionsheading'] = 'Ülevaade';
$string['reviewoverallfeedback'] = 'Koondtagasiside';
$string['reviewoverallfeedback_help'] = 'Tagasiside, mis antakse katse lõpus vastavalt saavutatud tulemusele.';
$string['reviewresponse'] = 'Vaata reageering üle';
$string['reviewresponsetoq'] = 'vastuse ülevaatus (küsimus {$a})';
$string['reviewthisattempt'] = 'Vaata üle oma vastused sellele katsele';
$string['rqp'] = 'Väline küsimus';
$string['rqps'] = 'Välised küsimused';
$string['sameasoverall'] = 'Sama nagu üldhinnete puhul';
$string['save'] = 'Salvesta';
$string['saveandedit'] = 'Salvesta muudatused ja muuda küsimusi';
$string['saveattemptfailed'] = 'Käesoleva testikatse salvestamine ebaõnnestus';
$string['savedfromdeletedcourse'] = 'Salvestatud kustutatud kursuselt  "{$a}"';
$string['savegrades'] = 'Salvesta hinded';
$string['savemyanswers'] = 'Salvesta minu vastused';
$string['savenosubmit'] = 'Salvesta ilma esitamiseta';
$string['saveoverrideandstay'] = 'Salvesta ja sisesta muu ümber kehtestus';
$string['savequiz'] = 'Salvesta kogu test';
$string['saving'] = 'Salvestan';
$string['savingnewgradeforquestion'] = 'Uue hinde salvestamine küsimusele ID {$a}.';
$string['savingnewmaximumgrade'] = 'Uue maksimaalse hinde salvestamine.';
$string['score'] = 'Esialgne skoor';
$string['scores'] = 'Skoorid';
$string['select'] = 'Vali';
$string['selectall'] = 'Vali kõik';
$string['selectcategory'] = 'Vali kategooria';
$string['selectedattempts'] = 'Valitud katsed...';
$string['selectnone'] = 'Võta kõigil märgistus maha';
$string['selectquestiontype'] = '-- Vali küsimuse tüüp --';
$string['serveradded'] = 'Server lisatud';
$string['serveridentifier'] = 'Identifikaator';
$string['serverinfo'] = 'Serveri info';
$string['servers'] = 'Serverid';
$string['serverurl'] = 'Serveri URL';
$string['settingsoverrides'] = 'Seadistuste ülekirjutamised';
$string['shortanswer'] = 'Lühivastus';
$string['show'] = 'Näita';
$string['showall'] = 'Näita kõiki küsimusi ühel lehel';
$string['showblocks'] = 'Kuva plokid testikatsete ajal';
$string['showblocks_help'] = 'Kui seatud Jah, siis tavalised plokid kuvatakse testikatsete ajal';
$string['showbreaks'] = 'Näita leheküljepiiri';
$string['showcategorycontents'] = 'Kuva kategooria sisusid {$a->arrow}';
$string['showcorrectanswer'] = 'Kas näitan tagasisides õigeid vastuseid?';
$string['showdetailedmarks'] = 'Näita hinde detaile';
$string['showeachpage'] = 'Kuva korraga üks aken';
$string['showfeedback'] = 'Kas näitan pärast vastamist tagasisidet?';
$string['showinsecurepopup'] = 'Kasuta katsete jaoks \'turvalisi\' hüpikaknaid';
$string['showlargeimage'] = 'Suur pilt';
$string['shownoattempts'] = 'Näita õppijaid, kes pole teinud katseid';
$string['shownoattemptsonly'] = 'Näita ainult õppijaid, kes pole teinud katseid';
$string['shownoimage'] = 'Pilt puudub';
$string['showreport'] = 'Kuva raport';
$string['showsmallimage'] = 'Väike pilt';
$string['showteacherattempts'] = 'Näita õpetaja katseid';
$string['showuserpicture'] = 'Kuva kasutaja pilt';
$string['showuserpicture_help'] = 'Kui sisse lülitatud, siis õpilase nime ja pilti kuvatakse ekraanil soorituse ajal ja ülevaatuse aknas, tehes lihtsamaks kontrollimaks, et õpilane on sisse loginud iseendana jälgitavale eksamile.';
$string['shuffle'] = 'Muuda järjekorda';
$string['shuffleanswers'] = 'Muuda vastuste järjekorda';
$string['shuffledrandomly'] = 'Paigutatud juhuslikult';
$string['shufflequestions'] = 'Muuda küsimuste järjekorda';
$string['shufflequestionsselected'] = 'Kasutusel segatud küsimused, mistõttu mõned seotud lehed ei ole kättesaadavad. Muutmaks segatuse valikud, {$a}.';
$string['shufflewithin'] = 'Muuda järjekorda küsimuste sees';
$string['shufflewithin_help'] = 'Kui sisse lülitatud see valik, siis osad, mis moodustavad iseseisvad küsimused segatakse juhuslikult iga kord, kui õpilane alustab testi katset. See võimalus on võimalik, kui võimaldatud samuti küsimuste seadetes. See seadistus rakendub ainult küsimustele, millel on mitu osa, nagu mitmikvalik või vastavusse viimise küsimused.';
$string['singleanswer'] = 'Vali üks vastus.';
$string['sortage'] = 'Järjesta vanuse järgi';
$string['sortalpha'] = 'Järjesta alfabeetiliselt';
$string['sortquestionsbyx'] = 'Sorteeri küsimused: {$a}';
$string['sortsubmit'] = 'Järjesta küsimused';
$string['sorttypealpha'] = 'Järjesta liigi, nimetuse järgi';
$string['startagain'] = 'Alusta uuesti';
$string['startattempt'] = 'Alusta katsega';
$string['startedon'] = 'Alustatud';
$string['startnewpreview'] = 'Alusta uut eelvaatlust';
$string['stateabandoned'] = 'Pole kunagi esitatud';
$string['statefinished'] = 'Valmis';
$string['statefinisheddetails'] = 'Esitatud {$a}';
$string['stateinprogress'] = 'Pooleli';
$string['statenotloaded'] = 'Küsimuse {$a} seisu ei laaditud andmebaasist';
$string['stateoverdue'] = 'Tähtaja ületanud';
$string['stateoverduedetails'] = 'Peab olema esitatud {$a}';
$string['status'] = 'Staatus';
$string['stoponerror'] = 'Lõpeta vea korral';
$string['submitallandfinish'] = 'Esita kõik ja lõpeta';
$string['subneterror'] = 'Vabandame, see küsimus on lukustatud, seega kättesaadav ainult teatud asukohtadest. Hetkel ei ole sinu arvuti lubatute nimekirjas.';
$string['subnetnotice'] = 'See küsimus on lukustatud, seega kättesaadav ainult teatud asukohtadest. Sinu arvuti ei kuulu lubatud alamvõrku. Aga õpetajana on sul lubatud eelvaadet näha nagunii.';
$string['subplugintype_quiz'] = 'RAport';
$string['subplugintype_quizaccess'] = 'Ligipääsureegel';
$string['subplugintype_quizaccess_plural'] = 'Ligipääsureeglid';
$string['subplugintype_quiz_plural'] = 'Raportid';
$string['substitutedby'] = 'asendatakse';
$string['summaryofattempt'] = 'Katse kokkuvõte';
$string['summaryofattempts'] = 'Sinu testitulemuste kokkuvõte';
$string['theattempt'] = 'Katse';
$string['time'] = 'Aeg';
$string['timecompleted'] = 'Lõpetatud';
$string['timeleft'] = 'Aega jäänud';
$string['timelimit'] = 'Ajapiirang';
$string['timelimitexeeded'] = 'Vabandame! Testi sooritamise aeg ületatud!';
$string['timelimit_help'] = 'Kui sisse lülitatud, siis kella aken (nõuab JavaScripti) on kuvab pöördloendust. Kui ajalimiit on otsa saanud, siis test postitatakse automaatselt, vaatamata väljade täidetusele.';
$string['timelimitmin'] = 'Ajalimiit (minutites)';
$string['timelimitsec'] = 'Ajalimiit (sekundites)';
$string['timestr'] = '%H:%M:%S on %d.%m.%y';
$string['timesup'] = 'Aeg on läbi!';
$string['timetaken'] = 'Aega kulus';
$string['timing'] = 'Ajastamine';
$string['tofile'] = 'faili';
$string['tolerance'] = 'Tolerantsus';
$string['toomanyrandom'] = 'Nõutud juhuslike küsimuste arv on suurem kui kategoorias sisalduvate küsimuste arv! ({$a})';
$string['top'] = 'Tipp';
$string['totalmarksx'] = 'Hinnete kogusumma: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Kategoorias kokku {$a} küsimust.';
$string['true'] = 'Tõene';
$string['truefalse'] = 'Tõene/väär';
$string['type'] = 'Tüüp';
$string['unfinished'] = 'ava';
$string['ungraded'] = 'Hindamata';
$string['unit'] = 'Ühik';
$string['unknowntype'] = 'Küsimuse tüüp real {$a} ei ole toetatud. Küsimust ignoreeritakse.';
$string['unusedcategorydeleted'] = 'See kategooria kustutati, kuna pärast kursuse kustutamist ei kasutatud serveris enam selle kategooria küsimusi.';
$string['updatesettings'] = 'Uuenda testi seadeid';
$string['updatingatttemptgrades'] = 'Katse hinnete uuendamine';
$string['updatingfinalgrades'] = 'Lõpphinnete uuendamine';
$string['updatingthegradebook'] = 'Hinnetelehe uuendamine.';
$string['upgradesure'] = '<div style="color: red;">Testi moodul hakkab tegema ulatuslikku testitabelite muutust ja seda uuendust ei ole veel korralikult testitud. On väga soovitatav, et sa varundaksid oma andmebaasi tabelid enne jätkamist.';
$string['upgradingquizattempts'] = 'Testi katsete täiendamine: test {$a->done}/{$a->outof} (Testi ID {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Väga vanade testi katsete täiendamine: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'See kategooria liigutati õpikeskkonna tasemele, kuna pärast kursuse kustutamist kasutati selle kategooria küsimusi serveri teistes testides.';
$string['useroverrides'] = 'Kasutaja ümber kehtestamised';
$string['usersnone'] = 'Õpilastel ei ole ligipääsu sellele testile';
$string['validate'] = 'Kinnita';
$string['viewallanswers'] = 'Vaata {$a} testikatset';
$string['viewallreports'] = 'Vaata {$a} katse kokkuvõtet';
$string['viewed'] = 'Vaadatud';
$string['warningmissingtype'] = '<b>Seda küsimuse tüüpi ei ole veel Sinu kasutuses olevasse Moodle\'sse installeeritud.<br />Palun oma Moodle administraatori poole.</b>';
$string['wheregrade'] = 'Kus on minu hinded?';
$string['wildcard'] = 'Muutuja';
$string['windowclosing'] = 'See aken sulgub natukese aja pärast.';
$string['withsummary'] = 'koos kokkuvõtliku statistikaga';
$string['wronguse'] = 'Sa ei saa kasutada seda lehekülge niimoodi';
$string['xhtml'] = 'XHTML formaat';
$string['youneedtoenrol'] = 'Sa pead kursusele registreeruma enne selle testi tegemist';
$string['yourfinalgradeis'] = 'Sinu lõpphinne selle testi eest on {$a}';
