<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'hakatakse paigaldama';
$string['action'] = 'Toiming';
$string['actionchoice'] = 'Mida Sa soovid teha failiga \'{$a}\'?';
$string['actions'] = 'Toimingud';
$string['active'] = 'Aktiivne';
$string['activeusers'] = 'Aktiivsed kasutajad';
$string['activities'] = 'Tegevused';
$string['activities_help'] = 'Erinevad tegevused nagu foorumid, küsimustikud ja wikid lubavad interaktiivsed sisu lisada kursusele.';
$string['activity'] = 'Tegevus';
$string['activityclipboard'] = 'Liigutan järgmist tegevust: {$a}';
$string['activityiscurrentlyhidden'] = 'Kahjuks on see tegevus hetkel peidetud';
$string['activitymodule'] = 'Tegevuse moodul';
$string['activitymodules'] = 'Tegevuste moodulid';
$string['activityreport'] = 'Tegevuse aruanne';
$string['activityreports'] = 'Tegevuste aruanded';
$string['activityselect'] = 'Vali see tegevus mujale viimiseks';
$string['activitysince'] = 'Tegevus alates {$a}';
$string['activityweighted'] = 'Tegevus kasutajate kaupa';
$string['add'] = 'Lisa';
$string['addactivity'] = 'Lisa tegevus...';
$string['addactivitytosection'] = 'Lisa tegevus sektsiooni \'{$a}\'';
$string['addadmin'] = 'Lisa administraator';
$string['addblock'] = 'Lisa plokk';
$string['addcomment'] = 'Lisa kommentaar...';
$string['addcountertousername'] = 'Loo kasutaja lisades number kasutajatunnusesse';
$string['addcreator'] = 'Lisa kursuse disainer';
$string['adddots'] = 'Lisa...';
$string['added'] = 'Lisatud {$a}';
$string['addedrecip'] = 'Lisatud {$a} uus vastuvõtja';
$string['addedrecips'] = 'Lisatud {$a} uut vastuvõtjat';
$string['addedtogroup'] = 'Lisatud rühma "{$a}"';
$string['addedtogroupnot'] = 'Ei lisatud rühma "{$a}"';
$string['addedtogroupnotenrolled'] = 'Ei lisatud rühma "{$a}", kuna Sa ei ole kursuse nimekirjas';
$string['addfilehere'] = 'Lisa fail(id) siia';
$string['addinganew'] = 'Lisan uue objekti: {$a}';
$string['addinganewto'] = 'Lisan uue vahendi: {$a->what} - asukohta {$a->to}';
$string['addingdatatoexisting'] = 'Lisan andmed olemasolevasse';
$string['additionalnames'] = 'Täiendavad nimed';
$string['addlinkhere'] = 'Lisa link siia';
$string['addnewcategory'] = 'Lisa uus kategooria';
$string['addnewcourse'] = 'Lisa uus kursus';
$string['addnewuser'] = 'Lisa uus kasutaja';
$string['addnousersrecip'] = 'Lisa kasutajad, kes pole veel sisenenud {$a} adressaatide nimekirja';
$string['addpagehere'] = 'Lisa siia leht';
$string['addresource'] = 'Lisa vahend...';
$string['addresourceoractivity'] = 'Lisa tegevus või vahend';
$string['addresourcetosection'] = 'Lisa vahend sektsiooni \'{$a}\'';
$string['address'] = 'Aadress';
$string['addstudent'] = 'Lisa õppija';
$string['addsubcategory'] = 'Lisa alamkategooria';
$string['addteacher'] = 'Lisa õpetaja';
$string['admin'] = 'Administraator';
$string['adminhelpaddnewuser'] = 'Uue kasutajakonto loomiseks käsitsi';
$string['adminhelpassignadmins'] = 'Administraatorid saavad selles õpikeskkonnas kõike teha ja igale poole minna';
$string['adminhelpassigncreators'] = 'Disainerid saavad luua uusi kursusi ja neis õpetada';
$string['adminhelpassignsiteroles'] = 'Määra õpikeskkonna rollid erikasutajale';
$string['adminhelpassignstudents'] = 'Mine kursusele ja lisa õppijaid administreerimise menüüst';
$string['adminhelpauthentication'] = 'Sa saad kasutada süsteemisiseseid kasutajakontosid või väliseid andmebaase';
$string['adminhelpbackup'] = 'Seadista automaatne varukoopia tegemine ja ajasta see';
$string['adminhelpconfiguration'] = 'Seadista õpikeskkonna väljanägemine ja töö';
$string['adminhelpconfigvariables'] = 'Seadista muutujad, mis mõjutavad süsteemi üldist tööd';
$string['adminhelpcourses'] = 'Määratle kursused ja kursuste kategooriad ning määra nendes osalejad';
$string['adminhelpeditorsettings'] = 'Määratle  HTML-toimeti seaded';
$string['adminhelpedituser'] = 'Sirvi kasutajakontode nimekirja ja muuda ükskõik millist neist';
$string['adminhelpenvironment'] = 'Kontrolli kuidas server rahuldab praegusi ja tulevasi instaleerimiste nõudeid';
$string['adminhelpfailurelogs'] = 'Sirvi ebaõnnestunud sisenemisi';
$string['adminhelplanguage'] = 'Keelefailide kontroll ja muutmine';
$string['adminhelplogs'] = 'Sirvi õpikeskkonna kõiki tegevusi';
$string['adminhelpmanageblocks'] = 'Installeeritud plokkide ja nende seadete haldamine';
$string['adminhelpmanagedatabase'] = 'Otsene ligipääs andmebaasile (ole ettevaatlik!)';
$string['adminhelpmanagefilters'] = 'Vali tekstifiltrid ja nende seadistused';
$string['adminhelpmanagemodules'] = 'Paigaldatud moodulite ja nende seadete haldamine';
$string['adminhelpmanageroles'] = 'Loo rolle mida on võimalik määrata hiljem kasutajatele.';
$string['adminhelpmymoodle'] = 'Seadista Minu Moodle plokk kasutajatele';
$string['adminhelpreports'] = 'Õpikeskkonna ülevaated';
$string['adminhelpsitefiles'] = 'Üldiste failide publitseerimine või välise varukoopia üleslaadimine';
$string['adminhelpsitesettings'] = 'Määra esilehe kujundus';
$string['adminhelpthemes'] = 'Määra õpikeskkonna kujundus(värvid, tähestiilid jne)';
$string['adminhelpuploadusers'] = 'Impordi uued kasutajakontod tekstifailist';
$string['adminhelpusers'] = 'Määra kasutajad ja seadista autentimine';
$string['adminhelpxmldbeditor'] = 'Liides redigeerimaks XMLDB faile. Ainult arendajatele.';
$string['administration'] = 'Administreerimine';
$string['administrationsite'] = 'Õpikeskkonna administreerimine';
$string['administrator'] = 'Administraator';
$string['administratordescription'] = 'Administraatorid võivad õpikeskkonnas, kõikidel kursustel teha kõike';
$string['administrators'] = 'Administraatorid';
$string['administratorsall'] = 'Kõik administraatorid';
$string['administratorsandteachers'] = 'Administraatorid ja õpetajad';
$string['advanced'] = 'Täpsem';
$string['advancedfilter'] = 'Täpsem otsing';
$string['advancedsettings'] = 'Täpsemad seaded';
$string['again'] = 'uuesti';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX ja Javascript';
$string['all'] = 'Kõik';
$string['allactions'] = 'Kõik toimingud';
$string['allactivities'] = 'Kõik tegevused';
$string['allcategories'] = 'Kõik kategooriad';
$string['allchanges'] = 'Kõik muudatused';
$string['alldays'] = 'Kõik päevad';
$string['allfieldsrequired'] = 'Kõik lahtrid tuleb täita';
$string['allfiles'] = 'Kõik failid';
$string['allgroups'] = 'Kõik rühmad';
$string['alllogs'] = 'Kõik sisenemised';
$string['allmods'] = 'Kõik {$a}';
$string['allow'] = 'Luba';
$string['allowinternal'] = 'Luba ka seesmisi meetodeid';
$string['allownone'] = 'Keela kõik';
$string['allownot'] = 'Keeldu';
$string['allparticipants'] = 'Kõik osalejad';
$string['allteachers'] = 'Kõik õpetajad';
$string['alphanumerical'] = 'Võib sisaldada üksnes tähti ja numbreid, sidekriipsu (-) ja punkti (.)';
$string['alreadyconfirmed'] = 'Registreerumine on juba kinnitatud';
$string['always'] = 'Alati';
$string['and'] = '{$a->one} ja {$a->two}';
$string['answer'] = 'Vasta';
$string['any'] = 'Iga';
$string['appearance'] = 'Välimus';
$string['approve'] = 'Kinnita';
$string['areyousure'] = 'Kas oled kindel?';
$string['areyousuretorestorethis'] = 'Kas soovid jätkata?';
$string['areyousuretorestorethisinfo'] = 'Hiljem avaneb võimalus lisada see varukoopia olemasolevale kursusele või luua täiesti uus kursus.';
$string['asc'] = 'Tõusvalt';
$string['assessment'] = 'Hindamine';
$string['assignadmins'] = 'Määra administraatorid';
$string['assigncreators'] = 'Määra kursuse disainerid';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Määra keskkonnaülesed rollid';
$string['authenticateduser'] = 'Autenditud kasutaja';
$string['authenticateduserdescription'] = 'Kõik sisenenud kasutajad.';
$string['authentication'] = 'Autentimine';
$string['authenticationplugins'] = 'Autentimise meetodid';
$string['autosubscribe'] = 'Automaatne liitumine foorumiga';
$string['autosubscribeno'] = 'Ei, ma ei liitu automaatselt foorumiga';
$string['autosubscribeyes'] = 'Jah, kui postitan, siis liitun selle foorumiga';
$string['availability'] = 'Avatus';
$string['availablecourses'] = 'Avatud kursused';
$string['back'] = 'Tagasi';
$string['backto'] = 'Tagasi {$a} juurde';
$string['backtocourselisting'] = 'Tagasi kursuste nimekirja';
$string['backtopageyouwereon'] = 'Tagasi lehele kus sa olid';
$string['backtoparticipants'] = 'Tagasi osalejate lehele';
$string['backup'] = 'Varukoopia';
$string['backupactivehelp'] = 'Vali, kas automaatset varukoopiat teha teha või mitte.';
$string['backupcancelled'] = 'Varukoopia tegemine katkestatud';
$string['backupcoursefileshelp'] = 'Kui on lubatud, siis kursuse failid lisatakse automaatsele varukoopiale';
$string['backupdate'] = 'Varukoopia tegemise kuupäev';
$string['backupdatenew'] = '&nbsp; {$a->TAG} on nüüd {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} oli {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Varukoopia komponendid';
$string['backupexecuteathelp'] = 'Vali, millal alustatakse automaatse varukoopia tegemist.';
$string['backupfailed'] = 'Mõned kursused ei ole salvestatud!';
$string['backupfilename'] = 'varukoopia';
$string['backupfinished'] = 'Varukoopia tegemine õnnestus';
$string['backupfromthissite'] = 'Varukoopia oli tehtud sellel saidil?';
$string['backupgradebookhistoryhelp'] = 'Kui lubatud siis lisatakse hinnetelehe ajalugu automaatsetesse varukoopiatesse. Teadmiseks, et selle valiku toimimiseks ei tohi hinnete ajalugu olla keelatud serveri seadetes (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Vali, kas soovid kursuse mooduleid (koos kasutajainfoga või ilma) lisada automaatsesse varukoopiasse';
$string['backupincludemoduleuserdatahelp'] = 'Vali, kas soovid kasutaja andmete moodulit lisada automaatsesse varukoopiasse.';
$string['backupkeephelp'] = 'Kui mitu viimast varukoopiat iga kursuse kohta soovite talletada? (vanemad kustutatakse automaatselt)';
$string['backuplogdetailed'] = 'Detailne täitmislogi';
$string['backuploglaststatus'] = 'Viimane täitmislogi';
$string['backupmissinguserinfoperms'] = 'Varukoopias puuduvad kasutaja andmed. Harjutuse ja Õpikoja tegevusi ei lisata varukoopiasse, kuna need moodulid ei sobitu sellist tüüpi varukoopiaga.';
$string['backupnext'] = 'Järgmine varukoopia';
$string['backupnotyetrun'] = 'Automaatne varukoopia on ootel';
$string['backuporiginalname'] = 'Varukoopia nimi';
$string['backuproleassignments'] = 'Varunda rolli määrangud nende rollide jaoks';
$string['backupsavetohelp'] = 'Varukoopia failide salvestuskoha täisaadress <br /> (jäta tühjaks kui soovid salvestada vaikimisi määratud kataloogi)';
$string['backupsitefileshelp'] = 'Kui on lubatud siis saidil kasutatud failid lisatakse automatiseeritud kursuste varukoopiatesse.';
$string['backuptakealook'] = 'Vaata oma varukoopia logisid {$a} seest';
$string['backupuserfileshelp'] = 'Kas kasutajate failid (nt. kasutajate fotod) lisatakse automaatsele varukoopiale?';
$string['backupversion'] = 'Varukoopia versioon';
$string['badges'] = 'Õpimärgid';
$string['block'] = 'Plokk';
$string['blockconfiga'] = 'Seadista plokki {$a}';
$string['blockconfigbad'] = 'See plokk ei ole veel korralikult realiseeritud ja seetõttu puudub ka kasutajaliides ploki seadistuste tegemiseks.';
$string['blocks'] = 'Plokid';
$string['blocksaddedit'] = 'Lisa/muuda plokke';
$string['blockseditoff'] = 'Lülita plokkide muutmine välja';
$string['blocksediton'] = 'Lülita plokkide muutmine sisse';
$string['blocksetup'] = 'Plokkide tabelite seadistamine';
$string['blocksuccess'] = '{$a} tabelite seadistamine õnnestus';
$string['brief'] = 'Lühike';
$string['bulkactions'] = 'Hulgitegevused';
$string['bulkmovecoursessuccess'] = '{$a->courses} kursust on edukalt teisaldatud kategooriasse {$a->category}';
$string['bycourseorder'] = 'Kursuste järjekorras';
$string['byname'] = '{$a} poolt';
$string['bypassed'] = 'Läbitud';
$string['cachecontrols'] = 'Puhvri kontrollid';
$string['cancel'] = 'Tühista';
$string['cancelled'] = 'Tühistatud';
$string['categories'] = 'Kursuste kategooriad';
$string['categoriesandcoures'] = 'Kursuste kategooriad ja kursused';
$string['category'] = 'Kategooria';
$string['categoryadded'] = 'Kategooria \'{$a}\' lisati';
$string['categorybulkaction'] = 'Hulgitegevused valitud kategooriatega';
$string['categorycontents'] = 'Alamkategooriad ja kursused';
$string['categorycurrentcontents'] = '{$a} sisu';
$string['categorydeleted'] = 'Kategooria \'{$a}\' kustutati';
$string['categoryduplicate'] = 'Kategooria nimega \'{$a}\' on juba olemas!';
$string['categorymodifiedcancel'] = 'Kategooriat on modifitseeritud! Palun tühista ja proovi uuesti.';
$string['categoryname'] = 'Kategooria nimi';
$string['categorysubcategoryof'] = '{$a->category} on {$a->parentcategory} alamkategooria';
$string['categoryupdated'] = 'Kategooria \'{$a}\' on uuendatud';
$string['changedpassword'] = 'Salasõna muudetud';
$string['changepassword'] = 'Muuda salasõna';
$string['changesmadereallygoaway'] = 'Oled teinud muudatusi. Kas Sa oled kindel, et soovid lehel lahkuda ja muudatustest ilma jääda?';
$string['changessaved'] = 'Muudatused salvestatud';
$string['check'] = 'Kontrolli';
$string['checkall'] = 'Kontrolli kõiki';
$string['checkingbackup'] = 'Kontrollin varukoopiat';
$string['checkingcourse'] = 'Kontrollin kursust';
$string['checkingforbbexport'] = 'Kontrollin BlackBoard\'i eksporti';
$string['checkinginstances'] = 'Kontrollin eksemplare';
$string['checkingsections'] = 'Kontrollin sektsioone';
$string['checklanguage'] = 'Kontrolli keelt';
$string['checknone'] = 'Ära kontrolli';
$string['childcoursenotfound'] = 'Alamkursust ei leitud!';
$string['childcourses'] = 'Alamkursused';
$string['choose'] = 'Vali';
$string['choosecourse'] = 'Vali kursus';
$string['choosedots'] = 'Vali...';
$string['chooselivelogs'] = 'Või jälgi jooksvat tegevust';
$string['chooselogs'] = 'Vali, milliseid logisid soovid näha';
$string['choosereportfilter'] = 'Vali filter kokkuvõttele';
$string['choosetheme'] = 'Vali kujundus';
$string['chooseuser'] = 'Vali kasutaja';
$string['city'] = 'Linn või maakond';
$string['clambroken'] = 'Teie administraator on üleslaetud failide jaoks viiruste kontrollimise sisse lülitanud, aga on midagi valesti konfigureerinud. <br/> Teie faili üleslaadimine EBAÕNNESTUS. Teie administraatorit on veast teavitatud.<br/> Te võite proovida hiljem seda faili uuesti üles laadida.';
$string['clamdeletedfile'] = 'Fail on kustutatud';
$string['clamdeletedfilefailed'] = 'Seda faili ei õnnestunud kustutada';
$string['clamemailsubject'] = '{$a} :: Clam AV teadaanne';
$string['clamfailed'] = 'Clam AV käivitamine ebaõnnestus. Veateade oli {$a}. Siin on Clami väljund:';
$string['clamlost'] = 'Moodle on seadistatud käivitama Clam\'i failide üleslaadimise ajal, aga Clam AV asukoht, {$a}, on vigane.';
$string['clamlostandactinglikevirus'] = 'Moodle on seadistatud nii, et kui Clam\'i käivitamine ebaõnnestub, siis koheldakse faile kui viiruseid. See tähendab, et ükski õppija ei saa faile üles laadida, kuni probleem on lahendatud.';
$string['clammovedfile'] = 'Fail on tõstetud Teie määratud karantiinikataloogi, mille uus asukoht on {$a}';
$string['clammovedfilebasic'] = 'Fail tõsteti karantiinikataloogi';
$string['clamquarantinedirfailed'] = 'Faili ei õnnestunud tõsta Sinu poolt määratud karantiinikataloogi, {$a}. Sa pead kataloogi asukoha ära parandama või vastasel korral failid kustutatakse, kui avastatakse, et nad on nakatunud.';
$string['clamunknownerror'] = 'Clam\'iga juhtus tundmatu viga.';
$string['cleaningtempdata'] = 'Ajutiste andmete kustutamine';
$string['clear'] = 'Puhasta';
$string['clickhelpiconformoreinfo'] = '... jätkub ... Vajutage abi ikoonil, et lugeda täispikka teksti';
$string['clickhere'] = 'Kliki siia ...';
$string['clicktochangeinbrackets'] = '{$a} (Klõpsa muutmiseks)';
$string['clicktohideshow'] = 'Kliki avamiseks või sulgemiseks';
$string['closebuttontitle'] = 'Sulge';
$string['closewindow'] = 'Sulge see aken';
$string['collapse'] = 'Sulge';
$string['collapseall'] = 'Sulge kõik';
$string['collapsecategory'] = 'Sulge {$a}';
$string['commentincontext'] = 'Leia see kommentaar kontekstis';
$string['comments'] = 'Kommentaarid';
$string['commentsnotenabled'] = 'Kommenteerimis võimalus ei ole lubatud';
$string['commentsrequirelogin'] = 'Sa pead olema sisseloginud kommentaaride nägemiseks';
$string['comparelanguage'] = 'Võrdle ja muuda kasutatavat keelt';
$string['complete'] = 'Lõpeta';
$string['completereport'] = 'Lõpeta aruanne';
$string['configuration'] = 'Seadistus';
$string['confirm'] = 'Kinnitan';
$string['confirmcheckfull'] = 'Oled sa absoluutselt kindel, et tahad kinnitada {$a} ?';
$string['confirmcoursemove'] = 'Kas oled kindel, et soovid teisaldada selle kursuse ({$a->course}) valitud kategooriasse ({$a->category})?';
$string['confirmed'] = 'Sinu registreerumine on kinnitatud';
$string['confirmednot'] = 'Sinu registreerumist pole veel kinnitatud!';
$string['content'] = 'Sisu';
$string['continue'] = 'Jätka';
$string['continuetocourse'] = 'Kursusele sisenemiseks kliki siin';
$string['convertingwikitomarkdown'] = 'Konverteerin Wiki formaadist märgenditega formaati';
$string['cookiesenabled'] = 'Sinu veebilehitseja peab lubama "küpsised"';
$string['cookiesenabled_help'] = 'Kahte küpsist kasutatakse selle saidi poolt:

Põhiline on seansiküpsis, tavaliselt nimetatakse MoodleSession. Sa pead lubama seda küpsist oma brauseri poolt, et pakkuda jätkupidevust ja hallata su sisse logitust lehelt lehele liikudes. Kui sa logid välja või suled brauseri, siis see küpsis hävitatakse (sinu brauseris ja serveris).

Teine küpsis on puhtalt mugavuse pärast, tavaliselt kutsutakse MOODLEID. Ta on ainult selleks, et mäletada su kasutajanime selles brauseris. See tähendab, et kui pöördud tagasi siia saidile, siis kasutaja nime lahter sisse logimise lehel on juba täidetud. On turvaline sellest küpsisest keelduda - sa lihtsalt pead iga kord uuesti oma kasutajanime sisestama sisse logimisel.';
$string['cookiesnotenabled'] = 'Kahjuks ei ole "küpsised" Sinu veebilehitsejas lubatud';
$string['copy'] = 'kopeeri';
$string['copyasnoun'] = 'koopia';
$string['copyingcoursefiles'] = 'Kopeeri kursuse failid';
$string['copyingsitefiles'] = 'Kopeeritakse keskkonna faile mis on kasutatud kursusel';
$string['copyinguserfiles'] = 'Kopeeri kasutaja failid';
$string['copyingzipfile'] = 'Kopeeri kokkupakitud fail';
$string['copyrightnotice'] = 'Autorikaitse märge';
$string['coresystem'] = 'Põhisüsteem';
$string['cost'] = 'Maksumus';
$string['costdefault'] = 'Vaikimisi maksumus';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Riik';
$string['course'] = 'Kursus';
$string['courseadministration'] = 'Kursuse administreerimine';
$string['courseapprovedemail'] = 'Sinu kursuse ("{$a->name}") taotlus on kinnitatud ja sind on määratud sellel kursusel {$a->teacher} rolli. Kursusele sisenemiseks ava aadress {$a->url}';
$string['courseapprovedemail2'] = 'Sinu kursuse ("{$a->name}") taotlus on rahuldatud. Oma uuele kursusele ligi pääsemiseks ava aadress {$a->url}';
$string['courseapprovedfailed'] = 'Ebaõnnestus salvestada kursust nagu soovitud!';
$string['courseapprovedsubject'] = 'Sinu kursus on kinnitatud!';
$string['courseavailable'] = 'See kursus on õppijatele avatud';
$string['courseavailablenot'] = 'See kursus ei ole õppijatele avatud';
$string['coursebackup'] = 'Kursuse varukoopia tegemine';
$string['coursebulkaction'] = 'Hulgitegevused valitud kursustega';
$string['coursecategories'] = 'Kursuste kategooriad';
$string['coursecategory'] = 'Kursuse kategooria';
$string['coursecategorydeleted'] = 'Kustutati kursuse kategooria {$a}';
$string['coursecategory_help'] = '<P ALIGN=CENTER><B>Course Categories</B></P>

<P>Your Moodle administrator may have set up several
   course categories.

<font size="2" face="Arial, Helvetica, sans-serif"><strong>Kursuse kategooriad</strong><br />
<br />
Sinu Moodle&#8217;i administraator on t&otilde;en&auml;oliselt seadistanud terve
rea kursuse kategooriaid.<br />
N&auml;iteks &#8220;Loodusteadused&#8221;, &#8220;Humanitaarteadused&#8221;, &#8220;Tervishoid&#8221;
jne.<br />
Vali see, mis k&otilde;ige paremini sinu kursusega seostub. Sinu valik m&otilde;jutab
seda, kuhu sinu kursus &uuml;ldises kursuste loendis kuvatakse ja teeb &otilde;pilastele
selle leidmise lihtsamaks. </font>
<p></p>';
$string['coursecatmanagement'] = 'Kursuste ja kategooriate haldus';
$string['coursecompletion'] = 'Kursuse sooritamise jälgimine';
$string['coursecompletions'] = 'Kursuse sooritamised';
$string['coursecreators'] = 'Kursuse disainer';
$string['coursecreatorsdescription'] = 'Kursuse disainerid võivad luua uusi kursusi ja neis õpetada.';
$string['coursedeleted'] = 'Kustutati kursus {$a}';
$string['coursedisplay'] = 'Kursuse paigutus';
$string['coursedisplay_help'] = 'See säte määrab, kas kogu kursuse sisu kuvatakse ühel lehel või jagatakse mitme lehe peale laiali.';
$string['coursedisplay_multi'] = 'Näita igal leheküljel ühte sektsiooni';
$string['coursedisplay_single'] = 'Näita kõiki sektsioone ühel lehel';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Kursuse failid';
$string['coursefilesedit'] = 'Muuda kursuse faile';
$string['coursefileswarning'] = 'Kursuse failid on iganenud';
$string['coursefileswarning_help'] = 'Kursuse failid on taunitavad alates Moodle 2.0\'st, palun kasuta väliseid repositooriume nii palju kui võimalik.';
$string['courseformatdata'] = 'Kursuse formaadi andmed';
$string['courseformatoptions'] = '{$a} formaadi valikud';
$string['courseformats'] = 'Kursuse formaadid';
$string['courseformatudpate'] = 'Uuenda formaati';
$string['coursegrades'] = 'Kursuse hinded';
$string['coursehelpcategory'] = 'Positsioneeri kursust kursuste nimekirjas ja see aitab õppijatel selle kergemini ülesleida.';
$string['coursehelpforce'] = 'Sunni kursuse grupi laad iga tegevusega kursusel';
$string['coursehelpformat'] = 'Kursuse pealeht kuvatakse selles formaadis.';
$string['coursehelphiddensections'] = 'Kuidas kursusel peidetud sektsioonid on kuvatud õpilastele.';
$string['coursehelpmaximumupload'] = 'Defineeri suurim faili suurus, mida saab üles lükata selles kursuses. Suuruse limiidiks on saidiülene seadistus.';
$string['coursehelpnewsitemsnumber'] = 'Mitu viimatist elementi kuvatakse kursuse kodulehel, uudiste kasti all, paremal pool (0 tähendab, et uudiste kasti ei kuvata)';
$string['coursehelpnumberweeks'] = 'Mitu nädalat/teemat kuvatakse kursuse põhilehel (rakendub vaid teatud kursuse formaatidele).';
$string['coursehelpshowgrades'] = 'Lülita sisse hinnetelehe kuvamine. See ei keela hinnete kuvamist üksikute tegevuste juures.';
$string['coursehidden'] = 'See kursus ei ole hetkel õppijatele avatud';
$string['courseinfo'] = 'Kursuse info';
$string['courselegacyfiles'] = 'Pärand kursuse failid';
$string['courselegacyfiles_help'] = 'Kursuse failide ala pakub mõningast tagasiühilduvust Moodle 1.9 ja varasemaga. Kõik failid selles alas on alati kättesaadavad kõikidele kursusest osalejatele (olenemata sellest, kas on linki neile või mitte) ja siin ei ole mingit teed teada saamaks, kus need failid on kasutusel Moodle\'s.

Kui sa soovid kasuada seda ala kursuse failide hoidmiseks, sa võib tekkida probleeme privaatsuse ja turvaprobleemidega, samuti võib jääda faile puudu varundamisel, kursuste importimistel ja igal ajal on sisu jagatud või taaskasutatud. Seetõttu on soovituslik mitte seda ala kasuada, välja arvatud juhul kui tead täpselt, mida sa teed.

Link all pakub rohkem informatsiooni selle kohta ja näitab mõned paremad teed haldamaks faili Moodle 2-s.';
$string['courselegacyfilesofcourse'] = 'Kursuse failid: {$a}';
$string['coursemessage'] = 'Sõnum kursuse kasutajatele';
$string['coursenotaccessible'] = 'See kursus ei ole avalikult kättesaadav';
$string['courseoverview'] = 'Kursuse ülevaade';
$string['courseoverviewfiles'] = 'Kursuse kokkuvõtte failid';
$string['courseoverviewfileslimit'] = 'Kursuse kokkuvõtte failide limiit';
$string['courseoverviewgraph'] = 'Kursuse ülevaate diagramm';
$string['courseprofiles'] = 'Kursuse profiilid';
$string['coursereasonforrejecting'] = 'Põhjus miks kursust ei saa luua.';
$string['coursereasonforrejectingemail'] = 'See saadetakse kursuse registreerijale.';
$string['coursereject'] = 'Lükka tagasi kursuse taotlus';
$string['courserejected'] = 'Kursus on tagasi lükatud ja taotlejat on teavitatud';
$string['courserejectemail'] = 'Vabandust, kuid Sinu poolt taotletud kursus lükati tagasi. Põhjuseks toodi

{$a}';
$string['courserejectsubject'] = 'Sinu kursuse taotlust ei kinnitatud';
$string['coursereport'] = 'Kursuse raport';
$string['coursereports'] = 'Kursuse raportid';
$string['courserequest'] = 'Kursuse taotlemine';
$string['courserequestdetails'] = 'Taotletava kursuse detailid';
$string['courserequestreason'] = 'Põhjus, miks soovid seda kursust';
$string['courserequestsuccess'] = 'Sinu kursuse taotlus salvestati edukalt. Palun oota vastust taotlusele e-kirja teel mõne päeva jooksul';
$string['courserequestsupport'] = 'Toetav info, aitamaks administraatoril käsitleda päringut';
$string['courserestore'] = 'Kuruse taastamine';
$string['courses'] = 'Kursused';
$string['coursesectionsummaries'] = 'Kursuse sektsiooni kokkuvõtted';
$string['coursesettings'] = 'Kursuse vaikimisi seaded';
$string['coursesmovedout'] = 'Kursus teisaldati välja {$a}-st';
$string['coursespending'] = 'Kinnitamist ootavad kursused';
$string['coursestart'] = 'Kursuse algus';
$string['coursesummary'] = 'Kursuse kokkuvõte';
$string['coursesummary_help'] = 'Kursuse lühikokkuvõte kuvatakse kursuste nimekirjas. Kursuse otsingul otsitakse teksti lisaks kursuste nimedele ka kursuse nimedest.';
$string['courseupdates'] = 'Kursuse uuendused';
$string['create'] = 'Loo';
$string['createaccount'] = 'Loo minu uus kasutajakonto';
$string['createcategory'] = 'Loo kategooria';
$string['createfolder'] = 'Loo uus kaust asukohta {$a}';
$string['createnew'] = 'Loo uus';
$string['createnewcategory'] = 'Loo uus kategooria';
$string['createnewcourse'] = 'Loo uus kursus';
$string['createnewsubcategory'] = 'Loo uus alamkategooria';
$string['createsubcategoryof'] = 'Loo kategooriale {$a} alamkategooria';
$string['createuser'] = 'Loo kasutaja';
$string['createuserandpass'] = 'Loo endale kasutajanimi ja salasõna';
$string['createziparchive'] = 'Paki  arhiivi';
$string['creatingblocks'] = 'Plokkide loomine';
$string['creatingcategoriesandquestions'] = 'Kategooriate ja küsimuste loomine';
$string['creatingcoursemodules'] = 'Kursuse moodulite loomine';
$string['creatingevents'] = 'Sündmuste loomine';
$string['creatinggradebook'] = 'Hinnetelehe koostamine';
$string['creatinggroupings'] = 'Grupeeringute loomine';
$string['creatinggroupingsgroups'] = 'Lisatakse grupid grupeeringusse';
$string['creatinggroups'] = 'Rühmade moodustamine';
$string['creatinglogentries'] = 'Logide kirjete loomine';
$string['creatingmessagesinfo'] = 'Sõnumite info esitamine';
$string['creatingmodroles'] = 'Luuakse mooduli tasemel rollide määrangud ja õiguste ülekatmised';
$string['creatingnewcourse'] = 'Uue kursuse loomine';
$string['creatingrolesdefinitions'] = 'Rollide defineerimine';
$string['creatingscales'] = 'Skaalade tegemine';
$string['creatingsections'] = 'Sektsioonide tegemine';
$string['creatingtemporarystructures'] = 'Esialgsete struktuuride loomine';
$string['creatinguserroles'] = 'Luuakse kasutaja tasemel rollide määrangud ja õiguste ülekatmised';
$string['creatingusers'] = 'Kasutajate määramine';
$string['creatingxmlfile'] = 'XML faili loomine';
$string['currency'] = 'Valuuta';
$string['currentcourse'] = 'Käesolev kursus';
$string['currentcourseadding'] = 'Lisan andmeid käesolevale kursusele';
$string['currentcoursedeleting'] = 'Kustutan käesoleva kursuse esmalt';
$string['currentlanguage'] = 'Kasutatav keel';
$string['currentlocaltime'] = 'kehtiv aeg';
$string['currentlyselectedusers'] = 'Hetkel märgistatud kasutajad';
$string['currentpicture'] = 'Kasutatav pilt';
$string['currentrelease'] = 'Kehtiv väljalaskeinfo';
$string['currentversion'] = 'Kehtiv versioon';
$string['databasechecking'] = 'Moodle\'i andmebaasi uuendus versioonilt {$a->oldversion} versioonile {$a->newversion}...';
$string['databaseperformance'] = 'Andmebaasi jõudlus';
$string['databasesetup'] = 'Andmebaasi seadistamine';
$string['databasesuccess'] = 'Andmebaasi uuendamine õnnestus';
$string['databaseupgradebackups'] = 'Varukoopia versioon on praegu {$a}';
$string['databaseupgradeblocks'] = 'Plokkide versioon on praegu {$a}';
$string['databaseupgradegroups'] = 'Rühmade versioon on praegu {$a}';
$string['databaseupgrades'] = 'Andmebaasi uuendamine';
$string['date'] = 'Kuupäev';
$string['datechanged'] = 'Kuupäev muudetud';
$string['datemostrecentfirst'] = 'Kuupäev - alates uuemast';
$string['datemostrecentlast'] = 'Kuupäev - alates vanemast';
$string['day'] = 'päev';
$string['days'] = 'päeva';
$string['decodinginternallinks'] = 'Dekodeeri sisemisi linke';
$string['default'] = 'Dekodeeri sisemisi linke';
$string['defaultcoursestudent'] = 'Õppija';
$string['defaultcoursestudentdescription'] = 'Õppuritel on kursuse sees üldjuhul vähem õiguseid.';
$string['defaultcoursestudents'] = 'Õppijad';
$string['defaultcoursesummary'] = 'Kirjuta siia kokkuvõtlik ja huvitav lõik, mis iseloomustab kursust.';
$string['defaultcourseteacher'] = 'Õpetaja';
$string['defaultcourseteacherdescription'] = 'Õpetajad saavad teha kõike kursuses, sealhulgas muuta tegevusi ja hinnata õpilasi.';
$string['defaultcourseteachers'] = 'Õpetajad';
$string['defaulteditor'] = 'Vaikimisi redaktor';
$string['delete'] = 'Kustuta';
$string['deleteablock'] = 'Kustuta plokk';
$string['deleteall'] = 'Kustuta kõik';
$string['deleteallcannotundo'] = 'Kustuta kõik - ei saa tagasi võtta';
$string['deleteallcomments'] = 'Kustuta kõik kommentaarid';
$string['deleteallratings'] = 'Kustuta kõik reitingud';
$string['deletecategory'] = 'Kustuta kategooria: {$a}';
$string['deletecategorycheck'] = 'Kas oled täiesti kindel, et soovid kustatada seda kategooriat <b>\'{$a}\'</b>?<br /> Kõik kursused liigutatakse peakataloogi (kui see eksisteerib), või kategooriasse "Varia".';
$string['deletecategorycheck2'] = 'Kui sa kustutad selle kategooria, sa pead valima mida teha kursustega ja alamkategooriatega, mida ta sisaldas';
$string['deletecategoryempty'] = 'See kategooria on tühi';
$string['deletecheck'] = 'Kustuta {$a} ?';
$string['deletecheckfiles'] = 'Kas oled täiesti kindel, et soovid neid faile kustutada?';
$string['deletecheckfull'] = 'Kas oled täiesti veendunud, et soovid lõplikult kustutada {$a} ?';
$string['deletechecktype'] = 'Oled Sa kindel, et soovid kustutada selle {$a->type}?';
$string['deletechecktypename'] = 'Kas oled kindel, et soovid kustutada {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Oled kustutamas neid faile';
$string['deletecomment'] = 'Kustuta kommentaar';
$string['deletecompletely'] = 'Kustuta lõplikult';
$string['deletecourse'] = 'Kustuta kursus';
$string['deletecoursecheck'] = 'Kas oled täiesti veendunud, et soovid lõplikult kustutada selle kursuse ja kõik selles sisalduvad andmed?';
$string['deleted'] = 'Kustutatud';
$string['deletedactivity'] = '{$a} kustutatud';
$string['deletedcourse'] = '{$a} on lõplikult kustutatud';
$string['deletednot'] = 'Ei saa  {$a} kustutada!';
$string['deletelogs'] = 'Kustuta logid';
$string['deleteselected'] = 'Kustuta valitud';
$string['deleteselectedkey'] = 'Kustuta valitud võti';
$string['deletingcourse'] = 'Kustutan {$a}';
$string['deletingexistingcoursedata'] = 'Kustuta olemasoleva kursuse andmed';
$string['deletingolddata'] = 'Kustuta vanad andmed';
$string['department'] = 'Osakond';
$string['desc'] = 'Kahanev';
$string['description'] = 'Kirjeldus';
$string['deselectall'] = 'Eemalda kõik märgistused';
$string['detailedless'] = 'Vähem detailsem';
$string['detailedmore'] = 'Rohkem detailsem';
$string['directory'] = 'Kataloog';
$string['disable'] = 'Keela';
$string['disabledcomments'] = 'Kommentaarid on keelatud';
$string['displayingfirst'] = 'Ainult esimesed {$a->count} {$a->things} on näidatud';
$string['displayingrecords'] = 'Näitan {$a} salvestust';
$string['displayingusers'] = 'Näitan kasutajaid {$a->start} kuni {$a->end}';
$string['displayonpage'] = 'Näita lehel';
$string['dndcourse'] = 'Sa võid seda kursust lohistada ja asetada, et kursuseid ümber sorteerida või viia see kursus uude kategooriasse.';
$string['dndenabled_inbox'] = 'Sa saad failide lisamiseks nad siia lohistada ja asetada.';
$string['dndnotsupported'] = 'Üleslaadimine kasutades lohistamist ja asetamist ei ole toetatud';
$string['dndnotsupported_help'] = 'Sinu veebilehitseja ei toeta üleslaadimist lohistamise ja asetamise teel.<br />Selline võimalus on saadaval kõigi veebilehitsejate Chrome, Firefox, Safari ja Internet Explorer 10 hiljutistes versioonides.';
$string['dndnotsupported_insentence'] = 'lohistamine ja asetamine ei ole toetatud';
$string['dnduploadwithoutcontent'] = 'Üles laetud failil puudub sisu';
$string['dndworkingfile'] = 'Failide üles laadimiseks lohista ja aseta nad kursuse sektsiooni peale';
$string['dndworkingfilelink'] = 'Failide või linkide lisamiseks lohista ja aseta nad kursuse sektsiooni peale';
$string['dndworkingfiletext'] = 'Failide või tekstide lisamiseks lohista ja aseta nad kursuse sektsiooni peale';
$string['dndworkingfiletextlink'] = 'Failide, tekstide või linkide lisamiseks lohista ja aseta nad kursuse sektsiooni peale';
$string['dndworkinglink'] = 'Linkide lisamiseks lohista ja aseta soovitud lingid kursuse sektsiooni peale';
$string['dndworkingtext'] = 'Teksti lisamiseks lohista ja aseta see kursuse sektsiooni peale';
$string['dndworkingtextlink'] = 'Teksti või linkide lisamiseks lohista ja aseta nad kursuse sektsiooni peale';
$string['documentation'] = 'Moodle dokumentatsioon';
$string['dontsortcategories'] = 'Ära sorteeri kategooriaid';
$string['dontsortcourses'] = 'Ära sorteeri kursuseid';
$string['down'] = 'Alla';
$string['download'] = 'Lae alla';
$string['downloadall'] = 'Lae kõik alla';
$string['downloadexcel'] = 'Lae alla Excel`i formaadis';
$string['downloadfile'] = 'Tõmba fail alla';
$string['downloadods'] = 'Lae alla Open Office`i formaadis';
$string['downloadtext'] = 'Lae alla tekstiformaadis';
$string['doyouagree'] = 'Kas olete lugenud ja mõistnud kõiki tingimusi?';
$string['droptoupload'] = 'Aseta failid siia, et nad üles laadida';
$string['duplicate'] = 'Tee koopia';
$string['duplicateconfirm'] = 'Oled kindel, et soovid dubleerida {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Tagasi kursusele';
$string['duplicatecontedit'] = 'Muuda uut koopiat';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' on dubleeritud edukalt';
$string['duplicatinga'] = 'Dubleerin: {$a}';
$string['edhelpaspellpath'] = 'Et kasutada selles toimetis õigekirja kontrolli, PEAB Teil serverisse olema installeeritud <strong>aspell 0.50</strong> või uuem versioon ja Te peate määrama korrektse juurdepääsutee aspell\'ile. Unixis ja Linuxis on see tee tavaliselt <strong>/usr/bin/aspell</strong>, aga võib olla ka teistsugune.';
$string['edhelpbgcolor'] = 'Defineeri toimeti taustavärv <br /> Sobivad väärtused on näiteks #ffffff või white';
$string['edhelpcleanword'] = 'See seadistus lülitab sisse või välja Wordi-spetsiifilise formaadi filtreerimise.';
$string['edhelpenablespelling'] = 'Lülita sisse või välja õigekirja kontroll. Sisse lülitatuna peab serveris olema installeeritud <strong>aspell</strong>.
Teine väärtus on <strong>vaikimisi sõnastik </strong>. Seda väärtust kasutatakse, kui aspell\'il pole kasutaja keele sõnastikku.';
$string['edhelpfontfamily'] = 'Fondiperekonna atribuut on nimekiri fondiperekondade nimedest ja/või geneeriliste perekondade nimedest. Perekondade nimed tuleb eraldada komadega.';
$string['edhelpfontlist'] = 'Defineeri fondid, mida kasutatakse toimeti rippmenüüs.';
$string['edhelpfontsize'] = 'Vaikimisi fondisuurus määrab fondi suuruse. <br />Sobivad väärtused on näiteks : medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Muuda';
$string['edita'] = 'Muuda {$a}';
$string['editcategorysettings'] = 'Muuda kategooria seadeid';
$string['editcategorythis'] = 'Muuda seda kategooriat';
$string['editcoursesettings'] = 'Muuda kursuse seadeid';
$string['editfiles'] = 'Muuda faile';
$string['editgroupprofile'] = 'Muuda rühma andmeid';
$string['editinga'] = 'Muudan objekti {$a}';
$string['editingteachershort'] = 'Toimetaja';
$string['editlock'] = 'Seda väärtust ei saa muuta!';
$string['editmyprofile'] = 'Muuda kasutaja andmeid';
$string['editorbgcolor'] = 'Tausta värv';
$string['editorcleanonpaste'] = 'Kleepimisel eemalda Word`i HTML';
$string['editorcommonsettings'] = 'Üldised seaded';
$string['editordefaultfont'] = 'Vaikimisi font';
$string['editorenablespelling'] = 'Lülita sisse õigekirja kontroll';
$string['editorfontlist'] = 'Fontide nimekiri';
$string['editorfontsize'] = 'Vaikimisi fondisuurus';
$string['editorresettodefaults'] = 'Taasta vaikeväärtustele';
$string['editorsettings'] = 'Toimeti seaded';
$string['editorshortcutkeys'] = 'Redaktori kiirklahvid';
$string['editsettings'] = 'Muuda sätteid';
$string['editsummary'] = 'Muuda kokkuvõtet';
$string['editthisactivity'] = 'Muuda tegevust';
$string['editthiscategory'] = 'Muuda seda kategooriat';
$string['edittitle'] = 'Muuda pealkirja';
$string['edittitleinstructions'] = 'Katkestamiseks vajuta klaviatuuril Escape, salvestamiseks vajuta Enter';
$string['edituser'] = 'Muuda kasutajate kontosid';
$string['email'] = 'E-posti aadress';
$string['emailactive'] = 'E-post aktiveeritud';
$string['emailagain'] = 'E-posti aadress (uuesti)';
$string['emailalreadysent'] = 'Salasõna lähtestamise e-kiri on juba saadetud. Palun vaata oma postkasti.';
$string['emailcharset'] = 'E-kirja "charset"';
$string['emailconfirm'] = 'Kinnita oma kasutakonto';
$string['emailconfirmation'] = 'Tere {$a->firstname},

\'{$a->sitename}\' õpikeskkonnas on taotletud uue kasutajakonto loomist kasutades antud e-posti aadressi.

Uue kasutajakonto kinnitamiseks mine järgmisele veebiaadressile:

{$a->link}

Enamasti peaks see ilmuma veebilingi kujul, millele võib lihtsalt klikkida. Kui see ei tööta, siis kopeeri aadress veebilehitseja aadressiribale.

Kui vajad abi, võta kontakti õpikeskkonna administraatoriga,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: kasutajakonto kinnitamine';
$string['emailconfirmsent'] = '<P>Sinu e-posti aadressile <B>{$a}</B></p>
<p>saadeti kiri, mis sisaldab lihtsaid juhendeid, kuidas kasutajatunnust kinnitada.</p>
<P>Probleemide korral pöördu õpikeskkonna administraatori poole.</p>';
$string['emaildigest'] = 'E-postiga saadetava kokkuvõtte liik';
$string['emaildigestcomplete'] = 'Täielik (iga päeva kohta e-kiri täispikkade postitustega)';
$string['emaildigestoff'] = 'Ilma kokkuvõtteta (üks e-kiri iga foorumipostituse kohta)';
$string['emaildigestsubjects'] = 'Pealkirjad  (iga päeva kohta e-kiri ainult pealkirjadega)';
$string['emaildisable'] = 'See e-posti aadress on keelatud';
$string['emaildisableclick'] = 'Vajuta siia, et lülitada välja e-posti saatmine antud aadressile';
$string['emaildisplay'] = 'Näita e-kirja';
$string['emaildisplaycourse'] = 'Luba ainult teistel kursusel osalejatel minu e-posti aadressi näha';
$string['emaildisplayhidden'] = 'E-mail peidetud';
$string['emaildisplayno'] = 'Peida minu tegelik e-posti aadress kõigi eest';
$string['emaildisplayyes'] = 'Luba kõigil mu e-posti aadressi näha';
$string['emailenable'] = 'See e-posti aadress on lubatud';
$string['emailenableclick'] = 'Vajuta siia, et lülitada sisse e-posti saatmine antud aadressile';
$string['emailexists'] = 'Antud e-posti aadress on juba kasutusel.';
$string['emailformat'] = 'E-kirja formaat';
$string['emailmustbereal'] = 'Märkus: sinu e-posti aadress peab olema reaalselt eksisteeriv';
$string['emailnotallowed'] = 'E-posti aadressid ei ole lubatud järgmistest domeenidest: {$a}';
$string['emailnotfound'] = 'E-posti aadressi ei leitud andmebaasist';
$string['emailonlyallowed'] = 'E-posti aadress ei ole üks nendest, mis on lubatud ({$a})';
$string['emailpasswordchangeinfo'] = 'Tere, {$a->firstname}!

Keegi (tõenäoliselt Sina ise) on soovinud uut salasõna Sinu kasutajakontole õpikeskkonnas \'{$a->sitename}\'.

Salasõna muutmiseks mine järgmisele veebiaadressile:

{$a->link}

Enamikes meiliprogrammides peaks veebiaadress olema kuvatud lingi kujul, millele võid lihtsalt klikkida. Kui see ei tööta, siis kopeeri aadress veebilehitseja aadressiribale.

Kui vajad abi, võta kontakti õpikeskkonna administraatoriga,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Tere, {$a->firstname}!

Keegi (ilmselt Sina ise) on tellinud uue salasõna kasutajakontole õpikeskkonnas \'{$a->sitename}\'.

Kahjuks on Sinu konto sellel saidil välja lülitatud ja seda pole võimalik lähtestada.
Palun võta ühendust Moodle keskkonna admininistraatoriga,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Tere, {$a->firstname}!

Keegi (ilmselt Sina ise) on tellinud uue salasõna kasutajakontole õpikeskkonnas \'{$a->sitename}\'.

Paraku pole salasõnu võimalik muuta antud Moodle´i keskkonnas.
Palun võta ühendust Moodle´i keskkonna administraatoriga,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Muuda parooli informatsiooni';
$string['emailpasswordconfirmation'] = 'Tere, {$a->firstname}!

Keegi (tõenäoliselt Sina ise) on soovinud uut salasõna Sinu kasutajakontole õpikeskkonnas \'{$a->sitename}\'.

Selle kinnitamiseks ja uue salasõna saamiseks e-kirjana mine järgmisele veebiaadressile:

{$a->link}

Enamikes meiliprogrammides peaks eelnevalt märgitud veebiaadress kuvatama lingi kujul, millele võid lihtsalt klikkida. Kui see ei tööta, siis kopeeri aadress veebilehitseja aadressiribale.

Probleemide korral kontakteeru õpikeskkonna administraatoriga,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Salasõna muutmise kinnitus';
$string['emailpasswordconfirmmaybesent'] = '<p>Kui sisestasid sobiva kasutajanime või e-mailiaadressi, siis peaks e-mail olema Sulle saadetud.</p><p>See e-mail sisaldab edasisi instruktsioone, mismoodi viia lõpule salasõna muutmine. Kui tekib raskusi, siis palun kontakteeru oma õpikeskkonna administraatoriga.</p>';
$string['emailpasswordconfirmsent'] = 'Sinu e-posti aadressile <b>{$a}</b> saadeti kiri, mis sisaldab lihtsaid juhiseid, kuidas kinnitada ja lõpule viia salasõna muutmine.
Probleemide korral kontakteeru õpikeskkonna adimistraatoriga.';
$string['emailpasswordsent'] = 'Täname, et kinnitasid salasõna muutmise.
  <p>Sinu e-posti aadressile <b>{$a->email}</b> saadeti e-kiri, mis sisaldab uut salasõna.
  <p>Uus salasõna tekitati automaatselt.
  <a href={$a->link}>Muuda salasõna</a> millekski lihtsamini meeldejäävaks.';
$string['emailresetconfirmationsubject'] = '{$a}: Salasõna lähtestamine';
$string['emptydragdropregion'] = 'tühi regioon';
$string['enable'] = 'Luba';
$string['encryptedcode'] = 'Krüptitud kood';
$string['english'] = 'Inglise';
$string['enrolmentmethods'] = 'Registreerimise meetodid';
$string['entercourse'] = 'Kliki kursusele sisenemiseks';
$string['enteremail'] = 'Sisesta oma e-posti aadress';
$string['enteremailaddress'] = 'Sisesta oma e-posti aadress, et õpikeskkond saaks genereerida uue salasõna ja saata selle sinu e-posti aadressile.';
$string['enterusername'] = 'Sisesta oma kasutajatunnus';
$string['entries'] = 'Kirjed';
$string['error'] = 'Viga';
$string['errorfiletoobig'] = 'Fail oli suurem kui lubatud {$a} baiti';
$string['errorwhenconfirming'] = 'Sa ei ole veel kinnitatud, kuna tekkis viga. Kui vajutasid linki e-kirja sees, vaata üle, ega link ei olnud vigane või mitmel real. Vajadusel kasuta lõika-kleebi meetodit lingi taastamiseks.';
$string['eventcoursecategorydeleted'] = 'Kategooria on kustutatud';
$string['eventcoursecontentdeleted'] = 'Kursuse sisu on kustutatud';
$string['eventcoursecreated'] = 'Kursus on loodud';
$string['eventcoursedeleted'] = 'Kursus on kustutatud';
$string['eventcoursemodulecreated'] = 'Kursuse moodul on loodud';
$string['eventcoursemoduledeleted'] = 'Kursuse moodul on kustutatud';
$string['eventcoursemoduleupdated'] = 'Kursuse moodul on uuendatud';
$string['eventcourseresetended'] = 'Kursuse lähtestamine on lõpetatud';
$string['eventcourseresetstarted'] = 'Kursuse lähtestamist on alustatud';
$string['eventcourserestored'] = 'Kursus on taastatud';
$string['eventcoursesectionupdated'] = 'Kursuse sektsioon on uuendatud';
$string['eventcourseupdated'] = 'Kursus on uuendatud';
$string['eventusercreated'] = 'Kasutaja on loodud';
$string['eventuserdeleted'] = 'Kasutaja on kustutatud';
$string['eventuserlistviewed'] = 'Kasutajate nimekirja vaatamine';
$string['eventuserloggedout'] = 'Kasutaja logis välja';
$string['eventuserprofileviewed'] = 'Kasutajaprofiili vaatamine';
$string['eventuserupdated'] = 'Kasutaja on uuendatud';
$string['everybody'] = 'Kõik';
$string['executeat'] = 'Käivita';
$string['existing'] = 'Olemasolev';
$string['existingadmins'] = 'Olemasolevad administraatorid';
$string['existingcourse'] = 'Olemasolev kursus';
$string['existingcourseadding'] = 'Lisan andmeid käesolevale kursusele';
$string['existingcoursedeleting'] = 'Kustutan esmalt käesoleva kursuse';
$string['existingcreators'] = 'Olemasolevad kursuse disainerid';
$string['existingstudents'] = 'registreerunud õppijat';
$string['existingteachers'] = 'Olemasolevad õpetajad';
$string['expand'] = 'Ava';
$string['expandall'] = 'Ava kõik';
$string['expandcategory'] = 'Ava {$a}';
$string['explanation'] = 'Selgitus';
$string['extendenrol'] = 'Laiendatud registreerumine (individuaalne)';
$string['extendperiod'] = 'Laiendatud periood';
$string['failedloginattempts'] = '{$a->attempts} ebaõnnestunud sisenemist peale Teie viimast sisenemist.';
$string['failedloginattemptsall'] = '{$a->attempts} ebaõnnestunud sisenemist {$a->accounts} kontole';
$string['feedback'] = 'Tagasiside';
$string['file'] = 'Fail';
$string['fileexists'] = 'Fail nimega {$a} on juba olemas';
$string['filemissing'] = '{$a} puudub';
$string['files'] = 'Kursuse failid';
$string['filesanduploads'] = 'Failid ja üleslaadimised';
$string['filesfolders'] = 'Failid/kaustad';
$string['filetoolarge'] = 'on liiga suur üles laadimiseks';
$string['filloutallfields'] = 'Palun täitke kõik väljad';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Otsi veel kursusi...';
$string['first'] = 'Esimene';
$string['firstaccess'] = 'Esimene pöördumine';
$string['firstname'] = 'Eesnimi';
$string['firstnamephonetic'] = 'Eesnimi - foneetiline';
$string['firsttime'] = 'Kasutajaks registreerumine';
$string['folder'] = 'Kaust';
$string['folderclosed'] = 'Suletud kaust';
$string['folderopened'] = 'Avatud kaust';
$string['followingoptional'] = 'Järgnevad punktid on valikulised';
$string['followingrequired'] = 'Järgnevad punktid on kohustuslikud';
$string['force'] = 'Sunni';
$string['forcelanguage'] = 'Sunni keel';
$string['forceno'] = 'Ära sunni';
$string['forcepasswordchange'] = 'Sunni salasõna vahetama';
$string['forcepasswordchangecheckfull'] = 'Oled sa täiesti kindel, et soovid sundida {$a} salasõna vahetama?';
$string['forcepasswordchange_help'] = 'Kui siin linnuke, siis kasutaja peab järgmisel sisse logimisel muutma oma parooli.';
$string['forcepasswordchangenot'] = 'Salasõna muutmise sundimine kasutajale {$a} ebaõnnestus';
$string['forcepasswordchangenotice'] = 'Edasi minemisks pead muutma oma salasõna.';
$string['forcetheme'] = 'Sunni kujundus';
$string['forgotaccount'] = 'Salasõna ununenud?';
$string['forgotten'] = 'Oled unustanud oma kasutajanime või salasõna?';
$string['forgottenduplicate'] = 'See e-posti aadress on seotud mitme kontoga, palun sisesta hoopis kasutajanimi';
$string['forgotteninvalidurl'] = 'Vigane salasõna tühistamise URL';
$string['format'] = 'Formaat';
$string['format_help'] = 'Kursuse formaat määrab kursuse lehe väljanägemise ja toimimise

* Nädalakava formaat - kursus on organiseeritud nädalate kaupa, konkreetse algus- ja lõppkuupäevaga.
Igal nädalal on ette nähtud rida tegevusi. Mõnel neist – nagu päevikutel - võivad olla “avatud aknad” näiteks kahenädalaseks perioodiks, mille lõppedes nad pole enam saadaval.
* Teemade formaat - väga sarnane nädalakava formaadile, välja arvatud see, et iga “nädalat” nimetatakse teemaks. “Teema” pole ajaliselt piiratud. Mingeid kuupäevi täpsustada ei tule.
* Sotsiaalne formaat - see formaat on orienteeritud ühele põhifoorumile, Sotsiaalsele foorumile, mis leidub kursuse lehel asuvas loendis. Seda saab kasutada olukordades, mis on vabama vormiga. Need ei pruugi olla isegi kursused, näiteks võib seda kasutada osakonna teadetetahvlina.
* Üksiktegevuse formaat - vaid ühe kursuse autori poolt valitud tegevuse või vahendi (näiteks test või SCORMi pakett) kuvamiseks kursuse lehel.';
$string['formathtml'] = 'HTML formaat';
$string['formatmarkdown'] = 'Märgenditega formaat';
$string['formatplain'] = 'Lihtteksti formaat';
$string['formattext'] = 'Moodle automaatne formaat';
$string['formattexttype'] = 'Formaatimine';
$string['from'] = 'Alates';
$string['frontpagecategorycombo'] = 'Combo-leht';
$string['frontpagecategorynames'] = 'Näita kategooriate nimekirja';
$string['frontpagecourselist'] = 'Näita kursuste nimekirja';
$string['frontpagecoursesearch'] = 'Kursuse otsingukast';
$string['frontpagedescription'] = 'Esilehe kirjeldus';
$string['frontpagedescriptionhelp'] = 'Antud õpikeskkonna kirjeldust näidatakse esilehel.';
$string['frontpageformat'] = 'Esilehe formaat';
$string['frontpageformatloggedin'] = 'Esilehe formaat pärast sisenemist';
$string['frontpagenews'] = 'Näita uudiseid';
$string['frontpagesettings'] = 'Esilehe seaded';
$string['fulllistofcourses'] = 'Kõik kursused';
$string['fullname'] = 'Täisnimi';
$string['fullnamecourse'] = 'Kursuse täisnimi';
$string['fullnamecourse_help'] = 'Kursuse täisnimi kuvatakse kursuse iga lehe päises ja kursuste nimekirjas.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Kasutaja täisnimi';
$string['fullprofile'] = 'Täielikud kasutaja andmed';
$string['fullsitename'] = 'Õpikeskkonna täisnimi';
$string['functiondisabled'] = 'See funktsioon on hetkel välja lülitatud';
$string['general'] = 'Üldine';
$string['geolocation'] = 'laius- ja pikkuskraad';
$string['gettheselogs'] = 'Telli soovitud ülevaade';
$string['go'] = 'Mine';
$string['gpl'] = 'Copyright (C) 1999 ja edaspidi  Martin Dougiamas  (http://dougiamas.com)

See programm on vaba tarkvara, mida võib levitada ja/või muuta vastavalt Vaba Tarkvara Fondi poolt avaldatud GNU Üldise Avaliku Litsentsi versioonile 2 või sinu omal valikul vastavalt mõnele hilisemale versioonile.

Seda programmi levitatakse lootuses, et ta on kasulik, kuid ILMA IGASUGUSE GARANTIITA, isegi ilma mingi vihjeta TURUSTATAVUSE või KONKREETSEKS EESMÄRGIKS SOBIVUSE garantiile.

Lisateabe saamiseks vaata GNU Üldist Avalikku Litsentsi:
http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Kopeerimisõigused (C) alates 1999 kuuluvad Martin Dougiamas\'le (http://moodle.com)

See programm on vabatarkvara: sa võid levitada seda ja/või muuta vastavalt Vabavara Fondi poolt avaldatud GNU Üldise Avaliku Litsentsi versioonile 3 või sinu omal valikul vastavalt mõnele hilisemale versioonile.
Seda programmi levitatakse lootuses, et ta on kasulik, kuid ILMA MINGI GARANTIITA, isegi ilma mingi vihjeta TURUSTATAVUSE või KONKREETSEKS EESMÄRGIKS SOBIVUSE garantiile.

Vaata Moodle Litsentsi info lehte detailide kohta:
http://docs.moodle.org/dev/License';
$string['gpllicense'] = 'GPL litsents';
$string['grade'] = 'Hinne';
$string['grades'] = 'Hinded';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> teenus on sellel saidil sisse lülitatud. Kui jätad enda profiilipildi üles laadimata, siis proovib Moodle leida ja laadida alla Sinu Gravatar profiilipildi.';
$string['group'] = 'Rühm';
$string['groupadd'] = 'Lisa uus rühm';
$string['groupaddusers'] = 'Lisa valitud rühma';
$string['groupextendenrol'] = 'Pikenda registreeringut (tavaline)';
$string['groupfor'] = 'rühmale';
$string['groupinfo'] = 'Valitud rühma info';
$string['groupinfoedit'] = 'Muuda rühma seadeid';
$string['groupinfomembers'] = 'Valitud kasutajate info';
$string['groupinfopeople'] = 'Valitud inimeste info';
$string['groupmembers'] = 'Rühma liikmed';
$string['groupmemberssee'] = 'Vaata rühma liikmeid';
$string['groupmembersselected'] = 'Valitud rühma liikmed';
$string['groupmode'] = 'Rühma režiim';
$string['groupmodeforce'] = 'Sunni rühmarežiim';
$string['groupmy'] = 'Minu rühm';
$string['groupnonmembers'] = 'Inimesed, kes ei ole rühmas';
$string['groupnotamember'] = 'Vabandust! Sa ei ole selles rühmas.';
$string['grouprandomassign'] = 'Määra kõik juhuslikult rühmadesse';
$string['groupremove'] = 'Kustuta valitud rühm';
$string['groupremovemembers'] = 'Eemalda valitud liikmed';
$string['groups'] = 'Rühmad';
$string['groupsnone'] = 'Rühmad puuduvad';
$string['groupsseparate'] = 'Eraldatud rühmad';
$string['groupsvisible'] = 'Nähtavad rühmad';
$string['guest'] = 'Külaline';
$string['guestdescription'] = 'Külalisel on minimaalsed õigused tegutsemaks kursusel ja tavaliselt ei saa mitte kuskil sisestada teksti.';
$string['guestskey'] = 'Luba külalisi, kes omavad võtit';
$string['guestsno'] = 'Ära luba külalisi';
$string['guestsnotallowed'] = 'Kahjuks \'{$a}\'  ei luba külalisi.';
$string['guestsyes'] = 'Luba külalisi, kellel pole võtit';
$string['guestuser'] = 'Külaliskasutaja';
$string['guestuserinfo'] = 'See on eriline kasutaja, kellel on ainult lugemisõigus teatud kursustel.';
$string['help'] = 'Abi';
$string['helpprefix2'] = 'Spikker {$a} kohta';
$string['helpwiththis'] = 'Abi selles';
$string['hiddenassign'] = 'Peidetud ülesanne';
$string['hiddenfromstudents'] = 'Õpilaste eest peidetud';
$string['hiddensections'] = 'Peidetud sektsioonid';
$string['hiddensectionscollapsed'] = 'Peidetud sektsioone näidatakse suletud kujul';
$string['hiddensections_help'] = 'See seadistus määrab, kas peidetud sektsioonid kuvatakse õpilastele suletud kujul (nädalaformaadis kursuses näiteks vaheaegade tähistamiseks) või on täielikult peidetud.';
$string['hiddensectionsinvisible'] = 'Peidetud sektsioonid on täiesti nähtamatud';
$string['hide'] = 'Peida';
$string['hideadvancedsettings'] = 'Peida laiendatud seaded';
$string['hidepicture'] = 'Peida pilt';
$string['hidesection'] = 'Peida sektsioon {$a}';
$string['hidesettings'] = 'Peida seaded';
$string['hideshowblocks'] = 'Peida või kuva plokid';
$string['hits'] = 'Klikid';
$string['hitsoncourse'] = 'Klikke kurusel {$a->coursename} {$a->username} poolt';
$string['hitsoncoursetoday'] = 'Tänased klikid kursusel {$a->coursename} {$a->username} poolt';
$string['home'] = 'Õpikeskkonna avalehele';
$string['hour'] = 'tund';
$string['hours'] = 'tundi';
$string['howtomakethemes'] = 'Kuidas teha uusi kujundusi?';
$string['htmleditor'] = 'Kasuta HTML toimetit';
$string['htmleditoravailable'] = 'HTML toimeti on saadaval';
$string['htmleditordisabled'] = 'Sa pole oma kasutaja andmetes võimaldanud HTML toimetit.';
$string['htmleditordisabledadmin'] = 'Administraator pole võimaldanud HTML toimetit õpikeskkonnas';
$string['htmleditordisabledbrowser'] = 'HTML toimeti pole saadaval, kuna sa ei kasuta Internet Explorer 5.5 või uuemat versiooni';
$string['htmlfilesonly'] = 'HTML failid ainult';
$string['htmlformat'] = 'Kena HTML formaat';
$string['icon'] = 'Ikoon';
$string['icqnumber'] = 'ICQ number';
$string['idnumber'] = 'ID number';
$string['idnumbercourse'] = 'Kursuse ID number';
$string['idnumbercoursecategory'] = 'Kategooria ID number';
$string['idnumbercourse_help'] = 'Kursuse ID-numbrit kasutatakse ainult kokku sidumiseks väliste süsteemidega ja seda ei kuvata kuskil mujal sel saidil. Kui kursusel on ametlik koodnimi, siis võib selle sisestada, muidu saab jätta tühjaks.';
$string['idnumbergroup'] = 'Rühma ID number';
$string['idnumbergrouping'] = 'Rühmituse ID number';
$string['idnumbermod'] = 'ID-number';
$string['idnumbermod_help'] = 'ID-number pakub võimalust identifitseerida tegevuse hinde arvutuseks. Kui tegevus ei ole kaasatud ühegi hinde arvutamisele, siis ID-numbri välja võib jätta tühjaks.

ID-numbri võib samuti märkida hinnetelehes, kuigi seda saab muuta ainult tegevuse seadete lehel.';
$string['idnumbertaken'] = 'See ID-number on juba võetud';
$string['imagealt'] = 'Pildi kirjeldus';
$string['import'] = 'Impordi';
$string['importdata'] = 'Impordi kursuse andmed';
$string['importdataexported'] = '"Kust" kursuse andmed eksporditud edukalt.<br />Jätka importimist "kuhu" kursusesse.';
$string['importdatafinished'] = 'Importimine lõpetatud! Jätka oma kursust.';
$string['importdatafrom'] = 'Otsi kursust, kust andmeid importida';
$string['inactive'] = 'Mitteaktiivne';
$string['include'] = 'Kaasa';
$string['includeallusers'] = 'Kaasa kõik kasutajad';
$string['includecoursefiles'] = 'Kaasa kursuse failid';
$string['includecourseusers'] = 'Kaasa kursuse kasutajad';
$string['included'] = 'Kaasatud';
$string['includelogentries'] = 'Kaasa logide kirjed';
$string['includemodules'] = 'Kaasa moodulid';
$string['includemoduleuserdata'] = 'Kaasa mooduli kasutaja andmed';
$string['includeneededusers'] = 'Kaasa vajalikud kasutajad';
$string['includenoneusers'] = 'Ära kaasa kasutajaid';
$string['includeroleassignments'] = 'Lisa rollide määramised';
$string['includesitefiles'] = 'Lisa keskkonna failid, mis on kasutatud kursusel.';
$string['includeuserfiles'] = 'Kaasa kasutajate failid';
$string['increasesections'] = 'Suurenda sektsioonide arvu';
$string['info'] = 'Informatsioon';
$string['institution'] = 'Asutus';
$string['instudentview'] = 'õppija vaates';
$string['interests'] = 'Huvialad';
$string['interestslist'] = 'Huvialade nimekiri';
$string['interestslist_help'] = 'Palun sisesta oma huvialad, eraldatuna komadega. Su huvialad kuvatakse su profiililehel märksõnadena.';
$string['invalidemail'] = 'Vigane e-posti aadress';
$string['invalidlogin'] = 'Vigane sisenemine, palun proovi uuesti';
$string['invalidusername'] = 'Kasutajanimi saab sisaldada ainult väiketähti, numbreid, alakriipsu (_), sidekriipsu (-), punkti (.) ja ät sümbolit (@).';
$string['invalidusernameupload'] = 'Kasutajatunnus ei sobi';
$string['ip_address'] = 'IP aadress';
$string['jump'] = 'Mine';
$string['jumpto'] = 'Mine...';
$string['keep'] = 'Säilita';
$string['keepsearching'] = 'Säilita otsing';
$string['langltr'] = 'Teksti suund vasakult paremale';
$string['langrtl'] = 'Teksti suund paremalt vasakule';
$string['language'] = 'Keel';
$string['languagegood'] = 'See keelepakett on ajakohane! :-)';
$string['last'] = 'Viimane';
$string['lastaccess'] = 'Viimane külastusaeg';
$string['lastedited'] = 'Viimati muudetud';
$string['lastlogin'] = 'Viimane sisenemine';
$string['lastmodified'] = 'Viimati muudetud';
$string['lastname'] = 'Perekonnanimi';
$string['lastnamephonetic'] = 'Perekonnanimi - foneetiline';
$string['lastyear'] = 'Möödunud aasta';
$string['latestlanguagepack'] = 'Kontrolli/otsi viimast keelepaketti moodle.org-is';
$string['leavetokeep'] = 'Jäta tühjaks, kui soovid säilitada hetkel kasutusel oleva salasõna';
$string['legacythemeinuse'] = 'Saiti kuvatakse ühilduvuse laadis, sest su brauser on nii vaba.';
$string['license'] = 'Litsents';
$string['licenses'] = 'Litsentsid';
$string['liketologin'] = 'Kas soovid siseneda?';
$string['list'] = 'Nimekiri';
$string['listfiles'] = 'Failide nimekiri kataloogis {$a}';
$string['listofallpeople'] = 'Kõigi inimeste nimekiri';
$string['listofcourses'] = 'Kursuste nimekiri';
$string['loadinghelp'] = 'Laadin...';
$string['local'] = 'Kohalik';
$string['localplugins'] = 'Kohalikud lisad';
$string['localpluginsmanage'] = 'Halda kohalikke lisasi';
$string['location'] = 'Asukoht';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Oled sisenenud kui {$a}';
$string['loggedinasguest'] = 'Oled sisenenud külalisena';
$string['loggedinnot'] = 'Sa pole veel sisenenud.';
$string['login'] = 'Sisene';
$string['loginalready'] = 'Oled juba sisenenud';
$string['loginas'] = 'Sisene kui';
$string['login_failure_logs'] = 'Ebaõnnestunud sisenemised';
$string['loginguest'] = 'Sisene külalisena';
$string['loginsite'] = 'Sisene õpikeskkonda';
$string['loginsteps'] = 'Tere! <p>Selleks, et pääseda kursus(t)ele, pead looma omale kasutajatunnuse. Kasutajatunnuse loomiseks pead:<ol><li>Täitma <a href="{$a}">avalduse vormi</a>.</li><li>Pärast avalduse täitmist saadetakse Sinu e-posti aadressile kiri.</li><li>Loe saadud e-kiri läbi ja täida kirjas olevad juhised.</li><li>Kui juhised on täidetud, siis Sinu kasutajatunnus kinnitatakse ja Sind suunatakse õpikeskkonda.</li><li>Vali kursus, millel soovid osaleda.</li><li>Vajadusel sisesta õpetajalt saadud kursusele registreerumise võti.</li></ol>
Edaspidi kasuta õpikeskkonda sisenemisel loodud kasutajanime ja salasõna.';
$string['loginstepsnone'] = '<p>Tere!</p>
<p>Selleks, et pääseda kursus(t)ele, pead looma omale kasutajakonto.</p>
<p>Sul tuleb mõelda välja kasutajanimi ja salasõna!</p>
<p>Kui keegi on sellise kasutajanime juba valinud, siis proovi uut kasutajanime varianti.</p>';
$string['loginto'] = 'Sisene {$a}';
$string['logout'] = 'Välju';
$string['logoutconfirm'] = 'Kas Sa tõesti tahad väljuda?';
$string['logs'] = 'Logid';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">veel</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">veel</a> ]';
$string['lookback'] = 'Vaata tagasi';
$string['mailadmins'] = 'Teavita administraatoreid';
$string['mailstudents'] = 'Teavita õppijaid';
$string['mailteachers'] = 'Teavita õpetajaid';
$string['maincoursepage'] = 'Kursuse avaleht';
$string['makeafolder'] = 'Loo kaust';
$string['makeeditable'] = 'Kui teed \'{$a}\' muudetavaks veebiserveri protsessi jaoks (nt apache), siis saad seda faili muuta otse sellelt leheküljelt';
$string['makethismyhome'] = 'Tee vaikimisi koduleheküljeks';
$string['manageblocks'] = 'Plokid';
$string['managecategorythis'] = 'Halda seda kategooriat';
$string['managecourses'] = 'Kursuste haldamine';
$string['managedatabase'] = 'Andmebaas';
$string['manageeditorfiles'] = 'Halda redaktori poolt kasutatavaid faile';
$string['managefilters'] = 'Filtrid';
$string['managemodules'] = 'Moodulid';
$string['manageroles'] = 'Rollid ja õigused';
$string['markedthistopic'] = 'See teema on esile tõstetud jooksva teemana';
$string['markthistopic'] = 'Märgi see teema jooksvaks teemaks';
$string['matchingsearchandrole'] = '\'{$a->search}\' ja {$a->role} sobivus';
$string['maxareabytesreached'] = 'Fail (või mitme faili kogusuurus) on suurem kui selles alas vaba ruumi leidub.';
$string['maxbytesforfile'] = 'Fail {$a} on suurem kui maksimaalselt lubatud.';
$string['maxfilesize'] = 'Maksimaalne suurus uutele failidele: {$a}';
$string['maxfilesreached'] = 'Sul on lubatud manustada maksimaalselt {$a} faili';
$string['maximumchars'] = 'Maksimaalselt {$a} tähemärki';
$string['maximumgrade'] = 'Maksimumhinne';
$string['maximumgradex'] = 'Maksimaalne hinne: {$a}';
$string['maximumshort'] = 'Maksimum';
$string['maximumupload'] = 'Maksimaalne üleslaadimise suurus';
$string['maximumupload_help'] = 'See seadistus määrab suurima lubatud üles laetavad faili suuruse, olles piiratud saidiülese seadistusega administraatori poolt. Tegevuse moodulid samuti sisaldavad maksimaalset üles lükatava faili suuruse piiranguid.';
$string['maxnumberweeks'] = 'Maksimaalne nädalate / teemade arv';
$string['maxnumberweeks_desc'] = 'See määrab maksimaalsete paistvate valikute hulga "Nädalate/teemade arv" kursuse seadetes.';
$string['maxnumcoursesincombo'] = 'Sirvi <a href="{$a->link}">{$a->numberofcourses} kursust</a>.';
$string['maxsize'] = 'Maksimaalne suurus: {$a}';
$string['maxsizeandareasize'] = 'Uute failide maksimaalne suurus: {$a->size}, üldine limiit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Uute failide maksimaalne suurus: {$a->size}, maksimaalne manuste arv: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Uute failide maksimaalne suurus: {$a->size}, maksimaalne manuste arv: {$a->attachments}, üldine limiit: {$a->areasize}';
$string['memberincourse'] = 'Inimesed kursusel';
$string['messagebody'] = 'Sõnumi tekst';
$string['messagedselectedusers'] = 'Valitud kasutajaid on teavitatud ja saajate nimekiri on tühjendatud.';
$string['messagedselectedusersfailed'] = 'Midagi läks valesti sõnumivahetuses valitud kasutajatele. Mõned võisid saada e-maili.';
$string['messageprovider:availableupdate'] = 'Saadaolevate uuenduste teavitused';
$string['messageprovider:backup'] = 'Varukoopia teavitused';
$string['messageprovider:badgecreatornotice'] = 'Õpimärgi looja teavitused';
$string['messageprovider:badgerecipientnotice'] = 'Õpimärgi saaja teavitused';
$string['messageprovider:courserequestapproved'] = 'Kursuse loomise palve rahuldamise teavitus';
$string['messageprovider:courserequested'] = 'Kursuse loomise palvee teavitus';
$string['messageprovider:courserequestrejected'] = 'Kursuse loomise palve tagasi lükkamise teavitus';
$string['messageprovider:errors'] = 'Saidi olulised vead';
$string['messageprovider:errors_help'] = 'Siin on olulised vead, millest administraator peaks teadma.';
$string['messageprovider:instantmessage'] = 'Personaalsed teated kasutajate vahel';
$string['messageprovider:instantmessage_help'] = 'See sektsioon seadistab, mis juhtub sõnumitega, mis saadetaks otse sinu sellel saidil teistelt kasutajatelt.';
$string['messageprovider:notices'] = 'Märkused pisiprobleemidest';
$string['messageprovider:notices_help'] = 'Siin on märkused, millede nägemisest võiks administraator olla huvitatud.';
$string['messageselect'] = 'Vali see kasutaja sõnumi saajana';
$string['messageselectadd'] = 'Saada sõnum';
$string['middlename'] = 'Liignimi';
$string['min'] = 'minut';
$string['mins'] = 'minutit';
$string['minute'] = 'minut';
$string['minutes'] = 'Minutid';
$string['miscellaneous'] = 'Varia';
$string['missingcategory'] = 'Vali kategooria';
$string['missingcity'] = 'Puudub linna või maakonna nimi';
$string['missingcountry'] = 'Puudub riigi nimi';
$string['missingdescription'] = 'Puudub kirjeldus';
$string['missingemail'] = 'Puudub e-posti aadress';
$string['missingfirstname'] = 'Puudub eesnimi';
$string['missingfromdisk'] = 'Puudub kettalt';
$string['missingfullname'] = 'Puudub täisnimi';
$string['missinglastname'] = 'Puudub perekonnanimi';
$string['missingname'] = 'Puudub nimi';
$string['missingnewpassword'] = 'Puudub uus salasõna';
$string['missingpassword'] = 'Puudub salasõna';
$string['missingrecaptchachallengefield'] = 'Puudu reCAPTCHA väljakutse väli';
$string['missingreqreason'] = 'Puudub põhjus';
$string['missingshortname'] = 'Puudub lühendnimi';
$string['missingshortsitename'] = 'Puudub õpikeskkonna lühendnimi';
$string['missingsitedescription'] = 'Puudub õpikeskkonna kirjeldus';
$string['missingsitename'] = 'Puudub õpikeskkonna nimi';
$string['missingstrings'] = 'Kontrolli puuduvate sõnede olemasolu';
$string['missingstudent'] = 'Pead midagi valima';
$string['missingsummary'] = 'Puudub kokkuvõte';
$string['missingteacher'] = 'Pead midagi valima';
$string['missingurl'] = 'Puudub URL';
$string['missingusername'] = 'Puudub kasutajanimi';
$string['modchooserdisable'] = 'Tegevuse valija lubatud';
$string['modchooserenable'] = 'Tegevuse valija keelatud';
$string['moddoesnotsupporttype'] = 'Moodul {$a->modname} ei toeta {$a->type} tüüpi üleslaetavaid faile';
$string['modified'] = 'Muudetud';
$string['moduleintro'] = 'Kirjeldus';
$string['modulesetup'] = 'Mooduli tabelite seadistamine';
$string['modulesuccess'] = '{$a} tabelid on korrektselt seadistatud';
$string['modulesused'] = 'Kasutatud moodulid';
$string['month'] = 'Kuu';
$string['months'] = 'Kuud';
$string['moodledocs'] = 'Moodle manuaalid';
$string['moodledocslink'] = 'Moodle manuaalid käesoleva lehe kohta';
$string['moodlerelease'] = 'Moodle väljalase';
$string['moodleversion'] = 'Moodle versioon';
$string['more'] = 'veel';
$string['morehelp'] = 'Rohkem abi';
$string['moreinformation'] = 'Veel  informatsiooni tekkinud vea kohta';
$string['moreprofileinfoneeded'] = 'Palun räägi meile rohkem endast';
$string['mostrecently'] = 'kõige viimane';
$string['move'] = 'Teisalda';
$string['movecategoriessuccess'] = '{$a->count} kategooriat on teisaldatud kategooriasse \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = '{$a->count} kategooriat on edukalt teisaldatud tipp-tasemele';
$string['movecategorycontentto'] = 'Teisalda siia';
$string['movecategorysuccess'] = 'Kategooria \'{$a->moved}\' on edukalt teisaldatud kategooriasse \'{$a->to}\'';
$string['movecategoryto'] = 'Teisalda kategooria asukohta:';
$string['movecategorytotopsuccess'] = 'Kategooria \'{$a->moved}\' on edukalt viidud tipp-tasemele';
$string['movecontent'] = 'Teisalda [$a}';
$string['movecontentstoanothercategory'] = 'Teisalda sisu mingisse muusse kategooriasse';
$string['movecourseto'] = 'Teisalda kursus asukohta:';
$string['movedown'] = 'Liiguta alla';
$string['movefilestohere'] = 'Tõsta failid siia';
$string['movefull'] = 'Teisalda {$a} siia';
$string['movehere'] = 'Teisalda siia';
$string['moveleft'] = 'Liiguta vasakule';
$string['moveright'] = 'Liiguta paremale';
$string['movesection'] = 'Teisalda sektsioon {$a}';
$string['moveselectedcategoriesto'] = 'Teisalda valitud kategooriad asukohta';
$string['moveselectedcoursesto'] = 'Teisalda valitud kursused...';
$string['movetoanotherfolder'] = 'Tõsta teise kausta';
$string['moveup'] = 'Liiguta üles';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Uus salasõna peab erinema eelmisest salasõnast';
$string['mustconfirm'] = 'Kinnita oma kasutajatunnus';
$string['mycourses'] = 'Minu kursused';
$string['myfiles'] = 'Minu privaatsed failid';
$string['myfilesmanage'] = 'Halda minu privaatseid faile';
$string['myhome'] = 'Minu kodu';
$string['mymoodledashboard'] = 'Minu Moodle töölaud';
$string['myprofile'] = 'Minu profiil';
$string['name'] = 'Nimi';
$string['nameforlink'] = 'Kuidas Sa seda linki nimetada soovid?';
$string['nameforpage'] = 'Kuidas Sa seda lehte nimetada soovid?';
$string['navigation'] = 'Navigatsioon';
$string['needed'] = 'Vajalik';
$string['never'] = 'Mitte kunagi';
$string['neverdeletelogs'] = 'Ära kunagi kustuta logisid';
$string['new'] = 'Uus';
$string['newaccount'] = 'Uus kasutajakonto';
$string['newcourse'] = 'Uus kursus';
$string['newpassword'] = 'Uus salasõna';
$string['newpassword_help'] = 'Sisesta uus salasõna või jäta väli tühjaks, et kasutada olemasolevat salasõna.';
$string['newpasswordtext'] = 'Tere {$a->firstname},

Sinu konto salasõna \'{$a->sitename}\' õpikeskkonnas on muudetud ning sulle on genereeritud AJUTINE salasõna.

Sinu kontoandmed on järgmised:
   kasutajanimi: {$a->username}
   salasõna: {$a->newpassword}

Palun mine järgmisele aadressile, et muuta salasõna:
   {$a->link}

Enamikus meiliprogrammides peaks eelnev aadress ilmuma lingi kujul, millele võib lihtsalt klikkida. Kui see ei tööta, siis kopeeri aadress oma veebilehitseja aadressiribale.

Tervitustega \'{$a->sitename}\' administraator,
{$a->signoff}';
$string['newpicture'] = 'Uus pilt';
$string['newpicture_help'] = '<P><font size="2" face="Arial, Helvetica, sans-serif"><strong>Pildi &uuml;les
  laadimine.</strong></font>
<P><font size="2" face="Arial, Helvetica, sans-serif">V&otilde;id oma arvutist
  sellesse serverisse &uuml;les laadida m&otilde;ne pildi ning seda pilti saab
  mitmel pool kasutada sinu esindamiseks. <br />
  Selleks sobib k&otilde;ige paremini kujutis, mis on l&auml;hi&uuml;lesv&otilde;te
  sinu n&auml;ost, kuid v&otilde;id kasutada ka mistahes muud kujutist. <br />
  Pilt peab olema JPG v&otilde;i PNG formaadis (nimetus l&otilde;peb tavaliselt
  kas l&uuml;hendiga .jpg v&otilde;i .png)<br />
  </font>
<P><font size="2" face="Arial, Helvetica, sans-serif">Pildifaili saad teha, kui
  kasutad &uuml;ht allnimetatud neljast meetodist:</font>
<blockquote>
  <p><font size="2" face="Arial, Helvetica, sans-serif">1. Kasutades digikaamerat,
    saad suure t&otilde;en&auml;osusega fotod, mis on arvuti tarvis &otilde;iges
    formaadis.<br />
    2. V&otilde;id kasutada skannerit, et skaneerida paberfotot. &Auml;ra unusta
    seda salvestada JPG v&otilde;i PNG formaadis.<br />
    3. Kui oled kunstiliste kalduvustega, v&otilde;id joonistada pildi joonistusprogrammi
    abil.<br />
    4. L&otilde;puks v&otilde;id ju ka &#8220;n&auml;pata&#8221; kujutisi veebist.
    http://images.google.com on fantastiline koht, kust kujutisi otsida. Kui oled
    m&otilde;ne leidnud, tee selle peal hiirega parempoolne kl&otilde;ps ja vali
    men&uuml;&uuml;st &#8220;Salvesta see kujutis&#8230;&#8221; (erinevatel arvutitel
    v&otilde;ib see pisut erineda).<br />
    </font></p>
</blockquote>
<P><font size="2" face="Arial, Helvetica, sans-serif">Kujutise &uuml;les laadimiseks
  kl&otilde;psa redigeerimislehel klahvile &#8220;Lehitse&#8221; ja vali kujutis
  oma k&otilde;vakettalt.<br />
  <br />
  M&Auml;RKUS: Veendu, et fail poleks suurem, kui lubatud maksimumsuurus, vastasel
  juhul ei saa seda &uuml;les laadida.<br />
  <br />
  Seej&auml;rel kl&otilde;psa &#8220;V&auml;rskenda minu profiili&#8221; alaosas
  ja kujutise fail l&otilde;igatakse ruudukujuliseks ning selle suurust v&auml;hendatakse
  kuni 100x100 pikselini.<br />
  <br />
  Kui tuled tagasi oma profiili lehele, v&otilde;ib juhtuda, et kujutis polegi
  muutunud. Sel juhul kasuta oma brauseri klahvi &#8220;Laadi uuesti&#8221;.<br />
  </font>';
$string['newsitem'] = 'uudis';
$string['newsitems'] = 'uudist';
$string['newsitemsnumber'] = 'Mitu uudist näidatakse';
$string['newsitemsnumber_help'] = '<P ALIGN=CENTER><B>Course News Items</B></P>

<P>A special forum called "News" appears in the
   "weekly" and "topics" course formats.  It\'s
   a good place to post notices for all students
   to see.  (By default, all students are subscribed
   to this forum, and will receive your notices by
   email.)

<p><font size="2" face="Arial, Helvetica, sans-serif"><strong>Kursuse uudiskirjad<br />
  </strong><br />
  Spetsiaalne foorum, nimega &#8220;Uudised&#8221; ilmub &#8220;N&auml;dalaste&#8221;
  ja &#8220;Teemade&#8221; kursuseformaatidesse. See on hea koht teadete j&auml;tmiseks,
  et k&otilde;ik &otilde;pilased neid n&auml;eksid. (Vaikimisi on k&otilde;ik
  &otilde;pilased selle foorumiga liitunud ja saavad sinu teated k&auml;tte emaili
  teel).<br />
  See seade m&auml;&auml;rab &auml;ra, kui palju viimaseid uudiseid ilmub sinu
  kursuse kodulehele uudistekasti sisse, mis on all paremal.<br />
  Kui teed seade &#8220;0 uudiskirja&#8221;, siis uudistekast &uuml;ldse ei ilmugi.
  </font></p>
<p><font size="2" face="Arial, Helvetica, sans-serif"><br />
  </font></p>';
$string['newuser'] = 'Uus kasutaja';
$string['newusernewpasswordsubj'] = 'Uus kasutajakonto';
$string['newusernewpasswordtext'] = 'Tere {$a->firstname},

Sinu jaoks on loodud kasutajakonto õpikeskkonnas \'{$a->sitename}\' ja Sinu kontole on määratud AJUTINE salasõna.

Sinu kontoandmed on järgmised:
   kasutajatunnus: {$a->username}
   salasõna: {$a->newpassword}
Esmasel sisenemisel palutakse Sul salasõna muuta.

Õpikeskkonna \'{$a->sitename}\' kasutamiseks logi sisse aadressil:
   {$a->link}

Enamikus meiliprogrammides peaks eelnev aadress ilmuma lingi kujul, millele võib lihtsalt klikkida. Kui see ei tööta, siis kopeeri aadress oma veebilehitseja aadressiribale.

Tervitustega \'{$a->sitename}\' administraator,
{$a->signoff}';
$string['newusers'] = 'Uued kasutajad';
$string['newwindow'] = 'Uus aken';
$string['next'] = 'Järgmine';
$string['nextsection'] = 'Järgmine sektsioon';
$string['no'] = 'ei';
$string['noblockstoaddhere'] = 'Pole ühtegi plokki mida saaksite siia lehele paigutada.';
$string['nobody'] = 'Mitte keegi';
$string['nochange'] = 'Muutusi pole';
$string['nocomments'] = 'Kommentaarid puuduvad';
$string['nocourses'] = 'Kursused puuduvad';
$string['nocoursesfound'] = 'Sõna \'{$a}\' ei esinenud üheski kursuse nimes';
$string['nocoursesyet'] = 'Selles kategoorias pole kursusi';
$string['nodstpresets'] = 'Administraator ei ole võimaldanud suveaja kasutamise tuge.';
$string['nofilesselected'] = 'Taastamiseks pole vaitud ühtegi faili';
$string['nofilesyet'] = 'Teie kursusele pole üles laetud ühtegi faili';
$string['nograde'] = 'Hinne puudub';
$string['nohelpforactivityorresource'] = 'Käesoleval ajal ei ole selle vahendi või tegevusega seotud abiinfot ega spikrit';
$string['noimagesyet'] = 'Sinu kursusele pole üles laetud veel ühtegi pilti';
$string['nologsfound'] = 'Logisid ei leitud';
$string['nomatchingusers'] = 'Ei leitud kasutajaid mis vastaksid \'{$a}\'';
$string['nomorecourses'] = 'Rohkem sobivaid kursuseid ei leidunud';
$string['nomoreidnumber'] = 'Ei kasuta ID numbrit, vältimaks kokkupõrkeid';
$string['none'] = 'Puudub';
$string['noneditingteacher'] = 'Toimetusõigusteta õpetaja';
$string['noneditingteacherdescription'] = 'Toimetusõigusteta õpetaja võib kursustel õpetada ja hinnata õppijaid, aga muutmisõigusi tal pole.';
$string['nonstandard'] = 'Mittestandardsed';
$string['nopendingcourses'] = 'Pole ühtegi kursust mis ootaksid kinnitust';
$string['nopotentialadmins'] = 'Võimalikke administraatoreid pole';
$string['nopotentialcreators'] = 'Võimalikke kursuse disainereid pole';
$string['nopotentialstudents'] = 'Võimalikke õppijaid pole';
$string['nopotentialteachers'] = 'Võimalikke õpetajaid pole';
$string['norecentactivity'] = 'Viimased tegevused puuduvad';
$string['noreplybouncemessage'] = 'Sa vastasid e-posti aadressile, kuhu ei saa kirju saata. Kui üritasid foorumi postitusele vastata, siis palun kasuta {$a} foorumit.
Järgnev on Sinu e-kirja sisu:';
$string['noreplybouncesubject'] = '{$a} - tagastatud e-kiri';
$string['noreplyname'] = 'Ära vasta sellele e-kirjale';
$string['noresults'] = 'Tulemusi ei olnud';
$string['normal'] = 'Normaalne';
$string['normalfilter'] = 'Tavaotsing';
$string['nosite'] = 'Ei leidnud õpikeskkonna kursusi';
$string['nostudentsfound'] = '{$a} ei leidunud';
$string['nostudentsingroup'] = 'Selles rühmas ei ole veel õppijaid';
$string['nostudentsyet'] = 'Sellele kursusele pole veel registreerunud ühtegi õppijat';
$string['nosuchemail'] = 'Sellist e-posti aadressi pole';
$string['notavailable'] = 'Ei ole avatud';
$string['noteachersyet'] = 'Sellel kursusel pole veel õpetajaid';
$string['notenrolled'] = '{$a} pole sellele kursusele registreerunud.';
$string['notenrolledprofile'] = 'Kasutajaprofiil pole kättesaadav kuna, see kasutaja pole antud kursusele registreerunud.';
$string['noteuserschangednonetocourse'] = 'Märkus: kasutajate andmeid taastades peab taastama ka kursuse kasutajad. See seadistus on nüüd muudetud.';
$string['nothingnew'] = 'Sinu viimasest sisenemisest alates pole midagi uut';
$string['nothingtodisplay'] = 'Pole midagi näidata';
$string['notice'] = 'Märkus';
$string['noticenewerbackup'] = 'See varukoopia fail on loodud Moodle versiooniga
{$a->backuprelease} ({$a->backupversion}), mis on uuem, kui hetkel installeeritud Moodle versioon {$a->serverrelease} ({$a->serverversion}). See võib tekitada mõningaid probleeme, kuna varundusfailide tagasi ühenduvus ei ole garanteeritud.';
$string['notifications'] = 'Teavitused';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Kasutaja: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Sa võid neid logisi vaadata siit:
{$a}/course/log.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Siin on {$a} ebaõnnestunud sisenemiste nimekiri alates sellest, kui sind viimati teavitati.';
$string['notifyloginfailuressubject'] = '{$a} :: Ebaõnnestunud sisenemiste teavitus';
$string['notincluded'] = 'Pole kaasatud';
$string['notingroup'] = 'Vabandust, aga selle tegevuse nägemiseks pead olema rühma liige.';
$string['notpublic'] = 'Pole avalik';
$string['nousersfound'] = 'Kasutajaid ei leitud';
$string['nousersmatching'] = 'Ei leitud sõna \'{$a}\' sisaldavaid kasutajaid.';
$string['nousersyet'] = 'Kasutajaid veel pole';
$string['novalidcourses'] = 'Pole kehtivaid kursusi kuvamiseks';
$string['now'] = 'Hetkel';
$string['numattempts'] = '{$a} ebaõnnestunud sisenemist';
$string['numberofcourses'] = 'Kursusi kokku';
$string['numberweeks'] = 'Nädalate/teemade arv';
$string['numdays'] = '{$a} päeva';
$string['numhours'] = '{$a} tundi';
$string['numletters'] = '{$a} tähte';
$string['numminutes'] = '{$a} minutit';
$string['nummonths'] = '{$a} kuud';
$string['numseconds'] = '{$a} sekundit';
$string['numviews'] = '{$a} korda vaadatud';
$string['numweeks'] = '{$a} nädalat';
$string['numwords'] = '{$a} sõna';
$string['numyears'] = '{$a} aastat';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Kehtiv salasõna';
$string['opentoguests'] = 'Külalise juurdepääs';
$string['optional'] = 'valikuline';
$string['options'] = 'valikud';
$string['order'] = 'Järjekord';
$string['originalpath'] = 'Originaali asukoht';
$string['other'] = 'Muud';
$string['outline'] = 'Liigendus';
$string['outlinereport'] = 'Liigenduse ülevaade';
$string['page'] = 'Leht';
$string['pagea'] = 'Leht {$a}';
$string['pageheaderconfigablock'] = 'Konfigureerin plokki %fullname%';
$string['pagepath'] = 'Lehekülje viit';
$string['pageshouldredirect'] = 'See leht peaks automaatselt edasi suunama. Kui seda ei juhtu, siis palun vajuta jätkamise linki allpool.';
$string['parentcategory'] = 'Ülemkategooria';
$string['parentcoursenotfound'] = 'Ülemkursust ei leitud!';
$string['parentfolder'] = 'Ülemkaust';
$string['participants'] = 'Osalejad';
$string['participantslist'] = 'Osalejate nimekiri';
$string['participationratio'] = 'Osalemise arv';
$string['participationreport'] = 'Osalemise arv';
$string['password'] = 'Salasõna';
$string['passwordchanged'] = 'Salasõna on muudetud';
$string['passwordconfirmchange'] = 'Kinnita salasõna muutmine';
$string['passwordforgotten'] = 'Unustatud salasõna';
$string['passwordforgotteninstructions'] = 'Sinu andmed peab alguses leidma meie andmebaasist. Palun sisesta kas oma kasutajanimi või konto e-mailiaadress vastavasse kastu (mitte mõlemaid korraga).';
$string['passwordforgotteninstructions2'] = 'Salasõna lähtestamiseks sisesta all olevatele väljadele oma kasutajanimi või e-posti aadress. Kui me suudame nende andmete alusel sinu konto andmebaasist leida, siis saadetakse sinu e-posti aadressile kiri, millest leiad juba edasised juhised oma kontole ligipääsu taastamiseks.';
$string['passwordrecovery'] = 'Jah, aita mul siseneda';
$string['passwordsdiffer'] = 'Need salasõnad ei lange kokku';
$string['passwordsent'] = 'Salasõna on saadetud';
$string['passwordsenttext'] = '<p>Sinu e-posti aadressile {$a->email} saadeti kiri.</p>

<p><b>Palun vaata sealt oma uut salasõna.</b></p>

<p>Uus salasõna genereeriti automaatselt, <a href={$a->link}>muuda salasõna</a> millekski lihtsamini meeldejäävaks</a>.</p>';
$string['passwordset'] = 'Sinu salasõna on salvestatud.';
$string['path'] = 'Viit';
$string['pathnotexists'] = 'Antud tee ei eksisteeri Sinu serveris!';
$string['pathslasherror'] = 'Tee ei tohi lõppeda kaldkriipsuga!';
$string['paymentinstant'] = 'Kasuta allolevat nuppu, et tasuda ja saada kursusele registreeritud.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> otsuse ootel</small>)';
$string['paymentrequired'] = 'See kursus on tasuline.';
$string['payments'] = 'Maksed';
$string['paymentsorry'] = 'Täname Sind makse eest. Kahjuks ei ole Sinu makse veel täielikult läbi viidud ja Sa ei ole veel registreeritud kursusele "{$a->fullname}".

Palun proovi siseneda kursusele uuesti mõne sekundi pärast. Kui probleemid jätkuvad, teavita sellest õpetajat {$a->teacher} või õpikeskkonna administraatorit.';
$string['paymentthanks'] = 'Täname Sind makse eest. Oled nüüd registreeritud kursusele<br />"{$a}"';
$string['pendingrequests'] = 'Otsustamata taotlused';
$string['periodending'] = 'Ajavahemiku lõppemine ({$a})';
$string['perpage'] = 'Lehekülje kohta';
$string['perpagea'] = 'Lehekülje kohta: {$a}';
$string['personal'] = 'Isiklik';
$string['personalprofile'] = 'Isiklikud andmed';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobiili nr.';
$string['phpinfo'] = 'PHP informatsioon';
$string['pictureof'] = '{$a} pilt';
$string['pictureofuser'] = 'Kasutajapilt';
$string['pleaseclose'] = 'Palun sulge see aken praegu.';
$string['pleasesearchmore'] = 'Palun otsi veel rohkem';
$string['pleaseusesearch'] = 'Palun kasuta otsingut';
$string['plugin'] = 'Plugin';
$string['plugincheck'] = 'Lisa vidinate kontroll';
$string['plugindeletefiles'] = 'Kõik pluginaga \'{$a->name}\' seotud andmed on kustutatud andmebaasist. Vältimaks plugina enda uuesti installeerimist, sa peaksid praegu kustutama selle kataloogi oma serverist: {$a->directory}';
$string['policyaccept'] = 'Saan aru ja nõustun';
$string['policyagree'] = 'Sa pead nõustuma nende tingimustega, et saaksid õpikeskkonda kasutada. Kas Sa nõustud?';
$string['policyagreement'] = 'Õpikeskkonna kasutamise tingimused';
$string['policyagreementclick'] = 'Kliki siia, et lugeda õpikeskkonna kasutamise tingimusi';
$string['popup'] = 'Hüpikaken';
$string['popupwindow'] = 'Ava fail uues aknas';
$string['popupwindowname'] = 'Hüpikaken';
$string['post'] = 'Post';
$string['posts'] = 'Postitused';
$string['potentialadmins'] = 'võimalikku administraatorit';
$string['potentialcreators'] = 'võimalikku kursuse disainerit';
$string['potentialstudents'] = 'võimalikku õppijat';
$string['potentialteachers'] = 'võimalikku õpetajat';
$string['preferences'] = 'Eelistused';
$string['preferredlanguage'] = 'Eelistatud keel';
$string['preferredtheme'] = 'Eelistatud kujundus';
$string['preprocessingbackupfile'] = 'Eeltöötlen varukoopia faili';
$string['prev'] = 'Eelm';
$string['preview'] = 'Eelvaade';
$string['previewhtml'] = 'HTML formaadi eelvaade';
$string['previeworchoose'] = 'Eelvaade või vali kujundus';
$string['previous'] = 'Eelmine';
$string['previouslyselectedusers'] = 'Eelnevalt valitud kasutajad, kes ei ole \'{$a}\'';
$string['previoussection'] = 'Eelmine sektsioon';
$string['primaryadminsetup'] = 'Administraatori konto seadistamine';
$string['profile'] = 'Kasutaja andmed';
$string['profilenotshown'] = 'Seda profiili kirjeldust ei kuvata enne kui pole registreeritud vähemalt ühele kursusele.';
$string['publicprofile'] = 'Avalik profiil';
$string['publicsitefileswarning'] = 'Märkus: siia pandud faile saab kasutada igaüks';
$string['publish'] = 'Avalda';
$string['question'] = 'Küsimus';
$string['questionsinthequestionbank'] = 'Küsimused küsimuste pangas';
$string['readinginfofrombackup'] = 'Loen infot varukoopiast';
$string['readme'] = 'LOEMIND';
$string['recentactivity'] = 'Hiljutine tegevus';
$string['recentactivityreport'] = 'Viimaste tegevuste täielik kokkuvõte';
$string['recipientslist'] = 'Saajate nimekiri';
$string['recreatedcategory'] = 'Uuesti loodud kategooria {$a}';
$string['redirect'] = 'Ümbersuunamine';
$string['reducesections'] = 'Vähenda sektsioonide arvu';
$string['refresh'] = 'Uuenda';
$string['refreshingevents'] = 'Sündmuste uuendamine';
$string['registration'] = 'Moodle registreerimine';
$string['registrationcontact'] = 'Kontakteerumine';
$string['registrationcontactno'] = 'Ei, ma ei soovi õpikeskkonda kontaktivormi';
$string['registrationcontactyes'] = 'Jah, loo vorm, mille kaudu tulevased õppijad saaksid minuga kontakteeruda';
$string['registrationemail'] = 'E-posti teavitused';
$string['registrationinfo'] = '<p> See leht võimaldab registreerida oma Moodle\'i keskkonna moodle.org\'is. Registreerimine on tasuta.

  Registreerimise põhihüveks on see, et liitud väikesemahulise meililistiga, kus edastatakse olulisi teateid nagu turvahoiatused ja teated Moodle\'i uute versioonide kohta.</p>

  <p>Vaikimisi hoitakse sinu informatsiooni privaatselt ja ei jagata ega müüda kunagi kellelegi teisele. Ainus põhjus seda infot koguda on toetuseesmärgil ning Moodle\'i kasutajaskonnast tervikliku ülevaate loomiseks.

</p><p>Soovi korral võid lubada oma õpikeskkonna nime, riigi ja URL\'i lisada Moodle\'i õpikeskkondade avalikku loendisse.

 </p><p>Kõik uued registreerimised kontrollitakse ükshaaval, enne kui nad loendisse lisatakse, kuid juba loendis olles võid uuendada oma registreerimist

(ning oma sissekannet avalikus loendis) suvalisel ajal, esitades uuesti selle blanketi.</p>';
$string['registrationinfotitle'] = 'Registreerimis informatsioon';
$string['registrationno'] = 'Ei, ma ei soovi e-kirju saada';
$string['registrationsend'] = 'Saada registreerimisinfo moodle.org-i';
$string['registrationyes'] = 'Jah, palun teatage mulle tähtsatest asjaoludest';
$string['reject'] = 'Keeldu/lükka tagasi';
$string['rejectdots'] = 'Lükka tagasi...';
$string['reload'] = 'Laadi uuesti';
$string['remove'] = 'Eemalda';
$string['removeadmin'] = 'Kustuta administraator';
$string['removecreator'] = 'Kustuta disainer kursuselt';
$string['removestudent'] = 'Kustuta õppija kursuselt';
$string['removeteacher'] = 'Kustuta õpetaja kursuselt';
$string['rename'] = 'Nimeta ümber';
$string['renamefileto'] = 'Nimeta ümber <b>{$a}</b> -';
$string['report'] = 'Ülevaade';
$string['reports'] = 'Ülevaated';
$string['repositories'] = 'Repositooriumid';
$string['requestcourse'] = 'Taotle uue kursuse loomist';
$string['requestedby'] = 'Taotleja';
$string['requestedcourses'] = 'Taotletud kursused';
$string['requestreason'] = 'Kursuse taotluse põhjus';
$string['required'] = 'Kohustuslik';
$string['requirespayment'] = 'Sellele kursusele pääs on tasuline';
$string['reset'] = 'Taasta';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Lähtesta kursus';
$string['resetinfo'] = 'Siin saate tühjendada oma kursuse õppijatest ja nende tegevustest. Seega pärast kursuse tühjendamist eelmistest õppijatest on teie kursus valmis järgmise rühma jaoks. Alles jäävad kõik õppejõu lisatud vahendid ja tegevused.  Arvestage sellega, et kustutatud andmeid pole võimalik enam taastada.

Automaatselt ei saa te tühjendada järgmisi tegevusi (soovi korral peate tegema seda käsitsi): õpipäevikud, wikid, mõistekaardid, mälukaardid,   M-sisupaketid ja NanoGongid (suulised ülesanded). <br />
<b>NB! Alljärgnevalt on vaikimisi määratud soovituslikud seaded, mida tüüpiliselt kursuse tühjendamisel kasutatakse. </b>';
$string['resetnotimplemented'] = 'Kursusel ei tühjendata';
$string['resetstartdate'] = 'Taasta alguskuupäev';
$string['resetstatus'] = 'Staatus';
$string['resettask'] = 'Ülesanne';
$string['resettodefaults'] = 'Taasta vaikimisi seaded';
$string['resortbyfullname'] = 'Täisnime järgi';
$string['resortbyidnumber'] = 'ID numbri järgi';
$string['resortbyshortname'] = 'Lühinime järgi';
$string['resortcourses'] = 'Sorteeri kursused';
$string['resortsubcategoriesbyidnumber'] = 'Sorteeri alamkategooriad ID numbri järgi';
$string['resortsubcategoriesbyname'] = 'Sorteeri alamkategooriad nime järgi';
$string['resource'] = 'Ressurss';
$string['resourcedisplayauto'] = 'Automaatne';
$string['resourcedisplaydownload'] = 'Allalaadimine';
$string['resourcedisplayembed'] = 'Manustatud';
$string['resourcedisplayframe'] = 'Raamis';
$string['resourcedisplaynew'] = 'Uus aken';
$string['resourcedisplayopen'] = 'Ava';
$string['resourcedisplaypopup'] = 'Hüpikaknas';
$string['resources'] = 'Kursuse materjalid';
$string['resources_help'] = 'Ressursitüübid võimaldavad peaaegu igat liiki veebi sisu lisada kursusele.';
$string['restore'] = 'Taasta varukoopiast';
$string['restorecancelled'] = 'Taastamine tühistatud';
$string['restorecannotcreateuser'] = 'Taastamine vajab uue kasutaja loomist \'{$a}\' varundusfailist aga sul pole õigusi kasutaid luua.';
$string['restorecoursenow'] = 'Taasa see kursus nüüd!';
$string['restoredaccount'] = 'Taastatud konto';
$string['restoredaccountinfo'] = 'See konto imporditi muust serverist ja protsessi käigus läks salasõna kaotsi. Uue salasõna seadistamiseks e-posti teel vajuta palun "Jätka"';
$string['restorefinished'] = 'Taastamine õnnestus';
$string['restoreto'] = 'Taasta asukohta';
$string['restoreuserconflict'] = 'Proovida taastada kasutajat \'{$a}\' varukoopiast võib põhjustada konflikti';
$string['restoreusersprecheck'] = 'Kontrollitakse kasutaja andmeid';
$string['restricted'] = 'Piiratud';
$string['returningtosite'] = 'Sisene õpikeskkonda';
$string['returntooriginaluser'] = 'Tagasi {$a} juurde';
$string['revert'] = 'Tühjenda väljad';
$string['role'] = 'Roll';
$string['roleassignments'] = 'Rollide jaotamised';
$string['rolemappings'] = 'Rolli sidumised';
$string['rolerenaming'] = 'Rolli ümber nimetamine';
$string['rolerenaming_help'] = 'See seadistus võimaldab muuta rollide kuvatavaid nimesid kursuses. Ainult kuvatavad nimi muudetakse - rolli õigused jäävad endiseks. Uued rollide nimed ilmuvad kursusest osavõtjate lehel ja mujal kursuses. Kui ümber nimetatud roll on üks, mida administraator on valinud kui kursuse haldaja roll, siis uue rolli nimi ilmub samuti kursuse nimekirja osas.';
$string['roles'] = 'Rollid';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'RSS artiklite arv';
$string['rsserror'] = 'Viga RSS andmete lugemisel';
$string['rsserrorauth'] = 'Su RSS-link ei sisalda kehtivat autentimisluba.';
$string['rsserrorguest'] = 'See sööt kasutab külalisligipääsu pääsemaks ligi andmetele, aga külalisel ei ole õiguseid lugeda andmeid. Külasta algset kohta, kust sööt tuleb (URL) kehtiva kasutajana ja saa uus RSS link sealt.';
$string['rsskeyshelp'] = 'Tagamaks turvalisust ja privaatsust, RSS-sööte URL-d sisaldavad spetsiaalset turvamärki (token), mis identifitseerivad kasutajat, kellele ta on välja antud. Vältimaks muude kasutajate ligipääsu Moodle alalt, ei tohiks neil olle ligipääsu läbi RSS-söötmete.</p><p>See turvamärk luuakse automaatselt, mil esimest korda sa pöördud Moodle ala poole, mis tekitab RSS-söötme. Kui sa tunned, et sinu RSS-söötme turvamärki on turvalisust on ohustatud mingit moodi, siis sa saad küsida uue, klikkides Lähtesta lini siin. Palun pane tähele, et su praegune RSS-sööte URL-s sel juhul muutuvad vigasteiks.';
$string['rsstype'] = 'RSS sööde selle tegevuse jaoks';
$string['saveandnext'] = 'Salvesta ja näita järgmist';
$string['savechanges'] = 'Salvesta muudatused';
$string['savechangesanddisplay'] = 'Salvesta ja kuva';
$string['savechangesandreturntocourse'] = 'Salvesta ja mine tagasi kursusele';
$string['savecomment'] = 'Salvesta kommentaar';
$string['savedat'] = 'Salvesta kohta:';
$string['savepreferences'] = 'Salvesta eelistused';
$string['saveto'] = 'Salvesta asukohta';
$string['scale'] = 'Skaala';
$string['scale_help'] = 'Skaala pakub teed kritiseerimise ja hindamise sooritust tegevustes. See defineerib järjestatud nimekirja väärtustest, reastatuna negatiivsest positiivseni, eraldatult komadega. Näiteks "Pettumus, mitte piisavalt hea, Keskmine, Hea, Väga hea, Suurepärane!"';
$string['scales'] = 'Skaalad';
$string['scalescustom'] = 'Omatehtud skaalad';
$string['scalescustomcreate'] = 'Lisa uus skaala';
$string['scalescustomno'] = 'Omatehtud skaalasid pole veel loodud';
$string['scalesstandard'] = 'Standardskaalad';
$string['scalestandard'] = 'Standard skaala';
$string['scalestandard_help'] = 'Standard skaala on saadaval kõigile, kõigis kursustes';
$string['scalestip'] = 'Omatehtud skaalade loomiseks kasuta \'Skaalad...\' linki kursuse administreerimise menüüs.';
$string['scalestip2'] = 'Selleks, et luua skaalasi, vajutage Hinnete linki kursuse administreerimise menüüs, seejärel Muuda, Skaalad.';
$string['schedule'] = 'Ajastamine';
$string['screenshot'] = 'Ekraanipilt';
$string['search'] = 'Otsi';
$string['searchagain'] = 'Otsi uuesti';
$string['searchbyemail'] = 'Otsi e-posti aadressite järgi';
$string['searchbyusername'] = 'Otsi kasutajatunnuse järgi';
$string['searchcourses'] = 'Otsi kursusi';
$string['searchhelp'] = 'Saate otsida mitmeid sõnu korraga. <br />sõna: otsi igat vastet sellele sõnale teksti seest.<br />+sõna: leitakse ainult täpne vaste otsitavale sõnale.<br />-sõna: ei lisata tulemusi, mis sisaldavad seda sõna.';
$string['search_help'] = 'Ühe või rohkema sõna otsimiseks tekstist, lihtsalt sisesta nad eraldatult tühikutega. Kasutatakse kõiki sõnu, mis pikemad kui kaks tähemärki.

Detailses otsinguks vajuta otsingunuppu ilma trükkimata mitte midagi otsingu kasti, et ligi pääseda ligi detailsele otsinguvormile.';
$string['searchoptions'] = 'Otsingu valikud';
$string['searchresults'] = 'Otsingu tulemused';
$string['sec'] = 'sekund';
$string['seconds'] = 'sekundit';
$string['secondstotime172800'] = '2 päeva';
$string['secondstotime259200'] = '3 päeva';
$string['secondstotime345600'] = '4 päeva';
$string['secondstotime432000'] = '5 päeva';
$string['secondstotime518400'] = '6 päeva';
$string['secondstotime604800'] = '1 nädal';
$string['secondstotime86400'] = '1 päev';
$string['secretalreadyused'] = 'Muuda parooli linki on juba kasutatud, parooli ei muudetud.';
$string['secs'] = 'sekundit';
$string['section'] = 'Sektsioon';
$string['sectionname'] = 'Sektsiooni nimi';
$string['sections'] = 'Sektsioonid';
$string['sectionusedefaultname'] = 'Kasuta vaikimisi sektsiooni nime';
$string['seealsostats'] = 'Vaata ka: statistika';
$string['selctauser'] = 'Vali kasutaja';
$string['select'] = 'Vali';
$string['selectacategory'] = 'Palun vali kategooria';
$string['selectacountry'] = 'Vali riik';
$string['selectacourse'] = 'Vali kursus';
$string['selectacoursesite'] = 'Vali kursus või sait';
$string['selectagroup'] = 'Vali rühm';
$string['selectall'] = 'Vali kõik';
$string['selectamodule'] = 'Vali toimingu moodul';
$string['selectanaction'] = 'Vali tegevus';
$string['selectanoptions'] = 'Tee valik';
$string['selectaregion'] = 'Vali piirkond';
$string['selectcategorysort'] = 'Mis kategooriaid sa sorteerida soovid';
$string['selectcategorysortby'] = 'Vali, kuidas soovid kategooriaid sorteerida';
$string['selectcoursesortby'] = 'Vali, kuidas soovid sorteerida kursuseid';
$string['selectdefault'] = 'Vali vaikimisi';
$string['selectedcategories'] = 'Valitud kategooriad';
$string['selectedfile'] = 'Valitud fail';
$string['selectednowmove'] = '{$a} valitud faili liigutamiseks. Nüüd mine sihtkohta ja vajuta \'Liiguta failid siia\'';
$string['selectfiles'] = 'Vali failid';
$string['selectmoduletoviewhelp'] = 'Vali tegevus või vahend, et näha abiinfot selle kohta.

Tegevuse või vahendi kiiresti lisamiseks tee selle nimel topeltklõps.';
$string['selectnos'] = 'Märgi kõik \'ei\'';
$string['selectperiod'] = 'Märgi periood';
$string['senddetails'] = 'Saada andmed minu e-posti aadressile';
$string['separate'] = 'Eraldatud';
$string['separateandconnected'] = 'Eraldatud ja ühendatud teadmise teed';
$string['separateandconnectedinfo'] = 'Skaala baseerub eraldatud ja ühendatud teadmise teoorial. Teooria kirjeldab kahte erinevat moodust, kuidas saab hinnata ja õppida asju, mida me näeme ja kuuleme:
<ul><li><strong>Eraldatud teadjad</strong> jäävad nii objektiivseteks kui võimalik, ilma tunnete ja emotsioonide kaasamiseta. Diskussioonides teiste inimestega, nad kaitsevad enda ideesid, kasutades loogikat leidmaks aukusid opponendi ideedes.</li>
<li><strong>Ühendatud teadjad</strong> on teiste suhtes tundlikumad. Nad on empaatias osavad ja kalduvad kuulama ning küsivad küsimusi, kuni nad tunnevad, et nad saavad ühenduda ja "mõistavad asju nende vaatenurgast". Nad õpivad proovides jagada kogemusi, mis juhtisid neid teiste inimeste teadmisteni..</li></ul>';
$string['serverlocaltime'] = 'Serveri kohalik aeg';
$string['setcategorytheme'] = 'Sea kategooria kujundus';
$string['setpassword'] = 'Määra salasõna';
$string['settings'] = 'Seaded';
$string['shortname'] = 'Lühendnimi';
$string['shortnamecollisionwarning'] = '[*] = See kursuse lühinimi on juba kasutusel ja on vaja muuta heaks kiitmiseks';
$string['shortnamecourse'] = 'Kursuse lühinimi';
$string['shortnamecourse_help'] = '<font size="2" face="Arial, Helvetica, sans-serif"><strong>Kursuse l&uuml;hinimi </strong>
</font><font face="Arial, Helvetica, sans-serif"><p><font size="2">Paljudel asutustel on kombeks oma kursusele viidata l&uuml;hinime abil, nagu
  BP102 v&otilde;i COMMS. Isegi kui sa veel pole oma kursusele sellist nime andnud,
  tee seda siin. Seda saab kasutada mitmel puhul, kus pikk nimi pole lihtsalt
  kohane (nagu emaili teemareal).<br />
</font></p>
</font>';
$string['shortnametaken'] = 'Lühendnimi on juba kasutusel teisel kursusel ({$a})';
$string['shortnameuser'] = 'Kasutaja lühinimi';
$string['shortsitename'] = 'Õpikeskkonna lühendnimi (näit. üks sõna)';
$string['show'] = 'Näita';
$string['showactions'] = 'Näita tegevusi';
$string['showadvancedsettings'] = 'Näita laiendatud seadeid';
$string['showall'] = 'Näita kõik {$a}';
$string['showallcourses'] = 'Näita kõiki kursusi';
$string['showallusers'] = 'Näita kõiki kasutajaid';
$string['showblockcourse'] = 'Näita kursuste nimekirja kus esineb plokk';
$string['showcategory'] = 'Näita {$a}';
$string['showcomments'] = 'Näita/peida kommentaare';
$string['showcommentsnonjs'] = 'Näita kommentaare';
$string['showdescription'] = 'Näita kirjeldust kursuse esilehel';
$string['showdescription_help'] = 'Kui lubatud, siis näidatakse kursuse lehel tegevuse / vahendi lingi all ka vastavat sissejuhatust / kirjeldust.';
$string['showgrades'] = 'Näita hinnetelehte õppijatele';
$string['showgrades_help'] = 'Mitmed tegevused kursuses võimaldavad hinnete panemist. See seadistus määrab kas õpilane saab näha kursuse oma hinnete nimekirja väbi hinnete lingi kursuse administreerimise plokis.';
$string['showingacourses'] = 'Näitan kõiki {$a} kursust';
$string['showlistofcourses'] = 'Näita kursuste nimekirja';
$string['showmodulecourse'] = 'Näita kursuste nimekirja kus esineb tegevus';
$string['showonly'] = 'Näita ainult';
$string['showperpage'] = 'Näita {$a} leheküljel';
$string['showrecent'] = 'Näita viimast tegevust';
$string['showreports'] = 'Näita tegevuse ülevaateid';
$string['showreports_help'] = 'Tegevuse raportid on kättesaadavad igale osalejale, mis kuvab nende tegevuse kursusel. Lisaks ka nende panused, nagu näiteks foorumipostitused või määratud esitused, need raportid sisaldavad samuti pöörduste logi. See seadistus määrab, kas õpilane saab näha nende oma tegevuste raportit oma profiili lehe kaugu.';
$string['showsettings'] = 'Näita seadeid';
$string['showtheselogs'] = 'Näita neid logisid';
$string['since'] = 'Alates';
$string['sincelast'] = 'Alates viimasest sisenemisest';
$string['site'] = 'Õpikeskkond';
$string['sitedefault'] = 'Õpikeskkonna vaikimisi seaded';
$string['siteerrors'] = 'Õpikeskkonna vead';
$string['sitefiles'] = 'Õpikeskkonna failid';
$string['sitehome'] = 'Saidi kodu';
$string['sitelegacyfiles'] = 'Pärand saidi failid';
$string['sitelogs'] = 'Õpikeskkonna sisenemised';
$string['sitenews'] = 'Õpikeskkonna uudised';
$string['sitepages'] = 'Saidi leheküljed';
$string['sitepartlist'] = 'Sul pole nõutavaid õigusi osalejate nimekirja vaatamiseks';
$string['sitepartlist0'] = 'Pead olema õppikeskkonna õpetaja, et näha osalejate nimekirja';
$string['sitepartlist1'] = 'Pead olema õpetaja, et näha õpikeskkonna osalejate nimekirja';
$string['sites'] = 'Õpikeskkonnad';
$string['sitesection'] = 'Kaasa teema sektsioon';
$string['sitesettings'] = 'Õpikeskkonna seaded';
$string['siteteachers'] = 'Õpikeskkonna õpetajad';
$string['size'] = 'Suurus /maht';
$string['sizeb'] = 'baiti';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Vahele jäetud';
$string['skiptocategorylisting'] = 'Hüppa otse kategooriate nimekirja';
$string['skiptocourselisting'] = 'Jäta vahele ja liigu kursuste nimekirja juurde';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Sotsiaalne foorum - viimased teemad';
$string['someallowguest'] = 'Mõnedele kursustele võib olla lubatud siseneda külalisena';
$string['someerrorswerefound'] = 'Osa informatsiooni puudus või oli ebakorrektne. Vaata järgnevat täpsustust.';
$string['sort'] = 'Sorteeri';
$string['sortby'] = 'Sorteeri';
$string['sortbyx'] = 'Sorteeri {$a} järgi tõusvalt';
$string['sortbyxreverse'] = 'Sorteeri {$a} järgi kahanevalt';
$string['sortcategoriesbyidnumber'] = 'Sorteeri kategooriad ID numbri järgi';
$string['sortcategoriesbyname'] = 'Sorteeri kategooriad nime järgi';
$string['sortcoursesbyfullname'] = 'Sorteeri kursused täisnime järgi';
$string['sortcoursesbyidnumber'] = 'Sorteeri kursused ID numbri järgi';
$string['sortcoursesbyshortname'] = 'Sorteeri kursused lühinime järgi';
$string['sorting'] = 'Sorteerimine';
$string['sourcerole'] = 'Lähteroll';
$string['specifyname'] = 'Pead täpsustama nime.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = kinnitamist ootav kursus)';
$string['startdate'] = 'Kursuse alguskuupäev';
$string['startdate_help'] = '<P ALIGN=CENTER><B>Course Start Date</B></P>

<P>This is where you specify the starting time of the
   course (in your own timezone).

<font size="2" face="Arial, Helvetica, sans-serif"><strong>Kursuse alguse kuup&auml;ev
</strong>
</font><font face="Arial, Helvetica, sans-serif"><p><font size="2">Siin saad t&auml;psustada oma kursuse algamise aja (oma ajav&ouml;&ouml;ndis).</font></p>
<p><font size="2">Kui kasutad &#8220;n&auml;dalate&#8221; kursuseformaati, siis m&otilde;jutab
  see n&auml;dalate kuvamist. Esimene n&auml;dal algab kuup&auml;eval, mille sa
  siin seadistad.</font></p>
<p><font size="2">See seade ei m&otilde;juta kursusi, kus on kasutusel &#8220;sotsiaalne&#8221;
  v&otilde;i &#8220;teemade&#8221; formaat. </font></p>
<p><font size="2">Sellegipoolest m&otilde;jutab see seade logide kuvamist, mis kasutavad seda
  kuup&auml;eva varaseima v&otilde;imaliku lubatud kuvamise kuup&auml;evana.</font></p>
<p><font size="2">&Uuml;ldiselt kui kursusel puudub tegelik alguskuup&auml;ev, siis on m&otilde;istlik
  seada selleks just see kuup&auml;ev, mistahes formaati sa ka ei kasutaks.<br />
</font></p>
</font>';
$string['startingfrom'] = 'Alates';
$string['startsignup'] = 'Loo uus konto';
$string['state'] = 'Riik/maakond';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Statistilised graafikud';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Sisenemised';
$string['statsmodedetailed'] = 'Detailne (kasutaja) vaade';
$string['statsmodegeneral'] = 'Üldine vaade';
$string['statsnodata'] = 'Siin pole kättesaadavaid andmeid kursuste ja ajaperioodi kombinatsiooni kohta.';
$string['statsoff'] = 'Statistika pole hetkel lubatud';
$string['statsreads'] = 'Vaatamised';
$string['statsreport1'] = 'Sisenemised';
$string['statsreport10'] = 'Kasutaja tegevus';
$string['statsreport11'] = 'Kõige aktiivsemad kursused';
$string['statsreport12'] = 'Kõige aktiivsemad kursused (kaalutud)';
$string['statsreport13'] = 'Suurima osalusega kursused (registreerunutega)';
$string['statsreport14'] = 'Suurima osalusega kursused (vaatamisi/postitusi)';
$string['statsreport2'] = 'Vaatamised (kõik rollid)';
$string['statsreport3'] = 'Postitamised (kõik rollid)';
$string['statsreport4'] = 'Kõik tegevused (kõik rollid)';
$string['statsreport5'] = 'Kõik tegevused (vaatamised ja postitused)';
$string['statsreport7'] = 'Kasutaja tegevused (vaatamised ja postitused)';
$string['statsreport8'] = 'Kõik kasutaja tegevused';
$string['statsreport9'] = 'Sisenemised (õpikeskkonna kursus)';
$string['statsreportactivity'] = 'Kõik tegevused (kõik rollid)';
$string['statsreportactivitybyrole'] = 'Kõik tegevused (vaatamised ja postitused)';
$string['statsreportforuser'] = 'kellele';
$string['statsreportlogins'] = 'Sisenemised';
$string['statsreportreads'] = 'Vaatamised (kõik rollid)';
$string['statsreporttype'] = 'Ülevaate liik';
$string['statsreportwrites'] = 'Postitused (kõik rollid)';
$string['statsstudentactivity'] = 'Õppija tegevused';
$string['statsstudentreads'] = 'Õppija vaatamised';
$string['statsstudentwrites'] = 'Õppija postitused';
$string['statsteacheractivity'] = 'Õpetaja tegevus';
$string['statsteacherreads'] = 'Õpetaja vaatamised';
$string['statsteacherwrites'] = 'Õpetaja postitused';
$string['statstimeperiod'] = 'Periood - viimane:';
$string['statsuniquelogins'] = 'Erilised sisenemised';
$string['statsuseractivity'] = 'Kõik tegevused';
$string['statsuserlogins'] = 'Sisenemised';
$string['statsuserreads'] = 'Vaatamised';
$string['statsuserwrites'] = 'Postitused';
$string['statswrites'] = 'Postitused';
$string['status'] = 'Staatus';
$string['stringsnotset'] = 'Järgnevad sõned pole defineeritud asukohas {$a}';
$string['studentnotallowed'] = 'Kahjuks ei tohi Sa sellele kursusele siseneda kui \'{$a}\'';
$string['students'] = 'Õppijad';
$string['studentsandteachers'] = 'Õppijad ja õpetajad';
$string['subcategories'] = 'Alamkategooriad';
$string['subcategory'] = 'Alamkategooria';
$string['subcategoryof'] = '{$a} alamkategooria';
$string['submit'] = 'Esita';
$string['success'] = 'Edu';
$string['summary'] = 'Kokkuvõte';
$string['summary_help'] = 'Lühikokkuvõtte mõte on lühitekst valmistab õpilased ette tegevusteks vastavas teemas või nädalas. Tekst kuvatakse kursusele lehel, sektsiooni nime all.';
$string['summaryof'] = '{$a} kokkuvõte';
$string['supplyinfo'] = 'Detailsemalt';
$string['suspended'] = 'Peatatud';
$string['suspendedusers'] = 'Peatatud kasutajad';
$string['switchdevicedefault'] = 'Lülita ümber standardkujundusele';
$string['switchdevicerecommended'] = 'Lülitu ümber soovitud kujundusele sinu seadme puhul';
$string['switchrolereturn'] = 'Tagasi minu tavarollile';
$string['switchroleto'] = 'Lülitu rollile...';
$string['tag'] = 'Märksõna';
$string['tagalready'] = 'See märksõna juba on olemas';
$string['tagmanagement'] = 'Lisa/kustuta märksõnad...';
$string['tags'] = 'Märksõnad';
$string['targetrole'] = 'Sihtroll';
$string['teacheronly'] = 'ainult  {$a} jaoks';
$string['teacherroles'] = '{$a} rollid';
$string['teachers'] = 'Õpetajad';
$string['textediting'] = 'Tekstiredaktor';
$string['texteditor'] = 'Kasuta standardseid veebivorme';
$string['textformat'] = 'Lihtteksti formaat';
$string['thanks'] = 'Tänan';
$string['theme'] = 'Kujundus';
$string['themes'] = 'Kujundused';
$string['themesaved'] = 'Uus kujundus salvestatud';
$string['therearecourses'] = 'Kokku on {$a} kursust';
$string['thereareno'] = 'Siin ei ole {$a} sellel kursusel';
$string['thiscategory'] = 'See kategooria';
$string['thiscategorycontains'] = 'See kategooria sisaldab';
$string['time'] = 'Aeg';
$string['timezone'] = 'Ajavöönd';
$string['to'] = 'Kuni';
$string['tocreatenewaccount'] = 'Jäta vahele, et luua uus konto';
$string['today'] = 'Täna';
$string['todaylogs'] = 'Tänased sisenemised';
$string['toeveryone'] = 'kõigile';
$string['toomanybounces'] = 'Sellelt e-posti aadressilt on tulnud liiga palju tagasisaatmisi. Jätkamiseks <b>pead</b> e-posti aadressi muutma.';
$string['toomanytoshow'] = 'Kasutajaid on näitamiseks liiga palju';
$string['toomanyusersmatchsearch'] = 'Liiga palju kasutajaid ({$a->count}) sobitus otsinguga \'{$a->search}';
$string['toomanyuserstoshow'] = 'Kuvamiseks liiga palju kasutajaid ({$a})';
$string['toonly'] = 'ainult  {$a} jaoks';
$string['top'] = 'Tipp';
$string['topic'] = 'Teema';
$string['topichide'] = 'Peida see teema {$a} eest';
$string['topicoutline'] = 'Kursuse/teemade ülevaade';
$string['topicshow'] = 'Näita teemat {$a} jaoks';
$string['toplevelcategory'] = 'Tipptaseme kategooria';
$string['total'] = 'Kokku';
$string['trackforums'] = 'Foorumi jälgimine';
$string['trackforumsno'] = 'Ei: ära tõsta uusi postitusi esile';
$string['trackforumsyes'] = 'Jah: tõsta uued postitused esile';
$string['trysearching'] = 'Proovi hoopis otsida';
$string['turneditingoff'] = 'Keela muutmine';
$string['turneditingon'] = 'Luba muutmine';
$string['undecided'] = 'Otsustamata';
$string['unfinished'] = 'Lõpetamata';
$string['unknowncategory'] = 'Tundmatu kategooria';
$string['unknownerror'] = 'Tundmatu viga';
$string['unlimited'] = 'Lõpmatu';
$string['unpacking'] = 'Pakin lahti {$a}';
$string['unsafepassword'] = 'Ebaturvaline salasõna - proovi mõnda muud';
$string['untilcomplete'] = 'Kuni valmis';
$string['unusedaccounts'] = 'Kasutajakontod, mida pole kasutatud rohkem kui {$a} päeva, kustutatakse automaatselt nimekirjast';
$string['unzip'] = 'Paki lahti';
$string['unzippingbackup'] = 'Paki lahti varukoopia';
$string['up'] = 'Üles';
$string['update'] = 'Uuenda';
$string['updated'] = '{$a} uuendatud';
$string['updatemymoodleoff'] = 'Lõpeta lehe uuendamine';
$string['updatemymoodleon'] = 'Uuenda lehte';
$string['updatemyprofile'] = 'Uuenda kasutaja andmeid';
$string['updatesevery'] = 'Uuendus iga {$a} sekundi tagant';
$string['updatethis'] = 'Uuenda {$a}';
$string['updatethiscourse'] = 'Uuenda see kursus';
$string['updatinga'] = 'Uuendan: {$a}';
$string['updatingain'] = 'Muudan objekti: {$a->what} - asukohas {$a->in}';
$string['upload'] = 'Lae üles';
$string['uploadafile'] = 'Lae fail üles';
$string['uploadcantwrite'] = 'Ebaõnnetus faili kirjutamine kettale';
$string['uploadedfile'] = 'Faili üleslaadimine õnnestus';
$string['uploadedfileto'] = 'Üles laetud {$a->file} kausta {$a->directory}';
$string['uploadedfiletoobig'] = 'Vabandust, fail on liiga suur (faili suuruse limiit {$a} baiti)';
$string['uploadextension'] = 'Faili üleslaadimine katkestati PHP laienduse poolt';
$string['uploadfailednotrecovering'] = 'Faili üles laadimine ebaõnnestus, kuna tekkis probleem failiga {$a->name}.<br /> Siin on probleemide logi:<br />{$a->problem}<br />Ei taastata.';
$string['uploadfilelog'] = 'Lae üles logi  fail {$a} jaoks';
$string['uploadformlimit'] = 'Üles laetud fail {$a} ületas sellele vormile seatud maksimaalse suuruse limiidi';
$string['uploadlabel'] = 'Pealkiri:';
$string['uploadlimitwithsize'] = '{$a->contextname} üleslaadimise limiit on ({$a->displaysize})';
$string['uploadnewfile'] = 'Lae üles uus fail';
$string['uploadnofilefound'] = 'Ühtegi faili ei leitud - kas olete veendunud, et ikka valisid mõne üleslaadimiseks?';
$string['uploadnotallowed'] = 'Üleslaadimised on keelatud';
$string['uploadnotempdir'] = 'Puudu ajutine kataloog';
$string['uploadoldfilesdeleted'] = 'Vana(d) fail(id) üleslaadimise piirkonnas on kustutatud';
$string['uploadpartialfile'] = 'Fail laeti üles ainult osaliselt';
$string['uploadproblem'] = 'Faili \'{$a}\' üleslaadimisel tekkis tundmatu probleem (võibolla oli fail liiga suur?)';
$string['uploadrenamedchars'] = 'Fail nimetati ümber {$a->oldname} {$a->newname} -ks vigaste sümbolite pärast';
$string['uploadrenamedcollision'] = 'Fail nimetati ümber {$a->oldname} {$a->newname} -ks, kuna tekkis failinime konflikt.';
$string['uploadserverlimit'] = 'Üleslaetud fail ületas serveri poolt seatud maksimumsuuruse limiidi';
$string['uploadthisfile'] = 'Lae fail üles';
$string['url'] = 'URL';
$string['used'] = 'Kasutatud';
$string['usedinnplaces'] = 'Kasutatud {$a} kohas';
$string['usemessageform'] = 'või kasuta vormi allpool, et saata teade valitud õppijatele';
$string['user'] = 'Kasutaja';
$string['userconfirmed'] = 'Kinnitatud {$a}';
$string['usercurrentsettings'] = 'Profiili seaded';
$string['userdata'] = 'Kasutaja andmed';
$string['userdeleted'] = 'See kasutajakonto on kustutatud';
$string['userdescription'] = 'Kirjeldus';
$string['userdescription_help'] = 'See kast võimaldab sul sisestada teksti enda kohta, mis on siis kuvatav sinu profiililehel teistele.';
$string['userdetails'] = 'Kasutaja detailid';
$string['userfiles'] = 'Kasutaja failid';
$string['userlist'] = 'Kasutajate nimekiri';
$string['username'] = 'Kasutajanimi';
$string['usernameemailmatch'] = 'Kasutajanimi ja e-mailiaadress ei ole seotud sama kasutajaga';
$string['usernameexists'] = 'See kasutajanimi on juba olemas, vali mõni teine';
$string['usernamelowercase'] = 'Ainult väiketähed on lubatud';
$string['usernamenotfound'] = 'Seda kasutajanime ei leitud andmebaasist';
$string['usernameoremail'] = 'Sisesta kas kasutajanimi või e-mailiaadress';
$string['usernotconfirmed'] = 'Ei õnnestunud kinnitada {$a}';
$string['userpic'] = 'Kasutaja pilt';
$string['users'] = 'Kasutajad';
$string['userselectorautoselectunique'] = 'Kui ainult üks kasutaja leidus, siis vali ta automaatselt';
$string['userselectorpreserveselected'] = 'Hoia valitud kasutajaid, isegi kui nad enam ei ole enam otsingu tulemustes';
$string['userselectorsearchanywhere'] = 'Otsitakse otsingu teksti ka kasuta nime keskel';
$string['usersnew'] = 'Uued kasutajad';
$string['usersnoaccesssince'] = 'Mitteaktiivsed rohkem kui';
$string['userswithfiles'] = 'Kasutajate failid';
$string['useruploadtype'] = 'Kasutaja üles laetu tüüp: {$a}';
$string['userviewingsettings'] = '{$a} profiiliseaded';
$string['userzones'] = 'Kasutajatsoonid';
$string['usetheme'] = 'Kasuta malli';
$string['usingexistingcourse'] = 'Olemasoleva kursuse kasutamine';
$string['valuealreadyused'] = 'See väärtus on juba kasutatud';
$string['version'] = 'Versioon';
$string['view'] = 'Vaade';
$string['viewallcourses'] = 'Vaata kõiki kursusi';
$string['viewallcoursescategories'] = 'Vaata kõiki kursusi ja kategooriaid';
$string['viewallsubcategories'] = 'Vaata kõiki alamkategooriaid';
$string['viewfileinpopup'] = 'Vaata faili hüpikaknas';
$string['viewing'] = 'Vaade:';
$string['viewmore'] = 'Vaata rohkem';
$string['viewprofile'] = 'Vaata profiili';
$string['views'] = 'Vaatamised';
$string['viewsolution'] = 'vaata lahendust';
$string['virusfound'] = 'Tähelepanu administraator! Clam AV leidis viiruse kasutaja {$a->user} poolt kursusele {$a->course} laetud failis. Siin on Clam AV väljund:';
$string['virusfoundlater'] = 'Failist nimega {$a->filename} , mille sa laadisid üles kuupäeval {$a->date} kurusele {$a->course}, leiti viirus. Siin on kokkuvõte sellest, mis sinu failiga tehti:
{$a->action}
Kui fail sisaldas esitatavat tööd, pead selle uuesti esitama, et sinu juhendaja seda näeks.';
$string['virusfoundlateradmin'] = 'Tähelepanu administraator! Fail nimega
{$a->filename}, mille kasutaja {$a->user} laadis üles kuupäeval {$a->date} kursusele {$a->course}, sisaldab viirust. Siin on kokkuvõte sellest, mis failiga tehti:
{$a->action}
Kasutajat on samuti teavitatud.
Siin on kokkuvõte mis failiga juhtus:
{$a->action}';
$string['virusfoundlateradminnolog'] = 'Tähelepanu administraator! Üles laetud fail nimega {$a->filename} sisaldab viirust. Moodle ei suutnud tuvastada, milline kasutaja selle faili üles laadis.
Siin on kokkuvõte sellest, mis failiga tehti:
{$a->action}';
$string['virusfoundsubject'] = '{$a}: Viirus leitud!';
$string['virusfounduser'] = 'Sinu poolt üles laetud faili {$a->filename} skaneeriti viirusetõrje poolt ja avastati, et see on viirusega nakatunud! Faili üles laadimine EBAÕNNESTUS.';
$string['virusplaceholder'] = 'Üleslaetud failist leiti viirus ja fail on ümber tõstetud või kustutatud ning kasutajat on teavitatud.';
$string['visible'] = 'Kas õppijatele nähtav?';
$string['visible_help'] = 'See seade määrab ära kas antud kursust näidatakse kursuste nimekirjas. Peale õppejõu ja administraatori rollis olevatele kasutajatele, pole teistel lubatud antud kursusele siseneda.';
$string['visibletostudents'] = 'Nähtav {$a} jaoks';
$string['warning'] = 'Hoiatus';
$string['webpage'] = 'Veebileht';
$string['week'] = 'Nädal';
$string['weekhide'] = 'Peida see nädal {$a} eest';
$string['weeklyoutline'] = 'Nädalavaade';
$string['weeks'] = 'nädalad';
$string['weekshow'] = 'Näita seda nädalat {$a} jaoks';
$string['welcometocourse'] = 'Tere tulemast kursusele {$a}';
$string['welcometocoursetext'] = 'Tere tulemast kursusele {$a->coursename}!

Sellele lingile klikkides saad täiendada oma kasutajaandmeid, et teised kursusel osalejad võiksid sind rohkem tundma õppida:

   {$a->profileurl}';
$string['whatforlink'] = 'Mida sa soovid selle lingiga teha?';
$string['whatforpage'] = 'Mida sa soovid selle lingiga teha?';
$string['whattocallzip'] = 'Mis pakitud faili nimeks saab?';
$string['whattodo'] = 'Mida teha';
$string['windowclosing'] = 'See aken peaks sulguma automaatselt. Kui mitte, siis palun sulge nüüd.';
$string['withchosenfiles'] = 'Valitud failid';
$string['withdisablednote'] = '{$a} (keelatud)';
$string['withoutuserdata'] = 'ilma kasutaja andmeteta';
$string['withselectedusers'] = 'Märgitud kasutajatega...';
$string['withselectedusers_help'] = '* Saada sõnum - saatmaks sõnumit ühele või mitmele osavõtjale
* Lisa uus märkus - lisamaks märkust valitud osavõtjale
* Lisa üldine märku - lisamaks sama märkust rohkem kui ühele osavõtjale
* Laiendatud registreerumine (individuaalne) - laiendamaks valitud õpilaste ligipääsu kursusele, isegi kui registreerumise aeg on seatud
* Laiendatud registreerumine (üldine) - laiendamaks rohkem kui ühe õpilase ligipääsu kursusele samal määral';
$string['withuserdata'] = 'koos kasutaja andmetega';
$string['wordforstudent'] = 'Kuidas nimetad õppijat?';
$string['wordforstudenteg'] = 'näiteks õppija, osaleja jne';
$string['wordforstudents'] = 'Kuidas nimetad õppijaid?';
$string['wordforstudentseg'] = 'näiteks õppijad, osalejad jne';
$string['wordforteacher'] = 'Kuidas nimetad õpetajat?';
$string['wordforteachereg'] = 'näiteks õpetaja, tuutor, juhendaja jne';
$string['wordforteachers'] = 'Kuidas nimetad õpetajaid?';
$string['wordforteacherseg'] = 'näiteks õpetajad, tuutorid, juhendajad jne';
$string['writingcategoriesandquestions'] = 'Kategooriate ja küsimuste kirjutamine';
$string['writingcoursedata'] = 'Kursuse info kirjutamine';
$string['writingeventsinfo'] = 'Sündmuste info kirjutamine';
$string['writinggeneralinfo'] = 'Üldinfo kirjutamine';
$string['writinggradebookinfo'] = 'Hinnetelehe info kirjutamine';
$string['writinggroupingsinfo'] = 'Rühmitamise info kirjutamine';
$string['writinggroupsinfo'] = 'Rühmade info kirjutamine';
$string['writingheader'] = 'Päise kirjutamine';
$string['writingloginfo'] = 'Logide info kirjutamine';
$string['writingmessagesinfo'] = 'Sõnumite info kirjutamine';
$string['writingmoduleinfo'] = 'Moodulite info kirjutamine';
$string['writingscalesinfo'] = 'Skaalade info kirjutamine';
$string['writinguserinfo'] = 'Kasutajate info kirjutamine';
$string['wrongpassword'] = 'Vale salasõna selle kasutajanime jaoks';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'aasta';
$string['years'] = 'aastad';
$string['yes'] = 'jah';
$string['youareabouttocreatezip'] = 'Sa lood pakitud arhiivi järgnevatest failidest';
$string['youaregoingtorestorefrom'] = 'Sa  taastad:';
$string['youneedtoenrol'] = 'Selle tegevuseks pead olema registreeritud sellele kursusele.';
$string['yourlastlogin'] = 'Sinu viimane sisenemine toimus';
$string['yourself'] = 'Sina ise';
$string['yourteacher'] = 'Sinu {$a}';
$string['yourwordforx'] = 'Sinu väljend \'{$a}\' kohta';
$string['zippingbackup'] = 'Pakin kokku varukoopia';
