<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Valitud administreerimiskataloog on vale';
$string['admindirname'] = 'Administreerimiskataloog';
$string['admindirsetting'] = 'Mõned vähesed veebihostid kasutavad spetsiaalset URL-i, et anda ligipääs juhtpaneelile. Kahjuks läheb see konflikti Moodle administreerimislehe standardse asukohaga. Sa saad seda viga parandada, kui nimetad oma administreerimiskataloogi ümber. Näiteks: <br /> <br /><b>moodleadmin</b><br /> <br /> See teeb administreerimislingid Moodle\'is korda.';
$string['admindirsettinghead'] = 'Kataloogi admin seadistamine ...';
$string['admindirsettingsub'] = 'Mõned vähesed veebihostid kasutavad spetsiaalset URL-i, et anda ligipääs juhtpaneelile. Kahjuks läheb see konflikti Moodle administreerimislehe standardse asukohaga. Sa saad seda viga parandada, kui nimetad oma administreerimiskataloogi ümber. Näiteks: <br /> <br /><b>moodleadmin</b><br /> <br /> See teeb administreerimislingid Moodle\'is korda.';
$string['availablelangs'] = 'Saadaval keelte nimekiri';
$string['caution'] = 'Hoiatus';
$string['chooselanguage'] = 'Vali keel';
$string['chooselanguagehead'] = 'Keele valik';
$string['chooselanguagesub'] = 'Palun vali keel, mida kasutatakse AINULT installeerimise käigus. Hiljem saab valida õpikeskkonna ja kasutajate keelt.';
$string['cliadminpassword'] = 'Uus admin kasutaja salasõna';
$string['cliadminusername'] = 'Administraatori konto kasutajanimi';
$string['clialreadyinstalled'] = 'Fail config.php juba eksisteerib, palun kasuta admin/cli/upgrade.php kui soovid uuendada oma saiti.';
$string['cliinstallfinished'] = 'Installeerimine lõpetati edukalt.';
$string['cliinstallheader'] = 'Moodle {$a} käsurea põhine installeerimise programm';
$string['climustagreelicense'] = 'Mitte interaktiivses laadis sa pead nõustuma litsentsiga määrates --agree-license valiku';
$string['clitablesexist'] = 'Andmebaasi tabelid juba eksisteerivad, käsureapõhine installeerimine ei saa jätkuda';
$string['compatibilitysettings'] = 'Kontrollin teie PHP sätteid ...';
$string['compatibilitysettingshead'] = 'PHP seadete kontrollimine...';
$string['compatibilitysettingssub'] = 'Sinu server peab läbima kõik need testid, et Moodle jookseks korralikult';
$string['configfilenotwritten'] = 'Installeerimisskript ei suutnud automaatselt tekitada config.php faili, mis sisaldaks sinu valitud seadistusi. Põhjus võib olla selles, et sinu Moodle kataloog ei ole kirjutatav. Sa võid käsitsi kopeerida järgneva koodi config.php nimelisse faili, mis asub Moodle juurkataloogis.';
$string['configfilewritten'] = 'config.php on edukalt loodud';
$string['configurationcomplete'] = 'Seadistamine lõpetatud';
$string['configurationcompletehead'] = 'Konfigureerimine lõpetatud';
$string['configurationcompletesub'] = 'Moodle tegi katse salvestada Sinu seadistuse Moodle juurkataloogis asuvasse faili.';
$string['database'] = 'Andmebaas';
$string['databasehead'] = 'Andmebaasi seaded';
$string['databasehost'] = 'Andmebaasi host';
$string['databasename'] = 'Andmebaasi nimi';
$string['databasepass'] = 'Andmebaasi salasõna';
$string['databasesocket'] = 'UNIX\'i sokkel';
$string['databasetypehead'] = 'Vali andmebaasi draiver';
$string['databasetypesub'] = 'Moodle toetab mitut andmebaasiserveri tüüpi. Palun kontakteeru serveri administraatoriga, kui ei tea millist valida';
$string['databaseuser'] = 'Andmebaasi kasutaja';
$string['dataroot'] = 'Andmete kataloog';
$string['datarooterror'] = 'Sinu määratud andmete kataloogi ei suudetud leida ega luua. Paranda tee või loo ise käsitsi see kataloog.';
$string['datarootpermission'] = 'Andmete kataloogide õigus';
$string['datarootpublicerror'] = 'Sinu määratud andmete kataloog on otse ligipääsetav veebi kaudu. Sa pead valima mingi muu kataloogi.';
$string['dbconnectionerror'] = 'Me ei suutnud sinu määratud andmebaasi ühendada. Palun kontrolli oma andmebaasi seadistust.';
$string['dbcreationerror'] = 'Andmebaasi loomise viga. Ei suudetud luua andmebaasi nime olemasolevate seadistustega.';
$string['dbhost'] = 'Hosti server';
$string['dbpass'] = 'Salasõna';
$string['dbprefix'] = 'Tabeli eesliide';
$string['dbtype'] = 'Tüüp';
$string['directorysettings'] = '<p>Palun kinnita Moodle installerimise asukoht.</p>
<p><b>Veebiaadress:</b>
Määra täispikk veebiaadress, kust saab Moodle\'ile juurdepääsu.
Kui sinu veebileht on juurdepääsetav mitme URL\'i kaudu, siis kasuta seda, mis on sinu õppijate jaoks kõige kergem meeles pidada. Ära kasuta kurakriipsu. </p>
<p><b>Moodle kataloog:</b>
Määra selle installatsiooni kataloogi täistee.
Tee kindlaks, et suured/väiketähed oleksid õiged.</p>
<p><b>Andmete kataloog:</b>
Sul on vaja kohta, kuhu Moodle salvestab üles laetud failid. See kataloog peaks olema loetav JA KIRJUTATAV veebiserveri kasutaja poolt (tavaliselt \'nobody\' või \'apache\'), kuid ei tohiks olla otse veebi kaudu ligipääsetav.
</p>';
$string['directorysettingshead'] = 'Palun kinnita Moodle installatsiooni asukohta';
$string['dirroot'] = 'Moodle kataloog';
$string['dirrooterror'] = 'Moodle kataloogi seadistus näib olevat vigane -  me ei suuda sealt leida Moodle installatsiooni. Allpool olev väärtus on nullitud.';
$string['download'] = 'Lae alla';
$string['downloadlanguagebutton'] = 'Tõmba alla &quot;{$a}&quot; keelepakett';
$string['downloadlanguagehead'] = 'Tõmba alla keelepakett';
$string['downloadlanguagesub'] = 'Sul on praegu võimalus tõmmata alla keelepakk ja jätkata installeerimist vastavas keeles.<br /><br />Kui Sa oled mitte võimeline alla tõmbama keelepakki, siis installeerimine jätkub inglise keeles. (Niipea, kui installeerimine on lõppenud, on Sul võimalus alla tõmmata täiendavaid keelepakke.)';
$string['doyouagree'] = 'Kas sa nõustud? (jah/ei):';
$string['environmenthead'] = 'Keskkonna kontrollimine...';
$string['environmentsub'] = 'Me kontrollime, kas mitmesugused süsteemi komponendid vastavad nõudmistele.';
$string['environmentsub2'] = 'Iga Moodle väljalaskel on oma minimaalne PHP versiooni nõue ja kohustuslikud PHP laiendused.
Täielik keskkonna kontroll tehakse enne iga installeerimist ja uuendamist. Palun võta ühendust serveri administraatoriga, kui sa ei sa kuidas installeerida või võimaldada PHP laiendusi.';
$string['errorsinenvironment'] = 'Keskkonna sobivuse kontroll ebaõnnestus!';
$string['fail'] = 'Fail';
$string['fileuploads'] = 'Failide üleslaadimine';
$string['fileuploadserror'] = 'See peaks olema sisse lülitatud';
$string['fileuploadshelp'] = '<p>Failide üleslaadimine näib sinu serveris olevat välja lülitatud.</p>
<p>Moodle\'it saab ikka installeerida, kui selle võimaluseta ei saa sa kursuse faile või uute kasutajate andmeid üles laadida</p>
<p>Failide üleslaadimise sisse lülitamiseks pead sa (või sinusüsteemiadministraator) muutma main php.ini faili oma süsteemis ja seadma <b>file_uploads</b> väärtuseks \'1\'.</p>';
$string['inputdatadirectory'] = 'Andmete kataloog:';
$string['inputwebadress'] = 'Veebiaadress:';
$string['inputwebdirectory'] = 'Moodle kataloog:';
$string['installation'] = 'Installeerimine';
$string['langdownloaderror'] = 'Kahjuks keelt "{$a}" ei paigaldatud. Paigaldamine jätkub inglise keeles.';
$string['langdownloadok'] = 'Keel "{$a}" paigaldati edukalt. Paigaldamisprotsess jätkub selles keeles.';
$string['magicquotesruntime'] = 'Magic Quotes talitlusaeg';
$string['magicquotesruntimeerror'] = 'See peaks olema välja lülitatud';
$string['magicquotesruntimehelp'] = '<p>Magic quotes talitlusaeg peaks olema välja lülitatud, et Moodle saaks korralikult funktsioneerida.</p>
<p>Tavalielt on see vaikimisi välja lülitatud. Vaata <b>magic_quotes_runtime</b> seadistust  sinu php.ini failis.</p>
<p>Kui sul ei ole ligipääsu oma php.ini failile, siis peaksid lisama järgmise koodi .htaccess nimelisse faili, mis asub sinu Moodle kataloogis:
<blockquote>php_value magic_quotes_runtime Off</blockquote>
</p>';
$string['memorylimit'] = 'Mälu limiit';
$string['memorylimiterror'] = 'PHP mälu limiit on seatud päris madalale...sul võib hiljem sellega seoses probleeme tekkida.';
$string['memorylimithelp'] = '<p>PHP mälu limiit sinu serveri jaoks on hetkel {$a}.</p>
<p>See võib hiljem tekitada Moodle\'il mäluprobleeme, eriti kui sul on palju mooduleid ja/või kasutajaid.
</p>
<p>Me soovitame, et sa konfigureeriksid PHP kõrgema limiidi peale, näiteks 16M. Selle tostamiseks on mitu viisi:</p>
<ol>
<li>Kui võimalik, siis kompileeri PHP uuesti parameetriga <i>--enable-memory-limit</i>.
See lubab Moodle\'il ise mälu limiiti määrata.</li>
<li>Kui sul on juurdepääs oma php.ini failile, siis saad muuta seal <b>memory_limit</b> väärtuseks midagi 16M lähedast. Kui sul ei ole juurdepääsu, siis võiksid paluda administraatoril seda teha.</li>
<li>Mõnedes PHP serverites saad luua Moodle kataloogi .htaccess faili, mis sisaldab seda rida:<p><blockquote>php_value memory_limit 16M</blockquote></p>
<p>Kuigi mõnedes serverites tõkestab see <b>kõigi</b> PHP lehekülgede tööd (sa näed veateateid, kui vaatad lehti), nii et pead eemaldama .htaccess faili.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP laiendus MSSQL ei ole korralikult seadistatud, mistõttu ei saa ühenduda SQL*Server\'iga. Palun kontrolli oma php.ini faili või kompileeri PHP uuesti.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP ei ole korralikult seadistatud  MySQLi laiendusega, nii et too saaks suhelda MySQL\'ga. Palun kontrolli oma php.ini faili või rekompileeri PHP. MySQLi laiendus ei ole saadaval PHP 4 jaoks.';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Nüüd on vaja seadistada andmebaas, kuhu Moodle andmed salvestatakse. See andmebaas peab olema juba loodud ja kasutajanimi ning salasõna sellele ligipääsuks. Tabeli prefiks on kohustuslik.';
$string['nativemysqli'] = 'Improved MySQL (native/mysqli)';
$string['nativemysqlihelp'] = 'Nüüd pead seadistama andmebaasi, kus Moodle hakkab hoidma põhilist osa andmetest.
Andmebaas luuakse, kui andmebaasi kasutajal on vajalikud õigused. Kasutajanimi ja salasõna peavad eelnevalt olemas olema. Tabeli prefiks on valikuline.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Nüüd pead seadistama andmebaasi, kus Moodle hakkab hoidma põhilist osa andmetest.
Andmebaas luuakse, kui andmebaasi kasutajal on vajalikud õigused. Kasutajanimi ja salasõna peavad eelnevalt olemas olema. Tabeli prefiks on valikuline.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Nüüd pead seadistama andmebaasi, kus Moodle hakkab hoidma põhilist osa andmetest.
Andmebaas luuakse, kui andmebaasi kasutajal on vajalikud õigused. Kasutajanimi ja salasõna peavad eelnevalt olemas olema. Tabeli prefiks on valikuline.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Nüüd pead seadistama andmebaasi, kus Moodle hakkab hoidma põhilist osa andmetest.
Andmebaas luuakse, kui andmebaasi kasutajal on vajalikud õigused. Kasutajanimi ja salasõna peavad eelnevalt olemas olema. Tabeli prefiks on valikuline.';
$string['ociextensionisnotpresentinphp'] = 'PHP laiendus OCI8 ei ole korralikult seadistatud, mistõttu ei saa ühenduda Oracle\'ga. Palun kontrolli oma php.ini faili või kompileeri PHP uuesti.';
$string['pass'] = 'Korras';
$string['paths'] = 'Rajad';
$string['pathserrcreatedataroot'] = 'Andmete kataloogi ({$a->dataroot}) ei saa installeerija luua.';
$string['pathshead'] = 'Radade kinnitused';
$string['pathsrodataroot'] = 'Andmete juurkataloog (Dataroot) ei ole kirjutatav.';
$string['pathsroparentdataroot'] = 'Ülemkataloog ({$a->parent}) ei ole kirjutatav. Installeerija ei saanud andmete kataloogi ({$a->dataroot}) luua.';
$string['pathssubadmindir'] = 'Väga vähesed veebihostid kasutavad /admin spetsiaalse URL-na, et pääseda ligi kontrollpaneelile või millegile sarnasele. Kahjuks on see konfliktis Moodle administreerimislehtedega. Sa saad olukorda parandada, kui nimetad kataloogi admin ümber oma üaigalduses ning kirjutad selle uue nime siia. Näiteks: <em>moodleadmin</em>. See parandab administreerimisliidese lingid Moodle\'s.';
$string['pathssubdataroot'] = 'Sa pead näitama koha, kuhu Moodle saaks salvestada üles laetud failid. See kataloog peab olema loetav JA KIRJUTATAV veebiserveri kasutaja poolt (tavaliselt \'nobody\' or \'apache\'), samas see kataloog ei tohiks olla ligipääsetav otse veebi kaudu. Kui kataloogi ei eksisteeri, siis installeerija püüab selle ise luua.';
$string['pathssubdirroot'] = 'Täistee Moodle paigalduse kataloogile.';
$string['pathssubwwwroot'] = 'Täielik veebiaadress, kust kaudu Moodle\'le ligi pääsetakse.
Ei ole võimalik kasutada mitmest kohast kohast ligipääsu.
Kui Su sait omab mitut avalikku aadress, siis pead seadistama ümbersuunamised kõikidelt teistest aadressidelt.
Kui Su sait on ligipääsetav nii Internetist kui intranetist (sisevõrgust), siis kasuta Interneti ehk avalikku aadressi ja seadista DNS sellisellt, et intraneti kasutajad kasutaksid ka avalikku aadressi.
Kui aadress pole korrektne, siis palun muuda URL oma brauseris, et taasalustada installeerimist erineva väärtusega.';
$string['pathsunsecuredataroot'] = 'Andmete juurkataloogi asukoht pole turvamine';
$string['pathswrongadmindir'] = 'Admin kataloogi ei eksisteeri';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP laiendus PGSQL ei ole korralikult seadistatud, mistõttu ei saa ühenduda PostgreSQL\'iga. Palun kontrolli oma php.ini faili või kompileeri PHP uuesti.';
$string['phpextension'] = '{$a} PHP laiendus';
$string['phpversion'] = 'PHP versioon';
$string['phpversionhelp'] = '<p>Moodle vajab vähemalt PHP versiooni 4.1.0</p>
<p>Sinu jooksev versioon on {$a}</p>
<p>Sa pead oma PHP-d uuendama või kolima hosti, kus on uuem PHP versioon!</p>';
$string['releasenoteslink'] = 'Rohkem informatsiooni selle versiooni kohta palun vaata väljalaste märkustest {$a}';
$string['safemode'] = 'Ohutu režiim';
$string['safemodeerror'] = 'Moodle\'il võib ohutus režiimis komplikatsioone tekkida';
$string['safemodehelp'] = '<p>Moodle võib tekkida mitmesuguseid probleeme, kui ohutu režiim on sisse lülitatud, näiteks ei luba ta tõenäoliselt luua uusi faile.</p>
<p>Ohutu režiim on tavaliselt sisse lülitatud ainult paranoilistel avalikel veebihostidel, seega pead leidma oma Moodle õpikeskkonnale uue serveriteenust pakkuva firma. </p>
<p>Sa võid proovida installeerimist jätkata, kui soovid, aga arvatavasti tekib sul ka hiljem probleeme.</p>';
$string['sessionautostart'] = 'Sessioonide automaatne algatamine';
$string['sessionautostarterror'] = 'See peaks olema välja lülitatud';
$string['sessionautostarthelp'] = '<p>Moodle vajab sessiooni tuge ja ei tööta ilma selleta.</p>
<p>Sessioone saab sisse lülitada php.ini failist, otsi sealt session.auto_start parameetrit.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP-s ei ole õieti seadistatud SQLite laiendus. Palun kontrolli oma php.ini faili või kompilleeri uuesti PHP.';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Sa näed seda lehte, sest oled edukalt installeerinud ja käivitanud <strong>{$a->packname} {$a->packversion}</strong> paketi Sinu arvutis. Õnnitleme!';
$string['welcomep30'] = 'See <strong>{$a->installername}</strong> väljalase rakendusi loomaks keskkonda, millel <strong>Moodle</strong> hakkab will operate, namely:';
$string['welcomep40'] = 'Pakett sisaldab ka <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Kasutamaks kõiki selle rakendusi selles paketis on kaetud nende vastavad litsentsid. Täielik <strong>{$a->installername}</strong> pakett on <a href="http://www.opensource.org/docs/definition_plain.html">avatud lähtekoodil</a> ja jaotatud <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> litsentsi alusel.';
$string['welcomep60'] = 'Järgnevatel lehtedel juhitakse sind läbi mõnede lihtsate sammude seadistamaks ja seadmaks üles <strong>Moodle</strong> oma arvutis. Sa võid nõustuda vaikeväärtustega või fakultatiivselt täiendada vastavalt oma vajadustele.';
$string['welcomep70'] = 'Vajuta "Järgmine" nuppu all jätkamaks <strong>Moodle</strong> paigaldamisega.';
$string['wwwroot'] = 'Veebiaadress';
$string['wwwrooterror'] = 'Veebiaadress näib vigane - Moodle installatsiooni ei paista seal olevat.';
