<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'et', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Aadress';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Sisesta/redigeeri ankur';
$string['advanced:backcolor_desc'] = 'Vali tausta värv';
$string['advanced:block'] = 'Formaat';
$string['advanced:blockquote'] = 'Plokkviide';
$string['advanced:blockquote_desc'] = 'Plokkviide';
$string['advanced:bold_desc'] = 'Rasvane (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Lisa/eemalda järjestamata loend';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Sisesta kohandatud kirjamärk';
$string['advanced:cleanup_desc'] = 'Puhasta segane kood';
$string['advanced:clipboard_msg'] = 'Kopeeri/Lõika/Kleebi ei ole Mozillas ja Firefoxis saadaval. Kas soovid rohkem infot selle probleemi kohta?';
$string['advanced:code'] = 'Kood';
$string['advanced:code_desc'] = 'Redigeeri HTML lähtekoodi';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopeeri';
$string['advanced:custom1_desc'] = 'Teie kohandatud kirjeldus siia';
$string['advanced:cut_desc'] = 'Lõika';
$string['advanced:dd'] = 'Mõiste kirjeldus';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'Teave';
$string['advanced_dlg:about_help'] = 'Abi';
$string['advanced_dlg:about_license'] = 'Litsents';
$string['advanced_dlg:about_loaded'] = 'Laetud lisad';
$string['advanced_dlg:about_plugin'] = 'Lisa';
$string['advanced_dlg:about_plugins'] = 'Lisad';
$string['advanced_dlg:about_title'] = 'Teave TinyMCE kohta';
$string['advanced_dlg:about_version'] = 'Versioon';
$string['advanced_dlg:accessibility_help'] = 'Ligipääsetavuse abi';
$string['advanced_dlg:accessibility_usage_title'] = 'Üldine kasutamine';
$string['advanced_dlg:anchor_invalid'] = 'Palun määra sobiv ankru nimi.';
$string['advanced_dlg:anchor_name'] = 'Ankru nimi';
$string['advanced_dlg:anchor_title'] = 'Sisesta/redigeeri ankur';
$string['advanced_dlg:charmap_title'] = 'Vali kohandatud tähemärk';
$string['advanced_dlg:charmap_usage'] = 'Kasuta navigeerimiseks vasakut ja paremat nooleklahvi.';
$string['advanced_dlg:code_title'] = 'HTML koodi redaktor';
$string['advanced_dlg:code_wordwrap'] = 'Murra ridu';
$string['advanced_dlg:colorpicker_color'] = 'Värv:';
$string['advanced_dlg:colorpicker_name'] = 'Nimi:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Nimetatud';
$string['advanced_dlg:colorpicker_named_title'] = 'Nimetatud värvid';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Palett';
$string['advanced_dlg:colorpicker_palette_title'] = 'Palett värvid';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Korjaja';
$string['advanced_dlg:colorpicker_picker_title'] = 'Värvi korjaja';
$string['advanced_dlg:colorpicker_title'] = 'Vali värv';
$string['advanced_dlg:image_align'] = 'Reastus';
$string['advanced_dlg:image_align_baseline'] = 'Kirjajoondus';
$string['advanced_dlg:image_align_bottom'] = 'Alumine';
$string['advanced_dlg:image_align_left'] = 'Vasak';
$string['advanced_dlg:image_align_middle'] = 'Keskmine';
$string['advanced_dlg:image_align_right'] = 'Parem';
$string['advanced_dlg:image_align_textbottom'] = 'Teksti põhi';
$string['advanced_dlg:image_align_texttop'] = 'Teksti tipp';
$string['advanced_dlg:image_align_top'] = 'Ülemine';
$string['advanced_dlg:image_alt'] = 'Pildi kirjeldus';
$string['advanced_dlg:image_border'] = 'Raam';
$string['advanced_dlg:image_dimensions'] = 'Dimensioonid';
$string['advanced_dlg:image_hspace'] = 'Horisontaalne vahe';
$string['advanced_dlg:image_list'] = 'Pildi loend';
$string['advanced_dlg:image_src'] = 'Pildi URL';
$string['advanced_dlg:image_title'] = 'Sisestal/redigeeri pilt';
$string['advanced_dlg:image_vspace'] = 'Vertikaalne vahe';
$string['advanced_dlg:invalid_color_value'] = 'Kehtetu värvi määrang';
$string['advanced_dlg:link_is_email'] = 'URL, mille Sa sisestasid, tundub olevat e-postiaadress. Kas soovid, et sellele lisatakse kohustuslik eesliide "mailto:"?';
$string['advanced_dlg:link_is_external'] = 'URL, mille Sa sisestasid, tundub olevat väline link. Kas soovid, et sellele lisatakse kohustuslik eesliide "http://"?';
$string['advanced_dlg:link_list'] = 'Lingi loetelu';
$string['advanced_dlg:link_target'] = 'Sihtala';
$string['advanced_dlg:link_target_blank'] = 'Ava link uues aknas';
$string['advanced_dlg:link_target_same'] = 'Ava link samas aknas';
$string['advanced_dlg:link_title'] = 'Sisesta/redigeeri link';
$string['advanced_dlg:link_titlefield'] = 'Pealkiri';
$string['advanced_dlg:link_url'] = 'Link URL';
$string['advanced:dt'] = 'Mõiste nimetus';
$string['advanced:fontdefault'] = 'Font';
$string['advanced:font_size'] = 'Fondi suurus';
$string['advanced:forecolor_desc'] = 'Vali teksti värv';
$string['advanced:h1'] = 'Heading 1';
$string['advanced:h2'] = 'Heading 2';
$string['advanced:h3'] = 'Heading 3';
$string['advanced:h4'] = 'Heading 4';
$string['advanced:h5'] = 'Heading 5';
$string['advanced:h6'] = 'Heading 6';
$string['advanced:help_desc'] = 'Abi';
$string['advanced:help_shortcut'] = 'Tööriistariba jaoks vajutage ALT-F10. Abi saamiseks vajutage ALT-0';
$string['advanced:hr_desc'] = 'Sisesta horisontaalne joon';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Sisesta/redigeeri pilti';
$string['advanced:image_props_desc'] = 'Pildi kirjeldus';
$string['advanced:indent_desc'] = 'Lisa taane';
$string['advanced:italic_desc'] = 'Kaldkiri (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Keskjoondus';
$string['advanced:justifyfull_desc'] = 'Täisjoondus';
$string['advanced:justifyleft_desc'] = 'Vasak joondus';
$string['advanced:justifyright_desc'] = 'Parem joondus';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Sisesta/redigeeri link';
$string['advanced:more_colors'] = 'Rohkem värve...';
$string['advanced:newdocument'] = 'Oled sa kindel, et tahad kustutada kõik sisud?';
$string['advanced:newdocument_desc'] = 'Uus dokument';
$string['advanced:numlist_desc'] = 'Lisa/eemalda nummerdatud loetelu';
$string['advanced:outdent_desc'] = 'Eemalda taane';
$string['advanced:paragraph'] = 'Paragrahv';
$string['advanced:paste_desc'] = 'Kleebi';
$string['advanced:path'] = 'Teekond';
$string['advanced:pre'] = 'Eelformaaditud';
$string['advanced:redo_desc'] = 'Tee uuesti (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Eemalda vormindus';
$string['advanced:rich_text_area'] = 'RTF ala';
$string['advanced:samp'] = 'Koodinäide';
$string['advanced:shortcuts_desc'] = 'Ligipääsetavuse abi';
$string['advanced:striketrough_desc'] = 'Läbijoonitud';
$string['advanced:style_select'] = 'Stiilid';
$string['advanced:sub_desc'] = 'Alaindeks';
$string['advanced:sup_desc'] = 'Ülaindeks';
$string['advanced:toolbar'] = 'Tööriistariba';
$string['advanced:toolbar_focus'] = 'Hüppa tööriista nuppudele - Alt+Q, Hüppa redaktorisse - Alt-Z, Hüppa elemendi teekonnale - Alt-X';
$string['advanced:underline_desc'] = 'Allajoonitud (Ctrl+U)';
$string['advanced:undo_desc'] = 'Võta tagasi (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Eemalda link';
$string['advanced:visualaid_desc'] = 'Lülita ümber juhtjooned/nähtamatud elemendid';
$string['advhr:advhr_desc'] = 'Sisesta horisontaalne joon';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normaalne';
$string['advhr_dlg:noshade'] = 'Ilma varjuta';
$string['advhr_dlg:size'] = 'Kõrgus';
$string['advhr_dlg:width'] = 'Laius';
$string['advhr_dlg:widthunits'] = 'Ühikud';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Joondus';
$string['advimage_dlg:align_baseline'] = 'Baasjoon';
$string['advimage_dlg:align_bottom'] = 'All';
$string['advimage_dlg:align_left'] = 'Vasakul';
$string['advimage_dlg:align_middle'] = 'Keskel';
$string['advimage_dlg:align_right'] = 'Paremal';
$string['advimage_dlg:align_textbottom'] = 'Tekst all';
$string['advimage_dlg:align_texttop'] = 'Tekst üleval';
$string['advimage_dlg:align_top'] = 'Üleval';
$string['advimage_dlg:alt'] = 'Pildi kirjeldus';
$string['advimage_dlg:alt_image'] = 'Alternatiivne pilt';
$string['advimage_dlg:border'] = 'Raam';
$string['advimage_dlg:classes'] = 'Klassid';
$string['advimage_dlg:constrain_proportions'] = 'Piira proportioone';
$string['advimage_dlg:dialog_title'] = 'Sisesta/muuda pilti';
$string['advimage_dlg:dimensions'] = 'Mõõtmed';
$string['advimage_dlg:example_img'] = 'Eelvaate pildi välimus';
$string['advimage_dlg:general'] = 'Üldine';
$string['advimage_dlg:height'] = 'Kõrgus';
$string['advimage_dlg:hspace'] = 'Horisontaalne vahe';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Piltide nimekiri';
$string['advimage_dlg:langcode'] = 'Keele kood';
$string['advimage_dlg:langdir'] = 'Keele suund';
$string['advimage_dlg:list'] = 'Piltide nimekiri';
$string['advimage_dlg:long_desc'] = 'Pikk kirjelduse link';
$string['advimage_dlg:ltr'] = 'Vasakult paremale';
$string['advimage_dlg:map'] = 'Pildikaart';
$string['advimage_dlg:misc'] = 'Mitmesugune';
$string['advimage_dlg:missing_alt'] = 'Oled kindel, et soovid jätkata pildile kirjeldust lisamata? Ilma kirjelduseta võib juhtuda, et lisatud pilt pole arusaadav mõnedele erivajadustega kasutajatele või neile, kes kasutavad tekstibrauserit või on eelistanud keelata piltide kuvamise internetibrauseris.';
$string['advimage_dlg:mouseout'] = '„Kursor maas“';
$string['advimage_dlg:mouseover'] = '„Kursor peal“';
$string['advimage_dlg:preview'] = 'Eelvaade';
$string['advimage_dlg:rtl'] = 'Paremalt vasakule';
$string['advimage_dlg:src'] = 'Pildi URL';
$string['advimage_dlg:style'] = 'Stiil';
$string['advimage_dlg:swap_image'] = 'Vaheta pilti';
$string['advimage_dlg:tab_advanced'] = 'Põhjalikum';
$string['advimage_dlg:tab_appearance'] = 'Välimus';
$string['advimage_dlg:tab_general'] = 'Üldine';
$string['advimage_dlg:title'] = 'Pealkiri';
$string['advimage_dlg:vspace'] = 'Vertikaalne vahe';
$string['advimage_dlg:width'] = 'Laius';
$string['advimage:image_desc'] = 'Sisesta/redigeeri pilt';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Ligipääsuklahv';
$string['advlink_dlg:advanced_props'] = 'Üldised seadistused';
$string['advlink_dlg:advanced_tab'] = 'Põhjalikum';
$string['advlink_dlg:anchor_names'] = 'Ankrud';
$string['advlink_dlg:classes'] = 'Klassid';
$string['advlink_dlg:encoding'] = 'Sihtmärgi kodeering';
$string['advlink_dlg:event_props'] = 'Sündmused';
$string['advlink_dlg:events_tab'] = 'Sündmused';
$string['advlink_dlg:general_props'] = 'Üldised seadistused';
$string['advlink_dlg:general_tab'] = 'Üldine';
$string['advlink_dlg:height'] = 'Kõrgus';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'URL, mille Sa sisestasid, tundub olevat e-postiaadress. Kas soovid, et sellele lisatakse kohustuslik eesliide "mailto:"?';
$string['advlink_dlg:is_external'] = 'URL, mille Sa sisestasid, tundub olevat väline link. Kas soovid, et sellele lisatakse kohustuslik eesliide "http://"?';
$string['advlink_dlg:langcode'] = 'Keele kood';
$string['advlink_dlg:langdir'] = 'Keele suund';
$string['advlink_dlg:link_list'] = 'Linkide nimekiri';
$string['advlink_dlg:list'] = 'Linkide nimekiri';
$string['advlink_dlg:ltr'] = 'Vasakult paremale';
$string['advlink_dlg:mime'] = 'Sihtmärgi MIME tüüp';
$string['advlink_dlg:popup'] = 'JavaScript hüpikaken';
$string['advlink_dlg:popup_dependent'] = 'Sõltuv (ainult Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Näita asukohariba';
$string['advlink_dlg:popup_menubar'] = 'Näita menüüriba';
$string['advlink_dlg:popup_name'] = 'Akna nimi';
$string['advlink_dlg:popup_opts'] = 'Valikud';
$string['advlink_dlg:popup_position'] = 'Positsioon (X/Y)';
$string['advlink_dlg:popup_props'] = 'Hüpikakna seadistused';
$string['advlink_dlg:popup_resizable'] = 'Määra akna suurus muudetavaks';
$string['advlink_dlg:popup_return'] = 'Sisesta \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Näita kerimisribasid';
$string['advlink_dlg:popup_size'] = 'Suurus';
$string['advlink_dlg:popup_statusbar'] = 'Näita staatuse riba';
$string['advlink_dlg:popup_tab'] = 'Hüpikaken';
$string['advlink_dlg:popup_toolbar'] = 'Näita seadistusriba';
$string['advlink_dlg:popup_url'] = 'Hüpikakna URL';
$string['advlink_dlg:rel'] = 'Seo leht sihtmärgiga';
$string['advlink_dlg:rev'] = 'Seo sihtmärk lehega';
$string['advlink_dlg:rtl'] = 'Paremalt vasakule';
$string['advlink_dlg:style'] = 'Stiil';
$string['advlink_dlg:tabindex'] = 'Tabulaatori indeks';
$string['advlink_dlg:target'] = 'Sihtmärk';
$string['advlink_dlg:target_blank'] = 'Ava uues aknas';
$string['advlink_dlg:target_langcode'] = 'Sihtmärgi keel';
$string['advlink_dlg:target_name'] = 'Sihtmärgi nimi';
$string['advlink_dlg:target_parent'] = 'Ava peamises aknas/raamis';
$string['advlink_dlg:target_same'] = 'Ava selles aknas/raamis';
$string['advlink_dlg:target_top'] = 'Ava kõrgeimas raamis (asendab kõik raamid)';
$string['advlink_dlg:title'] = 'Sisesta/redigeeri linki';
$string['advlink_dlg:titlefield'] = 'Pealkiri';
$string['advlink_dlg:url'] = 'Lingi URL';
$string['advlink_dlg:width'] = 'Laius';
$string['advlink:link_desc'] = 'Sisesta/redigeeri linki';
$string['advlist:circle'] = 'Ring';
$string['advlist:def'] = 'Vaikimisi';
$string['advlist:disc'] = 'Ketas';
$string['advlist:lower_alpha'] = 'Väiketähtedeks';
$string['advlist:lower_greek'] = 'Väikesteks Kreeka tähtedeks';
$string['advlist:lower_roman'] = 'Väikesteks Rooma tähtedeks';
$string['advlist:square'] = 'Ruut';
$string['advlist:types'] = 'Tüübid';
$string['advlist:upper_alpha'] = 'Suurtähtedeks';
$string['advlist:upper_roman'] = 'Suurteks Rooma tähtedeks';
$string['aria:rich_text_area'] = 'RTF';
$string['autosave:restore_content'] = 'Taasta automaat-salvestatud sisu.';
$string['autosave:unload_msg'] = 'Tehtud muudatused kaovad, kui lahkute siit lehelt.';
$string['autosave:warning_message'] = 'Kui taastat salvestatud sisu, siis kaotad kogu sisu, mis praegu redaktoris on.

Kas oled kindel, et soovid salvestatud sisu taastada?';
$string['availablebuttons'] = 'Saadaolead nupud';
$string['colors:000000'] = 'Must';
$string['colors:000080'] = 'Tumesinine';
$string['colors:0000FF'] = 'Sinine';
$string['colors:003300'] = 'Tumeroheline';
$string['colors:003366'] = 'Tume taevasinine';
$string['colors:008000'] = 'Roheline';
$string['colors:00CCFF'] = 'Taevasinine';
$string['colors:00FF00'] = 'Laim';
$string['colors:00FFFF'] = 'Vesi';
$string['colors:333300'] = 'Tume oliiv';
$string['colors:333333'] = 'Väga tume hall';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Kuninglik sinine';
$string['colors:339966'] = 'Mereroheline';
$string['colors:33CCCC'] = 'Türkiis';
$string['colors:666699'] = 'Hallikas-sinine';
$string['colors:800000'] = 'Kastanpruun';
$string['colors:800080'] = 'Lilla';
$string['colors:808000'] = 'Oliiv';
$string['colors:808080'] = 'Hall';
$string['colors:993300'] = 'Põlenud oranž';
$string['colors:993366'] = 'Pruun';
$string['colors:999999'] = 'Keskmiselt hall';
$string['colors:99CC00'] = 'Kollakas-roheline';
$string['colors:99CCFF'] = 'Hele sinine teavas';
$string['colors:C0C0C0'] = 'Hõbedane';
$string['colors:CC99FF'] = 'Ploom';
$string['colors:CCFFCC'] = 'Tuhm-roheline';
$string['colors:FF0000'] = 'Punane';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Oranž';
$string['colors:FF9900'] = 'Merevaik';
$string['colors:FF99CC'] = 'Roosa';
$string['colors:FFCC00'] = 'Kuldne';
$string['colors:FFCC99'] = 'Virsik';
$string['colors:FFFF00'] = 'Kollane';
$string['colors:FFFF99'] = 'Helekollane';
$string['colors:FFFFFF'] = 'Valge';
$string['common:apply'] = 'Rakenda';
$string['common:browse'] = 'Sirvi';
$string['common:cancel'] = 'Tühista';
$string['common:class_name'] = 'Klass';
$string['common:clipboard_msg'] = 'Kopeeri/Lõika/Kleebi ei ole saadaval Mozillas ja Firefoxis.
Kas soovite rohkem infot selle probleemi kohta?';
$string['common:clipboard_no_support'] = 'Hetkel ei ole toetatud Teie lehitseja poolt, kasutage klaviatuuri otseteid selle asemel.';
$string['common:close'] = 'Sulge';
$string['common:edit_confirm'] = 'Kas soovite kasutada WYSIWYG režiimi sellel tekstialal?';
$string['common:insert'] = 'Sisesta';
$string['common:invalid_data'] = 'Viga: Kehtetud väärtused sisestatud, need on märgitud punasega.';
$string['common:invalid_data_min'] = '{#field} peab olema number, mis on suurem kui {#min}';
$string['common:invalid_data_number'] = '{#field} peab olema number';
$string['common:invalid_data_size'] = '{#field} peab olema number või protsent';
$string['common:more_colors'] = 'Rohkem värve...';
$string['common:not_set'] = '-- Seadmata --';
$string['common:popup_blocked'] = 'Vabandust, aga Teie hüpikakna tõkestaja on blokeerinud akna, mis varustab rakenduse funktsionaalsust. Palun lubage hüpikaknad sellel kodulehel, et täielikult kasutada seda vahendit.';
$string['common:update'] = 'Uuenda';
$string['common:value'] = '(väärtus)';
$string['contextmenu:align'] = 'Joondus';
$string['contextmenu:center'] = 'Keskele';
$string['contextmenu:full'] = 'Servast-serva';
$string['contextmenu:left'] = 'Vasakule';
$string['contextmenu:right'] = 'Paremale';
$string['customtoolbar'] = 'Redaktori tööriistariba';
$string['directionality:ltr_desc'] = 'Suund vasakult paremale';
$string['directionality:rtl_desc'] = 'Suund paremalt vasakule';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Lahe';
$string['emotions_dlg:cry'] = 'Nutt';
$string['emotions_dlg:desc'] = 'Emotsioonid';
$string['emotions_dlg:embarassed'] = 'Häbitunne';
$string['emotions_dlg:foot_in_mouth'] = 'Jalg suus';
$string['emotions_dlg:frown'] = 'Kulmu kortsutamine';
$string['emotions_dlg:innocent'] = 'Süütu';
$string['emotions_dlg:kiss'] = 'Suudlus';
$string['emotions_dlg:laughing'] = 'Naermine';
$string['emotions_dlg:money_mouth'] = 'Rahasuu';
$string['emotions_dlg:sealed'] = 'Suletud';
$string['emotions_dlg:smile'] = 'Naeratus';
$string['emotions_dlg:surprised'] = 'Üllatunud';
$string['emotions_dlg:title'] = 'Sisesta emotsioon';
$string['emotions_dlg:tongue_out'] = 'Keel väljas';
$string['emotions_dlg:undecided'] = 'Kõhklev';
$string['emotions_dlg:usage'] = 'Navigeerimiseks kasuta vasakut ja paremat nooleklahvi.';
$string['emotions_dlg:wink'] = 'Silmapilgutus';
$string['emotions_dlg:yell'] = 'Karje';
$string['emotions:emotions_desc'] = 'Emotsioonid';
$string['fontselectlist'] = 'Saadaolevate fontide nimekiri';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Dokumendi omadused';
$string['fullpage_dlg:active_color'] = 'Aktiivne värv';
$string['fullpage_dlg:add'] = 'Lisa uus element';
$string['fullpage_dlg:add_base'] = 'Baaselement';
$string['fullpage_dlg:add_comment'] = 'Kommentaar';
$string['fullpage_dlg:add_link'] = 'Lingi element';
$string['fullpage_dlg:add_meta'] = 'Meta-element';
$string['fullpage_dlg:add_script'] = 'Skript’i element';
$string['fullpage_dlg:add_style'] = 'Stiili element';
$string['fullpage_dlg:add_title'] = 'Pealkirja element';
$string['fullpage_dlg:advanced_props'] = 'Põhjalikum';
$string['fullpage_dlg:advanced_tab'] = 'Põhjalikum';
$string['fullpage_dlg:appearance_bgprops'] = 'Tausta seadistus';
$string['fullpage_dlg:appearance_linkprops'] = 'Lingi värvid';
$string['fullpage_dlg:appearance_marginprops'] = 'Sisu piirid';
$string['fullpage_dlg:appearance_style'] = 'Stiilileht ja stiili seaded';
$string['fullpage_dlg:appearance_tab'] = 'Välimus';
$string['fullpage_dlg:appearance_textprops'] = 'Teksti seaded';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Baaselement';
$string['fullpage_dlg:bgcolor'] = 'Tausta värv';
$string['fullpage_dlg:bgimage'] = 'Tausta pilt';
$string['fullpage_dlg:bottom_margin'] = 'Alumine piir';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Kommentaar';
$string['fullpage_dlg:content'] = 'Sisu';
$string['fullpage_dlg:copyright'] = 'Autoriõigus';
$string['fullpage_dlg:defer'] = 'Edasi lükkamine';
$string['fullpage_dlg:doctypes'] = 'Dokumendi tüüp';
$string['fullpage_dlg:encoding'] = 'Character encoding';
$string['fullpage_dlg:fontface'] = 'Fondi perekond';
$string['fullpage_dlg:font_face'] = 'Fondi nimi';
$string['fullpage_dlg:fontsize'] = 'Fondi suurus';
$string['fullpage_dlg:font_size'] = 'Fondi suurus';
$string['fullpage_dlg:general_props'] = 'Üldine';
$string['fullpage_dlg:head_elements'] = 'Põhielemendid';
$string['fullpage_dlg:hover_color'] = 'Üle-värv';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informatsioon';
$string['fullpage_dlg:langcode'] = 'Keele kood';
$string['fullpage_dlg:langdir'] = 'Keele suund';
$string['fullpage_dlg:langprops'] = 'Keel ja kodeering';
$string['fullpage_dlg:language'] = 'Keel';
$string['fullpage_dlg:left_margin'] = 'Vasak piir';
$string['fullpage_dlg:link_color'] = 'Lingi värv';
$string['fullpage_dlg:link_element'] = 'Lingi element';
$string['fullpage_dlg:ltr'] = 'Vasakult paremale';
$string['fullpage_dlg:media'] = 'Meedia';
$string['fullpage_dlg:meta_description'] = 'Kirjeldus';
$string['fullpage_dlg:meta_element'] = 'Meta-element';
$string['fullpage_dlg:meta_index_follow'] = 'Märgi ja järgi linke';
$string['fullpage_dlg:meta_index_nofollow'] = 'Märgi ja ära järgi linke';
$string['fullpage_dlg:meta_keywords'] = 'Märksõnad';
$string['fullpage_dlg:meta_noindex_follow'] = 'Ära märgi linki, aga järgi linke';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Ära märgi linki ja ära järgi linke';
$string['fullpage_dlg:meta_props'] = 'Meta-informatsioon';
$string['fullpage_dlg:meta_robots'] = 'Robotid';
$string['fullpage_dlg:meta_tab'] = 'Üldine';
$string['fullpage_dlg:meta_title'] = 'Pealkiri';
$string['fullpage_dlg:movedown'] = 'Liiguta valitud element alla';
$string['fullpage_dlg:moveup'] = 'Liiguta valitud element üles';
$string['fullpage_dlg:name'] = 'Nimi';
$string['fullpage_dlg:properties'] = 'Seaded';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Eemalda valitud element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Parem piir';
$string['fullpage_dlg:rtl'] = 'Paremalt vasakule';
$string['fullpage_dlg:script_element'] = 'Skript’i element';
$string['fullpage_dlg:src'] = 'Allikas';
$string['fullpage_dlg:style'] = 'Stiil';
$string['fullpage_dlg:style_element'] = 'Stiili element';
$string['fullpage_dlg:stylesheet'] = 'Stiilileht';
$string['fullpage_dlg:target'] = 'Sihtmärk';
$string['fullpage_dlg:textcolor'] = 'Värv';
$string['fullpage_dlg:text_color'] = 'Teksti värv';
$string['fullpage_dlg:title'] = 'Dokumendi omadused';
$string['fullpage_dlg:title_element'] = 'Pealkirja element';
$string['fullpage_dlg:top_margin'] = 'Ülemine piir';
$string['fullpage_dlg:type'] = 'Tüüp';
$string['fullpage_dlg:value'] = 'Väärtus';
$string['fullpage_dlg:visited_color'] = 'Külastatud-värv';
$string['fullpage_dlg:xml_pi'] = 'XML avaldus';
$string['fullscreen:desc'] = 'Lülita ümber täisekraani ja tavalise režiimi vahel';
$string['iespell:download'] = 'ieSpell tuvastamata. Kas soovite paigaldada nüüd?';
$string['iespell:iespell_desc'] = 'Kontrolli õigekirja';
$string['insertdatetime:date_fmt'] = '%A-%k-%p';
$string['insertdatetime:day_long'] = 'Pühapäev,Esmaspäev,Teisipäev,Kolmapäev,Neljapäev,Reede,Laupäev,Pühapäev';
$string['insertdatetime:day_short'] = 'P,E,T,K,N,R,L,P';
$string['insertdatetime:insertdate_desc'] = 'Sisesta kuupäev';
$string['insertdatetime:inserttime_desc'] = 'Sisesta aeg';
$string['insertdatetime:months_long'] = 'Jaanuar,Veebruar,Märts,Aprill,Mai,Juuni,Juuli,August,September,Oktoober,November,Detsember';
$string['insertdatetime:months_short'] = 'Jaan,Veeb,Märts,Apr,Mai,Juuni,Juuli,Aug,Sept,Okt,Nov,Dets';
$string['insertdatetime:time_fmt'] = '%T:%M:%S';
$string['layer:absolute_desc'] = 'Lülita absoluutne positsioneerimine sisse või välja';
$string['layer:backward_desc'] = 'Liiguta tagasi';
$string['layer:content'] = 'Uus kiht...';
$string['layer:forward_desc'] = 'Liiguta edasi';
$string['layer:insertlayer_desc'] = 'Sisesta uus kiht';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Sisesta/muuda manustatud meediat';
$string['media_dlg:advanced'] = 'Täpsem';
$string['media_dlg:align'] = 'Joondus';
$string['media_dlg:align_bottom'] = 'All';
$string['media_dlg:align_bottom_left'] = 'All vasakul';
$string['media_dlg:align_bottom_right'] = 'All paremal';
$string['media_dlg:align_center'] = 'Keskel';
$string['media_dlg:align_left'] = 'Vasakul';
$string['media_dlg:align_right'] = 'Paremal';
$string['media_dlg:align_top'] = 'Üleval';
$string['media_dlg:align_top_left'] = 'Üleval vasakul';
$string['media_dlg:align_top_right'] = 'Pleval paremal';
$string['media_dlg:altsource1'] = 'Alternatiivne allikas 1';
$string['media_dlg:altsource2'] = 'Alternatiivne allikas 2';
$string['media_dlg:audio'] = 'HTML5 heli';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Alusta automaatselt mahamängimist';
$string['media_dlg:balance'] = 'Tasakaal';
$string['media_dlg:base'] = 'Baas';
$string['media_dlg:baseurl'] = 'Baas URL';
$string['media_dlg:bgcolor'] = 'Taust';
$string['media_dlg:cache'] = 'Vahemälu';
$string['media_dlg:captioningid'] = 'Tiitri ID';
$string['media_dlg:center'] = 'Keskel';
$string['media_dlg:class_name'] = 'Klass';
$string['media_dlg:console'] = 'Konsool';
$string['media_dlg:constrain_proportions'] = 'Säilita proportsioon';
$string['media_dlg:controller'] = 'Kontrollija';
$string['media_dlg:controls'] = 'Kontrollid';
$string['media_dlg:correction'] = 'Parandust ei ole';
$string['media_dlg:currentmarker'] = 'Antud marker';
$string['media_dlg:currentposition'] = 'Antud positioon';
$string['media_dlg:defaultframe'] = 'Vaikimisi raam';
$string['media_dlg:embeddedaudio'] = 'Vistutatud heli';
$string['media_dlg:embedded_audio_options'] = 'Vistutatud heli valikud';
$string['media_dlg:enabled'] = 'Lubatud';
$string['media_dlg:enablejavascript'] = 'Luba JavaScript';
$string['media_dlg:endtime'] = 'Lõpu aeg';
$string['media_dlg:file'] = 'Fail/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Flash’i seaded';
$string['media_dlg:flashvars'] = 'Flash muutujad';
$string['media_dlg:fullscreen'] = 'Täisekraan';
$string['media_dlg:general'] = 'Üldine';
$string['media_dlg:hidden'] = 'Peidetud';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Horisontaalne vahe';
$string['media_dlg:html5_audio_options'] = 'Heli valikud';
$string['media_dlg:html5_video_options'] = 'HTML5 video valikud';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Pildi staatus';
$string['media_dlg:invokeurls'] = 'Näita URLe';
$string['media_dlg:kioskmode'] = 'Kioski reziim';
$string['media_dlg:list'] = 'Nimekiri';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Auto-kordus';
$string['media_dlg:maintainaspect'] = 'Säilita külgede suhe';
$string['media_dlg:menu'] = 'Näita menüüd';
$string['media_dlg:mute'] = 'Vaigista';
$string['media_dlg:name'] = 'Nimi';
$string['media_dlg:nojava'] = 'Ilma Java’ta';
$string['media_dlg:numloop'] = 'Kordused';
$string['media_dlg:play'] = 'Alusta automaatselt mahamängimist';
$string['media_dlg:playcount'] = 'Mängukorrad';
$string['media_dlg:playeveryframe'] = 'Mängi igat raami';
$string['media_dlg:poster'] = 'Poster';
$string['media_dlg:prefetch'] = 'Eellaadimine';
$string['media_dlg:preload'] = 'Eellaadimine';
$string['media_dlg:preload_auto'] = 'Las kasutaja brauser otsustab';
$string['media_dlg:preload_metadata'] = 'Eellae video metaandmed';
$string['media_dlg:preload_none'] = 'Ära eellae';
$string['media_dlg:preview'] = 'Eelvaade';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'QuickTime valikud';
$string['media_dlg:qtsrc'] = 'QT allikas';
$string['media_dlg:qtsrcchokespeed'] = 'Kiirus';
$string['media_dlg:qt_stream_warn'] = 'Striimitavavad RTMP vahendid peaks olema lisatud QT allikate väljale põhjalike sätete vahelehel.
Sul tasub lisada ka mitte-striimitav versioon allikate väljale.';
$string['media_dlg:quality'] = 'Kvaliteet';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Hinda';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Real Media Player valikud';
$string['media_dlg:salign'] = 'SJoondus';
$string['media_dlg:scale'] = 'Mõõtkava';
$string['media_dlg:scriptcallbacks'] = 'Skripti tagasikutse';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Shockwave’i seaded';
$string['media_dlg:shuffle'] = 'Sega';
$string['media_dlg:size'] = 'Mõõdud';
$string['media_dlg:sound'] = 'Heli';
$string['media_dlg:source'] = 'Allikas';
$string['media_dlg:starttime'] = 'Stardi aeg';
$string['media_dlg:stretchtofit'] = 'Venita sobivaks';
$string['media_dlg:swstretchhalign'] = 'Venita H-joondust';
$string['media_dlg:swstretchstyle'] = 'Venita stiili';
$string['media_dlg:swstretchvalign'] = 'Venita V-joondust';
$string['media_dlg:target'] = 'Sihtmärk';
$string['media_dlg:targetcache'] = 'Sihtmärgi vahemälu';
$string['media_dlg:title'] = 'Sisesta/muuda manustatud meediat';
$string['media_dlg:type'] = 'Tüüp';
$string['media_dlg:uimode'] = 'UI režiim';
$string['media_dlg:video'] = 'HTML5 video';
$string['media_dlg:volume'] = 'Valjudus';
$string['media_dlg:vspace'] = 'V-vahe';
$string['media_dlg:windowlessvideo'] = 'Aknata video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMoodus';
$string['media_dlg:wmp_options'] = 'Windows Media Player valikud';
$string['media:edit'] = 'Redigeeri manustatud meediat';
$string['nonbreaking:nonbreaking_desc'] = 'Sisesta mittekatkestav tühik';
$string['pagebreak:desc'] = 'Sisesta lehevahetus printimise jaoks.';
$string['paste_dlg:text_linebreaks'] = 'Säilita reavahetused';
$string['paste_dlg:text_title'] = 'Vajuta oma klaviatuuril Ctrl+V teksti aknasse kleepimiseks.';
$string['paste_dlg:word_title'] = 'Vajuta oma klaviatuuril Ctrl+V teksti aknasse kleepimiseks.';
$string['paste:paste_text_desc'] = 'Kleebi tavalise tekstina';
$string['paste:paste_word_desc'] = 'Kleebi Word\'ist';
$string['paste:plaintext_mode'] = 'Kleepimine on nüüd lihtteksti režiimis. Kliki uuesti, lülitamaks tagasi tavalisse kleepimise režiimi.
Peale millegi kleepimist viiakse sind tagasi tavapärasesse kleepimise režiimi.';
$string['paste:plaintext_mode_stick'] = 'Kleepimine on nüüd lihtteksti režiimis. Kliki uuesti, lülitamaks tagasi tavalisse kleepimise režiimi.';
$string['paste:selectall_desc'] = 'Vali kõik';
$string['pluginname'] = 'TinyMCE HTML redaktor';
$string['preview:preview_desc'] = 'Eelvaade';
$string['print:print_desc'] = 'Print';
$string['save:cancel_desc'] = 'Tühista kõik muudatused';
$string['save:save_desc'] = 'Salvesta';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Kõik otsisõna ilmingud on asendatud.';
$string['searchreplace_dlg:direction'] = 'Suund';
$string['searchreplace_dlg:down'] = 'Alla';
$string['searchreplace_dlg:findnext'] = 'Otsi järgmine';
$string['searchreplace_dlg:findwhat'] = 'Mida otsida';
$string['searchreplace_dlg:mcase'] = 'Ole tõstutundlik (arvesta suuri ja väikeseid tähti)';
$string['searchreplace_dlg:notfound'] = 'Otsing on lõpetatud. Otsisõna ei leitud.';
$string['searchreplace_dlg:replace'] = 'Asenda';
$string['searchreplace_dlg:replaceall'] = 'Asenda kõik';
$string['searchreplace_dlg:replace_title'] = 'Otsi/asenda';
$string['searchreplace_dlg:replacewith'] = 'Asenda millega';
$string['searchreplace_dlg:searchnext_desc'] = 'Otsi uuesti';
$string['searchreplace_dlg:search_title'] = 'Otsi';
$string['searchreplace_dlg:up'] = 'Üles';
$string['searchreplace:replace_desc'] = 'Otsi/asenda';
$string['searchreplace:search_desc'] = 'Otsi';
$string['settings'] = 'Üldised sätted';
$string['simple:bold_desc'] = 'Rasvane (Ctrl+B)';
$string['simple:bullist_desc'] = 'Lisa/eemalda järjestamata loend';
$string['simple:cleanup_desc'] = 'Puhasta segane kood';
$string['simple:italic_desc'] = 'Kaldkiri (Ctrl+I)';
$string['simple:numlist_desc'] = 'Lisa/eemalda nummerdatud loend';
$string['simple:redo_desc'] = 'Tee uuesti (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Läbijoonitud';
$string['simple:underline_desc'] = 'Allajoonitud (Ctrl+U)';
$string['simple:undo_desc'] = 'Võta tagasi (Ctrl+Z)';
$string['spellchecker:desc'] = 'Lülita õigekirja kontroll sisse või välja';
$string['spellchecker:ignore_word'] = 'Jäta sõna vahele';
$string['spellchecker:ignore_words'] = 'Jäta kõik vahele';
$string['spellchecker:langs'] = 'Keeled';
$string['spellchecker:learn_word'] = 'Õpi sõna selgeks';
$string['spellchecker:menu'] = 'Õigekirjakontrolli seaded';
$string['spellchecker:no_mpell'] = 'Valesti kirjutamisi ei leitud.';
$string['spellchecker:no_sug'] = 'Soovitusi pole';
$string['spellchecker:sug'] = 'Soovitused';
$string['spellchecker:wait'] = 'Palun oota...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Redigeeri CSS stiili';
$string['style_dlg:apply'] = 'Rakenda';
$string['style_dlg:background'] = 'Taust';
$string['style_dlg:background_attachment'] = 'Manus';
$string['style_dlg:background_color'] = 'Tausta värv';
$string['style_dlg:background_hpos'] = 'Horisontaalne asend';
$string['style_dlg:background_image'] = 'Taustapilt';
$string['style_dlg:background_repeat'] = 'Kordus';
$string['style_dlg:background_tab'] = 'Taust';
$string['style_dlg:background_vpos'] = 'Vertikaalasend';
$string['style_dlg:block'] = 'Plokk';
$string['style_dlg:block_display'] = 'Kuva';
$string['style_dlg:block_letterspacing'] = 'Tähtede vahe';
$string['style_dlg:block_tab'] = 'Plokk';
$string['style_dlg:block_text_align'] = 'Teksti joondus';
$string['style_dlg:block_text_indent'] = 'Teksti taane';
$string['style_dlg:block_vertical_alignment'] = 'Vertikaaljoondus';
$string['style_dlg:block_whitespace'] = 'Tühimik';
$string['style_dlg:block_wordspacing'] = 'Sõnade vahe';
$string['style_dlg:border'] = 'Raam';
$string['style_dlg:border_tab'] = 'Raam';
$string['style_dlg:bottom'] = 'All';
$string['style_dlg:box'] = 'Kast';
$string['style_dlg:box_clear'] = 'Puhas';
$string['style_dlg:box_float'] = 'Hõljuv';
$string['style_dlg:box_height'] = 'Kõrgus';
$string['style_dlg:box_tab'] = 'Kast';
$string['style_dlg:box_width'] = 'Laius';
$string['style_dlg:bullet_image'] = 'Punkti pilt';
$string['style_dlg:clip'] = 'Klipp';
$string['style_dlg:color'] = 'Värv';
$string['style_dlg:height'] = 'Kõrgus';
$string['style_dlg:left'] = 'Vasakul';
$string['style_dlg:list'] = 'Loetelu';
$string['style_dlg:list_tab'] = 'Loetelu';
$string['style_dlg:list_type'] = 'Tüüp';
$string['style_dlg:margin'] = 'Serv';
$string['style_dlg:overflow'] = 'Ülevool';
$string['style_dlg:padding'] = 'Täidis';
$string['style_dlg:placement'] = 'Asetus';
$string['style_dlg:position'] = 'Positsioon';
$string['style_dlg:positioning_tab'] = 'Positsioneerimine';
$string['style_dlg:positioning_type'] = 'Tüüp';
$string['style_dlg:right'] = 'Paremal';
$string['style_dlg:same'] = 'Sama kõigile';
$string['style_dlg:style'] = 'Stiil';
$string['style_dlg:text'] = 'Tekst';
$string['style_dlg:text_blink'] = 'Vilkuv tekst';
$string['style_dlg:text_case'] = 'Suur-/väiketäht';
$string['style_dlg:text_color'] = 'Värv';
$string['style_dlg:text_decoration'] = 'Dekoratioon';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Joone kõrgus';
$string['style_dlg:text_none'] = 'Mitte ükski';
$string['style_dlg:text_overline'] = 'Ülejoon';
$string['style_dlg:text_props'] = 'Tekst';
$string['style_dlg:text_size'] = 'Suurus';
$string['style_dlg:text_striketrough'] = 'Läbikriipsutus';
$string['style_dlg:text_style'] = 'Stiil';
$string['style_dlg:text_tab'] = 'Tekst';
$string['style_dlg:text_underline'] = 'Allajoonitud';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Raskus';
$string['style_dlg:title'] = 'Muuda CSS stiili';
$string['style_dlg:toggle_insert_span'] = 'Sisesta valiku kohale <span>';
$string['style_dlg:top'] = 'Üleval';
$string['style_dlg:visibility'] = 'Nähtavus';
$string['style_dlg:width'] = 'Laius';
$string['style_dlg:zindex'] = 'Z-viit';
$string['subplugintype_tinymce_plural'] = 'Pluginad';
$string['table:cell'] = 'Lahter';
$string['table:cell_desc'] = 'Tabeli lahtri omadused';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Veerg';
$string['table:col_after_desc'] = 'Sisesta veerg peale';
$string['table:col_before_desc'] = 'Sisesta veerg enne';
$string['table:copy_row_desc'] = 'Kopeeri tabeli rida';
$string['table:cut_row_desc'] = 'Lõika tabeli rida';
$string['table:del'] = 'Kustuta tabel';
$string['table:delete_col_desc'] = 'Kustuta veerg';
$string['table:delete_row_desc'] = 'Kustuta rida';
$string['table:desc'] = 'Sisesta/redigeeri tabel(it)';
$string['table_dlg:advanced_props'] = 'Täpsustatud seaded';
$string['table_dlg:advanced_tab'] = 'Täpsustatud';
$string['table_dlg:align'] = 'Joondus';
$string['table_dlg:align_bottom'] = 'All';
$string['table_dlg:align_default'] = 'Vaikimisi';
$string['table_dlg:align_left'] = 'Vasak';
$string['table_dlg:align_middle'] = 'Keskel';
$string['table_dlg:align_right'] = 'Parem';
$string['table_dlg:align_top'] = 'Üleval';
$string['table_dlg:bgcolor'] = 'Tausta värv';
$string['table_dlg:bgimage'] = 'Tausta pilt';
$string['table_dlg:border'] = 'Raam';
$string['table_dlg:bordercolor'] = 'Raami värv';
$string['table_dlg:caption'] = 'Tabeli seletus';
$string['table_dlg:cell_all'] = 'Uuenda kõiki lahtreid tabelis';
$string['table_dlg:cell_cell'] = 'Uuenda antud lahtrit';
$string['table_dlg:cell_col'] = 'Uuenda kõik väljad veerus';
$string['table_dlg:cell_limit'] = 'Oled jõudnud maksimaalse arvu elementideni';
$string['table_dlg:cellpadding'] = 'Veeru täide';
$string['table_dlg:cell_row'] = 'Uuenda kõiki lahtreid reas';
$string['table_dlg:cellspacing'] = 'Veeru laius';
$string['table_dlg:cell_title'] = 'Tabeli veeru seaded';
$string['table_dlg:cell_type'] = 'Veeru tüüp';
$string['table_dlg:colgroup'] = 'Veeru grupp';
$string['table_dlg:col_limit'] = 'Oled kasutanud maksimaalse arvu veerge, mis on {$cols}.';
$string['table_dlg:cols'] = 'Veerge';
$string['table_dlg:frame'] = 'Raam';
$string['table_dlg:frame_all'] = 'kõik';
$string['table_dlg:frame_cols'] = 'veerud';
$string['table_dlg:frame_groups'] = 'grupid';
$string['table_dlg:frame_none'] = 'mitte ükski';
$string['table_dlg:frame_rows'] = 'read';
$string['table_dlg:general_props'] = 'Üldised seaded';
$string['table_dlg:general_tab'] = 'Üldine';
$string['table_dlg:height'] = 'Kõrgus';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Keele kood';
$string['table_dlg:langdir'] = 'Keele suund';
$string['table_dlg:ltr'] = 'Vasakult paremale';
$string['table_dlg:merge_cells_title'] = 'Ühenda lahtrid';
$string['table_dlg:mime'] = 'Sihtmärgi MIME tüüp';
$string['table_dlg:missing_scope'] = 'Oled kindel, et soovid jätkata täpsustamata antud tabeli päise nime? Ilma selleta võib mõnedel erivajadustega kasutajatel olla keeruline  mõista tabeli sisu.';
$string['table_dlg:row_all'] = 'Uuenda kõiki ridu tabelis';
$string['table_dlg:row_even'] = 'Uuenda paaris ridu tabelis';
$string['table_dlg:rowgroup'] = 'Rea-grupp';
$string['table_dlg:row_limit'] = 'Oled kasutanud maksimaalse arvu ridasid, mis on {$rows}.';
$string['table_dlg:row_odd'] = 'Uuenda paarituid ridu tabelis';
$string['table_dlg:row_row'] = 'Uuenda antud rida';
$string['table_dlg:rows'] = 'Ridu';
$string['table_dlg:row_title'] = 'Tabeli rea seaded';
$string['table_dlg:rowtype'] = 'Rea tüüp';
$string['table_dlg:rtl'] = 'Paremalt vasakule';
$string['table_dlg:rules'] = 'Reeglid';
$string['table_dlg:rules_above'] = 'üleval';
$string['table_dlg:rules_below'] = 'all';
$string['table_dlg:rules_border'] = 'raam';
$string['table_dlg:rules_box'] = 'kast';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'tühi';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'Ulatus';
$string['table_dlg:style'] = 'Stiil';
$string['table_dlg:summary'] = 'Kokkuvõte';
$string['table_dlg:tbody'] = 'Tabeli sisu';
$string['table_dlg:td'] = 'Andmed';
$string['table_dlg:tfoot'] = 'Tabeli jalus';
$string['table_dlg:th'] = 'Päis';
$string['table_dlg:thead'] = 'Tabeli päis';
$string['table_dlg:title'] = 'Sisesta/muuda tabel(it)';
$string['table_dlg:valign'] = 'Vertikaalne joondus';
$string['table_dlg:width'] = 'Laius';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Ühenda tabeli lahtrid';
$string['table:paste_row_after_desc'] = 'Kleebi tabeli rida peale';
$string['table:paste_row_before_desc'] = 'Kleebi tabeli rida enne';
$string['table:props_desc'] = 'Tabeli omadused';
$string['table:row'] = 'Rida';
$string['table:row_after_desc'] = 'Sisesta rida peale';
$string['table:row_before_desc'] = 'Sisesta rida enne';
$string['table:row_desc'] = 'Tabeli rea omadused';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Eralda ühendatud tabeli lahtrid';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Sisesta eeldefineeritud šablooni sisu';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Pühapäev,Esmaspäev,Teisipäev,Kolmapäev,Neljapäev,reede,Laupäev,Pühapäev';
$string['template_dlg:day_short'] = 'P,E,T,K,N,R,L,P';
$string['template_dlg:desc'] = 'Sisesta eeldefineeritud šablooni sisu';
$string['template_dlg:desc_label'] = 'Kirjeldus';
$string['template_dlg:label'] = 'Šabloon';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Jaanuar,Veebruar,Märts,Aprill,Mai,Juuni,Juuli,August,September,Oktoober,November,Detsember';
$string['template_dlg:months_short'] = 'Jaan,Veeb,Märts,Apr,Mai,Juuni,Juuli,Aug,Sep,Okt,Nov,Dets';
$string['template_dlg:preview'] = 'Eelvaade';
$string['template_dlg:select'] = 'Vali šabloon';
$string['template_dlg:title'] = 'Šabloonid';
$string['template_dlg:warning'] = 'Hoiatus: Šablooni uuendamine teistsugusega võib kaasa tuua andmete kaotsiminemist.';
$string['visualblocks:desc'] = 'Näita/varja ploki elemente';
$string['visualchars:desc'] = 'Visuaalsed kontrolltähemärgid sisse/välja';
$string['wordcount:words'] = 'Sõnu:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Lühend';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Akronüüm';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Sisesta/muuda atribuute';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Tsitaat';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Kustutus';
$string['xhtmlxtras_dlg:attribs_title'] = 'Sisesta/muuda atribuute';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atribuudid';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atribuudid';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Sündmused';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Ligipääsuklahv';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Tsitaat';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klass';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Kuupäev/aeg';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Keel';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Teksti suund';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stiil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Sisujuht';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Pealkiri';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Vasakult paremale';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Paremalt vasakule';
$string['xhtmlxtras_dlg:events_tab'] = 'Sündmused';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elementide atribuudid';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elementide sündmused';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Üldised seaded';
$string['xhtmlxtras_dlg:general_tab'] = 'Üldine';
$string['xhtmlxtras_dlg:insert_date'] = 'Sisesta hetke kuupäev/aeg';
$string['xhtmlxtras_dlg:option_ltr'] = 'Vasakult paremale';
$string['xhtmlxtras_dlg:option_rtl'] = 'Paremalt vasakule';
$string['xhtmlxtras_dlg:remove'] = 'Eemalda';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Elemendi lühend';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Elemendi akronüüm';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Elemendi tsitaat';
$string['xhtmlxtras_dlg:title_del_element'] = 'Elemendi kustutus';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Elemendi sisestus';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Lisandus';
