<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_essential
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alert1'] = 'Прво упозорење';
$string['alert2'] = 'Друго упозорење';
$string['alert3'] = 'Треће упозорење';
$string['alert_general'] = 'Најава';
$string['alert_info'] = 'Информације';
$string['alertsdesc'] = 'Ово ће вашим корисницима приказати упозорење/а на насловној страници Moodlea. Немојте заборавите да их искључите када вам више нису потребна,';
$string['alertsheading'] = 'Упозорења корисницима';
$string['alertsheadingsub'] = 'Прикажите важне поруке вашим корисницима на насловној страници';
$string['alerttext'] = 'Текст упозорења';
$string['alerttextdesc'] = 'Како гласи текст који желите да прикажете у упозорењу.';
$string['alerttitle'] = 'Наслов';
$string['alerttitledesc'] = 'Главни наслов вашег упозорења.';
$string['alerttype'] = 'Ниво';
$string['alerttypedesc'] = 'Подесите одговарајући ниво/тип упозорења како бисте најбоље информисали своје кориснике.';
$string['alert_warning'] = 'Упозорење';
$string['allclasses'] = 'Сви часови';
$string['allcourses'] = 'Сви курсеви';
$string['allmodules'] = 'Сви модули';
$string['allunits'] = 'Све јединице';
$string['alternativecolors'] = 'Алтернативне боје {$a}';
$string['alternativethemecolor'] = 'Алтернативна боја теме {$a}';
$string['alternativethemecolordesc'] = 'Које боје би требало да буде ваша тема за алтернативне боје теме {$a}.';
$string['alternativethemecolorname'] = 'Назив алтернативног скупа боја {$a}';
$string['alternativethemecolornamedesc'] = 'Обезбедите препознатљив назив за овај скуп алтернативних боја теме';
$string['alternativethemecolors'] = 'Алтернативне боје теме';
$string['alternativethemecolorsdesc'] = 'Дефинишите алтернативне боје за вашу тему које корисник може да изабере.';
$string['alternativethemehovercolor'] = 'Алтернативна лебдећа боја теме {$a}';
$string['alternativethemehovercolordesc'] = 'Која боја би требало да буде лебдећа боја у вашој теми за алтернативне боје теме {$a}.';
$string['alternativethemename'] = 'Назив шеме боја';
$string['alternativethemenamedesc'] = 'Обезбедите назив за ваше алтернативне боје теме';
$string['alternativethemetextcolor'] = 'Боја алтернативног текста {$a}';
$string['alternativethemetextcolordesc'] = 'Подесите боју за ваш алтернативни текст {$a}.';
$string['alternativethemeurlcolor'] = 'Боја алтернативног линка {$a}';
$string['alternativethemeurlcolordesc'] = 'Подесите боју за ваш алтернативни линковани текст {$a}.';
$string['alwaysdisplay'] = 'Увек прикажи';
$string['analytics'] = 'Аналитика';
$string['analyticscleanurl'] = 'чисте URL адресе';
$string['analyticscleanurldesc'] = 'Генеришите чисту URL адресу за напредно праћење';
$string['analyticsdesc'] = 'Изаберите алат за Аналитику који желите да уметнете и сачувајте промена како бисте омогућили друге опције.';
$string['analyticsenabled'] = 'Омогућено';
$string['analyticsenableddesc'] = 'Омогући Аналитику за Moodle';
$string['analyticsguniversal'] = 'Google универзална аналитика';
$string['analyticsheadingsub'] = 'Моћна аналитика за Moodle';
$string['analyticsimagetrack'] = 'Праћење слика';
$string['analyticsimagetrackdesc'] = 'Омогућите праћење слика за веб читаче у којима је искључен Javascript';
$string['analyticspiwik'] = 'Piwik';
$string['analyticssiteid'] = 'ID сајта';
$string['analyticssiteiddesc'] = 'Унесите ID вашег сајта';
$string['analyticssiteurl'] = 'URL адреса алата за аналитику';
$string['analyticssiteurldesc'] = 'Унесите URL адресу вашег Piwik Analytics алата без http(s) односно косе црте. На пример "mysite.com/analytics".';
$string['analyticstrackadmin'] = 'Праћење администратора';
$string['analyticstrackadmindesc'] = 'Омогућите праћење активности корисника са администраторским налогом (не препоручује се)';
$string['analyticstrackingid'] = 'ID сајта';
$string['analyticstrackingiddesc'] = 'Унесите свој ID за праћење';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Google Play продавници. Уколико немате своју можете унети адресу бесплатне званичне Moodle Mobile апликације (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['backgroundstylefixed'] = 'Фиксирано';
$string['backgroundstylestretch'] = 'Развучено';
$string['backgroundstyletiled'] = 'Поплочано';
$string['backtotop'] = 'Назад на врх';
$string['badgepreferences'] = 'Беџ (параметри)';
$string['blogpreferences'] = 'Блог (параметри)';
$string['bootstrapcdn'] = 'FontAwesome са CDN система за дистрибуцију садржаја';
$string['bootstrapcdndesc'] = 'Ако је омогућено, ово ће учитати FontAwesome са онлајн Bootstrap CDN система за дистрибуцију садржаја. Омогућите ову опцију уколико имате проблема са приказивањем Font Awesome иконица на свом сајту,';
$string['breadcrumbsimple'] = 'Једноставан';
$string['breadcrumbstyle'] = 'Стил навигационе путање';
$string['breadcrumbstyled'] = 'Елегантан';
$string['breadcrumbstyledesc'] = 'Овде можете да промените стил навигационе путање.';
$string['breadcrumbstylednocollapse'] = 'Елегантан без скупљања';
$string['breadcrumbthin'] = 'Проређен';
$string['cachesused'] = 'Коришћена кеш меморија';
$string['categoryiconcategory'] = 'Иконица за категорију: {$a->category}.';
$string['categoryicondesc'] = 'Ако омогућена ова опција ће вам дозволити да подесите иконице за сваку категорију курса.';
$string['categoryiconheading'] = 'Иконице категорија';
$string['categoryiconheadingsub'] = 'Користите иконице за приказивање ваших категорија';
$string['categoryiconinfo'] = 'Подесите прилагођене иконице категорија';
$string['categoryiconinfodesc'] = 'Унесите назив иконице коју желите да користите. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза "fa-".';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>О теми Essential</h3>
<p>Essential се заснива на теми Bootstrap, која је креирана за Moodle 2.5. Креирање теме су помогли:<br> Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans</p>
<h3>Заслуге за тему</h3>
<p>Оригинални аутор: Julian Ridden<br>
Од јула 2014 развој теме су преузели:<br>
Gareth J. Barnard<br>
David Bezemer<br>
</p>
<h3>Донације</h3>
<p>Ова тема је бесплатна, и уколико желите да  искажете своју захвалност, молимо вас да размотрите могућност слања донације
<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=themmai%40gmail%2ecom&lc=GB&item_name=Essential%20Theme%20Fund&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donate_LG%2egif%3aNonHosted" target="_blank">
тако што ћете кликнути овде.
</a><br>Донације ће нам омогућити да за вас развијемо тему, како са већим бројем тако и са бољим функцијама, за краће време.</p>
</div></div>';
$string['colordesc'] = 'Овде можете наћи различита подешавања за промену многих боја у овој теми.';
$string['colorheading'] = 'Боје';
$string['colorheadingsub'] = 'Подесите боје које се користе у вашој теми';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Контакт информације';
$string['contactinfodesc'] = 'Упишите своје контакт информације';
$string['copyright'] = 'Ауторско право';
$string['copyrightdesc'] = 'Назив ваше институције/организације';
$string['coursegrades'] = 'Оцене на курсу';
$string['customcss'] = 'Прилагођени CSS';
$string['customcssdesc'] = 'Која год CSS правила додате у ово поље за текст, она ће се рефлектовати на све странице, што олакшава прилагођавање ове теме.';
$string['dbqueries'] = 'База података - читање/уписивање';
$string['defaultcategoryicon'] = 'Подразумеване иконице категорија';
$string['defaultcategoryicondesc'] = 'Подесите подразумевану иконицу категорије';
$string['defaultcolors'] = 'Подразумеване боје';
$string['displayafterlogin'] = 'Прикажи само након пријаве на систем';
$string['displaybeforelogin'] = 'Прикажи само пре пријаве на систем';
$string['displaymycourses'] = 'Прикажи уписане курсеве';
$string['displaymycoursesdesc'] = 'Прикажи корисницима у прилагођеном менију курсеве које су уписали';
$string['donate_desc'] = 'Молимо';
$string['donate_desc2'] = 'како бисте помогли даљи развој теме Essential или једноставно изразили своју захвалност.';
$string['donate_title'] = 'Донације за тему Essential';
$string['dontdisplay'] = 'Никад не приказуј';
$string['enablealert'] = 'Укључи упозорења';
$string['enablealertdesc'] = 'Укључи или искључи упозорење';
$string['enablealternativethemecolors'] = 'Омогући алтернативне боје теме {$a}';
$string['enablealternativethemecolorsdesc'] = 'Ако је ова опција омогућена корисник ће моћи да изабере боје теме {$a}';
$string['enablecategoryicon'] = 'Омогући иконице категорија';
$string['enablecategoryicondesc'] = 'Ако је омогућено, моћи ћете да изаберете иконице категорија након што кликнете на "Сачувај промене"';
$string['enablecustomcategoryicon'] = 'Омогући прилагођене иконице категорија';
$string['enablecustomcategoryicondesc'] = 'Ако је ова опција омогућена. испод овог одељка видећете категорије са подесивим опцијама поред сваке категорије. Молимо вас да сачувате промене након што омогућите/онемогућите ову опцију.';
$string['extperfinfoheading'] = 'Информације о додатним перформансама';
$string['facebook'] = 'Facebook URL адреса';
$string['facebookdesc'] = 'Унесите URL адресу ваше Facebook странице (тј.http://www.facebook.com/mojaskola).';
$string['few'] = 'Неколико';
$string['fitvids'] = 'Kористи FitVids';
$string['fitvidsdesc'] = 'Омогућите FitVids (fitvidsjs.com) како би ваши видео снимци били прилагодљиви. Ако је FitVids укључен, и притом желите да видео снимак буде искључен, онда у HTML кôд додајте \'class="fitvidsignore"\' унутар \'iframe\' ознаке. На пример: \'iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe\'.';
$string['fixedwidthnarrow'] = 'Фиксна ширина - Уско';
$string['fixedwidthnormal'] = 'Фиксна ширина - Нормално';
$string['fixedwidthwide'] = 'Фиксна ширина - Широко';
$string['flattr_click'] = 'помоћу сервиса Flattr';
$string['flattr_desc'] = '{$a->url}';
$string['flickr'] = 'Flickr URL адреса';
$string['flickrdesc'] = 'Унесите URL адресу ваше Flickr странице (тј.http://www.flickr.com/mojaskola).';
$string['fontcharacterset'] = 'Додатан скуп карактера Google фонта';
$string['fontcharactersetcyrillic'] = 'Ћирилица';
$string['fontcharactersetcyrillicext'] = 'Проширена ћирилица';
$string['fontcharactersetdesc'] = 'Изаберите додатни скупове карактера за различите језике.
Како коришћење више скупова карактера може да успори ваш Moodle изаберите само оне који су вам стварно потребни.';
$string['fontcharactersetgreek'] = 'Грчки алфабет';
$string['fontcharactersetgreekext'] = 'Проширени грчки алфабет';
$string['fontcharactersetlatinext'] = 'Проширена латиница';
$string['fontcharactersetvietnamese'] = 'Вијетнамски';
$string['fontfileeotbody'] = 'Датотека основног EOT фонта';
$string['fontfileeotheading'] = 'Датотека EOT фонта наслова';
$string['fontfileotfbody'] = 'Датотека основног OTF фонта';
$string['fontfileotfheading'] = 'Датотека OTF фонта наслова';
$string['fontfiles'] = 'Датотеке фонтова';
$string['fontfilesdesc'] = 'Поставите овде своје датотеке фонтова.';
$string['fontfilesvgbody'] = 'Датотека основног SVG фонта';
$string['fontfilesvgheading'] = 'Датотека SVG фонта наслова';
$string['fontfilettfbody'] = 'Датотека основног TTF фонта';
$string['fontfilettfheading'] = 'Датотека TTF фонта наслова';
$string['fontfilewoffbody'] = 'Датотека основног WOFF фонта';
$string['fontfilewoffheading'] = 'Датотека WOFF фонта наслова';
$string['fontfilewofftwobody'] = 'Датотека основног WOFF2 фонта';
$string['fontfilewofftwoheading'] = 'Датотека WOFF2 фонта наслова';
$string['fontheadingdesc'] = 'Изаберите и унесите фонтове које желите да користите у свом Moodle окружењу.';
$string['fontheadingsub'] = 'Подешавања фонта';
$string['fontnamebody'] = 'Фонт текста';
$string['fontnamebodydesc'] = 'Унесите тачан назив фонта који желите да користите за сав остали текст';
$string['fontnameheading'] = 'Фонт наслова';
$string['fontnameheadingdesc'] = 'Унесите тачан назив фонта који желите да користите за наслове';
$string['fontselect'] = 'Бирач типа фонта';
$string['fontselectdesc'] = 'Изаберите са списка доступних типова фонтова. Молимо сачувајте како би се приказале опције за тип фонта који сте изабрали';
$string['fontsettings'] = 'Фонт';
$string['fonttypecustom'] = 'Нестандардни фонт';
$string['fonttypegoogle'] = 'Google  веб фонтови';
$string['fonttypestandard'] = 'Стандардни фонтови';
$string['footercolor'] = 'Боја позадине подножја';
$string['footercolordesc'] = 'Подесите боју позадине региона који се налази у подножју странице';
$string['footercolors'] = 'Боје подножја';
$string['footercolorsdesc'] = 'Промените боје подножја странице';
$string['footerheading'] = 'Подножје странице';
$string['footerheadingcolor'] = 'Боја наслова у подножју странице';
$string['footerheadingcolordesc'] = 'Подесите боју за наслове блокова у подножју странице.';
$string['footerhovercolor'] = 'Боја лебдећих линкова у подножју странице';
$string['footerhovercolordesc'] = 'Подесите боју за линковани текст у подножја странице приликом преласка мишем преко њега.';
$string['footersepcolor'] = 'Боја сепаратора у подножју странице';
$string['footersepcolordesc'] = 'Сепаратори су линије које се користе да би се раздвојио садржај. Овде подесите боју за сепараторе.';
$string['footertextcolor'] = 'Боја текста у подножју странице';
$string['footertextcolordesc'] = 'Подесите боју којом желите да буде приказан текст у подножју странице.';
$string['footerurlcolor'] = 'Боја линка у подножју странице';
$string['footerurlcolordesc'] = 'Подесите боју за ваш линковани текст у подножју странице.';
$string['footnote'] = 'Подножје';
$string['footnotedesc'] = 'Садржај овог поља за текст биће приказан у подножју сваке странице вашег Moodle сајта.';
$string['frontcontent'] = 'Омогући текстуални блок на насловној страници';
$string['frontcontentarea'] = 'Садржај текстуалног блока на насловној страници';
$string['frontcontentareadesc'] = 'Садржај који унесете у овај текстуални блок биће приказан читавом ширином насловне странице у простору који се налази између слајд презентације и промотивних блокова.';
$string['frontcontentdesc'] = 'Ако је омогућено, ово додаје текстуални блок за ваш наменски прилагођени садржај, смештен између слајд презентације и промотивних блокова.';
$string['frontcontentheading'] = 'Текстуални блок на насловној страници';
$string['frontpageblocks'] = 'Поравнање блокова на насловној страници';
$string['frontpageblocksdesc'] = 'Овде можете да одредите да ли су блокови на насловној страници поравнати на лево или десно.';
$string['frontpageblocksheading'] = 'Блокови насловне странице';
$string['frontpageheading'] = 'Насловна страница';
$string['frontpageheadingdesc'] = 'Подесите овде које додатне ставке желите да прикажете на насловној страници.';
$string['frontpagemiddleblocks'] = 'Омогући средишње блокове на насловној страници';
$string['frontpagemiddleblocksdesc'] = 'Ако је омогућена, ова опција ће приказати 3 нова блока одмах испод промотивних блокова';
$string['fullname'] = 'Пун назив сајта';
$string['fullnamesummary'] = 'Пун назив сајта и резиме';
$string['generalheadingdesc'] = 'Конфигуришите овде глобална подешавања теме. Пронаћићете опције за дозајн и визуелни идентитет странице.';
$string['generalheadingsub'] = 'Општа подешавања';
$string['genericsettings'] = 'Опште';
$string['googleplus'] = 'Google+ URL адреса';
$string['googleplusdesc'] = 'Унесите URL адресу вашег Google+ профила (тј.http://plus.google.com/+mojaskola).';
$string['headerheading'] = 'Заглавље';
$string['headertitle'] = 'Наслов заглавља';
$string['headertitledesc'] = 'Подесите овде наслов који ће се појавити у заглављу';
$string['helplink'] = 'Линк за помоћ';
$string['helplinkdesc'] = 'Ако сте претходно изабрали опцију "URL адреса" унесите комплетну URL адресу сајта са помоћним информацијама (адреса мора да садржи префикс http:// или https://). Ако сте изабрали опцију "E-адреса" унесите своју електронску адресу.';
$string['helplinktype'] = 'Омогући линк за помоћ у менију';
$string['helplinktypedesc'] = 'Изаберите да ли желите да омогућите опцију за помоћи у корисничком менију, Можете да бирате између URL адресе сајта са помоћним информације, који ће се отварати у новом прозору, и електронске адресе.';
$string['hideonphone'] = 'Сакриј слајд-шоу на мобилним уређајима';
$string['hideonphonedesc'] = 'Изаберите да ли желите да онемогућите слајд-шоу на мобилним уређајима.';
$string['hideontablet'] = 'Сакриј слајд-шоу на мобилним таблетима';
$string['hideontabletdesc'] = 'Изаберите да ли желите да онемогућите слајд-шоу на таблетима.';
$string['included'] = 'Датотеке укључене';
$string['instagram'] = 'Instagram URL адреса';
$string['instagramdesc'] = 'Унесите URL адресу ваше Instagram странице (тј. http://web.stagram.com/mojaskola/)';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Apple App продавници. Уколико немате своју можете унети адресу бесплатне званичне мобилне апликације за Moodle (https://itunes.apple.com/en/app/moodle-mobile/id633359593)..';
$string['iosicon'] = 'Иконице iOS почетног екрана';
$string['iosicondesc'] = 'Тема обезбеђује стандардне иконице за iOS и Android почетне екране. Ако желите можете поставити своје прилагођене иконице.';
$string['ipadicon'] = 'iPad иконица (Non Retina)';
$string['ipadicondesc'] = 'Иконица треба да буде PNG датотека величине 72 x 72 пиксела.';
$string['ipadretinaicon'] = 'iPad иконица (Retina)';
$string['ipadretinaicondesc'] = 'Иконица треба да буде PNG датотека величине 144 x 144 пиксела.';
$string['iphoneicon'] = 'iPhone/iPod Touch иконица (Non Retina)';
$string['iphoneicondesc'] = 'Иконица треба да буде PNG датотека величине 57 x 57 пиксела.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch иконица (Retina)';
$string['iphoneretinaicondesc'] = 'Иконица треба да буде PNG датотека величине 114 x 114 пиксела.';
$string['layout'] = 'Користи стандардни изглед курса';
$string['layoutdesc'] = 'Ова теме је дизајнирана тако да оба ступца са блоковима поставља са десне стране. Уколико преферирате стандардни изглед Moodle курсева можете да означите ово поље за потврду како бисте користили стари изглед курса са три ступца.';
$string['left'] = 'Лево';
$string['linkedin'] = 'LinkedIn URL адреса';
$string['linkedindesc'] = 'Унесите URL адресу вашег LinkedIn профила (тј.http://www.linkedin.com/company/mojaskola).';
$string['loadtime'] = 'Време учитавања';
$string['loggedinas'] = 'пријављен на систем као';
$string['loggedinfrom'] = 'Пријављен на систем са';
$string['logo'] = 'Логотип';
$string['logodesc'] = 'Поставите овде свој прилагођени логотип ако желите да га додате у заглавље.
<br>Слика треба да буде 65px висине и било које разумне ширине која је одговарајућа.
<br>Ако поставите логотип он ће заменити иконицу и назив који се стандардно приказују.';
$string['marketing1'] = 'Промотивни блок један';
$string['marketing2'] = 'Промотивни блок два';
$string['marketing3'] = 'Промотивни блок три';
$string['marketingbuttontext'] = 'Текст линка';
$string['marketingbuttontextdesc'] = 'Текст који се појављује на дугмету';
$string['marketingbuttonurl'] = 'URL адреса линка';
$string['marketingbuttonurldesc'] = 'URL адреса са којом је дугме повезано';
$string['marketingcontent'] = 'Садржај';
$string['marketingcontentdesc'] = 'Текст који се приказује у промотивном блоку. Треба да буде кратак и занимљив.';
$string['marketingdesc'] = 'Ова тема пружа опцију да на насловној страници поставите три промотивна блока или огласа, одмах испод слајд-шоу презентације. Ово вам омогућава да својим корисницима лако назначите најбитније информације и обезбедите одговарајуће директне линкове.';
$string['marketingheading'] = 'Промотивни блокови';
$string['marketingheadingsub'] = 'Три места на насловној страници сајта за додатне информације и линкове.';
$string['marketingheight'] = 'Висина слика у промотивним блоковима';
$string['marketingheightdesc'] = 'Ако желите да прикажете слике у промотивним блоковима овде можете да одредите њихову висину.';
$string['marketingicon'] = 'Иконица';
$string['marketingicondesc'] = 'Назив иконице коју желите да користите. <br> Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза  "fa-",", нпр.  "star".';
$string['marketingimage'] = 'Слика';
$string['marketingimagedesc'] = 'Ово пружа могућност приказивања слике изнад текста у промотивном блоку';
$string['marketinginfodesc'] = 'Унесите подешавања за ваш промотивни блок.';
$string['marketingtitle'] = 'Наслов';
$string['marketingtitledesc'] = 'Наслов који ће бити приказан у овом промотивном блоку';
$string['marketingurltarget'] = 'Одредиште линка';
$string['marketingurltargetdesc'] = 'Изаберите како линк треба да буде отворен';
$string['marketingurltargetnew'] = 'Нова страница';
$string['marketingurltargetparent'] = 'Матични оквир';
$string['marketingurltargetself'] = 'Текућа страница';
$string['memused'] = 'Коришћена меморија';
$string['messagepreferences'] = 'Поруке (параметри)';
$string['mobileappsdesc'] = 'Да ли имате веб апликацију у Apple App или Google Play продавници? Унесите овде линк како би ваши корисници могли да преузму апликације онлајн.';
$string['mobileappsheading'] = 'Мобилне апликације';
$string['mobileappsheadingsub'] = 'Линк ка вашој апликација за студенте који користе мобилне уређаје.';
$string['myclasses'] = 'Моји часови';
$string['mycourses'] = 'Моји курсеви';
$string['mycoursesinfo'] = 'Мени уписаних курсева';
$string['mycoursesinfodesc'] = 'Приказује корисницима динамички списак уписаних курсева';
$string['mycoursetitle'] = 'Терминологија';
$string['mycoursetitledesc'] = 'Промените терминологију за линк "Моји курсеви" у падајућем менију';
$string['mygrades'] = 'Моје оцене';
$string['mymodules'] = 'Моји модули';
$string['myunits'] = 'Моје јединице';
$string['navbartitle'] = 'Наслов траке за навигацију';
$string['navbartitledesc'] = 'Подесите овде наслов који ће се појавити у таци за навигацију';
$string['nextsection'] = 'Следећа секција';
$string['nobreadcrumb'] = 'Сакриј';
$string['noenrolments'] = 'Тренутно немате уписе';
$string['nomessagesfound'] = 'Није пронађена ниједна порука';
$string['noslidetitle'] = 'Нема наслова за слајд {$a->slide}';
$string['notitle'] = 'Без наслова';
$string['numberofslides'] = 'Број слајдова';
$string['numberofslides_desc'] = 'Број слајдова у оквиру слајд презентације.';
$string['oldnavbar'] = 'Користи стари положај навигационе траке';
$string['oldnavbardesc'] = 'Омогућите ову опцију како бисте користили стари положај навигационе траке.';
$string['pagebackground'] = 'Позадинска слика странице';
$string['pagebackgrounddesc'] = 'Поставите сопствену позадинску слику. Изаберите стил слике.';
$string['pagebackgroundstyle'] = 'Стил позадине странице';
$string['pagebackgroundstyledesc'] = 'Изаберите стил постављене слике';
$string['pagewidth'] = 'Подеси ширину станице';
$string['pagewidthdesc'] = 'Изаберите са списка доступних ширина странице за ваш сајт';
$string['paypal_click'] = 'пошаљите донацију помоћу сервиса PayPal';
$string['paypal_desc'] = '{$a->url} или';
$string['peakmem'] = 'Максимум оптерећења меморије';
$string['perfinfo'] = 'Информације о перформансама';
$string['perfinfodesc'] = 'Многим сајтовима нису потребне детаљне информације о перформансама, посебно када се посматра из угла корисника. Када је омогућено, ово приказује основне информације о учитавању странице.';
$string['perfinfoheading'] = 'Информације о перформансама';
$string['perf_max'] = 'Детаљно';
$string['perf_min'] = 'Минимално';
$string['pinterest'] = 'Pinterest URL адреса';
$string['pinterestdesc'] = 'Унесите URL адресу ваше Pinterest странице (тј.http://pinterest.com/mojaskola).';
$string['pluginname'] = 'Essential';
$string['previoussection'] = 'Претходна секција';
$string['profilebarcustomtitle'] = 'Трака профила - наслов прилагођеног блок';
$string['profilebarcustomtitledesc'] = 'Наслов за прилагођени блок са траком профила';
$string['readme_click'] = 'кликните за README.txt';
$string['readme_desc'] = 'Молимо {$a->url} датотеку која садржи више информација о теми Essential.';
$string['readme_title'] = 'Essential read-me датотека са упутством';
$string['readmore'] = 'Прочитај више';
$string['region-footer-left'] = 'Подножје (лево)';
$string['region-footer-middle'] = 'Подножје (средина)';
$string['region-footer-right'] = 'Подножје (десно)';
$string['region-hidden-dock'] = 'Сакривено од корисника';
$string['region-home-left'] = 'Почетна страница (лево)';
$string['region-home-middle'] = 'Почетна страница (средина)';
$string['region-home-right'] = 'Почетна страница (десно)';
$string['region-side-post'] = 'Десно';
$string['region-side-pre'] = 'Лево';
$string['right'] = 'Десно';
$string['serverload'] = 'Оптерећење сервера';
$string['sessionsize'] = 'Величина сесије';
$string['shortname'] = 'Скраћени назив сајта';
$string['shortnamesummary'] = 'Скраћени назив  и резиме';
$string['siteicon'] = 'Иконица сајта';
$string['siteicondesc'] = 'Немате свој лого? Унесите назив иконице коју желите да користите. Списак иконица можете наћи <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">овде</a>. Унесите само оно што следи иза "fa-".';
$string['skype'] = 'Skype налог';
$string['skypedesc'] = 'Унесите корисничко име за Skype налог ваше институције/организације.';
$string['slidebuttoncolor'] = 'Боја дугмета на слајду';
$string['slidebuttoncolordesc'] = 'Које боје треба да буде навигационо дугме на слајду.';
$string['slidebuttonhovercolor'] = 'Лебдећа боја дугмета на слајду';
$string['slidebuttonhovercolordesc'] = 'Које боје треба да буде лебдећа боја навигационог дугмета на слајду.';
$string['slidecaption'] = 'Опис слајда';
$string['slidecaptionbelow'] = 'Опис слајда испод слике';
$string['slidecaptionbelowdesc'] = 'Да ли опис слајда треба да буде испод слике';
$string['slidecaptioncentred'] = 'Опис слајда центриран';
$string['slidecaptioncentreddesc'] = 'Да ли опис слјда треба да буде на средини';
$string['slidecaptiondesc'] = 'Унесите текст који ће се користити за опис слајда';
$string['slidecolor'] = 'Боја текста слајда';
$string['slidecolordesc'] = 'Које боје треба да буде текст описа слајда';
$string['slideimage'] = 'Слика слајда';
$string['slideimagedesc'] = 'Најбоље је користити транспарентну слику.';
$string['slideinterval'] = 'Интервал између слајдова';
$string['slideintervaldesc'] = 'Време преласка са једног на други слајд у милисекундама.';
$string['slideno'] = 'Слајд {$a->slide}';
$string['slidenodesc'] = 'Унесите подешавања за слајд {$a->slide}.';
$string['slideshowdesc'] = 'Ово креира динамички слајд-шоу од максимално 16 слајдова за промовисање важних ствари на вашем сајту. Слајд-шоу је прилагодљив тако да се висина слике подешава према величини екрана. Препоручена висина је 300 пиксела. Ширина је подешена на 100 % па ће зато стварна висина слике бити мања ако је ширина већа од величине екрана. На екранима мање величине, висина се динамички смањује, без потребе да се обезбеде засебне слике. За екране чија је ширина мања од 767 пиксела висина ће бити165 пиксела, за екране чија је ширина између 768 и 979 пиксела, висина ће бити 225пиксела, док ће за екране ширине веће од 980 пиксела висина бити 300 пиксела. Ако је није изабрана ниједна слика за слајд, онда ће се користити слика default_slide која се налази у фолдеру pix.';
$string['slideshowheading'] = 'Слајд-шоу';
$string['slideshowheadingsub'] = 'Динамички слајд-шоу на насловној страници';
$string['slidetitle'] = 'Наслов слајда';
$string['slidetitledesc'] = 'Унесите описни наслов за ваш слајд';
$string['slideurl'] = 'Линк слајда';
$string['slideurldesc'] = 'Унесите циљно одредиште линка прве слике слајда';
$string['slideurltarget'] = 'Одредиште линка';
$string['slideurltargetdesc'] = 'Изаберите како линк треба да буде отворен';
$string['slideurltargetnew'] = 'Нова страница';
$string['slideurltargetparent'] = 'Матични оквир';
$string['slideurltargetself'] = 'Текућа страница';
$string['socialdesc'] = 'Унесите директне линкове ка главним друштвеним мрежама како бисте промовисали свој сајт. Ови линкови ће се појављивати у заглављу сваке странице.';
$string['socialheading'] = 'Друштвене мреже';
$string['socialheadingsub'] = 'Анимирајте своје кориснике путем друштвених мрежа';
$string['socialnetworks'] = 'Друштвене мреже';
$string['themecolor'] = 'Боја теме';
$string['themecolordesc'] = 'Које боје треба да буде ваша тема? Ово ће променити бројне компоненте како бисте користили боју коју желите на читавом сајту.';
$string['themecolors'] = 'Боје теме';
$string['themehovercolor'] = 'Боја лебдећих линкова теме';
$string['themehovercolordesc'] = 'Која боје треба да буде лебдећа боја у вашој теми. Она се користи за линкове, меније итд.';
$string['themeiconcolor'] = 'Боја иконица';
$string['themeiconcolordesc'] = 'Подесите боју за све иконице';
$string['themenavcolor'] = 'Боја навигације';
$string['themenavcolordesc'] = 'Подесите боју за навигацију, имајући у виду навигациону траку и елегантни стил навигационе путање.';
$string['themetextcolor'] = 'Боја текста';
$string['themetextcolordesc'] = 'Подесите боју за ваш текст.';
$string['themeurlcolor'] = 'Боја линка';
$string['themeurlcolordesc'] = 'Подесите боју за ваш линковани текст.';
$string['togglemarketing'] = 'Прекидач за приказ промотивних блокова';
$string['togglemarketingdesc'] = 'Изаберите да ли желите да сакријете или прикажете три промотивна блока.';
$string['toggleslideshow'] = 'Слајд-шоу - прекидач приказа';
$string['toggleslideshowdesc'] = 'Изаберите да ли желите да сакријете или прикажете слајд-шоу.';
$string['twitter'] = 'Twitter URL адреса';
$string['twitterdesc'] = 'Унесите URL адресу ваше Twitter странице (тј.http://www.twitter.com/mojaskola).';
$string['unreadnewnotification'] = 'Ново обавештење';
$string['usecategoryicon'] = 'Омогући иконице категорија';
$string['usecategoryicondesc'] = 'Користи прилагођене иконице за категорије';
$string['variablewidth'] = 'Променљива ширина';
$string['visibleadminonly'] = 'Блокови премештени у доњи регион биће видљиви само администраторима';
$string['vk'] = 'VKontakte URL адреса';
$string['vkdesc'] = 'Унесите URL адресу ваше Vkontakte странице (тј.http://www.vk.com/mojaskola).';
$string['website'] = 'URL адреса веб сајта';
$string['websitedesc'] = 'Унесите URL адресу вашег главног веб сајта (тј. http://www.mojfakultet.ac.rs или http://www.mojaskola.edu.rs)';
$string['windows'] = 'Windows стони рачунар';
$string['windowsdesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Windows продавници. Уколико немате своју можете унети адресу бесплатне званичне мобилне апликације за Moodle (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc).';
$string['winphone'] = 'Windows мобилни уређај';
$string['winphonedesc'] = 'Унесите URL адресу за вашу мобилну апликацију у Google Play продавници. Уколико немате своју можете унети адресу бесплатне званичне мобилне апликације за Moodle (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc).';
$string['youtube'] = 'YouTube URL адреса';
$string['youtubedesc'] = 'Унесите URL адресу вашег YouTube канала (тј.http://www.youtube.com/mojaskola).';
