<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'ће управо бити инсталирано';
$string['action'] = 'Акција';
$string['actionchoice'] = 'Шта желите да урадите са датотеком \'{$a}\'?';
$string['actions'] = 'Акције';
$string['active'] = 'Активан';
$string['activeusers'] = 'Активни корисници';
$string['activities'] = 'Активности';
$string['activities_help'] = 'Активности, као што су форуми, тестови и вики документи омогућавају да курсу буде додат интерактивни садржај.';
$string['activity'] = 'Активност';
$string['activityclipboard'] = 'Премештање ове активности: {$a}';
$string['activityiscurrentlyhidden'] = 'Нажалост, ова активност тренутно није доступна';
$string['activitymodule'] = 'Модул активности';
$string['activitymodules'] = 'Модули активности';
$string['activityreport'] = 'Извештај о активности';
$string['activityreports'] = 'Извештаји о активностима';
$string['activityselect'] = 'Одаберите ову активност како бисте је преместили на другу локацију';
$string['activitysince'] = 'Активност од {$a}';
$string['activityweighted'] = 'Активност по кориснику';
$string['add'] = 'Додај';
$string['addactivity'] = 'Додај активност...';
$string['addactivitytosection'] = 'Додај активност у секцију \'{$a}\'';
$string['addadmin'] = 'Додај администратора';
$string['addblock'] = 'Додај блок';
$string['addcomment'] = 'Додај коментар...';
$string['addcountertousername'] = 'Креирај корисника додавањем броја корисничком имену';
$string['addcreator'] = 'Додај креатора курса';
$string['adddots'] = 'Додај...';
$string['added'] = 'Додато {$a}';
$string['addedrecip'] = 'Додат је нови прималац: {$a}';
$string['addedrecips'] = 'Број нових прималаца: {$a}';
$string['addedtogroup'] = 'Додат(а) групи "{$a}"';
$string['addedtogroupnot'] = 'Није додат(а) групи "{$a}"';
$string['addedtogroupnotenrolled'] = 'Није додат(а) групи {$a}, јер није уписан(а) на курс';
$string['addfilehere'] = 'Додај датотеку/е овде';
$string['addinganew'] = 'Додавање активности: {$a}';
$string['addinganewto'] = 'Додавање активности у {$a->to}';
$string['addingdatatoexisting'] = 'Додавање података постојећим';
$string['additionalnames'] = 'Додатна имена';
$string['addlinkhere'] = 'Додај линк овде';
$string['addnewcategory'] = 'Додај нову категорију';
$string['addnewcourse'] = 'Додај нови курс';
$string['addnewuser'] = 'Додај новог корисника';
$string['addnousersrecip'] = 'Додавање корисника који није приступио овоме {$a} на листу прималаца';
$string['addpagehere'] = 'Додај текст овде';
$string['addresource'] = 'Додај ресурс...';
$string['addresourceoractivity'] = 'Додај активност или ресурс';
$string['addresourcetosection'] = 'Додај ресурс у секцију \'{$a}\'';
$string['address'] = 'Адреса';
$string['addstudent'] = 'Додај полазника';
$string['addsubcategory'] = 'Додај поткатегорију';
$string['addteacher'] = 'Додај предавача';
$string['admin'] = 'Администрација';
$string['adminhelpaddnewuser'] = 'Ручно креирање новог корисничког налога';
$string['adminhelpassignadmins'] = 'Администратори имају потпуна овлашћења на овом сајту';
$string['adminhelpassigncreators'] = 'Креатори могу креирати нове курсеве и предавати унутар истих';
$string['adminhelpassignsiteroles'] = 'Примена дефинисаних улога на сајту на специфициране кориснике';
$string['adminhelpassignstudents'] = 'Идите на курс и додајте нове полазнике из администраторског менија';
$string['adminhelpauthentication'] = 'Можете користити интерне корисничке налоге или екстерне базе података';
$string['adminhelpbackup'] = 'Конфигуришите аутоматско креирање резервних копија и временски распоред њиховог извршавања';
$string['adminhelpconfiguration'] = 'Конфигуришите како сајт изгледа и функционише';
$string['adminhelpconfigvariables'] = 'Конфигуришите променљиве које утичу на општу функционалност сајта';
$string['adminhelpcourses'] = 'Одредите курсеве и категорије и упишите полазнике у њих, уредите курсеве на чекању';
$string['adminhelpeditorsettings'] = 'Дефинишите основна подешавања HTML едитора';
$string['adminhelpedituser'] = 'Претражите листу корисничких налога и уредите било који од њих';
$string['adminhelpenvironment'] = 'Проверите како Ваш сервер задовољава тренутне и будуће предуслове за успешну инсталацију';
$string['adminhelpfailurelogs'] = 'Прегледајте записе о неуспешним пријавама на систем';
$string['adminhelplanguage'] = 'Провера и уређивање важећег језичког пакета';
$string['adminhelplogs'] = 'Прегледајте записе о свим активностима на сајту';
$string['adminhelpmanageblocks'] = 'Управљање инсталираним блоковима и њиховим подешавањима';
$string['adminhelpmanagedatabase'] = 'Директно приступите бази података (али опрезно!)';
$string['adminhelpmanagefilters'] = 'Избор текстуалних филтера и њихова подешавања';
$string['adminhelpmanagemodules'] = 'Управљање инсталираним модулима и њиховим подешавањима';
$string['adminhelpmanageroles'] = 'Креирање и дефинисање улога које се могу применити на кориснике';
$string['adminhelpmymoodle'] = 'Конфигуришите "Мој Moodle" блокове за кориснике';
$string['adminhelpreports'] = 'Извештаји на нивоу сајта';
$string['adminhelpsitefiles'] = 'Служи за објављивање општих датотека или постављање резервних копија';
$string['adminhelpsitesettings'] = 'Дефинишите како изгледа почетна страница сајта';
$string['adminhelpstickyblocks'] = 'Конфигуришите фиксне блокове на читавом сајту';
$string['adminhelpthemes'] = 'Изаберите како да изгледа сајт (боје, фонтови и сл.)';
$string['adminhelpuploadusers'] = 'Увезите нове корисничке налоге из текстуалне датотеке';
$string['adminhelpusers'] = 'Одредите своје кориснике и подесите начин провере идентитета';
$string['adminhelpxmldbeditor'] = 'Интерфејс за уређивање XMLDB датотека. Само за кориснике са уређивачким правима.';
$string['administration'] = 'Администрација';
$string['administrationsite'] = 'Администрација сајта';
$string['administrator'] = 'Администратор';
$string['administratordescription'] = 'Администратори обично могу да раде шта год желе у оквиру сајта, на било ком курсу.';
$string['administrators'] = 'Администратори';
$string['administratorsall'] = 'Сви администратори';
$string['administratorsandteachers'] = 'Администратори и предавачи';
$string['advanced'] = 'Напредно';
$string['advancedfilter'] = 'Напредно претраживање';
$string['advancedsettings'] = 'Напредна подешавања';
$string['afterresource'] = 'После ресурса "{$a}"';
$string['aftersection'] = 'После секције "{$a}"';
$string['again'] = 'поново';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX и Javascript';
$string['all'] = 'Све';
$string['allactions'] = 'Све акције';
$string['allactivities'] = 'Све активности';
$string['allcategories'] = 'Све категорије';
$string['allchanges'] = 'Све промене';
$string['alldays'] = 'Сви дани';
$string['allfieldsrequired'] = 'Сва поља су обавезна';
$string['allfiles'] = 'Све датотеке';
$string['allgroups'] = 'Све групе';
$string['alllogs'] = 'Сви записи о активностима';
$string['allmods'] = 'Сви {$a}';
$string['allow'] = 'Дозволити';
$string['allowinternal'] = 'Дозволити и интерне начине ауторизације';
$string['allownone'] = 'Не дозволити ништа';
$string['allownot'] = 'Не дозволити';
$string['allparticipants'] = 'Сви учесници';
$string['allteachers'] = 'Сви предавачи';
$string['alphanumerical'] = 'Може једино да садржи алфанумеричке карактере (слова и бројеве), цртицу (-) или тачку (.)';
$string['alreadyconfirmed'] = 'Регистрација је већ потврђена';
$string['alternatename'] = 'Алтернативно име';
$string['always'] = 'Увек';
$string['and'] = '{$a->one} и {$a->two}';
$string['answer'] = 'Одговор';
$string['any'] = 'Било које';
$string['appearance'] = 'Изглед';
$string['approve'] = 'Одобри';
$string['areyousure'] = 'Да ли сте сигурни?';
$string['areyousuretorestorethis'] = 'Желите ли да наставите?';
$string['areyousuretorestorethisinfo'] = 'Током овог поступка моћи ћете одабрати да ли желите да додате ову датотеку са резервним копијама већ постојећем курсу или да креирате потпуно нови курс.';
$string['asc'] = 'Растући';
$string['assessment'] = 'Процена';
$string['assignadmins'] = 'Одређивање администратора';
$string['assigncreators'] = 'Одређивање креатора';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Одређивање улога на нивоу сајта';
$string['authenticateduser'] = 'Ауторизовани корисник';
$string['authenticateduserdescription'] = 'Сви тренутно пријављени корисници';
$string['authentication'] = 'Провера идентитета';
$string['authenticationplugins'] = 'Додаци за аутентикацију';
$string['autosubscribe'] = 'Аутоматска пријава на форум';
$string['autosubscribeno'] = 'Не: не желим аутоматску пријаву на форуме';
$string['autosubscribeyes'] = 'Да: кад пошаљем поруку, пријави ме на тај форум';
$string['availability'] = 'Доступност';
$string['availablecourses'] = 'Доступни курсеви';
$string['back'] = 'Назад';
$string['backto'] = 'Назад на {$a}';
$string['backtocourselisting'] = 'Повратак на листу курсева';
$string['backtopageyouwereon'] = 'Повратак на страницу на којој сте били';
$string['backtoparticipants'] = 'Повратак на листу учесника';
$string['backup'] = 'Креирање резервне копије';
$string['backupactivehelp'] = 'Изаберите да ли треба или не треба аутоматски креирати резервне копије.';
$string['backupcancelled'] = 'Креирање резервне копије је отказано';
$string['backupcoursefileshelp'] = 'Ако је ово подешавање омогућено,  датотеке курса ће бити укључене у аутоматски креиране резервне копије';
$string['backupdate'] = 'Датум креирања резервне копије';
$string['backupdatenew'] = '&nbsp; {$a->TAG} сада је {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} био је {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Детаљи о резервној копији';
$string['backupexecuteathelp'] = 'Изаберите време за аутоматско креирање резервних копија.';
$string['backupfailed'] = 'Неки од Ваших курсева нису сачувани!';
$string['backupfilename'] = 'резервна копија';
$string['backupfinished'] = 'Креирање резервне копије је успешно завршено';
$string['backupfromthissite'] = 'Да ли је резервна копија креирана на овом сајту?';
$string['backupgradebookhistoryhelp'] = 'Ако је ово подешавање омогућено, онда ће историја књиге оцена бити укључена у аутоматску резервну копију. Имајте у виду, да историја оцена не сме бити онемогућена у подешавањима сервера (disablegradehistory) како би ово могло да функционише.';
$string['backupincludemoduleshelp'] = 'Одаберите желите ли у аутоматску процедуру креирања резервних копија да укључите и модуле курса, са или без корисничких података';
$string['backupincludemoduleuserdatahelp'] = 'Изаберите да ли желите да укључите податке корисника модула у аутоматски креиране резервне копије.';
$string['backupkeephelp'] = 'Колики број скорашњих резервних копија за сваки курс желите да чувате? (Старије копије биће аутоматски обрисане по истеку наведеног рока)';
$string['backuplogdetailed'] = 'Детаљни извештај о извршавању';
$string['backuploglaststatus'] = 'Извештај о последњем извршавању';
$string['backupmissinguserinfoperms'] = 'Напомена: ова резервна копија података не садржи корисничке податке. Активности као што су Вежба и Радионица неће бити укључене у резервну копију, с обзиром да ови модули нису компатибилни са овим типом резервне копије података.';
$string['backupnext'] = 'Следећа резервна копија';
$string['backupnonisowarning'] = 'Упозорење: ова резервна копија је креирана у верзији Moodle система која није подржавала Unicode (пре верзије 1.6). Ако ова резервна копија садржи текстове који се не слажу са ISO-8859-1 може бити ОШТЕЋЕНА ако покушате да је рестаурирате у овој Unicode Moodle верзији. Погледајте <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>за више информација о томе како да правилно урадите опоравак ове резервне копије.';
$string['backupnotyetrun'] = 'Аутоматска резервна копије на чекању';
$string['backuporiginalname'] = 'Назив резервне копије';
$string['backuproleassignments'] = 'Направи резервну копију доделе ових улога';
$string['backupsavetohelp'] = 'Пуна путања до директоријума у којем желите да сачувате датотеке са резервним копијама<br /> (оставите ово поље празно како бисте податке сачували у подразумевани директоријум за чување свих података везаних за овај курс)';
$string['backupsitefileshelp'] = 'Ако је ово подешавање омогућено, онда ће датотеке сајта коришћене у курсевима бити укључени у аутоматску резервну копију.';
$string['backuptakealook'] = 'Молимо прегледајте своје извештаје о креирању резервних копија у: {$a}';
$string['backupuserfileshelp'] = 'Одаберите да ли би требало да се корисничке датотеке (нпр. слике за личне профиле корисника) укључе у аутоматски креиране резервне копије';
$string['backupversion'] = 'Верзија резервне копије';
$string['badges'] = 'Беџеви';
$string['block'] = 'Блок';
$string['blockconfiga'] = 'Конфигурисање блока {$a}';
$string['blockconfigbad'] = 'Овај блок није правилно имплементиран и зато не можете користити конфигурациони интерфејс';
$string['blocks'] = 'Блокови';
$string['blocksaddedit'] = 'Додај/Уреди блокове';
$string['blockseditoff'] = 'Искључи уређивање блокова';
$string['blocksediton'] = 'Укључи уређивање блокова';
$string['blocksetup'] = 'Подешавање табела блокова';
$string['blocksuccess'] = '{$a} табела је исправно подешена';
$string['brief'] = 'Укратко';
$string['bulkactions'] = 'Масовне акције';
$string['bulkactionselect'] = 'Одабир збирне акције {$a}';
$string['bulkmovecoursessuccess'] = 'Успешно је премештено {$a->courses} курс(ев)а у {$a->category}';
$string['bycourseorder'] = 'Поредак по курсевима';
$string['byname'] = 'од {$a}';
$string['bypassed'] = 'Избегнуто';
$string['cachecontrols'] = 'Контрола кеширања';
$string['cancel'] = 'Одустани';
$string['cancelled'] = 'Отказано';
$string['categories'] = 'Категорије курсева';
$string['categoriesandcoures'] = 'Категорије курсева и курсеви';
$string['category'] = 'Категорија';
$string['categoryadded'] = 'Додата је категорија \'{$a}\'';
$string['categorybulkaction'] = 'Масовне акције за изабране категорије';
$string['categorycontents'] = 'Подкатегорије и курсеви';
$string['categorycurrentcontents'] = 'Садржаји категорије {$a}';
$string['categorydeleted'] = 'Обрисана је категорија \'{$a}\'';
$string['categoryduplicate'] = 'Категорија под називом \'{$a}\' већ постоји';
$string['categorymodifiedcancel'] = 'Категорија је измењена! Молимо Вас да изађете и покушате поново.';
$string['categoryname'] = 'Назив категорије';
$string['categorysubcategoryof'] = '{$a->category} - поткатегорија категорије {$a->parentcategory}';
$string['categoryupdated'] = 'Категорија \'{$a}\' је ажурирана';
$string['changedpassword'] = 'Лозинка је промењена';
$string['changepassword'] = 'Промена лозинке';
$string['changesmadereallygoaway'] = 'Направили сте промене. Да ли сте сигурни да желите да одете одавде  и изгубити своје промене?';
$string['changessaved'] = 'Промене су сачуване';
$string['check'] = 'Провери';
$string['checkall'] = 'Провери све';
$string['checkingbackup'] = 'Провера резервне копије';
$string['checkingcourse'] = 'Провера курса';
$string['checkingforbbexport'] = 'Провера BlackBoard извоза података';
$string['checkinginstances'] = 'Провера инстанци';
$string['checkingsections'] = 'Провера секција';
$string['checklanguage'] = 'Провера језика';
$string['checknone'] = 'Без провера';
$string['childcoursenotfound'] = 'Подређени курс није пронађен!';
$string['childcourses'] = 'Подређени курсеви';
$string['choose'] = 'Изабери';
$string['choosecourse'] = 'Избор курса';
$string['choosedots'] = 'Изабери...';
$string['chooselivelogs'] = 'Или надгледајте тренутну активност';
$string['chooselogs'] = 'Избoр записa о активностима који желите да видите';
$string['choosereportfilter'] = 'Избор филтера за извештај';
$string['choosetheme'] = 'Изаберите графичку тему';
$string['chooseuser'] = 'Избор корисника';
$string['city'] = 'Место';
$string['clambroken'] = 'Ваш администратор је укључио антивирусну проверу при постављању датотека, али је нажалост нешто погрешно конфигурисао.<br /> Постављање Ваше датотеке НИЈЕ било успешно. Администратору је упућена аутоматска е-порука од стране система и очекујемо негове исправке подешавања. <br /> Молимо покушајте учитавање те датотеке нешто касније.';
$string['clamdeletedfile'] = 'Датотека је обрисана';
$string['clamdeletedfilefailed'] = 'Датотека није могла бити обрисана';
$string['clamemailsubject'] = '{$a} :: Clam AV обавештење';
$string['clamfailed'] = 'Clam AV се није могао покренути. Обавештење о грешци је следеће: {$a}. Следи Clam AV излаз:';
$string['clamlost'] = 'Moodle је конфигурисан тако да проверава постављање датотека с Clam AV алатом, али је подешена путања ({$a}) до Clam AV алата нетачна.';
$string['clamlostandactinglikevirus'] = 'Поред тога, Moodle је конфигурисан тако да уколико Clam AV не успе да буде покренут, датотеке ће бити третиранe као вируси. Ово у пракси значи да НИЈЕДАН полазник не може послати датотеку на сервер све док не решите овај проблем.';
$string['clammovedfile'] = 'Датотека је премештена у специфицирани карантински директоријум, нова локација је {$a}';
$string['clammovedfilebasic'] = 'Датотека је премештена у карантински директоријум.';
$string['clamquarantinedirfailed'] = 'Није било могуће преместити датотеку у специфицирани карантински директоријум {$a}. Требали бисте ово поправити јер се датотеке аутоматски бришу ако се пронађу као заражене.';
$string['clamunknownerror'] = 'Непозната грешка при коришћењу Clam-a.';
$string['cleaningtempdata'] = 'Брисање привремених података';
$string['clear'] = 'Обриши';
$string['clickhelpiconformoreinfo'] = '... наставља се... Кликните на иконицу за помоћ како бисте прочитали цео чланак';
$string['clickhere'] = 'Кликни овде ...';
$string['clicktochangeinbrackets'] = '{$a} (Кликни за промену)';
$string['clicktohideshow'] = 'Кликните да бисте раширили или скупили';
$string['closebuttontitle'] = 'Затвори';
$string['closewindow'] = 'Затворите овај прозор';
$string['collapse'] = 'Скупи';
$string['collapseall'] = 'Скупи све';
$string['collapsecategory'] = 'Скупи {$a}';
$string['commentincontext'] = 'Пронађи овај коментар у контексту';
$string['comments'] = 'Коментари';
$string['commentsnotenabled'] = 'Коментарисање није омогућено';
$string['commentsrequirelogin'] = 'Потребно је да се пријавите на систем како бисте видели коментаре';
$string['comparelanguage'] = 'Упоредите и уредите тренутно одабрани језик';
$string['complete'] = 'Потпуно';
$string['completereport'] = 'Потпуни извештај';
$string['configuration'] = 'Конфигурација';
$string['confirm'] = 'Потврди';
$string['confirmcheckfull'] = 'Да ли сте апсолутни сигурни да желите да потврдите {$a}?';
$string['confirmcoursemove'] = 'Да ли сте сигурни да желите да преместите курс ({$a->course}) у ову категорију ({$a->category})?';
$string['confirmed'] = 'Ваша регистрација је потврђена';
$string['confirmednot'] = 'Ваша регистрација још није потврђена!';
$string['content'] = 'Садржај';
$string['continue'] = 'Настави';
$string['continuetocourse'] = 'Кликните овде да бисте ушли на свој курс';
$string['convertingwikitomarkdown'] = 'Претварање wiki формата у Markdown формат';
$string['cookiesenabled'] = 'Ваш веб читач мора имати омогућене "колачиће"';
$string['cookiesenabled_help'] = 'На овом сајту се користе два колачића (<i>cookies</i>):

Основни је колачић сесије (<i>session cookie</i>), који се обично зове MoodleSession. У вашем веб читачу морате дозволити употребу овог колачића, како бисте обезбедили континуирану пријаву на систем при преласку са једне на другу страницу сајта. Када се одјавите са система или затворите веб читач колачић се уништава (и у вашем веб читачу и на серверу).

Други колачић је ту чисто због комфора у раду и обично се назива MOODLEID. Он само памти ваше корисничко име унутар веб читача. То значи, да ће, када се буде вратили на овај сајт, поље за унос корисничког имена на страницу за пријаву, аутоматски бити попуњено Вашим корисничким именом. Из разлога безбедности (нарочито када Интернету приступате са јавног рачунара) боље је да одбијете овај колачић - у том случају ћете морати да унесете своје корисничко име сваки пут када се будете пријављивали на систем.';
$string['cookiesnotenabled'] = 'Нажалост, "колачићи" нису омогућени у Вашем веб читачу';
$string['copy'] = 'копирање';
$string['copyasnoun'] = 'копирање';
$string['copyingcoursefiles'] = 'Копирање датотека курса';
$string['copyingsitefiles'] = 'Копирање фајлова са сајта који су коришћени у курсу';
$string['copyinguserfiles'] = 'Копирање корисничких датотека';
$string['copyingzipfile'] = 'Копирање zip датотека';
$string['copyrightnotice'] = 'Напомена о заштити ауторских права';
$string['coresystem'] = 'Систем';
$string['cost'] = 'Цена';
$string['costdefault'] = 'Подразумевана цена';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Држава';
$string['course'] = 'Курс';
$string['courseadministration'] = 'Администрација курса';
$string['courseapprovedemail'] = 'Захтев за курсом, {$a->name}, који сте поднели је одобрен, курс је креиран и Вама је додељена следећа улога на њему: {$a->teacher}. Да бисте приступили свом новом курсу, идите на {$a->url}';
$string['courseapprovedemail2'] = 'Курс који сте тражили, {$a->name}, је одобрен. Да бисте приступили Вашем новом курсу идите на {$a->url}';
$string['courseapprovedfailed'] = 'Није успело чување курса онако како је одобрено!';
$string['courseapprovedsubject'] = 'Ваш курс је одобрен!';
$string['courseavailable'] = 'Овај курс је доступан полазницима';
$string['courseavailablenot'] = 'Овај курс није доступан полазницима';
$string['coursebackup'] = 'Резервна копија курса';
$string['coursebulkaction'] = 'Масовне акције за изабране курсеве';
$string['coursecategories'] = 'Категорије курсева';
$string['coursecategory'] = 'Категорија курса';
$string['coursecategorydeleted'] = 'Обрисана категорија $а';
$string['coursecategory_help'] = 'Ово подешавање одређује категорију у којој ће се курс појавити на списку курсева.';
$string['coursecatmanagement'] = 'Управљање курсом и категоријом';
$string['coursecompletion'] = 'Завршеност курса';
$string['coursecompletions'] = 'Завршеност курсева';
$string['coursecreators'] = 'Креатор курса';
$string['coursecreatorsdescription'] = 'Креатори курсева могу да креирају нове курсеве и предају на њима.';
$string['coursedeleted'] = 'Обрисан курс $а';
$string['coursedisplay'] = 'Прелом странице курса';
$string['coursedisplay_help'] = 'Ова подешавање одређује да ли ће цео курс бити приказан на једној страници или ће бити подељен на неколико страница.';
$string['coursedisplay_multi'] = 'Прикажи једну секцију по страници';
$string['coursedisplay_single'] = 'Прикажи све секције на једној страници';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Наслеђене датотеке курса';
$string['coursefilesedit'] = 'Уреди наслеђене датотеке курса';
$string['coursefileswarning'] = 'Датотеке курса су застареле';
$string['coursefileswarning_help'] = 'Опција \'Датотеке курса\' се не користи од верзије Moodle 2.0, Молимо да уместо тога користите спољашње репозиторијуме што је више могуће.';
$string['courseformatdata'] = 'Подаци о формату курса';
$string['courseformatoptions'] = 'Опције за форматирање - {$a}';
$string['courseformats'] = 'Формати курса';
$string['courseformatudpate'] = 'Ажурирај формат';
$string['coursegrades'] = 'Оцене на курсу';
$string['coursehelpcategory'] = 'Поставите курс на листи курсева тако да полазници могу лакше да га пронађу.';
$string['coursehelpforce'] = 'Обавезан групни мод за све активности на курсу';
$string['coursehelpformat'] = 'Главна страница курса биће приказана у овом формату.';
$string['coursehelphiddensections'] = 'Како ће скривене секције курса бити приказане полазницима.';
$string['coursehelpmaximumupload'] = 'Одредите максималну величину датотеке која се може поставити у оквиру курса. Ова величина је ограничена подешавањем на нивоу сајта.';
$string['coursehelpnewsitemsnumber'] = 'Број најновијих вести који ће се појавити на почетној страници курса, у блоку Вести. Ако је подешено на  0, блок са најновијим вестима неће бити приказан.';
$string['coursehelpnumberweeks'] = 'Број секција унутар курса (важи само за одређене формате курса).';
$string['coursehelpshowgrades'] = 'Омогући приказ књиге са оценама. Ово не спречава да оцене буду приказане унутар појединачних активности.';
$string['coursehidden'] = 'Овај курс тренутно није доступан полазницима';
$string['courseinfo'] = 'Информације о курсу';
$string['courselegacyfiles'] = 'Изворне датотеке курса';
$string['courselegacyfiles_help'] = 'Подручје датотека курса обезбеђује извесну компатибилност са Moodle 1.9 и старијим верзијама. Све датотеке у овом подручју увек су доступне свим учесницима курса (независно од тога да ли су повезани са курсом или не) и не постоји начин да се сазна где је било која од ових датотека коришћена у Moodleu.

Ако ово подручје користите да би сте у њему чували датотеке курса, можете себе да изложите бројним проблемима који се тичу приватности и безбдности система. Исто тако може доћи до губитка датотека при креирању резервних копија, увозу података из једног у други курс, као и сваки пут када садржај делите или поново користите. Због тога препоручујемо да не користите ово подручје, осим ако нисте сасвим сигурни да знате шта радите.';
$string['courselegacyfilesofcourse'] = 'Наслеђене датотеке курса: {$a}';
$string['coursemessage'] = 'Слање поруке корисницима курса';
$string['coursenotaccessible'] = 'Курс не дозвољава јавни приступ';
$string['courseoverview'] = 'Преглед курсева';
$string['courseoverviewfiles'] = 'Датотеке резимеа курсева';
$string['courseoverviewfilesext'] = 'Екстензије датотека резимеа курсева';
$string['courseoverviewfiles_help'] = 'Датотеке резимеа курсева, као што су слике, приказују се на списку курсева заједно са резимеом';
$string['courseoverviewfileslimit'] = 'Ограничење за датотеке резимеа курсева';
$string['courseoverviewgraph'] = 'Графикон прегледа курсева';
$string['courseprofiles'] = 'Профили курсева';
$string['coursereasonforrejecting'] = 'Вашо разлози за одбијање овог захтева';
$string['coursereasonforrejectingemail'] = 'Ово ће бити послато е-поштом подносиоцу захтева.';
$string['coursereject'] = 'Одбаците захтев за отварање курса';
$string['courserejected'] = 'Курс је одбијен и подносилац захтева је обавештен о томе.';
$string['courserejectemail'] = 'Жао нам је, али ваш захтев за отварање курса је одбијен. Ево образложења такве одлуке:

{$a}';
$string['courserejectreason'] = 'Наведите своје разлоге за одбијање овог курса<br />(ово ће бити послато е-поруком подносиоцу захтева)';
$string['courserejectsubject'] = 'Ваш курс је одбијен';
$string['coursereport'] = 'Извештај о курсу';
$string['coursereports'] = 'Ивештаји курса';
$string['courserequest'] = 'Захтев за покретање новог курса';
$string['courserequestdetails'] = 'Детаљније информације о курсу чије покретање тражите';
$string['courserequestfailed'] = 'Из неког разлога није могуће сачувати ваш захтев за покретање курса';
$string['courserequestintro'] = 'Употребите овај образац како бисте затражили да буде креиран нови курс за вас.<br />Покушајте да попуните образац са што више информација, како бисте помогли<br />администраторима да боље разумеју ваше разлоге због којих желите овај курс.';
$string['courserequestreason'] = 'Разлози за покретање овог курса';
$string['courserequestsuccess'] = 'Ваш захтев за покретање новог курса успешно је сачуван. Биће Вам послата електронска порука да бисте били информисани о томе да ли је Ваш захтев одобрен.';
$string['courserequestsupport'] = 'Додатне информације које ће помоћи администратору да процени овај захтев';
$string['courserestore'] = 'Рестаурирање курса';
$string['courses'] = 'Курсеви';
$string['coursesectionsummaries'] = 'Резиме секција курса';
$string['coursesettings'] = 'Подразумевана подешавања курса';
$string['coursesmovedout'] = 'Курс померен из {$a}';
$string['coursespending'] = 'Курсеви који чекају на одобрење';
$string['coursestart'] = 'Почетак курса';
$string['coursesummary'] = 'Резиме курса';
$string['coursesummary_help'] = 'Сажетак курса се приказује у оквиру листе курсева. Претрага курсева претражује и текст сажетака уз прегледање назива курсева.';
$string['courseupdates'] = 'Ажурирања курса';
$string['create'] = 'Креирај';
$string['createaccount'] = 'Креирај мој нови кориснички налог';
$string['createcategory'] = 'Креирај категорију';
$string['createfolder'] = 'Креирање директоријума у {$a}';
$string['createnew'] = 'Креирај нови';
$string['createnewcategory'] = 'Креирај нову категорију';
$string['createnewcourse'] = 'Креирај нови курс';
$string['createnewsubcategory'] = 'Креирај нову поткатегорију';
$string['createsubcategoryof'] = 'Креирај нову поткатегорију за {$a}';
$string['createuser'] = 'Креирај корисника';
$string['createuserandpass'] = 'Изаберите своје корисничко име и лозинку за приступ систему';
$string['createziparchive'] = 'Креирање zip архиве';
$string['creatingblocks'] = 'Креирање блокова';
$string['creatingblocksroles'] = 'Креирање задатака и преписивања улога на нивоу блока';
$string['creatingblogsinfo'] = 'Креирање информација о блоговима';
$string['creatingcategoriesandquestions'] = 'Креирање категорија и питања';
$string['creatingcoursemodules'] = 'Креирање модула курса';
$string['creatingcourseroles'] = 'Креирање задатака и преписивања улога на нивоу курса';
$string['creatingevents'] = 'Креирање догађаја';
$string['creatinggradebook'] = 'Креирање књиге оцена';
$string['creatinggroupings'] = 'Креирање груписања';
$string['creatinggroupingsgroups'] = 'Додавање група у груписања';
$string['creatinggroups'] = 'Креирање група';
$string['creatinglogentries'] = 'Креирање ставки извештаја о активностима';
$string['creatingmessagesinfo'] = 'Креирање информација о порукама';
$string['creatingmodroles'] = 'Креирање задатака и преписивања улога на нивоу модула';
$string['creatingnewcourse'] = 'Креирање новог курса';
$string['creatingrolesdefinitions'] = 'Креирање дефиниција улога';
$string['creatingscales'] = 'Креирање скала за оцењивање';
$string['creatingsections'] = 'Креирање секција';
$string['creatingtemporarystructures'] = 'Креирање привремених структура';
$string['creatinguserroles'] = 'Креирање задатака и преписивања улога на нивоу корисника';
$string['creatingusers'] = 'Креирање корисника';
$string['creatingxmlfile'] = 'Креирање XML датотеке';
$string['currency'] = 'Валута';
$string['currentcourse'] = 'Текући курс';
$string['currentcourseadding'] = 'Текући курс, додавање података већ постојећима';
$string['currentcoursedeleting'] = 'Текући курс, уз претходно брисање постојећих података';
$string['currentlanguage'] = 'Тренутно важећи језик';
$string['currentlocaltime'] = 'Ваше тренутно локално време';
$string['currentlyselectedusers'] = 'Тренутно одабрани корисници';
$string['currentpicture'] = 'Тренутна слика';
$string['currentrelease'] = 'Информација о тренутној верзији програма';
$string['currentversion'] = 'Тренутна верзија';
$string['databasechecking'] = 'Надоградња базе података са верзије {$a->oldversion} на верзију {$a->newversion}';
$string['databaseperformance'] = 'Перформансе базе података';
$string['databasesetup'] = 'Подешавање базе података';
$string['databasesuccess'] = 'База података је успешно надограђена';
$string['databaseupgradebackups'] = 'Тренутна верзија резервне копије је {$a}';
$string['databaseupgradeblocks'] = 'Тренутна верзија блокова је {$a}';
$string['databaseupgradegroups'] = 'Верзија групе сада је {$a}';
$string['databaseupgradelocal'] = 'Тренутна верзија прилагођавања локалне базе података је {$a}';
$string['databaseupgrades'] = 'Надоградња базе података';
$string['date'] = 'Датум';
$string['datechanged'] = 'Датум промене';
$string['datemostrecentfirst'] = 'Датум - прво најновији';
$string['datemostrecentlast'] = 'Датум - прво најстарији';
$string['day'] = 'дан';
$string['days'] = 'дан/а';
$string['decodinginternallinks'] = 'Декодирање унутрашњих линкова';
$string['default'] = 'Подразумевано';
$string['defaultcoursestudent'] = 'Полазник';
$string['defaultcoursestudentdescription'] = 'Полазници у општем случају имају мање привилегије у оквиру курса.';
$string['defaultcoursestudents'] = 'Полазници';
$string['defaultcoursesummary'] = 'Напишите кратак и занимљив резиме који објашњава које теме покрива Ваш курс.';
$string['defaultcourseteacher'] = 'Предавач';
$string['defaultcourseteacherdescription'] = 'Предавачи могу да раде било шта у оквиру курса, укључујући промену активности и оцењивање полазника.';
$string['defaultcourseteachers'] = 'Предавачи';
$string['defaulteditor'] = 'Подразумевани едитор';
$string['delete'] = 'Обриши';
$string['deleteablock'] = 'Обриши блок';
$string['deleteall'] = 'Обриши све';
$string['deleteallcannotundo'] = 'Обриши све - ова акција је неповратна';
$string['deleteallcomments'] = 'Обриши све коментаре';
$string['deleteallratings'] = 'Обриши сва оцењивања';
$string['deletecategory'] = 'Обриши категорију: {$a}';
$string['deletecategorycheck'] = 'Јесте ли апсолутно сигурни да желите да обришете категорију под називом <b>\'{$a}\'</b>?<br /> Ово ће преместити све курсеве који се налазе у тој категорији у надређену категорију (ако иста постоји), или у категорију Разно.';
$string['deletecategorycheck2'] = 'Ако обришете ову категорију, морате изабрати шта урадити са курсевима и подкатегоријама које она садржи.';
$string['deletecategoryempty'] = 'Ова категорија је празна';
$string['deletecheck'] = 'Обрисати {$a} ?';
$string['deletecheckfiles'] = 'Јесте ли у потпуности сигурни да желите да обришете ове датотеке?';
$string['deletecheckfull'] = 'Јесте ли сигурни да желите да потпуно обришете {$a}?';
$string['deletechecktype'] = 'Да ли сте сигурни да желите да обришете овај {$a->type}?';
$string['deletechecktypename'] = 'Да ли сте сигурни да желите да обришете {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Управо ћете обрисати ове датотеке';
$string['deletecomment'] = 'Обриши овај коментар';
$string['deletecompletely'] = 'Комплетно брисање';
$string['deletecourse'] = 'Брисање курса';
$string['deletecoursecheck'] = 'Јесте ли сигурни да желите потпуно да обришете овај курс и све податке које он садржи?';
$string['deleted'] = 'Обрисано';
$string['deletedactivity'] = 'Обрисано {$a}';
$string['deletedcourse'] = '{$a} је потпуно обрисан';
$string['deletednot'] = '{$a} се не може обрисати!';
$string['deletelogs'] = 'Обриши записе';
$string['deleteselected'] = 'Обрисати изабрано';
$string['deleteselectedkey'] = 'Обриши изабрани кључ';
$string['deletingcourse'] = 'Брисање {$a}';
$string['deletingexistingcoursedata'] = 'Брисање постојећих података курса';
$string['deletingolddata'] = 'Брисање старих података';
$string['department'] = 'Департман/Одсек';
$string['desc'] = 'Опадајуће';
$string['description'] = 'Опис';
$string['deselectall'] = 'Поништи избор свега';
$string['detailedless'] = 'Мање детаљно';
$string['detailedmore'] = 'Детаљније';
$string['directory'] = 'Директоријум';
$string['disable'] = 'Онемогући';
$string['disabledcomments'] = 'Коментарисање је онемогућено';
$string['displayingfirst'] = 'Приказано је само првих(а) {$a->count} {$a->things}';
$string['displayingrecords'] = 'Приказ {$a} записа';
$string['displayingusers'] = 'Приказ корисника од {$a->start} до {$a->end}';
$string['displayonpage'] = 'Прикажи на страници';
$string['dndcourse'] = 'Можете да превучете и спустити овај курс како бисте променили његово сортирање или га преместили у другу категорију.';
$string['dndenabled_inbox'] = 'Превуците и спустите датотеке овде како бисте их додали.';
$string['dndnotsupported'] = 'Није подржано постављање превлачењем';
$string['dndnotsupported_help'] = 'Ваш читач не подржава постављање превлачењем.<br />Ова могућност вам је на располагању у скоријим верзијама читача Chrome, Firefox и Safari, као и у читачу Internet Explorer од верзије 10.';
$string['dndnotsupported_insentence'] = 'превлачење није подржано';
$string['dnduploadwithoutcontent'] = 'Ово постављање нема никакав садржај';
$string['dndworkingfile'] = 'Превуците и спустите датотеке на секцију курса како бисте их поставили';
$string['dndworkingfilelink'] = 'Превуците и спустите датотеке или линкове на секцију курса како бисте их поставили';
$string['dndworkingfiletext'] = 'Превуците и спустите датотеке или текст на секцију курса како бисте их поставили';
$string['dndworkingfiletextlink'] = 'Превуците и спустите датотеке, текст или линкове на секцију курса како бисте их поставили';
$string['dndworkinglink'] = 'Превуците и спустите линкове на секцију курса како бисте их поставили';
$string['dndworkingtext'] = 'Превуците и спустите текст на секцију курса како бисте га поставили';
$string['dndworkingtextlink'] = 'Превуците и спустите текст или линкове на секцију курса како бисте их поставили';
$string['documentation'] = 'Moodle документација';
$string['dontsortcategories'] = 'Не сортирај категорије';
$string['dontsortcourses'] = 'Не сортирај курсеве';
$string['down'] = 'Доле';
$string['download'] = 'Преузми';
$string['downloadall'] = 'Преузми све';
$string['downloadexcel'] = 'Преузми у Excel формату';
$string['downloadfile'] = 'Преузми датотеку';
$string['downloadods'] = 'Преузми у ODS формату';
$string['downloadtext'] = 'Преузми у текстуалном формату';
$string['doyouagree'] = 'Јесте ли прочитали наведене услове и разумели их у потпуности?';
$string['droptoupload'] = 'Спусти овде датотеке за слање';
$string['duplicate'] = 'Дуплирај';
$string['duplicateconfirm'] = 'Да ли сте сигурни да желите да дуплирате {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Повратак на курс';
$string['duplicatecontedit'] = 'Уреди нову копију';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' је успешно дуплиран/а';
$string['duplicatinga'] = 'Дуплирање: {$a}';
$string['edhelpaspellpath'] = 'Да бисте користили проверу правописа у едитору, МОРАТЕ имати <strong>aspell 0.50</strong> или новији инсталиран на Вашем серверу, и морате специфицирати тачну путању за приступ aspell бинарној датотеци. На Unix/Linux системима, ова путања је обично <strong>/usr/bin/aspell</strong>, али може бити и нека друга.';
$string['edhelpbgcolor'] = 'Одредите позадинску боју поља за уређивање.<br />Пример вредности које се могу задати су: #ffffff или white';
$string['edhelpcleanword'] = 'Ово подешавање омогућава или онемогућава филтрирање Word-специфичног формата.';
$string['edhelpenablespelling'] = 'Укључите или искључите проверу правописа (spell-checking). Ако је провера укључена, <strong>aspell</strong> мора бити инсталиран на серверу. Друга вредност је <strong>подразумевани речник</strong>. Ова вредност ће бити коришћена ако aspell нема речник за језик који користи корисник.';
$string['edhelpfontfamily'] = 'Карактеристика фамилија фонтова је листа назива група фонтова сродних језика и/или генеричких назива група сродних фонтова. Имена група сродних језика морају бити одвојена зарезом.';
$string['edhelpfontlist'] = 'Одредите фонтове који ће се користити у падајућем менију.';
$string['edhelpfontsize'] = 'Подразумевана величина величина фонта. <br />Примери вредности које се могу задати су: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Уреди';
$string['edita'] = 'Уреди {$a}';
$string['editcategorysettings'] = 'Уреди подешавања категорије';
$string['editcategorythis'] = 'Уреди ову категорију';
$string['editcoursesettings'] = 'Уређивање подешавања курса';
$string['editfiles'] = 'Уређивање датотека';
$string['editgroupprofile'] = 'Уређивање профила групе';
$string['editinga'] = 'Уређивање';
$string['editingteachershort'] = 'Едитор';
$string['editlock'] = 'Ова вредност се не може променити!';
$string['editmyprofile'] = 'Уређивање профила';
$string['editorbgcolor'] = 'Боја позадине';
$string['editorcleanonpaste'] = 'Обриши Word HTML ознаке приликом копирања';
$string['editorcommonsettings'] = 'Општа подешавања';
$string['editordefaultfont'] = 'Подразумевани фонт';
$string['editorenablespelling'] = 'Омогући проверу правописа';
$string['editorfontlist'] = 'Списак фонтова';
$string['editorfontsize'] = 'Подразумевана величина фонта';
$string['editorresettodefaults'] = 'Врати на подразумеване вредности';
$string['editorsettings'] = 'Подешавања едитора';
$string['editorshortcutkeys'] = 'Пречице са тастатуре едитора';
$string['editsettings'] = 'Уреди подешавања';
$string['editsummary'] = 'Уређивање резимеа';
$string['editthisactivity'] = 'Уређивање ове активности';
$string['editthiscategory'] = 'Уређивање ове категорије';
$string['edittitle'] = 'Уреди наслов';
$string['edittitleinstructions'] = 'Притисните тастер \'Escape\' за отказивање, а тастер \'Enter\' када завршите';
$string['edituser'] = 'Уређивање корисничких налога';
$string['email'] = 'Адреса е-поште';
$string['emailactive'] = 'Адреса е-поште је активирана';
$string['emailagain'] = 'Адреса е-поште (поново)';
$string['emailalreadysent'] = 'Електронска порука за ресетовање лозинке је већ послата.
Молимо вас да проверите своју електронску пошту.';
$string['emailcharset'] = 'Скуп карактера коришћен за е-пошту';
$string['emailconfirm'] = 'Потврдите свој кориснички налог';
$string['emailconfirmation'] = 'Поштована/и {$a->firstname},

Затражено је отварање корисничког налога на сајту \'{$a->sitename}\' користећи вашу адресу е-поште.

Да бисте потврдили свој нови налог, молимо вас идите на следећу веб адресу

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: потврда регистрације корисничког налога';
$string['emailconfirmsent'] = '<p>Ускоро бисте требали примити е-поруку на Вашу адресу <b>{$a}</b></p>
   <p>Порука садржи једноставна упутства о даљем поступку регистрације.</p>
   <p>Ако имате техничких проблема с регистрацијом или питања у вези исте, контактирајте администратора система.</p>';
$string['emaildigest'] = 'Начин обавештавања путем е-порука';
$string['emaildigestcomplete'] = 'Комплетно (једна е-порука дневно са комплетним садржајем свих порука на форумима)';
$string['emaildigest_help'] = 'Ово је подешавање одређује како ће копије порука са форума бит слате на вашу е-адресу.

* Без скраћивања - добијаћете по једну електронску поруку за сваку поруку (пост) објављену на форумима;
* Сажетак - комплетан преглед свих порука - добијаћете једну електронску поруку дневно са комплетним садржајем свих порука (постова) објављених у току 24 сата;
* Сажетак - само теме порука - добијаћете једну електронску поруку дневно која ће садржати само теме свих порука (постова) објављених у току 24 сата (без садржаја самих постова).

Ако желите можете одабрати другачије подешавање за сваки форум.';
$string['emaildigestoff'] = 'Без скраћивања (по једна е-порука за сваку поруку објављену на форумима)';
$string['emaildigestsubjects'] = 'Теме порука (једна е-порука дневно само, са темама порука објављених на форумима)';
$string['emaildisable'] = 'Ова адреса е-поште није доступна';
$string['emaildisableclick'] = 'Кликните овде за онемогућавање слања било какве е-поруке на ову адресу.';
$string['emaildisplay'] = 'Приказ адресе е-поште';
$string['emaildisplaycourse'] = 'Дозволи једино другим полазницима курса (полазницима и предавачу) да виде моју адресу е-поште.';
$string['emaildisplayhidden'] = 'Електронска адреса је сакривена';
$string['emaildisplayno'] = 'Сакриј моју адресу е-поште од свих';
$string['emaildisplayyes'] = 'Дозволи свима да виде моју адресу е-поште';
$string['emailenable'] = 'Ова адреса е-поште је доступна';
$string['emailenableclick'] = 'Кликните овде за поновно омогућавање слања свих  е-порука на ову адресу';
$string['emailexists'] = 'Ова адреса е-поште је већ регистрована.';
$string['emailformat'] = 'Формат е-поште';
$string['emailmustbereal'] = 'Напомена: Ваша адреса е-поште мора бити стварна.';
$string['emailnotallowed'] = 'Електронске адресе које припадају овим доменима нису дозвољене ({$a})';
$string['emailnotfound'] = 'Адреса е-поште није нађена у бази података';
$string['emailonlyallowed'] = 'Ова адресе е-поште није једна од дозвољених ({$a})';
$string['emailpasswordchangeinfo'] = 'Поштована/и {$a->firstname},

Неко (вероватно ви) је затражио нову лозинку за ваш кориснички налог на сајту \'{$a->sitename}\'.

Да бисте променили своју лозинку идите на следећу веб адресу:

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Поштована/и {$a->firstname},

Неко (вероватно Ви) је тражио нову шифру за Ваш кориснички налог на \'{$a->sitename}\'.

На жалост, Ваш налог на овој локацији је недоступан и не може бити поново активиран, молимо контактирајте свог администратора, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Поштована/и {$a->firstname},

Неко (вероватно Ви) је тражио нову шифру за Ваш кориснички налог на \'{$a->sitename}\'.

На жалост, шифре се не могу мењати на овој локацији, молимо контактирајте свог администратора, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Информације о промени шифре';
$string['emailpasswordconfirmation'] = 'Поштована/и {$a->firstname},

Неко (вероватно ви) је затражио нову лозинку за ваш кориснички налог на сајту \'{$a->sitename}\'.

Да бисте потврдили захтев и добили нову лозинку путем е-поште, идите на следећу веб адресу:

{$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Уколико вам је потребна техничка помоћ, молимо вас да контактирате администратора,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Потврда промене лозинке';
$string['emailpasswordconfirmmaybesent'] = '<p>Ако сте навели тачно корисничко име или адресу е-поште, требало би да вам је послата електронска порука.</p>
<p>Она садржи једноставна упутства за потврду и завршетак процеса промене лозинке.
Ако будете и даље имали потешкоће, молимо контактирајте администратора свог сајта.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Кориснички налог који сте навели нема забележену електронску адресу.</p>
   <p>Молимо вас да контактирате администратора.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Кориснички подаци које сте навели се не односи ни на један корисники налог.</p>
   <p>Молимо вас да провеерите информацију коју сте навели и да покушате поново.
Ако и даље имате проблема, молимо вас да контактирате администратора.</p>';
$string['emailpasswordconfirmsent'] = 'Требали бисте примити е-поруку послату на Вашу адресу <b>{$a}</b>.
<p>Порука садржи једноставна упутства за потврђиање и комплетирање промене Ваше лозинке.
Ако будете имали потешкоћа приликом овог процеса, можете се обратити администратору.';
$string['emailpasswordsent'] = 'Захваљујемо на потврди захтева за промену лозинке.
<p>Е-порука која садржи Вашу нову лозинку је послата на Вашу адресу <b>{$a->email}</b>.</p>
<p>Нова лозинка је аутоматски генерисана - препоручујемо да је <a href="{$a->link}"<промените </a> чим је добијете у неку другу коју ћете лакше запамтити.</p>';
$string['emailresetconfirmation'] = 'Здраво {$a->firstname},

Затражена је нова лозинка за ваш кориснички налог \'{$a->username}\' на сајту {$a->sitename}.

Како бисте потврдили овај захтев и подесили нову лозинку за свој налог, молимо вас да посетите следећу веб адресу:

{$a->link}
(Овај линк је активан следећих {$a->resetminutes} минута од тренутка када је захтев за новом лозинком први пут затражен)

Ако нисте захтевали промену лозинке игноришите ову електронску поруку.

Ако вам је потребна помоћ молимо вас да контактирате администратора,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Захтев за промену лозинке';
$string['emailresetconfirmsent'] = 'Електронска порука је послата на вашу адресу <b>{$a}</b>.
<br />Порука садржи једноставна упутства како да потврдити и завршити промену лозинке.
Ако и даље имате проблема, молимо вас да контактирате администратора сајта.';
$string['emptydragdropregion'] = 'празан регион';
$string['enable'] = 'Омогући';
$string['encryptedcode'] = 'Шифровани код';
$string['english'] = 'Енглески';
$string['enrolmentmethods'] = 'Начин уписа';
$string['entercourse'] = 'Кликните за приступ курсу';
$string['enteremail'] = 'Унесите своју електронску адресу';
$string['enteremailaddress'] = 'Да бисте поништили тренутну лозинку и добили нову, треба да унесете Вашу важећу адресу електронске поште, на коју ће Вам бити послата нова лозинка.';
$string['enterusername'] = 'Унесите своје корисничко име';
$string['entries'] = 'Улази';
$string['error'] = 'Грешка';
$string['errorcreatingactivity'] = 'Није могуће креирати инстанцу активности \'{$a}\'';
$string['errorfiletoobig'] = 'Датотека је била већа од ограничења од {$a} бајта (бајтова)';
$string['errornouploadrepo'] = 'На овом сајту не постоји репозиторијум за постављање датотека који је омогућен';
$string['errorwhenconfirming'] = 'Ваш кориснички налог још није још потврђен због грешке која се догодила. Ако сте кликнули на линк који сте добили у е-поруци, молимо проверите је ли линија у којој се налази наведени линк исправна (односно, је да је није Ваш клијент е-поште можда форматирао у два реда, чиме је део линка завршио у другом реду). Постоји могућност да ћете морати ручним копирањем и уносом реконструисати оригинални линк.';
$string['eventcontentviewed'] = 'Садржај приказан';
$string['eventcoursecategorydeleted'] = 'Категорија обрисана';
$string['eventcoursecontentdeleted'] = 'Садржај курса обрисан';
$string['eventcoursecreated'] = 'Курс креиран';
$string['eventcoursedeleted'] = 'Курс обрисан';
$string['eventcoursemodulecreated'] = 'Модул курса креиран';
$string['eventcoursemoduledeleted'] = 'Модул курса обрисан';
$string['eventcoursemoduleupdated'] = 'Модул курса ажуриран';
$string['eventcourseresetended'] = 'Ресетовање курса завршено';
$string['eventcourseresetstarted'] = 'Ресетовање курса покренуто';
$string['eventcourserestored'] = 'Курс рестауриран';
$string['eventcoursesectionupdated'] = 'Секција курса ажурирана';
$string['eventcourseupdated'] = 'Курс ажуриран';
$string['eventusercreated'] = 'Корисник креиран';
$string['eventuserdeleted'] = 'Корисник обрисан';
$string['eventuserlistviewed'] = 'Списак корисника приказан';
$string['eventuserloggedout'] = 'Корисник се одјавио';
$string['eventuserprofileviewed'] = 'Профил корисника приказан';
$string['eventuserupdated'] = 'Корисник ажуриран';
$string['everybody'] = 'Сви';
$string['executeat'] = 'Извршити у';
$string['existing'] = 'Постојећи';
$string['existingadmins'] = 'Постојећи администратори';
$string['existingcourse'] = 'Постојећи курс';
$string['existingcourseadding'] = 'Постојећи курс - додавање података постојећим';
$string['existingcoursedeleting'] = 'Постојећи курс - претходно брисање курса';
$string['existingcreators'] = 'Постојећи креатори курса';
$string['existingstudents'] = 'Уписани полазници';
$string['existingteachers'] = 'Постојећи предавачи';
$string['expand'] = 'Прошири';
$string['expandall'] = 'Прошири све';
$string['expandcategory'] = 'Прошири {$a}';
$string['explanation'] = 'Објашњење';
$string['extendenrol'] = 'Продужи (појединачно) трајање чланства';
$string['extendperiod'] = 'Продужени период';
$string['failedloginattempts'] = '{$a->attempts} неуспешних приступа систему од Ваше последње пријаве';
$string['failedloginattemptsall'] = '{$a->attempts} неуспешних приступа систему за {$a->accounts} корисничке налоге';
$string['feedback'] = 'Повратне информације';
$string['file'] = 'Датотека';
$string['fileexists'] = 'Већ постоји датотека под називом {$a}';
$string['filemissing'] = '{$a} недостаје';
$string['files'] = 'Датотеке';
$string['filesanduploads'] = 'Датотеке и постављене датотеке';
$string['filesfolders'] = 'Датотеке/Директоријуми';
$string['filetoolarge'] = 'је превелика за постављање';
$string['fileuploadwithcontent'] = 'Постављање датотека не треба укључује параметре садржаја';
$string['filloutallfields'] = 'Молимо испуните сва поља у овој форми';
$string['filter'] = 'Филтер';
$string['findmorecourses'] = 'Пронађите још курсева...';
$string['first'] = 'Први';
$string['firstaccess'] = 'Први приступ';
$string['firstname'] = 'Име';
$string['firstnamephonetic'] = 'Име - фонетички';
$string['firstsiteaccess'] = 'Први приступ сајту';
$string['firsttime'] = 'Да ли сте овде први пут?';
$string['folder'] = 'Директоријум';
$string['folderclosed'] = 'Затворен директоријум';
$string['folderopened'] = 'Отворен директоријум';
$string['followingoptional'] = 'Следећа поља су опциона';
$string['followingrequired'] = 'Следећа поља су обавезна';
$string['for'] = 'За';
$string['force'] = 'Обавезно';
$string['forcelanguage'] = 'Обавезан језик';
$string['forceno'] = 'Није обавезно';
$string['forcepasswordchange'] = 'Приморај на промену лозинке';
$string['forcepasswordchangecheckfull'] = 'Јесте ли апсолутно сигурни да желите да присилите на промену лозинке корисника {$a}?';
$string['forcepasswordchange_help'] = 'Ако је ово поље за потврду означено, од корисника ће се тражити да промене лозинку када се наредни пут буду пријавили на систем';
$string['forcepasswordchangenot'] = 'Није било могуће присилити {$a} на промену лозинке.';
$string['forcepasswordchangenotice'] = 'Морате променити своју лозинку да бисте наставили';
$string['forcetheme'] = 'Обавезна графичка тема';
$string['forgotaccount'] = 'Заборавили сте лозинку?';
$string['forgotten'] = 'Заборавили сте своје корисничко име или лозинку?';
$string['forgottenduplicate'] = 'email адресу дели више корисничких налога, молим Вас унесите корисничко име уместо исте';
$string['forgotteninvalidurl'] = 'Поновно постављање адресе у случају погрешне шифре';
$string['format'] = 'Формат';
$string['format_help'] = 'Формат курса одређује изглед насловне странице курса.
* Формат једне активности - користи се за приказ једне активности или ресурса (као што је Тест или SCORM пакет) на насловној страници курса
* Друштвени формат - на насловној страници курса се приказује форум
* Тематски формат - насловна страница курса је организована у тематске секције
* Седмични формат - насловна страница курса је организована у недељне секције, при чему прва недеља одговара датуму почетка курса';
$string['formathtml'] = 'HTML формат';
$string['formatmarkdown'] = 'Markdown формат';
$string['formatplain'] = 'Текстуални формат';
$string['formattext'] = 'Moodle ауто-формат';
$string['formattexttype'] = 'Форматирање';
$string['framesetinfo'] = 'Овај скуп оквира садржи:';
$string['from'] = 'Од';
$string['frontpagecategorycombo'] = 'Комбиновани списак';
$string['frontpagecategorynames'] = 'Списак категорија';
$string['frontpagecourselist'] = 'Списак курсева';
$string['frontpagecoursesearch'] = 'Поље за претраживање курсева';
$string['frontpagedescription'] = 'Резиме насловне странице';
$string['frontpagedescriptionhelp'] = 'Овај резиме сајта ће бити приказан на насловној страници сајта коришћењем блока \'Резиме курса/сајта\' или укључивањем тематске секције на насловној страници.';
$string['frontpageenrolledcourselist'] = 'Уписани курсеви';
$string['frontpageformat'] = 'Формат насловне странице';
$string['frontpageformatloggedin'] = 'Формат насловне странице када је корисник пријављен';
$string['frontpagenews'] = 'Вести';
$string['frontpagesettings'] = 'Подешавања насловне странице';
$string['fulllistofcourses'] = 'Сви курсеви';
$string['fullname'] = 'Пун назив';
$string['fullnamecourse'] = 'Пун назив курса';
$string['fullnamecourse_help'] = 'Пун назив курса се приказује на врху сваке странице курса као и на списку курсева.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Пуно име корисника';
$string['fullprofile'] = 'Потпуни профил';
$string['fullsitename'] = 'Пуно име сајта';
$string['functiondisabled'] = 'Наведена функционалност тренутно није доступна';
$string['general'] = 'Опште';
$string['geolocation'] = 'ширина - дужина';
$string['gettheselogs'] = 'Преузми ове записе о активностима';
$string['go'] = 'Даље';
$string['gpl'] = 'Ауторска права од 1999 па надаље Мартин Дугиамас (http://moodle.com)

Овај програм је бесплатан софтвер; можете вршити његову редистрибуцију и/или мењати га само под условима GNU General Public License коју је објавила Free Software Foundation, верзија 2 или (по вашем избору) било која новија верзија.

Овај програм се дистрибуира у нади да ће бити користан, али БЕЗ ИКАКВИХ ГАРАНЦИЈА; чак и без имплицитних гаранција ИСПЛАТИВОСТИ или ПОГОДНОСТИ ЗА КОНКРЕТНУ ПРИМЕНУ.

Погледајте Moodle License страницу са информацијама за више детаља: http://docs.moodle.org/en/License';
$string['gpl3'] = 'Ауторска права од 1999 па надаље Мартин Дугиамас  (http://moodle.com)

Овај програм је бесплатан софтвер; можете вршити његову редистрибуцију и/или мењати га само под условима GNU General Public License коју је објавила Free Software Foundation, верзија 3 или (по вашем избору) било која новија верзија.

Овај програм се дистрибуира у нади да ће бити користан, али БЕЗ ИКАКВИХ ГАРАНЦИЈА; чак и без имплицитних гаранција ИСПЛАТИВОСТИ или ПОГОДНОСТИ ЗА КОНКРЕТНУ ПРИМЕНУ.

Погледајте Moodle License страницу са информацијама за више детаља: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL лиценца';
$string['grade'] = 'Оцена';
$string['grades'] = 'Оцене';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Граватар</a> је омогућен за овај сајт. Ако сами не поставите своју слику Moodle ће покушати да је уместо вас учита са Граватара.';
$string['group'] = 'Група';
$string['groupadd'] = 'Додавање нове групе';
$string['groupaddusers'] = 'Додавање изабраних полазника групи';
$string['groupextendenrol'] = 'Продужи трајање чланства свим полазницима';
$string['groupfor'] = 'за групу';
$string['groupinfo'] = 'Информације о изабраној групи';
$string['groupinfoedit'] = 'Уређивање подешавања групе';
$string['groupinfomembers'] = 'Информације о изабраним члановима';
$string['groupinfopeople'] = 'Информације о изабраним људима';
$string['groupmembers'] = 'Чланови групе';
$string['groupmemberssee'] = 'Приказ чланова групе';
$string['groupmembersselected'] = 'Чланови изабране групе';
$string['groupmode'] = 'Групни мод';
$string['groupmodeforce'] = 'Обавезан групни мод';
$string['groupmy'] = 'Моја група';
$string['groupnonmembers'] = 'Полазници који нису у групи';
$string['groupnotamember'] = 'Жао нам је, нисте члан те групе';
$string['grouprandomassign'] = 'Случајним одабиром распореди све полазнике у групе';
$string['groupremove'] = 'Уклони изабрану групу';
$string['groupremovemembers'] = 'Уклањање изабраних чланова';
$string['groups'] = 'Групе';
$string['groupsnone'] = 'Нема група';
$string['groupsseparate'] = 'Одвојене групе';
$string['groupsvisible'] = 'Видљиве групе';
$string['guest'] = 'Гост';
$string['guestdescription'] = 'Гости имају минималне привилегије и обично нигде не могу да унесу текст.';
$string['guestskey'] = 'Дозвољен приступ гостима који имају лозинку курса';
$string['guestsno'] = 'Забрањен приступ гостима';
$string['guestsnotallowed'] = 'Нажалост, курс \'{$a}\' не дозвољава приступ гостима.';
$string['guestsyes'] = 'Дозвољен приступ гостима без лозинке курса';
$string['guestuser'] = 'Корисник у улози госта';
$string['guestuserinfo'] = 'Овај корисник је посебан који дозвољава приступ неким курсевима само за читање.';
$string['help'] = 'Помоћ';
$string['helpprefix2'] = 'Помоћ за {$a}';
$string['helpwiththis'] = 'Помоћ за ово';
$string['hiddenassign'] = 'Сакривени задаци';
$string['hiddenfromstudents'] = 'Сакривено од полазника';
$string['hiddensections'] = 'Скривене секције';
$string['hiddensectionscollapsed'] = 'Скривене секције су приказане у скупљеном облику';
$string['hiddensections_help'] = 'Ово подешавање одређује да ли ће полазницима скривене секције курса бити приказане у сажетом облику (нпр. за курсеве у седмичном формату, да би се означили празници или распуст између два семестра), или ће бити у потпуности сакривене.';
$string['hiddensectionsinvisible'] = 'Скривене секције су у потпуности невидљиве';
$string['hide'] = 'Сакриј';
$string['hideadvancedsettings'] = 'Сакриј напредна подешавања';
$string['hidepicture'] = 'Сакриј слику';
$string['hidesection'] = 'Сакриј секцију {$a}';
$string['hidesettings'] = 'Сакриј подешавања';
$string['hideshowblocks'] = 'Сакриј или прикажи блокове';
$string['hits'] = 'Посете';
$string['hitsoncourse'] = 'Посете корисника {$a->username} курсу {$a->coursename}';
$string['hitsoncoursetoday'] = 'Данашње посете корисника {$a->username} курсу {$a->coursename}';
$string['home'] = 'Почетна страна';
$string['hour'] = 'h';
$string['hours'] = 'сат/а/и';
$string['howtomakethemes'] = 'Како направити нове графичке теме';
$string['htmleditor'] = 'Користи HTML едитор';
$string['htmleditoravailable'] = 'HTML едитор је доступан';
$string['htmleditordisabled'] = 'Искључили сте употребу HTML едитора за Ваш кориснички профил';
$string['htmleditordisabledadmin'] = 'Администратор система је искључио упортребу HTML едитора на нивоу целог система';
$string['htmleditordisabledbrowser'] = 'HTML едитор није доступан јер ваш веб читач није компатибилан са њим';
$string['htmlfilesonly'] = 'Само HTML датотеке';
$string['htmlformat'] = 'Улепшани HTML формат';
$string['icon'] = 'Икона';
$string['icqnumber'] = 'ICQ број';
$string['idnumber'] = 'Идентификациони број';
$string['idnumbercourse'] = 'Идентификациони број курса';
$string['idnumbercoursecategory'] = 'ID број категорије';
$string['idnumbercoursecategory_help'] = 'ID број категорије курса се користи само за поређење са екстерним системом ID бројева, и нигде се не приказује на сајту. Ако категорија има званичан кодни назив, он може бити унет, у супротном поље може бити остављено празно.';
$string['idnumbercourse_help'] = 'Идентификациони број курса се користи само приликом упоређивања са екстерним системима и не приказује се нигде на сајту. Ако курс има неку официјелну шифру, она може овде бити уписана, у супротном поље може остати празно.';
$string['idnumbergroup'] = 'ID број групе';
$string['idnumbergroup_help'] = 'Идентификациони (ID) број групе се користи само приликом упоређивања са екстерним системима и не приказује се нигде на сајту. Ако група има неку официјелну шифру, она може овде бити уписана, у супротном поље може остати празно.';
$string['idnumbergrouping'] = 'ID број груписања';
$string['idnumbergrouping_help'] = 'Идентификациони (ID) број груписања се користи само приликом упоређивања са екстерним системима и не приказује се нигде на сајту. Ако груписање има неку официјелну шифру, она може овде бити уписана, у супротном поље може остати празно.';
$string['idnumbermod'] = 'ID број';
$string['idnumbermod_help'] = 'Постављање идентификационог броја омогућује идентификацију активности у сврху рачунања оцена. Ако активност није укључена у неко од оцењивања, поље за идентификациони број може остати празно.

Идентификациони број се, такође, може поставити у књизи оцена, али се једино може уређивати на страници за подешавање активности.';
$string['idnumbertaken'] = 'Овај ID број је већ заузет';
$string['imagealt'] = 'Опис слике';
$string['import'] = 'Увоз';
$string['importdata'] = 'Увоз података курса';
$string['importdataexported'] = 'Извоз података из изворног курса прошао је успешно. <br /> Следи увоз података у одредишни курс';
$string['importdatafinished'] = 'Увоз података је успешно завршен! Наставите према Вашем курсу';
$string['importdatafrom'] = 'Пронађите курс из ког желите да увезете податке:';
$string['inactive'] = 'Неактиван';
$string['include'] = 'Укључујући';
$string['includeallusers'] = 'Укључујући све кориснике';
$string['includecoursefiles'] = 'Укључујући датотеке курса';
$string['includecourseusers'] = 'Укључујући полазнике курса';
$string['included'] = 'Укључени';
$string['includelogentries'] = 'Укључујући ставке извештаја о активностима';
$string['includemodules'] = 'Укључујући модуле';
$string['includemoduleuserdata'] = 'Укључујући податке корисника модула';
$string['includeneededusers'] = 'Укључујући потребне кориснике';
$string['includenoneusers'] = 'Без укључивања корисника';
$string['includeroleassignments'] = 'Обухвати доделу улога';
$string['includesitefiles'] = 'Укључујући фајлове коришћене у овом курсу';
$string['includeuserfiles'] = 'Укључи корисничке датотеке';
$string['increasesections'] = 'Повећај број секција';
$string['info'] = 'Информација';
$string['institution'] = 'Институција';
$string['instudentview'] = 'у полазничком погледу';
$string['interests'] = 'Интересовања';
$string['interestslist'] = 'Листа интересовања';
$string['interestslist_help'] = 'Унесите своја интересовања одвојена зарезима. Ваша интересовања ће бити приказана на Вашем профилу као ознаке (тагови).';
$string['invalidemail'] = 'Неважећа електронске адреса';
$string['invalidlogin'] = 'Погрешно корисничко име или лозинка. Молимо покушајте поново.';
$string['invalidusername'] = 'Корисничко име може садржати само мала слова и/или бројеве, доњу црту (_), цртицу (-), тачку (.) или симбол @';
$string['invalidusernameupload'] = 'Неисправно корисничко име';
$string['ip_address'] = 'IP адреса';
$string['jump'] = 'Прелаз';
$string['jumpto'] = 'Прелаз на...';
$string['keep'] = 'Задржите';
$string['keepsearching'] = 'Настави с претрагом';
$string['langltr'] = 'Смер писања с лева на десно';
$string['langrtl'] = 'Смер писања с десна на лево';
$string['language'] = 'Језик';
$string['languagegood'] = 'Овај језички пакет је ажуран! :-)';
$string['last'] = 'Последњи';
$string['lastaccess'] = 'Последњи приступ';
$string['lastcourseaccess'] = 'Последњи приступ курсу';
$string['lastedited'] = 'Последњи пут уређено';
$string['lastlogin'] = 'Последњи приступ систему';
$string['lastmodified'] = 'Последња измена';
$string['lastname'] = 'Презиме';
$string['lastnamephonetic'] = 'Презиме - фонетички';
$string['lastsiteaccess'] = 'Последњи приступ сајту';
$string['lastyear'] = 'Прошле године';
$string['latestlanguagepack'] = 'Погледајте најновије језичке пакете на moodle.org';
$string['layouttable'] = 'Распоред у табели';
$string['leavetokeep'] = 'Оставите празно поље да задржите тренутну лозинку';
$string['legacythemeinuse'] = 'Овај сајт вам се приказује у тзв. компатибилном моду зато што је ваш веб читач застарео.';
$string['license'] = 'Лиценца';
$string['licenses'] = 'Лиценце';
$string['liketologin'] = 'Желите ли сад да приступите систему с правим корисничим налогом?';
$string['list'] = 'Списак';
$string['listfiles'] = 'Списак датотека у {$a}';
$string['listofallpeople'] = 'Списак свих корисника';
$string['listofcourses'] = 'Списак курсева';
$string['loadinghelp'] = 'Учитавање ...';
$string['local'] = 'Локално';
$string['localplugins'] = 'Локални додаци';
$string['localpluginsmanage'] = 'Уреди локалне додатке';
$string['location'] = 'Локација';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Пријављени сте као {$a}';
$string['loggedinasguest'] = 'Тренутно приступате као гост';
$string['loggedinnot'] = 'Нисте пријављени.';
$string['login'] = 'Пријава';
$string['loginalready'] = 'Већ сте пријављени на систем';
$string['loginas'] = 'Приступ систему као';
$string['loginaspasswordexplain'] = '<p>Морате унети специјалну "приступи систему као" лозинку да бисте користили ову могућност.<br />Ако не знате ту лозинку, питајте администратора свог сервера.</p>';
$string['login_failure_logs'] = 'Записи о неуспешним пријавама';
$string['loginguest'] = 'Пријавите се као гост';
$string['loginsite'] = 'Приступ систему';
$string['loginsteps'] = 'Добродошли! Како бисте имали пуни приступ курсевима на овом веб сајту, морате креирати нови кориснички налог.
Сваки од појединих курсева може такође имати једнократну "лозинку курса", коју треба да добијете од свог предавача и која се уноси само приликом првог пријављивања на курс. Следите ова упутства:
   <ol size="2">
   <li>Испуните образац <a href="{$a}">Нови кориснички налог</a> својим личним подацима.</li>
   <li>Одмах ћете на своју електронску адресу добити наша даља упутства.</li>
   <li>Пажљиво прочитајте поруку и кликните на линк који се налази у њој.</li>
   <li>Ваш кориснички налог ће тиме бити потврђен и бићете пријављени на систем.</li>
   <li>Потом одаберите курс у којем желите да учествујете.</li>
   <li>Ако вам систем затражи "лозинку курса" - употребите ону коју вам је дао ваш предавач на наведеном курсу. Тако ћете се уписати на курс</li>
   <li>Након уноса исправне "лозинке курса" можете приступити курсу (односно, од тог тренутка сте уписани на исти). Убудуће, при доласку на сајт, биће потребно да унесете само своје корисничко име и лозинку (у образац на овој страни) како бисте приступили свим курсевима које сте уписали.</li>
</ol>';
$string['loginstepsnone'] = '<p>Поштовани будући корисниче!</p>
<p>За потпуни приступ курсевима морате креирати кориснички налог.</p>
<p>Све што треба да урадите је да смислите корисничко име и лозинку и унесете их у за то одређена поља у обрасцу на овој страници!</p>
<p>Ако је неко пре Вас већ одабрао идентично корисничко име, морате одабрати неко друго и покушати поново.</p>';
$string['loginto'] = 'Пријава на {$a}';
$string['logout'] = 'Одјава';
$string['logoutconfirm'] = 'Да ли заиста желите да се одјавите?';
$string['logs'] = 'Записи о активностима';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">више</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">више</a> ]';
$string['lookback'] = 'Погледај уназад';
$string['mailadmins'] = 'Обавестити администраторе';
$string['mailstudents'] = 'Обавестити полазнике';
$string['mailteachers'] = 'Обавестити предаваче';
$string['maincoursepage'] = 'Главна страница курса';
$string['makeafolder'] = 'Креирај директоријум';
$string['makeeditable'] = 'Ако подесите \'{$a}\' да се може уредити процесом веб сервера, онда можете мењати ову датотеку директно са ове странице';
$string['makethismyhome'] = 'Постави ово као моју подразумевану почетну страниву';
$string['manageblocks'] = 'Блокови';
$string['managecategorythis'] = 'Управљање овом категоријом';
$string['managecourses'] = 'Управљање курсевима';
$string['managedatabase'] = 'База података';
$string['manageeditorfiles'] = 'Уреди датотеке коришћене од стране едитора';
$string['managefilters'] = 'Филтери';
$string['managemodules'] = 'Модули';
$string['manageroles'] = 'Улоге и права приступа';
$string['markedthistopic'] = 'Ова тема је означена као тренутна тема';
$string['markthistopic'] = 'Означите ову тему као тренутну тему';
$string['matchingsearchandrole'] = 'Спаривање \'{$a->search}\' и {$a->role}';
$string['maxareabytesreached'] = 'Датотека (или укупна величина неколико датотека) је већа од места који је преостало у овом простору.';
$string['maxbytesforfile'] = 'Датотека {$a} је већа од максималне дозвољене величине.';
$string['maxfilesize'] = 'Максимална величина за нове датотеке {$a}';
$string['maxfilesreached'] = 'Дозвољено вам је да уз ову ставку приложите највише {$a} датотеку/е/а';
$string['maximumchars'] = 'Максимално {$a} карактера';
$string['maximumgrade'] = 'Максимална оцена';
$string['maximumgradex'] = 'Највећа оцена: {$a}';
$string['maximumshort'] = 'Макс.';
$string['maximumupload'] = 'Максимална величина датотека за постављање';
$string['maximumupload_help'] = 'Ово подешавања одређује највећу величину датотеке која се може поставити на курс, а ограничено је подешавањем на нивоу целог сајта које одређује администратор. Модули активности такође садрже подешавање којима се одређује и додатно ограничива највећа дозвољена величина датотеке за постављање.';
$string['maxnumberweeks'] = 'Максималан број секција';
$string['maxnumberweeks_desc'] = 'Максимална вредност у падајућем менију  "Број секција" (важи само за одређене формате курса)';
$string['maxnumcoursesincombo'] = 'Претражи <a href="{$a->link}">{$a->numberofcourses} курсеве</a>';
$string['maxsize'] = 'Макс. величина: {$a}';
$string['maxsizeandareasize'] = 'Максимална величина за нове датотеке: {$a->size}, глобално ограничење: {$a->areasize}';
$string['maxsizeandattachments'] = 'Максимална величина за нове датотеке: {$a->size}, макисималан број прилога: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Максимална величина за нове датотеке: {$a->size}, макисималан број прилога: {$a->attachments}';
$string['memberincourse'] = 'Учесници у курсу';
$string['messagebody'] = 'Тело поруке';
$string['messagedselectedusers'] = 'Изабраним полазницима је послата порука и ресетован је списак прималаца.';
$string['messagedselectedusersfailed'] = 'Нешто није било у реду при слању поруке изабраним корисницима. Неки од њих су ипак можда примили послату поруку.';
$string['messageprovider:availableupdate'] = 'Доступна обавештења о ажурирању';
$string['messageprovider:backup'] = 'Обавештења о креирању резервне копије';
$string['messageprovider:badgecreatornotice'] = 'Обавештење о креатору беџа';
$string['messageprovider:badgerecipientnotice'] = 'Обавештење о примаоцу беџа';
$string['messageprovider:courserequestapproved'] = 'Обавештење о одобрењу захтева за креирање курса';
$string['messageprovider:courserequested'] = 'Обавештење о захтеву за креирање курса';
$string['messageprovider:courserequestrejected'] = 'Обавештење о одбијању захтева за креирање курса';
$string['messageprovider:errors'] = 'Важне грешке у вези са сајтом';
$string['messageprovider:errors_help'] = 'Ово су важне грешке о којима администратор мора да буде упознат';
$string['messageprovider:instantmessage'] = 'Личне поруке између корисника';
$string['messageprovider:instantmessage_help'] = 'Ова секција конфигурише шта се догађа са порукама који су вам директно послате од стране других корисника на овом сајту.';
$string['messageprovider:notices'] = 'Обавештења о мањим проблемима';
$string['messageprovider:notices_help'] = 'Ово су обавештења која би могла да интересују администратора да их погледа.';
$string['messageselect'] = 'Изаберите овог корисника као примаоца поруке';
$string['messageselectadd'] = 'Пошаљи поруку';
$string['middlename'] = 'Средње име';
$string['migratinggrades'] = 'Премештање оцена';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'минут';
$string['minutes'] = 'минут/а';
$string['miscellaneous'] = 'Разно';
$string['missingcategory'] = 'Морате одабрати категорију';
$string['missingcity'] = 'Недостаје град/насеље';
$string['missingcountry'] = 'Недостаје држава';
$string['missingdescription'] = 'Недостаје опис';
$string['missingemail'] = 'Недостаје адреса е-поште';
$string['missingfirstname'] = 'Недостаје име';
$string['missingfromdisk'] = 'Недостаје на диску';
$string['missingfullname'] = 'Недостаје пуно име';
$string['missinglastname'] = 'Недостаје презиме';
$string['missingname'] = 'Недостаје име';
$string['missingnewpassword'] = 'Недостаје нова лозинка';
$string['missingpassword'] = 'Недостаје лозинка';
$string['missingrecaptchachallengefield'] = 'Недостаје поље за reCAPTCHA';
$string['missingreqreason'] = 'Недостаје разлог';
$string['missingshortname'] = 'Недостаје кратки назив';
$string['missingshortsitename'] = 'Недостаје кратки назив сајта';
$string['missingsitedescription'] = 'Недостаје опис сајта';
$string['missingsitename'] = 'Недостаје назив сајта';
$string['missingstrings'] = 'Провера непреведених речи или израза';
$string['missingstudent'] = 'Морате нешто одабрати';
$string['missingsummary'] = 'Недостаје резиме';
$string['missingteacher'] = 'Морате нешто одабрати';
$string['missingurl'] = 'Недостаје URL';
$string['missingusername'] = 'Недостаје корисничко име';
$string['modchooserdisable'] = 'Искључи бирач активности';
$string['modchooserenable'] = 'Укључи бирач активност';
$string['moddoesnotsupporttype'] = 'Модул {$a->modname} не подржава постављања типа {$a->type}';
$string['modified'] = 'Измењено';
$string['moduleintro'] = 'Опис';
$string['modulesetup'] = 'Подешавање табела модула';
$string['modulesuccess'] = '{$a} табела је исправно подешено';
$string['modulesused'] = 'Коришћени модули';
$string['month'] = 'Месец';
$string['months'] = 'Месеци';
$string['moodledocs'] = 'Moodle документација';
$string['moodledocslink'] = 'Moodle документација за ову страницу';
$string['moodlerelease'] = 'Moodle верзија';
$string['moodleversion'] = 'Moodle верзија';
$string['more'] = 'још';
$string['morehelp'] = 'Више помоћи';
$string['moreinformation'] = 'Више информација о овој грешци';
$string['moreprofileinfoneeded'] = 'Молимо реците нам нешто више о себи';
$string['mostrecently'] = 'најновије';
$string['move'] = 'Премести';
$string['movecategoriessuccess'] = 'Успешно премештено  {$a->count} категорија/е у категорију \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Успешно премештено {$a->count} категорија/е на највиши ниво';
$string['movecategorycontentto'] = 'Премести у:';
$string['movecategorysuccess'] = 'Категорије \'{$a->moved}\' је успешно премештена  у категорију \'{$a->to}\'';
$string['movecategoryto'] = 'Премести категорију у:';
$string['movecategorytotopsuccess'] = 'Категорије \'{$a->moved}\' је успешно премештена на највиши ниво';
$string['movecontent'] = 'Премести {$a}';
$string['movecontentstoanothercategory'] = 'Премести садржај у другу категорију';
$string['movecoursemodule'] = 'Премести ресурс';
$string['movecoursesection'] = 'Премести секцију';
$string['movecourseto'] = 'Премести курс у:';
$string['movedown'] = 'Премести доле';
$string['movefilestohere'] = 'Премести датотеке овде';
$string['movefull'] = 'Премести {$a} на ову локацију';
$string['movehere'] = 'Премести овамо';
$string['moveleft'] = 'Помакни улево';
$string['moveright'] = 'Помакни удесно';
$string['movesection'] = 'Премести секцију {$a}';
$string['moveselectedcategoriesto'] = 'Премести изабране категорије у';
$string['moveselectedcoursesto'] = 'Премести изабране курсеве у...';
$string['movetoanotherfolder'] = 'Премести у други директоријум';
$string['moveup'] = 'Премести горе';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Нова лозинка мора бити различита од тренутне';
$string['mustconfirm'] = 'Морате потврдити своју пријаву на систем';
$string['mycourses'] = 'Моји курсеви';
$string['myfiles'] = 'Моје приватне датотеке';
$string['myfilesmanage'] = 'Уреди моје приватне датотеке';
$string['myhome'] = 'Моја почетна страница';
$string['mymoodledashboard'] = 'Мој Moodle командна табла';
$string['myprofile'] = 'Мој профил';
$string['name'] = 'Име';
$string['nameforlink'] = 'Како желите да назовете овај линк?';
$string['nameforpage'] = 'Назив';
$string['navigation'] = 'Навигација';
$string['needed'] = 'Потребно';
$string['never'] = 'Никад';
$string['neverdeletelogs'] = 'Никада не бриши  записе о активностима';
$string['new'] = 'Ново';
$string['newaccount'] = 'Нови кориснички налог';
$string['newcourse'] = 'Нови курс';
$string['newpassword'] = 'Нова лозинка';
$string['newpasswordfromlost'] = '<strong>ОБАВЕШТЕЊЕ:</strong> Ваша <strong>тренутна лозинка</strong> биће вам послата у <strong>другој</strong> од две поруке послате у току поступка  за поновног добијања изгубљене лозинке. Проверите да ли сте примили замену лозинке пре него што наставите са овим екраном.';
$string['newpassword_help'] = 'Унесите нову лозинку или оставите поље празно како бисте задржали текућу лозинку.';
$string['newpasswordtext'] = 'Поштована/и {$a->firstname},

Лозинка вашег налога на сајту \'{$a->sitename}\' је ресетована и додељена вам је нова привремена лозинка.

Ваши тренутни подаци за приступ систему су:
   корисничко име: {$a->username}
   лозинка: {$a->newpassword}

Молимо вас да посетите ову страницу како бисте променили своју лозинку:
   {$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Поздрав,
\'{$a->sitename}\' администратор,
{$a->signoff}';
$string['newpicture'] = 'Нова слика';
$string['newpicture_help'] = 'Да бисте додали нову слику, пронађите и одаберите једну (у JPG или PNG формату) и кликните на "Ажурирај профил". Слика ће бити исечена у облику квадрата а њена величина смањена на 100x100 пиксела.';
$string['newsitem'] = 'вест';
$string['newsitems'] = 'вести';
$string['newsitemsnumber'] = 'Број вести које треба приказати';
$string['newsitemsnumber_help'] = 'Ово подешавање одређује колико ће се скорашњих вести појавити у блоку Најновије вести, на страници курса. Ако подесите на "0 вести" овај блок неће бити приказан.';
$string['newuser'] = 'Нови корисник';
$string['newusernewpasswordsubj'] = 'Нови кориснички налог';
$string['newusernewpasswordtext'] = 'Поштована/и {$a->firstname},

Отворен вам је нови кориснички налог на сајту \'{$a->sitename}\' и додељена вам је нова привремена лозинка.

Ваше тренутне информације за приступ сајту су:
корисничко име: {$a->username}
лозинка: {$a->newpassword}
(мораћете да промените лозинку када се први пут пријавите на систему)

Да бисте почели да користите сајт \'{$a->sitename}\', пријавите се на {$a->link}

У већини програма за електронску пошту, ово би требало да се појави као плаво обојени линк на који је потребно само кликнути. Ако та опција не функционише, копирајте наведену адресу у адресну линију на врху прозора вашег веб читача.

Поздрав,
\'{$a->sitename}\' администратор,
{$a->signoff}';
$string['newusers'] = 'Нови корисници';
$string['newwindow'] = 'Нови прозор';
$string['next'] = 'Следећи';
$string['nextsection'] = 'Следeћа секција';
$string['no'] = 'Не';
$string['noblockstoaddhere'] = 'Не постоје блокови које можете додати овој страници.';
$string['nobody'] = 'Нико';
$string['nochange'] = 'Без промена';
$string['nocomments'] = 'Нема коментара';
$string['nocourses'] = 'Нема курсева';
$string['nocoursesfound'] = 'Ниједан курс не садржи појам \'{$a}\'';
$string['nocoursesyet'] = 'Нема курсева у овој категорији';
$string['nodstpresets'] = 'Администратор система није омогућио подршку за Daylight Savings Time.';
$string['nofilesselected'] = 'Није изабрана ниједна датотека за рестаурирање.';
$string['nofilesyet'] = 'Унутар овог курса још није постављена ниједна датотека';
$string['nograde'] = 'Нема оцене';
$string['nohelpforactivityorresource'] = 'Тренутно не постоји помоћ везана за овај ресурс или активност';
$string['noimagesyet'] = 'Унутар овог курса још није постављена ниједна слика';
$string['nologsfound'] = 'Логови нису нађени';
$string['nomatchingusers'] = 'Ниједан корисник се не поклапа са \'{$a}\'';
$string['nomorecourses'] = 'Није пронађено више курсева који се уклапају са задатим критеријумима';
$string['nomoreidnumber'] = 'Не користи се idnumber да би се избегле колизије';
$string['none'] = 'Ниједан';
$string['noneditingteacher'] = 'Предавач без уређивачких права';
$string['noneditingteacherdescription'] = 'Предавачи без уређивачких права могу да предају на курсевима и оцењују полазнике, али не могу да мењају активности.';
$string['nonstandard'] = 'Нестандардно';
$string['nopendingcourses'] = 'Нема курсева који чекају на одобрење';
$string['nopotentialadmins'] = 'Нема потенцијалних администратора';
$string['nopotentialcreators'] = 'Нема потенцијалних креатора курса';
$string['nopotentialstudents'] = 'Нема потенцијалних полазника';
$string['nopotentialteachers'] = 'Нема потенцијалних предавача';
$string['norecentactivity'] = 'Нема недавних активности';
$string['noreplybouncemessage'] = 'Одговорили сте на адресу електронске поште са које се поруке само шаљу (no-reply email address). Ако сте покушавали да одговорите на поруку са форума, молимо да то учините директно користећи {$a} форуме.

Следи садржај ваше поруке:';
$string['noreplybouncesubject'] = '{$a} - враћена е-порука.';
$string['noreplyname'] = 'Немојте одговарати на ову е-поруку';
$string['noresetrecord'] = 'Не постоји запис о овом захтеву за промену лозинке. Молимо вас да покренете нов захтев за промену лозинке.';
$string['noresults'] = 'Нема резултата';
$string['normal'] = 'Нормално';
$string['normalfilter'] = 'Нормална претрага';
$string['nosite'] = 'Није пронађен курс на нивоу сајта';
$string['nostudentsfound'] = '{$a} није пронађен';
$string['nostudentsingroup'] = 'Још нема полазника у овој групи';
$string['nostudentsyet'] = 'Ниједан полазник још није уписан на овај курс';
$string['nosuchemail'] = 'Нема такве адресе е-поште';
$string['notavailable'] = 'Није доступно';
$string['noteachersyet'] = 'Још увек нема предавача на овом курсу';
$string['notenrolled'] = '{$a} није уписан/а на овај курс.';
$string['notenrolledprofile'] = 'Овај профил није доступан јер корисник није пријављен за овај курс.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Напомена:</strong> Могућност мењања датума приликом обнављања ове резервне копије је онемогућена јер немате потребна овлашћења.';
$string['noteuserschangednonetocourse'] = 'Напомена: Када рестаурирате корисничке податке (у активностима, датотекама или порукама) морате да рестаурирате и кориснике курса. Ово подешавање је промењено за вас.';
$string['nothingnew'] = 'Нема новости од Ваше последње посете';
$string['nothingtodisplay'] = 'Нема ничега за приказ';
$string['notice'] = 'Напомена';
$string['noticenewerbackup'] = 'Ова датотека са резервном копијом је направљена помоћу Moodle верзије {$a->backuprelease} ({$a->backupversion}) и новија је од Вашег тренутно инсталираног система Moodle {$a->serverrelease} ({$a->serverversion}). Ово би могло узроковати одређене недоследности због тога што компатибилност система са резервним копијама креираним помоћу ранијих верзија не може бити гарантована.';
$string['notifications'] = 'Обавештења';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Корисник: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Ове извештаје о активностима можете видети на адреси {$a}/course/report/log/index.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Ово је списак грешака при приступу систему на {$a} од последњег обавештења које сте примили';
$string['notifyloginfailuressubject'] = '{$a} :: Обавештење о грешкама при приступу систему';
$string['notincluded'] = 'Није укључено';
$string['notingroup'] = 'Нажалост, морате бити члан групе како бисте видели ову активност.';
$string['notpublic'] = 'Није јавно!';
$string['nousersfound'] = 'Није пронађен ниједан корисник';
$string['nousersmatching'] = 'Није пронађен ниједан корисник који се подудара са \'{$a}\'';
$string['nousersyet'] = 'Још нема корисника';
$string['novalidcourses'] = 'Нема важећих курсева који би били приказани';
$string['now'] = 'сада';
$string['numattempts'] = '{$a} неуспешних приступа систему';
$string['numberofcourses'] = 'Број курсева';
$string['numberweeks'] = 'Број секција';
$string['numdays'] = '{$a} дан(а)';
$string['numhours'] = '{$a} h';
$string['numletters'] = '??? слово(а)';
$string['numminutes'] = '{$a} min';
$string['nummonths'] = '{$a} месец(a)';
$string['numseconds'] = '{$a} s';
$string['numviews'] = '{$a} преглед(а)';
$string['numweeks'] = '{$a} седмица(е)';
$string['numwords'] = '{$a} реч(и)';
$string['numyears'] = '{$a} година(е)';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Тренутна лозинка';
$string['olduserdirectory'] = 'Ово је СТАРИ кориснички директоријум који више није потребан. Можете га слободно обрисати. Датотеке из овог директоријума су копиране у НОВИ кориснички директоријум.';
$string['opentoguests'] = 'Приступ гостима';
$string['optional'] = 'опционо';
$string['options'] = 'опције';
$string['order'] = 'Поредак';
$string['originalpath'] = 'Оригинална путања';
$string['orphanedactivitiesinsectionno'] = 'Активности сирочићи (секција {$a})';
$string['other'] = 'Остали';
$string['outline'] = 'Кратак преглед';
$string['outlinereport'] = 'Скраћени извештај';
$string['page'] = 'Страница';
$string['pagea'] = 'Страница {$a}';
$string['pageheaderconfigablock'] = 'Конфигурисање блока у {$a->fullname}';
$string['pagepath'] = 'Путања до странице';
$string['pageshouldredirect'] = 'Ова страница би требало да вас аутоматски преусмери. Уколико се ништа не догађа молимо вас да за наставак употребите доњи линк.';
$string['parentcategory'] = 'Надређена категорија';
$string['parentcoursenotfound'] = 'Надређени курс није пронађен!';
$string['parentfolder'] = 'Надређени директоријум';
$string['participants'] = 'Учесници';
$string['participantslist'] = 'Списак учесника';
$string['participationratio'] = 'Однос учешћа';
$string['participationreport'] = 'Извештај о учешћу';
$string['password'] = 'Лозинка';
$string['passwordchanged'] = 'Лозинка је промењена';
$string['passwordconfirmchange'] = 'Потврдите промену лозинке';
$string['passwordextlink'] = 'Следећи линк Вам је на располагању за опоравак Ваше изгубљене лозинке. Клик на њега ће Вас извести из Moodle система.';
$string['passwordforgotten'] = 'Заборављена лозинка';
$string['passwordforgotteninstructions'] = 'Ваши подаци прво морају бити пронађени у бази података корисника. Молимо унесите <strong>или</strong> своје корисничко име или пријављену електронску адресу у одговарајуће поље. Нема потребе да уносите оба податка.';
$string['passwordforgotteninstructions2'] = 'За ресетовање Ваше лозинке упишите своје корисничко име или електронску адресу. Уколико ти подаци постоје у бази података, биће Вам послата порука на електронску адресу са упутством како поново да добијете приступ.';
$string['passwordnohelp'] = 'Није на располагању никаква помоћ за проналажење Ваше изгубљење лозинке. Молимо контактирајте Вашег Moodle администратора.';
$string['passwordrecovery'] = 'Да, треба ми помоћ за приступ систему';
$string['passwordsdiffer'] = 'Лозинке се не поклапају';
$string['passwordsent'] = 'Лозинка је послата';
$string['passwordsenttext'] = '<p>Е-порука је послата на Вашу адресу е-поште {$a->email}.</p>
   <p><b>Молимо проверите Вашу е-пошту како бисте примили нову лозинку</b></p>
   <p>Нова лозинка је аутоматски генерисана, па бисте је можда желели
   <a href="{$a->link}">променити у нешто што ћете моћи лакше да запамтите</A>.</p>';
$string['passwordset'] = 'Ваша лозинка је подешена.';
$string['path'] = 'Путања';
$string['pathnotexists'] = 'Путања не постоји на Вашем серверу!';
$string['pathslasherror'] = 'Путања се не може завршавати косом цртом!';
$string['paymentinstant'] = 'Употребите дугме испод како бисте извршили уплату и уписали курс у року од неколико минута!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> на чекању</small>)';
$string['paymentrequired'] = 'Овај курс није бесплатан.';
$string['payments'] = 'Уплате';
$string['paymentsorry'] = 'Хвала Вам на Вашој уплати! Нажалост Ваша уплата још није потпуно обрађена, те још нисте регистровани за приступ курсу "{$a->fullname}". Молимо Вас покушајте наставити са приступом курсу за неколико секунди, али ако се проблеми наставе, молимо обавестите предавача {$a->teacher} или администратора сајта';
$string['paymentthanks'] = 'Хвала Вам на Вашој уплати! Сада сте уписани на курс:<br />"{$a}"';
$string['pendingrequests'] = 'Захтеви на чекању';
$string['periodending'] = 'Завршетак периода ({$a})';
$string['perpage'] = 'По страници';
$string['perpagea'] = 'По страници: {$a}';
$string['personal'] = 'Лично';
$string['personalprofile'] = 'Лични профил';
$string['phone'] = 'Телефон';
$string['phone2'] = 'Мобилни телефон';
$string['phpinfo'] = 'PHP информације';
$string['pictureof'] = 'Слика {$a}';
$string['pictureofuser'] = 'Слика корисника';
$string['pleaseclose'] = 'Молим Вас затворите сада овај прозор.';
$string['pleasesearchmore'] = 'Наставите претрагу';
$string['pleaseusesearch'] = 'Употребите претрагу';
$string['plugin'] = 'Додатак';
$string['plugincheck'] = 'Провера додатака';
$string['plugindeletefiles'] = 'Сви подаци повезани са додатком: \'{$a->name}\' су обрисани из базе података. Да бисте спречили аутоматску реинсталацију додатка,  потребно је да сада са сервера обришете овај директоријум: {$a->directory}';
$string['pluginsetup'] = 'Подешавање табеле додатака';
$string['policyaccept'] = 'Разумем и пристајем';
$string['policyagree'] = 'Да би сте наставили коришћење овог сајта морате се сложити са правилима коришћења. Да ли се слажете?';
$string['policyagreement'] = 'Сагласност са правилником о коришћењу сајта';
$string['policyagreementclick'] = 'Линк ка правилнику о коришћењу сајта';
$string['popup'] = 'искачући прозор';
$string['popupwindow'] = 'Отвори датотеку у новом прозору';
$string['popupwindowname'] = 'Искачући прозор';
$string['post'] = 'Порука';
$string['posts'] = 'Поруке';
$string['potentialadmins'] = 'Потенцијални администратори';
$string['potentialcreators'] = 'Потенцијални креатори курса';
$string['potentialstudents'] = 'Потенцијални полазници';
$string['potentialteachers'] = 'Потенцијални предавачи';
$string['preferences'] = 'Параметри';
$string['preferredlanguage'] = 'Преферирани језик';
$string['preferredtheme'] = 'Преферирана графичка тема';
$string['preprocessingbackupfile'] = 'Препроцесирање датотеке резервне копије';
$string['prev'] = 'Претходно';
$string['preview'] = 'Преглед';
$string['previewhtml'] = 'Преглед у HTML формату';
$string['previeworchoose'] = 'Преглед или избор шеме изгледа сајта';
$string['previous'] = 'Претходни';
$string['previouslyselectedusers'] = 'Претходно изабрани корисник се не поклапа са \'{$a}\'';
$string['previoussection'] = 'Претходна секција';
$string['primaryadminsetup'] = 'Подеси налог администратора';
$string['profile'] = 'Профил';
$string['profilenotshown'] = 'Овај опис корисничког профила неће бити приказан све док се корисник не упише барем на један курс.';
$string['publicprofile'] = 'Јавни профил';
$string['publicsitefileswarning'] = 'Напомена: Датотекама које су овде смештене сви могу приступити.';
$string['publicsitefileswarning2'] = 'Напомена: Датотекам које су овде смештене може да приступи свако ко зна (или погоди) URL. Из разлога безбедности, препоручује се брисање датотека резервне копије одмах након након завшетка њиховог рестаурирања.';
$string['publicsitefileswarning3'] = 'Напомена: Датотекама које су овде постављене може да приступи свако ко зна (или може да погоди) URL.<br /> Из разлога безбедности, датотеке резервне копије би требало да буду чуване само у зато предвиђеном директоријуму (backupdata).';
$string['publish'] = 'Објави';
$string['question'] = 'Питање';
$string['questionsinthequestionbank'] = 'Питања у банци питања';
$string['readinginfofrombackup'] = 'Учитавање информација из резервне копије';
$string['readme'] = 'Прочитај ме';
$string['recentactivity'] = 'Недавне активности';
$string['recentactivityreport'] = 'Потпуни извештај о недавним активностима...';
$string['recipientslist'] = 'Списак прималаца';
$string['recreatedcategory'] = 'Поновно креирана категорија {$a}';
$string['redirect'] = 'Преусмери';
$string['reducesections'] = 'Смањи број секција';
$string['refresh'] = 'Освежи';
$string['refreshingevents'] = 'Освежавање догађаја';
$string['registration'] = 'Moodle регистрација';
$string['registrationcontact'] = 'Јавни контакт';
$string['registrationcontactno'] = 'Не, не желим контактну форму на списку сајтова';
$string['registrationcontactyes'] = 'Да, прикажите форму како би ме други Moodle корисници могли контактирати';
$string['registrationemail'] = 'Обавештења путем е-поште';
$string['registrationinfo'] = '<p>Ова страна Вам омогућава да региструјете Ваш Moodle сајт на moodle.org. Регистрација је бесплатна.
Главна корист регистрације је у томе што ћете бити додати на листу за примање важних обавештења путем електронске поште, као што су сигурносна упозорења и нова издања Moodle CMS-a. Ова листа се користи врло разумно и штедљиво, односно само за заиста важне информације.</p>
<p>Подразумева се да ће све информације које нам доставите бити поверљиве, и да неће бити прослеђене даље, продате или на било који други начин злоупотребљене.
Једини разлог прикупљања информација је у сврху подршке и помоћи у изградњи статистичке слике Moodle заједнице у целини.</p>
<p>Ако желите, име Вашег сајта, државу и URL можете додати на јавну листу Moodle сајтова.
</p><p>Све нове регистрације се ручно проверавају пре додавања на листу.
Кад се једном нађете на листи, можете ажурирати Вашу регистрацију (и информације на јавној листи) у било које време, тако што ћете нам поново послати ову форму.</p>';
$string['registrationinfotitle'] = 'Информација о регистрацији';
$string['registrationno'] = 'Не, не желим да примам обавештења путем е-поште';
$string['registrationsend'] = 'Слање регистрационих информација на moodle.org';
$string['registrationyes'] = 'Да, молим обавештавајте ме о важним дешавањима';
$string['reject'] = 'Одбаци';
$string['rejectdots'] = 'Одбаци';
$string['reload'] = 'Учитај поново';
$string['remoteappuser'] = 'Удаљени {$a} Корисник';
$string['remove'] = 'Уклони';
$string['removeadmin'] = 'Уклони администратора';
$string['removecreator'] = 'Уклони креатора курса';
$string['removestudent'] = 'Уклони полазника';
$string['removeteacher'] = 'Уклони предавача';
$string['rename'] = 'Преименовање';
$string['renamefileto'] = 'Преименовање <b>{$a}</b> у';
$string['report'] = 'Извештај';
$string['reports'] = 'Извештаји';
$string['repositories'] = 'Репозиторијум';
$string['requestcourse'] = 'Захтевај курс';
$string['requestedby'] = 'Захтеван од стане';
$string['requestedcourses'] = 'Захтевани курсеви';
$string['requestreason'] = 'Разлог за захтевање курса';
$string['required'] = 'Обавезно';
$string['requirespayment'] = 'Овај курс захтева плаћање за приступ';
$string['reset'] = 'Ресетовање';
$string['resetcomponent'] = 'Компонента';
$string['resetcourse'] = 'Ресетовање курса';
$string['resetinfo'] = 'Ова страница Вам дозвољава да из курса избришете све податке о корисницима, задржавајући активности и друга подешавања. Молимо будите обазриви јер избором ставки испод и потврђивањем ове форме трајно бришете изабране кориснике и све податке везане за њих са овог курса!';
$string['resetnotimplemented'] = 'Ресетовање није извршено';
$string['resetrecordexpired'] = 'Линк за промену лозинке који сте користи је истекао јер је старији од {$a} минута. Молимо вас да поново покренете захтев за промену лозинку.';
$string['resetstartdate'] = 'Ресетуј датума почетка';
$string['resetstatus'] = 'Статус';
$string['resettask'] = 'Задатак';
$string['resettodefaults'] = 'Враћање на подразумеване вредности';
$string['resortbyfullname'] = 'По пуном називу';
$string['resortbyidnumber'] = 'По id броју';
$string['resortbyshortname'] = 'По скраћеном називу';
$string['resortcourses'] = 'Сортирај курсеве';
$string['resortsubcategoriesbyidnumber'] = 'Сортирај поткатегорије по id броју';
$string['resortsubcategoriesbyname'] = 'Сортирај поткатегорије по називу';
$string['resource'] = 'Ресурс';
$string['resourcedisplayauto'] = 'Аутоматски';
$string['resourcedisplaydownload'] = 'Приморај на преузимање';
$string['resourcedisplayembed'] = 'Угради (Embed)';
$string['resourcedisplayframe'] = 'У оквиру (frame)';
$string['resourcedisplaynew'] = 'Нови прозор';
$string['resourcedisplayopen'] = 'Отвори';
$string['resourcedisplaypopup'] = 'У искачућем прозору';
$string['resources'] = 'Ресурси';
$string['resources_help'] = 'Ресурси омогућавају додавање било које врсте веб садржаја на Ваш курс.';
$string['restore'] = 'Рестаурирање резервнe копијe';
$string['restorecancelled'] = 'Рестаурирање је отказано';
$string['restorecannotassignroles'] = 'Процедура обнављања резервне копије података мора да додели улоге, а Ви немате овлашћење за то';
$string['restorecannotcreateorassignroles'] = 'Процедура обнављања резервне копије података мора да креира или додели улоге, а Ви немате овлашћење за то';
$string['restorecannotcreateuser'] = 'Процедура обнављања резервне копије података мора да креира корисника \'{$a}\', а Ви немате овлашћење за то';
$string['restorecannotoverrideperms'] = 'Процедура обнављања резервне копије података мора да измени овлашћења, а Ви немате овлашћење за то';
$string['restorecoursenow'] = 'Рестаурирајте овај курс управо сада!';
$string['restoredaccount'] = 'Обновљени кориснички налог';
$string['restoredaccountinfo'] = 'Овај кориснички налог је увезен са другог сервера и лозинка је изгубљена. Како бисте задали нову лозинку помоћу е-поште, кликните на "Настави".';
$string['restorefinished'] = 'Рестаурирање је успешно завршено';
$string['restoreto'] = 'Рестаурирати у';
$string['restoretositeadding'] = 'Упозорење! Желите да рестаурирате резервну копију на насловну страницу сајта, тако што ћете постојећем придодати нови садржај!';
$string['restoretositedeleting'] = 'Упозорење! Желите да рестаурирате резервну копију на насловну страницу сајта, тако што ћете прво обрисати постојећи садржај са ње!';
$string['restoreuserconflict'] = 'Покушај рестаурирања корисника \'{$a}\' из рзервене копије података ће проузроковати конфликт';
$string['restoreuserinfofailed'] = 'Процес рестаурирања података је заустављен јер немате овлашћења за рестаурирање корисничких података.';
$string['restoreusersprecheck'] = 'Провера корисничких података';
$string['restoreusersprecheckerror'] = 'Уочени су одређени проблеми приликом провере корисничких података';
$string['restricted'] = 'Ограничено';
$string['returningtosite'] = 'Већ поседујете кориснички налог?';
$string['returntooriginaluser'] = 'Врати се на {$a}';
$string['revert'] = 'Вратите се назад';
$string['role'] = 'Улога';
$string['roleassignments'] = 'Додела улоге';
$string['rolemappings'] = 'Мапирања улога';
$string['rolerenaming'] = 'Преименовање улоге';
$string['rolerenaming_help'] = 'Ово подешавање омогућава промену приказаних назива за улоге које се користе на курсу. Мења се само приказани назив  улоге - овлашћења улоге остају иста. Нови називи улога ће се појавити на страници са учесницима курса и свим осталим местима унутар курса. Уколико је улога којој је промењен назив једна од оних коју је администратор изабрао као "менаџер курса", нови назив улоге ће се, такође, појавити и као део списка курсева.';
$string['roles'] = 'Улоге';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Број нових RSS чланака';
$string['rsserror'] = 'Грешка у читању RSS података';
$string['rsserrorauth'] = 'RSS линк не садржи исправан токен за проверу идентитета';
$string['rsserrorguest'] = 'Овај RSS извор вести користи анонимни  (као гост) приступ подацима, али гости овде немају овлашћење за  читање података. Посетите изворну локацију са које овај извор вести долази (URL) као регистровани корисник и преузмите одатле нови RSS линк.';
$string['rsskeyshelp'] = 'Да би се обезбедила сигурност и приватност, URL адреса RSS извора садржи специјални токен који идентификује корисника за кога је токен креиран. Ово ће спречити друге кориснике да преко RSS извора приступе оним деловима Moodlea којима то не би смели.
Овај токен се аутоматски креира када први пут приступате делу Moodlea који производи RSS извор. Ако мислите да је је ваш токен RSS извора на неки начин компромитован можете затражити нови токен тако што ћете овде кликнути на линк \'Ресетуј\'. Молимо вас, имајте у виду да ће тренутна URL адреса RSS извора постати неважећа.';
$string['rsstype'] = 'RSS сервис за ову активност';
$string['saveandnext'] = 'Сачувај и прикажи следеће';
$string['savechanges'] = 'Сачувај промене';
$string['savechangesanddisplay'] = 'Сачувај и прикажи';
$string['savechangesandreturntocourse'] = 'Сачувај и врати се на курс';
$string['savecomment'] = 'Сачувај коментар';
$string['savedat'] = 'Сачувано у:';
$string['savepreferences'] = 'Сачувај својства';
$string['saveto'] = 'Сачувај у';
$string['scale'] = 'Скала за оцењивање';
$string['scale_help'] = 'Скала пружа начин за евалуацију или оцењивања постигнућа у активности. Дефинисана је као уређена листа вредности, у распону од негативних до позитивних, одвојених зарезима. На пример: "Разочаравајуће, Недовољно добро, Просечно, Добро, Врло добро, Одлично!"';
$string['scales'] = 'Скале за оцењивање';
$string['scalescustom'] = 'Прилагођене скале за оцењивање';
$string['scalescustomcreate'] = 'Додај нову скалу за оцењивање';
$string['scalescustomno'] = 'Прилагођене скале за оцењивање још увек нису креиране';
$string['scalesstandard'] = 'Стандардне скале за оцењивање';
$string['scalestandard'] = 'Стандардна скала';
$string['scalestandard_help'] = 'Стандардна скала је доступна на нивоу целог сајта, за све курсеве.';
$string['scalestip'] = 'Како бисте креирали сопствене, прилагођене скале за оцењивање, употребите линк \'Скале...\' у менију за администрацију курса.';
$string['scalestip2'] = 'Да би сте креирали прилагођене скале, кликните на линк Оцене у административном менију курса, а онда изаберите Уреди Скале';
$string['schedule'] = 'Распоред';
$string['screenshot'] = 'Снимак екрана';
$string['search'] = 'Претрага';
$string['searchagain'] = 'Поновна претрага';
$string['searchbyemail'] = 'Претраживање по адреси е-поште';
$string['searchbyusername'] = 'Претраживање по корисничком имену';
$string['searchcourses'] = 'Претражи курсеве';
$string['searchhelp'] = '<p> Можете да претражујете више речи одједном. као и да  прецизирате своју претрагу на следећи начин:</p>
<ul>
<li>реч- налази било које појављивање ове речи унутар текста који се претражује (па и у склопу других речи).</li>
<li>+реч – биће пронађена само речи које се потпуно поклапају.</li>
<li>-реч – у резултате претраге се не укључује ова реч.</li>
</ul>';
$string['search_help'] = 'За основно претраживање једне или више речи било где у тексту, само их упишите одвојене размацима. Могу се претраживати све речи дуже од 2 знака.

За напредно претраживање, кликните на дугме за претрагу без уписивања појмова у поље за претрагу, како бисте приступили обрасцу за напредно претраживање.';
$string['searchoptions'] = 'Опције за претрагу';
$string['searchresults'] = 'Резултати претраге';
$string['sec'] = 'сек';
$string['seconds'] = 'секунд/е';
$string['secondstotime172800'] = '2 дана';
$string['secondstotime259200'] = '3 дана';
$string['secondstotime345600'] = '4 дана';
$string['secondstotime432000'] = '5 дана';
$string['secondstotime518400'] = '6 дана';
$string['secondstotime604800'] = '1 седмица';
$string['secondstotime86400'] = '1 дан';
$string['secretalreadyused'] = 'Линк за потврду промене шифре је већ кориштен, шифра није била промењена.';
$string['secs'] = 's';
$string['section'] = 'Секција';
$string['sectionname'] = 'Назив секције';
$string['sections'] = 'Секције';
$string['sectionusedefaultname'] = 'Користи подразумевано име секције';
$string['seealsostats'] = 'Погледајте и статистику';
$string['selctauser'] = 'Изабери корисника';
$string['select'] = 'Изаберите';
$string['selectacategory'] = 'Молимо вас да изаберете категорију';
$string['selectacountry'] = 'Изабери државу';
$string['selectacourse'] = 'Изабери курс';
$string['selectacoursesite'] = 'Изабери курс  или сајт';
$string['selectagroup'] = 'Изабери групу';
$string['selectall'] = 'Изабери све';
$string['selectamodule'] = 'Молимо изаберите модул активности';
$string['selectanaction'] = 'Изабери акцију';
$string['selectanoptions'] = 'Изабери опцију';
$string['selectaregion'] = 'Изабери регион';
$string['selectcategorysort'] = 'Које категорије желите да сортирате?';
$string['selectcategorysortby'] = 'Изаберите како желите да сортирате категорије';
$string['selectcoursesortby'] = 'Изаберите како желите да поређате курсеве';
$string['selectdefault'] = 'Изабери подразумевано';
$string['selectedcategories'] = 'Изабране категорије';
$string['selectedfile'] = 'Изабрана датотека';
$string['selectednowmove'] = '{$a} датотека означено за премештање. Сада идите на место где желите да преместите датотеке и кликните на \'Премести датотеке овде\'';
$string['selectfiles'] = 'Одаберите датотеке';
$string['selectmoduletoviewhelp'] = 'Изаберите активност или ресурс како бисте видели помоћне информације о њима.

Да бисте брзо додали активност или ресурс кликните два пута на назив одговарајуће активности односно ресурса.';
$string['selectnos'] = 'Изаберите \'Не\' за све';
$string['selectperiod'] = 'Изаберите период';
$string['senddetails'] = 'Пошаљи моје личне податке е-поштом';
$string['separate'] = 'Одвоји';
$string['separateandconnected'] = 'Одвојени и повезани начини сазнавања';
$string['separateandconnectedinfo'] = 'Ова скала се заснива на теорији одвојеног и повезаног сазнавања. Ова теорија описује два различита начина на које можемо да учимо о стварима које видимо и чујемо. <ul> <li><strong>Одвојени начин учења</strong> - полазници остају објективни што је више могуће без укључивања осећања. У дискусији са другим људима, они воле да бране своје идеје и ставове, користећи логику како би пронашли недостатке у идејама својих опонената.</li> <li><strong>Повезани начин учења</strong> - полазници су више осетљиви на друге људе. Они имају развијену способност емпатије и показују тенденцију да слушају и постављају питања док не осете да могу "разумети ствари из угла гледања својих саговорника". Они уче тако што покушавају да деле искуства која воде знању које проналазе код других људи.</li></ul>';
$string['servererror'] = 'Дошло је до грешке у току комуникације са сервером';
$string['serverlocaltime'] = 'Локално време сервера';
$string['setcategorytheme'] = 'Подеси графичку тему категорије';
$string['setpassword'] = 'Подеси лозинку';
$string['setpasswordinstructions'] = 'Молимо вас да унесете и поновите своју нову лозинку испод и потом кликнете на "Подеси лозинку". <br />Ваша нова лозинка биће сачувана а ви ћете бити пријављени';
$string['settings'] = 'Подешавања';
$string['shortname'] = 'Кратки назив';
$string['shortnamecollisionwarning'] = '[*] = Овај кратки назив већ користи неки други курс, те ће морати бити промењен по одобравању';
$string['shortnamecourse'] = 'Скраћени назив курса';
$string['shortnamecourse_help'] = 'Скраћен назив курса се приказује у навигацији и као део наслова електронске поруке која се шаље са са курса.';
$string['shortnametaken'] = 'Наведена скраћеница је већ у употреби за неки други курс ({$a})';
$string['shortnameuser'] = 'Краће име корисника';
$string['shortsitename'] = 'Кратки назив сајта (нпр. једна реч)';
$string['show'] = 'Прикажи';
$string['showactions'] = 'Прикажи акције';
$string['showadvancedsettings'] = 'Прикажи напредних подешавања';
$string['showall'] = 'Прикажи свих {$a}';
$string['showallcourses'] = 'Прикажи све курсеве';
$string['showallusers'] = 'Прикажи све кориснике';
$string['showblockcourse'] = 'Прикажи списак курсева који садрже блокове';
$string['showcategory'] = 'Прикажи {$a}';
$string['showcomments'] = 'Прикажи/сакриј коментаре';
$string['showcommentsnonjs'] = 'Прикажи коментаре';
$string['showdescription'] = 'Прикажи опис на страници курса';
$string['showdescription_help'] = 'Ако је ово подешавање омогућено, горњи опис биће приказан на страници курса одмах испод линка активности или ресурса.';
$string['showgrades'] = 'Прикажи оцене полазницима';
$string['showgrades_help'] = 'Многе активности на курсу се могу оцењивати. Ово подешавање одређује да ли полазник може да види списак свих својих оцена на курсу преко линка Оцене у блоку за администрацију курса.';
$string['showingacourses'] = 'Приказ свих {$a} курс(ев)а';
$string['showingxofycourses'] = 'Приказ курсева {$a->start} до {$a->end} од укупно {$a->total} курс(ев)а';
$string['showlistofcourses'] = 'Прикажи списак курсева';
$string['showmodulecourse'] = 'Прикажи списка курсева који садрже активности';
$string['showonly'] = 'Прикажи само';
$string['showperpage'] = 'Прикажи {$a} по страници';
$string['showrecent'] = 'Прикажи недавне активности';
$string['showreports'] = 'Прикажи извештаја о активностима';
$string['showreports_help'] = 'Извештаји о активностима приказују активност сваког учесника на курсу. Осим пописа њихових доприноса, попут порука на форумима или предатих радова за задатке, ови извештаји, такође, укључују записе о приступима. Ово подешавање одређује да ли полазници могу да виде извештаје о својој активности, преко њихових страница са профилом.';
$string['showsettings'] = 'Прикажи подешавања';
$string['showtheselogs'] = 'Прикажи ове записе о активностима';
$string['showthishelpinlanguage'] = 'Прикажи ову помоћ на језику: {$a}';
$string['since'] = 'Од';
$string['sincelast'] = 'од последњег приступа систему';
$string['site'] = 'Сајт';
$string['sitedefault'] = 'Подразумевано за сајт';
$string['siteerrors'] = 'Грешке на сајту';
$string['sitefiles'] = 'Датотеке сајта';
$string['sitefilesused'] = 'Датотеке сајта коришћени у овом курсу';
$string['sitehome'] = 'Насловна страна сајта';
$string['sitelegacyfiles'] = 'Изворне датотеке сајта';
$string['sitelogs'] = 'Записи о активностима на сајту';
$string['sitemessage'] = 'Пошаљи поруку корисницима';
$string['sitenews'] = 'Новости';
$string['sitepages'] = 'Странице сајта';
$string['sitepartlist'] = 'Немате одговарајуће дозволе за преглед списка учесника';
$string['sitepartlist0'] = 'Морате бити предавач сајта да би Вам било дозвољено да видите списак учесника сајта.';
$string['sitepartlist1'] = 'Морате бити предавач да би Вам било дозвољено да видите списак учесника сајта.';
$string['sites'] = 'Сајтови';
$string['sitesection'] = 'Укључи и тематску секцију';
$string['sitesettings'] = 'Подешавања сајта';
$string['siteteachers'] = 'Предавачи сајта';
$string['size'] = 'Величина';
$string['sizeb'] = 'бајта';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Прескочено';
$string['skiptocategorylisting'] = 'Пређи на списак категорија';
$string['skiptocoursedetails'] = 'Пређи на детаљне информације о курсу';
$string['skiptocourselisting'] = 'Пређи на списак курсева';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Друштвени форум - најновије теме';
$string['someallowguest'] = 'Неки од курсева могу дозволити приступ гостима (анонимним корисницима)';
$string['someerrorswerefound'] = 'Поједине информације недостају или су нетачне. Погледајте детаље испод.';
$string['sort'] = 'Сортирај';
$string['sortby'] = 'Сортирај по';
$string['sortbyx'] = 'Сортирај растућим редоследом пo {$a}';
$string['sortbyxreverse'] = 'Сортирај опадајућим редоследом пo {$a}';
$string['sortcategoriesbyidnumber'] = 'Сортирај категорије по ID броју';
$string['sortcategoriesbyname'] = 'Сортирај категорије по називу';
$string['sortcoursesbyfullname'] = 'Сортирај категорије по пуном називу';
$string['sortcoursesbyidnumber'] = 'Сортирај курсеве по ID броју';
$string['sortcoursesbyshortname'] = 'Сортирај курсеве по скраћеном називу';
$string['sorting'] = 'Сортирање';
$string['sourcerole'] = 'Изворна улога';
$string['specifyname'] = 'Морате навести име.';
$string['standard'] = 'Стандардно';
$string['starpending'] = '([*] = курс чека на одобрење)';
$string['startdate'] = 'Датум почетка курса';
$string['startdate_help'] = 'Ово подешавање одређује почетак прве недеље за курс у недељном формату. Оно такође одређује најранији датум за који ће бити доступни извештаји о активностима на курсу.';
$string['startingfrom'] = 'Почни од';
$string['startsignup'] = 'Креирај нови налог';
$string['state'] = 'Држава/Република';
$string['statistics'] = 'Статистика';
$string['statisticsgraph'] = 'Графикон статистике';
$string['stats'] = 'Статистика';
$string['statslogins'] = 'Приступи систему';
$string['statsmodedetailed'] = 'Детаљни (кориснички) приказ';
$string['statsmodegeneral'] = 'Општи приказ';
$string['statsnodata'] = 'Нема доступних података за ту комбинацију курса и временског периода.';
$string['statsnodatauser'] = 'Нема доступних података за ту комбинацију курса, корисника и временског периода.';
$string['statsoff'] = 'Статистика тренутно није омогућено';
$string['statsreads'] = 'Прегледи';
$string['statsreport1'] = 'Приступи систему';
$string['statsreport10'] = 'Активност корисника';
$string['statsreport11'] = 'Најактивнији курсеви';
$string['statsreport12'] = 'Најактивнији курсеви (вредносно)';
$string['statsreport13'] = 'Курсеви са највише учешћа (уписа)';
$string['statsreport14'] = 'Курсеви са највише учешћа (приказа/порука)';
$string['statsreport2'] = 'Прикази (све улоге)';
$string['statsreport3'] = 'Поруке (све улоге)';
$string['statsreport4'] = 'Укупна активност (све улоге)';
$string['statsreport5'] = 'Укупна активност (прикази и поруке)';
$string['statsreport7'] = 'Активност корисника (прикази и поруке)';
$string['statsreport8'] = 'Све активности корисника';
$string['statsreport9'] = 'Приступи (сајту/курсу)';
$string['statsreportactivity'] = 'Укупна активност (све улоге)';
$string['statsreportactivitybyrole'] = 'Укупна активност (прегледи и поруке)';
$string['statsreportforuser'] = 'за';
$string['statsreportlogins'] = 'Приступи систему';
$string['statsreportreads'] = 'Прикази (све улоге)';
$string['statsreporttype'] = 'Тип извештаја';
$string['statsreportwrites'] = 'Поруке (све улоге)';
$string['statsstudentactivity'] = 'Активност полазника';
$string['statsstudentreads'] = 'Прегледи полазника';
$string['statsstudentwrites'] = 'Објаве полазника';
$string['statsteacheractivity'] = 'Активност предавача';
$string['statsteacherreads'] = 'Прикази предавача';
$string['statsteacherwrites'] = 'Поруке предавача';
$string['statstimeperiod'] = 'Временски период - трајање:';
$string['statsuniquelogins'] = 'Различити приступи систему';
$string['statsuseractivity'] = 'Све активности';
$string['statsuserlogins'] = 'Приступи систему';
$string['statsuserreads'] = 'Прикази';
$string['statsuserwrites'] = 'Поруке';
$string['statswrites'] = 'Поруке';
$string['status'] = 'Статус';
$string['stringsnotset'] = 'Следећи изрази нису дефинисани у {$a}';
$string['studentnotallowed'] = 'Нажалост, не можете приступити овом курсу као \'{$a}\'';
$string['students'] = 'Полазници';
$string['studentsandteachers'] = 'Полазници и предавачи';
$string['subcategories'] = 'Поткатегорије';
$string['subcategory'] = 'Поткатегорија';
$string['subcategoryof'] = 'Поткатегорија од {$a}';
$string['submit'] = 'Проследи';
$string['success'] = 'Успешно';
$string['summary'] = 'Резиме';
$string['summary_help'] = 'Сажетак је кратак текст који припрема полазнике за активности унутар одређене теме односно недеље. Текст се приказује на страници курса испод назива секције.';
$string['summaryof'] = 'Резиме за {$a}';
$string['supplyinfo'] = 'Више детаља';
$string['suspended'] = 'Суспендован';
$string['suspendedusers'] = 'Суспендовани корисници';
$string['switchdevicedefault'] = 'Прелазак на стандардну графичку тему';
$string['switchdevicerecommended'] = 'Прелазак на препоручену графичку тему за ваш уређај';
$string['switchrolereturn'] = 'Повратак на моју нормалну улогу';
$string['switchroleto'] = 'Промени улогу у...';
$string['tag'] = 'Ознака';
$string['tagalready'] = 'Ознака већ постоји';
$string['tagmanagement'] = 'Додај/обриши ознаке...';
$string['tags'] = 'Ознаке';
$string['targetrole'] = 'Циљна улога';
$string['teacheronly'] = 'само за {$a}';
$string['teacherroles'] = '{$a} улоге';
$string['teachers'] = 'Предавачи';
$string['textediting'] = 'Едитор текста';
$string['texteditor'] = 'Користити стандардне веб форме';
$string['textformat'] = 'Обичан текстуални формат';
$string['thanks'] = 'Хвала';
$string['theme'] = 'Графичка тема';
$string['themes'] = 'Графичке теме';
$string['themesaved'] = 'Нова графичка тема је сачувана';
$string['therearecourses'] = 'Постоји {$a} курс/а/ева';
$string['thereareno'] = 'Не постоје {$a} у овом курс';
$string['thiscategory'] = 'Ова категорија';
$string['thiscategorycontains'] = 'Ова категорија садржи';
$string['time'] = 'Време';
$string['timezone'] = 'Временска зона';
$string['to'] = 'До';
$string['tocontent'] = 'Одредишна ставка "{$a}"';
$string['tocreatenewaccount'] = 'Прескочи за креирање новог корисничког налога';
$string['today'] = 'Данас';
$string['todaylogs'] = 'Данашњи записи о активностима';
$string['toeveryone'] = 'свима';
$string['toomanybounces'] = 'Са ове електронске адресе вратило се превише порука. <b>Морате</b> је променити да бисте наставили.';
$string['toomanytoshow'] = 'Превише корисника за приказ';
$string['toomanyusersmatchsearch'] = 'Превише корисника ({$a->count}) се поклапа са\'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Превише корисника за приказ ({$a}) to show';
$string['toonly'] = 'само за {$a}';
$string['top'] = 'Врх';
$string['topic'] = 'Тема';
$string['topichide'] = 'Сакривање ове теме од {$a}';
$string['topicoutline'] = 'Преглед теме';
$string['topicshow'] = 'Приказ ове теме за {$a}';
$string['toplevelcategory'] = 'Категорија највишег нивоа';
$string['total'] = 'Укупно';
$string['totopofsection'] = 'На почетак секције "{$a}"';
$string['trackforums'] = 'Праћење форума';
$string['trackforumsno'] = 'НЕ: не бележи информације о томе које сам поруке претходно прочитао/ла';
$string['trackforumsyes'] = 'ДА: истакни нове поруке';
$string['trysearching'] = 'Покушајте са претраживањем.';
$string['turneditingoff'] = 'Искључи уређивање';
$string['turneditingon'] = 'Укључи уређивање';
$string['undecided'] = 'Неодлучни';
$string['unfinished'] = 'Недовршено';
$string['unknowncategory'] = 'Непозната категорија';
$string['unknownerror'] = 'Непозната грешка';
$string['unlimited'] = 'Неограничено';
$string['unpacking'] = 'Распакује се {$a}';
$string['unsafepassword'] = 'Несигурна лозинка - пробајте нешто комплексније';
$string['untilcomplete'] = 'Док се не заврши';
$string['unusedaccounts'] = 'Кориснички налози који се не користе {$a} дана се аутоматски исписују';
$string['unzip'] = 'Распакуј';
$string['unzippingbackup'] = 'Распакује се резервна копија';
$string['up'] = 'Горе';
$string['update'] = 'Ажурирање';
$string['updated'] = 'Ажурирано {$a}';
$string['updatemymoodleoff'] = 'Престани са уређивањем ове странице';
$string['updatemymoodleon'] = 'Уреди ову страницу';
$string['updatemyprofile'] = 'Ажурирај профил';
$string['updatesevery'] = 'Ажурирање на сваких {$a} секунди';
$string['updatethis'] = 'Ажурирај';
$string['updatethiscourse'] = 'Ажурирај овај курс';
$string['updatinga'] = 'Ажурирање: {$a}';
$string['updatingain'] = 'Ажурирање {$a->what} у {$a->in}';
$string['upload'] = 'Постави';
$string['uploadafile'] = 'Постављање датотеке';
$string['uploadcantwrite'] = 'Неуспешно уписивање датотеке на диск';
$string['uploadedfile'] = 'Датотека је успешно постављена';
$string['uploadedfileto'] = 'Датотека {$a->file} је постављена у директоријум {$a->directory}';
$string['uploadedfiletoobig'] = 'Нажалост, наведена датотека је превелика (ограничење износи {$a} бајта)';
$string['uploadextension'] = 'Постављање датотеке прекинуто од стране PHP екстензије';
$string['uploadfailednotrecovering'] = 'Постављање Ваших датотека није успело јер је уочен проблем са једном од њих, {$a->name}.<br /> Овде је извештај о уоченим проблемима:<br />{$a->problem}<br />Нема опоравка.';
$string['uploadfilelog'] = 'Извештај о постављању датотеке {$a}';
$string['uploadformlimit'] = 'Постављена датотека {$a} је премашила ограничење за максималну величину одређену обрасцем';
$string['uploadlabel'] = 'Наслов:';
$string['uploadlimitwithsize'] = '{$a->contextname} - ограничење за постављање датотека ({$a->displaysize})';
$string['uploadnewfile'] = 'Постави нову датотеку';
$string['uploadnofilefound'] = 'Датотека није пронађена - јесте ли сигурни да сте одабрали датотеку за постављање?';
$string['uploadnotallowed'] = 'Постављање није дозвољено';
$string['uploadnotempdir'] = 'Недостаје привремени директоријум';
$string['uploadoldfilesdeleted'] = 'Старе датотеке у Вашем одељку за постављање су обрисане';
$string['uploadpartialfile'] = 'Постављање датотеке није извршено у потпуности';
$string['uploadproblem'] = 'Приликом постављања датотеке \'{$a}\' догодила се непозната грешка (можда је наведена датотека била превелика?)';
$string['uploadrenamedchars'] = 'Датотека је преименована са {$a->oldname} на {$a->newname} јер је њен назив садржао недозвољене карактере.';
$string['uploadrenamedcollision'] = 'Датотека је преименована са {$a->oldname} на {$a->newname} јер је дошло до конфликта са називом неке друге датотеке.';
$string['uploadserverlimit'] = 'Датотека која је постављена је већа од максималне величине дозовољене ограничењем овог сервера';
$string['uploadthisfile'] = 'Постави датотеку';
$string['url'] = 'URL';
$string['used'] = 'Коришћено';
$string['usedinnplaces'] = 'Користи се на {$a} места';
$string['usemessageform'] = 'или користите форму испод да пошаљете поруку изабраним полазницима';
$string['user'] = 'Корисник';
$string['userconfirmed'] = 'Потврђен {$a}';
$string['usercurrentsettings'] = 'Подешавања мог профила';
$string['userdata'] = 'Подаци о кориснику';
$string['userdeleted'] = 'Овај кориснички налог је обрисан';
$string['userdescription'] = 'Опис';
$string['userdescription_help'] = 'Овде можете унети податке о себи који ће бити приказани на страници Вашег профила и које ће моћи да виде други корисници.';
$string['userdetails'] = 'Детаљи о кориснику';
$string['userfiles'] = 'Корисничке датотеке';
$string['userlist'] = 'Списак корисника';
$string['username'] = 'Корисничко име';
$string['usernameemailmatch'] = 'Корисничко име и адреса е-поште се не односе на истог корисника';
$string['usernameexists'] = 'Наведено корисничко име већ постоји, изаберите неко друго';
$string['usernamelowercase'] = 'Дозвољена су само мала слова';
$string['usernamenotfound'] = 'Корисничко име није пронађено у бази података';
$string['usernameoremail'] = 'Унесите или корисничко име или адресу е-поште';
$string['usernotconfirmed'] = 'Није се могло потврдити {$a}';
$string['userpic'] = 'Слика корисника';
$string['users'] = 'Корисници';
$string['userselectorautoselectunique'] = 'Ако само један корисник одговара критеријумима претраге нека аутоматски буде изабран';
$string['userselectorpreserveselected'] = 'Задржи изабране кориснике, чак и ако се више не одговарају критеријумима претраге';
$string['userselectorsearchanywhere'] = 'Пронађи тражени текст било где у приказаним пољима';
$string['usersnew'] = 'Нови корисници';
$string['usersnoaccesssince'] = 'Неактивни више од';
$string['userswithfiles'] = 'Корисници са датотекама';
$string['useruploadtype'] = 'Тип постављања корисника: {$a}';
$string['userviewingsettings'] = 'Подешавања профила за корисника {$a}';
$string['userzones'] = 'Корисничке зоне';
$string['usetheme'] = 'Употреби ову тему';
$string['usingexistingcourse'] = 'Користећи постојећи курс';
$string['valuealreadyused'] = 'Ова вредност је већ искоришћена';
$string['version'] = 'Верзија';
$string['view'] = 'Приказ';
$string['viewallcourses'] = 'Погледај све курсеве';
$string['viewallcoursescategories'] = 'Погледај све курсеве и категорије';
$string['viewallsubcategories'] = 'Погледај све поткатегорије';
$string['viewfileinpopup'] = 'Погледај датотеку у искачућем прозору';
$string['viewing'] = 'Преглед:';
$string['viewmore'] = 'Погледај још';
$string['viewprofile'] = 'Прегледај профил';
$string['views'] = 'Прикази';
$string['viewsolution'] = 'види решење';
$string['virusfound'] = 'Упозорење за администратора! Clam AV је нашао вирус у датотеци коју је корисник {$a->user} поставио у оквиру курса {$a->course}. Ево резултата Clam скенирања:';
$string['virusfoundlater'] = 'У датотеци која је постављена дана {$a->date} под именом {$a->filename} за курс {$a->course} је у међувремену пронађен вирус. Овде је сажети извештај о томе шта се током времена дешавало са датотеком:

{$a->action}

Ако је то био предати рад, можда желите поново да га предате да би га Ваш предавач могао прегледати.';
$string['virusfoundlateradmin'] = 'Упозорење за администратора! У датотеци коју је корисник {$a->user} поставио дана {$a->date} под именом {$a->filename} за курс {$a->course} је у међувремену пронађен вирус. Овде је сажети извештај о томе шта се током времена дешавало са датотеком:

{$a->action}

Корисник који је учитао датотеку је такође обавештен о томе шта се догодило.';
$string['virusfoundlateradminnolog'] = 'Упозорење за администратора! У датотеци која је раније постављена под именом {$a->filename} је у међувремену пронађен вирус. Moodle није успео да преправи ову датотеку у њену првобитну верзију у каквој ју је корисник поставио.

Овде је сажети извештај о томе шта се током времена дешавало са датотеком:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Пронађен вирус!';
$string['virusfounduser'] = 'Датотека коју сте поставили, {$a->filename}, је скенирана антивирусним софтвером и пронађено је да је заражена! Учитавање Ваше датотеке НИЈЕ успело.';
$string['virusplaceholder'] = 'Пронађено је да је датотека која је постављена садржала вирус, па је премештена или обрисана, а корисник је о томе обавештен.';
$string['visible'] = 'Видљиво';
$string['visible_help'] = 'Ово подешавање одређује да ли ће се курс појавити на попису курсева. За разлику од наставника и администратора, корисницима није дозвољен улазак на курс.';
$string['visibletostudents'] = 'Видљиво за {$a}';
$string['warning'] = 'Упозорење';
$string['warningdeleteresource'] = 'Упозорење: на {$a} се односи ресурс. Да ли желите да ажурирате тај ресурс?';
$string['webpage'] = 'Веб страница';
$string['week'] = 'Седмица';
$string['weekhide'] = 'Сакриј ову седмицу од {$a}';
$string['weeklyoutline'] = 'Седмични преглед дешавања';
$string['weeks'] = 'недељa/е';
$string['weekshow'] = 'Приказ ове седмице до {$a}';
$string['welcometocourse'] = 'Добродошли на курс {$a}';
$string['welcometocoursetext'] = 'Добродошли на курс {$a->coursename}!

Уколико то већ нисте урадили, требало би да уредити страницу свог профила, тако да можемо да сазнамо нешто више о вама:

{$a->profileurl}';
$string['whatforlink'] = 'Шта желите да урадите са линком?';
$string['whatforpage'] = 'Шта желите да урадите са линком?';
$string['whattocallzip'] = 'Како желите да назовете архивирану датотеку?';
$string['whattodo'] = 'Шта урадити';
$string['windowclosing'] = 'Овај прозор би требало да се аутоматски затвори. Ако се то није догодило молим вас да га сада затворите.';
$string['withchosenfiles'] = 'Са изабраним датотекама';
$string['withdisablednote'] = '{$a} (онемогућено)';
$string['withoutuserdata'] = 'без корисничких података';
$string['withselectedusers'] = 'Са изабраним корисницима...';
$string['withselectedusers_help'] = '* Пошаљи поруку - за слање поруке једном или више корисника
* Додај нову белешку - за додавање белешке о одабраном кориснику
* Додај заједничку белешку - за додавање исте белешке о више корисника';
$string['withuserdata'] = 'с корисничким подацима';
$string['wordforstudent'] = 'Ваша реч за полазника';
$string['wordforstudenteg'] = 'нпр. полазник, учесник, кандидат и сл.';
$string['wordforstudents'] = 'Ваша реч за полазнике';
$string['wordforstudentseg'] = 'нпр. полазници, учесници, кандидати и сл.';
$string['wordforteacher'] = 'Ваша реч за предавача';
$string['wordforteachereg'] = 'нпр. предавач, професор, модератор и сл.';
$string['wordforteachers'] = 'Ваша реч за предаваче';
$string['wordforteacherseg'] = 'нпр. предавачи, професори, модератори и сл.';
$string['writingblogsinfo'] = 'Уписивање информација о блоговима';
$string['writingcategoriesandquestions'] = 'Записивање категорија и питања';
$string['writingcoursedata'] = 'Записивање података курса';
$string['writingeventsinfo'] = 'Записивање информација о догађајима';
$string['writinggeneralinfo'] = 'Записивање општих информација';
$string['writinggradebookinfo'] = 'Записивање информација о оцењивању';
$string['writinggroupingsgroupsinfo'] = 'Записивање информација о груписањима-групама';
$string['writinggroupingsinfo'] = 'Записивање информација о групацијама';
$string['writinggroupsinfo'] = 'Записивање информација о групама';
$string['writingheader'] = 'Записивање заглавља';
$string['writingloginfo'] = 'Записивање извештаја о активностима';
$string['writingmessagesinfo'] = 'Записивање информација о порукама';
$string['writingmoduleinfo'] = 'Записивање информација о модулима';
$string['writingscalesinfo'] = 'Записивање информација о скалама оцењивања';
$string['writinguserinfo'] = 'Записивање информација о корисницима';
$string['wrongpassword'] = 'Погрешна лозинка за ово корисничко име';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'година';
$string['years'] = 'година';
$string['yes'] = 'Да';
$string['youareabouttocreatezip'] = 'Управо ћете започети креирање zip архиве која садржи';
$string['youaregoingtorestorefrom'] = 'Управо ћете започети рестаурациони процес за';
$string['youneedtoenrol'] = 'Да бисте извршили ову акцију морате се пријавити на курс.';
$string['yourlastlogin'] = 'Ваш последњи приступ систему';
$string['yourself'] = 'себе';
$string['yourteacher'] = 'Ваш {$a}';
$string['yourwordforx'] = 'Ваша реч за \'{$a}\'';
$string['zippingbackup'] = 'Креира се архива са резервном копијом';
