<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Прихвати';
$string['accept_grades'] = 'Прихвати оцене алата';
$string['accept_grades_admin'] = 'Прихвати оцене алата';
$string['accept_grades_admin_help'] = 'Наведите да ли провајдер алата може да додаје, ажурира. чита и брише оцене повезане са инстанцама овог типа алата.

Неки провајдери подржавају могућност слања оцена назад у Moodle на основу акција које су предузете у оквиру алата, стварајући на тај начин доживљај веће интегрисаности Moodlea и екстерног алата.';
$string['accept_grades_help'] = 'Наведите да ли провајдер алата може да додаје, ажурира. чита и брише оцене повезане са инстанцама овог типа алата.

Неки провајдери подржавају могућност слања оцена назад у Moodle на основу акција које су предузете у оквиру алата, стварајући на тај начин доживљај веће интегрисаности Moodlea и екстерног алата.

Имајте у виду да се ова подешавања могу изменити у конфигурацији алата.';
$string['action'] = 'Акција';
$string['active'] = 'Активан';
$string['activity'] = 'Активност';
$string['addnewapp'] = 'Омогући екстерну апликацију';
$string['addserver'] = 'Додај нови поуздани сервер';
$string['addtype'] = 'Додај конфигурацију екстерног алата';
$string['allow'] = 'Дозволи';
$string['allowinstructorcustom'] = 'Дозволи предавачима да додају прилагођене параметре';
$string['allowsetting'] = 'Дозволи да алат унутар Moodlea  сачува 8K подешавања';
$string['always'] = 'Увек';
$string['automatic'] = 'Аутоматски, на основу иницијалне URL адресе';
$string['baseurl'] = 'Основна URL адреса';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI активности';
$string['basiclti_base_string'] = 'LTI OAuth основни стринг';
$string['basiclti_endpoint'] = 'LTI крајња тачка стартовања';
$string['basicltifieldset'] = 'Прилагођени пример скупа поља';
$string['basiclti_in_new_window'] = 'Ваша активност је отворена у новом прозору';
$string['basicltiintro'] = 'Опис активности';
$string['basicltiname'] = 'Назив активности';
$string['basiclti_parameters'] = 'LTI параметри стартовања';
$string['basicltisettings'] = 'Основна LTI подешавања';
$string['cannot_delete'] = 'Не можете да обришете ову конфигурацију алата';
$string['cannot_edit'] = 'Не можете да уредите ову конфигурацију алата';
$string['comment'] = 'Коментар';
$string['configpassword'] = 'Подразумевана лозинка удаљеног алата';
$string['configpreferheight'] = 'Стандардна преферирана висина';
$string['configpreferwidget'] = 'Постави додатак за подразумевано покретање';
$string['configpreferwidth'] = 'Стандардна преферирана ширина';
$string['configresourceurl'] = 'Подразумевана URL адреса ресурса';
$string['configtoolurl'] = 'Подразумевана URL адреса удаљеног алата';
$string['configtypes'] = 'Омогући LTI  апликације';
$string['courseid'] = 'ID број курса';
$string['coursemisconf'] = 'Курс је погрешно конфигурисан';
$string['course_tool_types'] = 'Типови алата на нивоу курса';
$string['createdon'] = 'Креирано дана';
$string['curllibrarymissing'] = 'PHP Curl библиотека мора да буде инсталирана како бисте могли да користите LTI';
$string['custom'] = 'Прилагођени параметри';
$string['custom_config'] = 'Коришћење прилагођене конфигурације алата';
$string['custom_help'] = 'Наменски прилагођени параметри су подешавања које користи провајдер алата. На пример, прилагођени параметри се могу користити за приказ одређених ресурса од стране провајдера.

Најсигурније је не мењати ово поље, осим ако то не учини сам провајдер алата.';
$string['custominstr'] = 'Прилагођени параметри';
$string['debuglaunch'] = 'Опција за отклањање грешака';
$string['debuglaunchoff'] = 'Нормално покретање';
$string['debuglaunchon'] = 'Покретање са отклањањем грешака';
$string['default'] = 'Подразумевано';
$string['default_launch_container'] = 'Подразумевани иницијални контејнер';
$string['default_launch_container_help'] = 'Иницијални контејнер утиче на приказ алата приликом његовог покретања унутар курса. Неки контејнери пружају већи број могућности, док други обезбеђују већи степен интеграције са Moodleom.

* **Подразумевано** - користи иницијални контејнер наведен у конфигурације алата.
* **Уметнуто** - алат се приказује унутар постојећег прозора Moodlea, на начин сличан већини других типова активности.
* **Уметнуто, без блокова** - алат се приказује унутар постојећег прозора Moodlea, али само са навигационом траком на врху странице.
* **Нови прозор** - Алат се отвара у новом прозору, заузимајући сав његов раположив простор.
      Зависно од веб читача, алат ће се отворити у новој картици читача или у искачућем прозору. Постоји могућност да веб читач неће дозволити отварање новог прозора.';
$string['delegate'] = 'Делегирај предавачу';
$string['delete'] = 'Обриши';
$string['delete_confirmation'] = 'Да ли сте сигурни да желите да обришете ову конфигурацију екстерног алата?';
$string['deletetype'] = 'Обриши конфигурацију екстерног алата';
$string['display_description'] = 'Прикажи опис активности приликом њеног стартовања';
$string['display_description_help'] = 'Ако је изабрана ова опција, опис активности (горе наведен) биће приказан изнад садржаја екстерног алата.

Опис се може користити како би се пружиле додатне инструкције онима који покрећу алат, али није неопходан.

Опис се никада не приказује када се екстерни алат покреће у новом прозору.';
$string['display_name'] = 'Прикажи назив активности када се покрене';
$string['display_name_help'] = 'Ако је изабрана ова опција, назив активности (горе наведен) биће приказан изнад садржаја екстерног алата.

Могуће је да провајдер алата, такође, може да прикаже наслов. Ова опција спречава да наслов активности буде приказан двапут.

Наслов се никада не приказује ако се иницијални контејнер алата покреће у новом прозору.';
$string['domain_mismatch'] = 'Домен иницијалне URL адресе се не поклапа са конфигурацијом алата.';
$string['donot'] = 'Немој слати';
$string['donotaccept'] = 'Немој прихватити';
$string['donotallow'] = 'Немој дозволити';
$string['edittype'] = 'Уреди конфигурацију екстерног алата';
$string['embed'] = 'Угради';
$string['embed_no_blocks'] = 'Угради, без блокова';
$string['enableemailnotification'] = 'Пошаљи обавештења е-поштом';
$string['enableemailnotification_help'] = 'Ако је омогућена ова опција, полазници ће е-поштом добити обавештење када буде оцењена њихова активност у оквиру екстерног алата..';
$string['errormisconfig'] = 'Погрешно  конфигурисан алат. Замолите свог Moodle администратора да поправи конфигурацију алата.';
$string['extensions'] = 'Сервиси LTI проширења';
$string['external_tool_type'] = 'Тип екстерног алата';
$string['external_tool_type_help'] = 'Основна намена конфигурације алата је успостављање безбедног канала комуникације између Moodlea и провајдера алата. Конфигурација алата, такође, пружа могућност да се подесе како подразумеване вредности, тако и додатни сервисе које пружа сам алат.

* ** Аутоматски, на основу иницијалне URL aдресе** - ово подешавања треба користити у скоро свим случајевима. Moodle ће изабрати најприкладнију конфигурацију алата која се заснива на иницијалној URL адреси. Биће коришћен алат који је конфигурисан било од стране администратора или унутар овога курса.
Када је наведена иницијална URL адреса, Moodle ће дати повратну информацију о томе да ли је препознао адресу или не. Ако Moodle није препознао .иницијалну URL адресу, можда ће бити потребно да ручно унесете податке о конфигурацији алата.
* **Специфичан тип алата** - ако изаберете специфичан тип алата, можете да натерате Moodle да у комуникацији са провајдером екстерног алата користи ту конфигурацију алата. Уколико се испостави да иницијална URL адреса не припада провајдеру, појавиће се упозорење. У неким случајевима, није потребно да се унесе иницијална URL адреса када се обезбеђује специфични тип алата (ако се не покреће тачно одређени ресурс унутар самог провајдера алата).
* **Наменски прилагођена конфигурација** - да бисте подесили прилагођену конфигурације алата, само за ову инстанцу, откријте ‘Напредне опције’ и унесите кориснички кључ и тајни дељени кôд. Ако немате кориснички кључ и тајни дељени кôд можда ћете моћи да их затражите од провајдера алата.
Не захтевају сви алати кориснички кључ и тајни дељени кôд. У том случају ова поља можете оставити празна.

### Уређивање типа алата 

Одмах иза падајућег менија ‘Тип екстерног алата’ доступне су три иконице:

* **Додај** - креирајте конфигурацију алата на нивоу курса. Све инстанце екстерног алата на овом курсу моћи ће да користе конфигурацију алата.
* **Уреди** - изаберите тип алата на нивоу курса из падајућег менија, а затим кликните на ову иконицу. Могу се уређивати детаљи конфигурације алата.
* **Обриши** - уклоните изабрани тип алата на нивоу курса.';
$string['external_tool_types'] = 'Типoви екстерних алата';
$string['failedtoconnect'] = 'Moodle није могао да успостави комуникацију са"{$a}" системом';
$string['filter_basiclti_configlink'] = 'Конфигуриши своје префериране сајтове и њихове лозинке';
$string['filter_basiclti_password'] = 'Лозинка је обавезна';
$string['filterconfig'] = 'LTI администрација';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Искористите постојећу конфигурацију за погрешно конфигурисану инстанцу';
$string['fixnew'] = 'Нова конфигурација';
$string['fixnewconf'] = 'Дефиниши нову конфигурацију за погрешно конфигурисану инстанцу';
$string['fixold'] = 'Користи постојећу';
$string['forced_help'] = 'Ово подешавање је постављено као обавезно у конфигурацији алата на нивоу курса или сајта. Не можете да га мењате у овом интерфејсу.';
$string['force_ssl'] = 'Обавезан SSL';
$string['force_ssl_help'] = 'Избором ове опције, свако покретање алата овог провајдера ће обавезно користити SSL протокол.

Осим тога, и сви захтеви веб сервиса провајдера алата ће користити SSL протокол.

Ако се користи ова опција, проверите да ли овај Moodle сајт и провајдер алата подржавају SSL протокол.';
$string['generaltool'] = 'Општи алат';
$string['global_tool_types'] = 'Глобални типови алата';
$string['grading'] = 'Усмеравање оцена';
$string['icon_url'] = 'Иконица URL адресе';
$string['icon_url_help'] = 'URL адресe иконице, омогућава да се измени иконица која се појављује на списку курсева за ова активност. Уместо да користите подразумевану LTI иконицу, може се дефинисати иконица која одражава тип активности.';
$string['id'] = 'id';
$string['invalidid'] = 'LTI ID је погрешан';
$string['launch_in_moodle'] = 'Покрени алат унутар Moodlea';
$string['launchinpopup'] = 'Иницијални контејнер';
$string['launch_in_popup'] = 'Покрени алат у искачућем прозору';
$string['launchinpopup_help'] = 'Иницијални контејнер утиче на приказ алата приликом његовог покретања унутар курса. Неки контејнери пружају већи број могућности, док други обезбеђују већи степен интеграције са Moodleom.

* **Подразумевано** - користи контејнер покретања наведен у конфигурацији алата.
* **Уметнуто** - алат се приказује унутар постојећег прозора Moodlea, на начин сличан већини других типова активности.
* **Уметнуто, без блокова** - алат се приказује унутар постојећег прозора Moodlea, али само са навигационом траком на врху странице.
* **Нови прозор** - Алат се отвара у новом прозору, заузимајући сав његов раположив простор.
      Зависно од веб читача, алат ће се отворити у новој картици читача или у искачућем прозору. Постоји могућност да веб читач неће дозволити отварање новог прозора.';
$string['launchoptions'] = 'Опције за покретање';
$string['launch_url'] = 'Иницијална URL адреса';
$string['launch_url_help'] = 'Иницијална URL адреса означава веб адресу екстерног алата. и може да садржи додатне информације, као што је ресурс који ће бити приказан.
Ако нисте сигурни шта да упишете као иницијалну URL адресу, молимо вас потражите више информације код провајдера алата.

Ако сте изабрали специфичан тип алата, можда нећете морати да упишете иницијалну URL адресу. То ће највероватније бити случај, ако се линк алата користи само за улазак на систем провајдера, а не за одлазак на неки одређени ресурс.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Додај за курс специфична подешавања алата';
$string['lti:addinstance'] = 'Додај нове активности екстерног алата';
$string['lti_administration'] = 'LTI администрација';
$string['lti_errormsg'] = 'Алат је вратио следећу поруку о грешци: "{$a}"';
$string['lti:grade'] = 'Погледај оцене добијене од екстерног алата';
$string['lti_launch_error'] = 'Догодила се грешка приликом покретања екстерног алата:';
$string['lti_launch_error_tool_request'] = '<p> Да бисте послали захтев администратору да заврши конфигурисање алата, кликните<a href="{$a->admin_request_url}" target="_top">овде</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Ова грешка може бити резултат недостатка корисничког кључа и заједничког тајног кључа за провајдера алата.</p>
<p> Ако имате кориснички кључ и заједнички тајни кључ, можете их унети приликом уређивања инстанце екстерног алата (проверите да ли су видљиве напредне опције).</p>
</p>Алтернативно, можете да <a href="{$a->course_tool_editor}"> креирате конфигурацију алата на нивоу курса </a>.</p>';
$string['lti:manage'] = 'Буди инструктор кад се покрене алат';
$string['lti:requesttooladd'] = 'Захтевај да се алат подеси на нивоу сајта';
$string['lti_tool_request_added'] = 'Захтев за конфигурисање алата је успешно послат. Можда ћете морати да се обратите администратору да бисте довршили конфигурисање.';
$string['lti_tool_request_existing'] = 'Конфигурација алата за домен алата је већ послата.';
$string['ltiunknownserviceapicall'] = 'API позив LTI непознатог сервиса.';
$string['lti:view'] = 'Покрени активности екстерног алата';
$string['main_admin'] = 'Општа помоћ';
$string['main_admin_help'] = 'Екстерни алати дозвољавају корисницима Moodlea да неприметно ступају у интеракцију са ресурсима који се налазе на удаљеним сајтовима.
Користећи специјалне протоколе удаљени алат ће имати приступ неким општим информацијама о кориснику који је покренуо алат. На пример, назив институције, id курса, id корисника, и друге информације, као што су име корисника или његова е-адреса. 

Типови алата приказани на овој страници су подељени у три категорије:

* **Активни** - ове провајдере алата је администратор одобрио и конфигурисао. Они могу да се користе унутар било ког курса ове инстанце Moodlea. Aко су унети кориснички кључ и тајни дељени кôд, успостављена је поуздана веза између инстанце Moodlea и удаљеног алата, што обезбеђује безбедан канал комуникације.
* **На чекању** - ови провајдери алата су увезени, али их администратор још увек није конфигурисао. Предавачи и даље могу да користе алате ових провајдера ако имају кориснички кључ и тајни дељени кôд, или ако они нису потребни.
* **Одбијени** - ови провајдери алата су означени као они које администратор не намерава да учини доступним свима унутар инстанце Moodlea. Предавачи и даље могу да користе алате ових провајдера ако имају кориснички кључ и тајни дељени код, или ако они нису потребни.';
$string['miscellaneous'] = 'Разно';
$string['misconfiguredtools'] = 'Откривене су погрешно конфигурисане инстанце алата';
$string['missingparameterserror'] = 'Страница је погрешно конфигурисана: "{$a}"';
$string['module_class_type'] = 'Тип Moodle модула';
$string['modulename'] = 'Екстерни алат';
$string['modulename_help'] = 'Екстерни алати дозвољавају корисницима Moodlea да ступају у интеракцију са ресурсима и активностима за учење на другим веб сајтовима. На пример, екстерни алат може да обезбеди приступ новом типу активности или образовним материјалима које нуде издавачи.

Како бисте подесили инстанцу екстерног алата, неопходно је да провајдер алата подржава LTI (Learning Tools Interoperability) стандард.
Ако пронађете провајдера алата који подржава LTI стандард, он треба да обезбеди упутство о томе како да се конфигурише инстанца екстерног алата. Додатно, биће доступни за употребу и типови алата које конфигурисао администратор сајта.

Екстерни алати се разликују од ресурса \'URL адреса\' на неколико начина:
* **Контекст** - екстерни алати имају приступ информацијама о кориснику који је покренуо алат, као што је назив институције и курса, име корисника и др.
* **Дубока интеграција** - екстерни алати подржавају читање, ажурирање и брисање оцена које су повезане са инстанцом активности. За будућа издања планира се већи степен интеграције.
* **Безбедност** - конфигурације екстерног алата креирају поуздану везу између Moodlea и провајдера алата, што омогућава безбедну комуникацију између њих.';
$string['modulenameplural'] = 'Екстерни алати';
$string['modulenamepluralformatted'] = 'LTI инстанце';
$string['never'] = 'Никада';
$string['new_window'] = 'Нови прозор';
$string['noattempts'] = 'Још није било покушаја у оквиру ове инстанце алата';
$string['no_lti_configured'] = 'Не постоје активни екстерни алати који су конфигурисани.';
$string['no_lti_pending'] = 'Нема екстерних алата на чекању.';
$string['no_lti_rejected'] = 'Нема одбијених екстерних алата.';
$string['noltis'] = 'Не постоје инстанце екстерних алата';
$string['noservers'] = 'Нису пронађени сервери';
$string['notypes'] = 'Тренутно не постоје подешавања LTI алата у Moodleу. Кликните на горњи линк за инсталацију како бисте их додали.';
$string['noviewusers'] = 'Нису пронађени корисници који имају овлашћења да користе овај алат';
$string['optionalsettings'] = 'Опциона подешавања';
$string['organization'] = 'Информације о организацији';
$string['organizationdescr'] = 'Опис организације';
$string['organizationid'] = 'ID организације';
$string['organizationid_help'] = 'Јединствени идентификатор ове инстанце Moodlea. Обично се користи DNS назив организације.

Ако ово поље остане празно, користиће се назив сервера овог Moodle сајта, као подразумевана вредност.';
$string['organizationurl'] = 'URL адреса организације';
$string['organizationurl_help'] = 'Основна URL адреса ове инстанце Moodlea';
$string['pagesize'] = 'Број приступа алату приказаних по страници';
$string['password'] = 'Тајни дељени кôд';
$string['password_admin'] = 'Тајни дељени кôд';
$string['password_admin_help'] = 'Тајни дељени кôд може да се посматра као лозинка која се користи за проверу идентитета приликом приступа алату. Кôд треба да обезбеди провајдер алата заједно са корисничким кључем.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају тајни дељени кôд.';
$string['password_help'] = 'За претходно конфигурисане алате, није неопходно да се овде унесе тајни дељени кôд, пошто ће он већ бити обезбеђен као део процеса конфигурације.

Ово поље треба попунити ако се креира веза ка провајдеру алата који није претходно конфигурисан. Ако провајдер алата треба да се користи више пута на овом курсу, додавање конфигурације алата је добра идеја.

Тајни дељени кôд може да се посматра као лозинка која се користи за проверу идентитета приликом приступа алату. Кôд треба да обезбеди провајдер алата заједно са корисничким кључем.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају тајни дељени кôд.';
$string['pending'] = 'Не чекању';
$string['pluginadministration'] = 'LTI администрација';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'Преферирана висина';
$string['preferwidget'] = 'Преферирано покретање додатка';
$string['preferwidth'] = 'Преферирана ширина';
$string['press_to_submit'] = 'Притисните да бисти покренули ову активност';
$string['privacy'] = 'Приватност';
$string['quickgrade'] = 'Дозволи брзо оцењивање';
$string['quickgrade_help'] = 'Ако је омогућена ова опција, више алата може да се оцењује на једној страници. Додајте оцене и коментаре а затим кликните на дугме "Сачувај све моје повратне информације" како бисте сачували све промене на тој страници.';
$string['redirect'] = 'Бићете преусмерени за неколико секунди. Ако се то не догоди притисните дугме.';
$string['reject'] = 'Одбиј';
$string['rejected'] = 'Одбијено';
$string['resource'] = 'Ресурс';
$string['resourcekey'] = 'Кориснички кључ';
$string['resourcekey_admin'] = 'Кориснички кључ';
$string['resourcekey_admin_help'] = 'Кориснички кључ може да се посматра као корисничко име које се користи за проверу идентитета приликом приступа алату. 
Провајдер алата може користити кључ како би обезбедио јединствену идентификацију Moodle сајта са којег корисници покрећу алат.

Кориснички кључ мора да обезбеди провајдер алата. Начин добијања кључа се разликује међу провајдерима. То може бити аутоматизовани процес или може захтевати дијалог са провајдером алата.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају кориснички кључ.';
$string['resourcekey_help'] = 'За претходно конфигурисане алате, није неопходно да се овде унесе кључ ресурса, пошто ће он већ бити обезбеђен као део процеса конфигурације.

Ово поље треба попунити ако се креира веза ка провајдеру алата који није претходно конфигурисан. Ако провајдер алата треба да се користи више пута на овом курсу, додавање конфигурације алата је добра идеја.

Кориснички кључ може да се посматра као корисничко име које се користи за проверу идентитета приликом приступа алату. 
Провајдер алата може користити кључ како би обезбедио јединствену идентификацију Moodle сајта са којег корисници покрећу алат.

Кориснички кључ мора да обезбеди провајдер алата. Начин добијања кључа се разликује међу провајдерима. То може бити аутоматизовани процес или може захтевати дијалог са провајдером алата.

Алати који не траже безбедну комуникацију са Moodeom и не пружају додатне сервисе (као што је извештај о оценама), не морају да захтевају кориснички кључ.';
$string['resourceurl'] = 'URL адреса ресурса';
$string['return_to_course'] = 'Кликни на <a href="{$a->link}" target="_top">here</a> за повратак на курс';
$string['saveallfeedback'] = 'Сачувај све моје повратне информације';
$string['secure_icon_url'] = 'Безбедна иконица URL адресе';
$string['secure_icon_url_help'] = 'Слично иконици URL адресе, али се користи ако корисник приступа Moodleu путем SSL протокола. Главна намена овог поља је да спречи веб читач да шаље упозорења кориснику, ако страници приступа путем SSL-а, а при томе се захтева приказ небезбедне слике.';
$string['secure_launch_url'] = 'Безбедна иницијална URL адреса';
$string['secure_launch_url_help'] = 'Иако слична обичној, безбедна иницијална URL адреса се користи ако је неопходан виши ниво безбедности. Moodle ће користити безбедну иницијалну URL адресу уколико се Moodle сајту приступа преко SSL протокола, или ако је конфигурација алата подешена тако да се она увек покреће путем SSL-а.

Иницијална URL адреса се може, такође, подесити као https адреса, како би се екстерни алат приморао на покретање путем SSL протокола. У том случају ово поље може остати празно.';
$string['send'] = 'Пошаљи';
$string['setupoptions'] = 'Опције за подешавање';
$string['share_email'] = 'Подели е-адресу корисника са провајдером алата';
$string['share_email_admin'] = 'Подели е-адресу корисника са провајдером алата';
$string['share_email_admin_help'] = 'Наведите да ли е-адресу корисника који покреће алат треба делити са провајдером..
Провајдер може да тражи е-адресе корисника који су покренули алат како би разликовао кориснике са истим именом или како би корисницима слао е-пошту зависно од акција унутар алата.';
$string['share_email_help'] = 'Наведите да ли е-адресу корисника који покреће алат треба делити са провајдером..
Провајдер може да тражи е-адресе корисника који су покренули алат како би разликовао кориснике са истим именом или како би корисницима слао е-пошту зависно од акција унутар алата.

Имајте у виду да се ово подешавање може изменити у конфигурацији алата.';
$string['share_name'] = 'Подели име корисника са провајдером алата';
$string['share_name_admin'] = 'Подели име корисника са провајдером алата';
$string['share_name_admin_help'] = 'Наведите да ли треба да се дели пуно име корисника, који покреће алат, са провајдером алата.
Провајдер може да тражи име корисника који је покренуо алат, како би приказао смислене информације унутар алата.';
$string['share_name_help'] = 'Наведите да ли треба да се дели пуно име корисника, који покреће алат, са провајдером алата.
Провајдер може да тражи име корисника који је покренуо алат, како би приказао смислене информације унутар алата.

Имајте у виду да се ово подешавање може изменити у конфигурацији алата.';
$string['share_roster'] = 'Дозволи алату приступ списку учесника курса';
$string['share_roster_admin'] = 'Алат може да приступи списку учесника курса';
$string['share_roster_admin_help'] = 'Наведите да ли алат може да приступи списку учесника уписаних на курсеве, у оквиру којих се овај тип алата користи.';
$string['share_roster_help'] = 'Наведите да ли алат може да приступи списку учесника уписаних на овај курс.

Имајте у виду да се ово подешавање може изменити у конфигурацији алата.';
$string['show_in_course'] = 'Прикажи тип алата приликом креирања инстанце алата';
$string['show_in_course_help'] = 'Ако је изабрано, ова конфигурација алата ће се појавити у падајућем менију "Тип екстерног алата" када предавачи конфигуришу екстерни алат унутар курсева.

У већини случајева, ова опција не треба да буде изабрана. Предавачи могу да користе ову конфигурацију алата, базирану на иницијалној URL адреси, која се поклапа са основном URL адресом, што је преферирани метод.

Једини случај, у којем би требало да се изабере ова опција, је онај када је конфигурација алата намењена једнократном пријављивању (Single Sign on). На пример, ако свa покретања алата воде корисника на унутрашњу страницу провајдера, уместо на одређени ресурс.';
$string['size'] = 'Параметри величине';
$string['submission'] = 'Активност на екстерном алату';
$string['submissions'] = 'Предато';
$string['submissionsfor'] = 'Предати радови за {$a}';
$string['subplugintype_ltisource'] = 'LTI извор';
$string['subplugintype_ltisource_plural'] = 'LTI извори';
$string['toggle_debug_data'] = 'Промена стања података о отклањању грешака';
$string['tool_config_not_found'] = 'За ову URL адресу није пронађена конфигурација алата.';
$string['tool_settings'] = 'Подешавања алата';
$string['toolsetup'] = 'Конфигурација екстерног алата';
$string['toolurl'] = 'Основна URL адреса алата';
$string['toolurl_help'] = 'Основна URL адреса се користи како би се иницијална URL адреса упариле са исправном конфигурацијом алата. Употреба префикса http(s), на почетку адресу, није обавезна.

Осим тога, основна URL адреса се користи као иницијална URL адреса ако ова није наведена у инстанци екстерног алата.

На пример, основна URL адреса за *tool.com* треба да одговара некој од следећих адреса:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Основна URL адреса за *www.tool.com/quizzes* треба да одговара некој од следећих адреса:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Основна URL адреса за *quiz.tool.com* треба да одговара некој од следећих адреса:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Уколико постоје две различите конфигурације алата за исти домен, користиће се она са најпрецизнијом адресом.';
$string['typename'] = 'Назив алата';
$string['typename_help'] = 'Назив алата се користи за идентификацију провајдера алата унутар Moodlea. Назив који се унесе биће видљив предавачима када додају екстерне алате унутар курса.';
$string['types'] = 'Типови';
$string['update'] = 'Ажурирај';
$string['using_tool_configuration'] = 'Коришћење конфигурације алата';
$string['validurl'] = 'Исправна URL адреса мора почети са http(s)://';
$string['viewsubmissions'] = 'Приказ предатих решења и екрана за оцењивање';
