<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Активности';
$string['addcategory'] = 'Додај категорију';
$string['addcategoryerror'] = 'Није могуће додати категорију';
$string['addexceptionerror'] = 'Дошло је до грешке током додавања изузетка за userid:gradeitem';
$string['addfeedback'] = 'Додај повратне информације';
$string['addgradeletter'] = 'Додај словну оцену';
$string['addidnumbers'] = 'Додај ID бројеве';
$string['additem'] = 'Додај ставку за оцењивање';
$string['addoutcome'] = 'Додај исход учења';
$string['addoutcomeitem'] = 'Додај ставку исхода учења';
$string['addscale'] = 'Додај скалу';
$string['aggregateextracreditmean'] = 'Средња вредност оцена (са додатним бодовима)';
$string['aggregatemax'] = 'Највећа оцена';
$string['aggregatemean'] = 'Средња вредност оцена';
$string['aggregatemedian'] = 'Медијана оцена';
$string['aggregatemin'] = 'Најнижа оцена';
$string['aggregatemode'] = 'Мод оцена (најчешћа оцена)';
$string['aggregateonlygraded'] = 'Сумирати само уписане оцене';
$string['aggregateonlygraded_help'] = '"Празна" оцена је оцена која недостаје у књизи оцена. То може бити предати задатка који још није оцењен или тест који полазник још увек није покушао да реши итд.

Ово подешавање одређује  да ли ће ове "празне" оцене бити укључене у збирну оцену или ће се рачунати као минимална оцена, на пример 0 за задатак који се оцењује од 0 до 100.';
$string['aggregateoutcomes'] = 'Укључи исходе учења у сумирање';
$string['aggregateoutcomes_help'] = 'Ако је ова опција омогућена, исходи учења су укључени у збирни резултат. Ово може да резултира неочекиваном укупном оценом за категорију.';
$string['aggregatesonly'] = 'Само збирне оцене';
$string['aggregatesubcats'] = 'Сумирај укључујући поткатегорије';
$string['aggregatesubcats_help'] = 'Ово подешавање одређује да ли су оцене у поткатегоријама укључене у израчунавање сумарне оцене.';
$string['aggregatesum'] = 'Збир оцена';
$string['aggregateweightedmean'] = 'Пондерисана средња вредност оцена';
$string['aggregateweightedmean2'] = 'Проста пондерисана средња вредност оцена';
$string['aggregation'] = 'Сумирање оцена';
$string['aggregationcoef'] = 'Коефицијент сумирања';
$string['aggregationcoefextra'] = 'Додатни бодови';
$string['aggregationcoefextra_help'] = 'Ако је метод сумирања \'Збир оцена\' или \'Једноставна пондерисана средња вредност\' и ако је означено поље за додатне бодове, максимална оцена ставке се не додаје највећој укупној оцени категорије, што резултира могућношћу да максимална оцена у категорији буде достигнута (или чак прекорачена, ако је администратор сајта омогућио ту опцију), а да при томе нема ниједне максималне оцене за било коју од ставки које се оцењују.

Ако је метод сумирања ‘Средња вредност оцена’ (са додатним бодовима) и ако је вредност за додатне бодове већа од нуле, онда додатни бодови постају фактор којим се оцена множи пре њеног додавања укупној оцени након израчунавања средње вредности.';
$string['aggregationcoefextrasum'] = 'Додатни бодови';
$string['aggregationcoefextrasum_help'] = 'Ако је поље за додатне бодове означено максимална оцена за ставку се не додаје максималној оцени категорије, што резултира могућношћу да максимална оцена у категорији буде достигнута (или чак прекорачена, ако је администратор сајта омогућио ту опцију), а да при томе нема ниједне максималне оцене за било коју од ставки које се оцењују.';
$string['aggregationcoefextraweight'] = 'Пондер додатних бодова';
$string['aggregationcoefextraweight_help'] = 'Ако је пондер додатних бодова постављен тако да буде већи од 0, онда се оцена понаша као додатни кредит у току сумирања. Број је фактор којим се оцена множи пре него што се дода укупној вредности за израчунавање средње вредности.';
$string['aggregationcoefweight'] = 'Пондер ставке';
$string['aggregationcoefweight_help'] = 'Пондер ставке се користи у израчунавању сумарне оцене категорије како би одредио важност ставке, у поређењу са другим ставкама које се оцењују унутар исте категорије.';
$string['aggregation_help'] = 'Начин сумирања одређује како се комбинују оцене у појединој категорији, а могући начини су:

* Средња вредност оцена - збир свих оцена подељен са укупним бројем оцена
* Медијана оцена - средишња оцена у распону од највеће до најмање оцене
* Најнижа оцена
* Највиша оцена
* Мод оцена - оцена која се најчешће појављује
* Збир оцена - збир свих вредности оцена, независно од скала оцена';
$string['aggregationposition'] = 'Позиција сумарне оцене';
$string['aggregationposition_help'] = 'Ово подешавање одређује да ли ће  колоне са оценама за категорије и колона са укупном оценом на курсу бити приказане прве или последње у извештајима из књиге оцена.';
$string['aggregationsvisible'] = 'Доступни начини сумирања';
$string['aggregationsvisiblehelp'] = 'Изаберите све начине сумирања оцена који би требало да су доступни. Држите CTRL тастер за избор више начина.';
$string['allgrades'] = 'Све оцене по категоријама';
$string['allstudents'] = 'Сви полазници';
$string['allusers'] = 'Сви корисници';
$string['autosort'] = 'Аутоматско сортирање';
$string['availableidnumbers'] = 'Расположиви идентификациони бројеви';
$string['average'] = 'Просек';
$string['averagesdecimalpoints'] = 'Број децимала у просецима колона';
$string['averagesdecimalpoints_help'] = 'Ово подешавање одређује број децималних места који ће бити приказана за сваки просек односно да ли ће се користити подешавање броја децималних места за категорију или за ставку оцене (наслеђено).';
$string['averagesdisplaytype'] = 'Тип приказа колоне са средњим оценам';
$string['averagesdisplaytype_help'] = 'Ово подешавање одређује да ли се просек (средња вредност) приказује као број, проценат или слово, односно, да ли ће се користити тип приказа за категорију или за ставку оцене (наслеђено).';
$string['backupwithoutgradebook'] = 'Резервна копија не садржи податке о конфигурацији књиге оцена';
$string['badgrade'] = 'Дата оцена је неисправна';
$string['badlyformattedscale'] = 'Молимо вас унесите списак вредности раздвојених зарезом (неопходне су најмање две вредности).';
$string['baduser'] = 'Дати корисник је неисправан';
$string['bonuspoints'] = 'Додатни бодови';
$string['bulkcheckboxes'] = 'Опсежна поља за потврду';
$string['calculatedgrade'] = 'Израчуната оцена';
$string['calculation'] = 'Прорачун';
$string['calculationadd'] = 'Додај прорачун';
$string['calculationedit'] = 'Уреди прорачун';
$string['calculation_help'] = 'Израчунавање оцене представља формулу која се користи како би се одредиле оцене. Формула треба да почиње знаком једнакости (=), и може да користи уобичајене математичке операторе, као што су max, min и sum. Ако желите, другe ставке за оцењивање могу бити укључене у израчунавање тако што ћете уписати ID бројева тих ставки унутар двоструких угластих заграда.';
$string['calculationsaved'] = 'Прорачун сачуван';
$string['calculationview'] = 'Погледај прорачун';
$string['cannotaccessgroup'] = 'Опростите, али не можете да приступите оценама изабраве групе.';
$string['categories'] = 'Категорије';
$string['categoriesanditems'] = 'Категорије и ставке';
$string['categoriesedit'] = 'Уреди категорије и ставке';
$string['category'] = 'Категорија';
$string['categoryedit'] = 'Уреди категорију';
$string['categoryname'] = 'Назив категорије';
$string['categorytotal'] = 'Укупна оцена за категорију';
$string['categorytotalfull'] = '{$a->category} укупно';
$string['categorytotalname'] = 'Назив за укупну оцену категоријe';
$string['changedefaults'] = 'Промени подразумевана подешавања';
$string['changereportdefaults'] = 'Промени подразумевана подешавања извештаја';
$string['chooseaction'] = 'Изабери акцију...';
$string['choosecategory'] = 'Изабери категорију';
$string['combo'] = 'Табови и Падајући мени';
$string['compact'] = 'Компактно';
$string['componentcontrolsvisibility'] = 'Подешавања активности контролишу да ли је ова ставка оцене сакривена.';
$string['contract'] = 'Скупи категорију';
$string['controls'] = 'Контроле';
$string['courseavg'] = 'Просек на нивоу курса';
$string['coursegradecategory'] = 'Категорија оцена курса';
$string['coursegradedisplaytype'] = 'Тип приказивања оцена на курсу';
$string['coursegradedisplayupdated'] = 'Тип приказа оцена на курсу је ажуриран.';
$string['coursegradesettings'] = 'Подешавање оцена курса';
$string['coursename'] = 'Назив курса';
$string['coursescales'] = 'Скале курса';
$string['coursesettings'] = 'Подешавања курса';
$string['coursesettingsexplanation'] = 'Подешавања курса одређују како се књига оцена приказује свим учесницима курса.';
$string['coursetotal'] = 'Укупно за курс';
$string['createcategory'] = 'Креирај категорију';
$string['createcategoryerror'] = 'Креирање нове категорије немогуће';
$string['creatinggradebooksettings'] = 'Креирање подешавања књиге оцена';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Тренутно надређено сумирање';
$string['curveto'] = 'Прилагоди на';
$string['decimalpoints'] = 'Број децималних места';
$string['decimalpoints_help'] = 'Ово подешавање одређује број децималних места која ће бити приказана за сваку оцену. Оно не утиче на израчунавања оцена, која се врше са прецизношћу од 5 децималних места.';
$string['default'] = 'Подразумевано';
$string['defaultprev'] = 'Подразумевано ({$a})';
$string['deletecategory'] = 'Обриши категорију';
$string['disablegradehistory'] = 'Онемогући историју оцена';
$string['disablegradehistory_help'] = 'Онемогући праћење историје промена у табелама које се односе на оцене. Ово може мало да убрза сервер и сачува простор у бази података.';
$string['displaylettergrade'] = 'Прикажи словне оцене (A, B, C...)';
$string['displaypercent'] = 'Прикажи проценте';
$string['displaypoints'] = 'Прикажи бодове';
$string['displayweighted'] = 'Прикажи пондерисане оцене';
$string['dropdown'] = 'Пaдајући мени';
$string['droplow'] = 'Одбаци најниже';
$string['droplowestvalue'] = 'Подесите број најнижих оцене за одбацивање';
$string['droplow_help'] = 'Ово подешавање омогућује да одређени број најнижих оцена буде искључен из сумирања.';
$string['dropped'] = 'Одбачено';
$string['dropxlowest'] = 'Одбаци X најнижих';
$string['dropxlowestwarning'] = 'Напомена: Ако користите опцију \'одбаци X најнижих оцена\' оцењивање претпоставља да све ставке унутар категорије имају исту вредност бода. Уколико се вредности бода разликују резултати ће бити непредвидљиви';
$string['duplicatescale'] = 'Дуплирај скалу';
$string['edit'] = 'Уреди';
$string['editcalculation'] = 'Уреди прорачун';
$string['editcalculationverbose'] = 'Уреди израчунaвање за {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Уреди повратне информације';
$string['editgrade'] = 'Уреди оцену';
$string['editgradeletters'] = 'Уреди словне оцене';
$string['editoutcome'] = 'Уреди исход учења';
$string['editoutcomes'] = 'Уреди исходе учења';
$string['editscale'] = 'Уреди скалу';
$string['edittree'] = 'Категорије';
$string['editverbose'] = 'Уреди {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Омогући AJAX';
$string['enableajax_help'] = 'Додаје AJAX функционалност извештају оцењивача, чиме поједностављује и убрзава уобичајене операције. Зависи од тога да ли је корисник укључио Javascript у свом веб читачу.';
$string['enableoutcomes'] = 'Омогући исходе учења';
$string['enableoutcomes_help'] = 'Подршка за исходе учења (тј. компетенције, циљеве, стандарде, или критеријуме) значи да се активности могу оцењивати коришћењем једне или више скала које су повезане са исказима исхода. Коришћење исхода учења тако омогућава специфично оцењивање на нивоу читавог сајта.';
$string['encoding'] = 'Кодирање';
$string['errorcalculationbroken'] = 'Вероватно постоји кружна референца или је формула за израчунавање оштећена';
$string['errorcalculationnoequal'] = 'Формула мора почети знаком једнакости (=1+2)';
$string['errorcalculationunknown'] = 'Неисправна формула';
$string['errorgradevaluenonnumeric'] = 'Добијена је ненумеричка вредност за високу или ниску оцену за';
$string['errornocalculationallowed'] = 'Израчунавања нису дозвољена за ову ставку';
$string['errornocategorisedid'] = 'Није могуће добити некатегорисан id!';
$string['errornocourse'] = 'Није могуће добити информације о курсу';
$string['errorreprintheadersnonnumeric'] = 'Добијена је ненумеричка вредност за поновни испис заглавља';
$string['errorsavegrade'] = 'Опростите, није могуће сачувати оцену.';
$string['errorsettinggrade'] = 'Грешка при покушају да се сачува "{$a->itemname}" оцена за кориснички id {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Грешка при ажурирању подешавања "Сумирај само уписане оцене" за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Грешка при ажурирању подешавања "Укључи исходе учења у сумирање" за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Грешка при ажурирању подешавања "Сумирај оцене укључујући поткатегорије" за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Грешка при ажурирању начина сумирања за категорију оцена чији је ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Грешка при ажурирању коефицијента сумирања (пондера или додатних бодова) ставке која се оцењује чији је ID {$a->id}';
$string['excluded'] = 'Искључено';
$string['excluded_help'] = 'Ако је означено, оцена неће бити укључена у било које сумирање.';
$string['expand'] = 'Прошири категорију';
$string['export'] = 'Извоз';
$string['exportalloutcomes'] = 'Извези све исходе учења';
$string['exportfeedback'] = 'Укључи повратне информације у извоз';
$string['exportonlyactive'] = 'Искључи суспендоване кориснике';
$string['exportonlyactive_help'] = 'Приликом извоза биће укључени само студенти који су активни на курсу и нису суспендовани';
$string['exportplugins'] = 'Извези додатке';
$string['exportsettings'] = 'Извези подешавања';
$string['exportto'] = 'Извези у';
$string['extracreditvalue'] = 'Додатни бодови за {$a}';
$string['extracreditwarning'] = 'Напомена: Подешавање додатних бодова за све ставке у категорији ће их уклонити из прорачуна оцене, те неће бити укупног броја бодова';
$string['feedback'] = 'Повратне информације';
$string['feedbackadd'] = 'Додај повратне информације';
$string['feedbackedit'] = 'Уреди повратне информације';
$string['feedbackforgradeitems'] = 'Повратна информација за {$a}';
$string['feedback_help'] = 'Ово поље омогућава додавање било каквог коментара о оцени.';
$string['feedbacks'] = 'Повратне информације';
$string['feedbacksaved'] = 'Повратне информације су сачуване';
$string['feedbackview'] = 'Погледај повратне информације';
$string['finalgrade'] = 'Коначна оцена';
$string['finalgrade_help'] = 'Ако је поље за измену означено, оцена може да буде додата или измењена.';
$string['fixedstudents'] = 'Статична колона са полазницима';
$string['fixedstudents_help'] = 'Ова опција фиксира колону са именима полазника и на тај начин омогућава да се колоне са оценама померају хоризонтално, а да се при томе колона са именима  полазника све време види.';
$string['forceoff'] = 'Обавезно: Искључено';
$string['forceon'] = 'Обавезно: Укључено';
$string['forelementtypes'] = 'за изабрани {$a}';
$string['forstudents'] = 'За полазнике';
$string['full'] = 'Пун';
$string['fullmode'] = 'Пуни приказ';
$string['fullview'] = 'Пуни приказ';
$string['generalsettings'] = 'Општа подешавања';
$string['grade'] = 'Оцена';
$string['gradeadministration'] = 'Администрација оцена';
$string['gradeanalysis'] = 'Анализа оцена';
$string['gradebook'] = 'Књига оцена';
$string['gradebookhiddenerror'] = 'Књига оцена је тренутно подешена тако да све скрива од полазника';
$string['gradebookhistories'] = 'Историје оцена';
$string['gradeboundary'] = 'Границе словних оцена';
$string['gradeboundary_help'] = 'Ово подешавање одређује минимални проценат изнад којег ће бити додељена словна оцена.';
$string['gradecategories'] = 'Категорије оцена';
$string['gradecategory'] = 'Категорија оцена';
$string['gradecategoryonmodform'] = 'Категорија оцена';
$string['gradecategoryonmodform_help'] = 'Ово подешавање контролише категорију у коју се смештају оцене за ову активност унутар књиге оцена.';
$string['gradecategorysettings'] = 'Подешавања категорије оцена';
$string['gradedisplay'] = 'Приказ оцена';
$string['gradedisplaytype'] = 'Тип приказа оцена';
$string['gradedisplaytype_help'] = 'Ово подешавање одређује начин на који ће оцене бити приказане у извештајима оцењивача и корисника.

* Број - праве оцене
* Проценат
* Слово - слова или речи се користе за приказ распона оцена';
$string['gradedon'] = 'Оцењено: $а';
$string['gradeexport'] = 'Извоз оцена';
$string['gradeexportcustomprofilefields'] = 'Прилагођена поља профила укључена у извоз оцена';
$string['gradeexportcustomprofilefields_desc'] = 'Укључите у извоз оцена ова прилагођена поља профила, раздвојена зарезима.';
$string['gradeexportdecimalpoints'] = 'Број децималних места при извозу оцена';
$string['gradeexportdecimalpoints_desc'] = 'Број децималних места за приказ при извозу. Ова вредност може бити промењена током извоза.';
$string['gradeexportdisplaytype'] = 'Тип приказа за извоз оцена';
$string['gradeexportdisplaytype_desc'] = 'Оцене могу бити приказане као цели бројеви, као проценти (у односу на најмање и највеће оцене) или као слова (А, Б, Ц итд.). Ово може бити промењено током експортовања.';
$string['gradeexportuserprofilefields'] = 'Поља корисничког профила укључена у извоз оцена';
$string['gradeexportuserprofilefields_desc'] = 'Укључите у извоз оцена ова поља корисничког профила, раздвојена зарезима.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Помоћ за оцене';
$string['gradehistorylifetime'] = 'Трајање историје оцена';
$string['gradehistorylifetime_help'] = 'Ово одређује колико дуго желите да чувате историју промена у табелама које су повезане са оценама. Препоручено је да историју чувате што је дуже могуће. Уколико будете имали проблема са перформансама система или ако имате ограничен простор за базу података, покушајте да поставите нижу вредност.';
$string['gradeimport'] = 'Увоз оцена';
$string['gradeimportfailed'] = 'Увоз оцена није успео. Више информација:';
$string['gradeitem'] = 'Могућа оцена';
$string['gradeitemaddusers'] = 'Искључи из оцењивања';
$string['gradeitemadvanced'] = 'Напредне опције за ставке оцењивања';
$string['gradeitemadvanced_help'] = 'Изабери све елементе које треба приказати као напредне када се уређују ставке оцењивања.';
$string['gradeitemislocked'] = 'Ова активност је закључана у књизи оцена. Промене које су начињене у оквиру ове активности неће бити копиране у књигу оцена све док се иста не откључа.';
$string['gradeitemlocked'] = 'Оцењивање закључано';
$string['gradeitemmembersselected'] = 'Искључено из оцењивања';
$string['gradeitemnonmembers'] = 'Укључено у оцењивање';
$string['gradeitemremovemembers'] = 'Укључи у оцењивање';
$string['gradeitems'] = 'Ставке оцењивања';
$string['gradeitemsettings'] = 'Подешавања ставки оцењивања';
$string['gradeitemsinc'] = 'Ставке оцењивања које треба укључити';
$string['gradeletter'] = 'Словна оцена';
$string['gradeletter_help'] = 'Словне оцене су А, Б, Ц... или речи, нпр. одличан, добар, довољан,... које се користе да представе распон оцена.';
$string['gradeletternote'] = 'Да бисте избрисали словну оцену само обришите било које од <br /> три текстулна поља за дато слово и притисните тастер за чување подешавања.';
$string['gradeletters'] = 'Словне оцене';
$string['gradelocked'] = 'Оцена је закључана';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Највећа оцена';
$string['grademax_help'] = 'Ово подешавање одређује максималну оцену када се као тип оцене користи бројчана вредност. Максимална оцена за активност се одређује на страници за подешавање те активности.';
$string['grademin'] = 'Најмања оцена';
$string['grademin_help'] = 'Ово подешавање одређује минималну оцену када се као тип оцене користи бројчана вредност.';
$string['gradeoutcomeitem'] = 'Оцени ставку исхода учења';
$string['gradeoutcomes'] = 'Исходи учења';
$string['gradeoutcomescourses'] = 'Исходи учења курса';
$string['gradepass'] = 'Оцена за пролаз';
$string['gradepass_help'] = 'Ово подешавање одређује минималну оцену потребну за пролаз. Вредност се користи за процену завршеност активности и курса, као и у књизи оцена где су прелазне оцене означене зеленом, а непрелазне црвеном бојом.';
$string['gradepreferences'] = 'Параметри оцене';
$string['gradepreferenceshelp'] = 'Помоћ за параметре оцене';
$string['gradepublishing'] = 'Омогући објављивање';
$string['gradepublishing_help'] = 'Омогућите објављивање у извозима и увозима података: Извезеним оценама може се приступити преко URL-a, без обавезне пријаве на Moodle сајт. Оцене се могу увозити приступом таквом URL-у (што значи да се на Moodle сајт могу увозити оцене објављене на другом сајту). Стандардно, само администратори могу користити ово својство. Молимо вас да детаљно обавестите кориснике пре него што ову могућност доделите другим улогама тј. корисницима - упозорите их на опасност дељења обележених ("букмаркованих") страница, коришћење програм за преузимање датотека (Flash Get и сличних програма), ограничења IP адреса итд.';
$string['gradereport'] = 'Извештај o оценама';
$string['graderreport'] = 'Извештај оцењивача';
$string['grades'] = 'Оцене';
$string['gradesforuser'] = 'Оцене за {$a->user}';
$string['gradesonly'] = 'Само оцене';
$string['gradessettings'] = 'Подешавања оцена';
$string['gradetype'] = 'Тип оцене';
$string['gradetype_help'] = 'Постоје 4 типа оцена:

* Ништа - оцењивање није могуће
* Вредност - бројчана вредност са максималном и минималном вредношћу
* Скала - ставка на списку
* Текст - само повратне информације

Само вредности и скале могу да се сумирају. Тип оцене за поједину активност се одређује на страници за подешавања те активности.';
$string['gradeview'] = 'Погледај оцену';
$string['gradewasmodifiedduringediting'] = 'Оцена унета под ставком {$a->itemname} за полазника са корисничким именом {$a->username} је игнорисана јер ју је касније ажурирао неко други.';
$string['gradeweighthelp'] = 'Помоћ за пондер оцена';
$string['groupavg'] = 'Просек групе';
$string['hidden'] = 'Сакривено';
$string['hiddenasdate'] = 'Прикажи датум за скривене оцене';
$string['hiddenasdate_help'] = 'Уколико корисник не може да види сакривене оцене прикажите датум када је оцена постављена уместо знака \'-\'.';
$string['hidden_help'] = 'Ако је означено, оцене су сакривене од полазника. Ако желите можете поставити опцију \'сакривено до дана\' како би се оцене објавиле након што је оцењивање завршено.';
$string['hiddenuntil'] = 'Сакривен до';
$string['hiddenuntildate'] = 'Сакривен до: {$a}';
$string['hideadvanced'] = 'Сакриј напредне опције';
$string['hideaverages'] = 'Сакриј просеке';
$string['hidecalculations'] = 'Сакриј прорачуне';
$string['hidecategory'] = 'Сакривено';
$string['hideeyecons'] = 'Сакриј иконице прикажи/сакриј';
$string['hidefeedback'] = 'Сакриј повратне информације';
$string['hideforcedsettings'] = 'Сакриј принудна подешавања';
$string['hideforcedsettings_help'] = 'Не приказуј принудна подешавања у корисничком интерфејсу за оцењивање';
$string['hidegroups'] = 'Сакриј групе';
$string['hidelocks'] = 'Сакриј закључавања';
$string['hidenooutcomes'] = 'Прикажи исходе учења';
$string['hidequickfeedback'] = 'Сакриј брзе повратне информације';
$string['hideranges'] = 'Сакриј опсеге';
$string['hidetotalifhiddenitems'] = 'Сакриј укупне оцене ако садрже скривене ставке';
$string['hidetotalifhiddenitems_help'] = 'Ово подешавање одређује да ли се укупне оцене које садрже сакривене ставке приказују полазницима или се замењују цртицом (-). Ако се приказују, укупна оцена може бити израчуната или без или са сакривеним ставкама.

Ако су сакривене ставке искључене, укупна оцена ће бити различита од укупне оцене коју види предавач у извештају оцењивача, зато што предавач увек види укупну оцену за све ставке, без обзира јесу ли оне сакривене или не. Ако су сакривене ставке укључене у укупну оцену, полазници могу да израчунају оцене за сакривене ставке.';
$string['hidetotalshowexhiddenitems'] = 'Прикажи укупне оцене без сакривених ставки';
$string['hidetotalshowinchiddenitems'] = 'Прикажи укупне оцене укључујући сакривене ставке';
$string['hideverbose'] = 'Сакриј {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Сортирај по висини оцене - растући низ';
$string['highgradedescending'] = 'Сортирај по висини оцене - опадајући низ';
$string['highgradeletter'] = 'Горња граница';
$string['identifier'] = 'Идентификуј корисника према';
$string['idnumbers'] = 'ID бројеви';
$string['ignore'] = 'Игнориши';
$string['import'] = 'Увези';
$string['importcsv'] = 'Увези CSV';
$string['importcustom'] = 'Увези као наменски прилагођене исходе учења (само за овај курс)';
$string['importerror'] = 'Дошло је до грешке, овај скрипт није био позван са правим параметрима';
$string['importfailed'] = 'Увоз није успео. Ништа од података није увезено.';
$string['importfeedback'] = 'Увези повратне информације';
$string['importfile'] = 'Увези датотеку';
$string['importfilemissing'] = 'Ниједна датотека није примљена, вратите се на образац и уверите се да сте проследили исправну датотеку.';
$string['importfrom'] = 'Увези из';
$string['importoutcomenofile'] = 'Постављена датотека је празна или оштећена. Молимо, проверите да ли је датотека исправна. Проблем је откривен у реду {$a}; ово је покренуто због редова са подацима који нису имали једнак број колона као први (насловни) ред, или уколико су недостајала очекивана заглавља у увезеној датотеци. Погледајте извезену датотеку за пример датотеке исправним заглављем.';
$string['importoutcomes'] = 'Увези исходе учења';
$string['importoutcomes_help'] = 'Исходи учења могу бити увезени из CSV датотеке која има формат као и CSV датотека за извоз исхода учења.';
$string['importoutcomesuccess'] = 'Увезен исход учења "{$a->name}" са ID #{$a->id}';
$string['importplugins'] = 'Увези додатке';
$string['importpreview'] = 'Преглед увезених оцена';
$string['importsettings'] = 'Подешавања увоза';
$string['importskippednomanagescale'] = 'Немате овлашћење за додавање нове скале оцењивања, тако да је исход учења"{$a}" изузет  јер је захтевао креирање нове скале';
$string['importskippedoutcome'] = 'Исход са краћим називом "{$a}" већ постоји у овом контексту, онај из увезене датотеке је прескочен.';
$string['importstandard'] = 'Увези као стандардне исходе учења';
$string['importsuccess'] = 'Успешан увоз оцена';
$string['importxml'] = 'Увези XML';
$string['includescalesinaggregation'] = 'Укључи скале у сумирање';
$string['includescalesinaggregation_help'] = 'Можете променити да се скале за оцењивање укључе као бројеви у свим збирним оценама у свим књигама оцена на свим курсевима. УПОЗОРЕЊЕ: промена овог подешавања покренуће поновно израчунавање свих збирних оцена.';
$string['incorrectcourseid'] = 'ID курса је нетачан';
$string['incorrectcustomscale'] = '(Неисправна прилагођена скала, молимо промените.)';
$string['incorrectminmax'] = 'Минимална вредност мора бити мања од максималне';
$string['inherit'] = 'Наслеђено';
$string['intersectioninfo'] = 'Полазник/Оцена инфо';
$string['item'] = 'Ставка';
$string['iteminfo'] = 'Информације о ставци';
$string['iteminfo_help'] = 'Ово подешавање обезбеђује простор за унос информација о ставци. Информације се нигде другде не приказују.';
$string['itemname'] = 'Назив ставке';
$string['itemnamehelp'] = 'Назив ове ставке добијен од модула.';
$string['items'] = 'Ставке';
$string['itemsedit'] = 'Уреди ставку оцене';
$string['keephigh'] = 'Задржи највећу';
$string['keephigh_help'] = 'Ако је ова опција подешена, чуваће се само X највиших оцена, где је X одабрана вредност за ову опцију.';
$string['keymanager'] = 'Управљање кључевима';
$string['lessthanmin'] = 'Оцена унета за {$a->itemname} за корисника {$a->username} је мања од минимално дозвољене';
$string['letter'] = 'Слово';
$string['lettergrade'] = 'Словна оцена';
$string['lettergradenonnumber'] = 'Најнижа и/или највиша оцена нису биле нумеричке за';
$string['letterpercentage'] = 'Слово (проценат)';
$string['letterreal'] = 'Слово (реална вредност)';
$string['letters'] = 'Слова';
$string['linkedactivity'] = 'Линкована активност';
$string['linkedactivity_help'] = 'Ово подешавање одређује активност са којом је овај исход учења повезан. Ово се може користити за мерење постигнућа полазника која се не процењују помоћу оцена активности.';
$string['linktoactivity'] = 'Линк ка активности {$a->name}';
$string['lock'] = 'Закључај';
$string['locked'] = 'Закључано';
$string['locked_help'] = 'Ако је означено, оцене су закључане и више не могу бити аутоматски ажуриране од стране припадајуће активности.';
$string['locktime'] = 'Закључано након';
$string['locktimedate'] = 'Закључај након: {$a}';
$string['lockverbose'] = 'Закључај {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Најниже';
$string['lowgradeletter'] = 'Доња граница';
$string['manualitem'] = 'Ручне ставке';
$string['mapfrom'] = 'Пресликај из';
$string['mappings'] = 'Пресликавање ставки оцена';
$string['mapto'] = 'Пресликај у';
$string['max'] = 'Највише';
$string['maxgrade'] = 'Максимална оцена';
$string['meanall'] = 'Све оцене';
$string['meangraded'] = 'Уписане оцене';
$string['meanselection'] = 'Оцене одабране за рачунање просека колоне';
$string['meanselection_help'] = 'Ово подешавање одредите да ли  поља без уписане оцене треба да буду укључене у рачунање просека (средње вредности) за сваку категорију или ставку оцене.';
$string['median'] = 'Медијана';
$string['min'] = 'Најниже';
$string['missingscale'] = 'Скала за оцењивање мора бити изабрана';
$string['mode'] = 'Мод';
$string['morethanmax'] = 'Оцена унета за {$a->itemname} за корисника {$a->username} је већа од максимално дозвољене';
$string['moveselectedto'] = 'Премести изабране ставке у';
$string['movingelement'] = 'Померање {$a}';
$string['multfactor'] = 'Мултипликатор';
$string['multfactor_help'] = 'Мултипликатор је фактор којим ће све оцене за ову ставку бити помножене, са највећом вредношћу максималне оцене. На пример, ако је мултипликатор 2 а максимална оцена 100, онда ће све оцене мање од 50 бити помножене са 2, а све оцене изнад 50 промењене у 100.';
$string['multfactorvalue'] = 'Вредност мултипликатора за {$a}';
$string['mypreferences'] = 'Моја подешавања';
$string['myreportpreferences'] = 'Мој извештај - подешавања';
$string['navmethod'] = 'Метод навигације';
$string['neverdeletehistory'] = 'Никада не бриши историју';
$string['newcategory'] = 'Нова категорија';
$string['newitem'] = 'Нова ставка оцене';
$string['newoutcomeitem'] = 'Нови исход учења';
$string['no'] = 'Не';
$string['nocategories'] = 'Категорије оцена за овај курс не могу бити додате или пронађене';
$string['nocategoryname'] = 'Није дат назив категорије';
$string['nocategoryview'] = 'Нема категорије за приказ';
$string['nocourses'] = 'Још увек нема курсева';
$string['noforce'] = 'Не форсирај подешавања';
$string['nogradeletters'] = 'Нема подешених словних оцена';
$string['nogradesreturned'] = 'Нема добијених оцена';
$string['noidnumber'] = 'Нема ID броја';
$string['nolettergrade'] = 'Нема словне оцене за';
$string['nomode'] = 'Није применљиво';
$string['nonnumericweight'] = 'Добијена је ненумеричка вредност за';
$string['nonunlockableverbose'] = 'Ова оцена не може се откључати док се не откључа {$a->itemname}.';
$string['nonweightedpct'] = 'непондерисани %';
$string['nooutcome'] = 'Без исхода учења';
$string['nooutcomes'] = 'Ставке исхода учења морају бити повезане са исходом курса, али за овај курс не постоје исхода . Да ли желите да додате исход учења?';
$string['nopublish'] = 'Не објављивати';
$string['norolesdefined'] = 'Ниједна улога није дефинисана у Администрација > Oцене > Општа подешавања > Улоге које се оцењују';
$string['noscales'] = 'Исходи морају бити повезани са скалом курса или глобалном скалом';
$string['noselectedcategories'] = 'није изабрана ниједна категорија.';
$string['noselecteditems'] = 'није изабрана ниједна ставка.';
$string['notteachererror'] = 'Морате бити предавач да бисте користили ову опцију.';
$string['nousersloaded'] = 'Нису учитани корисници';
$string['numberofgrades'] = 'Број оцена';
$string['onascaleof'] = 'на скали од {$a->grademin} до {$a->grademax}';
$string['operations'] = 'Операције';
$string['options'] = 'Опције';
$string['others'] = 'Остало';
$string['outcome'] = 'Исход учења';
$string['outcomeassigntocourse'] = 'Додели други исход учења овом курсу';
$string['outcomecategory'] = 'Креирај исходе у категорији';
$string['outcomecategorynew'] = 'Нова категорија';
$string['outcomeconfirmdelete'] = 'Да ли сте сигурни да желите да обришете исход учења "{$a}"?';
$string['outcomecreate'] = 'Додај нови исход учења';
$string['outcomedelete'] = 'Обриши исход учења';
$string['outcomefullname'] = 'Пуно име';
$string['outcome_help'] = 'Ово подешавање одређује исход учења који ће ова ставка оцењивања представљати у књизи оцена.';
$string['outcomeitem'] = 'Ставка исхода учења';
$string['outcomeitemsedit'] = 'Уреди ставку исхода учења';
$string['outcomereport'] = 'Извештај о исходима учења';
$string['outcomes'] = 'Исходи учења';
$string['outcomescourse'] = 'Исходи учења коришћени на курсу';
$string['outcomescoursecustom'] = 'Користе се нестандардни исходи учења (не могу се уклонити)';
$string['outcomescoursenotused'] = 'Не користе се стандардни исходи учења';
$string['outcomescourseused'] = 'Користе се стандардни исходи учења (не могу се уклонити)';
$string['outcomescustom'] = 'Нестандардни исходи учења';
$string['outcomeshortname'] = 'Скраћени назив';
$string['outcomesstandard'] = 'Стандардни исходи учења';
$string['outcomesstandardavailable'] = 'Расположиви стандардни исходи учења';
$string['outcomestandard'] = 'Стандардни исход учења';
$string['outcomestandard_help'] = 'Стандардни исход учења је доступан у свим курсевима на сајту.';
$string['overallaverage'] = 'Свеукупан просек';
$string['overridden'] = 'Поништено';
$string['overridden_help'] = 'Ако је означено, оцене не могу више да се мењају унутар припадајуће активности.

Када се оцена мења унутар извештаја оцењивача, поље за измену оцене је аутоматски означено.
Међутим, ознака се може уклонити како би се се дозволило да оцена буде промењена унутар припадајуће активности.';
$string['overriddennotice'] = 'Ваша завршна оцена за ову активност је ручно подешена';
$string['overridesitedefaultgradedisplaytype'] = 'Поништи подразумеване вредности на нивоу сајта';
$string['overridesitedefaultgradedisplaytype_help'] = 'Ако је означено, могу се подешавати словне оцене и њихови опсези на нивоу курса, уместо да се користе подразумевана подешавања на нивоу сајта.';
$string['parentcategory'] = 'Надређена категорија';
$string['pctoftotalgrade'] = '% од укупне оцене';
$string['percent'] = 'Проценат';
$string['percentage'] = 'Проценат';
$string['percentageletter'] = 'Проценат (слово)';
$string['percentagereal'] = 'Проценат (реална вредност)';
$string['percentascending'] = 'Сортирај по процентима - растући низ';
$string['percentdescending'] = 'Сортирај по процентима - опадајући низ';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Помак';
$string['plusfactor_help'] = 'Помак је број који се додаје свакој оцени за ову ставку, након примене мултипликатора.';
$string['plusfactorvalue'] = 'Офсет (додатnа) вредност за {$a}';
$string['points'] = 'бодова';
$string['pointsascending'] = 'Сортирај по бодовима - растући низ';
$string['pointsdescending'] = 'Сортирај по бодовима - опадајући низ';
$string['positionfirst'] = 'Први';
$string['positionlast'] = 'Последњи';
$string['preferences'] = 'Подешавања';
$string['prefgeneral'] = 'Општа подешавања';
$string['prefletters'] = 'Словне оцене и границе';
$string['prefrows'] = 'Специјални редови';
$string['prefshow'] = 'Прекидачи прикажи/сакриј';
$string['previewrows'] = 'Преглед редова';
$string['profilereport'] = 'Извештај корисничког профила';
$string['profilereport_help'] = 'Извештај о оценама који се користи на страници са профилом корисника.';
$string['publishing'] = 'Објављивање';
$string['quickfeedback'] = 'Брзе повратне информације';
$string['quickgrading'] = 'Брзо оцењивање';
$string['quickgrading_help'] = 'Ако је ова опција омогућена, када је уређивање укључено , за сваку оцену се појављује поље за унос текста, што омогућава да се истовремено уређује већи број оцена. Када се кликне да на дугме за ажурирање, промене су сачуване и истакнуте.

Имајте у виду да је, приликом уређивања оцене у извештају оцењивача, постављена заставица (индикатор) измене, што значи да оцена не може више да се мења унутар припадајуће активности.';
$string['range'] = 'Опсег';
$string['rangedecimals'] = 'Број децималних места опсега';
$string['rangedecimals_help'] = 'Број децималних места које треба приказати за опсег .';
$string['rangesdecimalpoints'] = 'Децимале приказане у опсезима';
$string['rangesdecimalpoints_help'] = 'Ово подешавање одређује број децималних места који ће бити приказан за сваки опсег, односно да ли ће бити коришћено подешавање броја децималних места за категорију или за ставку оцене (наслеђено)';
$string['rangesdisplaytype'] = 'Тип приказа опсега';
$string['rangesdisplaytype_help'] = 'Ово подешавање одређује да ли се опсег приказује као број, проценат или слово, односно, да ли ће се користити тип приказа за категорију или за ставку оцене (наслеђено).';
$string['rank'] = 'Ранг';
$string['rawpct'] = 'Необрађени %';
$string['real'] = 'Реална вредност';
$string['realletter'] = 'Реална вредност (слово)';
$string['realpercentage'] = 'Реална вредност (проценат)';
$string['recovergradesdefault'] = 'Поврати подразумеване оцене';
$string['recovergradesdefault_help'] = 'Стандардно, враћа старе оцене када поново уписујете корисника на курс.';
$string['regradeanyway'] = 'Ипак поново оцени';
$string['removeallcoursegrades'] = 'Обриши све оцене';
$string['removeallcourseitems'] = 'Обриши све ставке и категорије';
$string['report'] = 'Извештај';
$string['reportdefault'] = 'Подразумевани извештај ({$a})';
$string['reportplugins'] = 'Додаци за извештај';
$string['reportsettings'] = 'Подешавање извештаја';
$string['reprintheaders'] = 'Поновни испис заглавља';
$string['respectingcurrentdata'] = 'остављајући тренутна подешавања неизмењена';
$string['rowpreviewnum'] = 'Број редова за преглед';
$string['savechanges'] = 'Сачувај промене';
$string['savepreferences'] = 'Сачувај параметре';
$string['scaleconfirmdelete'] = 'Да ли сте сигурни да желите да обришете скалу "{$a}"?';
$string['scaledpct'] = 'Скалирани %';
$string['seeallcoursegrades'] = 'Погледај све оцене курса';
$string['select'] = 'Изабери {$a}';
$string['selectalloroneuser'] = 'Изабери све или ниједног корисника';
$string['selectauser'] = 'Изабери корисника';
$string['selectdestination'] = 'Изабери одредиште за {$a}';
$string['separator'] = 'Граничник';
$string['sepcolon'] = 'Двотачка';
$string['sepcomma'] = 'Зарез';
$string['sepsemicolon'] = 'Тачка и зарез';
$string['septab'] = 'Табулатор';
$string['setcategories'] = 'Подеси категорије';
$string['setcategorieserror'] = 'Прво морате да подесите категорије за свој курс пре него што им одредите пондере.';
$string['setgradeletters'] = 'Подеси словне оцене';
$string['setpreferences'] = 'Подеси параметре';
$string['setting'] = 'Подешавање';
$string['settings'] = 'Подешавања';
$string['setweights'] = 'Подеси пондере';
$string['showactivityicons'] = 'Прикажи иконице активности';
$string['showactivityicons_help'] = 'Ако је ова опција омогућена, иконице активности ће бити приказане поред назива активности.';
$string['showallhidden'] = 'Прикажи скривене';
$string['showallstudents'] = 'Прикажи све полазнике';
$string['showanalysisicon'] = 'Прикажи иконицу за анализу оцена';
$string['showanalysisicon_desc'] = 'Да ли, стандардно, приказати иконицу за анализу оцена. Ако модул активност то подржава, иконица за анализу оцена је повезана са страницом са детаљнијим објашњењем оцене и како је она добијена.';
$string['showanalysisicon_help'] = 'Ако модул активност то подржава, иконица за анализу оцена је повезана са страницом са детаљнијим објашњењем оцене и како је она добијена.';
$string['showaverage'] = 'Прикажи просек';
$string['showaverage_help'] = 'Прикажи просек колоне? Полазници би могли да процене оцене других полазника ако се просек рачуна на основу мањег броја оцена. Због брзине извођења, просек је приближан уколико зависи од скривених ставки.';
$string['showaverages'] = 'Прикажи просечне вредности колона';
$string['showaverages_help'] = 'Ако је ова опција омогућена, извјештај оцењивача ће садржати додатни ред у којем ће бити приказан просек (средња вредност) за сваку категорију и сваку ставку која се оцењује.';
$string['showcalculations'] = 'Прикажи прорачуне';
$string['showcalculations_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, за сваку ставку оцене и категорију оцењивања  приказује се калкулатор, заједно са кратким упутством, које се појављује када се мишем пређе преко израчунате ставке, као и са визуелним индикатором да је колона израчуната.';
$string['showeyecons'] = 'Прикажи иконице прикажи/сакриј';
$string['showeyecons_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, поред сваке оцене се појављује иконица прикажи/сакриј, чиме се контролише да ли ће полазник моћи да види своје оцене.';
$string['showfeedback'] = 'Прикажи повратне информације';
$string['showfeedback_help'] = 'Да ли приказати колону са повратним информацијама?';
$string['showgrade'] = 'Прикажи оцене';
$string['showgrade_help'] = 'Да ли приказати колону са оценама?';
$string['showgroups'] = 'Прикажи групе';
$string['showhiddenitems'] = 'Прикажи сакривене ставке';
$string['showhiddenitems_help'] = 'Да ли су сакривене ставке оцена сакривенe у потпуности или су називи тих ставки видљиви полазницима?

* Прикажи сакривено - називи сакривених ставки су приказани, али оцене полазника нису
* Сакривено до - ставке су потпуно сакривене до наведеног датума након чега су у потпуности видљиве.
* Не приказуј - сакривене ставке су у потпуности сакривене';
$string['showhiddenuntilonly'] = 'Сакривено до';
$string['showlettergrade'] = 'Прикажи словне оцене';
$string['showlettergrade_help'] = 'Да ли приказати колону са словним оценама?';
$string['showlocks'] = 'Прикажи закључавања';
$string['showlocks_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, поред сваке оцене се приказује иконица закључај/откључај којом се контролише да ли оцене могу аутоматски да се ажурирају од стране припадајуће активности.';
$string['shownohidden'] = 'Не приказуј';
$string['shownooutcomes'] = 'Сакриј исходе учења';
$string['shownumberofgrades'] = 'Прикажи број оцена у просецима';
$string['shownumberofgrades_help'] = 'Ако је омогућена ова опција, број оцена, коришћених приликом израчунавања просека (средње вредности), приказан је у загради поред сваког просека.';
$string['showonlyactiveenrol'] = 'Прикажи само активне уписе';
$string['showonlyactiveenrol_help'] = 'Ово подешавање одређује да ли ће у извештају из књиге оцена бити видљиви само уписани корисници који су активни. Ако је подешавање омогућено суспендовани корисници неће бити приказани у књизи оцена.';
$string['showpercentage'] = 'Прикажи проценат';
$string['showpercentage_help'] = 'Да ли приказати процентуалну вредност за сваку ставку оцене?';
$string['showquickfeedback'] = 'Прикажи брзе повратне информације';
$string['showquickfeedback_help'] = 'Ако је ова опција омогућена, када је уређивање укључено, поред сваке оцене приказује се поље, са испрекиданим ивицама, за унос повратних информација. што омогућава да се истовремено уређују повратне информације за већи број оцена. Када се кликне да на дугме за ажурирање, промене су сачуване и истакнуте.

Имајте у виду да је, приликом уређивања повратних информација у извештају оцењивача, постављена заставица (индикатор) измене, што значи да повратне информације не могу више да се мењају унутар припадајуће активности';
$string['showrange'] = 'Прикажи опсеге';
$string['showrange_help'] = 'Да ли приказати колону са опсегом?';
$string['showranges'] = 'Прикажи опсеге';
$string['showranges_help'] = 'Ако је ова опција омогућена, извештај оцењивача ће садржати додатни ред у којем ће бити приказан опсег за сваку категорију и ставку која се оцењује.';
$string['showrank'] = 'Прикажи ранг';
$string['showrank_help'] = 'Да ли приказати позицију полазника у односу на остале учеснике за сваку ставку оцене?';
$string['showuserimage'] = 'Прикажи слике из корисничких профила';
$string['showuserimage_help'] = 'Да ли приказати слику корисника поред његовог имена у извешатају оцењивача?';
$string['showverbose'] = 'Прикажи {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Прикажи пондере';
$string['showweight_help'] = 'Да ли приказати колону са пондерима оцена?';
$string['simpleview'] = 'Једноставан приказ';
$string['sitewide'] = 'На целом сајту';
$string['sort'] = 'сортирај';
$string['sortasc'] = 'Сортирај у растућем низу';
$string['sortbyfirstname'] = 'Сортирај по имену';
$string['sortbylastname'] = 'Сортирај по презимену';
$string['sortdesc'] = 'Сортирај у опадајућем низу';
$string['standarddeviation'] = 'Стандардна девијација';
$string['stats'] = 'Статистика';
$string['statslink'] = 'Статистика';
$string['student'] = 'Полазник';
$string['studentsperpage'] = 'Број полазника по страни';
$string['studentsperpage_help'] = 'Ово подешавање одређује број полазника који ће бити приказан на свакој страници извештаја оцењивача';
$string['studentsperpagereduced'] = 'Максималан број полазника по страници је смањен са {$a->originalstudentsperpage} на {$a->studentsperpage}. Размислите о повећању вредности за PHP подешавање max_input_vars из {$a->maxinputvars}.';
$string['subcategory'] = 'Нормална категорија';
$string['submissions'] = 'Предато';
$string['submittedon'] = 'Предато: {$a}';
$string['switchtofullview'] = 'Пређи на потпун приказ';
$string['switchtosimpleview'] = 'Пређи на једноставан приказ';
$string['tabs'] = 'Табулатори';
$string['topcategory'] = 'Надкатегорија';
$string['total'] = 'Укупно';
$string['totalweight100'] = 'Укупни пондер је једнак 100';
$string['totalweightnot100'] = 'Укупни пондер није једнак 100';
$string['turnfeedbackoff'] = 'Искључи повратне информације';
$string['turnfeedbackon'] = 'Укључи повратне информације';
$string['typenone'] = 'Ниједан';
$string['typescale'] = 'Скала';
$string['typescale_help'] = 'Ово подешавање одређује скалу која се користи када се оцењивање врши помоћу скала. Скала за оцењивање активности се поставља на страници за подешавање те активности.';
$string['typetext'] = 'Текст';
$string['typevalue'] = 'Вредност';
$string['uncategorised'] = 'Некатегорисано';
$string['unchangedgrade'] = 'Оцена је непромењена';
$string['unenrolledusersinimport'] = 'Овај увоз је укључио следеће оцене за кориснике који тренутно нису уписани на овај курсу: {$a}';
$string['unlimitedgrades'] = 'Неограничене оцене';
$string['unlimitedgrades_help'] = 'Стандардно, оцене су ограничене максималном и минималном вредношћу ставке која се оцењује. Ако се омогући ово подешавања укида се то ограничење и дозвољава се да оцене веће од 100% буду директно унете у књигу оцена. Препоручује се да ово подешавање буде укључено у време смањене активности на сајту, пошто ће све оцене бити прерачунате, што може да  резултира великим оптерећењем сервера.';
$string['unlock'] = 'Откључај';
$string['unlockverbose'] = 'Откључај {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Некоришћено';
$string['updatedgradesonly'] = 'Извези само нове или ажуриране оцене';
$string['uploadgrades'] = 'Пошаљи оцене';
$string['useadvanced'] = 'Користи напредне опције';
$string['usedcourses'] = 'Коришћени курсеви';
$string['usedgradeitem'] = 'Коришћена ставка оцењивања';
$string['usenooutcome'] = 'Не користи исходе учења';
$string['usenoscale'] = 'Без скала';
$string['usepercent'] = 'Користи проценте';
$string['user'] = 'Корисник';
$string['userenrolmentsuspended'] = 'Упис корисника је суспендован';
$string['usergrade'] = 'Корисник {$a->fullname} ({$a->useridnumber}) за ставку {$a->gradeidnumber}';
$string['userid'] = 'Идентификатор корисника';
$string['usermappingerror'] = 'Грешка приликом мапирања корисника: није могуће пронаћи корисника са пољем {$a->field} које има вредност "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Корисник није члан текуће групе.';
$string['usermappingerrorusernotfound'] = 'Грешка приликом мапирања корисника: Није могуће пронаћи корисника,';
$string['userpreferences'] = 'Корисничка подешавања';
$string['useweighted'] = 'Користи пондерисане вредности';
$string['verbosescales'] = 'Детаљне скале';
$string['viewbygroup'] = 'Група';
$string['viewgrades'] = 'Погледај оцене';
$string['warningexcludedsum'] = 'Упозорење: искључивање оцена није компатибилно са сумирањем.';
$string['weight'] = 'пондер';
$string['weightcourse'] = 'Користи пондерисане оцене за курс';
$string['weightedascending'] = 'Сортирај према пондерисаном проценту - растући низ';
$string['weighteddescending'] = 'Сортирај према пондерисаном проценту - опадајући низ';
$string['weightedpct'] = 'пондерисани %';
$string['weightedpctcontribution'] = 'допринос пондерисаних % у укупној оцени';
$string['weightorextracredit'] = 'Пондер или додатни бодови';
$string['weights'] = 'Пондери';
$string['weightsedit'] = 'Уреди пондер и додатне бодове';
$string['weightuc'] = 'Пондер';
$string['writinggradebookinfo'] = 'Записивање подешавања књиге оцена';
$string['xml'] = 'XML';
$string['yes'] = 'Да';
$string['yourgrade'] = 'Ваша оцена';
