<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'sr_cr', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Имате задатке на које треба обратити пажњу';
$string['addsubmission'] = 'Додај рад';
$string['allowdeleting'] = 'Дозволи брисање';
$string['allowdeleting_help'] = 'Ако је ова опција омогућена, полазници могу да бришу постављене датотеке у било ком тренутку, пре него што предају рад за оцењивање..';
$string['allowmaxfiles'] = 'Максималан број постављених датотека';
$string['allowmaxfiles_help'] = 'Максималан број датотека који може бити постављен. Како се овај број нигде не приказује полазницима, потребно је да у опису задатка обавезно наведете овај број, како би полазници знали колико датотека могу да поставе.';
$string['allownotes'] = 'Дозволи белешке';
$string['allownotes_help'] = 'Ако је ова опција омогућена, полазници ће моћи да уносе белешке у за то предвиђено поље за унос текста, слично као код задатка типа \'Онлајн текст\'.';
$string['allowresubmit'] = 'Дозволи поновно предавање рада';
$string['allowresubmit_help'] = 'Ако је ова опција омогућена, полазницима ће бити дозвољено да поново предају своје радове након што су претходне верзије већ оцењене (како би их наставник поново оценио).';
$string['alreadygraded'] = 'Ваш задатак је већ оцењен и поновно решавање задатка није дозвољено.';
$string['assignment:addinstance'] = 'Додај нови задатак';
$string['assignmentdetails'] = 'Детаљи задатка';
$string['assignment:exportownsubmission'] = 'Извоз сопственог рада';
$string['assignment:exportsubmission'] = 'Извези рад';
$string['assignment:grade'] = 'Оцени задатак';
$string['assignmentmail'] = '{$a->teacher} је послао/ла повратне информације на рад који сте предали за задатка \'{$a->assignment}\'.

Повратне информације су придружене вашем раду и можете их погледати на:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->teacher} је послао/ла повратне информације на рад који сте предали за задатка \'<i>{$a->assignment}</i>\'. </p>

</p>Повратне информације можете погледати придружене вашем <a href="{$a->url}">раду</a>.</p>';
$string['assignmentmailsmall'] = '{$a->teacher} је послао/ла повратне информације на рад који сте предали за задатка \'{$a->assignment}\'. Повратне информације можете видети придружене вашем раду.';
$string['assignmentname'] = 'Назив задатка';
$string['assignmentsubmission'] = 'Предати радови';
$string['assignment:submit'] = 'Предај задатак';
$string['assignmenttype'] = 'Тип задатка';
$string['assignment:view'] = 'Прегледај задатак';
$string['availabledate'] = 'Доступан од';
$string['cannotdeletefiles'] = 'Дошло је до грешке и датотеке се не могу обрисати.';
$string['cannotviewassignment'] = 'Не можете прегледати овај задатак';
$string['changegradewarning'] = 'Овај задатак садржи оцењене предате радове па промена оцене неће аутоматски поново израчунати постојеће оцене радова. Морате поново оценити све постојеће радове ако желите да промените оцену.';
$string['closedassignment'] = 'Oвај задатак је затворен, пошто је прошао крајњи рок за предају.';
$string['comment'] = 'Коментар';
$string['commentinline'] = 'Коментар унутар задатка';
$string['commentinline_help'] = 'Ако је ова опција омогућена, предати текст рада ће, приликом оцењивања, бити копиран у поље за повратне информације, како би наставник могао лакше да га коментарише (коришћењем различите боје, на пример) или да уређује оригинални текст.';
$string['configitemstocount'] = 'Врста прилога који ће се признавати као радови полазника у онлајн задацима.';
$string['configmaxbytes'] = 'Подразумевана максимална величина за све задатке на сајту (везано за ограничење курса и остала локална подешавања)';
$string['configshowrecentsubmissions'] = 'Сви могу да виде обавештење о предатим радовима у извештају о скорашњим активностима.';
$string['confirmdeletefile'] = 'Да ли сте потпуно сигурни да желите да обришете ову датотеку?<br /><strong>{$a}</strong>';
$string['coursemisconf'] = 'Курс није исправно подешен';
$string['currentgrade'] = 'Тренутна оцена у књизи оцена';
$string['deleteallsubmissions'] = 'Обриши сва предата радове';
$string['deletefilefailed'] = 'Брисање датотеке није успело.';
$string['description'] = 'Опис';
$string['downloadall'] = 'Преузми све задатке као zip архиву';
$string['draft'] = 'Нацрт';
$string['due'] = 'Рок за предају задатка';
$string['duedate'] = 'Крајњи рок';
$string['duedateno'] = 'Нема крајњег рока';
$string['early'] = '{$a} раније';
$string['editmysubmission'] = 'Измени мој рад';
$string['editthesefiles'] = 'Уреди ове датотеке';
$string['editthisfile'] = 'Ажурирај ову датотеку';
$string['emailstudents'] = 'Слање упозорења полазницима електронском поштом';
$string['emailteachermail'] = '{$a->username} је ажурирао/ла свој рад за задатка \'{$a->assignment}\' у  {$a->timeupdated}

Рад је доступно на следећој адреси:

{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} је ажурирао/ла свој рад за задатак <i>\'{$a->assignment}\' у  {$a->timeupdated}</i> </p>
<p>Рад је <a href="{$a->url}">доступан на сајту</a>.</p>';
$string['emailteachers'] = 'Слање упозорења предавачима електронском поштом';
$string['emailteachers_help'] = 'Ако је ова опција омогућена, кад год полазник преда или ажурира свој рад, наставници ће бити обавештени електронском поруком.

Само наставници који могу да оцењују конкретан задатак ће добити ово обавештењe. Тако на пример, ако се курс реализује за одвојене групе, наставници задужени за конкретне групе неће примати никаква обавештења о полазницима из других група.';
$string['emptysubmission'] = 'Још увек нисте ништа предали';
$string['enablenotification'] = 'Пошаљи обавештење';
$string['enablenotification_help'] = 'Ако је ова опција омогућена полазници ће добијати обавештење електронском поштом када њихови радови буде оцењени.';
$string['errornosubmissions'] = 'Нема предатих радова за преузимање';
$string['existingfiledeleted'] = 'Постојећа датотека је обрисана: {$a}';
$string['failedupdatefeedback'] = 'Ажурирање повратних информација за корисника {$a} није успело.';
$string['feedback'] = 'Повратне информације';
$string['feedbackfromteacher'] = 'Повратне информације које је послао/ла {$a}';
$string['feedbackupdated'] = 'Повратне информације су ажуриране за {$a} корисника';
$string['finalize'] = 'Спречи ажурирање задатка';
$string['finalizeerror'] = 'Дошло је до грешке и тај рад није могуће довршити';
$string['futureaassignment'] = 'Овај задатак још увек није доступан.';
$string['graded'] = 'Оцењено';
$string['guestnosubmit'] = 'Жао нам је, али гостима није дозвољено да предају свој рад. Морате се регистровати/пријавити као регистровани корисник да бисте предали свој рад.';
$string['guestnoupload'] = 'Жао нам је, али гостима није дозвољено да постављају датотеке';
$string['helpoffline'] = '<p>Овај тип задатка је користан када се ради изван Moodlea. То може бити негде друго на вебу или у учионици.</p><p>Полазници могу да виде опис задатка, али не могу да постављају датотеке или било шта друго. Оцењивање функционише потпуно нормално, и полазници ће добити обавештење о својим оценама.</p>';
$string['helponline'] = '<p>Овај тип задатка тражи од корисника да напишу текст користећи обичан едитор текста. Предавачи могу не само да оцењују задатке, онлајн, већ и да додају своје коментаре унутар самог текста или да га мењају.</p>
<p>(Уколико сте упознати са старијим верзијама Moodle система, сетићете се да овај тип задатка има исту намену коју је раније имао стари модул Журнаl (Journal).)</p>';
$string['helpupload'] = '<p>Овај тип задатка омогућава сваком полазнику да постави једну или више датотека (у било ком формату).</p> <p>То могу бити MS Word документи, слике, архивирани веб сајтови или било шта друго што сте тражили од полазника да предају као свој рад.</p>
<p>Овај тип задатка вам, такође, дозвољава  да поставите више датотека за одговоре. Датотеке за одговор могу бити постављене и пре предаје рада, што можете искористити како бисте сваком полазнику дали да ради са различитом датотеком.</p>
<p>Учесници такође могу да уносе своје белешке које описују предате датотеке, своје напредовање у раду на задатку или било какве друге текстуалне информације.</p>
<p>Полазник мора ручно да заврши предају рада за овај тип задатка. Можете погледати тренутни статус рада у било ком тренутку, при чему су незавршени задаци означени као \'Нацрт\'. Сваки неоцењени задатак можете вратити у статус нацрта.</p>';
$string['helpuploadsingle'] = '<p>Овај тип задатка омогућава сваком полазнику да постави једну датотеку (било ког типа).</p> <p>То може бити MS Word документ, слика, архивирани веб сајт или било шта друго што сте тражили од полазника да предају као свој рад.</p>';
$string['hideintro'] = 'Сакриј описа пре датума када задатак постаје доступан';
$string['hideintro_help'] = 'Ако је ова опција омогућена, опис задатка ће бити сакривен све до тренутка назначеног у подешавању "Доступно од". Студенти ће, до тада, моћи да виде само назив задатка.';
$string['invalidassignment'] = 'Неисправан задатак';
$string['invalidfileandsubmissionid'] = 'Недостаје датотека или ID предатог рада';
$string['invalidid'] = 'Неисправан ID задатка';
$string['invalidsubmissionid'] = 'Неисправан ID предатог рада';
$string['invalidtype'] = 'Неисправан тип задатка';
$string['invaliduserid'] = 'Неисправан кориснички ID';
$string['itemstocount'] = 'Број';
$string['lastgrade'] = 'Последња оцена';
$string['late'] = '{$a} касније';
$string['maximumgrade'] = 'Максимална оцена';
$string['maximumsize'] = 'Максимална величина';
$string['maxpublishstate'] = 'Најдужа доступност блог чланка пре истека рока';
$string['messageprovider:assignment_updates'] = 'Обавештења о задатку (2.2)';
$string['modulename'] = 'Задатак (2.2)';
$string['modulename_help'] = 'Модул \'Задаци\' даје могућност наставнику да одреди задатак који полазници решавају или у онлајн окружењу или ван њега. Након тога наставник може да оцени предате радoве полазника.';
$string['modulenameplural'] = 'Задаци (2.2)';
$string['newsubmissions'] = 'Задаци су предати';
$string['noassignments'] = 'Још увек нема задатака';
$string['noattempts'] = 'Нико није предао рад за овај задатак';
$string['noblogs'] = 'Немате ниједан блог чланак за предају!';
$string['nofiles'] = 'Ниједна датотека није предата';
$string['nofilesyet'] = 'Ниједна датотека још није предата';
$string['nomoresubmissions'] = 'Даља предаја радова није дозвољена';
$string['norequiregrading'] = 'Нема задатака који захтевају оцењивање';
$string['nosubmisson'] = 'Nijedan zadatak nije predat';
$string['notavailableyet'] = 'Жао нам је, али овај задатак још није доступан.<br />Упутства за задатак ће бити приказана на овом месту од доле наведеног датума.';
$string['notes'] = 'Белешке';
$string['notesempty'] = 'Нема уноса';
$string['notesupdateerror'] = 'Грешка при ажурирању белешки';
$string['notgradedyet'] = 'Још није оцењено';
$string['notsubmittedyet'] = 'Још није предато';
$string['onceassignmentsent'] = 'Једном када предате рад на оцењивање, више нећете моћи да бришете или додајете датотеке. Да ли желите да наставите?';
$string['operation'] = 'Операција';
$string['optionalsettings'] = 'Опциона подешавања';
$string['overwritewarning'] = 'Упозорење: поновно постављање ће ЗАМЕНИТИ ваш претходно предати рад';
$string['page-mod-assignment-submissions'] = 'Страница модула \'Задатак\' за предају рада';
$string['page-mod-assignment-view'] = 'Главна страница модула \'Задатак\'';
$string['page-mod-assignment-x'] = 'Било која страница модула \'Задатак\'';
$string['pagesize'] = 'Број предатих радова по страници';
$string['pluginadministration'] = 'Администрација задатака';
$string['pluginname'] = 'Задатак (2.2)';
$string['popupinnewwindow'] = 'Отвори у искачућем прозору';
$string['preventlate'] = 'Спречи кашњење';
$string['quickgrade'] = 'Дозволи брзо оцењивање';
$string['quickgrade_help'] = 'Ако је укључена ова опција за брзо оцењивање, предавач може да оцени више радова на једној страници. Додајете оцене и коментаре, а затим кликните на дугме "Сачувај све моје повратне информације" како бисте сачували све промене на тој страници.';
$string['requiregrading'] = 'Захтева оцењивање';
$string['responsefiles'] = 'Датотеке са одговорима';
$string['reviewed'] = 'Прегледано';
$string['saveallfeedback'] = 'Сачувај све моје повратне информације';
$string['selectblog'] = 'Одаберите блог чланак који желите да предате';
$string['sendformarking'] = 'Пошаљи на оцењивање';
$string['showrecentsubmissions'] = 'Прикажи скоро предате радове';
$string['submission'] = 'Предати рад';
$string['submissiondraft'] = 'Нацрт рада';
$string['submissionfeedback'] = 'Повратне информације о раду';
$string['submissions'] = 'Предати радови';
$string['submissionsaved'] = 'Ваше промене су сачуване';
$string['submissionsnotgraded'] = 'Број неоцењених радова: {$a}';
$string['submitassignment'] = 'Предајте свој рад користећи овај образац';
$string['submitedformarking'] = 'Рад је већ предат на оцењивање и не може бити ажуриран';
$string['submitformarking'] = 'Финална предаја рада на оцењивање';
$string['submitted'] = 'Предато';
$string['submittedfiles'] = 'Предате датотеке';
$string['subplugintype_assignment'] = 'Тип задатка';
$string['subplugintype_assignment_plural'] = 'Типови задатака';
$string['trackdrafts'] = 'Укључи дугме "Пошаљи на оцењивање"';
$string['trackdrafts_help'] = 'Дугме "Пошаљи на оцењивање" дозвољава полазницима да јаве предавачу да су завршили рад на задатку. Предавач може изабрати да рад врати у статус нацрта (ако, на пример, послати рад захтева да се на њему додатно ради).';
$string['typeblog'] = 'Блог чланак';
$string['typeoffline'] = 'Активност ван мреже (Offlinе)';
$string['typeonline'] = 'Онлајн текст';
$string['typeupload'] = 'Напредно постављање датотека';
$string['typeuploadsingle'] = 'Постављање датотеке';
$string['unfinalize'] = 'Врати на статус нацрта';
$string['unfinalizeerror'] = 'Дошло је до грешке и тај рад ноје могуће вратити на верзију нацрта';
$string['unfinalize_help'] = 'Враћање у статус нацрта омогућава полазнику да даље ажурира свој рад';
$string['unsupportedsubplugin'] = 'Тип задатка \'{$a}\' тренутно није подржан. Можете сачекати док не постане расположив или обрисати задатак.';
$string['upgradenotification'] = 'Ова активност се заснива на старијој верзији модула \'Задатак\'';
$string['uploadafile'] = 'Постави датотеку';
$string['uploadbadname'] = 'Назив ове датотеке садржи недозвољене знакове, па она није могла бити постављена.';
$string['uploadedfiles'] = 'постављене датотеке';
$string['uploaderror'] = 'Дошло је до грешке приликом покушаја да се  датотеке сачува на серверу';
$string['uploadfailnoupdate'] = 'Датотеке је  успешно постављена, али није било могуће заменити ваш претходно предати рад!';
$string['uploadfiles'] = 'Постави датотеке';
$string['uploadfiletoobig'] = 'Жао нам је, али ова датотека је превелика (дозвољена величина датотеке је {$a} бајта)';
$string['uploadnofilefound'] = 'Датотека није пронађена - да ли сте сигурни да сте изабрали датотеку за постављање?';
$string['uploadnotregistered'] = 'Датотеке \'{$a}\' је успешно постављена, али рад није регистрован!';
$string['uploadsuccess'] = 'Датотеке \'{$a}\' је успешно постављена';
$string['usermisconf'] = 'Корисник није исправно подешен';
$string['usernosubmit'] = 'Нажалост, није вам дозвољено да предате рад';
$string['viewassignmentupgradetool'] = 'Погледајте алатку за надоградњу модула \'Задатак\'';
$string['viewfeedback'] = 'Погледајте оцене и повратне информације';
$string['viewmysubmission'] = 'Погледај мој рад';
$string['viewsubmissions'] = 'Погледај {$a} предат(а)/предатих рад(а)/ова';
$string['yoursubmission'] = 'Ваш предати рад';
