<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'scheduler', language 'he', branch 'MOODLE_26_STABLE'
 *
 * @package   scheduler
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'פעילות';
$string['addappointment'] = 'Add another student';
$string['addondays'] = 'הוספת פגישה ב';
$string['addscheduled'] = 'הוספת פגישה שנקבעה';
$string['addscheduled_help'] = '<h3>Adding an appointment on slot setup</h3>
<p>Using this link, you will add a user to the appointment list defined by this slot information. It may be a simple and fast way to setup a collective appointment. </p>';
$string['addsession'] = 'הוספת מפגשים';
$string['addsingleslot'] = 'הוספת חלון מפגש אחד';
$string['addslot'] = 'ניתן להוסיף חלונות מפגש חדשים בכל שלב.';
$string['addstudenttogroup'] = 'הוספת סטודנט זה לקבוצת נוכחות';
$string['allappointments'] = 'כל המפגשים';
$string['allowgroup'] = 'מפגש בלעדי - לחצו כדי לשנות';
$string['allslotsincloseddays'] = 'כל המפגשים היו בימים מלאים';
$string['allteachersgrading'] = 'כאשר מאופשר, מורים יכולים להעניק ציון למפגשים שהם אינם מיועדים אליהם.';
$string['allteachersgrading_desc'] = 'When enabled, teachers can grade appointmenents they are not assigned to.';
$string['alreadyappointed'] = 'Cannot make the appointment. The slot is already fully booked.';
$string['appointagroup'] = 'מפגש קבוצתי';
$string['appointagroup_help'] = 'Choose whether you want to make the appointment only for yourself, or for an entire group.';
$string['appointfor'] = 'מיועד עבור';
$string['appointformygroup'] = 'קביעת פגישה לכל הקבוצה שלי';
$string['appointingstudent'] = 'פגישה לחלון';
$string['appointingstudentinnew'] = 'פגישה לחלון חדש';
$string['appointmentmode'] = 'Setting the appointment mode';
$string['appointmentmode_help'] = '<p>You may choose here some variants in the way appointments can be taken. </p>
<p><ul>
<li><b>"One single appointment" mode:</b> The student can only have a single appointment in this module. Once it has been seen by the teacher, he will not be allowed to apply for any further meeting. The only way to reset ability of a student to apply is to delete the old "seen" records.</li>
<li><b>"One at a time" mode:</b> The student can apply only to one (future) date. Once the meeting is over and concluded, he can appoint back. this mode is usefull to arbitrate project appointments on long run projects, specially when multiple phases of appointements are to be offered.
</li>
</ul>
</p>';
$string['appointmentno'] = 'Appointment {$a}';
$string['appointmentnotes'] = 'הערות מהמפגש';
$string['appointments'] = 'מפגשים';
$string['appointsolo'] = 'אני בלבד';
$string['appointsomeone'] = 'הוספת פגישה חדשה';
$string['attendable'] = 'יכולים להיות נוכחים בפגישה';
$string['attendablelbl'] = 'סהכ מועמדים להיות נוכחים בפגישה';
$string['attended'] = 'נכחו בפגישה';
$string['attendedlbl'] = 'כמות סטודנטים שנכחו';
$string['attendedslots'] = 'חלונות מפגש נוכחות';
$string['availableslots'] = 'חלונות מפגש זמינים';
$string['availableslotsall'] = 'כל חלונות המפגשים';
$string['availableslotsnotowned'] = 'לא משויך';
$string['availableslotsowned'] = 'משויך';
$string['bookwithteacher'] = 'נוכח';
$string['bookwithteacher_help'] = 'Choose a teacher for the appointment.';
$string['break'] = 'Break between slots';
$string['breaknotnegative'] = 'Length of the break must not be negative';
$string['cancelledbystudent'] = '{$a} : פגישה בוטלה או שונתה ע"י סטודנט';
$string['cancelledbyteacher'] = '{$a} : פגישה בוטלה ע"י המורה';
$string['choice'] = 'בחירה';
$string['chooseexisting'] = 'בחרו מפגש מהרשימה';
$string['choosingslotstart'] = 'Choosing the start time';
$string['choosingslotstart_help'] = 'Change (or choose) the appointement start time. If this appointement collides with some other slots, you\'ll be asked
if this slot replaces all conflicting appointements. Note that the new slot parameters will override all previous
settings.';
$string['comments'] = 'הערות';
$string['complete'] = 'רשום';
$string['composeemail'] = 'יצירת דואר:';
$string['confirmdelete'] = 'המחיקה היא סופית. להמשיך בכל זאת?';
$string['conflictingslots'] = 'מתנגש';
$string['course'] = 'מרחב לימוד';
$string['csvencoding'] = 'קידוד קובץ מלל';
$string['csvfieldseparator'] = 'מפריד שדות עבור csv';
$string['csvparms'] = 'פרמטרים של תבנית csv';
$string['csvrecordseparator'] = 'מפריד דוחות עבור csv';
$string['cumulatedduration'] = 'סיכומי משך זמן של פגישות';
$string['date'] = 'תאריך';
$string['datelist'] = 'מבוא';
$string['defaultslotduration'] = 'זמן מפגש בסיסי';
$string['defaultslotduration_help'] = 'The default length (in minutes) for appointment slots that you set up';
$string['deleteallslots'] = 'מחיקת כל חלונות המפגש';
$string['deleteallunusedslots'] = 'מחיקת כל חלונות המפגש הפנויים';
$string['deletemyslots'] = 'מחיקת חלונות המפגש שלי';
$string['deleteselection'] = 'מחיקת חלונות מפגש מסומנים';
$string['deletetheseslots'] = 'מחיקת חלונות אלו';
$string['deleteunusedslots'] = 'מחיקת חלונות מפגש לא פנויים שלי';
$string['department'] = 'מהיכן?';
$string['disengage'] = 'ביטול פגישות שלי';
$string['displayfrom'] = 'הצגת מפגש זה לסטודנטים מתאריך';
$string['distributetoslot'] = 'שיתוף עם הקבוצה כולה';
$string['divide'] = 'חלוקה לחלונות מפגש?';
$string['dontforgetsaveadvice'] = 'שיניתם את הרשימה של הסטודנטים שנקבעה להם פגישה. אל תשכחו לשמור טופס זה כדי לבצע את השינויים באופן מוחלט.';
$string['downloadexcel'] = 'ייצוא לגליון אלקטרוני (אקסל)';
$string['downloads'] = 'ייצוא';
$string['duration'] = 'משך זמן';
$string['durationrange'] = 'Slot duration must be between {$a->min} and {$a->max} minutes.';
$string['email_applied_html'] = '<p>An appointment has been applied for on {$a->date} at {$a->time},<br/>
by the student <a href="{$a->attendee_url}">{$a->attendee}</a> for the course:

<p>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></p>

<p>using the scheduler titled "<i>{$a->module}</i>" on the website: <a href="{$a->site_url}">{$a->site}</a>.</p>';
$string['email_applied_plain'] = 'An appointment has been applied for on {$a->date} at {$a->time},
by the student {$a->attendee} for the course:

{$a->course_short}: {$a->course}

using the scheduler titled "{$a->module}" on the website: {$a->site}.';
$string['email_applied_subject'] = '{$a->course_short}: New appointment';
$string['email_cancelled_html'] = '<p>Your appointment on <b>{$a->date}</b> at <b>{$a->time}</b>,<br/>
with the student <b><a href="{$a->attendee_url}">{$a->attendee}</a></b> for course :</p>

<p><b>{$a->course_short} : <a href="{$a->course_url}">{$a->course}</a></b></p>

<p>in the scheduler titled "<i>{$a->module}</i>" on the website : <b><a href="{$a->site_url}">{$a->site}</a></b></p>

<p><b><span style="color: red">has been cancelled or moved</span></b>.</p>';
$string['email_cancelled_plain'] = 'Your appointment on  {$a->date} at {$a->time},
with the student {$a->attendee} for course:

{$a->course_short} : {$a->course}

in the scheduler titled "{$a->module}" on the website : {$a->site}

has been cancelled or moved.';
$string['email_cancelled_subject'] = '{$a->course_short}: Appointment cancelled or moved by a student';
$string['emailreminder'] = 'דואר תזכורת';
$string['email_reminder_html'] = '<p>You have an upcoming appointment on <b>{$a->date}</b>
from <b>{$a->time}</b> to <b>{$a->endtime}</b><br/>
with <b><a href="{$a->attendant_url}">{$a->attendant}</a></b>.</p>

<p>Location: <b>{$a->location}</b></p>';
$string['email_reminder_plain'] = 'You have an upcoming appointment
on {$a->date} from {$a->time} to {$a->endtime}
with {$a->attendant}.

Location: {$a->location}';
$string['email_reminder_subject'] = '{$a->course_short}: Appointment reminder';
$string['email_teachercancelled_html'] = '<p>Your appointment on <b>{$a->date}</b> at <b>{$a->time} </b>,<br/>
with the {$a->staffrole} <b><a href="{$a->attendant_url}">{$a->attendant}</a></b> for course:</p>

<p><b>{$a->course_short}: <a href="{$a->course_url}">{$a->course}</a></b></p>

<p>in the scheduler "<i>{$a->module}</i>" on the website: <b><a href="{$a->site_url}">{$a->site}</a></b></p>

<p><b><span style="color : red">has been cancelled</span></b>. Please apply for a new slot.</p>';
$string['email_teachercancelled_plain'] = 'Your appointment on {$a->date} at {$a->time},
with the {$a->staffrole} {$a->attendant} for course:

{$a->course_short}: {$a->course}

in the scheduler titled "{$a->module}" on the website: {$a->site}

has been cancelled. Please apply for a new slot.';
$string['email_teachercancelled_subject'] = '{$a->course_short}: Appointment cancelled by the teacher';
$string['end'] = 'סיום';
$string['enddate'] = 'חזרה על אותו חלון זמן';
$string['endtime'] = 'זמן סיום';
$string['exclusive'] = 'בלעדי';
$string['exclusivity'] = 'Exclusivity';
$string['exclusivity_help'] = '<p>You can set a limit on the amount of students that can apply for a given slot. </p>
<p>Setting a limit of 1 (default) will toggle the slot in exclusive mode.</p>
<p>If the slot is set to unlimited number (0), this slot will never be considered in constraints evaluation, even if other slots are exclusive or limited in the same time range.
</p>';
$string['exclusivitylockedto'] = 'אינכם יכולים לשנות את מצב החלון כאשר קובעים פגישה. המגבלה הנוכחית של יעד החלון ייושם. אם החלון חדש, גבול ברירת מחדל של 1 ייושם';
$string['exclusivityoverload'] = '';
$string['explaingeneralconfig'] = 'אפשרויות אלה יכולות להיקבע רק ע"י הרשאה מערכתית והם ייושמו לכל מנהלי המפגשים במודל זה.';
$string['exportinstructions'] = 'מוטב לשמור את קובץ הייצוא שהופק על הכונן הקשיח לפני שאתם משתמשים בו.';
$string['finalgrade'] = 'ציון סופי';
$string['firstslotavailable'] = 'חלון זמן ראשון יפתח ב-';
$string['for'] = 'עבור';
$string['forbidgroup'] = 'חלון קבוצה - לחצו לשינוי';
$string['forcewhenoverlap'] = 'אלץ כאשר יש חפיפה';
$string['forcewhenoverlap_help'] = '<p>This control allows forcing the addition of slots when the session conflicts with other slots.
In that case, only "clean" slots will be added. Conflicting will be ignored.</p>

<p>If not used, the addition procedure will block when overlapping are detected, and you will asked for
deleting previous slots before the procedure can add new slots.</p>';
$string['forcourses'] = 'בחרו סטודנטים בקורסים';
$string['friday'] = 'שישי';
$string['generalconfig'] = 'תצורה כללית';
$string['grade'] = 'Grade';
$string['gradingstrategy'] = 'אופן חישוב ציונים';
$string['gradingstrategy_help'] = 'In a scheduler where students can have several appointments, select how grades are aggregated.
    The gradebook can show either <ul><li>the mean grade or</li><li>the maximum grade</li></ul> that the student has achieved.';
$string['group'] = 'קבוצה';
$string['groupbreakdown'] = 'על פי גודל הקבוצה';
$string['groupscheduling'] = 'Enable group scheduling';
$string['groupscheduling_desc'] = 'Allow entire groups to be scheduled at once.
(Apart from the global option, the activity group mode must be set to "Visible groups" or "Separate groups" in order to enable this feature.)';
$string['groupsession'] = 'מפגש קבוצתי';
$string['groupsize'] = 'גודל הקבוצה';
$string['guestscantdoanything'] = 'לאורחים אין כאן הרשאה לבצע שום שינוי';
$string['howtoaddstudents'] = 'For adding students to a global scoped scheduler, use the role setting for the module.<br/>You may also use module role definitions to define the attenders of your students.';
$string['ignoreconflicts'] = 'Ignore scheduling conflicts';
$string['ignoreconflicts_help'] = 'If this box is ticked, then the slot will be moved to the requested date and time, even if other slots exist at the same time. This may lead to overlapping appointments for some teachers or students, and should therefore be used with care.';
$string['incourse'] = 'בתוך הקורס';
$string['introduction'] = 'Introduction';
$string['invitation'] = 'הזמנה';
$string['invitationtext'] = 'אנא בחרו חלון זמן לפגישה ב';
$string['isnonexclusive'] = 'אינו בלעדי';
$string['lengthbreakdown'] = 'על פי משך זמן המפגש';
$string['limited'] = 'מוגבל ({$a} נותר)';
$string['location'] = 'מיקום';
$string['location_help'] = 'Specify the scheduled location of the meeting.';
$string['markasseennow'] = 'Mark as seen now';
$string['markseen'] = 'לאחר מפגש עם סטודנטים מסויימים אנא סמנו אותם כמפגשים שהתקיימו על ידי בחירת הסטודנטים ואישור קיום המפגש.';
$string['maxgrade'] = 'הציון הגובה ביותר';
$string['maxstudentlistsize'] = 'Maximum length of student list';
$string['maxstudentlistsize_desc'] = 'The maximum length of the list of students who need to make an appointment, as shown in the teacher view of the scheduler. If there are more students than this, no list will be displayed.';
$string['maxstudentsperslot'] = 'Maximum number of students per slot';
$string['maxstudentsperslot_desc'] = 'Group slots / non-exclusive slots can have at most this number of students. Note that in addition, the setting "unlimited" can always be chosen for a slot.';
$string['meangrade'] = 'Take the mean grade';
$string['meetingwith'] = 'מפגש עם';
$string['meetingwithplural'] = 'מפגש עם';
$string['mins'] = 'דקות';
$string['minutes'] = 'דקות';
$string['minutesperslot'] = 'דקות במפגש';
$string['missingstudents'] = '{$a} סטודנטים שעדיין צריכים לקבוע מפגש';
$string['missingstudentsmany'] = '{$a} students still need to make an appointment. No list is being displayed due to size.';
$string['mode'] = 'מצב';
$string['modulename'] = 'לוח מפגשים';
$string['modulename_help'] = 'The scheduler activity helps you in scheduling appointments with your students.

Teachers specify time slots for meetings, students then choose one of them on Moodle.
Teachers in turn can record the outcome of the meeting - and optionally a grade - within the scheduler.

Group scheduling is supported; that is, each time slot can accomodate several students, and optionally it is possible to schedule appointments for entire groups at the same time.';
$string['modulename_link'] = 'mod/scheduler/view';
$string['modulenameplural'] = 'לוחות מפגשים';
$string['monday'] = 'שני';
$string['move'] = 'העברה';
$string['moveslot'] = 'העברת מפגש';
$string['multiplestudents'] = 'אפשרות למספר סטודנטים במפגש?';
$string['myappointments'] = 'הפגישות שלי';
$string['name'] = 'שם לוח המפגשים';
$string['needteachers'] = 'Slots cannot be added as this course has no teachers';
$string['negativerange'] = 'הטווח הינו שלילי. זה לא יכול להיות!';
$string['never'] = 'מעולם לא';
$string['newappointment'] = '{$a} פגישה חדשה:';
$string['noappointments'] = 'אין פגישות';
$string['noexistingstudents'] = 'No existing students';
$string['nogroups'] = 'אין קבוצה זמינה לקביעת מפגש';
$string['noresults'] = 'אין תוצאות.';
$string['noschedulers'] = 'לא קיימים לוחות מפגש';
$string['noslots'] = 'אין מקום פנוי בפגישה. אנא צרו קשר עם המורה שלכם דרך המייל כדי לקבוע פגישה.';
$string['noslotsavailable'] = 'אין צורך לקבוע פגישה, או שכל הפגישות שנקבעו בוצעו.';
$string['noslotsopennow'] = 'אין מפגשים פתוחים בשלב זה.';
$string['nostudents'] = 'לא נבחרו סטודנטים';
$string['nostudenttobook'] = 'אין סטודנטים לרישום';
$string['note'] = 'ציון';
$string['noteacherforslot'] = 'אין מורים זמינים עבור המפגשים';
$string['noteachershere'] = 'אין מורים זמינים';
$string['notes'] = 'הערות';
$string['notifications'] = 'תזכורות';
$string['notifications_help'] = 'When this option is enabled, teachers and students will receive notifications when appointments are applied for or cancelled.';
$string['notselected'] = 'עדיין לא בחרתם';
$string['now'] = 'עכשיו';
$string['occurrences'] = 'חזרות';
$string['on'] = 'פעיל';
$string['oneappointmentonly'] = 'סטודנטים יכולים להירשם לפגישה אחת';
$string['oneatatime'] = 'סטודנטים יכולים להירשם לפגישה אחת כל פעם';
$string['onedaybefore'] = 'יום אחד לפני המפגש';
$string['oneslotadded'] = 'מפגש אחד נוסף';
$string['oneweekbefore'] = 'שבוע אחד לפני המפגש';
$string['onthemorningofappointment'] = 'בבוקר המפגש';
$string['overall'] = 'בכללי';
$string['overlappings'] = 'מספר מפגשים מתנגשים';
$string['pluginadministration'] = 'Scheduler administration';
$string['pluginname'] = 'Scheduler';
$string['registeredlbl'] = 'סטודנט שנקבעה לו פגישה';
$string['reminder'] = 'תזכורת';
$string['remindertext'] = 'שבת זו הינה תזכורת לכך שטרם הגדרתם את הפגישה. אנא בחרו בהקדם חלון זמן ב';
$string['remindtitle'] = '{$a}: Appointment reminder';
$string['remindwhere'] = 'מיקום המפגש:';
$string['remindwithwhom'] = 'פגישה נקבעה עם';
$string['return'] = 'בחזרה לקורס';
$string['reuse'] = 'שימוש חוזר במפגש זה';
$string['reuseguardtime'] = 'זמן שמור לשימוש חוזר במפגש';
$string['reuseguardtime_help'] = '<p>This parameter sets up the guard time for keeping volatile slots.</p>
<p>When a slot is declared as volatile (not reusable), it will be automatically deleted when a student changes is appointment assignation, feeing completely the slot, or when a teacher revokes all appointments on it. The deletion takes place when the slot starts too close to the actual date.</p>
<p>The parameter specifies the delay, from "now on", under which a freed slot will be deleted and will not be available for further appointments.</p>';
$string['reuse_help'] = 'A <i>reuseable</i> slot will remain in the scheduler even a student or the teacher revokes an appointment. The freed slot is available again for appointing.</p>

<p>A <i>volatile</i> slot will be automatically deleted in the above cases if it has to start to close to the current dat (it is considered you may not want to add a constraint so close to "right now"). The guard delay can be set by the instance-scoped configuration parameter "Reuse guard time".
</p>';
$string['revoke'] = 'ביטול הפגישה';
$string['saturday'] = 'שבת';
$string['save'] = 'שמירה';
$string['savechoice'] = 'שמור את בחירתי';
$string['savecomment'] = 'שמור את ההערות';
$string['saveseen'] = 'אישור מפגשים שהתקיימו';
$string['schedule'] = 'מפגש';
$string['scheduleappointment'] = 'קביעת פגישה עבור {$a}';
$string['schedulecancelled'] = '{$a} : המפגש נדחה או הועבר';
$string['schedulegroups'] = 'קביעת פגישה לפי קבוצה';
$string['scheduleinnew'] = 'Schedule in a new slot';
$string['scheduler'] = 'מנהל מפגשים';
$string['scheduler:addinstance'] = 'Add a new scheduler';
$string['scheduler:appoint'] = 'Appoint';
$string['scheduler:attend'] = 'Attend students';
$string['scheduler:canscheduletootherteachers'] = 'Schedule appointments for other staff members';
$string['scheduler:canseeotherteachersbooking'] = 'See and browse other teachers booking';
$string['scheduler:disengage'] = 'Drop all appointments (students)';
$string['scheduler:manage'] = 'Manage your slots and appointments';
$string['scheduler:manageallappointments'] = 'Manage all scheduler data';
$string['scheduler:seeotherstudentsbooking'] = 'See other student booking on the slot';
$string['scheduler:seeotherstudentsresults'] = 'See other slot student\'s result';
$string['schedulestudents'] = 'קביעת מפגשים על פי שמות סטודנטים';
$string['seen'] = 'התקיים';
$string['setreused'] = 'ניתן לשימוש חוזר';
$string['setunreused'] = 'ניתן לביטול';
$string['showemailplain'] = 'Show e-mail addresses in plain text';
$string['showemailplain_desc'] = 'In the teacher\'s view of the scheduler, show the e-mail addresses of students needing an appointment in plain text, in addition to mailto: links.';
$string['slot_is_just_in_use'] = 'מצטערים, אך הפגישה בדיוק נקבעה ע"י סטודנט אחר<br>אנא נסו שוב';
$string['slots'] = 'חלונות מפגשים';
$string['slotsadded'] = '{$a} חלונות מפגשים נוספו';
$string['slottype'] = 'סוג חלון מפגש';
$string['slotupdated'] = 'חלון מפגש אחד עודכן';
$string['slotwarning'] = '<b>הזהרה: </b>הזזת חלון זמן זו לזמן הנבחר תדרוש להסיר את החלונות הבאים...';
$string['staffbreakdown'] = 'ע"י {$a}';
$string['staffmember'] = 'אחד המורים';
$string['staffrolename'] = 'תפקיד אחראי המפגש';
$string['staffrolename_help'] = 'The label for the role who attends students. This is not necessarily a "teacher".';
$string['start'] = 'התחלה';
$string['startpast'] = 'אינכם יכולים להתחיל חלון פגישה בעבר';
$string['starttime'] = 'זמן התחלה';
$string['statistics'] = 'סטטיסטיקה';
$string['strdownloadcsvgrades'] = 'ייצוא קובץ CVS של ציונים';
$string['strdownloadcsvslots'] = 'ייצוא קובץ CVS של חלונות מפגש';
$string['strdownloadexcelsingle'] = 'ייצוא קובץ Excel כיריעה אחת';
$string['strdownloadexcelteachers'] = 'ייצוא קובץ Excel ע"י {$a}';
$string['strdownloadodssingle'] = 'ייצוא קובץ OpenDoc כיריעה אחת';
$string['strdownloadodsteachers'] = 'ייצוא קובץ OpenDoc ע"י {$a}';
$string['student'] = 'סטודנט';
$string['studentbreakdown'] = 'על פי סטודנטים';
$string['studentcomments'] = 'הערות הסטודנט';
$string['studentdetails'] = 'פרטי סטודנט';
$string['studentmultiselect'] = 'Each student can be selected only once in this slot';
$string['studentnotes'] = 'הערותיך לגבי&nbsp;&nbsp;<br/> הפגישה';
$string['students'] = 'סטודנטים';
$string['sunday'] = 'ראשון';
$string['teacher'] = 'Teacher';
$string['thursday'] = 'חמישי';
$string['tuesday'] = 'שלישי';
$string['unattended'] = 'לא נכחו בפגישה';
$string['unlimited'] = 'ללא הגבלה';
$string['unregisteredlbl'] = 'סטודנטים שלא נקבעה להם פגישה';
$string['updategrades'] = 'עדכון ציונים';
$string['updatesingleslot'] = '';
$string['updatingappointment'] = 'עדכון רשמים לאחר מפגש';
$string['wednesday'] = 'רביעי';
$string['welcomebackstudent'] = 'השורה המודגשת בטבלה למטה מסמנת את זמן הפגישה שבחרתם. אתם יכולים לשנות לכל חלון זמן פנוי אחר.';
$string['welcomenewstudent'] = 'הטבלה שלמטה מראה את כל חלונות הזמן הפנויים לפגישה. סמנו ע"י לחצן הבחירה את מבוקשכם, ולאחר מכן לחצו על מקש "שמור את בחירתי". אם תצטרכו לבצע שינוי בהמשך, תוכלו לחזור לדף זה.';
$string['welcomenewteacher'] = 'אנא בחרו באחד מהכפתורים ליצירת מפגש עם סטודנטים.';
$string['what'] = 'מה?';
$string['whathappened'] = 'מה סוכם?';
$string['whatresulted'] = 'כיצד הסתיים?';
$string['when'] = 'מתי?';
$string['where'] = 'היכן?';
$string['who'] = 'עם מי?';
$string['whosthere'] = 'מי שם?';
$string['xdaysbefore'] = 'ימים לפני מפגש';
$string['xweeksbefore'] = 'שבועות לפני מפגש';
$string['yourappointmentnote'] = 'הערות לעניך בלבד';
$string['yourslotnotes'] = 'הערות על המפגש';
