<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'he', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'באפשרותך לצפות בבוחן זה בתצוגה מקדימה, אך אם היה זה ניסיון מענה אמיתי, היית נחסם מכיוון ש:';
$string['action'] = 'פעולה';
$string['activityoverview'] = 'ישנם בחנים שעליך לבצע';
$string['adaptive'] = 'מצב מסתגל ( מספר ניסיונות מענה לשאלה + רמזים)';
$string['adaptive_help'] = 'בעת הפעלה, ניתן לענות מספר תשובות על שאלה אחת, וכל זאת באותו ניסיון של פתירת השאלה המסוימת. לדוגמה, אם תשובה מסומנת כלא נכונה, התלמיד יהיה רשאי לנסות שוב באופן מיידי. עם זאת, בהתאם להגדרה המוגדרת ב- " יישום עונשים", כל ניסיון שגוי בפתירת השאלה, יחויב בעונש.';
$string['addaquestion'] = 'הוספת שאלה...';
$string['addarandomquestion'] = 'הוספת שאלה אקראית...';
$string['addarandomquestion_help'] = 'כאשר שאלה אקראית מתווספת לבוחן, מתקבל בוחן המורכב משאלה אשר נבחרת באופן אקראי מתוך אוסף שאלות המצויות בקטגוריה מסויימת.

כאשר מוסיפים לבוחן מספר שאלות אקראיות,
מתקבל בוחן בו תלמידים שונים צפויים לקבל בחירה שונה של שאלות, וכאשר בוחן מאפשר ניסיונות מרובים אז כל ניסיון עלול להכיל מבחר חדש של שאלות.';
$string['adddescriptionlabel'] = 'הוספת תיאור/תוית';
$string['addingquestion'] = 'הוספת שאלה';
$string['addingquestions'] = 'צד זה של הדף משמש לניהול מסד נתוני השאלות שלך. השאלות נשמרות בקטגוריות כדי לאפשר לך לשמור על סדר, ניתן להשתמש בהן בכל בוחן בקורס שלך ואפילו בקורסים אחרים אם תחליט "לפרסם" אותן. <br /><br />אחרי שתבחר או תיצור קטגורית שאלות תוכל ליצור או לערוך שאלות. תוכל לבחור להוסיף כל אחת משאלות אלו לבוחן שלך בצד השני של הדף.';
$string['addmoreoverallfeedbacks'] = 'הוספת  {no}  שדות משוב נוספים';
$string['addnewgroupoverride'] = 'הוספת הגדרות־מותאמות לקבוצה';
$string['addnewpagesafterselected'] = 'הוספת דפים חדשים לאחר שאלות נבחרות';
$string['addnewquestionsqbank'] = 'הוספת שאלות לקטגוריה
{$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'הוספת הגדרות־מותאמות למשתמש';
$string['addpagehere'] = 'הוספת דף';
$string['addquestion'] = 'הוספת שאלה';
$string['addquestions'] = 'הוספת שאלות';
$string['addquestionstoquiz'] = 'הוספת שאלות לבוחן הנוכחי';
$string['addrandom'] = 'הוספת {$a} שאלות אקראיות';
$string['addrandom1'] = 'הוספה >>';
$string['addrandom2'] = 'שאלות אקראיות';
$string['addrandomfromcategory'] = 'הוספת שאלות אקראיות מהקטגוריה';
$string['addrandomquestion'] = 'הוספת שאלות אקראיות (מקטגוריה)';
$string['addrandomquestiontoquiz'] = 'הוספת שאלות אקראיות לבוחן {$a}';
$string['addselectedtoquiz'] = 'הוספת הנבחרות לבוחן';
$string['addtoquiz'] = 'הוספה לבוחן';
$string['affectedstudents'] = '{$a} הושפעו';
$string['aftereachquestion'] = 'לאחר הוספת כל שאלה ';
$string['afternquestions'] = 'לאחר הוספת {$}a שאלות ';
$string['age'] = 'גיל';
$string['allattempts'] = 'כל נסיונות המענה';
$string['allinone'] = 'בלתי מוגבל';
$string['allowreview'] = 'אפשר לסקור';
$string['alreadysubmitted'] = 'נראה שכבר שלחת ניסיון מענה זה';
$string['alternativeunits'] = 'יחידות־מידה חליפיות';
$string['alwaysavailable'] = 'תמיד זמין';
$string['analysisoptions'] = 'אפשרויות ניתוח';
$string['analysistitle'] = 'טבלת ניתוח פריט';
$string['answer'] = 'תשובה';
$string['answered'] = 'נענתה';
$string['answerhowmany'] = 'תשובה אחת או תשובות מרובות?';
$string['answers'] = 'התשובה הנכונה';
$string['answersingleno'] = 'אפשר תשובות מרובות';
$string['answersingleyes'] = 'תשובה אחת בלבד';
$string['answertoolong'] = 'תשובה ארוכה מדי אחרי השורה ה-{$a} (קיימת מגבלה של 255 תווים לתשובה)';
$string['aon'] = 'תסדיר AON';
$string['areyousureremoveselected'] = 'האם אתה בטוח שברצונך לסלק את כל השאלות שנבחרו?';
$string['asshownoneditscreen'] = 'כפי שמוצג על מסך העריכה';
$string['attempt'] = 'ניסיון מענה {$a}';
$string['attemptalreadyclosed'] = 'ניסיון זה כבר הסתיים.';
$string['attemptclosed'] = 'הניסיון לא סגור עדיין.';
$string['attemptduration'] = 'משך הזמן שלקח לענות';
$string['attemptedon'] = 'נוסה ב-';
$string['attempterror'] = 'אינך ראשי לנסות בוחן זה ';
$string['attemptfirst'] = 'ניסיון מענה ראשון';
$string['attemptincomplete'] = 'ניסיון מענה זה (ע"י {$a}) עדיין לא הושלם.';
$string['attemptlast'] = 'נסיון מענה אחרון';
$string['attemptnumber'] = 'נסיון מענה';
$string['attemptquiznow'] = 'התחלת ניסיון מענה';
$string['attempts'] = 'נסיונות מענה';
$string['attemptsallowed'] = 'מספר נסיונות מותרים';
$string['attemptsdeleted'] = 'נסיונות הבוחן הוסרו';
$string['attemptselection'] = 'בחר איזה נסיונות מענה יש לנתח עבור כל משתמש:';
$string['attemptsexist'] = 'לא ניתן להוסיף או להוריד שאלות בשלב זה.';
$string['attemptsnum'] = 'ניסיונות מענה: {$a}';
$string['attemptsnumthisgroup'] = 'ניסיונות מענה: {$a->total}  ({$a->group} מקורס זה';
$string['attemptsnumyourgroups'] = 'ניסיונות מענה: {$a->total}  ({$a->group} מהקבוצות שלך';
$string['attemptsonly'] = 'הצגת התלמידים שניסו לענות על בחנים';
$string['attemptstate'] = 'מצב';
$string['attemptstillinprogress'] = 'ניסיון מענה פעיל';
$string['attemptsunlimited'] = 'אין מגבלה על מספר נסיונות המענה';
$string['autosaveperiod'] = 'משך הזמן לשמירה אוטומטית';
$string['autosaveperiod_desc'] = 'התגובות של הסטודנטים ניתנות לשמירה אוטומטית לאחר מספר דקות במהלך נסיונות המענה של הבוחן. הדבר כרוך בתחלופה: שמירת תגובותיהם  מעלה את טעינת השרת , אך מקטינה את הסיכוי שסטודנטים יאבדו את תגובותיהם.';
$string['back'] = 'חזרה לתצוגה המקדימה של השאלה.';
$string['backtocourse'] = 'בחזרה לקורס';
$string['backtoquestionlist'] = 'חזרה לרשימת השאלות';
$string['backtoquiz'] = 'חזרה לעריכת הבוחן';
$string['basicideasofquiz'] = 'עצות ליצירת בוחן';
$string['bestgrade'] = 'הציון הטוב ביותר';
$string['bothattempts'] = 'הצגת התלמידים שניסו לענות על הבוחן בנוסף לתלמידים שלא ניסו';
$string['browsersecurity'] = 'אבטחת דפדפן';
$string['browsersecurity_help'] = 'אם בחרתם ב- "מסך מלא קופץ עם JavaScript מאובטח " ,אזי..

* הבוחן יתחיל רק אם לתלמיד יש דפדפן אינטרנט של JavaScript .

* הבוחן מופיע בחלון קופץ ובמסך מלא ללא כפתורי ניווט,המסתיר את כל שאר החלונות על המסך.

* סטודנטים נמנעו ככל האפשר,
משימוש בפעולות  כמו העתק והדבק.';
$string['calculated'] = 'חישוב';
$string['calculatedquestion'] = 'שורה {$a} לא תומכת בשאלת חישוב. השאלה לא תיחשב.';
$string['cannotcreatepath'] = 'לא ניתן ליצור נתיב ({$a})';
$string['cannoteditafterattempts'] = 'לא ניתן להוסיף או להסיר שאלות מכיוון שקיימים נסיונות מענה. ({$a})';
$string['cannotfindprevattempt'] = 'אין אפשרות למצוא את הניסיון הקודם בכדי להתבסס עליו.';
$string['cannotfindquestionregard'] = 'כישלון בהשגת שאלות בכדי לתת ציון מחדש!';
$string['cannotinsert'] = 'לא ניתן  להכניס שאלה.';
$string['cannotinsertrandomquestion'] = 'אין אפשרות להוסיף שאלה אקראית!';
$string['cannotloadquestion'] = 'אין אפשרות לטעון את אפשרויות השאלה';
$string['cannotloadtypeinfo'] = 'לא ניתן לטעון את המידע הפרטי של השאלה אודות סוג השאלהאין אפשרות';
$string['cannotopen'] = 'לא ניתן לפתוח את קובץ היצוא ({$a})';
$string['cannotrestore'] = 'אין אפשרות לשחזר את ישיבות השאלה';
$string['cannotreviewopen'] = 'לא ניתן לבדוק ניסיון זה, משום שהוא עדין פתוח.';
$string['cannotsavelayout'] = 'לא ניתן לשמור את תצורת הבוחן';
$string['cannotsavenumberofquestion'] = 'אין אפשרות לשמור את מספר השאלות שיופיעו בכל עמודא';
$string['cannotsavequestion'] = 'אין אפשרות לשמור את רשימת השאלות';
$string['cannotsetgrade'] = 'אין אפשרות להגדיר ערך מירבי חדש של ציונים לבוחן ';
$string['cannotsetsumgrades'] = 'כידלון בהגדרת ציונים מסוכמים';
$string['cannotstartgradesmismatch'] = 'לא ניתן להתחיל ניסיון מענה בבוחן זה. הבוחן מוגדר להיות עם ציון מתוך {$a->grade}, אבל אף אחת מהשאלות בבוחן אינה מעניקה ציון. דניתן לתקן זאת בעמוד \'ערוך בוחן\'.';
$string['cannotstartmissingquestion'] = 'אין אפשרות להתחיל בנסיון לפתור בוחן זה, היות והגדרת החידון כוללת שאלה שאינה קיימת.';
$string['cannotstartnoquestions'] = 'אין אפשרות להתחיל בניסיון לפתור בוחן זה, היות והחידון לא הוגדר עדיין ולא נוספו לו שאלות.';
$string['cannotwrite'] = 'לא ניתן לכתוב בקובץ היצוא ({$a})';
$string['caseno'] = 'לא, אותיות רשיות אינן חשובות';
$string['casesensitive'] = 'תלוי אותיות רישיות';
$string['caseyes'] = 'כן, אותיות רשיות חייבות להתאים';
$string['categories'] = 'קטגוריות';
$string['category'] = 'קטגוריה';
$string['categoryadded'] = 'הקטגוריה \'{$a}\' התווספה';
$string['categorydeleted'] = 'הקטגוריה \'{$a}\' נמחקה';
$string['categorynoedit'] = 'אין לך הרשאות עריכה בקטגוריה \'{$a}\'.';
$string['categoryupdated'] = 'הקטגוריה עודכנה בהצלחה';
$string['close'] = 'סגור חלון';
$string['closebeforeopen'] = 'לא היה ניתן לעדכן את הבוחן. הגדרת את תאריך הסגירה לפני תאריך הפתיחה.';
$string['closed'] = 'נסגר';
$string['closepreview'] = 'סיום תצוגה־מקדימה';
$string['closereview'] = 'סיום עיון־בתשובות.';
$string['comment'] = 'הערה';
$string['commentorgrade'] = 'הזנת הערה או ניקוד עדכני';
$string['comments'] = 'הערות';
$string['completedon'] = 'הושלם ב-';
$string['configadaptive'] = 'אם תבחר \'כן \' באפשרות זו, הסטודנט יוכל  לענות מספר תגובות לשאלה אפילו באותו נסיון מענה בבוחן.';
$string['configattemptsallowed'] = 'הגבלת מספר נסיונות המענה שהסטודנט רשאי לענות בבוחן זה.';
$string['configdecimaldigits'] = 'מספר הספרות שיוצגו לאחר הנקודה העשרונית כאשר יוצגו הציונים.';
$string['configdecimalplaces'] = 'מספר הספרות שיוצגו לאחר הנקודה העשרונית כאשר יוצגו הציונים לבוחן זה.';
$string['configdecimalplacesquestion'] = 'מספר הספרות שיוצגו לאחר הנקודה העשרונית כאשר יוצגו הציונים לכל שאלה ושאלה.';
$string['configdelay1'] = 'אם תגדירו השהיית זמן, אז יהיה על התלמיד  לחכות אחר ניסיון הפתירה הראשון שלו, לפי הזמן שהוגדר, עד לניסיון הבא שלו .';
$string['configdelay1st2nd'] = 'אם תגדירו כאן השהיית זמן, אז התלמיד לא יוכל להתחיל את הניסיון הבא שלו בפתירת הבוחן לפני שעבר הזמן, שהוגדר מראש, מניסיון הפתירה הקודם שלו.';
$string['configdelay2'] = 'אם תגדירו השהיית זמן, אז יהיה על התלמיד  לחכות לפי הזמן שהוגדר, עד לניסיון השלישי שלו בפתירת הבוחן וכן הלאה בניסיונות הבאים.';
$string['configdelaylater'] = 'אם תגדירו השהיית זמן, אז התלמיד לא יוכל להתחיל את הניסיון הבא שלו בפתירת הבוחן לפני שעבר הזמן, שהוגדר מראש, מניסיון הפתירה הקודם שלו.';
$string['configeachattemptbuildsonthelast'] = 'כאשר מאופשרים נסיונות מענה מרובים, כל נסיון חדש יכלול את התוצאות של הנסיון הקודם.';
$string['configgrademethod'] = 'כאשר נסיונות מרובים מאופשרים, איזו שיטה לבחור בכדי לחשב את הציון הסופי של בוחן זה.';
$string['configintro'] = 'הערכים שהגדרתם כאן, מגדירים את ערכי ברירת המחדל המופיעים בטופס ההגדרות כאשר יוצרים בוחן חדש. ניתן גם להגדיר אילו הגדרות בחנים נחשבות כמתקדמות.';
$string['configmaximumgrade'] = 'ציון ברירת המחדל ממנו יחושב הציון שהתקבל בבוחן.';
$string['confignavmethod'] = 'במצב ניווט "חופשי", ניתן לענות על שאלות בכל סדר שיופיעו, באמצעות מנגנון הניווט. במצב ניווט "קבוע", יש להשיב על השאלות לפי סדר עוקב שבו הן מופיעות בבוחן.';
$string['confignewpageevery'] = 'בעת הוספת שאלות לדף בבוחן, אוטומטית יתווספו רווחים בהתאם להגדרה שתבחר כאן.';
$string['configoutcomesadvanced'] = 'אם הגדרה זו מאופשרת , מדדי-הערכה בטופס עריכת הבוחן  יהיו בהגדרות המתקדמות.';
$string['configpenaltyscheme'] = 'הפחתת קנס לכל תגובה שגויה במצב מסתגל.';
$string['configpopup'] = 'במהלך ניסיונות מענה לבוחן, נסו לעצור את הניסיון של פתיחת חלון קופץ, והשתמש ביכולות ה- JavaScript על מנת להגביל העתקה והדבקה, וכו.';
$string['configrequirepassword'] = 'על הסטודנטים להכניס סיסמה לפני נסיון המענה לבוחן זה.';
$string['configrequiresubnet'] = 'סטודנטים יכולים לענות על הבוחן ממחשבים אלו.';
$string['configreviewoptions'] = 'אפשרויות אלה שולטות במידע שיופיע לעיניי המשתמש בעת ניסיון מחודש של פתירת הבוחן או צפייה בדוחות הבחנים.';
$string['configshowblocks'] = 'הצגת משבצות במהלך נסיונון מענה הבוחן';
$string['configshowuserpicture'] = 'הצגת תמונות המשתמשים במסך במהלך נסיונות המענה';
$string['configshufflequestions'] = 'כאשר אפשרות זו פעילה, סדר השאלות בבוחן יהיה אקראי בכל פעם שתלמיד ינסה לפתור אותו.';
$string['configshufflewithin'] = 'כאשר אפשרות זו פעילה, התשובות המרכיבות את השאלה יעורבבו בתוך השאלה באופן אקראי בכל פעם שתלמיד יתחיל ניסיון מענה של בוחן זה.

מנגנון ערבוב התשובות יהיה זמין בתנאי שהופעל גם ברמת השאלה';
$string['configtimelimit'] = 'הגבלת זמן ברירת מחדל לבוחן בדקות. 0 - משמעותו  היא ללא הגבלת זמן';
$string['configtimelimitsec'] = 'הגבלת זמן ברירת מחדל לבוחן בשניות. 0 - משמעותו  היא ללא הגבלת זמן';
$string['configurerandomquestion'] = 'עדכון הגדרות השאלה';
$string['confirmclose'] = 'אתה עומד להגיש באופן סופי את ניסיון מענה זה. מרגע שהגשת וסיימת את ניסיון המענה לא תוכל לשנות את תשובותיך.';
$string['confirmserverdelete'] = 'האם אתה בטוח שברצונך להסיר את השרת <b>{$a}</b> מהרשימה?';
$string['confirmstartattemptlimit'] = 'הבוחן מוגבל ל-{$a} נסיונות מענה. אתה עומד להתחיל בניסיון חדש לענות על הבוחן. האם אתה מעונין להמשיך?';
$string['confirmstartattempttimelimit'] = 'לבוחן זה יש הגבלת זמן, והוא מוגבל ל-{$a} נסיונות מענה. אתה עומד להתחיל בניסיון חדש לענות על הבוחן. האם אתה מעונין להמשיך?';
$string['confirmstarttimelimit'] = 'בוחן זה מוגבל בזמן, האם אתה בטוח שאתה רוצה להתחיל?';
$string['connectionok'] = 'חיבור רשת נתונים שוחזרה. ניתן להמשיך בבטחה.';
$string['containercategorycreated'] = 'קטגוריה זו נוצרה כדי לאחסן את כל הקטגוריות המקוריות שהועברו לרמת האתר בשל הסיבות המפורטות להלן.';
$string['continueattemptquiz'] = 'המשך את נסיון המענה האחרון';
$string['continuepreview'] = 'המשך בצפיה המוקדמת האחרונה';
$string['copyingfrom'] = 'יוצר העתק של השאלה \'{$a}\'';
$string['copyingquestion'] = 'מעתיק שאלה';
$string['correct'] = 'נכון';
$string['correctanswer'] = 'תשובה נכונה';
$string['correctanswerformula'] = 'נוסחת התשובה הנכונה';
$string['correctansweris'] = 'תשובה נכונה: {$a}';
$string['correctanswerlength'] = 'מספרים בעלי חשיבות';
$string['correctanswers'] = 'תשובות נכונות';
$string['correctanswershows'] = 'תשובה נכונה מראה';
$string['corrresp'] = 'תגובה נכונה';
$string['countdown'] = 'ספירה לאחור';
$string['countdownfinished'] = 'בוחן זה עומד להסתיים, עליך להגיש את תשובותיך כעת.';
$string['countdowntenminutes'] = 'בוחן זה יסתיים בעוד עשר דקות.';
$string['coursetestmanager'] = 'תסדיר מנהל מבחני קורס.';
$string['createcategoryandaddrandomquestion'] = 'יצירת קטגוריה והוספת שאלה־אקראית';
$string['createfirst'] = 'תחילה עליך ליצור מספר שאלות מסוג תשובה־קצרה.';
$string['createmultiple'] = 'הוספת מספר שאלות אקראיות לבוחן.';
$string['createnewquestion'] = 'הוספת שאלה חדשה';
$string['createquestionandadd'] = 'יצירת שאלה חדשה והוספה לבוחן.';
$string['custom'] = 'תסדיר מותאם אישית';
$string['dataitemneed'] = 'עליך להוסיף לפחות זוג אחד של פריטי נתונים כדי לקבל שאלה תקפה.';
$string['datasetdefinitions'] = 'הגדרות למערך נתונים זמין לשימוש חוזר עבור קטגוריה {$a}.';
$string['datasetnumber'] = 'מספר';
$string['daysavailable'] = 'ימים זמינים';
$string['decimaldigits'] = 'ספרות עשרוניות בציונים';
$string['decimalplaces'] = 'מקומות עשרוניים בציונים';
$string['decimalplaces_help'] = 'הגדרה זו קובעת את מספר הספרות המוצגות לאחר הנקודה העשרונית בהצגת ציונים. ההגדרה משפיעה רק על אופן הצגת הציונים, לא על חישובים פנימיים, שמבוצעים בדיוק מלא.';
$string['decimalplacesquestion'] = 'מקומות עשרוניים בציוני השאלה';
$string['decimalplacesquestion_help'] = 'מספר הספרות שיוצגו לאחר הנקודה העשרונית כאשר יוצגו הציונים לכל שאלה בנפרד.';
$string['decimalpoints'] = 'נקודות עשרוניות';
$string['default'] = 'ברירת מחדל';
$string['defaultgrade'] = 'משקל ברירת המחדל לשאלה';
$string['defaultinfo'] = 'קטגוריית ברירת המחדל לשאלות';
$string['delay1'] = 'השהיית זמן בין ניסיון המענה הראשון לבין הניסיון השני';
$string['delay1st2nd'] = 'חייב השהיה בין הניסיון הראשון לניסיון השני';
$string['delay1st2nd_help'] = '<p align="center"><b>השהיית זמן בין ניסיון המענה הראשון לשני</b></p>

<p>אם תגדירו השהיית זמן אז על הסטודנט להמתין עד שזמן זה יחלוף לפני שהוא יוכל לנסות ולענות על הבוחן בפעם השניה.
</p>';
$string['delay2'] = 'השהיית זמן בין ניסיונות מענה מאוחרים יותר.';
$string['delaylater'] = 'חייב השהיה בין נסיונות מאוחרים';
$string['delaylater_help'] = '<p align="center"><b>השהיית זמן בין ניסיונות מענה נוספים</b></p>

<p>אם תגדירו כאן השהיית זמן, אז על הסטודנט להמתין עד שהזמן המוגדר יחלוף לפני שהוא יוכל לנסות לענות על הבוחן בפעם השלישית ובכל פעם נוספת.
</p>';
$string['deleteattemptcheck'] = 'האם אתה בטוח לחלוטין שברצונך למחוק נסיונות מענה אלו?';
$string['deleteselected'] = 'מחק את הנבחר';
$string['deletingquestionattempts'] = 'מחיקת נסיונות השאלה';
$string['description'] = 'תיאור (לא שאלה)';
$string['disabled'] = 'אינו-זמין';
$string['displayoptions'] = 'אפשרויות תצוגה';
$string['donotuseautosave'] = 'לא לבצע שמירה אוטומטית';
$string['download'] = 'יש להקליק להורדת קובץ הקטגוריות שיוצא';
$string['downloadextra'] = '(הקובץ נשמר גם בקבצי הקורס תחת הספרייה  /backupdata/quiz )';
$string['duplicateresponse'] = 'ההגשה לא התקבלה מאחר שבמועד מוקדם יותר נתת תגובה זהה.';
$string['eachattemptbuildsonthelast'] = 'כל ניסיון מענה מתבסס על קודמו';
$string['eachattemptbuildsonthelast_help'] = '<p align="center"><b>כל ניסיון מענה נבנה על הקודם</b></p>

<p>אם מאופשרים ניסיונות מענה מרובים והגדרה זו נקבעת כ-<b>כן</b>, אז כל ניסיון מענה חדש יכיל את התוצאות של הניסיון הקודם, מה שמאפשר להשלים את הבוחן על פני מספר ניסיונות מענה (ולא ב"מכה אחת").

<p>כדי להציג בוחן חדש בכל ניסיון מענה, בחרו <b>לא</b> עבור הגדרה זו.</p>';
$string['editcategories'] = 'עריכת קטגוריות';
$string['editcategory'] = 'עריכת קטגוריה';
$string['editcatquestions'] = 'עריכת שאלות בקטגוריות';
$string['editingquestion'] = 'עריכת שאלה';
$string['editingquiz'] = 'עריכת השאלות בבוחן';
$string['editingquiz_help'] = 'בעת יצירת בוחן, הרעיונות העיקריים החשובים הם:

* בוחן שיכיל שאלות על דף אחד או יותר.

* בנק השאלות שמאחסן עותקים של כל השאלות, רצוי שיהיה מאורגן לפי קטגוריות.

* שאלות אקראיות - כל תלמיד מקבל שאלות שונות בכל פעם שהוא מנסה לפתור את הבוחן .';
$string['editingquizx'] = 'עריכת השאלות בבוחן {$a}';
$string['editoverride'] = 'ניהול הגדרות־מותאמות';
$string['editqcats'] = 'עריכת קטגוריות של שאלות';
$string['editquestions'] = 'עריכת שאלות';
$string['editquiz'] = 'עריכת השאלות בבוחן';
$string['editquizquestions'] = 'עריכת שאלות הבוחן';
$string['emailconfirmbody'] = '{$a->username}, היקר,
תודה על ששלחת את התשובות ל:
\'{$a->quizname}\'
בקורס \'{$a->coursename}\'
ב: {$a->submissiontime}

הודעה זו מאשרת כי קיבלנו את התשובות בהצלחה.
ניתן לגשת לבוחן כאן  {$a->quizurl}.';
$string['emailconfirmsmall'] = 'תודה לך על הגשת התשובות לבוחן \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'אישור שליחת ההבוחן: {$a->quizname}';
$string['emailnotifybody'] = '{$a->username} היקר,

{$a->studentname} סיים את {$a->quizname} ב: {$a->quizurl} בקורס {$a->coursename}

ניתן להתבונן שוב בנסיון המענה כאן {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} השלים את הבוחן
{$a->quizname}.
ראו See {$a->quizreviewurl}';
$string['emailnotifysubject'] = 'סטודנט {$a->studentname} סיים את הבוחן
{$a->quizname}';
$string['emailoverduebody'] = '{$a->studentname}  היקר,

התחלת את נסיון המענה \'{$a->quizname}\' בקורס  \'{$a->coursename}\', אך לא הגשת את התשובות עדיין.
היה עליך להגיש עד {$a->attemptduedate}.
אם עדיין תרצה להגיש את התשובות של הבוחן, אנא גש ל {$a->attemptsummaryurl} והקליק על כפתור "הגש". עליך לעשות זאת לפני {$a->attemptgraceend} אחרת נסיון המענה שלך לא ייחשב בציון.';
$string['emailoverduesmall'] = 'לא הגשת את נסיון המענה בבוחן  {$a->quizname}. אנא גש ל- {$a->attemptsummaryurl}  לפני
{$a->attemptgraceend} אם תרצה עדיין להגיש.';
$string['emailoverduesubject'] = 'איחור בנסיון מענה על בוחן "{$a->quizname}"';
$string['empty'] = 'ריק';
$string['enabled'] = 'מאופשר';
$string['endtest'] = 'סיום הבוחן...';
$string['erroraccessingreport'] = 'אתה לא יכול לגשת לדוח זה';
$string['errorinquestion'] = 'שגיאה בשאלה';
$string['errormissingquestion'] = 'שגיאה: השאלה בעלת מספר הזיהוי: {$a}, חסרה במערכת.';
$string['errornotnumbers'] = 'שגיאה - התשובות צריכות להיות מספריות';
$string['errorunexpectedevent'] = 'אירוע קוד לא תפוי {$a->event} נמצא בשאלה {$a->questionid} בניסיון מענה {$a->attemptid}.';
$string['essay'] = 'מאמר (שאלה פתוחה ארוכה)';
$string['essayquestions'] = 'שאלות';
$string['eventquizattemptabandoned'] = 'ניסיון המענה על הבוחן הופסק';
$string['eventquizattemptstarted'] = 'ניסיון המענה על הבוחן החל';
$string['eventquizattemptsubmitted'] = 'ניסיון המענה על הבוחן הוגש';
$string['eventquizattempttimelimitexceeded'] = 'ניסיון הבוחן חרג ממגבלת הזמן';
$string['everynquestions'] = 'כל {$a} שאלות';
$string['everyquestion'] = 'כל שאלה';
$string['everythingon'] = 'הכל על';
$string['export'] = 'יצוא';
$string['exportcategory'] = 'ייצא קטגוריה';
$string['exporterror'] = 'חלה שגיאה במהלך עיבוד היצוא ';
$string['exportingquestions'] = 'שאלות מיוצאות לקובץ';
$string['exportname'] = 'שם קובץ';
$string['exportquestions'] = 'יצוא שאלות לקובץ';
$string['extraattemptrestrictions'] = 'הגבלות נוספות על נסיונות המענה';
$string['false'] = 'לא נכון';
$string['feedback'] = 'משוב';
$string['feedbackerrorboundaryformat'] = 'על גבולות ציון המשוב חובה להיות או אחוז או מספר. הערך שהכנסת בגבול {$a} לא מזוהה.';
$string['feedbackerrorboundaryoutofrange'] = 'על גבולות ציון המשוב חובה להיות בין 0% ל-100%. הערך שהכנסת בגבול {$a} נמצא מחוץ לתחום.';
$string['feedbackerrorjunkinboundary'] = 'עליך למלא את קופסאות גבול ציון המשוב מבלי להשאיר רווחים.';
$string['feedbackerrorjunkinfeedback'] = 'עליך למלא את קופסאות המשוב מבלי להשאיר רווחים.';
$string['feedbackerrororder'] = 'על גבולות ציוני המשוב חובה להופיע לפי סדר, כאשר הגבוה ביותר מופיע ראשון. הערך שהכנסת בגבול {$a} נמצא מחוץ לרצף.';
$string['file'] = 'קובץ';
$string['fileformat'] = 'תסדיר הקובץ';
$string['fillcorrect'] = 'מלא עם הנכון';
$string['filloutnumericalanswer'] = 'עליך לספק לפחות תשובה אפשרית אחת ומרווח סבילות. התשובה המתאימה הראשונה תשמש כדי לקבוע את התוצאה והמשוב. אם בסוף תספק משוב כלשהוא ללא תשובה, משוב זה יוצג לתלמידים שתשובתם לא תואמת אף אחת מהתשובות האפשריות.';
$string['filloutoneanswer'] = 'עליך לספק לפחות תשובה אפשרית אחת. תשובות ריקות לא ייחשבו. ניתן להשתמש ב-* כתו-כללי שיתאים לכל תו שהוא. התשובה התואמת הראשונה תשמש לקביעת התוצאה והמשוב.';
$string['filloutthreequestions'] = 'עליך לספק לפחות שלוש שאלות בעלות תשובות תואמות. באפשרותך לספק בנוסף לאלו תשובות שגויות על ידי נתינת תשובה שהשאלה שלה ריקה. ערכים בהם גם השאלה וגם התשובה ריקות לא ייחשבו.';
$string['fillouttwochoices'] = 'עליך למלא לפחות שתי בחירות. בחירות שיושארו ריקות לא ייחשבו.';
$string['finishattemptdots'] = 'סיום נסיון מענה...';
$string['finishreview'] = 'סיום שלב צפייה במשוב';
$string['forceregeneration'] = 'כפה התחדשות';
$string['formatnotfound'] = 'לא נמצא תסדיר יבוא - יצוא  {$a}';
$string['formatnotimplemented'] = 'תסדיר זה לא יושם נכונה, אנא פרסם דוח באגים (שגיאות).';
$string['formulaerror'] = 'שגיאות בנוסחה!';
$string['fractionsaddwrong'] = 'המשקלים החיוביים בהם בחרת לא מסתכמים ל-100%<br />במקום זאת, הם מסתכמים ל-{$a}%<br />האם ברצונך לחזור ולתקן שאלה זו?';
$string['fractionsnomax'] = 'אחת מהתשובות צריכה להעניק 100% כדי שאפשר יהיה <br />לקבל את הציון המירבי עבור שאלה זו.<br />האם ברצונך לחזור ולתקן שאלה זו?';
$string['fromfile'] = 'מקובץ:';
$string['functiondisabledbysecuremode'] = 'יכולת זו אינה זמינה כרגע';
$string['generalfeedback'] = 'הסבר המורה לתשובה (משוב כללי)';
$string['generalfeedback_help'] = '<p align="center"><b>משוב כללי לשאלות</b></p>

<p>משוב כללי לשאלות הוא למעשה קטע טקסט כלשהוא שמוצג בפני סטודנט לאחר שהוא ניסה לענות על שאלה. שלא כמו המשוב שתלוי בסוג השאלה ובתשובה שהסטודנט נתן, אותו המשוב הכללי מוצג בפני כל הסטודנטים.
</p>

<p>בידכם האפשרות לשלוט בעיתוי שבו המשוב הכללי מוצג לסטודנטים באמצעות קופסאות הסימון של "סטודנטים יכולים לעיין בתשובות" שנמצאות בטופס העריכה של הבוחן.
</p>

<p>אתם יכולים להשתמש במשוב הכללי כדי לתת לסטודנטים רקע כלשהוא בנוגע למה שהשאלה בדקה.
או כדי לספק להם קישור למידע נוסף בו הם יכולים להשתמש במידה והם לא הבינו את השאלות.
</p>';
$string['graceperiod'] = 'תקופת "זמן-הארכה"';
$string['graceperiod_desc'] = 'מה יש לעשות כשסומן אפשור ש\'ניתן תקופת "זמן הארכה" להגשה אך ללא שינוי התגובות\', ערך ברירת המחדל של סכום הזמן הנוסף בשניות.';
$string['graceperiod_help'] = 'מה יש לעשות כשסומן אפשור ש\'ניתן תקופת "זמן הארכה" להגשה אך ללא שינוי התגובות\', זה הסכום הזמן הנוסף.';
$string['graceperiodmin'] = 'תקופת "זמן-הארכה" אחרון להגשה';
$string['graceperiodmin_desc'] = 'ייתכן ותיווצר בעיה בסופו של הבוחן. מצד אחד, אנו מעוניינים שהתלמידים ינצלו את הזמן שהוקצב להם למילוי הבוחן באופן מלא, כך שאוטומטית יוגש  הבוחן כשייגמר הזמן. מצד השני, ייתכן שבזמן זה ייווצר עומס על השרת, ותהליך עיבוד התגובות ייקח זמן מה. לפיכך, יתקבלו בחנים זמן מה לאחר פקיעת התוקף שלהם, כך שהתלמידים לא יצתרכו לספוג עונשים עקב פעילותו האיטית של השרת . עם זאת, ישנה אפשרות שהתלמידים ירמו וינצלו תוספת זמן זו, להמשך פתירת הבוחן.';
$string['graceperiodtoosmall'] = 'על תקופת "זמן הארכה" להיות יותר מ {$a}.';
$string['grade'] = 'ציון';
$string['gradeall'] = 'תן ציון לכל';
$string['gradeaverage'] = 'ציון ממוצע';
$string['gradeboundary'] = 'גבול הציון';
$string['gradeessays'] = 'תן ציון למאמרים';
$string['gradehighest'] = 'הציון הגבוה ביותר';
$string['grademethod'] = 'שיטת מתן ציונים';
$string['grademethod_help'] = '<p align="center"><b>שיטת מתן הציונים</b></p>

<p>כשמאפשרים לסטודנטים ניסיונות מענה מרובים (על הבחנים), ישנן דרכים שונות בהן אתם יכולים להשתמש בציונים של כל ניסיון כדי לחשב את הציון הסופי שהסטודנט יקבל עבור הבוחן.
</p>

<p><b>הציון הגבוה ביותר</b><p>
<ul>
<p>הציון הסופי יהיה הציון הגבוה (הטוב) ביותר מבין כל ניסיונות המענה.
</p>
</ul>

<p><b>ציון ממוצע</b><p>
<ul>
<p>הציון הסופי יהיה הציון הממוצע (ממוצע פשוט) של כל ניסיונות המענה.
</p>
</ul>

<p><b>ציון ראשון</b><p>
<ul>
<p>הציון הסופי יהיה הציון שהסטודנט הרוויח בניסיון המענה הראשון שלו (ניסיונות המענה האחרים לא יחשבו כלל.)</p>
</ul>

<p><b>ציון אחרון</b><p>
<ul>
<p>הציון האחרון הוא הציון שהתלמיד הרוויח רק עבור ניסיון המענה הכי עדכני שלו.
</p>
</ul>';
$string['gradesdeleted'] = 'ציוני הבוחן הוסרו';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'קיבלת: {$a->raw} מתוך {$a->max} נקודות להגשה זו.';
$string['gradingdetailsadjustment'] = 'עם קנסות קודמים התוצאה היא <strong>{$a->cur} / {$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'הגשה זו תיקנס ב-{$a}';
$string['gradingdetailszeropenalty'] = 'לא נקנסת בעבור הגשה זו.';
$string['gradingmethod'] = 'שיטת מתן הציון: {$a}';
$string['groupoverrides'] = 'הגדרות קבוצה מותאמות';
$string['groupsnone'] = 'לא נמצאו קבוצות בקורס זה';
$string['guestsno'] = 'אורחים אינם יכולים לראות או לנסות ולענות על הבחנים.';
$string['hidebreaks'] = 'הסתרת מעברי עמוד';
$string['hidereordertool'] = 'הסתא את כלי הסידור מחדש';
$string['history'] = 'היסטוריית התגובות:';
$string['howquestionsbehave_desc'] = 'הגדרות ברירת מחדל כסוג מנגנון השאלות';
$string['imagedisplay'] = 'תמונה להצגה';
$string['import'] = 'יבוא';
$string['importcategory'] = 'יבא קטגוריה';
$string['importerror'] = 'חלה שגיאה במהלך עיבוד היבוא.';
$string['importfilearea'] = 'יבא מתוך קובץ שכבר נמצא בקבצי הקורס...';
$string['importfileupload'] = 'יבא מתוך קובץ מועלה';
$string['importfromthisfile'] = 'יבא מתוך קובץ זה';
$string['import_help'] = 'פעולה זו מאפשרת לכם לייבא שאלות מקבצי טקסט חיצוניים.

אם הקובץ שלכם מכיל תווים שאינם ascii, אזי  עליכם להשתמש בקידוד UTF-8. עליכם להיות זהירים במיוחד עם קבצים שנוצרו על ידי יישומי Microsoft Office, היות והם נפוצים בשימוש קידוד מיוחד שלא יבוצע כראוי.

 תבניות יבוא ויצוא הן משאבים חיצוניים שניתן לחבר לתוכנה ולהרחיב את אפשרויות הפעולה שלה. תבניות  אפשריות נוספות, עשויות להיות זמינות במודולים וברכיביי מסדי נתונים חיצוניים המתחברים אליה .';
$string['importingquestions'] = 'מיבא  {$a} שאלות מתוך הקובץ.';
$string['importmax10error'] = 'בשאלה שלך יש שגיאה. אינך יכול להגדיר יותר מעשר תשובות.';
$string['importmaxerror'] = 'בשאלה שלך יש שגיאה. קיימות יותר מדי תשובות.';
$string['importquestions'] = 'יבא שאלות מקובץ';
$string['inactiveoverridehelp'] = '* לסטודנט לא קיימת קבוצה או התפקיד מתאים בכדי לנסות ולענות על הבוחן';
$string['incorrect'] = 'לא נכון';
$string['indivresp'] = 'תגובות של יחידים לכל פריט';
$string['info'] = 'מידע';
$string['infoshort'] = 'i';
$string['inprogress'] = 'בתהליך';
$string['introduction'] = 'הנחייה לבוחן';
$string['invalidattemptid'] = 'לא קיים ID לנסיון מענה זה';
$string['invalidcategory'] = 'מספר הזיהוי של הקטגוריה אינו תקף';
$string['invalidnumericanswer'] = 'אחת התשובות שהגשת לא היתה מספר תקף.';
$string['invalidnumerictolerance'] = 'אחד ממרווחי הסובלנות שהכנסת לא היה מספר תקף.';
$string['invalidoverrideid'] = 'קוד זיהוי הגדרות־מותאמות שגוי';
$string['invalidquestionid'] = 'ID השאלה שגויה';
$string['invalidquizid'] = 'ID הבוחן שגוי';
$string['invalidsource'] = 'המקור לא מתקבל כתקף.';
$string['invalidsourcetype'] = 'סוג מקור שגוי.';
$string['invalidstateid'] = 'מצב ID שגוי';
$string['lastanswer'] = 'התשובה האחרונה שלך הייתה';
$string['layout'] = 'סידור השאלות בבוחן';
$string['layoutasshown'] = 'תצורת עמוד הבוחןכמו שהיא';
$string['layoutasshownwithpages'] = 'תצורת העמוד כמו שמוצגת.
<small>( {$a} שאלות מוצג עמוד חדש לכל.)</small>';
$string['layoutshuffledandpaged'] = 'ערבוב שאלות אקראיות עם {$a} לכל עמוד';
$string['layoutshuffledsinglepage'] = 'שאלות עורבבו בצורה אקראית, כולן בעמוד אחד';
$string['link'] = 'קישור';
$string['listitems'] = 'רשימת הפריטים בבוחן';
$string['literal'] = 'מילולי';
$string['loadingquestionsfailed'] = 'טעינת השאלות לא צלחה: {$a}';
$string['makecopy'] = 'שמירה כשאלה חדשה';
$string['managetypes'] = 'ניהול סוגי שאלות ושרתים';
$string['manualgrading'] = 'מתן ציון';
$string['mark'] = 'הגש';
$string['markall'] = 'הגש את העמוד';
$string['marks'] = 'נקודות';
$string['marks_help'] = 'הניקוד המספרי עבור כל שאלה וסך-כל הציון הכללי';
$string['match'] = 'התאמה';
$string['matchanswer'] = 'תשובת התאמה';
$string['matchanswerno'] = '{$a} תשובת התמאה';
$string['max'] = 'מקסימום';
$string['messageprovider:attempt_overdue'] = 'תצוגת אזהרה כאשר הנסיון נעשה באיחור';
$string['messageprovider:confirmation'] = 'אישור להגשת הבוחן שלך';
$string['messageprovider:submission'] = 'הודעה על הגשות הבוחן';
$string['min'] = 'מינימום';
$string['minutes'] = 'דקות';
$string['missingcorrectanswer'] = 'חובה לציין את התשובה הנכונה.';
$string['missingitemtypename'] = 'שם חסר';
$string['missingquestion'] = 'שאלה זו כבר איננה קיימת';
$string['modulename'] = 'בוחן';
$string['modulename_help'] = 'פעילות "בוחן" (Quiz) מאפשרת למורה ליצור שאלות מסוגים שונים: שאלות בחירה מרובה, התאמה, תשובה קצרה, הזנת מאמר קצר באופן מקוון, נוסחאות מתמטיות ושאלות מבוססות תשובה מספרית.

המורה יכול לאפשר מספר כניסות לבוחן, וזאת עם אפשרות של ערבוב מחדש של סדר השאלות או שליפתן באופן אקראי ממאגר השאלות. ניתן להגדיר מגבלת זמן לניסיון המענה על הבוחן.

על כל ניסיון בפתירת שאלה בבוחן, מתקבל ציון באופן אוטומטי, פרט לשאלות מאמר (פתוחות). הציון נרשם בגליון-הציונים של הקורס.

המורה יכול לבחור אם וכאשר רמזים, משוב ותשובות נכונות, יוצגו לתלמידים.

בוחנים עשויים לשמש ל:

* בחינות או תרגול חומר לימוד בקורס.

* בדיקות קצרות לקריאת מטלות או בסוף לימוד של נושא כלשהו.

* כמבחן תרגול באמצעות שאלות מהבחינות קודמות.

* כדי לספק משוב מיידי על ביצועים.

* להערכה עצמית.';
$string['modulenameplural'] = 'בחנים';
$string['moveselectedonpage'] = 'העבר את השאלות שנבחרו לעמוד: {$a}';
$string['multichoice'] = 'רב-ברירה';
$string['multipleanswers'] = 'בחר בתשובה אחת לפחות';
$string['multiplier'] = 'מכפיל';
$string['mustbesubmittedby'] = 'יש צורך להגיש את נסיון מענה זה';
$string['name'] = 'שם';
$string['navmethod'] = 'שיטת ניווט';
$string['navmethod_free'] = 'חופשי';
$string['navmethod_help'] = 'במצב ניווט "קבוע", התלמידים חייבים להתקדם בניסיון המענה של הבוחן לפי סדר מסויים ואינם יכולים לחזור לעמודים הקודמים ולא לדלג קדימה.';
$string['navmethod_seq'] = 'קבוע, לפי סדר העמודים והשאלות';
$string['navnojswarning'] = 'אזהרה: קישורים אלו לא ישמרו את התשובות שלך. השתמש בכפתור הבא בתחתית העמוד.';
$string['neverallononepage'] = 'לעולם לא, כל השאלות באותו עמוד';
$string['newattemptfail'] = 'שגיאה: לא היה ניתן להתחיל בניסיון חדש לענות על הבוחן.';
$string['newpage'] = 'עמוד חדש';
$string['newpageevery'] = 'התחל עמוד חדש באופן אוטומטי';
$string['newpage_help'] = '<p align="center"><b>שאלות בעמוד</b></p>

<p>בבחנים ארוכים יותר הגיוני למתוח את הבוחן על כמה עמודים על ידי הגבלת מספר השאלות שיופיעו בכל עמוד. במהלך הוספת שאלות לעמוד הבוחן מעברי העמודים יוספו באופן אוטומטי לפי ההגדרה שתקבעו כאן. אבל תמיד תהיה בידכם האפשרות להזיז את מעברי העמודים מאוחר יותר באופן ידני בעמוד העריכה.
</p>';
$string['noanswers'] = 'לא נבחרו תשובות!';
$string['noattempts'] = 'לא נעשו ניסיונות לענות על בוחן זה';
$string['noattemptsfound'] = 'לא נמצאו נסיונות מענה';
$string['noattemptstoshow'] = 'אין נסיונות מענה להציג';
$string['nocategory'] = 'לא נכון או שלא פורטה קטגוריה.';
$string['noclose'] = 'ללא תאריך סגירה';
$string['nocommentsyet'] = 'עדיין אין הערות.';
$string['noconnection'] = 'נכון לרגע זה אין חיבור לשירות רשת שיכול לעבד את השאלה הזו. אנא צור קשר עם המנהל שלך.';
$string['nodataset'] = 'כלום - זהו אינו תו-כללי';
$string['nodatasubmitted'] = 'לא הוגש כל מידע';
$string['noessayquestionsfound'] = 'לא נמצאו שאלות שניתן להם ציון באופן ידני.';
$string['nogradewarning'] = 'לא ניתן ציון לבוחן זה. לא תוכל להגדיר הערכה מילולית מסכמת אשר שונה מהציון.';
$string['nomoreattempts'] = 'אין באפשרותך לבצע ניסיונות מענה נוספים עבור בוחן זה.';
$string['none'] = 'ללא';
$string['noopen'] = 'אין תאריך התחלה';
$string['nooverridedata'] = 'יש לעקוף הגדרה אחת מהגדרות הבוחן.';
$string['nopossibledatasets'] = 'אין מערכי נתונים אפשריים';
$string['noquestionintext'] = 'טקסט השאלה אינו מכיל שאלות משובצות.';
$string['noquestions'] = 'בשלב זה, יש להוסיף שאלות לבוחן על מנת שאפשר יהיה להציג אותו בפני התלמידים';
$string['noquestionsfound'] = 'לא נמצאו שאלות';
$string['noquestionsinquiz'] = 'לא קיימות שאלות בבוחן זה.';
$string['noquestionsnotinuse'] = 'השאלה האקראית לא בשימוש , מפני שהקטגוריה שלה ריקה.';
$string['noquestionsonpage'] = 'עמוד ריק';
$string['noresponse'] = 'אין תגובה.';
$string['noreview'] = 'אין הרשאה לעיין בתשובות של בוחן זה.';
$string['noreviewattempt'] = 'אין הרשאה לצפות בנסיון מענה זה';
$string['noreviewshort'] = 'אין הרשאה';
$string['noreviewuntil'] = 'אתה לא מורשה לעיין בתשובות של בוחן זה עד ל-{$a}.';
$string['noreviewuntilshort'] = 'זמין {$a}';
$string['noscript'] = 'כדי להמשיך עליך להפעיל את JavaScript!';
$string['notavailabletostudents'] = 'שים לב: נכון לעכשיו, בוחן זה אינו זמין לסטודנטים שלך.';
$string['notenoughrandomquestions'] = 'אין מספיק שאלות בקטגוריה  {$a->category}  ליצירת השאלה {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'לא הוגדרו מספיק תת-שאלות!<br />אתה מעוניין לחזור ולתקן את השאלה הזו?';
$string['notimedependentitems'] = 'נכון לעכשיו מודול הבחנים לא תומך בפריטים התלויים בזמן. כדי לעקוף את זה, קבע מגבלת זמן לבוחן כולו. האם אתה מעוניין לבחור בפריט אחר (או שבכל זאת תרצה להשתמש בפריט הנוכחי)?';
$string['notyetgraded'] = 'לא ניתן ציון עדיין';
$string['notyetviewed'] = 'לא נצפה עדיין';
$string['notyourattempt'] = 'זהו איננו הנסיון שלך!';
$string['noview'] = 'משתמש מחובר לא מורשה לצפות בבוחן זה';
$string['numattempts'] = '$a->studentnum $a->studentstring ניסה לענות על הבוחן $a->attemptnum פעמים.';
$string['numattemptsmade'] = '{$a} ניסיונות נעשו עבור בוחן זה';
$string['numberabbr'] = '#';
$string['numerical'] = 'מספרי';
$string['numquestionsx'] = 'שאלות: {$a}';
$string['oneminute'] = 'דקה אחת';
$string['onlyteachersexport'] = 'מורים בלבד יכולים לייצא שאלות.';
$string['onlyteachersimport'] = 'רק מורים בעלי זכויות עריכה יכולים לייצא שאלות.';
$string['onthispage'] = 'עמוד זה';
$string['open'] = 'לא נענו';
$string['openclosedatesupdated'] = 'מועדי תחילת וסיום הבוחן עודכנו';
$string['optional'] = 'לבחירתכם';
$string['orderandpaging'] = 'סדר ועימוד';
$string['orderandpaging_help'] = 'לצד כל שאלה מופיעים מספרים המציינים את סדר השאלות 10, 20, 30, ...
המספרים עולים בקפיצות של 10 על מנת להשאיר מקום לשאלות נוספות להוספה ביניהם. כדי לסדר מחדש את השאלות, יש לשנות את המספרים ואז להקיש על הכפתור "סידור מחדש של שאלות".

כדי להוסיף רווחים לאחר שאלות מסוימות, סמנו את תיבות הסימון שלצד השאלות ואז הקישו על כפתור " הוסיפו דפים חדשים לאחר שבחרתם שאלות " .

כדי לסדר את השאלות על פני מספר עמודים, הקישו על כפתור " סידור דפים מחדש" ובחרו את מספר השאלות הרצוי בכל עמוד.';
$string['orderingquiz'] = 'סדר ועימוד';
$string['orderingquizx'] = 'סדר ועימוד: {$a}';
$string['outcomesadvanced'] = 'מדדי-הערכה הם הגדרות מתקדמות';
$string['outof'] = '{$a->grade} מתוך מקסימום של {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade}  מתוך הציון המירבי  {$a->maxgrade}({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'הערכה מילולית מסכמת לבוחן';
$string['overallfeedback_help'] = '<p align="center"><b>"הערכה מילולית מסכמת"</b></p>

<p>"הערכה מילולית מסכמת" היא טקסט כלשהוא שמוצג לתלמיד לאחר שסיים נסיון לענות על הבוחן. ניתן לתלות את הערכה המילולית המסכמת שתוצג תלמיד בתוצאה שהוא קיבל.
</p>

<p>לדוגמא, אם תכניסו:</p>

<p>גבול הציון: 100%<br />
משוב: טוב מאוד<br />
גבול הציון: 40%<br />
משוב: אנא עבור שוב על החומר שנלמד השבוע <br />
...<br />
גבול הציון: 0%</p>

<p>אז, לתלמידים שקיבלו תוצאה בין 100% ל-40% תוצג ההודעה "טוב מאוד" ובפני התלמידים שקיבלו תוצאה בין 39.99% ל-0% תוצג ההודעה השניה. כלומר, גבולות הציון מגדירים את הטווחים של הציונים וכל מחרוזת של משוב תוצג לתוצאות שנמצאות בטווח המתאים.
</p>

<p>את גבולות הציון ניתן לפרט או כאחוזים, לדוגמא: "31.41%", או כמספר, לדוגמא: "7". אם הבוחן שלכם הוא בעל ציון מירבי של 10 נקודות, גבול ציון של 7 משמעותו ציון של 107 או גבוה יותר.

</p>';
$string['overdue'] = 'איחר את המועד';
$string['overduehandling'] = 'לאחר שחלף זמן סיום הבוחן';
$string['overduehandlingautoabandon'] = 'נסיונות מענה שלא יוגשו לפני זמן סיום הבוחן, לא יכללו בהגשה';
$string['overduehandlingautosubmit'] = 'הגשה אוטומטית של נסיונות מענה פתוחים';
$string['overduehandling_desc'] = 'מה יקרה כברירת מחדל אם סטודנט לא יגיש את הבוחן לפני הזמן החולף.';
$string['overduehandlinggraceperiod'] = 'מופעל מנגנון "זמן הארכה" המאפשר הגשה של נסיונות פתוחים, אך לא ניתן לענות על שאלות נוספות';
$string['overduehandling_help'] = 'הגדרה זו שולטת במקרה שתלמיד לא הספיק להגיש את פיתרון הבוחן שלו לפני הזמן שהוקצב. אם התלמיד עובד באופן פעיל על הבוחן בזמן שהוקצב, איז קוצב הזמן יגיש תמיד באופן אוטומטי את הבוחן שלו. במקרה שבו התנתק התלמיד, אז הגדרה זו תפעל.';
$string['overduemustbesubmittedby'] = 'עבר זמן ההגשה של בוחן זה. אם אתם מעוניינים לקבל ציון, עליכם להגישו ב- {$a}. במידה ולא תגישו  עד אז, אף ניקוד על שאלות בבוחן לא יחושב.';
$string['override'] = 'התאמת הגדרות';
$string['overridedeletegroupsure'] = 'האם אתה בטוח כי ברצונך למחוק את ההגדרות המותאמות לקבוצה {$a}?';
$string['overridedeleteusersure'] = 'האם אתה בטוח כי ברצונך למחוק את ההגדרות המותאמות למשתמש {$a}?';
$string['overridegroup'] = 'התאמת הגדרות לקבוצה';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'הגדרות־מותאמות';
$string['overrideuser'] = 'הגדרות־מותאמות למשתמש';
$string['overrideusereventname'] = '{$a->quiz} - הגדרות־מותאמות';
$string['page-mod-quiz-attempt'] = 'עמוד בוחן נסיון המענה';
$string['page-mod-quiz-edit'] = 'עריכת עמוד הבוחן';
$string['page-mod-quiz-report'] = 'עמוד כלשהו בדוח הבוחן';
$string['page-mod-quiz-review'] = 'בדיקת עמוד נסיון מענה הבוחן';
$string['page-mod-quiz-summary'] = 'עמוד סיכום נסיונות מענה הבוחן';
$string['page-mod-quiz-view'] = 'עמוד מידע הבוחן';
$string['page-mod-quiz-x'] = 'עמוד רכיב בוחן כלשהו';
$string['pagesize'] = 'גודל העמוד';
$string['parent'] = 'אב';
$string['parentcategory'] = 'קטגוריית אב';
$string['parsingquestions'] = 'מפרק את השאלות מתוך קובץ היבוא';
$string['partiallycorrect'] = 'תשובה נכונה חלקית';
$string['penalty'] = 'קנס';
$string['penaltyscheme'] = 'יישם קנסות';
$string['penaltyscheme_help'] = '<p align="center"><b>יישם קנס</b></p>

<p>אם הבוחן מורץ במצב מסתגל אז לסטודנט ניתנת האפשרות לנסות לענות שוב לאחר שהוא ענה תשובה לא נכונה.
במקרה הזה, יכול להיות שתרצו לכפות קנס על כל תשובה שגויה, קנס שיורד מהציון הסופי שהסטודנט יקבל עבור השאלה. גובה הקנס נבחר עבור כל שאלה באופן פרטני בזמן הגדרת או עריכת השאלה. </p>

<p>להגדרה זו אין כל השפעה במידה והבוחן לא מורץ במצב מסתגל.
</p>';
$string['percentcorrect'] = 'אחוז תשובות נכונות';
$string['pleaseclose'] = 'הבקשה שלך עובדה. כעת אתה יכול לסגור את החלון.';
$string['pluginadministration'] = 'ניהול בוחן';
$string['pluginname'] = 'בוחן';
$string['popup'] = 'הצגת המבחן בחלון "מוגן"';
$string['popupblockerwarning'] = 'החלק של הבחינה נמצא במצב \'מוגן\', הדבר אומר שעליך לפתור את הבוחן בחלון המוגן. אנא כבה את חוסם החלונות ה\'קופצים\' שלך. תודה.';
$string['popupnotice'] = 'הסטודנטים יראו את בוחן זה בחלון מוגן';
$string['preprocesserror'] = 'שגיאה התרחשה במהלך טרום תהליך העיבוד!';
$string['preview'] = 'תצוגה מקדימה';
$string['previewquestion'] = 'תצוגה מקדימה של השאלה';
$string['previewquiz'] = 'תצוגה מקדימה של {$a}';
$string['previewquiznow'] = 'צפיה מוקדמת בבוחן';
$string['previous'] = 'מצב קודם';
$string['publish'] = 'פרסם';
$string['publishedit'] = 'על מנת שתוכל להוסיף או לערוך שאלות שנמצאות בקטגוריה זה, עליך להיות בעל הרשאות מתאימות בקורס המפרסם';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'שם';
$string['qti'] = 'תסדיר IMS QTI';
$string['qtypename'] = 'סוג, שם';
$string['question'] = 'שאלה';
$string['questionbankcontents'] = 'תוכן מאגר־השאלות';
$string['questionbankmanagement'] = 'ניהול מאגר-השאלות';
$string['questionbehaviour'] = 'התנהגות השאלה';
$string['questioncats'] = 'קטגוריות של שאלות';
$string['questiondeleted'] = 'השאלה נמחקה. אנא צור קשר עם המורה שלך.';
$string['questioninuse'] = 'השאלה \'{$a->questionname}\' נמצאת כרגע בשימוש ב: <br />{$a->quiznames}<br />השאלה לא תימחק מבחנים אלה, אלא רק מרשימת הקטגוריות.';
$string['questionmissing'] = 'שאלה עבור מושב זה חסרה';
$string['questionname'] = 'שם השאלה';
$string['questionnonav'] = '<span class="accesshide">שאלה </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">מידע</span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'השאלה {$a} לא נטענה ממסד הנתונים';
$string['questionorder'] = 'סדר השאלה';
$string['questionposition'] = 'מיקום חדש בסדר של שאלה {$a}';
$string['questions'] = 'שאלות';
$string['questionsinclhidden'] = 'שאלות (כולל מוסתרות)';
$string['questionsinthisquiz'] = 'שאלות בבוחן זה';
$string['questionsperpage'] = 'שאלות בכל דף';
$string['questionsperpageselected'] = 'שאלות לכל עמוד הוגדר כאן כך שהעימוד תוכן כרגע.
כתוצאה מכך שליטת העימוד לא תאופשר. תוכל לשנות זאת כאן {$a}.
';
$string['questionsperpagex'] = 'שאלות לכל עמוד: {$a}';
$string['questiontext'] = 'תוכן השאלה';
$string['questiontextisempty'] = '[שאלה ללא תוכן]';
$string['questiontype'] = 'שאלה מסוג {$a}';
$string['questiontypesetupoptions'] = 'אפשרויות הגדרת התצורה של סוגי השאלות:';
$string['quiz:addinstance'] = 'הוספת בוחן חדש';
$string['quiz:attempt'] = 'נסה לענות על הבחנים';
$string['quizavailable'] = 'בוחן זה זמין עד: {$a}';
$string['quizclose'] = 'סיום הבוחן';
$string['quizclosed'] = 'בוחן זה מסתיים ב-{$a}';
$string['quizcloses'] = 'סיום הבוחן';
$string['quizcloseson'] = 'בוחן  זה יסגר ב  {$a}';
$string['quiz:deleteattempts'] = 'מחיקת ניסיונות המענה על הבחנים';
$string['quiz:emailconfirmsubmission'] = 'קבל אישור בדואר אלקטרוני כאשר הבוחן נשלח לבדיקה';
$string['quiz:emailnotifysubmission'] = 'קבל הודעה בדואר אלקטרוני על נסיון מענה לבוחן';
$string['quiz:emailwarnoverdue'] = 'קבלת הודעת דוא"ל כאשר חלף זמן נסיון המענה  ויש להגישו.';
$string['quiz:grade'] = 'בדוק ותן ציון לבחנים באופן ידני';
$string['quiz:ignoretimelimits'] = 'מתעלם מהגבלת הזמן שיש לבחנים';
$string['quizisclosed'] = 'בוחן זה נסגר';
$string['quizisclosedwillopen'] = 'הבוחן סגור (יפתח ב  {$a})';
$string['quizisopen'] = 'הבוחן זמין למענה';
$string['quizisopenwillclose'] = 'הבוחן נפתח (נסגר ב {$a})';
$string['quiz:manage'] = 'ניהול בחנים';
$string['quiz:manageoverrides'] = 'ניהול הגדרות בוחן מותאמות';
$string['quiznavigation'] = 'ניווט בוחן';
$string['quizopen'] = 'תחילת הבוחן';
$string['quizopenclose'] = 'פתיחה וסיום תאריכים';
$string['quizopenclose_help'] = 'הסטודנטים יכולים להתחיל את נסיונות המענה שלהם לאחר פתיחת תאריך זמינות הבוחן ועליהם לסיים את נסיונות המענה לפני תאריך (זמן) סגירת הבוחן.';
$string['quizopened'] = 'הבוחן פתוח.';
$string['quizopenedon'] = 'הבוחן יפתח ב-{$a}';
$string['quizopens'] = 'תחילת הבוחן';
$string['quizopenwillclose'] = 'הבוחן פתוח. הוא יסגר ב-{$a} ב-';
$string['quizordernotrandom'] = 'לא עורבב סדר השאלות בבוחן';
$string['quizorderrandom'] = '* סדר השאלות בבוחן עורבב';
$string['quiz:preview'] = 'תצוגה מקדימה לבחנים';
$string['quiz:regrade'] = 'תן ציון מחודש לנסיונות הבוחן';
$string['quiz:reviewmyattempts'] = 'סקירת הניסיונות שלך';
$string['quizsettings'] = 'הגדרות הבוחן';
$string['quiztimer'] = 'שעון עצר הבוחן';
$string['quiz:view'] = 'ראה את המידע הנתון על הבוחן';
$string['quiz:viewreports'] = 'ראה את דוחות הבוחן';
$string['quizwillopen'] = 'הבוחן יפתח ב-{$a}';
$string['random'] = 'שאלה אקראית (מקטגוריה)';
$string['randomcreate'] = 'יצירת שאלות אקראיות';
$string['randomfromcategory'] = 'שאלה־אקראית מקטגוריה:';
$string['randomfromexistingcategory'] = 'שאלה־אקראית מתוך קטגוריה קיימת';
$string['randomnosubcat'] = 'שאלות אך ורק מקטגוריה זו ולא מקטגוריות המשנה.';
$string['randomquestionusinganewcategory'] = 'שאלה־אקראית מקטגוריה חדשה';
$string['randomwithsubcat'] = 'שאלות מקטגוריה זו ומקטגוריות המשנה.';
$string['readytosend'] = 'אתה עומד לשלוח את כל הבוחן שלך לבדיקה וקבלת ציון. האם אתה בטוח שאתה רוצה להמשיך?';
$string['reattemptquiz'] = 'התחלת ניסיון מענה חדש של הבוחן';
$string['recentlyaddedquestion'] = 'שאלה שנוספה לאחרונה!';
$string['recurse'] = 'הצגת שאלות גם מתת-קטגוריות';
$string['regrade'] = 'בדוק והערך מחדש את כל נסיונות המענה';
$string['regradecomplete'] = 'כל נסיונות המענה נבדקו והוערכו מחדש או ניתן להם ציון מחדש';
$string['regradecount'] = 'שונו {$a->changed} מתוך {$a->attempt} ציונים.';
$string['regradedisplayexplanation'] = 'ניסיונות מענה שמשתנים במהלך הבדיקה מחדש, מוצגים כקישורים לחלון העיון בשאלה.';
$string['regradenotallowed'] = 'אין לך היתר לתת ציון לבוחן זה';
$string['regradingquestion'] = 'בודק מחדש את "{$a}".';
$string['regradingquiz'] = 'בודק מחדש את בוחן "{$a}"';
$string['remove'] = 'הסרת';
$string['removeallquizattempts'] = 'הסרת כל נסיונות הבוחן';
$string['removeemptypage'] = 'סלק דפים ריקים';
$string['removeselected'] = 'הסר את השאלות הנבחרות';
$string['rename'] = 'שנה שם';
$string['renderingserverconnectfailed'] = 'השרת {$a} לא הצליח לעבד בקשת RQP. בדוק שכתובת ה-URL נכונה.';
$string['reorderquestions'] = 'סדר מחדש את השאלות';
$string['reordertool'] = 'הצגת כלי הסידור מחדש.';
$string['repaginate'] = 'מספר מחדש את העמודים, כל עמוד עם {$a} שאלות.';
$string['repaginatecommand'] = 'מספר מחדש';
$string['repaginatenow'] = 'מספר כעת';
$string['replace'] = 'החלף';
$string['replacementoptions'] = 'אפשרויות החלפה';
$string['report'] = 'דוחות';
$string['reportanalysis'] = 'ניתוח פריט';
$string['reportattemptsfrom'] = 'נסיונות החל מ';
$string['reportattemptsthatare'] = 'נסיונות ש';
$string['reportdisplayoptions'] = 'הצגת אפשרויות';
$string['reportfullstat'] = 'נתונים סטטיסטיים מפורטים';
$string['reportmulti_percent'] = 'אחוזים מרובים';
$string['reportmulti_q_x_student'] = 'בחירות של מספר סטודנטים';
$string['reportmulti_resp'] = 'תגובות פרטניות';
$string['reportmustselectstate'] = 'עליך לבחור מצב אחד לפחות';
$string['reportnotfound'] = 'דוח לא ידוע {$a}';
$string['reportoverview'] = 'עיון כללי';
$string['reportregrade'] = 'בדוק והערך מחדש את הניסיונות';
$string['reportresponses'] = 'תגובות מפורטות';
$string['reports'] = 'דוחות';
$string['reportshowonly'] = 'הצגת רק נסיונות מענה';
$string['reportshowonlyfinished'] = 'הצג לכל היותר נסיון מענה שהסתיים עבור כל משתמש ({$a})';
$string['reportsimplestat'] = 'נתונים סטטיסטיים פשוטים';
$string['reportusersall'] = 'כל המשתמשים אשר ענו על בוחן זה';
$string['reportuserswith'] = 'משתמשים רשומים שהגישו בוחן זה';
$string['reportuserswithorwithout'] = 'משתמשים רשומים אשר הגישו או לא הגישו בוחן.';
$string['reportuserswithout'] = 'משתמשים רשומים שלא הגישו את הבוחן';
$string['reportwhattoinclude'] = 'מה לכלול בדוח';
$string['requirepassword'] = 'דרוש סיסמה';
$string['requirepassword_help'] = '<p align="center"><b>דרוש סיסמא</b></p>

<p>שדה זה הוא אינו חובה.</p>

<p>אם תפרטו כאן סיסמא, אז משתתפים יחוייבו להכניס את אותה הסיסמא לפני שהם יוכלו לנסות ולענות על הבוחן.
</p>';
$string['requiresubnet'] = 'דרוש כתובת רשת';
$string['requiresubnet_help'] = '<p>שדה זה הוא איננו חובה.</p>

<p>באפשרותכם להגביל את הגישה לבוחן לתת-רשתות מסויימות ב- LAN או באינטרנט על ידי פירוט רשימה המופרדת בפסיקים של המספרים המלאים או החלקיים של כתובות ה-IP.
</p>

<p>אפשרות זו מועילה במיוחד לבחנים שנמצאים תחת פיקוח, בהם אתם רוצים לוודא שרק אנשים שנמצאים בחדר מסויים מורשים לגשת לבוחן.
</p>

<p>לדוגמא: <b>192.168. , 231.54.211.0/20, 231.3.56.211, 231.3.56.10-20</b></p>

<p>ישנם ארבעה סוגים של מספרים בהם אתם יכולים להשתמש (אין באפשרותכם להשתמש בשמות domain המבוססים על כתב, כמו לדוגמא example.com):</p>

<ol>
<li>כתובותצ  IP מלאות, כמו <b>192.168.10.1</b> שיתאימו למחשב פרטני (או
    לאלא שקשורים אליו).</li>
<li>כתובות חלקיות, כמו: <b>192.168</b> שיתאימו לכל דבר המתחיל באותם המספרים.</li>
<li>סימון CIDR , כמו <b>231.54.211.0/20</b> שמאפשר לכם לציין תת-רשתות יותר מפורטות.</li>
<li>טווח של כתובות IP <b>231.3.56.10-20</b>הטווח מוחל על החלק האחרון של הכתובת, שמשמעותו כל כתובות ה-IP החל מ- 231.3.56.10
    ועד ל- 231.3.56.20.</li>
</ol>

<p>תוך התעלמות מהרווחים.</p>';
$string['response'] = 'תגובה';
$string['responses'] = 'תגובות';
$string['results'] = 'תוצאות';
$string['returnattempt'] = 'בחזרה לנסיון המענה';
$string['reuseifpossible'] = 'השתמש מחדש במה שסולק בעבר.';
$string['reverttodefaults'] = 'חזור לברירת המחדל של הבוחן';
$string['review'] = 'עיון בתשובות';
$string['reviewafter'] = 'אפשר עיון בתשובות לאחר שהבוחן מסתיים';
$string['reviewalways'] = 'אפשר לעיין בתשובות בכל זמן שהוא';
$string['reviewattempt'] = 'סקירת נסיון מענה';
$string['reviewbefore'] = 'אפשר לעיין בתשובות בזמן שהבוחן עדיין פתוח';
$string['reviewclosed'] = 'לאחר סגירת הבוחן';
$string['reviewduring'] = 'במהלך נסיון המענה';
$string['reviewimmediately'] = 'מיידית לאחר גמר הניסיון לפתירת הבוחן';
$string['reviewnever'] = 'לעולם אל תאפשר לעיין בתשובות.';
$string['reviewofattempt'] = 'עיון בתשובות שניתנו בניסיון מענה $a';
$string['reviewofpreview'] = 'סקירת תצוגה־מקדימה';
$string['reviewopen'] = 'מאוחר יותר, כאשר הבוחן עדיין פתוח';
$string['reviewoptions'] = 'הרשה לסטודנטים לעיין בתשובות';
$string['reviewoptionsheading'] = 'אפשרויות לתצוגת משוב';
$string['reviewoptionsheading_help'] = '<p>אפשרויות אלו שולטות על המידע שהמשתמשים יכולים לראות כאשר הם צופים בנסיונות הבוחן או כאשר הם צופים בדוחות הבוחן.</p>
<p>
במהלך נסיון מענה** מצב זה תקף למספר התנהגויות, כמו "אינטרקציה עם נסיונות מרובים" אשר יכולה להציג את המשוב במהלך הבוחן
</p>

<p>מיד לאחר נסיון המענה **  פרושו, שניתן לצפות רק עד שתי דקות מתום המענה לאחר  לחיצת המשתמש על "הגש הכל וסיים".</p>

<p>יותר מאוחר, כאשר הבוחן עדיין פתוח ** פרושו, לאחר מכן ולפני מועד סיום הבוחן. </p>

<p>לאחר  סגירת הבוחן, פרושו, לאחר שמועד סיום הבוחן עבר. אם לבוחן אין מועד סיום, השלב הזה לעולם לא יתבצע.</p>

<p>משתמשים בעלי  יכולת לצפיה בציונים מוסתרים [moodle/grade:viewhidden] (בד"כ מורים ומנהלים) לא מושפעים מהגדרה זו. ותמיד יוכלו לצפות בכל מידע נסיונות ההגשה של הסטודנטים בכל עת.</p>';
$string['reviewoverallfeedback'] = 'הערכה מילולית מסכמת לבוחן';
$string['reviewoverallfeedback_help'] = 'המשוב שניתן בסוף נסיון המענה תלוי בניקוד הכללי של הסטודנט';
$string['reviewresponse'] = 'עיון בתגובה';
$string['reviewresponsetoq'] = 'סקירת תגובה (שאלה {$a})';
$string['reviewthisattempt'] = 'סקירת התגובות שלך לנסיונות המענה';
$string['rqp'] = 'שאלה חיצונית';
$string['rqps'] = 'שאלות חיצוניות';
$string['sameasoverall'] = 'בדומה לציונים הכוללים';
$string['save'] = 'שמירה';
$string['saveandedit'] = 'שמירת שינויים ועריכת השאלות';
$string['saveattemptfailed'] = 'שגיאת מערכת!  נסיון המענה לא נשמר.';
$string['savedfromdeletedcourse'] = 'נשמר מקורס {$a} שנמחק.';
$string['savegrades'] = 'שמירת הציונים';
$string['savemyanswers'] = 'שמירת תשובותי';
$string['savenosubmit'] = 'שמור מבלי להגיש';
$string['saveoverrideandstay'] = 'שמירה והזנה של הגדרה־מותאמת חדשה';
$string['savequiz'] = 'שמירת הבוחן כולו';
$string['saving'] = 'שמירה';
$string['savingnewgradeforquestion'] = 'שמירת ציון חדש עבור שאלה {$a}.';
$string['savingnewmaximumgrade'] = 'שמירת ציון מירבי חדש';
$string['score'] = 'ציון גולמי';
$string['scores'] = 'ציון מחושב';
$string['select'] = 'בחר';
$string['selectall'] = 'בחר הכל';
$string['selectcategory'] = 'בחר קטגוריה';
$string['selectedattempts'] = 'ניסיונות שנבחרו....';
$string['selectnone'] = 'בטל בחירת הכל';
$string['selectquestiontype'] = '-- יש לבחור את סוג השאלה --';
$string['serveradded'] = 'נוסף שרת';
$string['serveridentifier'] = 'מזהה';
$string['serverinfo'] = 'מידע על השרת';
$string['servers'] = 'שרתים';
$string['serverurl'] = 'כתובת ה-URL של השרת';
$string['settingsoverrides'] = 'ניהול הגדרות־מותאמות';
$string['shortanswer'] = 'תשובה קצרה';
$string['show'] = 'תצוגה';
$string['showall'] = 'הצגת כל השאלות בעמוד אחד';
$string['showblocks'] = 'הצגת משבצות במהלך נסיונות מענה הבוחן';
$string['showblocks_help'] = 'אם מסומן \'כן\' משבצות רגילות יוצגו במהלך נסיונות מענה הבוחן';
$string['showbreaks'] = 'הצגת מעברי דפים';
$string['showcategorycontents'] = 'תצוגה השאלות המצויות בקטגוריה {$a->arrow}';
$string['showcorrectanswer'] = 'האם יש להציג בזמן המשוב את התשובות הנכונות?';
$string['showdetailedmarks'] = 'הצגת פרטי הניקוד';
$string['showeachpage'] = 'הצגת עמוד אחד בכל פעם';
$string['showfeedback'] = 'האם יש להציג משוב לאחר שניתנה התשובה?';
$string['showinsecurepopup'] = 'השתמש בחלון קופץ \'מאובטח\' עבור נסיונות המענה';
$string['showlargeimage'] = 'תמונה גדולה';
$string['shownoattempts'] = 'הצגת סטודנטים ללא נסיונות מענה';
$string['shownoattemptsonly'] = 'הצגת סטודנטים ללא נסיונות מענה בלבד';
$string['shownoimage'] = 'ללא תמונה';
$string['showreport'] = 'תצוגת דוח';
$string['showsmallimage'] = 'תמונה קטנה';
$string['showteacherattempts'] = 'הצגת ניסיונות מענה של מורים';
$string['showuserpicture'] = 'הצג תמונה של המשתמש';
$string['showuserpicture_help'] = 'אם מאופשר, שם הסטודנט ותמונתו יוצגו במסך בזמן נסיון המענה. ובנוסף יוצגו במסך סקירת נסיונות המענה. הדבר מקל לבדוק שהסטודנט מחובר במשתמש שלו ולהמשיך לצפות בבוחן.';
$string['shuffle'] = 'ערבוב';
$string['shuffleanswers'] = 'ערבוב תשובות';
$string['shuffledrandomly'] = 'ערבוב אקראי';
$string['shufflequestions'] = 'ערבוב שאלות';
$string['shufflequestionsselected'] = 'הבוחן מצוי במצב "ערבוב שאלות". פעולות הקשורות לסידור ידני של עמודים לא תהיינה זמינות. לשינוי מצב הבוחן,  {$a}.';
$string['shufflewithin'] = 'ערבוב תשובות בשאלה';
$string['shufflewithin_help'] = '<p align="center"><b>ערבוב  שאלות בבוחן</b></p>

<p>אם תאפשרו את האפשרות הזו, אז החלקים המרכיבים את השאלות הפרטניות יעורבבו באופן אקראי בכל פעם שסטודנט ינסה לענות על הבוחן, כל עוד האפשרות מאופשרת גם בהגדרות של השאלות.
</p>

<p>הכוונה היא פשוט להקשות מעט על הסטודנטים להעתיק אחד מהשני.
</p>

<p>אפשרות זו תקפה רק לשאלות שיש בהם מספר חלקים כמו שאלות התאמה או שאלות אמריקאיות. בשאלות אמריקאיות סדר התשובות מעורבב רק כאשר האפשרות הזו מכוונת ל-"כן". בשאלות מסוג התאמה התשובות תמיד מעורבבות ההגדרה הזו קובעת האם בנוסף לכך יעורבב הסדר של זוגות השאלות והתשובות.
</p>

<p>אפשרות זו לא קשורה לשימוש בשאלות אקראיות.</p>';
$string['singleanswer'] = 'בחר בתשובה אחת';
$string['sortage'] = 'מיין לפי תאריך הזנה';
$string['sortalpha'] = 'מיין לפי שם';
$string['sortquestionsbyx'] = 'מיין שאלות על-ידי: {$a}';
$string['sortsubmit'] = 'מיין שאלות';
$string['sorttypealpha'] = 'מיין לפי סוג, שם';
$string['specificapathnotonquestion'] = 'נתיב הקובץ המצויין כאן לא נמצא בשאלה המצויינת';
$string['specificquestionnotonquiz'] = 'השאלה המצויינת כאן איננה נמצאת בבוחן המצויין';
$string['startagain'] = 'התחל שוב';
$string['startattempt'] = 'תחילת נסיון המענה';
$string['startedon'] = 'התחיל ב:';
$string['startnewpreview'] = 'התחלת צפיה־מקדימה חדשה';
$string['stateabandoned'] = 'טרם הוגש';
$string['statefinished'] = 'הסתיים';
$string['statefinisheddetails'] = '{$a} הוגש';
$string['stateinprogress'] = 'בתהליך';
$string['statenotloaded'] = 'מצב השאלה {$a} לא נטען ממסד הנתונים';
$string['stateoverdue'] = 'באיחור';
$string['stateoverduedetails'] = 'מוכרח להיות מוגש עד {$a}';
$string['status'] = 'מצב';
$string['stoponerror'] = 'בשגיאה עצור';
$string['submitallandfinish'] = 'הגשה סופית וסיום ניסיון המענה (בוחן)';
$string['subneterror'] = 'סליחה, בוחן זה נחסם כך שניתן לגשת אליו רק ממקומות מסויימים. נכון לעכשיו, המחשב שלך הוא לא אחד ממקומות אלה, ולכן אינך יכול לנסות ולפתור את הבוחן.';
$string['subnetnotice'] = 'בוחן זה ננעל כך שהגישה אליו מותרת רק ממיקומים מסויימים. המחשב שלך לא נמצא בתת-רשת מורשה. כמורה, מותר לך לחזות בתצוגה המקדימה בכל מקרה.';
$string['subplugintype_quiz'] = 'דוח';
$string['subplugintype_quizaccess'] = 'תפקיד גישה';
$string['subplugintype_quizaccess_plural'] = 'תפקידי גישה';
$string['subplugintype_quiz_plural'] = 'דוחות';
$string['substitutedby'] = 'יוחלף על ידי';
$string['summaryofattempt'] = 'סיכום הנסיון';
$string['summaryofattempts'] = 'סיכום ניסיונות המענה הקודמים שלך';
$string['temporaryblocked'] = 'באופן זמני, אתה לא מורשה לנסות ולפתור את הבוחן שוב.<br />תוכל לנסות שוב בתאריך:';
$string['theattempt'] = 'תצוגת משוב לניסיון המענה';
$string['theattempt_help'] = 'האם הסטודנט יכול לצפות בהגשה בכלל?';
$string['time'] = 'זמן';
$string['timecompleted'] = 'הושלם';
$string['timedelay'] = 'אתה לא יכול לנסות לפתור את הבוחן מפני שעדיין לא חלפה השהיית הזמן שרק לאחריה אתה יכול לנסות ולפתור עוד בוחן.';
$string['timeleft'] = 'זמן נותר';
$string['timelimit'] = 'הגבלת זמן';
$string['timelimitexeeded'] = 'סליחה! עברת על מגבלת הזמן של הבוחן!';
$string['timelimit_help'] = 'אם מופעל, אז הגבלת הזמן תופיע בעמוד התחלת הבוחן ושעון הספירה לאחור יוצג בבלוק הניווט של הבוחן.';
$string['timelimitmin'] = 'משך הבחינה (בדקות)';
$string['timelimitsec'] = 'מגבלת הזמן (שניות)';
$string['timestr'] = '%H:%M:%S על %d/%m/%y';
$string['timesup'] = 'זמנך נגמר!';
$string['timetaken'] = 'הזמן שלקח';
$string['timing'] = 'תזמון';
$string['tofile'] = 'לקובץ';
$string['tolerance'] = 'מרווח סובלנות';
$string['toomanyrandom'] = 'מספר השאלות האקראיות הנדרשות עולה על מספר השאלות שעדיין זמינות בקטגוריה!';
$string['top'] = 'קצה עליון';
$string['totalmarksx'] = 'סך-כל הציונים: {$a}';
$string['totalquestionsinrandomqcategory'] = 'סך-כל הציונים: {$a} בקטגוריה';
$string['true'] = 'נכון';
$string['truefalse'] = 'נכון/לא-נכון';
$string['type'] = 'סוג';
$string['unfinished'] = 'פתוח';
$string['ungraded'] = 'לא נבדק, ללא ציון';
$string['unit'] = 'שם יחידת־המידה (באנגלית)';
$string['unknowntype'] = 'סוג השאלה לא נתמך בשורה {$a}. השאלה לא תיחשב.';
$string['unusedcategorydeleted'] = 'קטגוריה זו נמחקה מפני ששאלותיה יצאו מכלל שימוש לאחר שהקורס נמחק.';
$string['updatesettings'] = 'עדכן את הגדרות הבוחן.';
$string['updatingatttemptgrades'] = 'מעדכן את ציוני הנסיונות';
$string['updatingfinalgrades'] = 'מעדכן את הציונים הסופיים';
$string['updatingthegradebook'] = 'מעדכן את גליון הציונים';
$string['upgradesure'] = '<div style="color: red;">מודול הבוחן יבצע שינוי מקיף בטבלאות הבוחן, ושידרוג זה עדיין לא נבחן ונבדק במידה מספקת. לפני שאתה ממשיך, מומלץ מאוד לגבות את טבלאות בסיס הנתונים שלך.
.</div>';
$string['upgradingquizattempts'] = 'משדרג את נסיונות מענה הבוחן : בוחן
{$a->done}/{$a->outof} (Quiz id {$a->info})';
$string['upgradingveryoldquizattempts'] = 'משדרג את נסיונות המענה הישנים של הבוחן:
{$a->done}/{$a->outof}';
$string['url'] = 'כתובת URL';
$string['usedcategorymoved'] = 'קטגוריה זו נשתמרה בצורתה הנוכחית והועברה לרמת האתר זאת מפני שהיא קטגוריה מפורסמת וקורסים אחרים עדיין משתמשים בה.';
$string['useroverrides'] = 'הגדרות משתמש מותאמות';
$string['usersnone'] = 'אין לשום תלמיד גישה לבוחן זה';
$string['validate'] = 'תן תוקף';
$string['viewallanswers'] = 'צפה ב-{$a} נסיונות מענה';
$string['viewallreports'] = 'צפה בדוחות עבור {$a} נסיונות מענה';
$string['viewed'] = 'נצפה';
$string['warningmissingtype'] = '<b>סוג זה של שאלות עדיין לא הותקן על המוודל שלך. <br />אנה הודע זאת למנהל המוודל שלך.</b>';
$string['wheregrade'] = 'איפה הציון שלי?';
$string['wildcard'] = 'תו-כללי (Wild card)';
$string['windowclosing'] = 'החלון יסגר בקרוב.';
$string['withsummary'] = 'בליווי תקציר סטטיטי';
$string['wronguse'] = 'אתה לא יכול להשתמש בעמוד זה בצורה כזאת';
$string['xhtml'] = 'תסדיר XHTML';
$string['youneedtoenrol'] = 'בכדי לגשת לבוחן אתה צריך להיות רשום לקורס זה';
$string['yourfinalgradeis'] = 'ציונך הסופי בבוחן זה הוא {$a}';
