<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'he', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'ישנן הודעות חדשות בפורום';
$string['addanewdiscussion'] = 'הוספת נושא חדש לדיון';
$string['addanewquestion'] = 'הוספת שאלה חדשה';
$string['addanewtopic'] = 'הוספת נושא חדש';
$string['advancedsearch'] = 'חיפוש מתקדם';
$string['allforums'] = 'כל הפורומים';
$string['allowdiscussions'] = 'האם {$a} יכול לפרסם הודעות בפורום זה?';
$string['allowsallsubscribe'] = 'פורום זה מאפשר לכל אחד לבחור האם הוא מעוניין להירשם אליו כמנוי (לקבלת עדכונים) או לא';
$string['allowsdiscussions'] = 'פורום זה מאפשר לכל משתתף לפתוח בנושא חדש לדיון, פעם אחת.';
$string['allsubscribe'] = 'קבלת עדכונים מכל הפורומים';
$string['allunsubscribe'] = 'ביטול קבלת עדכונים מכל הפורומים';
$string['alreadyfirstpost'] = 'זהו כבר הפרסום הראשון לדיון זה';
$string['anyfile'] = 'כל קובץ';
$string['areaattachment'] = 'קבצים מצורפים';
$string['areapost'] = 'הודעות';
$string['attachment'] = 'קובץ מצורף';
$string['attachment_help'] = 'ניתן לצרף קובץ אחד או יותר לפרסום בפורום. אם תצרף תמונה, היא תוצג לאחר תוכן ההודעה.';
$string['attachmentnopost'] = 'תוכל לייצא קובץ מצורף ללא מספר זיהוי לפרסום.';
$string['attachments'] = 'קבצים מצורפים';
$string['attachmentswordcount'] = 'קבצים מצורפים וספירת מילים';
$string['blockafter'] = 'סף־חסימה לפרסום הודעות חדשות';
$string['blockafter_help'] = 'הגדרה זו מציינת את המספר המרבי של הודעות שמשתמש יכול לכתוב בתקופת זמן הנתונה. על משתמשים בעלי הרשאות mod/forum:postwithoutthrottling  לא חלה ההגבלה.';
$string['blockperiod'] = 'תקופת הזמן לפני החסימה';
$string['blockperioddisabled'] = 'ללא חסימה';
$string['blockperiod_help'] = 'ניתן לחסום תלמידים מפרסום יותר מאשר מספר נתון של הודעות בפרק זמן נתון. על משתמשים בעלי הרשאה mod/forum:postwithoutthrottling לא חלה ההגבלה.';
$string['blogforum'] = 'פורום רגיל מוצג בתצורת בלוג';
$string['bynameondate'] = 'על ידי {$a->name} בתאריך {$a->date}';
$string['cannotadd'] = 'לא ניתן להוסיף את הדיון לפורום זה.';
$string['cannotadddiscussion'] = 'על מנת שתוכל להוסיף דיונים לפורום עלייך להיות חבר בקבוצה.';
$string['cannotadddiscussionall'] = 'אין לך הרשאה להוסיף נושא דיון חדש עבור כל המשתתפים.';
$string['cannotaddsubscriber'] = 'לא ניתן היה להוסיף את המנוי עם מספר הזיהוי {$a} לפורום זה!';
$string['cannotaddteacherforumto'] = ' להוסיף מופע פורום של מורה אשר הומר ל-section 0
בקורס.';
$string['cannotcreatediscussion'] = 'כשלון ביצירת דיון חדש.';
$string['cannotcreateinstanceforteacher'] = 'לא ניתן ליצור מופע רכיב קורס חדש לפורום המורה';
$string['cannotdeletepost'] = 'לא ניתן למחוק פרסום זה';
$string['cannoteditposts'] = 'אינך יכול לערוך פרסומים של משתמשים אחרים.';
$string['cannotfinddiscussion'] = 'לא ניתן למצוא את הדיון לפורום זה.';
$string['cannotfindfirstpost'] = 'לא ניתן היה למצוא את הפרסום הראשון בפורום זה.';
$string['cannotfindorcreateforum'] = 'לא ניתן היה למצוא או ליצור פורום מסוג לוח מודעות לאתר זה.';
$string['cannotfindparentpost'] = 'לא ניתן היה למצוא את פרסום המקור לתגובה  {$a}';
$string['cannotmovefromsingleforum'] = 'לא ניתן להעביר את הדיון מ"פורום דיונים אחד"';
$string['cannotmovenotvisible'] = 'הפורום לא מוצג';
$string['cannotmovetonotexist'] = 'אינה יכול להגיע לפורום זה - הוא איננו קיים!';
$string['cannotmovetonotfound'] = '\'מטרת\' הפורום  לא נמצאה בקורס זה';
$string['cannotmovetosingleforum'] = 'לא ניתן להעביר דיון לפורום דיון פשוט';
$string['cannotpurgecachedrss'] = 'לא ניתן היה למחוק את מטמון הזנות ה-RSS עבור מקור זה ו/או פורומים מיועדים. אנא בדוק את קובץ הרשאות הפורומים שלך';
$string['cannotremovesubscriber'] = 'לא ניתן היה להסיר את המנוי עם מספר הזיהוי {$a} לפורום זה!';
$string['cannotreply'] = 'אינך יכול להגיב לפרסום זה.';
$string['cannotsplit'] = 'לא ניתן לפצל דיונים מפורום זה';
$string['cannotsubscribe'] = 'מצטערים, הינך מוכרח להיות חבר בקבוצה בכדי להיות מנוי.';
$string['cannottrack'] = 'לא ניתן היה לעקוב אחר פורום זה';
$string['cannotunsubscribe'] = 'לא ניתן להסיר אותך כמנוי מפורום זה';
$string['cannotupdatepost'] = 'אינך יכול לעדכן פרסום זה';
$string['cannotviewpostyet'] = 'עדיין אינך יכול לקרוא את השאלות של הסטודנטים האחרים בדיון זה, וזאת בגלל שעדיין לא פירסמת הודעה משלך.';
$string['cannotviewusersposts'] = 'לא קיימים פרסומים על-ידי משתמש זה שאתה רשאי לראות.';
$string['cleanreadtime'] = 'סמן פרסומים ישנים כשעת הקריאה';
$string['completiondiscussions'] = 'סטודנטים חייבים לפרסם דיונים';
$string['completiondiscussionsgroup'] = 'דיונים נדרשים';
$string['completiondiscussionshelp'] = 'נדרשים דיונים להשלמה';
$string['completionposts'] = 'סטודנטים מוכרחים לפרסם דיונים או תגובות:';
$string['completionpostsgroup'] = 'פרסומים נדרשים';
$string['completionpostshelp'] = 'נדרשים דיונים או תגובות בכדי להשלים';
$string['completionreplies'] = 'סטודנטים נדרשים לפרסם תגובות';
$string['completionrepliesgroup'] = 'תגובות נדרשות:';
$string['completionreplieshelp'] = 'תגובות נדרשום בכדי להשלים';
$string['configcleanreadtime'] = 'השעה ביום בה יש למחוק הודעות ישנות מטבלת "לקרוא".';
$string['configdigestmailtime'] = 'משתמשים הבוחרים לקבל מקבצי הודעות דוא"ל יקבלו את המקבץ מדי יום. הגדרה זו קובעת באיזה יום בשבוע המקבץ יישלח (הפעלת תהליך ה-cron אחרי שעה זו תגרום לשליחת המקבץ).';
$string['configdisplaymode'] = 'תצוגת הדיונים במצב ברירת המחדל, במידה שלא נקבעה דרך תצוגה אחרת.';
$string['configenablerssfeeds'] = 'דגל זה יפעיל את האפשרות של הזנות RSS לכל הפורומים. עדיין תצטרך להפעיל את ההזנות באופן ידני בהגדרות של כל פורום בנפרד.';
$string['configenabletimedposts'] = 'הצב \'כן\' במידה ואתה רוצה לאשר הגדרה של מועדי ההצגה כאשר מציגים דיון חדש  בפורום (עדיין בנסיון ולא נבדק דיו)';
$string['configlongpost'] = 'כל הודעה ארוכה מאורך זה (בתווים שאינם כוללים את תגי ה-HTML) נחשבת ארוכה. את ההודעות המתפרסמות בדף הראשי של האתר, עמודי הקורסים בתצורה חברתי או פרופילי המשתמשים, מקצרים בנקודה טבעית שנמצאת היכן-שהוא בין האורך המוגדר ע"י ערכי forum_shortpost ו-forum_longpost.';
$string['configmanydiscussions'] = 'מספר הדיונים המירבי שיוצג בכל דף בפורום';
$string['configmaxattachments'] = 'ברירת המחדל של המספר המירבי  של תצרופות קבצים המאופשרים בכל פרסום בפורום.';
$string['configmaxbytes'] = 'גודל מירבי המשמש כברירת מחדל לקובץ המצורף להודעת פורום באתר (כפוף להגבלות ברמת הקורס והגדרות מקומיות אחרות)';
$string['configoldpostdays'] = 'כל הודעה בת מספר זה של ימים, נחשבת כאילו היא נקראה.';
$string['configreplytouser'] = 'כאשר הודעה מהפורום נשלחת בדוא"ל, האם היא צריכה להכיל את כתובת הדוא"ל של השולח כדי שהמקבל יוכל לענות לו באופן אישי ולא דרך הפורום? גם אם תבחר בערך "כן", משתמשים יכולים לבחור בפרופיל שלהם לשמור על חסיון כתובת הדוא"ל שלהם.';
$string['configshortpost'] = 'כל הודעה מתחת לאורך זה (בתווים שאינם כוללים את תגי ה-HTML) נחשבת קצרה (ראה למטה).';
$string['configtrackingtype'] = 'הגדרות בררת מחדל של מעקב קריאה';
$string['configtrackreadposts'] = 'הגדר "כן" אם אתה רוצה לעקוב אחרי הודעות שנקראו/לא נקראו עבור כל משתמש.';
$string['configusermarksread'] = 'אם \'כן\', המשתמש מחויב לסמן כל הודעה שהוא קורא באופן ידני כ\'נקראה\'. אם \'לא\', ברגע שהודעה ניצפית, היא אוטומטית מסומנת כ\'נקראה\'.';
$string['confirmsubscribe'] = 'האם אתה בטוח כי ברצונך להירשם כמנוי לפורום  \'{$a}\'?';
$string['confirmunsubscribe'] = 'האם אתה בטוח כי ברצונך לבטל את המנוי שלך בפורום  \'{$a}\'?';
$string['couldnotadd'] = 'ההודעה שלך לא פורסמה עקב תקלה בלתי מזוהה';
$string['couldnotdeletereplies'] = 'לצערנו, אין אפשרות למחוק הודעה זו מאחר ומשתמשים אחרים כבר הגיבו אליה';
$string['couldnotupdate'] = 'עדכון ההודעה שלך נכשל עקב בעיה לא מזוהה';
$string['delete'] = 'מחיקה';
$string['deleteddiscussion'] = 'נושא הדיון נמחק';
$string['deletedpost'] = 'הודעה זו נמחקה';
$string['deletedposts'] = 'הודעות אלו נמחקו';
$string['deletesure'] = 'האם אתה בטוח שאתה רוצה למחוק הודעה זו?';
$string['deletesureplural'] = 'האם אתה בטוח שברצונך למחוק הודעה זו ואת כל התגובות עליה? ({$a} תגובות)';
$string['digestmailheader'] = 'זהו לקט ההודעות היומי שלך מפורומי האתר {$a->sitename}. כדי לשנות את העדפותיך בנוגע לשליחת דוא"ל מפורומים, לך ל-{$a->userprefs}.';
$string['digestmailpost'] = 'שינוי לקט מאפייני הפורום שלך';
$string['digestmailprefs'] = 'פרופיל המשתמש שלך';
$string['digestmailsubject'] = '{$a}: לקט פורומים';
$string['digestmailtime'] = 'השעה בה ישלח תקציר הדוא"לים.';
$string['digestsentusers'] = 'לקטי דוא"ל נשלחו בהצלחה ל-{$a} משתמשים.';
$string['disallowsubscribe'] = 'לא ניתן להירשם כמנויים';
$string['disallowsubscribeteacher'] = 'לא ניתן להירשם כמנויים (מלבד מורים)';
$string['discussion'] = 'דיון';
$string['discussionmoved'] = 'דיון זה הועבר ל-\'{$a}\'.';
$string['discussionmovedpost'] = 'דיון זה הועבר ל<a href="{$a->discusshref}">כאן</a> בפורום <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'שם הדיון';
$string['discussions'] = 'דיונים';
$string['discussionsstartedby'] = 'דיונים שנפתחו על ידי {$a}';
$string['discussionsstartedbyrecent'] = 'דיונים שנפתחו לאחרונה על ידי {$a}';
$string['discussionsstartedbyuserincourse'] = 'הדיוק נפתח על-ידי {$a->fullname} בקורס {$a->coursename}';
$string['discussthistopic'] = 'תצוגה מלאה של הדיון והתגובות';
$string['displayend'] = 'סוף התצוגה';
$string['displayend_help'] = '<p align="center"><b>תקופת תצוגה בפורום</b></p>

<p>אתם יכולים לבחור אם הפירסום שלכם בפורום יוצג החל מתאריך מסויים, עד לתאריך מסויים, או רק לתקופת זמן מוגבלת.</p>

<p>כדי להפעיל את תאריך התחלה ואו סיום התצוגה, בטלו את הבחירה באפשרות(יות) המונעת (מניעה - Disable).</p>

<p>שימו לב לכך שמשתמשים בעלי גישה של מנהל, יוכלו לראות הודעות לפני תאריך השיחרור שלהם ולאחר תאריך הסיום שלהם.
</p>';
$string['displaymode'] = 'מצב תצוגה';
$string['displayperiod'] = 'משך התצוגה';
$string['displaystart'] = 'תחילת התצוגה';
$string['displaystart_help'] = '<p align="center"><b>תקופת תצוגה בפורום</b></p>

<p>אתם יכולים לבחור אם הפירסום שלכם בפורום יוצג החל מתאריך מסויים, עד לתאריך מסויים, או רק לתקופת זמן מוגבלת.</p>

<p>כדי להפעיל את תאריך התחלה ואו סיום התצוגה, בטלו את הבחירה באפשרות(יות) המונעת (מניעה - Disable).</p>

<p>שימו לב לכך שמשתמשים בעלי גישה של מנהל, יוכלו לראות הודעות לפני תאריך השיחרור שלהם ולאחר תאריך הסיום שלהם.
</p>';
$string['displaywordcount'] = 'הצגת ספירת מילים';
$string['displaywordcount_help'] = 'הגדרה זו קובעת האם ספירת המילים של כל פרסום תוצג או לא.';
$string['eachuserforum'] = 'כל אחד מפרסם דיון אחד בלבד';
$string['edit'] = 'עריכה';
$string['editedby'] = 'נערך על ידי {$a->name} - הגשה מקורית: {$a->date}';
$string['editedpostupdated'] = 'הפרסום של {$a} עודכן';
$string['editing'] = 'עריכה';
$string['emaildigest_0'] = 'תקבל דוא"ל אחד לכל פרסום בפורום.';
$string['emaildigest_1'] = 'תקבל לקט אחד של תוכן ההודעות בפורום בכל יום.';
$string['emaildigest_2'] = 'תקבל לקט אחד של נושא ההודעות בפורום בכל יום.';
$string['emaildigestcompleteshort'] = 'פרסומים שהושלמו';
$string['emaildigestdefault'] = 'ברירת מחדל ({$a})';
$string['emaildigestoffshort'] = 'ללא לקט';
$string['emaildigestsubjectsshort'] = 'נושא בלבד';
$string['emaildigesttype'] = 'אפשרויות לקט הודעות בדוא"ל';
$string['emaildigesttype_help'] = 'סוגי ההודעות שתגבל בכל פורום:
* ברירת מחדל- עקוב אחר הגדרות בנוגע להודעות הפורום בפרופיל המשתמש שלך. אם תעדכן את ההגדרה בפרופיל המשתמש השינויים יתעדכנו גם כאן.
*ללא מעקב -  תקבל דוא"ל אחד לכל פרסום בפורום.
*מעקב - לכל הפרסומים בפורום - תקבל דוא"ל יומי אחד של מקבץ של כל תכני הפרסומים בפורום.
*מעקב - לנושאים בלבד - תקבל דוא"ל יומי אחד המכיר רק את הנושא של כל פרסום בפורום.';
$string['emptymessage'] = 'ההודעה שלך אינה תקינה. יתכן שהשארת את ההודעה ריקה או שהקובץ שצירפת גדול מדי. השינויים שלך לא נשמרו.';
$string['erroremptymessage'] = 'הודעת הפרסום איננה יכולה להיות ריקה';
$string['erroremptysubject'] = 'הנושא הפרסום אינו יכול להיות ריק';
$string['errorenrolmentrequired'] = 'עליך להיות רשום בקורס זה בכדי לגשת לתוכן זה';
$string['errorwhiledelete'] = 'חלה שגיאה בעת מחיקת הרשומה.';
$string['everyonecanchoose'] = 'כולם יכולים לבחור להרשם כמנויים לפורום זה';
$string['everyonecannowchoose'] = 'כעת כולם יכולים לבחור להירשם כמנויים';
$string['everyoneisnowsubscribed'] = 'כעת כולם רשומים כמנויים לפורום זה';
$string['everyoneissubscribed'] = 'כולם מנויים לפורום זה';
$string['existingsubscribers'] = 'מנויים קיימים';
$string['exportdiscussion'] = 'יצוא את כל הדיונים';
$string['forcedreadtracking'] = 'לאפשר מעקב קריאה באופן מאולץ';
$string['forcedreadtracking_desc'] = 'לאפשר לפורומים הגדרת מעקב קריאה מואלץ. הדבר יגרום לביצועים נמוכים למשתמשים מסויימים, במיוחד לקורסים בעלי פורומים ופרסומים רבים. כשזה כבוי כל פורום שהוגדר קודם לכן כמאולץ יוחס כעת כאפשרות בחירה.';
$string['forcessubscribe'] = 'בפורום זה כולם מנויים';
$string['forum'] = 'פורום';
$string['forum:addinstance'] = 'הוספת פורום חדש';
$string['forum:addnews'] = 'הוסף חדשות';
$string['forum:addquestion'] = 'הוספת שאלה';
$string['forum:allowforcesubscribe'] = 'אפשר רישום מאולץ';
$string['forumauthorhidden'] = 'מחבר (מוסתר)';
$string['forumblockingalmosttoomanyposts'] = 'אתה מתקרב לסף פירסום ההודעות. פירסמת הודעות {$a->numposts} פעמים ב-{$a->blockperiod} האחרונים, והגבול הוא {$a->blockafter}.';
$string['forumbodyhidden'] = 'לא ניתן לראות את תוכן תגובה זו, כנראה מפני שטרם פירסמת תגובה בעצמך בדיון זה או שזמן עריכת ההודעה פג.';
$string['forum:createattachment'] = 'צור קבצים מצורפים';
$string['forum:deleteanypost'] = 'מחק כל הודעה שהיא (בכל עת)';
$string['forum:deleteownpost'] = 'מחק את ההודעות שלי (תוך המועד הסופי)';
$string['forum:editanypost'] = 'עריכת כל הודעה';
$string['forum:exportdiscussion'] = 'יצוא את כל הדיונים';
$string['forum:exportownpost'] = 'יצא את פרסום ההודעה שלך בפורום';
$string['forum:exportpost'] = 'יצוא פרסום הודעת  פורום';
$string['forumintro'] = 'תיאור';
$string['forum:managesubscriptions'] = 'ניהול מנויים';
$string['forum:movediscussions'] = 'הסט דיונים';
$string['forumname'] = 'שם הפורום';
$string['forumposts'] = 'הודעות הפורום';
$string['forum:postwithoutthrottling'] = 'חריגה מסף הפרסום הודעות';
$string['forum:rate'] = 'דרג הודעות';
$string['forum:replynews'] = 'הגב לחדשות';
$string['forum:replypost'] = 'השב להודעות';
$string['forums'] = 'פורומים';
$string['forum:splitdiscussions'] = 'פצל דיונים';
$string['forum:startdiscussion'] = 'התחל בדיונים חדשים';
$string['forumsubjecthidden'] = 'נושא (מוסתר)';
$string['forumtracked'] = 'עוקב אחר הודעות שלא נקראו';
$string['forumtrackednot'] = 'לא עוקב אחר הודעות שלא נקראו';
$string['forumtype'] = 'סוג הפורום';
$string['forumtype_help'] = '<p align="center"><b>סוגי פורומים</b></p>

<p>ישנם מספר סוגי פורום שונים שתוכלו לבחור מהם:</p>

<p><b>דיון יחיד</b> - זהו נושא יחיד, המוצג כולו באותו העמוד. אפשרות זו יעילה לדיונים קצרים וממוקדים. </p>

<p><b> פורום רגיל לשימוש כללי</b> - זהו פורום פתוח, בו כל אחד יכול לפתוח בנושא חדש לדיון, בכל עת. זהו הפורום הטוב ביותר לשימוש-כללי, לכל מטרה שהיא. </p>

<p><b>כל אדם מפרסם דיון אחד</b> - כל אדם יכול לפרסם בדיוק נושא אחד לדיון (אך כולם יכולים להגיב אליו). האפשרות הזו יעילה כשאתם רוצים שכל סטודנט יתחיל בדיון על, למשל, המחשבות שלו לגבי נושא השבוע, ושכל שאר הסטודנטים יגיבו לכך.</p>

<p><b>פורום "כתיבת תשובה נדרשת לצפיה בדיון"</b> - פורום זה דורש מהסטודנטים לפרסם את נקודות המבט שלהם לפני שהם רואים את תוכן התגובות של שאר חבריהם לספסל הלימודים. לאחר פירסום התגובה  הראשונית, הסטודנטים יכולים לראות ולהגיב לפירסומים של אחרים. תכונה זו מאפשרת הזדמנות פירסום ראשוני שווה לכל התלמידים, ובכך מעודדת חשיבה מקורית ועצמאית.  </p>

<p>(פיתוחים נוספים מתוכננים בגירסאות עתידיות של מוודל.)</p>';
$string['forum:viewallratings'] = 'צפה בכל הדירוגי השורה שנתנו על-ידי אנשים';
$string['forum:viewanyrating'] = 'ראה את כל הדירוגים';
$string['forum:viewdiscussion'] = 'ראה דיונים';
$string['forum:viewhiddentimedposts'] = 'ראה הודעות מתוזמנות מוסתרות';
$string['forum:viewqandawithoutposting'] = 'תמיד ראה הודעות \'שאלה ותשובה\' (Q&A)';
$string['forum:viewrating'] = 'ראה את הדירוגים שלי';
$string['forum:viewsubscribers'] = 'ראה מנויים';
$string['generalforum'] = 'פורום רגיל לשימוש כללי';
$string['generalforums'] = 'פורומים כלליים';
$string['hiddenforumpost'] = 'דיון מוסתר בקבוצת הדיון';
$string['inforum'] = 'ב-{$a}';
$string['introblog'] = 'פרסומי הודעות בפורום זה הועתקו לכאן באופן אוטומטי מהבלוגים של המתמשמים בקורס זה מפני שהודעות הבלוג לא זמינות יותר';
$string['intronews'] = 'חדשות כלליות והודעות';
$string['introsocial'] = 'פורום פתוח, לניהול דיונים על כל דבר שתרצה.';
$string['introteacher'] = 'פורום לדיונים והערות בין מורים בלבד';
$string['invalidaccess'] = 'לא ניתן היה לגשת בצורה תקינה לעמוד זה';
$string['invaliddigestsetting'] = 'הגדרת לקט כתובות דוא"ל שגויות סופקה';
$string['invaliddiscussionid'] = 'מספר  הID של הדיון שגוי או שאינו קיים יותר';
$string['invalidforcesubscribe'] = 'מצב מנוי מאולץ';
$string['invalidforumid'] = 'מספר זיהוי הפורום שגוי';
$string['invalidparentpostid'] = 'מספר זיהוי לתגובה מעל שגוי';
$string['invalidpostid'] = 'מספר זיהוי הפרסום שגוי - {$a}';
$string['lastpost'] = 'הודעה אחרונה';
$string['learningforums'] = 'פורומי למידה';
$string['longpost'] = 'פרסום הודעה ארוך';
$string['mailnow'] = 'שלח עכשיו בדוא"ל';
$string['manydiscussions'] = 'דיונים לכל עמוד';
$string['markalldread'] = 'סמן את כל ההודעות בדיון זה כנקראו';
$string['markallread'] = 'סמן את כל ההודעות בפורום זה כנקראו';
$string['markread'] = 'סמן כנקרא';
$string['markreadbutton'] = 'סמן<br />כנקרא';
$string['markunread'] = 'סמן כלא-נקרא';
$string['markunreadbutton'] = 'סמן<br />כלא-נקרא';
$string['maxattachments'] = 'מספר מירבי של צירוף קבצים';
$string['maxattachments_help'] = 'הגדרה זו מציינת את המספר המקסימלי של קבצים אשר ניתן לצרפם לפרסום בפורום.';
$string['maxattachmentsize'] = 'גודל מירבי לקובץ מצורף';
$string['maxattachmentsize_help'] = '<p align="center"><b>גודל מירבי של קובץ מצורף</b></p>

<p>ניתן להגביל את הגודל של הקבצים שניתן לצרף להודעות פורום, את הגודל יכול לבחור האדם שהגדיר את הפורום.</p>

<p>לפעמים ניתן להעלות קובץ שהוא גדול יותר מהגודל המורשה, אבל הקובץ לא יישמר על השרת ובפניכם תופיע הודעת שגיאה.</p>';
$string['maxtimehaspassed'] = 'לצערנו, חלף הזמן המירבי בו ניתן היה לערוך הודעה זו({$a})!';
$string['message'] = 'הודעה';
$string['messageprovider:digests'] = 'מנוי ללקט עדכונים יומי';
$string['messageprovider:posts'] = 'פרסומי פורום של מנויים';
$string['missingsearchterms'] = 'ביטויי החיפוש הבאים מופיעים רק בקוד ה-HTML של הודעה זו:';
$string['modeflatnewestfirst'] = 'הצגת תגובות בצורה שטוחה, החדשות ביותר ראשונות';
$string['modeflatoldestfirst'] = 'הצגת תגובות בצורה שטוחה, הישנות ביותר ראשונות';
$string['modenested'] = 'הצגת תגובות באופן מקונן';
$string['modethreaded'] = 'הצגת תגובות בצורת פתילים';
$string['modulename'] = 'פורום';
$string['modulename_help'] = 'פעילות הפורום (קבוצת־דיון / Forum) מאפשרת למשתתפים לנהל דיונים לא־סינכרוניים. כלומר, דיונים המתרחשים על פני תקופה ממושכת ולא בזמן־אמת.

ישנם מספר סוגי פורום לבחירה, כגון: "פורום פשוט" שבו כל אחד יכול להתחיל דיון חדש בכל עת; פורום שבו כל תלמיד יכול לכתוב רק דיון אחד; או פורום מסוג שאלה - תשובה, שבו תלמידים חייבים קודם לפרסם תגובה, משוב או מאמר, לפני שיוכלו לצפות בהודעות של תלמידים אחרים.
מורה יכול לאפשר צירוף של קבצים מכול סוג לפורום, בין היתר גם תמונות וסרטונים.

משתתפים יכולים להירשם לפעילות פורום, כדי לקבל הודעות על פרסומים חדשים בפורום. המורה יכול להגדיר את מצב המנוי לידני, קבוע או אוטומטי. ואף למנוע את המינוי לחלוטין. במידת הצורך, ניתן לחסום תלמידים מפרסום הודעות העולות במספרן על מספר הודעות נתון ופרק זמן נתון שנקבעו מראש. פעולה זו מונעת מאנשים דומיננטיים להשתלט על דיונים.

הודעות פורום יכולות להיות מדורגות (מתן ניקוד) על ידי מורים או תלמידים (הערכת עמיתים). ניתן לצבור דירוגים, וליצור ציון סופי שיירשם במחברת הציונים.

לפעילות פורום שימושים רבים:

* מרחב חברתי לתלמידים שבו יוכלו להכיר אחד את השני.

* לקבלת הודעות קורס (באמצעות פורום חדשות שבו ההרשמה היא חובה על כל אחד מהמשתתפים).

* לדיון בתכנים הנלמדים בקורס או חומרי קריאה.

* לקבלת המשך מקוון של נושאים אשר הועלו בעבר במפגש פנים אל פנים.

* לדיוני מורים בלבד (באמצעות פורום מוסתר).

* מרכז עזרה של מורים ותלמידים שבו יכולים לתת עצה אחד לשני.

* אזור תמיכה של אחד על אחד לתקשורת בין תלמידים למורים בפרטיות.
 (באמצעות פורום שבו מקיימים קבוצות נפרדות כאשר בכל קבוצה, תלמיד אחד).

* לפעילויות נרחבות. לדוגמה, \'משחקים לגירוי המחשבה\'. לתלמידים שיוכלו להרהר ולהציע פתרונות ל..';
$string['modulenameplural'] = 'פורומים';
$string['more'] = 'עוד';
$string['movedmarker'] = '(הוזז)';
$string['movethisdiscussionto'] = 'העבר דיון זה ל...';
$string['mustprovidediscussionorpost'] = 'עליך לספק מספר ID של הדיון או מספר ID של הפרסום בכדי לייצא';
$string['namenews'] = 'לוח מודעות';
$string['namenews_help'] = '<p>לוח המודעות הינו פורום מיוחד שנוצר אוטומטית עבור כל קורס ועבור העמוד הראשי של האתר ומהווה מקום לפרסום הודעות כלליות. יכול להיות לכם רק לוח מודעות אחד עבור כל קורס.
</p>

<p>בלוק "החדשות האחרונות ביותר" יציג דיונים שארעו לאחרונה בפורום מיוחד זה (אפילו אם תשנו את שמו). מסיבה זו, במידה ואתם משתמשים בבלוק החדשות האחרונות ביותר, מוודל ייצר מחדש את פורום זה באופן אוטומטי.

</p>';
$string['namesocial'] = 'פורום קהילתי, ציבורי';
$string['nameteacher'] = 'פורום מורים';
$string['newforumposts'] = 'הודעות חדשות בפורום';
$string['noattachments'] = 'לא נמצא קובץ מצורף לפרסום זה.';
$string['nodiscussions'] = 'עדיין אין נושאים לדיון בפורום זה.';
$string['nodiscussionsstartedby'] = 'משתמש {$a} זה לא  פתח אף דיון';
$string['nodiscussionsstartedbyyou'] = 'לא פתחת אף דיון עדיין';
$string['noguestpost'] = 'לצערנו, אורחים אינם מורשים לפרסם הודעות.';
$string['noguesttracking'] = 'לצערנו, אורחים אינם יכולים להגדיר אפשרויות מעקב.';
$string['nomorepostscontaining'] = 'לא נמצאו עוד הודעות המכילות את \'{$a}\'';
$string['nonews'] = 'עדיין לא פורסמו חדשות';
$string['noonecansubscribenow'] = 'מנויים לא מאופשרים כעת';
$string['nopermissiontosubscribe'] = 'אין לך הרשאה לצפות במנויי הפורום';
$string['nopermissiontoview'] = 'אין לך הרשאה לצפיה בפרסום הודעת פורום זו';
$string['nopostforum'] = 'מצטערים, אינך רשאי לפרסם בפורום זה.';
$string['noposts'] = 'אין הודעות';
$string['nopostsmadebyuser'] = '{$a} לא פתח עדיין פרסומים';
$string['nopostsmadebyyou'] = 'לא פתחת עדיין פרסומים';
$string['noquestions'] = 'עדיין אין שאלות בפורום זה';
$string['nosubscribers'] = 'עדיין אין מנויים לפורום זה';
$string['notexists'] = 'לא קיימים יותר דיונים';
$string['nothingnew'] = 'שום דבר חדש ל-{$a}';
$string['notingroup'] = 'לצערנו, אך עליך להיות חלק מקבוצה כדי לצפות בפורום זה.';
$string['notinstalled'] = 'רכיב פורום זה איננו מותקן';
$string['notpartofdiscussion'] = 'פרסום זה אינו חלק מהדיון!';
$string['notrackforum'] = 'אל תעקוב אחרי הודעות שלא-נקראו';
$string['noviewdiscussionspermission'] = 'אין לך את ההרשאה לראות את הדיונים שמתקיימים בפורום זה.';
$string['nowallsubscribed'] = 'יש מנויים לכל הפורומים ב- {$a}.';
$string['nowallunsubscribed'] = 'אין מנויים לכל הפורומים ב- {$a}.';
$string['nownotsubscribed'] = '{$a->name} לא יקבל עותקים בדוא"ל מפורום \'{$a->forum}\'.';
$string['nownottracking'] = '{$a->name} אינו עוקב עוד אחרי \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} יקבל עותקים בדוא"ל מפורום \'{$a->forum}\' .';
$string['nowtracking'] = '{$a->name} עוקב כעת אחרי \'{$a->forum}\'.';
$string['numposts'] = '{$a} הודעות';
$string['olderdiscussions'] = 'דיונים ישנים יותר';
$string['oldertopics'] = 'נושאים ישנים יותר לדיון';
$string['oldpostdays'] = 'קרא לאחר מספר ימים';
$string['openmode0'] = 'ללא דיונים, ללא תגובות';
$string['openmode1'] = 'ללא דיונים, אולם מותר להגיב';
$string['openmode2'] = 'מותר לנהל דיונים ולהגיב אליהם';
$string['overviewnumpostssince'] = '{$a} הודעות פורסמו מאז התחברות אחרונה';
$string['overviewnumunread'] = 'סך הכולל {$a} שלא נקראו';
$string['page-mod-forum-discuss'] = 'עמוד דיונים בצורת פתיל של רכיב הפורום';
$string['page-mod-forum-view'] = 'עמוד ראשי של רכיב הפורום';
$string['page-mod-forum-x'] = 'עמוד רכיב פורום כלשהו';
$string['parent'] = 'הצגת הודעה מעל';
$string['parentofthispost'] = 'הצגת ההודעה מעל הודעה זו';
$string['pluginadministration'] = 'ניהול הפורום';
$string['pluginname'] = 'פורום (קבוצת־דיון)';
$string['postadded'] = '<p>הודעתך נוספה בהצלחה.</p>
<p>יש לך {$a} כדי לערוך את הודעתך במידה ותרצה לבצע שינויים.</p>';
$string['postaddedsuccess'] = 'פרסום הודעתך התווסף בהצלחה.';
$string['postaddedtimeleft'] = 'יש לך {$a} לערוך את ההודעה.';
$string['postbyuser'] = '{$a->post} על ידי {$a->user}';
$string['postincontext'] = 'צפה בהודעה זו בהקשר שלה';
$string['postmailinfo'] = 'זהו העתק של הודעה שפורסמה באתר {$a}.

להוספת תגובה דרך האתר, אנא לחץ על קישור זה:';
$string['postmailnow'] = '<p>הודעה זו תישלח באופן מיידי לכל המנויים בפורום.</p>';
$string['postrating1'] = 'לרוב מבוסס היגיון';
$string['postrating2'] = 'היגיון ורגש';
$string['postrating3'] = 'לרוב מבוסס רגש';
$string['posts'] = 'הודעות';
$string['postsmadebyuser'] = 'פרסומים שנוצרו על-ידי {$a}';
$string['postsmadebyuserincourse'] = 'פרסומים שנוצרו על-ידי {$a->fullname} בקורס  {$a->coursename}';
$string['posttoforum'] = 'שליחת הודעה לפורום';
$string['postupdated'] = 'ההודעה שלך עודכנה';
$string['potentialsubscribers'] = 'מנויים אפשריים';
$string['processingdigest'] = 'מכין לקט דוא"ל למשתמש {$a}';
$string['processingpost'] = 'מעבד את ההודעה {$a}';
$string['prune'] = 'פיצול';
$string['prunedpost'] = 'מהודעה זו נוצר דיון חדש';
$string['pruneheading'] = 'פצל את הדיון והעבר הודעה זו לדיון חדש';
$string['qandaforum'] = 'פורום "כתיבת תשובה נדרשת לצפיה בדיון"
(Q&A)';
$string['qandanotify'] = 'זהו פורום מסוג "כתיבת תשובה נדרשת לצפיה בדיון" (Q&A).<br/>
על מנת לראות את תגובות המשתתפים האחרים בפורום, עליך לפרסם תחילה תשובה משלך.';
$string['re'] = 'תשובה ל:';
$string['readtherest'] = 'קרא את שאר הדיון';
$string['replies'] = 'תגובות';
$string['repliesmany'] = '{$a} תגובות עד כה';
$string['repliesone'] = '{$a} תגובה עד כה';
$string['reply'] = 'תגובה';
$string['replyforum'] = 'שלח תגובה לפורום';
$string['replytouser'] = 'השתמש בכתובת דוא"ל בתגובה.';
$string['resetforums'] = 'הסרת כל ההודעות מפורומים מסוגים אלו:';
$string['resetforumsall'] = 'מחק את כל הפרסומים';
$string['resetsubscriptions'] = 'הסרת מינויי הפורום';
$string['resettrackprefs'] = 'מחק את כל מאפייני מעקב הפורום';
$string['rssarticles'] = 'מספר כתבות RSS אחרונות';
$string['rssarticles_help'] = '<p align="center"><b>מספר מאמרי ה-RSS שאירעו לאחרונה</b></p>

<p>אפשרות זו מאפשרת לכם לבחור את מספר המאמרים (טקסטים שנשלחו לקבוצות דיון) שאתם רוצים לכלול בתוך הזנת ה-RSS.
</p>

<p>מספר בין 5 ל-20 צריך להתאים למרבית הפורומים. הגדילו את המספר אם בפורום המדובר משתמשים אנשים רבים מאוד ובתדירות גדולה מאוד. </p>';
$string['rsssubscriberssdiscussions'] = 'הזנות RSS של דיוני הפורום';
$string['rsssubscriberssposts'] = 'פרסומי הזנות RSS';
$string['rsstype'] = 'הזנת RSS עבור פעילות זו';
$string['rsstype_help'] = '<p align="center"><b>הזנת RSS לפורום זה</b></p>

<p>אפשרות זו מאפשרת לכם להפעיל הזנות RSS לפורום זה.</p>

<p>אתם יכולים לבחור בין שני סוגי פורומים:</p>

<ul>
<li><b>דיונים:</b> על ידי שימוש בסוג זה, ההזנות שנוצרות יכילו בתוכן דיונים חדשים בפורום ביחד עם הפירסום הראשוני שלהם.</li>

<li><b>פירסומים:</b>על ידי שימוש בסוג זה, ההזנות שנוצרות יכילו בתוכן כל פירסום חדש בפורום. </li>
</ul>';
$string['search'] = 'חיפוש';
$string['searchdatefrom'] = 'על ההודעות להיות חדשות יותר מ-';
$string['searchdateto'] = 'על ההודעות להיות ישנות יותר מ-';
$string['searchforumintro'] = 'אנא הזן את מילות החיפוש באחד או יותר מהשדות הבאים:';
$string['searchforums'] = 'חיפוש בפורומים';
$string['searchfullwords'] = 'מילים אלו צריכות להופיע כמילים שלמות';
$string['searchnotwords'] = 'מילים אלו לא צריכות להיכלל';
$string['searcholderposts'] = 'עריכת חיפוש בהודעות ישנות יותר...';
$string['searchphrase'] = 'הביטוי המדויק חייב להופיע בהודעה';
$string['searchresults'] = 'תוצאות החיפוש';
$string['searchsubject'] = 'מילים אלו צריכות להופיע בנושא';
$string['searchuser'] = 'שם זה צריך להתאים למחבר ההודעה';
$string['searchuserid'] = 'מספר זיהוי מוודל של כותב ההודעה';
$string['searchwhichforums'] = 'יש לבחור את הפורומים בהם ייערך החיפוש';
$string['searchwords'] = 'מילים אלו יכולות להופיע בכל מקום בהודעה';
$string['seeallposts'] = 'צפה בכל ההודעות שנשלחו על ידי משתמש זה';
$string['shortpost'] = 'פרסום הודעה קצר';
$string['showsubscribers'] = 'הצגת/עריכת מנויים קיימים';
$string['singleforum'] = 'דיון יחיד';
$string['smallmessage'] = 'המשתמש {$a->user} פרסם ב בפורום
{$a->forumname}';
$string['startedby'] = 'נפתח על ידי';
$string['subject'] = 'נושא';
$string['subscribe'] = 'הרשמה לפורום זה';
$string['subscribeall'] = 'רשום את כולם כמנויים לפורום זה';
$string['subscribed'] = 'מצב המנוי הנוכחי שלך <br> (הקליקו לשינוי מצב)';
$string['subscribeenrolledonly'] = 'מצטערים, רק משתמשים רשומים בקורס יכולים להירשם כמנויים בכדי לקבל את הודעות פרסומי הפורום דרך הדוא"ל';
$string['subscribenone'] = 'בטל את המנוי של כולם לפורום זה';
$string['subscribers'] = 'מנויים';
$string['subscribersto'] = 'מנויים ל-\'{$a}\'';
$string['subscribestart'] = 'אני מעוניין לקבל עדכונים של הודעות חדשות מפורום זה לדוא"ל שלי';
$string['subscribestop'] = 'אינני מעוניין לקבל פרסומים של הודעות חדשות מפורום זה לדוא"ל שלי';
$string['subscription'] = 'מנוי';
$string['subscriptionandtracking'] = 'מנויים ומעקב';
$string['subscriptionauto'] = 'מנוי אוטומטי';
$string['subscriptiondisabled'] = 'מנוי אינו זמין';
$string['subscriptionforced'] = 'מנוי מאולץ';
$string['subscription_help'] = '<p align="center"><b>הרשמה לפורום</b></p>

<p>כשאדם נרשם לפורום, הדבר אומר שישלחו אליו בדואר אלקטרוני עותקים של כל פירסום בפורום.
(הודעות דוא"ל נשלחות בערך כ<?php echo $CFG->maxeditingtime/60 ?> דקות לאחר שהפירסום נכתב בראשונה.)</p>

<p>על פי רוב, אנשים יכולים לבחור אם להירשם לפורום או לא.</p>

<p>אך אם המורה מחליט לכפות הרשמה לפורום מסויים, אז אפשרות הבחירה נלקחת מהסטודנטים, וכל אחד בכיתה יקבל עותקים לדואר האלקטרוני שלו. </p>

<p>אפשרות זו יעילה במיוחד בפורום החדשות, ובפורומים בתחילת הקורס (לפני שכולם הבינו איך הם יכולים להירשם לפורומים בעצמם).
</p>';
$string['subscriptionmode'] = 'מצב המנוי';
$string['subscriptionmode_help'] = '<p align="center"><b>הרשמה לפורום</b></p>
<p> כשאדם נרשם לפורום, הדבר אומר כי ישלחו אליו בדואר אלקטרוני עותקים של כל פירסום בפורום. (הודעות הדוא"ל נשלחות בערך כ<!--?php echo $CFG--->maxeditingtime/60 ?> דקות לאחר שהפירסום נכתב בראשונה.)</p>
<p>ישנם 4 אפשרויות למצב רישום לפורום: </p> *מנוי ניתן לבחירה (אפשרי) - לרוב, הסטודנטים יכולים לבחור אם להירשם לפורום או לא על פי רצונם. <br />*מנוי מאולץ - אפשרות זו תאלץ את ההרשמה של הסטודנטים לפורום באופן אוטומטי (אפילו אלו שנרשמים לקורס בזמן מאוחר יותר) ללא התערבותם.<br /> *מנוי אוטומטי- האפשרות הזו רושמת את הסטודנטים לפורום באופן אוטומטי בתחילתו של הקורס ולאחר מכן הסטודנטים יכולים לבחור אם להסיר עצמם מהרישום של הפורום בכל זמן שירצו. <br />*מנוי אינו מאופשר- לא תתאפשר הרשמה לפורום לצורך קבלת הודעות דוא"ל';
$string['subscriptionoptional'] = 'מנוי ניתן לבחירה';
$string['subscriptions'] = 'מנויים';
$string['thisforumisthrottled'] = 'לפורום זה יש הגבלה על מספר ההודעות שניתן לפרסם בתקופת זמן מסויימת - כרגע הגבלה זו נקבעה ל-{$a->blockafter} הודעה(ות) ב-{$a->blockperiod}';
$string['timedposts'] = 'זמן פרסום הודעות';
$string['timestartenderror'] = 'תאריך סוף התצוגה לא יכול להיות מוקדם יותר מתאריך ההתחלה.';
$string['trackforum'] = 'עקוב אחרי הודעות שלא נקראו';
$string['tracking'] = 'עקוב';
$string['trackingoff'] = 'מופסק';
$string['trackingon'] = 'מואלץ';
$string['trackingoptional'] = 'לבחירתכם';
$string['trackingtype'] = 'מעקב קריאה';
$string['trackingtype_help'] = '<p>אם \'קרא מעקב\' עבור הפורום מאופשר, משתמשים יכולים לעקוב, לקרוא ולא לקרוא הודעות (פרסומים) בפורומים ובדיונים. המורה (מרצה) יכול להכריח את סוג המעקב בפורום ע"י הגדרות אלו.</p>

<p>קיימות שלוש בחירות להגדרה זו:</p>
<ul>
<li> "לשיקול המשתמש" (ברירת מחדל): סטודנטים יכולים להפעיל או לכבות את המעקב בפורום ע"י שיקול דעתם.</li>
<li>פעיל: המעקב תמיד פעיל (מאופשר)</li>
<li>כבוי: המעקב תמיד כבוי (אינו-זמין)</li>
</ul>';
$string['unread'] = 'לא נקרא';
$string['unreadposts'] = 'הודעות שלא נקראו';
$string['unreadpostsnumber'] = '{$a} הודעות שלא נקראו';
$string['unreadpostsone'] = 'הודעה אחת שלא נקראה';
$string['unsubscribe'] = 'ביטול קבלת עדכונים מפורום זה';
$string['unsubscribeall'] = 'ביטול קבלת עדכונים מכל הפורומים';
$string['unsubscribeallconfirm'] = 'אתה מנוי ל {$a} פורומים כעת.
האם אתה אכן רוצה לבטל את המנויים מכל הפורומים ולנטרל את מנוי האוטומטי?';
$string['unsubscribealldone'] = 'כל מנויי הפורומים שלך הוסרו, אתה עשוי לקבל הודעות מפורומים עם מנוי ש"נכפה".

אם אין ברצונך לקבל כל דוא"לים משרת זה, יש לעדכן את הגדרת שליחת "הודעות המערכת" תחת הגדרת "הודעות מערכת" המצויה במשבצת ה"הגדרות כלי משתמש".

או להסיר את הדוא"ל שלך מהגדרות המשתמש שלך.
(במידה וזה אפשרי)';
$string['unsubscribeallempty'] = 'אינך מנוי לאף פורום.

אם אין ברצונך לקבל כל דוא"לים משרת זה, יש לעדכן את הגדרת שליחת "הודעות המערכת" תחת הגדרת "הודעות מערכת" המצויה במשבצת ה"הגדרות כלי משתמש".

או להסיר את הדוא"ל שלך מהגדרות המשתמש שלך. (במידה וזה אפשרי)';
$string['unsubscribed'] = 'לא ישלחו אליך עדכונים חדשים מפורום זה';
$string['unsubscribeshort'] = 'ביטול קבלת עדכונים';
$string['usermarksread'] = 'סימן הקריאה של מסר ידני';
$string['viewalldiscussions'] = 'צפה בכל הדיונים';
$string['warnafter'] = 'סף־פרסום הודעות, לפני תצוגת אזהרת "הנך מתקרב לסף פרסום מירבי"';
$string['warnafter_help'] = '<p align="center"><b>פורומים בהם מנהלים את הפירסומים</b></p>

<p>הרעיון שעומד מאחורי ניהול הפירסומים הוא מאוד פשוט. בפני המשתמשים תיחסם האפשרות לפרסם הודעות חדשות בפורום לאחר שהם יעברו מכסה של כמות פרסומים כלשהיא בתקופת זמן מסויימת. ככל שהם יתקרבו לאותה מכסה, המשתמשים יקבלו אזהרה על כך שהם מתקרבים לסף הפירסומים המותר.</p>

<p>קביעה של סף האזהרה ל-0, תבטל את האזהרות. קביעה של סף החסימה ל-0, תבטל את החסימה. אם החסימה מבוטלת, האזהרות תבוטלנה גם הן באופן אוטומטי.</p>

<p>אף אחת מההגדרות הללו לא משפיעה על הפירסומים של המורים.</p>';
$string['warnformorepost'] = 'אזהרה! כבר קיים דיון אחד או יותר בפורום זה - משתמש בחדש ביותר';
$string['yournewquestion'] = 'השאלה החדשה שלך';
$string['yournewtopic'] = 'נושא הדיון החדש שלך';
$string['yourreply'] = 'התגובה שלך';
