<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'he', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'כתובת';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'הוספת/עריכת עוגן';
$string['advanced:backcolor_desc'] = 'בחירת צבע רקע';
$string['advanced:block'] = 'עיצוב';
$string['advanced:blockquote'] = 'קטע ציטוט';
$string['advanced:blockquote_desc'] = 'קטע ציטוט';
$string['advanced:bold_desc'] = 'מודגש (Ctrl+B)';
$string['advanced:bullist_desc'] = 'הוספת/הסרת רשימת תבליטים';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'הוספת סימן';
$string['advanced:cleanup_desc'] = 'ניקוי קוד';
$string['advanced:clipboard_msg'] = 'העתק/גזור/הדבק לא זמינים ב Mozilla וב-Firefox.
      האם ברצונך לקבל מידע נוסף על הנושא?';
$string['advanced:code'] = 'קוד';
$string['advanced:code_desc'] = 'עריכת קוד HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'העתקה';
$string['advanced:custom1_desc'] = 'התיאור שלך כאו';
$string['advanced:cut_desc'] = 'גזירה';
$string['advanced:dd'] = 'הגדרת המושג';
$string['advanced:div'] = 'Div';
$string['advanced_dlg:about_author'] = 'יוצר';
$string['advanced_dlg:about_general'] = 'אודות';
$string['advanced_dlg:about_help'] = 'עזרה';
$string['advanced_dlg:about_license'] = 'רשיון';
$string['advanced_dlg:about_loaded'] = 'תוספות פעילות';
$string['advanced_dlg:about_plugin'] = 'תוספת';
$string['advanced_dlg:about_plugins'] = 'תוספות';
$string['advanced_dlg:about_title'] = 'אודות TinyMCE';
$string['advanced_dlg:about_version'] = 'גירסה';
$string['advanced_dlg:accessibility_help'] = 'עזרה לנגישות';
$string['advanced_dlg:accessibility_usage_title'] = 'שימוש כללי';
$string['advanced_dlg:anchor_invalid'] = 'אנא הגדירו שם עוגן תקין.';
$string['advanced_dlg:anchor_name'] = 'שם העוגן';
$string['advanced_dlg:anchor_title'] = 'הוספה/עריכת עוגן';
$string['advanced_dlg:charmap_title'] = 'בחירת סימן';
$string['advanced_dlg:charmap_usage'] = 'השתמש בחצי ימין ושמאל לניווט';
$string['advanced_dlg:code_title'] = 'עורך ה-HTML';
$string['advanced_dlg:code_wordwrap'] = 'גלישת טקסט';
$string['advanced_dlg:colorpicker_color'] = 'צבע:';
$string['advanced_dlg:colorpicker_name'] = 'שם:';
$string['advanced_dlg:colorpicker_named_tab'] = 'צבעים בעלי שמות';
$string['advanced_dlg:colorpicker_named_title'] = 'צבעים בעלי שמות';
$string['advanced_dlg:colorpicker_palette_tab'] = 'לוח צבעים';
$string['advanced_dlg:colorpicker_palette_title'] = 'לוח צבעים';
$string['advanced_dlg:colorpicker_picker_tab'] = 'בחירת צבע';
$string['advanced_dlg:colorpicker_picker_title'] = 'בחירת צבע';
$string['advanced_dlg:colorpicker_title'] = 'בחירת צבע';
$string['advanced_dlg:image_align'] = 'יישור';
$string['advanced_dlg:image_align_baseline'] = 'קו ההתחלה';
$string['advanced_dlg:image_align_bottom'] = 'קצה התחתון';
$string['advanced_dlg:image_align_left'] = 'שמאל';
$string['advanced_dlg:image_align_middle'] = 'אמצע';
$string['advanced_dlg:image_align_right'] = 'ימין';
$string['advanced_dlg:image_align_textbottom'] = 'קצה התחתון של הטקסט';
$string['advanced_dlg:image_align_texttop'] = 'קצה העליון של הטקסט';
$string['advanced_dlg:image_align_top'] = 'קצה העליון';
$string['advanced_dlg:image_alt'] = 'תיאור';
$string['advanced_dlg:image_border'] = 'עובי קווי הטבלה';
$string['advanced_dlg:image_dimensions'] = 'גודל';
$string['advanced_dlg:image_hspace'] = 'ריווח אופקי';
$string['advanced_dlg:image_list'] = 'רשימה';
$string['advanced_dlg:image_src'] = 'כתובת:';
$string['advanced_dlg:image_title'] = 'הוספה/עריכת תמונה';
$string['advanced_dlg:image_vspace'] = 'ריווח אנכי';
$string['advanced_dlg:invalid_color_value'] = 'קוד בצע לא חוקי';
$string['advanced_dlg:link_is_email'] = 'כתובת ה-URL שהוכנסה היא ככל הנראה כתובת מייל האם ברצונך להוסיף את הקידומת MAILTO הנדרשת?';
$string['advanced_dlg:link_is_external'] = 'כתובת ה-URL שהוכנסה היא ככל הנראה קישור חיצוני האם ברצונך להוסיף את הקידומת http:// הנדרשת?';
$string['advanced_dlg:link_list'] = 'רשימת קישורים';
$string['advanced_dlg:link_target'] = 'יעד';
$string['advanced_dlg:link_target_blank'] = 'פתח קישור בחלון חדש';
$string['advanced_dlg:link_target_same'] = 'פתח קישור באותו חלון';
$string['advanced_dlg:link_title'] = 'הוספה/עריכת קישור';
$string['advanced_dlg:link_titlefield'] = 'כותרת';
$string['advanced_dlg:link_url'] = 'כתובת הקישור';
$string['advanced:dt'] = 'מושג';
$string['advanced:fontdefault'] = 'גופן';
$string['advanced:font_size'] = 'גודל גופן';
$string['advanced:forecolor_desc'] = 'בחירת צבע גופן';
$string['advanced:h1'] = 'כותרת 1';
$string['advanced:h2'] = 'כותרת 2';
$string['advanced:h3'] = 'כותרת 3';
$string['advanced:h4'] = 'כותרת 4';
$string['advanced:h5'] = 'כותרת 5';
$string['advanced:h6'] = 'כותרת 6';
$string['advanced:help_desc'] = 'עזרה';
$string['advanced:hr_desc'] = 'הוספת קו מפריד';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'הוספה/עריכת דף תמונה';
$string['advanced:image_props_desc'] = 'מאפייני התמונה';
$string['advanced:indent_desc'] = 'הזחה קדימה';
$string['advanced:italic_desc'] = 'נטוי (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'מירכוז טקסט';
$string['advanced:justifyfull_desc'] = 'יישור לשני הצדדים';
$string['advanced:justifyleft_desc'] = 'יישור טקסט לשמאל';
$string['advanced:justifyright_desc'] = 'יישור טקסט לימין';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'הוספת/עריכת קישור';
$string['advanced:more_colors'] = 'עוד צבעים';
$string['advanced:newdocument'] = 'האם ברצונך למחוק את כל התוכן?';
$string['advanced:newdocument_desc'] = 'מסמך חדש';
$string['advanced:numlist_desc'] = 'הוספת/הסרת רשימה ממוספרת';
$string['advanced:outdent_desc'] = 'הזחה אחורה';
$string['advanced:paragraph'] = 'פסקה';
$string['advanced:paste_desc'] = 'הדבקה';
$string['advanced:path'] = 'path';
$string['advanced:pre'] = 'Preformatted';
$string['advanced:redo_desc'] = 'חזרה על פעולה (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'הסרת עיצוב';
$string['advanced:rich_text_area'] = 'אזור טקסט עשיר';
$string['advanced:samp'] = 'דוגמת קוד';
$string['advanced:shortcuts_desc'] = 'עזרה לנגישות';
$string['advanced:striketrough_desc'] = 'קו חוצה';
$string['advanced:style_select'] = 'סגנונות';
$string['advanced:sub_desc'] = 'כתב עילי';
$string['advanced:sup_desc'] = 'כתב תחתי';
$string['advanced:toolbar'] = 'סרגל כלים';
$string['advanced:toolbar_focus'] = 'העברה לסרגל הכלים - Alt+Q, העברה למעבד תמלילים - Alt-Z, העברה לנתיב האלמטים - Alt-X';
$string['advanced:underline_desc'] = 'קו תחתון (Ctrl+U)';
$string['advanced:undo_desc'] = 'ביטול פעולה (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'הסרת קישור';
$string['advanced:visualaid_desc'] = 'הצגה או הסתרה של סימוני עיצוב';
$string['advhr:advhr_desc'] = 'קו אופקי';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'רגיל';
$string['advhr_dlg:noshade'] = 'ללא צל';
$string['advhr_dlg:size'] = 'גובה';
$string['advhr_dlg:width'] = 'רוחב';
$string['advhr_dlg:widthunits'] = 'יחידות';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'ישור';
$string['advimage_dlg:align_baseline'] = 'קו בסיסי';
$string['advimage_dlg:align_bottom'] = 'תחתית';
$string['advimage_dlg:align_left'] = 'לשמאל';
$string['advimage_dlg:align_middle'] = 'אמצע';
$string['advimage_dlg:align_right'] = 'ימין';
$string['advimage_dlg:align_textbottom'] = 'טקסט תחתון';
$string['advimage_dlg:align_texttop'] = 'טקסט עליון';
$string['advimage_dlg:align_top'] = 'עליון';
$string['advimage_dlg:alt'] = 'תיאור התמונה';
$string['advimage_dlg:alt_image'] = 'תמונה חליפית';
$string['advimage_dlg:border'] = 'עובי קווי הטבלה';
$string['advimage_dlg:classes'] = 'Classes';
$string['advimage_dlg:constrain_proportions'] = 'שמירה על יחס';
$string['advimage_dlg:dialog_title'] = 'הוספה/עריכת תמונה';
$string['advimage_dlg:dimensions'] = 'מימדים';
$string['advimage_dlg:example_img'] = 'תצוגה מקדימה של התמונה';
$string['advimage_dlg:general'] = 'כללי';
$string['advimage_dlg:height'] = 'גובה';
$string['advimage_dlg:hspace'] = 'ריווח אופקי';
$string['advimage_dlg:id'] = 'Id';
$string['advimage_dlg:image_list'] = 'רשימת תמונות';
$string['advimage_dlg:langcode'] = 'קוד השפה';
$string['advimage_dlg:langdir'] = 'כיוון השפה';
$string['advimage_dlg:list'] = 'רשימת תמונות';
$string['advimage_dlg:long_desc'] = 'תיאור קישור ארוך';
$string['advimage_dlg:ltr'] = 'משמאל לימין';
$string['advimage_dlg:map'] = 'Image map';
$string['advimage_dlg:misc'] = 'שונות';
$string['advimage_dlg:missing_alt'] = 'להמשיך מבלי להוסיף תיאור לתמונה?';
$string['advimage_dlg:mouseout'] = 'הסמן עבר את התמונה';
$string['advimage_dlg:mouseover'] = 'בעת מעבר הסמן על התמונה';
$string['advimage_dlg:preview'] = 'תצוגה מקדימה';
$string['advimage_dlg:rtl'] = 'מימין לשמאל';
$string['advimage_dlg:src'] = 'URL של התמונה';
$string['advimage_dlg:style'] = 'Style';
$string['advimage_dlg:swap_image'] = 'החלפת תמונה';
$string['advimage_dlg:tab_advanced'] = 'מתקדם';
$string['advimage_dlg:tab_appearance'] = 'מראה';
$string['advimage_dlg:tab_general'] = 'כללי';
$string['advimage_dlg:title'] = 'כותרת';
$string['advimage_dlg:vspace'] = 'ריווח אנכי';
$string['advimage_dlg:width'] = 'רוחב';
$string['advimage:image_desc'] = 'הוספה/עריכת תמונה';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Accesskey';
$string['advlink_dlg:advanced_props'] = 'תכונות מתקדמות';
$string['advlink_dlg:advanced_tab'] = 'מתקדם';
$string['advlink_dlg:anchor_names'] = 'קישור עוגנים';
$string['advlink_dlg:classes'] = 'Classes';
$string['advlink_dlg:encoding'] = 'Target character encoding';
$string['advlink_dlg:event_props'] = 'מאורעות';
$string['advlink_dlg:events_tab'] = 'ארועים';
$string['advlink_dlg:general_props'] = 'תכונות כלליות';
$string['advlink_dlg:general_tab'] = 'כללי';
$string['advlink_dlg:height'] = 'גובה';
$string['advlink_dlg:id'] = 'מספר סידורי ID';
$string['advlink_dlg:is_email'] = 'כתובת ה-URL שהוכנסה היא ככל הנראה כתובת מייל האם ברצונך להוסיף את הקידומת MAILTO הנדרשת?';
$string['advlink_dlg:is_external'] = 'כתובת ה-URL שהוכנסה היא ככל הנראה קישור חיצוני האם ברצונך להוסיף את הקידומת http:// הנדרשת?';
$string['advlink_dlg:langcode'] = 'קוד השפה';
$string['advlink_dlg:langdir'] = 'כיוון השפה';
$string['advlink_dlg:link_list'] = 'Link list';
$string['advlink_dlg:list'] = 'רשימת קישורים';
$string['advlink_dlg:ltr'] = 'משמאל לימין';
$string['advlink_dlg:mime'] = 'Target MIME type';
$string['advlink_dlg:popup'] = 'חלון קופץ javascript';
$string['advlink_dlg:popup_dependent'] = 'Dependent (Mozilla/Firefox only)';
$string['advlink_dlg:popup_location'] = 'הצגת location bar';
$string['advlink_dlg:popup_menubar'] = 'הצגת תפריט';
$string['advlink_dlg:popup_name'] = 'שם החלון';
$string['advlink_dlg:popup_opts'] = 'אפשרויות';
$string['advlink_dlg:popup_position'] = 'מיקום (X/Y)';
$string['advlink_dlg:popup_props'] = 'תכונות חלון קופץ';
$string['advlink_dlg:popup_resizable'] = 'חלון דינאמי(resizable)';
$string['advlink_dlg:popup_return'] = 'יש להכניס \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'הצגת פס גלילה';
$string['advlink_dlg:popup_size'] = 'גודל';
$string['advlink_dlg:popup_statusbar'] = 'הצגת שורת מצב';
$string['advlink_dlg:popup_tab'] = 'חלון קופץ';
$string['advlink_dlg:popup_toolbar'] = 'הצגת סרגלי כלים';
$string['advlink_dlg:popup_url'] = 'כתובת URL של החלון קופץ';
$string['advlink_dlg:rel'] = 'Relationship page to target';
$string['advlink_dlg:rev'] = 'Relationship target to page';
$string['advlink_dlg:rtl'] = 'מימין לשמאל';
$string['advlink_dlg:style'] = 'Style';
$string['advlink_dlg:tabindex'] = 'Tabindex';
$string['advlink_dlg:target'] = 'יעד';
$string['advlink_dlg:target_blank'] = 'פתיחה בחלון חדש';
$string['advlink_dlg:target_langcode'] = 'Target language';
$string['advlink_dlg:target_name'] = 'Target name';
$string['advlink_dlg:target_parent'] = 'פתיחת חלון האב/חלון בן';
$string['advlink_dlg:target_same'] = 'פתיחה בחלון חדש/חלון בן';
$string['advlink_dlg:target_top'] = 'פתיחה בחלון הבן הראשי(מחליף את כל חלונות הבנים)';
$string['advlink_dlg:title'] = 'הוספה/עריכת קישור';
$string['advlink_dlg:titlefield'] = 'כותרת הקישור';
$string['advlink_dlg:url'] = 'כתובת הקישור';
$string['advlink_dlg:width'] = 'רוחב';
$string['advlink:link_desc'] = 'הוספת/עריכת קישור';
$string['advlist:circle'] = 'מעגל';
$string['advlist:def'] = 'ברירת מחדל';
$string['advlist:disc'] = 'תיאור';
$string['advlist:lower_alpha'] = 'אלפא נמוכה';
$string['advlist:lower_greek'] = 'יווני נמוך';
$string['advlist:lower_roman'] = 'רומאי נמוך';
$string['advlist:square'] = 'מרובע';
$string['advlist:types'] = 'סוגים';
$string['advlist:upper_alpha'] = 'אלפה עליון';
$string['advlist:upper_roman'] = 'רומאי עליון';
$string['aria:rich_text_area'] = 'אזור טקסט עשיר';
$string['autosave:restore_content'] = 'שחזור תכנים הנשמרים אוטומטית';
$string['autosave:unload_msg'] = 'השינויים שביצעת לא ישמרו אם תעבור מדף זה';
$string['autosave:warning_message'] = 'אם תשמור את התוכן השמור, תאבד את כל התוכן אשר כרגע נמצא בעורך התוכן המעוצב.

האם אתה בטוח כי ברצונך לשחזר את התוכן השמור?';
$string['availablebuttons'] = 'כפתורים זמינים';
$string['colors:000000'] = 'שחור';
$string['colors:000080'] = 'כחול צי';
$string['colors:0000FF'] = 'כחול';
$string['colors:003300'] = 'ירוק כהה';
$string['colors:003366'] = 'תכלת כהה';
$string['colors:008000'] = 'ירוק';
$string['colors:008080'] = 'צהבהב';
$string['colors:00CCFF'] = 'כחול שמיים';
$string['colors:00FF00'] = 'צבע סיד';
$string['colors:333300'] = 'צבע זית כהה';
$string['colors:333333'] = 'אפור כהה מאוד';
$string['colors:3366FF'] = 'כחול מלכותי';
$string['colors:339966'] = 'ירוק ימי';
$string['colors:33CCCC'] = 'טורקיז';
$string['colors:666699'] = 'כחול אפרפר';
$string['colors:800000'] = 'חום ערמונים';
$string['colors:800080'] = 'סגול';
$string['colors:808000'] = 'זית';
$string['colors:808080'] = 'אפור';
$string['colors:993300'] = 'כתום שרוף';
$string['colors:993366'] = 'חום';
$string['colors:999999'] = 'אפור בינוני';
$string['colors:99CC00'] = 'ירוק צהבהב';
$string['colors:99CCFF'] = 'תכלת שמיים';
$string['colors:C0C0C0'] = 'כסף';
$string['colors:CC99FF'] = 'סגול שזיף';
$string['colors:CCFFCC'] = 'ירוק בהיר';
$string['colors:FF0000'] = 'אדום';
$string['colors:FF00FF'] = 'סגלגל';
$string['colors:FF6600'] = 'כתום';
$string['colors:FF9900'] = 'ענבר';
$string['colors:FF99CC'] = 'ורוד';
$string['colors:FFCC00'] = 'זהב';
$string['colors:FFCC99'] = 'אפרסק';
$string['colors:FFFF00'] = 'צהוב';
$string['colors:FFFF99'] = 'צהוב בהיר';
$string['colors:FFFFFF'] = 'לבן';
$string['common:apply'] = 'אישור';
$string['common:browse'] = 'עיון';
$string['common:cancel'] = 'ביטול';
$string['common:class_name'] = 'עיצוב (class)';
$string['common:clipboard_msg'] = 'העתקה/גזירה והדבקה אינם זמינים ב Mozilla וב-Firefox.
        האם ברצונך לקבל מידע נוסף על הנושא?';
$string['common:clipboard_no_support'] = 'כרגע לא נתמך על ידי הדפדפן שלך. השתמש בקיצורי המקלדת.';
$string['common:close'] = 'סגירה';
$string['common:edit_confirm'] = 'ברצונך להשתמש בעורך המתקדם?';
$string['common:insert'] = 'הוספה';
$string['common:invalid_data'] = 'Error: Invalid values entered, these are marked in red.';
$string['common:invalid_data_min'] = '{#field} חייב להיות מספר הגדול מ- {#min}';
$string['common:invalid_data_number'] = '{#field} חייב להיות מספר';
$string['common:invalid_data_size'] = '{#field} חייב להיות מספר או אחוז';
$string['common:more_colors'] = 'צבעים נוספים...';
$string['common:not_set'] = '-- לא הוגדר --';
$string['common:popup_blocked'] = 'חוסם פריטים מוקפצים מנע מחלון חשוב מלהפתח,אם ברצונך להשתמש בכלי זה עליך לבטל את חוסם הפריטים';
$string['common:update'] = 'עדכון';
$string['common:value'] = '(ערך)';
$string['contextmenu:align'] = 'יישור';
$string['contextmenu:center'] = 'אמצע';
$string['contextmenu:full'] = 'שני הצדדים';
$string['contextmenu:left'] = 'שמאל';
$string['contextmenu:right'] = 'ימין';
$string['customconfig'] = 'הגדרה מותאמת';
$string['customtoolbar'] = 'סרגל כלים של העורך';
$string['directionality:ltr_desc'] = 'כיוון טקסט משמאל לימין';
$string['directionality:rtl_desc'] = 'כיוון טקסט מימין לשמאל';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'מגניב';
$string['emotions_dlg:cry'] = 'בוכה';
$string['emotions_dlg:desc'] = 'סמיילים';
$string['emotions_dlg:embarassed'] = 'נבוך';
$string['emotions_dlg:foot_in_mouth'] = 'רגל בפה';
$string['emotions_dlg:frown'] = 'מזעיף את הפה';
$string['emotions_dlg:innocent'] = 'תמים';
$string['emotions_dlg:kiss'] = 'נשיקה';
$string['emotions_dlg:laughing'] = 'צוחק';
$string['emotions_dlg:money_mouth'] = 'כסף';
$string['emotions_dlg:sealed'] = 'אטום';
$string['emotions_dlg:smile'] = 'חיוך';
$string['emotions_dlg:surprised'] = 'מופתע';
$string['emotions_dlg:title'] = 'הוספת סמיילי';
$string['emotions_dlg:tongue_out'] = 'לשון בחוץ';
$string['emotions_dlg:undecided'] = 'הסנני';
$string['emotions_dlg:usage'] = 'השתמש בחצים ימינה ושמאלה כדי לנווט';
$string['emotions_dlg:wink'] = 'קריצה';
$string['emotions_dlg:yell'] = 'צעקה';
$string['emotions:emotions_desc'] = 'סמיילים';
$string['fontselectlist'] = 'רשימת גופנים זמינה';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Document properties';
$string['fullpage_dlg:active_color'] = 'Active color';
$string['fullpage_dlg:add'] = 'Add new element';
$string['fullpage_dlg:add_base'] = 'Base element';
$string['fullpage_dlg:add_comment'] = 'צומת הערות';
$string['fullpage_dlg:add_link'] = 'Link element';
$string['fullpage_dlg:add_meta'] = 'Meta element';
$string['fullpage_dlg:add_script'] = 'Script element';
$string['fullpage_dlg:add_style'] = 'Style element';
$string['fullpage_dlg:add_title'] = 'Title element';
$string['fullpage_dlg:advanced_props'] = 'מתקדם';
$string['fullpage_dlg:advanced_tab'] = 'Advanced';
$string['fullpage_dlg:appearance_bgprops'] = 'Background properties';
$string['fullpage_dlg:appearance_linkprops'] = 'Link colors';
$string['fullpage_dlg:appearance_marginprops'] = 'Body margins';
$string['fullpage_dlg:appearance_style'] = 'Stylesheet and style properties';
$string['fullpage_dlg:appearance_tab'] = 'Appearance';
$string['fullpage_dlg:appearance_textprops'] = 'Text properties';
$string['fullpage_dlg:author'] = 'Author';
$string['fullpage_dlg:base_element'] = 'Base element';
$string['fullpage_dlg:bgcolor'] = 'צבע רקע';
$string['fullpage_dlg:bgimage'] = 'תמונת רקע';
$string['fullpage_dlg:bottom_margin'] = 'Bottom margin';
$string['fullpage_dlg:charset'] = 'Charset';
$string['fullpage_dlg:comment_element'] = 'Comment';
$string['fullpage_dlg:content'] = 'Content';
$string['fullpage_dlg:copyright'] = 'זכות יוצרים';
$string['fullpage_dlg:defer'] = 'Defer';
$string['fullpage_dlg:doctypes'] = 'Doctype';
$string['fullpage_dlg:encoding'] = 'Character encoding';
$string['fullpage_dlg:fontface'] = 'גופן';
$string['fullpage_dlg:font_face'] = 'סוג גופן';
$string['fullpage_dlg:fontsize'] = 'גודל גופן';
$string['fullpage_dlg:font_size'] = 'גודל גופן';
$string['fullpage_dlg:general_props'] = 'כללי';
$string['fullpage_dlg:head_elements'] = 'Head elements';
$string['fullpage_dlg:hover_color'] = 'Hover color';
$string['fullpage_dlg:href'] = 'Href';
$string['fullpage_dlg:hreflang'] = 'Href lang';
$string['fullpage_dlg:info'] = 'Information';
$string['fullpage_dlg:langcode'] = 'קוד השפה';
$string['fullpage_dlg:langdir'] = 'כיוון השפה';
$string['fullpage_dlg:langprops'] = 'Language and encoding';
$string['fullpage_dlg:language'] = 'שפה';
$string['fullpage_dlg:left_margin'] = 'Left margin';
$string['fullpage_dlg:link_color'] = 'צבע קישור';
$string['fullpage_dlg:link_element'] = 'Link element';
$string['fullpage_dlg:ltr'] = 'משמאל לימין';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Description';
$string['fullpage_dlg:meta_element'] = 'Meta element';
$string['fullpage_dlg:meta_index_follow'] = 'Index and follow the links';
$string['fullpage_dlg:meta_index_nofollow'] = 'Index and don\'t follow the links';
$string['fullpage_dlg:meta_keywords'] = 'Keywords';
$string['fullpage_dlg:meta_noindex_follow'] = 'Do not index but follow the links';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Do not index and don\'t follow the links';
$string['fullpage_dlg:meta_props'] = 'Meta information';
$string['fullpage_dlg:meta_robots'] = 'Robots';
$string['fullpage_dlg:meta_tab'] = 'כללי';
$string['fullpage_dlg:meta_title'] = 'כותרת';
$string['fullpage_dlg:movedown'] = 'Move selected element down';
$string['fullpage_dlg:moveup'] = 'Move selected element up';
$string['fullpage_dlg:name'] = 'Name';
$string['fullpage_dlg:properties'] = 'Properties';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Remove selected element';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'שולים ימניים';
$string['fullpage_dlg:rtl'] = 'מימין לשמאל';
$string['fullpage_dlg:script_element'] = 'Script element';
$string['fullpage_dlg:src'] = 'קוד מקור (Source)';
$string['fullpage_dlg:style'] = 'Style';
$string['fullpage_dlg:style_element'] = 'Style element';
$string['fullpage_dlg:stylesheet'] = 'Stylesheet';
$string['fullpage_dlg:target'] = 'יעד';
$string['fullpage_dlg:textcolor'] = 'צבע';
$string['fullpage_dlg:text_color'] = 'צבע טקסט';
$string['fullpage_dlg:title'] = 'Document properties';
$string['fullpage_dlg:title_element'] = 'Title element';
$string['fullpage_dlg:top_margin'] = 'Top margin';
$string['fullpage_dlg:type'] = 'Type';
$string['fullpage_dlg:value'] = 'ערך';
$string['fullpage_dlg:visited_color'] = 'Visited color';
$string['fullpage_dlg:xml_pi'] = 'XML declaration';
$string['fullscreen:desc'] = 'מעבר למסך מלא/חלקי';
$string['iespell:download'] = 'לא נמצא ieSpell. האם ברצונך להתקין?';
$string['iespell:iespell_desc'] = 'בדיקת איות';
$string['insertdatetime:date_fmt'] = '%d-%m-%Y';
$string['insertdatetime:day_long'] = 'יום ראשון,יום שני,יום שלישי,יום רביעי,יום חמישי,יום שיש,יום שבת,יום ראשון';
$string['insertdatetime:day_short'] = 'יום א\',יום ב\',יום ג\',יום ד\',יום ה\',יום ו\',שבת,יום א\'';
$string['insertdatetime:insertdate_desc'] = 'הוספת תאריך';
$string['insertdatetime:inserttime_desc'] = 'הוספת זמן';
$string['insertdatetime:months_long'] = 'ינואר,פברואר,מרץ,אפריל,מאי,יונע,יולי,אוגוסט,ספטמבר,אוקטובר,נובמבר,דצמבר';
$string['insertdatetime:months_short'] = 'ינואר,פברואר,מרץ,אפריל,מאי,יונע,יולי,אוגוסט,ספטמבר,אוקטובר,נובמבר,דצמבר';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'בחירת מיקום מוחלט';
$string['layer:backward_desc'] = 'העברה אחורה';
$string['layer:content'] = 'שכבה חדשה...';
$string['layer:forward_desc'] = 'העברה קדימה';
$string['layer:insertlayer_desc'] = 'הוספת שכבה חדשה';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'הוספת/עריכת סרטון';
$string['media_dlg:advanced'] = 'מתקדם';
$string['media_dlg:align'] = 'Align';
$string['media_dlg:align_bottom'] = 'Bottom';
$string['media_dlg:align_bottom_left'] = 'שמאלה ומטה';
$string['media_dlg:align_bottom_right'] = 'ימינה ומטה';
$string['media_dlg:align_center'] = 'Center';
$string['media_dlg:align_left'] = 'לשמאל';
$string['media_dlg:align_right'] = 'ימין';
$string['media_dlg:align_top'] = 'Top';
$string['media_dlg:align_top_left'] = 'שמאלה ומעלה';
$string['media_dlg:align_top_right'] = 'ימינה ומעלה';
$string['media_dlg:altsource1'] = 'מקור חלופי 1';
$string['media_dlg:altsource2'] = 'מקור חלופי 2';
$string['media_dlg:audio'] = 'שמע HTML5';
$string['media_dlg:autogotourl'] = 'Auto goto URL';
$string['media_dlg:autohref'] = 'AutoHREF';
$string['media_dlg:autostart'] = 'Auto start';
$string['media_dlg:balance'] = 'Balance';
$string['media_dlg:base'] = 'Base';
$string['media_dlg:baseurl'] = 'Base URL';
$string['media_dlg:bgcolor'] = 'צבע רקע';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Captioning id';
$string['media_dlg:center'] = 'מרכז';
$string['media_dlg:class_name'] = 'עיצוב (class)';
$string['media_dlg:console'] = 'Console';
$string['media_dlg:constrain_proportions'] = 'שמור על פרופורציות';
$string['media_dlg:controller'] = 'Controller';
$string['media_dlg:controls'] = 'Controls';
$string['media_dlg:correction'] = 'No correction';
$string['media_dlg:currentmarker'] = 'Current marker';
$string['media_dlg:currentposition'] = 'Current position';
$string['media_dlg:defaultframe'] = 'Default frame';
$string['media_dlg:embeddedaudio'] = 'שמע מוטמע';
$string['media_dlg:embedded_audio_options'] = 'אפשרויות שמע מוטמע';
$string['media_dlg:enabled'] = 'Enabled';
$string['media_dlg:enablejavascript'] = 'Enable JavaScript';
$string['media_dlg:endtime'] = 'End time';
$string['media_dlg:file'] = 'כתובת הקובץ';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'אפשרויות פלאש';
$string['media_dlg:flashvars'] = 'Flashvars';
$string['media_dlg:fullscreen'] = 'מסך מלא';
$string['media_dlg:general'] = 'כללי';
$string['media_dlg:hidden'] = 'Hidden';
$string['media_dlg:href'] = 'Href';
$string['media_dlg:hspace'] = 'ריווח אופקי';
$string['media_dlg:html5_audio_options'] = 'אפשרויות שמע';
$string['media_dlg:html5_video_options'] = 'אפשרויות וידאו HTML5';
$string['media_dlg:id'] = 'Id';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Image status';
$string['media_dlg:invokeurls'] = 'Invoke URLs';
$string['media_dlg:kioskmode'] = 'Kiosk mode';
$string['media_dlg:list'] = 'רשימה';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'נגינה מחזורית';
$string['media_dlg:maintainaspect'] = 'Maintain aspect';
$string['media_dlg:menu'] = 'הצגת תפריט';
$string['media_dlg:mute'] = 'Mute';
$string['media_dlg:name'] = 'Name';
$string['media_dlg:nojava'] = 'No java';
$string['media_dlg:numloop'] = 'Num loops';
$string['media_dlg:play'] = 'נגינה אוטומטית עם הטעינה';
$string['media_dlg:playcount'] = 'Play count';
$string['media_dlg:playeveryframe'] = 'Play every frame';
$string['media_dlg:prefetch'] = 'Prefetch';
$string['media_dlg:preload'] = 'טעינה מקדימה';
$string['media_dlg:preload_auto'] = 'תן לדפדפן המשתמש לקבוע';
$string['media_dlg:preload_metadata'] = 'טעינה מוקדמת של מטהדאטה של וידאו';
$string['media_dlg:preload_none'] = 'ללא טעינה מוקדמת';
$string['media_dlg:preview'] = 'תצוגה מקדימה';
$string['media_dlg:progress'] = 'Progress';
$string['media_dlg:qt_options'] = 'אפשרויות Quicktime';
$string['media_dlg:qtsrc'] = 'QT Src';
$string['media_dlg:qtsrcchokespeed'] = 'Choke speed';
$string['media_dlg:qt_stream_warn'] = 'משאבי זרימת וידאו של RTSP אמורים להתווסף שדה ה-QT Src תחת לשונית המתקדם.
כדאי גם להוסיף גרסה שאינה בזרימת וידאו לשדה ה-QT Src..';
$string['media_dlg:quality'] = 'איכות הסרטון';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'אפשרויות נגן Real Media';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Scale';
$string['media_dlg:scriptcallbacks'] = 'Script callbacks';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'אפשרויות Shockwave';
$string['media_dlg:shuffle'] = 'Shuffle';
$string['media_dlg:size'] = 'רוחב וגובה';
$string['media_dlg:sound'] = 'צליל';
$string['media_dlg:source'] = 'מקור';
$string['media_dlg:starttime'] = 'Start time';
$string['media_dlg:stretchtofit'] = 'Stretch to fit';
$string['media_dlg:swstretchhalign'] = 'Stretch H-Align';
$string['media_dlg:swstretchstyle'] = 'Stretch style';
$string['media_dlg:swstretchvalign'] = 'Stretch V-Align';
$string['media_dlg:target'] = 'Target';
$string['media_dlg:targetcache'] = 'Target cache';
$string['media_dlg:title'] = 'הוספת/עריכת סרטון';
$string['media_dlg:type'] = 'סוג';
$string['media_dlg:uimode'] = 'UI Mode';
$string['media_dlg:video'] = 'וידאו HTML5';
$string['media_dlg:volume'] = 'Volume';
$string['media_dlg:vspace'] = 'ריווח אנכי';
$string['media_dlg:windowlessvideo'] = 'Windowless video';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'אפשרויות  Media Player';
$string['media:edit'] = 'עריכת סרטון';
$string['nonbreaking:nonbreaking_desc'] = 'הוספת רווח';
$string['pagebreak:desc'] = 'הוספת מעבר דף';
$string['paste_dlg:text_linebreaks'] = 'השאר את שורות הרווח';
$string['paste_dlg:text_title'] = 'הדביקו בחלון זה את הטקסט באמצעות המקשים CTRL+V.';
$string['paste_dlg:word_title'] = 'הדביקו בחלון זה את הטקסט באמצעות המקשים CTRL+V.';
$string['paste:paste_text_desc'] = 'הדבקה כטקסט בלבד';
$string['paste:paste_word_desc'] = 'הדבקה מ-WORD';
$string['paste:plaintext_mode'] = 'הדבקה כעת במצב טקסט פשוט.
הקלק שוב לחזור למצבהדבקה רגיל.';
$string['paste:plaintext_mode_stick'] = 'הדבקה כעת במצב של טקסט פשוט. לחיצה נוספת לחזיר למצב הדבקה רגילה';
$string['paste:selectall_desc'] = 'בחר הכל';
$string['pluginname'] = 'עורך התוכן המעוצב TinyMCE';
$string['preview:preview_desc'] = 'תצוגה מקדימה';
$string['print:print_desc'] = 'הדפסה';
$string['save:cancel_desc'] = 'ביטול כל השינוים';
$string['save:save_desc'] = 'שמירה';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'כל פריטי החיפוש הוחלפו';
$string['searchreplace_dlg:direction'] = 'כיוון';
$string['searchreplace_dlg:down'] = 'למטה';
$string['searchreplace_dlg:findnext'] = 'חפש את הבא';
$string['searchreplace_dlg:findwhat'] = 'לחפש את';
$string['searchreplace_dlg:mcase'] = 'התאם אותיות רישיות';
$string['searchreplace_dlg:notfound'] = 'החיפוש הסתיים. פריט החיפוש לא נמצא.';
$string['searchreplace_dlg:replace'] = 'החלפה';
$string['searchreplace_dlg:replaceall'] = 'החלפת הכל';
$string['searchreplace_dlg:replace_title'] = 'חיפוש והחלפה';
$string['searchreplace_dlg:replacewith'] = 'להחליף ב';
$string['searchreplace_dlg:searchnext_desc'] = 'חיפוש הבא';
$string['searchreplace_dlg:search_title'] = 'חיפוש';
$string['searchreplace_dlg:up'] = 'למעלה';
$string['searchreplace:replace_desc'] = 'חיפוש/החלפה';
$string['searchreplace:search_desc'] = 'חיפוש';
$string['settings'] = 'הגדרות כלליות';
$string['simple:bold_desc'] = 'מודגש (Ctrl+B)';
$string['simple:bullist_desc'] = 'הוספה/הסרת תבליטים';
$string['simple:cleanup_desc'] = 'ניקוי קוד';
$string['simple:italic_desc'] = 'נטוי (Ctrl+I)';
$string['simple:numlist_desc'] = 'הוספה/הסרת מספור';
$string['simple:redo_desc'] = '(Ctrl+Y)';
$string['simple:striketrough_desc'] = 'קו חוצה';
$string['simple:underline_desc'] = 'קו תחתון (Ctrl+U)';
$string['simple:undo_desc'] = 'ביטול פעולה (Ctrl+Z)';
$string['spellchecker:desc'] = 'הפעלת בודק איות';
$string['spellchecker:ignore_word'] = 'להתעלם מהמילה';
$string['spellchecker:ignore_words'] = 'להתעלם מהכל';
$string['spellchecker:langs'] = 'שפות';
$string['spellchecker:menu'] = 'הגדרות בודק איות';
$string['spellchecker:no_mpell'] = 'לא נמצאו שגיאות איות';
$string['spellchecker:no_sug'] = 'אין הצעות';
$string['spellchecker:sug'] = 'הצעות';
$string['spellchecker:wait'] = 'נא להמתין..';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'עדכון הגדרות CSS';
$string['style_dlg:apply'] = 'החל';
$string['style_dlg:background'] = 'רקע';
$string['style_dlg:background_attachment'] = 'קבצים מצורפים';
$string['style_dlg:background_color'] = 'צבע רקע';
$string['style_dlg:background_hpos'] = 'מיקום אופקי';
$string['style_dlg:background_image'] = 'תמונת רקע';
$string['style_dlg:background_repeat'] = 'חזור';
$string['style_dlg:background_tab'] = 'רקע';
$string['style_dlg:background_vpos'] = 'מיקום רוחבי';
$string['style_dlg:block'] = 'בלוק';
$string['style_dlg:block_display'] = 'הצגה';
$string['style_dlg:block_letterspacing'] = 'מרחק בין אותיות';
$string['style_dlg:block_tab'] = 'חסימה';
$string['style_dlg:block_text_align'] = 'מיקום התוכן';
$string['style_dlg:block_text_indent'] = 'הזחת התוכן';
$string['style_dlg:block_vertical_alignment'] = 'Vertical alignment';
$string['style_dlg:block_whitespace'] = 'Whitespace';
$string['style_dlg:block_wordspacing'] = 'מרחק בין מילים';
$string['style_dlg:border'] = 'עובי קווי הטבלה';
$string['style_dlg:border_tab'] = 'עובי קווי הטבלה';
$string['style_dlg:bottom'] = 'תחתית';
$string['style_dlg:box_clear'] = 'ניקוי';
$string['style_dlg:box_float'] = 'יישור';
$string['style_dlg:box_height'] = 'גובה';
$string['style_dlg:box_tab'] = 'משבצת';
$string['style_dlg:box_width'] = 'רוחב';
$string['style_dlg:bullet_image'] = 'Bullet image';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'צבע';
$string['style_dlg:height'] = 'גובה';
$string['style_dlg:left'] = 'שמאל';
$string['style_dlg:list'] = 'רשימה';
$string['style_dlg:list_tab'] = 'רשימה';
$string['style_dlg:list_type'] = 'סוג';
$string['style_dlg:margin'] = 'Margin';
$string['style_dlg:overflow'] = 'Overflow';
$string['style_dlg:padding'] = 'Padding';
$string['style_dlg:placement'] = 'מיקום';
$string['style_dlg:position'] = 'מיקום';
$string['style_dlg:positioning_tab'] = 'מיקום';
$string['style_dlg:positioning_type'] = 'סוג';
$string['style_dlg:right'] = 'ימין';
$string['style_dlg:same'] = 'אותו דבר עבור כולם';
$string['style_dlg:style'] = 'סגנון';
$string['style_dlg:text'] = 'טקסט';
$string['style_dlg:text_blink'] = 'blink';
$string['style_dlg:text_case'] = 'Case';
$string['style_dlg:text_color'] = 'צבע';
$string['style_dlg:text_decoration'] = 'עיצוב';
$string['style_dlg:text_font'] = 'גופן';
$string['style_dlg:text_lineheight'] = 'גובה שורה';
$string['style_dlg:text_none'] = 'ללא';
$string['style_dlg:text_overline'] = 'שורה מעל';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'גודל';
$string['style_dlg:text_striketrough'] = 'קו חוצה';
$string['style_dlg:text_style'] = 'סגנון';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'שורה מתחת';
$string['style_dlg:text_variant'] = 'Variant';
$string['style_dlg:text_weight'] = 'Weight';
$string['style_dlg:title'] = 'עדכון הגדרות CSS';
$string['style_dlg:top'] = 'עליון';
$string['style_dlg:visibility'] = 'Visibility';
$string['style_dlg:width'] = 'רוחב';
$string['style_dlg:zindex'] = 'Z-index';
$string['subplugintype_tinymce'] = 'תוסף';
$string['subplugintype_tinymce_plural'] = 'תוספים';
$string['table:cell'] = 'תא';
$string['table:cell_desc'] = 'תכונות תא בטבלה';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'עמודה';
$string['table:col_after_desc'] = 'הכנסת עמודה משמאל';
$string['table:col_before_desc'] = 'הכנסת עמודה מימין';
$string['table:copy_row_desc'] = 'העתקת שורה בטבלה';
$string['table:cut_row_desc'] = 'גזירת שורה בטבלה';
$string['table:del'] = 'מחיקת טבלה';
$string['table:delete_col_desc'] = 'מחיקת עמודה';
$string['table:delete_row_desc'] = 'מחיקת שורה';
$string['table:desc'] = 'הכנסת טבלה חדשה';
$string['table_dlg:advanced_props'] = 'תכונות מתקדמות';
$string['table_dlg:advanced_tab'] = 'מתקדם';
$string['table_dlg:align'] = 'ישור אופקי';
$string['table_dlg:align_bottom'] = 'תחתית';
$string['table_dlg:align_default'] = 'Default';
$string['table_dlg:align_left'] = 'לשמאל';
$string['table_dlg:align_middle'] = 'אמצע';
$string['table_dlg:align_right'] = 'לימין';
$string['table_dlg:align_top'] = 'עליון';
$string['table_dlg:bgcolor'] = 'צבע הרקע';
$string['table_dlg:bgimage'] = 'תמונת רקע';
$string['table_dlg:border'] = 'עובי קווי הטבלה';
$string['table_dlg:bordercolor'] = 'צבע קווי הטבלה';
$string['table_dlg:caption'] = 'כותרת הטבלה';
$string['table_dlg:cell_all'] = 'עדכון כל תאי הטבלה';
$string['table_dlg:cell_cell'] = 'עדכון תא נוכחי';
$string['table_dlg:cell_col'] = 'עדכון כל התאים בעמודה';
$string['table_dlg:cell_limit'] = 'חריגה ממספר המירבי של התאים בטבלה של {$cells}.';
$string['table_dlg:cellpadding'] = 'ריווח פנימי';
$string['table_dlg:cell_row'] = 'עדכון כל תאי השורה';
$string['table_dlg:cellspacing'] = 'ריווח בין תאים';
$string['table_dlg:cell_title'] = 'תכונות תא בטבלה';
$string['table_dlg:cell_type'] = 'סגנון התא';
$string['table_dlg:colgroup'] = 'קבוצת עמודה';
$string['table_dlg:col_limit'] = 'חריגה ממספר העמודות המירבי של {$cols}.';
$string['table_dlg:cols'] = 'עמודות';
$string['table_dlg:frame'] = 'Frame';
$string['table_dlg:frame_all'] = 'הכול';
$string['table_dlg:frame_cols'] = 'עמודות';
$string['table_dlg:frame_groups'] = 'קבוצות';
$string['table_dlg:frame_none'] = 'none';
$string['table_dlg:frame_rows'] = 'שורות';
$string['table_dlg:general_props'] = 'תכונות כלליות';
$string['table_dlg:general_tab'] = 'כללי';
$string['table_dlg:height'] = 'גובה';
$string['table_dlg:id'] = 'Id';
$string['table_dlg:langcode'] = 'קוד השפה';
$string['table_dlg:langdir'] = 'כיוון השפה';
$string['table_dlg:ltr'] = 'משמאל לימין';
$string['table_dlg:merge_cells_title'] = 'אחד תאים בטבלה';
$string['table_dlg:mime'] = 'Target MIME type';
$string['table_dlg:missing_scope'] = 'Are you sure you want to continue without specifying a scope for this table header cell. Without it, it may be difficult for some users with disabilities to understand the content or data displayed of the table.';
$string['table_dlg:row_all'] = 'עדכוןכל השורות בטבלה';
$string['table_dlg:row_even'] = 'עדכון שורות זוגיות בטבלה';
$string['table_dlg:rowgroup'] = 'שורות';
$string['table_dlg:row_limit'] = 'חריגה ממספר המירבי של השורות של {$rows}.';
$string['table_dlg:row_odd'] = 'עדכון שורות אי-זוגיות בטבלה';
$string['table_dlg:row_row'] = 'עדכון שורה נוכחית';
$string['table_dlg:rows'] = 'שורות';
$string['table_dlg:row_title'] = 'תכונות שורה בטבלה';
$string['table_dlg:rowtype'] = 'סוג השורה בטבלה';
$string['table_dlg:rtl'] = 'מימין לשמאל';
$string['table_dlg:rules'] = 'קווי הפרדה (rules)';
$string['table_dlg:rules_above'] = 'מעל';
$string['table_dlg:rules_below'] = 'מתחת';
$string['table_dlg:rules_border'] = 'עובי קווי הטבלה';
$string['table_dlg:rules_box'] = 'box';
$string['table_dlg:rules_hsides'] = 'hsides';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'void';
$string['table_dlg:rules_vsides'] = 'vsides';
$string['table_dlg:scope'] = 'עבור';
$string['table_dlg:style'] = 'Style';
$string['table_dlg:summary'] = 'תמצית';
$string['table_dlg:tbody'] = 'Body';
$string['table_dlg:td'] = 'תא מידע';
$string['table_dlg:tfoot'] = 'Footer';
$string['table_dlg:th'] = 'כותרת';
$string['table_dlg:thead'] = 'Header';
$string['table_dlg:title'] = 'הוספת/עריכת טבלה';
$string['table_dlg:valign'] = 'ישור אנכי';
$string['table_dlg:width'] = 'רוחב';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'איחוד תאים בטבלה';
$string['table:paste_row_after_desc'] = 'הדבקת שורה בטבלה אחרי';
$string['table:paste_row_before_desc'] = 'הדבקת שורה בטבלה לפני';
$string['table:props_desc'] = 'תכונות הטבלה';
$string['table:row'] = 'שורה';
$string['table:row_after_desc'] = 'הכנסת שורה מתחת';
$string['table:row_before_desc'] = 'הכנסת שורה מעל';
$string['table:row_desc'] = 'תכונות שורה בטבלה';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'פיצול תאים בטבלה';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Insert predefined template content';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'ראשון,שני,שלישי,רביעי,חמישי,שישי,שבת';
$string['template_dlg:day_short'] = 'ראשון,שני,שלישי,רביעי,חמישי,שישי,שבת';
$string['template_dlg:desc'] = 'Insert predefined template content';
$string['template_dlg:desc_label'] = 'תיאור';
$string['template_dlg:label'] = 'Template';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'January,February,March,April,May,June,July,August,September,October,November,December';
$string['template_dlg:months_short'] = 'Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec';
$string['template_dlg:preview'] = 'תצוגה מקדימה';
$string['template_dlg:select'] = 'Select a template';
$string['template_dlg:title'] = 'Templates';
$string['template_dlg:warning'] = 'Warning: Updating a template with a different one may cause data loss.';
$string['visualblocks:desc'] = 'הצג/הסתר רכיבי בלוק';
$string['visualchars:desc'] = 'Visual control characters on/off.';
$string['wordcount:words'] = 'מילים:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abbreviation';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acronym';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Insert/Edit Attributes';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citation';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Deletion';
$string['xhtmlxtras_dlg:attribs_title'] = 'הכנסת/עדכון תכונות';
$string['xhtmlxtras_dlg:attrib_tab'] = 'תכונות';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'תכונות';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'אירועים';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'ציטוט';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'עיצוב (class)';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'תאריך/זמן';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'שפה';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'כיוון הטקסט';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Style';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'כותרת';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'משמאל לימין';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'מימין לשמאל';
$string['xhtmlxtras_dlg:events_tab'] = 'אירועים';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'תכונות האלמנט';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'אירועי האלמנט';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'הגדרות כלליות';
$string['xhtmlxtras_dlg:general_tab'] = 'כללי';
$string['xhtmlxtras_dlg:insert_date'] = 'הכנסת זמן/תאריך נוכחי';
$string['xhtmlxtras_dlg:option_ltr'] = 'משמאל לימין';
$string['xhtmlxtras_dlg:option_rtl'] = 'מימין לשמאל';
$string['xhtmlxtras_dlg:remove'] = 'הסרת';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'קיצור אלמנט';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'ראשי תיבות האלמנט';
$string['xhtmlxtras_dlg:title_cite_element'] = 'ציטוט אלמנט';
$string['xhtmlxtras_dlg:title_del_element'] = 'מחיקת אלמנט';
$string['xhtmlxtras_dlg:title_ins_element'] = 'הכנסת אלמנט';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Insertion';
