<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   webservice
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Iznimka kontrole pristupa';
$string['actwebserviceshhdr'] = 'Aktivni protokoli web servisa';
$string['addaservice'] = 'Dodaj servis';
$string['addcapabilitytousers'] = 'Provjeri sposobnosti korisnika';
$string['addcapabilitytousersdescription'] = 'Korisnici bi trebali imati dvije sposobnosti - webservice:createtoken i mogućnost koja odgovara protokolu koji se koristi, npr. webservice/rest:use, webservice/soap:use. Kako bi to postigli, stvorite ulogu za web servis s odgovarajućim sposobnostima i dodijelite ju korisniku stvorenom za web servis kao ulogu na razini sustava.';
$string['addfunction'] = 'Dodaj funkciju';
$string['addfunctionhelp'] = 'Odaberite funkciju koju želite dodati servisu.';
$string['addfunctions'] = 'Dodaj funkcije';
$string['addfunctionsdescription'] = 'Odaberite neophodne funkcije za novo-stvoreni servis.';
$string['addrequiredcapability'] = 'Dodijeli/ukloni navedenu sposobnost';
$string['addservice'] = 'Dodaj novi servis: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Dodaj funkcije servisu "{$a}"';
$string['allusers'] = 'Svi korisnici';
$string['amftestclient'] = 'AMF probni klijent';
$string['apiexplorer'] = 'API explorer';
$string['apiexplorernotavalaible'] = 'API explorer nije dostupan.';
$string['arguments'] = 'Argumenti';
$string['authmethod'] = 'Vrsta autentikacije';
$string['cannotcreatetoken'] = 'Nema ovlasti za stvaranje tokena web servisa za servis {$a}.';
$string['cannotgetcoursecontents'] = 'Nije moguće dohvatiti sadržaj kolegija';
$string['checkusercapability'] = 'Provjeri sposobnosti korisnika';
$string['checkusercapabilitydescription'] = 'Korisnik bi trebao imati odgovarajuće spospobnosti sukladno protokolima koji se koriste, npr. webservice/rest:use, webservice/soap:use. Da bi to postigli, stvorite ulogu web servisa sa sposobnostima izvršenja protokola i dodijelite korisniku web servisa kao sistemsku ulogu.';
$string['configwebserviceplugins'] = 'Zbog sigurnosnih razloga, trebali bi biti omogućeni samo protokoli koji se koriste.';
$string['context'] = 'Kontekst';
$string['createservicedescription'] = 'Servis čini skup funkcija web servisa. Morate dopustiti korisniku pristup novom servisu. Na stranici <strong>Dodaj servis</strong> označite 2 opcije: \'Omogući\' i \'Prijavljeni korisnici\'. Odaberite i \'Nema zahtijevane sposobnosti\'.';
$string['createserviceforusersdescription'] = 'Servis čini skup funkcija web servisa. Morate dopustiti korisniku pristup novom servisu. Na stranici <strong>Dodaj servis</strong> označite opciju \'Omogući\' i uklonite oznaku s opcije \'Prijavljeni korisnici\'. Odaberite i \'Nema zahtijevane sposobnosti\'.';
$string['createtoken'] = 'Stvori token';
$string['createtokenforuser'] = 'Stvori token za korisnika';
$string['createtokenforuserdescription'] = 'Stvori token za web servis korisnika.';
$string['createuser'] = 'Stvori namjenskog korisnika';
$string['createuserdescription'] = 'Morate stvoriti namjenskog korisnika za kontrolu sustava Moodle.';
$string['criteriaerror'] = 'Nedostaju ovlasti za pretraživanje prema kriteriju.';
$string['default'] = 'Zadano za "{$a}"';
$string['deleteaservice'] = 'Obriši servis';
$string['deleteservice'] = 'Izbriši servis: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Brisanje servisa će također izbrisati tokene povezane s ovim servisom. Želite li uistinu izbrisati vanjski servis "{$a}"?';
$string['deletetokenconfirm'] = 'Želite li izbrisati ovaj token za web servis korisnika <strong>{$a->user}</strong> na servisu <strong>{$a->service}</strong>?';
$string['disabledwarning'] = 'Svi protokoli web servisa su onemogućeni. Postavku "Omogući korištenje web servisa" možete pronaći među naprednim postavkama.';
$string['doc'] = 'Dokumentacija';
$string['docaccessrefused'] = 'Nemate ovlasti za pregledavanje dokumentacije za ovaj token';
$string['documentation'] = 'dokumentacija web servisa';
$string['downloadfiles'] = 'Može preuzimati datoteke';
$string['editaservice'] = 'Uredi servis';
$string['editservice'] = 'Uredi servis: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Omogućeno';
$string['enabledocumentation'] = 'Omogući dokumentaciju za razvojne programere';
$string['enabledocumentationdescription'] = 'Detaljna dokumentacija za web servise je dostupna za omogućene protokole.';
$string['enableprotocols'] = 'Omogući protokole';
$string['enableprotocolsdescription'] = 'Mora biti omogućen barem jedan protokol. Zbog sigurnosnih razloga, omogućite samo one protokole koje namjeravate koristiti.';
$string['enablews'] = 'Omogući korištenje web servisa';
$string['enablewsdescription'] = 'Web servisi moraju biti omogućeni u naprednim postavkama.';
$string['entertoken'] = 'Unesite lozinku/token:';
$string['error'] = 'Pogreška: {$a}';
$string['errorcatcontextnotvalid'] = 'Ne možete izvršiti funkcije u kontekstu kategorije (ID kategorije:{$a->catid}). Poruka konteksta je glasila: {$a->message}';
$string['errorcodes'] = 'Poruka o pogrešci';
$string['errorcoursecontextnotvalid'] = 'Ne možete izvršiti funkcije u kontekstu kolegija (id kolegija:{$a->courseid}). Poruka pogreške konteksta glasi: {$a->message}';
$string['errorinvalidparam'] = 'Parametar "{$a}" nije valjan.';
$string['errornotemptydefaultparamarray'] = 'Parametar opisa web servisa naziva \'{$a}\' je jednostavne ili višestruke strukture. Zadano je da isti može jedino biti prazno polje. Provjerite opis web servisa.';
$string['erroroptionalparamarray'] = 'Parametar opisa web servisa naziva \'{$a}\' je jednostavne ili višestruke strukture. Ne može biti zadan kao VALUE_OPTIONAL. Provjerite opis web servisa.';
$string['execute'] = 'Izvrši';
$string['executewarnign'] = 'UPOZORENJE: Ako pokrenete izvršavanje, sadržaj vaše baze podataka će biti izmijenjen, a te promjene nije moguće automatski poništiti !';
$string['externalservice'] = 'Vanjski servis';
$string['externalservicefunctions'] = 'Funkcije vanjskog servisa';
$string['externalservices'] = 'Vanjski servisi';
$string['externalserviceusers'] = 'Korisnici vanjskog servisa';
$string['failedtolog'] = 'Nije zapisano';
$string['filenameexist'] = 'Datoteka s istim nazivom već postoji: {$a}';
$string['forbiddenwsuser'] = 'Nije moguće stvoriti token za nepotvrđenog, izbrisanog, suspendovanog ili korisnika u ulozi gosta.';
$string['function'] = 'Funkcija';
$string['functions'] = 'Funkcije';
$string['generalstructure'] = 'Opća struktura';
$string['information'] = 'Informacija';
$string['installexistingserviceshortnameerror'] = 'Web servis pod nazivom "{$a}" već postoji. Nije moguće instalirati/nadograditi različiti servis identična naziva.';
$string['invalidextparam'] = 'Neispravan parametar vanjskog API-ja: {$a}';
$string['invalidextresponse'] = 'Neispravan odgovor vanjskog API-ja: {$a}';
$string['invalidiptoken'] = 'Neispravan token - vaša IP adresa nije podržana';
$string['invalidtimedtoken'] = 'Neispravan token - token istekao';
$string['invalidtoken'] = 'Neispravan token - token nije pronađen';
$string['iprestriction'] = 'Restrikcija po IP adresi';
$string['iprestriction_help'] = 'Korisnik će morati pozivati web servis s navedene IP adrese.';
$string['key'] = 'Ključ';
$string['keyshelp'] = 'Ključevi se koriste za pristup vašem Moodle korisničkom računu iz vanjskih aplikacija.';
$string['manageprotocols'] = 'Uredi protokole';
$string['managetokens'] = 'Uredi tokene';
$string['missingcaps'] = 'Nedostaju sposobnosti';
$string['missingcaps_help'] = 'Popis sposobnosti obveznih za servis koje odabrani korisnik nema. Nedostajuće sposobnosti moraju biti dodane u korisnikovu ulogu kako bi se on mogao koristiti tim servisom.';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['missingversionfile'] = 'Programska pogreška: nedostaje datoteka version.php za komponentu {$a}';
$string['mobilewsdisabled'] = 'Onemogućeno';
$string['mobilewsenabled'] = 'Onemogućeno';
$string['nofunctions'] = 'Ovaj servis nema funkcija.';
$string['norequiredcapability'] = 'Nema potrebne sposobnosti';
$string['notoken'] = 'Popis tokena je prazan.';
$string['onesystemcontrolling'] = 'Dopusti vanjskom sustavu kontrolu Moodle sustava putem tokena';
$string['onesystemcontrollingdescription'] = 'Sljedeći koraci će vam pomoći da podesite Moodle web servis za sustav koji kontrolira Moodle. Ovi koraci će vam također pomoći pri zadavanju preporučene na tokenima zasnovanog autentikacijskog načina (sigurnosni ključevi).';
$string['operation'] = 'Operacija';
$string['optional'] = 'Opcionalno';
$string['passwordisexpired'] = 'Lozinka je istekla.';
$string['phpparam'] = 'XML-RPC (PHP struktura)';
$string['phpresponse'] = 'XML-RPC (PHP struktura)';
$string['postrestparam'] = 'PHP kod za REST (POST zahtjev)';
$string['potusers'] = 'Nema prijavljenih korisnika';
$string['potusersmatching'] = 'Nema podudaranja s prijavljenim korisnicima';
$string['print'] = 'Otisni sve';
$string['protocol'] = 'Protokol';
$string['removefunction'] = 'Ukloni';
$string['removefunctionconfirm'] = 'Želite li ukloniti funkciju "{$a->function}" servisa "{$a->service}"?';
$string['requireauthentication'] = 'Ovaj način zahtijeva autentikaciju s xxx ovlastima.';
$string['required'] = 'Obvezno';
$string['requiredcapability'] = 'Potrebna sposobnost';
$string['requiredcapability_help'] = 'Ako je tako podešeno, samo korisnici koji imaju potrebne sposobnosti mogu pristupiti servisu.';
$string['requiredcaps'] = 'Potrebne sposobnosti';
$string['resettokenconfirm'] = 'Želite li uistinu resetirati ovaj ključ web servisa za <strong>{$a->user}</strong> na servisu <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Želite li uistinu resetirati ovaj ključ? Sve pohranjene poveznice koje sadrže stari ključ više neće raditi.';
$string['response'] = 'Odgovor';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Vraćenom korisničkom računu morate resetirati lozinku prije stvaranja tokena.';
$string['restparam'] = 'REST (POST parametri)';
$string['restrictedusers'] = 'Samo prijavljeni korisnici';
$string['restrictedusers_help'] = 'Ova postavka određuje mogu li svi korisnici koji imaju ovlasti stvaranja tokena za web servis stvoriti i token za ovaj servis preko stranice sa sigurnosnim ključevima ili to mogu samo autorizirani korisnici.';
$string['securitykey'] = 'Sigurnosni ključ (token)';
$string['securitykeys'] = 'Sigurnosni ključevi';
$string['selectauthorisedusers'] = 'Odaberi prijavljene korisnike';
$string['selectedcapability'] = 'Odabrano';
$string['selectedcapabilitydoesntexit'] = 'Trenutno zadana potrebna sposobnost ({$a}) nije više dostupna. Promijenite to i pohranite promjene.';
$string['selectservice'] = 'Odaberi servis';
$string['selectspecificuser'] = 'Odaberi određenog korisnika';
$string['selectspecificuserdescription'] = 'Dodaj web servise kao prijavljene korisnike.';
$string['service'] = 'Servis';
$string['servicehelpexplanation'] = 'Servis čini skup funkcija. Servisu mogu pristupiti ili svi korisnici, ili samo odabrani korisnici.';
$string['servicename'] = 'Naziv servisa';
$string['servicenotavailable'] = 'Web servs nije dostupan (ne postoji ili je možda onemogućen)';
$string['servicesbuiltin'] = 'Ugrađeni servisi';
$string['servicescustom'] = 'Prilagođeni servisi';
$string['serviceusers'] = 'Prijavljeni korisnici';
$string['serviceusersettings'] = 'Korisničke postavke';
$string['serviceusersmatching'] = 'Prijavljeni korisnici koji se podudaraju';
$string['serviceuserssettings'] = 'Promijeni postavke za prijavljene korisnike';
$string['simpleauthlog'] = 'Jednostavni dodatak za autentikaciju';
$string['step'] = 'Korak';
$string['supplyinfo'] = 'Opširnije';
$string['testauserwithtestclientdescription'] = 'Simulirajte vanjski pristup servisu koristeći probni klijent web servisa. Prije toga se prijavite sustavu kao korisnik koji ima sposobnost moodle/webservice:createtoken i dohvatite sigurnosni ključ (token) na postavkama vašeg profila. Token vam je potreban za korištenje probnog klijenta. U probnom klijentu odaberite omogućeni protokol s autentikacijom tokenom. <strong>UPOZORENJE: Funkcije koje ćete isprobati će UISTINU BITI IZVRŠENE od strane ovog korisnika, pa budite pažljivi u odabiru toga što ćete isprobavati!</strong>';
$string['testclient'] = 'Probni klijent za web servis';
$string['testclientdescription'] = '* Probni klijent web servisa <strong>UISTINU izvršava</strong> funkcije koje pozovete. Nemojte isprobavati funkcije za koje ne znate čemu služe. <br/>* Sve postojeće funkcije web servisa nisu još implementirane u probni klijent. <br/>* Kako bi provjerili to da korisnik ne može pristupiti nekoj funkciji, možete pokušati pristupiti nekim funkcijama koje niste odobrili.<br/>* Kako bi vidjeli jasnije poruke o pogrešci podesite \'debugging\' na <strong>{$a->mode}</strong> na {$a->atag}<br/>* Pristupite {$a->amfatag}.';
$string['testwithtestclient'] = 'Isprobaj servis';
$string['testwithtestclientdescription'] = 'Simuliraj vanjski pristup servisu korištenjem probnog klijenta web servisa. Koristite omogućeni protokol s autentikacijom putem tokena. <strong>UPOZORENJE: Funkcije koje ćete isprobavati će biti ZAISTA IZVRŠENE, pa pazite što radite!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Autentikacija putem tokena';
$string['tokencreatedbyadmin'] = 'Samo administrator može vratiti na početne vrijednosti (*)';
$string['tokencreator'] = 'Autor';
$string['unknownoptionkey'] = 'Nepoznat ključ opcije ({$a})';
$string['unnamedstringparam'] = 'Parametar niza nije imenovan.';
$string['updateusersettings'] = 'Osvježi';
$string['userasclients'] = 'Korisnici kao klijenti s tokenom';
$string['userasclientsdescription'] = 'Ovi koraci vam pomažu podesiti Moodle web servis za korisnike kao klijente. Ovi koraci vam pomažu i podesiti preporučeni način autentikacije s tokenom (sigurnosnim ključem). U ovom načinu rada će korisnik stvoriti svoj token na stranici sa sigurnosnim ključevima dostupnoj preko postavki profila.';
$string['usermissingcaps'] = 'Nedostaje sposobnost: {$a}.';
$string['usernameorid'] = 'Korisničko ime / korisnički ID';
$string['usernameorid_help'] = 'Upišite korisničko ime ili korisnički ID';
$string['usernameoridnousererror'] = 'Nisu pronađeni korisnici s navedenim korisničkim imenom/korisničkim ID.';
$string['usernameoridoccurenceerror'] = 'Pronađeno je više od jednog korisnika s tim korisničkim imenom. Molim unesite korisnički ID.';
$string['usernotallowed'] = 'Ovaj korisnik nema ovlasti nad ovim servisom. Prvo ga morate ovlastiti na administracijskoj stranici {$a}.';
$string['usersettingssaved'] = 'Korisničke postavke pohranjene';
$string['validuntil'] = 'Vrijedi do';
$string['validuntil_help'] = 'Ako je podešeno, nakon ovog datuma servis će biti deaktiviran za ovog korisnika.';
$string['webservice'] = 'Web servis';
$string['webservices'] = 'Web servisi';
$string['webservicesoverview'] = 'Pregled';
$string['webservicetokens'] = 'Tokeni za web servis';
$string['wrongusernamepassword'] = 'Pogrešno korisničko ime ili lozinka';
$string['wsaccessuserdeleted'] = 'Odbijen pristup web servisu zbog izbrisanog korisničkog imena: {$a}';
$string['wsaccessuserexpired'] = 'Odbijen pristup web servisu zbog istekle lozinke za korisničko ime: {$a}';
$string['wsaccessusernologin'] = 'Odbijen pristup web servisu zbog autentikacije dodatkom "nologin" za korisničko ime: {$a}';
$string['wsaccessusersuspended'] = 'Odbijen pristup web servisu zbog suspendiranog korisničkog računa za korisničko ime: {$a}';
$string['wsaccessuserunconfirmed'] = 'Odbijen pristup web servisu zbog nepotvrđenog korisničkog imena za korisničko ime: {$a}';
$string['wsclientdoc'] = 'Dokumentacija Moodle web servis klijenta';
$string['wsdocapi'] = 'API dokumentacija';
$string['wsdocumentation'] = 'Dokumentacija web servisa';
$string['wsdocumentationdisable'] = 'Dokumentacija web servisa je onemogućena.';
$string['wsdocumentationintro'] = 'Prije stvaranja klijenta preporučljivo je pročitati {$a->doclink}';
$string['wsdocumentationlogin'] = 'ili unesite korisničko ime i lozinku za web servis:';
$string['wspassword'] = 'Lozinka za web servis';
$string['wsusername'] = 'Korisničko ime za web servis';
