<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   report_security
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_configrw_details'] = '<p>Preporučljivo je da se ovlasti nad datotekom config.php promijene nakon instalacije kako toj datoteci ne bi mogao pristupati web poslužitelj. Uzmite u obzir da to ne povećava sigurnost poslužitelja u velikoj mjeri, iako će donekle usporiti ili ograničiti općenite sigurnosne prijetnje.</p>';
$string['check_configrw_name'] = 'Moguće je zapisivati u config.php';
$string['check_configrw_ok'] = 'PHP skripte ne mogu mijenjati config.php';
$string['check_configrw_warning'] = 'PHP skripte MOGU mijenjati config.php';
$string['check_cookiesecure_details'] = '<p>Ako omogućite https komunikaciju, preporučljivo je da omogućite sigurne cookie datoteke. Trebali biste također dodati trajnu redirekciju sa http na https.</p>';
$string['check_cookiesecure_error'] = 'Omogućite sigurne cookie datoteke';
$string['check_cookiesecure_name'] = 'Sigurni cookies';
$string['check_cookiesecure_ok'] = 'Sigurni cookies omogućeni.';
$string['check_defaultuserrole_details'] = '<p>Svi prijavljenim korisnicima su dane sposobnosti zadane korisničke uloge. Provjerite da nisu zadane ikakve rizične spoposbnosti za navedenu ulogu.</p>
<p>Jedina podržana naslijeđena uloga za zadanu korisničku ulogu je <em>Prijavljeni korisnik</em>. Sposobnost pregleda kolegija ne smije biti omogućena.</p>';
$string['check_defaultuserrole_error'] = 'Zadana uloga "{$a}" nije ispravno podešena!';
$string['check_defaultuserrole_name'] = 'Zadana uloga za sve korisnike';
$string['check_defaultuserrole_notset'] = 'Zadana uloga nije podešena.';
$string['check_defaultuserrole_ok'] = 'Definicija zadane uloge za sve korisnike je OK.';
$string['check_displayerrors_details'] = '<p>Omogućavanje  PHP postavke <code>display_errors</code> nije preporučljivo na produkcijskim poslužiteljima jer poruke o pogrešci mogu otkriti povjerljive informacije o vašem poslužitelju.</p>';
$string['check_displayerrors_error'] = 'PHP postavka za prikaz pogrešaka je omogućena. Preporučujemo da ju onemogućite.';
$string['check_displayerrors_name'] = 'Prikaz PHP pogrešaka';
$string['check_displayerrors_ok'] = 'Prikaz PHP pogrešaka onemogućen.';
$string['check_emailchangeconfirmation_details'] = '<p>Preporučljivo je da je korak s potvrdom putem e-pošte obvezan pri postupku u kojem korisnici mijenjaju vlastitu adresu e-pošte na svom profilu. Ako je onemogućeno, spameri mogu iskoristiti vaš poslužitelj za slanje spama.</p>
<p>Polje e-pošte može biti zaključano u odnosu na dodatke za autentikaciju, ali to se ovdje ne razmatra.</p>';
$string['check_emailchangeconfirmation_error'] = 'Korisnici mogu unijeti bilo koju adresu e-pošte.';
$string['check_emailchangeconfirmation_info'] = 'Korisnici mogu unijeti adresu e-pošte samo s dopuštenih domena.';
$string['check_emailchangeconfirmation_name'] = 'Potvrda promjene adrese e-pošte';
$string['check_emailchangeconfirmation_ok'] = 'Potvrda promjene adrese e-pošte na korisničkom profilu.';
$string['check_embed_details'] = '<p>Neograničena ugradnja (embedding) objekata je jako opasna - bilo koji registrirani korisnik može pokrenuti napad XSS-om na sve ostale korisnike poslužitelja. Ovu postavku treba onemogućiti na produkcijskim poslužiteljima.</p>';
$string['check_embed_error'] = 'Omogućena je neograničena ugradnja (embedding) objekata - ovo je jako opsano na većini poslužitelja.';
$string['check_embed_name'] = 'Dopusti EMBED i OBJECT';
$string['check_embed_ok'] = 'Neograničena ugradnja objekata (embedding) nije dopuštena.';
$string['check_frontpagerole_details'] = '<p>Zadana uloga na naslovnici je dana svim prijavljenim korisnicima za aktivnosti na naslovnici. Provjerite da nema rizičnih spospobnosti za ovu ulogu.</p>
<p>Preporučljivo je da stvorite posebnu ulogu za ovu namjenu i da ne koristite naslijeđenu ulogu.</p>';
$string['check_frontpagerole_error'] = 'Otkrivena neispravno podešena uloga na naslovnici "{$a}"!';
$string['check_frontpagerole_name'] = 'Uloga na naslovnici';
$string['check_frontpagerole_notset'] = 'Uloga na naslovnici nije podešena.';
$string['check_frontpagerole_ok'] = 'Uloga na naslovnici je u redu.';
$string['check_globals_details'] = '<p>Register globals se smatra jako nesigurnom PHP postavkom.</p> <p><code>register_globals=off</code> mora biti postavljeno u PHP-u. Ovu postavku možete postaviti u <code>php.ini</code> datoteci, Apache/IIS postavkama ili <code>.htaccess</code> datoteci.</p>';
$string['check_globals_error'] = 'Register globals MORA biti onemogućen. ODMAH popravite postavke PHP poslužitelja!';
$string['check_globals_name'] = 'Register globals';
$string['check_globals_ok'] = 'Register globals je onemogućen.';
$string['check_google_details'] = '<p>Postavka \'Otvori prema Google\' omogućava pretraživačima pristup kolegijima s ulogom gosta. Nema svrhe omogućavati ovu postavku ako gostima nije dopuštena prijava.</p>';
$string['check_google_error'] = 'Pristup tražilicama je omogućen, ali je pristup gostima onemogućen.';
$string['check_google_info'] = 'Tražilice se mogu prijaviti kao gosti.';
$string['check_google_name'] = 'Otvoreno prema Google';
$string['check_google_ok'] = 'Pristup pretraživačima nije dopušten.';
$string['check_guestrole_details'] = '<p>Uloga gosta se koristi za goste, ne-prijavljene korisnike i  privremeni pristup kolegijima.  Provjerite da nisu zadane nikakve rizične spospobnosti za ovu ulogu.</p> <p>Jedina podržana naslijeđena uloga za ulogu gosta je <em>Gost</em>.</p>';
$string['check_guestrole_error'] = 'Uloga gosta "{$a}" nije ispravno podešena!';
$string['check_guestrole_name'] = 'Uloga gosta';
$string['check_guestrole_notset'] = 'Uloga gosta nije podešena.';
$string['check_guestrole_ok'] = 'Postavke uloge gosta su u redu.';
$string['check_mediafilterswf_details'] = '<p>Automatska ugradnja .swf datoteka je jako opasna - bilo koji registrirani korisnik može pokrenuti XSS napad na druge korisnike na poslužitelju. Onemogućite ovu postavku na produkcijskom poslužitelju.</p>';
$string['check_mediafilterswf_error'] = 'Multimedijski filtar za Flash sadržaje je omogućen - ovo je jako opasno na većini poslužitelja.';
$string['check_mediafilterswf_name'] = 'Omogućen .swf filtar';
$string['check_mediafilterswf_ok'] = 'Flash filtar nije omogućen.';
$string['check_noauth_details'] = '<p>Dodatak <em>Nema prijave</em> nije namijenjen produkcijskim sjedištima. Onemogućite ga, osim ako se radi o razvojnom sjedištu.</p>';
$string['check_noauth_error'] = 'Dodatak Nema prijave nije namijenjen produkcijskim sjedištima. ';
$string['check_noauth_name'] = 'Nema prijave';
$string['check_noauth_ok'] = 'Autentikacijski dodatak \'Nema prijave\' je onemogućen.';
$string['check_openprofiles_details'] = '<p>Otvoreni profili mogu biti zloporabljeni od strane spamera. Preporučljivo je da omogućite postavku ili <code>Obvezno prijavljivanje korisnika na sustav<(code> ili <code>Obvezno prijavljivanje korisnika za pregled profila</code>.';
$string['check_openprofiles_error'] = 'Svatko može pregledavati korisničke profile bez prijave sustavu.';
$string['check_openprofiles_name'] = 'Korisnički računi otvoreni prema svijetu';
$string['check_openprofiles_ok'] = 'Prije pregleda korisnikih profila treba se prijaviti sustavu.';
$string['check_passwordpolicy_details'] = '<p>Preporučljivo je podešavanje pravila za lozinke jer je pogađanje lozinki često najlakši način za dobivanje nedopuštenog pristupa. Nemojte ista zadati prestrogo, jer o može rezultirati time da korisnici nisu u stanju zapamtiti svoje lozinke, pa će ih ili češće zaboravljati ili ih zapisivati na papir.</p>';
$string['check_passwordpolicy_error'] = 'Pravila za lozinke nisu zadana.';
$string['check_passwordpolicy_name'] = 'Pravila za lozinke';
$string['check_passwordpolicy_ok'] = 'Pravila za lozinke su zadana.';
$string['check_riskadmin_detailsok'] = '<p>Molimo potvrdite sljedeći popis administratora sustava:</p>{$a}';
$string['check_riskadmin_name'] = 'Administratori';
$string['check_riskadmin_ok'] = 'Broj administratora: {$a}';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) pregled dodjele uloga</a>';
$string['check_riskadmin_warning'] = 'Pronađeno je {$a->admincount} administratora poslužitelja i {$a->unsupcount} nepodržanih dodjela administratorske uloge.';
$string['check_riskbackup_detailsok'] = 'Nema uloge koja eksplicitno dopušta backup korisničkih podataka. Međutim, imajte na umu da će administratori sa "doanything" sposobnosti vjerojatno biti u mogućnosti to učiniti.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Ova aktivne izmjene ovlasti daju korisnicima mogućnost obuhvaćanja korisničkih podataka u backupu. Provjerite je li navedena ovlast neophodna.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Slijedeće sistemske uloge trenutno dopuštaju korisnicima obuhvaćanje korisničkih podataka u backupu. Provjerite je li ova ovlast uistinu potrebna.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Zbog gore navedenih uloga ili lokalnih izmjena ovlasti, ovim se korisničkim računim trenutno dopušta obuhvaćanje korisničkih podataka u backupu. Provjerite (a) jesu li to pouzdani korisnici i (b) imaju li dovoljno jake lozinke:</p> {$a}';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} u {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Backup korisničkih podataka';
$string['check_riskbackup_ok'] = 'Nijedna od uloga ne dopušta eksplicitno backup podataka';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) u {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Pronađeno je ovoliko uloga: {$a->rolecount}, {$a->overridecount} izmjena ovlasti i {$a->usercount} korisnika koji imaju mogućnost backupa korisničkih podataka.';
$string['check_riskxss_details'] = '<p>RISK_XSS označava sve opasne sposobnosti koje trebaju moći koristiti samo pouzdani korisnici.</p>
<p>Provjerite ovaj popis korisnika i provjerite vjerujete li svima u potpunosti:</p><p>{$a}</p>';
$string['check_riskxss_name'] = 'XSS pouzdani korisnici';
$string['check_riskxss_warning'] = 'RISK_XSS - pronađeno je {$a} korisnik(a) koji moraju biti pouzdani.';
$string['check_unsecuredataroot_details'] = '<p>Dataroot mapa ne smije biti dostupna putem weba. Najbolji način da to učinite je da istu smjestite u mapu izvan one u kojoj su smještene javno dostupne web stranice.

Ako naknadno prebacujete mapu, morate promijeniti i
<code>$CFG->dataroot</code> postavku u  <code>config.php</code> datoteci.</p>';
$string['check_unsecuredataroot_error'] = 'Vaša dataroot mapa <code>{$a}</code> je na pogrešnom mjestu i izložena je pristupu putem weba!';
$string['check_unsecuredataroot_name'] = 'Nesigurna osnovna mapa s podacima';
$string['check_unsecuredataroot_ok'] = 'Osnovna mapa s podacima ne smije biti dostupna putem weba.';
$string['check_unsecuredataroot_warning'] = 'Vaša dataroot mapa <code>{$a}</code> je na pogrešnom mjestu i može biti izložena pristupu putem weba!';
$string['configuration'] = 'Postavke';
$string['description'] = 'Opis';
$string['details'] = 'Detalji';
$string['issue'] = 'Problem';
$string['pluginname'] = 'Sigurnosna provjera';
$string['security:view'] = 'Pregled sigurnosnog izvještaja';
$string['status'] = 'Status';
$string['statuscritical'] = 'Kritično';
$string['statusinfo'] = 'Informacija';
$string['statusok'] = 'OK';
$string['statusserious'] = 'Ozbiljno';
$string['statuswarning'] = 'Upozorenje';
$string['timewarning'] = 'Obrada podataka može potrajati, budite strpljivi...';
