<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Ovaj test možete pregledati, no da je ovo stvarni pokušaj rješavanja, pristup bi vam bio blokiran jer:';
$string['action'] = 'Akcija';
$string['activityoverview'] = 'Imate zakazane testove';
$string['adaptive'] = 'Adaptivni oblik';
$string['adaptive_help'] = 'Ako je omogućeno, pri svakom rješavanju dopušteni su višestruki pokušaji odgovaranja. Na primjer, ako je odgovor označen kao netočan, studentu će biti dopušteno ponovno odgovaranje. No, ovisno o postavci "Primijeni kaznene bodove", kazneni će se bodovi odbiti za svaki krivi pokušaj.';
$string['addaquestion'] = 'Dodaj pitanje ...';
$string['addarandomquestion'] = 'Dodaj pitanje slučajnim odabirom ...';
$string['addarandomquestion_help'] = 'Kod dodavanja pitanja slučajnim odabirom, slučajno se odabrano pitanje iz kategorije dodaje u test. To znači da će različiti studenti vjerojatno dobiti različita pitanja, a kada test dopušta ponovne pokušaje rješavanja, svaki pokušaj će vjerojatno sadržavati novi skup pitanja.';
$string['adddescriptionlabel'] = 'Dodavanje opisa';
$string['addingquestion'] = 'Dodavanje pitanja';
$string['addingquestions'] = 'Na ovom dijelu stranice uređujete svoju bazu pitanja. Pitanja su pohranjena u kategorije kako bi se što lakše organizirala, i mogu biti upotrijebljena u bilo kojem testu unutar vašeg kolegija ili nekog drugog kolegija ako odaberete opciju \'objavljivanja\' pitanja. <br /><br />
Nakon što odaberete određenu kategoriju pitanja, možete stvoriti nova ili uređivati već postojeća pitanja. Možete označiti bilo koje od tih pitanja i dodati ga (ih) u vaš test koji se nalazi s lijeve strane ekrana.';
$string['addmoreoverallfeedbacks'] = 'Dodaj još {no} polja za povratne informacije';
$string['addnewgroupoverride'] = 'Dodaj promjenu pravila za grupu';
$string['addnewpagesafterselected'] = 'Umetni nove stranice poslije odabranih pitanja';
$string['addnewquestionsqbank'] = 'Dodaj pitanja u kategoriju {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj promjenu pravila za korisnika ';
$string['addpagehere'] = 'Dodaj stranicu ovdje';
$string['addquestion'] = 'Dodaj pitanje';
$string['addquestions'] = 'Dodaj pitanja';
$string['addquestionstoquiz'] = 'Dodajte pitanja u trenutni test';
$string['addrandom'] = 'Dodaj {$a} slučajno odabranih pitanja';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'slučajna pitanja';
$string['addrandomfromcategory'] = 'Dodaj pitanja slučajnim odabirom iz ove kategorije:';
$string['addrandomquestion'] = 'Dodaj pitanje slučajnim odabirom';
$string['addrandomquestiontoquiz'] = 'Dodaj pitanje slučajnim odabirom u test {$a}';
$string['addselectedtoquiz'] = 'Dodaj odabrano u test';
$string['addtoquiz'] = 'Dodaj u test';
$string['affectedstudents'] = 'Obuhvaćeno: ($a)';
$string['aftereachquestion'] = 'Nakon dodavanja svakog pitanja';
$string['afternquestions'] = 'Nakon dodavanja {$a} pitanja';
$string['age'] = 'starost';
$string['allattempts'] = 'Svi pokušaji';
$string['allinone'] = 'Neograničen';
$string['allowreview'] = 'Dopusti pregled';
$string['alreadysubmitted'] = 'Vjerojatno ste već predali test.';
$string['alternativeunits'] = 'Alternativne jedinice';
$string['alwaysavailable'] = 'Uvijek dostupan';
$string['analysisoptions'] = 'Postavke analize';
$string['analysistitle'] = 'Tablica analize čestica';
$string['answer'] = 'Odgovor';
$string['answered'] = 'Odgovoreno';
$string['answerhowmany'] = 'Jedan ili više odgovora?';
$string['answers'] = 'Odgovori';
$string['answersingleno'] = 'Dopušteni su višestruki odgovori';
$string['answersingleyes'] = 'Jedan odgovor';
$string['answertoolong'] = 'Odgovor je predugačak nakon linije {$a} (maks. 255 znakova)';
$string['aon'] = 'AON oblik';
$string['areyousureremoveselected'] = 'Želite li izbrisati sva odabrana pitanja?';
$string['asshownoneditscreen'] = 'Kao što je prikazano na stranici za uređivanje';
$string['attempt'] = 'Pokušaj broj {$a}';
$string['attemptalreadyclosed'] = 'Ovaj je pokušaj već završen.';
$string['attemptclosed'] = 'Ovaj pokušaj još nije završen.';
$string['attemptduration'] = 'Utrošeno vrijeme';
$string['attemptedon'] = 'Datum predaje testa';
$string['attempterror'] = 'Trenutno ne možete pristupiti testu jer: {$a}';
$string['attemptfirst'] = 'Prvi pokušaj';
$string['attemptincomplete'] = 'Ovaj pokušaj (korisnika: {$a}) još nije završen.';
$string['attemptlast'] = 'Posljednji pokušaj';
$string['attemptnumber'] = 'Pokušaj';
$string['attemptquiznow'] = 'Započnite test';
$string['attempts'] = 'Pokušaja';
$string['attemptsallowed'] = 'Dopušteni broj pokušaja';
$string['attemptsdeleted'] = 'Broj izbrisanih pokušaja';
$string['attemptselection'] = 'Odaberite koje pokušaje za svakog korisnika treba analizirati:';
$string['attemptsexist'] = 'Test je već u uporabi, ne možete više dodavati ili brisati pitanja.';
$string['attemptsnum'] = 'Broj pokušaja: {$a}';
$string['attemptsnumthisgroup'] = 'Pokušaji: {$a->total} ({$a->group} iz ove grupe)';
$string['attemptsnumyourgroups'] = 'Pokušaji: {$a->total} ({$a->group} iz vaših grupa)';
$string['attemptsonly'] = 'Prikaži samo studente koji su pokušali riješiti test';
$string['attemptstate'] = 'Stanje';
$string['attemptstillinprogress'] = 'Pokušaj u tijeku';
$string['attemptsunlimited'] = 'Neograničen broj pokušaja';
$string['back'] = 'Natrag na pregled pitanja';
$string['backtocourse'] = 'Natrag na kolegij';
$string['backtoquestionlist'] = 'Natrag na listu pitanja';
$string['backtoquiz'] = 'Natrag na uređivanje testa';
$string['basicideasofquiz'] = 'Osnovni koncepti izrade testova';
$string['bestgrade'] = 'Najviša ocjena';
$string['bothattempts'] = 'Prikaži i one studente koji su rješavali i one koji nisu rješavali test';
$string['browsersecurity'] = 'Zaštićen prozor web preglednika';
$string['browsersecurity_help'] = 'Ako je odabrano "prozor preko cijelog ekrana s dijelom JavaScript sigurnosnih postavki",

* test će se pokrenuti samo ako student ima web preglednik s omogućenom podrškom za JavaScript
* test će se pojaviti u novom prozoru preko cijelog ekrana i bez gumba za navigaciju
* studente će se spriječiti, koliko je moguće, od kopiranja i lijepljenja sadržaja';
$string['calculated'] = 'Računsko';
$string['calculatedquestion'] = 'Računsko pitanje nije podržano na liniji {$a}. Ovo će pitanje biti ignorirano. ';
$string['cannotcreatepath'] = 'Nije moguće stvoriti putanju (PATH) ({$a})';
$string['cannoteditafterattempts'] = 'Ne možete dodati ili ukloniti pitanja jer je test već rješavan. ({$a})';
$string['cannotfindprevattempt'] = 'Nije moguće pronaći prethodni pokušaj rješavanja';
$string['cannotfindquestionregard'] = 'Nije moguće dohvatiti pitanja za ponovno ocjenjivanje!';
$string['cannotinsert'] = 'Ne mogu umetnuti pitanje';
$string['cannotinsertrandomquestion'] = 'Nije moguće umetnuti novo pitanje nasumičnim odabirom!';
$string['cannotloadquestion'] = 'Nije moguće učitati opcije pitanja';
$string['cannotloadtypeinfo'] = 'Nije moguće učitati informacije vezane za ovaj tip pitanja';
$string['cannotopen'] = 'Ne mogu otvoriti datoteku za izvoz podataka ({$a})';
$string['cannotrestore'] = 'Nije moguće vratiti podatke o sesijama pitanja';
$string['cannotreviewopen'] = 'Ne možete pregledati ovaj pokušaj, još uvijek je otvoren.';
$string['cannotsavelayout'] = 'Nije moguće spremiti izgled.';
$string['cannotsavenumberofquestion'] = 'Nije moguće pohraniti broj pitanja po stranici';
$string['cannotsavequestion'] = 'Popis pitanja nije bilo moguće pohraniti';
$string['cannotsetgrade'] = 'Nije moguće postaviti novu maksimalnu ocjenu za ovaj test';
$string['cannotsetsumgrades'] = 'Nije moguće postaviti sumu ocjena';
$string['cannotstartgradesmismatch'] = 'Nije moguće započeti rješavanje testa. Broj bodova u testu bi trebao biti {$a->grade}, ali niti jedno pitanje ne sadrži bodove. Ovo možete popraviti na stranici \'Uredi test\'.';
$string['cannotstartmissingquestion'] = 'Nije moguće započeti rješavanje ovog testa. Definicija testa sadrži pitanje koje ne postoji.';
$string['cannotstartnoquestions'] = 'Nije moguće započeti rješavanje ovog testa. Test još nije postavljen. Niti jedno pitanje nije dodano.';
$string['cannotwrite'] = 'Ne mogu zapisivati u datoteku za izvoz podataka ({$a})';
$string['caseno'] = 'NE, nema razlike između malih i VELIKIH slova';
$string['casesensitive'] = 'Postoji li razlika između malih i VELIKIH slova';
$string['caseyes'] = 'DA, postoji razlika između malih i VELIKIH slova';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Kategorija  \'{$a}\' je dodana';
$string['categorydeleted'] = 'Kategorija  \'{$a}\' je izbrisana';
$string['categorynoedit'] = 'Nemate ovlasti za mijenjanje kategorije \'{$a}\'.';
$string['categoryupdated'] = 'Kategorija je uspješno izmjenjena';
$string['close'] = 'Zatvori prozor';
$string['closebeforeopen'] = 'Nije moguće osvježiti test. Odabrali ste datum zatvaranja koji je prije datuma otvaranja testa.';
$string['closed'] = 'Zatvoreno';
$string['closepreview'] = 'Zatvori pregled';
$string['closereview'] = 'Zatvori pregled';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Komentirajte ili izmijenite ocjenu';
$string['comments'] = 'Komentari';
$string['completedon'] = 'Završeno';
$string['configadaptive'] = 'Ako odaberete ovu opciju, student će moći na pitanje odgovoriti više puta, čak i unutar jednog pokušaja rješavanje testa.';
$string['configattemptsallowed'] = 'Ograničenje u broju pokušaja koji su studentima dopušteni u testu.';
$string['configdecimaldigits'] = 'Prikazani broj decimala ocjena';
$string['configdecimalplaces'] = 'Prikazani broj decimala ocjena';
$string['configdecimalplacesquestion'] = 'Prikazani broj decimala ocjena za pojedinačna pitanja.';
$string['configdelay1'] = 'Ako podesite vremenski razmak, student će trebati toliko sačekati prije nego ponovno pokuša rješavati kviz, nakon prvog pokušaja.';
$string['configdelay1st2nd'] = 'Ako ovdje postavite vremenski razmak, student ne može započeti drugi pokušaj rješavanja prije nego prođe ovoliko vremena od njihovog prvog pokušaja.';
$string['configdelay2'] = 'Ako ovdje postavite vremenski razmak, mora proći toliko vremena između prijašnjeg i trećeg ili svakog sljedećeg pokušaja rješavanja testa.';
$string['configdelaylater'] = 'Ako ovdje postavite vremenski razmak, mora proći toliko vremena između prijašnjeg i trećeg ili svakog sljedećeg pokušaja rješavanja testa.';
$string['configeachattemptbuildsonthelast'] = 'Ako su dopušteni višestruki pokušaji, svaki novi pokušaj sadržu rezultate prethodnog pokušaja.';
$string['configgrademethod'] = 'Kada su dopušteni višestruki pokušaji, koju metodu koristiti za izračunavanje konačne ocjene testa.';
$string['configintro'] = 'Vrijednosti koje ovdje postavite određuju zadane vrijednosti koje će biti predložene pri izradi novog testa. Također možete odabrati koje postavke kviza se smatraju naprednim postavkama.';
$string['configmaximumgrade'] = 'Zadana ocjena na temelju koje će se test skalirati.';
$string['confignavmethod'] = 'U načinu navigacije \'Slobodno\', na pitanja se može odgovarati u bilo kojem redoslijedu, koristeći navigaciju. U načinu \'Sekvencijalno\', na pitanja se mora odgovarati u točno određenom redoslijedu.';
$string['confignewpageevery'] = 'Prilikom dodavanja pitanja u test, prekid stranice će automatski biti umentut ovisno o odabranoj postavci. ';
$string['configpenaltyscheme'] = 'Kazneni bodovi koji se oduzimaju za svaki krivi odgovor u adaptivnom načinu testa.';
$string['configpopup'] = 'Otvaranje pokušaja u novom prozoru, uz korištenje trikova u JavaScriptu, kojima će se pokušati ograničiti kopiranje i lijepljenje sadržaja i slično, tijekom rješavanja testa.';
$string['configrequirepassword'] = 'Studenti moraju upisati lozinku testa prije pristupanja testu.';
$string['configrequiresubnet'] = 'Studenti mogu pristupiti testu jedino s ovih računala.';
$string['configreviewoptions'] = 'Ove opcije određuju koje podatke studenti mogu vidjeti kada budu pregledavali pokušaj rješavanja ili izvještaj testa.';
$string['configshowblocks'] = 'Prikaži blokove tijekom rješavanja testa.';
$string['configshowuserpicture'] = 'Prikaži sliku korisnika tijekom rješavanja testa.';
$string['configshufflequestions'] = 'Ako odaberete ovu opciju, poredak pitanja u testu će biti slučajno odabran, svaki puta kada student počne rješavati test.';
$string['configshufflewithin'] = 'Ako odaberete ovu opciju, elementi od kojih se sastoje pojedina pitanja bit će slučajno odabrani svaki puta kada student započne rješavati test, ako je ova opcija istovremeno odabrana i u postavkama pitanja. ';
$string['configtimelimit'] = 'Zadano vremensko ograničenje trajanja testova u minutama. 0 označava neograničeno trajanje.';
$string['configtimelimitsec'] = 'Zadano vremensko ograničenje trajanja testova u sekundama. 0 označava neograničeno trajanje.';
$string['configurerandomquestion'] = 'Podesite pitanje';
$string['confirmclose'] = 'Spremni ste završiti test. Kada završite test, više nećete biti u mogućnosti promijeniti svoje odgovore.';
$string['confirmserverdelete'] = 'Jeste li sigurni kako želite ukloniti poslužitelj <b>{$a}</b> s popisa?';
$string['confirmstartattemptlimit'] = 'Broj dopuštenih pokušaja {$a}. Želite li započeti novi pokušaj?';
$string['confirmstartattempttimelimit'] = 'Ovaj test je vremenski ograničen, s brojem dopuštenih pokušaja {$a}. Želite li započeti novi pokušaj?';
$string['confirmstarttimelimit'] = 'Test ima vremensko ograničenje. Želite li započeti?';
$string['containercategorycreated'] = 'Ova je kategorija napravljena za pohranu svih izvornih kategorija koje su premještene na razinu sjedišta, zbog dolje navedenih razloga.';
$string['continueattemptquiz'] = 'Nastavite na osnovu svog zadnjeg pokušaja';
$string['continuepreview'] = 'Nastavite posljednji pregled.';
$string['copyingfrom'] = 'Stvaranje kopije pitanja \'{$a}\'';
$string['copyingquestion'] = 'Kopiranje pitanja';
$string['correct'] = 'Točno';
$string['correctanswer'] = 'Ispravan odgovor';
$string['correctanswerformula'] = 'Formula točnog odgovora';
$string['correctansweris'] = 'Ispravan odgovor: {$a}';
$string['correctanswerlength'] = 'Značajne znamenke';
$string['correctanswers'] = 'Točni odgovori';
$string['correctanswershows'] = 'Ispravan odgovor sadrži';
$string['corrresp'] = 'Ispravan odgovor';
$string['countdown'] = 'Brojač';
$string['countdownfinished'] = 'Test se uskoro zatvara, pa biste trebali predati svoje odgovore što prije.';
$string['countdowntenminutes'] = 'Test se zatvara za deset minuta.';
$string['coursetestmanager'] = 'Course Test Manager oblik';
$string['createcategoryandaddrandomquestion'] = 'Stvori kategoriju i dodaj slučajno odabrana pitanja';
$string['createfirst'] = 'Prvo morate napraviti nekoliko pitanja s kratkim odgovorima.';
$string['createmultiple'] = 'Dodajte u test više slučajno odabranih pitanja';
$string['createnewquestion'] = 'Stvori novo pitanje';
$string['createquestionandadd'] = 'Stvori novo pitanje i dodaj ga u test';
$string['custom'] = 'Proizvoljan oblik';
$string['dataitemneed'] = 'Potrebno je dodati barem jedan skup stavki podataka, kako biste dobili važeće pitanje';
$string['datasetdefinitions'] = 'Definicije skupa podataka koje se ponovno mogu upotrijebiti, za kategoriju {$a}';
$string['datasetnumber'] = 'Broj';
$string['daysavailable'] = 'Dostupno danima';
$string['decimaldigits'] = 'Broj decimala u ocjenama';
$string['decimalplaces'] = 'Decimalna mjesta u ocjeni';
$string['decimalplaces_help'] = 'Ova postavka određuje broj decimalnih mjesta za prikaz ocjena ili rezultata. Ona utječe isključivo na prikaz, ne na podatke spremljene u bazi, niti na interne izračune, koji se obavljaju s punom preciznošću.';
$string['decimalplacesquestion'] = 'Decimalna mjesta u ocjenama pitanja';
$string['decimalplacesquestion_help'] = 'Ova postavka određuje broj decimalnih mjesta pri prikazu ocjena za pojedinačna pitanja.';
$string['decimalpoints'] = 'Decimalna mjesta';
$string['default'] = 'Zadano';
$string['defaultgrade'] = 'Zadana ocjena za ovo pitanje';
$string['defaultinfo'] = 'Zadana kategorija za pitanja.';
$string['delay1'] = 'Vremenski razmak između prvog i drugog pokušaja rješavanja testa';
$string['delay1st2nd'] = 'Obvezan vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd_help'] = 'Ako je omogućeno, student mora čekati određeno vrijeme prije nego pokuša po drugi put riješiti test.';
$string['delay2'] = 'Vremenski razmak do naknadnih pokušaja rješavanja testa';
$string['delaylater'] = 'Obvezan vremenski razmak između naknadni pokušaja';
$string['delaylater_help'] = 'Ako je omogućeno, student mora čekati određeno vrijeme prije nego pokuša po treći i svaki sljedeći put riješiti test.';
$string['deleteattemptcheck'] = 'Želite li uistinu izbrisati ove pokušaje rješavanja?';
$string['deleteselected'] = 'Izbriši označeno';
$string['deletingquestionattempts'] = 'Brisanje pokušaja rješavanja';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogućeno';
$string['displayoptions'] = 'Opcije prikaza';
$string['download'] = 'Preuzmite datoteku s izveženim kategorijama';
$string['downloadextra'] = '(datoteka se čuva i među datotekama tečaja u mapi /backupdata/quiz)';
$string['duplicateresponse'] = 'Ovo rješenje je zanemareno jer ste već prije dali isti odgovor.';
$string['eachattemptbuildsonthelast'] = 'Svaki pokušaj rješavanja testa nadograđuje se na prethodni';
$string['eachattemptbuildsonthelast_help'] = 'Ako je dopušteno više pokušaja i ako je ova postavka odabrana, svaki novi pokušaj rješavanja testa sadržavat će rezultate prošlog pokušaja. Ovo omogućuje dovršavanje testa u nekoliko pokušaja.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategory'] = 'Uredi kategoriju';
$string['editcatquestions'] = 'Uredi pitanja u kategoriji';
$string['editingquestion'] = 'Promjene pitanja';
$string['editingquiz'] = 'Promjene testa';
$string['editingquiz_help'] = 'Pri izradi testa, osnovni pojmovi su:

* Test, koji sadrži pitanja na jednoj ili više stranica
* Baza pitanja, koja sadrži kopije svih pitanja podijeljene u kategorije
* Slučajno odabrana pitanja - Student dobiva različita pitanja svaki puta kada pokuša riješiti test. Različiti studenti mogu dobiti različita pitanja';
$string['editingquizx'] = 'Uređivanje testa: {$a}';
$string['editoverride'] = 'Uredi promjene pravila';
$string['editqcats'] = 'Uredi kategorije pitanja';
$string['editquestions'] = 'Promjena pitanja';
$string['editquiz'] = 'Uredi test';
$string['editquizquestions'] = 'Uređivanje pitanja na testu';
$string['emailconfirmbody'] = 'Draga/i {$a->username},

hvala za slanje odgovora za test \'{$a->quizname}\', na kolegiju \'{$a->coursename}\', koji su poslani u {$a->submissiontime}.

Ova poruka e-poste potvrdjuje da smo primili odgovore.

Test je dostupan na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Hvala vam na predavanju vaših odgovora za test \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potvrda predaje testa: {$a->quizname}';
$string['emailnotifybody'] = 'Postovani {$a->username},

{$a->studentname} je predao test \'{$a->quizname}\' ({$a->quizurl}) na kolegiju \'{$a->coursename}\'

Ovaj pokusaj mozete pregledati na {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} je dovršio/la test {$a->quizname}. Pogledajte {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} je rijesio/la test {$a->quizname}';
$string['emailoverduebody'] = 'Postovani {$a->studentname},

zapoceli ste rjesavati test \'{$a->quizname}\' na kolegiju \'{$a->coursename}\', ali ga nikada niste zavrsili. Trebao je biti predan do {$a->attemptduedate}.

Ako ipak zelite predati test, molimo da na stranici {$a->attemptsummaryurl} odaberete gumb za predaju testa. To biste trebali uciniti do {$a->attemptgraceend}. U suprotnom vas pokusaj nece biti uvazen.';
$string['emailoverduesmall'] = 'Niste predali test {$a->quizname}. Mozete ga predati na stranici {$a->attemptsummaryurl} prije {$a->attemptgraceend} ako to zelite.';
$string['emailoverduesubject'] = 'Pokusaj nakon isteka vremena: {$a->quizname}';
$string['empty'] = 'Prazno';
$string['enabled'] = 'Omogućeno';
$string['endtest'] = 'Završi test ...';
$string['erroraccessingreport'] = 'Ne možete pristupiti ovom izvještaju';
$string['errorinquestion'] = 'Pogreška u pitanju';
$string['errormissingquestion'] = 'Pogreška: Sustav ne može pronaći pitanje koje ima oznaku {$a}';
$string['errornotnumbers'] = 'Pogreška - odgovori moraju biti numerički';
$string['errorunexpectedevent'] = 'Neočekivani kôd događaja {$a->event} pronađen za pitanje {$a->questionid} u pokušaju {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Pitanja';
$string['everynquestions'] = 'Svaka/ih {$a} pitanja';
$string['everyquestion'] = 'Svako pitanje';
$string['everythingon'] = 'Sve na';
$string['export'] = 'Izvoz';
$string['exportcategory'] = 'Izvoz kategorije';
$string['exporterror'] = 'Došlo je do pogreške prilikom izvoza';
$string['exportingquestions'] = 'Pitanja su izvezena u datoteku';
$string['exportname'] = 'Naziv datoteke';
$string['exportquestions'] = 'Izvoz pitanja u datoteku';
$string['extraattemptrestrictions'] = 'Dodatna ograničenja prilikom pokušaja';
$string['false'] = 'Netočno';
$string['feedback'] = 'Povratna informacija (Feedback)';
$string['feedbackerrorboundaryformat'] = 'Granice ocjena za povratne informacije moraju biti postotci ili brojevi. Vrijednost koju ste unijeli u granici  {a} nije podržana.';
$string['feedbackerrorboundaryoutofrange'] = 'Granice ocjena za povratne informacije moraju biti izmeđe 0% i 100%. Vrijednost koju ste unijeli za granicu {a} nije unutar dopuštenog opsega.';
$string['feedbackerrorjunkinboundary'] = 'Polja s granicama ocjena za povratne informacije treba unijeti bez ikakvih praznina.';
$string['feedbackerrorjunkinfeedback'] = 'Polja povratnih informacija je potrebno popuniti bez ikakvih praznina.';
$string['feedbackerrororder'] = 'Granice ocjena za povratne informacije moraju biti poredane od najviših prema najmanjim. Vrijednost koju ste unijeli u granici {$a} nije u dobrom poretku.';
$string['file'] = 'Datoteka';
$string['fileformat'] = 'Oblik datoteke (format)';
$string['fillcorrect'] = 'Unesite točan odgovor';
$string['filloutnumericalanswer'] = 'Unesite barem jedan mogući odgovor i odstupanje. Rezultat i povratna informacija bit će određena prvom odgovarajućom vrijednosti. Ako na kraju unesete povratnu informaciju bez ponuđenog odgovora, ista će biti prikazana studentima koji nisu upisali niti jedan od ponuđenih odgovora.';
$string['filloutoneanswer'] = 'Morate unijeti barem jedan od mogućih odgovora. Prazni odgovori se ne uzimaju u obzir. "*" (zvjezdicu, asterisk) možete koristiti kao zamjenu za bilo koji znak. Prvi odgovarajući odgovor će biti korišten za procjenu rezultata i povratnu informaciju.';
$string['filloutthreequestions'] = 'Morate riješiti barem tri pitanja. Prazna pitanja se ne uzimaju u obzir.';
$string['fillouttwochoices'] = 'Morate označiti barem dva odgovora. Prazni odgovori se ne uzimaju u obzir.';
$string['finishattemptdots'] = 'Završi pokušaj...';
$string['finishreview'] = 'Završi pregled';
$string['forceregeneration'] = 'Obvezno obnavljanje';
$string['formatnotfound'] = 'Nije pronađen oblik {$a} za uvoz/izvoz';
$string['formatnotimplemented'] = 'Ovaj oblik nije ispravno implementiran, molimo prijavite pogrešku.';
$string['formulaerror'] = 'Pogreške u formuli (izračunu)!';
$string['fractionsaddwrong'] = 'Zbroj pozitivnih ocjena koje ste odabrali ne daju 100%<br />Naime, njihov zbroj je {$a}%<br />Želite li se vratiti i ispraviti pitanje?';
$string['fractionsnomax'] = 'Jedan od odgovora bi trebao nositi 100% ocjene, tako da je <br />moguće dobiti najveću ocjenu za ovo pitanje.<br />Želite li se vratiti i ispraviti pitanje?';
$string['fromfile'] = 'iz datoteke:';
$string['functiondisabledbysecuremode'] = 'Ova funkcionalnost trenutno nije omogućena';
$string['generalfeedback'] = 'Općenita povratna informacija';
$string['generalfeedback_help'] = 'Općenita povratna informacija je tekst koji se prikazuje poslije odgovaranja na pitanje. Za razliku od povratne informacije za pojedino pitanje, koja ovisi o danom odgovoru, uvijek se prikazuje ista općenita povratna informacija.';
$string['graceperiod'] = 'Razdoblje naknadne predaje';
$string['graceperiod_desc'] = 'Ako je odabrana opcija \'Dopusti naknadnu predaju, bez promjena odgovora\', ovo označava dodatno vrijeme u kojem je predaja dopuštena (u sekundama).';
$string['graceperiod_help'] = 'Ako je odabrana opcija \'Dopusti naknadnu predaju, bez promjena odgovora\', ovo označava dodatno vrijeme u kojem je predaja dopuštena.';
$string['graceperiodmin'] = 'Zadnje razdoblje naknadne predaje';
$string['graceperiodmin_desc'] = 'Na kraju testa može se dogoditi problem. S jedne strane, želimo dopustiti studentima da test rješavaju do zadnjeg trenutka - uz pomoć štoperice koja automatski predaje test kada vrijeme istekne. S druge strene, poslužitelj bi tada mogao biti preopterećen. Zato ćemo prihvatiti odgovore i nekoliko sekundi nakon što istekne vrijeme, kako studenti ne bi bili kažnjeni zbog sporog rada poslužitelja. Ipak, student bi mogao varati i dobiti dodatne sekunde za rješavanje testa. Stoga treba pronaći pravu mjeru, ovisno o tome koliko ste sigurni u performanse poslužitelja tijekom rješavanja testova.';
$string['graceperiodtoosmall'] = 'Razdoblje naknadne predaje mora biti veće od {$a}.';
$string['grade'] = 'Ocjena';
$string['gradeall'] = 'Ocijeni sve';
$string['gradeaverage'] = 'Srednja ocjena';
$string['gradeboundary'] = 'Bodovna granica';
$string['gradeessays'] = 'Ocijeni eseje';
$string['gradehighest'] = 'Najviša ocjena';
$string['grademethod'] = 'Način ocjenjivanja';
$string['grademethod_help'] = 'Kada su dopušteni višestruki pokušaji, dostupni su sljedeći načini izračuna završne ocjene testa:

* Najveća ocjena svih pokušaja
* Prosječna (srednja) ocjena svih pokušaja
* Prvi pokušaj (ostali pokušaji se zanemaruju)
* Posljednji pokušaj (ostali pokušaji se zanemaruju)';
$string['gradesdeleted'] = 'Ocjene testa izbrisane.';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Ocjena za ovaj odgovor je: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'S prijašnjim kaznenim bodovima ocjena je <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Ovim odgovorom zaradili ste {$a} kaznena/ih boda/ova.';
$string['gradingdetailszeropenalty'] = 'Niste dobili negativne bodove zbog predaje ovog testa.';
$string['gradingmethod'] = 'Način ocjenjivanja: {$a}';
$string['groupoverrides'] = 'Izmjena pravila za grupu';
$string['groupsnone'] = 'Na ovom kolegiju nema grupa';
$string['guestsno'] = 'Nažalost, gosti (anonimni korisnici) ne mogu pregledavati ili rješavati testove';
$string['hidebreaks'] = 'Skrij prekide stranica';
$string['hidereordertool'] = 'Skrij alat za reorganizaciju';
$string['history'] = 'Povijest odgovora: ';
$string['howquestionsbehave_desc'] = 'Zadana postavka koja određuje kako se ponašaju pitanja u testu.';
$string['imagedisplay'] = 'Prikaz slike';
$string['import'] = 'Uvezi podatke';
$string['importcategory'] = 'kategorija uveza';
$string['importerror'] = 'Dogodila se pogreška prilikom procedure uvoza podataka';
$string['importfilearea'] = 'Uvoz iz datoteke koja se već nalazi u datotekama kolegija...';
$string['importfileupload'] = 'Uvoz iz prenešene datoteke...';
$string['importfromthisfile'] = 'Uvoz podataka iz ove datoteke';
$string['import_help'] = 'Ova funkcija omogućuje uvoz pitanja iz vanjskih tekstualnih datoteka.

Ako datoteka sadrži ne-ascii znakove, morate koristiti kodnu stranicu UTF-8. Posebnu pažnju obratite na dokumente aplikacija Microsoft Office, jer one često koriste posebnu kodnu stranicu koja neće biti ispravno obrađena.

Može postojati više oblika za uvoz i izvoz, koji se nalaze u bazi "Modules and Plugins" (web sjedište moodle.org) ';
$string['importingquestions'] = 'Uvoz {$a} pitanja iz datoteke';
$string['importmax10error'] = 'Pogreška u pitanju: Ne možete imati više od deset ponuđenih odgovora.';
$string['importmaxerror'] = 'Pogreška u pitanju: Uneseno je previše ponuđenih odgovora.';
$string['importquestions'] = 'Uvezi pitanja iz datoteke';
$string['inactiveoverridehelp'] = '* Student nema ispravnu grupu ili ulogu za rješavanje ovog testa';
$string['incorrect'] = 'Netočno';
$string['indivresp'] = 'Odgovori pojedinaca na svaku stavku';
$string['info'] = 'Informacija';
$string['infoshort'] = 'i';
$string['inprogress'] = 'U tijeku';
$string['introduction'] = 'Uvod';
$string['invalidattemptid'] = 'Ne postoji takav ID pokušaja';
$string['invalidcategory'] = 'ID kategorije nije valjan';
$string['invalidnumericanswer'] = 'Jedan od unesenih odgovora nije ispravan broj';
$string['invalidnumerictolerance'] = 'Jedno od unesenih odstupanja nije ispravan broj';
$string['invalidoverrideid'] = 'Neispravan ID izmjene ovlasti';
$string['invalidquestionid'] = 'Neispravan ID pitanja';
$string['invalidquizid'] = 'Neispravan ID testa';
$string['invalidsource'] = 'Izvor nije prihvaćen kao valjan';
$string['invalidsourcetype'] = 'Neispravan tip izvora';
$string['invalidstateid'] = 'Neispravan ID stanja';
$string['lastanswer'] = 'Vaš posljednji odgovor je bio';
$string['layout'] = 'Izgled';
$string['layoutasshown'] = 'Izgled stranice kao što je prikazano.';
$string['layoutasshownwithpages'] = 'Izgled stranice kao što je prikazano. <small>(Nova stranica automatski na svakih  {$a} pitanja.)</small>';
$string['layoutshuffledandpaged'] = 'Pitanja nasumično izmiješana, s {$a} pitanja po stranici.';
$string['layoutshuffledsinglepage'] = 'Pitanja nasumično izmiješana, prikazana na jednoj stranici.';
$string['link'] = 'Poveznica';
$string['listitems'] = 'Popis stavki u testu';
$string['literal'] = 'Literal';
$string['loadingquestionsfailed'] = 'Nije uspjelo učitavanje pitanja: {$a}';
$string['makecopy'] = 'Spremi kao novo pitanje';
$string['managetypes'] = 'Upravanje vrstama pitanja i poslužiteljima';
$string['manualgrading'] = 'Ocjenjivanje';
$string['mark'] = 'Predaj';
$string['markall'] = 'Predaj stranicu';
$string['marks'] = 'Bodovi';
$string['marks_help'] = 'Numeričke oznake za svako pitanje, i broj ukupnih bodova za pokušaj.';
$string['match'] = 'Uparivanje';
$string['matchanswer'] = 'Upareni odgovor';
$string['matchanswerno'] = 'Upareni odgovor {$a}';
$string['max'] = 'Maks.';
$string['messageprovider:attempt_overdue'] = 'Upozorenje pri kašnjenju s predajom testa';
$string['messageprovider:confirmation'] = 'Potvrda vlastitih predaja testa';
$string['messageprovider:submission'] = 'Obavijesti o predanim testovima';
$string['min'] = 'Min.';
$string['minutes'] = 'min.';
$string['missingcorrectanswer'] = 'Morate zadati točan odgovor';
$string['missingitemtypename'] = 'Nedostaje ime';
$string['missingquestion'] = 'Ovo pitanje izgleda više ne postoji';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Test omogućava stvaranje testova koji se mogu sastojati od brojnih vrsta pitanja: pitanja s višestrukim odgovorima, točno/netočno pitanja, pitanja uparivanja, numeričkih pitanja i drugih vrsta.

Nastavnik može omogućiti višestruku rješavanje i predaju testa, pri čemu pitanja i odgovori mogu biti uvršteni slučajnim odabirom iz baze pitanja.

Svaki pokušaj se automatski ocjenjuje, a nastavnici mogu odlučiti žele li studentima dati povratne informacije i/ili prikazati točne odgovore nakon što student odgovori na pitanje ili preda test.

Testovi se mogu koristiti za:

* pismenu provjeru znanja
* kraće provjere znanja vezano uz građu obrađenu na satu/predavanju
* vježbanje za pravu pismenu provjeru znanja (korištenjem starih pitanja)
* samoprocjenu studenata';
$string['modulenameplural'] = 'Testovi';
$string['moveselectedonpage'] = 'Premjesti odabrana pitanja na stranicu: {$a}';
$string['multichoice'] = 'Višestruki odabir';
$string['multipleanswers'] = 'Morate odabrati barem jedan odgovor.';
$string['multiplier'] = 'Množitelj';
$string['mustbesubmittedby'] = 'Ovaj je test potrebno predati do {$a}.';
$string['name'] = 'Naziv';
$string['navmethod'] = 'Način navigacije';
$string['navmethod_free'] = 'Slobodno';
$string['navmethod_help'] = 'Kada je omogućena sekvencijalna navigacija, student mora proći kroz test u točno određenom redoslijedu i ne može se vratiti na prethodne stranice niti preskakati pitanja.';
$string['navmethod_seq'] = 'Sekvencijalno';
$string['navnojswarning'] = 'Upozorenje: klik na ovu poveznicu neće pohraniti odgovore. Koristite gumb "Sljedeći" na dnu stranice.';
$string['neverallononepage'] = 'Nikad, prikaži sva pitanja na jednoj stranici';
$string['newattemptfail'] = 'Pogreška: Nije moguće započeti novi pokušaj rješavanja testa.';
$string['newpage'] = 'Nova stranica';
$string['newpageevery'] = 'Automatski stvori novu stranicu';
$string['newpage_help'] = 'Kod duljih testova, korisno je prikazati test na nekoliko stranica, ograničavanjem broja pitanja po stranici. Pri dodavanju pitanja u test, prekidi stranica će se automatski unijeti ovisno o ovoj opciji. Ipak, prekidi stranice se kasnije mogu ručno pomicati na stranici za uređivanje. ';
$string['noanswers'] = 'Nijedan odgovor nije odabran!';
$string['noattempts'] = 'Nije bilo pokušaja rješavanja ovog testa.';
$string['noattemptsfound'] = 'Nema pokušaja rješavanja.';
$string['noattemptstoshow'] = 'Nema pokušaja za prikaz';
$string['nocategory'] = 'Pogrešna ili nespecificirana kategorija';
$string['noclose'] = 'Nema datuma zatvaranja';
$string['nocommentsyet'] = 'Nema komentara.';
$string['noconnection'] = 'Trenutno nije uspostavljena veza s Web servisom koji obrađuje ovo pitanje. Molimo kontaktirajte svog administratora.';
$string['nodataset'] = 'ništa - nije valjan zamjenski znak';
$string['nodatasubmitted'] = 'Nema predanih podataka.';
$string['noessayquestionsfound'] = 'Nisu pronađena pitanja koja se ručno ocjenjuju';
$string['nogradewarning'] = 'Test nije ocijenjen, pa ne možete upisati sveobuhvatne informacije koje se razlikuju ovisno o ocjeni';
$string['nomoreattempts'] = 'Nemate više pravo na novo rješavanje testa';
$string['none'] = 'Nema';
$string['noopen'] = 'Nema datuma otvaranja / početka';
$string['nooverridedata'] = 'Morate izmijeniti barem jednu od postavki testa.';
$string['nopossibledatasets'] = 'Nema mogućih skupova podataka';
$string['noquestionintext'] = 'Tekst pitanja ne sadrži umetnuta pitanja';
$string['noquestions'] = 'Nijedno pitanje nije dodano za sada';
$string['noquestionsfound'] = 'Nema pitanja';
$string['noquestionsinquiz'] = 'Ne postoje pitanja u ovom testu.';
$string['noquestionsnotinuse'] = 'Ovo slučajno odrabrano pitanje nije u uporabi jer je njegova kategorija prazna.';
$string['noquestionsonpage'] = 'Prazna stranica';
$string['noresponse'] = 'Bez odgovora';
$string['noreview'] = 'Nije vam dopušten pregled ovog testa';
$string['noreviewattempt'] = 'Nemate mogućnost pregledati ovaj pokušaj.';
$string['noreviewshort'] = 'Nije dopušteno';
$string['noreviewuntil'] = 'Nije vam dopušten pregled ovog testa do {$a}';
$string['noreviewuntilshort'] = 'Dostupno {$a}';
$string['noscript'] = 'JavaScript mora biti omogućen kako bi nastavili dalje!';
$string['notavailabletostudents'] = 'Napomena: Ovaj test nije još raspoloživ vašim studentima.';
$string['notenoughrandomquestions'] = 'Nema dovoljno pitanja u kategoriji {$a->category} za izradu pitanja {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nije napisano dovoljno pod-pitanja!<br/>Želite li se vratiti i popraviti pitanje?';
$string['notimedependentitems'] = 'Vremenski limit za pojedine stavke testa trenutno nije podržan. Kao zaobilazno rješenje, postavite vremensko ograničenje na cijeli test. Želite li odabrati drugu stavku (ili ipak koristiti trenutnu)?';
$string['notyetgraded'] = 'Još nije ocijenjeno';
$string['notyetviewed'] = 'Još nije pogledano';
$string['notyourattempt'] = 'Ovo nije vaš pokušaj!';
$string['noview'] = 'Prijavljeni korisnik nema pravo vidjeti ovaj test';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} je napravilo {$a->attemptnum} pokušaja';
$string['numattemptsmade'] = '{$a} pokušaja na ovom testu';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeričko';
$string['numquestionsx'] = 'Pitanja: {$a}';
$string['oneminute'] = '1 minuta';
$string['onlyteachersexport'] = 'Samo nastavnici mogu izvoziti pitanja';
$string['onlyteachersimport'] = 'Samo nastavnici s pravom uređivanja mogu uvoziti pitanja';
$string['onthispage'] = 'Ova stranica';
$string['open'] = 'Nije odgovoreno';
$string['openclosedatesupdated'] = 'Datumi otvaranja i zatvaranja testa su nadograđeni';
$string['optional'] = 'opcionalno';
$string['orderandpaging'] = 'Redoslijed i paginacija';
$string['orderandpaging_help'] = 'Brojevi 10, 20, 30... pored svakog pitanja označavaju poredak pitanja. Brojevi se povećavaju u koracima po 10 kako bi ostalo mjesta za ubacivanje dodatnih pitanja. Za promjenu redoslijeda, promijenite brojeve pa kliknite gumb "Promijeni poredak pitanja".

Za dodoavanja prijeloma stranice nakon određenog pitanja, označite kvačice pored pitanje, te odaberite gumb "Dodaj nove stranice poslije označenih pitanja".

Za raspodjelu pitanja na određen broj stranica, kliknite gumb "Preraspodijeli" i odaberite željeni broj pitanja po stranici.';
$string['orderingquiz'] = 'Redoslijed i paginacija';
$string['orderingquizx'] = 'Redoslijed i paginacija';
$string['outcomesadvanced'] = 'Ishodi učenja su napredne postavke';
$string['outof'] = '{$a->grade} od maksimalno {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} od maksimalno {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sveobuhvatna povratna informacija';
$string['overallfeedback_help'] = 'Sveobuhvatna povratna informacija prikazuje se nakon rješavanja.testa. Ovisno o dodatnim granicama ocjena (poput postotka ili broja), prikazat će se različit tekst.';
$string['overdue'] = 'Kasne';
$string['overduehandling'] = 'Kada vrijeme istekne';
$string['overduehandlingautoabandon'] = 'Test treba predati prije isteka vremena, inače se neće uvažiti';
$string['overduehandlingautosubmit'] = 'Započeti pokušaji rješavanja se automatski predaju';
$string['overduehandling_desc'] = 'Što se događa ako student ne preda test prije nego istekne vrijeme.';
$string['overduehandlinggraceperiod'] = 'Postoji razdoblje naknadne predaje kada se započeti pokušaji mogu predati, ali bez promjene odgovora';
$string['overduehandling_help'] = 'Ova postavka određuje što se događa ako student ne preda test prije nego istekne vrijeme. Ako student radi na testu u tom trenutku, njihov će pokušaj automatski biti predan. Ova postavka određuje što se događa ako se odjavio sa sustava.';
$string['overduemustbesubmittedby'] = 'Ovaj test je već trebalo predati. Ako želite da pokušaj bude ocijenjen, morate ga predati do {$a}. Ako ga ne predate do tada, nećete biti ocijenjeni.';
$string['override'] = 'Izmijeni';
$string['overridedeletegroupsure'] = 'Želite li izbrisati izmjenu za grupu {$a}?';
$string['overridedeleteusersure'] = 'Želite li izbrisati izmjenu za korisnika {$a}?';
$string['overridegroup'] = 'Izmijeni postavke za grupu';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Izmjene';
$string['overrideuser'] = 'Izmijeni postavke za korisnika';
$string['overrideusereventname'] = '{$a->quiz} - Izmjene';
$string['page-mod-quiz-edit'] = 'Uredi stranicu testa';
$string['page-mod-quiz-x'] = 'Bilo koja stranica modula test';
$string['pagesize'] = 'Broj pokušaja prikazanih na stranici:';
$string['parent'] = 'Nadređeni';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parsingquestions'] = 'Parsiranje pitanja iz uvežene datoteke.';
$string['partiallycorrect'] = 'Djelomično točno';
$string['penalty'] = 'Negativni bodovi';
$string['penaltyscheme'] = 'Primijeni kaznene bodove';
$string['penaltyscheme_help'] = 'Ako je omogućeno, kazneni bodovi će se oduzeti od konačne ocjene pitanja, zbog prvotnog netočnog odgovora. Broj kaznenih bodova određen je u svojstvima pitanja. Ovo će se primijeniti samo ako je omogućen adaptivni način testa.';
$string['percentcorrect'] = 'Postotak točnosti';
$string['pleaseclose'] = 'Vaš zahtjev je obrađen. Možete zatvoriti ovaj prozor';
$string['pluginadministration'] = 'Administracija testa';
$string['pluginname'] = 'Test';
$string['popup'] = 'Prikaži test u \'sigurnom\' prozoru';
$string['popupblockerwarning'] = 'Ovaj dio testa prikazuje se u sigurnom načinu rada, što znači da ga trebate otvoriti u sigurnom prozoru. Potrebno je omogućiti otvaranje novih <em>popup</em> prozora. Hvala.';
$string['popupnotice'] = 'Studenti će vidjeti test u \'sigurnom\' prozoru';
$string['preprocesserror'] = 'Došlo je do pogreške prilikom pre-procesiranja!';
$string['preview'] = 'Pregled (preview)';
$string['previewquestion'] = 'Pregled pitanja (preview)';
$string['previewquiz'] = 'Pregled {$a}';
$string['previewquiznow'] = 'Pogledajte test';
$string['previous'] = 'Prethodno stanje';
$string['publish'] = 'Objavi';
$string['publishedit'] = 'Morate imate dovoljnu razinu prava u željenom kolegiju, kako biste dodali ili uredili pitanja u ovoj kategoriji. ';
$string['qbrief'] = 'P: {$a}';
$string['qname'] = 'naziv';
$string['qti'] = 'IMS QTI oblik';
$string['qtypename'] = 'vrsta, naziv';
$string['question'] = 'Pitanje';
$string['questionbankcontents'] = 'Sadržaj baze pitanja';
$string['questionbankmanagement'] = 'Upravljanje bazom pitanja';
$string['questionbehaviour'] = 'Karakteristike pitanja';
$string['questioncats'] = 'Kategorije pitanja';
$string['questiondeleted'] = 'Ovo pitanje je izbrisano. Molimo kontaktirajte nastavnika.';
$string['questioninuse'] = 'Pitanje \'{$a->questionname}\' se trenutno koristi u: <br />{$a->quiznames}<br />Ovo pitanje se neće obrisati iz tih testova, već samo iz popisa kategorija.';
$string['questionmissing'] = 'Nedostaje pitanje za ovu sesiju';
$string['questionname'] = 'Naziv pitanja';
$string['questionnonav'] = '<span class="accesshide">Pitanje </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pitanje {$a} nije učitano iz baze';
$string['questionorder'] = 'Redoslijed pitanja';
$string['questionposition'] = 'Novi redoslijed za pitanje {$a}';
$string['questions'] = 'Pitanja';
$string['questionsinclhidden'] = 'Pitanja (uključujući skrivena)';
$string['questionsinthisquiz'] = 'Pitanja u ovom testu';
$string['questionsperpage'] = 'Pitanja po stranici';
$string['questionsperpageselected'] = 'Definirana je opcija "Broj pitanja po stranici", pa je paginacija trenutno nepromjenjiva. Zbog toga je onemogućena uporaba alata za repaginaciju. To možete promijeniti u {$a}';
$string['questionsperpagex'] = 'Broj pitanja po stranici: {$a}';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontextisempty'] = '[Nema teksta pitanja]';
$string['questiontype'] = 'Tip pitanja {$a}';
$string['questiontypesetupoptions'] = 'Postavljanje opcija za vrste pitanja:';
$string['quiz:addinstance'] = 'Dodaj novi kviz';
$string['quiz:attempt'] = 'Pokušaji rješavanja testa';
$string['quizavailable'] = 'Test je dostupan do: {$a}';
$string['quizclose'] = 'Test dostupan do:';
$string['quizclosed'] = 'Test je zatvoren na datum {$a}';
$string['quizcloses'] = 'Test se zatvara';
$string['quizcloseson'] = 'Ovaj test se zatvara u: {$a}';
$string['quiz:deleteattempts'] = 'Briši pokušaje rješavanja';
$string['quiz:emailconfirmsubmission'] = 'Primanje potvrde o predaji testa e-poštom';
$string['quiz:emailnotifysubmission'] = 'Primanje obavijesti o predaji testa e-poštom';
$string['quiz:emailwarnoverdue'] = 'Obavijesti me porukom kada je pokušaj potrebno predati.';
$string['quiz:grade'] = 'Ručna ocjena testova';
$string['quiz:ignoretimelimits'] = 'Zanemaruje vremensko ograničenje testova';
$string['quizisclosed'] = 'Ovaj test nije dostupan';
$string['quizisclosedwillopen'] = 'Test je zatvoren ((otvara se {$a})';
$string['quizisopen'] = 'Ovaj test je dostupan';
$string['quizisopenwillclose'] = 'Test je dostupan (zatvara se u: {$a})';
$string['quiz:manage'] = 'Uredjivanje testova';
$string['quiz:manageoverrides'] = 'Uređivanje izmjena kviza';
$string['quiznavigation'] = 'Navigacija u testu';
$string['quizopen'] = 'Test dostupan od:';
$string['quizopenclose'] = 'Početni i krajnji datum';
$string['quizopenclose_help'] = 'Studenti mogu započeti rješavanje tek nakon otvaranja testa i moraju predati test prije zatvaranja testa.';
$string['quizopened'] = 'Test je dostupan.';
$string['quizopenedon'] = 'Test je postao dostupan u: {$a}';
$string['quizopens'] = 'Test počinje';
$string['quizopenwillclose'] = 'Ovaj test je otvoren, bit će zatvoren {$a}';
$string['quizordernotrandom'] = 'Poredak u testu nije promiješan';
$string['quizorderrandom'] = '* Poredak u testu je promiješan';
$string['quiz:preview'] = 'Pregledavanje testova';
$string['quiz:regrade'] = 'Ponovo ocijeni pokušaje';
$string['quiz:reviewmyattempts'] = 'Pregled vlastitih pokušaja';
$string['quizsettings'] = 'Postavke testa';
$string['quiztimer'] = 'Vrijeme za rješavanje test';
$string['quiz:view'] = 'Prikaži informacije o testu';
$string['quiz:viewreports'] = 'Prikaži izvještaje o testu/testovima';
$string['quizwillopen'] = 'Ovaj test se otvara {$a}';
$string['random'] = 'Slučajno pitanje';
$string['randomcreate'] = 'Stvori slučajna pitanja';
$string['randomfromcategory'] = 'Slučajno pitanje iz kategorije:';
$string['randomfromexistingcategory'] = 'Slučajno odabrano pitanje iz postojeće kategorije';
$string['randomnosubcat'] = 'Samo pitanja iz ove kategorije, ne i njezinih potkategorija.';
$string['randomquestionusinganewcategory'] = 'Slučajno odabrano pitanje iz nove kategorije';
$string['randomwithsubcat'] = 'Pitanja iz ove kategorije i njezinih potkategorija';
$string['readytosend'] = 'Predat ćete test na ocjenjivanje. Želite li nastaviti?';
$string['reattemptquiz'] = 'Pokušaj ponovo riješiti ovaj test';
$string['recentlyaddedquestion'] = 'Nedavno dodano pitanje!';
$string['recurse'] = 'Prikaži i pitanja iz potkategorija';
$string['regrade'] = 'Ponovo ocijeni sve pokušaje';
$string['regradecomplete'] = 'Svi pokušaji su ponovo ocijenjeni';
$string['regradecount'] = '{$a->changed} od {$a->attempt} ocjena je promijenjeno';
$string['regradedisplayexplanation'] = 'Pokušaji koji su promijenjeni tijekom ponovnog ocjenjivanja su prikazani kao poveznice na pregled pitanja';
$string['regradenotallowed'] = 'Nemate ovlasti za ponovno ocjenjivanje ovog testa';
$string['regradingquestion'] = 'Ponovno ocjenjivanje "{$a}".';
$string['regradingquiz'] = 'Ponovno ocjenjivanje testa "{$a}"';
$string['remove'] = 'Ukloni';
$string['removeallquizattempts'] = 'Ukloni sve pokušaje rješavanja testa';
$string['removeemptypage'] = 'Ukloni praznu stranicu';
$string['removeselected'] = 'Ukloni označeno';
$string['rename'] = 'Preimenuj';
$string['renderingserverconnectfailed'] = 'Poslužitelj {$a} nije uspio obraditi RQP zahtjev. Provjerite je li URL točan.';
$string['reorderquestions'] = 'Promijeni redoslijed pitanja';
$string['reordertool'] = 'Prikaži alat za promjenu redoslijeda';
$string['repaginate'] = 'Promijeni broj pitanja po stranici na {$a}';
$string['repaginatecommand'] = 'Repaginiraj';
$string['repaginatenow'] = 'Repaginiraj sada';
$string['replace'] = 'Zamijenite';
$string['replacementoptions'] = 'Mogućnost zamjene';
$string['report'] = 'Izvještaji';
$string['reportanalysis'] = 'Analiza odgovora';
$string['reportattemptsfrom'] = 'Pokušaji rješavanja -';
$string['reportattemptsthatare'] = 'Pokušaji rješavanja koji su';
$string['reportdisplayoptions'] = 'Opcije prikaza';
$string['reportfullstat'] = 'Detaljna statistika';
$string['reportmulti_percent'] = 'Postotci odgovora';
$string['reportmulti_q_x_student'] = 'Odabiri studenata';
$string['reportmulti_resp'] = 'Individualni odgovori';
$string['reportmustselectstate'] = 'Morate odabrati barem jedno stanje.';
$string['reportnotfound'] = 'Izvještaj nije poznat ({$a})';
$string['reportoverview'] = 'Pregled';
$string['reportregrade'] = 'Ponovna ocjena pokušaja rješavanja testa';
$string['reportresponses'] = 'Detaljni odgovori';
$string['reports'] = 'Izvještaji';
$string['reportshowonly'] = 'Prikaži samo pokušaje';
$string['reportshowonlyfinished'] = 'Prikaži najviše jedan predani pokušaj po korisniku ({$a})';
$string['reportsimplestat'] = 'Jednostavna statistika';
$string['reportusersall'] = 'svih korisnika koji su rješavali test';
$string['reportuserswith'] = 'korisnika na kolegiju koji su rješavali test';
$string['reportuserswithorwithout'] = 'korisnika na kolegiju koji jesu, ili nisu, rješavali test';
$string['reportuserswithout'] = 'korisnika na kolegiju koji nisu rješavali test';
$string['reportwhattoinclude'] = 'Što uključiti u izvještaj';
$string['requirepassword'] = 'Lozinka za pristup testu';
$string['requirepassword_help'] = 'Ako unesete lozinku, studenti će ju morati upisati prije nego pristupie testu.';
$string['requiresubnet'] = 'Ograniči pristup samo ovim IP adresama';
$string['requiresubnet_help'] = 'Pristup testu je ograničen na posebne dijelove (podmreže) LAN-a ili Interneta, definirane kao lista djelomičnih ili punih IP-adresa, odvojenih zarezom. Ovo može biti korisno za testove u učionici, kako bi se osiguralo da samo korisnici na toj lokaciji mogu pristupiti testu.';
$string['response'] = 'Odgovor';
$string['responses'] = 'Odgovori studenta';
$string['results'] = 'Rezultati';
$string['returnattempt'] = 'Povratak na pokušaj';
$string['reuseifpossible'] = 'ponovno koristi izbrisano';
$string['reverttodefaults'] = 'Vrati postavke testa na zadane';
$string['review'] = 'Pregled';
$string['reviewafter'] = 'Dopusti pregled nakon što se test zatvori';
$string['reviewalways'] = 'Dopusti pregled u bilo koje vrijeme';
$string['reviewattempt'] = 'Pregledaj pokušaj';
$string['reviewbefore'] = 'Dopusti pregled dok je test otvoren';
$string['reviewclosed'] = 'Nakon zatvaranja testa';
$string['reviewduring'] = 'Prilikom rješavanja';
$string['reviewimmediately'] = 'Odmah nakon rješavanja';
$string['reviewnever'] = 'Nikad ne dopusti pregled';
$string['reviewofattempt'] = 'Pregled pokušaja {$a}';
$string['reviewofpreview'] = 'Pregled prikaza';
$string['reviewopen'] = 'Kasnije, dok je test još otvoren';
$string['reviewoptions'] = 'Studenti mogu pregledavati';
$string['reviewoptionsheading'] = 'Postavke pregleda testa';
$string['reviewoptionsheading_help'] = 'Ove opcije određuju što student može vidjeti prilikom kasnijeg pregleda testa.

**Prilikom rješavanja** je opcija korisna samo za neke karakteristike testa, poput \'višestrukih pokušaja odgovaranja na pitanje\', koji mogu prikazivati povratne informacije prilikom rješavanja.

**Odmah nakon rješavanja** označava vrijeme unutar 2 minute nakon što je odabrano "Predajte sve i završite".

**Kasnije, dok je test još otvoren** znači nakon 2 minute, no prije datuma zatvaranja testa.

**Nakon zatvaranja testa** znači nakon što je prošao datum zatvaranja testa. Ako test nema datum zatvaranja, ovaj se datum nikad neće dostići.';
$string['reviewoverallfeedback'] = 'Sveobuhvatna povratna informacija';
$string['reviewoverallfeedback_help'] = 'Povratna informacija nakon rješavanja, koja ovisi o ukupnoj ocjeni testa.';
$string['reviewresponse'] = 'Pregled odgovora';
$string['reviewresponsetoq'] = 'Pregledaj odgovore (pitanje {$a})';
$string['reviewthisattempt'] = 'Pregledavanje vlastitih odgovora u ovom pokušaju';
$string['rqp'] = 'Udaljeno pitanje';
$string['rqps'] = 'Udaljena pitanja';
$string['sameasoverall'] = 'Isti kao i za ukupne ocjene';
$string['save'] = 'Pohrani';
$string['saveandedit'] = 'Pohrani promjene i uredi pitanja';
$string['saveattemptfailed'] = 'Pogreška pri pohrani trenutnog pokušaja rješavanja testa.';
$string['savedfromdeletedcourse'] = 'Pohranjeno iz obrisanog kolegija "{$a}"';
$string['savegrades'] = 'Pohrani ocjene';
$string['savemyanswers'] = 'Pohrani moje odgovore';
$string['savenosubmit'] = 'Pohrani odgovore bez predavanja';
$string['saveoverrideandstay'] = 'Pohrani i unesi novu izmjenu pravila';
$string['savequiz'] = 'Pohranite cijeli test';
$string['saving'] = 'Pohranjivanje';
$string['savingnewgradeforquestion'] = 'Spremanje nove ocjene za pitanje koje ima ID {$a}.';
$string['savingnewmaximumgrade'] = 'Spremanje nove najviše ocjene.';
$string['score'] = 'Neobrađeni rezultat';
$string['scores'] = 'Rezultati';
$string['select'] = 'Odaberi';
$string['selectall'] = 'Odaberi sve';
$string['selectcategory'] = 'Odaberi kategoriju';
$string['selectedattempts'] = 'Odabrani pokušaji...';
$string['selectnone'] = 'Odznači sve';
$string['selectquestiontype'] = '-- Odaberite vrstu pitanja --';
$string['serveradded'] = 'Dodan poslužitelj';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Informacije poslužitelja';
$string['servers'] = 'Poslužitelji';
$string['serverurl'] = 'URL poslužitelja';
$string['settingsoverrides'] = 'Izmjene pravila';
$string['shortanswer'] = 'Kratki odgovor';
$string['show'] = 'Prikaz';
$string['showall'] = 'Prikaži sva pitanja na jednoj stranici';
$string['showblocks'] = 'Prikaži blokove tijekom rješavanja testa.';
$string['showblocks_help'] = 'Ako je ovo omogućeno, tijekom rješavanja testa će na stranici biti prikazani uobičajeni blokovi.';
$string['showbreaks'] = 'Prikaži prijelome stranica';
$string['showcategorycontents'] = 'Prikaži sadržaj kategorija {$a->arrow}';
$string['showcorrectanswer'] = 'Prikaži točne odgovore u sklopu povratnih informacija?';
$string['showdetailedmarks'] = 'Prikaži detaljne informacije o bodovima';
$string['showeachpage'] = 'Prikaži jednu po jednu stranicu';
$string['showfeedback'] = 'Prikazati povratnu informaciju poslije predaje?';
$string['showinsecurepopup'] = 'Rješavanje testa u "sigurnom" novom prozoru.';
$string['showlargeimage'] = 'Velika slika';
$string['shownoattempts'] = 'Prikaži studente koji nisu pokušali riješiti test';
$string['shownoattemptsonly'] = 'Prikaži samo studente koji još nisu rješavali test';
$string['shownoimage'] = 'Bez slike';
$string['showreport'] = 'Prikaži izvještaj';
$string['showsmallimage'] = 'Mala slika';
$string['showteacherattempts'] = 'Prikaži pokušaje rješavanja od strane nastavnika';
$string['showuserpicture'] = 'Prikaži sliku studenta';
$string['showuserpicture_help'] = 'Ako je omogućeno, ime i slika studenta će se prikazati na zaslonu pri rješavanju testa, kao i pri pregledu rezultata. To nam olakšava provjeru identiteta prijavljenog studenta prilikom rješavanja testa u učionici.';
$string['shuffle'] = 'Izmiješaj';
$string['shuffleanswers'] = 'Izmiješaj redoslijed pitanja';
$string['shuffledrandomly'] = 'Izmiješano slučajnim rasporedom';
$string['shufflequestions'] = 'Izmiješaj redoslijed odgovora';
$string['shufflequestionsselected'] = 'Postavljena je opcija miješanja rasporeda pitanja, pa neke mogućnosti vezane za upravljanje stranicama nisu dostupne. Za promjenu opcije miješanja, {$a}.';
$string['shufflewithin'] = 'Izmiješaj redoslijed odgovora';
$string['shufflewithin_help'] = 'Ako je omogućeno, elementi koji čine pojedino pitanje će se odabrati nasumično, svaki puta kada student rješava test, uz uvjet da je ta opcija omogućena u postavkama pitanja. Ova postavka se odnosi samo na pitanja koja se sastoje od više elemenata, poput višestrukog odabira ili uparivanja.';
$string['singleanswer'] = 'Odaberite jedan odgovor.';
$string['sortage'] = 'Sortiraj po starosti';
$string['sortalpha'] = 'Sortiraj po imenu';
$string['sortquestionsbyx'] = 'Sortiraj pitanja po: {$a}';
$string['sortsubmit'] = 'Sortiraj pitanja';
$string['sorttypealpha'] = 'Sortiraj po vrsti, nazivu';
$string['specificapathnotonquestion'] = 'Put do datoteke nije u odabranom pitanju';
$string['specificquestionnotonquiz'] = 'Pitanje se ne nalazi u odabranom testu.';
$string['startagain'] = 'Počni ispočetka';
$string['startattempt'] = 'Započni rješavanje';
$string['startedon'] = 'Započeto';
$string['startnewpreview'] = 'Započni novi pregled';
$string['stateabandoned'] = 'Nikada nije predano';
$string['statefinished'] = 'Završeno';
$string['statefinisheddetails'] = 'Predano {$a}';
$string['stateinprogress'] = 'U tijeku';
$string['statenotloaded'] = 'Stanje pitanja {$a} nije učitano iz baze podataka';
$string['stateoverdue'] = 'Kašnjenje';
$string['stateoverduedetails'] = 'Mora biti predano do {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Zaustavi pri pogrešci';
$string['submitallandfinish'] = 'Predaj sve i završi';
$string['subneterror'] = 'Nažalost, ovom testu je moguće pristupiti samo s nekih računala. Trenutno vaše računalo nije na popisu dopuštenih.';
$string['subnetnotice'] = 'Nažalost, ovom testu je moguće pristupiti samo s nekih računala. Trenutno vaše računalo nije na popisu dopuštenih . No, kao nastavnik ga ipak možete pregledati.';
$string['subplugintype_quiz'] = 'Izvještaj';
$string['subplugintype_quizaccess'] = 'Pristupno pravilo';
$string['subplugintype_quizaccess_plural'] = 'Pristupna pravila';
$string['subplugintype_quiz_plural'] = 'Izvještaji';
$string['substitutedby'] = 'će biti zamijenjeno sa';
$string['summaryofattempt'] = 'Sažetak pokušaja';
$string['summaryofattempts'] = 'Sažetak prethodnih pokušaja';
$string['temporaryblocked'] = 'U ovom trenutku ne možete ponoviti ovaj test.<br/>Moći ćete ponovno pokušati:';
$string['theattempt'] = 'Pokušaj rješavanja';
$string['theattempt_help'] = 'Može li student pregledavati pokušaje';
$string['time'] = 'Vrijeme';
$string['timecompleted'] = 'Završeno';
$string['timedelay'] = 'Ne možete pristupiti testu jer nije prošlo dovoljno vremena od rješavanja prethodnog testa';
$string['timeleft'] = 'Preostalo vrijeme';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimitexeeded'] = 'Žalim! Vremensko ograničenje testa je isteklo!';
$string['timelimit_help'] = 'Ako je omogućeno, u bloku s navigacijom testa bit će prikazano vremensko ograničenje i štoperica.';
$string['timelimitmin'] = 'Vremensko ograničenje (u minutama)';
$string['timelimitsec'] = 'Vremensko ograničenje (u sekundama)';
$string['timestr'] = '%H:%M:%S - %d/%m/%y';
$string['timesup'] = 'Vrijeme je isteklo!';
$string['timetaken'] = 'Proteklo vrijeme';
$string['timing'] = 'Vrijeme';
$string['tofile'] = 'u datoteku';
$string['tolerance'] = 'Tolerancija';
$string['toomanyrandom'] = 'Broj pitanja potrebnih za slučajni odabir je veći nego broj trenutno dostupnih pitanja u ovoj kategoriji!';
$string['top'] = 'Vrh';
$string['totalmarksx'] = 'Ukupna ocjena {$a}';
$string['totalquestionsinrandomqcategory'] = 'Broj pitanja u kategoriji: {$a}.';
$string['true'] = 'Točno';
$string['truefalse'] = 'Točno/Netočno';
$string['type'] = 'Vrsta';
$string['unfinished'] = 'otvoreno';
$string['ungraded'] = 'Neocijenjeno';
$string['unit'] = 'Jedinica';
$string['unknowntype'] = 'Vrsta pitanja u retku {$a} nije podržana. Pitanje će se zaobići.';
$string['unusedcategorydeleted'] = 'Ova kategorija je izbrisana jer, nakon brisanja kolegija, pitanja više nisu bila u uporabi.';
$string['updatesettings'] = 'Izmjeni postavke testa';
$string['updatingatttemptgrades'] = 'Nadogradnja ocjena za pokušaj.';
$string['updatingfinalgrades'] = 'Nadogradnja završnih ocjena.';
$string['updatingthegradebook'] = 'Nadogradnja popisa ocjena.';
$string['upgradesure'] = '<div>Modul Test će provesti veliku promjenu tablica testa u bazi podataka. Ova nadogradnja nije dovoljno testirana. Preporučujemo vam da izradite sigurnosnu kopiju tablica baze podataka prije nastavka.</div>';
$string['upgradingquizattempts'] = 'Nadogradnja pokušaja rješavanja: test {$a->done}/{$a->outof} (ID testa {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Nadogradnja vrlo starih pokušaja rješavanja testa:{$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Ova kategorija je sačuvana i premještena na razinu sjedišta, jer je objavljena i još uvijek se koristi u drugim kolegijima.';
$string['useroverrides'] = 'Izmjene za korisnike';
$string['usersnone'] = 'Niti jedan student nema pristup ovom testu';
$string['validate'] = 'Provjeri';
$string['viewallanswers'] = 'Prikaži predane testove: {$a}';
$string['viewallreports'] = 'Prikaži izvještaj za {$a} pokušaja';
$string['viewed'] = 'Pogledano';
$string['warningmissingtype'] = '<b>Podrška za ovu vsrtu pitanja još nije instalirana na ovo Moodle sjedište.<br />Molimo javite se svom Moodle administratoru.</b>';
$string['wheregrade'] = 'Gdje je moja ocjena?';
$string['wildcard'] = 'Zamjenski znak (Joker)';
$string['windowclosing'] = 'Ovaj prozor će se ubrzo zatvoriti.';
$string['withsummary'] = 'sa sažetkom statistike';
$string['wronguse'] = 'Nije moguće koristiti stranicu na ovaj način';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Prije rješavanja testa potrebno se upisati na kolegij.';
$string['yourfinalgradeis'] = 'Vaša završna ocjena na ovom testu je {$a}';
