<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Operacija';
$string['addanotherhint'] = 'Dodaj još savjeta';
$string['addcategory'] = 'Dodaj kategoriju';
$string['addmorechoiceblanks'] = 'Dodatnih praznih odgovora: {no}';
$string['adminreport'] = 'Izvještaj o mogućim problemima u vašoj bazi pitanja';
$string['answer'] = 'Odgovor';
$string['answers'] = 'Odgovori';
$string['answersaved'] = 'Odgovor pohranjen';
$string['attemptfinished'] = 'Pokušaj rješavanja završen';
$string['attemptfinishedsubmitting'] = 'Pokušaj rješavanja završen, predani odgovor:';
$string['attemptoptions'] = 'Postavke pokušaja';
$string['availableq'] = 'Dostupno?';
$string['badbase'] = 'Loša baza prije **: {$a}**';
$string['behaviour'] = 'Ponašanje';
$string['behaviourbeingused'] = 'Korištena karakteristika pitanja:';
$string['broken'] = 'Ovo je "neispravna poveznica", pokazuje na nepostojeću datoteku.';
$string['byandon'] = 'uredio/la <em>{$a->user}</em> (<em>{$a->time}</em>)';
$string['cannotcopybackup'] = 'Nije bilo moguće kopirati backup datoteku';
$string['cannotcreate'] = 'Nije moguće stvoriti novi zapis u tablici question_attempts';
$string['cannotcreatepath'] = 'Nije moguće stvoriti putanju: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Nije moguće izbrisati karakteristiku pitanja: \'{$a}\'. Već se koristi u pokušajima rješavanja.';
$string['cannotdeletecate'] = 'Ne možete izbrisati ovu kategoriju, budući da je u ovom kontekstu to zadana kategorija.';
$string['cannotdeleteneededbehaviour'] = 'Nije moguće izbrisati karakteristiku pitanja \'{$a}\'. Instalirane su druge karakteristike koje o njoj ovise.';
$string['cannotdeleteqtypeinuse'] = 'Ne možete izbrisati vrstu pitanja \'{$a}\'. U bazi pitanja postoje pitanja ove vrste.';
$string['cannotdeleteqtypeneeded'] = 'Ne možete izbrisati vrstu pitanja \'{$a}\'. Postoje druge vrste pitanja koje ovise o toj vrsti.';
$string['cannotenable'] = 'Ovu vrstu pitanja ({$a}) nije moguće direktno stvoriti.';
$string['cannotenablebehaviour'] = 'Nije moguće izravno koristiti karakteristku pitanja {$a}. Ona je samo za internu uporabu.';
$string['cannotfindcate'] = 'Nije moguće pronaći zapis kategorije';
$string['cannotfindquestionfile'] = 'Nije moguće pronaći datoteku s pitanjima u dotičnoj zip arhivi';
$string['cannotgetdsfordependent'] = 'Nije moguće dohvatiti zadani skup podataka za pitanje koje ovisi o skupu podataka! (pitanje: {$a[0]}, datasetitem: {a[1]})';
$string['cannotgetdsforquestion'] = 'Nije moguće pronaći zadani skup podataka za računsko pitanje! (pitanje {$a})';
$string['cannothidequestion'] = 'Nije bilo moguće sakriti pitanje';
$string['cannotimportformat'] = 'Nažalost, uvoz ovog oblika nije još implementiran!';
$string['cannotinsertquestion'] = 'Nije bilo moguće umetnuti novo pitanje!';
$string['cannotinsertquestioncatecontext'] = 'Nije bilo moguće umetnuti novu kategoriju pitanja {$a->cat} illegal contextid {$a->ctx}';
$string['cannotloadquestion'] = 'Nije bilo moguće učitati pitanje';
$string['cannotmovequestion'] = 'Ne možete koristiti ovu skriptu za premještanje pitanja koja imaju pridružene datoteke iz drugih područja.';
$string['cannotopenforwriting'] = 'Ne mogu otvoriti za pisanje: {$a}';
$string['cannotpreview'] = 'Ne možete pregledati ova pitanja!';
$string['cannotread'] = 'Ne mogu čitati podatke iz datoteke za uvoz podataka (ili je datoteka prazna)';
$string['cannotretrieveqcat'] = 'Nije bilo moguće pronaći kategoriju pitanja';
$string['cannotunhidequestion'] = 'Nije bilo moguće učiniti pitanje vidljivim';
$string['cannotunzip'] = 'Nije bilo moguće otpakirati zip arhivu.';
$string['cannotwriteto'] = 'Nije moguće zapisati izvežena pitanja u {$a}';
$string['category'] = 'Kategorija';
$string['categorycurrent'] = 'Trenutna kategorija';
$string['categorycurrentuse'] = 'Koristi ovu kategoriju';
$string['categorydoesnotexist'] = 'Navedena kategorija ne postoji';
$string['categoryinfo'] = 'Informacija o kategoriji';
$string['categorymove'] = 'Kategorija \'{$a->name}\' sadrži {$a->count} pitanja.  (neka od njih mogu biti stara, skrivena ili pitanja koja se i dalje koriste u postojećim testovima).<br /> Odaberite drugu kategoriju u koju ćete ih premjestiti.';
$string['categorymoveto'] = 'Pohrani u kategoriju';
$string['categorynamecantbeblank'] = 'Naziv kategorije ne može biti prazan.';
$string['changeoptions'] = 'Promijeni opcije';
$string['changepublishstatuscat'] = '<a href="{$a->caturl}">Kategoriji "{$a->name}"</a> unutar kolegija "{$a->coursename}" će od sada biti promijenjen status dijeljenja iz <strong>{$a->changefrom} u {$a->changeto}</strong>.';
$string['check'] = 'Provjeri';
$string['chooseqtypetoadd'] = 'Odaberite vrstu pitanja za dodavanje';
$string['clearwrongparts'] = 'Izbriši netočne odgovore';
$string['clickflag'] = 'Označi pitanje';
$string['clicktoflag'] = 'Kliknite za postavljanje oznake neprikladnosti';
$string['clicktounflag'] = 'Kliknite za uklanjanje oznake neprikladnosti';
$string['clickunflag'] = 'Kliknite za uklanjanje oznake neprikladnosti';
$string['closepreview'] = 'Zatvori pregled';
$string['combinedfeedback'] = 'Kombinirana povratna informacija';
$string['comment'] = 'Komentar';
$string['commented'] = 'Komentirano: {$a}';
$string['commentormark'] = 'Komentirajte ili izmijenite ocjenu';
$string['comments'] = 'Komentari';
$string['commentx'] = 'Komentar: {$a}';
$string['complete'] = 'Završeno';
$string['contexterror'] = 'Ovdje niste trebali dospjeti osim ako ne premještate kategoriju u neki drugi kontekst';
$string['copy'] = 'Kopiraj iz {$a} i promijeni poveznice.';
$string['correct'] = 'Točno';
$string['correctfeedback'] = 'Za bilo koji točan odgovor';
$string['correctfeedbackdefault'] = 'Vaš odgovor je točan.';
$string['created'] = 'Stvoreno';
$string['createdby'] = 'Stvorio';
$string['createdmodifiedheader'] = 'Stvorio / Zadnji pohranio';
$string['createnewquestion'] = 'Stvori novo pitanje ...';
$string['cwrqpfs'] = 'Pitanja slučajnim odabirom odabiru pitanja iz podkategorija.';
$string['cwrqpfsinfo'] = '<p>Prilikom nadogradnje na Moodle 1.9 kategorije pitanja se dijele u razne kontekste. Nekim kategorijama pitanja i samim pitanjima na vašem poslužitelju treba promijeniti postavke dijeljenja. Ovo je neophodno u rijetkim slučajevima da su jedno ili više \'slučajnih\' pitanja u testu postavljena tako da odabiru pitanja iz mješavine dijeljenih i nedijeljenih kategorija (kao što je slučaj na ovom poslužitelju).</p>
<p>Sve kategorije i podkategorije iz kojih se odabiru \'slučajna\' pitanja će nakon ove operacije imati _JEDNAK_ status dijeljenja.</p>
<p>Pitanja koja su zahvaćena ovim će nastaviti raditi na svim postojećim testovima dok ih ne uklonite iz tih testova.</p> ';
$string['cwrqpfsnoprob'] = 'Nijedno kategorija pitanja na vašem poslužitelju nije pogođena problemom "Pitanja slučajnim odabirom odabiru pitanja iz podkategorija.".';
$string['decimalplacesingrades'] = 'Decimalna mjesta u ocjenama';
$string['defaultfor'] = 'Zadano za {$a}';
$string['defaultinfofor'] = 'Zadana kategorija za pitanja iz konteksta \'{$a}\'.';
$string['defaultmark'] = 'Zadani bodovi';
$string['defaultmarkmustbepositive'] = 'Zadana ocjena mora biti pozitivna.';
$string['deletecoursecategorywithquestions'] = 'Postoje pitanja u bazi pitanja povezana s ovom kategorijom na razini kolegija. Ako nastavite, ista će biti obrisana. Možete ih pokušati prvo premjestiti, koristeći sučelje baze pitanja.';
$string['deletequestioncheck'] = 'Želite li uistinu izbrisati \'{$a}\'?';
$string['deletequestionscheck'] = 'Želite li uistinu obrisati sljedeća pitanja?<br /><br />{$a}';
$string['deletingbehaviour'] = 'Brisanje karakteristike pitanja \'{$a}\'';
$string['deletingqtype'] = 'Brisanje tipa pitanja \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Nema poklapanja niti s jednim odgovorom]';
$string['disabled'] = 'Onemogućeno';
$string['displayoptions'] = 'Postavke prikaza';
$string['disterror'] = 'Distribucija {$a} je izazvala probleme';
$string['donothing'] = 'Nemoj kopirati/premještati datoteke ili mijenjati poveznice.';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategories_help'] = 'Pitanja moraju biti podijeljena u kategorije i potkategorije.

Svaka kategorija ima kontekst koji određuje gdje se pitanja iz određene kategorije mogu koristiti:

* Kontekst aktivnosti - Pitanja su dostupna samo u sklopu modula aktivnosti
* Kontekst kolegija - Pitanja su dostupna samo u sklopu modula aktivnosti na razini kolegija
* Kontekst kategorije kolegija - Pitanja su dostupna u sklopu svih modula aktivnosti unutar neke kategorije kolegija
* Kontekst sustava - Pitanja su dostupna na svim kolegijima i aktivnostima na poslužitelju

Kategorije se koriste i za pitanja odabrana slučajnim redoslijedom, budući da se ista odabiru iz pojedinih kategorija.';
$string['editcategory'] = 'Uredi kategoriju';
$string['editingcategory'] = 'Uređivanje kategorija';
$string['editingquestion'] = 'Uređivanje pitanja';
$string['editquestion'] = 'Uredi pitanje';
$string['editquestions'] = 'Uredi pitanja';
$string['editthiscategory'] = 'Uredi ovu kategoriju';
$string['emptyxml'] = 'Nepoznata pogreška - prazan imsmanifest.xml';
$string['enabled'] = 'Omogućeno';
$string['erroraccessingcontext'] = 'Nije moguće pristupiti kontekstu';
$string['errordeletingquestionsfromcategory'] = 'Poreška pri brisanju pitanja iz kategorije {$a}.';
$string['errorduringpost'] = 'Dogodila se pogreška pri naknadnoj obradi.';
$string['errorduringpre'] = 'Dogodila se pogreška pri procesima prije obrade.';
$string['errorduringproc'] = 'Dogodila se pogreška pri obradi!';
$string['errorduringregrade'] = 'Nije bilo moguće ponovo ocjeniti pitanje {$a->qid}, prelazim na stanje {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Pogreška: nije moguće kopirati datoteku {$a}.';
$string['errorfilecannotbemoved'] = 'Pogreška: nije moguće premjestiti datoteku {$a}.';
$string['errorfileschanged'] = 'Pogreška: datoteke koje su povezane s pitanjem su se promijenile otkad je obrazac prikazan.';
$string['errormanualgradeoutofrange'] = 'Ocjena {$a->grade} se ne nalazi između 0 i {$a->maxgrade} za pitanje {$a->name}. Rezultat i komentar nisu pohranjeni.';
$string['errormovingquestions'] = 'Pogreška pri premještanju pitanja s id vrijednostima {$a}.';
$string['errorpostprocess'] = 'Dogodila se pogreška pri naknadnoj obradi!';
$string['errorpreprocess'] = 'Dogodila se pogreška pri procesima prije obrade.';
$string['errorprocess'] = 'Dogodila se pogreška pri obradi!';
$string['errorprocessingresponses'] = 'Dogodila se pogreška pri obradi vaših odgovora ({$a}). Vratite se na prethodnu stranicu i pokušajte ponovno.';
$string['errorsavingcomment'] = 'Pogreška pri pohrani komentara na pitanje {$a->name} u bazu podataka.';
$string['errorsavingflags'] = 'Pogreška pri pohrani stanja zastavice.';
$string['errorupdatingattempt'] = 'Pogreška pri pokušaju osvježavanju {$a->id} u bazi podataka.';
$string['exportcategory'] = 'Izvoz kategorije';
$string['exportcategory_help'] = 'Ova postavka određuje kategoriju iz koje će izvežena pitanja biti preuzeta.

Određeni oblici uvoza, kao što su GIFT i Moodle XML, dopuštaju obuhvaćanje informacija o kategoriji i kontekstu, omogućujući njihovo (opcionalno) ponovno stvaranje pri uvozu. Ako vam je to neophodno, označite pripadajuća polja za izbor.';
$string['exporterror'] = 'Dogodila se pogreška pri izvozu podataka!';
$string['exportfilename'] = 'test';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = 'Izvezi pitanja u datoteku';
$string['exportquestions_help'] = 'Ova funkcija omogućava izvoz cijele kategorije pitanja (i bilo koje potkategorije) u datoteku. Imajte na umu da se, ovisno o odabranom obliku, neki podaci o pitanjima i određene vrste pitanja ne mogu izvesti. ';
$string['feedback'] = 'Povratna informacija';
$string['filecantmovefrom'] = 'Datoteke s pitanjima se ne mogu premještati jer nemate ovlasti za uklanjanje datoteka s lokacije s koje ih želite prebaciti.';
$string['filecantmoveto'] = 'Datoteke s pitanjima se ne mogu premještati jer nemate ovlasti za dodavanje datoteka na lokaciji na koju ih želite prebaciti.';
$string['fileformat'] = 'Oblik datoteke';
$string['filesareacourse'] = 'prostor za datoteke kolegija';
$string['filesareasite'] = 'prostor za datoteke poslužitelja';
$string['filestomove'] = 'Premjesti / kopiraj datoteke u {$a}?';
$string['fillincorrect'] = 'Unesi točne odgovore';
$string['flagged'] = 'Označeno';
$string['flagthisquestion'] = 'Označi ovo pitanje';
$string['formquestionnotinids'] = 'Obrazac sadrži pitanje koje nije u questionids';
$string['fractionsnomax'] = 'Jedan od odgovora MORA imati rezultat od 100% kako bi bilo moguće dobiti sve bodove za ovo pitanje.';
$string['generalfeedback'] = 'Općenita povratna informacija';
$string['generalfeedback_help'] = 'Općenita povratna informacija prikazuje se nakon što je student odgovorio na pitanje. Za razliku od specifične povratne informacije, koja ovisi o vrsti pitanja i odgovoru studenta, općenita povratna informacija je ista za sve studente.

Općenitu povratnu informaciju možete koristiti za cjelovito objašnjavanje odgovora, možda uz poveznicu na više informacija o gradivu.';
$string['getcategoryfromfile'] = 'Preuzmi kategoriju iz datoteke';
$string['getcontextfromfile'] = 'Preuzmi kontekst iz datoteke';
$string['hidden'] = 'Skriveno';
$string['hintn'] = 'Savjet {no}';
$string['hintnoptions'] = 'Opcije za savjet {no}';
$string['hinttext'] = 'Tekst savjeta';
$string['howquestionsbehave'] = 'Karakteristike pitanja';
$string['ignorebroken'] = 'Zanemari neispravne poveznice';
$string['importcategory'] = 'Uvoz kategorije';
$string['importcategory_help'] = 'Ova postavka određuje kategoriju u koju će uvežena pitanja biti postavljena.

Određeni oblici uvoza, kao što su GIFT i Moodle XML, dopuštaju obuhvaćanje informacija o kategoriji i kontekstu. Ako želite koristiti te podatke, a ne odabranu kategoriju, označite pripadajuća polja za izbor. Ako kategorije navedene u datoteci iz koje uvozite podatke ne postoje na poslužitelju, bit će stvorene.';
$string['importerror'] = 'Dogodila se pogreška prilikom obrade uvoza';
$string['importerrorquestion'] = 'Pogreška pri uvozu pitanja';
$string['importfromcoursefiles'] = '... ili odaberite datoteku kolegija za uvoz.';
$string['importfromupload'] = 'Odaberite datoteku za prijenos ...';
$string['importingquestions'] = 'Uvoz {$a} pitanja iz datoteke';
$string['importparseerror'] = 'Pronađene su pogreške prilikom parsiranja datoteke za uvoz. Nijedno pitanje nije uvezeno. Za uvoz valjanih pitanja pokušajte postaviti opciju \'Zaustavi pri pogrešci\' na \'Ne\'.';
$string['importquestions'] = 'Uvezi pitanja iz datoteke';
$string['importquestions_help'] = 'Ova funkcija omogućuje uvoz pitanja u različitim oblicima putem tekstualne datoteke. Imajte na umu da datoteka mora koristiti kodnu stranicu UTF-8.';
$string['importwrongfiletype'] = 'Oblik datoteke koju ste odabrali ({$a->actualtype}) ne odgovara očekivanom obliku za uvoz ({$a->expectedtype}).';
$string['impossiblechar'] = 'Nedopušteni znak {$a} prepoznat kao znak zagrade';
$string['includesubcategories'] = 'Prikaži i pitanja iz potkategorija';
$string['incorrect'] = 'Netočno';
$string['incorrectfeedback'] = 'Za bilo koji netočan odgovor';
$string['incorrectfeedbackdefault'] = 'Vaš odgovor nije točan.';
$string['information'] = 'Informacija';
$string['invalidanswer'] = 'Nepotpun odgovor';
$string['invalidarg'] = 'Neispravni argumenti ili netočne postavke poslužitelja';
$string['invalidcategoryidforparent'] = 'Neispravan ID nadređene kategorije!';
$string['invalidcategoryidtomove'] = 'Neispravan ID kategorije koju želite premjestiti!';
$string['invalidconfirm'] = 'Niz za potvrdu nije valjan';
$string['invalidcontextinhasanyquestions'] = 'Pružen je neispravan kontekst question_context_has_any_questions.';
$string['invalidgrade'] = 'Ocjene ne odgovaraju opcijama ocjenjivanja - pitanje je preskočeno';
$string['invalidpenalty'] = 'Kazneni bodovi nisu valjani';
$string['invalidwizardpage'] = 'Navedena je neispravna stranica ili ona na kojoj nema vođenog kretanja (čarobnjaka)!';
$string['lastmodifiedby'] = 'Zadnja izmjena';
$string['linkedfiledoesntexist'] = 'Datoteka {$a} na koju vodi poveznica ne postoji';
$string['makechildof'] = 'Podredi \'{$a}\'';
$string['makecopy'] = 'Kopiraj';
$string['maketoplevelitem'] = 'Premjesti na najvišu razinu';
$string['manualgradeoutofrange'] = 'Ocjena je izvan dopuštenog opsega.';
$string['manuallygraded'] = 'Ručno ocijenjeno, broj bodova: {$a->mark} uz komentar: {$a->comment}';
$string['mark'] = 'Bod';
$string['markedoutof'] = 'Broj bodova od';
$string['markedoutofmax'] = 'Broj bodova od {$a}';
$string['markoutofmax'] = 'Broj bodova: {$a->mark} od {$a->max}';
$string['marks'] = 'Bodovi';
$string['matchgrades'] = 'Podudaranje ocjena';
$string['matchgradeserror'] = 'Pogreška ako se ocjena ne nalazi na popisu';
$string['matchgrades_help'] = 'Uvežene ocjene moraju se podudarati s fiksnim popisom valjanih ocjena - 100, 90, 80, 75, 70, 66.666, 60, 50, 40, 33.333, 30, 25, 20, 16.666, 14.2857, 12.5, 11.111, 10, 5, 0 (također i negativne vrijednosti). Ako se ne podudaraju, postoje 2 mogućnosti:

* Pogreška ako se ocjena ne nalazi na popisu - Ako pitanje sadrži ocjene koje se ne nalaze na popisu, prikazuje se pogreška i pitanje neće biti uveženo
* Najbliža ocjena ako se ocjena ne nalazi na popisu - Ako nije moguće pronaći ocjenu na popisu valjanih, ocjena se mijenja u onu s popisa s kojom se najviše podudara (ili od koje se najmanje razlikuje)';
$string['matchgradesnearest'] = 'Najbliža ocjena ako se ocjena ne nalazi na popisu';
$string['missingcourseorcmid'] = 'Print_question zahtjeva courseid ili cmid.';
$string['missingcourseorcmidtolink'] = 'Get_question_edit_link zahtjeva courseid ili cmid.';
$string['missingimportantcode'] = 'Ovom tipu pitanja nedostaje važan kod: {$a}.';
$string['missingoption'] = 'CLOZE pitanju {$a} nedostaju opcije ';
$string['modified'] = 'Zadnja izmjena';
$string['move'] = 'Premjesti iz {$a} i promijeni poveznice.';
$string['movecategory'] = 'Premjesti kategoriju';
$string['movedquestionsandcategories'] = 'Pitanja i kategorije pitanja su premještena iz {$a->oldplace} na {$a->newplace}.';
$string['movelinksonly'] = 'Samo promijeni odredište poveznica, nemoj micati niti kopirati datoteke.';
$string['moveq'] = 'Premjesti pitanje(a)';
$string['moveqtoanothercontext'] = 'Premjesti pitanja u drugi kontekst.';
$string['moveto'] = 'Premjesti u >>';
$string['movingcategory'] = 'Premještanje kategorije';
$string['movingcategoryandfiles'] = 'Želite li premjestiti kategoriju {$a->name} i sve njezine podređena kategorije u kontekst "{$a->contextto}"?<br /> Postoji {$a->urlcount} datoteka povezanih s ovim pitanjima u {$a->fromareaname}, želite li premjestiti i njih u {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Želite li premjestiti kategoriju "{$a->name}" i sve potkategorije u kontekst za "{$a->contextto}"?';
$string['movingquestions'] = 'Premještanje pitanja i datoteka';
$string['movingquestionsandfiles'] = 'Želite li premjestiti pitanja {$a->questions} u kontekst <strong>"{$a->tocontext}"</strong>?<br /> Postoji <strong>{$a->urlcount} datoteka</strong>povezanih s ovim pitanjima u  {$a->fromareaname}. Želite li premjestiti i njih kopirati u {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Želite li premjestiti pitanje(a) {$a->questions} u kontekst <strong>"{$a->tocontext}"</strong>?<br /> <strong>Ne postoji nijedna datoteka</strong> pridružena ovim pitanjima u {$a->fromareaname}.';
$string['needtochoosecat'] = 'Morate odabrati kategoriju u koju ćete prebaciti ovo pitanje ili kliknuti na \'Odustani\'.';
$string['nocate'] = 'Nema takve kategorije {$a}!';
$string['nopermissionadd'] = 'Nemate ovlasti za dodavanje pitanja ovdje.';
$string['nopermissionmove'] = 'Nemate ovlasti za premještanje pitanja odavde. Morate ga ili pohraniti u ovoj kategoriji ili pohraniti kao novo pitanje.';
$string['noprobs'] = 'Nije pronađen ni jedan problem u vašoj bazi pitanja.';
$string['noquestions'] = 'Ne pitanja koja je moguće izvesti. Odaberite kategoriju koja sadržava pitanja za izvoz.';
$string['noquestionsinfile'] = 'Nema pitanja u datoteci odabranoj za uvoz';
$string['noresponse'] = '[Nema odgovora]';
$string['notanswered'] = 'Nije odgovoreno';
$string['notchanged'] = 'Bez promjena od posljednjeg pokušaja';
$string['notenoughanswers'] = 'Ova vrste pitanja zahtjeva barem {$a} odgovora';
$string['notenoughdatatoeditaquestion'] = 'Nisu navedeni ni ID pitanja, ni ID kategorije kao ni vrsta pitanja.';
$string['notenoughdatatomovequestions'] = 'Morate navesti ID pitanja koje želite premjestiti.';
$string['notflagged'] = 'Nije označeno';
$string['notgraded'] = 'Nije ocijenjeno';
$string['notshown'] = 'Nije prikazano';
$string['notyetanswered'] = 'Nije još odgovoreno';
$string['notyourpreview'] = 'Ovaj pregled ne pripada vama.';
$string['novirtualquestiontype'] = 'Nema virtualne vrste pitanja za vrstu pitanja {$a}';
$string['numqas'] = 'Bez pokušaja odgovaranja';
$string['numquestions'] = 'Broj pitanja';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} skriveno)';
$string['options'] = 'Opcije';
$string['orphanedquestionscategory'] = 'Pitanja pohranjena iz izbrisanih kategorija';
$string['orphanedquestionscategoryinfo'] = 'Ponekad, najčešće zbog pogrešaka u programu, pitanja mogu ostati u bazi podataka čak i nakon što je njihova kategorija izbrisana. Naravno, to se ne bi smjelo dogoditi, no dogodilo se. Ova je kategorija automatski kreirana, i sadrži pitanja iz izbrisanih kategorija koja možete urediti. Sve slike i medijske datoteke korištene u ovim pitanjima su vjerojatno izgubljene.';
$string['page-question-category'] = 'Stranica za kategorije pitanja';
$string['page-question-edit'] = 'Stranica za uređivanje pitanja';
$string['page-question-export'] = 'Stranica za izvoz pitanja';
$string['page-question-import'] = 'Stranica za uvoz pitanja';
$string['page-question-x'] = 'Bilo koja stranica s pitanjem';
$string['parent'] = 'Nadređeni';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcategory_help'] = 'Nadređena kategorija je ona u koju će nova kategorija biti smještena. "Krovna" znači to da se ta kategorija ne nalazi ni u jednoj drugoj kategoriji. Konteksti kategorije su prikazani masnim slovima (bold). Mora postojati barem jedna kategorija u svakom kontekstu.';
$string['parenthesisinproperclose'] = 'Zagrade prije ** nisu pravilno zatvorene u {$a}**';
$string['parenthesisinproperstart'] = 'Zagrade prije ** nisu pravilno otvorene u {$a}**';
$string['parsingquestions'] = 'Parsiranje pitanja iz datoteke za uvoz.';
$string['partiallycorrect'] = 'Djelomično točno';
$string['partiallycorrectfeedback'] = 'Za bilo koji djelomično točan odgovor';
$string['partiallycorrectfeedbackdefault'] = 'Vaš odgovor je djelomično točan.';
$string['penaltyfactor'] = 'Faktor kaznenih bodova';
$string['penaltyfactor_help'] = 'Ova postavka određuje koji dio postignutog rezultata će biti oduzet za svaki netočni odgovor. Moguće ju je primijeniti samo ako je kviz pokrenut u tzv. adaptivnom načinu rada.

Faktor kaznenih bodova može biti broj između 0 i 1. Faktor kaznenih bodova s vrijednošću 1 znači da student mora dati točan odgovor pri prvom pokušaju kako bi uopće dobio bodove. Faktor kaznenih bodova s vrijednošću 0 znači da student može pokušati riješiti pitanje (dati odgovor) koliko god puta želi i da će i dalje dobiti sve predviđene bodove.';
$string['penaltyforeachincorrecttry'] = 'Kazneni bodovi za svaki netočan pokušaj';
$string['permissionedit'] = 'Uredi ovo pitanje';
$string['permissionmove'] = 'Premjesti ovo pitanje';
$string['permissionsaveasnew'] = 'Spremi ovo kao novo pitanje';
$string['permissionto'] = 'Imate ovlasti za:';
$string['previewquestion'] = 'Pregled pitanja: {$a}';
$string['published'] = 'dijeljeno';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Pitanje "{$a->name}" ({$a->qtype})</a> je u ovoj kategoriji ali se također koristi u <a href="{$a->qurl}">testu "{$a->quizname}"</a> na drugom kolegiju "{$a->coursename}".';
$string['questionbank'] = 'Baza pitanja';
$string['questionbehaviouradminsetting'] = 'Postavke karakteristika pitanja';
$string['questionbehavioursdisabled'] = 'Karakteristike pitanja koje će biti onemogućene';
$string['questionbehavioursdisabledexplained'] = 'Upišite popis karakteristika pitanja, odvojenih zarezom, koje se ne trebaju vidjeti u padajućem izborniku';
$string['questionbehavioursorder'] = 'Poredak karakteristika pitanja';
$string['questionbehavioursorderexplained'] = 'Upišite popis karakteristika pitanja, odvojenih zarezom, u onom poretku u kojrm se trebaju vidjeti u padajućem izborniku';
$string['questioncategory'] = 'Kategorija pitanja';
$string['questioncatsfor'] = 'Kategorije pitanja za \'{$a}\'';
$string['questiondoesnotexist'] = 'Pitanje ne postoji';
$string['questionidmismatch'] = 'ID-ovi pitanja se ne podudaraju';
$string['questionname'] = 'Naziv pitanja';
$string['questionno'] = 'Pitanje {$a}';
$string['questions'] = 'Pitanja';
$string['questionsaveerror'] = 'Dogodile su se pogreške pri pohranjivanju pitanja - ({$a})';
$string['questionsinuse'] = '(* Pitanja označena zvjezdicom se već koriste u testovima. Ova pitanja neće biti izbrisana iz testova, već samo iz popisa kategorije.)';
$string['questionsmovedto'] = 'Pitanja koja se i dalje koriste su premještena u "{$a}" u nadređenoj kategoriji kolegija.';
$string['questionsrescuedfrom'] = 'Pitanje pohranjeno iz konteksta {$a}.';
$string['questionsrescuedfrominfo'] = 'Ova pitanja (od kojih su neka možda skrivena) su pohranjena kada je kontekst {$a} izbrisan jer se i dalje koriste od strane testa ili neke druge aktivnosti';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontype'] = 'Vrsta pitanja';
$string['questionuse'] = 'Koristi pitanje u ovoj aktivnosti';
$string['questionvariant'] = 'Varijanta pitanja';
$string['questionx'] = 'Pitanje {$a}';
$string['requiresgrading'] = 'Zahtijeva ocjenjivanje';
$string['responsehistory'] = 'Povijest odgovora';
$string['restart'] = 'Ponovno započni';
$string['restartwiththeseoptions'] = 'Ponovno započni s ovim opcijama';
$string['reviewresponse'] = 'Pregledaj odgovor';
$string['rightanswer'] = 'Ispravan odgovor';
$string['rightanswer_help'] = 'automatski generirani sažetak točnog odgovora. Ovo može biti dosta ograničeno, pa razmislite o objašnjavanju točnog odgovora pomoću općenite povratne informacije za pitanje, umjesto korištenja ove opcije.';
$string['save'] = 'Pohrani';
$string['saved'] = 'Pohranjeno: {$a}';
$string['saveflags'] = 'Pohrani stanje označenih stavki';
$string['selectacategory'] = 'Odaberite kategoriju:';
$string['selectaqtypefordescription'] = 'Odaberite vrstu pitanja kako biste vidjeli njegov opis';
$string['selectcategoryabove'] = 'Select a category above';
$string['selectquestionsforbulk'] = 'Odaberi pitanja za masovne operacije';
$string['settingsformultipletries'] = 'Postavke za višestruke pokušaje rješavanja';
$string['shareincontext'] = 'Dijeli u kontekstu za {$a}';
$string['showhidden'] = 'Prikaži i stara pitanja';
$string['showmarkandmax'] = 'Prikaži ostvareni i maksimalni broj bodova';
$string['showmaxmarkonly'] = 'Prikaži samo maksimalni broj bodova';
$string['shown'] = 'Prikazano';
$string['shownumpartscorrect'] = 'Prikaži broj točnih odgovora';
$string['shownumpartscorrectwhenfinished'] = 'Prikaži broj točnih odgovora nakon što je pitanje odgovoreno';
$string['showquestiontext'] = 'Prikaži tekst pitanja u popisu pitanja';
$string['specificfeedback'] = 'Specifična povratna informacija';
$string['specificfeedback_help'] = 'Povratna informacija koja ovisi o studentovom odgovoru';
$string['started'] = 'Započeto';
$string['state'] = 'Stanje';
$string['step'] = 'Korak';
$string['stoponerror'] = 'Zaustavi pri pogrešci';
$string['stoponerror_help'] = 'Ova postavka određuje hoće li se postupak uvoza podataka zaustaviti pri pogrešci, rezultirajući time da nijedno pitanje ne bude uveženo, ili će pitanja čiji uvoz bude rezultirao pogreškama biti zanemarena i samo će valjana pitanja biti uvežena.';
$string['submissionoutofsequence'] = 'Pristup nije po očekivanom redoslijedu. Nemojte koristiti gumb za povratak na prošlu stranicu tijekom rada na pitanjima u testu.';
$string['submissionoutofsequencefriendlymessage'] = 'Unijeli ste podatke izvan očekivanog redoslijeda. Ovo se može dogoditi pri uporabi gumba Natrag i Naprijed u pregledniku; molimo ne koristite ih tijekom testa. Također se može dogoditi ako kliknete na dio stranice dok se učitava. Odaberite <strong>Nastavi</strong> za nastavak.';
$string['submit'] = 'Predajte';
$string['submitandfinish'] = 'Predajte i završite';
$string['submitted'] = 'Predajte: {$a}';
$string['technicalinfo'] = 'Tehničke informacije';
$string['technicalinfo_help'] = 'Ove su tehničke informacije vjerojatno korisne samo programerima koji rade na novim vrstama pitanja. Također mogu biti od pomoći prilikom uklanjanja problema vezanih za pitanja.';
$string['technicalinfominfraction'] = 'Najmanji dio: {$a}';
$string['technicalinfoquestionsummary'] = 'Sažetak pitanja: {$a}';
$string['technicalinforightsummary'] = 'Sažetak točnog odgovora: {$a}';
$string['technicalinfostate'] = 'Stanje pitanja: {$a}';
$string['tofilecategory'] = 'Zapiši kategoriju u datoteku';
$string['tofilecontext'] = 'Zapiši kontekst u datoteku';
$string['uninstallbehaviour'] = 'Deinstaliraj ovu karakteristiku pitanja.';
$string['uninstallqtype'] = 'Deinstaliraj ovu vrstu pitanja';
$string['unknown'] = 'Nepoznato';
$string['unknownbehaviour'] = 'Nepoznata karakteristika pitanja: {$a}.';
$string['unknownorunhandledtype'] = 'Nepoznata ili neobrađena vrsta pitanja: {$a}';
$string['unknownquestion'] = 'Nepoznato pitanje: {$a}.';
$string['unknownquestioncatregory'] = 'Nepoznata kategorija pitanja: {$a}.';
$string['unknownquestiontype'] = 'Nepoznata vrsta pitanja: {$a}.';
$string['unknowntolerance'] = 'Nepoznata vrsta tolerancije {$a}';
$string['unpublished'] = 'neobjavljeno';
$string['updatedisplayoptions'] = 'Nadogradi postavke prikaza';
$string['upgradeproblemcategoryloop'] = 'Otkriven je problem pri nadogradnji kategorija pitanja. Postoji petlja u hijerarhiji kategorija. ID kategorija koje su pogođene - {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nije moguće osjvežiti kategoriju pitanja {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Otkriven je problem pri nadogradnji kategorija pitanja. Kategorija {$a->id} se odnosi na nadređenu kategoriju {$a->parent}, koja ne postoji. Nadređena kategorija je promijenjena automatski.';
$string['whethercorrect'] = 'Je li točno';
$string['whethercorrect_help'] = 'Ovo pokriva tekstualne opise \'Točno\', \'Djelomično točno\' te \'Netočno\', te sve onake u bojama koje prenose iste informacije.';
$string['withselected'] = 'S označenim';
$string['wrongprefix'] = 'Neispravno oblikovan nameprefix {$a}';
$string['xoutofmax'] = '{$a->mark} od{$a->max}';
$string['yougotnright'] = 'Broj točnih odgovora: {$a->num}';
$string['youmustselectaqtype'] = 'Morate odabrati vrstu pitanja.';
$string['yourfileshoulddownload'] = 'Preuzimanje vaše datoteke s podacima bi uskoro trebalo početi. Ako se to ne dogodi, <a href="{$a}">kliknite ovdje</a>.';
