<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'mnet', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   mnet
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutyourhost'] = 'O vašem poslužitelju';
$string['accesslevel'] = 'Razina pristupa';
$string['addhost'] = 'Dodaj poslužitelj';
$string['addnewhost'] = 'Dodaj novi poslužitelj';
$string['addtoacl'] = 'Dodaj u kontrolu pristupa';
$string['allhosts'] = 'Svi poslužitelji';
$string['allhosts_no_options'] = 'Nema dostupnih mogućnosti prilikom pregledavanja višestrukih poslužitelja';
$string['allow'] = 'Dopusti';
$string['applicationtype'] = 'Vrsta aplikacije';
$string['authfail_nosessionexists'] = 'Autorizacija nije uspjela: ne postoji mnet sesija.';
$string['authfail_sessiontimedout'] = 'Autorizacija nije uspjela: mnet sesija je istekla.';
$string['authfail_usermismatch'] = 'Autorizacija nije uspjela: korisnik se ne podudara.';
$string['authmnetdisabled'] = 'MNet autentikacijski dodatak je <strong>onemogućen</strong>.';
$string['badcert'] = 'Ovo nije valjan certifikat.';
$string['certdetails'] = 'Cert detalji';
$string['configmnet'] = 'MNet omogućava komunikaciju ovog poslužitelja i drugih poslužitelja i/ili servisa.';
$string['couldnotgetcert'] = 'Nema certifikata na <br />{$a}. <br />Poslužitelj je možda nedostupan ili je neispravno podešen.';
$string['couldnotmatchcert'] = 'Ovo se ne podudara s certifikatom koji je trenutno objavljen na web poslužitelju.';
$string['courses'] = 'kolegiji';
$string['courseson'] = 'kolegiji na';
$string['currentkey'] = 'Trenutni javni ključ';
$string['current_transport'] = 'Trenutni transport';
$string['databaseerror'] = 'Zapis detalja u bazu podataka nije bilo moguće ostvariti.';
$string['deleteaserver'] = 'Brisanje poslužitelja';
$string['deletedhostinfo'] = 'Ovaj poslužitelj je izbrisan. Ako želite poništiti brisanje, prebacite stanje brisanja na \'Ne\'.';
$string['deletedhosts'] = 'Izbrisani poslužitelji: {$a}';
$string['deletehost'] = 'Obriši poslužitelj';
$string['deletekeycheck'] = 'Želite li uistinu izbrisati ovaj ključ?';
$string['deleteoutoftime'] = 'Rok od 60 sekundi koji ste imali za brisanje ovog ključa je istekao. Molimo pokušajte ponovo.';
$string['deleteuserrecord'] = 'SSO ACL: Izbriši zapis korisnika \'{$a->user}\' sa {$a->host}.';
$string['deletewrongkeyvalue'] = 'Dogodila se pogreška. Ako niste sami pokušavali izbrisati SSL ključ vašeg poslužitelja, postoji mogućnost da ste bili izloženi zlonamjernom napadu. Nije poduzeta nikakva akcija.';
$string['deny'] = 'Zabrani';
$string['description'] = 'Opis';
$string['enabled_for_all'] = '(Ovaj servis je omogućen za sve poslužitelje).';
$string['enterausername'] = 'Molim unesite korisničko ime, ili više njih odvojenih zarezima.';
$string['error7022'] = 'Poruka koju ste poslali na udaljeni poslužitelj je bila ispravno zakrivena, ali nije bila potpisana. Ovo je prilično neočekivano; trebali biste prijaviti BUG ako se ovo dogodi (dajući što je moguće više informacija o inačici aplikacije i slično).';
$string['error709'] = 'Udaljeni poslužitelj nije uspio dohvatiti SSL ključ s ovog poslužitelja.';
$string['expired'] = 'Ovaj ključ je istekao';
$string['expires'] = 'Vrijedi do';
$string['expireyourkey'] = 'Izbriši ovaj ključ';
$string['expireyourkeyexplain'] = 'Moodle automatski rotira vaše ključeve svakih 28 dana (zadana vrijednost), ali imate mogućnost da <em>ručno</em> provedete istek nekog ključa u bilo koje vrijeme. To će korisno ako mislite da je isti ključ je ugrožen/poznat drugima. Zamjena će biti odmah automatski stvorena.<br /> Brisanje tog ključa onemogućiti drugim aplikacijama komunikaciju s vama, sve dok vi osobno ne kontaktirate svakog administratora i date im svoj novi ključ.';
$string['exportfields'] = 'Polja za izvoz';
$string['failedaclwrite'] = 'Nije bilo moguće zapisati MNet popis kontrole pristupa za korisnika \'{$a}\'.';
$string['findlogin'] = 'Pronađi login';
$string['forbidden-function'] = 'Ova funkcija nije omogućena za RPC.';
$string['forbidden-transport'] = 'Način prijenosa koji vi pokušavate koristiti nije dopušten.';
$string['forcesavechanges'] = 'Obvezna pohrana promjena';
$string['helpnetworksettings'] = 'Podesi MNet postavke';
$string['hidelocal'] = 'Skrij lokalne korisnike';
$string['hideremote'] = 'Skrij udaljene korisnike';
$string['host'] = 'poslužitelj';
$string['hostcoursenotfound'] = 'Poslužitelj ili kolegij nisu pronađeni';
$string['hostdeleted'] = 'Poslužitelj je izbrisan';
$string['hostexists'] = 'Već postoji zapis o poslužitelju s identičnim nazivom (moguće je da je izbrisan). <a href="{$a}">Kliknite ovdje</a> kako bi uredili taj zapis.';
$string['hostlist'] = 'Popis umreženih poslužitelja';
$string['hostname'] = 'Naziv poslužitelja';
$string['hostnamehelp'] = 'FQDN udaljenog poslužitelja, npr. www.example.com';
$string['hostnotconfiguredforsso'] = 'Ovaj poslužitelj ne podržava udaljeni login.';
$string['hostsettings'] = 'Postavke poslužitelja';
$string['http_self_signed_help'] = 'Dopusti veze koje koriste samostalno potpisane SSL certifikate na udaljenom poslužitelju.';
$string['https_self_signed_help'] = 'Dopusti veze koje koriste samostalno potpisane SSL certifikate u PHP-u na udaljenom poslužitelju preko http.';
$string['https_verified_help'] = 'Dopusti veze koje koriste verificirane SSL certifikate na udaljenom poslužitelju.';
$string['http_verified_help'] = 'Dopusti veze koje koriste verificirane SSL certifikate na udaljenom poslužitelju, ali preko http (ne https).';
$string['id'] = 'ID';
$string['idhelp'] = 'Ova vrijednost se automatski dodjeljuje i ne može se mijenjati';
$string['importfields'] = 'Polja za uvoz';
$string['inspect'] = 'Provjera';
$string['installnosuchfunction'] = 'Programska pogreška! Nešto pokušava instalirati mnet xmlrpc funkciju ({$a->method}) iz datoteke ({$a->file}) a istu nije moguće pronaći!';
$string['installnosuchmethod'] = 'Programska pogreška! Nešto pokušava instalirati mnet xmlrpc način ({$a->method}) u razredu ({$a->class}) a istu nije moguće pronaći!';
$string['installreflectionclasserror'] = 'Programska pogreška! MNet introspekcija nije uspjela za način \'{$a->method}\' u razred \'{$a->class}\'. Izvorni tekst pogreške glasi: \'{$a->error}\'';
$string['installreflectionfunctionerror'] = 'Programska pogreška! MNet introspekcija nije uspjela za funkciju \'{$a->method}\' u datoteci \'{$a->class}\'. Izvorni tekst pogreške glasi: \'{$a->error}\'';
$string['invalidaccessparam'] = 'Neispravan parametar pristupa.';
$string['invalidactionparam'] = 'Neispravan parametar akcije.';
$string['invalidhost'] = 'Morate pružiti valjani identifikator poslužitelja';
$string['invalidpubkey'] = 'Ovo nije valjan SSL ključ. ({$a})';
$string['invalidurl'] = 'Neispravan URL parametar.';
$string['ipaddress'] = 'IP adresa';
$string['is_in_range'] = 'IP adresa <code>{$a}</code> predstavlja valjani pouzdani poslužitelj.';
$string['ispublished'] = '{$a} vam je omogućio ovaj servis.';
$string['issubscribed'] = '{$a} je pretplaćen na ovaj servis koji pruža vaš poslužitelj.';
$string['keydeleted'] = 'Vaš ključ je uspješno izbrisan i zamijenjen.';
$string['keymismatch'] = 'Javni ključ koji imate za ovaj poslužitelj je RAZLIČIT u odnosu na javni ključ koji je trenutno dostupan. Trenutno objavljeni ključ glasi:';
$string['last_connect_time'] = 'Zadnje spajanje';
$string['last_connect_time_help'] = 'Kada ste se zadnji puta spojili na ovaj poslužitelj.';
$string['last_transport_help'] = 'Prijenos koji ste koristili pri zadnjem spajanju na ovaj poslužitelj.';
$string['leavedefault'] = 'Koristi zadane postavke umjesto toga';
$string['listservices'] = 'Popis servisa';
$string['logs'] = 'zapisi';
$string['managemnetpeers'] = 'Uredi ravnopravne poslužitelje';
$string['method'] = 'Način';
$string['methodhelp'] = 'Pomoć za način {$a}';
$string['methodsavailableonhost'] = 'Načini dostupni na {$a}';
$string['methodsavailableonhostinservice'] = 'Načini dostupni za {$a->service} na {$a->host}';
$string['methodsignature'] = 'Uredi potpis za {$a}';
$string['mnet'] = 'MNet';
$string['mnet_concatenate_strings'] = 'Spoji (do) 3 niza i vrati rezultat';
$string['mnetdisabled'] = 'MNet je <strong>onemogućen</strong>.';
$string['mnetidprovider'] = 'Pružatelj MNet ID';
$string['mnetidprovidermsg'] = 'Trebali biste se moći prijaviti kod svog {$a} pružatelja';
$string['mnetidprovidernotfound'] = 'Nažalost, više informacija nije dostupno.';
$string['mnetlog'] = 'Zapisi';
$string['mnetpeers'] = 'Ravnopravni poslužitelji';
$string['mnetservices'] = 'Servisi';
$string['mnet_session_prohibited'] = 'Korisnici s vašeg poslužitelja trenutno ne mogu raditi na {$a}.';
$string['mnetsettings'] = 'MNet postavke';
$string['moodle_home_help'] = 'Putanja do naslovnice MNet aplikacije na udaljenom poslužitelju, npr. /moodle/.';
$string['name'] = 'Naziv';
$string['net'] = 'Umrežavanje';
$string['networksettings'] = 'Mrežne postavke';
$string['never'] = 'Nikad';
$string['noaclentries'] = 'Nema zapisa u SSO popisu kontrole pristupa';
$string['noaddressforhost'] = 'Naziv poslužitelja ({$a}) nije bilo moguće razriješiti!';
$string['nocurl'] = 'PHP cURL biblioteka nije instalirana';
$string['nolocaluser'] = 'Nema lokalnih zapisa o udaljenom korisniku i iste nije moguće stvoriti, budući da ovaj poslužitelj ne stvara nove korisnike automatski. Kontaktirajte svog administratora!';
$string['nomodifyacl'] = 'Nemate ovlasti za izmjene u MNet popisu kontrole pristupa.';
$string['nonmatchingcert'] = 'Naslov certifikata: <br /><em>{$a->subject}</em><br />se ne podudara s poslužiteljem s kojeg je došao:<br /><em>{$a->host}</em>.';
$string['nopubkey'] = 'Dogodio se problem pri dohvatu javnog ključa. <br/>Možda poslužitelj nema aktiviran MNet ili je ključ neispravan.';
$string['nosite'] = 'Nije bilo moguće pronaći kolegij na razini poslužitelja';
$string['nosuchfile'] = 'Datoteka/funkcija {$a} ne postoji.';
$string['nosuchfunction'] = 'Nije moguće locirati funkciju ili je ista zabranjena za RPC.';
$string['nosuchmodule'] = 'Funkcija je neispravno smještena i ne može biti locirana. Koristite mod/modulename/lib/functionname oblik.';
$string['nosuchpublickey'] = 'Nije bilo moguće dohvatiti javni ključ potreban za verifikaciju potpisa.';
$string['nosuchservice'] = 'RPC servis nije pokrenut na ovom poslužitelju.';
$string['nosuchtransport'] = 'Ne postoji transport koji ima taj ID';
$string['notBASE64'] = 'Niz nije u base64 enkodiranom obliku. Ne može biti valjani ključ.';
$string['notenoughidpinfo'] = 'Vaš izvorni sustav nam ne pruža dovoljno informacija za stvaranje ili osvježavanje vašeg lokalnog korisničkog računa.';
$string['not_in_range'] = 'IP adresa <code>{$a}</code> ne predstavlja valjani pouzdani poslužitelj.';
$string['notinxmlrpcserver'] = 'Pokušaj pristupa MNet udaljenom klijentu, van XMLRPC poslužiteljskog izvršenja';
$string['notmoodleapplication'] = 'UPOZORENJE: Ovo nije Moodle aplikacija, tako da neke od metoda ispitivanja možda neće biti uspješne.';
$string['notPEM'] = 'Ovaj ključ nije u PEM obliku. Neće funkcionirati.';
$string['notpermittedtojump'] = 'Nemate dovoljno ovlasti za započinjanje udaljene sesije s ovog Moodle poslužitelja.';
$string['notpermittedtojumpas'] = 'Ne možete započeti udaljenu sesiju dok ste prijavljeni kao drugi korisnik.';
$string['notpermittedtoland'] = 'Nemate dovoljno ovlasti za započinjanje udaljene sesije.';
$string['off'] = 'Onemogućeno';
$string['on'] = 'Omogućeno';
$string['options'] = 'Opcije';
$string['peerprofilefielddesc'] = 'Ovdje možete promijeniti globalne postavke o tome koja polja korisničkog profila se šalju ili uvoze pri stvaranju novih korisničkih računa';
$string['permittedtransports'] = 'Dopušteni transporti';
$string['phperror'] = 'Interna PHP pogreška je onemogućila izvršenje vašeg zahtjeva.';
$string['position'] = 'Pozicija';
$string['postrequired'] = 'Za funkciju brisanja potreban je POST zahtjev.';
$string['profileexportfields'] = 'Polja koja se šalju';
$string['profilefielddesc'] = 'Ovdje možete podesiti popis polja profila koja se šalju i primaju preko MNet kada se stvaraju novi ili osvježavaju postojeći korisnički računi. Možete također promijeniti dani popis polja za svaki udaljeni poslužitelj pojedinačno. Uzmite u obzir da se sljedeća polja UVIJEK šalju i da nisu opcionalna: {$a}';
$string['profilefields'] = 'Polja profila';
$string['profileimportfields'] = 'Polja za uvoz';
$string['promiscuous'] = 'Promiskuitetni';
$string['publickey'] = 'Javni ključ';
$string['publickey_help'] = 'Javni ključ se automatski dohvaća s udaljenog poslužitelja.';
$string['publickeyrequired'] = 'Morate pružiti javni ključ.';
$string['publish'] = 'Objavi';
$string['reallydeleteserver'] = 'Želite li izbrisati poslužitelj';
$string['receivedwarnings'] = 'Zabilježena su sljedeća upozorenja';
$string['recordnoexists'] = 'Zapis ne postoji.';
$string['reenableserver'] = 'NE - odaberite ovu opciju kako bi ponovo omogućili rad ovog poslužitelja.';
$string['registerallhosts'] = 'Registriraj sve poslužitelje (promiskuitetni način rada)';
$string['registerallhostsexplain'] = 'Možete odabrati automatsku registraciju svih poslužitelja koji se pokušavaju spojiti na vaš poslužitelj. To znači da će se pojaviti zapis na vašem popisu poslužitelja za svako MNet sjedište koje se spoji na vaše sjedište i zatraži vaš javni ključ.<br/>U nastavku imate opciju za podešavanje usluga za \'Sve poslužitelje\' i na taj način možete pružiti usluge svim udaljenim poslužiteljima neselektivno.';
$string['registerhostsoff'] = 'Registriraj sve poslužitelje je trenutno <b>omogućeno</b>';
$string['registerhostson'] = 'Registriraj sve poslužitelje je trenutno <b>onemogućeno</b>';
$string['remotecourses'] = 'Udaljeni kolegiji';
$string['remotehost'] = 'Udaljeni poslužitelj';
$string['remotehosts'] = 'Udaljeni poslužitelji';
$string['remoteuserinfo'] = 'Udaljeni korisnik {$a->remotetype} - profil dohvaćen s <a href="{$a->remoteurl}">{$a->remotename}</a>';
$string['requiresopenssl'] = 'Umrežavanje zahtijeva OpenSSL ekstenziju';
$string['restore'] = 'Vraćanje kolegija';
$string['returnvalue'] = 'Vraćena vrijednost';
$string['reviewhostdetails'] = 'Pregled detalja o poslužitelju';
$string['reviewhostservices'] = 'Pregled servisa na poslužitelju';
$string['RPC_HTTP_PLAINTEXT'] = 'nekriptirani HTTP';
$string['RPC_HTTP_SELF_SIGNED'] = 'HTTP (samostalno ovjereni)';
$string['RPC_HTTPS_SELF_SIGNED'] = 'HTTPS  (samostalno ovjereni)';
$string['RPC_HTTPS_VERIFIED'] = 'HTTPS (ovjereni)';
$string['RPC_HTTP_VERIFIED'] = 'HTTP (ovjereni)';
$string['selectaccesslevel'] = 'Molim odaberite razinu pristupa s popisa.';
$string['selectahost'] = 'Odaberite udaljeni poslužitelj.';
$string['service'] = 'Naziv servisa';
$string['serviceid'] = 'ID servisa';
$string['servicesavailableonhost'] = 'Servisi dostupni na {$a}';
$string['serviceswepublish'] = 'Servisi koje pružamo {$a}.';
$string['serviceswesubscribeto'] = 'Servisi na {$a} na koje smo pretplaćeni.';
$string['settings'] = 'Postavke';
$string['showlocal'] = 'Prikaži lokalne korisnike';
$string['showremote'] = 'Prikaži korisnike s udaljenih poslužitelja';
$string['ssl_acl_allow'] = 'SSO ACL: Dopusti pristup korisniku \'{$a->user}\' s poslužitelja \'{$a->host}\'';
$string['ssl_acl_deny'] = 'SSO ACL: Zabrani pristup korisniku {$a->user} s poslužitelja {$a->host}';
$string['ssoaccesscontrol'] = 'SSO kontrola pristupa';
$string['ssoacldescr'] = 'Ovu stranicu možete koristiti za dopuštenje/zabranu pristupa pojedinačnim korisnicima s udaljenih MNet poslužitelja. Ovo je funkcionalno ako pružate SSO usluge udaljenim korisnicima. Kako bi kontrolirali sposobnost vaših <em>lokalnih</em> korisnika da se koriste drugim MNet poslužiteljima, koristite se sustavom uloga kako bi im omogućili korištenje sposobnosti <em>mnetlogintoremote</em>.';
$string['ssoaclneeds'] = 'Kako bi radila ova mogućnost, morate omogućiti MNet, kao i MNet autentikacijski dodatak.';
$string['strict'] = 'Striktno';
$string['subscribe'] = 'Pretplati se';
$string['system'] = 'Sustav';
$string['testclient'] = 'MNet probni klijent';
$string['testtrustedhosts'] = 'Testiraj adresu';
$string['testtrustedhostsexplain'] = 'Unesite IP adresu kako bi provjerili radi li se o pouzdanom poslužitelju.';
$string['theypublish'] = 'Oni objavljuju';
$string['theysubscribe'] = 'Oni su pretplaćeni';
$string['transport_help'] = 'Ove opcije su recipročne, tako da možete obavezati drugi poslužitelj na korištenje potpisanog SSL certifikata samo ako i vaš poslužitelj koristi potpisani SSL certifikat.';
$string['trustedhosts'] = 'XML-RPC poslužitelji';
$string['trustedhostsexplain'] = '<p>Mehanizam pouzdanih poslužitelja dopušta pojedinim računalima izvršenje poziva preko XML-RPC na bilo koji dio Moodle API-ja. Ovo je dostupno skriptama koje kontroliraju ponašanje Moodle poslužitelja i može biti jako opasno. Ako ste u dvojbi, isključite ovu opciju.</p> <p><strong>To nije potrebno za nijednu standardnu MNet značajku!</strong> Uključite samo ako znate što radite.</p> <p>Kako bi isto omogućili, unesite popis IP adresa ili mreža, po jednu u redu. Npr.:</p> Vaš lokalni poslužitelj:<br />127.0.0.1<br />Vaš lokalni poslužitelj (s blokiranjem mreže):<br />127.0.0.1/32<br />Samo poslužitelj s IP adresom 192.168.0.7:<br />192.168.0.7/32<br />Bilo koji poslužitelj s IP adresom od 192.168.0.1 do 192.168.0.255:<br />192.168.0.0/24<br />Bilo koji poslužitelj:<br />192.168.0.0/0<br />Očito je da ovaj zadnji primjer <strong>NIJE PREPORUČLJIV</strong>!';
$string['turnitoff'] = 'Isključi';
$string['turniton'] = 'Uključi';
$string['type'] = 'Vrsta';
$string['unknown'] = 'Nepoznato';
$string['unknownerror'] = 'Dogodila se nepoznata pogreška tijekom pregovora.';
$string['usercannotchangepassword'] = 'Ne možete ovdje promijeniti lozinku budući da ste vanjski korisnik.';
$string['userchangepasswordlink'] = '<br /> Možda možete promijeniti svoju lozinku na svom izvornom sustavu <a href="{$a->wwwroot}/login/change_password.php">{$a->description}</a>.
	';
$string['usernotfullysetup'] = 'Vaš korisnički račun nije potpun. Morate posjetiti stranicu vašeg <a href="{$a}">izvornog sustava</a> i provjeriti da su svi podaci unešeni. Možda ćete se morati odjaviti i ponovo prijaviti na ovaj sustav kako bi se navedene izmjene osvježile i na ovom sustavu.';
$string['usersareonline'] = 'UPOZORENJE: Broj korisnika s tog poslužitelja koji su trenutno prijavljeni na vaš poslužitelj: {$a}';
$string['validated_by'] = 'Potvrđeno je od mreže: <code>{$a}</code>';
$string['verifysignature-error'] = 'Nije uspjela verifikacija potpisa. Dogodila se pogreška.';
$string['verifysignature-invalid'] = 'Verifikacija potpisa nije uspjela. Izgleda da vi to niste potpisali.';
$string['version'] = 'Inačica';
$string['warning'] = 'Upozorenje';
$string['wrong-ip'] = 'Vaša IP adresa se ne podudara s onom koju mi imamo zabilježenu.';
$string['xmlrpc-missing'] = 'Morate imati instaliran XML-RPC instaliran u sklopu vašeg PHP-a kako bi mogli koristiti ovu mogućnost.';
$string['yourhost'] = 'Vaš poslužitelj';
$string['yourpeers'] = 'Poslužitelji ravnopravni vašemu';
