<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Prihvati';
$string['accept_grades'] = 'Prihvati ocjene iz alata';
$string['accept_grades_admin'] = 'Prihvati ocjene iz alata';
$string['accept_grades_admin_help'] = 'Navedite može li pružatelj alata dodavati, nadograđivati, čitati ili brisati ocjene povezane s instancama ove vrste alata.

Neki pružatelji alata podržavaju zapis ocjena u Moodle zasnovano na operacijiama koje korisnici provedu unutra alata, stvarajući time korisniku doživljaj veće integracije Moodle-a i vanjskog alata.';
$string['accept_grades_help'] = 'Navedite može li pružatelj alata dodavati, nadograđivati, čitati ili brisati ocjene povezane s instancama ove vrste alata.

Neki pružatelji alata podržavaju zapis ocjena u Moodle zasnovano na operacijiama koje korisnici provedu unutra alata, stvarajući time korisniku doživljaj veće integracije Moodle-a i vanjskog alata.

Imajte u vidu da se ova postavka može izmjeniti u postavkama samog alata.';
$string['action'] = 'Operacija';
$string['active'] = 'Aktivno';
$string['activity'] = 'Aktivnost';
$string['addnewapp'] = 'Omogući vanjsku aplikaciju';
$string['addserver'] = 'Dodajte novi pouzdani poslužitelj';
$string['addtype'] = 'Dodaj konfiguraciju vanjskog alata';
$string['allow'] = 'Dopusti';
$string['allowinstructorcustom'] = 'Dopusti nastavnicima da dodaju prilagođene parametre';
$string['allowsetting'] = 'Dopusti alatu pohranu 8k postavki u Moodle';
$string['always'] = 'Uvijek';
$string['automatic'] = 'Automatski, na osnovu inicijalne URL adrese';
$string['baseurl'] = 'Base URL';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI aktivnosti';
$string['basiclti_base_string'] = 'LTI OAuth Base String';
$string['basiclti_endpoint'] = 'LTI krajnja točka pokretanja';
$string['basicltifieldset'] = 'Prilagođeni primjer skupa polja';
$string['basiclti_in_new_window'] = 'Vaša aktivnost se otvorila u novom prozoru';
$string['basicltiintro'] = 'Opis aktivnosti';
$string['basicltiname'] = 'Naziv aktivnosti';
$string['basiclti_parameters'] = 'Parametri pokretanja LTI';
$string['basicltisettings'] = 'Osnovne LTI postavke';
$string['cannot_delete'] = 'Ne možete izbrisati ovu konfiguraciju alata';
$string['cannot_edit'] = 'Ne možete urediti ovu konfiguraciju alata';
$string['comment'] = 'Komentar';
$string['configpassword'] = 'Zadana lozinka udaljenog alata';
$string['configpreferheight'] = 'Zadana željena visina';
$string['configpreferwidget'] = 'Postavi dodatak za zadano pokretanje';
$string['configpreferwidth'] = 'Zadana željena širina';
$string['configresourceurl'] = 'Zadani URL resursa';
$string['configtoolurl'] = 'Zadani URL udaljenog alata';
$string['configtypes'] = 'Omogući LTI aplikacije';
$string['courseid'] = 'ID broj kolegija';
$string['coursemisconf'] = 'Kolegij nije ispravno podešen';
$string['course_tool_types'] = 'Vrste alata na razini kolegija';
$string['createdon'] = 'Stvoreno';
$string['curllibrarymissing'] = 'Za korištenje LTI morate imati instaliranu biblioteku PHP CURL.';
$string['custom'] = 'Prilagođeni parametri';
$string['custom_config'] = 'Korištenje prilagođene konfiguracije alata';
$string['custom_help'] = 'Prilagođeni parametri su postavke koje koristi pružatelj alata. Na primjer, prilagođeni parametar se može koristiti za prikaz pojedinog resursa pružatelja.

Najsigurnije je ostaviti ovo polje nepromijenjenim, ako nemate informacije od pružatelja alata.';
$string['custominstr'] = 'Prilagođeni parametri';
$string['debuglaunch'] = 'Debug opcije';
$string['debuglaunchoff'] = 'Normalno pokretanje';
$string['debuglaunchon'] = 'Debug pokretanje';
$string['default'] = 'Zadano';
$string['default_launch_container'] = 'Zadani spremnik za pokretanje';
$string['default_launch_container_help'] = 'Spremnik za pokretanje određuje način prikaza alata kada ga se pokrene iz kolegija. Neki spremnici daju vanjskom alatu više prostora za prikaz, dok se drugi bolje integriraju u Moodle okolinu.

* **Zadano** - korištenje spremnika određenog u podešavanju alata.
* **Ugradi** - alat je prikazan u postojećem Moodle prozoru, slično kao ostale aktivnosti.
* **Ugradi, bez blokova** - alat je prikazan u postojećem Moodle prozoru, ali prikazuje samo navigacijske kontrole na vrhu stranice.
* **Novi prozor** - alat se otvara u novom prozoru i zauzima sav dostupni prostor.
     Ovisno o Web pregledniku, otvorit će se novi prozor ili nova kartica (tab).
     Moguće je da će Web preglednik spriječiti otvaranje novog prozora.';
$string['delegate'] = 'Delegiraj nastavniku';
$string['delete'] = 'Izbriši';
$string['delete_confirmation'] = 'Želite li izbrisati ovu konfiguraciju vanjskog alata?';
$string['deletetype'] = 'Izbriši konfiguraciju vanjskog alata';
$string['display_description'] = 'Prikaži opis aktivnosti kada je pokrenuta';
$string['display_description_help'] = 'Ako je označeno, opis aktivnosti (definiran iznad) će biti prikazan iznad sadržaja pružatelja alata.

Opis se može koristiti za dodatne upute za pokretanje alata, ali nije nužan.

Opis se nikada ne prikazuje kada se spremnik za pokretanje otvara u novom prozoru.';
$string['display_name'] = 'Prikaži naziv aktivnost kada je pokrenuta';
$string['display_name_help'] = 'Ako je označeno, naziv aktivnosti (definiran iznad) će biti prikazan iznad sadržaja pružatelja alata.

Moguće je da će pružatelj alata također prikazati naslov. Ova opcija može spriječiti dvostruko prikazivanje.

Opis se nikada ne prikazuje kada se spremnik za pokretanje otvara u novom prozoru.';
$string['domain_mismatch'] = 'Domena inicijalne URL adrese se ne poklapa s konfiguracijom alata.';
$string['donot'] = 'Nemoj slati';
$string['donotaccept'] = 'Nemoj prihvatiti';
$string['donotallow'] = 'Nemoj dopustiti';
$string['edittype'] = 'Uredi konfiguraciju vanjskog alata';
$string['embed'] = 'Ugradi';
$string['embed_no_blocks'] = 'Ugradi, bez blokova';
$string['enableemailnotification'] = 'Pošalji obavijesti e-poštom';
$string['enableemailnotification_help'] = 'Ako je omogućeno, studenti će putem e-pošte primati obavijesti o tome kad njihove aktivnosti unutar alata budu ocijenjene.';
$string['errormisconfig'] = 'Neispravno podešen alat. Zamolite vašeg Moodle administratora da popravi konfiguraciju alata.';
$string['extensions'] = 'LTI prošireni servisi';
$string['external_tool_type'] = 'Vrsta vanjskog alata';
$string['external_tool_type_help'] = 'Glavna svrha podešavanja alata je uspostavljanje sigurne komunikacije između Moodlea i pružatelja alata.
Ovdje se također mogu promijeniti zadane vrijednosti konfiguracije i postaviti dodatne usluge koje alat pruža.

* ** Automatski, na osnovu inicijalne URL adrese ** - ova postavka bi trebala biti korištena u gotovo svim slučajevima. Moodle će odabrati najprikladniju konfiguraciju alata temeljem URL-a za pokretanje. Bit će korišteni alati koje je podesio administrator, kao i alati na razini kolegija.
      Kada je definiran URL za pokretanje, Moodle će javiti prepoznaje li ga ili ne. Ako Moodle ne prepoznaje URL za pokretanje, trebat ćete ručno podesiti alat.
* **Određena vrsta alata** - odabirom ove opcije, možete prisiliti Moodle da koristi tu konfiguraciju alata prilikom komunikacije s vanjskim pružateljem alata. Ako URL za pokretanje ne pripada pružatelju alata, pojavit će se upozorenje. U nekom slučajevima nije nužno upisivati URL za pokretanje prilikom definiranja određene vrste alata (ako se ne pokreće određeni resurs unutar pružatelja alata).
* **Prilagođena konfiguracija** - Za podešavanje prilagođene konfiguracije samo na ovoj instanci, prikažite Napredne postavke, te sami uneite korisnički ključ i dijeljenu tajnu riječ. Ako ih nemate, možete ih dobiti kod pružatelja alata.
     Neki alati ne zahtjevaju korisnički ključ ni dijeljenu tajnu riječ; u tom slučaju polja ostavite praznima.

### Uređivanje vrste alata

Tri su ikone dostupne iza padajućeg izbornika za vrste vanjskih alata:

* **Dodaj** - stvaranje konfiguracije alata na razini kolegija. Sve instance vanjskih alata u ovom kolegiju mogu koristiti tu konfiguraciju.
* **Uredi** - Odaberite vrstu alata na razini kolegija iz padajućeg izbornika, a zatim odaberite ovu ikonu. Tako možete urediti detalje konfiguracije alata.
* **Izbriši** - brisanje označene vrste alata na razini kolegija.';
$string['external_tool_types'] = 'Vrste vanjskih alata';
$string['failedtoconnect'] = 'Moodle nije mogao uspostaviti komunikaciju sa sustavom "{$a}"';
$string['filter_basiclti_configlink'] = 'Zadajte vaša preferirana sjedišta i njihove lozinke';
$string['filter_basiclti_password'] = 'Lozinka je obvezna';
$string['filterconfig'] = 'LTI administracija';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Koristite postojeću konfiguraciju za neispravno podešenu instancu';
$string['fixnew'] = 'Nova konfiguracija';
$string['fixnewconf'] = 'Zadajte novu konfiguraciju za neispravno podešenu instancu';
$string['fixold'] = 'Koristi postojeću';
$string['forced_help'] = 'Ova postavka je postavljena kao obvezna u konfiguraciji alata na razini cijelog sjedišta. Ne možete ju mijenjati na ovom sučelju.';
$string['force_ssl'] = 'Obveži na upotrebu SSL-a';
$string['force_ssl_help'] = 'Odabirom ove opcije sva pokretanja ovog alata obvezna su koristiti SSL.

Dodatno, svi zahtjevi web servisa koje će zatražiti pružatelj alata, koristit će SSL.

Ako koristite ovu opciju, provjerite da ovo Moodle sjedište, kao i pružatelj alata, podržavaju SSL.';
$string['global_tool_types'] = 'Globalne vrste alata';
$string['grading'] = 'Usmjeravanje ocjena';
$string['icon_url'] = 'URL ikone';
$string['icon_url_help'] = 'URL ikone omogućuje promjenu ikone koja se pojavljuje uz ovu aktivnost u kolegiju. Umjesto korištanje zadane LTI ikone, može se definirati ikona koja opisuje vrstu aktivnosti.';
$string['id'] = 'id';
$string['invalidid'] = 'Neispravan LTI ID';
$string['launch_in_moodle'] = 'Pokreni alat u Moodle-u';
$string['launchinpopup'] = 'Inicijalno spremište';
$string['launch_in_popup'] = 'Pokreni alat u novom prozoru';
$string['launchinpopup_help'] = 'Spremnik za pokretanje određuje način prikaza alata kada ga se pokrene iz kolegija. Neki spremnici daju vanjskom alatu više prostora za prikaz, dok se drugi bolje integriraju u Moodle okolinu.

* **Zadano** - korištenje spremnika određenog u podešavanju alata.
* **Ugradi** - alat je prikazan u postojećem Moodle prozoru, slično kao ostale aktivnosti.
* **Ugradi, bez blokova** - alat je prikazan u postojećem Moodle prozoru, ali prikazuje samo navigacijske kontrole na vrhu stranice.
* **Novi prozor** - alat se otvara u novom prozoru i zauzima sav dostupni prostor.
     Ovisno o Web pregledniku, otvorit će se novi prozor ili nova kartica (tab).
     Moguće je da će Web preglednik spriječiti otvaranje novog prozora.';
$string['launchoptions'] = 'Postavke pokretanja';
$string['launch_url'] = 'URL za pokretanje';
$string['launch_url_help'] = 'URL za pokretanje označava web adresu vanjskog alata, te može sadržavati dodatne informacije, poput resursa kojeg treba prikazati.
Ako niste sigurno što ovdje napisati, više informacija zatražite kod pružatelja alata.

Ako ste odabrali određenu vrstu alata, nećete moći unijeti URL za pokretanje. Ovo bi mogao biti slučaj ako se poveznica koristi samo za ulazak u sustav pružatelja alata, bez pokretanja određenog resursa.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Ocijeni LTI aktivnosti';
$string['lti:addinstance'] = 'Dodajte novu LTI aktivnost';
$string['lti_administration'] = 'LTI administracija';
$string['lti_errormsg'] = 'Alat je vratio sljedeću poruku o pogrešci: "{$a}"';
$string['lti:grade'] = 'Ocijeni LTI aktivnost';
$string['lti_launch_error'] = 'Dogodila se pogreška pri pokretanju vanjskog alata:';
$string['lti_launch_error_tool_request'] = '<p>
Za slanje zahtjeva administratoru da dovrši podešavanje alata, kliknite <a href="{$a->admin_request_url}" target="_top">ovdje
</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>
        Ova pogreška se možda dogodila zbog nepostojećih ključeva - korisničkog i dijeljenog - za pružatelja alata.
    </p>
    <p>
       Ako imate korisnički i dijeljeni ključ, možete ih upisati pri uređivanju instance vanjskog alata (uvjerite se da su vidljive napredne opcije).<br />
       Osim toga, <a href="{$a->course_tool_editor}">ovdje</a> možete napraviti podešavanje pružatelja alata na razini kolegija.
    </p>';
$string['lti:manage'] = 'Uredi LTI aktivnosti';
$string['lti:requesttooladd'] = 'Pošalji alat administratoru na podešavanje';
$string['lti_tool_request_added'] = 'Zahtjev za podešavanje alata je uspješno poslan. Možda ćete morati dodatno kontaktirati administratora kako bi dovršio podešavanje.';
$string['lti_tool_request_existing'] = 'Konfiguracija alata za domenu alata je već poslana.';
$string['lti:view'] = 'Prikaz LTI aktivnosti';
$string['main_admin'] = 'Općenita pomoć';
$string['main_admin_help'] = 'Vanjski alati omogućuju korisnicima Moodlea da jednostavno komuniciraju s udaljenim resursima za učenje. Pomoću posebnog protokola za pokretanje, udaljeni alat imat će pristup nekim općeniti informacijama o korisniku. Na primjer, naziv institucije, id kolegija, id korisnika, i druge informacije poput korisnikove adrese e-pošte.

Vrste alata popisane na ovoj stranici podijeljene su u tri kategorije:

* **Aktivni** - ove pružatelje alata je prihvatio i konfigurirao administrator. Mogu se koristiti unutar bilo kojeg kolegija na sjedištu. Ako su uneseni korisnički ključ i dijeljena tajna riječ, sigurna veza između Moodlea i udaljenog alata je uspostavljena.
* **Na čekanju** - ovi pružatelji alata su uvezeni kao paket, ali ih administrator još nije podesio. Nastavnici ih ipak mogu koristiti, ako imaju korisnički ključ i dijeljenu tajnu riječ, ili ako ti podaci nisu potrebni.
* **Odbijeni** - ove je pružatelje alata administrator označio kao one koji neće biti dostupni na cijelom Moodle sjedištu. Nastavnici ih ipak mogu koristiti, ako imaju korisnički ključ i dijeljenu tajnu riječ, ili ako ti podaci nisu potrebni.';
$string['miscellaneous'] = 'Razno';
$string['misconfiguredtools'] = 'Otkrivene su pogrešno podešene instance alata';
$string['missingparameterserror'] = 'Stranica nije ispravno podešena: "{$a}"';
$string['module_class_type'] = 'Vrsta Moodle modula';
$string['modulename'] = 'Vanjski alat';
$string['modulename_help'] = 'Aktivnost Vanjski alat omogućuje studentima interakciju s resursima i aktivnostima na drugim Web sjedištima. Na primjer, vanjski alat može omogućiti pristup novoj vrsti aktivnosti ili materijala za učenje.

Za izradu ove aktivnosti, potreban je pružatelj alata koji podržava LTI (Learning Tools Interoperability). Nastavnik može stvoriti vanjski alat ili koristiti alat kojeg je podesio administrator.

Vanjski alati se razlikuju od URL resursa na nekoliko načina:

* Vanjski alati su svjesni konteksta, tj. imaju pristup informacijama o korisniku koji je pokrenuo alat, poput institucije, kolegija i naziva
* Vanjski alati podržavaju čitanje, nadogradnju i brisanje ocjena koje su povezane s ovom instancom aktivnosti
* Konfiguracija vanjskog alata stvara sigurnu vezu između vašeg sjedišta i pružatelja alata, za sigurnu komunikaciju';
$string['modulenameplural'] = 'osnovni ltijevi';
$string['modulenamepluralformatted'] = 'LTI instance';
$string['never'] = 'Nikad';
$string['new_window'] = 'Novi prozor';
$string['noattempts'] = 'Još nije bilo pokušaja u okviru ove instance alata';
$string['no_lti_configured'] = 'Ne postoje aktivni vanjski alati koji su podešeni.';
$string['no_lti_pending'] = 'Nema vanjskih alata na čekanju.';
$string['no_lti_rejected'] = 'Nema odbijenih vanjskih alata.';
$string['noltis'] = 'Nema lti instanci';
$string['noservers'] = 'Nije pronađen nijedan poslužitelj';
$string['notypes'] = 'Trenutno ne postoje postavke za instalaciju LTI alata u Moodle. Kliknite na gornju poveznicu za instalaciju kako biste ih dodali.';
$string['noviewusers'] = 'Nisu pronađeni korisnici koji imaju ovlasti za korištenje ovog alata';
$string['optionalsettings'] = 'Opcionalne postavke';
$string['organization'] = 'Detalji organizacije';
$string['organizationdescr'] = 'Opis organizacije';
$string['organizationid'] = 'ID organizacije';
$string['organizationid_help'] = 'Jedinstveni identifikator za ovu Moodle instancu. Obično je to DNS zapis organizacije.

Ako je ovo polje prazno, kao zadanu vrijednost koristit će se naziv poslužitelja na kojem se nalazi ovo Moodle sjedište.';
$string['organizationurl'] = 'URL organizacije';
$string['organizationurl_help'] = 'Osnovni URL ove instalacije Moodlea.

Ako ovo polje ostavite praznim, koristit će se zadana vrijednost zasnovana na postavkama sjedišta.';
$string['pagesize'] = 'Broj pristupa alatu prikazanih po stranici.';
$string['password'] = 'Dijeljena tajna riječ';
$string['password_admin'] = 'Dijeljena tajna riječ';
$string['password_admin_help'] = 'Dijeljena tajna riječ se može opisati kao lozinka kojom autenticirate pristup alatu. Trebao bi ju objaviti pružatelj alata, uz korisnički ključ.

Alati koji od Moodlea ne zahtijevaju sigurnu komunikaciju i ne pružaju dodatne usluge (poput izvještaja o ocjenama) možda ne trebaju koristiti dijeljenu tajnu riječ.';
$string['password_help'] = 'Za unaprijed podešene alate, nije potrebno ovdje unositi dijeljenu tajnu riječ, jer će tajna riječ biti pohranjena tijekom procesa podešavanja.

Ovo je polje potrebno popuniti ako se stvara poveznica na pružatelja alata koji još nije podešen. Ako će pružatelj alata u ovom kolegiju biti korišten više puta, dobra ideja je dodati podašavanje alata na kolegiju.

Dijeljena tajna riječ se može opisati kao lozinka kojom autenticirate pristup alatu. Trebao bi ju objaviti pružatelj alata, uz korisnički ključ.

Alati koji od Moodlea ne zahtijevaju sigurnu komunikaciju i ne pružaju dodatne usluge (poput izvještaja o ocjenama) možda ne trebaju koristiti dijeljenu tajnu riječ.';
$string['pending'] = 'Na čekanju';
$string['pluginadministration'] = 'LTI administracija';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'Željena visina';
$string['preferwidget'] = 'Željeni Widget za pokretanje';
$string['preferwidth'] = 'Željena širina';
$string['press_to_submit'] = 'Kliknite za pokretanje ove aktivnosti';
$string['privacy'] = 'Privatnost';
$string['quickgrade'] = 'Dopusti brzo ocjenjivanje';
$string['quickgrade_help'] = 'Ako je omogućeno, na jednoj stranici može biti ocijenjeno više alata. Unesite ocjene i komentare, zatim kliknite na gumb "Pohrani sve povratne informacije" kako biste pohranili sve promjene na toj stranici.';
$string['redirect'] = 'Bit ćete preusmjereni za par trenutaka. Ako se to ne dogodi, kliknite na gumb.';
$string['reject'] = 'Odbijte';
$string['rejected'] = 'Odbijeni';
$string['resource'] = 'Resurs';
$string['resourcekey'] = 'Korisnički ključ';
$string['resourcekey_admin'] = 'Korisnički ključ';
$string['resourcekey_admin_help'] = 'Korisnički ključ se može opisati kao korisničko ime kojim autenticirate pristup alatu. Može ga koristiti pružatelj alata kako bi jedinstveno identificirao Moodle sjedište, s kojeg će korisnici pokretati alat.

Korisnički ključ daje pružatelj alata. Način isporuke korsničkog ključa različit je među alatima. Može biti automatizirano, ili interaktivni proces s pružateljem alata.

Alati koji od Moodlea ne zahtijevaju sigurnu komunikaciju i ne pružaju dodatne usluge (poput izvještaja o ocjenama) možda ne trebaju koristiti ključ resursa.';
$string['resourcekey_help'] = 'Za unaprijed podešene alate, nije potrebno ovdje unositi ključ resursa, jer će korisnički ključ biti pohranjen tijekom procesa podešavanja.

Ovo je polje potrebno popuniti ako se stvara poveznica na pružatelja alata koji još nije podešen. Ako će pružatelj alata u ovom kolegiju biti korišten više puta, dobra ideja je dodati podašavanje alata na kolegiju.

Korisnički ključ se može opisati kao korisničko ime kojim autenticirate pristup alatu. Može ga koristiti pružatelj alata kako bi jedinstveno identificirao Moodle sjedište, s kojeg će korisnici pokretati alat.

Korisnički ključ daje pružatelj alata. Način isporuke korsničkog ključa različit je među alatima. Može biti automatizirano, ili interaktivni proces s pružateljem alata.

Alati koji od Moodlea ne zahtijevaju sigurnu komunikaciju i ne pružaju dodatne usluge (poput izvještaja o ocjenama) možda ne trebaju koristiti dijeljenu tajnu riječ.';
$string['resourceurl'] = 'URL resursa';
$string['return_to_course'] = 'Kliknite <a href="{$a->link}" target="_top">ovdje</a> za povratak na kolegij.';
$string['saveallfeedback'] = 'Pohrani sve moje povratne informacije';
$string['secure_icon_url'] = 'Sigurni URL ikone';
$string['secure_icon_url_help'] = 'Slično kao URL ikone, ali se koristi u slučaju sigurnog pristupanja sustavu Moodle preko SSL-a. Osnovna svrha ovog polja je spriječiti Web preglednik da upozorava korisnika ako je željenoj stranici pristupano preko SSL-a, ali je zatražana slika preko nesigurnog URL-a.';
$string['secure_launch_url'] = 'Sigurni URL za pokretanje';
$string['secure_launch_url_help'] = 'Slično kao URL za pokretanje, ali se koristi ako je potrebna visoka sigurnost. Moodle će koristiti sigurni URL za pokretanje umjesto URL-a za pokretanje ako se Moodle sjedištu pristupa preko SSL-a, ili ako je u alat podešen da se uvijek pokreće preko SSL-a.

URL za pokretanje također može biti postavljen s https protokolom, kako bi se obvezalo na korištenje SSL-a, a ovo polje može ostati prazno.';
$string['send'] = 'Pošalji';
$string['setupoptions'] = 'Postavke za podešavanje';
$string['share_email'] = 'Podijeli adresu e-pošte s pružateljem alata';
$string['share_email_admin'] = 'Podijeli adresu e-pošte s pružateljem alata';
$string['share_email_admin_help'] = 'Definira hoće li adresa e-pošte korisnika koji pokreće alat biti podijeljena s pružateljem alata.
Pružatelju alata adresa može trebati za raspoznavanje korisnika s istim imenom u korisničkom sučelju, ili za slanje poruka e-poštom, ovisno o operacijama korisnika u alatu.';
$string['share_email_help'] = 'Definira hoće li adresa e-pošte korisnika koji pokreće alat biti podijeljena s pružateljem alata.
Pružatelju alata adresa može trebati za raspoznavanje korisnika s istim imenom u korisničkom sučelju, ili za slanje poruka e-poštom, ovisno o operacijama korisnika u alatu.

Napomena: ova se postavka može zaobići u podešavanju alata.';
$string['share_name'] = 'Podijeli ime korisnika s pružateljem alata';
$string['share_name_admin'] = 'Podijeli ime korisnika s pružateljem alata';
$string['share_name_admin_help'] = 'Definira hoće li puno ime korisnika koji pokreće alat biti podijeljena s pružateljem alata.
Pružatelju alata puno ime može trebati za prikazivanje korisnih informacija u alatu.';
$string['share_name_help'] = 'Definira hoće li puno ime korisnika koji pokreće alat biti podijeljena s pružateljem alata.
Pružatelju alata puno ime može trebati za prikazivanje korisnih informacija u alatu.

Napomena: ova se postavka može zaobići u podešavanju alata.';
$string['share_roster'] = 'Dopusti alatu pristup popisu sudionika kolegija';
$string['share_roster_admin'] = 'Alat može pristupiti popisu sudionika kolegija';
$string['share_roster_admin_help'] = 'Definira može li alat pristupiti popisu korisnika kolegija u kojima se pokreće ovaj tip alata.';
$string['share_roster_help'] = 'Definira može li alat pristupiti popisu korisnika kolegija.

Napomena: ova se postavka može zaobići u podešavanju alata.';
$string['show_in_course'] = 'Prikaži vrstu alata pri stvaranju instance alata';
$string['show_in_course_help'] = 'Ako je ovo označeno, konfiguracija ovog alata pojavit će se u padajućem izborniku "Vrsta vanjskog alata" kada nastavnici u kolegijima podešavaju vanjske alate.

U većini slučajeva, opcija ne treba biti označena. Nastavnci mogu koristiti ovu konfiguraciju alata temeljenu na URL-u za pokretanje koji odgovara URL osnovne adrese alata, što je preporučena metoda.

Jedini slučaj kada ova opcija treba biti omogućena je kada se konfiguracija alata za Single-Sign-On.
Na primjer, to je slučaj kada sva pokretanja pružatelja alata korisnika šalju samo do stranice od koje će krenuti dalje, umjesto do pojediog resursa.';
$string['size'] = 'Parametri veličine';
$string['submission'] = 'Aktivnost na vanjskom alatu';
$string['submissions'] = 'Predano';
$string['subplugintype_ltisource'] = 'Izvor LTI';
$string['subplugintype_ltisource_plural'] = 'Izvori LTI';
$string['toggle_debug_data'] = 'Uključi podatke o debugiranju';
$string['tool_config_not_found'] = 'Nije pronađena konfiguracija alata za ovaj URL.';
$string['tool_settings'] = 'Postavke alata';
$string['toolsetup'] = 'Podešavanje vanjskog alata';
$string['toolurl'] = 'URL osnovne adrese alata';
$string['toolurl_help'] = 'URL osnovne adrese alata koristi se za uparivanje URL-ova za pokretanje alata s toćnom konfiguracijom alata. Pisanje protokola - http(s) je opcionalno.

Dodatno, URL osnovne adrese alata koristi se kao URL za pokretanje, ako isti nije postavljen u ovoj instnaci vanjskog alata.

<table>
    <thead>
        <tr>
            <td>
                <b>URL osnovne adrese</b>
            </td>
            <td>
                <b>Odgovara</b>
            </td>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>
                tool.com
            </td>
            <td>
                tool.com, tool.com/quizzes, tool.com/quizzes/quiz.php?id=10, www.tool.com/quizzes
            </td>
        </tr>
        <tr>
            <td>
                www.tool.com/quizzes
            </td>
            <td>
                tool.com/quizzes, tool.com/quizzes/take.php?id=10, www.tool.com/quizzes
            </td>
        </tr>
        <tr>
            <td>
                quiz.tool.com
            </td>
            <td>
                quiz.tool.com, quiz.tool.com/take.php?id=10
            </td>
        </tr>
    </tbody>
</table>

Ako dvije različite konfiguracije postoje na istoj domeni, bit će korišteno najpreciznije uparivanje.';
$string['typename'] = 'Naziv alata';
$string['typename_help'] = 'Naziv alata služi za identifikaciju pružatelja alata unutar Moodle-a. Naziv koji unesete ovdje će biti vidljiv predavačima pri dodavanju vanjskih alata u svoj kolegij.';
$string['types'] = 'Vrste';
$string['update'] = 'Nadogradnja';
$string['using_tool_configuration'] = 'Korištenje konfiguracije alata:';
$string['validurl'] = 'Valjani URL mora započeti s http(s)://';
$string['viewsubmissions'] = 'Prikaži ocjenjivanje aktivnosti na vanjskom alatu.';
