<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Kontrola pristupa';
$string['actionaftercorrectanswer'] = 'Operacija nakon točnog odgovora';
$string['actionaftercorrectanswer_help'] = '<p>Nakon točno odgovora na pitanje moguće su 3 opcije za sljedeću stranicu:<p><br />

<ul>
<li>Normalan - slijedi tok lekcije</li>
<li>Prikaži neprikazanu stranicu - stranice su prikazane nasumično s time da je svaka stranica prikazana samo ujedanput</li>
<li>Prikaži neodgovorenu stranicu - stranice su prikazane nasumično s time da se stranice s ne odgovorenim pitanjem ponavljaju</li>
</ul>';
$string['actions'] = 'Operacije';
$string['activitylink'] = 'Poveznica na sljedeću aktivnost';
$string['activitylink_help'] = 'Ukoliko na kraju lekcije želite prikazati poveznicu na neku drugu aktivnost u kolegiju, odaberite aktivnost iz padajućeg izbornika.';
$string['activitylinkname'] = 'Idi na: {$a}';
$string['addabranchtable'] = 'Dodaj tablicu grananja';
$string['addanendofbranch'] = 'Dodaj kraj grane';
$string['addanewpage'] = 'Dodaj novu stranicu';
$string['addaquestionpage'] = 'Dodaj novu stranicu s pitanjem';
$string['addaquestionpagehere'] = 'Dodaj ovdje novu stranicu s pitanjem';
$string['addbranchtable'] = 'Dodaj tablicu grananja';
$string['addcluster'] = 'Dodaj grupu pitanja';
$string['addedabranchtable'] = 'Dodana je tablica grananja';
$string['addedanendofbranch'] = 'Dodan je kraj grane';
$string['addedaquestionpage'] = 'Dodaj novu stranicu s pitanjem';
$string['addedcluster'] = 'Dodana je grupa pitanja';
$string['addedendofcluster'] = 'Dodan je kraj grupe pitanja';
$string['addendofcluster'] = 'Dodaj kraj grupe pitanja';
$string['addpage'] = 'Dodaj stranicu';
$string['anchortitle'] = 'Početak glavnog sadržaja';
$string['and'] = 'i';
$string['answer'] = 'Odgovor';
$string['answeredcorrectly'] = 'je točno odgovoreno.';
$string['answersfornumerical'] = 'Odgovori numeričkih pitanja trebaju biti uređeni parovi najmanjih i najvećih vrijednosti.';
$string['arrangebuttonshorizontally'] = 'Posloži gumbe u tablici grananja vodoravno?';
$string['attempt'] = 'Pokušaj: {$a}';
$string['attempts'] = 'Pokušaja';
$string['attemptsdeleted'] = 'Izbrisani pokušaji';
$string['attemptsremaining'] = 'Broj preostalih pokušaja: {$a}';
$string['available'] = 'Dostupno od';
$string['averagescore'] = 'Prosječan broj bodova';
$string['averagetime'] = 'Prosječno vrijeme';
$string['branch'] = 'Grana';
$string['branchtable'] = 'Tablica grananja';
$string['cancel'] = 'Odustanite';
$string['cannotfindanswer'] = 'Pogreška: odgovor nije pronađen';
$string['cannotfindattempt'] = 'Pogreška: pokušaj nije pronađen';
$string['cannotfindessay'] = 'Pogreška: esej nije pronađen';
$string['cannotfindfirstgrade'] = 'Pogreška: ocjena nije pronađena';
$string['cannotfindfirstpage'] = 'Nije moguće naći prvu stranicu';
$string['cannotfindgrade'] = 'Pogreška: ocjene nisu pronađene';
$string['cannotfindnewestgrade'] = 'Pogreška: najnovija ocjena nije pronađena';
$string['cannotfindnextpage'] = 'Backup lekcije: sljedeća stranica nije pronađena!';
$string['cannotfindpagerecord'] = 'Dodavanje kraja grane: zapis o stranici nije pronađen';
$string['cannotfindpages'] = 'Nije moguće naći stranice lekcije';
$string['cannotfindpagetitle'] = 'Potvrda brisanja: naslov stranice nije pronađen';
$string['cannotfindpreattempt'] = 'Zapis o prethodnom pokušaju nije pronađen!';
$string['cannotfindrecords'] = 'Pogreška: zapisi lekcije nisu pronađeni';
$string['cannotfindtimer'] = 'Pogreška: zapisi iz tablice lesson_timer nisu pronađeni';
$string['cannotfinduser'] = 'Pogreška: korisnici nisu pronađeni';
$string['canretake'] = '{$a} može ponovo pogledati lekciju';
$string['casesensitive'] = 'Koristi regularne izraze';
$string['casesensitive_help'] = 'Stavite kvačicu ako želite koristiti regularne izraze za analizu odgovora.';
$string['checkbranchtable'] = 'Provjera tablice grananja';
$string['checkedthisone'] = 'je odabralo ovaj odgovor';
$string['checknavigation'] = 'Provjeri navigaciju';
$string['checkquestion'] = 'Provjeri pitanje';
$string['classstats'] = 'Statistika svih sudionika kolegija';
$string['clicktodownload'] = 'Kliknite na sljedeću poveznicu kako bi preuzeli datoteku.';
$string['clicktopost'] = 'Kliknite ovdje kako bi postavili svoju ocjenu na listu najboljih rezultata.';
$string['cluster'] = 'Grupa pitanja';
$string['clusterjump'] = 'Neprikazano pitanje iz grupe pitanja';
$string['clustertitle'] = 'Grupa pitanja';
$string['collapsed'] = 'Sažeto';
$string['comments'] = 'Vaši komentari';
$string['completed'] = 'Završeno';
$string['completederror'] = 'Završite lekciju';
$string['completethefollowingconditions'] = 'Morate ispuniti sljedeće uvjete u lekciji <b>{$a}</b> kako bi mogli nastaviti.';
$string['conditionsfordependency'] = 'Uvjet(i) zavisnosti';
$string['configactionaftercorrectanswer'] = 'Zadana operacija koja će se izvesti nakon točnog odgovora';
$string['configmaxanswers'] = 'Zadani najveći broj odgovora/grana po stranici';
$string['configmaxhighscores'] = 'Broj prikazanih najboljih rezultata';
$string['configmediaclose'] = 'Prikaži gumb za zatvaranje prozora na skočnom prozoru povezane multimedijske datoteke';
$string['configmediaheight'] = 'Postavka visine skočnog prozora povezane multimedijske datoteke';
$string['configmediawidth'] = 'Postavka širine skočnog prozora povezane multimedijske datoteke';
$string['configslideshowbgcolor'] = 'Boja pozadine slideshow-a ako je omogućen';
$string['configslideshowheight'] = 'Postavka visine slideshow-a ako je omogućen';
$string['configslideshowwidth'] = 'Postavka širine slideshow-a ako je omogućen';
$string['confirmdelete'] = 'Izbriši stranicu';
$string['confirmdeletionofthispage'] = 'Potvrdi brisanje stranice';
$string['congratulations'] = 'Čestitamo - stigli ste do kraja lekcije';
$string['continue'] = 'Nastavak';
$string['continuetoanswer'] = 'Nastavite da biste promijenili odgovore.';
$string['continuetonextpage'] = 'Nastavite na sljedeću stranicu';
$string['correctanswerjump'] = 'Ispravan odgovor vodi na';
$string['correctanswerscore'] = 'Broj bodova za točan odgovor';
$string['correctresponse'] = 'Povratna informacija za točan odgovor';
$string['credit'] = 'Bodovi';
$string['customscoring'] = 'Prilagođeno bodovanje';
$string['customscoring_help'] = 'Ako je omogućeno, svakom se odgovoru može dodijeliti numerička vrijednost (pozitivna ili negativna)';
$string['deadline'] = 'Krajnji rok';
$string['defaultessayresponse'] = 'Nastavnik će pregledati vaš esej.';
$string['deleteallattempts'] = 'Izbriši sve pokušaje prolaska kroz lekciju';
$string['deletedefaults'] = 'Obrisan {$a} x osnovne postavke lekcije';
$string['deletedpage'] = 'Obrisana stranica';
$string['deleting'] = 'Brisanje';
$string['deletingpage'] = 'Brisanje stranice: {$a}';
$string['dependencyon'] = 'Zavisi o';
$string['dependencyon_help'] = 'Ova postavka omogućava da pristup ovoj lekciji ovisi o rezultatima ocjena studenata u drugoj lekciji u istom kolegiju. Može se koristiti bilo koja kombinacija utrošenog vremena, završenosti ili "ocjene veće od".';
$string['description'] = 'Opis';
$string['detailedstats'] = 'Detaljna statistika';
$string['didnotanswerquestion'] = 'Niste odgovorili na ovo pitanje.';
$string['didnotreceivecredit'] = 'Niste dobili bodove';
$string['displaydefaultfeedback'] = 'Korištenje zadanih povratnih informacija';
$string['displaydefaultfeedback_help'] = 'Ako je omogućeno i povratna informacija nije nađena, bit će prikazana zadana povratna informacija "Točan odgovor" ili "Pogrešan odgovor".';
$string['displayhighscores'] = 'Prikaz najboljih rezultata';
$string['displayinleftmenu'] = 'Prikaz u izborniku s lijeve strane?';
$string['displayleftif'] = 'Prikaži izbornike s lijeve strane ako je ocjena veća od';
$string['displayleftif_help'] = 'Ovom postavkom određujete mora li student prikupiti određeni broj bodova kako bi vidio izbornik s lijeve strane. Ova postavka obvezuje studenta da prođe kroz cijelu lekciju pri prvom pokušaju. Nakon što dobije potrebnu ocjenu student može koristiti izbornik s lijeve strane za pregled.';
$string['displayleftmenu'] = 'Prikaz izbornika s lijeve strane';
$string['displayleftmenu_help'] = 'Ako je omogućeno, bit će prikazana lista stranica (tablica grananja).';
$string['displayofgrade'] = 'Prikaz ocjena (samo za studente)';
$string['displayreview'] = 'Prikaz gumba za pregled';
$string['displayreview_help'] = 'Ako je omogućeno i student pogrešno odgovori na pitanje bit će mu ponuđeno da pokuša ponovo odgovoriti bez dobivanja bodova ili da nastavi s lekcijom.';
$string['displayscorewithessays'] = 'Osvojili ste {$a->score} od najviše {$a->tempmaxgrade} bodova za pitanja koja se automatski ocjenjuju.<br />Broj vaših odgovora na pitanja tipa esej koji će biti naknadno ocjenjeni i pridodani ukupnoj ocjeni: {$a->essayquestions}.<br /><br />Vaša trenutna ocjena (bez eseja) je {$a->score} od {$a->grade}';
$string['displayscorewithoutessays'] = 'Vaš rezultat je {$a->score} (od mogućih {$a->grade}).';
$string['edit'] = 'Uredi';
$string['editingquestionpage'] = 'Uređivanje {$a} stranice pitanja';
$string['editlessonsettings'] = 'Uredi postavke lekcije';
$string['editpage'] = 'Uredi sadržaj stranice';
$string['editpagecontent'] = 'Uredi sadržaj stranice';
$string['email'] = 'E-pošta';
$string['emailallgradedessays'] = 'Pošalji sve ocijenjene eseje putem e-pošte';
$string['emailgradedessays'] = 'Pošalji ocijenjene eseje putem e-pošte';
$string['emailsuccess'] = 'E-pošta je uspješno poslana';
$string['emptypassword'] = 'Lozinka ne može biti prazna (bez ijednog znaka)';
$string['endofbranch'] = 'Kraj grane';
$string['endofcluster'] = 'Kraj grupe pitanja';
$string['endofclustertitle'] = 'Kraj grupe pitanja';
$string['endoflesson'] = 'Kraj lekcije';
$string['enteredthis'] = 'je unio ovaj odgovor.';
$string['entername'] = 'Unesite nadimak koji će biti prikazan na listi najboljih rezultata';
$string['enterpassword'] = 'Molim unesite lozinku:';
$string['eolstudentoutoftime'] = 'Upozorenje: Isteklo Vam je vrijeme za ovu lekciju. Vaš posljednji odgovor možda nije uračunat ako je predan nakon isteka vremena.';
$string['eolstudentoutoftimenoanswers'] = 'Niste odgovorili niti na jedno pitanje. Vaša ocjena za ovu lekciju je 0.';
$string['essay'] = 'Esej';
$string['essayemailmessage'] = '<p>Esej:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentar nastavnika ({$a->teacher}):<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste {$a->earned} od maksimalno {$a->outof} bodova za ovaj esej.</p><p>Vaša ocjena za ovu lekciju je promijenjena u {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Esej:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentrar ocjenjivača:<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste {$a->earned} od maksimalnih {$a->outof} bodova za ovaj esej.</p><p>Vaša ocjena za ovu lekciju je promijenjena u {$a->newgrade}%.</p>';
$string['essayemailsubject'] = 'Vaša ocjena za pitanje {$a}';
$string['essays'] = 'Eseji';
$string['essayscore'] = 'Rezultat eseja';
$string['fileformat'] = 'Oblik datoteke (format)';
$string['finish'] = 'Završi';
$string['firstanswershould'] = 'Prvi odgovor bi trebalo voditi na "ispravnu" stranicu';
$string['firstwrong'] = 'Nažalost, ne možete osvojiti ovaj bod jer je Vaš odgovor netočan. Želite li pokušati ponovo kako bi ste učili (ali bez mogućnosti osvojanja boda)?';
$string['flowcontrol'] = 'Kontrola toka lekcije';
$string['full'] = 'Prošireno';
$string['general'] = 'Opće postavke';
$string['gotoendoflesson'] = 'Idi na kraj lekcije';
$string['grade'] = 'Ocjena';
$string['gradebetterthan'] = 'Ocjena viša od (%)';
$string['gradebetterthanerror'] = 'Osvojite ocjenu veću od {$a} posto';
$string['gradeessay'] = 'Ocijeni odgovore na esejski tip pitanja({$a->notgradedcount} još nije ocjenjeno, a {$a->notsentcount} nije poslano)';
$string['gradeis'] = 'Ocjena: {$a}';
$string['gradeoptions'] = 'Postavke ocjene';
$string['handlingofretakes'] = 'Upravljanje ponovnim pokušajima';
$string['handlingofretakes_help'] = 'Ukoliko su dopušteni ponovni pokušaji, ova postavka označava je li ocjena lekcije jednaka prosjeku ili maksimumu svih pokušaja.';
$string['havenotgradedyet'] = 'Još nije ocijenjeno.';
$string['here'] = 'ovdje';
$string['highscore'] = 'Najbolji rezultat';
$string['highscores'] = 'Popis najboljih rezultata';
$string['hightime'] = 'Najbolje vrijeme';
$string['importcount'] = 'Uvoz {$a} pitanja';
$string['importquestions'] = 'Uvoz pitanja';
$string['importquestions_help'] = 'Ova mogućnost omogućava uvoz raznih oblika pitanja preko tekstualne datoteke.';
$string['insertedpage'] = 'Umetnuta stranica';
$string['invalidfile'] = 'Neispravna datoteka';
$string['invalidid'] = 'Nije proslijeđen ID modula ili lekcije';
$string['invalidlessonid'] = 'ID lekcije nije valjan';
$string['invalidpageid'] = 'ID stranice nije valjan';
$string['jump'] = 'Pređi na';
$string['jumps'] = 'Prijelazi';
$string['jumps_help'] = 'Svaki odgovor ili opis ima odgovarajući prijelaz. Prijelaz može biti relativan, poput trenutne ili sljedeće stranice, ili apsolutan, poput bilo koje stranice u lekciji.';
$string['jumpsto'] = 'Prijelazi na <em>{$a}</em>';
$string['leftduringtimed'] = 'Napustili ste lekciju koja je vremenski ograničena.<br />Pritisnite gumb "Nastavi" kako bi ste pogledali lekciju od početka.';
$string['leftduringtimednoretake'] = 'Napustili ste lekciju koja je vremenski ograničena i nije Vam <br /> dopušteno da nastavite ili počnete lekciju iz početka.';
$string['leftduringtimedsession'] = 'Napustili ste lekciju koja je vremenski ograničena.';
$string['lesson:addinstance'] = 'Dodavanje nove lekcije';
$string['lessonattempted'] = 'Lekciji je pristupano';
$string['lessonclosed'] = 'Lekcija je zatvorena {$a}.';
$string['lessoncloses'] = 'Lekcija se zatvara';
$string['lessoncloseson'] = 'Vrijeme zatvaranja lekcije: {$a}';
$string['lesson:edit'] = 'Uredi lekciju';
$string['lessonformating'] = 'Oblikovanje lekcije';
$string['lesson:manage'] = 'Upravljanje lekcijom';
$string['lessonmenu'] = 'Izbornik lekcije';
$string['lessonnotready'] = 'Ova lekcija još nije spremna za uporabu. Molimo kontaktirajte svog {$a}.';
$string['lessonnotready2'] = 'Ova lekcija još nije spremna za uporabu.';
$string['lessonopen'] = 'Ova lekcija će biti dostupna od {$a}.';
$string['lessonopens'] = 'Lekcija se otvara';
$string['lessonpagelinkingbroken'] = 'Prva stranica nije pronađena. Poveznice među stanicama lekcije nisu ispravne. Molimo kontaktirajte administratora.';
$string['lessonstats'] = 'Statistika lekcije';
$string['linkedmedia'] = 'Povezana multimedija';
$string['loginfail'] = 'Prijava neuspješna, pokušajte ponovno...';
$string['lowscore'] = 'Naslabiji rezultat';
$string['lowtime'] = 'Najslabije vrijeme';
$string['manualgrading'] = 'Ocjenjivanje eseja';
$string['matchesanswer'] = 'Poklapa se s odgovorom';
$string['matching'] = 'Odgovarajući';
$string['matchingpair'] = 'Povezani par {$a}';
$string['maxgrade'] = 'Najviša ocjena';
$string['maxgrade_help'] = 'Ova postavka određuje najvišu ocjenu za lekciju. Ukoliko je vrijednost postavljena na 0 lekcija se neće prikazati među ocjenama.';
$string['maxhighscores'] = 'Broj najboljih rezultata za prikaz';
$string['maximumnumberofanswersbranches'] = 'Maksimalni broj odgovora/grananja';
$string['maximumnumberofanswersbranches_help'] = 'Ova postavka određuje maksimalan broj odgovora koji se mogu koristiti u lekciji. Ukoliko se koriste samo pitanja tipa točno/netočno, vrijednost se može postaviti na 2. Ova postavka se može promijeniti u bilo kojem trenutku pošto utječe samo na prikaz nastavniku, ne i na podatke.';
$string['maximumnumberofattempts'] = 'Maksimalni broj pokušaja';
$string['maximumnumberofattempts_help'] = 'Ova postavka određuje maksimalni broj pokušaja za svako pitanje. Ukoliko se uzastopce netočno odgovori na pitanje i dostigne maksimalna vrijednost prikazat će se sljedeća stranica lekcije.';
$string['maximumnumberofattemptsreached'] = 'Dosegnut je maksimalni broj pokušaja - prelazi se na sljedeću stranicu';
$string['maxtime'] = 'Vremensko ograničenje (u minutama)';
$string['maxtimewarning'] = 'Minuta preostalih do kraja lekcije: {$a} ';
$string['mediaclose'] = 'Prikaz gumba za zatvaranje';
$string['mediafile'] = 'Skočni prozor za prikaz datoteke ili web stranice';
$string['mediafile_help'] = 'Ukoliko želite pridodati skočni prozor na početku lekcije odaberite odgovarajuću datoteku za prikaz. Svaka stranica lekcije će sadržati poveznicu za otvaranje skočnog prozora ukoliko je potrebno.';
$string['mediafilepopup'] = 'Kliknite ovdje za prikaz';
$string['mediaheight'] = 'Visina prozora:';
$string['mediawidth'] = 'Širina prozora:';
$string['messageprovider:graded_essay'] = 'Obavijesti o ocijenjenim esejima';
$string['minimumnumberofquestions'] = 'Maksimalni broj odgovora';
$string['minimumnumberofquestions_help'] = 'Ova postavka određuje najmanji broj odgovora koji će se koristiti pri izračunu ocjene za aktivnost. Ukoliko lekcija sadrži jednu ili više tablice grana vrijednost bi trebalo postaviti na 0.

Na primjer, ukoliko postavite vrijednost na 20 sljedeći tekst će se pojaviti na uvodnoj stranici lekcije: "U ovoj lekciji se očekuje da odgovorite na najmanje 20 pitanja. Ukoliko želite možete odgovoriti i na više. Međutim, ukoliko odgovorite na manje od 20 pitanja, vaša ocjena će se računati kao da ste odgovorili na svih 20 pitanja."';
$string['missingname'] = 'Unesite nadimak';
$string['modattempts'] = 'Dopusti pregled studentima';
$string['modattempts_help'] = 'Ova postavka omogućava studentima da pregledaju lekciju ponovo od početka.';
$string['modattemptsnoteacher'] = 'Pregled studentima vrijedi samo za studente.';
$string['modulename'] = 'Lekcija';
$string['modulename_help'] = 'Lekcija omogućava nastavnicima stvaranje interaktivnih sadržaja. Nastavnik može koristiti lekciju za stvaranje linearno nanizanih stranica sa sadržajem ili izraditi aktivnost koja studentu pruža veći broj različitih "puteva" i opcija pri usvajanju datih sadržaja. U svakom slučaju, nastavnici mogu povećati ciljanu interakciju studenata sa sadržajem korištenjem raznovrsnih pitanja (višestruki odgovori, pitanja s uparivanjem i sl.). Ovisno o odgovorima, studenti mogu napredovati dalje u samoj lekciji ili biti vraćeni na prethodnu stranicu ili usmjereni na neko od grananja sadržaja.

Lekcija može biti ocijenjena.

Lekcije se mogu koristiti za:

* Samostalno učenje
* Scenarije koji obuhvaćaju simulacije ili vježbe iz odlučivanja';
$string['modulenameplural'] = 'Lekcije';
$string['move'] = 'Premjesti stranicu';
$string['movedpage'] = 'Premještena stranica';
$string['movepagehere'] = 'Premjesti stranicu ovdje';
$string['moving'] = 'Premeštanje stranice: {$a}';
$string['multianswer'] = 'Višestruki odgovor';
$string['multianswer_help'] = 'Označite ukoliko postoji više točnih odgovora.';
$string['multichoice'] = 'Višestruki odabir';
$string['multipleanswer'] = 'Višestruki odgovori';
$string['nameapproved'] = 'Naziv odobren';
$string['namereject'] = 'Nažalost, vaše ime je odbijeno.<br />Molimo pokušajte s drugim imenom.';
$string['new'] = 'novo';
$string['nextpage'] = 'Sljedeća stranica';
$string['noanswer'] = 'Nema predanih odgovora. Molimo vratite se natrag i odgovorite na pitanje.';
$string['noattemptrecordsfound'] = 'Nije pronađen niti jedan pokušaj: ocjena nije dana';
$string['nobranchtablefound'] = 'Nije pronađena nijedna tablica grananja';
$string['nocommentyet'] = 'Nema komentara.';
$string['nocoursemods'] = 'Nema aktivnosti';
$string['nocredit'] = 'Bez bodova';
$string['nodeadline'] = 'Nema roka';
$string['noessayquestionsfound'] = 'U lekciji nisu pronađena pitanja esejskog tipa.';
$string['nohighscores'] = 'Nema najboljih rezultata';
$string['nolessonattempts'] = 'U lekciji trenutno nema pokušaja.';
$string['nooneansweredcorrectly'] = 'Nitko nije točno odgovorio.';
$string['nooneansweredthisquestion'] = 'Nitko nije odgovorio na ovo pitanje.';
$string['noonecheckedthis'] = 'Nitko nije odabrao ovaj odgovor.';
$string['nooneenteredthis'] = 'Nitko nije ovo pokušao.';
$string['noonehasanswered'] = 'Trenutno nitko nije odgovorio na pitanje esejskog tipa.';
$string['noretake'] = 'Ponovni pokušaj lekcije nije dopušten.';
$string['normal'] = 'Normalno - pratite tok lekcije';
$string['notcompleted'] = 'Nije završeno';
$string['notdefined'] = 'Nije definirano';
$string['nothighscore'] = 'Vaš rezultat nije među prvih {$a} na listi najboljih rezultata.';
$string['notitle'] = 'Bez naslova';
$string['numberofcorrectanswers'] = 'Broj točnih odgovora: {$a}';
$string['numberofcorrectmatches'] = 'Number of Correct Matches: {$a}';
$string['numberofpagestoshow'] = 'Broj stranica (kartica) koje će biti prikazane';
$string['numberofpagestoshow_help'] = 'Ova postavka određuje broj stranica prikazanih u lekciji. Postavka je primjenjiva samo na lekcije kod koje se stranice prikazuju nasumičnim redom (kada je postavka "Akcija nakon točnog odgovora" postavljena na "Prikaži nepregledanu stranicu" ili "Prikaži neodgovorenu stranicu"). Ukoliko je vrijednost 0, bit će prikazane sve stranice.';
$string['numberofpagesviewed'] = 'Broj odgovorenih pitanja: {$a}';
$string['numberofpagesviewednotice'] = 'Broj odgovorenih pitanja: {$a->nquestions}; (Trebali bi odgovoriti na barem: {$a->minquestions} pitanja)';
$string['numerical'] = 'Brojčani';
$string['ongoing'] = 'Prikaz trenutnog rezultata';
$string['ongoingcustom'] = 'Do sada ste osvojili {$a->score} od maksimalno {$a->currenthigh} bodova.';
$string['ongoing_help'] = 'Ako je omogućeno, na svakoj stranici će se prikazati trenutni broj bodova od ukupno mogućeg.';
$string['ongoingnormal'] = 'Točno odgovorenih pitanja: {$a->correct} od {$a->viewed} pokušaja.';
$string['onpostperpage'] = 'Samo jedna poruka po ocjeni';
$string['options'] = 'Opcije';
$string['or'] = 'ILI';
$string['ordered'] = 'Poredan';
$string['other'] = 'Ostalo';
$string['outof'] = 'Od {$a}';
$string['overview'] = 'Pregled';
$string['overview_help'] = 'Lekcija se sastoji od određenog broja stranica, te izborno tablica grana. Stranicu čini sadržaj, a obično završava pitanjem. Uz svaki odgovor je vezan prijelaz. Prijelazi mogu biti relativni, poput trenutne ili sljedeće stranice, ili relativni poput bilo koje stranice u lekciji. Tablica grana je stranica koja sadrži niz poveznica na druge stranice u lekcije, na primjer "Tablica sadržaja".';
$string['page'] = 'Stranica: {$a}';
$string['pagecontents'] = 'Sadržaj stranice';
$string['page-mod-lesson-edit'] = 'Uredi stranicu lekcije';
$string['page-mod-lesson-x'] = 'Bilo koja stranica lekcije';
$string['pages'] = 'Stranice';
$string['pagetitle'] = 'Naslov stranice';
$string['password'] = 'Lozinka';
$string['passwordprotectedlesson'] = 'Lekcija {$a} je zaštićena lozinkom.';
$string['pleasecheckoneanswer'] = 'Molimo odaberite jedan odgovor';
$string['pleasecheckoneormoreanswers'] = 'Molimo odaberite jedan ili više točnih odgovora';
$string['pleaseenteryouranswerinthebox'] = 'Molimo unesite svoj odgovor u polje za unos teksta';
$string['pleasematchtheabovepairs'] = 'Uparite prethodne parove';
$string['pluginadministration'] = 'Administracija lekcije';
$string['pluginname'] = 'Lekcija';
$string['pointsearned'] = 'Osvojeni bodovi';
$string['postprocesserror'] = 'Došlo je do greške tijekom postprocesiranja!';
$string['postsuccess'] = 'Uspješna predaja';
$string['practice'] = 'Lekcija za vježbu';
$string['practice_help'] = 'Lekcija za vježbu se ne prikazuje u ocjenama.';
$string['preprocesserror'] = 'Došlo je do greške tijekom predprocesiranja!';
$string['prerequisitelesson'] = 'Lekcija koja je preduvjet';
$string['preview'] = 'Pregled';
$string['previewlesson'] = 'Pregled {$a}';
$string['previouspage'] = 'Prethodna stranica';
$string['processerror'] = 'Pogreška prilikom obrade!';
$string['progressbar'] = 'Traka s prikazom napredovanja kroz lekciju';
$string['progressbar_help'] = 'Ako je omogućeno, traka će biti prikazana na dnu stranica lekcije i prikazivat će približan postotak napredovanja kroz lekciju.';
$string['progressbarteacherwarning'] = 'Traka s prikazom napretka se ne prikazuje za {$a}';
$string['progressbarteacherwarning2'] = 'Traka s prikazom napredovanja kroz lekciju Vam neće biti prikazana jer imate mogućnost uređivanja lekcije';
$string['progresscompleted'] = 'Dovršili ste {$a}% ove lekcije';
$string['qtype'] = 'Vrsta stranice';
$string['question'] = 'Pitanje';
$string['questionoption'] = 'Pitanje';
$string['questiontype'] = 'Vrsta pitanja';
$string['randombranch'] = 'Nasumičnim redom odabrana tablica grananja';
$string['randompageinbranch'] = 'Nasumičnim redom odabrano pitanje unutar grane';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Neobrađena ocjena';
$string['receivedcredit'] = 'Dobiveni bodovi';
$string['redisplaypage'] = 'Ponovno prikaži stranicu';
$string['report'] = 'Izvještaj';
$string['reports'] = 'Izvještaji';
$string['response'] = 'Povratna informacija';
$string['retakesallowed'] = 'Ponovni pregled lekcije je dopušten';
$string['retakesallowed_help'] = 'Ako je omogućeno, studenti će moći više puta pregledati lekciju.';
$string['returnto'] = 'Vrati se na {$a}';
$string['returntocourse'] = 'Vrati se na kolegij';
$string['review'] = 'Pregled';
$string['reviewlesson'] = 'Pregled lekcije';
$string['reviewquestionback'] = 'Da, želim pokušati ponovo';
$string['reviewquestioncontinue'] = 'Ne, želim preći na sljedeće pitanje';
$string['sanitycheckfailed'] = 'Provjera ispravnosti nije uspjela: Ovaj pokušaj je izbrisan';
$string['savechanges'] = 'Pohrani promjene';
$string['savechangesandeol'] = 'Pohrani sve promjene i idi na kraj lekcije.';
$string['savepage'] = 'Spremi stranicu';
$string['score'] = 'Rezultat';
$string['scores'] = 'Rezultati';
$string['secondpluswrong'] = 'Nije u potpunosti točno. Želite li pokušati ponovno?';
$string['selectaqtype'] = 'Odaberite vrstu pitanja';
$string['shortanswer'] = 'Kratki odgovor';
$string['showanunansweredpage'] = 'Prikaz stranice s neodgovorenim pitanjima';
$string['showanunseenpage'] = 'Prikaz nepregledane stranice';
$string['singleanswer'] = 'Jedan odgovor';
$string['skip'] = 'Preskoči navigaciju';
$string['slideshow'] = 'Slideshow';
$string['slideshowbgcolor'] = 'Pozadinska boja slideshow-a';
$string['slideshowheight'] = 'Visina slideshow-a';
$string['slideshow_help'] = 'Ako je omogućeno, lekcija će se prikazati kao slideshow s fiksnom visinom i širinom';
$string['slideshowwidth'] = 'Širina slideshow-a';
$string['startlesson'] = 'Pokreni lekciju';
$string['studentattemptlesson'] = 'Pokušaj: {$a->attempt} korisnika {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} Ime';
$string['studentoneminwarning'] = 'Upozorenje: imate manje od jedne minute da završite lekciju.';
$string['studentresponse'] = 'Odgovor studenta {$a}';
$string['submit'] = 'Predaj';
$string['submitname'] = 'Pošalji ime';
$string['teacherjumpwarning'] = 'U ovoj lekciji se koristi {$a->cluster} ili {$a->unseen} prijelaz između stranica. Prijelaz "Sljedeća stranica" će se koristiti u prikazu. Prijavite se u ulozi studenta ukoliko želite testirati prijelaze.';
$string['teacherongoingwarning'] = 'Prikaz trenutnog rezultata tijekom pregleda lekcije je omogućen samo studentima. Prijavite se u ulozi studenta da biste isprobali ovu mogućnost.';
$string['teachertimerwarning'] = 'Mjerenje vremena je omogućeno samo studentima. Prijavite se u ulozi studenta da biste isprobali ovu mogućnost.';
$string['thatsthecorrectanswer'] = 'Ispravan odgovor';
$string['thatsthewronganswer'] = 'Netočan odgovor';
$string['thefollowingpagesjumptothispage'] = 'Sljedeće stranice prelaze na ovu.';
$string['thispage'] = 'Ova stranica';
$string['timeremaining'] = 'Preostalo vrijeme';
$string['timespenterror'] = 'Provedite barem {$a} minuta u ovoj lekciji.';
$string['timespentminutes'] = 'Utrošeno vrijeme (u minutama)';
$string['timetaken'] = 'Utrošeno vrijeme';
$string['topscorestitle'] = '{$a} najboljih rezultata';
$string['truefalse'] = 'Točno/Netočno';
$string['unabledtosavefile'] = 'Nije moguće spremiti datoteku koju ste predali.';
$string['unknownqtypesnotimported'] = 'Pitanja s nepodržanim tipom pitanja koja nisu uvezena: {$a}';
$string['unseenpageinbranch'] = 'Još neprikazano pitanje unutar grane';
$string['unsupportedqtype'] = 'Tip pitanja nije podržan ({$a})!';
$string['updatedpage'] = 'Stranica je osvježena';
$string['updatefailed'] = 'Osvježavanje nije uspjelo';
$string['usemaximum'] = 'Koristi najveću vrijednost';
$string['usemean'] = 'Koristi prosječnu vrijednost';
$string['usepassword'] = 'Lekcija zaštićena lozinkom';
$string['usepassword_help'] = 'Ako je omogućeno, potrebno je upisati lozinku za pristup lekciji.';
$string['viewgrades'] = 'Prikaži ocjene';
$string['viewhighscores'] = 'Prikaži popis najboljih rezultata';
$string['viewreports'] = 'Pregled završenih pokušaja studenta {$a->student}: {$a->attempts}';
$string['viewreports2'] = 'Pregled završenih pokušaja: {$a->attempts}';
$string['welldone'] = 'Bravo!';
$string['whatdofirst'] = 'Što želite prvo napraviti?';
$string['wronganswerjump'] = 'Stranica koja će se prikazati nakon pogrešnog odgovora';
$string['wronganswerscore'] = 'Broj bodova koji nosi pogrešan odgovor';
$string['wrongresponse'] = 'Pogrešan odgovor';
$string['xattempts'] = '{$a} pokušaj(a)';
$string['youhaveseen'] = 'Već ste pregledali više od jedne stranice ove lekcije.<br /> Želite li početi od posljednje stranice koju ste pregledali?';
$string['youmadehighscore'] = 'Dospjeli ste na listu {$a} najboljih rezultata.';
$string['youranswer'] = 'Vaš odgovor';
$string['yourcurrentgradeis'] = 'Vasa trenutna ocjena je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša trenutna ocjena je {$a->grade} od mogućih {$a->total}';
$string['youshouldview'] = 'Trebali bi odgovoriti na barem: {$a}';
