<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Lokacija admin mape je netočna';
$string['admindirname'] = 'Admin mapa';
$string['admindirsetting'] = 'Manji broj webhosting tvrtki koristi /admin kao posebni URL za Vaš pristup upravljanju vašim hosting paketom. Nažalost, to rezultira konfliktom sa standardnom lokacijom za Moodle administratorsku stranicu. Navedenu lokaciju unutar Moodle sustava možete preimenovati. Na primjer: <br /> <br /><b>moodleadmin</b><br /> <br />
Ovo će promijeniti administratorsku poveznicu na Moodle sustavu u novu vrijednost.';
$string['admindirsettinghead'] = 'Podešavanje admin mape ...';
$string['admindirsettingsub'] = 'Manji broj webhosting tvrtki koristi /admin kao posebni URL za pristup upravljanju vašim hosting paketom. Nažalost, to rezultira konfliktom sa standardnom lokacijom za Moodle administratorsku stranicu. Navedenu lokaciju unutar Moodle sustava možete preimenovati. Na primjer: <br /> <br /><b>moodleadmin</b><br /> <br />
Ovo će promijeniti administratorsku poveznicu na Moodle sustavu u novu vrijednost.';
$string['availablelangs'] = 'Popis dostupnih jezika';
$string['caution'] = 'Oprez';
$string['chooselanguage'] = 'Odaberi jezik';
$string['chooselanguagehead'] = 'Odaberite jezik';
$string['chooselanguagesub'] = 'Molimo odaberite jezik instalacije. Ovaj jezik će biti korišten kao zadani jezik sustava, a kasnije to možete lagano promijeniti.';
$string['cliadminpassword'] = 'Nova lozinka za administratorski korisnički račun';
$string['cliadminusername'] = 'Korisničko ime za administratora';
$string['clialreadyconfigured'] = 'Datoteka config.php već postoji. Upotrijebite naredbu admin/cli/install_database.php ako želite nastaviti instalaciju.';
$string['clialreadyinstalled'] = 'Datoteka config.php već postoji. Upotrijebite naredbu admin/cli/upgrade.php ako želite nadograditi ovaj sustav.';
$string['cliinstallfinished'] = 'Instalacija je uspješno završena';
$string['cliinstallheader'] = 'Moodle {$a} program za instalaciju iz naredbenog retka';
$string['climustagreelicense'] = 'U neinteraktivnom modu morate prihvatiti licencu navodeći opciju --agree-license';
$string['clitablesexist'] = 'Baza podataka već postoji. Nije moguće nastaviti instalaciju iz naredbenog retka.';
$string['compatibilitysettings'] = 'Provjeravanje vaših PHP postavki ...';
$string['compatibilitysettingshead'] = 'Provjeravanje vaših PHP postavki ...';
$string['compatibilitysettingssub'] = 'Vaš poslužitelj bi trebao zadovoljiti sve ove uvjete kako bi Moodle uspješno radio';
$string['configfilenotwritten'] = 'Instalacijska skripta nije bila u mogućnosti automatski stvoriti datoteku naziva config.php koja bi sadržavala vaše odabrane postavke, vjerojatno zbog toga što nema prava na pisanje (mijenjanje sadržaja) u vašoj Moodle mapi. Ako to želite, možete ručno kopirati kod u datoteku config.php u osnovnoj mapi vaše Moodle instalacije.';
$string['configfilewritten'] = 'config.php je uspješno stvoren';
$string['configurationcomplete'] = 'Konfiguracija završena';
$string['configurationcompletehead'] = 'Konfiguracija završena';
$string['configurationcompletesub'] = 'Moodle je pokušao pohraniti vaše postavke u datoteku u osnovnoj mapi vaše Moodle instalacije.';
$string['database'] = 'Baza podataka';
$string['databasehead'] = 'Postavke baze podataka';
$string['databasehost'] = 'Poslužitelj baze podataka (HOST)';
$string['databasename'] = 'Naziv baze podataka';
$string['databasepass'] = 'Lozinka baze podataka';
$string['databasesocket'] = 'Unix socket';
$string['databasetypehead'] = 'Odaberite vrstu baze podataka';
$string['databasetypesub'] = 'Moodle podržava nekoliko vrsta baza podataka. Ako niste sigurni koju vrstu baze podataka trebate koristiti, kontaktirajte administratora vašeg poslužitelja.';
$string['databaseuser'] = 'Korisničko ime za bazu podataka';
$string['dataroot'] = 'Mapa s podacima';
$string['datarooterror'] = '\'Mapu s podacima\' koju ste zadali nije moguće pronaći ili stvoriti. Unesite točnu putanju ili ručno stvorite navedenu mapu.';
$string['datarootpermission'] = 'Ovlasti nad mapom s podacima';
$string['datarootpublicerror'] = '\'Mapa s podacima\' koju ste zadali je izravno dostupna putem weba, morate zadati drugu mapu.';
$string['dbconnectionerror'] = 'Nemoguće je uspostaviti vezu sa bazom podataka koju ste naveli. Molimo provjerite podatke koje ste unijeli.';
$string['dbcreationerror'] = 'Pogreška pri stvaranju baze podataka. Nije bilo moguće stvoriti bazu navedenog imena uz zadane postavke';
$string['dbhost'] = 'Poslužitelj';
$string['dbpass'] = 'Lozinka';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Prefiks tablice';
$string['dbtype'] = 'Vrsta';
$string['directorysettings'] = '<p>Molimo potvrdite lokacije ove Moodle instalacije</p>

<p><b>Web adresa:</b> Unesite punu web adresu putem koje će se pristupati vašem Moodle sustavu. Ako je vašem web poslužitelju moguće pristupiti preko više URL-ova, odaberite onaj koji vam najviše odgovara. Nemojte navoditi krajnju kosu crtu.</p>

<p><b>Moodle mapa:</b> Unesite potpunu putanju do ove instalacije. Vodite računa o velikim i malim slovima.</p>

<p><b>Mapa s podacima:</b> Morate odrediti lokaciju na kojoj će Moodle čuvati upload datoteke. Korisnik pod kojim je pokrenut web server (obično \'nobody\' ili \'apache\') bi morao imati mogućnost čitanja/pisanja podataka u toj mapi, ali oni ne bi trebali biti dostupni direktno preko weba. Instalacijska skripta će pokušati stvoriti navedenu mapu ako ista ne postoji.</p>';
$string['directorysettingshead'] = 'Molimo potvrdite lokacije ove Moodle instalacije';
$string['directorysettingssub'] = '<b>Web adresa:</b> Unesite punu web adresu putem koje će se pristupati vašem Moodle sustavu. Ako je vašem web poslužitelju moguće pristupiti preko više URL-ova, odaberite onaj koji vam najviše odgovara. Nemojte navoditi krajnju kosu crtu.
<br/>
<br/>
<b>Moodle mapa:</b>
Unesite potpunu putanju do ove instalacije. Vodite računa o velikim i malim slovima.
<br/>
<br/>
<b>Mapa s podacima:</b>
Morate odrediti lokaciju na kojoj će Moodle čuvati postavljene datoteke. Korisnik pod kojim je pokrenut web server (obično \'nobody\' ili \'apache\') bi morao imati mogućnost čitanja/pisanja podataka u toj mapi, ali oni ne bi trebali biti dostupni direktno preko weba. Instalacijska skripta će pokušati stvoriti navedenu mapu ako ista ne postoji.';
$string['dirroot'] = 'Moodle mapa';
$string['dirrooterror'] = 'Postavka \'Moodle mapa\' je izgleda netočna - na navedenoj lokaciji nije moguće pronaći Moodle instalaciju. Unešena vrijednost je uklonjena.';
$string['download'] = 'Preuzimanje';
$string['downloadlanguagebutton'] = 'Preuzmite jezični paket &quot;{$a}&quot; ';
$string['downloadlanguagehead'] = 'Preuzmi jezični paket';
$string['downloadlanguagenotneeded'] = 'Možete nastaviti proces instalacije korištenjem zadanog jezičnog paketa, "{$a}".';
$string['downloadlanguagesub'] = 'Imate mogućnost preuzimanja željenog jezičnog paketa i nastavka instalacije na tom jeziku.<br/><br/>Ako niste u mogućnosti preuzeti željeni jezični paket, instalacijski proces će se nastaviti na engleskom jeziku. (Kada se instalacija uspješno završi, moći ćete preuzeti i instalirati dodatne jezične pakete.)';
$string['doyouagree'] = 'Slažete li se? (da/ne)';
$string['environmenthead'] = 'Provjera okruženja vašeg poslužitelja ...';
$string['environmentsub'] = 'Provjeravamo zadovoljavaju li razne komponente vašeg sustava minimalne zahtjeve';
$string['environmentsub2'] = 'Svaka inačica Moodle-a ima minimalne zahtjeve po pitanju odgovarajuće PHP inačice i nekoliko obveznih PHP ekstenzija.
Puna provjera okruženja se obavlja prije svake instalacije ili nadogradnje postojeće inačice. Ako ne znate kako instalirati novu inačicu ili omogućiti PHP ekstenzije, kontaktirajte administratora vašeg poslužitelja.';
$string['errorsinenvironment'] = 'Pogreške u okruženju poslužitelja!';
$string['fail'] = 'Nije prošlo';
$string['fileuploads'] = 'Postavljanje datoteka na poslužitelj';
$string['fileuploadserror'] = 'Ova opcija bi trebala biti uključena';
$string['fileuploadshelp'] = '<p>Postavljanje datoteka (upload) je izgleda nedostupno na vašem poslužitelju.</p>

<p>Moodle još uvek može biti instaliran, ali bez ove mogućnosti, nećete biti u mogućnosti postavljati datoteke kolegija ili nove slike za korisničke profile.</p>

<p>Kako bi učitavanje datoteka postalo dostupno, vi (ili vaš sistem administrator) trebate promijeniti php.ini datoteku na vašem sustavu i podesiti postavku <b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Mapa s podacima :';
$string['inputwebadress'] = 'Web adresa :';
$string['inputwebdirectory'] = 'Moodle mapa :';
$string['installation'] = 'Instalacija';
$string['langdownloaderror'] = 'Nažalost, jezik "{$a}" nije instaliran. Proces instalacije će biti nastavljen na engleskom jeziku.';
$string['langdownloadok'] = 'Jezik "{$a}" je uspješno instaliran. Proces instalacije će biti nastavljen na ovom jeziku.';
$string['magicquotesruntime'] = 'Magic Quotes Run Time';
$string['magicquotesruntimeerror'] = 'Ova opcija bi trebala biti isključena';
$string['magicquotesruntimehelp'] = '<p>Magic Quotes runtime bi trebalo isključiti kako bi Moodle mogao uspješno raditi.</p>

<p>Zadana vrijednost je isključeno... pogledajte postavku <b>magic_quotes_runtime</b> u php.ini datoteci.</p>

<p>Ako nemate pristup php.ini datoteci, pokušajte staviti slijedeći red u datoteku pod nazivom .htaccess u Moodle mapi: <blocquote>php_value magic_quotes_runtime Off</blockquote>';
$string['memorylimit'] = 'Ograničenje memorije';
$string['memorylimiterror'] = 'PHP ograničenje memorije je podešeno na prilično nisku vrijednost ... kasnije može doći do problema.';
$string['memorylimithelp'] = '<p>PHP ograničenje memorije na poslužitelju je trenutno podešeno na {$a}.</p>

<p>Ova postavka može kasnije rezultirati memorijskim problemima na vašem Moodle sustavu, posebno ako imate veći broj omogućenih modula i/ili veći broj korisnika.</p>

<p>Preporučujemo da konfigurirate PHP s većim ograničenjem ako je moguće, recimo 40M. Postoji nekoliko načina na koje to možete napraviti:</p>
<ol>
<li>Ako možete, rekompajlirajte PHP s <i>--enable-memory-limit</i>. Ovo će dopustiti Moodle sustavu samostalno postavljanje memorijskog ograničenja.</li>
<li>Ako imate pristup php.ini datoteci, možete promijeniti <b>memory_limit</b> vrijednost na 40M. Ako nemate pristup toj datoteci možete pitati svog administratora da to uradi.</li>
<li>Na nekim PHP poslužiteljima možete napraviti .htaccess datoteku u Moodle mapi koja sadrži red: <p><blockquote>php_value memory_limit 40M</blockquote></p>
<p>Uzmite u obzir da će na nekim poslužiteljima to spriječiti prikazivanje <b>svih</b> PHP stranica (bit će vam prikazana poruka o grešci), pa ćete na takvim poslužiteljima morati ukloniti .htaccess datoteku.</p></li> </ol>';
$string['mssqlextensionisnotpresentinphp'] = 'MSSQL ekstenzija PHP-a nije ispravno podešena (što je preduvjet za komunikaciju s SQL*Serverom). Molimo provjerite vašu php.ini datoteku ili rekompajlirajte PHP. ';
$string['mysqliextensionisnotpresentinphp'] = 'MySQLi ekstenzija PHP-a nije ispravno podešena (što je preduvjet za komunikaciju s MySQL-om). Molimo provjerite vašu php.ini datoteku ili rekompajlirajte PHP. MySQLi nije dostupan za PHP4.';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Trebate unijeti postavke baze podataka u koju će Moodle ubuduću pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup istoj moraju biti prethodno stvoreni. Prefiks tablice je obvezni.';
$string['nativemysqli'] = 'Unaprijeđeni MySQL (native/mysqli)';
$string['nativemysqlihelp'] = 'Trebate unijeti postavke baze podataka u koju će Moodle ubuduću pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup istoj moraju biti prethodno stvoreni. Prefiks tablice je opcinalan.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Trebate unijeti postavke baze podataka u koju će Moodle ubuduću pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup istoj moraju biti prethodno stvoreni. Prefiks tablice je obvezni.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Trebate unijeti postavke baze podataka u koju će Moodle ubuduću pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup istoj moraju biti prethodno stvoreni. Prefiks tablice je obvezni.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Trebate unijeti postavke baze podataka u koju će Moodle ubuduću pohranjivati većinu podataka. Ova baza podataka, kao i korisničko ime i lozinka za pristup istoj moraju biti prethodno stvoreni. Prefiks tablice je obvezni.';
$string['nativesqlsrvnodriver'] = 'Microsoft Drivers for SQL Server for PHP nisu instalirani ili nisu ispravno podešeni.';
$string['nativesqlsrvnonwindows'] = 'Microsoft Drivers for SQL Server for PHP su dostupni samo za Windows OS.';
$string['ociextensionisnotpresentinphp'] = 'OCI8 ekstenzija PHP-a nije ispravno podešena (što je preduvjet za komunikaciju s Oracle-om). Molimo provjerite vašu php.ini datoteku ili rekompajlirajte PHP.';
$string['pass'] = 'Prošlo';
$string['paths'] = 'Putanje (PATH)';
$string['pathserrcreatedataroot'] = 'Instalacijska skripta ne može stvoriti \'Mapu s podacima\' ({$a->dataroot}).';
$string['pathshead'] = 'Potvrdi putanje (PATH)';
$string['pathsrodataroot'] = 'Nije moguće zapisivanje u podatkovnu (dataroot) mapu.';
$string['pathsroparentdataroot'] = 'Nije moguće zapisivati podatke u nadređenu mapu ({$a->parent}). Instalacijska skripta ne može stvoriti mapu za podatke ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Manji broj webhosting tvrtki koristi /admin kao posebni URL za Vaš pristup upravljanju vašim hosting paketom. Nažalost, to rezultira konfliktom sa standardnom lokacijom za Moodle administratorsku stranicu. Navedenu lokaciju unutar Moodle sustava možete preimenovati. Na primjer: <br /> <br /><em>moodleadmin</em><br /> <br />
Ovo će promijeniti administratorsku poveznicu na Moodle sustavu u novu vrijednost.';
$string['pathssubdataroot'] = 'Mora postojati mapa u koju Moodle može pohraniti prenešene datoteke. Korisnik pod kojim je pokrenut web server (obično \'nobody\' ili \'apache\') bi morao imati mogućnost čitanja/pisanja podataka u toj mapi, ali oni ne bi trebali biti dostupni direktno preko weba. Instalacijska skripta će pokušati stvoriti navedenu mapu ako ista ne postoji.';
$string['pathssubdirroot'] = 'Puna putanja (PATH) do Moodle instalacije.';
$string['pathssubwwwroot'] = 'Unesite punu web adresu putem koje će se pristupati vašem Moodle sustavu.
Moodle sustavu NIJE MOGUĆE pristupiti preko više URL-ova, odaberite onaj koji vam najviše odgovara.
Ako vaš poslužitelj ima višestruke javne adrese, onda morate postaviti tzv. permanent redirect na sve osim ove adrese.
Ako je vaš poslužitelj dostupan i putem intraneta i Interneta, onda ovdje unesite javnu adresu i podesite DNS tako da vaši intranet korisnici mogu koristiti tu javnu adresu.
Ako adresa nije točna, molimo unesite točnu adresu u vaš internet preglednik i ponovno pokrenite instalaciju s promijenjenim vrijednostima.';
$string['pathsunsecuredataroot'] = 'Podatkovna (dataroot) mapa nije sigurna';
$string['pathswrongadmindir'] = 'Admin mapa ne postoji';
$string['pgsqlextensionisnotpresentinphp'] = 'PGSQL ekstenzija PHP-a nije ispravno podešena (što je preduvjet za komunikaciju s PostreSQL-om). Molimo provjerite vašu php.ini datoteku ili rekompajlirajte PHP.';
$string['phpextension'] = 'PHP ekstenzija {$a}';
$string['phpversion'] = 'PHP inačica';
$string['phpversionhelp'] = '<p>Moodle zahtijeva najmanje PHP inačicu 4.3.0 ili 5.1.0 (5.0.x funkcionira uz brojne uočene probleme).</p> <p>Trenutno imate inačicu {$a}</p> <p>Morate nadograditi PHP ili premestiti Moodle instalaciju na web poslužitelj s novijom inačicom PHP-a!</br> (U slučaju inačice 5.0.x bilo bi najbolje da je vratite na inačicu 4.4.x)</p>';
$string['releasenoteslink'] = 'Za više informaciji o ovoj inačici Moodlea, pogledajte <em>Release Notes</em> na {$a}';
$string['safemode'] = 'Sigurni način rada (Safe mode)';
$string['safemodeerror'] = 'Moodle može imati problema ako je pokrenut sigurni način rada';
$string['safemodehelp'] = '<p>Moodle se može suočiti s nizom problema kada je uključen sigurni način rada (SAFE MODE). Jedan od tih problema može biti nemogućnost stvaranja novih datoteka.</p>

<p>Sigurni način rada je obično omogućen na paranoidno održavanim javnim web poslužiteljima, pa je jedno od rješenja premještanje vašeg Moodle sustava na poslužitelj neke druge tvrtke.</p>

<p>Možete pokušati nastaviti instalaciju ako želite, no očekujte probleme pri korištenju i radu.</p>';
$string['sessionautostart'] = 'Automatski start sesije (Session Auto Start)';
$string['sessionautostarterror'] = 'Ova opcija bi trebala biti isključena';
$string['sessionautostarthelp'] = '<p>Moodle zahtijeva podršku za sesije i neće funcionirati bez iste.</p> <p>Rad sa sesijama možete omogućiti u datoteci php.ini ... potražite parametar session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'SQLite ekstenzija PHP-a nije ispravno podešena. Molimo provjerite vašu php.ini datoteku ili rekompajlirajte PHP.';
$string['upgradingqtypeplugin'] = 'Nadogradnja dodatka za pitanja';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Prikazana vam je ova stranica jer ste uspješno instalirali i pokrenuli <strong>{$a->packname} {$a->packversion}</strong> paket na svom poslužitelju. Čestitamo!';
$string['welcomep30'] = 'Ova inačica <strong>{$a->installername}</strong> uključuje aplikacije za stvaranje okruženja u kojem će sustav <strong>Moodle</strong> uspješno funkcionirati, konkretno:';
$string['welcomep40'] = 'Ovaj paket obuhvaća i <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Korištenje svih aplikacija u ovom paketu je uređeno licencama pod kojima su izdane. Cijeli paket <strong>{$a->installername}</strong> je rješenje <a href="http://www.opensource.org/docs/definition_plain.html">otvorenog koda</a> distribuirano pod <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> licencom.';
$string['welcomep60'] = 'Sljedeće stranice će vas voditi kroz postupak instalacije i podešavanja sustava <em>Moodle</em> na poslužitelju. Možete prihvatiti zadane postavke ili promijeniti iste sukladno vašim potrebama.';
$string['welcomep70'] = 'Kliknite na "Next" gumb kako bi započeli <strong>Moodle</strong> instalaciju.';
$string['wwwroot'] = 'Web adresa';
$string['wwwrooterror'] = 'Vrijednost \'Web adresa\' izgleda nije valjana - Moodle instalacija nije smještena na toj lokaciji. Vrijednost je vraćena na izvorne postavke.';
