<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Forum sadrži nove poruke';
$string['addanewdiscussion'] = 'Dodaj novu raspravu';
$string['addanewquestion'] = 'Dodajte novo pitanje';
$string['addanewtopic'] = 'Dodajte novu temu';
$string['advancedsearch'] = 'Napredno pretraživanje';
$string['allforums'] = 'Svi forumi';
$string['allowdiscussions'] = 'Može li {$a} dodavati poruke u ovom forumu?';
$string['allowsallsubscribe'] = 'Ovaj forum omogućava svima da odaberu žele li biti pretplaćeni.';
$string['allowsdiscussions'] = 'Ovaj forum omogućava svakome da započne jednu raspravu. ';
$string['allsubscribe'] = 'Pretplatite se na sve forume. ';
$string['allunsubscribe'] = 'Odjavite se sa svih foruma. ';
$string['alreadyfirstpost'] = 'Ovo već jest prva poruka u raspravi.';
$string['anyfile'] = 'Bilo koja datoteka';
$string['areaattachment'] = 'Prilozi';
$string['areapost'] = 'Poruke';
$string['attachment'] = 'Prilog';
$string['attachment_help'] = 'Poruci možete priložiti jednu ili više datoteka. Ako priložite sliku, bit će prikazana nakon poruke. ';
$string['attachmentnopost'] = 'Ne možete izvesti priloge bez id-a poruke.';
$string['attachments'] = 'Prilozi';
$string['attachmentswordcount'] = 'Prilozi i brojač riječi';
$string['blockafter'] = 'Granični broj poruka za blokiranje';
$string['blockafter_help'] = '<p>Ova postavka definira najveći broj poruka koje student može objaviti u određenom vremenskom periodu. </p>
<p>Ograničenje broja poruka ne vrijedi za korisnike s ovlastima mod/forum:postwithoutthrottling (npr. nastavnici).</p>';
$string['blockperiod'] = 'Vremensko razdoblje nakon kojeg slijedi blokiranje';
$string['blockperioddisabled'] = 'Ne blokirati';
$string['blockperiod_help'] = '<p>Moguće je ograničiti broj poruka koje studenti mogu objaviti unutar nekog vremenskog razdoblja. </p>
<p>Ograničenje broja poruka ne vrijedi za korisnike s ovlastima mod/forum:postwithoutthrottling (npr. nastavnici). </p>';
$string['blogforum'] = 'Forum u obliku zajedničkog bloga';
$string['bynameondate'] = 'napisao/la {$a->name} - {$a->date}';
$string['cannotadd'] = 'Nije moguće dodati raspravu u ovom forumu';
$string['cannotadddiscussion'] = 'Za dodavanje rasprave u ovaj forum treba biti član grupe.';
$string['cannotadddiscussionall'] = 'Nemate ovlasti da biste dodali novu raspravu za sve sudionike. ';
$string['cannotaddsubscriber'] = 'Nije moguće dodati pretplatnika s id brojem {$a} ovom forumu!';
$string['cannotaddteacherforumto'] = 'Nije moguće dodati instancu promijenjenog nastavničkog foruma u sekciju 0 na ovom kolegiju';
$string['cannotcreatediscussion'] = 'Nije moguće otvoriti novu raspravu';
$string['cannotcreateinstanceforteacher'] = 'Nije moguće stvoriti novu instancu nastavničkog foruma na razini kolegija';
$string['cannotdeletepost'] = 'Nije moguće izbrisati ovu poruku!';
$string['cannoteditposts'] = 'Nije moguće uređivati poruke drugih sudionika!';
$string['cannotfinddiscussion'] = 'Rasprava nije pronađena u ovom forumu.';
$string['cannotfindfirstpost'] = 'Nije pronađena prva poruka u ovom forumu. ';
$string['cannotfindorcreateforum'] = 'Nije moguće pronaći ili stvoriti glavni forum s obavijestima na razini poslužitelja';
$string['cannotfindparentpost'] = 'Nije pronađena nadređena poruka poruci broj {$a}';
$string['cannotmovefromsingleforum'] = 'Nije moguće premjestiti raspravu iz foruma tipa "Samo jedna rasprava"';
$string['cannotmovenotvisible'] = 'Forum nije vidljiv';
$string['cannotmovetonotexist'] = 'Nije moguće premjestiti u taj forum jer on ne postoji!';
$string['cannotmovetonotfound'] = 'Traženi forum nije pronađen u ovom kolegiju. ';
$string['cannotmovetosingleforum'] = 'Nije moguće premjestiti raspravu u forum oblika "Samo jedna rasprava"';
$string['cannotremovesubscriber'] = 'Nije moguće ukloniti pretplatnika id-a {$a} s ovog foruma!';
$string['cannotreply'] = 'Nije moguće odgovoriti na ovu poruku ';
$string['cannotsplit'] = 'Rasprave u ovom forumu nije moguće razdijeliti';
$string['cannotsubscribe'] = 'Morate biti član grupe da biste se pretplatili. ';
$string['cannottrack'] = 'Nije moguće prestati pratiti ovaj forum. ';
$string['cannotunsubscribe'] = 'Nije se moguće odjaviti s ovog foruma';
$string['cannotupdatepost'] = 'Nije moguće nadograditi ovu poruku';
$string['cannotviewpostyet'] = 'Ne možete pročitati pitanja drugih studenata u ovoj raspravi prije nego što objavite poruku. ';
$string['cannotviewusersposts'] = 'Nema poruka koje je napisao ovaj korisnik, a koje možete pročitati.';
$string['cleanreadtime'] = 'Kada će stare poruke biti označene kao pročitane?';
$string['completiondiscussions'] = 'Student mora pokrenuti rasprave:';
$string['completiondiscussionsgroup'] = 'Obvezno pokretanje rasprave';
$string['completiondiscussionshelp'] = 'Potrebno pokretanje rasprave za dovršavanje aktivnosti';
$string['completionposts'] = 'Student mora objaviti poruku ili odgovor';
$string['completionpostsgroup'] = 'Obvezna objava poruke';
$string['completionpostshelp'] = 'Potrebna objava poruke ili odgovora za dovršavanje aktivnosti';
$string['completionreplies'] = 'Student mora objaviti odgovore:';
$string['completionrepliesgroup'] = 'Obavezan odgovor na poruku';
$string['completionreplieshelp'] = 'Potreban odgovor na poruku za dovršavanje aktivnosti';
$string['configcleanreadtime'] = 'Sat u danu kada se uklanjanju stare poruke iz tablice \'pročitano\'.';
$string['configdigestmailtime'] = 'Korisnici koji odaberu digest oblik slanja poruka e-poštom, dobivat će iste na dnevnoj bazi. Ova postavka zadaje vrijeme dana kada će navedena poruka biti poslana (prvi sljedeći cron koji se pokrene nakon zadanog vremena će ih poslati).';
$string['configdisplaymode'] = 'Zadani način prikaza rasprava, ako nije naknadno podešeno.';
$string['configenablerssfeeds'] = 'Ova postavka omogućuje stvaranje RSS kanala za sve forume. No i dalje ćete morati ručno uključiti kanale u postavkama svakog od foruma.';
$string['configenabletimedposts'] = 'Odaberite \'da\' ako želite postaviti podešavanje razdoblja prikazivanja poruke prilikom započinjanja nove rasprave na forumu. (Eksperimentalno, nije još uvijek u potpunosti isprobano.)';
$string['configlongpost'] = 'Bilo koja poruka veća od ove vrijednosti (ne uključujući HTML oblikovanje) smatra se predugačkom.';
$string['configmanydiscussions'] = 'Najveći broj rasprava na forumu prikazanih na stranici.';
$string['configmaxattachments'] = 'Zadani najveći broj priloga dopušten po jednoj poruci.';
$string['configmaxbytes'] = 'Najveća zadana veličina svih priloga u forumu na sjedištu (ovisno o ograničenjima kolegija i drugim lokalnim postavkama)';
$string['configoldpostdays'] = 'Starost poruke (u danima) koja se smatra pročitanom. ';
$string['configreplytouser'] = 'Hoće li poruka s foruma, kada se šalje elektronskom poštom, sadržavati adresu autora poruke, kako bi primatelj poruke mogao odgovoriti i privatnom porukom, a ne samo preko foruma? Čak i kada je ova opcija podešena na "Da", korisnici u svom profilu mogu podesiti da njihova adresa e-pošte bude skrivena. ';
$string['configshortpost'] = 'Svaka poruka koje ima manje znakova (ne uključujući HTML kod) smatra se kratkom (vidi ispod).';
$string['configtrackreadposts'] = 'Odaberite "da" ako želite pratiti pročitane/nepročitane poruke za svakog korisnika.';
$string['configusermarksread'] = 'Ako je odabrana opcija "da" korisnik mora ručno označiti poruku kao pročitanu. Ako je odabrana opcija "ne", poruka je po otvaranju označena kao pročitana.';
$string['confirmsubscribe'] = 'Želite li se pretplatiti na forum \'{$a}\'?';
$string['confirmunsubscribe'] = 'Želite li se ispisati s foruma \'{$a}\'?';
$string['couldnotadd'] = 'Nažalost, nije moguće dodati vašu poruku zbog nepoznate pogreške';
$string['couldnotdeletereplies'] = 'Nije moguće izbrisati jer je na poruku već odgovoreno';
$string['couldnotupdate'] = 'Sustav nije mogao promijeniti sadržaj vaše poruke zbog nepoznate pogreške';
$string['delete'] = 'Izbriši';
$string['deleteddiscussion'] = 'Ova rasprava je obrisana';
$string['deletedpost'] = 'Poruka je obrisana';
$string['deletedposts'] = 'Navedene poruke su obrisane';
$string['deletesure'] = 'Želite li izbrisati ovu poruku?';
$string['deletesureplural'] = 'Želite li izbrisati ovu poruku i SVE odgovore? ({$a} poruka)';
$string['digestmailheader'] = 'Ovo je dnevni sažetak novih poruka s foruma {$a->sitename}. Postavke prosljeđivanja poruka s foruma promijenite na {$a->userprefs}.';
$string['digestmailprefs'] = 'vaši osobni podaci';
$string['digestmailsubject'] = '{$a}: sažetak foruma';
$string['digestmailtime'] = 'Vrijeme za slanje poruka e-pošte sa skraćenim izveštajima';
$string['digestsentusers'] = 'Sažetak je uspješno poslan korisnicima e-poštom. Broj korisnika: {$a}';
$string['disallowsubscribe'] = 'Pretplaćivanje nije dopušteno';
$string['disallowsubscribeteacher'] = 'Pretplaćivanje nije dopušteno (osim za nastavnike)';
$string['discussion'] = 'Rasprava';
$string['discussionmoved'] = 'Ova rasprava je premještena u \'{$a}\'.';
$string['discussionmovedpost'] = 'Ova rasprava je premještena <a href="{$a->discusshref}">ovdje</a>, u forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Naziv rasprave';
$string['discussions'] = 'Rasprave';
$string['discussionsstartedby'] = 'Raspravu započeo/la {$a}';
$string['discussionsstartedbyrecent'] = 'Nedavno započete rasprave od strane korisnika {$a}';
$string['discussionsstartedbyuserincourse'] = 'Rasprave započete od strane {$a->fullname} na kolegiju {$a->coursename}';
$string['discussthistopic'] = 'Rasprava o ovoj temi';
$string['displayend'] = 'Kraj prikazivanja';
$string['displayend_help'] = '<p>Ovom se postavkom definira hoće li poruka u forumu u nekom razdoblju biti skrivena. </p>
<p> Napomena: Administratori uvijek mogu vidjeti poruke u forumu. >/p> ';
$string['displaymode'] = 'Način prikaza';
$string['displayperiod'] = 'Vrijeme prikazivanja';
$string['displaystart'] = 'Početak prikazivanja';
$string['displaystart_help'] = 'Ovom postavkom definirate treba li poruka na forumu biti prikazana od određenog datuma. Imajte na umu da će korisnici s administratorskim pristupom poruke moći vidjeti bez obzira na vremensko ograničenje. ';
$string['displaywordcount'] = 'Prikaži broj riječi';
$string['displaywordcount_help'] = 'Ova postavka određuje hoće li biti prikazan brojač riječi uz svaku poruku na forumu.';
$string['eachuserforum'] = 'Svaki korisnik može započeti samo jednu raspravu';
$string['edit'] = 'Promijeni';
$string['editedby'] = 'Uredio/la  {$a->name} - izvorno objavljeno {$a->date}';
$string['editedpostupdated'] = 'Post korisnika {$a} je nadograđen';
$string['editing'] = 'Mijenjanje';
$string['emaildigestdefault'] = 'Zadano ({$a})';
$string['emptymessage'] = 'Postojali su određeni problemi vezani uz vašu poruku. Moguće je da ste pokušali poslati praznu poruku ili je možda prilog (attachment) bio prevelik (odnosno veličine koja nije dopuštena na ovom forumu). Vaše promjene stoga nisu pohranjene.';
$string['erroremptymessage'] = 'Tijelo poruke ne može biti prazno';
$string['erroremptysubject'] = 'Naslov poruke ne može biti prazan';
$string['errorenrolmentrequired'] = 'Morate biti upisani na ovaj kolegij kako biste pristupili ovom sadržaju';
$string['errorwhiledelete'] = 'Tijekom brisanja zapisa došlo je do pogreške.';
$string['everyonecanchoose'] = 'Korisnici mogu odabrati žele li biti pretplaćeni na ovaj forum';
$string['everyonecannowchoose'] = 'Korisnici sada mogu odabrati žele li biti pretplaćeni na ovaj forum';
$string['everyoneisnowsubscribed'] = 'Sada su svi korisnici pretplaćeni na ovaj forum.';
$string['everyoneissubscribed'] = 'Svi korisnici su pretplaćeni na ovaj forum';
$string['existingsubscribers'] = 'Postojeći pretplatnici';
$string['exportdiscussion'] = 'Izvezi cijelu raspravu u portfolio';
$string['forcessubscribe'] = 'Pretplata na ovaj forum obvezna je za sve korisnike';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Dodavanje novog foruma';
$string['forum:addnews'] = 'Dodaj obavijest';
$string['forum:addquestion'] = 'Dodaj pitanje';
$string['forum:allowforcesubscribe'] = 'Dopusti obvezno pretplaćivanje';
$string['forumauthorhidden'] = 'Autor (skriveni)';
$string['forumblockingalmosttoomanyposts'] = 'Približavate se najvećem mogućem broju poruka u ovom forumu.
Objavili ste {$a->numposts} poruka u posljednjih {$a->blockperiod}, a ograničenje je {$a->blockafter} poruka.';
$string['forumbodyhidden'] = 'Ne možete vidjeti ovu poruku, vjerojatno jer još niste objavili nijednu poruku u ovoj raspravi, još nije prošlo maksimalno vrijeme uređivanja, rasprava nije započela ili je već završila.';
$string['forum:createattachment'] = 'Stvori prilog (attachment)';
$string['forum:deleteanypost'] = 'Izbriši sve poruke (u bilo koje vrijeme)';
$string['forum:deleteownpost'] = 'Brisanje vlastitih poruka (u zadanom roku)';
$string['forum:editanypost'] = 'Uređivanje bilo koje poruke';
$string['forum:exportdiscussion'] = 'Izvoz cijele rasprave';
$string['forum:exportownpost'] = 'Izvoz vlastite poruke';
$string['forum:exportpost'] = 'Izvoz poruke';
$string['forumintro'] = 'Opis foruma';
$string['forum:managesubscriptions'] = 'Uređivanje pretplata';
$string['forum:movediscussions'] = 'Premještanje diskusija';
$string['forumname'] = 'Naziv foruma';
$string['forumposts'] = 'Poruke na forumu';
$string['forum:postwithoutthrottling'] = 'Ograničenje broja poruka nije primjenjivo';
$string['forum:rate'] = 'Ocijeni poruke';
$string['forum:replynews'] = 'Odgovoranje na obavijest';
$string['forum:replypost'] = 'Odgovaranje na poruke';
$string['forums'] = 'Forumi';
$string['forum:splitdiscussions'] = 'Razdvajanje rasprava';
$string['forum:startdiscussion'] = 'Započni nove rasprave';
$string['forumsubjecthidden'] = 'Tema (skriveno)';
$string['forumtracked'] = 'Nepročitane poruke se prate';
$string['forumtrackednot'] = 'Nepročitane poruke se ne prate';
$string['forumtype'] = 'Vrsta foruma';
$string['forumtype_help'] = 'Postoji 5 vrsta foruma:

* Samo jedna rasprava - Forum u obliku jedne rasprave u koju svi mogu slati odgovore (ne može biti korišten s odvojenim grupama)
* Jedna rasprava po korisniku - Svaki student može pokrenuti samo jednu novu raspravu, na koju svi mogu odgovarati
* Oblik pitanja i odgovora - Studenti moraju objaviti vlastite odgovore prije nego što mogu pročitati poruke drugih
* Forum u obliku zajedničkog bloga - Otvoreni forum u kojem bilo tko u bilo kojem trenutku može započeti novu raspravu te u kojem su rasprave prikazane na jednoj stranici s poveznicama "Raspravljajte o ovoj temi"
* Opći forum - Otvoreni forum u kojem bilo tko može započeti novu raspravu u bilo kojem trenutku';
$string['forum:viewallratings'] = 'Pregled svih neobrađenih ocjena danih od strane individualaca';
$string['forum:viewanyrating'] = 'Pregled svih ocjena koje je netko dobio';
$string['forum:viewdiscussion'] = 'Pregled rasprava';
$string['forum:viewhiddentimedposts'] = 'Pregled skrivenih, vremenski ograničenih poruka';
$string['forum:viewqandawithoutposting'] = 'Uvijek može vidjeti poruke s često postavljanim pitanjima';
$string['forum:viewrating'] = 'Pregled vlastitih dobivenih ocjena ';
$string['forum:viewsubscribers'] = 'Prikaz pretplatnika';
$string['generalforum'] = 'Opći forum';
$string['generalforums'] = 'Opći forumi';
$string['inforum'] = 'u {$a}';
$string['introblog'] = 'Poruke u ovom forumu su u njega automatski prenesene iz blogova korisnika ovog tečaja, jer na njihovim blogovima ove objave više nisu dostupne';
$string['intronews'] = 'Opće obavijesti i najave';
$string['introsocial'] = 'Otvoreni forum za razgovor o bilo kojoj temi';
$string['introteacher'] = 'Forum rezerviran za bilješke i rasprave nastavnika';
$string['invalidaccess'] = 'Ovoj stranici nije ispravno pristupljeno';
$string['invaliddiscussionid'] = 'ID rasprave nije točan ili više ne postoji';
$string['invalidforcesubscribe'] = 'Neispravan način obvezne pretplate';
$string['invalidforumid'] = 'ID foruma nije točan';
$string['invalidparentpostid'] = 'ID nadređene poruke je neispravan';
$string['invalidpostid'] = 'Neispravan ID poruke';
$string['lastpost'] = 'Zadnja poruka';
$string['learningforums'] = 'Obrazovni forumi';
$string['longpost'] = 'Dugačka poruka';
$string['mailnow'] = 'Pošalji ODMAH  e-poštom';
$string['manydiscussions'] = 'Broj rasprava po stranici';
$string['markalldread'] = 'Označi sve poruke u ovoj raspravi kao pročitane';
$string['markallread'] = 'Označi sve poruke u ovom forumu kao pročitane.';
$string['markread'] = 'Označi kao pročitano';
$string['markreadbutton'] = 'Označi kao<br /> pročitano';
$string['markunread'] = 'Označi kao nepročitano';
$string['markunreadbutton'] = 'Označi kao<br /> nepročitano';
$string['maxattachments'] = 'Najveći dopušteni broj priloga';
$string['maxattachments_help'] = 'Ova postavka definira najveći dopušteni broj datoteka koje je moguće priložiti poruci u forumu.';
$string['maxattachmentsize'] = 'Maksimalna veličina priloga (attachment)';
$string['maxattachmentsize_help'] = 'Ova postavka definira maksimalnu veličinu datoteke koju je moguće priložiti poruci u forumu.';
$string['maxtimehaspassed'] = 'Nažalost, dopušteno vrijeme za uređivanje ove poruke ({$a}) je isteklo!';
$string['message'] = 'Poruka';
$string['messageprovider:digests'] = 'Sažeci foruma na koje ste pretplaćeni';
$string['messageprovider:posts'] = 'Poruke s foruma na koje ste pretplaćeni';
$string['missingsearchterms'] = 'Sljedeći traženi pojmovi se pojavljuju samo u HTML kodu ove poruke:';
$string['modeflatnewestfirst'] = 'Prikaz odgovora, počevši s najnovijim';
$string['modeflatoldestfirst'] = 'Prikaz odgovora, počevši s najstarijim';
$string['modenested'] = 'Prikaz odgovora u hijerarhijskoj strukturi';
$string['modethreaded'] = 'Prikaz odgovora u nizu';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'Forum omogućava sudionicima vođenje asinkrone rasprave, odnosno rasprava koje mogu trajati dulje vrijeme.

Postoji više vrsta foruma koje možete koristiti, poput standardnog foruma gdje bilo tko od polaznika može pokrenuti raspravu u bilo koje vrijeme; potom forum gdje svaki student može pokrenuti samo jednu raspravu; forum s pitanjima i odgovorima gdje studenti prvo moraju poslati odgovor prije nego što mogu vidjeti tuđe odgovore. Nastavnik može dopustiti i dodavanje priloga u obliku datoteka, pri čemu se priložene slike prikazuju kao dio poruke na forumu.

Sudionici se mogu pretplatiti na forum kako bi dobivali obavijesti o novim porukama na istom. Nastavnik može zadati dostupne načine pretplate: opcionalno, obvezno (svi) ili automatski, uz mogućnost ukidanja pretplate u potpunosti. Ako postoji potreba za time, moguće je ograničiti broj poruka koje studenti mogu poslati u nekom vremenskom periodu, čime se može spriječiti nečija dominacija u raspravi.

Poruke na forumu mogu ocjenjivati i nastavnici i drugi studenti. Te ocjene se mogu zbrojiti u završnu ocjenu.

Primjene foruma (osim očite - rasprave):

* Prostor za druženje i međusobno upoznavanje studenata
* Oglasna ploča za najave i obavijesti na razini kolegija
* Rasprava o sadržajima/materijalima na kolegiju
* Nastavak rasprave započete "na satu", odnosno predavanju
* Za raspravu među nastavnicima (korištenjem skrivenog foruma)';
$string['modulenameplural'] = 'Forumi';
$string['more'] = 'više';
$string['movedmarker'] = '(Premješteno)';
$string['movethisdiscussionto'] = 'Premjesti ovu raspravu u  ...';
$string['mustprovidediscussionorpost'] = 'Za izvoz podataka morate navesti ID broj rasprave ili poruke u forumu';
$string['namenews'] = 'Obavijesti';
$string['namenews_help'] = '<p>Forum "Obavijesti" posebni je forum koji se automatski stvara pri otvaranju novog kolegija te u kojem je moguće objavljivati obavijesti. U ovom forumu poruke mogu objavljivati samo korisnici s nastavničkim ili administratorskim ovlastima. </p>
<p>Najnovije rasprave i poruke iz ovog foruma automatski će se prikazivati u bloku "Nove obavijesti".</p>';
$string['namesocial'] = 'Društveni forum';
$string['nameteacher'] = 'Nastavnički forum';
$string['newforumposts'] = 'Nove poruke na forumu';
$string['noattachments'] = 'Ova poruka nema priloga';
$string['nodiscussions'] = 'U ovom forumu još nema rasprava';
$string['nodiscussionsstartedby'] = 'Korisnik {$a} još nije započeo nijednu raspravu';
$string['nodiscussionsstartedbyyou'] = 'Niste još započeli nijednu raspravu';
$string['noguestpost'] = 'Nažalost, gosti (anonimni korisnici) ne mogu slati poruke na forum';
$string['noguesttracking'] = 'Nažalost, korisnicima s ovlastima gosta nije dopušteno podešavanje praćenja foruma.';
$string['nomorepostscontaining'] = 'Nema više poruka koje sadrže \'{$a}\'';
$string['nonews'] = 'Trenutno nema obavijesti';
$string['noonecansubscribenow'] = 'Pretplata je sada onemogućena';
$string['nopermissiontosubscribe'] = 'Nemate ovlasti za pregledavanje pretplatnika na forum';
$string['nopermissiontoview'] = 'Nemate ovlasti da biste vidjeli ovu poruku';
$string['nopostforum'] = 'Nemate ovlasti objavljivati poruke u ovom forumu';
$string['noposts'] = 'Nema poruka';
$string['nopostsmadebyuser'] = '{$a} nije napisao/la nijednu poruku';
$string['nopostsmadebyyou'] = 'Niste napisali nijednu poruku';
$string['noquestions'] = 'U ovom forumu još nema pitanja';
$string['nosubscribers'] = 'Trenutno nema pretplaćenih korisnika u ovom forumu';
$string['notexists'] = 'Rasprava više ne postoji';
$string['nothingnew'] = 'Ništa novo za {$a}';
$string['notingroup'] = 'Nažalost, morate pripadati određenoj grupi da biste mogli vidjeti ovaj forum.';
$string['notinstalled'] = 'Modul "Forum" nije instaliran';
$string['notpartofdiscussion'] = 'Ova poruka nije dio rasprave!';
$string['notrackforum'] = 'Bez praćenja nepročitanih poruka';
$string['noviewdiscussionspermission'] = 'Nemate ovlasti za pregledavanje rasprava u ovom forumu';
$string['nowallsubscribed'] = 'Svi forumi u {$a} su pretplaćeni.';
$string['nowallunsubscribed'] = 'Svi forumi na {$a} nisu pretplaćeni.';
$string['nownotsubscribed'] = '{$a->name} NEĆE primati poruke e-pošte s kopijom poruka s foruma \'{$a->forum}\'';
$string['nownottracking'] = '{$a->name} više ne prati forum \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} će primati poruke e-pošte s kopijom poruka s foruma \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} sada prati forum \'{$a->forum}\'.';
$string['numposts'] = 'Broj poruka: {$a}';
$string['olderdiscussions'] = 'Prošle rasprave';
$string['oldertopics'] = 'Prošle teme';
$string['oldpostdays'] = 'Nakon koliko se dana stare poruke smatraju pročitanima';
$string['openmode0'] = 'Nema rasprava, nema odgovora';
$string['openmode1'] = 'Nema rasprava, ali odgovori su dopušteni';
$string['openmode2'] = 'Rasprave i odgovori su dopušteni';
$string['overviewnumpostssince'] = 'poruka od zadnje prijave na sustav: {$a}';
$string['overviewnumunread'] = 'ukupno nepročitanih: {$a}';
$string['page-mod-forum-discuss'] = 'Stranica foruma s raspravom prikazanom u hijerarhijskoj strukturi';
$string['page-mod-forum-view'] = 'Glavna stranica foruma';
$string['page-mod-forum-x'] = 'Bilo koja stranica foruma';
$string['parent'] = 'Prikaži nadređenu poruku';
$string['parentofthispost'] = 'Poruka nadređena ovoj poruci';
$string['pluginadministration'] = 'Administracija foruma';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Vaša poruka je uspješno dodana.</p>
<p>Imate {$a} za promjenu sadržaja iste, pod uvjetom da to želite.</p>';
$string['postaddedsuccess'] = 'Vaša poruka je uspješno dodana.';
$string['postaddedtimeleft'] = 'Imate {$a} minuta da biste u poruku unijeli moguće izmjene.';
$string['postincontext'] = 'Prikaži poruku u kontekstu';
$string['postmailinfo'] = 'Ovo je kopija poruke s foruma na {$a}.

Kako biste odgovorili na poruku, kliknite na ovu poveznicu:';
$string['postmailnow'] = '<p>Ova će poruka biti odmah poslana svim pretplatnicima na ovaj forum.</p> ';
$string['postrating1'] = 'Uglavnom odvojeno znanje';
$string['postrating2'] = 'Odvojeno i povezano';
$string['postrating3'] = 'Uglavnom povezano znanje';
$string['posts'] = 'Poruke';
$string['postsmadebyuser'] = 'Poruke koje je napisao/la {$a}';
$string['postsmadebyuserincourse'] = 'Poruke koje je napisao/la {$a->fullname} na kolegiju {$a->coursename}';
$string['posttoforum'] = 'Pošaljite poruku na forum';
$string['postupdated'] = 'Vaša poruka je promijenjena';
$string['potentialsubscribers'] = 'Potencijalni pretplatnici';
$string['processingdigest'] = 'Slanje sažetka putem e-pošte korisniku {$a}';
$string['processingpost'] = 'Obrađujem poruku {$a}';
$string['prune'] = 'Podijeli';
$string['prunedpost'] = 'Ova je poruka izdvojena iz postojeće rasprave i njome je započeta nova rasprava';
$string['pruneheading'] = 'Podijeli raspravu i premjesti ovu poruku u novu raspravu';
$string['qandaforum'] = 'Oblik pitanja i odgovora';
$string['qandanotify'] = 'Ovo je forum u obliku pitanja i odgovora. Da biste vidjeli replike drugih korisnika na ova pitanja, morate prvo objaviti svoj odgovor. ';
$string['re'] = 'Re:';
$string['readtherest'] = 'Pročitaj ostatak ove teme';
$string['replies'] = 'Odgovora';
$string['repliesmany'] = '{$a} odgovora za sada';
$string['repliesone'] = '{$a} odgovor za sada';
$string['reply'] = 'Odgovori (reply)';
$string['replyforum'] = 'Odgovori na forumu';
$string['replytouser'] = 'Za odgovor koristi adresu e-pošte';
$string['resetforums'] = 'Izbriši poruke s';
$string['resetforumsall'] = 'Izbriši sve poruke';
$string['resetsubscriptions'] = 'Poništi sve pretplate na forum';
$string['resettrackprefs'] = 'Poništi sve postavke za praćenje foruma';
$string['rssarticles'] = 'Broj nedavnih RSS članaka';
$string['rssarticles_help'] = 'Ova postavka definira broj članaka (rasprava ili poruka) koji će biti omogućeni u RSS kanal. Za većinu foruma je prihvatljiv broj od 5 do 20 članaka.';
$string['rsssubscriberssdiscussions'] = 'Praćenje rasprava putem RSS kanala';
$string['rsssubscriberssposts'] = 'Praćenje objava u forumu putem RSS kanala ';
$string['rsstype'] = 'Praćenje ove aktivnosti putem RSS kanala';
$string['rsstype_help'] = 'Da biste omogućili stvaranje RSS kanala za ovu aktivnost, odaberite rasprave ili poruke koje želite da u njega budu omogućene.';
$string['search'] = 'Pretraživanje';
$string['searchdatefrom'] = 'Poruke moraju biti svježije od';
$string['searchdateto'] = 'Poruke moraju biti starije od';
$string['searchforumintro'] = 'Unesite ključne riječi za pretraživanje u jedno ili više sljedećih polja:';
$string['searchforums'] = 'Pretraživanje';
$string['searchfullwords'] = 'Ove bi se riječi trebale pojaviti kao cijele riječi';
$string['searchnotwords'] = 'Ove riječi NE BI TREBALE biti u rezultatu pretraživanja';
$string['searcholderposts'] = 'Pretraživanje starijih poruka...';
$string['searchphrase'] = 'Pretraživanje prema točno sljedećem izrazu u poruci ';
$string['searchresults'] = 'Rezultati pretraživanja';
$string['searchsubject'] = 'Pretraživanje prema sljedećim riječima u naslovu poruke';
$string['searchuser'] = 'Sljedeće ime je ime autora';
$string['searchuserid'] = 'MOODLE ID autora';
$string['searchwhichforums'] = 'Koje forume treba pretražiti?';
$string['searchwords'] = 'Ove se riječi mogu pojaviti u bilo kojem dijelu poruke';
$string['seeallposts'] = 'Pregled svih poruka ovog korisnika';
$string['shortpost'] = 'Kratka poruka';
$string['showsubscribers'] = 'Prikaži/promijeni popis trenutnih pretplatnika';
$string['singleforum'] = 'Samo jedna rasprava';
$string['smallmessage'] = '{$a->user} pisao/la na {$a->forumname}';
$string['startedby'] = 'Započeo';
$string['subject'] = 'Naslov';
$string['subscribe'] = 'Pretplatite se na ovaj forum';
$string['subscribeall'] = 'Pretplatite sve korisnike na ovaj forum';
$string['subscribed'] = 'Pretplaćeni';
$string['subscribeenrolledonly'] = 'Samo registrirani korisnici se mogu pretplatiti na dobivanje obavijesti o porukama s foruma.';
$string['subscribenone'] = 'Ukini pretplatu na ovaj forum za sve korisnike';
$string['subscribers'] = 'Pretplatnici';
$string['subscribersto'] = 'Pretplatnici na \'{$a}\'';
$string['subscribestart'] = 'Pošaljite mi kopije poruka na ovom forumu putem e-pošte';
$string['subscribestop'] = 'Ne želim primati kopije poruka na ovom forumu putem e-pošte';
$string['subscription'] = 'Pretplata';
$string['subscriptionandtracking'] = 'Pretplata i praćenje foruma';
$string['subscriptionauto'] = 'Automatska pretplata';
$string['subscriptiondisabled'] = 'Pretplata onemogućena';
$string['subscriptionforced'] = 'Obvezna pretplata';
$string['subscription_help'] = '<p>Kada ste pretplaćeni na neki forum to znači da ćete primati kopije poruka s foruma putem e-pošte.</p>
<p>Najčešće je moguće odabrati želite li biti pretplaćeni na određeni forum, iako je ponekad pretplata od strane nastavnika definirana kao obvezna. U tom će slučaju svi korisnici primati kopije poruka s foruma putem e-pošte.</p>';
$string['subscriptionmode'] = 'Način pretplate';
$string['subscriptionmode_help'] = '<p>Kada je korisnik pretplaćen na neki forum to znači da će primati kopije poruka iz foruma putem e-pošte.</p>

<p>Postoje četiri moguće postavke:</p>
* Opcionalna pretplata  - korisnici mogu odabrati žele li biti pretplaćeni na forum ili ne
* Obvezna pretplata - svi su korisnici pretplaćeni na forum i ne mogu ukinuti pretplatu
* Automatska pretplata - svi su korisnici početno pretplaćeni na neki forum, no mogu se s njega odjaviti u bilo kojem trenutku
* Onemogućena pretplata - pretplata na forum nije dopuštena';
$string['subscriptionoptional'] = 'Opcionalna pretplata';
$string['subscriptions'] = 'Pretplate';
$string['thisforumisthrottled'] = 'Na ovom je forumu ograničen broj poruka koje možete objaviti u nekom vremenskom razdoblju - to je ograničenje trenutno podešeno na {$a->blockafter} poruka unutar {$a->blockperiod}';
$string['timedposts'] = 'Poruke s vremenskim ograničenjem';
$string['timestartenderror'] = 'Kraj prikaza poruke ne može biti podešen na datum raniji od početka prikaza';
$string['trackforum'] = 'Prati nepročitane poruke';
$string['tracking'] = 'Prati';
$string['trackingoff'] = 'Onemogućeno';
$string['trackingon'] = 'Omogućeno';
$string['trackingoptional'] = 'Opcionalno';
$string['trackingtype'] = 'Praćenje pročitanih/nepročitanih poruka na ovom forumu?';
$string['trackingtype_help'] = '<p>Ako je omogućeno, korisnici mogu pratiti pročitane/nepročitane poruke u nekoj raspravi ili forumu.</p>
<p>Postoje tri moguće postavke:</p>
* Opcionalno - korisnici mogu odabrati hoće li uključiti ili isključiti praćenje pročitanih/nepročitanih poruka
* Omogućeno - praćenje je uvijek uključeno
* Onemogućeno - praćenje je uvijek isključeno';
$string['unread'] = 'Nepročitano';
$string['unreadposts'] = 'Nepročitane poruke';
$string['unreadpostsnumber'] = 'Broj nepročitanih poruka: {$a}';
$string['unreadpostsone'] = '1 nepročitana poruka';
$string['unsubscribe'] = 'Ukini pretplatu na ovaj forum';
$string['unsubscribeall'] = 'Ukini pretplatu na sve forume';
$string['unsubscribeallconfirm'] = 'Trenutno ste pretplaćeni na {$a} forum(a). Jeste li sigurni da se želite odjaviti sa svih foruma i onemogućiti automatsku pretplatu na forume? ';
$string['unsubscribealldone'] = '<p>Sve vaše pretplate na forume su ukinute, iako ćete još uvijek primati obavijesti s foruma na kojima je pretplata obvezna. </p>
<p>Obavijestima o aktivnosti na forumu možete upravljati kroz Postavke profila -> Poruke.</p>';
$string['unsubscribeallempty'] = '<p>Nažalost niste pretplaćeni niti na jedan forum. </p>
<p>Ako ne želite više primati poruke e-pošte s ovog poslužitelja, to možete promijeniti kroz Postavke profila -> Poruke.</p>';
$string['unsubscribed'] = 'Odjavljen';
$string['unsubscribeshort'] = 'Ukini pretplatu';
$string['usermarksread'] = 'Ručno označavanje pročitanih poruka';
$string['viewalldiscussions'] = 'Pregled svih rasprava';
$string['warnafter'] = 'Granični broj poruka za upozorenje';
$string['warnafter_help'] = '<p>Studenti mogu biti upozoreni kada se približe najvećem dopuštenom broju poruka u zadanom vremenskom razdoblju. Ova postavka definira nakon koliko će objavljenih poruka biti upozoreni.</p>
<p>Ograničenje broja poruka ne vrijedi za korisnike s ovlastima mod/forum:postwithoutthrottling (npr. nastavnici).</p>';
$string['warnformorepost'] = 'Upozorenje! Postoji više od jedne rasprave na ovom forumu - koristi se najnovija';
$string['yournewquestion'] = 'Novo pitanje';
$string['yournewtopic'] = 'Nova rasprava';
$string['yourreply'] = 'Vaš odgovor';
