<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Već ste prijavljeni kao {$a}, trebate se odjaviti prije nego se prijavite kao drugi korisnik.';
$string['authnotexisting'] = 'Autorizacijski dodatak (plugin) ne postoji';
$string['backupcontainexternal'] = 'Ova backup datoteka sadrži vanjske MNet poslužitelje koji nisu lokalno podešeni.';
$string['backuptablefail'] = 'Nije bilo moguće postaviti backup tablice!';
$string['blockcannotconfig'] = 'Ovaj blok ne podržava globalno podešavanje';
$string['blockcannotinistantiate'] = 'Problem pri stvaranju ove instance bloka';
$string['blockcannotread'] = 'Nije bilo moguće pročitati podatke za blockid= {$a}';
$string['blockdoesnotexist'] = 'Blok ne postoji';
$string['blockdoesnotexistonpage'] = 'Ovaj blok (id={$a->instanceid}) ne postoji na stranici: ({$a->url}).';
$string['blocknameconflict'] = 'Konflikt u nazivu: blok {$a->name} ima isti naslov kao i postojeći blok: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Modul odbija dodavanje ovog komentara';
$string['cannotaddcoursemodule'] = 'Nije bilo moguće dodati novi modul';
$string['cannotaddcoursemoduletosection'] = 'Nije bilo moguće dodati novi modul u ovu sekciju';
$string['cannotaddmodule'] = 'Modul {$a} nije mogao biti dodan na popis modula!';
$string['cannotaddnewmodule'] = 'Nije bilo moguće dodati novi modul: {$a}';
$string['cannotaddrss'] = 'Nemate ovlasti za dodavanje RSS kanala';
$string['cannotaddthisblocktype'] = 'Nije bilo moguće dodati blok {$a} na ovu stranicu.';
$string['cannotassignrole'] = 'Nije moguće dodijeliti ulogu na razini kolegija';
$string['cannotassignrolehere'] = 'Ne možete dodijeliti ulogu (id = {$a->roleid}) u kontekstu:  ({$a->context})';
$string['cannotassignselfasparent'] = 'Nije moguće biti nadređen samom sebi!';
$string['cannotcallscript'] = 'Ne možete pozvati skriptu na taj način';
$string['cannotcallusgetselecteduser'] = 'Ne možete pozvati user_selector:get_selected_user ako je omogućen višestruki odabir.';
$string['cannotcreatebackupdir'] = 'Nije moguće stvoriti mapu backupdata. Administrator treba popraviti ovlasti za datoteku';
$string['cannotcreatecategory'] = 'Kategorija nije dodana';
$string['cannotcreategroup'] = 'Pogreška pri stvaranju grupe';
$string['cannotcreatelangbase'] = 'Pogreška: Nije moguće stvoriti osnovnu mapu lang';
$string['cannotcreatelangdir'] = 'Nije moguće stvoriti lang mapu';
$string['cannotcreateorfindstructs'] = 'Pogreška pri traženju ili stvaranju struktura poglavlja u ovom kolegiju';
$string['cannotcreatepopupwin'] = 'Nedefinirani element - nije moguće stvoriti iskočni prozor';
$string['cannotcreatesitedir'] = 'Nije moguće stvoriti mapu sjedišta. Administrator sjedišta treba promijeniti ovlasti na datotekama.';
$string['cannotcreatetempdir'] = 'Nije moguće stvoriti privremenu (TEMP) mapu';
$string['cannotcreateuploaddir'] = 'Nije moguće stvoriti mapu za prijenos na poslužitelj. Administrator sjedišta treba promijeniti ovlasti na datotekama.';
$string['cannotcustomisefiltersblockuser'] = 'Ne možete prilagoditi postavke filtera u kontekstu korisnika ili bloka.';
$string['cannotdeletebackupids'] = 'Nije bilo moguće obrisati id oznake prethodnih backup datoteka';
$string['cannotdeletecategorycourse'] = 'Nije uspjelo brisanje kolegija \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Nije bilo moguće izbrisati pitanja iz kategorije \'{$a}\'';
$string['cannotdeletecourse'] = 'Nemate ovlasti za brisanje ovog kolegija';
$string['cannotdeletecustomfield'] = 'Pogreška pri brisanju prilagođenog polja podataka';
$string['cannotdeletedir'] = 'Nije moguće obrisati ({$a})';
$string['cannotdeletefile'] = 'Nije moguće izbrisati ovu datoteku';
$string['cannotdeleterole'] = 'Brisanje nije moguće zbog {$a}';
$string['cannotdeleterolewithid'] = 'Nije moguće izbrisati ulogu koja ima ID {$a}';
$string['cannotdeletethisrole'] = 'Ne možete izbrisati ovu ulogu, jer se koristi u sustavu, ili je to zadnja uloga s administratorskim ovlastima.';
$string['cannotdisableformat'] = 'Nije moguće onemogućiti zadani oblik';
$string['cannotdownloadcomponents'] = 'Nije moguće preuzimanje komponenti';
$string['cannotdownloadlanguageupdatelist'] = 'Nije moguće preuzeti popis jezičnih nadogradnji s download.moodle.org';
$string['cannotdownloadzipfile'] = 'Nije moguće preuzeti ZIP datoteku';
$string['cannoteditcomment'] = 'Ovaj komentar nije vaš i ne možete ga uređivati!';
$string['cannoteditcommentexpired'] = 'Ne možete ovo uređivati. Vrijeme je isteklo!';
$string['cannoteditpostorblog'] = 'Ne možete pisati članke ili uređivati blogove';
$string['cannoteditsiteform'] = 'Ne možete uređivati kolegij sjedišta pomoću ovog obrasca';
$string['cannotedityourprofile'] = 'Nažalost, ne možete uređivati vlastiti profil';
$string['cannotfindcategory'] = 'Nije moguće pronaći zapis u bazi podataka o kategoriji koja ima ID {$a}';
$string['cannotfindcomponent'] = 'Nije moguće pronaći komponentu';
$string['cannotfindcontext'] = 'Nije moguće pronaći kontekst';
$string['cannotfindcourse'] = 'Nije moguće pronaći kolegij';
$string['cannotfinddocs'] = 'Nije moguće pronaći dokumentacijske datoteke za "{$a}" jezik';
$string['cannotfindgradeitem'] = 'Nije moguće pronaći grade_item';
$string['cannotfindgroup'] = '	
Nije moguće pronaći grupu';
$string['cannotfindhelp'] = 'Nije moguće pronaći datoteke pomoći za jezik: {$a}';
$string['cannotfindinfo'] = 'Nije moguće pronaći naći informacije za: "{$a}"';
$string['cannotfindlang'] = 'Nije moguće pronaći jezični paket za:  "{$a}"!';
$string['cannotfindteacher'] = 'Nije moguće pronaći nastavnika';
$string['cannotfinduser'] = 'Nije moguće pronaći korisnika po imenu "{$a}"';
$string['cannotgeoplugin'] = 'Spajanje na geoPlugin poslužitelj, http://www.geoplugin.com nije moguće, provjerite proxy postavke ili, još bolje, instalirajte MaxMind GeoLite City datoteku s podacima.';
$string['cannotgetblock'] = 'Nije moguće pristupiti blokovima u bazi podataka';
$string['cannotgetcats'] = 'Nije moguće dobiti zapis kategorije';
$string['cannotgetdata'] = 'Nije moguće dobiti podatak';
$string['cannotgradeuser'] = 'Ovog korisnika nije moguće ocijeniti';
$string['cannothaveparentcate'] = 'Kategorija kolegija ne može imati nadređene kategorije!';
$string['cannotimport'] = 'Pogreška pri uvozu';
$string['cannotimportformat'] = 'Nažalost, uvoz ovog oblika još nije implementiran!';
$string['cannotimportgrade'] = 'Pogreška pri uvozu ocjena';
$string['cannotinsertgrade'] = 'Nije moguće dodati stavku ocjene bez ID-a kolegija!';
$string['cannotinsertrate'] = 'Nije moguće dodati novi rating ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Nije moguće dodati ID za novi zapis: {$a}';
$string['cannotmailconfirm'] = 'Pogreška pri slanju poruke e-pošte s potvrdom o promjeni lozinke';
$string['cannotmanualctrack'] = 'Nije podržano ručno praćenje dovršetka ove aktivnosti';
$string['cannotmapfield'] = 'Otkriven sukob pri pridruživanju - dva polja se pridružuju istoj stavki ocjene: {$a}';
$string['cannotmarktopic'] = 'Nije iblo moguće označiti temu za ovaj kolegij';
$string['cannotmigratedatacomments'] = 'Nije moguće migrirati komentare modula podataka';
$string['cannotmodulename'] = 'Nije moguće dohvatiti naziv modula pri stvaranju navigacije';
$string['cannotmoduletype'] = 'Nije moguće dohvatiti vrstu modula pri stvaranju navigacije';
$string['cannotmovecategory'] = 'Nije moguće premjestiti kategoriju';
$string['cannotmoverolewithid'] = 'Nije moguće premjestiti ulogu s ID-jem {$a}';
$string['cannotopencsv'] = 'Nije moguće otvoriti CSV datoteku';
$string['cannotopenfile'] = 'Nije moguće otvoriti datoteku ({$a})';
$string['cannotopenforwrit'] = 'Nije moguće otvoriti za pisanje: {$a}';
$string['cannotopentemplate'] = 'Nije moguće otvoriti datoteku s predloškom ({$a})';
$string['cannotopenzip'] = 'Nije moguće otvoriti zip datoteku. Vjerojatno se radi o pogrešci sa zip ekstenzijom na 64-bitnom operativnom sustavu.';
$string['cannotoverridebaserole'] = 'Nije moguće zaobići osnovne mogućnosti uloge';
$string['cannotoverriderolehere'] = 'Nije vam dopušteno izmijeniti ovlast za ovu ulogu (id = {$a->roleid}) u ovom kontekstu ({$a->context})';
$string['cannotreadfile'] = 'Nije moguće pročitati datoteku ({$a})';
$string['cannotreadtmpfile'] = 'Pogreška pri čitanju privremene datoteke';
$string['cannotreaduploadfile'] = 'Nije moguće pročitati prenešenu datoteku';
$string['cannotremovefrommeta'] = 'Nije moguće ukloniti odabrani kolegij iz ovog meta kolegija!';
$string['cannotresetguestpwd'] = 'Ne možete resetirati lozinku gosta / anonimnog korisnika';
$string['cannotresetmail'] = 'Pogreška pri resetiranju lozinke i slanja e-pošte na vašu adresu';
$string['cannotresetthisrole'] = 'Ovu ulogu nije moguće resetirati';
$string['cannotrestore'] = 'Pogreška pri dovršenju vraćanja backupa!';
$string['cannotrestoreadminorcreator'] = 'Trebate biti autor kolegija ili administrator kako biste vratili sadržaj backup datoteke u novi kolegij!';
$string['cannotrestoreadminoredit'] = 'Trebati biti nastavnik s ovlastima uređivanja ili administrator kako biste vratili sadržaj backup datoteke u odabrani kolegij! ';
$string['cannotsaveagreement'] = 'Nije bilo moguće pohraniti vaš sporazum';
$string['cannotsaveblock'] = 'Pogreška pri pohrani postavki bloka';
$string['cannotsavecomment'] = 'Nije moguće pohraniti komentar';
$string['cannotsavedata'] = 'Podatke nije moguće pohraniti';
$string['cannotsavefile'] = 'Nije moguće pohraniti datoteku "{$a}"!';
$string['cannotsavemd5file'] = 'Nije moguće pohraniti md5 datoteku';
$string['cannotsavezipfile'] = 'Nije moguće pohraniti ZIP datoteku';
$string['cannotservefile'] = 'Nije moguće prikazati datoteku - problem u postavkama poslužitelja.';
$string['cannotsetparentforcatoritem'] = 'Nije moguće postaviti nadređenu kategoriju ili stavku kolegija!';
$string['cannotsetpassword'] = 'Nije moguće podesiti korisničku lozinku!';
$string['cannotsettheme'] = 'Nije moguće postaviti temu!';
$string['cannotsetupblock'] = 'NIJE bilo moguće uspješno podesiti tablice blokova!';
$string['cannotsetupcapformod'] = 'Nije bilo moguće podesiti postavke - {$a}';
$string['cannotsetupcapforplugin'] = 'Nije bilo moguće podesiti postavke - {$a}';
$string['cannotshowhidecoursesincategory'] = 'Nije moguće prikazati/skriti kolegije u kategoriji {$a}';
$string['cannotunassigncap'] = 'Nije moguće ukloniti zastarjelu mogućnost {$a->cap} iz uloge {$a->role}';
$string['cannotunassignrolefrom'] = 'Nije moguće ukloniti ulogu ovom korisniku koji ima ID uloge: {$a}';
$string['cannotunzipfile'] = 'Nije moguće otpakirati datoteku';
$string['cannotupdatemod'] = 'Nije moguće osvježiti {$a}';
$string['cannotupdatepasswordonextauth'] = 'Nije moguće nadograditi lozinku na vanjskoj autentikaciji: {$a}. Za više detalja pogledajte zapise na poslužitelju.';
$string['cannotupdateprofile'] = 'Pogreška prilikom osvježavanja korisničkog zapisa';
$string['cannotupdaterecord'] = 'Nije moguće osvježiti zapis s ID {$a}';
$string['cannotupdaterss'] = 'Nije moguće osvježiti RSS izvor vijesti';
$string['cannotupdatesubcourse'] = 'Nije bilo moguće osvježiti podređeni kolegij!';
$string['cannotupdateusermsgpref'] = 'Nije moguće nadograditi korisničke postavke za poruke';
$string['cannotupdateuseronexauth'] = 'Nije moguće nadograditi podatke o korisnicima na vanjskoj autentikaciji: {$a}. Za više detalja pogledajte zapise na poslužitelju.';
$string['cannotuploadfile'] = 'Pogreška pri obradi prenešene datoteke';
$string['cannotuseadmin'] = 'Morate biti administrator da biste koristili ovu stranicu';
$string['cannotuseadminadminorteacher'] = 'Morate biti nastavnik ili administrator da biste koristili ovu stranicu';
$string['cannotusepage'] = 'Samo nastavnici i administratori mogu koristiti ovu stranicu';
$string['cannotusepage2'] = 'Ne možete koristiti ovu stranicu';
$string['cannotviewprofile'] = 'Ne možete vidjeti profil ovog korisnika';
$string['cannotviewreport'] = 'Ne možete vidjeti ovaj izvještaj';
$string['cannotwritefile'] = 'Ne mogu pisati u datoteku ({$a})';
$string['categoryerror'] = 'Pogreška vezana za kategoriju';
$string['categoryidnumbertaken'] = 'ID se već koristi za drugu kategoriju';
$string['categorynamerequired'] = 'Neophodno je unijeti naziv kategorije';
$string['categorytoolong'] = 'Naziv kategorije je predugačak';
$string['commentmisconf'] = 'ID komentara je pogrešno podešen';
$string['componentisuptodate'] = 'Komponenta je dostupna u svojoj najnovijoj inačici.';
$string['confirmsesskeybad'] = 'Vaš ključ sjednice nije moguće potvrditi, kako bi ova akcija bila izvršena. Ova sigurnosna značajka štiti od slučajnih ili zlonamjernih obavljanja važnih zadaća u vaše ime. Uvjerite se da doista želite ovo napraviti.';
$string['couldnotassignrole'] = 'Pri dodjeljivanju vaše uloge došlo je do ozbiljne, ali nespecificirane pogreške';
$string['couldnotupdatenoexistinguser'] = 'Nije moguće osvježiti podatke o korisniku - korisnik ne postoji';
$string['countriesphpempty'] = 'Pogreška: Datoteka countries.php u jezinkom paketu {$a} je prazna ili nedostaje.';
$string['coursedoesnotbelongtocategory'] = 'Kolegij ne spada u ovu kategoriju';
$string['courseformatnotfound'] = 'Oblik kolegija \'{$a}\' ne postoji ili nije prepoznat';
$string['coursegroupunknown'] = 'Kolegij koji odgovara grupi {$a} nije zadan';
$string['courseidnotfound'] = 'ID kolegija ne postoji';
$string['coursemisconf'] = 'Kolegij je pogrešno podešen';
$string['courserequestdisabled'] = 'Administrator nije omogućio slanje zahtjeva za kolegije';
$string['csvcolumnduplicates'] = 'Pronađeni dupli stupci';
$string['csvemptyfile'] = 'CSV datoteka je prazna';
$string['csvfewcolumns'] = 'Nema dovoljno stupaca, molimo provjerite postavku delimitera';
$string['csvinvalidcols'] = '<b>Nevaljana CSV datoteka:</b>
Prvi redak mora sadržavati "Polja zaglavlja" i datoteka mora biti u obliku
<br />"Expanded Fields/Comma Separated"<br />ili<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Neispravna CSV datoteka - svaki red mora imati 49 ili 70 polja';
$string['csvloaderror'] = 'Došlo je do pogreške pri učitavanju CSV datoteke!';
$string['csvweirdcolumns'] = 'Neispravan oblik CSV datoteke - broj stupaca nije svuda isti!';
$string['dbconnectionfailed'] = '<p>Pogreška: Nije moguće spajanje na bazu podataka</p> <p>Moguće je da je baza preopterećena ili ne radi.
</p> <p>Administrator sjedišta treba provjeriti da su detalji spajanja na bazu točno definirani u datoteci config.php</p>';
$string['dbdriverproblem'] = '<p>Pogreška: otkriven je problem s driverom za bazu podataka
</p> <p>Administrator sjedišta treba provjeriti konfiguraciju poslužitelja</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Došlo je do ozbiljne pogreške sesije baze podataka.<br /><br />Obavijestite administratora.';
$string['dbsessionhandlerproblem'] = 'Postavljanje sesije baze podataka nije uspjelo. <br /><br />Obavijestite administratora poslužitelja.';
$string['dbsessionmysqlpacketsize'] = 'Otkrivena je ozbiljna pogreška u sesiji. <br /><br />Obavijestite administratora. Ovaj je problem vjerojatno uzrokovan premalom vrijednošću postavke max_allowed_packet MySQL';
$string['dbupdatefailed'] = 'Nadogradnja baze podataka nije uspjela';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" nije moguće mijenjati. Otkrivena je ovisnost o  {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Pogreška "DDL sql execution"';
$string['ddlfieldalreadyexists'] = 'Polje "{$a}" već postoji';
$string['ddlfieldnotexist'] = 'Polje "{$a->fieldname}" ne postoji u tablici "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tablica "{$a}" već postoji';
$string['ddltablenotexist'] = 'Tablica "{$a}" ne postoji';
$string['ddlunknownerror'] = 'Nepoznata DDL pogreška';
$string['ddlxmlfileerror'] = 'Pronađene su pogreške u datoteci XML baze podataka';
$string['ddsequenceerror'] = 'Definicija tablice "{$a}" je netočna; može postojati samo jedan auto-stupac, i mora biti definiran kao ključ.';
$string['destinationcmnotexit'] = 'Odredišni modul kolegija ne postoji';
$string['detectedbrokenplugin'] = 'Dodatak "{$a}" je neispravan ili zastario, stoga nije moguće nastaviti.';
$string['dmlreadexception'] = 'Pogreška pri čitanju iz baze podataka';
$string['dmltransactionexception'] = 'Transakcijska pogreška baze podataka';
$string['dmlwriteexception'] = 'Pogreška pri pisanju u bazu podataka';
$string['downgradedcore'] = 'POGREŠKA! Kôd koji koristite je STARIJI od inačice koja je stvorila ove baze!';
$string['downloadedfilecheckfailed'] = 'Došlo je do pogreške pri provjeri preuzete datoteke';
$string['duplicatefieldname'] = 'Otkriven dupli naziv polja "{$a}"';
$string['duplicatenosupport'] = 'Nije moguće duplicirati aktivnosti \'{$a->modname}\' jer modul {$a->modtype} ne podržava backup i vraćanje kopije.';
$string['duplicateparaminsql'] = 'POGREŠKA: dupli naziv parametra u upitu';
$string['duplicaterolename'] = 'Već postoji uloga s ovim imenom!';
$string['duplicateroleshortname'] = 'Već postoji uloga s tom kraticom!';
$string['duplicateusername'] = 'Duplikat korisničkog imena - ovaj zapis se preskače';
$string['emailfail'] = 'Slanje poruke e-pošte nije uspjelo';
$string['error'] = 'Dogodila se pogreška';
$string['errorcleaningdirectory'] = 'Pogreška pri čišćenju mape "{$a}"';
$string['errorcopyingfiles'] = 'Pogreška pri kopiranju datoteka';
$string['errorcreatingdirectory'] = 'Pogreška pri stvaranju mape "{$a}"';
$string['errorcreatingfile'] = 'Pogreška pri stvaranju datoteke "{$a}"';
$string['errorcreatingrole'] = 'Pogreška pri stvaranju uloge';
$string['errorfetchingrssfeed'] = 'Pogreška pri dohvatu RSS kanala.';
$string['erroronline'] = 'Pogreška u liniji {$a}';
$string['errorparsingxml'] = 'Pogreška pri parsiranju XML-a: {$a->errorstring} u retku {$a->errorline}, na znaku {$a->errorchar}';
$string['errorreadingfile'] = 'Pogreška pri čitanju datoteke "{$a}"';
$string['errorsavingrequest'] = 'Dogodila se pogreška pri pohrani vašeg zahtjeva.';
$string['errorsettinguserpref'] = 'Pogreška pri postavljanju korisničkih postavki';
$string['errorunzippingfiles'] = 'Pogreška pri raspakivanju datoteka';
$string['expiredkey'] = 'Ključ je istekao';
$string['externalauthpassworderror'] = 'Lozinka za vanjsku autentikaciju koja nije prazan niz';
$string['externalfilenolocation'] = 'Vanjska datoteka ne sadrži putanju do lokacije';
$string['failtoloadblocks'] = 'Jedan ili više blokova su registrirani u bazi podataka, ali se nijedan nije učitao!';
$string['fieldrequired'] = '"{$a}" je obvezno polje';
$string['fileexists'] = 'Datoteka postoji od prije';
$string['filenotfound'] = 'Nažalost, nije bilo moguće pronaći traženu datoteku';
$string['filenotreadable'] = 'Datoteka nije čitljiva';
$string['filterdoesnothavelocalconfig'] = 'Filtar {$a} ne ne dopušta lokalno podešavanje.';
$string['filternotactive'] = 'Filtar {$a} trenutno nije aktivan';
$string['filternotenabled'] = 'Filtar nije omogućen!';
$string['filternotinstalled'] = 'Filtar {$a} trenutno nije instaliran';
$string['forumblockingtoomanyposts'] = 'Prekoračili ste ograničenje za broj poruka na ovom forumu.';
$string['generalexceptionmessage'] = 'Izuzetak - {$a}';
$string['gradepubdisable'] = 'Onemogućeno objavljivanje ocjena';
$string['groupalready'] = 'Korisnik već pripada grupi {$a}';
$string['groupexistforcourse'] = 'Grupa "{$a}" već postoji na ovom kolegiju';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Grupa "{$a->name}" čiji je ID "{$a->idnumber}" već postoji u ovom kolegiju';
$string['grouphasidnumber'] = 'Grupa "{$a}" ima ID i možda ju je stvorio neki vanjski sustav. Nemate ovlasti za brisanje ove grupe.';
$string['groupinghasidnumber'] = 'Grupacija "{$a}" ima ID i možda ju je stvorio neki vanjski sustav. Nemate ovlasti za brisanje ove grupacije.';
$string['groupingnotaddederror'] = 'Grupacija "{$a}" nije dodana';
$string['groupnotaddederror'] = 'Grupa "{$a}" nije dodana';
$string['groupnotaddedtogroupingerror'] = 'Grupa "{$a->groupname}" nije dodana u grupaciju "{$a->groupingname}"';
$string['groupunknown'] = 'Group {$a} not associated to specified course';
$string['groupusernotmember'] = 'Korisnik nije član ove grupe';
$string['guestnocomment'] = 'Gosti ne mogu komentirati!';
$string['guestnoeditprofile'] = 'Gost ne može uređivati svoj profil';
$string['guestnoeditprofileother'] = 'Profil korisnika \'Gost\' nije moguće uređivati';
$string['guestnorate'] = 'Gosti ne mogu ocjenjivati pojmove';
$string['guestsarenotallowed'] = 'Gost to ne može napraviti';
$string['hackdetected'] = 'Otkriven je hakerski napad!';
$string['hashpoolproblem'] = 'Neispravan sadržaj pool datoteke {$a}.';
$string['headersent'] = 'Zaglavlja su već poslana';
$string['idnumbertaken'] = 'ID broj se otprije koristi za drugi kolegij';
$string['idnumbertoolong'] = 'ID je predugačak';
$string['importformatnotimplement'] = 'Uvoz ovog oblika još nije implementiran!';
$string['incorrectext'] = 'Datoteka ima neispravnu ekstenziju';
$string['installproblem'] = 'Obično nije moguć oporavak od pogrešaka tijekom instalacije, trebali biste napraviti novu bazu podataka ili koristiti različiti prefiks tablica u bazi ako želite ponoviti postupak instalacije.';
$string['internalauthpassworderror'] = 'Nedostaju pravila za lozinke ili nisu ispravno podešena';
$string['invalidaccess'] = 'Ovoj stranici nije ispravno pristupljeno';
$string['invalidaccessparameter'] = 'Neispravan parametar pristupa';
$string['invalidaction'] = 'Neispravan akcijski parametar';
$string['invalidactivityid'] = 'Neispravan ID aktivnosti';
$string['invalidadminsettingname'] = 'Neispravna admin postavka ({$a})';
$string['invalidargorconf'] = 'Nisu predani valjani argumenti ili je konfiguracija poslužitelja neispravna ';
$string['invalidarguments'] = 'Nema valjanih argurmenata';
$string['invalidblockinstance'] = 'Neispravna instanca bloka za: {$a}';
$string['invalidbulkenrolop'] = 'Zatražena masovna operacija upisa nije valjana.';
$string['invalidcategory'] = 'Pogrešna kategorija!';
$string['invalidcategoryid'] = 'Pogrešan id kategorije!';
$string['invalidcomment'] = 'Komentar nije valjan';
$string['invalidcommentarea'] = 'Neispravno polje za komentiranje';
$string['invalidcommentid'] = 'Neispravan ID komentara';
$string['invalidcommentitemid'] = 'Neispravan itemid komentara';
$string['invalidcommentparam'] = 'Neispravni parametri komentara';
$string['invalidcomponent'] = 'Neispravan naziv komponente';
$string['invalidconfirmdata'] = 'Neispravni podaci o potvrdi';
$string['invalidcontext'] = 'Neispravan kontekst';
$string['invalidcourse'] = 'Neispravan kolegij';
$string['invalidcourseid'] = 'Pokušavate koristiti ID kolegija koji nije valjan';
$string['invalidcourselevel'] = 'Pogrešna razina konteksta';
$string['invalidcoursemodule'] = 'Nevaljan ID modula kolegija';
$string['invalidcoursenameshort'] = 'Neispravna kratica kolegija';
$string['invaliddata'] = 'Predani podaci nisu valjani';
$string['invaliddatarootpermissions'] = 'Pronađene su nevaljane ovlasti u mapi $CFG->dataroot. Administrator treba popraviti ovlasti.';
$string['invaliddevicetype'] = 'Neispravna vrsta uređaja';
$string['invalidelementid'] = 'Pogrešan id elementa';
$string['invalidentry'] = 'Ovo nije ispravan unos!';
$string['invalidevent'] = 'Neispravan događaj';
$string['invalidfieldname'] = '"{$a}" nije valjano ime polja.';
$string['invalidfiletype'] = '"{$a}" nije ispravna vrsta datoteke';
$string['invalidformatpara'] = 'Neispravan oblik za odabrani parametar';
$string['invalidformdata'] = 'Neispravni podaci u obrascu';
$string['invalidfunction'] = 'Netočna funkcija';
$string['invalidgradeitemid'] = 'Neispravan ID stavke ocjene';
$string['invalidgroupid'] = 'Neispravan ID grupe';
$string['invalidipformat'] = 'Netočan oblik IP adrese';
$string['invaliditemid'] = 'Neispravan ID objekta';
$string['invalidkey'] = 'Neispravan ključ';
$string['invalidlegacy'] = 'Neispravna naslijeđena definicija uloge za vrstu: {$a} ';
$string['invalidmd5'] = 'Neispravna md5 datoteka';
$string['invalidmode'] = 'Neispravan način ({$a})';
$string['invalidmodule'] = 'Neispravan modul';
$string['invalidmoduleid'] = 'Neispravan ID modula: {$a}';
$string['invalidmodulename'] = 'Neispravan naziv modula: {$a}';
$string['invalidnum'] = 'Neispravna numerička vrijednost';
$string['invalidnumkey'] = 'Polje $conditions ne može sadržavati numeričke ključeve, popravite kôd!';
$string['invalidoutcome'] = 'Neispravan id ishoda učenja';
$string['invalidpagesize'] = 'Neispravna veličina stranice';
$string['invalidpasswordpolicy'] = 'Neispravna pravila za lozinke';
$string['invalidpaymentmethod'] = 'Neispravan način plaćanja {$a}';
$string['invalidqueryparam'] = 'POGREŠKA: Neispravan broj parametara u zahtjevu. Očekivano: {$a->expected}, primljeno {$a->actual}.';
$string['invalidratingarea'] = 'Područje za ocjenjivanje nije valjano';
$string['invalidrecord'] = 'Zapisi podataka za tablicu {$a} nisu pronađeni.';
$string['invalidrecordunknown'] = 'Ne možete pronaći zapis podatka u bazi podataka.';
$string['invalidrequest'] = 'Neispravan zahtjev';
$string['invalidrole'] = 'Neispravna uloga';
$string['invalidroleid'] = 'Neispravan ID uloge';
$string['invalidscaleid'] = 'Neispravan ID skale';
$string['invalidsection'] = 'Zapis o modulu kolegija sadrži nevaljani odjeljak';
$string['invalidsesskey'] = 'Poslani ključ sesije je neispravan, obrazac nije prihvaćen!';
$string['invalidshortname'] = 'Neispravna kratica kolegija';
$string['invalidsourcefield'] = 'Polje za unos nacrta datoteke nije valjano';
$string['invalidstatedetected'] = 'Nešto je pošlo po zlu: {$a}. Ovo se obično nikad ne bi trebalo dogoditi.';
$string['invalidurl'] = 'Neispravan URL';
$string['invaliduser'] = 'Neispravan korisnik';
$string['invaliduserfield'] = 'Neispravno korisničko polje: {$a}';
$string['invaliduserid'] = 'Neispravan id korisnika';
$string['invalidusername'] = 'Zadano korisničko ime sadržava nedopuštene znakove';
$string['invalidxmlfile'] = '"{$a}" nije ispravna XML datoteka';
$string['iplookupfailed'] = 'Nije moguće pronaći geografske podatke o ovoj IP adresi {$a}.';
$string['iplookupprivate'] = 'Ne mogu prikazati lookup detalje privatne IP adrese';
$string['ipmismatch'] = 'Klijentska IP adresa je različita';
$string['listcantmovedown'] = 'Nije moguće stavku pomaknuti dolje, jer je to zadnja stavka';
$string['listcantmoveleft'] = 'Nije moguće stavku pomaknuti lijevo, jer nema nadređenu stavku';
$string['listcantmoveright'] = 'Nije moguće stavku pomaknuti desno, jer nema stavke koja bi joj bila podređena. Pomaknite ju ispod druge stavke, i tada ju možete pomaknuti desno.';
$string['listcantmoveup'] = 'Nije moguće stavku pomaknuti gore, jer je prva od svih stavki.';
$string['listnochildren'] = 'Nema podređenih stavki';
$string['listnoitem'] = 'Objekt nije pronađen';
$string['listnopeers'] = 'Nema ravnopravnih stavki';
$string['listupdatefail'] = 'DB operacija nije uspjela pri uređivanju hijerarhije  popisa';
$string['logfilenotavailable'] = 'Zapisi nisu dostupni';
$string['loginasnoenrol'] = 'Ne možete se upisivati ili ispisivati s kolegija, dok traje sesija "Prijavi se kao"';
$string['loginasonecourse'] = 'Ne možete pristupiti ovom kolegiju.<br />Trebate završiti sa sesijom "Prijavi se kao", prije nego pristupite nekom drugom kolegiju.';
$string['maxareabytes'] = 'Nema dovoljno mjesta za pohranu ove datoteke';
$string['maxbytes'] = 'Ova datoteka je veća od najveće dopuštene veličine';
$string['messagingdisable'] = 'Na ovom sustavu slanje poruka nije omogućeno';
$string['mimetexisnotexist'] = 'Vaš sustav nije podešen da pokreće mimeTeX. Potrebno je preuzeti prikaladne izvšrne datoteke za vašu PHP_OS platformu s <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, ili nabaviti izvorni kod pisan u C-u s: <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, prevesti ga i prenijeti izvršni kod u mapu moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Prilagođeni mimetex nije moguće pokrenuti!';
$string['missingfield'] = 'Polje "{$a}" nedostaje';
$string['missingkeyinsql'] = 'POGREŠKA: nedostaje parametar "{$a}" u upitu';
$string['missing_moodle_backup_xml_file'] = 'U backup arhivi nedostaje XML datoteka: {$a}';
$string['missingparam'] = 'Obvezni parametar ({$a}) nedostaje';
$string['missingparameter'] = 'Nedostaje parametar';
$string['missingrequiredfield'] = 'Nedostaje neko obvezno polje';
$string['missinguseranditemid'] = 'Nedostaje userid i itemid';
$string['missingvarname'] = 'Nedostaje ime neophodne varijable';
$string['mixedtypesqlparam'] = 'POGREŠKA: Pomiješane vrste parametara u SQL upitima!!';
$string['mnetdisable'] = 'MNET nije omogućen';
$string['mnetlocal'] = 'Udaljeni MNet korisnici se ne mogu prijaviti lokalno';
$string['moduledisable'] = 'Ovaj modul ({$a}) je nije moguće koristiti u ovom kolegiju';
$string['moduledoesnotexist'] = 'Ovaj modul ne postoji';
$string['moduleinstancedoesnotexist'] = '	
Instanca ovog modula ne postoji';
$string['modulemissingcode'] = 'Kôd za izvođenje ove funkcije nedostaje u modulu {$a} ';
$string['movecatcontentstoroot'] = 'Premještanje sadržaja kategorije u osnovnu kategoriju nije dopušteno. Sadržaj je potrebno premjestiti u postojeću kategoriju!';
$string['multiplerecordsfound'] = 'Pronađeni višestruki zapisi, očekivan je samo jedan zapis.';
$string['multiplerestorenotallow'] = 'Nije dopušteno višestruko pokretanje postupka vraćanja podataka!';
$string['mustbeloggedin'] = 'Kako biste to mogli učiniti morate biti prijavljeni na sustav';
$string['mustbeteacher'] = 'Morate biti nastavnici kako bi mogli pregledavati ovu stranicu';
$string['myisamproblem'] = 'Tablice u bazi koriste MyISAM sustav. Preporuča se da koristite sustav kompatibilan s ACID-om, s punom podrškom za transakcije, poput InnoDB-a.';
$string['needcopy'] = 'Prvo morate nešto kopirati!';
$string['needcoursecategroyid'] = 'ID kolegija ili kategorije mora biti upisan.';
$string['needphpext'] = 'Potrebno je dodati podršku za {$a} u instalaciju PHP-a';
$string['noadmins'] = '	
Nema administratora!';
$string['noblocks'] = 'Nijedan blok nije pronađen!';
$string['nocapabilitytousethisservice'] = 'Korisnik nema potrebna svojstva za uporabu ove usluge ';
$string['nocategorydelete'] = 'Kategoriju \'{$a}\' nije moguće obrisati!';
$string['nocontext'] = 'Ovo nije valjan kontekst';
$string['nodata'] = 'Nema podataka';
$string['noexistingcategory'] = 'Nema kategorije';
$string['nofile'] = 'Datoteka nije specificirana';
$string['nofiltersenabled'] = 'Nijedan filtar nije omogućen.';
$string['nofolder'] = 'Tražena mapa ne postoji';
$string['noformdesc'] = 'Za ovu aktivnost nije pronađena formslib datoteka s opisom obrasca';
$string['noguest'] = 'Nema gostiju!';
$string['noinstances'] = 'U ovom kolegiju nema instanci od: {$a}';
$string['nologinas'] = 'Ne možete se prijaviti kao ovaj korisnik';
$string['nonmeaningfulcontent'] = 'Besmislen sadržaj';
$string['noparticipants'] = 'Na ovom kolegiju nema sudionika';
$string['noparticipatorycms'] = 'Nažalost, nema modula koji podržavaju izradu izvještaja';
$string['nopermissions'] = 'Trenutno nemate ovlasti da napravite ({$a})';
$string['nopermissiontocomment'] = 'Ne možete komentirati';
$string['nopermissiontodelentry'] = 'Ne možete brisati tuđe zapise!';
$string['nopermissiontoeditcomment'] = 'Ne možete uređivati komentare drugih korisnika!';
$string['nopermissiontohide'] = 'Nemate ovlasti za skrivanje!';
$string['nopermissiontoimportact'] = 'Nemate ovlasti potrebne za unos aktivnosti u ovaj kolegij';
$string['nopermissiontolock'] = 'Nemate ovlasti za zaključavanje!';
$string['nopermissiontomanagegroup'] = 'Nemate ovlasti potrebne za uređivanje grupa';
$string['nopermissiontorate'] = 'Ocjenjivanje stavki nije dopušteno!';
$string['nopermissiontoshow'] = 'Nemate ovlasti za pregled ovoga!';
$string['nopermissiontounlock'] = 'Nemate ovlasti za otključavanje!';
$string['nopermissiontoupdatecalendar'] = 'Trenutno nemate ovlasti nadogradnje događaja u kalendaru';
$string['nopermissiontoviewgrades'] = 'Ne možete vidjeti ocjene.';
$string['nopermissiontoviewletergrade'] = 'Nemate ovlasti za pregled ocjena u obliku slova';
$string['nopermissiontoviewpage'] = 'Nemate ovlasti za pregled ove stranice';
$string['nosite'] = 'Nije moguće pronaći kolegij najviše razine';
$string['nositeid'] = 'Ne postoji ID sustava';
$string['nostatstodisplay'] = 'Nema raspoloživih podataka za prikaz';
$string['notallowedtoupdateprefremotely'] = 'Ne možete na daljinu nadograditi ovu korisničku postavku';
$string['notavailable'] = 'Ova opcija trenutno nije moguća';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Niste član ove grupe';
$string['notownerofkey'] = 'Vi niste vlasnik ovog ključa';
$string['nousers'] = 'Korisnik ne postoji!';
$string['onlyadmins'] = 'To mogu samo administratori';
$string['onlyeditingteachers'] = 'To mogu samo nastavnici (s ovlastima za izmjenu)';
$string['onlyeditown'] = 'Možete mijenjati samo osobne podatke';
$string['orderidnotfound'] = 'ID narudžbe {$a} nije pronađen';
$string['pagenotexist'] = 'Dogodila se neobična pogreška (zatražena je stranica koja ne postoji)';
$string['pathdoesnotstartslash'] = 'Nisu predani valjani argumenti, put ne počinje s kosom crtom /';
$string['pleasereport'] = 'Ako imate vremena, molimo opišite nam što ste pokušavali napraviti kada je došlo do pogreška:';
$string['pluginrequirementsnotmet'] = 'Dodatak "{$a->pluginname}" ({$a->pluginversion}) nije moguće instalirati. Zahtijeva noviju inačicu Moodle-a (trenutno koristite
{$a->currentmoodle}, a trebate {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Pogreška: prefiks tablice u bazi ne može biti prazan ({$a})</p> <p>Administrator sjedišta mora riješiti ovaj problem.</p>';
$string['prefixtoolong'] = '<p>Pogreška: prefiks tablice u bazi je predugačak ({$a->dbfamily})</p> <p>Administrator sjedišta mora riješiti ovaj problem. Najveći broj znakova prefiksa tablice u {$a->dbfamily} je {$a->maxlength} .</p>';
$string['processingstops'] = 'Obrada sad prestaje. Preostali zapisi su zanemareni.';
$string['querystringcannotbeempty'] = 'Niz s upitom ne može biti prazan.';
$string['redirecterrordetected'] = 'Otkriveno je prosljeđivanje koje nije podržano, izvođenje skripte je prekinuto';
$string['refoundto'] = 'Može se refundirati za {$a}';
$string['refoundtoorigi'] = 'Refundirano na izvorni iznos: {$a}';
$string['remotedownloaderror'] = 'Nije uspjelo preuzimanje komponente na poslužitelj, provjerite postavke proxyja. Preporuča se uporaba PHP cURL dodatka.<br /><br />Ručno preuzmite datoteku s <a href="{$a->url}">{$a->url}</a> iskopirajte ju u "{$a->dest}" na poslužitelju i raspakirajte.';
$string['remotedownloadnotallowed'] = 'Nije dopušteno preuzimanje komponenata na poslužielj (allow_url_fopen opcija nije omogućena).<br /><br />Ručno preuzmite <a href="{$a->url}">{$a->url}</a> kopirajte ga u "{$a->dest}" na serveru i raspakirajte.';
$string['reportnotavailable'] = 'Ova vrsta izvještaja je dostupna samo za kolegij sjedišta';
$string['requirecorrectaccess'] = 'Neispravan URL ili port.';
$string['requireloginerror'] = 'Tečaj ili aktivnost nisu dostupni.';
$string['restore_path_element_missingmethod'] = 'Metoda za vraćanje {$a} ne postoji. Mora ju definirati programer.';
$string['restore_path_element_noobject'] = 'Objekt za vraćanje {$a} nije objekt.';
$string['restrictedcontextexception'] = 'Izvođenje vanjskih funkcija krši restrikcije konteksta.';
$string['restricteduser'] = 'Vaš trenutni korisnički račun "{$a}" nema ovlasti za tu akciju';
$string['reverseproxyabused'] = 'Omogućen je obrnuti proxy, poslužitelju se ne može izravno pristupiti. <br />Javite se administratoru sjedišta.';
$string['rpcerror'] = 'Ooops! Došlo je do problema u MNet komunikaciji! Proslijedite ovu poruku administratoru: {$a}';
$string['scheduledbackupsdisabled'] = 'Administrator sjedišta je onemogućio planirane backupe';
$string['secretalreadyused'] = 'Poveznica za potvrdu promjene lozinke je već iskorištena. Lozinka nije promijenjena.';
$string['sectionnotexist'] = 'Ova sekcija ne postoji';
$string['sendmessage'] = 'Slanje poruke';
$string['serverconnection'] = 'Pogreška pri spajanju na poslužitelj';
$string['servicedonotexist'] = 'Servis ne postoji';
$string['sessioncookiesdisable'] = 'Neispravna uporaba funkcije require_key_login() - kolačići sesije moraju biti onemogućeni!';
$string['sessiondiskfull'] = 'Particija za čuvanje sesija je puna. Prijava trenutno nije moguća. <br /><br />Obavijestite administratora sjedišta.';
$string['sessionerroruser'] = 'Vaša sesija je istekla. Molimo prijavite se ponovno sustavu.';
$string['sessionerroruser2'] = 'Pogreška na poslužitelju koja utječe na vašu trenutnu sesiju je otkrivena. Molimo, prijavite se opet ili ponovno pokrenite internet preglednik.';
$string['sessionipnomatch2'] = 'Čini se da vaša IP adresa promijenila nakon prve prijave. Ova sigurnosna mogućnost sprječava krađu identiteta dok ste prijavljenji na ovo sjedište. Ovu pogrešku možda vidite ako ste prijavljeni na bežičnu mrežu ili ako u roamingu prelazite s jedne mreže na drugu. Obratite se administratoru sjedišta za pomoć. <br /><br /> Ako želite nastaviti, pritisnite F5 za ponovno učitavanje stranice.';
$string['sessionwaiterr'] = 'Isteklo je vrijeme čekanja na zaključavanje sesije.<br />Pričekajte da se završe vaši trenutni zahtjevi te pokušajte ponovno kasnije.';
$string['shortnametaken'] = 'Kraticu otprije koristi drugi kolegij';
$string['socksnotsupported'] = 'SOCKS5 proxy nije podržan u PHP4';
$string['spellcheckernotconf'] = 'Provjera pravopisa nije podešena';
$string['sslonlyaccess'] = 'Zbog sigurnosnih razloga dostupna je samo veza preko https.';
$string['statscatchupmode'] = 'Statistika je trenutno u modu osvježavanja podataka. Trenutno procesirano broj dana je: {$a->daysdone} a broj dana koji preostaje je: {$a->dayspending} Ponovno provjerite uskoro!';
$string['statsdisable'] = 'Statistika nije omogućena.';
$string['statsnodata'] = 'Nema dostupnih podataka za ovu kombinaciju kolegija i vremenskog trajanja';
$string['storedfilecannotcreatefiledirs'] = 'Nije moguće stvoriti lokalne mape pool datoteka, provjerite ovlasti u dataroot.';
$string['storedfilecannotread'] = 'Nije moguće pročitati datoteku. Datoteka ili ne postoji ili postoje problemi s ovlastima.';
$string['storedfilenotcreated'] = 'Nije moguće stvoriti datoteku "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}"';
$string['storedfileproblem'] = 'Nepoznata pogreška vezana za lokalne datoteke ({$a})';
$string['tagdisabled'] = 'Oznake su onemogućene!';
$string['tagnotfound'] = 'Navedena oznaka nije pronađena u bazi podataka';
$string['targetdatabasenotempty'] = 'Odredišna baza podataka nije prazna. Prijenos je prekinut radi sigurnosnih razloga.';
$string['textconditionsnotallowed'] = 'Usporedba uvjeta tekstualnih stupaca nije dopuštena. Koristite sql_compare_text() u vašem upitu.';
$string['themenotinstall'] = 'Ova tema nije instalirana!';
$string['TODO'] = 'TODO';
$string['tokengenerationfailed'] = 'Nije moguće stvoriti novi token.';
$string['transactionvoid'] = 'Nije moguće poništiti transakciju jer je već poništena';
$string['unenrolerror'] = 'Došlo je do pogreške prilikom pokušaja ispisivanja te osobe';
$string['unknowaction'] = 'Nepoznata akcija!';
$string['unknowcategory'] = 'Nepoznata kategorija!';
$string['unknowcontext'] = 'Ovo je nepoznati kontekst ({$a}) u get_child_contexts!';
$string['unknowformat'] = 'Nepoznat oblik ({$a})';
$string['unknownbackupexporterror'] = 'Nepoznata pogreška pri pripremanju podataka za uvoz';
$string['unknownblockregion'] = 'Regija bloka \'{$a}\' nije prepoznata na ovoj stranici.';
$string['unknowncontext'] = 'Nepoznat kontekst.';
$string['unknowncourse'] = 'Ne postoji kolegij pod nazivom "{$a}"';
$string['unknowncourseidnumber'] = 'Nepoznati ID kolegija "{$a}"';
$string['unknowncourserequest'] = 'Nepoznat zahtjev za otvaranje novog kolegija';
$string['unknowncoursesection'] = 'Nepoznat odjeljak kolegija u kolegiju "{$a}"';
$string['unknownfiletype'] = 'Pogreška, nepoznata vrsta filtra';
$string['unknowngroup'] = 'Nepoznata grupa "{$a}"';
$string['unknownhelp'] = 'Nepoznata tema pomoći {$a}';
$string['unknownjsinrequirejs'] = 'Nij emoguće pronaći JS biblioteku: {$a}';
$string['unknownmodulename'] = 'Nepoznati naziv modula za obrazac';
$string['unknownrole'] = 'Nepoznata uloga "{$a}"';
$string['unknownsortcolumn'] = 'Nepoznati stupac za sortiranje {$a}';
$string['unknownuseraction'] = 'Nepoznata operacija korisnika';
$string['unknownuserselector'] = 'Nepoznata opcija za odabir korisnika';
$string['unknoworder'] = 'Nepoznati redoslijed';
$string['unknowparamtype'] = 'Nepoznata vrsta parametra {$a}';
$string['unknowquestiontype'] = 'Nepodržana vrsta pitanja {$a}';
$string['unknowuploadaction'] = 'Pogreška: Nepoznata akcija za prijenos na poslužitelj ({$a})';
$string['unspecifycourseid'] = 'Potrebno je odrediti ID kolegija, kratki naziv ili idbroj';
$string['unsupportedevent'] = 'Nepodržana vrsta događaja';
$string['unsupportedstate'] = 'Nepodržan status dovršenosti';
$string['unsupportedwebserver'] = 'Web server softver ({$a}) nažalost nije podržan.';
$string['upgraderequires19'] = 'Pogreška: Nova inačica Moodle-a je instalirana. Nažalost, nadogradnja s prethodne inačice nije podržana.<br />Prvo nadogradite na zadnju inačicu 1.9.x. Na prethodnu se inačicu možete vratiti ponovnom instalacijom izvornih datoteka.';
$string['upgraderunning'] = 'Sustav je u postupku nadogradnje, molimo pokušajte kasnije.';
$string['urlnotdefinerss'] = 'Nije zadan URL za RSS kanal';
$string['useradmineditadmin'] = 'Samo administratori mogu mijenjati druge administratorske korisničke račune';
$string['useradminodelete'] = 'Administratorski korisnički računi ne mogu biti izbrisani.';
$string['userautherror'] = 'Nepoznat autorizacijski dodatak';
$string['userauthunsupported'] = 'Autorizacijski dodatak nije podržan ovdje';
$string['useremailduplicate'] = 'Dupla adresa';
$string['usermustbemnet'] = 'Korisnici u MNet popisu kontrole pristupa moraju biti udaljeni MNet korisnici';
$string['usernotaddederror'] = 'Korisnik nije dodan - nepoznata pogreška';
$string['usernotaddedregistered'] = 'Korisnik nije dodan - već je registriran otprije';
$string['usernotavailable'] = 'Detaljne informacije o ovom korisniku vam nisu dostupne.';
$string['usernotdeletedadmin'] = 'Korisnik nije izbrisana - nije moguće izbrisati administratorske korisničke račune';
$string['usernotdeletederror'] = 'Korisnik nije izbrisan - nepoznata pogreška';
$string['usernotdeletedmissing'] = 'Korisnik nije izbrisan - korisničko ime nije pronađeno';
$string['usernotdeletedoff'] = 'Korisnik nije izbrisan - brisanje nije dopušteno.';
$string['usernotincourse'] = 'Ovaj korisnik nije na ovom kolegiju!';
$string['usernotrenamedadmin'] = 'Nije moguće preimenovati admin korisnički račun';
$string['usernotrenamedexists'] = 'Korisnik nije preimenovan - novo korisničko ime je već u uporabi';
$string['usernotrenamedmissing'] = 'Korisnik nije preimenovan - nije bilo moguće pronaći staro korisničko ime';
$string['usernotrenamedoff'] = 'Korisnik nije preimenovan - preimenovanje nije dopušteno';
$string['usernotupdatedadmin'] = 'Nije moguće nadograditi admin korisničke račune';
$string['usernotupdatederror'] = 'Korisnički račun nije nadograđen - pogreška';
$string['usernotupdatednotexists'] = 'Korisnički račun nije nadograđen - ne postoji';
$string['userquotalimit'] = 'Dostigli ste svoju kvotu - memorijsko ograničenje.';
$string['userselectortoomany'] = 'user_selector je dobio više od jednog odabranog korisnika, iako nije omogućen višestruki odabir.';
$string['wrongcall'] = 'Skripta je pogrešno pozvana';
$string['wrongcontextid'] = 'ID konteksta nije valjan (nije ga moguće pronaći)';
$string['wrongdestpath'] = 'Pogrešna odredišna putanja.';
$string['wrongroleid'] = 'Netočan ID uloge!';
$string['wrongsourcebase'] = 'Pogrešna baza izvornog URL-a';
$string['wrongusernamepassword'] = 'Pogrešno korisničko ime / lozinka';
$string['wrongzipfilename'] = 'Pogrešno ime ZIP datoteke';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Nije moguće stvoriti kolegij - Nema ovlasti';
$string['wwwrootmismatch'] = 'Otkriven je pogrešan pristup, ovom je poslužitelju moguće pristupiti jedino preko adrese "{$a}". <br />Obavijestite administratora sjedišta.';
$string['wwwrootslash'] = 'Otkriven je pogrešan $CFG->wwwroot u datoteci config.php, ne smije sadržavati slash ( / ) na početku.<br />Obavijestite administratora sjedišta.';
$string['xmldberror'] = 'XMLDB pogreška!';
$string['youcannotdeletecategory'] = 'Ne možete izbrisati kategoriju \'{$a}\' jer niti možete izbrisati njen sadržaj, niti ga možete negdje premjestiti.';
