<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_shibboleth', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_shibboleth
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_shib_auth_method'] = 'Naziv autentikacijske metode';
$string['auth_shib_auth_method_description'] = 'Navedite naziv Shibboleth autentikacijskog načina koji je poznat vašim korisnicima. Ovo može biti naziv vaše Shibboleth federacije, npr. <tt>SWITCHaai prijava</tt>, <tt>InCommon prijava</tt> ili nešto slično.';
$string['auth_shibboleth_errormsg'] = 'Odaberite organizaciju kojoj pripadate!';
$string['auth_shibboleth_login'] = 'Shibboleth korisničko ime';
$string['auth_shibboleth_login_long'] = 'Prijava na Moodle preko Shibboleth';
$string['auth_shibboleth_manual_login'] = 'Ručna prijava';
$string['auth_shibboleth_select_member'] = 'Član sam...';
$string['auth_shibboleth_select_organization'] = 'Za autentikaciju preko Shibboleth-a, odaberite vašu instituciju s padajućeg izbornika:';
$string['auth_shib_changepasswordurl'] = 'URL za promjenu lozinke';
$string['auth_shib_convert_data'] = 'API za izmjenu podataka';
$string['auth_shib_convert_data_description'] = 'Možete koristiti ovaj API za daljnje izmjene podataka od strane Shibboleth-a. Pročitajte <a href="../auth/shibboleth/README.txt">README</a> za opširnije upute.';
$string['auth_shib_convert_data_warning'] = 'Ova datoteka ne postoji ili nije čitljiva od strane procesa web poslužitelja.';
$string['auth_shib_idp_list'] = 'Pružatelj identiteta';
$string['auth_shib_idp_list_description'] = 'Pružite popis entityID pružatelja identiteta kako bi omogućili korisnicima odabir istih na stranici za prijavu.<br/>U svakom redu treba stajati zarezima odvojeni \'tuple\' za entityID pružatelja usluge (pročitajte Shibboleth datoteku o metapodacima) i naziv pružatelja identiteta, jer će potonji biti ispisan na padajućem izborniku.<br/>Kao opcionalni treći parametar možete dodati lokaciju inicijatora Shibboleth sesije koji će se koristiti ako je vaša Moodle instalacija dio više-federacijskog sustava.';
$string['auth_shib_instructions'] = 'Koristite <a href="{$a}">Shibboleth korisnički račun</a> kako bi pristupili putem Shibboleth-a ako ga vaša institucija podržava.<br/>U suprotnome, koristite uobičajeni obrazac za prijavu prikazan ovdje.';
$string['auth_shib_instructions_help'] = 'Ovdje trebate pružiti prilagođene upute za vaše korisnike koje pojašnjavaju korištenje Shibboleth-a. Iste će biti prikazane na stranici za prijavu. Upute moraju sadržavati i poveznicu na "<b>{$a}</b>" na koju korisnici moraju kliknuti kako bi se prijavili.';
$string['auth_shib_integrated_wayf'] = 'Moodle WAYF servis';
$string['auth_shib_integrated_wayf_description'] = 'Ako ovo omogućite, Moodle će koristiti svoju vlastitu WAYF uslugu umjesto one koja je zadana za Shibboleth. Moodle će prikazati padajući izbornik iz kojeg će korisnik moći odabrati svog pružatelja identiteta.';
$string['auth_shib_logout_return_url'] = 'Alternativni URL nakon odjave';
$string['auth_shib_logout_return_url_description'] = 'Zadajte URL na koji će Shibboleth korisnici biti preusmjereni nakon odjave.<br/>Ako je ostavljeno prazno, korisnici će biti preusmjereni na lokaciju na koju se inače preusmjeravaju Moodle korisnici';
$string['auth_shib_logout_url'] = 'URL nakon odjave (Shibboleth SP)';
$string['auth_shib_logout_url_description'] = 'Zadajte URL nakon odjave sa Shibboleth SP. Obično glasi <tt>/Shibboleth.sso/Logout</tt>';
$string['auth_shib_no_organizations_warning'] = 'Ako želite koristiti integriranu WAYF uslugu, morate zadati popis odvojen zarezima koji sadrži entityID vrijednosti Pružatelja identiteta, njihove nazive i opcionalno inicijator sesije.';
$string['auth_shib_only'] = 'Samo Shibboleth';
$string['auth_shib_only_description'] = 'Omogućite ovu opciju ako je Shibboleth autentikacija obvezna';
$string['auth_shib_username_description'] = 'Naziv webserver Shibboleth varijable koja će biti korištena kao Moodle korisničko ime';
$string['pluginname'] = 'Shibboleth';
$string['shib_no_attributes_error'] = 'Izgleda ste prijavljeni preko Shibboleth-a, ali Moodle nije dobio nikakve korisničke atribute. Provjerite šalje li vaš pružatelj identiteta neophodne atribute ({$a}) prema pružatelju usluge na kojem se nalazi Moodle ili obavijestite webmastera ovog poslužitelja.';
$string['shib_not_all_attributes_error'] = 'Moodle treba određene Shibboleth atribute koji nisu prisutni u vašem slučaju. Ti atributi su: {$a}<br/>Kontaktirajte webmastera ovog poslužitelja ili vašeg pružatelja identiteta.';
$string['shib_not_set_up_error'] = 'Autentikacija Shibboleth-om izgleda nije ispravno podešena jer na ovoj stranici nema nijedne Shibboleth varijable okruženja. Pročitajte <a href="README.txt">README</a> za opširnije informacije o tome kako podesiti Shibboleth autentikaciju ili kontaktirajte administratora Moodle-a.';
