<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   auth_ldap
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Nije moguće stvoriti novi korisnički račun u AD. Provjerite zadovoljavate li sve potrebne zahtjeve (LDAPS veza, bind korisnik s odgovarajućim ovlastima i slično).';
$string['auth_ldap_attrcreators'] = 'Popis grupa ili konteksta čiji članovi mogu stvarati atribute. Odvojite grupe s \';\'. Obično nešto poput \'cn=nastavnici, ou=zaposlenici, o=mojfakultet\'';
$string['auth_ldap_attrcreators_key'] = 'Autori atributa';
$string['auth_ldap_auth_user_create_key'] = 'Stvori korisnike eksterno';
$string['auth_ldap_bind_dn'] = 'Ako želite koristiti bind-korisnika za traženje korisnika, zadajte ga ovdje. Npr. \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'DN (Razlikovno ime)';
$string['auth_ldap_bind_pw'] = 'Lozinka za bind-korisnika.';
$string['auth_ldap_bind_pw_key'] = 'Lozinka';
$string['auth_ldap_bind_settings'] = 'Bind postavke';
$string['auth_ldap_changepasswordurl_key'] = 'URL za promjenu lozinke';
$string['auth_ldap_contexts'] = 'Popis konteksta u kojima su smješteni korisnici. Odvojite različite kontekste s \';\'. Npr. \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_contexts_key'] = 'Konteksti';
$string['auth_ldap_create_context'] = 'Ako omogućite stvaranje korisnika s potvrđivanjem e-poštom, morate zadati kontekst gdje će se korisnici stvarati. Ovaj kontekst bi trebao biti različit od ostalih korisnika kako bi se izbjegli sigurnosni problemi. Ne morate dodavati ovaj kontekst u ldap_context-variable, Moodle će automatski tražiti korisnike iz ovog konteksta.<br/><b>Napomena!</b>Morate izmijeniti način user_create() u datoteci auth/ldap/auth.php kako bi radilo stvaranje novih korisnika.';
$string['auth_ldap_create_context_key'] = 'Kontekst za nove korisnike';
$string['auth_ldap_create_error'] = 'Pogreška pri stvaranju korisnika u LDAP-u.';
$string['auth_ldap_creators'] = 'Popis grupa ili konteksta čiji članovi mogu stvarati nove kolegije. Odvojite grupe s \';\'. Obično nešto poput \'cn=nastavnici, ou=zaposlenici, o=mojfakultet\'';
$string['auth_ldap_creators_key'] = 'Autori';
$string['auth_ldapdescription'] = 'Ovaj način pruža autentikaciju putem vanjskog LDAP poslužitelja.
Ako su pruženo korisničko ime i lozinka valjani, Moodle će stvoriti zapis o novom korisniku u bazi podataka. Ovaj modul može čitati korisničke atribute iz LDAP-a i upisati ih u željena polja u Moodle bazi podataka. Za dotične korisničke račune provjerava se samo korisničko ime i lozinka.';
$string['auth_ldap_expiration_desc'] = 'Odaberite Ne kako bi onemogućili provjeru isteka lozinke ili to da LDAP čita vrijeme zadano u passwordexpiration direktno iz LDAP-a';
$string['auth_ldap_expiration_key'] = 'Istek';
$string['auth_ldap_expiration_warning_desc'] = 'Broj dana prije nego se izda upozorenje o isteku lozinke.';
$string['auth_ldap_expiration_warning_key'] = 'Upozorenje o isteku';
$string['auth_ldap_expireattr_desc'] = 'Opcionalno: nadjačava LDAP-atribut koji sadržava vrijeme isteka lozinke';
$string['auth_ldap_expireattr_key'] = 'Atribut isteka';
$string['auth_ldapextrafields'] = 'Ova polja su opcionalna. Možete odabrati punjenje nekih od tih Moodle korisničkih polja iz <b>LDAP polja</b> koja zadate ovdje. <p>Ako ostavite ova polja praznima, onda ništa neće biti prenešeno iz LDAP-a i bit će korištene Moodle zadane vrijednosti.</p><p>U svakom slučaju, korisnik će moći urediti sva ta polja nakon prijave sustavu.</p>';
$string['auth_ldap_graceattr_desc'] = 'Opcionalno: Nadjačava atribut \'gracelogin\'';
$string['auth_ldap_gracelogin_key'] = 'Atribut \'grace\' prijava';
$string['auth_ldap_gracelogins_desc'] = 'Omogućite LDAP \'gracelogin\' podršku. Nakon što lozinka istekne korisnik se može prijavljivati dok \'gracelogin\' vrijednost ne dođe do 0. Omogućavanje ove postavke prikazuje poruku o tome da se koriste \'grace\' prijave nakon isteka lozinke.';
$string['auth_ldap_gracelogins_key'] = '\'Grace\' prijave';
$string['auth_ldap_groupecreators'] = 'Popis grupa ili konteksta čijim članovima je dopušteno stvaranje grupa. Odvojite višestruke grupe s \';\'. Obično nešto poput \'cn=nastavnici,ou=zaposlenici,o=mojfakultet\'';
$string['auth_ldap_groupecreators_key'] = 'Autori grupa';
$string['auth_ldap_host_url'] = 'Zadajte LDAP poslužitelj u obliku URL-a \'ldap://ldap.mojfakultet.hr/\' ili \'ldaps://ldap.mojfakultet.hr/\' Odvojite višestruke poslužitelje s \';\' kako bi imali <i>failover</i> podršku.';
$string['auth_ldap_host_url_key'] = 'URL poslužitelja';
$string['auth_ldap_ldap_encoding'] = 'Odredite kodnu stranicu koju koristi vaš LDAP poslužitelj. Najvjerojatnije se radi o UTF-8; MS AD v2 obično koristi zadanu kodnu stranicu na platformi, kao što je cp1252, cp1250 i slično.';
$string['auth_ldap_ldap_encoding_key'] = 'Kodna stranica LDAP-a';
$string['auth_ldap_login_settings'] = 'Postavke za prijavu';
$string['auth_ldap_memberattribute'] = 'Opcionalno: nadjačava atribut članstva korisnika, kada korisnik pripada grupi. Obično \'član\'.';
$string['auth_ldap_memberattribute_isdn'] = 'Opcionalno: nadjačava rukovanje vrijednostima atributa članstva, bilo 0 ili 1.';
$string['auth_ldap_memberattribute_isdn_key'] = 'Korisnički atribut koristi DN';
$string['auth_ldap_memberattribute_key'] = 'Korisnički atribut';
$string['auth_ldap_noconnect'] = 'LDAP-modul se ne može povezati na poslužitelj: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-modul se ne može povezati ni na jedan poslužitelj: {$a}';
$string['auth_ldap_noextension'] = '<em>PHP LDAP modul izgleda nije prisutan. Provjerite je li instaliran i omogućen ako želite koristiti ovaj autentikacijski dodatak.</em>';
$string['auth_ldap_no_mbstring'] = 'Potrebna vam je mbstring ekstenzija kako bi mogli stvarati korisnike u AD.';
$string['auth_ldapnotinstalled'] = 'Ne možete koristiti LDAP autentikaciju. PHP LDAP modul nije instaliran.';
$string['auth_ldap_objectclass'] = 'Opcionalno: Nadjačava objectClass koji se koristi za imenovanje/traženje korisnika preko ldap_user_type. Obično ovo ne morate mijenjati.';
$string['auth_ldap_objectclass_key'] = 'Razred objekta';
$string['auth_ldap_opt_deref'] = 'Određuje kako se rukuje aliasima prilikom traženja. Odaberite jednu od slijedećih vrijednosti: "Ne" (LDAP_DEREF_NEVER) ili "Da" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Dereferencirajući aliasi';
$string['auth_ldap_passtype'] = 'Odredite oblik novih ili promijenjenih lozinki na LDAP poslužitelju.';
$string['auth_ldap_passtype_key'] = 'Oblik lozinke';
$string['auth_ldap_passwdexpire_settings'] = 'Postavke isteka LDAP lozinke';
$string['auth_ldap_preventpassindb'] = 'Odaberite DA kako bi spriječili pohranu lozinki u bazu podataka Moodle-a.';
$string['auth_ldap_preventpassindb_key'] = 'Skrij lozinke';
$string['auth_ldap_search_sub'] = 'Traži korisnike u podkontekstima';
$string['auth_ldap_search_sub_key'] = 'Traži u podkontekstima';
$string['auth_ldap_server_settings'] = 'Postavke LDAP poslužitelja';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() ne podržava odabranu vrstu korisnika: {$a}';
$string['auth_ldap_update_userinfo'] = 'Osvježite korisničke podatke (ime, prezime, adresa...) iz LDAP-a u Moodle. Zadajte postavku \'Mapiranje podataka\' po potrebi.';
$string['auth_ldap_user_attribute'] = 'Opcionalo: Nadjačava atribut koji se koristi za imenovanje/traženje korisnika. Obično \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Atribut korisnika';
$string['auth_ldap_user_exists'] = 'LDAP korisničko ime već postoji.';
$string['auth_ldap_user_settings'] = 'Postavke traženja korisnika';
$string['auth_ldap_user_type'] = 'Odaberite kako se korisnici pohranjuju u LDAP-u. Ova postavka također određuje kako će raditi istek valjanosti korisničkog imena, grace login i stvaranje korisničkih računa.';
$string['auth_ldap_user_type_key'] = 'Vrsta korisnika';
$string['auth_ldap_usertypeundefined'] = 'config.user_type nije zadan ili funkcija ldap_expirationtime2unix ne podržava odabranu vrstu!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type nije zadan ili funkcija ldap_unixi2expirationtime ne podržava odabranu vrstu!';
$string['auth_ldap_version'] = 'Inačica protokola LDAP koju koristi vaš poslužitelj.';
$string['auth_ldap_version_key'] = 'Inačica';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Postavite na \'Da\' kako bi pokušali SSO na NTLM domenu. <strong>Napomena:</strong> ovo zahtijeva dodatno podešavanje na web poslužitelju, pročitajte <a href="http://docs.moodle.org/en/NTLM_authentication">http://docs.moodle.org/en/NTLM_authentication</a>';
$string['auth_ntlmsso_enabled_key'] = 'Omogući';
$string['auth_ntlmsso_ie_fastpath'] = 'Postavite na \'Da\' kako bi omogućili NTLM SSO fast path (preskače pojedine korake i radi samo ako je klijentski preglednik MS IE).';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE fast path?';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Nije moguće izvući korisničko ime iz zaglavlja REMOTE_USER. Je li podešeni oblik ispravan?';
$string['auth_ntlmsso_missing_username'] = 'Morate navesti barem %username% u obliku udaljenog korisničkog imena';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Oblik udaljenog korisničkog imena';
$string['auth_ntlmsso_subnet'] = 'Ako je postavljeno, samo će se pokušavati SSO s klijentima u ovom subnet-u. Oblik: xxx.xxx.xxx.xxx/bitmask';
$string['auth_ntlmsso_subnet_key'] = 'Subnet';
$string['auth_ntlmsso_type'] = 'Autentikacijski način podešen na razini web poslužitelja za prijavljivanje korisnika (ako ste u dvojbi, odaberite NTLM)';
$string['auth_ntlmsso_type_key'] = 'Vrsta autentikacije';
$string['connectingldap'] = 'Spajanje na LDAP poslužitelj...';
$string['creatingtemptable'] = 'Stvaranje privremene tablice {$a}';
$string['didntfindexpiretime'] = 'password_expire() nije pronašao vrijeme isteka.';
$string['didntgetusersfromldap'] = 'Nije dohvaćen nijedan korisnik iz LDAP-a -- pogreška? -- izlaz';
$string['gotcountrecordsfromldap'] = 'Broj zapisa dohvaćenih iz LDAP-a: {$a}';
$string['morethanoneuser'] = 'Čudno! Pronađeno je više od jednog zapisa o korisniku u LDAP-u. Koristi se samo prvi. ';
$string['needbcmath'] = 'BCMath ekstenzija je neophodna za korištenje tzv. \'grace prijava\' s AD.';
$string['needmbstring'] = 'Ako želite mijenjati lozinke u Active Directory, potrebna vam je mbstring ekstenzija ';
$string['nodnforusername'] = 'Pogreška u user_update_password(). Ne postoji DN za: {$a->username}';
$string['noemail'] = 'Slanje poruke e-pošte nije uspjelo!';
$string['notcalledfromserver'] = 'Ne bi trebalo biti pozivano s web poslužitelja!';
$string['noupdatestobedone'] = 'Nema osvježenja';
$string['nouserentriestoremove'] = 'Nema korisničkih zapisa koje treba ukloniti';
$string['nouserentriestorevive'] = 'Nema korisničkih računa za oživljavanje';
$string['nouserstobeadded'] = 'Nije dodan nijedan korisnik';
$string['ntlmsso_attempting'] = 'Pokušavam SSO preko NTLM...';
$string['ntlmsso_failed'] = 'Automatska prijava nije uspjela, pokušajte prijavu na uobičajenoj stranici za prijavu...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO je onemogućen.';
$string['ntlmsso_unknowntype'] = 'Nepoznati ntlmsso tip!';
$string['pagedresultsnotsupp'] = 'LDAP stranični prikaz rezultata nije podržan (vašoj inačici PHP-a nedostaje podrška ili ste podesili Moodle da koristi inačicu 2 LDAP protokola)';
$string['pagesize_key'] = 'Veličina stranice';
$string['pluginname'] = 'LDAP';
$string['pluginnotenabled'] = 'Dodatak nije omogućen!';
$string['renamingnotallowed'] = 'Preimenovanje korisnika nije dopušteno u LDAP-u';
$string['rootdseerror'] = 'Pogreška pri slanju upita rootDSE za Active Directory';
$string['start_tls'] = 'Koristi standardni LDAP servis (port 389) s TLS enkripcijom';
$string['start_tls_key'] = 'Koristi TLS';
$string['updatepasserror'] = 'Pogreška u user_update_password(). Kôd pogreške: {$a->errno}; Tekst pogreške: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Pogreška u user_update_password() pri čitanju vremena isteka lozinke. K	ôd pogreške: {$a->errno}; Tekst pogreške: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Pogreška u user_update_password() pri mijenjanju expirationtime i/ili gracelogins. Kôd pogreške: {$a->errno}; Tekst pogreške: {$a->errstring}';
$string['updateremfail'] = 'Pogreška pri osvježavanju LDAP zapisa. Kôd pogreške: {$a->errno}; Tekst pogreške: {$a->errstring}<br/>Ključ ({$a->key}) - stara moodle vrijednost: \'{$a->ouvalue}\' nova vrijednost: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Nije uspjelo osvježavanje LDAP-a s dvosmislenim poljem {$a->key}; stara moodle vrijednost: \'{$a->ouvalue}\' nova vrijednost: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Nije bilo moguće pronaći korisnika prilikom osvježavanja vanjskog izvora. Detalji: search base: \'{$a->userdn}\'; search filter: \'(objectClass=*)\'; search attributes: {$a->attribs}';
$string['useracctctrlerror'] = 'Pogreška pri dohvatu userAccountControl za {$a}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ne podržava odabranu vrstu korisnika: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ne podržava odabranu vrstu korisnika: {$a}';
$string['userentriestoadd'] = 'Korisnički zapisi koji će biti dodani: {$a}';
$string['userentriestoremove'] = 'Korisnički zapisi koji će biti uklonjeni: {$a}';
$string['userentriestorevive'] = 'Korisnički računi koji trebaju oživljavanje: {$a}';
$string['userentriestoupdate'] = 'Korisnički zapisi koji će biti nadograđeni: {$a}';
$string['usernotfound'] = 'Korisnik nije pronađen u LDAP-u.';
