<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assignment', language 'hr', branch 'MOODLE_26_STABLE'
 *
 * @package   assignment
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Postoje zadaće koje zahtijevaju vašu pažnju';
$string['addsubmission'] = 'Predaj zadaću';
$string['allowdeleting'] = 'Dopusti brisanje';
$string['allowdeleting_help'] = 'Ako je omogućeno, tada korisnici mogu brisati prenešene datoteke u bilo koje vrijeme prije ocjenjivanja.';
$string['allowmaxfiles'] = 'Najveći broj datoteka koji je moguće prenijeti';
$string['allowmaxfiles_help'] = 'Najveći broj datoteka koje se može prenijeti. Ovaj broj se ne prikazuje studentima, pa vas molimo da u tekstu zadaće navedete točan broj datoteka koje studenti mogu/moraju prenijeti.';
$string['allownotes'] = 'Dopusti bilješke';
$string['allownotes_help'] = 'Ako je omogućeno, tada studenti mogu unositi bilješke u za to predviđeno polje, nešto poput online zadaće.';
$string['allowresubmit'] = 'Dozvolite ponovno predavanje zadaće';
$string['allowresubmit_help'] = 'Ako je omogućeno, studenti mogu predati novu zadaću umjesto stare koja je već ocijenjena (pa će nova zadaća morati biti ocijenjena umjesto stare).';
$string['alreadygraded'] = 'Vaša zadaća je već ocijenjena i ponovno predavanje iste nije dozvoljeno.';
$string['assignment:addinstance'] = 'Dodaj novu zadaću';
$string['assignmentdetails'] = 'Detalji zadaće';
$string['assignment:exportownsubmission'] = 'Izvoz vlastite zadaće';
$string['assignment:exportsubmission'] = 'Izvoz zadaća';
$string['assignment:grade'] = 'Ocijeni zadaću';
$string['assignmentmail'] = '{$a->teacher} je objavio povratne informacije (feedback) o vasoj zadaci predanoj na osnovu zadatka pod nazivom \'{$a->assignment}\'.

Povratnu informaciju mozete vidjeti kao dodatak svojoj zadaci na ovoj adresi:

    {$a->url}';
$string['assignmentmailhtml'] = '{$a->teacher} je objavio povratne informacije (feedback) o vasoj zadaci predanoj na osnovu zadatka pod nazivom \'<i>{$a->assignment}</i>\'.<br /><br />

Povratnu informaciju mozete vidjeti kao dodatak svojoj zadaci na <a href="{$a->url}">ovoj adresi</a>.';
$string['assignmentmailsmall'] = '{$a->teacher} je poslao/la povratnu informaciju o vašoj predanoj zadaći \'{$a->assignment}\'. Navedena informacija je prikazana nakon vaše zadaće.';
$string['assignmentname'] = 'Naziv zadaće';
$string['assignmentsubmission'] = 'Predane zadaće';
$string['assignment:submit'] = 'Predaj zadaću';
$string['assignmenttype'] = 'Tip zadaće';
$string['assignment:view'] = 'Pregledaj zadaću';
$string['availabledate'] = 'Dostupna od';
$string['cannotdeletefiles'] = 'Dogodila se pogreška i nije bilo moguće obrisati datoteke ';
$string['cannotviewassignment'] = 'Ovu zadaću ne možete vidjeti';
$string['changegradewarning'] = 'Dio predanih zadaća je već ocijenjen, pa se promjenom ocjene te zadaće neće automatski ponovno ocijeniti. Morate ponovno ocijeniti sve već predane zadaće, ako želite promijeniti ocjenu.';
$string['closedassignment'] = 'Predaja radova za ovu zadaću je zatvorena i rok za predaju radova je istekao.';
$string['comment'] = 'Komentar';
$string['commentinline'] = 'Komentar unutar teksta';
$string['commentinline_help'] = 'Ako je omogućeno, onda će prilikom ocjenjivanja predani tekst biti kopiran u polje za povratne informacije, kako bi se nastavniku olakšalo komentiranje istog (npr. korištenjem druge boje) ili uređivati izvorni tekst.';
$string['configitemstocount'] = 'Vrsta objekata koji će biti uzimani u obzir kao predana zadaća.';
$string['configmaxbytes'] = 'Zadana maksimalna veličina za sve zadaće na poslužitelju (podložna dodatnim ograničenjima na razini pojedinog kolegija i ostalim lokalnim postavkama)';
$string['configshowrecentsubmissions'] = 'Svi mogu vidjeti obavijesti o predanim zadaćama u izvještaju o nedavnim aktivnostima.';
$string['confirmdeletefile'] = 'Želite li uistinu izbrisati ovu datoteku?<br /><strong>$a</strong>{$a}';
$string['coursemisconf'] = 'Kolegij nije ispravno podešen';
$string['currentgrade'] = 'Trenutno pohranjena ocjena';
$string['deleteallsubmissions'] = 'Obriši sve predane zadaće';
$string['deletefilefailed'] = 'Brisanje datoteke nije uspjelo.';
$string['description'] = 'Opis';
$string['downloadall'] = 'Pohrani sve zadaće na lokalno računalo';
$string['draft'] = 'Nacrt';
$string['due'] = 'Rok za predaju zdaće';
$string['duedate'] = 'Krajnji datum';
$string['duedateno'] = 'Bez krajnjeg datuma';
$string['early'] = '{$a} ranije';
$string['editmysubmission'] = 'Izmijeni moju zadaću';
$string['editthesefiles'] = 'Uredi ove datoteke';
$string['editthisfile'] = 'Osvježi ovu datoteku';
$string['emailstudents'] = 'Pošalji upozorenje studentima putem e-pošte';
$string['emailteachermail'] = '{$a->username} je izmijenio/predao svoju zadacu vezanu uz zadatak pod nazivom \'{$a->assignment}\' u {$a->timeupdated}

Ista je dostupna ovdje:
{$a->url}';
$string['emailteachermailhtml'] = '{$a->username} je izmijenio/predao svoju zadacu vezanu uz zadatak pod nazivom <i>\'{$a->assignment}\'</i> u {$a->timeupdated}</i><br /><br />Ista je dostupna na <a href="{$a->url}">ovoj adresi</a>.';
$string['emailteachers'] = 'Pošalji poruku e-pošte nastavniku za svaku predanu/izmijenjenu zadaću';
$string['emailteachers_help'] = 'Ako je omogućeno, nastavnici će dobiti obavijest porukom e-pošte kad studenti dodaju ili osvježe svoju zadaću.

Samo nastavnici koji imaju ovlasti za ocjenjivanje će dobiti navedenu obavijest. Tako da, na primjer, u kolegiju koji koristi odvojene grupe, nastavnici koji su ograničeni ovlastima nad pojedinom grupom, neće dobiti obavijest(i) o studentima iz drugih grupa.';
$string['emptysubmission'] = 'Još niste ništa predali';
$string['enablenotification'] = 'Pošalji poruku e-pošte s obavijesti';
$string['enablenotification_help'] = 'Ako je omogućeno, studenti će primiti poruku e-pošte kada njihova zadaća bude ocijenjena.';
$string['errornosubmissions'] = 'Nema predanih zadaća za preuzimanje';
$string['existingfiledeleted'] = 'Postojeća datoteka je obrisana: {$a}';
$string['failedupdatefeedback'] = 'Osvježavanje povratnih informacija za korisnika {$a} nije uspjelo.';
$string['feedback'] = 'Povratna informacija (Feedback)';
$string['feedbackfromteacher'] = 'Povratna informacija koju je pružio/la {$a}';
$string['feedbackupdated'] = 'Povratna informacija (Feedback) promijenjena za {$a} korisnika';
$string['finalize'] = 'Spriječi nadogradnju predanih zadaća';
$string['finalizeerror'] = 'Došlo je do pogreške zbog koje nije moguće predati zadaću';
$string['futureaassignment'] = 'Ova zadaća još nije dostupna.';
$string['graded'] = 'Ocijenjeno';
$string['guestnosubmit'] = 'Nažalost, gostima nije dopušteno predavati zadaće. Morate se prijaviti/registrirati prije predavanja.';
$string['guestnoupload'] = 'Nažalost, gosti (anonimni korisnici) ne mogu vršiti upload';
$string['helpoffline'] = '<p>Ovo je naročito korisno kada se zadaća priprema izvan sustava Moodle. Može se raditi o aktivnosti na webu ili fizičkom, stvarnom ispitivanju.</p><p>Studenti mogu vidjeti opis zadaće, ali ne mogu vršiti upload datoteka ili neku sličnu online aktivnost. Ocjenjivanje, međutim, funkcionira kao i kod online zadaća, i studenti dobiju obavijest o svojoj ocjeni putem poruke e-pošte.</p>';
$string['helponline'] = '<p>Ovaj tip zadaće traži od studenta unos teksta koristeći klasični interni Moodle editor. Nastavnici mogu zadaće ocjenjivati online, pa čak i dodavati komentare ili izmjene u samom tekstu zadaće.</p>
<p>(Ako ste upoznati sa starijim inačicama Moodle sustava, ova vrsta zadaće ima istu funkcionalnost kao i prethodni Journal modul.)</p>';
$string['helpupload'] = '<p>Ova vrsta zadaće omogućava svakom polazniku postavljanje jedne ili više datoteka (bilo kojeg oblika) na poslužitelj. To mogu biti MS Word dokumenti, slike, web stranice pohranjene u ZIP datoteku, ili bilo koji drugi oblik datoteke.</p>
<p>Ova vrsta zadaće omogućava i postavljanje na poslužitelj više datoteka (u sklopu jedne zadaće) odjednom. Ove datoteke se mogu postaviti i prije završne predaje, što možete iskoristiti za dodijeljivanje različitih datoteka svakome od polaznika.</p>
<p>Polaznici mogu unijeti bilješke opisujući predane datoteke, stupanj završenosti ili bilo koju drugu potrebnu informaciju.</p>
<p>Predane zadaće ove vrste moraju biti ručno završene od strane polaznika. U bilo koje vrijeme možete pregledati trenutno stanje, pri čemu su nedovršene zadaće označene kao Nacrt. Bilo koju neocijenjenu zadaću možete vratiti u stanje nacrta.</p>';
$string['helpuploadsingle'] = '<p>Ovaj tip zadaće omogućava svakom studentu upload jedne datoteke (bilo kojeg oblika).</p> <p>Datoteka može biti MS Word dokument, slika, ZIP arhiva ili bilo što drugo u digitalnom obliku što zatražite od vaših studenata kao zadaću.</p>';
$string['hideintro'] = 'Sakrij opis prije početnog datuma zadaće';
$string['hideintro_help'] = 'Ako je omogućeno, opis zadaće će biti skriven sve do trenutka kada zadaća postane dostupna studentima. Do tog trenutka je vidljiv samo naziv zadaće.';
$string['invalidassignment'] = 'Neispravna zadaća';
$string['invalidfileandsubmissionid'] = 'Nedostaje ID datoteke ili ID predaje';
$string['invalidid'] = 'ID zadaće nije bio valjan';
$string['invalidsubmissionid'] = 'Neispravan ID predaje';
$string['invalidtype'] = 'Netočna vrsta zadaće';
$string['invaliduserid'] = 'Pogrešan ID korisnika';
$string['itemstocount'] = 'Broj';
$string['lastgrade'] = 'Zadnja ocjena';
$string['late'] = '{$a} kasnije';
$string['maximumgrade'] = 'Maksimalna ocjena';
$string['maximumsize'] = 'Maksimalna veličina';
$string['maxpublishstate'] = 'Najdulja vidljivost blog članka prije isteka';
$string['messageprovider:assignment_updates'] = 'Obavijesti o zadaći (2.2)';
$string['modulename'] = 'Zadaća (2.2)';
$string['modulename_help'] = 'Zadaće omogućuju nastavniku određivanje bilo online ili offline zadaća (koje potom mogu biti ocijenjene).';
$string['modulenameplural'] = 'Zadaće (2.2)';
$string['newsubmissions'] = 'Predane zadaće';
$string['noassignments'] = 'Trenutno nema ni jedne zadaće';
$string['noattempts'] = 'Nitko nije predao zadaću';
$string['noblogs'] = 'Nemate blog članaka koje biste mogli predati!';
$string['nofiles'] = 'Nijedna datoteka nije predana';
$string['nofilesyet'] = 'Nijedna datoteka još nije predana';
$string['nomoresubmissions'] = 'Više nije moguće predavati zadaće.';
$string['norequiregrading'] = 'Nema zadaća koje je potrebno ocijeniti';
$string['nosubmisson'] = 'Nijedna zadaća nije predana';
$string['notavailableyet'] = 'Nažalost, ova zadaća još nije raspoloživa.<br/>Opis zadaće i upute bit će dostupni na ovoj stranici nakon dolje navedenog datuma.';
$string['notes'] = 'Bilješke';
$string['notesempty'] = 'Nema unosa';
$string['notesupdateerror'] = 'Pogreška pri uređivanju bilješki';
$string['notgradedyet'] = 'Neocijenjeno';
$string['notsubmittedyet'] = 'Zadaća jos nije predana';
$string['onceassignmentsent'] = 'Jednom kad predate zadaću na ocjenjivanje, nećete više moći brisati ili dodavati datoteke. Želite li nastaviti?';
$string['operation'] = 'Operacija';
$string['optionalsettings'] = 'Opcionalne postavke';
$string['overwritewarning'] = 'Upozorenje: ponovni upload će ZAMIJENITI vašu postojeću zadaću na poslužitelju';
$string['page-mod-assignment-submissions'] = 'Stranica za predaju modula zadaća';
$string['page-mod-assignment-view'] = 'Glavna stranica modula zadaća';
$string['page-mod-assignment-x'] = 'Bilo koja stranica modula zadaća';
$string['pagesize'] = 'Broj predanih zadaća po stranici';
$string['pluginadministration'] = 'Administracija zadaće';
$string['pluginname'] = 'Zadaća (2.2)';
$string['popupinnewwindow'] = 'Otvori u novom prozoru.';
$string['preventlate'] = 'Zabrani zakašnjelu predaju zadaće';
$string['quickgrade'] = 'Dozvoli brzo ocjenjivanje';
$string['quickgrade_help'] = 'Ako je omogućeno, moguće je ocjenjivati više zadaća na jednoj stranici. Dodijelite ocjene i komentare i kliknite na "Pohrani sve povratne informacije" kako bi pohranili promjene na toj stranici.';
$string['requiregrading'] = 'Zahtijevaj ocjenjivanje';
$string['responsefiles'] = 'Datoteke s odgovorima';
$string['reviewed'] = 'Pregledano';
$string['saveallfeedback'] = 'Pohrani sve moje povratne informacije (feedback)';
$string['selectblog'] = 'Odaberite koji blok članak želite predati';
$string['sendformarking'] = 'Predajte za ocjenjivanje';
$string['showrecentsubmissions'] = 'Prikaži nedavno predane zadaće';
$string['submission'] = 'Predaja';
$string['submissiondraft'] = 'Nacrt zadaće';
$string['submissionfeedback'] = 'Povratna informacija o zadaći';
$string['submissions'] = 'Predane zadaće';
$string['submissionsaved'] = 'Vaše promjene su pohranjene';
$string['submissionsnotgraded'] = 'Broj zadaća koje nisu ocijenjene: {$a} ';
$string['submitassignment'] = 'Predajte zadaću koristeći ovaj obrazac';
$string['submitedformarking'] = 'Zadaća je već predana na ocjenjivanje i ne može biti osvježena / mijenjana';
$string['submitformarking'] = 'Predajte zadaću na ocjenjivanje';
$string['submitted'] = 'Predano';
$string['submittedfiles'] = 'Predane datoteke';
$string['subplugintype_assignment'] = 'Tip zadaće';
$string['subplugintype_assignment_plural'] = 'Vrste zadaće';
$string['trackdrafts'] = 'Omogući opciju Slanja na ocjenjivanje';
$string['trackdrafts_help'] = '"Pošalji na ocjenjivanje" gumb omogućava studentima da jave nastavniku kako su završili rad na zadaći. Nastavnik može vratiti zadaću u oblik nacrta (nepredane zadaće), ako ista npr. zahtijeva dodatne izmjene.';
$string['typeblog'] = 'Blog članak';
$string['typeoffline'] = 'Offline aktivnost (zadaća se predaje u tiskanom, pisanom obliku)';
$string['typeonline'] = 'Online tekst';
$string['typeupload'] = 'Napredni prijenos datoteka';
$string['typeuploadsingle'] = 'Prenesite datoteku';
$string['unfinalize'] = 'Vrati se na nacrt';
$string['unfinalizeerror'] = 'Dogodila se pogreška zbog koje vašu zadaću nije moguće pohraniti kao nacrt';
$string['unfinalize_help'] = 'Vraćanje zadaće u oblik nacrta omogućuje studentu daljnje izmjene zadaće.';
$string['upgradenotification'] = 'Ova aktivnost je zasnovana na starom modulu za zadaće.';
$string['uploadafile'] = 'Prijenos datoteke na poslužitelj (upload)';
$string['uploadbadname'] = 'Naziv datoteke je sadržavao SPECIJALNE (nedozvoljene) znakove i sustav ju nije mogao prenijeti na poslužitelj.';
$string['uploadedfiles'] = 'prenešene datoteke';
$string['uploaderror'] = 'Nažalost, dogodila se pogreška prilikom pohranjivanja vaše datoteke na poslužitelj.';
$string['uploadfailnoupdate'] = 'Upload datoteke je prošao uspješno, ali nije bilo moguće zamijeniti vašu prethodu zadaću!';
$string['uploadfiles'] = 'Prenesi datoteke na poslužitelj (upload)';
$string['uploadfiletoobig'] = 'Nažalost, navedena datoteka je prevelika (ograničenje iznosi {$a} bajta)';
$string['uploadnofilefound'] = 'Nije pronađena nijedna datoteka - jeste li sigurni da ste odabrali neku datoteku za prijenos na poslužitelj?';
$string['uploadnotregistered'] = 'Upload datoteke \'{$a}\' je prošao uspješno, ali predaja zadaće nije uspjela!';
$string['uploadsuccess'] = 'Upload datoteke \'{$a}\' uspješan';
$string['usermisconf'] = 'Korisnički račun nije ispravno podešen';
$string['usernosubmit'] = 'Nažalost, vi ne možete predati zadaću.';
$string['viewassignmentupgradetool'] = 'Pogledajte alat za nadogradnju stare zadaće na novi modul';
$string['viewfeedback'] = 'Prikaži ocjene i povratne informacije (feedback)';
$string['viewmysubmission'] = 'Vidi moje zadaće';
$string['viewsubmissions'] = 'Prikaži predane zadaće, trenutno: {$a}';
$string['yoursubmission'] = 'Vaša zadaća';
