<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'hu', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'telepítés folyamatban';
$string['action'] = 'Művelet';
$string['actionchoice'] = 'Mit kíván tenni ezzel az  állománnyal: \'{$a}\'?';
$string['actions'] = 'Műveletek';
$string['active'] = 'Aktív';
$string['activeusers'] = 'Aktív felhasználók';
$string['activities'] = 'Tevékenységek';
$string['activities_help'] = 'Például fórumok, tesztek és wikik segítségével interaktív tartalommal bővítheti a kurzust.';
$string['activity'] = 'Tevékenység';
$string['activityclipboard'] = 'A következő tevékenység áthelyezése: {$a}';
$string['activityiscurrentlyhidden'] = 'Ez a tevékenység jelenleg rejtett';
$string['activitymodule'] = 'Tevékenységmodul';
$string['activitymodules'] = 'Tevékenységmodulok';
$string['activityreport'] = 'Tevékenységről szóló jelentés';
$string['activityreports'] = 'Tevékenységről szóló jelentések';
$string['activityselect'] = 'A tevékenység kiválasztása áthelyezésre';
$string['activitysince'] = 'Tevékenység {$a} óta';
$string['activityweighted'] = 'Tevékenység felhasználónként';
$string['add'] = 'Hozzáadás';
$string['addactivity'] = 'Tevékenység hozzáadása...';
$string['addactivitytosection'] = 'Tevékenység hozzáadása minden \'{$a}\' szekcióhoz';
$string['addadmin'] = 'Rendszergazda hozzáadása';
$string['addblock'] = 'Blokk hozzáadása';
$string['addcomment'] = 'Megjegyzés hozzáadása...';
$string['addcountertousername'] = 'Felhasználó létrehozása szám felhasználónévhez való hozzáadásával';
$string['addcreator'] = 'Kurzuskészítő hozzáadása';
$string['adddots'] = 'Hozzáadás...';
$string['added'] = '{$a} hozzáadva';
$string['addedrecip'] = '{$a} új címzett hozzáadva';
$string['addedrecips'] = '{$a} új címzettek hozzáadva';
$string['addedtogroup'] = '{$a} csoporthoz hozzáadva';
$string['addedtogroupnot'] = '{$a} csoporthoz nem lett hozzáadva';
$string['addedtogroupnotenrolled'] = '{$a} csoporthoz nem lett hozzáadva, mert nem iratkozott be a kurzusra';
$string['addfilehere'] = 'Állomány(ok) beszúrása ide';
$string['addinganew'] = 'Új {$a} hozzáadása';
$string['addinganewto'] = 'Új {$a->what} hozzáadása ehhez: {$a->to}';
$string['addingdatatoexisting'] = 'Adat hozzáadása meglévőhöz';
$string['additionalnames'] = 'További nevek';
$string['addlinkhere'] = 'Ugrópont beszúrása ide';
$string['addnewcategory'] = 'Új kategória hozzáadása';
$string['addnewcourse'] = 'Új kurzus hozzáadása';
$string['addnewuser'] = 'Új felhasználó hozzáadása';
$string['addnousersrecip'] = 'Olyan felhasználók hozzáadása a címzettekhez, akik még nem léptek be ide: {$a}';
$string['addpagehere'] = 'Szöveg beszúrása ide';
$string['addresource'] = 'Tananyag hozzáadása...';
$string['addresourceoractivity'] = 'Tevékenység vagy tananyag beszúrása';
$string['addresourcetosection'] = 'Tananyag hozzáadása a(z) \'{$a}\' szekcióhoz';
$string['address'] = 'Cím';
$string['addstudent'] = 'Tanuló hozzáadása';
$string['addsubcategory'] = 'Alkategória hozzáadása';
$string['addteacher'] = 'Tanár hozzáadása';
$string['admin'] = 'Rendszergazda';
$string['adminhelpaddnewuser'] = 'Új felhasználói fiók kézi létrehozása';
$string['adminhelpassignadmins'] = 'A rendszergazdák bármit csinálhatnak és bárhová ellátogathatnak a portálon';
$string['adminhelpassigncreators'] = 'A kurzuskészítők új kurzusokat hozhatnak létre';
$string['adminhelpassignsiteroles'] = 'Meghatározott portálszerepek hozzárendelése adott felhasználókhoz';
$string['adminhelpassignstudents'] = 'Belépés egy kurzusba és tanulók hozzáadása a portáladminisztrációs menüből';
$string['adminhelpauthentication'] = 'Belső felhasználói fiókokat vagy külső adatbázisokat használhat';
$string['adminhelpbackup'] = 'Automatikus biztonsági mentések beállítása és azok ütemezése';
$string['adminhelpconfiguration'] = 'A portál kinézetének és működésének beállítása';
$string['adminhelpconfigvariables'] = 'A portál általános működését befolyásoló változók beállítása';
$string['adminhelpcourses'] = 'Kurzusok és kategóriák meghatározása, személyek ezekhez rendelése, valamint folyamatban lévő kurzusok szerkesztése';
$string['adminhelpeditorsettings'] = 'HTML-szerkesztő alapbeállításainak megadása';
$string['adminhelpedituser'] = 'Felhasználói azonosítók jegyzékének böngészése és bármelyikük szerkesztése';
$string['adminhelpenvironment'] = 'Ellenőrizze, mennyiben felel meg a szervere a jelenlegi és a jövőbeli telepítési követelményeknek';
$string['adminhelpfailurelogs'] = 'Sikertelen belépések naplóinak böngészése';
$string['adminhelplanguage'] = 'A jelenlegi nyelvi csomag ellenőrzéséhez és szerkesztéséhez';
$string['adminhelplogs'] = 'A portál összes tevékenységnaplójának böngészése';
$string['adminhelpmanageblocks'] = 'Telepített blokkok és beállításaik kezelése';
$string['adminhelpmanagedatabase'] = 'Adatbázis közvetlen elérése (csak óvatosan!)';
$string['adminhelpmanagefilters'] = 'Szövegszűrők és kapcsolódó beállítások kiválasztása';
$string['adminhelpmanagemodules'] = 'Telepített modulok és beállításaik kezelése';
$string['adminhelpmanageroles'] = 'Felhasználókhoz hozzárendelhető szerepek létrehozása és meghatározása';
$string['adminhelpmymoodle'] = 'MyMoodle-blokkok beállítása felhasználók számára';
$string['adminhelpreports'] = 'Portálszintű jelentések';
$string['adminhelpsitefiles'] = 'Általános állományok közzététele vagy külső biztonsági mentések feltöltése';
$string['adminhelpsitesettings'] = 'A portál első oldalán a megjelenés meghatározása';
$string['adminhelpstickyblocks'] = 'Megmaradó Moodle-szintű blokkok beállítása';
$string['adminhelpthemes'] = 'A portál megjelenésének meghatározása (színek, betűk stb.)';
$string['adminhelpuploadusers'] = 'Új felhasználói azonosítók importálása szöveges állományból';
$string['adminhelpusers'] = 'Felhasználók megadása és hitelesítés beállítása';
$string['adminhelpxmldbeditor'] = 'Interfész XMLDB-állományok szerkesztéséhez. Csak fejlesztők számára.';
$string['administration'] = 'Adminisztráció';
$string['administrationsite'] = 'Portáladminisztráció';
$string['administrator'] = 'Rendszergazda';
$string['administratordescription'] = 'A rendszergazdák a portálon az összes kurzusban általában bármit tehetnek.';
$string['administrators'] = 'Rendszergazdák';
$string['administratorsall'] = 'Minden rendszergazda';
$string['administratorsandteachers'] = 'Rendszergazdák és tanárok';
$string['advanced'] = 'Részletes';
$string['advancedfilter'] = 'Részletes keresés';
$string['advancedsettings'] = 'Részletes beállítások';
$string['afterresource'] = '"{$a}" tananyag után';
$string['aftersection'] = '"{$a}" szakasz után';
$string['again'] = 'ismét';
$string['aimid'] = 'AIM-azonosító';
$string['ajaxuse'] = 'AJAX és javascript';
$string['all'] = 'Mind';
$string['allactions'] = 'Minden művelet';
$string['allactivities'] = 'Minden tevékenység';
$string['allcategories'] = 'Minden kategória';
$string['allchanges'] = 'Minden módosítás';
$string['alldays'] = 'Minden nap';
$string['allfieldsrequired'] = 'Minden mező kitöltése kötelező';
$string['allfiles'] = 'Minden állomány';
$string['allgroups'] = 'Minden csoport';
$string['alllogs'] = 'Minden naplóbejegyzés';
$string['allmods'] = 'Minden {$a}';
$string['allow'] = 'Engedélyez';
$string['allowinternal'] = 'Belső metódusok is engedélyezve';
$string['allownone'] = 'Egyet sem engedélyez';
$string['allownot'] = 'Nem engedélyez';
$string['allparticipants'] = 'Összes résztvevő';
$string['allteachers'] = 'Minden tanár';
$string['alphanumerical'] = 'Csak alfanumerikus karaktereket, kötőjelet (-) vagy pontot (.) tartalmazhat';
$string['alreadyconfirmed'] = 'A regisztrációt már visszaigazolták';
$string['alternatename'] = 'Másik név';
$string['always'] = 'Mindig';
$string['and'] = '{$a->one} és {$a->two}';
$string['answer'] = 'Válasz';
$string['any'] = 'Bármelyik';
$string['appearance'] = 'Megjelenés';
$string['approve'] = 'Jóváhagy';
$string['areyousure'] = 'Biztos?';
$string['areyousuretorestorethis'] = 'Kívánja folytatni?';
$string['areyousuretorestorethisinfo'] = 'Később ezt a biztonsági mentést hozzáadhatja egy meglévő kurzushoz, vagy pedig létrehozhat egy teljesen új kurzust.';
$string['asc'] = 'Növekvő';
$string['assessment'] = 'Értékelés';
$string['assignadmins'] = 'Rendszergazdák hozzárendelése';
$string['assigncreators'] = 'Kurzuskészítők hozzárendelése';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Egész portálra érvényes szerepek hozzárendelése';
$string['authenticateduser'] = 'Hitelesített felhasználó';
$string['authenticateduserdescription'] = 'Minden belépett felhasználó.';
$string['authentication'] = 'Hitelesítés';
$string['authenticationplugins'] = 'Hitelesítési segédprogramok';
$string['autosubscribe'] = 'Automatikus feliratkozás a fórumra';
$string['autosubscribeno'] = 'Nem: nem iratkozom fel automatikusan a fórumokra';
$string['autosubscribeyes'] = 'Igen: ha hozzászólok, írjon fel arra a fórumra';
$string['availability'] = 'Felvehetőség';
$string['availablecourses'] = 'Felvehető kurzusok';
$string['back'] = 'Vissza';
$string['backto'] = 'Vissza ide: {$a}';
$string['backtocourselisting'] = 'Vissza a kurzuslistához';
$string['backtopageyouwereon'] = 'Vissza az előző oldalra';
$string['backtoparticipants'] = 'Vissza a résztvevők felsorolásához';
$string['backup'] = 'Biztonsági mentés';
$string['backupactivehelp'] = 'Adja meg, készüljön-e automatikus biztonsági mentés.';
$string['backupcancelled'] = 'Biztonsági mentés törölve';
$string['backupcoursefileshelp'] = 'Bekapcsolása esetén a kurzus állományai bekerülnek az automatikus biztonsági mentések közé.';
$string['backupdate'] = 'Biztonsági mentés dátuma';
$string['backupdatenew'] = '{$a->TAG} most {$a->year}. {$a->month}, {$a->weekday}, {$a->mday} <br />';
$string['backupdateold'] = '{$a->TAG} {$a->year}. {$a->month} {$a->weekday}, {$a->mday} volt';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Biztonsági mentés részletei';
$string['backupexecuteathelp'] = 'Adja meg, mikor fusson le az automatikus biztonsági mentés.';
$string['backupfailed'] = 'Kurzusai közül néhánynak a mentése nem történt meg!';
$string['backupfilename'] = 'biztonsági mentés';
$string['backupfinished'] = 'A biztonsági mentés sikeresen lezajlott';
$string['backupfromthissite'] = 'A biztonsági mentésre ezen a portálon került sor?';
$string['backupgradebookhistoryhelp'] = 'Bekapcsolása esetén az osztályozó napló előzményei bekerülnek az automatikus biztonsági mentésekbe. Ehhez a szerverbeállításoknál nem kell kikapcsolni az osztályozónapló előzményeit (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Döntse el, hogy a kurzusmodulok - felhasználói adatokkal, vagy azok nélkül - bekerüljenek-e az automatikus biztonsági mentések közé.';
$string['backupincludemoduleuserdatahelp'] = 'Adja meg, szerepeljenek-e a modult használó adatai az automatikus biztonsági mentésekben.';
$string['backupkeephelp'] = 'Hány utóbbi biztonsági mentést kíván kurzusonként megtartani (az ennél régebbiek automatikusan törlődnek)?';
$string['backuplogdetailed'] = 'Részletes végrehajtási napló';
$string['backuploglaststatus'] = 'Utolsó végrehajtási napló';
$string['backupmissinguserinfoperms'] = 'Megjegyzés: ez a biztonsági mentés nem tartalmaz felhasználói adatokat. A gyakorlatokkal és a műhelymunkával kapcsolatos tevékenységek kimaradnak a biztonsági mentésből, mivel ezek a modulok nem részei az effajta biztonsági mentésnek.';
$string['backupnext'] = 'Következő biztonsági mentés';
$string['backupnonisowarning'] = 'Figyelem: ez a biztonsági mentés a Moodle unikódot megelőző (1.6 előtti) változatával készült. Ha van benne nem ISO-8859-1 kódolású szöveg, előfordulhat, hogy MEGSÉRÜL, ha a Moodle ezen unikódos változatával próbálja meg visszaállítani. Lásd a <a href="http://docs.moodle.org/en/Backup_FAQ">Biztonsági mentések GYIK-jét</a> ezen biztonsági mentés helyes visszaállításával kapcsolatosan.';
$string['backupnotyetrun'] = 'Automatikus biztonsági mentés folyamatban';
$string['backuporiginalname'] = 'Biztonsági mentés neve';
$string['backuproleassignments'] = 'Ezen szerep-hozzárendelések biztonsági mentése';
$string['backupsavetohelp'] = 'A mentendő állományok könyvtárához vezető teljes útvonal (a kurzus alapkönyvtárába mentéshez hagyja üresen)';
$string['backupsitefileshelp'] = 'Bekapcsolása esetén a kurzusokban használt portálállományokról automatikus biztonsági mentés készül.';
$string['backuptakealook'] = 'Tekintse meg biztonsági naplóit itt: {$a}';
$string['backupuserfileshelp'] = 'Döntse el, hogy a felhasználói állományok (pl. a profilképek) bekerüljenek-e az automatikus biztonsági mentésbe.';
$string['backupversion'] = 'Biztonsági mentés változata';
$string['badges'] = 'Kitűzők';
$string['block'] = 'Blokk';
$string['blockconfiga'] = '{$a} blokk beállítása';
$string['blockconfigbad'] = 'Ez a blokk nincs megfelelően telepítve, ezért nincs hozzá beállítási interfész.';
$string['blocks'] = 'Blokkok';
$string['blocksaddedit'] = 'Blokkok hozzáadása/szerkesztése';
$string['blockseditoff'] = 'Blokkszerkesztés kikapcsolva';
$string['blocksediton'] = 'Blokkszerkesztés bekapcsolva';
$string['blocksetup'] = 'Blokktáblázatok beállítása';
$string['blocksuccess'] = '{$a} táblázatot sikerült megfelelően beállítani';
$string['brief'] = 'Rövid';
$string['bulkactions'] = 'Tömeges intézkedések';
$string['bulkactionselect'] = '{$a} ömlesztett lépés kiválasztása';
$string['bulkmovecoursessuccess'] = '{$a->courses} kurzus {$a->category} alá sikeresen áthelyezve';
$string['bycourseorder'] = 'A kurzusok sorrendje szerint';
$string['byname'] = '{$a} szerint';
$string['bypassed'] = 'Kihagyva';
$string['cachecontrols'] = 'Vezérlőelemek gyorsítótárba helyezése';
$string['cancel'] = 'Mégse';
$string['cancelled'] = 'Törölve';
$string['categories'] = 'Kurzuskategóriák';
$string['categoriesandcoures'] = 'Kurzuskategóriák és kurzusok';
$string['category'] = 'Kategória';
$string['categoryadded'] = 'A(z) \'{$a}\' kategória hozzáadva';
$string['categorybulkaction'] = 'Ömlesztett lépések a kiválasztott kategóriákhoz';
$string['categorycontents'] = 'Alkategóriák és kurzusok';
$string['categorycurrentcontents'] = 'A(z) {$a} tartalma';
$string['categorydeleted'] = 'A(z) \'{$a}\' kategória törlése megtörtént';
$string['categoryduplicate'] = '\'{$a}\' nevű kategória már létezik!';
$string['categorymodifiedcancel'] = 'A kategória módosult! Törölje és próbálja meg újra.';
$string['categoryname'] = 'Kategória neve';
$string['categorysubcategoryof'] = '{$a->category} - {$a->parentcategory} alkategóriája';
$string['categoryupdated'] = 'A(z) \'{$a}\' kategória frissítése megtörtént';
$string['changedpassword'] = 'Megváltozott jelszó';
$string['changepassword'] = 'Jelszó módosítása';
$string['changesmadereallygoaway'] = 'Módosításokat hajtott végre. Biztosan továbblép és nem menti a módosításokat?';
$string['changessaved'] = 'Módosítások elmentve';
$string['check'] = 'Ellenőrzés';
$string['checkall'] = 'Mind ellenőrzése';
$string['checkingbackup'] = 'Biztonsági mentés ellenőrzése';
$string['checkingcourse'] = 'Kurzus ellenőrzése';
$string['checkingforbbexport'] = 'BlackBoard exportálásának ellenőrzése';
$string['checkinginstances'] = 'Példányok ellenőrzése';
$string['checkingsections'] = 'Szekciók ellenőrzése';
$string['checklanguage'] = 'Nyelv ellenőrzése';
$string['checknone'] = 'Egyiket sem ellenőrzi';
$string['childcoursenotfound'] = 'Alkurzus nem található!';
$string['childcourses'] = 'Alkurzusok';
$string['choose'] = 'Választás';
$string['choosecourse'] = 'Válasszon kurzust';
$string['choosedots'] = 'Választás...';
$string['chooselivelogs'] = 'vagy tekintse meg az éppen zajló tevékenységet';
$string['chooselogs'] = 'Válassza ki a megtekintendő naplókat';
$string['choosereportfilter'] = 'Válasszon szűrőt a jelentéshez';
$string['choosetheme'] = 'Válasszon témát';
$string['chooseuser'] = 'Válasszon felhasználót';
$string['city'] = 'Helység';
$string['clambroken'] = 'Rendszergazdája feltöltésekhez bekapcsolta a vírusellenőrzést, de valamit rosszul állított be. Állományának feltöltése NEM sikerült. A rendszergazdát értesítettük, így a javítást el tudja végezni. Esetleg próbálja meg ezt az állományt később feltölteni.';
$string['clamdeletedfile'] = 'Az állomány törölve.';
$string['clamdeletedfilefailed'] = 'Ezt az állományt nem lehetett törölni.';
$string['clamemailsubject'] = '{$a} :: A Clam vírusirtó üzenete';
$string['clamfailed'] = 'A vírusirtó nem futott le. A hibajelzés {$a} volt. Íme a vírusirtó üzenete:';
$string['clamlost'] = 'A Moodle feltöltéskor vírusirtóval ellenőrzi az állományt, de a vírusirtó megadott {$a} útvonala érvénytelen.';
$string['clamlostandactinglikevirus'] = 'Emellett a Moodle úgy van beállítva, hogy a vírusirtó sikertelen lefutásakor az állományokat fertőzöttnek tekinti. Emiatt a tanulók mindaddig nem tölthetnek fel állományokat, amíg ezt nem sikerül kiküszöbölnie.';
$string['clammovedfile'] = 'Az állomány átkerült a megadott karanténkönyvtárba, az új hely: {$a}';
$string['clammovedfilebasic'] = 'Az állomány karanténkönyvtárba került.';
$string['clamquarantinedirfailed'] = 'Az állományt nem lehetett a megadott {$a} karanténkönyvtárba áthelyezni. Ki kell javítania, mert a fertőzöttnek vélt állományokat a rendszer törli.';
$string['clamunknownerror'] = 'Ismeretlen hiba történt a vírusirtóval.';
$string['cleaningtempdata'] = 'Ideiglenes adatok törlése';
$string['clear'] = 'Töröl';
$string['clickhelpiconformoreinfo'] = '... folytatódik ... A teljes cikk elolvasásához kattintson a súgóikonra.';
$string['clickhere'] = 'Kattintson ide ...';
$string['clicktochangeinbrackets'] = '{$a} (Kattintson a módosításhoz.)';
$string['clicktohideshow'] = 'Kattintson a kibontáshoz vagy a becsukáshoz.';
$string['closebuttontitle'] = 'Bezárás';
$string['closewindow'] = 'Ablak bezárása';
$string['collapse'] = 'Összeejtés';
$string['collapseall'] = 'Az összes becsukása';
$string['collapsecategory'] = '{$a} becsukása';
$string['commentincontext'] = 'A megjegyzés megkeresése környezetében';
$string['comments'] = 'Megjegyzések';
$string['commentsnotenabled'] = 'A Megjegyzések szolgáltatás nincs bekapcsolva';
$string['commentsrequirelogin'] = 'A megjegyzések megtekintéséhez be kell jelentkeznie';
$string['comparelanguage'] = 'Az aktuális nyelv ellenőrzése és szerkesztése';
$string['complete'] = 'Teljes';
$string['completereport'] = 'Teljes jelentés';
$string['configuration'] = 'Szerkesztés';
$string['confirm'] = 'Megerősítés';
$string['confirmcheckfull'] = 'Biztosan megerősíti ezt: {$a}?';
$string['confirmcoursemove'] = 'Biztosan áthelyezi a(z) ({$a->course}) kurzust a(z) ({$a->category}) kategóriába?';
$string['confirmed'] = 'Regisztrációját visszaigazoltuk';
$string['confirmednot'] = 'A regisztráció visszaigazolása még nem történt meg!';
$string['content'] = 'Tartalom';
$string['continue'] = 'Folytatás';
$string['continuetocourse'] = 'A kurzusba való belépéshez kattintson ide';
$string['convertingwikitomarkdown'] = 'Wiki átalakítása Markdown-formába';
$string['cookiesenabled'] = 'a böngészőjében engedélyeznie kell a sütiket';
$string['cookiesenabled_help'] = '<p>Ez a portál kétféle sütit használ.</p>

<p>Ezek közül az alapvetően fontos süti az általában <strong>MoodleSession</strong> néven ismert folyamatrögzítő süti. Ezt a sütit engedélyezni kell a böngészőben, ha folyamatosan szeretne dolgozni, eközben belépése oldalról oldalra érvényes marad. Kilépéskor vagy a böngésző bezárásakor ez a süti megsemmisül (mind a böngészőben, mind a szerveren).</p>

<p>A másik süti kizárólag kényelmi célokat szolgál és rendszerint
a <strong>MOODLEID</strong> vagy ehhez hasonló nevet viseli. Ennek csak annyi a szerepe, hogy emlékezzen a
böngészőn belül a felhasználónévre. Ez azt jelenti, hogy ha visszatér erre a weboldalra,
a belépési oldalon a felhasználónév már kitöltve jelenik meg. Ha nem kívánja
ezt a sütit használni, minden gond nélkül lemondhat róla, ez mindössze azzal jár, hogy minden alkalommal belépéskor újból be kell írnia a nevét.</p>';
$string['cookiesnotenabled'] = 'Böngészőjében a sütik használata nincs engedélyezve.';
$string['copy'] = 'másol';
$string['copyasnoun'] = 'másolat';
$string['copyingcoursefiles'] = 'Kurzusállományok másolása';
$string['copyingsitefiles'] = 'A kurzusban használt portálállományok másolása';
$string['copyinguserfiles'] = 'Felhasználói állományok másolása';
$string['copyingzipfile'] = 'Tömörített állomány másolása';
$string['copyrightnotice'] = 'Szerzői jogra vonatkozó megjegyzés';
$string['coresystem'] = 'alaprendszer';
$string['cost'] = 'Költség';
$string['costdefault'] = 'Alapköltség';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Ország';
$string['course'] = 'Kurzus';
$string['courseadministration'] = 'Kurzus kezelése';
$string['courseapprovedemail'] = 'Kért {$a->name} kurzusa jóvá lett hagyva, Ön pedig {$a->teacher} lett. Új kurzusa eléréséhez látogasson el ide: {$a->url}';
$string['courseapprovedemail2'] = 'Kért {$a->name} kurzusát jóváhagytuk. Eléréséhez látogasson el ide: {$a->url}.';
$string['courseapprovedfailed'] = 'A kurzust mint jóváhagyottat nem sikerült elmenteni!';
$string['courseapprovedsubject'] = 'Kurzusa jóvá lett hagyva!';
$string['courseavailable'] = 'A kurzus tanulók számára elérhető';
$string['courseavailablenot'] = 'A kurzus tanulók számára nem elérhető';
$string['coursebackup'] = 'Kurzus biztonsági mentése';
$string['coursebulkaction'] = 'Ömlesztett lépések a kiválasztott kurzusokhoz';
$string['coursecategories'] = 'Kurzuskategóriák';
$string['coursecategory'] = 'Kurzuskategória';
$string['coursecategorydeleted'] = 'A(z) {$a} kurzuskategória törölve';
$string['coursecategory_help'] = '<p>A Moodle-rendszergazda néhány kurzuskategóriát előre elkészíthet.</p>

<p>Például létrehozhat "Természettudományok", "Bölcsészettudományok", "Egészségügy" stb. elnevezésű kategóriákat.</p>

<p>Válassza ki a kurzusának leginkább megfelelőt. Ez a választás határozza majd meg, hogy a
kurzuslistán hol jelenik meg a kurzus. Emellett megkönnyítheti a tanulók számára a kurzus megtalálását. </p>';
$string['coursecatmanagement'] = 'Kurzusok és kategóriák kezelése';
$string['coursecompletion'] = 'Kurzus teljesítése';
$string['coursecompletions'] = 'Kurzusteljesítések';
$string['coursecreators'] = 'Kurzuskészítő';
$string['coursecreatorsdescription'] = 'A kurzuskészítők új kurzusokat hozhatnak létre.';
$string['coursedeleted'] = 'A(z) {$a} kurzus törölve';
$string['coursedisplay'] = 'Kurzus elrendezése';
$string['coursedisplay_help'] = 'Ez a beállítás határozza meg, hogy az egész kurzus egy oldalon vagy több oldalra osztva jelenik-e meg.';
$string['coursedisplay_multi'] = 'Oldalanként egy szakasz megjelenítése';
$string['coursedisplay_single'] = 'Az összes szakasz megjelenítése egy oldalon';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Korábbi kurzusállományok';
$string['coursefilesedit'] = 'Kurzusállományok szerkesztése';
$string['coursefileswarning'] = 'A Moodle 2.0 óta a kurzusállományok nem használatosak, amennyire lehet, használjon helyettük külső adattárakat.';
$string['coursefileswarning_help'] = 'A Moodle 2.0-tól kezdődően a kurzusállományok elavultnak minősülnek, ha lehet, inkább külső adattárakat használjon.';
$string['courseformatdata'] = 'Kurzusforma adatai';
$string['courseformatoptions'] = 'Formázási lehetőségek {$a} esetén';
$string['courseformats'] = 'Kurzusformák';
$string['courseformatudpate'] = 'Formátum frissítése';
$string['coursegrades'] = 'Kurzuspontok';
$string['coursehelpcategory'] = 'Helyezze el a kurzust a kurzuslistában, hogy a tanulók könnyebben megtalálhassák.';
$string['coursehelpforce'] = 'A kurzus minden tevékenységéhez kurzuscsoportos mód előírása.';
$string['coursehelpformat'] = 'A kurzus fő oldala ebben a formában jelenik meg.';
$string['coursehelphiddensections'] = 'Hogyan jelennek meg a kurzus rejtett részei a tanulók számára.';
$string['coursehelpmaximumupload'] = 'Adja meg a kurzusba feltölthető maximális fájlméretet az egész portálra érvényes korlátoknak megfelelően.';
$string['coursehelpnewsitemsnumber'] = 'A kurzus honlapján hírdobozban jobbra megjelenő legújabb tételek száma<br/>(0 esetén a hírdoboz meg sem jelenik).';
$string['coursehelpnumberweeks'] = 'A kurzus szekcióinak száma (csak bizonyos kurzusformák esetén)';
$string['coursehelpshowgrades'] = 'Osztályozónapló megjelenítésének bekapcsolása. Ettől az egyes tevékenységekben még látszani fognak a pontok.';
$string['coursehidden'] = 'Ez a kurzus tanulók számára jelenleg nem elérhető';
$string['courseinfo'] = 'Kurzus adatai';
$string['courselegacyfiles'] = 'Kurzusállományok';
$string['courselegacyfiles_help'] = 'A Kurzusállományok területe némi visszamenőleges kompatibilitást biztosít a
Moodle 1.9 és korábbi verziókkal. A területen lévő összes állományt a kurzus minden résztvevője elérheti
(akár hozzájuk kapcsolja, akár nem), és nem deríthető ki, ezeket az állományokat a Moodle éppen hol használja.

Ha ezen a területen kurzusállományokat tárol, különféle titkossági és biztonsági problémának teszi ki magát, emellett
a biztonsági mentésekből és kurzusimportálásokból állományok maradhatnak ki, ha a tartalmat megosztják vagy újból felhasználják. Ezért csak akkor használja ezt a területet, ha biztosan tudja, mit cselekszik.';
$string['courselegacyfilesofcourse'] = 'Korábbi kurzusfájlok: {$a}';
$string['coursemessage'] = 'Üzenet a kurzus felhasználóinak';
$string['coursenotaccessible'] = 'Ez a kurzus nem mindenki számára hozzáférhető';
$string['courseoverview'] = 'Kurzus áttekintése';
$string['courseoverviewfiles'] = 'Kurzusleíró állományok';
$string['courseoverviewfilesext'] = 'Kurzusleíró állományok kiterjesztései';
$string['courseoverviewfiles_help'] = 'A kurzusleíró állományok (általában képek) az összegzéssel együtt a kurzuslistán láthatók';
$string['courseoverviewfileslimit'] = 'Kurzusleíró állományok korlátja';
$string['courseoverviewgraph'] = 'Kurzusáttekintés grafikonja';
$string['courseprofiles'] = 'Kurzusprofilok';
$string['coursereasonforrejecting'] = 'Indokai a kurzuskérés elutasítására';
$string['coursereasonforrejectingemail'] = 'Ezt a kérelmező e-mailben megkapja';
$string['coursereject'] = 'Kurzuskérés elutasítása';
$string['courserejected'] = 'A kurzus elutasítása megtörtént, a kérelmező értesítést kapott.';
$string['courserejectemail'] = 'Az Ön által kért kurzust elutasítottuk. Ehhez az indoklás a következő: {$a}';
$string['courserejectreason'] = 'Fogalmazza meg a kurzus elutasításának okát (ezt a kérelmező e-mailben megkapja)';
$string['courserejectsubject'] = 'Kurzusát elutasítottuk';
$string['coursereport'] = 'Kurzusjelentés';
$string['coursereports'] = 'Kurzusjelentések';
$string['courserequest'] = 'Kurzuskérés';
$string['courserequestdetails'] = 'A kért kurzus adatai';
$string['courserequestfailed'] = 'Valami miatt kurzuskérését nem sikerült elmenteni';
$string['courserequestintro'] = 'Ezen az űrlapon kérje kurzus létrehozását az Ön számára. Minél több információt adjon meg, hogy a rendszergazda láthassa, miért van szüksége erre a kurzusra.';
$string['courserequestreason'] = 'A kurzus létrehozásának indokai';
$string['courserequestsuccess'] = 'Kurzuskérelmének mentése megtörtént. E-mailben kap értesítést az eredményről.';
$string['courserequestsupport'] = 'A kérés rendszergazda általi értékelését elősegítő információk';
$string['courserestore'] = 'Kurzus visszaállítása';
$string['courses'] = 'Kurzusok';
$string['coursesectionsummaries'] = 'Kurzusszekció összesítése';
$string['coursesettings'] = 'A kurzus alapbeállításai';
$string['coursesmovedout'] = 'Kurzusok a(z) {$a} alól eltávolítva';
$string['coursespending'] = 'Jóváhagyandó kurzusok';
$string['coursestart'] = 'A kurzus kezdete';
$string['coursesummary'] = 'Kurzusösszegzés';
$string['coursesummary_help'] = 'A kurzusösszegzés a kurzuslistán látható. A kurzuskeresés a kurzusneveken kívül a kurzusösszegzés szövegére is kiterjed.';
$string['courseupdates'] = 'Kurzusfrissítések';
$string['create'] = 'Létrehozás';
$string['createaccount'] = 'Új felhasználói azonosítóm létrehozása';
$string['createcategory'] = 'Kategória létrehozása';
$string['createfolder'] = 'Mappa létrehozása itt: {$a}';
$string['createnew'] = 'Új léltrehozása';
$string['createnewcategory'] = 'Új kategória létrehozása';
$string['createnewcourse'] = 'Új kurzus létrehozása';
$string['createnewsubcategory'] = 'Új alkategória létrehozása';
$string['createsubcategoryof'] = '{$a} alkategóriájának létrehozása';
$string['createuser'] = 'Felhasználó létrehozása';
$string['createuserandpass'] = 'Új felhasználónév és jelszó megadása';
$string['createziparchive'] = 'Tömörített archívum létrehozása';
$string['creatingblocks'] = 'Blokkok létrehozása';
$string['creatingblocksroles'] = 'Blokkszintű szerepkijelölések és -felülírások';
$string['creatingblogsinfo'] = 'Bloginformációk létrehozása';
$string['creatingcategoriesandquestions'] = 'Kategóriák és kérdések létrehozása';
$string['creatingcoursemodules'] = 'Kurzusmodulok létrehozása';
$string['creatingcourseroles'] = 'Blokkszintű szerepkijelölések és -felülírások létrehozása';
$string['creatingevents'] = 'Események létrehozása';
$string['creatinggradebook'] = 'Osztályozónapló létrehozása';
$string['creatinggroupings'] = 'Csoportosítások létrehozása';
$string['creatinggroupingsgroups'] = 'Csoportok hozzáadása csoportosításokhoz';
$string['creatinggroups'] = 'Csoportok létrehozása';
$string['creatinglogentries'] = 'Naplóbejegyzések létrehozása';
$string['creatingmessagesinfo'] = 'Üzenetekről szóló információ létrehozása';
$string['creatingmodroles'] = 'Modulszintű szerepkijelölések és -felülírások létrehozása';
$string['creatingnewcourse'] = 'Új kurzus létrehozása';
$string['creatingrolesdefinitions'] = 'Szerepmeghatározások létrehozása';
$string['creatingscales'] = 'Skálák létrehozása';
$string['creatingsections'] = 'Szekciók létrehozása';
$string['creatingtemporarystructures'] = 'Ideiglenes struktúrák létrehozása';
$string['creatinguserroles'] = 'Felhasználói szintű szerepkijelölések és -felülírások létrehozása';
$string['creatingusers'] = 'Felhasználók létrehozása';
$string['creatingxmlfile'] = 'XML-állomány létrehozása';
$string['currency'] = 'Pénznem';
$string['currentcourse'] = 'Ez a kurzus';
$string['currentcourseadding'] = 'Adott kurzus: adatok hozzáadása';
$string['currentcoursedeleting'] = 'Először az adott kurzus törlése';
$string['currentlanguage'] = 'Aktuális nyelv';
$string['currentlocaltime'] = 'az aktuális helyi idő';
$string['currentlyselectedusers'] = 'Jelenleg kiválasztott felhasználók';
$string['currentpicture'] = 'Aktuális kép';
$string['currentrelease'] = 'Aktuális változatra vonatkozó információk';
$string['currentversion'] = 'Aktuális változat';
$string['databasechecking'] = 'A Moodle-adatbázis frissítése {$a->oldversion} verzióról {$a->newversion} verzióra';
$string['databaseperformance'] = 'Adatbázis teljesítménye';
$string['databasesetup'] = 'Adatbázis létrehozása';
$string['databasesuccess'] = 'Az adatbázis átalakítása sikerült';
$string['databaseupgradebackups'] = 'A biztonsági mentés verziószáma most: {$a}';
$string['databaseupgradeblocks'] = 'A blokkok verziószáma most: {$a}';
$string['databaseupgradegroups'] = 'A jelenlegi csoportverzió most: {$a}';
$string['databaseupgradelocal'] = 'A helyi adatbázis beállítási változata most: {$a}';
$string['databaseupgrades'] = 'Az adatbázis átalakítása';
$string['date'] = 'Dátum';
$string['datechanged'] = 'Módosítás dátuma';
$string['datemostrecentfirst'] = 'Dátum - a legutóbbival kezdve';
$string['datemostrecentlast'] = 'Dátum - a legutóbbival a végén';
$string['day'] = 'nap';
$string['days'] = 'nap';
$string['decodinginternallinks'] = 'Belső kapcsolatok feloldása';
$string['default'] = 'Alapbeállítás';
$string['defaultcoursestudent'] = 'Tanuló';
$string['defaultcoursestudentdescription'] = 'A tanulók egy kurzuson belül általában kevesebb joggal rendelkeznek.';
$string['defaultcoursestudents'] = 'Tanulók';
$string['defaultcoursesummary'] = 'Írjon tömör és figyelemfelkeltő bekezdést a kurzus tartalmáról';
$string['defaultcourseteacher'] = 'Tanár';
$string['defaultcourseteacherdescription'] = 'A tanárok egy kurzuson belül bármit megtehetnek, beleértve a tevékenységek módosítását és a tanulók pontozását.';
$string['defaultcourseteachers'] = 'Tanárok';
$string['defaulteditor'] = 'Alapbeállítás szerinti szerkesztő';
$string['delete'] = 'Törlés';
$string['deleteablock'] = 'Blokk törlése';
$string['deleteall'] = 'Az összes törlése';
$string['deleteallcannotundo'] = 'Az összes törlése - visszaállítás nem lehetséges';
$string['deleteallcomments'] = 'Az összes megjegyzés törlése';
$string['deleteallratings'] = 'Az összes értékelés törlése';
$string['deletecategory'] = 'Kategória törlése: {$a}';
$string['deletecategorycheck'] = 'Teljesen biztos abban, hogy az egész \'{$a}\' kategóriát törölni kívánja? Ezzel minden kurzus a felette lévő kategóriába, ha ilyen nincs, az Egyéb kategóriába kerül.';
$string['deletecategorycheck2'] = 'Ha törli ezt a kategóriát, el kell döntenie, mi legyen a benne lévő kurzusokkal és alkategóriákkal.';
$string['deletecategoryempty'] = 'A kategória üres.';
$string['deletecheck'] = 'A(z) {$a} törlendő?';
$string['deletecheckfiles'] = 'Biztosan törölni szeretné ezeket az állományokat?';
$string['deletecheckfull'] = 'A(z) {$a} biztosan teljesen törlendő?';
$string['deletechecktype'] = 'Biztosan törlendő: {$a->type}?';
$string['deletechecktypename'] = 'Biztosan törlendő: } "{$a->name}" {$a->type}?';
$string['deletecheckwarning'] = 'Törölni fogja ezeket az állományokat';
$string['deletecomment'] = 'A megjegyzés törlése';
$string['deletecompletely'] = 'Teljes törlés';
$string['deletecourse'] = 'Kurzus törlése';
$string['deletecoursecheck'] = 'Biztosan törölni akarja ezt a kurzust adataival együtt?';
$string['deleted'] = 'Törölve';
$string['deletedactivity'] = '{$a} törölve';
$string['deletedcourse'] = '{$a} teljesen törölve';
$string['deletednot'] = '{$a} nem törölhető!';
$string['deletelogs'] = 'Naplók törlése';
$string['deleteselected'] = 'A kiválasztott törlése';
$string['deleteselectedkey'] = 'A kiválasztott kulcs törlése';
$string['deletingcourse'] = 'A(z) {$a} törlése';
$string['deletingexistingcoursedata'] = 'Meglévő kurzusadatok törlése';
$string['deletingolddata'] = 'Korábbi adatok törlése';
$string['department'] = 'Egység';
$string['desc'] = 'Csökkenő';
$string['description'] = 'Leírás';
$string['deselectall'] = 'Kijelölések megszüntetése';
$string['detailedless'] = 'Kevésbé részletes';
$string['detailedmore'] = 'Részletesebb';
$string['directory'] = 'Könyvtár';
$string['disable'] = 'Kikapcsolás';
$string['disabledcomments'] = 'Megjegyzések kikapcsolva';
$string['displayingfirst'] = 'Csak az első {$a->count} {$a->things} jelenik meg';
$string['displayingrecords'] = '{$a} rekord megjelenítése';
$string['displayingusers'] = 'Felhasználók megjelenítése {$a->start} és {$a->end} között';
$string['displayonpage'] = 'Megjelenítés az oldalon';
$string['dndcourse'] = 'Elhúzással módosíthatja a kurzus rendezését, vagy áthelyezheti egy másik kategóriába,';
$string['dndenabled_inbox'] = 'Hozzáadáshoz húzza ide az állományokat.';
$string['dndnotsupported'] = 'A húzáson alapuló feltöltést a rendszer nem támogatja.';
$string['dndnotsupported_help'] = 'A húzáson alapuló feltöltést a böngésző nem támogatja.<br />A húzás a Chrome, a Firefox és a Safari újabb változataiban, valamint az Internet Explorer 10-es verziójától érhető el.';
$string['dndnotsupported_insentence'] = 'A húzáson alapuló feltöltést a rendszer nem támogatja.';
$string['dnduploadwithoutcontent'] = 'A feltöltésben nincs tartalom';
$string['dndworkingfile'] = 'A feltöltéshez húzza az állományokat a kurzuszsakaszokra';
$string['dndworkingfilelink'] = 'A feltöltéshez húzza az állományokat vagy az ugrópontokat a kurzuszsakaszokra';
$string['dndworkingfiletext'] = 'A feltöltéshez húzza az állományokat vagy szöveget a kurzuszsakaszokra';
$string['dndworkingfiletextlink'] = 'A feltöltéshez húzza az állományokat, szöveget vagy ugrópontokat a kurzuszsakaszokra';
$string['dndworkinglink'] = 'A feltöltéshez húzza az ugrópontokat a kurzuszsakaszokra';
$string['dndworkingtext'] = 'A feltöltéshez húzza a szöveget a kurzuszsakaszokra';
$string['dndworkingtextlink'] = 'A feltöltéshez húzza a szöveget vagy az ugrópontokat a kurzuszsakaszokra';
$string['documentation'] = 'A Moodle dokumentációja';
$string['dontsortcategories'] = 'Kategóriarendezés mellőzése';
$string['dontsortcourses'] = 'Kurzusrendezés mellőzése';
$string['down'] = 'Le';
$string['download'] = 'Letöltés';
$string['downloadall'] = 'Az összes letöltése';
$string['downloadexcel'] = 'Letöltés Excel-formában';
$string['downloadfile'] = 'Állomány letöltése';
$string['downloadods'] = 'Letöltés ODS-formában';
$string['downloadtext'] = 'Letöltés szövegként';
$string['doyouagree'] = 'Az olvasott feltételekkel egyetért?';
$string['droptoupload'] = 'Ide dobja a feltöltendő állományokat.';
$string['duplicate'] = 'Másodpéldány';
$string['duplicateconfirm'] = 'Biztosan készít {$a->modtype} másolatot \'{$a->modname}\'?';
$string['duplicatecontcourse'] = 'Vissza a kurzushoz';
$string['duplicatecontedit'] = 'Az új példány szerkesztése';
$string['duplicatesuccess'] = '{$a->modtype} másolata \'{$a->modname}\' sikeresen létrehozva';
$string['duplicatinga'] = '{$a} másodpéldányának elkészítése';
$string['edhelpaspellpath'] = 'A szerkesztőn belüli helyesírás-ellenőrzéshez aspell 0.50 vagy későbbi verzióval KELL a szerveren rendelkezni, és meg kell adni az aspell programhoz vezető útvonalat. Unix-/Linux-rendszereken ez általában /usr/bin/aspell, de lehet egyéb.';
$string['edhelpbgcolor'] = 'Szerkesztési terület háttérszínének megadása. Érvényes érték pl.: #ffffff vagy white';
$string['edhelpcleanword'] = 'Ezzel kapcsolható ki vagy be a Word speciális formázásának a szűrése.';
$string['edhelpenablespelling'] = 'Helyesírás-ellenőrzés ki-/bekapcsolása. A második érték az <strong>alapszótár</strong>. A rendszer ezt az értéket használja, ha az aspell nem rendelkezik a felhasználó nyelve szerinti szótárral.';
$string['edhelpfontfamily'] = 'A font-family tulajdonsággal betűkészletcsaládok nevei és/vagy általános betűcsaládnevek adhatók meg. A neveket vesszővel kell egymástól elválasztani.';
$string['edhelpfontlist'] = 'A szerkesztők lenyíló menüjén megjelenő betűkészletek megadása.';
$string['edhelpfontsize'] = 'Az alapmérettel adható meg a betűkészlet mérete. Érvényes érték pl.: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Szerkesztés';
$string['edita'] = 'Szerkesztés';
$string['editcategorysettings'] = 'Kategóriabeállítások szerkesztése';
$string['editcategorythis'] = 'Ezen kategória szerkesztése';
$string['editcoursesettings'] = 'Kurzusbeállítások szerkesztése';
$string['editfiles'] = 'Állományok szerkesztése';
$string['editgroupprofile'] = 'Csoportprofil szerkesztése';
$string['editinga'] = '{$a} szerkesztése';
$string['editingteachershort'] = 'Szerkesztő';
$string['editlock'] = 'Ez az érték nem szerkeszthető!';
$string['editmyprofile'] = 'Profil szerkesztése';
$string['editorbgcolor'] = 'Háttérszín';
$string['editorcleanonpaste'] = 'Beillesztéskor Worddel készült HTML megtisztítása';
$string['editorcommonsettings'] = 'Általános beállítások';
$string['editordefaultfont'] = 'Alapértelmezett betűkészlet';
$string['editorenablespelling'] = 'Helyesírás-ellenőrzés bekapcsolása';
$string['editorfontlist'] = 'Betűkészletek felsorolása';
$string['editorfontsize'] = 'Alapértelmezett betűméret';
$string['editorresettodefaults'] = 'Alapértékek visszaállítása';
$string['editorsettings'] = 'A szerkesztő beállításai';
$string['editorshortcutkeys'] = 'A szerkesztő gyorsbillentyűi';
$string['editsettings'] = 'Beállítások szerkesztése';
$string['editsummary'] = 'Összegzés szerkesztése';
$string['editthisactivity'] = 'Tevékenység szerkesztése';
$string['editthiscategory'] = 'Kategória szerkesztése';
$string['edittitle'] = 'Cím szerkesztése';
$string['edittitleinstructions'] = 'Mégse: Esc, kész: Enter';
$string['edituser'] = 'Felhasználói fiókok szerkesztése';
$string['email'] = 'E-mail cím';
$string['emailactive'] = 'E-mail bekapcsolva';
$string['emailagain'] = 'E-mail (ismét)';
$string['emailalreadysent'] = 'Jelszó-visszaállítási e-mail kiküldve. Nézze meg levelesében.';
$string['emailcharset'] = 'E-mail karakterkészlete';
$string['emailconfirm'] = 'Fiókjának megerősítése';
$string['emailconfirmation'] = 'Üdvözöljük, {$a->firstname}! Új fiókot igényeltek a(z) \'{$a->sitename}\' portálon az Ön e-mail címével. Új fiókjának megerősítéséhez látogasson el erre a weboldalra: {$a->link}. Általában a levelező programokban ez kék ugrópontként jelenik meg, amelyre csak kattintania kell. Ha ez nem működik, másolja ki a címet a böngészőablak tetején lévő címsorba. Ha segítségre van szüksége, lépjen kapcsolatba a portál rendszergazdájával: {$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: fiók megerősítése';
$string['emailconfirmsent'] = 'Egy e-mailt kellett kapnia {$a} címére. A levél a regisztráció kitöltéséhez szükséges egyszerű teendőket tartalmazza. Ha továbbra is nehézségekbe ütközik, lépjen kapcsolatba a portál rendszergazdájával.';
$string['emaildigest'] = 'Összesített e-mail';
$string['emaildigestcomplete'] = 'Teljes (napi e-mail minden hozzászólással)';
$string['emaildigest_help'] = 'Az egyes fórumok által használt olvasási alapbeállítás

* Ne ömlesztve - fórumüzenetenként egy e-mailt fog kapni.
* Ömlesztve - teljes üzenetek - naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tartalmával;
* Ömlesztve - csak a tárgy -
naponta egy ömlesztett e-mailt fog kapni az összes fórumüzenet tárgyával.

Fórumonként más-más beállítást is megadhat.';
$string['emaildigestoff'] = 'Nincs összesítés (a fórum minden hozzászólásáról e-mail)';
$string['emaildigestsubjects'] = 'Témák (napi e-mail csak a témákkal)';
$string['emaildisable'] = 'Ez az e-mail cím ki van kapcsolva.';
$string['emaildisableclick'] = 'Ide kattintva kapcsoljon ki minden erre a címre küldendő e-mailt.';
$string['emaildisplay'] = 'E-mail cím megjelenítése';
$string['emaildisplaycourse'] = 'Csak a kurzus résztvevői láthatják az e-mail címemet';
$string['emaildisplayhidden'] = 'Rejtett e-mail';
$string['emaildisplayno'] = 'Senki nem láthatja az e-mail címemet';
$string['emaildisplayyes'] = 'Mindenki láthatja az e-mail címemet';
$string['emailenable'] = 'Ez az e-mail cím be van kapcsolva.';
$string['emailenableclick'] = 'Ide kattintva újból bekapcsolhat minden erre a címre küldendő e-mailt.';
$string['emailexists'] = 'Ez az e-mail cím már regisztrálva van.';
$string['emailformat'] = 'E-mail formája';
$string['emailmustbereal'] = 'Megjegyzés: az e-mail címnek valódinak kell lennie';
$string['emailnotallowed'] = 'Ezeken a doméneken e-mail címek nem használhatók ({$a})';
$string['emailnotfound'] = 'Az e-mail cím nem található az adatbázisban';
$string['emailonlyallowed'] = 'Az e-mail nincs az engedélyezettek között ({$a})';
$string['emailpasswordchangeinfo'] = 'Üdvözöljük {$a->firstname}, Valaki (feltehetőleg Ön) egy új jelszó létrehozását igényelte a(z) \'{$a->sitename}\'. Jelszava módosításához látogasson el ide: {$a->link}. Általában a levelező programokban ez kék ugrópontként jelenik meg, amelyre csak kattintania kell. Ha ez nem működik, másolja ki a címet a böngészőablak tetején lévő címsorba.  Ha segítségre van szüksége, forduljon a portál rendszergazdájához: {$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Üdvözöljük {$a->firstname}, Valaki (feltehetőleg Ön) egy új jelszó létrehozását igényelte a(z) \'{$a->sitename}\' portálon lévő fiókjához. Fiókját ezen a portálon kikapcsolták és nem lehet helyreállítani, forduljon a portálon {$a->admin} rendszergazdához.';
$string['emailpasswordchangeinfofail'] = 'Üdvözöljük, {$a->firstname}! Valaki (feltehetőleg Ön) új jelszót kért a(z) {$a->sitename} portálon lévő azonosítójához. Jelszavát ezen a portálon nem lehetett helyreállítani, forduljon a portálon {$a->admin} rendszergazdához.';
$string['emailpasswordchangeinfosubject'] = '{$a}: jelszómódosítás adatai';
$string['emailpasswordconfirmation'] = 'Üdvözöljük, {$a->firstname}! Valaki (feltehetőleg Ön) új jelszó létrehozását kérte a(z) {$a->sitename} portálon lévő azonosítójához. Ennek megerősítéséhez és a jelszónak az Ön e-mail címére való elküldéséhez látogasson el erre a weboldalra: {$a->link}. Általában a levelező programokban ez kék ugrópontként jelenik meg, amelyre csak kattintania kell. Ha ez nem működik, másolja ki a címet a böngészőablak tetején lévő címsorba. Ha segítségre van szüksége, lépjen kapcsolatba a portál rendszergazdájával: {$a->admin}.';
$string['emailpasswordconfirmationsubject'] = '{$a}: jelszómódosítás megerősítése';
$string['emailpasswordconfirmmaybesent'] = 'Ha helyes felhasználónevet vagy címet adott meg, akkor kapnia kellett egy e-mailt. Benne egyszerű leírást talál ezen jelszómódosítás megerősítésére és végrehajtására vonatkozóan. Ha továbbra is gondja van, forduljon a portál rendszergazdájához.';
$string['emailpasswordconfirmnoemail'] = '<p>A megadott fiókhoz nem tartozik e-mail cím.</p> <p>Forduljon a rendszergazdához.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>A megadott adattal nem azonosítható fiók.</p> <p>Ellenőrizze az adatot ismét, majd próbálja meg újból. Ha továbbra is gondja van, forduljon a rendszergazdához.</p>';
$string['emailpasswordconfirmsent'] = 'Egy e-mailt kellett kapnia {$a} címére. A levél a regisztráció kitöltéséhez szükséges egyszerű teendőket tartalmazza. Ha továbbra is nehézségekbe ütközik, lépjen kapcsolatba a portál rendszergazdájával.';
$string['emailpasswordsent'] = 'Köszönjük a jelszómódosítás megerősítését. Egy e-mailt kellett kapnia {$a->email} címére. Az új jelszó automatikusan elkészült - előfordulhat, hogy szeretné <a href="{$a->link}">jelszavát kicserélni</a> valamilyen könnyebben megjegyezhetőre.';
$string['emailresetconfirmation'] = 'Kedves {$a->firstname},

Jelszó-visszaállítási kérelem érkezett a(z) {$a->sitename} portálon lévő \'{$a->username}\' fiókhoz. A kérelem megerősítéséhez és új jelszó beállításához térjen át ide: {$a->link} (Ez az ugrópont a kérelemtől számítva {$a->resetminutes} percig él). Ha a kérelem nem Öntől származik, nincs tennivalója. Ha segítségre van szüksége, forduljon a rendszergazdához: {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: jelszó-visszaállítási kérelem';
$string['emailresetconfirmsent'] = 'A(z) <b>{$a}</b> címre e-mail üzenetet küldtünk. <br />Benne egyszerű utasításokat talál a jelszómódosításhoz. . Ha továbbra is gondja van, forduljon a rendszergazdához.';
$string['emptydragdropregion'] = 'üres régió';
$string['enable'] = 'Bekapcsolás';
$string['encryptedcode'] = 'Titkosított kód';
$string['english'] = 'Angol';
$string['enrolmentmethods'] = 'Beiratkozási módszerek';
$string['entercourse'] = 'Kattintással lépjen be a kurzusba';
$string['enteremail'] = 'Adja meg e-mail címét.';
$string['enteremailaddress'] = 'Jelszavának törléséhez és új jelszavának e-mailben való elküldéséhez írja be az e-mail címét.';
$string['enterusername'] = 'Adja meg felhasználónevét.';
$string['entries'] = 'Bejegyzések';
$string['error'] = 'Hiba';
$string['errorcreatingactivity'] = '\'{$a}\' tevékenység péáldánya nem hozható létre';
$string['errorfiletoobig'] = '\'{$a}\' bájt korlátot meghaladó méretű állomány';
$string['errornouploadrepo'] = 'A portálon nincs bekapcsolva feltöltési adattár';
$string['errorwhenconfirming'] = 'Még nem kapott megerősítést, mert hiba lépett fel. Ha egy e-mailen keresztül jutott ide, ellenőrizze, hogy az e-mail küldése során a címnek nem csak egy részét adta-e meg. Lehet, hogy a kapcsolat helyreállításához ki kell másolni a címet.';
$string['eventcontentviewed'] = 'A tartalmat megtekintették';
$string['eventcoursecategorydeleted'] = 'Kategória törölve';
$string['eventcoursecontentdeleted'] = 'Kurzustartalom törölve';
$string['eventcoursecreated'] = 'Kurzus létrehozva';
$string['eventcoursedeleted'] = 'Kurzus törölve';
$string['eventcoursemodulecreated'] = 'Kurzusmodul létrehozva';
$string['eventcoursemoduledeleted'] = 'Kurzusmodul törölve';
$string['eventcoursemoduleupdated'] = 'Kurzusmodul frissítve';
$string['eventcourseresetended'] = 'A kurzus visszaállítása véget ért.';
$string['eventcourseresetstarted'] = 'A kurzus visszaállítása elkezdődött.';
$string['eventcourserestored'] = 'Kurzus helyreállítva';
$string['eventcoursesectionupdated'] = 'Kurzusrész frissítve';
$string['eventcourseupdated'] = 'Kurzus frissítve';
$string['eventusercreated'] = 'Felhasználó létrehozva';
$string['eventuserdeleted'] = 'Felhasználó törölve';
$string['eventuserlistviewed'] = 'Megtekintett felhasználói lista';
$string['eventuserloggedout'] = 'A felhasználó kilépett';
$string['eventuserprofileviewed'] = 'Megtekintett felhasználói profil';
$string['eventuserupdated'] = 'Felhasználó frissítve';
$string['everybody'] = 'Mindenki';
$string['executeat'] = 'Végrehajtási időpont';
$string['existing'] = 'Létező';
$string['existingadmins'] = 'Létező rendszergazdák';
$string['existingcourse'] = 'Létező kurzus';
$string['existingcourseadding'] = 'Létező kurzus, adatok hozzáadása';
$string['existingcoursedeleting'] = 'Létező kurzus, először törlés';
$string['existingcreators'] = 'Létező kurzuskészítők';
$string['existingstudents'] = 'Beiratkozott tanulók';
$string['existingteachers'] = 'Létező tanárok';
$string['expand'] = 'Kinyitás';
$string['expandall'] = 'Az összes kibontása';
$string['expandcategory'] = '{$a} kinyitása';
$string['explanation'] = 'Magyarázat';
$string['extendenrol'] = 'Beiratkozás meghosszabbítása (egyéni)';
$string['extendperiod'] = 'Meghosszabbított időszak';
$string['failedloginattempts'] = '{$a->attempts} sikertelen belépés utolsó belépése óta';
$string['failedloginattemptsall'] = '{$a->attempts} sikertelen belépés {$a->accounts} esetén';
$string['feedback'] = 'Visszajelzés';
$string['file'] = 'Állomány';
$string['fileexists'] = 'Már van egy {$a} nevű fájl-';
$string['filemissing'] = '{$a} hiányzik';
$string['files'] = 'Állományok';
$string['filesanduploads'] = 'Állományok és feltöltések';
$string['filesfolders'] = 'Állományok/mappák';
$string['filetoolarge'] = 'feltöltéshez túl nagy';
$string['fileuploadwithcontent'] = 'Az állományfeltöltésekben nem szerepelhet tartalomparaméter';
$string['filloutallfields'] = 'Töltsön ki minden mezőt ezen az űrlapon';
$string['filter'] = 'Szűrő';
$string['findmorecourses'] = 'További kurzusok keresése...';
$string['first'] = 'Első';
$string['firstaccess'] = 'Első hozzáférés';
$string['firstname'] = 'Keresztnév';
$string['firstnamephonetic'] = 'Keresztnév - fonetikusan';
$string['firstsiteaccess'] = 'Első belépés a portálra';
$string['firsttime'] = 'Most van itt először?';
$string['folder'] = 'Mappa';
$string['folderclosed'] = 'Bezárt mappa';
$string['folderopened'] = 'Kinyitott mappa';
$string['followingoptional'] = 'A következők kitöltése nem kötelező';
$string['followingrequired'] = 'A következők kitöltése kötelező';
$string['for'] = 'Kinek';
$string['force'] = 'Csoportos részvétel előírása';
$string['forcelanguage'] = 'Nyelv előírása';
$string['forceno'] = 'Ne írja elő';
$string['forcepasswordchange'] = 'Jelszómódosítás előírása';
$string['forcepasswordchangecheckfull'] = 'Biztosan jelszómódosítást kíván előírni {$a} esetén?';
$string['forcepasswordchange_help'] = 'Felszólítja a felhasználót, hogy következő belépésekor változtassa meg.';
$string['forcepasswordchangenot'] = '{$a} esetén nem lehetett jelszómódosítást előírni';
$string['forcepasswordchangenotice'] = 'Továbblépéshez módosítsa jelszavát.';
$string['forcetheme'] = 'Stílus előírása';
$string['forgotaccount'] = 'Elveszítette jelszavát?';
$string['forgotten'] = 'Elfelejtette felhasználónevét vagy jelszavát?';
$string['forgottenduplicate'] = 'Az e-mail cím több felhasználói fiókhoz tartozik, helyette adja meg a felhasználónevet';
$string['forgotteninvalidurl'] = 'Érvénytelen jelszó-visszaállítási URL';
$string['format'] = 'Forma';
$string['format_help'] = 'A kurzusoldal elrendezését meghatározó kurzusforma.

* Egyedi tevékenység - Ez a forma a kurzus kezdőoldalán egyetlen tevékenységet vagy tananyagot (pl. egy tesztet vagy egy SCORM-csomagot).

* Társas forma - A kurzusoldalon egy fórum jelenik meg.

* Témaforma - A kurzus témákba szerveződik.

* Heti forma - A kurzus hetenkénti elrendezésben szerepel, az első hét a kurzus kezdési időpontjával indul.';
$string['formathtml'] = 'HTML-forma';
$string['formatmarkdown'] = 'Markdown-forma';
$string['formatplain'] = 'Egyszerű szöveg';
$string['formattext'] = 'Automatikus Moodle-forma';
$string['formattexttype'] = 'Formázás';
$string['framesetinfo'] = 'Ezen keretkészlet-dokumentum tartalma:';
$string['from'] = 'Mikortól';
$string['frontpagecategorycombo'] = 'Lenyíló lista';
$string['frontpagecategorynames'] = 'Kategóriák felsorolása';
$string['frontpagecourselist'] = 'Kurzusok felsorolása';
$string['frontpagecoursesearch'] = 'Kurzuskereső mező';
$string['frontpagedescription'] = 'Kezdőoldal leírása';
$string['frontpagedescriptionhelp'] = 'A portál ezen leírása a kezdőoldalon lesz látható.';
$string['frontpageenrolledcourselist'] = 'Felvett kurzusok';
$string['frontpageformat'] = 'Kezdőoldal formája';
$string['frontpageformatloggedin'] = 'Kezdőoldal formája belépéskor';
$string['frontpagenews'] = 'Hírek';
$string['frontpagesettings'] = 'A kezdőoldal beállításai';
$string['fulllistofcourses'] = 'Minden kurzus';
$string['fullname'] = 'Teljes név';
$string['fullnamecourse'] = 'A kurzus teljes neve';
$string['fullnamecourse_help'] = 'A kurzus teljes neve a kurzusoldalak tetején és a kurzusok felsorolásában jelenik meg.';
$string['fullnamedisplay'] = '{$a->lastname} {$a->firstname}';
$string['fullnameuser'] = 'A felhasználó teljes neve';
$string['fullprofile'] = 'Teljes profil';
$string['fullsitename'] = 'A portál teljes neve';
$string['functiondisabled'] = 'Ez a funkció jelenleg ki van kapcsolva';
$string['general'] = 'Általános';
$string['geolocation'] = 'szélesség - hosszúság';
$string['gettheselogs'] = 'Naplók behozása';
$string['go'] = 'Mehet';
$string['gpl'] = 'Copyright (C) 1999-2004   Martin Dougiamas  (http://moodle.com) Ez a program ingyenes szoftver; továbbadhatja és/vagy módosíthatja a Free Software Foundation által kibocsátott GNU General Public License feltételeinek a betartásával - vagy a licenc 2-es, vagy (választhatóan) annak bármely későbbi verziója szerint. A programot abban a reményben adjuk közre, hogy hasznosnak bizonyul, azonban MINDENNEMŰ GARANCIA VÁLLALÁSA NÉLKÜL; ideértve az ELADHATÓSÁG vagy valamely KONKRÉT CÉLRA VALÓ ALKALMASSÁG szavatolását. A további részleteket lásd: http://docs.moodle.org/en/License';
$string['gpl3'] = 'Copyright (C) 1999-tól: Martin Dougiamas  (http://moodle.com)
Ez a program ingyenes szoftver; továbbadhatja és/vagy módosíthatja a Free Software Foundation által kibocsátott GNU General Public License feltételeinek a betartásával - vagy a licenc 3-as, vagy (választhatóan) annak bármely későbbi verziója szerint.
A programot abban a reményben adjuk közre, hogy hasznosnak bizonyul, azonban MINDENNEMŰ GARANCIA VÁLLALÁSA NÉLKÜL; ideértve az ELADHATÓSÁG vagy valamely KONKRÉT CÉLRA VALÓ ALKALMASSÁG szavatolását.
A Moodle-licenccel kapcsolatos további részleteket lásd: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL-licenc';
$string['grade'] = 'Pont';
$string['grades'] = 'Pontok';
$string['gravatarenabled'] = 'A <a href="http://www.gravatar.com/">Gravatar</a> a portálon be van kapcsolva. Ha nem tölt föl profilképet, akkor a Moodle megpróbál egyet a Gravatarból feltölteni Önnek.';
$string['group'] = 'Csoport';
$string['groupadd'] = 'Új csoport hozzáadása';
$string['groupaddusers'] = 'A kiválasztott csoport hozzáadása';
$string['groupextendenrol'] = 'Beiratkozás meghosszabbítása (mindenki számára)';
$string['groupfor'] = 'csoport számára';
$string['groupinfo'] = 'Információk a kiválasztott csoportról';
$string['groupinfoedit'] = 'Csoportbeállítások szerkesztése';
$string['groupinfomembers'] = 'Információk a kiválasztott tagokról';
$string['groupinfopeople'] = 'Információk a kiválasztott személyekről';
$string['groupmembers'] = 'Csoporttagok';
$string['groupmemberssee'] = 'Csoporttagok megtekintése';
$string['groupmembersselected'] = 'A kiválasztott csoport tagjai';
$string['groupmode'] = 'Csoportos részvétel';
$string['groupmodeforce'] = 'Csoportos részvétel előírása';
$string['groupmy'] = 'Csoportom';
$string['groupnonmembers'] = 'Csoportba nem tartozók';
$string['groupnotamember'] = 'Ön nem tagja annak a csoportnak';
$string['grouprandomassign'] = 'Véletlenszerű hozzárendelés a csoportokhoz';
$string['groupremove'] = 'A kiválasztott csoport eltávolítása';
$string['groupremovemembers'] = 'A kiválasztott tagok eltávolítása';
$string['groups'] = 'Csoportok';
$string['groupsnone'] = 'Nincs csoport';
$string['groupsseparate'] = 'Külön csoportok';
$string['groupsvisible'] = 'Látható csoportok';
$string['guest'] = 'Vendég';
$string['guestdescription'] = 'A vendégek általában kevés jogosultsággal rendelkeznek és nem tudnak sehova szöveget beírni.';
$string['guestskey'] = 'A kóddal rendelkező vendégek beléphetnek';
$string['guestsno'] = 'Vendégek nem léphetnek be';
$string['guestsnotallowed'] = 'A(z) \'{$a}\' nem engedélyezi vendégek belépését.';
$string['guestsyes'] = 'A vendégek beléphetnek kód nélkül';
$string['guestuser'] = 'Vendég felhasználó';
$string['guestuserinfo'] = 'Ez egy speciális felhasználó, akinek csak olvasási joga van egyes kurzusokhoz.';
$string['help'] = 'Súgó';
$string['helpprefix2'] = 'Súgó ehhez: {$a}';
$string['helpwiththis'] = 'Súgó ehhez';
$string['hiddenassign'] = 'Rejtett feladat';
$string['hiddenfromstudents'] = 'Tanulók elől rejtve';
$string['hiddensections'] = 'Rejtett részek';
$string['hiddensectionscollapsed'] = 'A rejtett részek összecsukott formában jelennek meg';
$string['hiddensections_help'] = 'Ezzel az opcióval azt határozhatja meg, hogy a kurzusban lévő rejtett részek összecsukott formában jelenjenek-e meg a tanulók számár (pl. heti forma esetén hasznos,
mert így az ünnepnapok elkülönülnek).
Ha kívánja, teljesen el is rejtheti őket.';
$string['hiddensectionsinvisible'] = 'A rejtett részek teljesen láthatatlanok';
$string['hide'] = 'Elrejtés';
$string['hideadvancedsettings'] = 'Részletes beállítások elrejtése';
$string['hidepicture'] = 'Kép elrejtése';
$string['hidesection'] = 'A(z) {$a} szekció elrejtése';
$string['hidesettings'] = 'Beállítások elrejtése';
$string['hideshowblocks'] = 'Blokkok elrejtése vagy megjelenítése';
$string['hits'] = 'Találatok';
$string['hitsoncourse'] = '{$a->username} találatai a(z) {$a->coursename} kurzusban';
$string['hitsoncoursetoday'] = '{$a->username} mai találatai a(z) {$a->coursename} kurzusban';
$string['home'] = 'Kezdőoldal';
$string['hour'] = 'óra';
$string['hours'] = 'óra';
$string['howtomakethemes'] = 'Új stílusok készítése';
$string['htmleditor'] = 'HTML-szerkesztő használata';
$string['htmleditoravailable'] = 'A HTML-szerkesztő elérhető.';
$string['htmleditordisabled'] = 'Felhasználói profiljában kikapcsolta a HTML-szerkesztőt';
$string['htmleditordisabledadmin'] = 'A rendszergazda nem engedélyezte a HTML-szerkesztő használatát ezen a portálon';
$string['htmleditordisabledbrowser'] = 'A HTML-szerkesztő nem elérhető, mert böngészője nem kompatibilis';
$string['htmlfilesonly'] = 'Csak HTML-állományok';
$string['htmlformat'] = 'Szerkesztett HTML-forma';
$string['icon'] = 'Ikon';
$string['icqnumber'] = 'ICQ-szám';
$string['idnumber'] = 'Azonosítószám';
$string['idnumbercourse'] = 'A kurzus azonosítószáma';
$string['idnumbercoursecategory'] = 'Kategória azonosítószáma';
$string['idnumbercoursecategory_help'] = 'Egy kurzuskategória azonosítószáma csak a kategória külső rendszerekhez való illesztésére használatos, és a portálon sehol nem látható. Ha a kategória hivatalos kódnévvel rendelkezik, azt itt m,egadhatja, ellenkező esetben a mezőt üresen hagyhatja.';
$string['idnumbercourse_help'] = '<p>Egy kurzus azonosítószáma csak akkor használatos, amikor az adott kurzust külső
rendszerekkel hozza kapcsolatba - a Moodle ezt sohasem jeleníti meg. Ha a kurzus hivatalos kódnévvel
rendelkezik, azt használja itt, egyébként hagyja üresen.</p>';
$string['idnumbergroup'] = 'Csoport azonosítószáma';
$string['idnumbergroup_help'] = 'Egy csoport azonosítószáma csak a csoport külső rendszerekkel való összehasonlítására használatos, és nem jelenik meg sehol az oldalon. Ha a csoport hivatalos kódnévvel rendelkezik, itt megadhatja, különben a mező üresen hagyható.';
$string['idnumbergrouping'] = 'Csoport azonosítószáma';
$string['idnumbergrouping_help'] = 'Egy csoport azonosítószáma csak a csoport külső rendszerekkel való összehasonlítására használatos, és nem jelenik meg sehol az oldalon. Ha a csoport hivatalos kódnévvel rendelkezik, itt megadhatja, különben a mező üresen hagyható.';
$string['idnumbermod'] = 'Azonosítószám';
$string['idnumbermod_help'] = 'Azonosítószám beállításával pontszámításhoz azonosíthat egy tevékenységet. Ha a tevékenység egyik pontszámításban sem szerepel, akkor az Azonosítószám mező üresen maradhat.
Az azonosítószámot beállíthatja az osztályozónaplóban is, bár ott csak a tevékenység beállítási oldalán szerkeszthet.';
$string['idnumbertaken'] = 'Ez az azonosítószám már foglalt';
$string['imagealt'] = 'Kép leírása';
$string['import'] = 'Importálás';
$string['importdata'] = 'Kurzusadatok importálása';
$string['importdataexported'] = 'Forráskurzusa adatainak exportálása sikerült. Folytassa a célkurzusba való importálással.';
$string['importdatafinished'] = 'Az importálás megtörtént! Térjen át kurzusára';
$string['importdatafrom'] = 'Forráskurzus keresése adatimportáláshoz:';
$string['inactive'] = 'Nincs bekapcsolva';
$string['include'] = 'Felvesz';
$string['includeallusers'] = 'Minden felhasználó felvétele';
$string['includecoursefiles'] = 'Kurzusállományok felvétele';
$string['includecourseusers'] = 'Kurzus felhasználóinak felvétele';
$string['included'] = 'Felvéve';
$string['includelogentries'] = 'Naplóbejegyzések felvétele';
$string['includemodules'] = 'Modulok felvétele';
$string['includemoduleuserdata'] = 'Modul felhasználói adatainak hozzáadása';
$string['includeneededusers'] = 'Szükséges felhasználók felvétele';
$string['includenoneusers'] = 'Nem vesz fel felhasználókat';
$string['includeroleassignments'] = 'Szerepek hozzárendelésének felvétele';
$string['includesitefiles'] = 'A kurzusban használt portálállományok felvétele';
$string['includeuserfiles'] = 'Felhasználói állományok felvétele';
$string['increasesections'] = 'Szakaszszám emelése';
$string['info'] = 'Információ';
$string['institution'] = 'Intézmény';
$string['instudentview'] = 'tanulói nézetben';
$string['interests'] = 'Érdeklődési kör';
$string['interestslist'] = 'Érdeklődési körök felsorolása';
$string['interestslist_help'] = 'Vesszőkkel elválasztva adja meg érdeklődési köreit';
$string['invalidemail'] = 'Érvénytelen e-mail cím';
$string['invalidlogin'] = 'Érvénytelen belépés, próbálja újra';
$string['invalidusername'] = 'A felhasználónévben csak kisbetűk, számok, aláhúzás (_), kötőjel (-), pont (.) és a (@) használható';
$string['invalidusernameupload'] = 'Érvénytelen felhasználónév';
$string['ip_address'] = 'IP-cím';
$string['jump'] = 'Ugrás';
$string['jumpto'] = 'Ugrás...';
$string['keep'] = 'Megtart';
$string['keepsearching'] = 'Keressen tovább';
$string['langltr'] = 'Írás iránya balról-jobbra';
$string['langrtl'] = 'Írás iránya jobbról balra';
$string['language'] = 'Nyelv';
$string['languagegood'] = 'Ez a nyelvi csomag friss! :-)';
$string['last'] = 'Utolsó';
$string['lastaccess'] = 'Utolsó belépés';
$string['lastcourseaccess'] = 'Utolsó belépés a kurzusba';
$string['lastedited'] = 'Utolsó szerkesztés';
$string['lastlogin'] = 'Utolsó belépés';
$string['lastmodified'] = 'Utolsó módosítás';
$string['lastname'] = 'Vezetéknév';
$string['lastnamephonetic'] = 'Vezetéknév - fonetikusan';
$string['lastsiteaccess'] = 'Utolsó belépés a portálra';
$string['lastyear'] = 'Tavaly';
$string['latestlanguagepack'] = 'A legfrissebb nyelvi csomagért látogasson el a moodle.org portálra';
$string['layouttable'] = 'Elrendezési táblázat';
$string['leavetokeep'] = 'A jelenlegi jelszó megtartásához hagyja üresen';
$string['legacythemeinuse'] = 'A portál kompatibilitási üzemmódban jelenik meg, mert túl régi böngészőt használ.';
$string['license'] = 'Licenc';
$string['licenses'] = 'Licencek';
$string['liketologin'] = 'Szeretne egy teljes felhasználónévvel bejelentkezni?';
$string['list'] = 'Lista';
$string['listfiles'] = '{$a} állományainak listája';
$string['listofallpeople'] = 'Az összes személy felsorolása';
$string['listofcourses'] = 'Kurzuslista';
$string['loadinghelp'] = 'Betöltés...';
$string['local'] = 'Helyi';
$string['localplugins'] = 'Helyi segédprogramok';
$string['localpluginsmanage'] = 'Helyi segédprogramok kezelése';
$string['location'] = 'Hely';
$string['log_excel_date_format'] = 'éééé hhhh n ó:pp';
$string['loggedinas'] = '{$a} néven lépett be';
$string['loggedinasguest'] = 'Jelenleg vendégként van bejelentkezve';
$string['loggedinnot'] = 'Nincs bejelentkezve.';
$string['login'] = 'Belépés';
$string['loginalready'] = 'Már belépett';
$string['loginas'] = 'Belépés mint';
$string['loginaspasswordexplain'] = 'Ennek használatához a speciális "belépés mint" jelszót kell megadnia. Ha nem ismeri, forduljon a rendszergazdához.';
$string['login_failure_logs'] = 'Sikertelen belépések naplói';
$string['loginguest'] = 'Belépés vendégként';
$string['loginsite'] = 'Belépés a portálra';
$string['loginsteps'] = 'Üdvözöljük! Ahhoz, hogy teljesen hozzáférjen a kurzusokhoz, új fiókot kell létrehoznia ezen a weboldalon. Minden kurzushoz hozzátartozhat egy egyszeri beiratkozási kulcs, amelyre egyelőre nincs szüksége. A végrehajtandó lépések: <ol> <li>Töltse ki az <a href="{$a}">Új felhasználó</a> űrlap adatait. </li> <li>Egy e-mailt kap a saját címére közvetlenül a kitöltés után.</li> <li> Olvassa el az e-mailt és kattintson a benne talált ugrópontra.</li> <li> Azonosítóját ekkor a rendszer visszaigazolja, Ön pedig ezzel sikeresen be is lépett.</li> <li>Most válassza ki azt a kurzust, amelynek résztvevője kíván lenni.</li> <li> Ha egy beiratkozási kulcsot kér a rendszer, írja be azt, amelyet a tanár adott Önnek. Ezzel be is iratkozott a kurzusra.</li> <li>Ezután szabadon beléphet a kurzusba. A továbbiakban a belépéshez csak a felhasználónevét és a jelszavát kell beírnia (az ezen az oldalon lévő űrlapba). Ezután minden kurzushoz hozzáfér, amelyre beiratkozott. </li> </ol>';
$string['loginstepsnone'] = 'Üdvözöljük!
Ahhoz, hogy teljesen hozzáférjen a kurzusokhoz, új fiókot kell létrehoznia.
Csupán egy felhasználónevet és jelszót kell kitalálnia és beírnia az ezen az oldalon lévő űrlapba!
Ha valaki már kiválasztotta a kívánt felhasználónevet, akkor újra kell próbálkoznia egy másik névvel.';
$string['loginto'] = 'Belépés ide: {$a}';
$string['logout'] = 'Kilépés';
$string['logoutconfirm'] = 'Biztosan kilép?';
$string['logs'] = 'Naplók';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">tovább</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">tovább</a> ]';
$string['lookback'] = 'Visszatekintés';
$string['mailadmins'] = 'Rendszergazdák értesítése';
$string['mailstudents'] = 'Tanulók értesítése';
$string['mailteachers'] = 'Tanárok értesítése';
$string['maincoursepage'] = 'Fő kurzusoldal';
$string['makeafolder'] = 'Mappa létrehozása';
$string['makeeditable'] = 'Ha a webszerver (pl. apache) eljárása írhatóvá teszi \'{$a}\'-t , akkor ezt az állományt közvetlenül szerkesztheti erről az oldalról';
$string['makethismyhome'] = 'Ez legyen az alapbeállítás szerinti honlapom';
$string['manageblocks'] = 'Blokkok';
$string['managecategorythis'] = 'Kategória kezelése';
$string['managecourses'] = 'Kurzusok kezelése';
$string['managedatabase'] = 'Adatbázis';
$string['manageeditorfiles'] = 'A szerkesztő által használt állományok kezelése';
$string['managefilters'] = 'Szűrők';
$string['managemodules'] = 'Modulok';
$string['manageroles'] = 'Szerepek és engedélyek';
$string['markedthistopic'] = 'A stílus aktuális stílusnak van kijelölve';
$string['markthistopic'] = 'A stílus kiválasztása aktuális stílusnak';
$string['matchingsearchandrole'] = '\'{$a->search}\' és {$a->role} egyeztetése';
$string['maxareabytesreached'] = 'Az állomány(ok) mérete nagyobb a területen rendelkezésre álló szabad helynél';
$string['maxbytesforfile'] = 'A(z) {$a} állomány mérete nagyobb a megengedettnél';
$string['maxfilesize'] = 'Új állományok maximális mérete: {$a}';
$string['maxfilesreached'] = 'Ehhez legfeljebb {$a} állományt csatolhat.';
$string['maximumchars'] = 'Maximum {$a} karakter';
$string['maximumgrade'] = 'Maximális pont';
$string['maximumgradex'] = 'Maximális pont: {$a}';
$string['maximumshort'] = 'Max.';
$string['maximumupload'] = 'Maximális feltöltési méret';
$string['maximumupload_help'] = '<p>Ez a beállítás határozza meg azt a legnagyobb állományméretet,
amelyet a tanulók a kurzus folyamán feltöltethetnek és amelyet a rendszergazda a portál beállítása során határoz meg.</p>

<p>Ezt a méretet tovább csökkentheti az egyes tevékenységmodulokhoz tartozó beállításokon keresztül. </p>';
$string['maxnumberweeks'] = 'Szekciók maximális száma';
$string['maxnumberweeks_desc'] = 'A szekció lenyíló menünek maximális száma (csak bizonyos kurzusformák esetén).';
$string['maxnumcoursesincombo'] = '<a href="{$a->link}">{$a->numberofcourses} kurzus</a> böngészése.';
$string['maxsize'] = 'max. méret: {$a}';
$string['maxsizeandareasize'] = 'Új állományok maximális mérete: {$a->size}, globális korlát: {$a->areasize}';
$string['maxsizeandattachments'] = 'Új állományok maximális mérete: {$a->size}, maximális csatolt állomány: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Új állományok maximális mérete: {$a->size}, maximum {$a->attachments} melléklet, globális korlát: {$a->areasize}';
$string['memberincourse'] = 'fő a kurzusban';
$string['messagebody'] = 'Üzenet törzse';
$string['messagedselectedusers'] = 'A kiválasztott felhasználók üzenetet kaptak és a címzettlista visszaállítódott.';
$string['messagedselectedusersfailed'] = 'Hiba történt a kiválasztott felhasználók értesítése közben. Néhányan megkaphatták az e-mailt.';
$string['messageprovider:availableupdate'] = 'Elérhető értesítések frissítésekről';
$string['messageprovider:backup'] = 'Biztonsági mentés értesítései';
$string['messageprovider:badgecreatornotice'] = 'KItűző létrehozójának értesítései';
$string['messageprovider:badgerecipientnotice'] = 'KItűző átvevőjének értesítései';
$string['messageprovider:courserequestapproved'] = 'Értesítés kurzuskérés jóváhagyásáról';
$string['messageprovider:courserequested'] = 'Értesítés kurzuskérésről';
$string['messageprovider:courserequestrejected'] = 'Értesítés kurzuskérés elutasításáról';
$string['messageprovider:errors'] = 'A portálon komoly hibák észlelhetők';
$string['messageprovider:errors_help'] = 'Ezek olyan súlyos hibák, amelyekről a rendszergazdának tudnia kell.';
$string['messageprovider:instantmessage'] = 'Felhasználók közötti személyes üzenetek';
$string['messageprovider:instantmessage_help'] = 'Itt adható meg, mi történjen azon üzenetekkel, amelyeket közvetlenül a portál más felhasználóitól kap.';
$string['messageprovider:notices'] = 'Értesítések kisebb problémákról';
$string['messageprovider:notices_help'] = 'Előfordulhat, hogy ezek az értesítések érdeklik a rendszergazdát.';
$string['messageselect'] = 'A felhasználó üzenet címzettjeként való kiválasztása';
$string['messageselectadd'] = 'Üzenet küldése';
$string['middlename'] = 'Egyéb vezetéknév';
$string['migratinggrades'] = 'Pontok átvitele';
$string['min'] = 'p';
$string['mins'] = 'perc';
$string['minute'] = 'perc';
$string['minutes'] = 'perc';
$string['miscellaneous'] = 'Egyéb';
$string['missingcategory'] = 'Kategóriát kell választania';
$string['missingcity'] = 'Hiányzó helység';
$string['missingcountry'] = 'Hiányzó ország';
$string['missingdescription'] = 'Hiányzó leírás';
$string['missingemail'] = 'Hiányzó e-mail cím';
$string['missingfirstname'] = 'Hiányzó keresztnév';
$string['missingfromdisk'] = 'Nincs a lemezen';
$string['missingfullname'] = 'Hiányzó teljes név';
$string['missinglastname'] = 'Hiányzó vezetéknév';
$string['missingname'] = 'Hiányzó név';
$string['missingnewpassword'] = 'Hiányzó új jelszó';
$string['missingpassword'] = 'Hiányzó jelszó';
$string['missingrecaptchachallengefield'] = 'Hiányzik a reCAPTCHA-feladathoz tartozó mező';
$string['missingreqreason'] = 'Hiányzó indok';
$string['missingshortname'] = 'Hiányzó rövid név';
$string['missingshortsitename'] = 'Nincs rövid név a portálhoz';
$string['missingsitedescription'] = 'Hiányzó portálleírás';
$string['missingsitename'] = 'Hiányzó portálnév';
$string['missingstrings'] = 'Lefordítatlan szövegek keresése';
$string['missingstudent'] = 'Választania kell valamit';
$string['missingsummary'] = 'Hiányzó összegzés';
$string['missingteacher'] = 'Választania kell valamit';
$string['missingurl'] = 'Hiányzó URL';
$string['missingusername'] = 'Hiányzó felhasználónév';
$string['modchooserdisable'] = 'Tevékenységválasztó kikapcsolva';
$string['modchooserenable'] = 'Tevékenységválasztó kikapcsolva';
$string['moddoesnotsupporttype'] = 'A(z) {$a->modname} modul nem támogatja {$a->type} típusú állományok feltöltését.';
$string['modified'] = 'Módosítva';
$string['moduleintro'] = 'Leírás';
$string['modulesetup'] = 'Modultáblák létrehozása';
$string['modulesuccess'] = 'A(z) {$a} táblák létrehozása sikerült';
$string['modulesused'] = 'Használatban lévő modulok';
$string['month'] = 'hónap';
$string['months'] = 'hónap';
$string['moodledocs'] = 'Moodle-dokumentumok';
$string['moodledocslink'] = 'Az oldalhoz tartozó Moodle-dokumentumok';
$string['moodlerelease'] = 'Moodle-kiadás';
$string['moodleversion'] = 'Moodle-verzió';
$string['more'] = 'tovább';
$string['morehelp'] = 'További segítség';
$string['moreinformation'] = 'További tájékoztatás erről a hibáról';
$string['moreprofileinfoneeded'] = 'Áruljon el többet magáról';
$string['mostrecently'] = 'legutoljára';
$string['move'] = 'Áthelyezés';
$string['movecategoriessuccess'] = '{$a->count} kategória  \'{$a->to}\' kategória alá sikeresen áthelyezve';
$string['movecategoriestotopsuccess'] = '{$a->count} kategória sikeresen áthelyezve a felső szintre';
$string['movecategorycontentto'] = 'Áthelyezés ide';
$string['movecategorysuccess'] = '{$a->moved} kategória  \'{$a->to}\' kategória alá sikeresen áthelyezve';
$string['movecategoryto'] = 'Kategória áthelyezése ide:';
$string['movecategorytotopsuccess'] = '\'{$a->moved}\' kategória sikeresen áthelyezve a felső szintre';
$string['movecontent'] = '{$a} mozgatása';
$string['movecontentstoanothercategory'] = 'Tartalom áthelyezése egy másik kategóriába';
$string['movecoursemodule'] = 'Tananyag áthelyezése';
$string['movecoursesection'] = 'Szakasz áthelyezése';
$string['movecourseto'] = 'Kurzus áthelyezése ide:';
$string['movedown'] = 'Lejjebb';
$string['movefilestohere'] = 'Állományok áthelyezése ide';
$string['movefull'] = '{$a} áthelyezése ide';
$string['movehere'] = 'Áthelyezés ide';
$string['moveleft'] = 'Mozgatás balra';
$string['moveright'] = 'Mozgatás jobbra';
$string['movesection'] = 'A(z) {$a} szekció áthelyezése';
$string['moveselectedcategoriesto'] = 'A kiválasztott kategóriák áthelyezése ide';
$string['moveselectedcoursesto'] = 'A kiválasztott kurzusok áthelyezése ...';
$string['movetoanotherfolder'] = 'Áthelyezés másik mappába';
$string['moveup'] = 'Feljebb';
$string['msnid'] = 'MSN-azonosító';
$string['mustchangepassword'] = 'Az új jelszó nem lehet azonos a mostanival.';
$string['mustconfirm'] = 'Meg kell erősítenie a belépését';
$string['mycourses'] = 'Kurzusaim';
$string['myfiles'] = 'Saját állományaim';
$string['myfilesmanage'] = 'Saját állományaim kezelése';
$string['myhome'] = 'Honlapom';
$string['mymoodledashboard'] = 'Moodle-irányítópultom';
$string['myprofile'] = 'Profilom';
$string['name'] = 'Név';
$string['nameforlink'] = 'Mi legyen az ugrópont neve?';
$string['nameforpage'] = 'Név';
$string['navigation'] = 'Navigáció';
$string['needed'] = 'Szükséges';
$string['never'] = 'Soha';
$string['neverdeletelogs'] = 'Soha ne törölje a naplókat';
$string['new'] = 'Új';
$string['newaccount'] = 'Új fiók';
$string['newcourse'] = 'Új kurzus';
$string['newpassword'] = 'Új jelszó';
$string['newpasswordfromlost'] = '<strong>FIGYELEM:</strong> A <strong>jelenlegi jelszavát</strong> a jelszóvisszanyerés során az elküldendő két e-mail közül a <strong>másodikban<strong/> küldjük el Önnek. A képernyőn való továbblépés előtt ellenőrizze, megkapta-e cserejelszavát.';
$string['newpassword_help'] = 'A jelenlegi jelszó megtartásához hagyja üresen.';
$string['newpasswordtext'] = 'Üdvözöljük, {$a->firstname}! Az Ön jelszava a(z) \'{$a->sitename}\' portálon megváltozott és egy új, ideiglenes jelszót kapott. A jelenlegi belépési információi: felhasználónév: {$a->username}, jelszó: {$a->newpassword}. Kérjük, a jelszó megváltoztatásához térjen át erre az oldalra: {$a->link}. Általában a levelező programokban ez kék ugrópontként jelenik meg, amelyre csak kattintania kell. Ha ez nem működik, másolja ki a címet a böngészőablak tetején lévő címsorba. Üdvözlettel: \'{$a->sitename}\' rendszergazda, {$a->signoff}';
$string['newpicture'] = 'Új kép';
$string['newpicture_help'] = 'Egy képet feltöltéséhez válasszon egy JPG vagy PNG formátumban lévő képet, majd kattintson a "Profil frissítése" gombra. A kép négyzet alakú és 100x100 képernyőpont méretű lesz.';
$string['newsitem'] = 'hír';
$string['newsitems'] = 'hírek';
$string['newsitemsnumber'] = 'Megjelenítendő hírek száma';
$string['newsitemsnumber_help'] = '<p>A heti és a téma szerinti kurzusformának része egy speciális Hírek
elnevezésű fórum. Ez a fórum alkalmas olyan üzenetek küldésére,
amelyeket minden tanuló olvashat. (Alaphelyzetben a rendszer minden tanulót felvesz a fórumba, az üzeneteket a tanulók e-mailben kapják meg.)</p>
<p>Ez a beállítás határozza meg, hány friss üzenet jelenjen meg a kurzus
oldalán, jobbra lent, egy híreket tartalmazó négyzetben.</p>

<p>Ha ezt az értéket 0-ra állítja, akkor a híreket tartalmazó
négyzet meg sem jelenik. </p>';
$string['newuser'] = 'Új felhasználó';
$string['newusernewpasswordsubj'] = 'Új fiók';
$string['newusernewpasswordtext'] = 'Üdvözöljük, {$a->firstname}! A(z) \'{$a->sitename}\' portálon egy új felhasználói nevet és ideiglenes jelszót kapott. A jelenlegi belépési információi:  felhasználónév: {$a->username}, jelszó: {$a->newpassword} (első belépésekor a jelszót meg kell változtatnia). A(z) \'{$a->sitename}\' használatához lépjen be itt: {$a->link}. Általában a levelező programokban ez kék ugrópontként jelenik meg, amelyre csak kattintania kell. Ha ez nem működik, másolja ki a címet a böngészőablak tetején lévő címsorba. Üdvözlettel: \'{$a->sitename}\' rendszergazda, {$a->signoff}';
$string['newusers'] = 'Új felhasználók';
$string['newwindow'] = 'Új ablak';
$string['next'] = 'Következő';
$string['nextsection'] = 'Következő szekció';
$string['no'] = 'Nem';
$string['noblockstoaddhere'] = 'Nincs az oldalhoz hozzáadható blokk.';
$string['nobody'] = 'Senki';
$string['nochange'] = 'Nincs változás';
$string['nocomments'] = 'Nincs megjegyzés.';
$string['nocourses'] = 'Nincs kurzus';
$string['nocoursesfound'] = 'A \'{$a}\' szavakkal nincsenek kurzusok';
$string['nocoursesyet'] = 'Ebben a kategóriában nincsenek kurzusok';
$string['nodstpresets'] = 'A rendszergazda nem kapcsolta be a nyári időszámítás használatát.';
$string['nofilesselected'] = 'A visszaállításhoz nincs  kiválasztva állomány';
$string['nofilesyet'] = 'A kurzusához még nincsenek feltöltve állományok.';
$string['nograde'] = 'Nincs pont';
$string['nohelpforactivityorresource'] = 'A tananyaghoz vagy tevékenységhez nincs súgó';
$string['noimagesyet'] = 'A kurzusához még nincsenek képek feltöltve.';
$string['nologsfound'] = 'Nincsenek naplók';
$string['nomatchingusers'] = 'Nincs {$a} szerint megfelelő felhasználó';
$string['nomorecourses'] = 'Nincs több ennek megfelelő kurzus';
$string['nomoreidnumber'] = 'Nem használ azonosítószámot az ütközések elkerülésére';
$string['none'] = 'Nincs';
$string['noneditingteacher'] = 'Nem szerkesztő tanár';
$string['noneditingteacherdescription'] = 'A nem szerkesztő tanárok taníthatnak kurzusokat és osztályozhatnak tanulókat, de a tevékenységeket nem módosíthatják.';
$string['nonstandard'] = 'Nem standard';
$string['nopendingcourses'] = 'Nincs jóváhagyásra váró kurzus';
$string['nopotentialadmins'] = 'Nincs lehetséges rendszergazda';
$string['nopotentialcreators'] = 'Nincs lehetséges kurzuskészítő';
$string['nopotentialstudents'] = 'Nincs lehetséges tanuló';
$string['nopotentialteachers'] = 'Nincs lehetséges tanár';
$string['norecentactivity'] = 'Nincs újabb tevékenység';
$string['noreplybouncemessage'] = 'Választ nem váró e-mail címre válaszolt. Ha fórumra próbált választ küldeni, használja ehelyett a(z) {$a} fórumokat. E-mailjének tartalma:';
$string['noreplybouncesubject'] = '{$a} - visszapattanó e-mail.';
$string['noreplyname'] = 'Ne válaszoljon erre az e-mailre';
$string['noresetrecord'] = 'Nincs adat a visszaállítási kérelemről. Indítson új jelszó-visszaállítási kérelmet.';
$string['noresults'] = 'Nincs eredmény';
$string['normal'] = 'Szokásos';
$string['normalfilter'] = 'Szokásos keresés';
$string['nosite'] = 'Nem található portálszintű kurzus';
$string['nostudentsfound'] = 'Nincs {$a}';
$string['nostudentsingroup'] = 'Ebben a csoportban még nincsenek tanulók';
$string['nostudentsyet'] = 'Ebbe a kurzusba még nem iratkoztak be tanulók';
$string['nosuchemail'] = 'Nincs ilyen e-mail cím';
$string['notavailable'] = 'Nem vehető fel';
$string['noteachersyet'] = 'Ehhez a kurzushoz még nincsenek tanárok';
$string['notenrolled'] = '{$a} nem vette fel ezt a kurzust.';
$string['notenrolledprofile'] = 'Ez a profil nem elérhető, mert a felhasználó nem vette fel a kurzust.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Megjegyzés:</strong> A biztonsági mentés visszaállításához nem görgethetők a dátumok, mert nincs meg ehhez az engedélye.';
$string['noteuserschangednonetocourse'] = '<strong>Megjegyzés:<strong> a kurzus felhasználói azonosítóit a felhasználói adatok (tevékenységekben, állományokban vagy üzenetekben való) helyreállítása során vissza kell állítani. Ezt a beállítást megváltoztattuk Önnek.';
$string['nothingnew'] = 'Semmi hír az utolsó belépés óta';
$string['nothingtodisplay'] = 'Nincs mit megjeleníteni';
$string['notice'] = 'Tájékoztatás';
$string['noticenewerbackup'] = 'Ez a biztonsági mentés a Moodle {$a->backuprelease} ({$a->backupversion}) verziójával készült, amely újabb a most telepített Moodle {$a->serverrelease} ({$a->serverversion}) szerververziónál. Ezért némi eltérés fordulhat elő, mert a mentett állományok kompatibilitása visszafelé nem garantálható.';
$string['notifications'] = 'Értesítések';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, felhasználó: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Itt tekintheti meg ezeket a naplókat:
{$a}/report/log/index.php?id=1&amp;chooselog=1&amp;modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'A(z) {$a} sikertelen belépési kísérleteinek felsorolása az Ön utolsó értesítése óta';
$string['notifyloginfailuressubject'] = '{$a} :: értesítés sikertelen belépésekről';
$string['notincluded'] = 'Nincs felvéve';
$string['notingroup'] = 'Ezen tevékenység megtekintéséhez egy csoporthoz kell tartoznia.';
$string['notpublic'] = 'Nem nyilvános!';
$string['nousersfound'] = 'Nincs felhasználó';
$string['nousersmatching'] = 'Nincs \'{$a}\' szerint megfelelő felhasználó';
$string['nousersyet'] = 'Még nincsenek felhasználók';
$string['novalidcourses'] = 'Nem jeleníthetők meg érvényes kurzusok';
$string['now'] = 'most';
$string['numattempts'] = '{$a} sikertelen belépés';
$string['numberofcourses'] = 'Kurzusok száma';
$string['numberweeks'] = 'Szekciók száma';
$string['numdays'] = '{$a} nap';
$string['numhours'] = '{$a} óra';
$string['numletters'] = '{$a} betű';
$string['numminutes'] = '{$a} perc';
$string['nummonths'] = '{$a} hónap';
$string['numseconds'] = '{$a} másodperc';
$string['numviews'] = '{$a} nézet';
$string['numweeks'] = '{$a} hét';
$string['numwords'] = '{$a} szó';
$string['numyears'] = '{$a} év';
$string['ok'] = 'Rendben';
$string['oldpassword'] = 'Jelenlegi jelszó';
$string['olduserdirectory'] = 'Ez a régi felhasználói könyvtár, a továbbiakban nincs rá szükség. Nyugodtan kitörölheti. A benne lévő állományok másolata átkerült az ÚJ felhasználói könyvtárba.';
$string['opentoguests'] = 'Vendégek bekapcsolódása';
$string['optional'] = 'opcionális';
$string['options'] = 'lehetőségek';
$string['order'] = 'Sorrend';
$string['originalpath'] = 'Eredeti útvonal';
$string['orphanedactivitiesinsectionno'] = 'Árván maradt tevékenységek ({$a} szakasz)';
$string['other'] = 'Más';
$string['outline'] = 'Vázlat';
$string['outlinereport'] = 'Vázlatos jelentés';
$string['page'] = 'Oldal';
$string['pagea'] = '{$a} oldal';
$string['pageheaderconfigablock'] = '%fullname% egyik blokkjának beállítása';
$string['pagepath'] = 'Oldal útvonala';
$string['pageshouldredirect'] = 'Az oldal automatikusan átirányítódik. Ha nem történik semmi, használja az alábbi Tovább gombot.';
$string['parentcategory'] = 'Szülőkategória';
$string['parentcoursenotfound'] = 'A főkurzus nem található!';
$string['parentfolder'] = 'Főkönyvtár';
$string['participants'] = 'Résztvevők';
$string['participantslist'] = 'Résztvevők felsorolása';
$string['participationratio'] = 'Részvételi arány';
$string['participationreport'] = 'Jelentés a részvételről';
$string['password'] = 'Jelszó';
$string['passwordchanged'] = 'A jelszó megváltozott';
$string['passwordconfirmchange'] = 'Jelszómódosítás megerősítése';
$string['passwordextlink'] = 'Elveszett jelszavának visszanyeréséhez az alábbi ugrópont áll rendelkezésre. Ezzel kilép a Moodle-ból.';
$string['passwordforgotten'] = 'Elfelejtett jelszó';
$string['passwordforgotteninstructions'] = 'Adatainak szerepelni kell a felhasználói adatbázisban. Az adott mezőben adja meg vagy a Moodle-felhasználói nevét, vagy a rögzített e-mail címét. Mindkettőt nem kell megadnia.';
$string['passwordforgotteninstructions2'] = 'Jelszavának visszaállításához adja meg alább felhasználónevét vagy e-mail címét. Ha szerepel az adatbázisban, e-mailt küldünk az e-mail címére, melyben tájékoztatjuk, hogy léphet be ismét.';
$string['passwordnohelp'] = 'Nem lehet visszakeresni elveszett jelszavát. Forduljon a Moodle rendszergazdájához.';
$string['passwordrecovery'] = 'Igen, kérek segítséget a belépéshez';
$string['passwordsdiffer'] = 'A jelszavak nem egyeznek';
$string['passwordsent'] = 'A jelszó elküldve';
$string['passwordsenttext'] = '<p>Egy e-mailt küldtünk erre a címére: {$a->email}.</p> <p>Ellenőrizze levelesládáját, megérkezett-e új jelszava. Az új jelszó automatikusan jött létre, így lehet, hogy <a href="{$a->link}">egy könnyebben megjegyezhetőre szeretné módosítani</a>.</p>';
$string['passwordset'] = 'Jelszava beállítva';
$string['path'] = 'Útvonal';
$string['pathnotexists'] = 'Az útvonal a szerverén nem létezik!';
$string['pathslasherror'] = 'Az útvonal nem végződhet perjellel!';
$string['paymentinstant'] = 'A fizetéshez és a perceken belüli beiratkozáshoz használja az alábbi gombot!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> folyamatban</small>)';
$string['paymentrequired'] = 'Ebbe a kurzusba csak fizetés után léphet be.';
$string['payments'] = 'Befizetések';
$string['paymentsorry'] = 'Köszönjük a befizetést! Sajnos még nem sikerült teljesen feldolgozni, ezért nem vehette fel a(z) "{$a->fullname}" kurzust. Próbáljon meg áttérni a kurzusra néhány másodperc múlva, de ha továbbra is gondja támad, szóljon a(z) {$a->teacher} tanárnak vagy a portál rendszergazdájának';
$string['paymentthanks'] = 'Köszönjük a befizetést! Sikerült beiratkoznia erre a kurzusra: "{$a}"';
$string['pendingrequests'] = 'Folyamatban lévő kérések';
$string['periodending'] = 'Időtartam lejár ({$a})';
$string['perpage'] = 'Oldalanként';
$string['perpagea'] = 'Oldalanként: {$a}';
$string['personal'] = 'Személyes';
$string['personalprofile'] = 'Személyes profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobiltelefon';
$string['phpinfo'] = 'PHP-vel kapcsolatos infó';
$string['pictureof'] = 'Kép';
$string['pictureofuser'] = 'Felhasználói kép';
$string['pleaseclose'] = 'Csukja be most az ablakot.';
$string['pleasesearchmore'] = 'Keressen még';
$string['pleaseusesearch'] = 'Használja fel a keresést';
$string['plugin'] = 'Segédprogram';
$string['plugincheck'] = 'Segédprogram ellenőrzése';
$string['plugindeletefiles'] = 'Az adatbázisból törlődött a segédprogramhoz \'{$a->name}\' kapcsolódó összes adat. A segédprogram újratelepülésének megelőzéséhez törölje szerveréről ezt a könyvtárat: {$a->directory}';
$string['pluginsetup'] = 'Segédprogram-táblázatok beállítása';
$string['policyaccept'] = 'Megértettem és elfogadom';
$string['policyagree'] = 'A portál használatához el kell fogadnia a feltételeket. Elfogadja őket?';
$string['policyagreement'] = 'A portál használati feltételeiről szóló megállapodás';
$string['policyagreementclick'] = 'Ugrópont a portál használati feltételeiről szóló megállapodáshoz';
$string['popup'] = 'előbukkanó';
$string['popupwindow'] = 'Állomány megnyitása új ablakban';
$string['popupwindowname'] = 'Előbukkanó ablak';
$string['post'] = 'Hozzászólás';
$string['posts'] = 'Hozzászólások';
$string['potentialadmins'] = 'Lehetséges rendszergazdák';
$string['potentialcreators'] = 'Lehetséges kurzuskészítők';
$string['potentialstudents'] = 'Lehetséges tanulók';
$string['potentialteachers'] = 'Lehetséges tanárok';
$string['preferences'] = 'Beállítások';
$string['preferredlanguage'] = 'Választott nyelv';
$string['preferredtheme'] = 'Választott stílus';
$string['preprocessingbackupfile'] = 'Biztonsági mentése előfeldolgozása';
$string['prev'] = 'Előző';
$string['preview'] = 'Előzetes megtekintés';
$string['previewhtml'] = 'HTML formájú nyomtatási kép';
$string['previeworchoose'] = 'Egy stílus megtekintése vagy kiválasztása';
$string['previous'] = 'Előző';
$string['previouslyselectedusers'] = 'A korábban kiválasztott felhasználók {$a} szerint nem felelnek meg.';
$string['previoussection'] = 'Előző szekció';
$string['primaryadminsetup'] = 'A rendszergazda fiókjának beállítása';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'A profilleírás mindaddig nem jelenik meg, amíg az adott személy legalább egy kurzust fel nem vesz.';
$string['publicprofile'] = 'Nyilvános profil';
$string['publicsitefileswarning'] = 'Megjegyzés: az ide kerülő állományokat bárki elérheti';
$string['publicsitefileswarning2'] = 'Megjegyzés: az ide kerülő állományokat bárki elérheti, aki ismeri (vagy kitalálja) az URL-t. Biztonsági okokból ajánlatos helyreállítás után törölni az összes biztonsági mentést.';
$string['publicsitefileswarning3'] = 'Megjegyzés: Az itteni állományokat bárki elérheti, ha ismeri (vagy kitalálja) az URL-t. <br />A biztonság érdekében a biztonsági mentés állományait kizárólag a biztonságos Biztonsági mentések mappában tárolja.';
$string['publish'] = 'Közzététel';
$string['question'] = 'Kérdés';
$string['questionsinthequestionbank'] = 'Kérdés a kérdésbankban';
$string['readinginfofrombackup'] = 'Információk kiolvasása biztonsági mentésből';
$string['readme'] = 'OLVASS_EL';
$string['recentactivity'] = 'Utóbbi tevékenység';
$string['recentactivityreport'] = 'Teljes jelentés a legutóbbi tevékenységről...';
$string['recipientslist'] = 'Címzettek felsorolása';
$string['recreatedcategory'] = '{$a} kategória újból létrehozva';
$string['redirect'] = 'Átirányítás';
$string['reducesections'] = 'Szakaszszám csökkentése';
$string['refresh'] = 'Frissítés';
$string['refreshingevents'] = 'Események frissítése';
$string['registration'] = 'Moodle-regisztráció';
$string['registrationcontact'] = 'Általános kapcsolatfelvétel';
$string['registrationcontactno'] = 'A portál jegyzékén nem kérek kapcsolat-felvételi űrlapot.';
$string['registrationcontactyes'] = 'Igen, a Moodle jövőbeli használói számára adjanak meg űrlapot az elérhetőségemmel.';
$string['registrationemail'] = 'Értesítések e-mailben';
$string['registrationinfo'] = '<p>Ezen az oldalon regisztrálhatja Moodle-portálját a moodle.org címen. A regisztráció ingyenes. A regisztráció fő előnye, hogy felkerül egy alacsony forgalmú levelező listára, amelyben olyan fontos értesítéseket kap, mint pl. a biztonsági figyelmeztetések vagy a Moodle új változatai. </p><p>Alapesetben az Önről szóló információkat nem szolgáltatjuk ki, nem értékesítjük, és senki másnak nem adjuk át. Ezen információk összegyűjtése kizárólag a támogatást és a globális Moodle-közösséggel kapcsolatos statisztika céljait szolgálja.</p><p> Ha úgy dönt, hozzáférhetővé teheti portálja, országa nevét és az URL-t a Moodle-portálok nyilvános jegyzéke számára. Minden új regisztrációt kézzel ellenőrzünk, mielőtt a jegyzékbe felvesszük. Felvétel után viszont lehetősége lesz arra, hogy saját regisztrációját (és a nyilvános jegyzékben szereplő adatait) a jelen űrlap újbóli leadásával bármikor frissítse.</p>';
$string['registrationinfotitle'] = 'Regisztrációra vonatkozó adatok';
$string['registrationno'] = 'Nem szeretnék e-mailt kapni';
$string['registrationsend'] = 'Regisztrációs információk elküldése a moodle.org részére';
$string['registrationyes'] = 'Igen, értesítsenek engem a fontosabb kérdésekről';
$string['reject'] = 'Elutasít';
$string['rejectdots'] = 'Elutasít...';
$string['reload'] = 'Újbóli betöltés';
$string['remoteappuser'] = 'Távoli {$a} felhasználó';
$string['remove'] = 'Törlés';
$string['removeadmin'] = 'Rendszergazda törlése';
$string['removecreator'] = 'Kurzuskészítő törlése';
$string['removestudent'] = 'Tanuló törlése';
$string['removeteacher'] = 'Tanár törlése';
$string['rename'] = 'Átnevezés';
$string['renamefileto'] = '{$a} átnevezése a következőre:';
$string['report'] = 'Jelentés';
$string['reports'] = 'Jelentések';
$string['repositories'] = 'Tárhelyek';
$string['requestcourse'] = 'Kurzus kérelmezése';
$string['requestedby'] = 'Kérelmező';
$string['requestedcourses'] = 'Kérelmezett kurzusok';
$string['requestreason'] = 'Kurzus kérelmezésének oka';
$string['required'] = 'Kitöltendő';
$string['requirespayment'] = 'A kurzus csak fizetés ellenében érhető el';
$string['reset'] = 'Visszaállítás';
$string['resetcomponent'] = 'Összetevő';
$string['resetcourse'] = 'Kurzus visszaállítása';
$string['resetinfo'] = 'Ezen az oldalon felhasználói adatokat törölhet anélkül, hogy a tevékenységek és más beállítások eltűnnének. Ne feledje, hogy az alábbi tételek kiválasztásával és az oldal elküldésével a kiválasztott felhasználói adatai a kurzusból mindörökre törlődnek!';
$string['resetnotimplemented'] = 'A visszaállítás nincs telepítve';
$string['resetrecordexpired'] = 'A  jelszó-visszaállítási kérelme {$a} percnél régebbi, ezért lejárt. Indítson új jelszó-visszaállítási kérelmet.';
$string['resetstartdate'] = 'Kezdési idő visszaállítása';
$string['resetstatus'] = 'Állapot';
$string['resettask'] = 'Feladat';
$string['resettodefaults'] = 'Alapbeállítások visszaállítása';
$string['resortbyfullname'] = 'Teljes név alapján';
$string['resortbyidnumber'] = 'Azonosítószám alapján';
$string['resortbyshortname'] = 'Rövid név szerint';
$string['resortcourses'] = 'Kurzusok rendezése';
$string['resortsubcategoriesbyidnumber'] = 'Alkategóriák rendezése azonosítószám alapján';
$string['resortsubcategoriesbyname'] = 'Alkategóriák rendezése nevük alapján';
$string['resource'] = 'tananyag';
$string['resourcedisplayauto'] = 'Automatikus';
$string['resourcedisplaydownload'] = 'Letöltés előírása';
$string['resourcedisplayembed'] = 'Beágyazás';
$string['resourcedisplayframe'] = 'Keretben';
$string['resourcedisplaynew'] = 'Új ablak';
$string['resourcedisplayopen'] = 'Megnyitás';
$string['resourcedisplaypopup'] = 'Előbukkanó ablakban';
$string['resources'] = 'tananyagok';
$string['resources_help'] = 'A tananyagtípusokkal csaknem mindenféle webes tartalmat beilleszthet a kurzusba.';
$string['restore'] = 'Helyreállítás';
$string['restorecancelled'] = 'A helyreállítás törölve';
$string['restorecannotassignroles'] = 'A helyreállításhoz szerepeket kell hozzárendelni, ám ehhez nincs meg a jogosultsága.';
$string['restorecannotcreateorassignroles'] = 'A helyreállításhoz szerepeket kell létrehozni vagy hozzárendelni, ám ehhez nincs meg a jogosultsága.';
$string['restorecannotcreateuser'] = 'A helyreállításhoz a mentett állományból a(z) \'{$a}\' felhasználót létre kell hozni, Önnek azonban nincs ehhez jogosultsága';
$string['restorecannotoverrideperms'] = 'A helyreállításhoz jogosultságokat kell felülírnia, ám ehhez nincs meg a jogosultsága.';
$string['restorecoursenow'] = 'Állítsa helyre a kurzust most!';
$string['restoredaccount'] = 'Helyreállít fiók';
$string['restoredaccountinfo'] = 'A fiók másik szerverről került át, a jelszó pedig elveszett. Új jelszó e-mailen keresztüli beállításához kattintson a "Tovább" gombra';
$string['restorefinished'] = 'A helyreállítás sikerült';
$string['restoreto'] = 'Helyreállítás helye';
$string['restoretositeadding'] = 'Figyelmeztetés: a portál kezdőoldalára készül helyreállítani és adatokat hozzáadni!';
$string['restoretositedeleting'] = 'Figyelmeztetés: a portál kezdőoldalára készül helyreállítani és onnan először adatokat törölni!';
$string['restoreuserconflict'] = 'Ha a mentett állományból a(z) \'{$a}\' felhasználót megpróbálja helyreállítani, az ütközéshez vezet.';
$string['restoreuserinfofailed'] = 'A helyreállítás leállt, mert Önnek nincs engedélye felhasználói adatok helyreállításához';
$string['restoreusersprecheck'] = 'Felhasználói adatok ellenőrzése';
$string['restoreusersprecheckerror'] = 'Felhasználói adatok ellenőrzése közben gondok merültek föl';
$string['restricted'] = 'Korlátozott';
$string['returningtosite'] = 'Visszatér erre a portálra?';
$string['returntooriginaluser'] = 'Visszatérés ide: {$a}';
$string['revert'] = 'Visszatérés';
$string['role'] = 'Szerep';
$string['roleassignments'] = 'Szerepek hozzárendelései';
$string['rolemappings'] = 'Szerepek kiosztása';
$string['rolerenaming'] = 'Szerep átnevezése';
$string['rolerenaming_help'] = 'Ezzel a beállítással módosíthatja kurzusában a szerepeknél megjelenő elnevezéseket. Csak a megjelenő név módosul, a szerephez tartozó engedélyeket ez nem befolyásolja. Az új szerepneveket a kurzus résztvevőinek oldalán és a kurzus egyéb helyein fogja látni. Ha az átnevezett szerepet a rendszergazda kurzusvezetői szerepnek választotta ki, akkor az új szerep neve megjelenik a kurzusok felsorolásában is.
';
$string['roles'] = 'Szerepek';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Újabb RSS-hírek száma';
$string['rsserror'] = 'Hiba RSS-adatok olvasása közben';
$string['rsserrorauth'] = 'RSS-hivatkozásában nincs érvényes hitelesítési jel';
$string['rsserrorguest'] = 'A hír az adatok eléréséhez vendégjogokat használ, de a vendég nem jogosult az adatok olvasására. Jogosult felhasználóként látogasson el a hír eredeti helyére (URL) és szerezzen be egy új RSS-ugrópontot.';
$string['rsskeyshelp'] = 'A biztonság és a titoktartás érdekében az RSS-hírek URL-jeiben egy speciális jel szerepel, amely azonosítja az érintett felhasználót. Ily módon más felhasználók nem férhetnek hozzá a Moodle olyan területeihez, amelyeket RSS-híreken keresztül nem érhetnek el.
Ez a jel automatikusan jön létre a Moodle RSS-hírt létrehozó területének első elérésekor. Ha úgy véli, a jelével valamilyen visszaélés történt, kérhet egy újat, ha rákattint a Reset (Átállítás) ugrópontra. Ne feledje, hogy ez esetben mostani RSS-híreinek URL-jei érvénytelenek lesznek.';
$string['rsstype'] = 'RSS-hírek ehhez a tevékenységhez';
$string['saveandnext'] = 'Mentés és a következő megjelenítése';
$string['savechanges'] = 'Módosítások mentése';
$string['savechangesanddisplay'] = 'Módosítások mentése és a változások megtekintése';
$string['savechangesandreturntocourse'] = 'Módosítások mentése és visszatérés a kurzushoz';
$string['savecomment'] = 'Megjegyzés mentése';
$string['savedat'] = 'Mentés időpontja:';
$string['savepreferences'] = 'Beállítások mentése';
$string['saveto'] = 'Mentés helye';
$string['scale'] = 'Skála';
$string['scale_help'] = '<p>A tanárok új saját skálákat hozhatnak létre a kurzus során végzendő
bármely pontozási tevékenység céljára.</p>

<p>A skála nevét úgy kell megválasztani, hogy az egyértelmű
azonosítást tegyen lehetővé: ez meg fog jelenni a skálaválasztási listákon,
valamint a környezetérzékeny súgó gombjain.</p>

<p>Magát a skálát egymástól vesszővel elválasztott,
negatívtól pozitívig terjedő értékek egy rendezett listája határozza meg.
Például:</p>

<blockquote><i>
Kiábrándító, Nem elég jó, Átlagos, Jó, Nagyon jó, Kitűnő!
</i></blockquote>

<p>A skálákhoz rendelni kell egy megfelelő leírást is azok tartalmáról és használatának módjáról.
Ez a leírás jelenik meg a tanár és a tanuló súgójának oldalain.</p>

<p>Végezetül használható egy vagy több "szokásos" skála is, amelyet a rendszergazda az oldalhoz
meghatároz. Ezek minden kurzus számára elérhetők.</p>';
$string['scales'] = 'Skálák';
$string['scalescustom'] = 'Saját skálák';
$string['scalescustomcreate'] = 'Új skála hozzáadása';
$string['scalescustomno'] = 'Nincsenek még létrehozva saját skálák';
$string['scalesstandard'] = 'Standard skálák';
$string['scalestandard'] = 'Standard skála';
$string['scalestandard_help'] = '<p>A standard skála az egész portálon, minden kurzusban használható skála.</p>';
$string['scalestip'] = 'Saját skálák használatához a kurzusadminisztrációs menüből válassza ki a \'Skálák ...\' ugrópontot.';
$string['scalestip2'] = 'Egyedi skálák létrehozásához kattintson a kurzusadminisztrációs menüben a Pontok ugrópontra, majd válassza a Szerkesztés/Skálák pontot.';
$string['schedule'] = 'Ütemezés';
$string['screenshot'] = 'Képernyőkép';
$string['search'] = 'Keresés';
$string['searchagain'] = 'Keresés ismétlése';
$string['searchbyemail'] = 'Keresés e-mail cím alapján';
$string['searchbyusername'] = 'Keresés felhasználónév alapján';
$string['searchcourses'] = 'Kurzusok keresése';
$string['searchhelp'] = 'Egyszerre több szóra is rákereshet.<br /><br />szó : a szó bármely előfordulása a szövegben.<br />+szó : csak a pontos egyezést keresi ki.<br />-szó : az adott szót tartalmazó eredményeket kihagyja.';
$string['search_help'] = 'A szövegben való kereséshez írja be a szavakat szóközökkel elválasztva. Minden két karakternél hosszabb szót felhasznál a rendszer.

Részletes kereséshez a részletes keresés űrlapjára áttérhet, ha megnyomja a Keresés gombot, de a keresőnégyzetet üresen hagyja';
$string['searchoptions'] = 'Keresés beállításai';
$string['searchresults'] = 'Keresési eredmények';
$string['sec'] = 'mp';
$string['seconds'] = 'másodperc';
$string['secondstotime172800'] = '2 nap';
$string['secondstotime259200'] = '3 nap';
$string['secondstotime345600'] = '4 nap';
$string['secondstotime432000'] = '5 nap';
$string['secondstotime518400'] = '6 nap';
$string['secondstotime604800'] = '1 hét';
$string['secondstotime86400'] = '1 nap';
$string['secretalreadyused'] = 'A módosult jelszó megerősítési ugrópontját már használták, a jelszó nem módosult.';
$string['secs'] = 'mp';
$string['section'] = 'Szekció';
$string['sectionname'] = 'Szekció neve';
$string['sections'] = 'Szekciók';
$string['sectionusedefaultname'] = 'Alapbeállítás szerinti szekciónév használata';
$string['seealsostats'] = 'Lásd még: statisztika';
$string['selctauser'] = 'Válasszon felhasználót';
$string['select'] = 'Kiválasztás';
$string['selectacategory'] = 'Válasszon kategóriát';
$string['selectacountry'] = 'Válasszon egy országot';
$string['selectacourse'] = 'Válasszon kurzust';
$string['selectacoursesite'] = 'Válasszon kurzust vagy portált';
$string['selectagroup'] = 'Válasszon csoportot';
$string['selectall'] = 'Az összes kiválasztása';
$string['selectamodule'] = 'Válasszon tevékenységmodult';
$string['selectanaction'] = 'Válasszon lépést';
$string['selectanoptions'] = 'Válasszon egyet';
$string['selectaregion'] = 'Válasszon egy területet';
$string['selectcategorysort'] = 'Melyik kategóriákat kívánja rendezni?';
$string['selectcategorysortby'] = 'Hogyan kívánja a kategóriákat rendezni?';
$string['selectcoursesortby'] = 'Hogyan kívánja a kurzusokat rendezni?';
$string['selectdefault'] = 'Alapértelmezett kiválasztása';
$string['selectedcategories'] = 'Kiválasztott kategóriák';
$string['selectedfile'] = 'Kiválasztott állomány';
$string['selectednowmove'] = '{$a} állomány áthelyezésre kiválasztva. Térjen át a célkönyvtárra és nyomja meg az \'Állományok áthelyezése ide\' gombot';
$string['selectfiles'] = 'Válasszon ki állományokat.';
$string['selectmoduletoviewhelp'] = 'Válasszon ki egy tevékenységet vagy tananyagot a súgója megtekintéséhez.';
$string['selectnos'] = 'Minden \'nem\' kiválasztása';
$string['selectperiod'] = 'Időszak kiválasztása';
$string['senddetails'] = 'Adataim elküldése e-mailben';
$string['separate'] = 'Különálló';
$string['separateandconnected'] = 'Különálló és kapcsolt ismeretek';
$string['separateandconnectedinfo'] = 'A skála az elkülönült és a kapcsolt tudás elméletén alapszik. Ennek megfelelően az általunk látott és hallott dolgokról kétféleképpen szerezhetünk ismereteket.
<ul><li><strong>Elkülönülő tudás</strong> a lehető legobjektívebb marad, az érzelmek kirekesztésével. Másokkal való vita során szereti a mások érvelésében fellelt logikai lyukak kihasználásával próbálja megvédeni saját elképzelését.</li><li><strong>Kapcsolt tudás</strong> fogékonyabb másokra. Empatikus, odafigyel és kérdez, amíg úgy nem érzi, össze tudja kapcsolni véleményét "mások szemszögének felismerésével". A másokban felfedezett ismerethez vezető tapasztalat megosztásával próbál ismeretekre szert tenni.</li></ul>';
$string['servererror'] = 'Hiba történt a szerverrel való kommunikáció közben';
$string['serverlocaltime'] = 'Szerveridő';
$string['setcategorytheme'] = 'Kategóriastílus beállítása';
$string['setpassword'] = 'Jelszó beállítása';
$string['setpasswordinstructions'] = 'Alább írja be és ismételje meg az új jelszót, majd kattintson a "Jelszó beállítása" pontra.
 <br />Ekkor jelszavát elmentjük, Ön pedig belép.\'';
$string['settings'] = 'Beállítások';
$string['shortname'] = 'Rövid név';
$string['shortnamecollisionwarning'] = '[*] = Ezt a rövid nevet már használja egy kurzus, ezért jóváhagyásakor meg kell változtatni';
$string['shortnamecourse'] = 'A kurzus rövid neve';
$string['shortnamecourse_help'] = 'A kurzus rövid neve a navigációban jelenik meg, és a kurzus e-mail üzeneteinek tárgysorában használatos.';
$string['shortnametaken'] = 'Ezt a rövid nevet már egy másik kurzus használja ({$a})';
$string['shortnameuser'] = 'A felhasználó rövid neve';
$string['shortsitename'] = 'A portál rövid neve (pl. egy szó)';
$string['show'] = 'Mutat';
$string['showactions'] = 'Műveletek megtekintése';
$string['showadvancedsettings'] = 'Részletes beállítások megjelenítése';
$string['showall'] = 'Minden {$a} megjelenítése';
$string['showallcourses'] = 'Minden kurzus megjelenítése';
$string['showallusers'] = 'Minden felhasználó megjelenítése';
$string['showblockcourse'] = 'Blokkot tartalmazó kurzusok felsorolásának megjelenítése';
$string['showcategory'] = '{$a} megjelenítése';
$string['showcomments'] = 'Megjegyzések megjelenítése/elrejtése';
$string['showcommentsnonjs'] = 'Megjegyzések megjelenítése';
$string['showdescription'] = 'Leírás megjelenítése a kurzusoldalon';
$string['showdescription_help'] = 'Bekapcsolása esetén a fenti leírás megjelenik a kurzusoldalon a tevékenység / tananyag ugrópontja alatt.';
$string['showgrades'] = 'Pontok megjelenítése a tanulók számára';
$string['showgrades_help'] = '<p>Számos tevékenységhez rendelhet pontokat.</p>

<p>Kiinduló helyzetben egy kurzuson belül minden pont megtekinthető a Pontok oldalon, amely a fő kurzusoldalról érhető el.</p>

<p>Ha a tanár nem kívánja az adott kurzust pontozni,
vagy ha csak el akarja rejteni a pontokat a tanulók elől, akkor kikapcsolhatja a pontok
megjelenítését a kurzusbeállításokban. Ettől még az
egyes tevékenységekhez használhat vagy beállíthat pontokat, itt csak
azt kapcsolja ki, hogy a tanulók lássák az eredményt.</p>';
$string['showingacourses'] = 'Mind a(z)  {$a} kurzus megjelenítése';
$string['showingxofycourses'] = 'Az összesen {$a->total} kurzusból {$a->start} -- {$a->end} kurzus megjelenítése';
$string['showlistofcourses'] = 'Tanfolyamok felsorolásának megjelenítése';
$string['showmodulecourse'] = 'Tevékenységet tartalmazó kurzusok felsorolásának megjelenítése';
$string['showonly'] = 'Csak megjelenítés';
$string['showperpage'] = 'Oldalanként {$a} megjelenítése';
$string['showrecent'] = 'Legutóbbi tevékenység megjelenítése';
$string['showreports'] = 'Tevékenységjelentés megjelenítése';
$string['showreports_help'] = '<p>A tevékenységekről szóló jelentések az adott kurzusban tevékenységet
végző résztvevők mindegyike számára elérhetők. A beküldött anyagok
felsorolásán túl ezek a jelentések részletes naplózást adnak a rendszerbe való
belépésekről.</p>

<p>A tanárok az egyes személyek profilját tartalmazó oldalakon lévő gomb segítségével mindig hozzáférhetnek ezekhez a jelentésekhez.</p>

<p>A tanulók saját jelentéseihez való hozzáférését a tanár szabályozza a kurzusbeállításon keresztül. Egyes kurzusok esetén ezek a jelentések hasznos eszközt jelenthetnek a tanuló számára, mivel képet
kapnak arról, hogyan szerepeltek az online környezetben, más kurzusok esetén viszont ez nem feltétlenül szükséges.</p>

<p>Egy másik ok ennek az opciónak a kikapcsolására az, hogy a jelentés előállítása során megterheli a szervert. Nagy és hosszan tartó osztálykurzusok
esetén ezért hatékonyabb lehet, ha a tevékenységekről szóló jelentések
készítését kikapcsolt állapotban tartja.<p>';
$string['showsettings'] = 'Beállítások megjelenítése';
$string['showtheselogs'] = 'Ezen naplók megjelenítése';
$string['showthishelpinlanguage'] = 'A súgó megjelenítése {$a} nyelven.';
$string['since'] = 'Mióta';
$string['sincelast'] = 'utolsó belépés óta';
$string['site'] = 'Portál';
$string['sitedefault'] = 'Portál alapbeállítása';
$string['siteerrors'] = 'Portálhibák';
$string['sitefiles'] = 'Portál állományai';
$string['sitefilesused'] = 'A portál ezen kurzusban használt állományai';
$string['sitehome'] = 'Portál kezdőoldala';
$string['sitelegacyfiles'] = 'Korábbi portálállományok';
$string['sitelogs'] = 'Portálnaplók';
$string['sitemessage'] = 'Felhasználói üzenet';
$string['sitenews'] = 'Portálhírek';
$string['sitepages'] = 'Portáloldalak';
$string['sitepartlist'] = 'Nincs engedélye a résztvevők megtekintésére';
$string['sitepartlist0'] = 'A portál résztvevőinek megtekintéséhez a portálon tanárnak kell lennie';
$string['sitepartlist1'] = 'A portál résztvevőinek megtekintéséhez tanárnak kell lennie';
$string['sites'] = 'Portálok';
$string['sitesection'] = 'Stílusszekció beszúrása';
$string['sitesettings'] = 'A portál beállításai';
$string['siteteachers'] = 'A portál tanárai';
$string['size'] = 'Méret';
$string['sizeb'] = 'bájt';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Kihagyva';
$string['skiptocategorylisting'] = 'Ugrás a kategóriák felsorolásához';
$string['skiptocoursedetails'] = 'Ugrás a részletes kurzusadatokhoz';
$string['skiptocourselisting'] = 'Ugrás a kurzusok felsorolásához';
$string['skypeid'] = 'Skype-azonosító';
$string['socialheadline'] = 'Társas fórum - legutóbbi témák';
$string['someallowguest'] = 'Egyes kurzusok megengedhetik vendégek belépését';
$string['someerrorswerefound'] = 'Valamilyen információ hiányzik vagy hibás. A részleteket lásd lentebb.';
$string['sort'] = 'Rendezés';
$string['sortby'] = 'Rendezési szempont';
$string['sortbyx'] = 'Rendezés növekvő {$a} szerint';
$string['sortbyxreverse'] = 'Rendezés csökkenő {$a} szerint';
$string['sortcategoriesbyidnumber'] = 'Kategóriák rendezése azonosítószám alapján';
$string['sortcategoriesbyname'] = 'Kategóriák rendezése nevük alapján';
$string['sortcoursesbyfullname'] = 'Kurzusok rendezése teljes név alapján';
$string['sortcoursesbyidnumber'] = 'Kurzusok rendezése azonosítószám alapján';
$string['sortcoursesbyshortname'] = 'Kurzusok rendezése rövid név alapján';
$string['sorting'] = 'Rendezés';
$string['sourcerole'] = 'Kiinduló szerep';
$string['specifyname'] = 'Nevet kell megadnia.';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] = jóváhagyásra váró kurzus)';
$string['startdate'] = 'A kurzus kezdésének dátuma';
$string['startdate_help'] = 'Itt adhatja meg a heti formájú kurzus első hetének kezdő időpontját. Azt is beállítja, hogy a kurzustevékenységek naplózása mikortól legyen elérhető.';
$string['startingfrom'] = 'Ekkortól';
$string['startsignup'] = 'Új fiók létrehozása';
$string['state'] = 'Állam/tartomány';
$string['statistics'] = 'Statisztika';
$string['statisticsgraph'] = 'Statisztika grafikonja';
$string['stats'] = 'Statisztika';
$string['statslogins'] = 'Belépések';
$string['statsmodedetailed'] = 'Részletes (felhasználói) nézet';
$string['statsmodegeneral'] = 'Általános nézet';
$string['statsnodata'] = 'A kurzus és az időtartam ezen párosításához nincsenek adatok.';
$string['statsnodatauser'] = 'A kurzus, a felhasználó és az időtartam ezen párosításához nincsenek adatok.';
$string['statsoff'] = 'A statisztika nincs bekapcsolva';
$string['statsreads'] = 'Nézetek';
$string['statsreport1'] = 'Belépések';
$string['statsreport10'] = 'Felhasználói tevékenység';
$string['statsreport11'] = 'Legaktívabb kurzusok';
$string['statsreport12'] = 'Legaktívabb kurzusok (súlyozva)';
$string['statsreport13'] = 'Leglátogatottabb kurzusok (beiratkozások)';
$string['statsreport14'] = 'Leglátogatottabb kurzusok (megtekintés/hozzászólások)';
$string['statsreport2'] = 'Nézetek (minden szerep)';
$string['statsreport3'] = 'Hozzászólások (minden szerep)';
$string['statsreport4'] = 'Minden tevékenység (minden szerep)';
$string['statsreport5'] = 'Minden tevékenység (nézetek és hozzászólások)';
$string['statsreport7'] = 'Felhasználói tevékenység (nézetek és hozzászólások)';
$string['statsreport8'] = 'Minden felhasználói tevékenység';
$string['statsreport9'] = 'Belépések (portálkurzus)';
$string['statsreportactivity'] = 'Minden tevékenység (minden szerep)';
$string['statsreportactivitybyrole'] = 'Minden tevékenység (nézetek és hozzászólások)';
$string['statsreportforuser'] = 'kié';
$string['statsreportlogins'] = 'Belépések';
$string['statsreportreads'] = 'Nézetek (minden szerep)';
$string['statsreporttype'] = 'Jelentés típusa';
$string['statsreportwrites'] = 'Hozzászólások (minden szerep)';
$string['statsstudentactivity'] = 'Tanulói tevékenység';
$string['statsstudentreads'] = 'Tanulói nézetek';
$string['statsstudentwrites'] = 'Tanulói hozzászólások';
$string['statsteacheractivity'] = 'Tanári tevékenység';
$string['statsteacherreads'] = 'Tanári nézetek';
$string['statsteacherwrites'] = 'Tanári hozzászólások';
$string['statstimeperiod'] = 'Időszak - utolsó:';
$string['statsuniquelogins'] = 'Egyedi belépések';
$string['statsuseractivity'] = 'Minden tevékenység';
$string['statsuserlogins'] = 'Belépések';
$string['statsuserreads'] = 'Nézetek';
$string['statsuserwrites'] = 'Hozzászólások';
$string['statswrites'] = 'Hozzászólások';
$string['status'] = 'Állapot';
$string['stringsnotset'] = 'A következő szövegek nincsenek megadva itt: {$a}';
$string['studentnotallowed'] = 'Erre a tanfolyamra nem tud belépni \'{$a}\'-ként';
$string['students'] = 'Tanulók';
$string['studentsandteachers'] = 'Tanulók és tanárok';
$string['subcategories'] = 'Alkategóriák';
$string['subcategory'] = 'Alkategória';
$string['subcategoryof'] = '{$a} alkategóriája';
$string['submit'] = 'Leadás';
$string['success'] = 'Sikerült';
$string['summary'] = 'Leírás';
$string['summary_help'] = 'A téma összegzése olyan igen rövid szöveg, amellyel a tanulót felkészíti az adott témán (vagy héten) belül elvégzendő tevékenységekre. A szöveg a kurzusoldalon a szekció neve alatt jelenik meg.';
$string['summaryof'] = '{$a} rész összegzése';
$string['supplyinfo'] = 'További részletek';
$string['suspended'] = 'Felfüggesztett';
$string['suspendedusers'] = 'Felfüggesztett felhasználók';
$string['switchdevicedefault'] = 'Áttérés a standard stílusra';
$string['switchdevicerecommended'] = 'Áttérés az eszközéhez ajánlott  stílusra';
$string['switchrolereturn'] = 'Visszatérés szokásos szerepemhez';
$string['switchroleto'] = 'Szerep átváltása erre...';
$string['tag'] = 'Címke';
$string['tagalready'] = 'A címke már létezik';
$string['tagmanagement'] = 'Címke hozzáadása/törlése...';
$string['tags'] = 'Címkék';
$string['targetrole'] = 'Célszerep';
$string['teacheronly'] = 'csak {$a} számára';
$string['teacherroles'] = '{$a} szerepei';
$string['teachers'] = 'Tanárok';
$string['textediting'] = 'Szövegszerkesztő';
$string['texteditor'] = 'Szokásos internetes űrlapok használata';
$string['textformat'] = 'Egyszerű szöveg';
$string['thanks'] = 'Köszönjük';
$string['theme'] = 'Stílus';
$string['themes'] = 'Stílusok';
$string['themesaved'] = 'Új stílus elmentve';
$string['therearecourses'] = '{$a} kurzus létezik';
$string['thereareno'] = 'A(z) {$a} nem fordul elő ebben a kurzusban!';
$string['thiscategory'] = 'Ez a kategória';
$string['thiscategorycontains'] = 'A kategória tartalma';
$string['time'] = 'Idő';
$string['timezone'] = 'Időzóna';
$string['to'] = 'Meddig';
$string['tocontent'] = '" {$a}" elembe';
$string['tocreatenewaccount'] = 'Ugrás új fiók létrehozására';
$string['today'] = 'Ma';
$string['todaylogs'] = 'Mai naplók';
$string['toeveryone'] = 'mindenkinek';
$string['toomanybounces'] = 'Ez az e-mail cím túl sokszor nem fogadott üzenetet. Folytatáshoz meg kell változtatnia.';
$string['toomanytoshow'] = 'Túl sok a megjelenítendő felhasználó';
$string['toomanyusersmatchsearch'] = 'Túl sok ({$a->count}) felhasználó felel meg \'{$a->search}\' szerint';
$string['toomanyuserstoshow'] = 'Túl sok ({$a}) megjelenítendő felhasználó';
$string['toonly'] = 'csak {$a} részére';
$string['top'] = 'Fent';
$string['topic'] = 'Téma';
$string['topichide'] = 'Téma elrejtése {$a} elől';
$string['topicoutline'] = 'Téma ismertetése';
$string['topicshow'] = 'Téma megjelenítése {$a} részére';
$string['toplevelcategory'] = 'Legfölső kategória';
$string['total'] = 'Összesen';
$string['totopofsection'] = '"{$a}" szakasz elejére';
$string['trackforums'] = 'Fórum nyomon követése';
$string['trackforumsno'] = 'Ne tartsa számon a már megtekintett hozzászólásokat';
$string['trackforumsyes'] = 'Az új hozzászólásokat jelölje ki számomra';
$string['trysearching'] = 'Próbálkozzon inkább kereséssel.';
$string['turneditingoff'] = 'Szerkesztés kikapcsolása';
$string['turneditingon'] = 'Szerkesztés bekapcsolása';
$string['undecided'] = 'Nincs eldöntve';
$string['unfinished'] = 'Nincs befejezve';
$string['unknowncategory'] = 'Ismeretlen kategória';
$string['unknownerror'] = 'Ismeretlen hiba';
$string['unlimited'] = 'Korlátlan';
$string['unpacking'] = '{$a} kicsomagolása';
$string['unsafepassword'] = 'Nem biztonságos jelszó - próbálkozzon egy másikkal';
$string['untilcomplete'] = 'Míg el nem készül';
$string['unusedaccounts'] = 'A {$a} napnál hosszabb ideig nem használt fiók tulajdonosa automatikusan kiiratkozik';
$string['unzip'] = 'Kicsomagolás';
$string['unzippingbackup'] = 'Biztonsági mentés kicsomagolása';
$string['up'] = 'Fel';
$string['update'] = 'Frissítés';
$string['updated'] = '{$a} frissítve';
$string['updatemymoodleoff'] = 'Oldal testreszabásának befejezése';
$string['updatemymoodleon'] = 'Oldal testreszabása';
$string['updatemyprofile'] = 'Profil frissítése';
$string['updatesevery'] = 'Frissítés minden {$a} másodpercben';
$string['updatethis'] = '{$a} frissítése';
$string['updatethiscourse'] = 'A kurzus frissítése';
$string['updatinga'] = '{$a} frissítése';
$string['updatingain'] = '{$a->what} frissítése: {$a->in}';
$string['upload'] = 'Feltöltés';
$string['uploadafile'] = 'Egy állomány feltöltése';
$string['uploadcantwrite'] = 'Az állományt nem sikerült lemezre írni.';
$string['uploadedfile'] = 'Az állomány feltöltése sikerült.';
$string['uploadedfileto'] = '{$a->file} feltöltve a(z) {$a->directory} könyvtárba';
$string['uploadedfiletoobig'] = 'Az állomány túl nagy (maximum {$a} bájt lehet)';
$string['uploadextension'] = 'Az állomány feltöltését egy PHP-bővítmény leállította.';
$string['uploadfailednotrecovering'] = 'Az állományok feltöltése nem sikerült, mert gond volt az egyik fájllal: {$a->name}. Erről a következő napló készült:{$a->problem}. Nem lehet helyreállítani.';
$string['uploadfilelog'] = 'A(z) {$a} állomány naplójának feltöltése';
$string['uploadformlimit'] = 'A feltöltött állomány {$a} mérete nagyobb, mint az űrlapon megadott';
$string['uploadlabel'] = 'Cím:';
$string['uploadlimitwithsize'] = '{$a->contextname} feltöltési korlátja({$a->displaysize})';
$string['uploadnewfile'] = 'Új állomány feltöltése';
$string['uploadnofilefound'] = 'Nem található állomány - biztosan kiválasztott egyet feltöltésre?';
$string['uploadnotallowed'] = 'Feltöltés nincs engedélyezve';
$string['uploadnotempdir'] = 'Hiányzik egy ideiglenes mappa.';
$string['uploadoldfilesdeleted'] = 'A régi állomány(ok) törölve lett(ek) feltöltési területéről';
$string['uploadpartialfile'] = 'A(z) {$a} állomány feltöltése csak részben sikerült';
$string['uploadproblem'] = 'Ismeretlen probléma lépett fel a(z) \'{$a}\' állomány feltöltésekor (talán túl nagy a fájl?)';
$string['uploadrenamedchars'] = 'Az állomány neve {$a->oldname} névről {$a->newname} névre változott az érvénytelen karakterek miatt.';
$string['uploadrenamedcollision'] = 'Névütközés miatt az állomány {$a->oldname} helyett {$a->newname} nevet kapott.';
$string['uploadserverlimit'] = 'A feltöltött állomány mérete nagyobb, mint a szerver által megadott';
$string['uploadthisfile'] = 'Állomány feltöltése';
$string['url'] = 'URL';
$string['used'] = 'Használatban';
$string['usedinnplaces'] = '{$a} helyen van használatban';
$string['usemessageform'] = 'vagy az alábbi űrlappal küldjön üzenetet a kiválasztott hallgatóknak';
$string['user'] = 'Felhasználó';
$string['userconfirmed'] = '{$a} megerősítve';
$string['usercurrentsettings'] = 'Profilom beállításai';
$string['userdata'] = 'Felhasználói adatok';
$string['userdeleted'] = 'Ez a felhasználó törölve lett';
$string['userdescription'] = 'Leírás';
$string['userdescription_help'] = 'Ebben a négyzetben írhat magáról, ami a profiloldalán látható lesz mások számára.';
$string['userdetails'] = 'Felhasználó adatai';
$string['userfiles'] = 'Felhasználó állományai';
$string['userlist'] = 'Felhasználók felsorolása';
$string['username'] = 'Felhasználónév';
$string['usernameemailmatch'] = 'A felhasználónév és az e-mail cím más-más felhasználóé';
$string['usernameexists'] = 'A felhasználónév már létezik, válasszon másikat';
$string['usernamelowercase'] = 'Csak kisbetűk használhatók';
$string['usernamenotfound'] = 'A felhasználónév nem volt az adatbázisban';
$string['usernameoremail'] = 'Felhasználónevet vagy e-mail címet adjon meg';
$string['usernotconfirmed'] = '{$a} nem volt megerősíthető';
$string['userpic'] = 'Felhasználó képe';
$string['users'] = 'Felhasználó';
$string['userselectorautoselectunique'] = 'Ha csak egy felhasználó felel meg a keresésnek, legyen automatikusan kiválasztva';
$string['userselectorpreserveselected'] = 'A kiválasztott felhasználók megtartása akkor is, ha már nem felelnek meg a keresésnek';
$string['userselectorsearchanywhere'] = 'A keresett szöveg a kijelzésben bárhol előfordulhat.';
$string['usersnew'] = 'Új felhasználók';
$string['usersnoaccesssince'] = 'Hosszabb ideje tétlen, mint';
$string['userswithfiles'] = 'Ezen állományokkal rendelkező felhasználók';
$string['useruploadtype'] = 'Felhasználói feltöltés típusa: : {$a}';
$string['userviewingsettings'] = '{$a} profilja';
$string['userzones'] = 'Felhasználói zónák';
$string['usetheme'] = 'Stílus használata';
$string['usingexistingcourse'] = 'Létező kurzus használata';
$string['valuealreadyused'] = 'Az érték már használatban van.';
$string['version'] = 'Változat';
$string['view'] = 'Nézet';
$string['viewallcourses'] = 'Minden kurzus megtekintése';
$string['viewallcoursescategories'] = 'Minden kurzus és kategória megtekintése';
$string['viewallsubcategories'] = 'Az összes alkategória megtekintése';
$string['viewfileinpopup'] = 'Állomány megtekintése előugró ablakban';
$string['viewing'] = 'Megtekintés:';
$string['viewmore'] = 'Továbbiak megtekintése';
$string['viewprofile'] = 'Profil megtekintése';
$string['views'] = 'Nézetek';
$string['viewsolution'] = 'megoldás megtekintése';
$string['virusfound'] = 'Figyelem, rendszergazda! A vírusirtó vírust talált a(z) {$a->user} által a(z) {$a->course} kurzushoz feltöltött állományban. Íme a vírusirtó jelentése:';
$string['virusfoundlater'] = 'A(z) {$a->date} időpontban a(z){$a->course} kurzushoz feltöltött {$a->filename} nevű állományban a rendszer vírust talált. Az állományával a következő történt: {$a->action}. Ha ez leadott munka volt, lehetősége van újbóli leadásra, hogy a tanára megtekinthesse.';
$string['virusfoundlateradmin'] = 'Figyelem, rendszergazda! A(z) {$a->date} időpontban a(z) {$a->course} kurzushoz a(z) {$a->user} által feltöltött {$a->filename} nevű állományban a rendszer vírust talált. Az állománnyal a következő történt: {$a->action}. A felhasználót szintén értesítettük.';
$string['virusfoundlateradminnolog'] = 'Figyelem, rendszergazda! A(z) {$a->filename} nevű feltöltött állományban a rendszer vírust talált. A Moodle nem tudta visszajuttatni az állományt az azt eredetileg feltöltő felhasználóhoz. Az állománnyal a következő történt: {$a->action} A felhasználót szintén értesítettük.';
$string['virusfoundsubject'] = '{$a}: Vírus!';
$string['virusfounduser'] = 'Az Ön által feltöltött {$a->filename} nevű állományban a rendszer vírust talált. Az állomány feltöltése NEM sikerült.';
$string['virusplaceholder'] = 'A feltöltött állományban a rendszer vírust talált. Az állományt áthelyeztük vagy töröltük, a  felhasználót értesítettük.';
$string['visible'] = 'Látható';
$string['visible_help'] = 'Ez a beállítás szabja meg, hogy a kurzus megjelenjen-e a kurzuslistán. A kurzusba
tanárokon és rendszergazdákon kívül más nem léphet be.';
$string['visibletostudents'] = 'Láthatja: {$a}';
$string['warning'] = 'Figyelmeztetés';
$string['warningdeleteresource'] = 'Figyelmeztetés: {$a} kapcsán hivatkozás szerepel az egyik tananyagban. Kívánja frissíteni a tananyagot?';
$string['webpage'] = 'Weboldal';
$string['week'] = 'Hét';
$string['weekhide'] = 'A hét elrejtése {$a} elől';
$string['weeklyoutline'] = 'Heti forma';
$string['weeks'] = 'hét';
$string['weekshow'] = 'A hét megmutatása {$a} részére';
$string['welcometocourse'] = 'Üdvözöljük itt: {$a}';
$string['welcometocoursetext'] = 'Üdvözöljük {$a->coursename} kurzusunkban! Ha még nem tette meg, állítsa be felhasználói profilját, hogy többet megtudjunk Önről: {$a->profileurl}';
$string['whatforlink'] = 'Mit kíván tenni az ugróponttal?';
$string['whatforpage'] = 'Mit kíván tenni az ugróponttal?';
$string['whattocallzip'] = 'Mi legyen a tömörített állomány neve?';
$string['whattodo'] = 'Mi a teendő';
$string['windowclosing'] = 'Az ablak automatikusan becsukódik. Ha mégsem, csukja be most.';
$string['withchosenfiles'] = 'A kiválasztott fájlokkal';
$string['withdisablednote'] = '{$a} (kikapcsolva)';
$string['withoutuserdata'] = 'felhasználói adatok nélkül';
$string['withselectedusers'] = 'A kiválasztott felhasználókkal...';
$string['withselectedusers_help'] = '* Üzenet küldése - Üzenet küldése egy vagy több résztvevőnek
* Új megjegyzés hozzáadása - Új megjegyzés hozzáadása egy kiválasztott résztvevőhöz
* Közös megjegyzés hozzáadása - Ugyanazon megjegyzés hozzáadása egynél több résztvevőhöz';
$string['withuserdata'] = 'felhasználói adatokkal';
$string['wordforstudent'] = 'Az Ön szava a tanulóra';
$string['wordforstudenteg'] = 'pl. tanuló, résztvevő stb.';
$string['wordforstudents'] = 'Az Ön szava a tanulókra';
$string['wordforstudentseg'] = 'pl. tanulók, résztvevők stb.';
$string['wordforteacher'] = 'Az Ön szava a tanárra';
$string['wordforteachereg'] = 'pl. tanár, tutor, mentor stb.';
$string['wordforteachers'] = 'Az Ön szava a tanárokra';
$string['wordforteacherseg'] = 'pl. tanárok, tutorok, mentorok stb.';
$string['writingblogsinfo'] = 'Bloginformációk írása';
$string['writingcategoriesandquestions'] = 'Kategóriák és kérdések írása';
$string['writingcoursedata'] = 'Kurzusadatok írása';
$string['writingeventsinfo'] = 'Eseményinformációk írása';
$string['writinggeneralinfo'] = 'Általános információk írása';
$string['writinggradebookinfo'] = 'Osztályozónapló információinak írása';
$string['writinggroupingsgroupsinfo'] = 'Csoport-csoportosítási információk írása';
$string['writinggroupingsinfo'] = 'Csoportosítási információk írása';
$string['writinggroupsinfo'] = 'Csoportinformációk írása';
$string['writingheader'] = 'Fejléc írása';
$string['writingloginfo'] = 'Naplózási információk írása';
$string['writingmessagesinfo'] = 'Üzenetinformációk írása';
$string['writingmoduleinfo'] = 'Modulinformációk írása';
$string['writingscalesinfo'] = 'Skálainformációk írása';
$string['writinguserinfo'] = 'Felhasználói információk írása';
$string['wrongpassword'] = 'A jelszó hibás ehhez a felhasználónévhez';
$string['yahooid'] = 'Yahoo-azonosító';
$string['year'] = 'év';
$string['years'] = 'év';
$string['yes'] = 'Igen';
$string['youareabouttocreatezip'] = 'Most lát hozzá az alábbi tartalmú állomány tömörítéséhez';
$string['youaregoingtorestorefrom'] = 'Most lát hozzá az alábbi folyamat helyreállításához';
$string['youneedtoenrol'] = 'Ennek végrehajtásához be kell iratkoznia a kurzusba.';
$string['yourlastlogin'] = 'Utolsó belépésének időpontja:';
$string['yourself'] = 'Ön';
$string['yourteacher'] = 'az Ön tanára {$a}';
$string['yourwordforx'] = 'Az Ön szava {$a} esetén';
$string['zippingbackup'] = 'Biztonsági mentés tömörítése';
