<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'hu', branch 'MOODLE_26_STABLE'
 *
 * @package   badges
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Lépések';
$string['activate'] = 'Hozzáférés engedélyezése';
$string['activatesuccess'] = 'A kitűzők elérésének bekapcsolása sikerült.';
$string['addbadgecriteria'] = 'Kitűzőhöz kapcsolódó feltétel hozzáadása';
$string['addcourse'] = 'Kurzusok hozzáadása';
$string['addcourse_help'] = 'Válassza ki a kitűző feltételéhez kapcsolódó összes kurzust. Több elem kiválasztásához tartsa nyomva a CTRL-billentyűt.';
$string['addcriteria'] = 'Feltételek hozzáadása';
$string['addcriteriatext'] = 'Feltételek hozzáadásához válasszon egy lehetőséget a lenyíló menüből.';
$string['addtobackpack'] = 'Hozzáadás a hátizsákhoz';
$string['adminonly'] = 'Az oldalt csak rendszergazdák érhetik el';
$string['after'] = 'kiállítás napja után';
$string['aggregationmethod'] = 'Összegzési mód';
$string['all'] = 'Mind';
$string['allmethod'] = 'Minden kiválasztott feltétel teljesül';
$string['allmethodactivity'] = 'Minden kiválasztott tevékenység véget ért';
$string['allmethodcourseset'] = 'Minden kiválasztott kurzus véget ért';
$string['allmethodmanual'] = 'Minden kiválasztott szerep adományoz kitűzőt';
$string['allmethodprofile'] = 'Minden kiválasztott profilmező ki van töltve';
$string['allowcoursebadges'] = 'Kurzuskitűzők bekapcsolása';
$string['allowcoursebadges_desc'] = 'Kitűzők létrehozásának és adományozásának engedélyezése a kurzuskörnyezetben';
$string['allowexternalbackpack'] = 'Külső hátizsákokhoz csatlakozás engedélyezése';
$string['allowexternalbackpack_desc'] = 'Engedélyezi, hogy a felhasználók kapcsolódhassanak külső kibocsátókhoz.
Megjegyzés: hagyja tiltva ezt az opciót, ha a weboldal nem érhető el közvetlenül az interneten (pl.: tűzfal miatt).';
$string['any'] = 'Bármelyik';
$string['anymethod'] = 'A kiválasztott feltételek bármelyike teljesül';
$string['anymethodactivity'] = 'A kiválasztott tevékenységek bármelyike véget ér';
$string['anymethodcourseset'] = 'A kiválasztott kurzusok bármelyike befejeződik';
$string['anymethodmanual'] = 'A kiválasztott szerepek bármelyike adományozza a kitűzőt';
$string['anymethodprofile'] = 'A kiválasztott profilmezők bármelyikét kitöltötték';
$string['attachment'] = 'Kitűző hozzákapcsolása az üzenethez';
$string['attachment_help'] = 'Bejelölése esetén a kapott kitűző letöltéshez a címzett e-mailjéhez lesz mellékelve. Használatához a Portáladminisztráció > Segédprogramok > Üzenetek kimenete > E-mail alatt a csatolmányokat engedélyezni kell.';
$string['award'] = 'Kitűző adományozása';
$string['awardedtoyou'] = 'Kibocsátás dátuma';
$string['awardoncron'] = 'A kitűzők hozzáférését sikerült engedélyezni. A kitűzőt jelenleg túl sok felhasználó kaphatja meg. A portál teljesítménye érdekében a művelet végrehajtása némi időt vesz igénybe.';
$string['awards'] = 'Átvevők';
$string['backpackavailability'] = 'Külső kitűző ellenőrzése';
$string['backpackavailability_help'] = 'Ahhoz, hogy a kitűzőt kapók bizonyíthassák, hogy a kitűzőt Öntől kapták, külső hátizsák-szolgáltatásnak kell elérnie az Ön portálját és egybevetnie az általa kiadott kitűzőkkel. Az Ön portálja jelenleg nem elérhető, így a már kiadott vagy később kiadandó kitűzők sem ellenőrizhetők.


##Miért jelent meg ez az üzenet?

Előfordulhat, hogy tűzfal akadályozza meg külső felhasználók belépését, vagy portálját jelszó védi, esetleg portálját az internetről nem elérhető számítógépről működteti (pl. helyi fejlesztésre használt gépről).

##Ez gondot jelent?

Nyilvános portálon a gondot meg kell oldania, ha kitűzőket kíván adományozni, ellenkező esetben az átvevők nem fogják tudni bizonyítani, hogy kitűzőjüket Öntől kapták. Ha portálja még nem éles, kipróbálás céljából létrehozhat és adományozhat próbakitűzőket.

##Mi történik, ha a teljes portált nem tehetem nyilvánosan elérhetővé?

Az ellenőrzéshez csak a  [portálom-url-je]/badges/assertion.php URL-re van szükség, így ha tűzfalán ezen fájl elérését engedélyezni tudja, a kitűzők ellenőrzése végrehajtható.';
$string['backpackbadges'] = 'Ön {$a->totalbadges} kitűzőt jelenít meg a(z) {$a->totalcollections} gyűjteményből. <a href="mybackpack.php">Hátizsák beállításainaki módosítása</a>.';
$string['backpackconnection'] = 'Hátizsák csatlakozása';
$string['backpackconnection_help'] = 'Itt állíthatja be egy külső hátizsák-szolgáltató csatlakozását. Hátizsákhoz csatlakozva a portálon külső kitűzőket jeleníthet meg és tűzhet a hátizsákjára.

Jelenleg csak a  <a href="http://backpack.openbadges.org">Mozilla OpenBadges Backpack</a> hátizsák-alkalmazás használatát támogatja rendszer. A csatlakozás előtt fel kell iratkoznia a szolgáltatásra.';
$string['backpackdetails'] = 'KItűző beállításai';
$string['backpackemail'] = 'E-mail cím';
$string['backpackemail_help'] = 'A hátizsákjához kapcsolódó e-mail cím.
A kapcsolat alatt a postálon megszerzett összes kitűző ehhez az e-mail címhez fog kapcsolódni.';
$string['backpackimport'] = 'Kitűzők importálási beállításai';
$string['backpackimport_help'] = 'Ha sikerült csaltakozni a hátizsákhoz, a hátizsákján lévő kitűzőket megjelenítheti a "Kitűzőim" oldalon és a profiloldalán.

Ezen a területen kiválaszthatja, mely hátizsákjáról mely kitűzőgyűjtemények jenlejenek meg a profiloldalán.';
$string['badgedetails'] = 'Részletek';
$string['badgeimage'] = 'A kitűző képe';
$string['badgeimage_help'] = 'Kitűző adományozásakor a rendszer ezt a képet fogja használni.

Új kép hozzáadásához válasszon ki egy (JPG- vagy PNG-) képet, utána kattintson a "Módosítások mentése" pontra. A rendszer a képet négyzet alakúvá módosítja és a kitűzőkép követelményeinek megfelelőre méretezi.';
$string['badgeprivacysetting'] = 'Kitűző megjelenítési beállításai';
$string['badgeprivacysetting_help'] = 'A kapott kitűzőket megjelenítheti profiloldalán. Itt állíthatja be, hogy az újonnan kapott kitűzők automatikusan láthatók legyenek-e.

Ettől függetlenül egy-egy kitűző beállítását meghatározhatja a "Kitűzőim" oldalon.';
$string['badgeprivacysetting_str'] = 'Kapott kitűzőim automatikusan láthatók legyenek a profiloldalamon.';
$string['badgesalt'] = 'Védőérték az átvevő e-mail címének kivonatolásához';
$string['badgesalt_desc'] = 'Kivonatttal a hátizsák-szolgáltatás anélkül ellenőrizni tudja a kitűzőt kapó kilétét, hogy megjelenítené e-mail címét. A beállításban csak számok és betűk szerepelhetnek.

Megjegyzés: a kitűzőt kapók ellenőrzéséhez ne módosítsa ezt a beállítást, ha elkezdi adományozni a kitűzőket.';
$string['badgesdisabled'] = 'A kitűzők használata nincs engedélyezve ezen a portálon.';
$string['badgesearned'] = 'A szerzett kitűzők száma: {$a}';
$string['badgesettings'] = 'Kitűző beállításai';
$string['badgestatus_0'] = 'Nem elérhető a felhasználók számára';
$string['badgestatus_1'] = 'Elérhető a felhasználók számára';
$string['badgestatus_2'] = 'Nem elérhető a felhasználók számára';
$string['badgestatus_3'] = 'Elérhető a felhasználók számára';
$string['badgestatus_4'] = 'Archivált';
$string['badgestoearn'] = 'Elérhető kitűzők száma: {$a}';
$string['badgesview'] = 'Kurzuskitűzők';
$string['badgeurl'] = 'Kapcsolat a kiadott kitűzőkhöz';
$string['bawards'] = 'Átvevők ({$a})';
$string['bcriteria'] = 'Feltételek';
$string['bdetails'] = 'Részletek szerkesztése';
$string['bmessage'] = 'Üzenet';
$string['boverview'] = 'Áttekintés';
$string['bydate'] = 'teljesítés időpontja';
$string['clearsettings'] = 'Beállítások törlése';
$string['completioninfo'] = 'KItűző adományozásának alapja';
$string['completionnotenabled'] = 'A kurzusteljesítés a kurzushoz nincs bekapcsolva, így nem szerepelhet a kitűző feltételei között. A kurzusteljesítést a kurzusbeállításoknál kapcsolhatja be.';
$string['configenablebadges'] = 'Bekapcsolása esetén kitűzőket hozhat létre és adhat át a portál felhasználóinak.';
$string['configuremessage'] = 'Kitűzőhöz kapcsolódó üzenet';
$string['connect'] = 'Kapcsolódás';
$string['connected'] = 'Kapcsolódva';
$string['connecting'] = 'Csatlakozás...';
$string['contact'] = 'Kapcsolat';
$string['contact_help'] = 'A kitűzőt adományozóhoz kapcsolódó e-mail cím';
$string['copyof'] = '{$a} másolata';
$string['coursebadges'] = 'Kitűzők';
$string['coursebadgesdisabled'] = 'Ezen a portálon nem lehet kurzuskitűzőket adományozni.';
$string['coursecompletion'] = 'A tanulóknak teljesíteni kell ezt a kurzust';
$string['create'] = 'Új kitűző';
$string['createbutton'] = 'Kitűző létrehozása';
$string['creatorbody'] = '<p>{$a->user} teljesítette a kitűzőhöz előírt összes feltételt, így kitűzőt kapott. A kitűző megtekintése:  {$a->link} </p>';
$string['creatorsubject'] = '\'{$a}\'-t kapott!';
$string['criteria_0'] = 'Ez a kitűző odaítélhető, ha...';
$string['criteria_1'] = 'Tevékenység végrehajtása';
$string['criteria_1_help'] = 'A kurzushoz tartozó tevékenységek végrehajtásakor a felhasználók kitűzőt kaphatnak.';
$string['criteria_2'] = 'Kitűző kézi adományozása szerep alapján';
$string['criteria_2_help'] = 'A portálon vagy a kurzusban meghatározott szerepet betöltő felhasználók számára kitűző kézi adományozását engedélyezi';
$string['criteria_3'] = 'Közösségi részvétel';
$string['criteria_3_help'] = 'Közösségi';
$string['criteria_4'] = 'Kurzus teljesítése alapján';
$string['criteria_4_help'] = 'A kurzust teljesítők számára kitűző adományozását teszi lehetővé. A feltételhez egyéb paraméterek írhatók elő, pl. minimális pontszám, a kurzus teljesítésének időpontja.';
$string['criteria_5'] = 'Több kurzus teljesítése';
$string['criteria_5_help'] = 'Több kurzust teljesítők számára kitűző adományozását teszi lehetővé. Az egyes kurzusokhoz egyéb paraméterek írhatók elő, pl. minimális pontszám, a kurzus teljesítésének időpontja.';
$string['criteria_6'] = 'Profil befejezése';
$string['criteria_6_help'] = 'Profiljukban bizonyos mezőket teljesítők számára kitűző adományozását teszi lehetővé. Választhat alapmezők és egyedi profilmezők közül.';
$string['criteriacreated'] = 'A kitűzőhöz kapcsolódó feltételek létrehozása sikerült';
$string['criteriadeleted'] = 'A kitűzőhöz kapcsolódó feltételek törlése sikerült';
$string['criteria_descr'] = 'A tanulók megkapják ezt a kitűzőt, amennyiben teljesülnek az alábbi követelmények:';
$string['criteria_descr_0'] = 'A tanulók megkapják ezt a kitűzőt, ha a felsorolt követelmények közül  teljesítenek <strong>{$a}</strong>-t :';
$string['criteria_descr_1'] = 'Az alábbi tevékenységek közül <strong>{$a}</strong>-t sikerült teljesíteni:';
$string['criteria_descr_2'] = 'Ezt a kitűzőt az alábbi szerepek közül <strong>{$a}</strong> szereppel rendelkezők adhatják.';
$string['criteria_descr_4'] = 'A felhasználóknak teljesíteni kell a kurzust.';
$string['criteria_descr_5'] = 'Az alábbi kurzusok közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_6'] = 'Az alábbi profilmezők közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_bydate'] = '<em>{$a}</em> időpontig';
$string['criteria_descr_grade'] = '<em>{$a}</em> minimális pontszámmal';
$string['criteria_descr_short0'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short1'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short2'] = '<strong>{$a}</strong> adta.';
$string['criteria_descr_short4'] = 'Teljesítse a kurzust';
$string['criteria_descr_short5'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_short6'] = 'közül <strong>{$a}</strong> teljesítendő.';
$string['criteria_descr_single_1'] = 'Az alábbi tevékenységet teljesíteni kell:';
$string['criteria_descr_single_2'] = 'Ezt a kitűzőt az alábbi szereppel rendelkező adhatja:';
$string['criteria_descr_single_4'] = 'A felhasználóknak teljesíteni kell a kurzust.';
$string['criteria_descr_single_5'] = 'Az alábbi kurzust teljesíteni kell:';
$string['criteria_descr_single_6'] = 'Az alábbi profilmezőt teljesíteni kell:';
$string['criteria_descr_single_short1'] = 'Teljesítve:';
$string['criteria_descr_single_short2'] = 'Adományozta:';
$string['criteria_descr_single_short4'] = 'Teljesítse a kurzust';
$string['criteria_descr_single_short5'] = 'Teljesítve:';
$string['criteria_descr_single_short6'] = 'Teljesítve:';
$string['criteriasummary'] = 'Feltételek összegzése';
$string['criteriaupdated'] = 'A kitűzőhöz kapcsolódó feltételek frissítése sikerült';
$string['criterror'] = 'Paraméterekkel kapcsolatos gondok';
$string['criterror_help'] = 'A mezőkészletben látszik az összes eredeti kitűzőfeltétel, de ezek már nem elérhetők. Az ilyen paraméterek bejelölését szüntesse meg, hogy a felhasználók a jövőben kitűzőt kaphassanak.';
$string['currentimage'] = 'Aktuális kép';
$string['currentstatus'] = 'Aktuális állapot:';
$string['dateawarded'] = 'Kiadás dátuma';
$string['dateearned'] = 'Dátum: {$a}';
$string['day'] = 'nap';
$string['deactivate'] = 'Hozzáférés kikapcsolása';
$string['deactivatesuccess'] = 'A kitűzők elérésének kikapcsolása sikerült.';
$string['defaultissuercontact'] = 'A kitűző alapbeállítás szerinti adományozójának elérhetősége';
$string['defaultissuercontact_desc'] = 'A kitűző adományozójához kapcsolódó e-mail cím';
$string['defaultissuername'] = 'A kitűző alapbeállítás szerinti adományozójának neve';
$string['defaultissuername_desc'] = 'A kiadmányozó vagy a hatóság neve';
$string['delbadge'] = 'Kitűző törlése';
$string['delconfirm'] = 'Biztosan törli a kitűzőt? {$a}';
$string['delcritconfirm'] = 'Biztosan törli a feltételt?';
$string['delparamconfirm'] = 'Biztosan törli a paramétert?';
$string['description'] = 'Leírás';
$string['disconnect'] = 'Szétkapcsolás';
$string['donotaward'] = 'Jelenleg a kitűző nem aktív, így nem adományozható. Ha valakinek adni szeretné, állapotát állítsa át aktívra.';
$string['editsettings'] = 'Beállítások szerkesztése';
$string['enablebadges'] = 'KItűzők engedélyezése';
$string['error:backpackdatainvalid'] = 'A hátizsáktól visszakapott adatok érvénytelenek.';
$string['error:backpackemailnotfound'] = 'A(z)  \'{$a}\' e-mail cím nem kapcsolódik hátizsákhoz. Hozzon létre a fiókhoz egy  <a href="http://backpack.openbadges.org">hátizsákot</a> vagy jelentkezzen be egy másik e-mail címről.';
$string['error:backpackloginfailed'] = 'Nem tudott külső hátizsákhoz kapcsolódni. Ennek oka: {$a}.';
$string['error:backpacknotavailable'] = 'Portálját az internetről nem lehet elérni, így a kiadott kitűzőket külső hátizsák-szolgáltatók nem tudják ellenőrizni.';
$string['error:backpackproblem'] = 'Hiba a hátizsák-szolgáltatójához csatlakozás közben. Próbálja meg később.';
$string['error:badjson'] = 'A csatlakozási kísérlet érvénytelen adatot jelzett.';
$string['error:cannotact'] = 'A kitűzőt nem lehet aktiválni.';
$string['error:cannotawardbadge'] = 'A kitűzőt nem lehet felhasználónak adni.';
$string['error:clone'] = 'A kitűzőt nem lehet másolni.';
$string['error:connectionunknownreason'] = 'A csatlakozási kísérlet sikertelen, de nincs hozzá indok.';
$string['error:duplicatename'] = 'Ilyen névvel már szerepel kitűző a rendszerben.';
$string['error:externalbadgedoesntexist'] = 'Nincs meg a kitűző';
$string['error:guestuseraccess'] = 'Jelenleg vendégként kezeljük. Kitűzőinek megtekintéséhez lépjen be felhasználói fiókjából.';
$string['error:invalidbadgeurl'] = 'Kitűző-adományozóhoz kapcsolódó hibás URL-formátum';
$string['error:invalidcriteriatype'] = 'Érvénytelen feltételtípus';
$string['error:invalidexpiredate'] = 'A lejárat jövőbeni időpont lehet.';
$string['error:invalidexpireperiod'] = 'A lejárat nem lehet negatív szám vagy 0.';
$string['error:noactivities'] = 'A kurzusban nincs teljesítési feltételhez kötött tevékenység';
$string['error:noassertion'] = 'A Persona nem igazolta vissza. Lehet, hogy az ablakot a bejelentkezési folyamat közben bezárta.';
$string['error:nocourses'] = 'A kurzusteljesítés a portál egyetlen kurzusához sincs hozzárendelve. A kurzusteljesítést a kurzusbeállítások között írhatja elő.';
$string['error:nogroups'] = '<p>Hátizsákján nincs elérhető nyilvános kitűzőgyűjtemény. </p> <p>Csak a nyilvános gyűjtemények jelennek meg. Nyilvános gyűjtemény létrehozásához látogassa meg <a href="http://backpack.openbadges.org">hátizsákját</a>.</p>';
$string['error:nopermissiontoview'] = 'Nem nézheti meg, kik kaptak kitűzőt.';
$string['error:nosuchbadge'] = 'Nincs {$a} azonosítóval rendelkező kitűző.';
$string['error:nosuchcourse'] = 'Figyelem! A kurzus már nem elérhető.';
$string['error:nosuchfield'] = 'Figyelem! A felhasználói profilmező már nem elérhető.';
$string['error:nosuchmod'] = 'Figyelem! A tevékenység már nem elérhető.';
$string['error:nosuchrole'] = 'Figyelem! A szerep már nem elérhető.';
$string['error:nosuchuser'] = 'Ilyen e-mail címmel nincs felhasználói fiók a hátizsák-szolgáltatónál.';
$string['error:notifycoursedate'] = 'Figyelem! Kurzusteljesítéshez és tevékenységteljesítéshez kötött kitűzők kiadására a kurzus kezdetéig nem kerül sor.';
$string['error:parameter'] = 'Figyelem! A helyes kitűzőkiadási folyamathoz legalább egy paramétert ki kell választani.';
$string['error:personaneedsjs'] = 'Jelenleg a hátizsákhoz kapcsolódáshoz Javascriptre van szükség. Engedélyezze, majd töltse be újra az oldalt.';
$string['error:requesterror'] = 'A csatlakozás nem sikerült (hibakód: {$a}).';
$string['error:requesttimeout'] = 'A csatlakozási idő időközben lejárt.';
$string['error:save'] = 'A kitűzőt nem lehet elmenteni.';
$string['error:userdeleted'] = '{$a->user} (A felhasználó a(z) {$a->site} portálon nem létezik)';
$string['evidence'] = 'Bizonyíték';
$string['existingrecipients'] = 'Létező kitűzőt átvevők';
$string['expired'] = 'Lejárt';
$string['expiredate'] = 'A kitűző {$a}.időpontban lejár.';
$string['expireddate'] = 'A kitűző {$a}.időpontban lejárt.';
$string['expireperiod'] = 'A kitűző kiadása után {$a}.nappal lejár.';
$string['expireperiodh'] = 'A kitűző kiadása után {$a}.órával lejár.';
$string['expireperiodm'] = 'A kitűző kiadása után {$a}.perccel lejár.';
$string['expireperiods'] = 'A kitűző kiadása után {$a}.másodperccel lejár.';
$string['expirydate'] = 'Lejárat időpontja';
$string['expirydate_help'] = 'Választhatóan a kitűzők lejárhatnak egy megadott napon, vagy egy olyan napon, amelyet a felhasználónak adományozás kelte alapján számít ki a rendszer.';
$string['externalbadges'] = 'Más portálokról származó kitűzőim';
$string['externalbadges_help'] = 'Itt jelennek meg a külső hátizsákon lévő kitűzői';
$string['externalbadgesp'] = 'Más portálokról származó kitűzők';
$string['externalconnectto'] = 'Külső kitűzők megjelenítéséhez kapcsolódnia kell egy <a href="{$a}">hátizsákhoz</a>.';
$string['fixed'] = 'Rögzített időpont';
$string['hidden'] = 'Rejtett';
$string['hiddenbadge'] = 'A kitűző tulajdonosa ezt az információt nem tette elérhetővé.';
$string['issuancedetails'] = 'A kitűző lejárata';
$string['issuedbadge'] = 'A kiadott kitűző adatai';
$string['issuerdetails'] = 'Az adományozó adatai';
$string['issuername'] = 'Az adományozó neve';
$string['issuername_help'] = 'Az adományozó szerv vagy hatóság neve';
$string['issuerurl'] = 'Az adományozó webcíme';
$string['localbadges'] = '{$a} portálról származó kitűzőim';
$string['localbadgesh'] = 'A portálról származó kitűzőim';
$string['localbadgesh_help'] = 'A portálon kurzusteljesítéssel, kurzustevékenységekkel és más követelményekkel megszerzett összes kitűző.

Itt kezelheti kitűzőit, azaz nyilvánossá teheti vagy profiloldalához kötheti őket..

Kitűzőit letöltheti és gépre mentheti ömleszttve vagy egyesével. A letöltött kitűzőket hozzáadhatja külső hátizsák-szolgáltatásához.';
$string['localbadgesp'] = '{$a}:portálról származó kitűzők';
$string['localconnectto'] = 'A kitűzők portálon kívüli megosztásához kapcsolódnia kell egy <a href="{$a}">hátizsákhoz</a>.';
$string['makeprivate'] = 'Nem tesz elérhetővé';
$string['makepublic'] = 'Elérhetővé tesz';
$string['managebadges'] = 'Kitűzők kezelése';
$string['message'] = 'Üzenet törzsszövege';
$string['messagebody'] = '<p>Ön "%badgename%" kitűzőt kapott!</p> <p>További információkat olvashat a kitűzőről itt: %badgelink%.</p> <p>A kitűzőt kezelheti és a(z)  {$a} weboldalról letöltheti.</p>';
$string['messagesubject'] = 'Gratulálunk! Ön kitűzőt kapott!';
$string['method'] = 'A feltétel akkor teljesül, ha...';
$string['mingrade'] = 'Szükséges minimális pontszám';
$string['month'] = 'hónap';
$string['mybackpack'] = 'Hátizsák-beállításaim';
$string['mybadges'] = 'Kitűzőim';
$string['never'] = 'Soha';
$string['newbadge'] = 'Új kitűző hozzáadása';
$string['newimage'] = 'Új kép';
$string['noawards'] = 'A kitűzőt meg senki nem szerezte meg.';
$string['nobackpack'] = 'A fiókhoz nem kapcsolódik hátizsák-szolgáltatás .<br />';
$string['nobackpackbadges'] = 'A kiválasztott gyűjteményekben nincs kitűző. <a href="mybackpack.php">További gyűjtemények hozzáadása</a>.';
$string['nobackpackcollections'] = 'Nincs kiválasztva kitűzőgyűjtemény. <a href="mybackpack.php">Gyűjtemények hozzáadása</a>.';
$string['nobadges'] = 'Nincs elérhető kitűző.';
$string['nocriteria'] = 'A kitűzőhöz még nincsenek előírva feltételek.';
$string['noexpiry'] = 'A kitűzőhöz nincs megadva lejárati idő.';
$string['noparamstoadd'] = 'A kitűzőhöz nincsenek megadva további paraméterek.';
$string['notacceptedrole'] = 'Az Önhöz rendelt szereppel nem lehet kézileg kitűzőt adományozni.<br /> A kitűzőt kapott felhasználók megtekintéséhez látogasson el ide: {$a}.';
$string['notconnected'] = 'Nem kapcsolódik.';
$string['nothingtoadd'] = 'Nincs hozzáadható feltétel.';
$string['notification'] = 'Kitűző létrehozójának értesítése';
$string['notification_help'] = 'A beállítás a kitűző létrehozójának a kitűző kiadásakor küldendő értesítéseket kezeli.

Lehetőségek:

* **SOHA** – Nem küld értesítést.
* **MINDIG** – A kitűző minden egyes adományozásakor értesítést küld.
* **NAPONTA** – Naponta egyszer küld értesítést.
* **HETENTE** – Hetente egyszer küld értesítést.
* **HAVONTA** – Havonta egyszer küld értesítést.';
$string['notifydaily'] = 'Naponta';
$string['notifyevery'] = 'Mindig';
$string['notifymonthly'] = 'Havonta';
$string['notifyweekly'] = 'Hetente';
$string['numawards'] = 'Ezt a kitűzőt <a href="{$a->link}">{$a->count}</a> felhasználó szerezte meg.';
$string['numawardstat'] = 'Ezt a kitűzőt {$a} felhasználó szerezte meg.';
$string['overallcrit'] = 'teljesült a kiválasztott feltételek közül.';
$string['personaconnection'] = 'Jelentkezzen be e-mail címével.';
$string['personaconnection_help'] = 'A Persona esetén saját e-mail címével léphet be. Az Open Badges a belépéshez a Personát használja, ezért a hátizsákhoz való kapcsolódáshoz Persona-fiókra van szüksége.

További információk a Personáról: <a href="https://login.persona.org/about">https://login.persona.org/about</a>.';
$string['potentialrecipients'] = 'Lehetséges kitűzőt kapók';
$string['recipientdetails'] = 'A megjutalmazott adatai';
$string['recipientidentificationproblem'] = 'A meglévő felhasználók között nem szerepel a kitűzővel megjutalmazott személy.';
$string['recipients'] = 'Kitűzőt kapók';
$string['recipientvalidationproblem'] = 'A felhasználó nem tanúsítható mint a kitűzővel megjutalmazott személy.';
$string['relative'] = 'Relatív dátum';
$string['requiredcourse'] = 'A kurzuskészlet feltételéhez legalább egy kurzust hozzá kell adni.';
$string['reviewbadge'] = 'Kitűzőhöz kapcsolódás változásai';
$string['reviewconfirm'] = '<p>Ez megjeleníti kitűzőjét a felhasználók számára, akik elkezdhetnek dolgozni annak megszerzéséért.</p>
<p>Előfordulhat, hogy egyes felhasználók máris teljesítik annak követelményeit, így azonnal meg is kapják.</p>
<p>A megszerzett kitűzőt a rendszer <strong>zárolja</strong>, így egyes beállításait (pl. a feltételeket és a lejáratot) már nem lehet módosítani.</p> <p>Biztosan hozzáférhető teszi a(z) \'{$a}\' kitűzőt?</p>';
$string['save'] = 'Mentés';
$string['searchname'] = 'Keresés név szerint';
$string['selectaward'] = 'Válassza ki, melyik szerep adomámyozhatja ezt a kitűzőt:';
$string['selectgroup_end'] = 'Csak a nyilvános gyűjtemények jelennek meg, látogasson el <a href="http://backpack.openbadges.org">hátizsákjához</a>, ha további nyilvános gyűjteményeket kíván létrehozni.';
$string['selectgroup_start'] = 'Válasszon ki hátizsákjáról gyűjteményeket a portálon való megjelenítéshez:';
$string['selecting'] = 'A kiválasztott kitűzőkkel:';
$string['setup'] = 'Csatlakozás beállítása';
$string['signinwithyouremail'] = 'Jelentkezzen be e-mail címével.';
$string['sitebadges'] = 'A portál kitűzői';
$string['sitebadges_help'] = 'A portál kitűzőit csak portálhoz kapcsolódó tevékenységekkel lehet megszerezni. Ilyen pl. kurzusok elvégzése vagy felhasználói profilrészek kitöltése. A portál kitűzőit adományozhatja akár az egyik felhasználó is a másiknak.

Kurzustevékenységekhez kapcsolódó kitűzőket kurzusszinten kell létrehozni. A kurzuskitűzők a Kurzusadminisztráció > Kitűzők menüpontban találhatók.';
$string['status'] = 'A kitűző állapota';
$string['status_help'] = 'A kitűző állapota határozza meg rendszerbeli viselkedését.';
$string['statusmessage_0'] = 'Ez a kitűző jelenleg nem szerezhető meg. A megszerezhetőség bekapcsolásához engedélyezze a hozzáférést.';
$string['statusmessage_1'] = 'Ez a kitűző jelenleg megszerezhető. Módosítások végrehajtásához kapcsolja ki a hozzáférést.';
$string['statusmessage_2'] = 'Ez a kitűző jelenleg nem szerezhető meg, feltételei pedig zárolva vannak. A megszerezhetőség bekapcsolásához engedélyezze a hozzáférést.';
$string['statusmessage_3'] = 'Ez a kitűző jelenleg megszerezhető, feltételei pedig zárolva vannak.';
$string['statusmessage_4'] = 'Ez a kitűző jelenleg irattárban van.';
$string['subject'] = 'Üzenet tárgya';
$string['variablesubstitution'] = 'Változó behelyettesítése üzenetekben';
$string['variablesubstitution_help'] = 'A kitűzőhöz tartozó üzenet tárgymezőjébe és/vagy törzsrészébe változókat szúrhat be az alábbiak szerint. Használható változók:
%badgename% : a kitűző teljes neve. %username% : a címzett teljes neve.
%badgelink% : az adományozott kitűző ismertetése a nyilvános URL-lel együtt.';
$string['viewbadge'] = 'Az adományozott kitűző megtekintése';
$string['visible'] = 'Látható';
$string['warnexpired'] = '(A kitűző érvényessége lejárt.)';
$string['year'] = 'Év';
