<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'hu', branch 'MOODLE_26_STABLE'
 *
 * @package   admin
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Hozzáférés elutasítva';
$string['accounts'] = 'Fiókok';
$string['addcategory'] = 'Kategória hozzáadása';
$string['additionalhtml'] = 'Kiegészítő HTML';
$string['additionalhtml_desc'] = 'Itt állíthatja be, milyen HTML szerepeljen minden oldalon. Megadhatja, milyen HTML szerepeljen az oldal HEAD címkéjében közvetlenül a BODY címke megnyitása után vagy a bezárása előtt.<br />Ezzel testre szabott fejlécet és láblécet használhat minden oldalon, illetve szolgáltatásokat, pl. a Google Analytics használatát támogathatja igen egyszerűen és a kiválasztott stílustól függetlenül.';
$string['additionalhtmlfooter'] = 'A BODY bezárása előtt';
$string['additionalhtmlfooter_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik a BODY bezárása előtt.';
$string['additionalhtmlhead'] = 'A HEAD-en belül';
$string['additionalhtmlhead_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik a HEAD-címke aljához.';
$string['additionalhtml_heading'] = 'Minden oldalhoz hozzáadandó kiegészítő HTML. ';
$string['additionalhtmltopofbody'] = 'A BODY megnyitásakor';
$string['additionalhtmltopofbody_desc'] = 'Az itt szereplő tartalom minden oldalhoz hozzáadódik, közvetlenül a BODY-címke megnyitása után.';
$string['admincategory'] = 'Kategória: {$a}';
$string['adminseesall'] = 'A rendszergazdák mindent látnak';
$string['adminseesallevents'] = 'A rendszergazdák minden eseményt látnak';
$string['adminseesownevents'] = 'A rendszergazdák nem különböznek a többi felhasználótól';
$string['advancedfeatures'] = 'További jellemzők';
$string['allcountrycodes'] = 'Az összes országkód';
$string['allowbeforeblock'] = 'Először az engedélyezett lista feldolgozására kerül sor.';
$string['allowbeforeblockdesc'] = 'Alaphelyzetben először a zárolt IP-lista elemeinek párosítására kerül sor. Ezen funkció bekapcsolása esetén a zárolt  lista feldolgozása előtt történik az engedélyezett IP-lista elemeinek a feldolgozása.';
$string['allowblockstodock'] = 'Blokkok számára a tároló használatának engedélyezése';
$string['allowcategorythemes'] = 'Kategóriastílusok engedélyezése';
$string['allowcoursethemes'] = 'Kurzusstílusok engedélyezése';
$string['allowediplist'] = 'Engedélyezett IP-lista';
$string['allowemailaddresses'] = 'Engedélyezett e-mail domének';
$string['allowframembedding'] = 'Keretbeágyazás engedélyezése';
$string['allowframembedding_help'] = 'A portál keretekben külső portálokba való beágyazásának engedélyezése. Biztonsági okokból lehetőleg kerülendő.';
$string['allowguestmymoodle'] = 'Hozzáférés engedélyezése a My honlapjához  vendégek számára';
$string['allowobjectembed'] = 'EMBED- és OBJECT-címke használatának engedélyezése';
$string['allowthemechangeonurl'] = 'Stílusmódosítások engedélyezése az URL-ben';
$string['allowuserblockhiding'] = 'Felhasználók számára blokkok elrejtésének engedélyezése';
$string['allowuserswitchrolestheycantassign'] = 'Szerepváltás engedélyezése szerep-hozzárendelő funkcióval nem rendelkező felhasználók részére';
$string['allowuserthemes'] = 'Felhasználói stílusok engedélyezése';
$string['antivirus'] = 'Vírusirtó';
$string['appearance'] = 'Megjelenés';
$string['aspellpath'] = 'Útvonal az aspellhez';
$string['authentication'] = 'Hitelesítés';
$string['authpreventaccountcreation'] = 'Fiók létrehozásának megakadályozása hitelesítés közben';
$string['authpreventaccountcreation_help'] = 'Egy felhasználó hitelesítésekor a portálon - ha még nincs - automatikusan létrejön egy fiók. Ha a hitelesítéshez külső adatbázist, pl. LDAP-t használ, de a hozzáférést már fiókkal rendelkező felhasználókra kívánja korlátozni, akkor ezt a funkciót be kell kapcsolnia. Új fiókokat kézzel vagy a felhasználó-feltöltési funckióval hozhat létre. Ne feledje, hogy ez a beállítás nem érvényes MNet.hitelesítés esetén.';
$string['authsettings'] = 'Hitelesítés kezelése';
$string['autolang'] = 'Nyelv automatikus észlelése';
$string['autologinguests'] = 'Vendégek automatikus beléptetése';
$string['availablelicenses'] = 'Elérhető licencek';
$string['availableto'] = 'Elérheti';
$string['backgroundcolour'] = 'Áttetsző szín';
$string['backups'] = 'Biztonsági mentések';
$string['backup_shortname'] = 'Kurzusnév használata a biztonsági mentés állománynevében';
$string['backup_shortnamehelp'] = 'Kurzusnév használata a biztonsági mentés állománynevében';
$string['badwordsconfig'] = 'Adja meg a nem használható szavak vesszővel elválasztott jegyzékét.';
$string['badwordsdefault'] = 'Ha a testre szabott lista üres, a rendszer a nyelvi csomag alapbeállítás szerinti listáját fogja használni.';
$string['badwordslist'] = 'Nem használható szavak egyedi felsorolása';
$string['blockediplist'] = 'Blokkolt IP-lista';
$string['blockeditingmenu'] = 'Blokkszerkesztő menük';
$string['blockeditingmenu_desc'] = 'Bekapcsolása esetén a szerkesztés közben megjelenített blokkszerkesztési ikon közül több egy lenyíló menüben jelenik meg. Ezzel kevesebb lesz a tartalom a képernyőn, mert az ikonok csak szükség esetén fognak látszani.';
$string['blockinstances'] = 'Előfordulások';
$string['blockmultiple'] = 'Többszöri';
$string['blockprotect'] = 'Példányok védelme';
$string['blockprotect_help'] = 'Ha zárol egy adott blokktípust, akkor ehhez senki sem adhat hozzá vagy törölhet példányokat. Szerkesztésükhöz oldja fel a zárat.

Ez alapvetően a navigációs és a beállítási blokkokat védi, amelyek visszaállítása véletlen törlés esetén igen körülményes lehet.';
$string['blocksettings'] = 'Blokkok kezelése';
$string['blockunprotect'] = 'Védelem feloldása';
$string['bloglevel'] = 'Blogok láthatósága';
$string['bookmarkadded'] = 'Könyvjelző hozzáadva.';
$string['bookmarkalreadyexists'] = 'Ezt az oldalt már megjelölte.';
$string['bookmarkdeleted'] = 'Könyvjelző törölve.';
$string['bookmarkthispage'] = 'Oldal megjelölése';
$string['cacheapplication'] = 'Alkalmazás gyorsítótára';
$string['cacheapplicationhelp'] = 'A gyorsítótárba helyezett elemeket az összes felhasználó eléri, időtartamát egy adott ttl szabja meg.';
$string['cachejs'] = 'Javascript gyorsítótárban futtatása';
$string['cachejs_help'] = 'A javascript gyorsítótárban futtatása és tömörítése nagyban javítja az oldalak betöltését, használata éles portálokon mindenképpen ajánlatos. Fejlesztők inkább kerülik a funkció használatát.';
$string['cacherequest'] = 'Gyorsítótár kérése';
$string['cacherequesthelp'] = 'Felhasználóhoz kötődő gyorsítótár, mely a kérés teljesítésekor ér véget. Statikus tárakat helyettesít.';
$string['cachesession'] = 'Munkafolyamat gyorsítótára';
$string['cachesessionhelp'] = 'Felhasználóhoz kötődő gyorsítótár, mely a munkafolyamat befejezésekor ér véget. A munkafolyamat lelassulását fékezi.';
$string['cachesettings'] = 'A gyorsítótár beállításai';
$string['cachetext'] = 'Szöveggyorsítótár időtartama';
$string['caching'] = 'Kezelés gyorsítótárban';
$string['calendarexportsalt'] = 'Naptárexportáló rejtjelbitek';
$string['calendarsettings'] = 'Naptár';
$string['calendartype'] = 'Naptár típusa';
$string['calendartype_desc'] = 'Válasszon ki egy naptártípust az egész portál számára. A beállítás a kurzusbeállításokban vagy a felhasználók profiljában módosítható.';
$string['calendar_weekend'] = 'Hétvége';
$string['cannotdeletemodfilter'] = 'A(z) \'{$a->filter}\' nem távolítható el, mert a(z) \'{$a->module}\' modul része.';
$string['cannotuninstall'] = 'A(z) {$a} nem távolítható el.';
$string['cfgwwwrootslashwarning'] = 'A $CFG->wwwroot hibásan van megadva config.php fájljában. Nem egyezik az ezen oldal elérésére használt URL-lel. Javítsa ki, ellenkező esetben furcsa hibákkal találja szemben magát, pl.:  <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['cfgwwwrootwarning'] = 'A config.php állományban hibásan van megadva a $CFG->wwwroot. Nem egyezik az oldal elérésére használt URL-lel. Ha nem javítja ki, váratlan hibákba fog ütközni, pl. <a href=\'http://tracker.moodle.org/browse/MDL-11061\'>MDL-11061</a>.';
$string['change'] = 'módosítás';
$string['checkboxno'] = 'Nem';
$string['checkboxyes'] = 'Igen';
$string['choosefiletoedit'] = 'Válassza ki a szerkesztendő állományt';
$string['clamfailureonupload'] = 'A clam vírusirtó hibája esetén';
$string['cleanup'] = 'Tisztítás';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'i';
$string['cliincorrectvalueerror'] = 'Hiba, "{$a->value}" értéke "{$a->option}" esetén hibás';
$string['cliincorrectvalueretry'] = 'Hibás érték, próbálja újra.';
$string['clistatusdisabled'] = 'Állapot: kikapcsolva';
$string['clistatusenabled'] = 'Állapot: bekapcsolva';
$string['clistatusenabledlater'] = 'állapot: a  {$a} CLI karbantartási üzemmódját bekapcsolja';
$string['clitypevalue'] = 'érték beírása';
$string['clitypevaluedefault'] = 'érték beírása, Enter esetén alapérték ({$a}) használata';
$string['cliunknowoption'] = 'Ismeretlen paraméter: {$a}. Használja a --help paramétert.';
$string['cliupgradefinished'] = 'A parancssori frissítés sikerült.';
$string['cliupgradenoneed'] = 'A telepített {$a} verziót nem szükséges frissíteni.';
$string['cliyesnoprompt'] = 'írjon be i-t (igen) vagy n-t (nem)';
$string['commentsperpage'] = 'Oldalanként megjelenő megjegyzések száma';
$string['commonfiltersettings'] = 'Általános szűrőbeállítások';
$string['commonsettings'] = 'Általános beállítások';
$string['componentinstalled'] = 'Összetevő telepítve';
$string['computedfromlogs'] = 'A(z) {$a} óta gyűjtött naplókból kiszámítva.';
$string['condifmodeditdefaults'] = 'Tevékenység vagy tananyag létrehozásakor a beállítási űrlapon alapértékek jelennek meg.';
$string['confeditorhidebuttons'] = 'Válassza ki a HTML-szerkesztőben elrejtendő gombokat.';
$string['configallcountrycodes'] = 'Ez a különféle helyeken, például a felhasználói profilban kiválasztható országok listája. Ha üresen hagyja (alaphelyzet), akkor az angol nyelvi alapcsomagban lévő felsorolás jelenik meg. Ez az ISO 3166-1 szerinti lista. Ellenkező esetben meghatározhat egy sor vesszővel elválasztott kódot, pl. GB,FR,ES. Ha új, nem szabvány szerinti kódokat ad meg, azokat hozzá kell adnia mind a nyelvi csomagjának megfelelő, mind az \'en\' countries.php állományhoz.';
$string['configallowassign'] = 'A bal oldalon lévő szerepekkel rendelkezők részére engedélyezheti egyes oszlopszerepek másokhoz való hozzárendelését';
$string['configallowblockstodock'] = 'Bekapcsolása és a kiválasztott stílusok általi támogatása esetén a felhasználók speciális tárolóba is áthelyezhetnek blokkokat.';
$string['configallowcategorythemes'] = 'Bekapcsolása esetén a stílusokat kategóriaszinten állíthatja be. Ez minden lentebbi kategóriára és kurzusra érvényes lesz, hacsak azokhoz nincs külön stílus beállítva. FIGYELEM: A kategóriastílusok bekapcsolása befolyásolhatja a teljesítményt!';
$string['configallowcoursethemes'] = 'Ennek bekapcsolásakor a kurzusok önmaguk állíthatják be a stílusokat. A kurzusstílusok minden egyéb kiválasztott stílust (portál-, felhasználó- vagy eseménystílust) felülírnak.';
$string['configallowemailaddresses'] = 'Ha minden e-mail címet konkrét doménekre kíván korlátozni, szóközökkel elválasztva sorolja fel őket itt. Minden egyéb domént a rendszer elutasít. Aldomének engedélyezéséhez a domén neve elé írjon  \'.\' karaktert, pl. <strong>iskola.intezmeny.hu .intezmeny.hu. </strong>';
$string['configallowguestmymoodle'] = 'Bekapcsolása esetén a vendégek hozzáférnek a honlapjához, ellenkező esetben visszakerülnek a portál címoldalára';
$string['configallowobjectembed'] = 'Alapvető biztonsági intézkedésként a felhasználók nem építhetnek be multimédiát (pl. flash-t) a HTML-be EMBED- és OBJECT-címkékkel (jóllehet, erre módot ad a médiaprogramkódok biztonságos szűrője). Ezen címkék engedélyezéséhez az opciót be kell kapcsolni.';
$string['configallowoverride'] = 'A bal oldalon lévő szerepekkel rendelkezők részére engedélyezheti egyes oszlopszerepek felülírását';
$string['configallowoverride2'] = 'Válassza ki, mely szerep(ek)et írhatnak felül a bal oszlopban lévő egyes szerepek.<br />Ne feledje, hogy ezek a beállítások csak azon felhasználókra érvényesek, akiknél a moodle/role:override vagy a moodle/role:safeoverride képesség engedélyezve van.';
$string['configallowswitch'] = 'Válassza ki, a meglévő szerepeik alapján a felhasználók mely szerepekre válthatnak át. Az átváltáshoz a tábla bejegyzésén túl a felhasználónak moodle/role:switchroles képességgel is rendelkeznie kell.<br />Ne feledje, hogy a szerepváltás csak akkor lehetséges, ha a felhasználó a  moodle/course:view képességgel rendelkezik, de nem rendelkezik moodle/site:doanything képességgel, ezért a tábla néhány oszlopa ki van kapcsolva.';
$string['configallowthemechangeonurl'] = 'Ha ezt a beállítást bekapcsolja, akkor a stílust bármely Moodle URL esetén módosíthatja a theme={themename} hozzáadásával (pl.:  mymoodlesite.com/?theme=afterburner ) vagy <br />&theme=themename egy belső Moodle URL-re (pl.: mymoodlesite.com/course/view.php?id=2&theme=afterburner )..';
$string['configallowuserblockhiding'] = 'A felhasználók az egész portálon elrejthetik/megjeleníthetik az oldalsó blokkokat? Ez a funkció javascript és sütik használatával emlékezik az egyes becsukható blokkok állapotára, és csak a felhasználó saját nézetére van hatással.';
$string['configallowuserswitchrolestheycantassign'] = 'Alaphelyzetben a felhasználók a moodle/role:assign segítségével váltanak szerepet. Ennek bekapcsolása esetén ez a követelmény elhárul és a szerepek elérhetővé válnak a "Szerep átváltása erre..." lenyíló menüből, melyet csak a "Szerepek hozzárendelésének engedélyezése" táblázat beállításai határoznak meg. Ajánlatos elkerülni, hogy a "Szerepek hozzárendelésének engedélyezése" táblázat beállításai alapján a felhasználók meglévő szerepüknél szélesebb hatókörű szerepre váltsanak át.';
$string['configallowuserthemes'] = 'Ennek bekapcsolásakor a felhasználók beállíthatják saját stílusukat. A felhasználói stílusok felülírják a portálstílusokat (de a kurzusstílusokat nem).';
$string['configallusersaresitestudents'] = 'A portál kezdőoldalán szereplő tevékenységekhez MINDEN felhasználó tanulónak tekintendő? Ha válasza "Igen", akkor minden jóváhagyott felhasználó tanulóként részt vehet ezen tevékenységekben. Ha válasza "Nem", akkor csak a legalább egy kurzusban már részt vevő felhasználók  kapcsolódhatnak be a kezdőoldalon szereplő tevékenységekbe. A kezdőoldalon szereplő tevékenységeket illetően csak a rendszergazdák és a külön kijelölt tanárok vehetnek részt tanári minőségben.';
$string['configauthenticationplugins'] = 'Válassza ki a használni kívánt hitelesítő segédprogramokat és rendezze el őket végrehajtási sorrend szerint.';
$string['configautolang'] = 'Kikapcsolt portálbeállítás esetén az alapbeállítás szerinti nyelvet állapítsa meg a böngésző beállítása alapján.';
$string['configautologinguests'] = 'A látogatók automatikusan vendégként lépjenek-e be, ha valamely kurzusba vendégként jelentkeznek be?';
$string['configbloglevel'] = 'Ezzel a beállítással korlátozhatja, mely felhasználói blogokat lehet megtekinteni ezen a portálon. Ezzel a blog MEGTEKINTÉSÉNEK tartalmát szabja meg, nem annak feladóját vagy a blogüzenetek típusait. A blogokat teljes egészében kikapcsolhatja, ha egyáltalán nem akarja őket használni.';
$string['configcachetext'] = 'Nagyobb portálokon vagy szövegszűrőt használó portálokon ez a beállítás ugyancsak felgyorsíthatja az eseményeket. A szövegek másolata az itt megadott ideig feldolgozott formában megőrződik. Ennek az értéknek túl kicsire állítása valamelyest lassíthatja a programot, túl nagyra állítva viszont a szövegek (például új hivatkozásokkal való) frissítése sokáig tarthat.';
$string['configcalendarcustomexport'] = 'Naptár egyéni adattartományként való exportálásának bekapcsolása';
$string['configcalendarexportsalt'] = 'Ez a véletlenszerűen előálló szöveg a naptárexportáláshoz használt hitelesítő jelek biztonságosságát fokozza. Ha ezeket a rejtjelbiteket módosítja, minden jelenlegi jel érvénytelenné válik.';
$string['configclamactlikevirus'] = 'Állományok vírusosként kezelése';
$string['configclamdonothing'] = 'Állományok vírusmentesként kezelése';
$string['configclamfailureonupload'] = 'Ha a vírusirtó úgy van beállítva, hogy ellenőrizze a feltöltött állományokat, de rosszul van konfigurálva vagy valamilyen ismeretlen okból nem fut le, mi legyen a teendő? Ha a beállítás \'Állományok vírusosként kezelése\', akkor vagy karanténba kerülnek, vagy a rendszer törli őket. Ha a beállítás \'Állományok vírusmentesként kezelése\', akkor az állományok szokásos módon a célkönyvtárba kerülnek. Mindenesetre a rendszergazdák figyelmeztetést kapnak arról, hogy a vírusirtó nem működött. Ha a beállítás \'Állományok vírusosként kezelése\', a vírusirtó pedig valamilyen okból nem fut le (rendszerint azért, mert rossz útvonalat adott meg hozzá), akkor MINDEN feltöltött állomány vagy karanténba kerül, vagy a rendszer törli őket. Ezzel a beállítással legyen óvatos!';
$string['configconvertformat'] = 'Ha elérhető a <i>latex</i>, a <i>dvips</i> és a <i>convert</i>, akkor a képek a megadott formátum felhasználásával jönnek létre. Ellenkező esetben a rendszer mimeTeX-et használ és GIF-képeket hoz létre.';
$string['configcookiehttponly'] = 'Bekapcsolja a PHP 5.2.0 új funkcióját – a böngészők csak valódi http-kérésekkel küldenek sütit, a sütiket szkriptnyelvek nem érhetik el. Ezt nem minden böngésző támogatja, emellett előfordulhat, hogy a jelenlegi kóddal nem teljesen kompatibilis. Célszerű lehet bizonyos XSS-támadásokat megelőzni.';
$string['configcookiesecure'] = 'Ha a szerver csak https-kapcsolatot fogad el, akkor ajánlott bekapcsolni a biztonságos sütik küldését. Bekapcsolása esetén ügyeljen arra, hogy a webszerver ne fogadjon el http://-t, vagy állítson be állandó https://-címre való átirányítást. Ha a <em>wwwroot</em> címe nem https:// kezdetű, akkor ez a beállítás automatikusan kikapcsol.';
$string['configcountry'] = 'Ha itt egy ország van megadva, akkor az új felhasználók esetén alaphelyzetben ez az ország lesz a kiválasztott ország. A választás előírásához hagyja ezt a helyet üresen.';
$string['configcourseoverviewfilesext'] = 'Az engedélyezett kurzusáttekintő fájlok kiterjesztéseinek vesszővel elválasztott listája';
$string['configcourseoverviewfileslimit'] = 'A kurzus összegzéséhez csatolható állományok maximális száma';
$string['configcourserequestnotify'] = 'Adja meg az új kurzus kérésekor értesítendő felhasználó felhasználói nevét.';
$string['configcourserequestnotify2'] = 'Kurzuskérés esetén értesített felhasználók. A listán csak a kurzuskérést jóváhagyó felhasználók jelennek meg.';
$string['configcoursesperpage'] = 'Kurzusok oldalankénti számának megadása a kurzuslista megjelenítéséhez.';
$string['configcourseswithsummarieslimit'] = 'Kurzuslistán megjelenítendő kurzusok maximális száma összegzésekkel együtt';
$string['configcronclionly'] = 'Beállítása esetén a cron-kód csak a parancssorból futtatható, a webről nem. Felülírja a cron alább beállított jelszavát.';
$string['configcronremotepassword'] = 'Ez azt jelenti, hogy a cron.php kód böngészőből nem futtatható az alábbi formájú URL:<pre>      http://site.example.com/admin/cron.php?password=opensesame </pre> segítségével megadott jelszó nélkül. Ha üresen hagyja, nem lesz szükség jelszóra.';
$string['configcurlcache'] = 'A cURL gyorsítótár működési ideje másodpercekben.';
$string['configcustommenuitems'] = 'Itt egy stílusok által megjelenítendő egyéni menüt állíthat be. Minden sor valamilyen menüszöveget,  (választhatóan) egy URL-ugrópontot, (választhatóan) egy elemleírást és nyelvi kódot tartalmaz, melyeket függőleges vonalak választanak el egymástól. Kötőjelekkel struktúrát adhat meg. Például:
<pre> Moodle-közösség|http://moodle.org -Moodle ingyenes támogatása|http://moodle.org/support -Moodle-fejlesztés|http://moodle.org/development
--Moodle-dokumentumok|http://docs.moodle.org|Moodle-dokumentumok németül|http://docs.moodle.org/de|Dokumentáció németül|de
Moodle.com|http://moodle.com/ </pre>';
$string['configdbsessions'] = 'Bekapcsolásakor ez a beállítás a pillanatnyi eseményekről szóló adatokat adatbázisban tárolja. Ne feledje, hogy a beállítás módosítása esetén minden belépett felhasználót a rendszer kiléptet (Önt is beleértve). Ha MySQL-t használ, a my.cnf-ben (vagy my.ini-ben) a  \'max_allowed_packet\' legalább 4 MB legyen. A többi eseményvezérlő közvetlenül a config.php-ben állítható be, lásd: config-dist.php. Ez a lehetőség eltűnik, ha az eseményvezérlőt a config.php-ben állítja be.';
$string['configdebug'] = 'Bekapcsolt állapotban a PHP hibajelentése bővebb lesz, azaz több figyelmeztetést nyomtat ki. Ez csak a fejlesztőknek hasznos.';
$string['configdebugdisplay'] = 'Bekapcsolása esetén a hibajelentések a HTML-oldalra kerülnek. Noha ez egy praktikus megoldás, általában véve tönkreteszi az XHTML-t, a JS-t, a sütiket és a HTTP-fejléceket. Kikapcsolása esetén a hibajelentéseket a szervernaplóba küldi, így jobb hibaelhárítást tesz lehetővé. A PHP error_log beállítása határozza meg, hogy ez melyik naplóba kerül.';
$string['configdebugpageinfo'] = 'Ha bekapcsolja, az oldal láblécén megjelennek az oldallal kapcsolatos információk.';
$string['configdebugsmtp'] = 'Bekapcsolja szöveges hibaelhárítási információk megadását e-mail üzenetek SMTP-szerverre küldése során.';
$string['configdebugvalidators'] = 'Ha bekapcsolja, az oldal láblécén ugrópontok jelennek meg a külső validálóhoz. Előfordulhat, hogy új felhasználót kell létrehoznia <em>w3cvalidator</em> névvel és engedélyeznie kell a vendégként való hozzáférést.';
$string['configdefaulthomepage'] = 'Ez határozza meg a belépett felhasználók kezdőoldalát';
$string['configdefaultrequestcategory'] = 'A felhasználók által igényelt kurzusok automatikusan ebbe a kategóriába kerülnek.';
$string['configdefaultrequestedcategory'] = 'Alapkategória az igényelt kurzusok elhelyezésére, amennyiben megtörténik jóváhagyásuk.';
$string['configdefaultuserroleid'] = 'Minden belépett felhasználó megkapja az itt megadott szerephez tartozó portálszintű jogosultságokat, az esetleges EGYÉB szerepei mellett. Az alapbeállítás a hitelesített felhasználói szerep (régebbi változatok esetén vendég). Ne feledje, hogy ez nem ütközik többi szerepükkel, csak biztosítja, hogy minden felhasználó rendelkezzen olyan lehetőségekkel, amelyek kurzusszinten nem rendelhetők hozzá (pl. blogüzeneteket helyezhetnek el, saját naptárukat kezelhetik stb.).';
$string['configdeleteincompleteusers'] = 'Ezen idő eltelte után minden hiányosan beállított fiókot töröl a rendszer.';
$string['configdeleteunconfirmed'] = 'Ha az e-mail hitelesítéssel működik, ez lesz az az idő, amely alatt a felhasználók által adott választ a rendszer elfogadja. Ezen időszak elteltével a korábbi, meg nem erősített felhasználói azonosítókat törli a rendszer.';
$string['configdenyemailaddresses'] = 'Ha nem kíván konkrét doménekről e-mailt fogadni, ugyanúgy sorolja fel őket itt. Minden egyéb domént a rendszer elfogad. Aldomének elutasításához a domént \'.\'-vel adja meg. Pl. hotmail.com yahoo.co.uk.';
$string['configdisableuserimages'] = 'Felhasználói profilkép módosításának tiltása felhasználók számára.';
$string['configdisplayloginfailures'] = 'Ez tájékoztatja az adott felhasználókat a korábbi sikertelen belépésekről.';
$string['configdndallowtextandlinks'] = 'Szöveg és ugrópontok kurzusoldalra való elhúzásának ki-be kapcsolása, állományok elhúzásával együtt. Vegye figyelembe, hogy Firefox esetén és böngészők között a szöveg átemelése nem megbízhatóan működik!';
$string['configdocroot'] = 'A Moodle Docs útvonalát adja meg az oldalak láblécén. Ha üresen marad, nem jelenik meg ugrópont.';
$string['configdoctonewwindow'] = 'Ennek bekapcsolásakor a Moodle Docs ugrópontjai új ablakban jelennek meg.';
$string['configeditordictionary'] = 'A rendszer ezt az értéket használja, ha az aspell nem rendelkezik a felhasználó nyelve szerinti szótárral.';
$string['configeditorfontlist'] = 'Válassza ki a szerkesztő lenyíló listáján megjelenítendő betűfajtákat.';
$string['configemailchangeconfirmation'] = 'E-mailben való megerősítést ír elő, ha a felhasználók profiljukban módosítják e-mail címüket.';
$string['configenableajax'] = 'Ezzel a beállítással szabályozhatja az AJAX használatát a teljes portálon. Az AJAX bizonyos funkciókhoz, pl. az egérrel való húzáshoz szükséges.';
$string['configenableblogs'] = 'Ez a kapcsoló minden portált használó számára saját blogot biztosít.';
$string['configenablecalendarexport'] = 'Exportálás vagy naptárak előjegyzésének engedélyezése.';
$string['configenablecomments'] = 'Megjegyzések engedélyezése';
$string['configenablecourserequests'] = 'Ezzel bármely felhasználó kérheti egy kurzus létrehozását.';
$string['configenabledevicedetection'] = 'Stílusok és más funkciók alkalmazásához bekapcsolja a mobiltelefonok, okostelefonok, táblaszámítógépek vagy alapeszközök (asztali számítógépek, hordozható számítógépek stb.) észlelését.';
$string['configenablegroupmembersonly'] = 'Bekapcsolása esetén a tevékenységek elérése csoporttagokra korlátozható. Ezzel megnőhet a szerver leterhelése. Ráadásul az osztályozónapló kategóriáit úgy kell beállítani, hogy a tevékenységeket a csoporton kívüliek ne láthassák.';
$string['configenablemobilewebservice'] = 'Mobil szolgáltatás bekapcsolása hivatalos Moodle-alkalmazáshoz vagy más ezt igénylő alkalmazáshoz. További információk itt olvashatók: {$a}.';
$string['configenablerssfeeds'] = 'Bekapcsolása esetén a portálon különféle RSS-hírek készülnek, pl. blogokról. fórumokról. adatbázis-tevékenységekről és szójegyzékekről. A változások megjelenítéséhez az egyes tevékenységmodulokban is be kell kapcsolni az RSS-híreket';
$string['configenablerssfeedsdisabled'] = 'Nem elérhető, mert az RSS-hírek az egész portálon ki vannak kapcsolva. Bekapcsolásukhoz térjen át a Portáladminisztráció alatt a Változók beállítása pontra.';
$string['configenablerssfeedsdisabled2'] = 'Az RSS-hírek szerverszinten ki vannak kapcsolva.';
$string['configenablesafebrowserintegration'] = 'Ezzel a tesztbeállítási űrlapon a böngésző biztonsági mezőjéhez hozzáadhatja a \'Biztonságos vizsgáztatási böngésző előírása\' opciót. További információk: http://www.safeexambrowser.org/ .';
$string['configenablestats'] = 'Ha ezt bekapcsolja, a Moodle cronjob programja feldolgozza a naplókat és statisztikát állít elő. A portál forgalmától függően ez sok időt vehet igénybe. Használata esetén az egyes kurzusokról vagy az egész portálról érdekes grafikonokat és statisztikákat tekinthet meg.';
$string['configenabletrusttext'] = 'Alaphelyzetben a Moodle a felhasználóktól érkező szövegeket mindig gondosan megtisztítja a biztonságot veszélyeztető esetleges hibás kódtól, médiafájloktól stb. A megbízható tartalom rendszerével a megbízhatónak tekintett felhasználóknak engedélyezheti ezen fejlettebb funkciók ütközésmentes használatát. A rendszer bekapcsolásához először jelölje be ezt a beállítást, majd rendeljen megbízható tartalom szerinti engedélyt egy konkrét Moodle-szerephez.  Az ilyen felhasználók által létrehozott vagy feltöltött szövegek megbízható jelölést kapnak és megjelenítésük előtt nem esnek át a tisztítási folyamaton.';
$string['configenablewebservices'] = 'A webszolgáltatások lehetővé teszik egyéb rendszerek számára, hogy belépjenek ezen Moodle alá és műveleteket hajtsanak végre.';
$string['configenablewsdocumentation'] = 'Bekapcsolása esetén a webszolgáltatások dokumentációja automatikusan előállítódik. A felhasználó saját dokumentációját biztonsági kulcsainak {$a} oldalán érheti el. Csak a bekapcsolt protokollok dokumentációját jeleníti meg.';
$string['configerrorlevel'] = 'Válassza ki, hány PHP-figyelmeztetés jelenjen meg. A Szokásos kiválasztása rendszerint a legjobb megoldás.';
$string['configexportlookahead'] = 'Exportálás közbeni előretekintés napjainak száma';
$string['configexportlookback'] = 'Exportálás közbeni előretekintés napjainak száma';
$string['configextendedusernamechars'] = 'Ezt bekapcsolva a tanulók bármilyen karaktert használhatnak felhasználónevükben (ez nincs befolyással konkrét nevükre!). Az alapbeállítás \'Nem\', amely esetén a felhasználónév csak betűket, számokat, aláhúzást (_), kötőjelet (-), pontot (.) vagy kukacot (@) tartalmazhat.';
$string['configextramemorylimit'] = 'Egyes programkódoknak (pl. keresés, mentés/helyreállítás, cron) nagyobb memóriára van szükségük. Nagy portál esetén állítson be magasabb értékeket.';
$string['configfilterall'] = 'Minden szövegsor szűrése, beleértve a fejléceket, a címeket, a navigációs sávot stb. Bekapcsolása akkor hasznos, ha a multilang szűrőt használja, egyéb esetben csak növeli a portál leterhelését.';
$string['configfiltermatchoneperpage'] = 'Automatikusan kapcsoló szűrők esetén csak az oldalon a szöveg első előfordulásához áll elő kapcsolat. Az összes többit a rendszer figyelmen kívül hagyja.';
$string['configfiltermatchonepertext'] = 'Automatikusan kapcsoló szűrők esetén az oldalon csak az egyes szövegek (pl. forrás, blokk) első előfordulásához áll elő kapcsolat. Az összes többit a rendszer figyelmen kívül hagyja. Ezt a beállítást figyelmen kívül hagyja, ha a fenti \'Oldalanként egy...\' beállítás <i>igen</i>.';
$string['configfilteruploadedfiles'] = 'Minden feltöltött HTML- és szöveges állományt, csak a feltöltött HTML-állományokat, illetve egyetlen állományt se dolgozzon fel a szűrőkkel, mielőtt megjelennének.';
$string['configforcelogin'] = 'A portál kezdőoldalát és a kurzuslistákat (de nem a kurzusokat) bárki megtekintheti anélkül, hogy belépne a portálra. Ha azt szeretné, hogy a portálra látogatók ELŐSZÖR lépjenek be, ezt a beállítást be kell kapcsolni.';
$string['configforceloginforprofiles'] = 'Ezzel a beállítással érhető el, hogy a bejelentkezőknek ne vendégként, hanem valódi felhasználónévvel kelljen belépni, mielőtt valamely felhasználói profilt megtekintenének. Ha ezt a beállítást kikapcsolta, előfordulhat, hogy egyes felhasználók hirdetést (levélszemetet) vagy egyéb, oda nem való tartalmat tesznek közzé profiljukban, amely így az egész világ számára láthatóvá válik.';
$string['configfrontpage'] = 'Kiválasztása esetén a kiválasztott elemek megjelennek a portál kezdőoldalán.';
$string['configfrontpagecourselimit'] = 'A kurzusok maximális száma';
$string['configfrontpagecourselimithelp'] = 'A portálon a kurzusok felsorolásának nyitóoldalán megjelenítendő kurzusok maximális száma';
$string['configfrontpageloggedin'] = 'A fent kiválasztott elemek megjelennek a portál kezdőoldalán, ha egy felhasználó bejelentkezik.';
$string['configfullnamedisplay'] = 'Itt adható meg a megjelenő nevek alakja.  A "language" alapértéke szerinti nyelvi csomagban a "fullnamedisplay" határozza meg. Egyes nyelvekben a nevek másként jelenhetnek meg.

Az egynyelvű portálok esetén a legmegfelelőbb beállítás az alapértelmezett \'Vezetéknév + Keresztnév\', de dönthet úgy, hogy a vezetéknevek egyáltalán ne jelenjenek meg, vagy dönthet erről az adott nyelvi csomag alapján is (egyes nyelvekben az elrendezés ettől eltérő lehet). Használható helyőrzők: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename és alternatename.';
$string['configgeoipfile'] = 'A GeoIP City bináris adatállomány helye. Az állomány nem része a Moodle-csomagnak, külön kell beszerezni a <a href="http://www.maxmind.com/">MaxMind</a>-tól. Megvásárolhatja a kereskedelmi változatot vagy használhatja az ingyeneset.<br />Mindössze le kell töltenie a <a href="http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz" >http://geolite.maxmind.com/download/geoip/database/GeoLiteCity.dat.gz</a> állományt és ki kell csomagolnia szervere "{$a}" könyvtárába.';
$string['configgetremoteaddrconf'] = 'Ha szervere egy fordított gyorsítótár mögött van, ezzel a beállítással megadhatja, mely HTTP-fejlécek tartalmazhatják a megbízható távoli IP-címet. A fejlécek beolvasása sorrendben történik, kezdve az első elérhetővel.';
$string['configgradebookroles'] = 'Ezzel a beállítással szabályozhatja, ki szerepeljen az osztályozónaplóban.  A felhasználóknak adott kurzusban legalább ezen szerepek egyikével kell rendelkezni ahhoz, hogy megjelenjenek a kurzus osztályozónaplójában.';
$string['configgradeexport'] = 'Válassza ki, mely formátumú osztályozónaplók lesznek az osztályzatok exportálására használt elsődleges módszerek. A kiválasztott segédprogramok minden osztályzat esetén az \'utoljára exportált\' mezőt fogják beállítani és használni. Az exportált rekordok azonosítója ennek alapján lehet például \'új\' vagy \'frissített\'. Ha bizonytalan, hagyjon mindent bejelöletlenül.';
$string['confighiddenuserfields'] = 'Válassza ki, milyen információt tartalmazó mezőket kíván elrejteni a tanárokon/rendszergazdákon kívül minden egyéb felhasználó elől. Ezzel növelheti a tanulók adatainak titkosságát. A CTRL-billentyű lenyomásával egyszerre több mezőt is kiválaszthat.';
$string['configidnumber'] = 'Ezzel az opcióval adható meg, hogy (a) a felhasználóktól kell-e egyáltalán azonosítószámot kérni, (b) a felhasználóktól kér a rendszer azonosítószámot, de üresen hagyhatják, illetve (c) a felhasználóktól a rendszer azonosítószámot kér, ők pedig ezt nem hagyhatják üresen. Ha van megadva, akkor a felhasználói azonosítószám megjelenik a profiljukban.';
$string['configintro'] = 'Ezen az oldalon adhatók meg olyan beállítási változók, amelyekkel a Moodle megfelelően működhet az adott szerveren. Nem szükséges a beállítással sokat vesződni, az alapbeállítások rendszerint megfelelnek, emellett bármikor vissza lehet térni erre az oldalra és módosítani lehet a beállításokon.';
$string['configintroadmin'] = 'Ezen az oldalon kell megadni a fő rendszergazdát, aki ezt követően az egész portál fölött rendelkezik majd. Ügyeljen arra, hogy a felhasználónév és a jelszó biztonságos, az e-mail cím pedig valóságos legyen. Később további rendszergazdákat adhat meg.';
$string['configintrosite'] = 'Ezen az oldalon állíthatja be a kezdőoldalt és az új portál nevét. Később bármikor visszatérhet ide és módosíthatja a beállításokat a honlap portáladminisztrációs menüiről.';
$string['configiplookup'] = 'Ha a naplózásokhoz hasonlóan egy IP-címre kattint (pl. 34.12.222.93), egy térkép jelenik meg, amely megbecsüli, hol található az adott IP.  Különféle segédprogramok közül választhat, melyek más-más előnyökkel és hátrányokkal rendelkeznek.';
$string['configkeeptagnamecase'] = 'Jelölje be, ha meg szeretné tartani a felhasználók által eredetileg megadott kis- és nagybetűket.';
$string['configlang'] = 'Válasszon egy alapértelmezett nyelvet a teljes portál számára. A felhasználók ezt a beállítást a nyelvi menüben vagy személyes profiljukban felülírhatják.';
$string['configlanglist'] = 'Ha ezt üresen hagyja, a felhasználók a Moodle adott telepítéséből elérhető bármely nyelvet választhatják. A nyelvi menüt lerövidítheti, ha vesszővel elválasztva itt felsorolja a kívánt nyelvek kódjait. Például:  en,es_es,fr,it';
$string['configlangmenu'] = 'Itt adja meg, hogy megjelenjen-e az általános nyelvi menü a honlapon, a belépési oldalon stb. Ez nem korlátozza a felhasználókat abban, hogy a nekik megfelelő nyelvet saját profiljukban beállítsák.';
$string['configlangstringcache'] = 'Az adatkönyvtárban az összes nyelvi szöveget lefordított fájlokká alakítja a gyorsítótárhoz. Ha a Moodle-t fordítja vagy annak forráskódját módosítja, ezt kikapcsolhatja. Ellenkező esetben a jobb teljesítmény érdekében hagyja bekapcsolva.';
$string['configlatinexcelexport'] = 'Válassza ki az Excel-exportálás kódolását.';
$string['configlocale'] = 'Válasszon egy egész portálra érvényes nyelvterületet - ez befolyásolja a dátumok formáját és nyelvét. Ehhez az adott operációs rendszerben a nyelvterületre vonatkozó adatoknak már telepítve kell lenni (linux esetén pl. en_US vagy es_ES). A legtöbbször ezt a mezőt célszerű üresen hagyni.';
$string['configloginhttps'] = 'Ennek bekapcsolása esetén a Moodle csak a belépési oldalon használ biztonságos https-csatlakozást (így biztonságos belépést), ezt követően visszatér a gyorsabb normál http-vel megadott URL használatára. VIGYÁZAT: ennek a beállításához a https-t külön be KELL állítani a webszerveren - ellenkező esetben KIREKESZTHETI MAGÁT SAJÁT PORTÁLJÁRÓL!';
$string['configloglifetime'] = 'Itt adható meg a felhasználói aktivitás naplózásának megőrzési ideje. Az ennél régebbi naplókat a rendszer automatikusan törli. Érdemes a naplókat a lehető leghosszabb ideig megőrizni, mert szükség lehet rájuk. Ha viszont túlságosan nagy a szerver forgalma és gondok merülnek fel a teljesítménnyel kapcsolatban, akkor csökkentheti a naplómegőrzés időtartamát. A statisztika megfelelő működése érdekében azonban 30-nál alacsonyabb értéket nem célszerű megadni.';
$string['configlookahead'] = 'Előrenézési napok száma';
$string['configmaxbytes'] = 'Itt adható meg a teljes portálra vonatkozóan a feltöltött állományok maximális mérete. Ezt a beállítást a PHP upload_max_filesize és az Apache LimitRequestBody beállítása határolja be. Ugyanakkor a maxbytes a kurzusszinten vagy a modulszinten választható méreteket korlátozza. Ha a \'Server Limit\' lett kiválasztva, a rendszer a szerver által engedélyezett szervermaximumot fogja használni.';
$string['configmaxconsecutiveidentchars'] = 'A jelszavak legfeljebb ennyi egymás után következő azonos karakterből állhatnak. Az ellenőrzést a 0-t választva kapcsolhatja ki.';
$string['configmaxeditingtime'] = 'Ez adja meg azt az időt, amely alatt még lehet fórumüzeneteket, naplóvisszajelzéseket stb. újraszerkeszteni. Rendszerint egy 30 perces időtartam megfelelőnek mondható.';
$string['configmaxevents'] = 'Előrenézés eseményei';
$string['configmaxusersperpage'] = 'A felhasználói kiválasztó modulban megjelenítendő felhasználók max. száma kurzus, csoport, beiratkozottak, webszolgáltatás stb. esetén';
$string['configmessaging'] = 'Bekapcsolandó-e a portál felhasználói közötti üzenetküldő rendszer?';
$string['configmessagingallowemailoverride'] = 'E-mail értesítések a felhasználói profilban szereplőtől eltérő címre küldésének engedélyezése.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Az elolvasott értesítések helytakarékosság céljából törölhetők. Az olvasás és a törlés között mennyi idő teljen el?';
$string['configmessaginghidereadnotifications'] = 'Üzenetelőzmények megtekintése közben elolvasandókról, pl. fórumhozzászólásokról szóló értesítések elrejtése';
$string['configminpassworddigits'] = 'A jelszavakban legalább ennyi számjegynek kell szerepelni.';
$string['configminpasswordlength'] = 'A jelszavakban legalább ennyi karakternek kell szerepelni.';
$string['configminpasswordlower'] = 'A jelszavakban legalább ennyi kisbetűnek kell szerepelni.';
$string['configminpasswordnonalphanum'] = 'A jelszavakban legalább ennyi nem alfanumerikus karakternek kell szerepelni.';
$string['configminpasswordupper'] = 'A jelszavakban legalább ennyi nagybetűnek kell szerepelni.';
$string['configmobilecssurl'] = 'Mobil alkalmazás felületének testreszabására való CSS-állomány';
$string['configmodchooserdefault'] = 'A tevékenységválasztó alapesetben megjelenjen a felhasználók előtt?';
$string['configmycoursesperpage'] = 'Maximális megjelenítendő kurzusszám a felhasználó bármelyik saját kurzuslistáján belül';
$string['configmymoodleredirect'] = 'Ez a beállítás az átirányításokat a /my-ba tereli, ha nem a rendszergazda jelentkezik be, és lecseréli a legfelső szintű portálnavigálás nyomvonalát /my-ra';
$string['configmypagelocked'] = 'Ezzel megakadályozza, hogy az alapoldalt rendszergazdákon kívül mások szerkeszthessék.';
$string['confignavcourselimit'] = 'Korlátozza a be nem lépett vagy be nem iratkozott felhasználók számára a megjelenő kurzusok számát.';
$string['confignavshowallcourses'] = 'Beállítása esetén a felhasználók az általuk felvett kurzusokat mind a Kurzusaim ágon, mind a kurzusszerkezetben látni fogják.';
$string['confignavshowcategories'] = 'A navigációs sávon és a navigációs blokkokban látsszanak a kurzuskategóriák. Ez nem fordul elő azon kurzusokkal, amelyeket a felhasználó felvett, ugyanakkor kategóriák nélkül megjelennek a Kurzusaim alatt.';
$string['confignotifyloginfailures'] = 'A belépési hibák rögzítése után e-mail értesítések küldhetők. Ki láthatja ezeket az értesítéseket?';
$string['confignotifyloginthreshold'] = 'Ha a sikertelen belépésekről szóló értesítés be van kapcsolva, egy felhasználótól vagy egy IP-címről hány sikertelen belépés után kerüljön sor az értesítésre?';
$string['confignotloggedinroleid'] = 'A portálra be nem lépett felhasználókat úgy tekinti a rendszer, mint akik a portálon ezzel a szereppel rendelkeznek.  Legtöbbször a vendégként való kezelés megfelelő, de létrehozhat ennél bővebb vagy szűkebb jogosultságot biztosító szerepeket.  Például az üzenetküldés továbbra is csak megfelelő belépés esetén engedélyezett.';
$string['configopentogoogle'] = 'Ezen beállítás bekapcsolásakor a Google-lal vendégként léphet be a portálra. Emellett a Google-keresés révén a portálra eljutók automatikusan vendégként tudnak bejelentkezni. Ne feledje, hogy ez csak azon kurzusokhoz biztosít követhető hozzáférést, amelyek engedélyezik vendégek belépésé.';
$string['configoverride'] = 'A config.php definiálja';
$string['configpasswordpolicy'] = 'Bekapcsolásakor a Moodle a jelszavakat az érvényben lévő jelszószabvány szempontjából ellenőrzi. Az alábbi beállításokkal adhat meg egy jelszószabványt (ha \'Nem\'-re állítja, a rendszer kihagyja az ellenőrzést).';
$string['configpasswordresettime'] = 'Ennyi idő alatt lehet egy jelszó-visszaállítási kérelmet érvényesíteni. Általában 30 perc elegendő.';
$string['configpathtoclam'] = 'Útvonal a vírusirtóhoz. Feltehetőleg egy /usr/bin/clamscan vagy /usr/bin/clamdscan jellegű útvonal. Erre a vírusirtó működéséhez van szükség.';
$string['configpathtodu'] = 'Útvonal a du-hoz. Például /usr/bin/du. Megadásakor a könyvtártartalmakat mutató oldalak sokkal gyorsabban futtathatók olyan könyvtárak esetén, amelyekben sok állomány van.';
$string['configperfdebug'] = 'Ha bekapcsolja, a teljesítményre vonatkozó információk megjelennek a standard stílus lábrészében.';
$string['configprofileroles'] = 'A felhasználói profilokban és a részvételi oldalon látható szerepek felsorolása';
$string['configprofilesforenrolledusersonly'] = 'A levélszemétküldők támadásának megelőzésére a még be nem iratkozott felhasználók profiljának leírása rejtve marad. Az új felhasználóknak legalább egy kurzust fel kell venni ahhoz, hogy hozzáadhassák profiljuk leírását.';
$string['configprotectusernames'] = 'Alapesetben a forget_password.php nem ad semmilyen ötletet a felhasználónevek vagy az e-mail címek kitalálásához.';
$string['configproxybypass'] = 'Olyan (részleges) gazdagépek és IP-címek vesszővel elválasztott listája, amelyeknek a proxyt ki kell hagyni (pl., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'Ha ennek a szervernek proxyszámítógépet (például tűzfal) kell használni az Internet eléréséhez, akkor a proxygazdagép nevét és portszámát itt kell megadni. Ellenkező esetben hagyja üresen.';
$string['configproxypassword'] = 'Szükség esetén az internet proxyn keresztüli eléréséhez szükséges jelszó, üres, ha nincs rá szükség (PHP cURL-bővítményre van szükség).';
$string['configproxyport'] = 'Ha a szerver proxy-számítógépet használ, itt adja meg a proxy portját.';
$string['configproxytype'] = 'Webproxy típusa (PHP5-re és cURL-bővítményre van szükség a SOCKS5 támogatásához).';
$string['configproxyuser'] = 'Szükség esetén az internet proxyn keresztüli eléréséhez szükséges felhasználónév, üres, ha nincs rá szükség (PHP cURL-bővítményre van szükség).';
$string['configquarantinedir'] = 'Ha azt szeretné, hogy a vírusirtó a fertőzött állományokat karanténkönyvtárba helyezze, azt itt adja meg. A könyvtárnak a webszerver számára írhatónak kell lenni. Ha ezt üresen hagyja, illetve olyan könyvtárat ad meg, amely nem létezik vagy nem írható, akkor a rendszer törölni fogja a fertőzött állományokat. Lezáró perjelet ne használjon.';
$string['configrecaptchaprivatekey'] = 'Karaktersor az Ön Moodle-szervere és a recaptcha.net szerver közötti kommunikációhoz. Erről a portálról szerezhet be egyet: http://www.google.com/recaptcha.';
$string['configrecaptchapublickey'] = 'Karaktersor a reCAPTCHA-elem használatához a belépési űrlapon. A http://http://www.google.com/recaptcha
 állítja elő.';
$string['configrequestcategoryselection'] = 'Kurzuskérés eesetén kategória kiválasztásának engedélyezése';
$string['configrequestedstudentname'] = 'A tanuló megnevezése a kért kurzusokban';
$string['configrequestedstudentsname'] = 'A tanulók megnevezése a kért kurzusokban';
$string['configrequestedteachername'] = 'A tanár megnevezése a kért kurzusokban';
$string['configrequestedteachersname'] = 'A tanárok megnevezése a kért kurzusokban';
$string['configrequiremodintro'] = 'Kapcsolja ki, ha nem írja elő a felhasználók számára, hogy minden egyes tevékenységhez mellékeljenek leírást.';
$string['configrunclamavonupload'] = 'Bekapcsolása esetén a clam vírusirtó ellenőrzi az összes feltöltött állományt.';
$string['configrunclamonupload'] = 'Állományok feltöltésekor lefusson a vírusirtó? Ahhoz, hogy ez működjék, a pathtoclam útvonalnak helyesnek kell lennie. (Az ingyenes vírusirtó a http://www.clamav.net/ címről tölthető le.)';
$string['configsectioninterface'] = 'Felület';
$string['configsectionmail'] = 'Levelezés';
$string['configsectionmaintenance'] = 'Karbantartás';
$string['configsectionmisc'] = 'Egyéb';
$string['configsectionoperatingsystem'] = 'Operációs rendszer';
$string['configsectionpermissions'] = 'Engedélyek';
$string['configsectionrequestedcourse'] = 'Kurzuskérések';
$string['configsectionsecurity'] = 'Biztonság';
$string['configsectionstats'] = 'Statisztika';
$string['configsectionuser'] = 'Felhasználó';
$string['configsecureforms'] = 'A Moodle további biztonsági szintet használhat internetes űrlapok fogadásakor. Ennek bekapcsolásakor a böngésző HTTP_REFERER változóját ellenőrzi az adott űrlap címe szempontjából. Igen ritka esetekben ez gondot okozhat, ha a felhasználó olyan beállítású tűzfalat (pl. Zonealarm) használ, amely a HTTP_REFERER változót kiiktatja az internetes forgalomból. Ezt jelzi, ha az űrlap \'lefagy\'. Ha felhasználóinak gondja támad (például) a belépési oldallal, megfontolható ennek a beállításnak a kikapcsolása, jóllehet, ez a durvább jelszó elleni támadásokkal szemben védtelenül hagyhatja a rendszert. Ha bizonytalan, hagyja ezt a paramétert \'Igen\' beállításban.';
$string['configsessioncookie'] = 'Ez a beállítás szabja meg azt a sütinevet, amelyet a Moodle eseményei használni fognak. Megadása opcionális, és csak annyiban van értelme, hogy a sütik nem keverednek össze, ha ugyanazon a portálon a Moodle egynél több példányban fut.';
$string['configsessioncookiedomain'] = 'Ezzel módosíthatja azt a domént, ahonnan a Moodle-sütik elérhetők. Ez hasznos a Moodle olyan testre szabása esetén (pl. hitelesítés vagy beiratkozási segédprogramok), amely során a Moodle egy internetes alkalmazással vagy egy másik aldoménnel információkat kényszerül megosztani. <strong>VIGYÁZAT: kifejezetten ajánlott megtartani az alapbeállítást (üres), mert hibás érték esetén senki nem jelentkezhet be a portálra.</strong>';
$string['configsessioncookiepath'] = 'Ha módosítani kívánja a Moodle sütijeinek helyét, megadhat egy alkönyvtárat a portálján. Ellenkező esetben megfelelő az alapértelmezett \'/\'.';
$string['configsessiontimeout'] = 'Ha a portálra belépett személyek sokáig tétlenek (oldalak betöltése nélkül), a rendszer automatikusan kilépteti őket (eseményük befejeződik). Ez a változó szabja meg ezt az időtartamot.';
$string['configshowcommentscount'] = 'Megjegyzések számának kijelzése; a megjegyzések ugrópontjának kijelzésekor eggyel több lekérdezést jelent.';
$string['configshowicalsource'] = 'iCal-események forrásadatainak megjelenítése';
$string['configshowsiteparticipantslist'] = 'Az oldalhoz tartozó összes tanuló és tanár neve szerepelni fog az oldalhoz tartozó résztvevők felsorolásában. Ki tekintheti meg az oldalhoz tartozó résztvevők felsorolását?';
$string['configsitedefaultlicense'] = 'Alapértelmezett portállicenc';
$string['configsitedefaultlicensehelp'] = 'Alapértelmezett licenc valamely tartalom portálon való közzétételéhez';
$string['configsitemaxcategorydepth'] = 'Maximális kategóriamélység';
$string['configsitemaxcategorydepthhelp'] = 'Ez határozza meg a megjelenő alárendelt kategóriák maximális megjelenítési mélységét kategóriák vagy kombinált lista szerinti felsorolás esetén. A mélyebb szintű kategóriák ugrópontként láthatók, melyeket a felhasználó AJAX.utasítással nyithat meg.';
$string['configslasharguments'] = 'Az állományok (képek, feltöltések stb.) olyan kódon keresztül állnak rendelkezésre, amely \'perjeles argumentumokat\' használ. Ezzel a módszerrel az állományokat könnyebben betöltheti webböngészőbe, proxyszerverbe stb. Némely PHP-szerverrel ez a módszer nem használható, ezért ha gond támad a feltöltött állományok vagy képek (például felhasználók képei) megtekintésével, kapcsolja ki ezt a beállítást.';
$string['configsmartpix'] = 'Bekapcsolása esetén az ikonokat olyan PHP-kód biztosítja, amely az adott stílust, majd az összes fölötte lévő stílust, végül a Moodle /pix mappáját nézi végig. Ezáltal kevesebb ismétlődő képállományra lesz szükség a stílusokon belül, ugyanakkor némileg csökken a teljesítmény.';
$string['configstartwday'] = 'A hét kezdete';
$string['configstatsfirstrun'] = 'Itt adható meg, mely korábbi naplók legyenek feldolgozva, amikor a cronjob először készül feldolgozni a statisztikát. Ha nagy a forgalma és másokkal osztozik a portálon, jobb kerülni a túl régre való visszanyúlást, mert sokáig tarthat és sok erőforrást köthet le. (Ne feledje, hogy ennél a beállításnál 1 hónap = 28 nap. Az előállított grafikonok és jelentések esetén viszont 1 hónap = 1 naptári hónap.)';
$string['configstatsmaxruntime'] = 'A statisztika feldolgozása erőforrás-igényes lehet, ezért ezt a mezőt a lefuttatás idejének és időtartamának a megadásához kapcsolja össze a következővel.';
$string['configstatsmaxruntime2'] = 'A statisztika feldolgozása erőforrás-igényes lehet, ezért adjon meg egy maximális időt, amelyet az egy napi statisztika összegyűjtésére engedélyez. Egyetlen cron lefuttatásához a feldolgozható napok száma maximum 31 lehet.';
$string['configstatsmaxruntime3'] = 'Adja meg az egy napra statisztika kiszámítására fordítható maximális időt, figyelembe véve azt, hogy ez a feldolgozás erősen megterheli a szervert. Alább adhatja meg az egy cron alatt feldolgozható napok maximális számát.';
$string['configstatsruntimedays'] = 'Adja meg az egyes statisztikákban feldolgozott napok maximális számát. Naprakész statisztika esetén csak egy napot dolgoz föl a rendszer, ezért ezt az értéket a szerver leterheltsége szerint állítsa be; ha rövidebb cronra van szüksége, rövidítse az időtartamot.';
$string['configstatsruntimestart'] = 'A statisztikai feldolgozást végző cronjob mikor induljon el? Ha egy szerveren több Moodle fut, célszerű más-más időpontot megadni.';
$string['configstatsuserthreshold'] = 'Ez határozza meg a kurzust felvettek azon minimális számát, akikről készül statisztika.';
$string['configstrictformsrequired'] = 'Bekapcsolása esetén a felhasználók az űrlapok kitöltendő mezőibe nem írhatnak szóközt vagy sortörést.';
$string['configstripalltitletags'] = 'Szüntesse meg a bejelölést, ha engedélyezni kívánja HTML-címkék használatát tevékenység- és tananyagnevekben.';
$string['configsupportemail'] = 'A portál felhasználói ezt az e-mail címet kapják meg levelezéshez, ha általában segítségre szorulnak (például amikor létrehozzák saját fiókjukat). Ha üresen hagyja, a felhasználókat nem segíti egy ilyen elérhetőség.';
$string['configsupportname'] = 'Azon személy vagy intézmény neve, aki/amely a kisegítő e-mailen vagy weboldalon keresztüli általános segítséget nyújtja.';
$string['configsupportpage'] = 'A portál felhasználói ezt az ugrópontot kapják meg arra az esetre, ha általában segítségre szorulnak (például amikor létrehozzák saját fiókjukat).  Ha üresen hagyja, a felhasználókat nem segíti egy ilyen ugrópont.';
$string['configthemedesignermode'] = 'A stílusokhoz tartozó képek és a CSS a teljesítmény érdekében régóta a böngésző és a szerver gyorsítótárában vannak. Stílusok kidolgozása vagy kódírás esetén kapcsolja be a gyorsítótáras verziók elkerülése érdekében. Figyelem: ezzel portálja minden felhasználó számára lelassul! A gyorsítótárban lévő stílusokat kézzel is visszaállíthatja a stílusválasztó oldalon.';
$string['configthemelist'] = 'Ha ez üres, bármely érvényes stílus használható. Ha a stílusmenüt rövidíteni kívánja, itt a nevekből megadhat egy vesszővel elválasztott felsorolást. Ne használjon szóközt! Például: standard,orangewhite.';
$string['configtimezone'] = 'Itt állíthatja be az alapértelmezett időzónát. Ez az egyetlen alapértelmezett időzóna a dátumok megjelenítésére - minden felhasználó felülírhatja ezt a beállítást a saját profiljában. A \'Szerveridő\' beállításakor a Moodle a szerver operációs rendszerének a beállítását fogja használni, a felhasználói profilban megadott \'Szerveridő\' viszont a felhasználó számára írja elő az idő megjelenítéséhez ezt az alapbeállítást.';
$string['configuseblogassociations'] = 'A felhasználók szervezhessék blogjukat az üzenetek kurzusokhoz és kurzusmodulokhoz kapcsolása révén?';
$string['configuseexternalyui'] = 'Helyi állományok helyett használjon online fájlokat a Yahoo szervereiről. VIGYÁZAT: ehhez internetes kapcsolatra van szükség, különben portálján nem fog működni az AJAX. A beállítás nem működik https-t használó portálok esetén.';
$string['configuserquota'] = 'Az egyes felhasználók által saját állományterületükön tárolható bájtok maximális száma.
$a->bytes} bytes == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Bekapcsolása esetén a "portáloldalak" helyett a portál rövid neve szerepel a portáloldalak navigáláshoz való csomópontjaként.';
$string['configusetags'] = 'A címkék használatát az egész portálra bekapcsolja?';
$string['configvariables'] = 'Változók';
$string['configverifychangedemail'] = 'Bekapcsolja a módosított e-mail címek ellenőrzését az engedélyezett és a tiltott e-mail doménbeállítások alapján. Kikapcsolása esetén a domének használatára csak új felhasználók létrehozása esetén kerül sor.';
$string['configvisiblecourses'] = 'Rejtett kategóriák kurzusainak szokásos megjelenítése.';
$string['configwarning'] = 'Ezen beállítások módosításakor óvatosságra van szükség - a furcsa értékek gondot okozhatnak.';
$string['configyuicomboloading'] = 'Ennek révén YUI-könyvtárak optimális kombinált állománybetöltésre nyílik lehetőség. Éles környezetben a teljesítmény érdekében bekapcsolandó.';
$string['confirmation'] = 'Megerősítés';
$string['confirmdeletecomments'] = 'Biztosan törli a megjegyzéseket?';
$string['confirmed'] = 'Megerősítve';
$string['convertformat'] = 'kimeneti forma <i>átalakítása</i>';
$string['cookiehttponly'] = 'Csak http-sütik';
$string['cookiesecure'] = 'Csak biztonságos sütik';
$string['country'] = 'Alapértelmezett ország';
$string['coursecontact'] = 'Kurzusvezetők';
$string['coursecontact_desc'] = 'Ezzel a beállítással megadhatja, ki jelenjen meg a kurzusleírásban. A felhasználóknak legalább ezen szerepek közül eggyel rendelkezni kell az adott kurzusban ahhoz, hogy annak kurzusleírásában megjelenjenek.';
$string['courselistshortnames'] = 'Kibővített kurzusnevek megjelenítése';
$string['courselistshortnames_desc'] = 'Bekapcsolása esetén a rövid kurzusnevek is megjelennek. Szükség esetén a \'courseextendednamedisplay\' nyelvi megfelelőjének szerkesztésével szabhatja testre a kibővített kurzusneveket a nyelv testreszabása funkció segítségével.';
$string['coursemgmt'] = 'Kurzusok és kategóriák kezelése';
$string['courseoverview'] = 'Kurzus áttekintése';
$string['courserequestnotify'] = 'Értesítés kurzuskérésről';
$string['courserequestnotifyemail'] = '{$a->user} felhasználó {$a->link} címen új kurzust igényelt.';
$string['courserequests'] = 'Kurzuskérések';
$string['courserequestspending'] = 'Függőben lévő kurzuskérések';
$string['courses'] = 'Kurzusok';
$string['coursesperpage'] = 'Kurzus oldalanként';
$string['courseswithsummarieslimit'] = 'Kurzusok összegzésekkel korlátozásával';
$string['creatornewroleid'] = 'Szerkesztői szerep új kurzusokban';
$string['creatornewroleid_help'] = 'Ha a felhasználó még nem rendelkezik az új kurzus kezeléséhez szükséges engedéllyel, akkor automatikusan ezzel a szereppel iratkozik be.';
$string['cron'] = 'Cron';
$string['cronclionly'] = 'A cron futtatása csak a parancssorból';
$string['cronerrorclionly'] = 'Az oldal internetes elérését a rendszergazda kikapcsolta.';
$string['cronerrorpassword'] = 'Az oldal eléréséhez nem adott meg érvényes jelszót';
$string['cron_help'] = 'A cron.php karbantartó programkóddal egyes Moodle-modulok ütemezett feladatokat hajthatnak végre (pl. új fórumüzenetek kiküldése). A kód rendszeres, pl. 5 percenkénti  lefuttatásához valamilyen megoldásra van szükség.';
$string['cronremotepassword'] = 'Cron-jelszó a távoli eléréshez';
$string['cronwarning'] = 'A <a href="cron.php">cron.php karbantartó kódot</a> legalább 24 órája nem futtatta le.';
$string['ctyperecommended'] = 'Ajánlatos telepíteni az opcionális ctype PHP-bővítményt a portál teljesítményének növelése érdekében, különösen abban az esetben, ha a portál támogatja nem latin nyelvek használatát.';
$string['ctyperequired'] = 'A ctype PHP-bővítményt a Moodle előírja a portál teljesítményének növelése és a több nyelvű kompatibilitás érdekében.';
$string['curlcache'] = 'cURL-gyorsítótári TTL';
$string['curlrecommended'] = 'Ajánlatos a választható Curl-könyvtár telepítése a Moodle Networking bekapcsolásához.';
$string['curlrequired'] = 'A Moodle a Moodle-adattárakkal való kommunikációhoz most már megköveteli a cURL PHP bővítményt.';
$string['curltimeoutkbitrate'] = 'A cURL minimális időtúllépésének  bitsebessége (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Kellőképpen lassú bitsebesség tartalom letöltése során jelzendő időtúllépéshez.A HTTP HEAD-hez kapcsolódó kérelem alapján történik az időtúllépés kiszámítása a fájlméret alapján. A 0 kikapcsolja a kérelmet.';
$string['currenttheme'] = 'Aktuális stílus';
$string['customcheck'] = 'Egyéb ellenőrzések';
$string['custommenu'] = 'Egyedi menü';
$string['custommenuitems'] = 'Egyedi menü elemei';
$string['datarootsecurityerror'] = '<p><strong>BIZTONSÁGI FIGYELMEZTETÉS!</strong></p><p>Adatainak gyökérkönyvtára rossz helyen van és elérhető a netről. Így minden magánállományát bárki elérheti, portáljára pedig jogosulatlan rendszergazdaként való belépésre ad lehetőséget!</p>
<p>Adatainak gyökérkönyvtárát ({$a}) <em>mindenképpen</em> helyezze át nyilvánosan elérhető internetes könyvtárán kívülre, valamint frissítse a <code>$CFG->dataroot</code> beállítást config.php állományában.</p>';
$string['datarootsecuritywarning'] = 'Előfordulhat, hogy portáljának beállítása nem biztonságos. Ellenőrizze, hogy adatainak gyökérkönyvtárát ({$a}) nem lehet-e közvetlenül elérni a netről.';
$string['dbmigrate'] = 'A Moodle adatbázisának áttelepítése';
$string['dbmigrateconnecerror'] = 'Nem lehetett a megadott adatbázishoz kapcsolódni.';
$string['dbmigrateencodingerror'] = 'A megadott adatbázis kódolása UNICODE/UTF8 helyett {$a}. Adjon meg helyette egy másikat.';
$string['dbmigratepostgres'] = 'Az Ön által használt adatbázisszerver feltehetőleg a PostgreSQL. Az áttelepítési folyamat folytatásához az áttelepített adatok tárolásához kézi úton új adatbázist kell \'UNICODE\' (PostgreSQL 7) vagy \'UTF8\' (PostgreSQL 8) kódolással létrehozni. Folytatáshoz adja meg alább az új adatbázis kapcsolódási beállításait:';
$string['dbmigratewarning'] = 'A folytatás előtt ellenőrizze, készített-e biztonsági mentést Moodle-adatbázisáról. Ha nem biztos abban, hogyan kell ezt megtenni, forduljon a rendszergazdához. Az áttelepítési folyamat elindítása után a Moodle-portál karbantartási üzemmódba kerül.';
$string['dbmigratewarning2'] = 'Figyelmeztetés: most indítja el az áttelepítési folyamatot. Mindenképpen győződjön meg arról, hogy a teljes Moodle adatbázisról készült-e biztonsági másolat.';
$string['dbmigrationdeprecateddb'] = '<font color="#ff0000">Az adatbázisról új UTF8 áttelepítés készült, így ez elavulttá vált. Szerkessze meg a config.php állományt és a Moodle-t használja ezzel az új adatbázissal.</font>';
$string['dbmigrationdupfailed'] = 'Az adatbázisról nem sikerült másodpéldányt készíteni, ennek feltételezett oka:<font color="#ff0000">{$a}</font>';
$string['dbsessions'] = 'Adatbázis használata a folyamatról szóló információkhoz';
$string['debug'] = 'Hibaszűrési üzenetek';
$string['debugall'] = 'MIND: a PHP összes használható hibaszűrési üzenetének megjelenítése';
$string['debugdeveloper'] = 'FEJLESZTŐ: a Moodle külön hibaszűrési üzenetei fejlesztők számára';
$string['debugdisplay'] = 'Hibaszűrési üzenetek megjelenítése';
$string['debugging'] = 'Hibaszűrés';
$string['debugminimal'] = 'MINIMÁLIS: csak a végzetes hibákat jelzi';
$string['debugnone'] = 'EGY SEM: semmilyen hibát vagy figyelmeztetést nem jelez';
$string['debugnormal'] = 'SZOKÁSOS: jelzi a hibákat, a figyelmeztetéseket és a tájékoztató üzeneteket';
$string['debugpageinfo'] = 'Oldalra vonatkozó információk megjelenítése';
$string['debugsmtp'] = 'E-mailküldés hibaszűrése';
$string['debugstringids'] = 'Nyelvi szövegek eredetének kijelzése';
$string['debugstringids_desc'] = 'Ez a fordítókat hivatott segíteni. Bekapcsolása esetén egy kérelem URL-jéhez a strings=1 paramétert hozzáadva az egyes megjelenő szövegek mellett kijelzi a nyelvi állományt és a szövegazonosítót.';
$string['debugvalidators'] = 'Validáló ugrópontjainak megjelenítése';
$string['defaultcity'] = 'Alapbeállítás szerinti város';
$string['defaultcity_help'] = 'Az itt megadott város lesz új felhasználói fiókok létrehozása során az alapbeállítás szerinti város.';
$string['defaultformatnotset'] = 'Hiba a kurzus alapformátumának meghatározása során. Ellenőrizze a portál beállításait.';
$string['defaulthomepage'] = 'Alapértelmezett honlap felhasználóknak';
$string['defaultrequestcategory'] = 'Alapkategória kurzuskérésekhez';
$string['defaultsettinginfo'] = 'Alapbeállítás ({$a})';
$string['defaultuserroleid'] = 'Alapszerep minden felhasználó esetén';
$string['deleteincompleteusers'] = 'Hiányosan megadott felhasználók törlése ennyi idő elteltével';
$string['deleteunconfirmed'] = 'Hiányosan beállított felhasználók törlése ennyi idő elteltével';
$string['deleteuser'] = 'Felhasználó törlése';
$string['density'] = 'Sűrűség';
$string['denyemailaddresses'] = 'Elutasított e-mailek doménjei';
$string['development'] = 'Fejlesztés';
$string['devicedetectregex'] = 'Eszközészleléshez használt reguláris kifejezések';
$string['devicedetectregex_desc'] = '<p>Alapesetben a Moodle képes észlelni alapeszközöket (asztali gép, laptop stb.), mobil eszközöket (telefon, kézi eszközök), táblaszámítógépeket  (iPad, Android) és elavult rendszereket (Internet Explorer 6 felhasználók). A stílusválasztóval ezeket megkülönböztetheti egymástól. A beállítással olyan reguláris kifejezéseket használhat, amelyekkel különleges eszközfajták észlelhetők (ezek megelőzik az alaptípusokat).</p> <p>Például a \'/(MIDP-1.0|Maemo|Windows CE)/\' reguláris kifejezéssel egyes elterjedt telefonok észlelhetők \'featurephone\' visszatérési értékkel. Ez hozzáadja a \'featurephone\' értéket a stílusválasztón ahhoz a stílushoz, amely ezen eszközök esetén lesz használatos. Egyéb telefonok esetén továbbra is a mobil eszköztípushoz használatos stílust választja ki.</p>';
$string['devicedetectregexexpression'] = 'Reguláris kifejezés';
$string['devicedetectregexvalue'] = 'Visszatérési érték';
$string['devicetype'] = 'Eszköz típusa';
$string['disableuserimages'] = 'Felhasználói profilképek kikapcsolása';
$string['displayerrorswarning'] = 'A <em>display_errors</em> PHP-beállítás bekapcsolása nem ajánlott éles portálokon, mert egyes hibaüzenetek érzékeny adatokat adhatnak ki a szerveréről.';
$string['displayloginfailures'] = 'Sikertelen belépésekről értesítendő';
$string['dndallowtextandlinks'] = 'Szöveg/ugrópontok feltöltésének elhúzása';
$string['docroot'] = 'Moodle Docs dokumentumok gyökérkönyvtára';
$string['doctonewwindow'] = 'Új ablakban jelenik meg';
$string['download'] = 'Letöltés';
$string['edithelpdocs'] = 'Súgóállományok szerkesztése';
$string['editingnoncorelangfile'] = 'Kiegészítő modult/segédprogram fordítását próbálja módosítani. Külső programozású modulok fordítását csak a _local mappába mentheti. Az állomány fordítását áthelyezheti a modul lang könyvtárába és/vagy elküldheti a kiegészítő modult gondozó fél részére.';
$string['editlang'] = '<b>Szerkesztés</b>';
$string['editorbackgroundcolor'] = 'Háttérszín';
$string['editordictionary'] = 'Szerkesztő szótára';
$string['editorfontfamily'] = 'Betűtípus';
$string['editorfontlist'] = 'Betűtípusok felsorolása';
$string['editorfontsize'] = 'Betűméret';
$string['editorhidebuttons'] = 'Rejtett gombok';
$string['editorkillword'] = 'Word-forma szűrője';
$string['editorspelling'] = 'Szerkesztő helyesírás-ellenőrzése';
$string['editorspellinghelp'] = 'Helyesírás-ellenőrzés ki-/bekapcsolása. Bekapcsolása esetén az aspellnek a szerveren telepítve kell lennie.';
$string['editstrings'] = 'Szavak vagy kifejezések szerkesztése';
$string['emailchangeconfirmation'] = 'E-mail módosításának megerősítése';
$string['emoticonalt'] = 'Alternatív szöveg ';
$string['emoticoncomponent'] = 'Képelem';
$string['emoticonimagename'] = 'Kép neve';
$string['emoticons'] = 'Hangulatjelek használata';
$string['emoticons_desc'] = 'Az űrlap meghatározza a portálján használt hangulatjeleket (emotikonokat). Ha egy sort ki akar törölni a táblázatból, mentse el az űrlapot bármely kitöltendő mezőben egy üres értékkel. Új hangulatjel felvételéhez töltse ki az utolsó üres sorban lévő mezőket. Az összes mező alapértékekkel való visszaállításához kövesse a fenti ugrópontot.
* Szöveg (kitöltendő) - Ez a szöveg jelenik meg a hangulatjel képe helyén. Legalább két karakter hosszúnak kell lennie.
* Kép neve (kitöltendő) - A hangulatjel képállományának neve kiterjesztés nélkül, a pix mappához viszonyítva.
* Képelem (kitöltendő) - Az ikont létrehozó elem.
* Alternatív szöveg (választható) - Szövegazonosító és a hangulatjel alternatív szövegeleme.';
$string['emoticonsreset'] = 'Hangulatjelek visszaállítása alapértékekre';
$string['emoticontext'] = 'Szöveg';
$string['emptysettingvalue'] = 'Üres';
$string['enableajax'] = 'Az AJAX bekapcsolása';
$string['enableblogs'] = 'Blogok bekapcsolása';
$string['enablecalendarexport'] = 'Naptárexportálás bekapcsolása';
$string['enablecomments'] = 'Megjegyzések engedélyezése';
$string['enablecourserequests'] = 'Kurzuskérések bekapcsolása';
$string['enablecssoptimiser'] = 'CSS-optimalizáló bekapcsolása';
$string['enablecssoptimiser_desc'] = 'Bekapcsolása esetén a CSS gyorsítótárba kerülése előtt optimalizációs folyamaton megy keresztül. Az optimalizáló feldolgozza a CSS-t, kiszűri az ismétlődő szabályokat és stílusokat, a törölhető szóközöket és az újraformázást. Ne feledje bekapcsolni, mert a stílustervező üzemmód lassú, de optimalizált CSS létrehozását teszi lehetővé.';
$string['enabled'] = 'Bekapcsolva';
$string['enabledevicedetection'] = 'Eszközészlelés bekapcsolása';
$string['enablegravatar'] = 'A Gravatar bekapcsolása';
$string['enablegravatar_help'] = 'Bekapcsolása esetén a Moodle megpróbál Gravatarból elérni egy felhasználói profilképet, ha a felhasználó nem töltött föl egyet.';
$string['enablegroupmembersonly'] = 'Csak csoporttagok bekapcsolása';
$string['enablemobilewebservice'] = 'Mobil webszolgáltatás bekapcsolása';
$string['enablerecordcache'] = 'Rekordgyorsítótár bekapcsolása';
$string['enablerssfeeds'] = 'RSS-hírek bekapcsolása';
$string['enablesafebrowserintegration'] = 'A biztonságos vizsgáztatási böngésző integrálásának bekapcsolása';
$string['enablestats'] = 'Statisztika bekapcsolása';
$string['enabletgzbackups'] = 'Új biztonsági mentési formátum engedélyezése';
$string['enabletgzbackups_desc'] = 'Engedélyezése esetén a biztonsági mentések .mbz fájlok esetén új tömörítési formátumban jönnek létre (belsőleg tar.gz  formában tárolva). Ezzel megszűnik a biztonsági mentésekre vonatkozó 4 GB korlát és javulhat a teljesítmény. A hylereállítás minda két formátumot támogatja, a különbség a felhasználók számára szembeötlő.';
$string['enabletgzbackups_nozlib'] = 'A &lsquo;zlib&rsquo; PHP-bővítmény nem elérhető. Az új biztonsági mentési formátum ezt használja, ezért a zlib telepítéséig és bekapcsolásáig nem vehető igénybe.';
$string['enabletrusttext'] = 'Megbízható tartalom bekapcsolása';
$string['enablewebservices'] = 'Webszolgáltatások bekapcsolása';
$string['enablewsdocumentation'] = 'Webszolgáltatások dokumentációja';
$string['enrolinstancedefaults'] = 'Beiratkozási esemény alapbeállításai';
$string['enrolinstancedefaults_desc'] = 'Beiratkozás alapbeállításai új kurzusok esetén';
$string['enrolmultipleusers'] = 'A felhasználók beíratása';
$string['environment'] = 'Környezet';
$string['environmenterrortodo'] = 'A fentiekben fellelt összes környezeti problémát (hibát) el kell hárítania, mielőtt folytatja a Moodle ezen változatának a telepítését!';
$string['environmenterrorupgrade'] = 'Figyelmeztetés: a fentiekben talált összes környezeti problémát (hibát) el kell hárítania, mielőtt folytatja a Moodle ezen változatának frissítését! Ha a követelmények teljesítése nélkül végzi el a frissítést, gondokba (például adatvesztés) ütközhet. Biztosan folytatja a frissítést?';
$string['environmentmustfixsetting'] = 'A PHP beállításait módosítani kell.';
$string['environmentok'] = 'Szerverkörnyezete megfelel az összes minimális követelménynek.';
$string['environmentrecommendcustomcheck'] = 'ha ez az ellenőrzés sikertelen, az potenciális gondot jelez';
$string['environmentrecommendinstall'] = 'a megfelelő teljesítmény érdekében telepítse és kapcsolja be';
$string['environmentrecommendversion'] = 'a {$a->needed} változatot ajánlott a mostani {$a->current} helyett használni';
$string['environmentrequirecustomcheck'] = 'ennek az ellenőrzésnek sikerülnie kell';
$string['environmentrequireinstall'] = 'telepíteni kell és be kell kapcsolni';
$string['environmentrequireversion'] = 'a {$a->needed} változatot kell a mostani {$a->current} helyett használni';
$string['environmentsettingok'] = 'ajánlott beállítás észlelve';
$string['environmentshouldfixsetting'] = 'A PHP beállítását módosítani kell.';
$string['environmentxmlerror'] = 'Hiba a környezeti adatok ({$a->error_code}) beolvasása közben';
$string['errordeletingconfig'] = 'Hiba történt a(z)\'{$a}\' segédprogram beállítási rekordjainak törlése közben.';
$string['errorsetting'] = 'Ezt a beállítást nem lehetett elmenteni:';
$string['errorwithsettings'] = 'Egyes beállításokat hiba miatt nem lehetett módosítani.';
$string['everyonewhocan'] = 'Bárki, aki számára \'{$a}\' engedélyezve van.';
$string['exceptions'] = 'kivételek';
$string['execpathnotallowed'] = 'A futtatási útvonalak beállítása a config.php-ben ki van kapcsolva.';
$string['experimental'] = 'Kísérleti';
$string['experimentalsettings'] = 'Kísérleti beállítások';
$string['extendedusernamechars'] = 'Tetszőleges karakterek engedélyezése a felhasználónevekben';
$string['extramemorylimit'] = 'Külön php-memóriakorlát';
$string['fatalmagicquotesruntime'] = '<p>Súlyos konfigurációs hiba, tájékoztassa róla a rendszergazdát.</p><p> A helyes működéshez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>magic_quotes_runtime</code> <code>off</code>-ra állítandó.</p><p>Ezt a beállítást a szerveren lévő <code>php.ini</code>, Apache/IIS <br />beállításának vagy a <code>.htaccess</code> állomány szerkesztésével módosíthatja.</p>';
$string['fatalsessionautostart'] = '<p>Súlyos konfigurációs hiba, tájékoztassa róla a rendszergazdát.</p><p> A helyes működéshez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>session.auto_start</code> <code>off</code>-ra állítandó.</p><p>Ezt a beállítást a szerveren lévő <code>php.ini</code>, Apache/IIS <br />beállításának vagy a <code>.htaccess</code> állomány szerkesztésével módosíthatja.</p>';
$string['filecreated'] = 'Új állomány létrehozva';
$string['filestoredin'] = 'Állomány mentése ebbe a mappába:';
$string['filestoredinhelp'] = 'Ahová az állomány kerül';
$string['filterall'] = 'Minden szövegsor szűrése';
$string['filtermatchoneperpage'] = 'Oldalanként egy találat kiszűrése';
$string['filtermatchonepertext'] = 'Szövegenként egy találat kiszűrése';
$string['filters'] = 'Szűrők';
$string['filtersettings'] = 'Szűrők kezelése';
$string['filtersettingsgeneral'] = 'Általános szűrőbeállítások';
$string['filteruploadedfiles'] = 'Feltöltött állományok szűrése';
$string['forcelogin'] = 'Felhasználói belépés előírása';
$string['forceloginforprofileimage'] = 'Felhasználók számára a felhasználói képek megtekintéséhez belépés előírása';
$string['forceloginforprofileimage_help'] = 'Bekapcsolása esetén a felhasználóknak a felhasználói profilképek megtekintéséhez be kell lépni. Az alapbeállítás szerinti felhasználói kép jelenik meg minden tájékoztató e-mailben.';
$string['forceloginforprofiles'] = 'Felhasználói belépés előírása a profilhoz';
$string['forcetimezone'] = 'Időzóna megadásának előírása';
$string['formatuninstallwithcourses'] = 'Összesen {$a->count} kurzus használja a{$a->format} formátumot. Ezek {$a->defaultformat} formátumra módosulnak (a portál alapformátuma). Egyes kapcsolódó adatok elvesznek. Biztosan folytatja?';
$string['frontpage'] = 'Kezdőoldal';
$string['frontpagebackup'] = 'A kezdőoldal biztonsági mentése';
$string['frontpagedefaultrole'] = 'Kezdőoldali alapszerep';
$string['frontpagefilters'] = 'Kezdőoldali szűrők';
$string['frontpageloggedin'] = 'A kezdőoldal elemei belépéskor';
$string['frontpageoverrides'] = 'A kezdőoldalra vonatkozó engedélyek felülírása';
$string['frontpagequestions'] = 'A kezdőoldal kérdései';
$string['frontpagerestore'] = 'A kezdőoldal helyreállítása';
$string['frontpageroles'] = 'A kezdőoldal szerepei';
$string['frontpagesettings'] = 'A kezdőoldal beállításai';
$string['fullnamedisplay'] = 'Teljes név szerinti forma';
$string['fullnamedisplayprivate'] = 'Teljes név formája - magán';
$string['gdrecommended'] = 'A GD-bővítmény képek átalakítására szolgál. Ha nem telepíti, egyes funkciók, például a felhasználói profilképek hiányozni fognak.';
$string['gdrequired'] = 'A GD-bővítményre a Moodle-nak a képek átalakításához szüksége van';
$string['generalsettings'] = 'Általános beállítások';
$string['geoipfile'] = 'GeoIP City adatállomány';
$string['getremoteaddrconf'] = 'Naplózott IP-cím forrása';
$string['globalswarning'] = '<p><strong>BIZTONSÁGI FIGYELMEZTETÉS</strong>: A megfelelő működéshez a Moodle <br />bizonyos módosításokat ír elő az adott PHP-beállításokban.<p/><p>A <em>beállítandó</em> érték: <code>register_globals=off</code>. <p>Ezek a beállítások a <code>php.ini</code>, az Apache/IIS <br />beállításával vagy a <code>.htaccess</code>-állomány szerkesztésével módosíthatók.</p>';
$string['googlemapkey3'] = 'A Google Maps API V3 kulcsa';
$string['googlemapkey3_help'] = 'Speciális kódot kell megadnia, ha a Google Maps segítségével kíván IP-címeket megjeleníteni. A kód ingyenesen beszerezhető a <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a> címről.';
$string['gotofirst'] = 'Ugrás az első hiányzó szövegsorra';
$string['gradebook'] = 'Osztályozónapló';
$string['gradebookroles'] = 'Osztályozott szerepek';
$string['gradeexport'] = 'Elsődleges osztályzat exportálásának módszerei';
$string['gravatardefaulturl'] = 'Gravatar alapképének URL-je';
$string['gravatardefaulturl_help'] = 'A Gravatarnak megjelenítendő alapképre van szüksége, ha nem talál képet egy adott felhasználóhoz. Teljes URL-t adjon meg a képhez. Ha üresen hagyja, a Moodle megpróbál egy leginkább megfelelő alapképet használni az éppen nézett oldalhoz. A Gravatarral egyébként számos kód használható <a href="https://en.gravatar.com/site/implement/images/#default-image">alapképek előállítására</a>.';
$string['groupenrolmentkeypolicy'] = 'Csoportos beiratkozási kulcsra vonatkozó szabvány';
$string['groupenrolmentkeypolicy_desc'] = 'Ennek bekapcsolása esetén a Moodle ellenőrzi, hogy a csoportos beiratkozási kulcsok megfelelnek-e egy érvényes jelszószabványnak.';
$string['guestroleid'] = 'Vendégszerep';
$string['guestroleid_help'] = 'Ezt a szerepet a vendég automatikusan megkapja. Ideiglenesen azon be nem iratkozott felhasználók is megkapják, akik a kurzusba a vendéget beiratkoztató segédprogramon keresztül lépnek be.
';
$string['helpadminseesall'] = 'A rendszergazdák minden naptáreseményt lássanak, vagy csak a rájuk vonatkozókat?';
$string['helpcalendarcustomexport'] = 'Naptárexportálás során  az egyéni adattartományként való exportálás bekapcsolása. Ehhez előbb be kell kapcsolni a naptárexportálást.';
$string['helpexportlookahead'] = 'A naptár egyéni exportálásához hány nappal tekintsen előre a naptár?';
$string['helpexportlookback'] = 'A naptár egyéni exportálásához hány nappal tekintsen vissza a naptár?';
$string['helpforcetimezone'] = 'A felhasználók számára lehetővé teheti, hogy egyenként válasszák ki a saját időzónájukat, vagy dönthet úgy, hogy mindenkinek egyetlen időzónát biztosít.';
$string['helpshowicalsource'] = 'Kapcsolja be, ha importált iCal-eseményekhez szeretné megjeleníteni az iCalhoz tartozó nevet és ugrópontot';
$string['helpsitemaintenance'] = 'Verziófrissítések és egyéb tennivalók';
$string['helpstartofweek'] = 'Melyik nappal kezdődjék a naptárban a hét?';
$string['helpupcominglookahead'] = 'Alaphelyzetben a naptár hány nappal előre keressen közelgő eseményeket?';
$string['helpupcomingmaxevents'] = '(Maximum) hány közelgő eseményt lássanak a felhasználók alaphelyzetben?';
$string['helpweekenddays'] = 'A hét mely napjait kezelje a rendszer eltérő színben megjelenített \'ünnepnapként\'?';
$string['hiddenuserfields'] = 'Felhasználói mezők elrejtése';
$string['hidefromall'] = 'Elrejtés minden felhasználó elől';
$string['hidefromnone'] = 'Senki elől ne rejtse el';
$string['hidefromstudents'] = 'Elrejtés a tanulók elől';
$string['htmleditor'] = 'HTML-szerkesztő';
$string['htmleditorsettings'] = 'A HTML-szerkesztő beállításai';
$string['htmlsettings'] = 'HTML-beállítások';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP-biztonság';
$string['hubs'] = 'Elosztók';
$string['iconvrecommended'] = 'A portál teljesítményének növelése érdekében ajánlatos telepíteni az opcionális ICONV-könyvtárat, különösen akkor, ha a portál támogatja nemlatin nyelvek használatát.';
$string['iconvrequired'] = 'Telepíteni kell az ICONV-bővítményt.';
$string['ignore'] = 'Kihagy';
$string['includemoduleuserdata'] = 'Modul felhasználói adatainak hozzáadása';
$string['incompatibleblocks'] = 'A blokkok nem kompatibilisek';
$string['installhijacked'] = 'A telepítést az eredeti IP-címről kell befejezni.';
$string['installsessionerror'] = 'A PHP-folyamat nem indítható el, ellenőrizze, hogy böngészőjében a sütik be vannak-e kapcsolva.';
$string['intlrecommended'] = 'Az Intl-bővítménnyel javítható a többnyelvű szövegek támogatása, például a portál nyelve szerinti rendezés.';
$string['invalidsection'] = 'Érvénytelen szekció.';
$string['invaliduserchangeme'] = 'A \'changeme\' felhasználói név fenntartott név - ezzel nem hozhat létre felhasználói nevet.';
$string['ipblocked'] = 'A portál jelenleg nem érhető el.';
$string['ipblocker'] = 'IP-blokkoló';
$string['ipblockersyntax'] = 'Minden tételt egy sorba írjon. Érvényes az a teljes IP-cím (pl. <b>192.168.10.1</b>), amely egyetlen gazdagépet azonosít; a részleges cím (pl. <b>192.168.</b>), amely bármely ilyen számokkal kezdődő címet azonosít; a CIDR-jelölés (pl. <b>231.54.211.0/20</b>); az IP-címek tartománya (pl. <b>231.3.56.10-20</b>), ahol a tartomány a cím utolsó részére vonatkozik. A szöveges doménnevek (pl \'example.com\') használatát a rendszer nem támogatja, az üres sorokat pedig figyelmen kívül hagyja.';
$string['iplookup'] = 'IP-cím keresése';
$string['iplookupgeoplugin'] = '<a href="http://www.geoplugin.com">A geoPlugin</a> szolgáltatás földrajzi információkat keres. Pontosabb eredményekhez telepítse a MaxMind GeoLite adatbázis helyi példányát.';
$string['iplookupinfo'] = 'Alaphelyzetben a Moodle az ingyenes online NetGeo (az Internet földrajzi adatbázisa) szerverét használja IP-címek helyének kikereséséhez, de ezt az adatbázist már nem frissítik, így <em>merőben téves</em> adatokkal szolgálhat. Ajánlott a MaxMind ingyenes GeoLite City adatbázisának helyi példányát telepíteni.<br /> Az IP-cím helye vagy egy egyszerű térképen, vagy a Google Maps-en jelenik meg. Az interaktív térképek bekapcsolásához Google-fiókkal és ingyenes Google Maps API kulccsal kell rendelkeznie.';
$string['iplookupmaxmindnote'] = 'Ez a termék a MaxMind által létrehozott GeoLite-ot tartalmazza, amely elérhető a <a href="http://www.maxmind.com/">http://www.maxmind.com/</a> portálról.';
$string['keeptagnamecase'] = 'Címkenév betűalakjának megőrzése';
$string['lang'] = 'Alapnyelv';
$string['langcache'] = 'Nyelvi menü gyorsítótárba helyezése';
$string['langcache_desc'] = 'Nyelvi menü gyorsítótárba helyezése. Bekapcsolása esetén az elérhető fordítások a gyorsítótárba kerülnek. A gyorsítótár egy nyelvi csomag beépített nyelvcsomag-kezelővel  való telepítése vagy törlése esetén automatikusan frissítődik. A nyelvi csomag kézi telepítése esetén az összes gyorsítótár kiürítése funkcióval kell frissítenie a gyorsítótárban lévő csomagok listáját.';
$string['langlist'] = 'A nyelvi menü nyelvei';
$string['langmenu'] = 'A nyelvi menü megjelenítése';
$string['langpackwillbeupdated'] = 'A verzióváltás során a Moodle megpróbálja frissíteni a kiválasztott nyelvi csomagot.';
$string['langstringcache'] = 'Az összes nyelvi szöveg gyorsítótárba helyezése';
$string['languagesettings'] = 'Nyelvi beállítások';
$string['latexpreamble'] = 'LaTeX-preambulum';
$string['latexsettings'] = 'A LaTeX-átalakító beállításai';
$string['latinexcelexport'] = 'Excel-kódolás';
$string['legacyfilesaddallowed'] = 'Korábbi kurzusállományokhoz való hozzáadás engedélyezése';
$string['legacyfilesaddallowed_help'] = 'Ha egy kurzusnak vannak korábbi kurzusállományai, engedélyezi ezekhez új állományok és mappák hozzáadását.';
$string['legacyfilesinnewcourses'] = 'Új kurzusokban szereplő korábbi kurzusállományok';
$string['legacyfilesinnewcourses_help'] = 'Alapesetben a korábbi kurzusállományok területe csak frissített kurzusokban érhető el. Ezzel a beállítással egyes funkciók, pl. az egyetlen tevékenység biztonsági mentése/visszaállítása, nem használhatók.';
$string['licensesettings'] = 'Licencbeállítások';
$string['linkadmincategories'] = 'Rendszergazdai kategóriák összekapcsolása';
$string['linkadmincategories_help'] = 'Bekapcsolása esetén a rendszergazdai kategóriák ugrópontokként jelennek meg a rendszergazdai kategóriák oldalához.';
$string['loading'] = 'Betöltés';
$string['localetext'] = 'Az egész portál nyelvi környezete';
$string['localstringcustomization'] = 'Helyi szöveg testre szabása';
$string['location'] = 'Hely';
$string['locationsettings'] = 'Hely beállításai';
$string['locked'] = 'Zárolva';
$string['lockoutduration'] = 'Fiók felfüggesztésének időtartama';
$string['lockoutduration_desc'] = 'A felfüggesztett fiók ezen időtartam letelte után automatikusan újraindul.';
$string['lockoutemailbody'] = '{$a->username} felhasználónévre szóló,  \'{$a->sitename}\' szerveren futó fiókját többszöri érvénytelen bejelentkezés miatt felfüggesztettük. A fiók azonnal visszakapcsolásához térján át ide: {$a->link}.
A legtöbb levelező programban ez kék színű, kattintható ugrópontként jelenik meg.
Ha ez nem működik, másolja ki a címet és illessze be a böngésző címsorába

Ha segítségre van szüksége, forduljon a portál rendszergazdájához: {$a->admin}.';
$string['lockoutemailsubject'] = '{$a} szerveren futó fiókját felfüggesztettük.';
$string['lockouterrorunlock'] = 'A felfüggesztés feloldásához érvénytelen adatot adott meg.';
$string['lockoutthreshold'] = 'Fiók felfüggesztésének küszöbértéke';
$string['lockoutthreshold_desc'] = 'Válassza ki, hány érvénytelen bejelentkezési kísérlet után függesszük föl a fiók használatát. Ezzel segítheti a szervertámadások elleni védelmet.';
$string['lockoutwindow'] = 'Fiók felfüggesztését figyelő ablak';
$string['lockoutwindow_desc'] = 'Fiók felfüggesztésének figyelési ideje. Ezen idő eltelte után sikertelen próbálkozások elmaradása esetén a küszöbérték számlálója nullázódik.';
$string['log'] = 'Naplók';
$string['logguests'] = 'Vendég hozzáférésének naplózása';
$string['logguests_help'] = 'Ezzel bekapcsolja vendégek és be nem lépők tevékenységeinek naplózását. Nagy forgalmú portálokon a teljesítményre tekintettel kikapcsolható ez a naplózás. Éles portálokon azonban ajánlott bekapcsolva tartani.';
$string['loginhttps'] = 'HTTPS használata belépéshez';
$string['loginpageautofocus'] = 'Bejelentkezési űrlap automatikus fókusza';
$string['loginpageautofocus_help'] = 'Bekapcsolásával javul a bejelentkező oldal használhatósága, de a mezők automatikus fókusza elérhetőségi gondokat vethet fel.';
$string['loginpasswordautocomplete'] = 'Jelszó automatikus kitöltésének megakadályozása a bejelentkezési űrlapon';
$string['loginpasswordautocomplete_help'] = 'Kikapcsolása esetén a felhasználók jelszavukat elmenthetik böngészőjükben. Bekapcsolásakor a portálja felhagy az XHTML szigorú érvényesítési szabályainak betartásával.';
$string['loglifetime'] = 'Naplók megőrzése ehhez';
$string['longtimewarning'] = '<b>Ne feledje, hogy ez a folyamat eltarthat egy ideig.</b>';
$string['maintenancemode'] = 'Karbantartási üzemmódban';
$string['maintenancemodeisscheduled'] = 'A portál {$a} percen belül  karbantartási üzemmódba kapcsol.';
$string['maintfileopenerror'] = 'Hiba a karbantartási állományok megnyitása közben!';
$string['maintinprogress'] = 'A karbantartás folyamatban...';
$string['manageformats'] = 'Kurzusformátumok kezelése';
$string['manageformatsgotosettings'] = 'Az alapformátum {$a} esetén megváltozik.';
$string['managelang'] = 'Kezelés';
$string['managelicenses'] = 'Licencek kezelése';
$string['manageqbehaviours'] = 'Kérdések viselkedésének kezelése';
$string['manageqtypes'] = 'Kérdéstípusok kezelése';
$string['maturity100'] = 'Béta';
$string['maturity150'] = 'Jelölt közzététele';
$string['maturity200'] = 'Stabil verzió';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Ötlet: - Próbálja futtatni a programot az --allow-unstable opcióval.';
$string['maturitycoreinfo'] = 'Portálján jelenleg a fejlesztés alatt álló  "{$a}" program fut.';
$string['maturitycorewarning'] = 'Olyan "{$a}" jelzéssel megjelölt verzióra kívánja frissíteni a Moodle-t, amely még nem használható élesben. Ellenőrizze, hogy valóban ezt akarja-e, és ehhez a Moodle STABIL változatának a forráskódját jelölte-e be. További részleteket olvashat a Moodle Docs alatt.';
$string['maxbytes'] = 'Maximálisan feltölthető állományméret';
$string['maxconsecutiveidentchars'] = 'Egymást követő azonos karakterek';
$string['maxeditingtime'] = 'Maximális üzenetszerkesztési idő';
$string['maxusersperpage'] = 'Oldalankénti felhasználók maximális száma';
$string['mbstringrecommended'] = 'A portál teljesítményének javítása érdekében ajánlatos telepíteni az opcionális MBSTRING-könyvtárat, különösen, ha a portál támogatja nemlatin nyelvek használatát.';
$string['mediapluginavi'] = '.avi szűrő bekapcsolása';
$string['mediapluginflv'] = '.flv szűrő bekapcsolása';
$string['mediapluginimg'] = 'Kapcsolt képek automatikus beágyazásának engedélyezése';
$string['mediapluginmov'] = '.mov szűrő bekapcsolása';
$string['mediapluginmp3'] = '.mp3 szűrő bekapcsolása';
$string['mediapluginmpg'] = '.mpg szűrő bekapcsolása';
$string['mediapluginogg'] = 'Az .ogg szűrő bekapcsolása';
$string['mediapluginogv'] = 'Az .ogv szűrő bekapcsolása';
$string['mediapluginram'] = '.ram szűrő bekapcsolása';
$string['mediapluginrm'] = '.rm szűrő bekapcsolása';
$string['mediapluginrpm'] = '.rpm szűrő bekapcsolása';
$string['mediapluginswf'] = '.swf szűrő bekapcsolása';
$string['mediapluginswfnote'] = 'A biztonság érdekében szokásos felhasználók nem építhetnek be swf flash típusú állományokat.';
$string['mediapluginwmv'] = '.wmv szűrő bekapcsolása';
$string['mediapluginyoutube'] = 'A YouTube ugrópontszűrőjének bekapcsolása';
$string['messaging'] = 'Üzenetküldő rendszer bekapcsolása';
$string['messagingallowemailoverride'] = 'Értesítési e-mail felülírása';
$string['messagingdeletereadnotificationsdelay'] = 'Elolvasott értesítések törlése';
$string['messaginghidereadnotifications'] = 'Elolvasandókról szóló értesítések elrejtése';
$string['minpassworddigits'] = 'Számjegyek';
$string['minpasswordlength'] = 'Jelszó hossza';
$string['minpasswordlower'] = 'Kisbetűk';
$string['minpasswordnonalphanum'] = 'Nem alfanumerikus karakterek';
$string['minpasswordupper'] = 'Nagybetűk';
$string['misc'] = 'Egyéb';
$string['mnetrestore_extusers'] = '<strong>Megjegyzés</strong>: Ebben a biztonsági mentésben a Moodle Network olyan távoli felhasználói fiókjai szerepelnek, amelyeket a rendszer a folyamat részeként helyreállít.';
$string['mnetrestore_extusers_admin'] = '<strong>Megjegyzés:</strong> Ez a biztonsági mentés feltehetőleg egy másik Moodle-telepítésből való, a Moodle-hálózat távoli felhasználói fiókjait tartalmazza. A helyreállítási folyamat minden létrehozott fiókot a Moodle-hálózat gazdagépeihez illeszt. A nem egyező fiókok esetén automatikusan belső hitelesítésre kapcsol át (mnet helyett). Erről a helyreállítási napló tájékoztatja.';
$string['mnetrestore_extusers_mismatch'] = 'Megjegyzés: Ez a biztonsági mentés nyilvánvalóan egy másik Moodle-telepítésből való, és benne a Moodle Network olyan távoli felhasználói fiókjai szerepelnek, amelyek helyreállítása esetleg sikertelen lesz. Ezt a műveletet a rendszer nem támogatja. Ha biztos benne, hogy a Moodle ezen telepítésével hozta létre, illetve ha gondoskodni tud arról, hogy a Moodle Network összes gazdagépe konfigurálva legyen, úgy megpróbálkozhat a helyreállítással.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Megjegyzés:</strong> Ez a biztonsági mentés feltehetőleg egy másik Moodle-telepítésből való, a Moodle-hálózat távoli felhasználói fiókjait tartalmazza. Ilyen típusú helyreállítást nem hajthat végre. Forduljon a portál rendszergazdájához vagy felhasználói információk (modulok, állományok...) nélkül hajtsa végre a helyreállítást.';
$string['mnetrestore_extusers_switchuserauth'] = 'A Moodle-hálózat {$a->username} távoli felhasználója ({$a->mnethosturl} helyről) helyi {$a->auth} hitelesítésű felhasználóra váltott.';
$string['mobile'] = 'Mobil';
$string['mobilecssurl'] = 'CSS';
$string['modchooserdefault'] = 'Tevékenységválasztó alapbeállítása';
$string['modeditdefaults'] = 'Alapértékek tevékenységek beállításához';
$string['modeditingmenu'] = 'Tevékenységszerkesztő menük';
$string['modeditingmenu_desc'] = 'Bekapcsolása esetén a szerkesztés közben megjelenített tevékenységszerkesztő ikon közül több egy lenyíló menüben jelenik meg. Ezzel kevesebb lesz a tartalom a képernyőn, mert az ikonok csak szükség esetén fognak látszani.';
$string['modsettings'] = 'Tevékenységek kezelése';
$string['modulesecurity'] = 'Modulbiztonság';
$string['moodleorghubname'] = 'Moodle.net';
$string['multilangforceold'] = 'Régi többnyelvű szintaxis előírása a class="multilang" és a &lt;lang&gt; nélkül';
$string['mustenablestats'] = 'A portálon nincs bekapcsolva a statisztika.';
$string['mycoursesperpage'] = 'Kurzusok száma';
$string['mydashboard'] = 'A rendszer alapértelmezett irányítópultja';
$string['mymoodle'] = 'Moodle-oldalam';
$string['mymoodleredirect'] = 'Az én Moodle-om használatának előírása';
$string['mypage'] = 'Elsődleges Moodle-oldalam';
$string['mypagelocked'] = 'Elsődleges oldal zárolása';
$string['myprofile'] = 'Elsődleges profiloldal';
$string['mysql416bypassed'] = 'Ha viszont a portálja CSAK iso-8859-1 (latin) nyelveket használ, továbbra is használhatja a pillanatnyilag telepített MySQL 4.1.12 (vagy magasabb) verziót.';
$string['mysql416required'] = 'A Moodle 1.6 esetén a MySQL minimális verziószáma a 4.1.16 azért, hogy a későbbiekben minden adatot UTF-8 formában lehessen tárolni.';
$string['navadduserpostslinks'] = 'Felhasználói hozzászólások megtekintéséhez ugrópontok hozzáadása';
$string['navadduserpostslinks_help'] = 'Bekapcsolása esetén a navigáláshoz minden felhasználóhoz két ugrópont adódik hozzá az adott felhasználó által kezdeményezett viták és az egész portálon vagy egyes kurzusokon belül a fórumokra részéről beérkező hozzászólások megtekintéséhez.';
$string['navcourselimit'] = 'Kurzuskorlát';
$string['navigationupgrade'] = 'Ez a verziófrissítés két új navigációs blokkot tartalmaz, melyek ezen blokkokat váltják fel: Adminisztráció, Kurzusok, Tevékenységek és Felhasználók. Ha ezekhez a blokkokhoz külön engedélyeket rendelt, ellenőrizze, hogy minden a kívánt módon működik-e.';
$string['navshowallcourses'] = 'Az összes kurzus megjelenítése';
$string['navshowcategories'] = 'Kurzuskategóriák megjelenítése';
$string['navshowfrontpagemods'] = 'A navigálás során látsszanak a címoldali tevékenységek';
$string['navshowfrontpagemods_help'] = 'Bekapcsolása esetén a navigálás során a portáloldalak alatt látszanak a címoldali tevékenységek.';
$string['navshowfullcoursenames'] = 'Teljes kurzuscímek megjelenítése';
$string['navshowfullcoursenames_help'] = 'Bekapcsolása esetén a navigáció során a rövid helyett a teljes kurzuscímek jelennek meg';
$string['navshowmycoursecategories'] = 'Kurzuskategóriáim megjelenítése';
$string['navshowmycoursecategories_help'] = 'Bekapcsolása esetén kurzuságam felhasználói látják a kategóriákat.';
$string['navsortmycoursessort'] = 'Kurzusaim rendezése';
$string['navsortmycoursessort_help'] = 'Meghatározza, hogy a Kurzusaim ágon megjelenő kurzusok böngészéskor a megadott sorrendben vagy betűrendben jelennek-e meg.';
$string['neverdeleteruns'] = 'Profilkészítések soha ne törlődjenek';
$string['nobookmarksforuser'] = 'Nincsenek könyvjelzői.';
$string['nodatabase'] = 'Nincs adatbázis';
$string['nohttpsformobilewarning'] = 'Ajánlatos érvényes tanúsítvánnyal rendelkező HTTPS-t bekapcsolni. A Moodle először mindig biztonságos csatlakozást próbál használni.';
$string['nomissingstrings'] = 'Nincs hiányzó szöveg';
$string['nonewsettings'] = 'A frissítés során nem került sor új beállítások hozzáadására.';
$string['nonexistentbookmark'] = 'A kért könyvjelző nem létezik.';
$string['noresults'] = 'Nincs eredmény.';
$string['noroles'] = 'Nincs szerep.';
$string['notifications'] = 'Értesítések';
$string['notifyloginfailures'] = 'Sikertelen e-mailben történt belépésekről értesítendő';
$string['notifyloginthreshold'] = 'E-mailben történt értesítések küszöbértéke';
$string['notloggedinroleid'] = 'Látogatói szerep';
$string['numberofmissingstrings'] = 'Hiányzó szövegek száma: {$a}';
$string['numberofstrings'] = 'Összes szövegszám: {$a->strings}<br></br>Hiányzó: {$a->missing} ({$a->missingpercent} %)';
$string['opcacherecommended'] = 'A PHP műveleti kód gyorsítótárazása javítja a teljesítményt és csökkenti a memóriaszükségletet. Az OPcache kibővítés használata ajánlott és teljes mértékben támogatott.';
$string['opensslrecommended'] = 'Határozottan ajánlott az OpenSSL-könyvtár telepítése - ezzel kapcsolható be a hálózati Moodle.';
$string['opentogoogle'] = 'A Google engedélyezése';
$string['optionalmaintenancemessage'] = 'Opcionális karbantartási üzenet';
$string['order1'] = 'Első';
$string['order2'] = 'Második';
$string['order3'] = 'Harmadik';
$string['order4'] = 'Negyedik';
$string['passwordpolicy'] = 'Jelszószabvány';
$string['passwordresettime'] = 'Jelszó-visszaállítási kérelem érvényesítésére rendelkezésre álló maximális idő';
$string['pathconvert'] = 'A <i>convert</i> bináris állomány útvonala';
$string['pathdvips'] = 'A <i>dvips</i> bináris állomány útvonala';
$string['pathlatex'] = 'A <i>latex</i> bináris állomány útvonala';
$string['pathtoclam'] = 'A clam vírusirtó útvonala';
$string['pathtodot'] = 'Útvonal a dothoz';
$string['pathtodot_help'] = 'Útvonal a dothoz. Például /usr/bin/dot. Ahhoz, hogy DOT-állományokból grafikát tudjon előállítani, rendelkeznie kell telepített dot-programmal és itt hivatkoznia kell rá. Jelenleg ez csak a Moodle-ba beépített profilfunkciókkal (Fejlesztés->Profilkészítés) használatos.';
$string['pathtodu'] = 'A du útvonala';
$string['pathtopgdump'] = 'A pg_dump útvonala';
$string['pathtopgdumpdesc'] = 'Ezt csak akkor kell megadni, ha egynél több pg_dump van a rendszerben (ha pl. a postgresql egynél több verziója van telepítve)';
$string['pathtopgdumpinvalid'] = 'Érvénytelen pg_dump-útvonal - vagy az útvonal hibás, vagy a kód nem futtatható';
$string['pathtopsql'] = 'A psql útvonala';
$string['pathtopsqldesc'] = 'Ezt csak akkor kell megadni, ha egynél több psql van a rendszerben (ha pl. a postgresql egynél több verziója van telepítve)';
$string['pathtopsqlinvalid'] = 'Érvénytelen psql-útvonal - vagy az útvonal hibás, vagy a kód nem futtatható';
$string['pcreunicodewarning'] = 'Ajánlatos az unikódos karaterekkel kompatibilis PCRE PHP kiegészítés használata.';
$string['perfdebug'] = 'Teljesítményről szóló tájékoztató';
$string['performance'] = 'Teljesítmény';
$string['pgcluster'] = 'PostgreSQL-fürt';
$string['pgclusterdescription'] = 'A PostgreSQL-verzió/-fürt paramétere parancssori műveletekhez. Ha csak egy postgresql van a rendszerén telepítve, illetve ha nem biztos abban, melyik van telepítve, akkor hagyja ezt a mezőt üresen.';
$string['php50restricted'] = 'A PHP 5.0.x számos ismert problémával rendelkezik, frissítsen 5.1.x-re vagy térjen vissza a 4.3.x vagy a 4.4.x változathoz';
$string['php533warning'] = 'Ajánlott a PHP 5.3.3 vagy későbbi verzió használata';
$string['phpfloatproblem'] = 'A PHP lebegőpontos számainak - {$a} - kezelésében váratlan hiba történt.';
$string['pleaserefreshregistration'] = 'Portáljának a moodle.org-on való regisztrálása megtörtént, ha számottevő változások történtek utolsó frissítés óta, kérjük, végezzen frissítést a(z) {$a} portálon';
$string['pleaseregister'] = 'A gomb eltávolításához regisztrálja portálját!';
$string['plugin'] = 'Segédprogram';
$string['plugins'] = 'Segédprogramok';
$string['pluginscheck'] = 'Segédprogramok kapcsolódásainak ellenőrzése';
$string['pluginscheckfailed'] = 'Kapcsolódások ellenőrzése {$a->pluginslist} esetén sikertelen.';
$string['pluginschecktodo'] = 'A segédprogramokkal kapcsolatos összes követelményt teljesítenie kell, mielőtt továbblép a Moodle ezen verziójának a telepítésével.';
$string['pluginsoverview'] = 'Segédprogramok áttekintése';
$string['pluginsoverviewsee'] = 'A részleteket lásd a <a href="{$a->url}">segédprogramok áttekintése</a> oldalon.';
$string['profilecategory'] = 'Kategória';
$string['profilecategoryname'] = 'Kategórianév (egyedinek kell lennie)';
$string['profilecategorynamenotunique'] = 'Ezt a kategórianevet már használják';
$string['profilecommonsettings'] = 'Általános beállítások';
$string['profileconfirmcategorydeletion'] = 'Ebben a kategóriában olyan mező(k) van(nak), amely(ek) a felette lévő kategóriába kerül(nek) át (vagy - legfelső kategória esetén - az alá).<br />Biztosan törli a kategóriát?';
$string['profileconfirmfielddeletion'] = 'Ebben a mezőben felhasználói rekord(ok) van(nak), amely(ek)et a rendszer törölni fog.<br />Biztosan törli a mezőt?';
$string['profilecreatecategory'] = 'Új profilkategória létrehozása';
$string['profilecreatefield'] = 'Új profilmező létrehozása:';
$string['profilecreatenewcategory'] = 'Új kategória létrehozása';
$string['profilecreatenewfield'] = 'Új \'{$a}\' profilmező létrehozása';
$string['profiledefaultcategory'] = 'Egyéb mezők';
$string['profiledefaultchecked'] = 'Alaphelyzetben ellenőrizve';
$string['profiledefaultdata'] = 'Alapérték';
$string['profiledeletecategory'] = 'Kategória törlése';
$string['profiledeletefield'] = '\'{$a}\' mező törlése';
$string['profiledescription'] = 'A mező leírása';
$string['profiledscript'] = 'A kód bekerült a profilba.';
$string['profiledscriptview'] = 'A kód profiladatainak megtekintése';
$string['profileeditcategory'] = 'Kategória szerkesztése: {$a}';
$string['profileeditfield'] = 'Profilmező szerkesztése: {$a}';
$string['profilefield'] = 'Profilmező';
$string['profilefieldcolumns'] = 'Oszlopok';
$string['profilefieldispassword'] = 'Ez jelszómező?';
$string['profilefieldlink'] = 'Ugrópont';
$string['profilefieldlink_help'] = 'A szöveg ugróponttá alakításához adjon meg egy $$-t tartalmazó URL-t, ahol a $$ helyére kerül a szöveg. Például egy Twitter azonosító ugróponttá alakításához írja be a http://twitter.com/$$-t.';
$string['profilefieldlinktarget'] = 'Ugrópont célja';
$string['profilefieldmaxlength'] = 'Maximális hossz';
$string['profilefieldrows'] = 'Sorok';
$string['profilefields'] = 'Felhasználói profilmezők';
$string['profilefieldsize'] = 'Megjelenítési méret';
$string['profileforceunique'] = 'Az adatok egyediek legyenek?';
$string['profileinvaliddata'] = 'Érvénytelen érték';
$string['profilelocked'] = 'A mező zárolva van?';
$string['profilemenudefaultnotinoptions'] = 'Az alapérték nem szerepel a lehetőségek között';
$string['profilemenunooptions'] = 'Nincsenek megadva menüpontok';
$string['profilemenuoptions'] = 'Menüpontok (soronként egy)';
$string['profilemenutoofewoptions'] = 'Legalább két menüpontot meg kell adnia';
$string['profilename'] = 'Név';
$string['profilenofieldsdefined'] = 'Nincsenek megadva mezők';
$string['profilerequired'] = 'Szükség van erre a mezőre?';
$string['profileroles'] = 'Látható szerepek profilja';
$string['profilesforenrolledusersonly'] = 'Profil csak beiratkozott felhasználó esetén';
$string['profileshortname'] = 'Rövid név (egyedinek kell lennie)';
$string['profileshortnamenotunique'] = 'Ezt a rövid nevet már használják';
$string['profilesignup'] = 'Látsszon a belépési oldalon?';
$string['profilespecificsettings'] = 'Konkrét beállítások';
$string['profilevisible'] = 'Ki látja ezt a mezőt?';
$string['profilevisibleall'] = 'Mindenki látja';
$string['profilevisible_help'] = '<p>Az egyedi mezőkhöz háromféle láthatóság állítható be: láthatatlan, bárki és felhasználó. A láthatatlan általában a rendszergazda állítja be, ha a felhasználók magánadatait rejtve kívánja megőrizni. A \'felhasználó\' beállítás általában olyan mezőre vonatkozik, amely érzékeny adatot tartalmaz, míg a \'bárki\' tetszőleges információkat tartalmazhat.</p>';
$string['profilevisiblenone'] = 'Nem látható';
$string['profilevisibleprivate'] = 'A felhasználó látja';
$string['profiling'] = 'Profilkészítés';
$string['profilingallowall'] = 'Folyamatos profilkészítés';
$string['profilingallowall_help'] = 'Bekapcsolása esetén bármikor bárhol (PGC) használhatja a PROFILEALL paramétert az összes végrehajtott kód profilkészítéséhez a Moodle-folyamat teljes tartama alatt. Leállítására használja a PROFILEALLSTOP paramétert. ';
$string['profilingallowme'] = 'Választható profilkészítés';
$string['profilingallowme_help'] = 'Bekapcsolása esetén bárhol (PGC) használhatja a PROFILEME paramétert, és sor kerül az adott kód profilkészítésére. A profilkészítés megelőzésére használja a DONTPROFILEME paramétert. ';
$string['profilingautofrec'] = 'Automatikus profilkészítés';
$string['profilingautofrec_help'] = 'Beállítása esetén (véletlenszerűen, a megadott 1/XXX frekvencia alapján) kiválaszt valamely kérelmet és automatikusan elkészíti profilját, az eredményeket további elemzéshez eltárolja. Az ilyen profilkészítés tekintetbe veszi a beiktat/kihagy beállításokat. 0-ra állítva kikapcsolja az automatikus profilkészítést.';
$string['profilingenabled'] = 'Profilkészítés bekapcsolása';
$string['profilingenabled_help'] = 'Bekapcsolása esetén a portálon elérhető lesz a profilkészítés, melynek  viselkedését a következők szerint állíthatja be. ';
$string['profilingexcluded'] = 'Profilkészítés kihagyása';
$string['profilingexcluded_help'] = 'Azon (vesszővel elválasztott, a wwwroot útvonalat teljesen kihagyó, elérhető) URL-ek listája, amelyeket kihagy azon profilkészítésből, amely a \'Profilkészítés ezekről\' beállításban van megadva.';
$string['profilingimportprefix'] = 'Importálási előtag beállítása';
$string['profilingimportprefix_desc'] = 'Az egyszerűbb kereséshez minden importált profilfuttatás az itt megadott előtaggal egészül ki.';
$string['profilingincluded'] = 'Profilkészítés ezekről';
$string['profilingincluded_help'] = 'Azon (vesszővel elválasztott, a wwwroot útvonalat teljesen kihagyó, elérhető) URL-ek listája, amelyekről automatikusan profil készül. Pl.:  /index.php, /course/view.php. Bárhol elfogadja a * karakterhelyettesítőt is, pl: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Profilkészítések megőrződjenek';
$string['profilinglifetime_help'] = 'Adja meg, mennyi ideig kívánja megőrizni a régi profilkészítéseket. A régiek időről időre törlődnek. A folyamatból kimaradnak a \'referenciaprofilok\' névvel megjelöltek.';
$string['protectusernames'] = 'Felhasználónevek védelme';
$string['proxybypass'] = 'Proxyt elkerülő gazdagépek';
$string['proxyhost'] = 'Proxy-gazdagép';
$string['proxypassword'] = 'Proxy-jelszó';
$string['proxyport'] = 'Proxy-port';
$string['proxytype'] = 'Proxy típusa';
$string['proxyuser'] = 'Proxy-felhasználó';
$string['purgecaches'] = 'Az összes gyorsítótár kiürítése';
$string['purgecachesconfirm'] = 'A Moodle gyorsítótárban tud kezelni stílusokat, javascriptet, nyelvi szövegeket, szűrt szövegeket, rss-híreket és egy sor egyéb, számított adatot. A gyorsítótárak kiürítése során ezek az adatok törlődnek a szerverről, a böngészőknek pedig újból be kell olvasni ezeket az adatokat, hogy mindenkor a legfrissebbek legyenek láthatók. A gyorsítótárak kiürítése nem veszélyes, de a portál működése lassabbnak tűnhet, amíg a szerver és az ügyfélprogramok kiszámítják és gyorsítótárba helyezik az új adatokat. ';
$string['purgecachesfinished'] = 'Az összes gyorsítótár kiürítése megtörtént.';
$string['qtyperqpwillberemoved'] = 'Frissítés közben az RQP-kérdéstípus törlődik. Ön nem használta ezt a kérdéstípust, ezért nem lesz gondja ezzel kapcsolatban.';
$string['qtyperqpwillberemovedanyway'] = 'Frissítés során törlődik az RQP kérdéstípus. Mivel adatbázisában szerepelnek RQP-kérdések, ezek használhatatlanok lesznek, ha nem telepíti újra a kódot a http://moodle.org/mod/data/view.php?d=13&amp;rid=797 weboldalról, mielőtt folytatja a frissítést.';
$string['quarantinedir'] = 'Karanténkönyvtár';
$string['question'] = 'Kérdés';
$string['questionbehaviours'] = 'Kérdések viselkedése';
$string['questioncwqpfscheck'] = 'Valamely tesztben egy vagy több \'véletlenszerűen kiválasztott\' kérdés úgy van beállítva, hogy megosztott és megosztatlan kérdéskategóriák egyvelegéből válasszon kérdéseket. Részletesebb beszámolót olvashat erről <a href="{$a->reporturl}">itt</a> és a Moodle Docs oldalon <a href="{$a->docsurl}">itt</a>.';
$string['questioncwqpfsok'] = 'Rendben. Tesztjei között nem szerepelnek  \'véletlenszerűen kiválasztott\', megosztott és megosztatlan kérdéskategóriák egyvelegéből választandó kérdések.';
$string['questiontype'] = 'Kérdéstípus';
$string['questiontypes'] = 'Kérdéstípusok';
$string['quizattemptsupgradedmessage'] = 'A Moodle 2.1 átszabta a kérdéseket. Az adatbázis-frissítést későbbre lehetett halasztani, de a 2.7-re frissítés előtt végre kellett hajtani.';
$string['recaptchaprivatekey'] = 'A ReCAPTCHA magánkulcsa';
$string['recaptchapublickey'] = 'A ReCAPTCHA nyilvános kulcsa';
$string['register'] = 'Regisztrálja portálját.';
$string['registermoodleorg'] = 'Amikor portálját regisztrálja itt: {$a}';
$string['registermoodleorgli1'] = 'Alacsony forgalmú levelezőlistára került föl, ahol fontos információkról értesítjük, pl. biztonsági figyelmeztetésekről vagy a Moodle új verzióról.';
$string['registermoodleorgli2'] = 'Portáljának statisztikáját hozzáadjuk a Moodle-közösség {$a} nyilvántartásához.';
$string['registermoodleorgli3'] = 'Portálját a Moodle.neten ({$a}) is nyilvánrtartjuk, így a kurzusok közzétételére jogosult felhasználók (alapesetben a vezetők) kurzusokat adhatnak hozzá a Moodle.nethez.';
$string['registerwithmoodleorg'] = 'Regisztrálás a Moodle.org doménen.';
$string['registration'] = 'Regisztráció';
$string['registration_help'] = 'Biztonsági értesítésekhez, a Moodle <a href="http://moodle.org/stats">statisztikájának</a> kiegészítéséhez és a <a href="http://hub.moodle.net/">Moodle.net</a> webhelyen kurzusok megosztásához regisztrálja portálját a Moodle.org doménen.';
$string['registrationwarning'] = 'Még nem regisztrálta portálját.';
$string['releasenoteslink'] = 'A Moodle ezen verziójának adataival kapcsolatosan olvassa el az online <a target="_blank" href="{$a}">Változatra vonatkozó megjegyzések</a>et';
$string['rememberusername'] = 'Felhasználónév megjegyzése';
$string['rememberusername_desc'] = 'Kapcsolja be, ha a felhasználók bejelentkezésekor állandó sütikben kívánja megőrizni a felhasználónevüket. Hozzájárulásuk nélküli használata magánjogot sérthet.';
$string['reportsmanage'] = 'Jelentések kezelése';
$string['requestcategoryselection'] = 'Kategória kiválasztásának engedélyezése';
$string['requiredentrieschanged'] = '<strong>FONTOS - OLVASSA EL!<br/>(Ez a figyelmeztetés csak ezen verziófrissítés alkalmával jelenik meg)</strong><br/>Hibajavítás miatt a \'Kitöltendő bejegyzések\' és a \'Megtekintés beállítása előtti kitöltendő bejegyzések\' beállításokat használó adatbázis-tevékenységek viselkedése módosulni fog. Részletesebben lásd az <a href="http://moodle.org/mod/forum/discuss.php?d=110928" target="_blank">adatbázismodul fórumát</a>. Az elvárt viselkedésről olvashat itt is: <a href="http://docs.moodle.org/en/Adding/editing_a_database#Required_entries" target="_blank">Moodle Docs</a>. <br/><br/>A változás az Ön rendszerében az alábbi adatbázisokat fogja érinteni: (a listát most is és verziófrissítés után is mentse el, és ellenőrizze, hogy a tevékenységek továbbra is a tanár szándékainak megfelelően működnek-e.)<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Tevékenység leírásának előírása';
$string['requires'] = 'Előfeltétel';
$string['restorernewroleid'] = 'Helyreállítók kurzusbeli szerepe';
$string['restorernewroleid_help'] = 'Ha a felhasználó még nem rendelkezik engedéllyel az újonnan helyreállított kurzusok kezeléséhez, akkor automatikusan megkapja ezt a szerepet és szükség esetén beíratására is sor kerül. Válassza az "Egy sem" pontot, ha a helyreállítók részére nem kívánja engedélyezni minden újonnan helyreállított kurzusok kezelését.';
$string['reverseproxy'] = 'Fordított proxy';
$string['riskconfig'] = 'A felhasználók módosíthatják a portál beállításait és működését';
$string['riskconfigshort'] = 'Konfigurációs veszély';
$string['riskdataloss'] = 'A felhasználók terjedelmes tartalmat és információkat tehetnek tönkre.';
$string['riskdatalossshort'] = 'Adatvesztés kockázata';
$string['riskmanagetrust'] = 'A felhasználók módosíthatják más felhasználók megbízhatósági beállításait';
$string['riskmanagetrustshort'] = 'Megbízhatóság kezelése';
$string['riskpersonal'] = 'A felhasználók hozzáférhetnek más felhasználók magánadataihoz';
$string['riskpersonalshort'] = 'Személyes adatok veszélyben';
$string['riskspam'] = 'A felhasználók levélszemetet küldhetnek a portál felhasználóinak és másoknak';
$string['riskspamshort'] = 'Levélszemétveszély';
$string['riskxss'] = 'A felhasználók hozzáadhatnak portálok közötti kódolást (XSS) engedélyező állományokat és szövegeket';
$string['riskxssshort'] = 'XSS-veszély';
$string['roleswithexceptions'] = '{$a->roles}, {$a->exceptions} kivétellel';
$string['rssglobaldisabled'] = 'Szerverszinten kikapcsolva';
$string['runclamavonupload'] = 'A clam vírusirtó használata feltöltött állományokhoz';
$string['save'] = 'Mentés';
$string['savechanges'] = 'Változások mentése';
$string['search'] = 'Keresés';
$string['searchinsettings'] = 'Keresés a beállítások között';
$string['searchresults'] = 'Keresési eredmények';
$string['sectionerror'] = 'Szekcióhiba!';
$string['secureforms'] = 'Kiegészítő űrlapbiztonság használata';
$string['security'] = 'Biztonság';
$string['selectdevice'] = 'Eszköz kiválasztása';
$string['selecttheme'] = 'Stíluas kiválasztása {$a} eszközhöz';
$string['server'] = 'Szerver';
$string['serverchecks'] = 'Szerverellenőrzések';
$string['serverlimit'] = 'Szerverkorlát';
$string['sessionautostartwarning'] = '<p>Súlyos beállítási hiba lépett föl, tájékoztassa a rendszergazdát.</p><p>A Moodle megfelelő működéséhez a rendszergazdának módosítania kell a PHP beállításait.</p><p>A <code>session.auto_start</code> <code>off</code>-ra állítandó.</p><p>Ezt a szerveren a <code>php.ini</code> fájlnak, az Apache/IIS <br />konfigurációjának vagy a <code>.htaccess</code> fájlnak a szerkesztésével érheti el.</p>';
$string['sessioncookie'] = 'Süti előtagja';
$string['sessioncookiedomain'] = 'Süti doménje';
$string['sessioncookiepath'] = 'Süti útvonala';
$string['sessionhandling'] = 'Folyamat kezelése';
$string['sessiontimeout'] = 'Időtúllépés';
$string['settingfileuploads'] = 'A szokásos működéshez állományfeltöltésre van szükség, engedélyezze a PHP beállításában.';
$string['settingmemorylimit'] = 'Kevés a memória, állítsa be magasabbra a PHP beállításában.';
$string['settingsafemode'] = 'A Moodle nem teljesen kompatibilis a csökkentett üzemmóddal, kérje meg a rendszergazdát, hogy kapcsolja ki. Ha csökkentett üzemmódban futtatja a Moodle-t, különféle problémákra kell felkészülnie.';
$string['showcommentscount'] = 'Megjegyzések számának kijelzése';
$string['showdetails'] = 'Részletek megtekintése';
$string['showuseridentity'] = 'Felhasználó kilétének megjelenítése';
$string['showuseridentity_desc'] = 'Felhasználók kiválasztása, keresése és megjelenítése során ezek a mezők nevük mellett megjeleníthetők. Csak azok számára láthatók, akik rendelkeznek moodle/site:viewuseridentity jogosultsággal. Ezek alapesetben a tanárok és a vezetők. (Leginkább akkor van értelme, ha az intézményben előírt egy-két mezőt választja ki.)';
$string['simplexmlrequired'] = 'A Moodle most már előírja a SimpleXML PHP-bővítményt .';
$string['sitemaintenance'] = 'A portálon karbantartás folyik, jelenleg nem elérhető';
$string['sitemaintenancemode'] = 'Karbantartási üzemmód';
$string['sitemaintenanceoff'] = 'A karbantartási üzemmód kikapcsolva, a portál ismét a szokásos módon üzemel';
$string['sitemaintenanceon'] = 'Portálja jelenleg karbantartási üzemmódban van (a portálra csak rendszergazdák jelentkezhetnek be).';
$string['sitemaintenanceoncli'] = 'Portálján a CLI karbantartási üzemmódban van, internetes hozzáférés nem engedélyezett.';
$string['sitemaintenancewarning'] = 'Portálja jelenleg karbantartási üzemmódban van (csak rendszergazdák jelentkezhetnek be). Szokásos üzemmódba való visszatéréshez <a href="maintenance.php">kapcsolja ki a karbantartási üzemmódot</a>.';
$string['sitemaintenancewarning2'] = 'Portálja most karbantartási módban üzemel (csak rendszergazdák jelentkezhetnek be). A normál üzemmód visszaállításához  <a href="{$a}">kapcsolja ki a karbantartási módot</a>.';
$string['sitepolicies'] = 'Portálszabványok';
$string['sitepolicy'] = 'Portálszabvány URL-je';
$string['sitepolicyguest'] = 'Portálszabvány URL-je vendégek számára';
$string['sitepolicyguest_help'] = 'Ha létezik olyan portálszabványa, amelyet a vendégeknek belépés előtt el kell olvasni és el kell fogadni, akkor annak URL-jét adja meg itt. Ellenkező esetben hagyja a mezőt üresen. A beállítás tartalmazhat bármilyen nyilvános URL-t. Megjegyzés: ha be nem lépett felhasználók hozzáférését kívánja korlátozni, ezt a belépés előírásával teheti meg.';
$string['sitepolicy_help'] = 'Ha olyan portálszabványa van, amely szerint azt belépés előtt minden regisztrált felhasználónak el kell olvasni és el kell fogadni, akkor annak URL-jét adja meg itt. Ellenkező esetben hagyja a mezőt üresen. A beállítás tartalmazhat bármilyen nyilvános URL-t. ';
$string['sitesectionhelp'] = 'Kiválasztása esetén a stílusszekció megjelenik a portál kezdőoldalán.';
$string['slasharguments'] = 'Perjeles argumentumok használata';
$string['smartpix'] = 'Smart pix szerinti keresés';
$string['soaprecommended'] = 'A soap-kiegészítés telepítése webszolgáltatások és egyes külső fejlesztésű modulok esetén hasznos lehet.';
$string['sort_fullname'] = 'Teljes kurzusnév';
$string['sort_idnumber'] = 'Kurzusazonosító szám';
$string['sort_shortname'] = 'Rövid kurzusnév';
$string['sort_sortorder'] = 'Rendezés';
$string['spellengine'] = 'Helyesírásmotor';
$string['spelllanguagelist'] = 'Helyesírás-ellenőrző nyelvek';
$string['splrequired'] = 'A Moodle előírja az SPL PHP-bővítményt.';
$string['stats'] = 'Statisztika';
$string['statsfirstrun'] = 'Maximális feldolgozási intervallum';
$string['statsmaxruntime'] = 'Maximális futásidő';
$string['statsmoodleorg'] = 'statisztika';
$string['statsruntimedays'] = 'Földolgozandó napok';
$string['statsruntimestart'] = 'Végrehajtás időpontja';
$string['statsuserthreshold'] = 'Felhasználói küszöbérték';
$string['stickyblocks'] = 'Megmaradó blokkok';
$string['stickyblockscourseview'] = 'Kurzusoldal';
$string['stickyblocksduplicatenotice'] = 'Ha ide beszúr egy blokkot, amely már létezik egy másik oldalon, akkor másodpéldány jön létre.<br />Csak a rögzített blokkot nem tudja szerkeszteni, a másodpéldányt viszont igen.';
$string['stickyblocksmymoodle'] = 'Az én Moodle-om';
$string['stickyblockspagetype'] = 'Beállítandó oldaltípus';
$string['strictformsrequired'] = 'A kitöltendő mezők szigorú ellenőrzése';
$string['stripalltitletags'] = 'Minden tevékenységnévből törölje a HTML-címkéket.';
$string['supportcontact'] = 'Támogatói kapcsolat';
$string['supportemail'] = 'Támogatói e-mail';
$string['supportname'] = 'Támogató neve';
$string['supportpage'] = 'Támogató oldala';
$string['suspenduser'] = 'Felhasználói fiók felfüggesztése';
$string['switchlang'] = 'Nyelvi könyvtárak közötti váltás';
$string['systempaths'] = 'Rendszerútvonalak';
$string['tablenosave'] = 'A fenti táblázat módosításainak mentése automatikus';
$string['tablesnosave'] = 'A fenti táblázatok módosításainak mentése automatikus';
$string['tabselectedtofront'] = 'Tabulátoros táblázatokban a kiválasztott elemet tartalmazó sor elölre kerüljön.';
$string['tabselectedtofronttext'] = 'Fülek kiválasztott sorának előtérbe hozása';
$string['testsiteupgradewarning'] = 'Jelenleg a tesztelő {$a} portált használja. Megfelelő frissítéséhez használja a parancssori felületet.';
$string['themedesignermode'] = 'Stílustervező üzemmód';
$string['themelist'] = 'Stílusjegyzék';
$string['themenoselected'] = 'NIncs kiválasztva stílus';
$string['themeresetcaches'] = 'Stílust tartalmazó gyorsítótárak törlése';
$string['themeselect'] = 'Stílus módosítása';
$string['themeselector'] = 'Stílusválasztó';
$string['themesettings'] = 'Stílusbeállítások';
$string['therewereerrors'] = 'Adataiban hiba volt';
$string['thirdpartylibrary'] = 'Konyvtár';
$string['thirdpartylibrarylocation'] = 'Hely';
$string['thirdpartylibs'] = 'Külsős könyvtárak';
$string['timezone'] = 'Alapidőzóna';
$string['timezoneforced'] = 'Ezt a portál rendszergazdája írja elő';
$string['timezoneisforcedto'] = 'Használatának előírása minden felhasználó számára';
$string['timezonenotforced'] = 'A felhasználók kiválaszthatják saját időzónájukat';
$string['tokenizerrecommended'] = 'Ajánlott a PHP Tokenizer bővítmény telepítése - javítja a hálózati Moodle használhatóságát.';
$string['tools'] = 'Rendszergazda eszközei';
$string['toolsmanage'] = 'Rendszergazda eszközeinek kezelése';
$string['unattendedoperation'] = 'Felügyelet nélküli működtetés';
$string['unbookmarkthispage'] = 'Oldal könyvjelzőjének eltávolítása';
$string['unicoderecommended'] = 'Ajánlott minden adatot unikódban (UTF-8) tárolni. Az új telepítéseket unikód alapkészletű adatbázisokba kell telepíteni. Ha újabb változatra vált, végre kell hajtania az UTF-8-ra való áttérést (lásd a Portáladminisztráció oldalát).';
$string['unicoderequired'] = 'Minden adatot unikódban (UTF-8) kell tárolni. Az új telepítéseket unikód alapkészletű adatbázisokba kell telepíteni. Ha újabb változatra vált, végre kell hajtania az UTF-8-ra való áttérést (lásd a Portáladminisztráció oldalát).';
$string['uninstallplugin'] = 'Eltávolítás';
$string['unlockaccount'] = 'Fiók felfüggesztésének feloldása';
$string['unsettheme'] = 'Stílus kijelölésének megszüntetése';
$string['unsupported'] = 'Nem támogatott';
$string['unsuspenduser'] = 'Felhasználói fiók bekapcsolása';
$string['updateaccounts'] = 'Meglévő fiókok frissítése';
$string['updateautocheck'] = 'Elérhető frissítések automatikus ellenőrzése';
$string['updateautocheck_desc'] = 'Bekapcsolása esetén portálja automatikusan ellenőrzi, vannak-e elérhető frissítések a Moodle-hoz és a segédprogramokhoz. Ha vannak, a portál rendszergazdája erről értesítést kap.';
$string['updateautodeploy'] = 'Firssítések alkalmazásának bekapcsolása';
$string['updateautodeploy_desc'] = 'Bekapcsolása esetén az elérhető frissítéseket közvetlenül a Moodle adminsiztrációs oldalairól töltheti le és telepítheti. A webszervernek ehhez mappába írási jogosultsággal kell rendelkezni. Ez potenciálisan biztonsági kockázatot jelenthet.';
$string['updateavailable'] = 'Újabb Moodle-verzió érhető el!';
$string['updateavailabledetailslink'] = 'A részleteket lásd itt: {$a->url}.';
$string['updateavailableforplugin'] = 'Újabb segédprogram-verziók érhetők el!';
$string['updateavailableinstall'] = 'Frissítés telepítése';
$string['updateavailable_moreinfo'] = 'További részletek...';
$string['updateavailablenot'] = 'Az Ön Moodle-verziója a legújabb.';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzió {$a}';
$string['updatecomponent'] = 'Összetevő frissítése';
$string['updateminmaturity'] = 'Szükséges programérettség';
$string['updateminmaturity_desc'] = 'Csak akkor figyelmzetessen elérhető frissítésekre, ha a program érettsége legalább a beállított szintet eléri. A programérettség szintjéről nem nyilatkozó segédprogramok frissítéséről mindig kap tájékoztatást - ettől a beállítástól függetlenül.';
$string['updatenotificationfooter'] = 'Az Ön {$a->siteurl} Moodle-portálján be van kapcsolva az elérhető frissítések automatikus ellenőrzése. Ezt az üzenetet a portál rendszergazdájaként kapja. A Beállítások blokk Portáladminisztráció mezőjében kapcsolhatja ki az elérhető frissítések automatikus ellenőrzését. Az értesítést a Profilom beállításai alatt módosíthatja.';
$string['updatenotifications'] = 'Értesítések frissítésekről.';
$string['updatenotificationsubject'] = 'Moodle-frissítések érhetők el ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Értesítés új programváltozatokról';
$string['updatenotifybuilds_desc'] = 'Bekapcsolása esetén akkor is kap értesítést, ha az elérhető frissítés az adott verziónak egy programváltozatát tartalmazza. A programváltozat valamely verzió folyamatos fejlesztésének egy állomását jelenti. A programváltozatok hetente állnak elő. Kikapcsolása esetén csak akkor kap értesítést frissítésekről, ha az a Mopddle egy magasabb verziójának felel meg. A beállítás a segédprogramok ellenőrzését nem befolyásolja.';
$string['upgrade197notice'] = '<p>A Moodle 1.9.7 egy sor jelszóval és biztonsági mentéssel kapcsolatos biztonsági javítást tartalmaz a portálján tárolt felhasználói adatok védelme érdekében. Ezért egyes biztonsági mentéssel kapcsolatos beállításai és engedélyei módosulhattak.<br />
A részleteket lásd itt: <a href="http://docs.moodle.org/dev/Moodle_1.9.7_release_notes" target="_blank">A Moodle 1.9.7 verzió megjegyzései</a>.</p>';
$string['upgrade197noticesubject'] = 'A Moodle 1.9.7 frissítésének biztonsági megjegyzései';
$string['upgrade197salt'] = 'A jelszólopás elkerülése érdekében ajánlatos zajos jelszót beállítani.<br />A részleteket l. a <a href="{$a}" target="_blank">jelszó zajossá tételéről szóló dokumentációban</a>.';
$string['upgradeerror'] = 'Ismeretlen hiba {$a->plugin} {$a->version} verzióra frissítése során, a Moodle leáll.';
$string['upgradeforumread'] = 'A Moodle 1.5 új elemmel bővült az elolvasott/még nem olvasott fórumhozzászólások nyomon követésére.<br />Ennek használatához <a href="{$a}">frissítenie kell táblázatait</a>.';
$string['upgradeforumreadinfo'] = 'A Moodle 1.5 új elemmel bővült az elolvasott/még nem olvasott fórumhozzászólások nyomon követésére. Ennek használatához frissítenie kell táblázatait az összes meglévő hozzászólásra vonatkozó nyomon követési információval. A portál méretétől függően ez hosszú időbe (akár órákba) telhet és igénybe veheti az adatbázis erőforrását, ezért ennek elvégzésére célszerű egy nyugodtabb időszakot kiválasztani. Ugyanakkor a portál a frissítés alatt továbbra is üzemel, a felhasználókat ez nem érinti. Ha a folyamatot elindítja, hagyja, hogy véget érjen (a böngésző ablakát tartsa nyitva). Ha mégis becsukná, semmi probléma, újrakezdheti.<br /><br />Most akarja elindítani a frissítést?';
$string['upgradelogs'] = 'Az összes funkció működéséhez minden régi naplóállományt frissíteni kell. <a href="{$a}">További tájékoztatás</a>';
$string['upgradelogsinfo'] = 'A naplóállományok tárolásában nemrégiben változásokra került sor. Ha a régebbi naplóállományokat tevékenységek szerint kívánja megtekinteni, akkor ezeket frissítenie kell. Ez az adott portáltól függően sok időt (akár órákat) vehet igénybe és meglehetősen megterhelheti a nagyobb portálok adatbázisait. Ha nekilát a folyamatnak, hagynia kell, hogy befejeződjék (azaz a böngésző ablakát hagyja nyitva). A naplóállományok frissítése közben a portál mások számára minden gond nélkül üzemel.<br /><br />Most kívánja frissíteni a naplóállományait?';
$string['upgradepluginsfirst'] = 'Először az elérhető frissítéseket kell telepítenie.';
$string['upgradepluginsinfo'] = 'Segédprogramok frissítése';
$string['upgradepluginsinfo_help'] = 'Egyes segédprogramjaihoz frissítések állnak rendelkezésre, melyeket a Moodle adatbázisának verziófrissítése előtt kell telepítenie. Ha portálja nem támogatja az automatikus frissítést, a frissítéseket kézi úton kell letöltenie és telepítenie.';
$string['upgradesettings'] = 'Új beállítások';
$string['upgradesettingsintro'] = 'Az alábbi beállítások hozzáadása a Moodle utolsó verziófrissítése óta történt. Az alapbeállításokon hajtsa végre a szükséges módosításokat, majd kattintson az oldal alján lévő &quot;Beállítások mentése&quot; pontra.';
$string['upgradestalefiles'] = 'Vegyes verziójú a Moodle telepítése, a frissítés nem folytatható.';
$string['upgradestalefilesinfo'] = 'A Moodle frissítési folyamata szünetel, mert a Moodle legalább két fő verziójából származó PHP-kódok fordulnak elő a Moodle-könyvtárban.

Ez jelentős problémákat okozhat később, ezért gondoskodjon arról, hogy a Moodle-könyvtár csak az egyik verzióból származó fájlokat  tartalmazza.

A Moodle-könyvtár megtisztításához:

* nevezze át a jelenlegi Moodle-könyvtárat "moodle_old"-ra;
* hozzon létre egy új könyvtárat, amely csak egy szabványos Moodle-csomag fájljait tartalmazza;
* a "moodle_old" könyvtárból helyezze át az eredeti config.php fájlt és a nem szabványos segédprogramokat az új Moodle-könyvtárba.

Ha elkészült a megtisztított Moodle-könyvtár, frissítse az oldalt és folytassa a Moodle frissítési folyamatát.

Ez a figyelmeztetés gyakran azért jelenik meg, mert egy standard csomagot egy korábbi verzióra másol rá. Kisebb frissítések esetén ez nem jelent gondot, nagyobb frissítés esetén azonban nem ajánlott.

A figyelmeztetést okozhatja az is, ha nem teljes frissítést hajt végre egy Git-adattár esetén. Ilyen esetben várja meg a frissítés végét vagy ismételje meg a műveletet.

Bővebb információ a frissítésről: <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'A Moodle adatbázisának verziófrissítése most.';
$string['upgradesure'] = 'Moodle-állományai módosultak, szerverét pedig automatikusan erre a változatra frissíti:  <strong>{$a}</strong> <br /><br /> Ha ez megtörtént, nem lesz módja a visszatérésre. <br /><br /> A folyamat elég sokáig tarthat. <br /><br /> Biztosan frissíti a szervert erre a változatra?';
$string['upgradetimedout'] = 'A frissítési idő lejárt, indítsa újra a frissítést.';
$string['upgradingdata'] = 'Adatok frissítése';
$string['upgradinglogs'] = 'Naplóállományok frissítése';
$string['upgradingversion'] = 'Frissítés új verzióra';
$string['upwards'] = 'felfelé';
$string['useblogassociations'] = 'Társítások bekapcsolása';
$string['useexternalyui'] = 'Használjon online YUI-könyvtárakat';
$string['user'] = 'Felhasználó';
$string['userbulk'] = 'Vegyes felhasználói lépések';
$string['userlist'] = 'Felhasználók felsorolásának böngészése';
$string['userpolicies'] = 'Felhasználói szabványok';
$string['userpreference'] = 'Felhasználói beállítások';
$string['userquota'] = 'Felhasználói kvóta';
$string['users'] = 'Felhasználók';
$string['usesitenameforsitepages'] = 'Portálnév használata a portál oldalaihoz';
$string['usetags'] = 'Címkék működésének bekapcsolása';
$string['validateerror'] = 'Ez az érték nem érvényes:';
$string['verifychangedemail'] = 'Domének korlátozása e-mail módosításakor';
$string['warningcurrentsetting'] = 'Érvénytelen aktuális érték: {$a}';
$string['warningiconvbuggy'] = 'Az iconv-könyvtár adott verziója nem támogatja az //IGNORE használatát. Helyette telepítse az mbstring bővítményt az érvénytelen UTF-8 karakterek kiszűréséhez.';
$string['webproxy'] = 'Web-proxy';
$string['webproxyinfo'] = 'Töltse ki az alábbi lehetőségeket, ha Moodle-szerverének nincs közvetlen hozzáférése az internethez. Internet-hozzáférés szükséges környezeti adatok, nyelvi csomagok, RSS-hírek, időzónák stb. letöltéséhez.<br /><em>Használja a PHP cURL-bővítményét.</em>';
$string['xmlrpcrecommended'] = 'Az xmlrpc-bővítmény az elosztó kommunikációjához szükséges, és hasznos a webszolgáltatások és a hálózati Moodle használatához.';
$string['yuicomboloading'] = 'YUI-kombó betöltése';
$string['ziprequired'] = 'A Moodle a Zip PHP bővítményt igényli, az info-ZIP bináris állományokra vagy a PclZip könyvtárra már nincs szükség.';
$string['zlibenabled'] = 'A zlib bekapcsolva';
