<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_elegance', language 'es_mx', branch 'MOODLE_26_STABLE'
 *
 * @package   theme_elegance
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alwaysdisplay'] = 'Mostrar siempre';
$string['backtotop'] = 'Regresar arriba';
$string['bannercolor'] = 'Color diapositiva';
$string['bannercolordesc'] = '¿No quiere usar una imagen? Especifique entonces un color de fondo';
$string['bannerimage'] = 'Imágen de diapositiva';
$string['bannerimagedesc'] = 'Imagen grande para ir detrás del texto de la diapositiva';
$string['bannerindicator'] = 'Diapositiva número';
$string['bannerindicatordesc'] = 'Configurar esta diapositiva';
$string['bannerlinktext'] = 'URL del nombre';
$string['bannerlinktextdesc'] = 'Texto a mostrar al mostrar enlace';
$string['bannerlinkurl'] = 'URL dirección';
$string['bannerlinkurldesc'] = 'Dirección a donde enlaza la diapositiva';
$string['bannersettings'] = 'Configuraciones de Paso de diapositivas';
$string['bannersettingsdesc'] = 'Habilitar y determinar las configuraciones para cada diapositiva debajo';
$string['bannersettingssub'] = 'Estas configuraciones controlan el paso de diapositivas que aparece en la portada de Moodle';
$string['bannertext'] = 'Texto de diapositiva';
$string['bannertextdesc'] = 'Texto a mostrar en la diapositiva';
$string['bannertitle'] = 'Título de diapositiva';
$string['bannertitledesc'] = 'Nombre de esta diapositiva';
$string['blog'] = 'URL del Blog';
$string['blogdesc'] = 'escriba la URL del Blog de su institución (por ejemplo, http://www.moodleman.net)';
$string['bodybg'] = 'Imagen del fondo';
$string['bodybgdesc'] = 'Si Usted quiere remplazar el fondo estándar, puede subir aquí su propio fondo.<br>
<strong>Sugerencia simpática</strong>: Usted puede usar esto para mostrar el contenido de Moodle empleando la opción inferior de transparencia.';
$string['bodycolor'] = 'Color del fondo';
$string['bodycolordesc'] = 'Si no se carga ninguna imagen, Moodle usará este color por defecto';
$string['categoryicondesc'] = 'Seleccione el ícono a usar para la categoría';
$string['categoryiconheading'] = 'Íconos de categoría';
$string['categoryiconheadingdesc'] = 'Si se habilita, le permitirá configurar íconos para cada categoría de curso.';
$string['categoryiconheadingsub'] = 'Use íconos para representar sus categorías.';
$string['categoryiconinfo'] = 'Configurar Íconos de Categoría personalizados';
$string['categoryiconinfodesc'] = 'Cada ícono se configura por "category ID". Usted puede obtener éstos en la URL de cada categoría. La lista está <a href="http://fontawesome.github.io/Font-Awesome/cheatsheet/">aquí</a>. Simplemente escriba lo que sigue después de  "fa-".';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Tema Elegancia (Elegance)</h2>
<p><img class=img-polaroid src="elegance/pix/screenshot.jpg" /></p>
</div>
<div class="well">
<h3>Acerca de</h3>
<p>Elegancia (Elegance) es un tema limpio a dos columnas, y altamente personalizable construido sobre el armazón del tema Bootstrap 3.</p>
<h3>Créditos de Tema</h3>
<p>Autor: Julian (Moodleman) Ridden<br>
Contacto: julian@moodleman.net<br>
Website: <a href="http://moodleman.net">www.moodleman.net</a>
</p>
<p>Suporte del Autor: Bas Brands (for the Bootstrap 3 work)<br>
Contacto: bas@sonsbeekmedia.nl<br>
Website: <a href="http://www.basbrands.nl">www.basbrands.nl</a>
</p>
<h3>Reporte problemas:</h3>
<p><a href="http://tracker.moodle.org">http://tracker.moodle.org</a></p>
<h3>Done si puede</h3>
<p>Elegancia, y todos mis temas, siempres serán gratuitos para la comunidad de Moodle. Sin embargo, el tiempo que se requiere para crear y mantener estos temas aumenta con cada versión liberada. Si a Usted le gusta este tema y el soporte que yo doy en los foros, le animo a donar con el botón inferior. Esto de ninguna manera es necesario para usar este tema.</p>

<a href="https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=KNV2ZPHCYTB8E" class="btn btn-lrg btn-info">Done AUD$15</a>

</div></div>';
$string['colorsettings'] = 'Logos y colores';
$string['colorsettingsdesc'] = 'Suba sus logos y cambie los colores del tema con estas configuraciones.';
$string['colorsettingssub'] = 'Cambie el aspecto';
$string['configtitle'] = 'Elegancia';
$string['copyright'] = 'Derechos Reservados';
$string['copyrightdesc'] = 'El nombre de su organización';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Las reglas CSS que añada en esta área se reflejarán en todas las páginas, haciendo más fácil la personalización del tema.';
$string['customlinkicon'] = 'Ícono de enlace';
$string['customlinkicondesc'] = 'Nombre del ícono que desea usar junto a su enlace.<br> La lista está  <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que sigue de  "fa-".';
$string['customlinkindicator'] = 'Número de enlace personalizado';
$string['customlinkindicatordesc'] = 'Configurar este enlace personalizado';
$string['customlinkname'] = 'Nombre del enlace';
$string['customlinknamedesc'] = 'Nombre mostrado a los usuarios para su enlace';
$string['customlinkurl'] = 'URL del destino del enlace';
$string['customlinkurldesc'] = 'La ruta completa o relativa para la URL de su destino.';
$string['defaultcategoryicon'] = 'Íconos de Categoría por Defecto';
$string['defaultcategoryicondesc'] = 'Si USted no escribe un valor en ninguna de las categorías debajo, entonces se usará este valor por defecto. Esta es una forma sencilla de cambiar rápidamente muchos íconos de categoría.';
$string['displayafterlogin'] = 'Mostrar solamente después de ingresar';
$string['displaybeforelogin'] = 'Mostrar solamente antes de ingresar';
$string['dontdisplay'] = 'Nunca mostrar';
$string['enablebadges'] = 'Insignias';
$string['enablebadgesdesc'] = 'Mostrar un enlace hacia insignias de usuario';
$string['enablebanner'] = 'Habilitar esta diapositiva';
$string['enablebannerdesc'] = 'Usted estará usando esta diapositiva';
$string['enablecalendar'] = 'Calendario del usuario';
$string['enablecalendardesc'] = 'Mostrar un enlace hacia el calendario de los usuarios';
$string['enablecategoryicon'] = 'Habilitar íconos para Categorías';
$string['enablecategoryicondesc'] = 'Si se habilita, Usted podrá seleccionar íconos de categoría después de elegir "Guadar cambios".';
$string['enablecustomlogin'] = 'Usar logo personalizado';
$string['enablecustomlogindesc'] = 'Al habilitarse, esto usará la versión aumentada del tema para la pantalla para ingresar al sitio. Al remover la selección, se regresará a la versión por defecto de Moodle.<br>La versión aumentada le permite a Usted subir imágenes de fondo para añadirle más lucimiento al diseño de su página.';
$string['enableeditprofile'] = 'Editar perfil';
$string['enableeditprofiledesc'] = 'Mostrarun enlace hacia el perfil del usuario';
$string['enablemy'] = 'Mi Tablero de Control';
$string['enablemydesc'] = 'Mostrar un enlace hacia la página de Mi Moodle';
$string['enableprivatefiles'] = 'Archivos Privados';
$string['enableprivatefilesdesc'] = 'Mostrar un enlace hacia los archivos privados del usuario';
$string['enableprofile'] = 'Perfil delusuario';
$string['enableprofiledesc'] = 'Mostra un enlace hacia el perfil de los usuarios';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Escriba la URL de su página de Facebook . (por ejemplo, http://www.facebook.com/pukunui)';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Escriba la URLde su página de Flickr . (por ejemplo, http://www.flickr.com/mycollege)';
$string['fluidwidth'] = 'Tema de ancho fluído';
$string['fluidwidthdesc'] = 'Habilite esta opción para permitir usar su pantalla completa.';
$string['fontcolor'] = 'Color de tipo de letra';
$string['fontcolordesc'] = 'Configurar el color perincipal usado en el sitio';
$string['fonticons'] = 'Usar tipo de letra de Íconos';
$string['fonticonsdesc'] = 'Habilite esta opción para usar el tipo de letra de Íconos Glyphicon';
$string['footnote'] = 'Nota al pie';
$string['footnotedesc'] = 'Todo lo que añada en esta área de texto se mostrará en el pie de página de todo su sitio Moodle.';
$string['frontpagecontent'] = 'Contenido de la portada';
$string['frontpagecontentdesc'] = 'Esta localización aparece resaltada debajo del paso de diapositivas en la portada del sitio';
$string['geneicsettings'] = 'Configuraciones Generalews';
$string['googleplus'] = 'URL de Google+';
$string['googleplusdesc'] = 'Escriba la URL de su perfil de Google+ . (por ejemplo,  https://google.com/+Pukunui/)';
$string['headerbg'] = 'Fondo del encabezado';
$string['headerbgdesc'] = 'Si Usted quiere remplazar el fondo estándar, Usted puede subir aquí su propio fondo.<br>
El tamaño recomendado es de  110 pixeles de alto por 1600 pixerles de ancho. Si la imagen fuera más pequeña, se mostrará en mosaico repetido.<br>
<strong>Tip padrísimo</strong>: Si su imagen usa transparencia, el color del tema se mostrará a travez de la imagen.';
$string['headingcolor'] = 'Colores del Encabezado';
$string['headingcolordesc'] = 'Configure el color para la mayoría de los encabezados de todo el sitio.';
$string['instagram'] = 'URL de Instagram';
$string['instagramdesc'] = 'Escriba la URL de su página de Instagram. (por ejemplo, http://Instagram.com/mi_colegio)';
$string['invert'] = 'Invertir barra de navegación';
$string['invertdesc'] = 'Catafixia (alterna), entre negro y blanco, el texto y el fondo para la barra de navegación en la parte superior de la página.';
$string['linkedin'] = 'URL de Linkedln';
$string['linkedindesc'] = 'Escriba la URL de su perfil en Linkedln. (por ejemplo, http://www.linkedin.com/company/pukunui-technology)';
$string['loginbgumber'] = 'Número de Fondo';
$string['loginbgumberdesc'] = 'Cuando fondos se revolverán cuando cargue la página para ingreso';
$string['loginimage'] = 'Imagen de fondo';
$string['loginimagedesc'] = 'El tamaño ideal para imágenes de fondo es de 1200 por 800 pixeles';
$string['loginsettings'] = 'Pantalal de Ingreso';
$string['loginsettingsdesc'] = 'La versión personalizada tiene un paso automático de imágenes con imágenes que Usted puede personalizar, además de un aspecto más claro.';
$string['loginsettingssub'] = 'Configuraciones para Pantalla de Ingreso Personalizada';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Por favor, suba aquí su logo personalizado si quiere añadirlo al encabezado<br>
Como el espacio en la Barra de Navegación está limitado, su logo no deberá exceder de 30 pixeles de alto.';
$string['marketing1'] = 'Bloque Publicitario Uno';
$string['marketing2'] = 'Bloque Publicitario Dos';
$string['marketing3'] = 'Bloque Publicitario Tres';
$string['marketing4'] = 'Bloque Publicitario Cuatro';
$string['marketingbuttontext'] = 'Texto de enlace';
$string['marketingbuttontextdesc'] = 'Texto que aparecerá hasta abajo.';
$string['marketingbuttonurl'] = 'URL del enlace';
$string['marketingbuttonurldesc'] = 'URL hacia donde apuntará el enlace.';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido a mostrar en la caja de publicidad. Hágalo corto y dulce.';
$string['marketingdesc'] = 'Este tema proporciona la opción para habilitar tres puntos para "Anuncios" o "promoción" justamente debajo del paso de diapositivas. Estos puntos le permiten identificar facilmente información vital para sus usuarios y proporcionarles enlaces directos.';
$string['marketingheading'] = 'Bloques Publicitario';
$string['marketingheadingsub'] = 'Tres lugares en la portada para añadir información y enlaces';
$string['marketingheight'] = 'Altura de cajas de Anuncios';
$string['marketingheightdesc'] = 'Si Usted desea mostrar imágenes en las cajas de Anuncios Usted puede especificar su altura aquí.';
$string['marketingicon'] = 'Ícono';
$string['marketingicondesc'] = 'Nombre del ícono que desea usar . La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que sigue después de "fa-".';
$string['marketingimage'] = 'Imagen';
$string['marketingimagedesc'] = 'Esto proporciona la opción de mostrar una imagen arriba del texto en el bloque publicitario';
$string['marketinginfodesc'] = 'Escriba las configuraciones para su bloque publicitario';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a mostrar en este Bloque Publicitario';
$string['marketingtitleicon'] = 'Ícono de Encabezado';
$string['marketingtitleicondesc'] = 'Nombre del ícono que Usted desea mostrar en el encabezado para el bloque publicitario. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que aparece después de "fa-".';
$string['moodlemobilecss'] = 'CSS de Moodle Mobile';
$string['moodlemobilecssdesc'] = 'La aplicación de Moodle Mobile le permite definir una hoja de estilo (\'\'style sheet\'\') externa para estilizar la aplicación. Las reglas CSS que Usted añada a esta área_de_texto se mostrarán en la aplicación Moodle Mobile oficial. Simplemente copie la URL inferior y guárdela en la configuración de "mobilecssurl" debajo de "Web Services -> Mobile".';
$string['mydashboard'] = 'Mi Tablero de Control';
$string['nextsection'] = 'Siguiente sección';
$string['pinterest'] = 'URL de Piinterest';
$string['pinterestdesc'] = 'Escriba la URL de su página de Pinterest. (por ejemplo, http://pinterest.com/mi_colegio)';
$string['pluginname'] = 'Elegancia';
$string['previoussection'] = 'Sección anterior';
$string['quicklinkbuttoncolor'] = 'Color del botón';
$string['quicklinkbuttoncolordesc'] = 'Color del botón de enlace rápido';
$string['quicklinkbuttontext'] = 'Texto del enlace';
$string['quicklinkbuttontextdesc'] = 'Texto que aparecerá en el botón';
$string['quicklinkbuttonurl'] = 'URL del enlace';
$string['quicklinkbuttonurldesc'] = 'URL hacia donde apuntará el botón.';
$string['quicklinkicon'] = 'Ícono';
$string['quicklinkiconcolor'] = 'Color del Enlace Rápido';
$string['quicklinkiconcolordesc'] = 'Color del fondo detrás del ícono de Enlace Rápido';
$string['quicklinkicondesc'] = 'Nombre del ícono que desea usar . La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que sigue después de "fa-".';
$string['quicklinks'] = 'Número del Enlace Rápido';
$string['quicklinksdesc'] = 'Este tema proporciona la opción de habilitar puntos para "Enlace Rápido". Estos le permiten crear localizaciones que enlazan hacia cualquier URL que Usted elija.';
$string['quicklinksheading'] = 'Enlaces Rápidos';
$string['quicklinksheadingdesc'] = 'Escriba las configuraciones para sus Enlaces Rápidos en la Portada';
$string['quicklinksheadingsub'] = 'Localizaciones en la portada para añadirles información y enlaces';
$string['quicklinksicon'] = 'Ícono del Encabezado';
$string['quicklinksicondesc'] = 'Nombre del ícono que desea usar en el encabezado para los Enlaces Rápidos. La lista está <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">aquí</a>. Solamente escriba lo que sigue después de "fa-".';
$string['quicklinksnumber'] = 'Número de Enlaces';
$string['quicklinksnumberdesc'] = 'Cuantos enlaces rápidos quiere Usted que se muestren en la portada.';
$string['quicklinkstitle'] = 'Encabezado del área';
$string['quicklinkstitledesc'] = 'El nombre asociado con el área de Enlaces Rápidos en la portada';
$string['reader'] = 'Lector';
$string['region-hidden-dock'] = 'Solamente Admin';
$string['region-side-middle'] = 'Mitad de la página principal';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['showoldmessages'] = 'Mostrar Mensajes Antiguos';
$string['showoldmessagesdesc'] = 'Mostrar mensajes antiguos en el menú de mensajes';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Escriba su nombre_de_usuario de Skype de su cuenta institucional de Skype';
$string['slidenumber'] = 'Número de diapositivas';
$string['slidenumberdesc'] = 'No se cambiarán las opciones acerca del número de diapositivas HASTA DESPUËS DE que Usted presione guardar después de haber cambiado este número.';
$string['slidespeed'] = 'Duración de diapositiva';
$string['slidespeeddesc'] = 'Configure por cuantos milisegundos aparece la diapositiva';
$string['socialdesc'] = 'Proporcione enlaces directos a las redes sociales que promueven su marca/institución. Estos aparecerán en el encabezado de todas las páginas.';
$string['socialheading'] = 'Redes Sociales';
$string['socialheadingsub'] = 'Acapre la atención de sus usuarios con Redes Sociales';
$string['socialnetworks'] = 'Redes Sociales';
$string['socialnetworksicondescriptionblog'] = 'Lea nuestro Blog';
$string['socialnetworksicondescriptionfacebook'] = 'Véanos en Facebook';
$string['socialnetworksicondescriptionflickr'] = 'Véanos en Flickr';
$string['socialnetworksicondescriptiongoogleplus'] = 'Síganos en Google Plus';
$string['socialnetworksicondescriptioninstagram'] = 'Encuéntrenos en Instagram';
$string['socialnetworksicondescriptionlinkedin'] = 'Conéctese con nosotros en LinkedIn';
$string['socialnetworksicondescriptionpinterest'] = 'Pónganos en Pinterest';
$string['socialnetworksicondescriptionskype'] = 'LLámenos por Skype';
$string['socialnetworksicondescriptiontumblr'] = 'Encuéntrenos en Tumblr';
$string['socialnetworksicondescriptiontwitter'] = 'Síganos en Twitter';
$string['socialnetworksicondescriptionvimeo'] = 'Veanos en Vimeo';
$string['socialnetworksicondescriptionvk'] = 'Disfrútenos en VK';
$string['socialnetworksicondescriptionwebsite'] = 'Visite nuestra página web';
$string['socialnetworksicondescriptionyoutube'] = 'Véanos en YouTube';
$string['themecolor'] = 'Color del tema';
$string['themecolordesc'] = 'Configure su color "resaltado". Esto se usa también para los enlaces.';
$string['togglemarketing'] = 'Vista de Bloque Publicitario';
$string['togglemarketingdesc'] = 'Elija si desea oculltar o mostrar los tres Bloques Publicitarios.';
$string['togglequicklinks'] = 'Mostra Enlaces Rápidos';
$string['togglequicklinksdesc'] = 'Elija si quiere mostrar o si desea ocultar el área de Enlaces Rápidos';
$string['transparency'] = 'Transparencia del contenido';
$string['transparencydesc'] = '¿Quire ver más a través de su fondo? Esta configuración cambia la transparencia del contenido de Moodle y de los bloques';
$string['tumblr'] = 'URL de Tumblr';
$string['tumblrdesc'] = 'Escriba la URL de su Tumblr. ejemplo:http://moodleman.tumblr.com)';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Escriba la URL de su canal de Twitter. (ejemplo: http://www.twitter.com/pukunui)';
$string['usermenulinks'] = '# de Enlaces Personalizados';
$string['usermenulinksdesc'] = 'Configure cuantos enlaces extra le gustaría añadir para sus usuarios.<br>Usted necesitará guardar esta configuración para que aparezcan las nuevas opciones de los enlaces.';
$string['usermenusettings'] = 'Menú del Usuario';
$string['usermenusettingsdesc'] = 'Determinar cuales enlaces mostrar en el menú para usuarios ingresados';
$string['usermenusettingssub'] = 'Opciones para los usuarios ingresados';
$string['videowidth'] = 'Configurar el ancho máximo del video';
$string['videowidthdesc'] = 'Este tema cambia dinámicamente el tamaño del video incrustado. Por defecto, se ponen al 100% del ancho. Usted puede anular esto aquí.<br>
<strong>Nota importante:</strong> Acuérdese de añadir el postfijo de % o px después del número, o no funcionará';
$string['vimeo'] = 'URL de Vimeo';
$string['vimeodesc'] = 'Escriba la URLde su canal de Vimeo . (ejemplo:http://vimeo.com/moodleman)';
$string['visibleadminonly'] = 'Los bloques movidos al área inferior solamente serán vistos por administradores.';
$string['vk'] = 'URL de VKontakte';
$string['vkdesc'] = 'Escriba aquí la URL de su página de Vkontakte . (ejemplo: http://www.vk.com/micolegio)';
$string['website'] = 'URL del sitio web';
$string['websitedesc'] = 'Escriba la URL de su propio sitio web. (por ejemplo, http://www.pukunui.com)';
$string['youtube'] = 'URL de YouTube';
$string['youtubedesc'] = 'Escriba la URL de su canal de YouTube. (ejemplo: http://www.youtube.com/moodleman)';
