<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_preg', language 'es_mx', branch 'MOODLE_26_STABLE'
 *
 * @package   qtype_preg
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_leaf_control'] = '';
$string['answerno'] = 'Respuesta {$a}';
$string['anycrlf_leaf_control'] = '';
$string['any_leaf_control'] = '';
$string['authoring_form_charset_flags'] = 'significado real (formato unificado)';
$string['authoring_form_charset_mode'] = 'Modo de visualización para clases de caracteres complejos';
$string['authoring_form_charset_userinscription'] = 'como se escribe en expresiones regulares';
$string['authoring_form_check_strings'] = 'Revisar la(s) cadena(s)';
$string['authoring_form_edit_header'] = 'Expresión regular';
$string['authoring_form_edit_header_help'] = 'Escriba su regex aquí. Usted verá el árbol de sintaxis correspondiente, la gráfica explicativa y la descripción. Elija "Actualizar (\'\'Update\'\') para aplicar los cambios en el regex.';
$string['authoring_form_graph_build'] = 'Construyendo la gráfica ...';
$string['authoring_form_options_header'] = 'Opciones de concordancia';
$string['authoring_form_options_header_help'] = 'Aquí puede Usted afinar la concordancia (coincidencia). Estas opciones se guardarán en el formato de edición de la pregunta.';
$string['authoring_form_page_header'] = 'Constructor Regex';
$string['authoring_form_rect_selection_mode'] = 'Modo de selección de rectángulo';
$string['authoring_form_rect_selection_select'] = 'Seleccionar';
$string['authoring_form_testing_header'] = 'Prueba de expresión regular';
$string['authoring_form_testing_header_help'] = 'Aquí pued eUsted escribir algunas cadenas de texto (una por línea) para probar su regex. Después de hacer click en "Revisar la(s) cadena(s)", Usted verá los resultados a la derecha: las parejas coincidentes son verdes, las partes que no coinciden son rojas. Un ícono le muestra si es que la cadena dada coincidió con todo el regex (palomita color verde) o no (cruz roja).';
$string['authoring_form_testing_textarea'] = 'Escriba las cadenas para ver coincidencia (una por línea)';
$string['authoring_form_text'] = 'Escriba su regex aquí:';
$string['authoring_form_tooltip'] = 'Abrir constructor regex';
$string['authoring_form_tree_build'] = 'Construyendo el árbol ...';
$string['bsr_anycrlf_leaf_control'] = '';
$string['bsr_unicode_leaf_control'] = '';
$string['callout_big_number_node_error'] = 'El número {$a->addinfo} en la llamada es demasiado grande, no debería de ser mayor de 255.';
$string['capital_esc_z_leaf_assert'] = 'Fin de la cadena';
$string['c_at_end_of_pattern_node_error'] = 'Error de sintaxis: c al final del patrón';
$string['char_code_disallowed_node_error'] = 'Los puntos de código Unicode 0xd800 ... 0xdfff no están permitidos';
$string['char_code_too_big_node_error'] = 'El código de carcter {$a->addinfo} es demasiao grande.';
$string['charhintpenalty'] = 'Castigo para la pista de la letra siguiente';
$string['charhintpenalty_help'] = 'Castigo por obtener la pista de una-letra. Típicamente será mayor que el castigo de pregunta habitual de Moodle (que aplica a cualquier intento de pregunta para contestar pregunta sin pistas). Estos castigos son mutuamente exclusivos.';
$string['circumflex_leaf_assert'] = 'inicio de la cadena';
$string['commit_leaf_control'] = '';
$string['condsubexpr_assert_expected_node_error'] = 'Afirmación o condición esperada.';
$string['condsubexpr_too_much_alter_node_error'] = 'Error de sintaxis: tres o más alternacias de nivel superior en la subexpresión condicional en posición desde  {$a->indfirst} hasta {$a->indlast}. Use paréntesis si desea incluir alternancias en expresiones-si (yes-expr) o expresiones-no (no-expr).';
$string['condsubexpr_zero_condition_node_error'] = 'Condición inválida (?(0).';
$string['correctanswer'] = 'Respuesta correcta';
$string['correctanswer_help'] = 'Escriba una respuesta correcta (no una expresión regular) para mostrar a los estudiantes. Si lo deja vacío, el motor de coincidencia tratará de generar una respuesta correcta por sí mismo, poniendo atención a obtener la más cercana a la respuesta del estudiante. Por ahora solamente el motor NFA puede generar respuestas correctas.';
$string['cr_leaf_control'] = '';
$string['crlf_leaf_control'] = '';
$string['cx_should_be_ascii_node_error'] = 'c debería de ser seguida por un caracter ASCII';
$string['debugheading'] = 'Configuraciones para depurar (debug)';
$string['defaultenginedescription'] = 'Motor coincidente seleccionado por defecto al crear pregunta nueva';
$string['defaultenginelabel'] = 'Motor coincidente por defecto';
$string['defaultlangdescription'] = 'Idioma seleccionado por defecto al crear pregunta nueva';
$string['defaultlanglabel'] = 'Idioma por defecto';
$string['defaultnotationdescription'] = 'Notación seleccionada por defecto al crear pregunta nueva';
$string['defaultnotationlabel'] = 'Notación por defecto';
$string['define_node_cond_subexpr'] = '"define"-subexpresión condicional';
$string['description_accept_leaf_control'] = 'forzar coincidencia de subexpresión exitosa';
$string['description_anycrlf_leaf_control'] = 'alimentación de línea coincide con retorno de carro, alimentación de línea o retorno de carro seguido por alimentación de línea';
$string['description_any_leaf_control'] = 'alimentación de línea coincide con alguna secuencia de línea nueva Unicode';
$string['description_bsr_anycrlf_leaf_control'] = 'R coincide con CR (retorno de carro), LF (alimentación de línea), o CRLF (Retorno de carro con alimentación de línea)';
$string['description_bsr_unicode_leaf_control'] = 'R coincide con cualquier secuencia de línea nueva Unicode';
$string['description_capital_esc_z_leaf_assert'] = 'fin de la cadena';
$string['description_char'] = '<span style="color:blue">{$a->char}</span>';
$string['description_char0'] = 'caracter nulo (NUL)';
$string['description_char1'] = 'caracter inicio de encabezado (SOH)';
$string['description_char10'] = 'caracter de escape de enlace de datos (DLE)';
$string['description_char18'] = 'caracter cancelar (CAN)';
$string['description_char19'] = 'caracter fin de medio (EM)';
$string['description_char1A'] = 'caracter sustituto (SUB)';
$string['description_char1B'] = 'escape (ESC)';
$string['description_char1C'] = 'caracter separador de archivo (FS)';
$string['description_char1D'] = 'caracter separador de grupo (GS)';
$string['description_char1E'] = 'caracter separador de registro (RS)';
$string['description_char1F'] = 'caracter separador de unidad (US)';
$string['description_char2'] = 'caracter inicio de texto (STX)';
$string['description_char20'] = 'espacio';
$string['description_char2002'] = 'espacio en';
$string['description_char2003'] = 'espacio em';
$string['description_char2009'] = 'espacio angosto';
$string['description_char200C'] = 'no-unión de ancho cero';
$string['description_char200D'] = 'unión de ancho cero';
$string['description_char3'] = 'caracter fin de texto (ETX)';
$string['description_char4'] = 'caracter fin de transmisión (EOT)';
$string['description_char5'] = 'caracter de interrogación (Enquiry=ENQ)';
$string['description_char6'] = 'Caracter de confirmación (Acknowledgement=ACK)';
$string['description_char7'] = 'caracter de timbre (BEL)';
$string['description_char7F'] = 'caracter suprimir (Delete=DEL)';
$string['description_char8'] = 'caracter retroceso (BS)';
$string['description_char9'] = 'tabulación (HT)';
$string['description_charA'] = 'alimentación de línea (LF)';
$string['description_charA0'] = 'espacio no-separable';
$string['description_charAD'] = 'caracter de guión suave';
$string['description_charB'] = 'tabulación vertical (VT)';
$string['description_charC'] = 'alimentación de formato (FF)';
$string['description_charD'] = 'caracter de retorno de carro (CR)';
$string['description_charE'] = 'caracter shift out (SO)';
$string['description_charF'] = 'caracter shift in (SI)';
$string['description_charflag_alnum'] = 'una letra o dígito';
$string['description_charflag_alnum_neg'] = 'no-letra y no-dígito';
$string['description_charflag_alpha'] = 'una letra';
$string['description_charflag_alpha_neg'] = 'no-es-una-letra';
$string['description_charflag_Arabic'] = 'Caracter arábigo';
$string['description_charflag_Arabic_neg'] = 'caracter no-arábigo';
$string['description_charflag_Armenian'] = 'Caracter armenio';
$string['description_charflag_Armenian_neg'] = 'Caracter no-armenio';
$string['description_charflag_ascii'] = 'un caracter con códigos 0-127';
$string['description_charflag_ascii_neg'] = 'no es un un caracter con códigos 0-127';
$string['description_charflag_Avestan'] = 'Caracter avestan';
$string['description_charflag_Avestan_neg'] = 'Caracter no-avestan';
$string['description_charflag_Balinese'] = 'Caracter balinés';
$string['description_charflag_Balinese_neg'] = 'Caracter no-balinés';
$string['description_charflag_Bamum'] = 'Caracter banum';
$string['description_charflag_Bamum_neg'] = 'Caracter no-banum';
$string['description_charflag_Bengali'] = 'Caracter bengalí';
$string['description_charflag_Bengali_neg'] = 'Caracter no-bengalí';
$string['description_charflag_blank'] = 'solamente un espacio o tabulación';
$string['description_charflag_blank_neg'] = 'no es espacio ni tabulación';
$string['description_charflag_Bopomofo'] = 'Caracter bopomofo';
$string['description_charflag_Bopomofo_neg'] = 'Caracter no-bopomofo';
$string['description_charflag_Braille'] = 'caracter Braille';
$string['description_charflag_Braille_neg'] = 'caracter no-Braille';
$string['description_charflag_Buginese'] = 'Caracter buginés';
$string['description_charflag_Buginese_neg'] = 'caracter no-Buginés';
$string['description_charflag_Buhid'] = 'Caracter buhid';
$string['description_charflag_Buhid_neg'] = 'caracter no-Buhid';
$string['description_charflag_C'] = 'otra propiedad Unicode';
$string['description_charflag_Canadian_Aboriginal'] = 'Caracter aborígen canadiense';
$string['description_charflag_Canadian_Aboriginal_neg'] = 'caracter no-Aborígeno Canadiense';
$string['description_charflag_Carian'] = 'Caracter cariano';
$string['description_charflag_Carian_neg'] = 'caracter no-Cariano';
$string['description_charflag_Cc'] = 'control';
$string['description_charflag_Cc_neg'] = 'no-control';
$string['description_charflag_Cf'] = 'formato';
$string['description_charflag_Cf_neg'] = 'no-formato';
$string['description_charflag_Cham'] = 'Caracter cham';
$string['description_charflag_Cham_neg'] = 'caracter no-Cham';
$string['description_charflag_Cherokee'] = 'Caracter cheroki';
$string['description_charflag_Cherokee_neg'] = 'caracter no-Cherokee';
$string['description_charflag_Cn'] = 'no asignado';
$string['description_charflag_C_neg'] = 'no es otra propiedad Unicode';
$string['description_charflag_Cn_neg'] = 'no sin-asignar';
$string['description_charflag_cntrl'] = 'un caracter de control';
$string['description_charflag_cntrl_neg'] = 'no es un caracter de control';
$string['description_charflag_Co'] = 'uso privado';
$string['description_charflag_Common'] = 'Caracter común';
$string['description_charflag_Common_neg'] = 'no es un caracter Común';
$string['description_charflag_Co_neg'] = 'no uso-privado';
$string['description_charflag_Coptic'] = 'Caracter cóptico';
$string['description_charflag_Coptic_neg'] = 'caracter no-Cóptico';
$string['description_charflag_Cs'] = 'sustituto';
$string['description_charflag_Cs_neg'] = 'no surrogado';
$string['description_charflag_Cuneiform'] = 'Caracter cuneiforme';
$string['description_charflag_Cuneiform_neg'] = 'caracter no-Cuneiforme';
$string['description_charflag_Cypriot'] = 'Caracter chipriota';
$string['description_charflag_Cypriot_neg'] = 'caracter no-Cipriota';
$string['description_charflag_Cyrillic'] = 'Caracter cirílico';
$string['description_charflag_Cyrillic_neg'] = 'caracter no-Cirílico';
$string['description_charflag_Deseret'] = 'Caracter Deseret';
$string['description_charflag_Deseret_neg'] = 'caracter no-Deseret';
$string['description_charflag_Devanagari'] = 'Caracter devanagari';
$string['description_charflag_Devanagari_neg'] = 'Caracter no-devanagari';
$string['description_charflag_digit'] = 'un dígito decimal';
$string['description_charflag_digit_neg'] = 'no es un dígito decimal';
$string['description_charflag_dot'] = 'cualquier caracter';
$string['description_charflag_Egyptian_Hieroglyphs'] = 'Caracter jeroglífico egipcio';
$string['description_charflag_Egyptian_Hieroglyphs_neg'] = 'Caracter no-jeroglífico-egipcio';
$string['description_charflag_Ethiopic'] = 'Caracter etiope';
$string['description_charflag_Ethiopic_neg'] = 'caracter no-Etiope';
$string['description_charflag_Georgian'] = 'Caracter georgiano';
$string['description_charflag_Georgian_neg'] = 'caracter no-Georgiano';
$string['description_charflag_Glagolitic'] = 'Caracter glagolítico';
$string['description_charflag_Glagolitic_neg'] = 'Caracter no-glagolítico';
$string['description_charflag_Gothic'] = 'Caracter gótico';
$string['description_charflag_Gothic_neg'] = 'caracter no-Gótico';
$string['description_charflag_graph'] = 'un caracter imprimible (excluyendo espacio)';
$string['description_charflag_graph_neg'] = 'no es un caracter imprimible (excluyendo espacio)';
$string['description_charflag_Greek'] = 'Caracter griego';
$string['description_charflag_Greek_neg'] = 'caracter no-Griego';
$string['description_charflag_Gujarati'] = 'Caracter gujarati';
$string['description_charflag_Gujarati_neg'] = 'caracter no-Gujarati';
$string['description_charflag_Gurmukhi'] = 'Caracter gurmukhi';
$string['description_charflag_Gurmukhi_neg'] = 'Caracter no-gurmukhi';
$string['description_charflag_Han'] = 'Caracter han';
$string['description_charflag_Hangul'] = 'Caracter hangul';
$string['description_charflag_Hangul_neg'] = 'Caracter no-hangul';
$string['description_charflag_Han_neg'] = 'caracter no-Han';
$string['description_charflag_Hanunoo'] = 'Caracter hanunoo';
$string['description_charflag_Hanunoo_neg'] = 'Caracter no-hanunoo';
$string['description_charflag_Hebrew'] = 'Caracter hebreo';
$string['description_charflag_Hebrew_neg'] = 'caracter no Hebreo';
$string['description_charflag_Hiragana'] = 'Caracter hiragana';
$string['description_charflag_Hiragana_neg'] = 'Caracter no-hiragana';
$string['description_charflag_Imperial_Aramaic'] = 'Caracter arameo imperial';
$string['description_charflag_Imperial_Aramaic_neg'] = 'Caracter no-arameo-imperial';
$string['description_charflag_Inherited'] = 'caracter heredado';
$string['description_charflag_Inherited_neg'] = 'caracter no heredado';
$string['description_charflag_Inscriptional_Pahlavi'] = 'Caracter pahlavi inscripcional';
$string['description_charflag_Inscriptional_Pahlavi_neg'] = 'Caracter no-pahlavi-inscripcional';
$string['description_charflag_Inscriptional_Parthian'] = 'Caracter parthian inscripcional';
$string['description_charflag_Inscriptional_Parthian_neg'] = 'Caracter no-parthian-inscripcional';
$string['description_charflag_Javanese'] = 'Caracter javanés';
$string['description_charflag_Javanese_neg'] = 'caracter no-Javanés';
$string['description_charflag_Kaithi'] = 'Caracter kaithi';
$string['description_charflag_Kaithi_neg'] = 'Caracter no-kaithi';
$string['description_charflag_Kannada'] = 'Caracter Kannada';
$string['description_charflag_Kannada_neg'] = 'Caracter no-Kannada';
$string['description_charflag_Katakana'] = 'Caracter katakana';
$string['description_charflag_Katakana_neg'] = 'Caracter no-katakana';
$string['description_charflag_Kayah_Li'] = 'caracter Kayah Li';
$string['description_charflag_Kayah_Li_neg'] = 'caracter no-Kayah-Li';
$string['description_charflag_Kharoshthi'] = 'caracter Kharoshthi';
$string['description_charflag_Kharoshthi_neg'] = 'caracter no-Kharoshthi';
$string['description_charflag_Khmer'] = 'Caracter Khmer';
$string['description_charflag_Khmer_neg'] = 'Caracter no-Khmer';
$string['description_charflag_L'] = 'letra';
$string['description_charflag_Lao'] = 'caracter lao';
$string['description_charflag_Lao_neg'] = 'caracter no-lao';
$string['description_charflag_Latin'] = 'caracter latino';
$string['description_charflag_Latin_neg'] = 'caracter no Latino';
$string['description_charflag_Lepcha'] = 'caracter Lepcha';
$string['description_charflag_Lepcha_neg'] = 'caracter no-Lepcha';
$string['description_charflag_Limbu'] = 'Caracter limbu';
$string['description_charflag_Limbu_neg'] = 'Caracter no-limbu';
$string['description_charflag_Linear_B'] = 'caracter lineal B';
$string['description_charflag_Linear_B_neg'] = 'caracter no-lineal-B';
$string['description_charflag_Lisu'] = 'caracter lisu';
$string['description_charflag_Lisu_neg'] = 'caracter no-lisu';
$string['description_charflag_Ll'] = 'letra minúscula';
$string['description_charflag_Ll_neg'] = 'no es letra minúscula';
$string['description_charflag_Lm'] = 'letra modificadora';
$string['description_charflag_Lm_neg'] = 'no es letra modificadora';
$string['description_charflag_L_neg'] = 'no letra';
$string['description_charflag_Lo'] = 'otra letra';
$string['description_charflag_Lo_neg'] = 'no es otra letra';
$string['description_charflag_lower'] = 'una letra minúscula';
$string['description_charflag_lower_neg'] = 'no es letra minúscula';
$string['description_charflag_Lt'] = 'letra de Título';
$string['description_charflag_Lt_neg'] = 'no es letra de Título';
$string['description_charflag_Lu'] = 'letra MAYÚSCULA';
$string['description_charflag_Lu_neg'] = 'no es letra MAYÚSCULA';
$string['description_charflag_Lycian'] = 'caracter liciano';
$string['description_charflag_Lycian_neg'] = 'caracter no-liciano';
$string['description_charflag_Lydian'] = 'caracter lyndian';
$string['description_charflag_Lydian_neg'] = 'caracter no-lyndian';
$string['description_charflag_M'] = 'marca';
$string['description_charflag_Malayalam'] = 'Caracter malayalam';
$string['description_charflag_Malayalam_neg'] = 'Caracter no-malayalam';
$string['description_charflag_Mc'] = 'marca que espacía';
$string['description_charflag_Mc_neg'] = 'no es marca que espacía';
$string['description_charflag_Me'] = 'signo que encierra';
$string['description_charflag_Meetei_Mayek'] = 'Caracter meetel mayek';
$string['description_charflag_Meetei_Mayek_neg'] = 'Caracter no-meetel-mayek';
$string['description_charflag_Me_neg'] = 'no es signo que encierra';
$string['description_charflag_Mn'] = 'signo que no espacía';
$string['description_charflag_M_neg'] = 'no es signo';
$string['description_charflag_Mn_neg'] = 'no es un signo no-espaciador';
$string['description_charflag_Mongolian'] = 'Caracter mongol';
$string['description_charflag_Mongolian_neg'] = 'no es un caracter mongólico';
$string['description_charflag_Myanmar'] = 'Caracter myanmar';
$string['description_charflag_Myanmar_neg'] = 'Caracter no-myanmar';
$string['description_charflag_N'] = 'número';
$string['description_charflag_Nd'] = 'número decimal';
$string['description_charflag_Nd_neg'] = 'no es número decimal';
$string['description_charflag_Nko'] = 'Caracter Nko';
$string['description_charflag_Nko_neg'] = 'Caracter no-Nko';
$string['description_charflag_Nl'] = 'número en letra';
$string['description_charflag_Nl_neg'] = 'número no-letra';
$string['description_charflag_N_neg'] = 'no es número';
$string['description_charflag_No'] = 'otro número';
$string['description_charflag_No_neg'] = 'no es otro número';
$string['description_charflag_Ogham'] = 'Caracter ogham';
$string['description_charflag_Ogham_neg'] = 'Caracter no-Nko';
$string['description_charflag_Ol_Chiki'] = 'caracter Ol_Chiki';
$string['description_charflag_Ol_Chiki_neg'] = 'caracter no-Ol_Chiki';
$string['description_charflag_Old_Italic'] = 'caracter itálico antiguo';
$string['description_charflag_Old_Italic_neg'] = 'caracter no-itálico-antiguo';
$string['description_charflag_Old_Persian'] = 'caracter persa antiguo';
$string['description_charflag_Old_Persian_neg'] = 'caracter no-persa-antiguo';
$string['description_charflag_Old_Turkic'] = 'caracter turco antiguo';
$string['description_charflag_P'] = 'puntuación';
$string['description_charflag_Pc'] = 'puntuación conectora';
$string['description_charflag_Pc_neg'] = 'no es puntuación conectora';
$string['description_charflag_Pd'] = 'puntuación guión';
$string['description_charflag_Pd_neg'] = 'no es puntuación guión';
$string['description_charflag_Pe'] = 'puntuación de cierre';
$string['description_charflag_Pe_neg'] = 'no es puntuación de cierre';
$string['description_charflag_Pf'] = 'puntuación final';
$string['description_charflag_Pf_neg'] = 'no es puntuación final';
$string['description_charflag_Phoenician'] = 'caracter fenicio';
$string['description_charflag_Pi'] = 'puntuación inicial';
$string['description_charflag_Pi_neg'] = 'no es puntuación inicial';
$string['description_charflag_P_neg'] = 'no es puntuación';
$string['description_charflag_Po'] = 'otra puntuación';
$string['description_charflag_Po_neg'] = 'no es otra puntuación';
$string['description_charflag_print'] = 'un caracter imprimible (incluyendo espacio)';
$string['description_charflag_print_neg'] = 'no es un caracter imprimible (incluyendo espacio)';
$string['description_charflag_Ps'] = 'puntuación abierta';
$string['description_charflag_Ps_neg'] = 'no es puntuación abierta';
$string['description_charflag_punct'] = 'un caracter imprimible (excluyendo letras, dígitos y espacio)';
$string['description_charflag_punct_neg'] = 'no es un caracter imprimible (excluyendo letras, dígitos y espacio)';
$string['description_charflag_Rejang'] = 'Caracter rejang';
$string['description_charflag_Rejang_neg'] = 'Caracter no-rejang';
$string['description_charflag_Runic'] = 'caracter rúnico';
$string['description_charflag_Runic_neg'] = 'caracter no-rúnico';
$string['description_charflag_S'] = 'símbolo';
$string['description_charflag_Samaritan'] = 'Caracter samaritano';
$string['description_charflag_Samaritan_neg'] = 'Caracter no-samaritano';
$string['description_charflag_Saurashtra'] = 'Caracter saurashtra';
$string['description_charflag_Saurashtra_neg'] = 'Caracter no-saurashtra';
$string['description_charflag_Sc'] = 'símbolo de divisa';
$string['description_charflag_Sc_neg'] = 'no es símbolo de divisa';
$string['description_charflag_Shavian'] = 'caracter shaviano';
$string['description_charflag_Shavian_neg'] = 'caracter no-shaviano';
$string['description_charflag_Sinhala'] = 'caracter sinhala';
$string['description_charflag_Sinhala_neg'] = 'caracter no-sinhala';
$string['description_charflag_Sk'] = 'símbolo modificador';
$string['description_charflag_Sk_neg'] = 'no es símbolo modificador';
$string['description_charflag_slashd'] = 'dígito decimal';
$string['description_charflag_slashd_neg'] = 'no es dígito decimal';
$string['description_charflag_slashh'] = 'un caracter de espacio blanco horizontal';
$string['description_charflag_slashh_neg'] = 'no es un caracter de espacio blanco horizontal';
$string['description_charflag_slashs'] = 'un espacio blanco';
$string['description_charflag_slashs_neg'] = 'no es un espacio blanco';
$string['description_charflag_slashv'] = 'un caracter de espacio blanco vertical';
$string['description_charflag_slashv_neg'] = 'no es un caracter de espacio blanco vertical';
$string['description_charflag_slashw'] = 'un caracter de palabra';
$string['description_charflag_slashw_neg'] = 'no es un caracter de palabra';
$string['description_charflag_Sm'] = 'símbolo matemático';
$string['description_charflag_Sm_neg'] = 'no es un símbolo matemático';
$string['description_charflag_S_neg'] = 'no es símbolo';
$string['description_charflag_So'] = 'otro símbolo';
$string['description_charflag_So_neg'] = 'no es otro símbolo';
$string['description_charflag_space'] = 'un espacio blanco';
$string['description_charflag_space_neg'] = 'no es un espacio blanco';
$string['description_charflag_Sundanese'] = 'caracter sudanés';
$string['description_charflag_Sundanese_neg'] = 'caracter no-sudanés';
$string['description_charflag_Tagalog'] = 'Caracter tagalog';
$string['description_charflag_Tamil'] = 'Caracter tamil';
$string['description_charflag_Thai'] = 'Caracter Thai';
$string['description_charflag_Tibetan'] = 'Caracter tibetano';
$string['description_charflag_upper'] = 'una letra MAYÚSCULA';
$string['description_charflag_upper_neg'] = 'no es una letra MAYÚSCULA';
$string['description_charflag_Vai'] = 'Caracter vai';
$string['description_charflag_word'] = 'un caracter palabra';
$string['description_charflag_word_neg'] = 'no es un caracter palabra';
$string['description_charflag_Xan'] = 'cualquier caracter alfanumérico';
$string['description_charflag_Xan_neg'] = 'no es cualquier caracter alfanumérico';
$string['description_charflag_xdigit'] = 'un dígito hexadecimal';
$string['description_charflag_xdigit_neg'] = 'no es un dígito hexadecimal';
$string['description_charflag_Xsp'] = 'cualquier caracter de espacio Perl';
$string['description_charflag_Xsp_neg'] = 'no es cualquier caracter de espacio Perl';
$string['description_charflag_Xwd'] = 'cualquier caracter de "palabra" Perl';
$string['description_charflag_Xwd_neg'] = 'no es cualquier caracter de "palabra" Perl';
$string['description_charflag_Z'] = 'separador';
$string['description_charflag_Zl'] = 'separador de línea';
$string['description_charflag_Zl_neg'] = 'no es separador de línea';
$string['description_charflag_Z_neg'] = 'no es separador';
$string['description_charflag_Zp'] = 'separador de párrafo';
$string['description_charflag_Zp_neg'] = 'no es separador de párrafo';
$string['description_charflag_Zs'] = 'separador de espacio';
$string['description_charflag_Zs_neg'] = 'no es separador de espacio';
$string['description_charset'] = 'uno de los caracteres siguientes: {$a->characters};';
$string['description_charset_neg'] = 'cualquier caracter exceptuando los siguientes: {$a->characters};';
$string['description_charset_neg_one'] = 'no {$a->characters}';
$string['description_charset_range'] = 'cualquier caracter {$a}';
$string['description_circumflex_leaf_assert'] = 'inicio de la cadena';
$string['description_cr_leaf_control'] = 'línea-nueva concuerda con solamente retorno-de-carro';
$string['description_crlf_leaf_control'] = 'línea-nueva concuerda con retorno-de-carro seguido por avance-de-línea';
$string['description_define_node_cond_subexpr'] = 'definición de {$a->firstoperand}';
$string['description_dollar_leaf_assert'] = 'fin de la cadena';
$string['description_empty_leaf_meta'] = 'nada';
$string['description_esc_a_leaf_assert'] = 'inicio de la cadena';
$string['description_esc_b_leaf_assert'] = 'un límite de palabra';
$string['description_esc_b_leaf_assert_neg'] = 'no es un límite de palabra';
$string['description_grouping_node_subexpr'] = 'agrupando: [ {$a->firstoperand} ]';
$string['description_leaf_backref'] = 'texto que concordó con subpatrón #{$a}';
$string['description_leaf_backref_name'] = 'texto que concordó con subpatrón "{$a}"';
$string['description_leaf_options'] = '{$a}:';
$string['description_leaf_subexpr_call_all_recursive'] = 'llamada recursiva de la exresión regular completa';
$string['description_leaf_subexpr_call_name'] = 'llamada del subpatrón "{$a}"';
$string['description_leaf_subexpr_call_name_recursive'] = 'llamada recursiva del subpatrón "{$a}"';
$string['description_leaf_subexpr_call_recursive'] = 'llamada recursiva del subpatrón #{$a}';
$string['description_lf_leaf_control'] = 'línea nueva coincide con alimentación de línea solamente';
$string['description_node_finite_quant_borders_err'] = '(bordes cuantificadores incorrectos)';
$string['description_operand'] = 'operando';
$string['description_option_J'] = 'permitir nombres duplicados';
$string['description_option_m'] = 'concordancia multilínea';
$string['description_option_x'] = 'los espacios blancos en la expresión se ignoraron';
$string['description_quant_lazy'] = '(cuantificador flojo)';
$string['description_quant_possessive'] = '(cuantificador posesivo)';
$string['description_range'] = 'desde {$a->start} hasta {$a->end}';
$string['description_recursion_node_cond_subexpr_all'] = 'todo el patrón está en concordancia recursiva';
$string['description_recursion_node_cond_subexpr_name'] = 'el patrón "{$a->name}" está en concordancia recursiva';
$string['description_small_esc_z_leaf_assert'] = 'fin de la cadena';
$string['description_subexpr_node_subexpr'] = 'subpatrón #{$a->number}: [ {$a->firstoperand} ]';
$string['description_subexpr_node_subexpr_name'] = 'subpatrón "{$a->name}" #{$a->number}: [ {$a->firstoperand} ]';
$string['description_tool'] = 'Descripción';
$string['description_tool_help'] = 'Aquí puede Usted ver la descripción de la expresión regular. Al presionar el nodo del árbol marca en las sub-gráficas correspondientes la parte de la descripción con color amarillo.';
$string['description_unsetoption_i'] = 'sensible minús/MAYÚS';
$string['description_unsetoption_U'] = 'cuantificadores avariciosos por defecto';
$string['description_unsetoption_x'] = 'los espacios blancos en la expresión no fueron ignorados';
$string['description_utf16_leaf_control'] = 'modo UTF-16';
$string['description_utf8_leaf_control'] = 'modo UTF-8';
$string['dollar_leaf_assert'] = 'fin de la cadena';
$string['empty_leaf_meta'] = 'vacío';
$string['engine'] = 'Motor de concordancia';
$string['error_duringauthoringtool'] = 'Hubo errores al tratar de construir {$a}:';
$string['esc_a_leaf_assert'] = 'inicio de la cadena';
$string['esc_b_leaf_assert'] = 'un límite de palabra';
$string['esc_g_leaf_assert'] = 'la primera posición concordante en la cadena';
$string['exactmatch'] = 'Concordancia exacta';
$string['exactmatch_help'] = '<p>Por defecto, la concordancia (coincidencia) de expresión regular regresa verdadero (\'\'true\'\') si hay al menos una concordancia (coincidencia) en la cadena de caracteres (respuesta) dada.</p><p>Configure esto a Si (\'\'Yes\'\'), si Usted escribe expresiones regulares para respuestas completas de estudiantes. El configurar esto a No le da a Usted flexibilidad  adicional; Usted puede especificar una respuesta con calificación baja (o cero) para pescar errores comunes y dar comentarios al respecto. Usted todavía puede especificar concordancias (coincidencias) exactas para algunas de sus expresiones regulares si comienzan con ^ y terminan con $.</p>';
$string['explain_any_char'] = 'Cualquier caracter de';
$string['explain_any_char_except'] = 'Cualquier caracter excepto';
$string['explain_begin'] = 'empezar';
$string['explain_end'] = 'fin';
$string['explain_false'] = 'falso';
$string['explaining_graph_tool'] = 'Gráfica explicativa';
$string['explaining_graph_tool_help'] = 'Aquí puede Usted ver la gráfica explicativa. El presionar el nodo del árbol marca a la subgráfica correspondiente con rectángulo verde oscuro. Usted también puede seleccionar nodos múltiples al mismo tiempo, habilitando el modo de selección en rectángulo.';
$string['explain_true'] = 'cierto';
$string['explain_unknow_meta'] = 'meta desconocida';
$string['fa_matcher'] = 'Autómata de estado finito';
$string['fa_settings_heading'] = 'Configuraciones del motor del autómata de estado finito';
$string['fa_state_limit'] = 'Límite del tamaño del autómata: estados';
$string['fa_state_limit_description'] = 'Le permite a Usted afinar límites de tiempo y memoria para el motor FA al concordar regexes complejos';
$string['fa_transition_limit'] = 'Límite del tamaño del autómata: transiciones';
$string['greedyquant'] = 'Cuantificadores avariciosos';
$string['grouping_node_subexpr'] = 'agrupamiento';
$string['hintcolouredstring'] = 'parte concordada de la respuesta';
$string['hintgradeborder'] = 'Límite de calificación de pista';
$string['hintgradeborder_help'] = 'Las respuestas con calificación menor que el límite de calificación de pista no se usarán para dar pistas.';
$string['hintnextchar'] = 'siguiente caracter correcto';
$string['hintnextlexem'] = 'siguiente correcto {$a}';
$string['langselect'] = 'Idioma (lenguaje)';
$string['langselect_help'] = 'Para la siguiente pista de lexema Usted debería de elegir un idioma o lenguaje, que se usa para partir las respuestas en lexemas. Cada idioma tiene sus propias reglas para lexemas. Los idiomas están definidos usando el bloque de \'Idiomas (lenguajes)  formales\'.';
$string['largefa'] = 'Automatón finito demasiado grande';
$string['lazyquant'] = 'Cuantificadores flojos';
$string['leaf_assert'] = 'aseveración simple';
$string['leaf_charset'] = 'conjunto de caracteres';
$string['leaf_charset_error'] = 'conjunto de caracteres incorrecto';
$string['leaf_charset_except'] = 'cualquier caracter exceptuando';
$string['leaf_charset_neg'] = 'conjunto de caracteres negativo';
$string['leaf_charset_one'] = 'caracter';
$string['leaf_control'] = 'secuencia de control';
$string['leaf_meta'] = 'meta-caracter o secuencia-de-escape';
$string['leaf_options'] = 'modificador';
$string['leaf_subexpr_call'] = 'llamada a subexpresión';
$string['lexemhintpenalty'] = 'Castigo para la siguiente pista de lexema';
$string['lexemusername'] = 'Nombre para el lexema visible-al-estudiante';
$string['lexemusername_help'] = 'Sus estudiantes probablemente no sabrán que una parte atómica (indivisible) del idioma que aprenden se llama  <b>lexema</b>. Ellos podrían preferir llamarle "palabra" o "número" o algo más. Usted podría definir un nombre para lexema que se mostraría en el botón de "Pista de siguiente lexema" aquí.';
$string['maxerrorsshownlabel'] = 'Número máximo de errores mostrados';
$string['missing_subexpr_name_ending_node_error'] = 'Error de sintaxis en nombre del subpatrón';
$string['node_alt'] = 'alternancia';
$string['node_concat'] = 'concadenación';
$string['node_cond_subexpr'] = 'subpatrón condicional';
$string['node_error'] = 'Error de sintaxis';
$string['node_finite_quant'] = 'cuantificador finito';
$string['node_infinite_quant'] = 'cuantificador infinito';
$string['node_subexpr'] = 'subexpresión';
$string['nohintgradeborderpass'] = 'Ninguna respuesta tiene una calificación mayor o igual al límite de calificación de pista (\'\' hint grade border\'\'). Esto deshabilita las pistas.';
$string['nosubexprcapturing'] = 'El motor {$a} no soporta captura de subpatrones; por favor, quite los sustituibles (\'\'placeholders\'\') (excepto {$0}) de la retroalimentación o elija otro motor';
$string['notation'] = 'Notación de expresión regular';
$string['notation_mdlshortanswer'] = 'Respuesta corta de Moodle';
$string['notation_native'] = 'Expresión regular';
$string['notation_pcreextended'] = 'Expresión regular (extendida)';
$string['objectname'] = 'pregunta';
$string['onceonly_node_subexpr'] = 'subpatrón solamente-una-vez';
$string['php_preg_matcher'] = 'Extensión Preg PHP';
$string['pluginname'] = 'Expresión regular';
$string['pluginnameadding'] = 'Añadiendo una pregunta de expresión regular';
$string['pluginnameediting'] = 'Editando una pregunta de expresión regular';
$string['pluginname_help'] = '<p>Expresiones regulares son una forma de patrones de escritura para concordar con diferentes cadenas de texto. Usted puede usarla para verificar respuestas en dos formas: una expresión a concordar (coincidir) con una respuesta completa (usualmente correcta), o una expresión a concordar (coincidir) con una parte de la respuesta (que puede ser usada, por ejemplo, para detectar errores comunes y dar los comentarios apropiados).
</p><p>Esta pregunta usa la sintaxis de expresiones regulares compatibles-con-perl de PHP como su notación por defecto. Hay muchos tutoriales acerca de la creación y el uso de expresiones regulares; aquí hay un: <a href="http://www.phpfreaks.com/content/print/126">ejemplo</a>. Usted puede encontrar la sintaxis detallada de expresiones regulares aquí: <a href="http://www.nusphere.com/kb/phpmanual/reference.pcre.pattern.syntax.htm">manual de PHP</a>.
Tome nota de que Usted no debería de encerrar las expresiones regulares dentro de delimitadores ni tampoco especificar ningún modificador - Moodle lo hará por Usted.
</p><p>Usted también puede usar esta pregunta como la forma avanzada de respuesta-corta con pistas, ¡aún cuando usted no sepa ni jota acerca de expresiones regulares ! Simplemente seleccione  <b>Moodle respuestacorta</b> como la notación para sus preguntas.</p>';
$string['pluginnamesummary'] = 'Escriba una respuesta en una cadena de texto del estudiante, que pueda parearse contra varias expresiones regulares- Le muestra al estudiante la parte correcta de su respuesta. Usando comportamiento con intentos múltiples puede dar una pista al decir el siguiente caracter o \'lexem\'.<br/> Usted puede usarlo sin conocimiento acerca de expresiones regulares, para obtener pistas al usar la notación de \'Moodle shortanswer\' (respuestacorta de Moodle).';
$string['possessivequant'] = 'Cuantificadores posesivos';
$string['questioneditingheading'] = 'Configuraciones para editar preguntas';
$string['recursion_node_cond_subexpr'] = 'subpatrón condicional recursivo';
$string['regex_handler'] = 'Manejador regex';
$string['slash_at_end_of_pattern_node_error'] = 'Error de sintaxis: al final del patrón.';
$string['small_esc_z_leaf_assert'] = 'fin de la cadena';
$string['subexpression'] = 'Subexpresión';
$string['subexpr_name_expected_node_error'] = 'Se esperaba nombre del subpatrón';
$string['subexpr_node_subexpr'] = 'subexpresión';
$string['syntax_tree_tool'] = 'Árbol de sintaxis';
$string['syntax_tree_tool_collapsing_mode'] = 'Modo colapsante';
$string['syntax_tree_tool_help'] = 'Aquí puede Usted ver el árbol de sintaxis de su expresión. El presionar sobre del nodo del árbol marca a los sub-árboles correspondientes, la subgráfica y la parte correspondiente de la descripción. Usted tambien puede colapsar / expandir los nodos al activar convolución (\'\'convolution\'\').';
$string['tobecontinued'] = '...';
$string['toolargequant'] = 'Cuantificador finito demasiado grande';
$string['toomanyerrors'] = '.......{$a} errores más';
$string['unallowedhint'] = 'La pista seleccionada no está permitida debido a restricciones en las configuraciones de la pregunta. Por favor, configure "Permitir pista {$a} Allow hinting" a "si (yes) " para permitirlot. El motor de concordancia seleccionado podría afectar la disponibilidad de pistas';
$string['unexisting_subexpr_node_error'] = 'El subpatrón "{$a->addinfo}"no existe.';
$string['ungreedyquant'] = 'Cuantificadores no-codiciosos';
$string['unknown_error_node_error'] = 'error desconocido';
$string['unknown_unicode_property_node_error'] = 'Propiedad Unicode desconocida: {$a->addinfo}.';
$string['unrecognized_pqh_node_error'] = 'Caracter no-reconocido después de (? o (?-';
$string['unrecognized_pqlt_node_error'] = 'Caracter no-reconocido después de (?<';
$string['unrecognized_pqp_node_error'] = 'Caracter no-reconocido después de (?P';
$string['unsupported'] = '{$a->nodename} en posición desde {$a->linefirst}:{$a->colfirst} hasta {$a->linelast}:{$a->collast} no está soportado por {$a->engine}.';
$string['unsupported_modifier_node_error'] = 'Modificador(es) desconocido(s), equivocado(s) o no-soportado(s) : {$a->addinfo}.';
$string['usecharhint'] = 'Permitir pista siguiente letra';
$string['usecharhint_help'] = 'En comportamientos que permiten intentos múltiples (como por ejemplo, adaptativo o interactivo) se les muestra a los estudiantes el botón para \'Pista de la letra siguiente\' que les permite obtener una pista de una letra con la aplicación del \'Castigo por letra siguiente\'. No todos los motores de concordancia soportan el dar pistas.';
$string['usehint_help'] = 'En comportamientos que permiten intentos múltiples (como por ejemplo, adaptativo o interactivo) se les muestra a los estudiantes el botón para \'Pista de la letra siguiente\' que les permite obtener una pista de una letra con la aplicación del \'Castigo por letra siguiente\'. No todos los motores de concordancia soportan el dar pistas.';
$string['uselexemhint'] = 'Permitir la pista del siguiente lexema (palabra, número, signo de puntuación)';
$string['uselexemhint_help'] = '<p>En comportamientos que permiten intentos múltiples (como por ejemplo adaptativo o interactivo) les muestra a los estudiantes el botón para \'Pista de palabra siguiente\' que les permite obtener una pista, ya sea completando el lexema actual o mostrar el siguiente si el lexema está completo, con la aplicación del \'Castigo del siguiente lexema\'. No todos los motores de concordancia soportan dar pistas.</p><p><b>Lexema</b> es una parte atómica (indivisible) de un idioma: una palabra, número, signo de puntuación, operador, etc.</p>';
