<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'offlinequiz', language 'es_mx', branch 'MOODLE_26_STABLE'
 *
 * @package   offlinequiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add'] = 'Añadir';
$string['addaquestion'] = 'Añadir una pregunta ...';
$string['addarandomquestion'] = 'Añadir preguntas aleatoriamente';
$string['addarandomquestion_help'] = 'Moodle añade una selección aleatoria de preguntas de opción múltiple (o preguntas de opción múltiple todo-o-nada) al grupo del examen fuera-de-línea actual. El número de preguntas añadidas puede configurarse. Las preguntas son elegidas de la categoría de preguntas actual (y, si estuviera seleccionada, de la sub-categoría).';
$string['addlist'] = 'Añadir lista';
$string['addnewpagesafterselected'] = 'Añadir saltos de página después de las preguntas seleccionadas';
$string['addnewquestionsqbank'] = 'Añadir preguntas a la categoría {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Añadir anulación de usuario';
$string['addpagehere'] = 'Añadir página aquí';
$string['addparts'] = 'Añadir participantes';
$string['addrandom'] = 'Añadir aleatoriamente {$a} pregunta(s) de opción múltiple';
$string['addrandomfromcategory'] = 'Añadir preguntas aleatoriamente';
$string['addtoofflinequiz'] = 'Añadir a examen fuera-de-línea';
$string['addtoqueue'] = 'Añadir a la cola';
$string['allinone'] = 'Ilimitado(a)';
$string['alllists'] = 'Todas las listas';
$string['allresults'] = 'Mostrar todos los resultados';
$string['allstudents'] = 'Mostrar todos los estudiantes';
$string['alwaysavailable'] = 'Siempre disponible';
$string['analysis'] = 'Análisi de ítems';
$string['answerform'] = 'Formato para respuestas';
$string['answerformforgroup'] = 'Formato de respuesta para el grupo {$a}';
$string['answerpdfxy'] = 'Formato para respuestas ({$a}->maxquestions questions / {$a}->maxanswers options)';
$string['areyousureremoveselected'] = '¿Está seguro de querer remover todas las preguntas seleccionadas?';
$string['attemptexists'] = 'Existen intentos';
$string['attemptsexist'] = 'Usted ya no puede añadir o quitar preguntas';
$string['attemptsnum'] = 'Resultados: {$a}';
$string['attemptsonly'] = 'Mostrar solamente estudiantes con resultados';
$string['attendances'] = 'Asistentes';
$string['basicideasofofflinequiz'] = 'Las ideas básicas de hacer preguntas fuera-de-línea';
$string['bulksavegrades'] = 'Guardar calificaciones';
$string['calibratescanner'] = 'Calibrar \'\'scanner\'\'';
$string['cannoteditafterattempts'] = 'Usted no puede añadir o quitar preguntas porque ya hay resultados completados. ({$a})';
$string['category'] = 'Categoría';
$string['changed'] = 'Se han cambiado los resultados.';
$string['checkparts'] = 'Marcar a los participantes seleccionados como presentes';
$string['checkuserid'] = 'Revisar ID de grupo/usuario';
$string['chooseagroup'] = 'Elegir un grupo ...';
$string['closebeforeopen'] = 'No pudo actualizarse el examen fuera-de-línea. Usted ha especificado una fecha de cierre anterior a la fecha de apertura.';
$string['closestudentview'] = 'Elegir Vista de estudiante';
$string['closewindow'] = 'Cerrar ventana';
$string['cmmissing'] = 'Falta el módulo del curso para el examen fuera-de-línea con ID {$a';
$string['configdecimalplaces'] = 'Número de dígitos que deberían mostrarse después del punto decimal al mostrar calificaciones para el examen fuera-de-línea.';
$string['configintro'] = 'Los valores que Usted configure aquí son usados como valores por defecto para las configuraciones de los nuevos exámenes fuera-de-línea.';
$string['configkeepfilesfordays'] = 'Determinar por cuantos días se conservan los archivos de imágenes subidas en el almacenamiento temporal. Durante este tiempo, los archivos de imágenes están disponibles en el reporte de la administración del examen fuera-de-línea.';
$string['configonlylocalcategories'] = 'No se permiten categorías de preguntas compartidas.';
$string['configpapergray'] = 'valor-gris del papel';
$string['configshuffleanswers'] = 'Barajear respuestas';
$string['configshufflequestions'] = 'Si Usted habilita esta opción, entonces el orden de las preguntas en los grupos de examen fuera-de-línea serán barajados aleatoriamente cada vez que Usted re-cree la vista previa en la pestaña de "Crear formato".';
$string['configshufflewithin'] = 'Si Usted habilita esta opción, entonces las partes que componen las preguntas individuales se barajarán aleatoriamente cuando sean creados los formatos de pregunta y los formatos de respuesta.';
$string['configuseridentification'] = 'Una fórmula que describe la identificación del usuario. Esta fórmula es usada para asignar formatos de respuestas a usuarios en el sistema.';
$string['copy'] = 'Copiar';
$string['copyright'] = '<strong>Advertencia: ¡ Los textos en esta página son solamente para su información personal. Al igual que otros textos, estas preguntas están protegidas por Reserva de Derechos de Autor (\'\'copyright\'\') Usted no tiene permitido copiarlas ni mostrarlas a otras personas  !</strong>';
$string['copyselectedtogroup'] = 'Añadir preguntas seleccionadas al grupo: {$a}';
$string['copytogroup'] = 'Añadir todas las preguntas al grupo: {$a}';
$string['correct'] = 'correcto';
$string['correcterror'] = 'resolver';
$string['correctforgroup'] = 'Respuestas correctas para el Grupo {$a}';
$string['correctionoptionsheading'] = 'Opciones para corrección';
$string['correctupdated'] = 'Formato actualizado para corrección del grupo {$a}';
$string['couldnotgrab'] = 'No se pudo capturar la imagen {$a}';
$string['couldnotregister'] = 'No se pudo registrar al usuario {$a}';
$string['createlistfirst'] = 'Añadir participantes';
$string['createofflinequiz'] = 'Crear formatos';
$string['createpartpdferror'] = 'El formato PDF para la lista de participantes {$a} no se pudo crear. La lista podría estar vacía.';
$string['createpdf'] = 'Formato PDF';
$string['createpdferror'] = 'No pudo crearse el formato para el grupo {$a} . Posiblemente no haya preguntas en el grupo.';
$string['createpdffirst'] = 'Crear primeramente lista PDF';
$string['createpdfforms'] = 'Crear formatos';
$string['createpdfs'] = 'Formatos PDF';
$string['createpdfsparticipants'] = 'Formatos PDF para listas de participantes';
$string['createquestionandadd'] = 'Crear una pregunta nueva y añadirla al examen.';
$string['createquiz'] = 'Crear formatos';
$string['csvfile'] = 'Archivo CSV';
$string['CSVformat'] = 'Formato CSV';
$string['CSVplus1format'] = 'Formato CSV (datos crudos)';
$string['darkgray'] = 'Gris oscuro';
$string['datanotsaved'] = 'No se pudieron guardar las configuraciones';
$string['decimalplaces'] = 'Número de decimales';
$string['decimalplaces_help'] = 'Número de dígitos que deberían mostrarse después del punto decimal al mostrar calificaciones para el examen fuera-de-línea.';
$string['deletelistcheck'] = '¿Realmente desea eliminar la lista seleccionada y a todos sus participantes?';
$string['deletepagecheck'] = '¿Realmente desea eliminar las páginas seleccionadas?';
$string['deletepagesafterselected'] = 'Remover saltos de página después de las preguntas seleccionadas';
$string['deletepartcheck'] = '¿Realmente desea eliminar los participantes seleccionados?';
$string['deleteparticipantslist'] = 'Eliminar lista de participantes';
$string['deletepdfs'] = 'Eliminar documentos';
$string['deleteresultcheck'] = '¿Realmente desea eliminar los resultados seleccionados?';
$string['deleteselectedpart'] = 'Eliminar participantes seleccionados';
$string['deleteselectedresults'] = 'Eliminar resultados seleccionados';
$string['deletethislist'] = 'Eliminar esta lista';
$string['deleteupdatepdf'] = 'Eliminar y actualizar formatos-PDF';
$string['difficultytitle'] = 'Dificultad';
$string['difficultytitlea'] = 'Dificultad A';
$string['difficultytitleb'] = 'Dificultad B';
$string['difficultytitlediff'] = 'Diferencia';
$string['displayoptions'] = 'Mostrar opciones';
$string['done'] = 'hecho';
$string['downloadpartpdf'] = 'Descargar archivo PDF para la lista \'{$a}\'';
$string['downloadpdfs'] = 'Descargar documentos';
$string['downloadresultsas'] = 'Descargar resultados como:';
$string['editgroupquestions'] = 'Editar pregunas del grupo';
$string['editgroups'] = 'Editar grupos fuera-de-línea';
$string['editingofflinequiz'] = 'Editando preguntas del grupo';
$string['editingofflinequiz_help'] = 'Al crear un examen fuera-de-línea, los conceptos principales son :
*
* El examen fuera-de-línea, que contiene las preguntas en una o más páginas
* El banco de preguntas, que almacena copias de todas las preguntas organizadas en categorías';
$string['editlist'] = 'Editar lista';
$string['editlists'] = 'Editar listas';
$string['editofflinequiz'] = 'Editar examen fuera-de-línea';
$string['editofflinesettings'] = 'Editar configuraciones fuera-de-línea';
$string['editorder'] = 'Editar orden';
$string['editparticipants'] = 'Editar participantes';
$string['editquestions'] = 'Editar preguntas';
$string['editscannedform'] = 'Editar formato escaneado';
$string['editthislist'] = 'Editar esta lista';
$string['emptygroups'] = 'Algunos grupos de exámenes fuera-de-línea están vacíos. Por favor, añada algunas preguntas.';
$string['enroluser'] = 'Inscribir usuario';
$string['erroraccessingreport'] = 'Usted no tiene permitido ver este reporte.';
$string['errorreport'] = 'Reporte de errores de importación';
$string['everythingon'] = 'habilitado';
$string['Excelformat'] = 'Formato Excel';
$string['fileformat'] = 'Formato para hojas de pregunta';
$string['fileformat_help'] = 'Elija si quiere sus hojas de preguntas en formato PDF o formato DOCX. Los formatos de respuesta y las hojas para corrección siempre se generarán en formato PDF.';
$string['filesizetolarge'] = 'Algunos de sus archivos de imágenes son muy grandes. Las dimensiones serán re-dimensionadas durante la interpretación. Por favor, intente escanear con una resulución de entre 200 y 300 dpi (puntos por pulgada) y en el modo de blanco y negro. Esto acelerará la interpretación la próxima vez.';
$string['fontsize'] = 'Tamaño de letra';
$string['forautoanalysis'] = 'Para análisis automático';
$string['formforcorrection'] = 'Formato para corrección del grupo {$a}';
$string['formforgroup'] = 'Formato de preguntas para grupo {$a}';
$string['formforgroupdocx'] = 'Formato de preguntas para grupo {$a} (DOCX)';
$string['formsexist'] = 'Los formatos ya estan creados.';
$string['formsheetsettings'] = 'Configuraciones del formato';
$string['formspreview'] = 'Vista previa para formatos';
$string['formwarning'] = 'No hay un formato de respuesta definido. Por favor, contacte a su administrador.';
$string['functiondisabledbysecuremode'] = 'Esta fucionalidad actualmente está deshabilitada';
$string['generalfeedback'] = 'Retroalimentación general';
$string['generalfeedback_help'] = 'La retroalimentación general es el texto que se les muestra a los estudiantes después del intento de reponder a una pregunta. A diferencia de la retroalimentación para una respuesta específica, siempre se muestra la misma retroalimentación general.';
$string['generatepdfform'] = 'Generar formato PDF';
$string['grade'] = 'Cañlificación';
$string['gradedon'] = 'Calificado en';
$string['gradedscannedform'] = 'Formato escaneado con calificaciones';
$string['gradeiszero'] = 'Nota: ¡ La calificación máxima para este examen es de 0 puntos !';
$string['gradeswarning'] = '¡ Las calificaciones de preguntas deben de ser números !';
$string['gradewarning'] = '¡ La calificaciones de pregunta debe de ser un número !';
$string['gradingofflinequiz'] = 'Calificaciones';
$string['gradingoptionsheading'] = 'Opciones para calificar';
$string['greeniscross'] = 'contada como una cruz';
$string['group'] = 'Grupo';
$string['groupoutofrange'] = 'El grupo estaba fuera del rango y se remplazó con grupo A.';
$string['groupquestions'] = 'Preguntas del Grupo';
$string['hasresult'] = 'Existen resultados';
$string['idnumber'] = 'Número ID';
$string['imagefile'] = 'Archivo de imagen';
$string['imagenotfound'] = '¡Archivo de imagen: {$a} no encontrado!';
$string['imagenotjpg'] = 'La imagen no es .JPG ni .PNG: {$a}';
$string['imagickwarning'] = 'Falta imagick: Pídale a su administrador del sistema que instale la librería (biblioteca) de imágenes magick y que revise la ruta hacia el binario para convertir en las configuraciones de su filtro de notación TeX. ¡ Usted no puede importar archivos TIF si no tiene imagick (http://www.imagemagick.org/) para las imágenes !';
$string['import'] = 'Importar';
$string['importedon'] = 'Importado en';
$string['importerror11'] = 'Existen otros resultados';
$string['importerror12'] = 'Usuario no registrado';
$string['importerror13'] = 'Sin datos del grupo';
$string['importerror14'] = 'No pudo obtenerse';
$string['importerror15'] = 'Marcas inseguras';
$string['importerror16'] = 'Error en página';
$string['importerror17'] = 'Páginas incompletas';
$string['importerror21'] = 'No pudo obtenerse';
$string['importerror22'] = 'Marcas inseguras';
$string['importerror23'] = 'Usuario no está en lista';
$string['importerror24'] = 'Lista no detectada';
$string['importforms'] = 'Importar formatos de respuesta';
$string['importfromto'] = 'Importando de {$a->from} a {$a->to} de {$a->total}.';
$string['import_help'] = '<p>
Usted puede importar archivos de imágenes escaneadas individuales, o varios archivos de varias imágenes escaneadas dentro de un archivo ZIP. El módulo de examen fuera-de-línea procesará los archivos de imágenes en segundo plano (\'\'in the background\'\').
Los nombres de los archivos no son relevantes, pero no deben de contener caracteres especiales, como diéresis ni acentos ni eñes. Las imágenes deben de ser .GIF o .PNG o .TIF. Se  recomienda una resolución de entre 200 y 300 dpi (puntos por pulgada).</p>';
$string['importisfinished'] = 'LA importación del examen  fuera-de-línea {$a} está terminada.';
$string['importlinkresults'] = 'Enlace hacia resultados: {$a}';
$string['importlinkverify'] = 'Enlace hacia verificación: {$a}';
$string['importmailsubject'] = 'Notificación de importación de examen fuera-de-línea';
$string['importnumberexisting'] = 'Número de formatos dobles: {$a}';
$string['importnumberpages'] = 'Número de páginas importadas exitosamente: {$a}';
$string['importnumberresults'] = 'Número de importadas : {$a}';
$string['importnumberverify'] = 'Número de formatos que necesitan verificación: {$a}';
$string['importtimefinish'] = 'Proceso terminado: {$a}';
$string['importtimestart'] = 'Proceso iniciado: {$a}';
$string['inconsistentdata'] = 'Datos inconsistentes: {$a}';
$string['info'] = 'Información';
$string['infoshort'] = 'i';
$string['insecuremarkings'] = 'Las marcas inseguras necesitan corrección manual';
$string['insecuremarkingsforquestion'] = 'Las marcas inseguras necesitan corrección manual para preguntas';
$string['insertnumber'] = 'Por favor, inserte el número de identificación correcto enmarcado por el marco azul.';
$string['instruction1'] = 'El formato de respuesta será escaneado automáticamente. Por favor, no lo doble ni lo arrugue. Use una pluma negra o azul para marcar los campos.';
$string['instruction2'] = '¡Solamente las anotaciones de respuestas claras pueden interpretarse correctamente! Si Usted quiere corregir una anotación, llene completamente la casilla con color. Este campo será entonces interpretado como una caja vacía:';
$string['instruction3'] = 'Las cajas corregidas no pueden volverse a marcar. Por favor, no escriba nada afuera de las cajas.';
$string['introduction'] = 'Introducción';
$string['invigilator'] = 'Supervisor';
$string['ischecked'] = 'La participación está seleccionada';
$string['isnotchecked'] = 'La participación no está seleccionada';
$string['itemdata'] = 'Itemdata';
$string['keepfilesfordays'] = 'Conservar archivos por días';
$string['lightgray'] = 'Gris claro';
$string['linktoscannedform'] = 'Ver formato escaneado';
$string['listnotdetected'] = '¡ No pudo detectarse el código de barras para la lista !';
$string['logdeleted'] = 'Entrada de bitácora {$a} eliminada.';
$string['logourl'] = 'URL del logo';
$string['logourldesc'] = 'URL de un archivo de imagen a mostrar en la esquia superior derecha de los formatos de respuesta. <b>El tamaño máximo permitido es de 520 por 140 pixeles</b>. ¡ Los formatos de respuesta no pueden ser evaluados si la imagen excede el tamaño máximo !';
$string['lowertrigger'] = 'Segundo límite inferior';
$string['lowertriggerzero'] = 'El Segundo límite inferior es cero';
$string['lowerwarning'] = 'Primer límite inferior';
$string['lowerwarningzero'] = 'El Primer límite inferior es cero';
$string['marginwarning'] = '¡ Por favor, imprima los siguientes archivos PDF sin márgenes adicionales !<br /> Evite el entregarle fotocopias a los estudiantes. Si Usted tiene dudas, ordénele copias al equipo de soporte.';
$string['marks'] = 'Puntuación';
$string['matrikel'] = 'Número de estudiantes';
$string['maxgradewarning'] = '¡La calificación máxima debe de ser un número !';
$string['missingimagefile'] = 'Falta archivo de imagen';
$string['missingitemdata'] = 'Respuesta(s) faltante(s) para usuario {$a}';
$string['missinglogdata'] = 'Datos de bitácora faltantes para los resultados existentes.';
$string['missingquestion'] = 'Al parecer ya no existe la pregunta';
$string['missinguserid'] = '¡Falta número de identificación del usuario! ¡No se pudo leer el código de barras!';
$string['modulename'] = 'Examen Fuera-de-línea';
$string['modulename_help'] = 'Este módulo le permite al profesor diseñar exámenes fuera-de-línea que consisten de preguntas de opción múltiple. Estas preguntas se guardan en el Banco de preguntas de Moodle y pueden reusarse dentro de cursos y compartirse entre cursos.
Los exámenes fuera-de-línea pueden descargarse como archivos PDF. Los estudiantes marcan sus preguntas en hojas de formatos. LAs hojas de formatos son escaneadas y las respuestas son importadas al sistema.
Para más información, vea http://offline-tests.univie.ac.at';
$string['modulenameplural'] = 'Exámenes Fuera-de-línea';
$string['moodleprocessing'] = 'Permitir que Moodle procese los datos';
$string['movecorners'] = 'Cambie primeramente las posiciones de las marcas de esquina. Use arrastrar y soltar.';
$string['moveselectedonpage'] = 'Mover preguntas seleccionadas a la página: {$a}';
$string['multianswersforsingle'] = 'Respuestas múltiples para preguntas de opción única';
$string['multichoice'] = 'Opción múltiple';
$string['multipleanswers'] = 'Elegir al menos una respuesta.';
$string['name'] = 'Nombre del Examen fuera-de-línea';
$string['neededcorrection'] = '<strong>Atención: Algunas de sus anotaciones necesitaron corrección manual. Vea los cuadros rojos en la siguiente imagen.
<br />¡Esto implicó intervención manual por un profesor y retrasó la publicación de los resultados del examen fuera-de-línea!</strong>';
$string['newgrade'] = 'Calificado';
$string['newpage'] = 'Página nueva';
$string['noattemptexists'] = 'No existen resultados';
$string['noattempts'] = '¡ Sin resultados importados !';
$string['noattemptsonly'] = 'Mostra solamente estudiantes sin resultados';
$string['nocourse'] = 'El curso con id {$a->course} al que pertenece el examen fuera-de-línea con ID {$a->offlinequiz} falta.';
$string['nogradesseelater'] = 'Este examen todavía no ha sido calificado para {$a}. Los resultados se publicarán aquí.';
$string['nogroupdata'] = 'No hay datos de grupo para el usuario {$a}';
$string['nomcquestions'] = '¡ No hay preguntas de opción múltiple dentro del grupo {$a} !';
$string['noofflinequiz'] = 'No hay examen fuera-de-línea con id {$a}!';
$string['nopages'] = 'No se importaron páginas';
$string['noparticipantsfound'] = 'No se encontraron participantes';
$string['nopdfscreated'] = '¡ No se crearon documentos !';
$string['noquestions'] = 'Algunos grupos de exámenes fuera-de-línea están vacíos. Por favor, añada algunas preguntas.';
$string['noquestionselected'] = '¡ No se encontraron preguntas !';
$string['noquestionsfound'] = '¡ No hay preguntas en el grupo {$a}!';
$string['noquestionsonpage'] = 'Página vacía';
$string['noresults'] = 'No hay resultados.';
$string['noreview'] = 'Usted no tiene permitido revisar este examen fuera-de-línea';
$string['noscannedpage'] = '¡No hay página escaneada con ID {$a}!';
$string['notxtfile'] = 'No hay archivo TXT';
$string['notyetgraded'] = 'Todavía sin calificar';
$string['nozipfile'] = 'No hay archivo ZIP';
$string['numattempts'] = 'Número de resultados importados: {$a}';
$string['numattemptsqueue'] = '{$a} formatos de respuestas añadidos a la cola. Se enviará un Email a su dirección después del procesamiento de los datos.';
$string['numattemptsverify'] = 'Formatos escaneados esperando corrección: {$a}';
$string['numberformat'] = '¡El valor debe ser un número con {$a} dígitos!';
$string['numbergroups'] = 'Número de grupos';
$string['numpages'] = '{$a} páginas importadas';
$string['numquestionsx'] = 'Preguntas: {$a}';
$string['numusersadded'] = '{$a} participantes añadidos';
$string['ODSformat'] = 'Formato ODS';
$string['offlineimplementationfor'] = 'Implementación fuera-de-línea para';
$string['offlinequiz:addinstance'] = 'Añadir un examen Fuera-de-línea';
$string['offlinequiz:attempt'] = 'Intentar exámenes';
$string['offlinequizcloses'] = 'El examen fuera-de-línea se cierra en';
$string['offlinequizcloseson'] = 'La revisión para este examen fuera-de-línea se cierra en {$a}';
$string['offlinequiz:createofflinequiz'] = 'Crear formatos de examen fuera-de-línea';
$string['offlinequiz:deleteattempts'] = 'Eliminar resultados de examen fuera-de-línea';
$string['offlinequiz:grade'] = 'Calificar manualmente exámenes fuera-de-línea';
$string['offlinequizisclosed'] = 'Examen fuera-de-línea cerrado';
$string['offlinequizisclosedwillopen'] = 'Examen fuera-de-línea cerrado (se abre en {$a})';
$string['offlinequizisopen'] = 'Este examen fuera-de-línea está abierto';
$string['offlinequizisopenwillclose'] = 'Examen fuera-de-línea abierto (se cierra en {$a})';
$string['offlinequiz:manage'] = 'Gestionar Exámenes fuera-de-línea';
$string['offlinequizopenedon'] = 'Este examen fuera-de-línea se abrió en {$a}';
$string['offlinequizopens'] = 'Examen fuera-de-línea se abre';
$string['offlinequiz:preview'] = 'Previsualizar Exámenes fuera-de-línea';
$string['offlinequizsettings'] = 'Configuraciones de Examen fuera-de-línea';
$string['offlinequiz:view'] = 'Ver información sobre Exámenes fuera-de-línea';
$string['offlinequiz:viewreports'] = 'Ver reportes de Exámenes fuera-de-línea';
$string['offlinequizwillopen'] = 'Examen Fuera-de-línea se abre en {$a}';
$string['oneclickenrol'] = 'Inscripción de 1-Click';
$string['oneclickenroldesc'] = 'Si se activa esta opción, los profesores tienen la posibilidad de inscribir usuarios con un click al corregir los formatos de respuesta (error de "Usuario no está en el curso").';
$string['oneclickrole'] = 'Rol para Inscripción de 1-Click';
$string['oneclickroledesc'] = 'Elija el rol usado para la inscripción de 1-Click. Solamente pueden seleccionarse roles que tengan el arquetipo "estudiante".';
$string['onlylocalcategories'] = 'Solamente categorías locales de preguntas';
$string['orderandpaging'] = 'Orden y Paginación';
$string['orderandpaging_help'] = 'Los números 10, 20, 30, ... opuestos a cada pregunta indican el orden de las preguntas. Los números aumentan en escalones de 10 en 10 para dejarle espacio para insertar preguntas adicionales. Para reordenar las preguntas, cambie  los números y después elija el botón para "Reordenar preguntas".

Para añadir saltos de página después de ciertas preguntas en particular, active las casillas junto a las preguntas y después elija el botón para "Añadir saltos de página después de las preguntas seleccionadas".

Para arreglar las preguntas sobre un número de página, elija el botón para \'Repaginar\' y seleccione el número requerido de preguntas por página.';
$string['orderingofflinequiz'] = 'Orden y Paginación';
$string['otherresultexists'] = '¡Ya existen resultados diferentes para {$a}, importación ignorada! Primero elimine los resultados.';
$string['outof'] = '{$a->grade} de un máximo de {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Retroalimentación global';
$string['overview'] = 'Vista general';
$string['overviewdownload_help'] = '';
$string['pagecorrected'] = 'Hoja corregida de lista de participantes importada';
$string['pageimported'] = 'Hoja de lista de participantes importada';
$string['page-mod-offlinequiz-edit'] = 'Editar página de examen fuera-de-línea';
$string['page-mod-offlinequiz-x'] = 'Cualquier página de examen fuera-de-línea';
$string['pagenotdetected'] = '¡No pudo detectarse código de barras para la página!';
$string['pagenumberimported'] = 'Hoja {$a} de lista de participantes importada';
$string['pagesizeparts'] = 'Participantes mostrados por página';
$string['papergray'] = 'Valor de blancura del papel';
$string['papergray_help'] = 'Si las partes blancas de sus formatos de respuestas escaneados están muy oscuras, Usted puede corregirlas al configurar este valor a gris oscuro.';
$string['participants'] = 'Participantes';
$string['participants_help'] = '<p>Las listas de participantes están diseñadas para exámenes fuera-de-línea grandes, con muchos participantes. Las listas le ayudan al profesor para revisar cuales estudiantes participaron en el examen y ver si los resultados se importaron correctamente.
Usted puede añadirle usuarios a listas diferentes. Cada lista podría, por ejemplo, tener a los participantes de un salón particular. Los participantes pueden ser miembros de un grupo especial. Puede usarse una herramienta para registro de grupo para crear estos grupos.
Las listas de participantes pueden descargarse como documentos PDF, imprimirse y marcarse con cruces de la misma manera que los formatos de respuesta de los exámenes fuera-de-línea. Después, se pueden subir a Moodle y los estudiantes marcados serán marcados como presentes en la BasedeDatos. Por favor evite las manchas en los códigos de barras, ya que se usan para identificar a los estudiantes.</p>';
$string['participantsinlists'] = 'Participantes en listas';
$string['participantslist'] = 'Lista de participantes';
$string['participantslists'] = 'Participantes';
$string['partimport'] = 'Actualizando listas de participantes';
$string['partimport_help'] = '<p>
En esta pestaña Usted puede subir las listas completadas de los participantes. Usted puede subir archivos de imágenes escaneadas individuales, o varios archivos de varias imágenes escaneadas dentro de un archivo ZIP. El módulo de examen fuera-de-línea procesará los archivos de imágenes en segundo plano (\'\'in the background\'\').
Los nombres de los archivos no son relevantes, pero no deben de contener caracteres especiales, como diéresis ni acentos ni eñes. Las imágenes deben de ser .GIF o .PNG o .TIF. Se  recomienda una resolución de entre 200 y 300 dpi (puntos por pulgada).</p>';
$string['pdfdeletedforgroup'] = 'Formato para grupo {$a} eliminado';
$string['pdfintro'] = 'Información adicional';
$string['pdfintro_help'] = 'Esta información se imprimirá en la primera página de la hoja de respuestas y debería de contener información general acerca de como llenar el formato de respuestas.';
$string['pdfintrotext'] = '<b>¿Cómo lo contesto correctamente??</b><br />Este formato de respuesta será escaneado automáticamente. Por favor, no lo doble ni lo arrugue. Use una pluma negra o azul para marcar los campos. Si Usted quiere corregir una respuesta, llene completamente la casuilla con color. Ese campo será entonces interpretado cpmo una casilla vacía.<br />';
$string['pdfintrotoolarge'] = 'La introducción es demasiado arga (máximo 2000 caracteres).';
$string['pdfscreated'] = 'Se crearon los formatos PDF';
$string['pdfsdeletedforgroup'] = 'Formatos para grupo {$a} eliminados';
$string['pearlywhite'] = 'Blanco perlado';
$string['pluginadministration'] = 'Adminsitración del examen fuera-de-línea';
$string['pluginname'] = 'Examen_fuera_de_línea';
$string['point'] = 'punto';
$string['present'] = 'presente';
$string['preview'] = 'Vista previa';
$string['previewforgroup'] = 'Vista previa para grupo {$a}';
$string['previewquestion'] = 'Previsualizar pregunta';
$string['questionanalysis'] = 'Análisis de dificultad';
$string['questionanalysistitle'] = 'Tabla de Análisis de dificultad';
$string['questionbankcontents'] = 'Contenidos del banco de preguntas';
$string['questionname'] = 'Nombre de la pregunta';
$string['questionsheet'] = 'Hoja de preguntas';
$string['questionsin'] = 'Preguntas en';
$string['questionsingroup'] = 'Preguntas en el grupo';
$string['questionsinthisofflinequiz'] = 'Preguntas en este examen fuera-de-línea';
$string['questiontextisempty'] = '[Texto de pregunta vacía]';
$string['quizdate'] = 'Fecha del examen fuera-de-línea';
$string['quizopenclose'] = 'Fechas de apertura y cierre';
$string['quizopenclose_help'] = 'Los estudiantes solamente pueden ver su(s) intento(s) después de la fecha de apertura y antes de la fecha de cierre.';
$string['quizquestions'] = 'Preguntas del Examen';
$string['readjust'] = 'Reajustar';
$string['realydeletepdfs'] = '¿ Realmente desea eliminar los archivos de formatos ?';
$string['realydeleteupdatepdf'] = '¿Realmente desea eliminar y actualizar la lista de participantes?';
$string['recreatepdfs'] = 'Re-crear PDFs';
$string['rediswrong'] = 'cruz equivocada o falta cruz';
$string['refreshpreview'] = 'Refrescar vista previa';
$string['regrade'] = 'Recalificar';
$string['regradedisplayexplanation'] = '<b>Atención:</b> ¡Re-calificar tambien cambia los puntajes que hubieran sido sobre-escritos manualmente!';
$string['regradinginfo'] = 'Si Usted cambia el puntaje para una pregunta, Usted debe re-calificar el examen fuera-de-línea para actualizar los resultados de los participantes.';
$string['regradingquiz'] = 'Recalificando';
$string['regradingresult'] = 'Re-clificando resultados para el usuario {$a}...';
$string['reloadpreview'] = 'Re-cargar vista previa';
$string['reloadquestionlist'] = 'Re-cargar lista de preguntas';
$string['remove'] = 'Remover';
$string['removeemptypage'] = 'Remover página vacía';
$string['removeselected'] = 'Remover seleccionadas';
$string['reordergroupquestions'] = 'Reordenar Preguntas del Grupo';
$string['reorderquestions'] = 'Reordenar preguntas';
$string['reordertool'] = 'Mostrar la herramienta para re-ordenación';
$string['repaginate'] = 'Repaginar con {$a} preguntas por página';
$string['repaginatecommand'] = 'Repaginar';
$string['repaginatenow'] = 'Repaginar ahora';
$string['reportstarts'] = 'revisión de resultados';
$string['resetofflinequizzes'] = 'Reiniciar datos de Examen Fuera-de-línea';
$string['resultexists'] = 'Ya existen los mismos resultados para {$a} , importación ignorada';
$string['resultimport'] = 'Importar resultados';
$string['results'] = 'Resultados';
$string['review'] = 'Revisión';
$string['reviewbefore'] = 'Permitir revisión mientras el examen fuera-de-línea esté abierto';
$string['reviewclosed'] = 'Después de que cierre el examen fuera-de-lpinea';
$string['reviewcloses'] = 'Se cierra la revisión';
$string['reviewimmediately'] = 'Inmediatamente después del intento';
$string['reviewincludes'] = 'La revisión incluye';
$string['reviewofresult'] = 'Revisión del resultado';
$string['reviewopens'] = 'Se abre para revisión';
$string['reviewoptions'] = 'Los estudiantes pueden ver';
$string['reviewoptionsheading'] = 'Opciones para revisión';
$string['reviewoptions_help'] = 'Con estas opciones, Usted puede controlar lo que los estudiantes pueden ver después de que los resultados sean importados. Usted también puede definir la hora de inicio y fin para el reporte de resultados. Las casillas significan:
<table>
<tr><td style="vertical-align: top;"><b>El intento</b></td><td>
El texto de las preguntas y las respuestas se mostrará a los estudiantes. Ellos verán cuales respuestas eligieron ellos mismos, pero no se indicarán las respuestas correctas.</td>
</td></tr>
<tr><td style="vertical-align: top;"><b>Si está correcta</b></td><td>
Esta opción solamente puede activarse si es que está activada también la opción para "El intento". Si está activada, los estudiantes pueden ver cuales de sus respuestas elegidas son correctas (fondo verde) o incorrectas (fondo rojo).
</td></tr>
<tr><td style="vertical-align: top;"><b>Puntos</b></td><td>Se muestran: el grupo (por ejemplo, el B), puntajes (calificación obtenida, calificación total para las preguntas, logro en porcentaje (por ejemplo, 40/80 (50)) y la calificación (por ejemplo, 50 de un máximo de 100).
Adicionalmente, si estuviera seleccionado "El intento" se muestran el puntaje obtenido y el puntaje máxio para cada pregunta.
</td></tr>
<tr><td style="vertical-align: top;"><b>Respuestas correctas</b></td><td>
se muestran cuales respuestas son correctas o erróneas. Esta opción solamente está disponible si está configurado "El intento".
</td></tr>
<tr><td style="vertical-align: top;"><b>Formato escaneado</b></td><td>
Se muestran los formatos de respuestas escaneados. Las casillas elegidas se muestran con cuadros verdes.
</td></tr>
<tr><td style="vertical-align: top;"><b>Formato escaneado con calificaciones</b></td><td>
Se muestran los formatos de respuestas escaneados. Las casillas eleghidas están marcadas con cuadros verdes. Las respuestas erróneas y faltantes están resaltadas.
Adicionalmente, una tabla muestra la calificación máxima (los puntos) y la calificación obtenida para cada pregunta.
</td></tr>
</table>';
$string['rimport'] = 'Subir/Corregir';
$string['rotate'] = 'Rotar';
$string['rotatingsheet'] = 'La hoja está girada ...';
$string['save'] = 'Guardar';
$string['saveandshow'] = 'Guardar y mostrarle cambios al estudiante';
$string['savescannersettings'] = 'Guardar configuraciones del escanner';
$string['scannedform'] = 'Formato escaneado';
$string['scannerformfortype'] = 'Formatop ara tipo {$a}';
$string['scanneroptions'] = 'Configuraciones del escanner';
$string['scannerpdfs'] = 'Formatos vacíos';
$string['scannerpdfstext'] = 'Descargue los siguientes formatos vacíos si Usted desea usar su propio \'\'software\'\' para el escanner.';
$string['scanningoptionsheading'] = 'Opciones para escanear';
$string['score'] = 'Puntaje';
$string['select'] = 'Seleccionar';
$string['selectagroup'] = 'Seleccionar un grupo';
$string['selectall'] = 'Seleccionar todo';
$string['selectcategory'] = 'Seleccionar categoría';
$string['selectdifferentgroup'] = 'Por favor, sleccione un grupo diferente';
$string['selectedattempts'] = 'Intentos selecionados ...';
$string['selectformat'] = 'Seleccionar formato ...';
$string['selectgroup'] = 'Basado en grupo';
$string['selectlist'] = 'Por favor, seleccione una lista o trate de reajustar la hoja:';
$string['selectnone'] = 'Des-seleccionar todo';
$string['selectpage'] = 'Por favor, seleccione número de página o trate de reajustar la hoja:';
$string['selectquestiontype'] = '-- Seleccionar tipo de preguntas --';
$string['showallparts'] = 'Mostrar a todos los {$a} participantes';
$string['showcopyright'] = 'Mostrar declaración sobre Derechos de Autor (copyright)';
$string['showcopyrightdesc'] = 'Si Usted habilita esta opción, se mostrará una declaratoria sobre Derechos de Autor (\'\'copyright\'\')  en la página de revisar resultados del estudiante.';
$string['showgrades'] = 'Imprimir calificaciones de preguntas';
$string['showgrades_help'] = 'Esta opción controla si es que las calificaciones máximas de las preguntas del examen fuera-de-línea dberían o no de imprimirse en la hoja de preguntas.';
$string['showmissingattemptonly'] = 'Mostrar todos los participantes revisados (seleccionados) sin resultados';
$string['showmissingcheckonly'] = 'Mostrar todos los participantes no-revisados (no-seleccionados) con resultados';
$string['shownumpartsperpage'] = 'Mostrar  {$a} participantes por página';
$string['showstudentview'] = 'Mostrar vista del estudiante.';
$string['showtutorial'] = 'Mostrarle a los estudiantes un tutorial de examen fuera-de-línea.';
$string['showtutorialdescription'] = 'Usted puede añadirle a la página del curso un enlace hacia el tutorial usando la siguiente URL:';
$string['showtutorial_help'] = 'Esta opción determina si es que los estudiantes pueden ver un tutorial acerca de las bases de los exámenes fuera-de-línea.
El tutorial proporciona información acerca de cómo manejar los diferentes tipos de documentos en exámenes fuera-de-línea. En una parte interactiva ellos aprenden como señalar su ID de estudiante correctamente.<br />
<b>Por favor tome nota de que:</b><br />
Si Usted configura esta opción en "Si" pero les oculta el examen fuera-de-línea, el enlace hacia el tutorial no será visible. En este caso, Usted puede añadir un enlace hacia el tutorial dentro de la página del curso.';
$string['shuffleanswers'] = 'Barajar respuestas';
$string['shufflequestions'] = 'Barajar preguntas';
$string['shufflequestionsanswers'] = 'Barajar preguntas y respuestas';
$string['shufflequestionsselected'] = 'Se ha configurado el barajar preguntas, por lo que algunas acciones relacionadas con las páginas no están disponibles. Para cambiar la opción de barajar,, {$a}.';
$string['shufflewithin'] = 'Barajar dentro de las preguntas';
$string['shufflewithin_help'] = 'Si se habilita, las partes que componen cada pregunta se barajarán aleatoriamente cada vez que Usted presione el botón para Re-cargar en la vista previa del formato. NOTA: Esta configuración solamente aplica para preguntas que tengan activada la opción para barajearse.';
$string['signature'] = 'Firma';
$string['standard'] = 'Estandar';
$string['starttutorial'] = 'Iniciar tutorial acerca del examen';
$string['statistics'] = 'Estadísticas';
$string['statisticsplural'] = 'Estadísticas';
$string['statsoverview'] = 'Vista general de Estadísticas';
$string['studycode'] = 'Estudiar el código';
$string['theattempt'] = 'El Intento';
$string['timesup'] = '¡Se agotó el tiempo!';
$string['totalpointsx'] = 'Total de calificaciones: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total de {$a} preguntas en categoría';
$string['trigger'] = 'límite inferior/superior';
$string['tutorial'] = 'Tutorial de exámenes fuera-de-línea';
$string['type'] = 'Tipo';
$string['uncheckparts'] = 'Marcar a los participantes seleccionados como ausentes';
$string['updatedsumgrades'] = 'La suma de todas las calificaciones del grupo {$a->letter} fue re-calculada a {$a->grade}.';
$string['upgradingilogs'] = 'Actualizando páginas escaneadas: página escaneada {$a->done}/{$a->outof} <br/>(ID del Examen Fuera-de-línea {$a->info})';
$string['upgradingofflinequizattempts'] = 'Actualizando intentos de resolver examen fuera-de-línea: offline quiz {$a->done}/{$a->outof} <br/>(ID del Examen Fuera-de-línea {$a->info})';
$string['upload'] = 'Subir/Corregir';
$string['uploadpart'] = 'Subir/Corregir listas de participantes';
$string['uppertrigger'] = 'Segundo límite superior';
$string['uppertriggerzero'] = 'El Segundo límite superior es cero';
$string['upperwarning'] = 'Primer límite superior';
$string['upperwarningzero'] = 'El Primer límite superior es cero';
$string['useradded'] = 'Usuario {$a} añadido';
$string['userdoesnotexist'] = 'Usuario {$a} a no existe en el sistema';
$string['useridentification'] = 'Identificación del examen';
$string['userimported'] = 'Usuario {$a} importado y calificado';
$string['usernotincourse'] = 'Usuario {$a} no está en el curso';
$string['usernotinlist'] = '¡Usuario no registrado en la lista!';
$string['usernotregistered'] = 'Usuario {$a} no registrado en el curso';
$string['userpageimported'] = 'Página única importada para el usuario {$a}';
$string['valuezero'] = 'El valor no debería de ser cero';
$string['viewresults'] = 'Ver resultados';
$string['white'] = 'Blanco';
$string['withselected'] = 'Con seleccionados ...';
$string['zerogradewarning'] = 'Advertencia: ¡ Su calificación del examen-fuera-de-línea es 0.0 !';
$string['zipfile'] = 'Archivo ZIP';
$string['zipok'] = 'Archivo ZIP importado';
