<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'odottaa asennusta';
$string['action'] = 'Tapahtuma';
$string['actionchoice'] = 'Mitä haluat tehdä tiedostolla \'{$a}\'?';
$string['actions'] = 'Tapahtumat';
$string['active'] = 'Aktiivinen';
$string['activeusers'] = 'Aktiiviset käyttäjät';
$string['activities'] = 'Aktiviteetit';
$string['activities_help'] = 'Aktiviteettien avulla lisäät kurssialueelle vuorovaikutteisuutta. Aktiviteetteja ovat esimerkiksi keskustelut, tehtävät, tentit ja wiki.';
$string['activity'] = 'Aktiviteetti';
$string['activityclipboard'] = 'Siirretään tätä aktiviteettia: {$a}';
$string['activityiscurrentlyhidden'] = 'Valitettavasti tämä aktiviteetti on piilotettuna';
$string['activitymodule'] = 'Aktiviteettimoduuli';
$string['activitymodules'] = 'Aktiviteettimoduulit';
$string['activityreport'] = 'Tapahtumaraportti';
$string['activityreports'] = 'Tapahtumaraportit';
$string['activityselect'] = 'Valitse tämä aktiviteetti siirrettäväksi';
$string['activitysince'] = 'Tapahtumat {$a} lähtien';
$string['activityweighted'] = 'Tapahtumat käyttäjittäin';
$string['add'] = 'Lisää';
$string['addactivity'] = 'Lisää aktiviteetti...';
$string['addactivitytosection'] = 'Lisää aktiviteetti osioon {$a}';
$string['addadmin'] = 'Lisää ylläpitäjä';
$string['addblock'] = 'Lisää lohko';
$string['addcomment'] = 'Lisää kommentti...';
$string['addcountertousername'] = 'Luo käyttäjä lisäämällä numero käyttäjänimeen';
$string['addcreator'] = 'Lisää kurssiylläpitäjä';
$string['adddots'] = 'Lisää...';
$string['added'] = 'Lisätty {$a}';
$string['addedrecip'] = 'Lisätty {$a} uusi vastaanottaja';
$string['addedrecips'] = 'Lisätty {$a} uutta vastaanottajaa';
$string['addedtogroup'] = 'Lisätty ryhmään {$a}';
$string['addedtogroupnot'] = 'Ei lisätty ryhmään {$a}';
$string['addedtogroupnotenrolled'] = 'Ei lisätty ryhmään {$a}, koska ei ole mukana ko. kurssilla';
$string['addfilehere'] = 'Lisää tiedosto(ja) tähän';
$string['addinganew'] = 'Lisätään uusi {$a}';
$string['addinganewto'] = 'Lisätään uusi {$a->what} kohtaan {$a->to}';
$string['addingdatatoexisting'] = 'Lisätään dataa olemassa olevaan';
$string['additionalnames'] = 'Lisänimet';
$string['addlinkhere'] = 'Lisää linkki tähän';
$string['addnewcategory'] = 'Lisää uusi kategoria';
$string['addnewcourse'] = 'Lisää uusi kurssi';
$string['addnewuser'] = 'Lisää uusi käyttäjä';
$string['addnousersrecip'] = 'Lisää käyttäjät jotka eivät ole käsitelleet tätä {$a} vastaanottajiksi.';
$string['addpagehere'] = 'Lisää sivu tähän';
$string['addresource'] = 'Lisää aineisto...';
$string['addresourceoractivity'] = 'Lisää aktiviteetti tai aineisto';
$string['addresourcetosection'] = 'Lisää aineisto osioon {$a}';
$string['address'] = 'Osoite';
$string['addstudent'] = 'Lisää opiskelija';
$string['addsubcategory'] = 'Lisää alakategoria';
$string['addteacher'] = 'Lisää opettaja';
$string['admin'] = 'Ylläpito';
$string['adminhelpaddnewuser'] = 'Käyttäjien lisäys käsin';
$string['adminhelpassignadmins'] = 'Ylläpitäjällä on pääsy kaikkialle tällä sivustolla sekä kaikki oikeudet lisäyksiin ja poistoihin';
$string['adminhelpassigncreators'] = 'Kurssiylläpitäjät voivat luoda uusia kursseja.';
$string['adminhelpassignsiteroles'] = 'Liitä määriteltyjä rooleja käyttäjille';
$string['adminhelpassignstudents'] = 'Siirry kurssille ja lisää opiskelijat ylläpitovalikosta';
$string['adminhelpauthentication'] = 'Voit käyttää Moodlen omia käyttäjätilejä tai ulkoista tietokantaa';
$string['adminhelpbackup'] = 'Määritä, kuinka varmuuskopiointi toimii';
$string['adminhelpconfiguration'] = 'Määritä sivuston ulkoasu ja toiminnot';
$string['adminhelpconfigvariables'] = 'Määritä sivuston yleiseen toimintaan vaikuttavat asetukset';
$string['adminhelpcourses'] = 'Määritä kategoriat ja kurssit sekä niille käyttäjät';
$string['adminhelpeditorsettings'] = 'Määrittele HTML-editorin perusasetukset';
$string['adminhelpedituser'] = 'Selaa käyttäjälistaa ja muokkaa tunnuksia';
$string['adminhelpenvironment'] = 'Tarkista kuinka palvelin sopii nykyisiin ja tuleviin asennusvaatimuksiin';
$string['adminhelpfailurelogs'] = 'Selaa epäonnistuneita kirjautumisia';
$string['adminhelplanguage'] = 'Käytössä olevan kielipaketin tarkistus ja editointi';
$string['adminhelplogs'] = 'Selaa sivuston kaikkia tapahtumia';
$string['adminhelpmanageblocks'] = 'Hallitse asennettuja lohkoja ja niiden asetuksia';
$string['adminhelpmanagedatabase'] = 'Hallitse tietokantaa suoraan (muista olla varovainen!)';
$string['adminhelpmanagefilters'] = 'Valitse tekstisuodattimet ja niiden asetukset';
$string['adminhelpmanagemodules'] = 'Hallitse asennettuja moduuleita ja niiden asetuksia';
$string['adminhelpmanageroles'] = 'Luo ja määrittele rooleja joita voidaan jakaa käyttäjille';
$string['adminhelpmymoodle'] = 'Määritä  my moodle -lohkot käyttäjille';
$string['adminhelpreports'] = 'Sivuston raportit';
$string['adminhelpsitefiles'] = 'Tiedostojen julkaisu tai varmuuskopioiden siirto palvelimelle';
$string['adminhelpsitesettings'] = 'Määritä, miltä sivuston etusivu näyttää';
$string['adminhelpstickyblocks'] = 'Määritä koko sivuston pysyvät lohkot';
$string['adminhelpthemes'] = 'Valitse, miltä sivusto näyttää (värit, fontit jne.)';
$string['adminhelpuploadusers'] = 'Tuo uudet käyttäjät tekstitiedostosta';
$string['adminhelpusers'] = 'Määritä käyttäjät ja varmistusmenetelmä';
$string['adminhelpxmldbeditor'] = 'Käyttöliittymä XMLDB-tiedostojen muokkaamiseen. Tarpeellinen vain Moodlen kehittäjille.';
$string['administration'] = 'Ylläpito';
$string['administrationsite'] = 'Sivuston hallinta';
$string['administrator'] = 'Ylläpitäjä';
$string['administratordescription'] = 'Ylläpitäjät voivat tehdä sivustolla ja kaikilla kursseilla mitä tahansa.';
$string['administrators'] = 'Ylläpitäjät';
$string['administratorsall'] = 'Kaikki ylläpitäjät';
$string['administratorsandteachers'] = 'Ylläpitäjät ja opettajat';
$string['advanced'] = 'Tarkemmin';
$string['advancedfilter'] = 'Tarkennettu haku';
$string['advancedsettings'] = 'Lisäasetukset';
$string['again'] = 'taas';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX ja Javascript';
$string['all'] = 'Kaikki';
$string['allactions'] = 'Kaikki tapahtumat';
$string['allactivities'] = 'Kaikki aktiviteetit';
$string['allcategories'] = 'Kaikki kategoriat';
$string['allchanges'] = 'Kaikki muutokset';
$string['alldays'] = 'Kaikki päivät';
$string['allfieldsrequired'] = 'Täytä kaikki kentät';
$string['allfiles'] = 'Kaikki tiedostot';
$string['allgroups'] = 'Kaikki ryhmät';
$string['alllogs'] = 'Kaikki tapahtumat';
$string['allmods'] = 'Kaikki {$a}';
$string['allow'] = 'Salli';
$string['allowinternal'] = 'Salli myös sisäiset metodit';
$string['allownone'] = 'Estä kaikilta';
$string['allownot'] = 'Älä salli';
$string['allparticipants'] = 'Kaikki osallistujat';
$string['allteachers'] = 'Kaikki opettajat';
$string['alphanumerical'] = 'Voi sisältää ainoastaan kirjaimia, numeroita, tavuviivan (-) tai pisteen (.).';
$string['alreadyconfirmed'] = 'Rekisteröinti on jo aiemmin vahvistettu.';
$string['alternatename'] = 'Lisänimi';
$string['always'] = 'Aina';
$string['and'] = '{$a->one} ja {$a->two}';
$string['answer'] = 'Vastaus';
$string['any'] = 'Mikä vain';
$string['appearance'] = 'Näkyvyyteen liittyvät asetukset';
$string['approve'] = 'Hyväksy';
$string['areyousuretorestorethis'] = 'Haluatko jatkaa?';
$string['areyousuretorestorethisinfo'] = 'Voit myöhemmin lisätä tämän varmuuskopion jo olemassa olevalle kurssille tai luoda kokonaan uuden kurssin.';
$string['asc'] = 'Nouseva';
$string['assessment'] = 'Arviointi';
$string['assignadmins'] = 'Määritä ylläpitäjät';
$string['assigncreators'] = 'Määritä kurssiylläpitäjät';
$string['assignsiteroles'] = 'Jaa rooleja sivustolle';
$string['authenticateduser'] = 'Tunnistautunut käyttäjä';
$string['authenticateduserdescription'] = 'Kaikki kirjautuneet käyttäjät.';
$string['authentication'] = 'Käyttäjäntunnistus';
$string['authenticationplugins'] = 'Käyttäjäntunnistuksen lisäosat';
$string['autosubscribe'] = 'Keskustelualueviestien tilaus sähköpostiin';
$string['autosubscribeno'] = 'Ei: älä lähetä keskustelualueen viestejä oletusarvoisesti sähköpostiini';
$string['autosubscribeyes'] = 'Kyllä: lähetä keskustelualueviestit sähköpostiin osallistuessani keskusteluun';
$string['availability'] = 'Näkyvyys opiskelijoille';
$string['availablecourses'] = 'Saatavilla olevat kurssit';
$string['back'] = 'Takaisin';
$string['backto'] = 'Takaisin {$a}';
$string['backtocourselisting'] = 'Takaisin kurssilistaan';
$string['backtopageyouwereon'] = 'Takaisin edelliselle sivulle';
$string['backtoparticipants'] = 'Takaisin osallistujalistaan';
$string['backup'] = 'Varmuuskopiointi';
$string['backupactivehelp'] = 'Valitse suoritetaanko automaattisesta varmuuskopiointia';
$string['backupcancelled'] = 'Varmuuskopiointi peruutettu';
$string['backupcoursefileshelp'] = 'Jos asetus on päällä, tulevat kurssien tiedostot mukaan automaattisiin varmuuskopioihin.';
$string['backupdate'] = 'Varmuuskopion päivämäärä';
$string['backupdatenew'] = '&nbsp; {$a->TAG} on nyt {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} oli {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Varmuuskopion yksityiskohdat';
$string['backupexecuteathelp'] = 'Milloin automaattinen varmuuskopiointi tulisi suorittaa';
$string['backupfailed'] = 'Joitain kursseistasi ei tallennettu!';
$string['backupfilename'] = 'varmuuskopio';
$string['backupfinished'] = 'Varmuuskopio tehty onnistuneesti';
$string['backupfromthissite'] = 'Tehtiinkö varmuuskopio tästä sivustosta?';
$string['backupgradebookhistoryhelp'] = 'Jos valittu, arvosanat sisällytetään varmuuskopioon. Huomioi, että arvosanahistoria ei saa olla kielletty serverin asetuksissa (disablegradehistory)';
$string['backupincludemoduleshelp'] = 'Valitse, haluatko sisällyttää kurssimoduulit, käyttäjätietojen kanssa tai ilman, automaattiseen varmuuskopiointiin';
$string['backupincludemoduleuserdatahelp'] = 'Haluatko sisällyttää moduulien sisältämät käyttäjätiedot ja tiedostot varmuuskopioihin';
$string['backupkeephelp'] = 'Montako varmuuskopiota haluat säilyttää? Vanhimmat niistä poistetaan automaattisesti.';
$string['backuplogdetailed'] = 'Tarkka suoritusloki';
$string['backuploglaststatus'] = 'Viimeisin suoritusloki';
$string['backupmissinguserinfoperms'] = 'Huomio: Tämä varmuuskopio ei sisällä käyttäjädataa. Harjoitukset ja työpaja-aktiviteetit eivät sisälly varmuuskopioon';
$string['backupnext'] = 'Seuraava varmuuskopio';
$string['backupnonisowarning'] = 'Varoitus: Tämä varmuuskopio on ei unikoodatusta moodlesta (< v.1.6). Jos tiedostossa ISO-8859-1 merkistön ulkopuolisia merkkejä ne voivat korruptoitua jos palautat varmuuskopion.
Saat lisätietoa ongelmasta sivulta <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>.';
$string['backuporiginalname'] = 'Varmuuskopion nimi';
$string['backuproleassignments'] = 'Varmuuskopioi näiden roolien jaot';
$string['backupsavetohelp'] = 'Koko polku hakemistoon, johon haluat tallentaa varmuuskopiotiedostot.<br /> (Jätä tämä tyhjäksi, jos haluat tallentaa kurssin oletushakemistoon.)';
$string['backupsitefileshelp'] = 'Kurssilla käytetyt sivuston tiedostot sisällytetään varmuuskopioon.';
$string['backuptakealook'] = 'Ole hyvä ja katso varmuuskopioinnin lokitiedostot paikasta: {$a}';
$string['backupuserfileshelp'] = 'Valitse, haluatko sisällyttää käyttäjien tiedostot (esim. omat kuvat) automaattiseen varmuuskopiointiin';
$string['backupversion'] = 'Varmuuskopion versio';
$string['badges'] = 'Osaamismerkit';
$string['block'] = 'Lohko';
$string['blockconfiga'] = 'Muokataan lohkoa {$a}';
$string['blockconfigbad'] = 'Tätä lohkoa ei ole toteutettu oikein ja siksi muokkausikkunaa ei voida näyttää.';
$string['blocks'] = 'Lohkot';
$string['blocksaddedit'] = 'Lisää tai muokkaa lohkoja';
$string['blockseditoff'] = 'Lohkojen muokkaus pois';
$string['blocksediton'] = 'Lohkojen muokkaus päälle';
$string['blocksetup'] = 'Asetetaan lohkojen taulut';
$string['blocksuccess'] = '{$a} taulut on asetettu onnistuneesti';
$string['brief'] = 'Tiivistetty';
$string['bycourseorder'] = 'Kurssin mukaan';
$string['byname'] = '{$a} mukaan';
$string['bypassed'] = 'Ohitettu';
$string['cachecontrols'] = 'Välimuistin asetukset';
$string['cancel'] = 'Peruuta';
$string['cancelled'] = 'Peruutettu';
$string['categories'] = 'Kurssikategoriat';
$string['categoriesandcoures'] = 'Kurssikategoriat ja kurssit';
$string['category'] = 'Kategoria';
$string['categoryadded'] = 'Kategoria \'{$a}\' lisätty';
$string['categorybulkaction'] = 'Massatoiminnot valituille kategorioille';
$string['categorycontents'] = 'Alakategoriat ja kurssit';
$string['categorycurrentcontents'] = 'Kategorian {$a} sisältö';
$string['categorydeleted'] = 'Kategoria \'{$a}\' poistettu';
$string['categoryduplicate'] = 'Kategoria \'{$a}\' on jo olemassa';
$string['categorymodifiedcancel'] = 'Kategoriaa muutettiin! Peruuta ja kokeile uudestaan.';
$string['categoryname'] = 'Kategorian nimi';
$string['categorysubcategoryof'] = '{$a->category}  on alikategoria ylätasolle {$a->parentcategory}';
$string['categoryupdated'] = 'Kategoria \'{$a}\' päivitetty';
$string['changedpassword'] = 'Salasana vaihdettu ja käyttäjätunnus selvitetty.';
$string['changepassword'] = 'Vaihda salasana';
$string['changesmadereallygoaway'] = 'Olet tehnyt muutoksia. Haluatko varmasti siirtyä pois tältä sivulta ja hävittää muutoksesi?';
$string['changessaved'] = 'Muutokset tallennettu';
$string['check'] = 'Tarkista';
$string['checkall'] = 'Tarkista kaikki';
$string['checkingbackup'] = 'Tutkitaan varmuuskopiota';
$string['checkingcourse'] = 'Tutkitaan kurssi';
$string['checkingforbbexport'] = 'Tarkistetaan BlackBoard -vientiä';
$string['checkinginstances'] = 'Tarkistetaan tapahtumia';
$string['checkingsections'] = 'Tarkistetaan tehtävälohkoja';
$string['checklanguage'] = 'Tarkista kieli';
$string['checknone'] = 'Älä tarkista mitään';
$string['childcoursenotfound'] = 'Alakurssia ei löytynyt!';
$string['childcourses'] = 'Alakurssit';
$string['choose'] = 'Valitse';
$string['choosecourse'] = 'Valitse kurssi';
$string['choosedots'] = 'Valitse...';
$string['chooselivelogs'] = 'Tai tarkastele nykyistä aktiivisuutta';
$string['chooselogs'] = 'Valitse tapahtumat, joita haluat tarkastella';
$string['choosereportfilter'] = 'Valitse suodatin raporttia varten';
$string['choosetheme'] = 'Valitse teema';
$string['chooseuser'] = 'Valitse käyttäjä';
$string['city'] = 'Paikkakunta';
$string['clambroken'] = 'Ylläpitäjä on määritellyt virustunnistuksen, mutta jokin virustunnistuksen asetuksista on väärin.<br /> Tiedoston tallentaminen ei onnistunut. Ylläpitäjälle on lähetetty sähköposti tästä virheestä, jotta hän voi korjata asian. <br /> Yritä lähettää tiedosto myöhemmin uudelleen.';
$string['clamdeletedfile'] = 'Tiedosto on poistettu';
$string['clamdeletedfilefailed'] = 'Tiedostoa ei voitu poistaa';
$string['clamemailsubject'] = '{$a} :: Clam AV -ilmoitus';
$string['clamfailed'] = 'Clam Antivirus -ohjelmaa ei voitu suorittaa. Virhe oli {$a}. Tässä on ohjelman tuloste:';
$string['clamlost'] = 'Moodle on konfiguroitu tarkistamaan lähetetyt tiedostot Clam Antivirus -ohjelmistolla, mutta ohjelman sijainti, {$a}, on virheellinen.';
$string['clamlostandactinglikevirus'] = 'Lisäksi, Moodle on määritelty hylkäämään tarkistamatta jääneet tiedostot. Tämä tarkoittaa sitä, ettei tiedostoja voida lähettää ennen kuin ongelma on korjattu.';
$string['clammovedfile'] = 'Tiedosto on siirretty karanteenihakemistoon. Tiedoston uusi sijainti on {$a}.';
$string['clammovedfilebasic'] = 'Tiedosto on siirretty karanteenihakemistoon.';
$string['clamquarantinedirfailed'] = 'Tiedostoa ei voitu siirtää karanteenihakemistoon {$a}. Ongelma pitää korjata, koska tässä tapauksessa kaikki saastuneet tiedostot poistetaan.';
$string['clamunknownerror'] = 'Tuntematon virhe Clam AV-ohjelmiston käytössä.';
$string['cleaningtempdata'] = 'Puhdistetaan väliaikaiset tiedot';
$string['clear'] = 'Tyhjennä';
$string['clickhelpiconformoreinfo'] = '... jatkuu ... Klikkaa Ohje-ikonia lukeaksesi koko artikkelin';
$string['clickhere'] = 'Napsauta tästä';
$string['clicktochangeinbrackets'] = '{$a} (Napsauta muuttaaksesi)';
$string['clicktohideshow'] = 'Klikkaa avataksesi tai sulkeaksesi';
$string['closewindow'] = 'Sulje tämä ikkuna';
$string['collapse'] = 'Sulje';
$string['collapseall'] = 'Sulje kaikki';
$string['collapsecategory'] = 'Sulje {$a}';
$string['commentincontext'] = 'Hae tätä kommenttia kontekstista';
$string['comments'] = 'Kommentit';
$string['commentsnotenabled'] = 'Kommentit-toiminto ei ole käytössä';
$string['commentsrequirelogin'] = 'Sinun täytyy kirjautua sisään nähdäksesi kommentit';
$string['comparelanguage'] = 'Vertaa ja muokkaa kielipakettia';
$string['complete'] = 'Suoritettu loppuun';
$string['completereport'] = 'Täysi raportti';
$string['configuration'] = 'Asetukset';
$string['confirm'] = 'Vahvista';
$string['confirmcheckfull'] = 'Oletko aivan vama että haluat vahvistaa {$a} ?';
$string['confirmed'] = 'Rekisteröitymisesi on vahvistettu';
$string['confirmednot'] = 'Rekisteröitymistäsi ei ole vielä vahvistettu';
$string['content'] = 'Sisältö';
$string['continue'] = 'Jatka';
$string['continuetocourse'] = 'Napsauta tästä päästäksesi kurssille';
$string['convertingwikitomarkdown'] = 'Muunnetaan Wiki Markdown-muotoon';
$string['cookiesenabled'] = 'Selaimessasi pitää olla evästeet (cookies) päällä.';
$string['cookiesenabled_help'] = 'Tämä sivusto käyttää kahta evästettä. Oleellisin on istuntoeväste, jota yleensä kutsutaan <strong>MoodleSession</strong>:iksi.  Salli tämä eväste selaimessasi saadaksesi istuntosi säilymään ja ylläpitääksesi kirjautumista sivulta sivulle. Kun kirjaudut ulos tai suljet selaimen, tämä eväste tuhoutuu selaimessasi ja palvelimella.

Toinen eväste on vain käytännöllisyyden vuoksi, sitä kutsutaan esimerkiksi <b>MOODLEID</b>:ksi. Se muistaa käyttäjänimesi selaimen sisällä. Tämä tarkoittaa sitä, että kun palaat tälle sivustolle, käyttäjänimi kenttä sisäänkirjautumissivulla on jo valmiiksi täytetty sinua varten. On turvallista kieltäytyä tästä evästeestä - sinun vain täytyy kirjoittaa käyttäjänimesi joka kerta kun kirjaudut sisään.';
$string['cookiesnotenabled'] = 'Selaimessasi ei ole evästeiden (cookies) tuki päällä.';
$string['copy'] = 'kopioi';
$string['copyasnoun'] = 'kopio';
$string['copyingcoursefiles'] = 'Kopioi kurssin tiedostoja';
$string['copyingsitefiles'] = 'Kopioi kurssilla käytettyjä sivuston tiedostoja';
$string['copyinguserfiles'] = 'Kopioi käyttäjän tiedostoja';
$string['copyingzipfile'] = 'Kopioi zip-tiedostoa';
$string['copyrightnotice'] = 'Käyttöoikeustiedot';
$string['coresystem'] = 'Järjestelmä';
$string['cost'] = 'Hinta';
$string['costdefault'] = 'Perushinta';
$string['counteditems'] = '{$a->items} ({$a->count})';
$string['country'] = 'Maa';
$string['course'] = 'Kurssi';
$string['courseadministration'] = 'Kurssin ylläpito';
$string['courseapprovedemail'] = 'Pyytämäsi kurssi , {$a->name}, on hyväksytty ja sinusta kurssin {$a->teacher}.
Löydät kurssisi seuraavasta osoitteesta {$a->url}';
$string['courseapprovedemail2'] = 'Tilaamasi kurssialue, {$a->name} on perustettu. Löydät kurssisi seuraavasta osoitteesta {$a->url}';
$string['courseapprovedfailed'] = 'Kurssialueen perustaminen ei onnistunut.';
$string['courseapprovedsubject'] = 'Kurssialuetilauksesi on hyväksytty';
$string['courseavailable'] = 'Tämä kurssi on avoinna opiskelijoille';
$string['courseavailablenot'] = 'Tämä kurssi on suljettu opiskelijoilta';
$string['coursebackup'] = 'Kurssin varmuuskopiointi';
$string['coursecategories'] = 'Kurssikategoriat';
$string['coursecategory'] = 'Kurssikategoria';
$string['coursecategorydeleted'] = 'Kurssikategoria {$a} poistettu';
$string['coursecategory_help'] = 'Moodleen on valmiiksi luotu kurssikategorioita, kuten tiedekuntakohtainen tai muu oppiaineperustainen jako. Kurssisi on sijoitettu kategoriaan, johon olet sen pyytänyt, tai esimerkiksi Harjoituskursseihin. Jos sinulla ei ole itselläsi oikeuksia vaihtaa kurssialueesi kategoriaa, voit tarvittaessa pyytää vaihtoa Moodle-ylläpidosta.

Valitse kategoria, johon kurssisi sopii parhaiten. Tämä valinta vaikuttaa siihen, missä kohdassa kurssisi näkyy kurssiluettelossa ja helpottaa opiskelijota kurssisi löytymisessä.';
$string['coursecatmanagement'] = 'Kurssien ja kategorioiden hallinta';
$string['coursecompletion'] = 'Kurssin lopetus';
$string['coursecompletions'] = 'Kurssien lopetukset';
$string['coursecreators'] = 'Kurssinluoja';
$string['coursecreatorsdescription'] = 'Kurssinluojat voivat opettajaoikeuksien lisäksi perustaa uusia kurssialueita.';
$string['coursedeleted'] = 'Kurssi {$a} poistettu';
$string['coursedisplay'] = 'Kurssialueen sisällön taitto sivuille';
$string['coursedisplay_help'] = 'Tällä asetuksella määrittelet, näkyykö kurssi kokonaisuudessaan yhdellä sivulla vai jaetaanko sisältö usealle sivulle.';
$string['coursedisplay_multi'] = 'Näytä kukin osio omalla sivullaan';
$string['coursedisplay_single'] = 'Näytä kaikki osiot yhdellä sivulla';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Perinteiset kurssitiedostot';
$string['coursefilesedit'] = 'Muokkaa kurssin tiedostoja';
$string['coursefileswarning'] = 'Kurssin tiedostot ovat vanhentuneet';
$string['coursefileswarning_help'] = 'Kurssialuekohtaisten tiedostojen sijaan Moodlessa suositellaan hyödynnettäväksi ulkoisia tallennuspaikkoja ja linkitystä kullekin kurssialueelle. Tämä vähentää Moodlen sisäistä tilantarvetta.';
$string['courseformatdata'] = 'Kurssimuodon tiedot';
$string['courseformatoptions'] = '{$a} asetukset';
$string['courseformats'] = 'Kurssimuodot';
$string['courseformatudpate'] = 'Päivitä kurssimuoto';
$string['coursegrades'] = 'Kurssin arvioinnit';
$string['coursehelpcategory'] = 'Lisää kurssi kurssilistaukseen ja tee siitä helpommin löydettävä opiskelijoille';
$string['coursehelpforce'] = 'Pakota ryhmät käyttöön kurssialueen kaikkiin aktiviteetteihin';
$string['coursehelpformat'] = 'Kurssialueen pääsivu näytetään tässä formaatissa.';
$string['coursehelphiddensections'] = 'Miten kurssin piilotetut osiot näytetään opiskelijoille';
$string['coursehelpmaximumupload'] = 'Määritä tälle kurssialueelle ladattavien tiedostojen maksimikoko (jota rajoittaa Moodleen määritelty tiedostojen maksimikoko)';
$string['coursehelpnewsitemsnumber'] = 'Uutisten lukumäärä Viimeisimmät uutiset -lohkossa. Nolla (0) tarkoittaa, että Viimeisimmät uutiset -lohko ei näy lainkaan.';
$string['coursehelpnumberweeks'] = 'Kurssin pääsivulla näytettävien osioiden lukumäärä - koskee vain osaa kurssimuodoista.';
$string['coursehelpshowgrades'] = 'Salli arviointikirjan näyttäminen. Tämä ei estä arvosanojen näkymistä aktiviteeteissa.';
$string['coursehidden'] = 'Tämä kurssi ei ole avoinna opiskelijoille';
$string['courseinfo'] = 'Kurssin kuvaus';
$string['courselegacyfiles'] = 'Perinteiset kurssitiedostot';
$string['courselegacyfiles_help'] = 'Kurssin tiedostoalue mahdollistaa yhteensopivuuden aikaisempien Moodle-versioiden kanssa. Kaikki tiedostoalueen tiedostot ovat aina kaikkien kurssin osallistujien käytettävissä (oli niihin sitten linkki tai ei). Tietoa missä näitä tiedostoja käytetään ei ole mahdollista saada.

Jos käytät tätä aluetta kurssien tiedostojen säilyttämiseen on riskinä tietoturvaongelmat ja yksityisyyden suoja. Samoin ongelmana voi olla puuttuvat tiedostot varmuuskopiossa, kurssien siirtojen yhteydessä tai silloin kun sisältöä on jaettu toisille käyttäjille tai käytetään uudelleen. Siksi on suositeltavaa, että käytä tätä aluetta vain jos tiedät tarkkaan mitä olet tekemässä.';
$string['coursemessage'] = 'Lähetä viesti kurssin osallistujille';
$string['coursenotaccessible'] = 'Tälle kurssille ei ole avointa pääsyä';
$string['courseoverview'] = 'Kurssin yhteenveto';
$string['courseoverviewfiles'] = 'Kurssikuvaukseen liittyvät tiedostot';
$string['courseoverviewfilesext'] = 'Kurssikuvaukseen liittyvien tiedostojen tiedostopäätteet';
$string['courseoverviewfiles_help'] = 'Kurssikuvaukseen liittyvät tiedostot, kuten kuvat, näytetään  kaikille avoimessa kurssilistauksessa, myös kirjautumattomille käyttäjille.';
$string['courseoverviewfileslimit'] = 'Kurssikuvaukseen liittyvien tiedostojen kokoraja.';
$string['courseoverviewgraph'] = 'Kurssin yleiskatsauksen graafinen esitys';
$string['courseprofiles'] = 'Kurssiprofiilit';
$string['coursereasonforrejecting'] = 'Syyt tämän pyynnön hylkäämiseen';
$string['coursereasonforrejectingemail'] = 'Tämä lähetetään sähköpostilla tilaajalle';
$string['coursereject'] = 'Hylkää kurssianomus';
$string['courserejected'] = 'Kurssialueen tilaus on hylätty ja tilaajalle on tiedotettu asiasta';
$string['courserejectemail'] = 'Hei!

Kurssialuetilaustasi ei voitu hyväksyä.
Hylkäämisen perustelu:

{$a}

Ystävällisin terveisin, Moodle-ylläpito';
$string['courserejectreason'] = 'Kerro lyhyesti kurssin hylkäämisen syy </br>
(Tämä tieto lähetetään kurssin tilaajalle)';
$string['courserejectsubject'] = 'Kurssialuetta ei voitu perustaa';
$string['coursereport'] = 'Kurssiraportti';
$string['coursereports'] = 'Kurssiraportit';
$string['courserequest'] = 'Kurssialueen tilaus';
$string['courserequestdetails'] = 'Kurssin tiedot';
$string['courserequestfailed'] = 'Kurssialueen tilausta ei voitu tallentaa';
$string['courserequestintro'] = 'Täytä lomakkeelle tiedot anomastasi kurssista mahdollisimman hyvin, jotta kurssin tarpeellisuus tuli esille.';
$string['courserequestreason'] = 'Lisätiedot';
$string['courserequestsuccess'] = 'Kurssialuetilauksesi on tallennettu. Saat tiedon sähköpostitse kun kurssialue on perustettu.';
$string['courserequestsupport'] = 'Lisätietoa kurssialueen perustamiseen liittyen.';
$string['courserestore'] = 'Kurssin palautus';
$string['courses'] = 'Kurssit';
$string['coursesectionsummaries'] = 'Kurssiosioiden yhteenvedot';
$string['coursesettings'] = 'Kurssin oletusasetukset';
$string['coursesmovedout'] = 'Kurssit siirretty kohteesta {$a}';
$string['coursespending'] = 'Käsittelyä odottavat kurssialuetilaukset';
$string['coursestart'] = 'Kurssin aloitus';
$string['coursesummary'] = 'Kurssikuvaus';
$string['coursesummary_help'] = 'Kurssikuvaus näkyy kaikille avoimessa kurssilistauksessa, myös kirjautumattomille käyttäjille. Hakutoiminto etsii hakulauseketta kurssien nimien lisäksi myös kurssikuvaus-tekstistä.';
$string['courseupdates'] = 'Kurssin päivitykset';
$string['create'] = 'Luo';
$string['createaccount'] = 'Luo uusi käyttäjätunnus.';
$string['createcategory'] = 'Luo kategoria';
$string['createfolder'] = 'Luo hakemisto kohtaan {$a}';
$string['createnewcategory'] = 'Luo uusi kategoria';
$string['createnewcourse'] = 'Luo uusi kurssi';
$string['createnewsubcategory'] = 'Luo uusi alikategoria';
$string['createsubcategoryof'] = 'Luo uusi alikategoria ylemmälle tasolle {$a}';
$string['createuser'] = 'Luo käyttäjä';
$string['createuserandpass'] = 'Valitse käyttäjätunnus ja salasana';
$string['createziparchive'] = 'Luo zip-paketti';
$string['creatingblocks'] = 'Luodaan lohkoja';
$string['creatingblocksroles'] = 'Luodaan lohkotason rooleja';
$string['creatingblogsinfo'] = 'Luodaan blogien tietoja';
$string['creatingcategoriesandquestions'] = 'Luodaan kategoriat ja kysymykset';
$string['creatingcoursemodules'] = 'Luodaan kurssin moduuleja';
$string['creatingcourseroles'] = 'Luodaan kurssitason rooleja';
$string['creatingevents'] = 'Luodaan tapahtumia';
$string['creatinggradebook'] = 'Luodaan arviointikirja';
$string['creatinggroupings'] = 'Luodaan ryhmittelyjä';
$string['creatinggroupingsgroups'] = 'Ryhmien lisääminen ryhmiin';
$string['creatinggroups'] = 'Luodaan ryhmiä';
$string['creatinglogentries'] = 'Luodaan tapahtumalokit';
$string['creatingmessagesinfo'] = 'Luodaan viestitietoja';
$string['creatingmodroles'] = 'Luodaan moduulitason rooleja';
$string['creatingnewcourse'] = 'Luodaan uutta kurssia';
$string['creatingrolesdefinitions'] = 'Luodaan roolimäärityksiä';
$string['creatingscales'] = 'Luodaan asteikkoja';
$string['creatingsections'] = 'Luodaan osioita';
$string['creatingtemporarystructures'] = 'Luodaan väliaikaisia rakenteita';
$string['creatinguserroles'] = 'Luodaan käyttäjätason rooleja';
$string['creatingusers'] = 'Luodaan käyttäjiä';
$string['creatingxmlfile'] = 'Luodaan XML-tiedostoa';
$string['currency'] = 'Valuutta';
$string['currentcourse'] = 'Nykyinen kurssi';
$string['currentcourseadding'] = 'Nykyinen kurssi, lisätään tiedot';
$string['currentcoursedeleting'] = 'Nykyinen kurssi, poistetaan ensin';
$string['currentlanguage'] = 'Nykyinen kieli';
$string['currentlocaltime'] = 'Nykyinen paikallinen aika';
$string['currentlyselectedusers'] = 'Valitut käyttäjät';
$string['currentpicture'] = 'Nykyinen kuva';
$string['currentrelease'] = 'Nykyisen version tiedot';
$string['currentversion'] = 'Nykyinen versio';
$string['databasechecking'] = 'Päivitetään tietokanta versiosta  {$a->oldversion} versioon {$a->newversion}';
$string['databaseperformance'] = 'Tietokannan suorituskyky';
$string['databasesetup'] = 'Asennetaan tietokantaa';
$string['databasesuccess'] = 'Tietokanta päivitettiin virheittä';
$string['databaseupgradebackups'] = 'Varmuuskopion versio on {$a}';
$string['databaseupgradeblocks'] = 'Lohkojen versio on {$a}';
$string['databaseupgradegroups'] = 'Ryhmätoiminnon versio on {$a}';
$string['databaseupgradelocal'] = 'Paikallisten tietokantamuutosten versio on nyt {$a}';
$string['databaseupgrades'] = 'Päivitetään tietokantaa';
$string['date'] = 'Päiväys';
$string['datechanged'] = 'Päiväys vaihdettu';
$string['datemostrecentfirst'] = 'Päiväys - viimeisin ensin';
$string['datemostrecentlast'] = 'Päiväys - vanhin ensin';
$string['day'] = 'päivä';
$string['days'] = 'päivää';
$string['decodinginternallinks'] = 'Pura sisäiset linkit';
$string['default'] = 'Oletus';
$string['defaultcoursestudent'] = 'Opiskelija';
$string['defaultcoursestudentdescription'] = 'Opiskelijat voivat lukea opettajien kurssialueelle lisäämiä materiaaleja ja osallistua opettajan suunnittelemiin kurssiaktivieetteihin, kuten osallistua keskusteluun, palauttaa tehtäviä, tehdä tenttejä ja työskennellä wikissä.';
$string['defaultcoursestudents'] = 'Opiskelijat';
$string['defaultcoursesummary'] = 'Kirjoita lyhytsanainen ja kiinnostava kuvaus kurssista tähän.';
$string['defaultcourseteacher'] = 'Opettaja';
$string['defaultcourseteacherdescription'] = 'Opettajilla on kurssialueillaan ylläpitäjän oikeudet. He voivat lisätä kurssialueelle aineistoja ja aktiviteetteja, osallistua kurssityöskentelyyn kuten keskusteluihin ja ryhmätöihin wikissä sekä arvioida opiskelijoiden tuotoksia.';
$string['defaultcourseteachers'] = 'Opettajat';
$string['defaulteditor'] = 'Oletuseditori';
$string['delete'] = 'Poista';
$string['deleteablock'] = 'Poista lohko';
$string['deleteall'] = 'Poista kaikki';
$string['deleteallcannotundo'] = 'Poista kaikki - ei voi peruuttaa';
$string['deleteallcomments'] = 'Poista kaikki kommentit';
$string['deleteallratings'] = 'Poista kaikki arvoinnit';
$string['deletecategory'] = 'Poista kategoria: {$a}';
$string['deletecategorycheck'] = 'Oletko aivan varma, että haluat poistaa kokonaan kategorian <b>\'{$a}\'</b>?<br />Kaikki kategorian kurssit siirretään ylempään kategoriaan, tai ylemmän kategorian puuttuessa kategoriaan \'Muut\'.';
$string['deletecategorycheck2'] = 'Jos poistat tämän kategorian, sinun pitää valita mitä teet sen alakategorioille ja kursseille.';
$string['deletecategoryempty'] = 'Tämä kategoria on tyhjä.';
$string['deletecheck'] = 'Poista {$a}?';
$string['deletecheckfiles'] = 'Oletko aivan varma, että haluat poistaa nämä tiedostot?';
$string['deletecheckfull'] = 'Oletko aivan varma, että haluat pysyvästi poistaa kohteen {$a}?';
$string['deletechecktype'] = 'Haluatko varmasti poistaa tämän {$a->type}?';
$string['deletechecktypename'] = 'Haluatko varmasti poistaa {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Olet aikeissa poistaa nämä tiedostot';
$string['deletecomment'] = 'Poista tämä kommentti';
$string['deletecompletely'] = 'Poista kokonaan';
$string['deletecourse'] = 'Poista kurssi';
$string['deletecoursecheck'] = 'Oletko aivan varma, että haluat poistaa tämän kurssin ja kaikki sen sisältämät tiedot?';
$string['deleted'] = 'Poistettu';
$string['deletedactivity'] = 'Poistettu: {$a}';
$string['deletedcourse'] = '{$a} on kokonaan poistettu';
$string['deletednot'] = 'Ei voi poistaa kohdetta {$a}!';
$string['deletelogs'] = 'Poista lokit';
$string['deleteselected'] = 'Poista valitut';
$string['deleteselectedkey'] = 'Poista valittu avain';
$string['deletingcourse'] = 'Poistetaan {$a}';
$string['deletingexistingcoursedata'] = 'Poistetaan olemassa olevan kurssin tiedot';
$string['deletingolddata'] = 'Poistetaan vanhat tiedot';
$string['department'] = 'Osasto';
$string['desc'] = 'Laskeva';
$string['description'] = 'Kuvaus';
$string['deselectall'] = 'Poista valinnat';
$string['detailedless'] = 'Tiivistetty';
$string['detailedmore'] = 'Yksityiskohtainen';
$string['directory'] = 'Hakemisto';
$string['disable'] = 'Poista käytöstä';
$string['disabledcomments'] = 'Kommentointi on pois käytöstä';
$string['displayingfirst'] = 'Vain ensimmäiset {$a->count} {$a->things} näytetään';
$string['displayingrecords'] = 'Näytetään {$a} tietuetta';
$string['displayingusers'] = 'Näytetään käyttäjät {$a->start} / {$a->end}';
$string['displayonpage'] = 'Näytä sivulla';
$string['dndcourse'] = 'Voit raahata ja pudottaa kurssin haluttuun kohtaan listassa tai toiseen kategoriaan.';
$string['dndenabled_inbox'] = 'Lisää tiedostoja raahaamalla ne hiirellä tähän.';
$string['dndnotsupported'] = 'Raahaaminen (drag&drop) ei toimi tiedostojen lataamisessa.';
$string['dndnotsupported_help'] = 'Selaimesi ei tule raahaamistoimintoa (drag&drop) tiedostojen lataamisessa.';
$string['dndnotsupported_insentence'] = 'Raahaaminen (drag&drop) ei toimi tässä';
$string['dnduploadwithoutcontent'] = 'Tällä ladatulla ei ole sisältöä';
$string['dndworkingfile'] = 'Lataa tiedostoja raahaamalla ne kurssialueen osioihin.';
$string['dndworkingfilelink'] = 'Lataa tiedostoja tai linkkejä raahaamalla ne kurssialueen osioihin.';
$string['dndworkingfiletext'] = 'Lataa tiedostoja tai tekstiä raahaamalla ne kurssialueen osioihin.';
$string['dndworkingfiletextlink'] = 'Lataa tiedostoja, tekstiä tai linkkejä raahaamalla ne kurssialueen osioihin.';
$string['dndworkinglink'] = 'Lataa linkkejä raahaamalla ne kurssialueen osioihin.';
$string['dndworkingtext'] = 'Lataa tekstiä raahaamalla se kurssialueen osioihin.';
$string['dndworkingtextlink'] = 'Lataa tekstiä tai linkkejä raahaamalla ne kurssialueen osioihin.';
$string['documentation'] = 'Moodlen dokumentaatio';
$string['dontsortcategories'] = 'Älä järjestä kategorioita';
$string['dontsortcourses'] = 'Älä järjestä kursseja';
$string['down'] = 'Alas';
$string['download'] = 'Lataa';
$string['downloadall'] = 'Lataa kaikki';
$string['downloadexcel'] = 'Lataa taulukkolaskentamuodossa';
$string['downloadfile'] = 'Lataa tiedosto';
$string['downloadods'] = 'Lataa ODS-muodossa';
$string['downloadtext'] = 'Lataa tekstimuodossa';
$string['doyouagree'] = 'Oletko lukenut käyttöoikeuslisenssin ja ymmärtänyt sen?';
$string['droptoupload'] = 'Lataa tiedostot pudottamalla ne tähän';
$string['duplicate'] = 'Kopioi';
$string['duplicateconfirm'] = 'Oletko varma, että haluat kopioida {$a->modtype} \'{$a->modname}\'?';
$string['duplicatecontcourse'] = 'Palaa kurssille';
$string['duplicatecontedit'] = 'Muokkaa uutta kopiota';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' on monistettu onnistuneesti';
$string['duplicatinga'] = 'Monistetaan: {$a}';
$string['edhelpaspellpath'] = 'Jotta voisit käyttää oikeinkirjoituksen tarkistusta editorissa, sinulla TÄYTYY olla <strong>aspell 0.50</strong> tai sitä uudempi versio asennettuna palvelimellasi ja sinun täytyy määrittää oikea polku aspell-ohjelmalle. Linux/Unix-järjestelmissä tämä polku on tavallisesti strong>/usr/bin/aspell</strong>, mutta se saattaa olla jokin muukin.';
$string['edhelpbgcolor'] = 'Määritä muokkausalueen taustan väri.<br /> Sallittuja arvoja ovat esim #ffffff tai white';
$string['edhelpcleanword'] = 'Suodata Wordin tekemät muotoilut liitettäessä tekstiä.';
$string['edhelpenablespelling'] = 'Oikoluvun käyttö editorissa. Jos asetus on päällä, pitää <strong>aspell</strong> ohjelmiston olla asennettuna palvelimelle.';
$string['edhelpfontfamily'] = 'Kirjasinperhelista valittavissa olevista kirjasinperheistä ja yleisistä kirjasinnimistä. Nimet erotellaan toisistaan pilkuilla.';
$string['edhelpfontlist'] = 'Määrittele valikossa käytettävät kirjasimet.';
$string['edhelpfontsize'] = 'Määritä kirjasimen oletuskoko.<br /> Sallittuja arvoja ovat esim.: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Muokkaa ';
$string['edita'] = 'Muokkaa {$a}';
$string['editcategorysettings'] = 'Muokkaa kategorian asetuksia';
$string['editcategorythis'] = 'Muokkaa tätä kategoriaa';
$string['editcoursesettings'] = 'Muokkaa kurssin asetuksia';
$string['editfiles'] = 'Muokkaa tiedostoja';
$string['editgroupprofile'] = 'Muokkaa ryhmän tietoja';
$string['editinga'] = 'Muokataan {$a}';
$string['editingteachershort'] = 'Muokkausoikeudet';
$string['editlock'] = 'Tätä arvoa ei voi muokata';
$string['editmyprofile'] = 'Muokkaa tietoja';
$string['editorbgcolor'] = 'Taustaväri';
$string['editorcleanonpaste'] = 'Puhdista Word HTML liitettäessä';
$string['editorcommonsettings'] = 'Yleiset asetukset';
$string['editordefaultfont'] = 'Oletuskirjasin';
$string['editorenablespelling'] = 'Käytä oikolukua';
$string['editorfontlist'] = 'Kirjasinlista';
$string['editorfontsize'] = 'Oletuskirjasinkoko';
$string['editorresettodefaults'] = 'Palauta oletukset';
$string['editorsettings'] = 'Editorin asetukset';
$string['editorshortcutkeys'] = 'Editorin pikanäppäimet';
$string['editsettings'] = 'Muokkaa asetuksia';
$string['editsummary'] = 'Muokkaa yhteenvetoa';
$string['editthisactivity'] = 'Muokkaa tätä toimintoa';
$string['editthiscategory'] = 'Muokkaa tätä kategoriaa';
$string['edittitle'] = 'Muokkaa otsikkoa';
$string['edittitleinstructions'] = 'Peru Esc-painikkeella, hyväksy Enter-painikkeella';
$string['edituser'] = 'Muokkaa käyttäjätietoja';
$string['email'] = 'Sähköpostiosoite';
$string['emailactive'] = 'Sähköposti aktivoitu';
$string['emailagain'] = 'Sähköposti (varmistus)';
$string['emailcharset'] = 'Sähköpostin merkistö';
$string['emailconfirm'] = 'Vahvista käyttäjätunnuksesi';
$string['emailconfirmation'] = 'Hei {$a->firstname},

Uusi käyttäjätunnus on rekisteröity \'{$a->sitename}\'
käyttäen sinun osoitettasi.

Vahvistaaksesi käyttäjätunnuksen itsellesi mene selaimellasi osoitteeseen

  {$a->link}

Useimmissa postiohjelmissa sinun tarvitsee vain napsauttaa ylläolevaa linkkiä.
Jos tämä ei toimi, kopioi ja liitä osoite selaimen osoitekenttään.

Terveisin \'{$a->sitename}\' pääkäyttäjä,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: tunnuksen vahvistaminen';
$string['emailconfirmsent'] = '<p>Vahvistusviesti on lähetetty osoitteeseesi <b>{$a}</b></p>
   <p>Se sisältää ohjeet, kuinka voit vahvistaa käyttäjätunnuksesi.</p>
   <p>Jos vahvistuksessa on ongelmia, ota yhteyttä ylläpitäjään.</p>';
$string['emaildigest'] = 'Sähköpostiviestien keräilytapa';
$string['emaildigestcomplete'] = 'Koosteviesti, täydet sisällöt (yksi sähköpostiviesti päivässä)';
$string['emaildigest_help'] = 'Tällä asetuksella määrittelet, miten Moodle lähettää keskustelualueviestejä sähköpostiisi.

* Ei keräilyä: saat sähköpostiviestin kustakin keskustelualueviestistä
* Koosteviesti, täydet sisällöt: saat kerran vuorokaudessa yhden sähköpostiviestin, johon on koostettu kaikki edeltävän vuorokauden aikana kirjoitetut keskustelualueviestit kokonaisuudessan
* Koosteviesti, vain otsikot: saat kerran vuorokaudessa yhden sähköpostiviestin, johon on koostettu otsikot kaikista edeltävän vuorokauden aikana kirjoitetuista keskustelualueviesteistä';
$string['emaildigestoff'] = 'Ei keräilyä (sähköpostiviesti jokaisesta keskustelualueviestistä)';
$string['emaildigestsubjects'] = 'Koosteviesti, vain otsikot (yksi sähköpostiviesti päivässä)';
$string['emaildisable'] = 'Tämä osoite ei ole käytössä.';
$string['emaildisableclick'] = 'Estä kaikki viestit tähän osoitteeseen';
$string['emaildisplay'] = 'Sähköpostiosoitteen näyttö';
$string['emaildisplaycourse'] = 'Vain kurssiosallistujat saavat nähdä osoitteeni';
$string['emaildisplayhidden'] = 'Sähköposti piilotettu';
$string['emaildisplayno'] = 'Piilota osoitteeni kaikilta';
$string['emaildisplayyes'] = 'Näytä osoitteeni kaikille';
$string['emailenable'] = 'Tämä osoite on käytössä.';
$string['emailenableclick'] = 'Salli kaikki viestit tähän osoitteeseen';
$string['emailexists'] = 'Tämä osoite on jo rekisteröity.';
$string['emailformat'] = 'Sähköpostin muotoilu';
$string['emailmustbereal'] = 'Huomaa: sinun pitää käyttää oikeaa osoitetta';
$string['emailnotallowed'] = 'Osoitteita näiltä toimialueilta ei sallita ({$a})';
$string['emailnotfound'] = 'Sähköpostiosoitetta ei löytynyt tietokannasta';
$string['emailonlyallowed'] = 'Tätä osoitetta ei sallita ({$a})';
$string['emailpasswordchangeinfo'] = 'Hei {$a->firstname} {$a->lastname},

olet pyytänyt uutta salasanaa ja lähettänyt käyttäjätunnuksen selvityspyynnön sivustolle \'{$a->sitename}\'.

Vahvistaaksesi salasanan vaihtamisen ja käyttäjätunnuksen selvityspyynnön siirry seuraavaan web-osoitteeseen: {$a->link}

Useimmissa sähköpostiohjelmissa web-osoite näkyy sinisenä linkkinä,
ja voit siirtyä web-osoitteeseen napsauttamalla linkkiä. Jos tämä ei toimi, kopioi osoite selaimen osoitepalkkiin.

Jos tarvitset apua, ota yhteyttä sivuston ylläpitäjään,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hei {$a->firstname},

Joku (luultavasti sinä) on pyytänyt uutta salasanaa
tunnuksellesi sivustolla \'{$a->sitename}\'.

Valitettavasti tunnuksesi sivustollaon poissa käytöstäja salanaa ei voida vaihtaa, joten sinun on otettava
yhteyttä sivuston ylläpitäjään,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hei {$a->firstname},

Joku (luultavasti sinä) on pyytänyt uutta salasanaa
tunnuksellesi sivustolla \'{$a->sitename}\'.

Valitettavasti tämä sivusto ei salli salasanojen
vaihtamista tällä tavoin, joten sinun on otettava
yhteyttä sivuston ylläpitäjään,
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Tietoja salasanan vaihtamisesta';
$string['emailpasswordconfirmation'] = 'Hei {$a->firstname} {$a->lastname},

olet pyytänyt uutta salasanaa ja lähettänyt käyttäjätunnuksen selvityspyynnön sivustolle \'{$a->sitename}\'.

Vahvistaaksesi salasanan vaihtamisen ja käyttäjätunnuksen selvityspyynnön siirry seuraavaan web-osoitteeseen: {$a->link}

Useimmissa sähköpostiohjelmissa web-osoite näkyy sinisenä linkkinä,
ja voit siirtyä web-osoitteeseen napsauttamalla linkkiä. Jos tämä ei toimi, kopioi osoite selaimen osoitepalkkiin.

Jos tarvitset apua, ota yhteyttä sivuston ylläpitäjään,

{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Salasanapyynnön vahvistus.';
$string['emailpasswordconfirmmaybesent'] = '<p>Jos annoit toimivan käyttäjätunnuksen tai sähköpostiosoitteen, sinun pitäisi saada pian sähköpostiviesti.</p> <p>Viestissä on ohjeet salasanan vaihdon ja käyttäjätunnuksen selvityspyynnön vahvistamiseksi. Jos et saa viestiä ota yhteyttä sivuston ylläpitoon</p>';
$string['emailpasswordconfirmsent'] = 'Sinulle on lähetty vahvistusviesti osoitteeseen: <b>{$a}</b>.
<br />Viesti sisältää ohjeet, kuinka voit vahvistaa salasanasi vaihdon.
Jos salasanan vaihdossa on ongelmia, ota yhteyttä sivuston ylläpitoon.';
$string['emailpasswordsent'] = 'Kiitos salasananvaihdon varmistamisesta.
Uusi salasanasi on lähetty sähköpostilla osoitteeseen: {$a->email}.';
$string['emailresetconfirmation'] = 'Hei {$a->firstname},

Tilillesi \'{$a->username}\' pyydettiin salasanan muutosta sivustolla {$a->sitename}.

Vahvistaaksesi tämän pyynnön ja muuttaaksesi tilisi salasanan, mene seuraavaan verkko-osoitteeseen:

{$a->link}
(Tämä linkki on voimassa {$a->resetminutes} minuuttia salasanan muutospyynnöstä lähtien)

Jos et itse pyytänyt salasanan muutosta, sinun ei tarvitse tehdä mitään.

Jos tarvitset apua, ota yhteyttä sivuston ylläpitäjään,
{$a->admin}';
$string['enable'] = 'Ota käyttöön';
$string['encryptedcode'] = 'Salattu koodi';
$string['english'] = 'Englanti';
$string['entercourse'] = 'Napsauta päästäksesi kurssille';
$string['enteremail'] = 'Syötä sähköpostiosoitteesi';
$string['enteremailaddress'] = 'Anna sähköpostiosoitteesi, jotta uusi salasana voidaan lähettää sinulle.';
$string['enterusername'] = 'Syötä käyttäjätunnuksesi';
$string['entries'] = 'Merkinnät';
$string['error'] = 'Virhe';
$string['errorcreatingactivity'] = 'Instanssia aktiviteetista \'{$a}\' ei voitu luoda';
$string['errorfiletoobig'] = 'Tiedosto oli suurempi kuin raja {$a} byteä';
$string['errornouploadrepo'] = 'Tällä sivustolla ei ole ladattujen tiedostojen repositoriota';
$string['errorwhenconfirming'] = 'Virheen takia sinua ei ole vielä tunnistettu. Jos tulit tänne sähköpostissa olleen linkin kautta, varmista, että linkki ei ole hajonnut osiin usealle riville. Voit ehkä korjata linkin liittämällä osat yhteen.';
$string['everybody'] = 'Kaikki';
$string['executeat'] = 'Suorita';
$string['existing'] = 'Olemassa oleva';
$string['existingadmins'] = 'Ylläpitäjät';
$string['existingcourse'] = 'Olemassa oleva kurssi';
$string['existingcourseadding'] = 'Olemassa oleva kurssi, lisätään tiedot';
$string['existingcoursedeleting'] = 'Olemassa oleva kurssi, poistetaan ensin';
$string['existingcreators'] = 'Kurssiylläpitäjät';
$string['existingstudents'] = 'Opiskelijat';
$string['existingteachers'] = 'Opettajat';
$string['expandall'] = 'Näytä kaikki';
$string['explanation'] = 'Selitys';
$string['extendenrol'] = 'Kurssialueelle liittymisaikaa jatkettu (henkilökohtainen)';
$string['extendperiod'] = 'Jatkettu jakso';
$string['failedloginattempts'] = '{$a->attempts} epäonnistunutta kirjautumisyritystä viime käyntisi jälkeen.';
$string['failedloginattemptsall'] = '{$a->attempts} epäonnistunutta kirjautumisyritystä {$a->accounts} tunnukselle.';
$string['feedback'] = 'Palaute';
$string['file'] = 'Tiedosto';
$string['fileexists'] = 'Tiedosto, jolla on nimi {$a}, on jo olemassa';
$string['filemissing'] = '{$a} puuttuu';
$string['files'] = 'Tiedostot';
$string['filesanduploads'] = 'Tiedostojen kokoraja';
$string['filesfolders'] = 'Tiedostot/kansiot';
$string['filetoolarge'] = 'on liian suuri ladattavaksi';
$string['fileuploadwithcontent'] = 'Tiedoston latauksen ei pitäisi sisältää sisältöparametria.';
$string['filloutallfields'] = 'Ole hyvä ja täytä lomakkeen kaikki kentät.';
$string['filter'] = 'Suodatin';
$string['findmorecourses'] = 'Etsi lisää kursseja...';
$string['firstaccess'] = 'Ensimmäinen kirjautuminen';
$string['firstname'] = 'Etunimi';
$string['firstnamephonetic'] = 'Etunimi - foneettinen';
$string['firsttime'] = 'Jos sinulla ei ole vielä tunnusta:';
$string['folder'] = 'Kansio';
$string['folderclosed'] = 'Suljettu kansio';
$string['folderopened'] = 'Avattu kansio';
$string['followingoptional'] = 'Seuraavat tiedot ovat vapaaehtoisia';
$string['followingrequired'] = 'Seuraavat tiedot pitää täyttää';
$string['force'] = 'Pakota';
$string['forcelanguage'] = 'Pakota kielivalinta';
$string['forceno'] = 'Älä pakota';
$string['forcepasswordchange'] = 'Pakota salasanan vaihto';
$string['forcepasswordchangecheckfull'] = 'Oletko varma, että haluat ottaa käyttöön salasanan pakotetun vaihtamisen: {$a}?';
$string['forcepasswordchange_help'] = 'Jos valintalaatikko on valittuna, käyttäjä pakotetaan vaihtamaan salasanansa seuraavan sisäänkirjautumisen yhteydessä.';
$string['forcepasswordchangenot'] = 'Salasanan pakotettua vaihtamista ei voida ottaa käyttöön: {$a}';
$string['forcepasswordchangenotice'] = 'Sinun pitää vaihtaa salasanasi ennen kuin voit jatkaa.';
$string['forcetheme'] = 'Pakota teema';
$string['forgotaccount'] = 'Unohditko salasanasi?';
$string['forgotten'] = 'Unohditko käyttäjätunnuksesi tai salasanasi?';
$string['forgottenduplicate'] = 'Tätä sähköpostiosoitetta käyttää useampi kuin yksi käyttäjä, anna käyttäjätunnus sähköpostiosoitteen sijaan';
$string['forgotteninvalidurl'] = 'Virheellinen salasanan vaihdon verkko-osoite';
$string['format'] = 'Kurssimuoto';
$string['format_help'] = 'Moodlen kurssimuodot

<p>Tyypillisimmin käytetyt kurssimuodot ovat Viikot ja Aiheet. Saattaa myös olla, että jokin tämän listan kurssimuodoista ei ole käytettävissä organisaatiossasi.</p>

<p><b>Viikot</b></p>
<blockquote>
Kurssialue muodostuu peräkkäisistä kurssiviikoista, ja työskentelyllä on selkeät aloitus- ja lopetuspäivät. Kullekin kurssiviikolle voit sitten lisätä haluamasi aktiviteetit ja resurssit. Huomaa, että kurssiviikko voi alkaa minä tahansa kalenteriviikon päivänä ja sen kesto on aina 7 päivää.
</blockquote>

<p><b>Aiheet</b></p>
<blockquote>
Kurssin jäsentelyn kannalta tämä on usein vastaava kuin viikkomuoto, paitsi että jokaista "viikkoa" kutsutaan "aiheeksi", ja "aiheita" ei ole rajoitettu tiettyyn aikaan. Sinun ei tarvitse määritellä tarkkoja kurssipäivämääriä.
</blockquote>

<p><b>Keskustelu</b></p>
<blockquote>
Tämä muoto keskittyy yhteen Keskustelualueeseen, joka näkyy kurssialueen luettelossa. Keskustelumuoto on käytännöllinen vapaampimuotoisissa tilanteissa, joiden ei välttämättä tarvitse olla kursseja. Tämä muoto soveltuu käytettäväksi esimerkiksi osaston ilmoitustauluna. Huomaa, että muita aktiviteetteja tai resursseja kuin keskusteluja ei voi lisätä.
</blockquote>

<p><b>SCORM-sisällöt</b></p>

<blockquote>
Tämä muoto esittää SCORM-standardin mukaisesti toteutettua sisältöä kurssialueen ylimmässä lohkossa. Toinen vaihtoehto lisätä SCORM-muotoista sisältöä kurssialueelle on käyttää SCORM/AICC-aktiviteettia.
</blockquote>

<p><b>Viikot CSS-muotoiltuna</b></p>

<blockquote>
Kurssin rakenne on viikoittainen kuten viikkomuodossa. Ulkoasu eroaa hieman viikkomuodosta siten, että viikkolohkot piirretään ilman taulukkoreunuksia.
</blockquote>';
$string['formathtml'] = 'HTML-muoto';
$string['formatmarkdown'] = 'Markdown-muoto';
$string['formatplain'] = 'Pelkkää tekstiä';
$string['formattext'] = 'Automaattimuotoilu';
$string['formattexttype'] = 'Muotoilu';
$string['framesetinfo'] = 'Tämä kehysrakenne sisältää:';
$string['from'] = 'Alkaen';
$string['frontpagecategorycombo'] = 'Yhdistelmälista';
$string['frontpagecategorynames'] = 'Näytä kategorialista';
$string['frontpagecourselist'] = 'Näytä kurssilista';
$string['frontpagedescription'] = 'Etusivun yhteenveto';
$string['frontpagedescriptionhelp'] = 'Tämä yhteenveto voidaan näyttää kurssialueella, kun käytät Yhteenveto-lohkoa tai sisällyttämällä se johonkin kurssialueen osioon.';
$string['frontpageformat'] = 'Etusivun muoto';
$string['frontpageformatloggedin'] = 'Etusivun muoto kirjautumisen yhteydessä';
$string['frontpagenews'] = 'Näytä uutisaiheet';
$string['frontpagesettings'] = 'Etusivun asetukset';
$string['fulllistofcourses'] = 'Kaikki kurssit';
$string['fullname'] = 'Koko nimi';
$string['fullnamecourse'] = 'Kurssin nimi';
$string['fullnamecourse_help'] = 'Kurssin nimi on se tieto, joka näkyy ylinnä kurssialueen kullakin sivulla sekä opiskelijoille kurssilistoissa kurssikategorian alla ja mymoodle-sivulla, ja jolla opiskelijat siis voivat löytää kurssisi kurssilistasta myös Hae kurssia -kentän kautta.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Koko nimi';
$string['fullprofile'] = 'Kaikki käyttäjätiedot';
$string['fullsitename'] = 'Koko sivuston nimi';
$string['functiondisabled'] = 'Tämä toiminnallisuus ei ole käytössä';
$string['general'] = 'Yleinen';
$string['geolocation'] = 'leveysaste - pituuspiiri';
$string['gettheselogs'] = 'Hae lokit';
$string['go'] = 'Hae';
$string['gpl'] = 'Copyright (C) vuodesta 1999 alkaen Martin Dougiamas  (http://moodle.com)

(Epävirallisen suomenkielisen käännöksen lisenssistä löydät  osoitteesta: http://www.turre.com/licenses/gpl_fi.php)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details:
http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Copyright (C) 1999  Martin Dougiamas  (http://Moodle.com)

(Epävirallisen suomenkielisen käännöksen lisenssistä löydät  osoitteesta: http://www.turre.com/licenses/gpl_fi.php)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details:

http://www.gnu.org/copyleft/gpl.html';
$string['gpllicense'] = 'GPL-lisenssi';
$string['grade'] = 'Arviointi';
$string['grades'] = 'Arvioinnit';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a>-kuvapalvelu on käytössä tässä Moodlessa. Jos et halua lisätä Moodleen omaa profiilikuvaa, Moodle voi hakea kuvasi <a href="http://www.gravatar.com/">Gravatar</a>-kuvapalvelusta.';
$string['group'] = 'Ryhmä';
$string['groupadd'] = 'Lisää ryhmä';
$string['groupaddusers'] = 'Lisää valitut ryhmään';
$string['groupextendenrol'] = 'Jatka kaikkien osallistumista (yleinen)';
$string['groupfor'] = 'ryhmälle';
$string['groupinfo'] = 'Tietoa valitusta ryhmästä';
$string['groupinfoedit'] = 'Muokkaa ryhmän asetuksia';
$string['groupinfomembers'] = 'Tietoa valituista ryhmän jäsenistä';
$string['groupinfopeople'] = 'Tietoa valituista henkilöistä';
$string['groupmembers'] = 'Ryhmän jäsenet';
$string['groupmemberssee'] = 'Katso ryhmän jäsenet';
$string['groupmembersselected'] = 'Valitun ryhmän jäsenet';
$string['groupmode'] = 'Ryhmien käyttö';
$string['groupmodeforce'] = 'Pakotettu ryhmien käyttö';
$string['groupmy'] = 'Ryhmäni';
$string['groupnonmembers'] = 'Ryhmättömät henkilöt';
$string['groupnotamember'] = 'Valitettavasti et ole kyseisen ryhmän jäsen';
$string['grouprandomassign'] = 'Liitä kaikki satunnaisesti ryhmiin';
$string['groupremove'] = 'Poista valittu ryhmä';
$string['groupremovemembers'] = 'Poista valitut jäsenet';
$string['groups'] = 'Ryhmät';
$string['groupsnone'] = 'Ei ryhmiä';
$string['groupsseparate'] = 'Erilliset ryhmät';
$string['groupsvisible'] = 'Näkyvät ryhmät';
$string['guest'] = 'Vierailija';
$string['guestdescription'] = 'Vierailijoilla on vain lukuoikeus kurssialueella.';
$string['guestskey'] = 'Salli vierailijat, joilla on avain';
$string['guestsno'] = 'Älä salli vierailijoita';
$string['guestsnotallowed'] = '\'{$a}\' ei salli vierailijoiden liittyä.';
$string['guestsyes'] = 'Salli vierailijat ilman avainta';
$string['guestuser'] = 'Vierailija';
$string['guestuserinfo'] = 'Tällä tunnuksella on vain lukuoikeudet.';
$string['help'] = 'Ohje';
$string['helpprefix2'] = 'Toiminnon {$a} ohje';
$string['helpwiththis'] = 'Avusta tässä';
$string['hiddenassign'] = 'Piilotettu tehtävä';
$string['hiddenfromstudents'] = 'Piilotettu opiskelijoilta';
$string['hiddensections'] = 'Piilotetut osiot';
$string['hiddensectionscollapsed'] = 'Piilotetut osiot näytetään tiivistetyssä muodossa';
$string['hiddensections_help'] = '<p>T&auml;m&auml; vaihtoehto sallii sinun p&auml;&auml;tt&auml;&auml; miten piilotetut osiot kurssillasi n&auml;kyv&auml;t opiskelijoille. </p>

<p>Oletuksena n&auml;ytett&auml;&auml;n pieni alue (supistetussa muodossa, yleens&auml; harmaana) viittauksena siit&auml; miss&auml; piilotettu osio on. Vaikka he eiv&auml;t silti n&auml;e piilotettuja toimintoja ja tekstej&auml;. T&auml;m&auml; on erityisen k&auml;yt&auml;nn&ouml;llist&auml; viikoittaisessa muodossa, jolloin viikot joilla ei ole luentoja, ovat tyhji&auml;.</p>
<p>Jos haluat, n&auml;m&auml; voivat olla my&ouml;s kokonaan piilotettuja, jolloin opiskelijat eiv&auml;t edes tied&auml;, ett&auml; osioita kurssista on piilotettuina.</p>';
$string['hiddensectionsinvisible'] = 'Piilotetut osiot ovat kokonaan näkymättömissä';
$string['hide'] = 'Piilota';
$string['hideadvancedsettings'] = 'Piilota lisäasetukset';
$string['hidepicture'] = 'Piilota kuva';
$string['hidesection'] = 'Piilota osio {$a}';
$string['hidesettings'] = 'Piilota asetukset';
$string['hideshowblocks'] = 'Piilota tai näytä lohkoja';
$string['hits'] = 'Vierailut';
$string['hitsoncourse'] = 'Käyttäjän {$a->username} vierailut kurssilla {$a->coursename}';
$string['hitsoncoursetoday'] = 'Tämän päivän vierailut kurssilla {$a->coursename}';
$string['home'] = 'Moodle';
$string['hour'] = 'tunti';
$string['hours'] = 'tuntia';
$string['howtomakethemes'] = 'Kuinka tehdä uusia teemoja';
$string['htmleditor'] = 'Käytä tekstinmuotoilunäkymää (rich text)';
$string['htmleditoravailable'] = 'Richtext-editori on käytettävissä';
$string['htmleditordisabled'] = 'Olet poistanut Richtext-editorin käytön käyttäjätiedoissasi.';
$string['htmleditordisabledadmin'] = 'Pääkäyttäjä on estänyt Richtext-editorin käytön';
$string['htmleditordisabledbrowser'] = 'Richtext-editori ei ole saatavilla.';
$string['htmlfilesonly'] = 'Vain HTML-tiedostoja';
$string['htmlformat'] = 'HTML-muotoilu';
$string['icon'] = 'Ikoni';
$string['icqnumber'] = 'ICQ-numero';
$string['idnumber'] = 'Tunnistenumero';
$string['idnumbercourse'] = 'Kurssin tunnistenumero';
$string['idnumbercoursecategory'] = 'Kategorian tunnistenumero';
$string['idnumbercoursecategory_help'] = 'Kurssikategorian ID-numeroa käytetään vain kun kategoriaa verrataan ulkoisiin järjestelmiin, eikä sitä näytetä missään sivustolla. Jos kategorialla on virallinen koodinimi se voidaan syöttää, muuten kenttä voidaan jättää tyhjäksi.';
$string['idnumbercourse_help'] = 'Kurssin tunnistenumeroa käytetään vain, kun kurssia verrataan ulkoisiin järjestelmiiin. Sitä ei koskaan näytetä Moodlen sisällä. Jos sinulla on virallinen koodinimi kurssille, käytä sitä tässä. Muuten voit jättää kohdan tyhjäksi.';
$string['idnumbergroup'] = 'Ryhmän tunniste';
$string['idnumbergroup_help'] = 'Ryhmän tunnistetta käytetään vain ryhmän yhdistämisessä ulkopuolisiin järjestelmiin eikä sitä näytetä missään Moodlen sisäisesti. Jos ryhmällä on virallinen nimi, voit lisätä sen tähän; muussa tapauksessa jätä kenttä tyhjäksi.';
$string['idnumbergrouping'] = 'Ryhmittelyn tunnistenumero';
$string['idnumbergrouping_help'] = 'Ryhmittelyn tunnistetta käytetään vain ryhmittelyn yhdistämisessä ulkopuolisiin järjestelmiin eikä sitä näytetä missään Moodlen sisäisesti. Jos ryhmittelyllä on virallinen nimi, voit lisätä sen tähän; muussa tapauksessa jätä kenttä tyhjäksi.';
$string['idnumbermod'] = 'Tunnistenumero';
$string['idnumbermod_help'] = 'ID-numeron asetus antaa mahdollisuuden tunnistaa aktiviteetti arvosanan laskennassa. Jos tietty aktiviteetti ei sisälly mihinkään arvosanaan voidaan ID-numeron kenttä jättää tyhjäksi.

ID-kentän voi määritellä myös Arvioinnit-sivulla, tosin sitä voi muokata ainoastaan aktiviteetin asetuksista.';
$string['idnumbertaken'] = 'Tämä tunnistenumero on jo käytössä';
$string['imagealt'] = 'Kuvan kuvaus';
$string['import'] = 'Tuo';
$string['importdata'] = 'Tuo kurssin tiedot';
$string['importdataexported'] = 'Tietojen vieminen kurssilta \'from\' onnistui.<br />
Jatka tuodaksesi tiedot \'to\' kurssille.';
$string['importdatafinished'] = 'Tietojen tuominen valmis! Voit jatkaa kurssillesi';
$string['importdatafrom'] = 'Etsi kurssi, jolta tuodaan tiedot:';
$string['inactive'] = 'Ei käytössä';
$string['include'] = 'Ota mukaan';
$string['includeallusers'] = 'Ota mukaan kaikki käyttäjät';
$string['includecoursefiles'] = 'Ota mukaan kurssin tiedostot';
$string['includecourseusers'] = 'Ota mukaan kurssin osallistujat';
$string['included'] = 'Sisältyy';
$string['includelogentries'] = 'Ota mukaan tapahtumaloki';
$string['includemodules'] = 'Sisällytä moduulit';
$string['includemoduleuserdata'] = 'Sisällytä moduulien käyttäjädata';
$string['includeneededusers'] = 'Ota mukaan tarvittavat käyttäjät';
$string['includenoneusers'] = 'Älä ota mukaan käyttäjiä';
$string['includeroleassignments'] = '... roolien jaot';
$string['includesitefiles'] = 'Ota mukaan kurssilla käytetyt sivuston tiedostot';
$string['includeuserfiles'] = 'Ota mukaan käyttäjien tiedostot';
$string['increasesections'] = 'Lisää osioita';
$string['info'] = 'Tiedot';
$string['institution'] = 'Laitos';
$string['instudentview'] = 'opiskelijan näkymässä';
$string['interests'] = 'Kiinnostukset';
$string['interestslist'] = 'Kiinnostuksenkohteet';
$string['interestslist_help'] = 'Syötä kiinnostuksenkohteitasi pilkulla erotettuna. Kiinnostuksenkohteesi näytetään profiilisivullasi tageina.';
$string['invalidemail'] = 'Virheellinen sähköpostiosoite';
$string['invalidlogin'] = 'Kirjautuminen epäonnistui , yritä uudelleen';
$string['invalidusername'] = 'Käyttäjänimi voi sisältää vain pieniä kirjaimia, numeroita, alaviivan (_), pisteen (.) tai at-symbolin (@)';
$string['invalidusernameupload'] = 'Epäkelpo käyttäjänimi';
$string['ip_address'] = 'IP-osoite';
$string['jump'] = 'Siirry';
$string['jumpto'] = 'Siirry...';
$string['keep'] = 'Pidä';
$string['keepsearching'] = 'Jatka etsintää';
$string['langltr'] = 'Kirjoitussuunta vasemmalta oikealle';
$string['langrtl'] = 'Kirjoitussuunta oikealta vasemmalle';
$string['language'] = 'Kieli';
$string['languagegood'] = 'Tämä kielipaketti on ajan tasalla! :-)';
$string['lastaccess'] = 'Viimeksi käytetty';
$string['lastedited'] = 'Viimeksi muokattu';
$string['lastlogin'] = 'Viimeisin kirjautuminen';
$string['lastmodified'] = 'Viimeksi muutettu';
$string['lastname'] = 'Sukunimi';
$string['lastnamephonetic'] = 'Sukunimi - foneettinen';
$string['lastyear'] = 'Viime vuosi';
$string['latestlanguagepack'] = 'Tarkista moodle.org-sivuilta uusin kielipaketti';
$string['layouttable'] = 'Asettelutaulukko';
$string['leavetokeep'] = 'Jätä tyhjäksi säilyttääksesi nykyisen salasanasi.';
$string['legacythemeinuse'] = 'Tämä sivu näytetään yhteensopivuustilassa koska selaimesi on liian vanha.';
$string['license'] = 'Lisenssi';
$string['licenses'] = 'Lisenssit';
$string['liketologin'] = 'Haluatko kirjautua sisään nyt täydellä käyttäjätilillä?';
$string['list'] = 'Lista';
$string['listfiles'] = 'Lista tiedostoista {$a}:ssa';
$string['listofallpeople'] = 'Kaikki henkilöt';
$string['listofcourses'] = 'Lista kursseista';
$string['local'] = 'Paikallinen';
$string['localplugins'] = 'Paikalliset lisäosat';
$string['localpluginsmanage'] = 'Hallitse paikallisia lisäosia';
$string['location'] = 'Sijainti';
$string['log_excel_date_format'] = 'yyyy mmmmm d h:mm';
$string['loggedinas'] = 'Olet kirjautunut nimellä  {$a}.';
$string['loggedinasguest'] = 'Käytät vierailijatunnusta';
$string['loggedinnot'] = 'Et ole kirjautunut.';
$string['login'] = 'Kirjaudu';
$string['loginalready'] = 'Olet jo kirjautunut';
$string['loginas'] = 'Kirjaudu käyttäjänä';
$string['loginaspasswordexplain'] = '<p>Sinun pitää antaa erityinen "Kirjaudu toisena" -salasana.<br />Ellet tiedä sitä, kysy ohjeita järjestelmän ylläpitäjältä.</p>';
$string['login_failure_logs'] = 'Kirjautumisvirhelokit';
$string['loginguest'] = 'Kirjaudu vierailijana';
$string['loginsite'] = 'Kirjaudu sivustoon';
$string['loginsteps'] = 'Hei!

Päästäksesi kurssialueille luo ensin itsellesi käyttäjätunnus ja salasana sivustoon. Joillekin kurssialueille saatat tarvita ensimmäisellä kerralla kurssiavaimen, jonka saat tarvittaessa opettajaltasi. Luo tunnus näin:
   <ol>
   <li>Täytä lomake <a href="{$a}">uusi tunnus</a> henkilötiedoillasi.</li>
   <li>Saat sähköpostitse vahvistusviestin antamaasi osoitteeseen. Jos tarkistusviestiä ei kuulu, tarkistathan roskapostilaatikon.</li>
   <li>Saamassasi vahvistusviestissä on linkki; napsauta sitä.</li>
   <li>Tunnuksesi vahvistetaan ja sinut kirjataan sisään Moodleen.</li>
   <li>Valitse kurssialue, jolle haluat päästä.</li>
   <li>Jos kurssialueelle pääsy vaatii avaimen, kirjoita se vastaavaan kenttään.</li>
   <li>Tämän jälkeen pääset kurssialueelle. Jatkossa pääset kurssialueillesi kirjautumalla Moodleen ja valitsemalla haluamasi kurssialueen Katsaus kursseistani -sivulta.</li>
   </ol>';
$string['loginstepsnone'] = '<p>Hei!</p>
<p>Jotta voisit käyttää kursseja, sinun pitää luoda itsellesi
käyttäjätunnus. Luot vain itsellesi käyttäjätunnuksen ja salasanan, sitten käytät niitä tällä sivulla. Jos käyttäjätunnus on jo varattu, sinun pitää valita toinen käyttäjätunnus.</p>';
$string['loginto'] = 'Kirjaudu {$a}';
$string['logout'] = 'Kirjaudu ulos';
$string['logoutconfirm'] = 'Haluatko todella kirjautua ulos?';
$string['logs'] = 'Tapahtumat';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">näytä lisää</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">näytä lisää</a> ]';
$string['lookback'] = 'Katso taaksepäin';
$string['mailadmins'] = 'Tiedota ylläpitäjiä';
$string['mailstudents'] = 'Tiedota käyttäjiä';
$string['mailteachers'] = 'Tiedota opettajia';
$string['makeafolder'] = 'Luo kansio';
$string['makeeditable'] = 'Jos annat WWW-palvelimelle kirjoitusoikeudet kansioon \'{$a}\', voit muokata tätä tiedostoa suoraan tältä sivulta.';
$string['makethismyhome'] = 'Tee tästä oletuskotisivuni';
$string['manageblocks'] = 'Lohkot';
$string['managecategorythis'] = 'Muokkaat tätä kategoriaa';
$string['managecourses'] = 'Kurssien hallinta';
$string['managedatabase'] = 'Tietokanta';
$string['manageeditorfiles'] = 'Hallitse editorin käyttämiä tiedostoja';
$string['managefilters'] = 'Suodattimet';
$string['managemodules'] = 'Moduulit';
$string['manageroles'] = 'Roolit ja käyttöoikeudet';
$string['markedthistopic'] = 'Tämä aihe on merkitty aktiiviseksi';
$string['markthistopic'] = 'Merkitse tämä aihe aktiiviseksi.';
$string['matchingsearchandrole'] = 'Verrataan \'{$a->search}\' ja {$a->role}';
$string['maxfilesize'] = 'Uusien tiedostojen maksimikoko: {$a}';
$string['maxfilesreached'] = 'Saat lisätä tähän korkeintaan {$a} tiedostoa liitteiksi';
$string['maximumchars'] = 'Korkeintaan {$a} merkkiä';
$string['maximumgrade'] = 'Arviointimaksimi';
$string['maximumgradex'] = 'Maksimiarvosana: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Suurin lähetyskoko';
$string['maximumupload_help'] = '<p>T&auml;m&auml; asetus m&auml;&auml;ritt&auml;&auml; suurimman koon tiedostolle, jonka opiskelija voi ladata t&auml;lle kurssille, ja se on rajattu sivuston laajuisten asetusten kautta yll&auml;pit&auml;j&auml;n taholta.</p>
<p>Voit myös rajoittaa lähetysten kokoa lisää jokaisen toimintamoduulin asetusten kautta erikseen.</p>';
$string['maxnumberweeks'] = 'Osioiden enimmäismäärä';
$string['maxnumberweeks_desc'] = 'Osioiden enimmäismäärä pudotusvalikossa - sovelletaan vain osaan kurssimuodoista.';
$string['maxnumcoursesincombo'] = 'Selaa <a href="{$a->link}">{$a->numberofcourses} kurssia</ a>.';
$string['maxsize'] = 'Suurin koko: {$a}';
$string['maxsizeandareasize'] = 'Uusien tiedostojen kokoraja: {$a->size}, alueen kokonaiskoko: {$a->areasize}';
$string['maxsizeandattachments'] = 'Uusien tiedostojen kokoraja: {$a->size} ja liitetiedostojen maksimimäärä: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Uusien tiedostojen kokoraja:  {$a->size}, liitetiedostojen enimmäismäärä: {$a->attachments}, kurssialueen kokoraja: {$a->areasize}';
$string['memberincourse'] = 'Kurssin osallistujat';
$string['messagebody'] = 'Viestin sisältö';
$string['messagedselectedusers'] = 'Valituille käyttäjille on lähetetty viesti ja vastaanottajalista on tyhjätty.';
$string['messagedselectedusersfailed'] = 'Viestien lähettämisessä tapahtui virhe. Osa käyttäjistä on silti saattanut saada viestin.';
$string['messageprovider:availableupdate'] = 'Olemassa olevat päivitysilmoitukset';
$string['messageprovider:backup'] = 'Varmuuskopioilmoitukset';
$string['messageprovider:badgecreatornotice'] = 'Osaamismerkin antamiseen liittyvät asetukset';
$string['messageprovider:badgerecipientnotice'] = 'Osaamismerkin vastaanottamiseen liittyvät asetukset';
$string['messageprovider:courserequestapproved'] = 'Ilmoitus kurssialuetilauksen hyväksymisestä';
$string['messageprovider:courserequested'] = 'Ilmoitus kurssialuetilauksesta';
$string['messageprovider:courserequestrejected'] = 'Ilmoitus kurssialuetilauksen hylkäämisestä';
$string['messageprovider:errors'] = 'Sivuston vakavat virheet';
$string['messageprovider:errors_help'] = 'Nämä ovat vakavia virheitä joista ylläpitäjän pitäisi tietää.';
$string['messageprovider:instantmessage'] = 'Henkilökohtaiset viestit käyttäjien välillä';
$string['messageprovider:instantmessage_help'] = 'Tämä osio määrittelee mitä tapahtuu niille viesteille mitä sinulle on lähetetty suoraan tämän sivuston muilta käyttäjiltä.';
$string['messageprovider:notices'] = 'Huomautukset pienistä ongelmista';
$string['messageprovider:notices_help'] = 'Nämä ovat huomautuksia, jotka ylläpitäjä todennäköisesti haluaisi nähdä.';
$string['messageselect'] = 'Valitse tämä käyttäjä viestin vastaanottajaksi';
$string['messageselectadd'] = 'Lähetä viesti';
$string['middlename'] = 'Keskimmäinen nimi';
$string['migratinggrades'] = 'Muunnetaan arvosanat';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minuutti';
$string['minutes'] = 'minuuttia';
$string['miscellaneous'] = 'Muut';
$string['missingcategory'] = 'Sinun pitää valita kategoria';
$string['missingcity'] = 'Puuttuva kaupunki/paikkakunta';
$string['missingcountry'] = 'Puuttuva maa';
$string['missingdescription'] = 'Puuttuva kuvaus';
$string['missingemail'] = 'Puuttuva sähköpostiosoite';
$string['missingfirstname'] = 'Puuttuva etunimi';
$string['missingfromdisk'] = 'Puuttuu levyltä';
$string['missingfullname'] = 'Puuttuva koko nimi';
$string['missinglastname'] = 'Puuttuva sukunimi';
$string['missingname'] = 'Puuttuva nimi';
$string['missingnewpassword'] = 'Puuttuva uusi salasana';
$string['missingpassword'] = 'Puuttuva salasana';
$string['missingrecaptchachallengefield'] = 'Puuttuva roskapostivarmenteen haastekenttä';
$string['missingreqreason'] = 'Puuttuva syy';
$string['missingshortname'] = 'Puuttuva lyhenne';
$string['missingshortsitename'] = 'Puuttuva sivuston lyhyt nimi';
$string['missingsitedescription'] = 'Puuttuva sivuston kuvaus';
$string['missingsitename'] = 'Puuttuva sivuston nimi';
$string['missingstrings'] = 'Tarkista kääntämättömät sanat ja ilmaisut';
$string['missingstudent'] = 'Sinun pitää valita jotain';
$string['missingsummary'] = 'Puuttuva yhteenveto';
$string['missingteacher'] = 'Pitää valita jotain';
$string['missingurl'] = 'Puuttuva verkko-osoite';
$string['missingusername'] = 'Puuttuva käyttäjänimi';
$string['modchooserdisable'] = 'Aktiviteettien valitsin pois päältä';
$string['modchooserenable'] = 'Aktiviteettien valitsin päällä';
$string['moddoesnotsupporttype'] = 'Aktiviteetti {$a->modname} ei tue tyypin {$a->type} latausta';
$string['modified'] = 'Muokattu';
$string['moduleintro'] = 'Kuvaus';
$string['modulesetup'] = 'Asetetaan taulut moduuleille';
$string['modulesuccess'] = '{$a} taulut asetettu';
$string['month'] = 'Kuukausi';
$string['months'] = 'Kuukaudet';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Tämä sivu Moodle Docs -sivustolla';
$string['moodlerelease'] = 'Moodlen julkaisu';
$string['moodleversion'] = 'Moodlen versio';
$string['more'] = 'lisää';
$string['morehelp'] = 'Lisää apua';
$string['moreinformation'] = 'Lisätietoja virheestä';
$string['moreprofileinfoneeded'] = 'Kerro lisää itsestäsi';
$string['mostrecently'] = 'viimeisimmät';
$string['move'] = 'Siirrä';
$string['movecategorycontentto'] = 'Siirrä kohteeseen';
$string['movecategoryto'] = 'Siirrä kategoria kohtaan:';
$string['movecontent'] = 'Siirrä {$a}';
$string['movecontentstoanothercategory'] = 'Siirrä sisältö toiseen kategoriaan';
$string['movecoursemodule'] = 'Siirrä';
$string['movecoursesection'] = 'Siirrä osio';
$string['movecourseto'] = 'Siirrä kurssi kohtaan:';
$string['movedown'] = 'Siirrä alas';
$string['movefilestohere'] = 'Siirrä tiedostot tänne';
$string['movefull'] = 'Siirrä {$a} tähän';
$string['movehere'] = 'Siirrä tänne';
$string['moveleft'] = 'Siirrä vasemmalle';
$string['moveright'] = 'Siirrä oikealle';
$string['movesection'] = 'Siirrä osio {$a}';
$string['moveselectedcategoriesto'] = 'Siirrä valitut kategoriat';
$string['moveselectedcoursesto'] = 'Siirrä valitut kurssit kohtaan';
$string['movetoanotherfolder'] = 'Siirrä toiseen kansioon';
$string['moveup'] = 'Siirrä ylös';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Uuden salasanan on oltava eri kuin nykyinen';
$string['mustconfirm'] = 'Vahvista kirjautumisesi';
$string['mycourses'] = 'Omat kurssini';
$string['myfiles'] = 'Omat yksityiset tiedostoni';
$string['myfilesmanage'] = 'Hallitse yksityisiä tiedostoja';
$string['myhome'] = 'Katsaus kursseistani';
$string['mymoodledashboard'] = 'Oman Moodleni (My Moodle) -kojelauta';
$string['myprofile'] = 'Oma profiilini';
$string['name'] = 'Nimi';
$string['nameforlink'] = 'Minkä nimen haluat antaa tälle linkille?';
$string['nameforpage'] = 'Minkä nimen haluat antaa tälle sivulle?';
$string['navigation'] = 'Navigaatio';
$string['needed'] = 'Tarvittavat';
$string['never'] = 'Ei koskaan';
$string['neverdeletelogs'] = 'Älä poista tapahtumia';
$string['new'] = 'Uusi';
$string['newaccount'] = 'Uusi tunnus';
$string['newcourse'] = 'Uusi kurssi';
$string['newpassword'] = 'Uusi salasana';
$string['newpasswordfromlost'] = '<strong>HUOMAA:</strong> Sinun <strong>Nykyinen salasanasi</strong> on lähetetty <strong>toisena</strong> kahdesta viestistä. Tarkista että olet saanut uuden salasanasi ennen kuin jatkat tästä näytöstä eteenpäin.';
$string['newpassword_help'] = 'Syötä uusi salasana tai jätä tyhjäksi pitääksesi nykyisen salasanasi';
$string['newpasswordtext'] = 'Hei {$a->firstname} {$a->lastname},

Käyttäjätunnuksesi on nyt selvitetty ja salasanasi sivustolla \'{$a->sitename}\' on vaihdettu ja sinulle on annettu uusi tilapäinen salasana.

Käyttäjätunnuksesi on: {$a->username} ja väliaikainen salasanasi: {$a->newpassword}

Käytä alla olevaa linkkiä vaihtaaksesi väliaikaisen salasanasi: {$a->link}

Useimmissa postiohjelmissa sinun tarvitsee vain napsauttaa ylläolevaa linkkiä.
Jos tämä ei toimi, kopioi ja liitä osoite selaimen osoitekenttään.

Terveisin \'{$a->sitename}\' pääkäyttäjä,
{$a->signoff}';
$string['newpicture'] = 'Uusi kuva';
$string['newpicture_help'] = 'Lisää kuva tietokoneeltasi palvelimelle. Kuvaa käytetään Moodlessa nimesi vieressä. Lähikuva kasvoistasi on käyttökelpoisin mutta voit toki käyttää mitä tahansa haluamaasi kuvaa. Muista kuitenkin kuvan tekijänoikeudet.

Kuvan on oltava jpg tai png -tallennusmuodossa (eli tiedostonimen pääte on .jpg tai .png). Tee kuva esimeriksi näin:

* Digikameran ottamat kuvat ovat todennäköisesti valmiiksi oikeassa muodossa.
* Voit skannata paperikuvan
* Voit piirtää kuvan kuvankäsittelyohjelmalla.

Kun lähetät kuvan, napsauta "Browse" painiketta ja valitse kuvatiedosto. HUOMAA: Varmista että tiedosto ei ole suurempi sivuston maksimikoko, muutoin sitä ei voi lähettää. Kuvan tosin ei kannatakaan olla kovin suuri, sillä se joka tapauksessa pienennetään.

Napsauta sitten "Päivitä profiilini" ("Update my Profile") alhaalla - kuvatiedosto leikkautuu neliöksi ja koko muuttuu 100x100 pikseliksi.

Kun palaat profiilisivullesi, voi olla, näet edelleen vanhan kuvasi. Käytä siinä tapauksessa selaimen "Päivitä" -painiketta.';
$string['newsitem'] = 'uutisaihe';
$string['newsitems'] = 'uutisaihetta';
$string['newsitemsnumber'] = 'Näytä uutisaiheet';
$string['newsitemsnumber_help'] = 'Viikko- ja aihemuodoissa on erillinen Uutiset -niminen keskustelualue. Sen kautta opettajat voivat lähettää kurssitiedotuksia osallistujille. Vain opettajat saavat kirjoittaa viestejä ja kaikki viestit lähtevät pakotetusti kaikille osallistujille sähköpostiin.

Tällä asetuksella määrittelet, kuinka monta uutista Viimeisimmät uutiset -lohkossa näkyy. Jos laitat arvoksi "0", Viimeisimmät uutiset -lohko ei näy ollenkaan.';
$string['newuser'] = 'Uusi käyttäjä';
$string['newusernewpasswordsubj'] = 'Uusi käyttäjätunnus';
$string['newusernewpasswordtext'] = 'Hei {$a->firstname},

Sinulle on luotu uusi käyttäjätili sivustolla \'{$a->sitename}\' ja sinulle on myönnetty uusi tilapäinen salasana.

Nykyiset kirjautumistietosi ovat nyt:
  käyttäjätunnus: {$a->username}
  salasana: {$a->newpassword}
(sinun pitää muuttaa salasanasi kirjautuessasi ensimmäistä kertaa sivustolle)

Alkaaksesi käyttää sivustoa \'{$a->sitename}\', kirjaudu täältä {$a->link}

Useimmissa sähköpostiohjelmissa tämän pitäisi näkyä linkkinä, jota klikkaamalla siirryt sivulle. Jos tämä ei toimi, voit kopioida ja liittää linkin osoiteriville www-selaimessasi.

Terveisin \'{$a->sitename}\' pääkäyttäjä,
{$a->signoff}';
$string['newusers'] = 'Uudet käyttäjät';
$string['newwindow'] = 'aukeaa uuteen ikkunaan';
$string['next'] = 'Seuraava';
$string['nextsection'] = 'Seuraava osio';
$string['no'] = 'Ei';
$string['noblockstoaddhere'] = 'Ei lohkoja jotka voisit lisätä tälle sivulle.';
$string['nobody'] = 'Ei kukaan';
$string['nochange'] = 'Ei muutoksia';
$string['nocomments'] = 'Ei kommentteja';
$string['nocourses'] = 'Ei kursseja';
$string['nocoursesfound'] = 'Sanaa \'{$a}\' ei löytynyt kurssien nimistä';
$string['nocoursesyet'] = 'Ei kursseja tässä kategoriassa';
$string['nodstpresets'] = 'Ylläpitäjä ei ole ottanut käyttöön kesäajan huomioimista.';
$string['nofilesselected'] = 'Mitään tiedostoa ei ole valittu palautettavaksi';
$string['nofilesyet'] = 'Tälle kurssille ei ole vielä lähetetty tiedostoja.';
$string['nograde'] = 'Ei arviointia';
$string['nohelpforactivityorresource'] = 'Tähän aineistoon tai aktiviteettiin ei vielä liity ohjetta.';
$string['noimagesyet'] = 'Tälle kurssille ei ole vielä lähetetty kuvia.';
$string['nologsfound'] = 'Lokeja ei löytynyt';
$string['nomatchingusers'] = 'Yksikään käyttäjä ei vastaa hakua \'{$a}\'';
$string['nomorecourses'] = 'Muita haun ehdot täyttäviä kursseja ei löytynyt';
$string['nomoreidnumber'] = 'Ei käytetä tunnistenumeroa ristiriitojen välttämiseksi';
$string['none'] = 'Ei yhtään';
$string['noneditingteacher'] = 'Opettaja ilman muokkausoikeutta';
$string['noneditingteacherdescription'] = 'Opettajilla ilman muokkausoikeutta on muuten samat oikeudet kuin opettajilla, paitsi että he eivät voi lisätä, muokata tai poistaa aktiviteetteja ja aineistoja.';
$string['nonstandard'] = 'Ei vakio';
$string['nopendingcourses'] = 'Käsittelyä odottavia kurssialuetilauksia ei ole';
$string['nopotentialadmins'] = 'Ei mahdollisia ylläpitäjiä';
$string['nopotentialcreators'] = 'Ei mahdollisia kurssiylläpitäjiä';
$string['nopotentialstudents'] = 'Ei mahdollisia opiskelijoita';
$string['nopotentialteachers'] = 'Ei mahdollisia opettajia';
$string['norecentactivity'] = 'Ei tapahtumia';
$string['noreplybouncemessage'] = 'Olet yrittänyt vastata sähköpostiosoitteeseen, joka ei ota viestejä vastaan. Jos yritit vastata viestiin keskustelualueella, käytä vastauksesi lähettämiseen {$a} keskustelualueita.

Sähköpostisi sisältö:';
$string['noreplybouncesubject'] = '{$a} - sähköposti ei päässyt perille';
$string['noreplyname'] = 'Älä vastaa tähän sähköpostiin';
$string['noresults'] = 'Ei tuloksia';
$string['normal'] = 'Normaali';
$string['normalfilter'] = 'Normaali haku';
$string['nosite'] = 'Sivuston päätason kurssia ei löytynyt';
$string['nostudentsfound'] = 'Ei ketään';
$string['nostudentsingroup'] = 'Tässä ryhmässä ei ole vielä opiskelijoita';
$string['nostudentsyet'] = 'Kurssilla ei ole vielä opiskelijoita';
$string['nosuchemail'] = 'Sähköpostiosoitetta ei löydy';
$string['notavailable'] = 'Ei saatavilla';
$string['noteachersyet'] = 'Kurssilla ei ole vielä opettajaa';
$string['notenrolled'] = '{$a} ei ole tällä kurssilla.';
$string['notenrolledprofile'] = 'Profiilia ei voida näyttää, sillä tämä käyttäjä ei ole kirjautuneena tälle kurssille.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Huom:</strong> Päivämäärien muutosmahdollisuus varmuuskopion palautuksen yhteydessä on otettu pois käytöstä, koska käyttöoikeutesi eivät riitä.';
$string['noteuserschangednonetocourse'] = '<strong>Huom:</strong>Kurssin käyttäjät tulee palauttaa kun käyttäjätietoja palautetaan. Tämä asetus on muutettu sinun kohdaltasi.';
$string['nothingnew'] = 'Ei uutisia edellisen käyntisi jälkeen';
$string['nothingtodisplay'] = 'Ei näytettävää';
$string['notice'] = 'Ilmoitus';
$string['noticenewerbackup'] = 'Tämä varmuuskopio on luotu Moodlen versiolla {$a->backuprelease} ({$a->backupversion}) joka on uudempi kuin käyttämällesi palvelimelle asennettu versio {$a->serverrelease} ({$a->serverversion}). Tämä saattaa aiheuttaa palautettaessa joitain yhteensopivuusongelmia, koska varmuuskopioiden yhteensopivuutta vanhempien versioiden kanssa ei voida taata.';
$string['notifications'] = 'Ilmoitukset';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Käyttäjä: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Voit katsella näitä tapahtumia osoitteessa {$a}/course/log.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Tässä on lista epäonnistuneista kirjautumisyrityksistä {$a} edellisen ilmoituksen jälkeen';
$string['notifyloginfailuressubject'] = '??? :: Epäonnistuneiden kirjautumisyritysten ilmoitus';
$string['notincluded'] = 'Ei  mukana';
$string['notingroup'] = 'Sinun pitää olla ryhmän jäsen nähdäksesi tämän aktiviteetin.';
$string['notpublic'] = 'Ei julkinen!';
$string['nousersfound'] = 'Käyttäjiä ei löytynyt';
$string['nousersmatching'] = 'Haku \'{$a}\' ei löytänyt käyttäjiä';
$string['nousersyet'] = 'Ei vielä käyttäjiä';
$string['novalidcourses'] = 'Ei näytettäviä kursseja';
$string['now'] = 'nyt';
$string['numattempts'] = '{$a} epäonnistunutta kirjautumisyritystä';
$string['numberofcourses'] = 'Kurssien määrä';
$string['numberweeks'] = 'Viikkojen/aiheiden määrä';
$string['numdays'] = '{$a} päivää';
$string['numhours'] = '{$a} tuntia';
$string['numletters'] = '{$a} kirjainta';
$string['numminutes'] = '{$a} minuuttia';
$string['nummonths'] = '{$a} kuukautta';
$string['numseconds'] = '{$a} sekuntia';
$string['numviews'] = 'katsottu {$a} kertaa';
$string['numweeks'] = '{$a} viikkoa';
$string['numwords'] = '{$a} sanaa';
$string['numyears'] = '{$a} vuotta';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Nykyinen salasana';
$string['olduserdirectory'] = 'Tämä on vanha käyttäjähakemisto jonka voit poistaa, tällä oleet tiedot on jo kopioitu uuteen käyttäjähakemistoon.';
$string['opentoguests'] = 'Avoin vierailijoille';
$string['optional'] = 'vapaaehtoinen';
$string['options'] = 'vaihtoehdot';
$string['order'] = 'Järjestys';
$string['originalpath'] = 'Alkuperäinen hakemistopolku';
$string['other'] = 'Toinen';
$string['outline'] = 'Rakenne';
$string['outlinereport'] = 'Rakenneraportti';
$string['page'] = 'Sivu';
$string['pageheaderconfigablock'] = 'Määritellään lohkoa kurssilla {$a->fullname}';
$string['pagepath'] = 'Sivun polku';
$string['pageshouldredirect'] = 'Sivun pitäisi ohjautua uudelleen automaattisesti. Jos mitään ei tapahdu, käytä alla olevaa linkkiä.';
$string['parentcategory'] = 'Isäntäkategoria';
$string['parentcoursenotfound'] = 'Isäntäkurssia ei löytynyt!';
$string['parentfolder'] = 'Yläkansio';
$string['participants'] = 'Osallistujat';
$string['participantslist'] = 'Osallistujalista';
$string['participationratio'] = 'Osallistumissuhde';
$string['participationreport'] = 'Osallistumisraportti';
$string['password'] = 'Salasana';
$string['passwordchanged'] = 'Salasana on vaihdettu';
$string['passwordconfirmchange'] = 'Vahvista salasanan vaihto';
$string['passwordextlink'] = 'Voit palauttaa salasanasi seuraavan linkin avulla. Tämä vie sinut toiselle sivustolle.';
$string['passwordforgotten'] = 'Unohdettu salasana';
$string['passwordforgotteninstructions'] = 'Ole hyvä ja anna henkilötietosi <strong>tai</strong> käyttäjätunnuksesi jotta tietosi voidaan etsiä tietokannasta.';
$string['passwordforgotteninstructions2'] = 'Syötä käyttäjätunnuksesi <b>tai</b> sähköpostiosoitteesi alle ja paina Hae. Jos käyttäjätunnuksesi löytyy tietokannasta, saat sähköpostitse viestin, jossa pyydetään vahvistamaan salasanan vaihto.';
$string['passwordnohelp'] = 'Unohtuneen salasanan palauttaminen ei onnistunut. Ota yhteyttä Moodle-sivustosi pääkäyttäjään.';
$string['passwordrecovery'] = 'Kyllä, auta minua kirjautumisessa';
$string['passwordsdiffer'] = 'Salasanat eivät täsmää';
$string['passwordsent'] = 'Salasana on lähetetty';
$string['passwordsenttext'] = '<p>Viesti on lähetetty osoitteeseen: {$a->email}.</p>
   <p><b>Tarkista viestistä uusi salasanasi.</b></p>
   <p>Uusi salasana on automaattisesti generoitu, joten haluat luultavasti
   <a href="{$a->link}">vaihtaa sen joksikin helpommin muistettavaksi</a>.</p>';
$string['path'] = 'Polku';
$string['pathnotexists'] = 'Polkua ei löydy palvelimelta';
$string['pathslasherror'] = 'Polku ei voi päättyä kauttaviivaan "/"!';
$string['paymentinstant'] = 'Napsauta painiketta maksaaksesi kurssista ja liittyäksesi kurssille.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> odottaa</small>)';
$string['paymentrequired'] = 'Tämä kurssi vaatii osallistumismaksun.';
$string['payments'] = 'Maksut';
$string['paymentsorry'] = 'Kiitokset maksusta! Maksuasi ei ole vielä rekisteröity järjestelmään ja sinua ei ole vielä rekisteröity kurssille "{$a->fullname}". Yritä uudelleen hetken kuluttua, mutta jos ongelma jatkuu ilmoita siitä {$a->teacher} tai sivuston ylläpitäjälle.';
$string['paymentthanks'] = 'Kiitokset maksusta! Sinut on rekisteröity kurssille: <br /> "{$a}"';
$string['pendingrequests'] = 'Käsittelyä odottavat kurssialuetilaukset';
$string['periodending'] = 'Jakso loppuu ({$a})';
$string['perpage'] = 'Per sivu';
$string['perpagea'] = 'Per sivu {$a}';
$string['personal'] = 'Henkilökohtainen';
$string['personalprofile'] = 'Omat käyttäjätiedot';
$string['phone'] = 'Puhelin';
$string['phone2'] = 'Matkapuhelin';
$string['phpinfo'] = 'PHP-info';
$string['pictureof'] = 'Kuva: {$a}';
$string['pictureofuser'] = 'Käyttäjäkuva';
$string['pleaseclose'] = 'Sulje ikkuna heti, kiitos.';
$string['pleasesearchmore'] = 'Hae lisää';
$string['pleaseusesearch'] = 'Käytä hakua';
$string['plugin'] = 'Lisäosa';
$string['plugincheck'] = 'Lisäosien tarkistus';
$string['plugindeletefiles'] = 'Kaikki data, joka liittyy lisäosaan \'{$a->name}\', on poistettu tietokannasta. Estääksesi lisäosan asentamasta itseään uudelleen, poista palvelimeltasi hakemisto: {$a->directory}';
$string['pluginsetup'] = 'Asetetaan lisäosien tietokannat';
$string['policyaccept'] = 'Ymmärrän ja hyväksyn';
$string['policyagree'] = 'Sinun täytyy hyväksyä tämä käyttösopimus voidaksesi jatkaa sivun käyttöä. Hyväksytkö käyttösopimuksen?';
$string['policyagreement'] = 'Sivuston käyttösopimus';
$string['policyagreementclick'] = 'Napsauttamalla tästä voit lukea sivuston käyttösopimuksen';
$string['popup'] = 'ponnahdusikkuna';
$string['popupwindow'] = 'Avaa tiedosto uudessa ikkunassa';
$string['popupwindowname'] = 'Ponnahdusikkuna';
$string['post'] = 'Viesti';
$string['posts'] = 'Viestit';
$string['potentialadmins'] = 'Mahdolliset ylläpitäjät';
$string['potentialcreators'] = 'Mahdolliset kurssiylläpitäjät';
$string['potentialstudents'] = 'Mahdolliset opiskelijat';
$string['potentialteachers'] = 'Mahdolliset opettajat';
$string['preferences'] = 'Asetukset';
$string['preferredlanguage'] = 'Haluttu kieli';
$string['preferredtheme'] = 'Haluttu teema';
$string['preprocessingbackupfile'] = 'Esikäsitellään varmuuskopiotiedostoa';
$string['preview'] = 'Esikatsele';
$string['previewhtml'] = 'HTML- esikatselu';
$string['previeworchoose'] = 'Esikatsele tai valitse teema';
$string['previous'] = 'Edellinen';
$string['previouslyselectedusers'] = 'Aikaisemmin valitut käyttäjät eivät täsmää \'{$a}\'';
$string['previoussection'] = 'Edellinen osio';
$string['primaryadminsetup'] = 'Ylläpitäjän tunnuksen luonti';
$string['profile'] = 'Käyttäjätiedot';
$string['profilenotshown'] = 'Tätä profiilikuvausta ei näytetä ennen kuin käyttäjä on osallistunut vähintään yhdelle kurssille';
$string['publicprofile'] = 'Julkinen profiili';
$string['publicsitefileswarning'] = 'Huom: kaikki pääsevät käsiksi tänne ladattuihin tiedostoihin';
$string['publicsitefileswarning2'] = 'Huom: Täällä olevat tiedostot näkyvät kaikille, jotka tietävät (tai osaavat arvata) osoitteen. Turvallisuussyistä kaikki varmuuskopiotiedostot kannattaa poistaa heti niiden palauttamisenjälkeen.';
$string['publicsitefileswarning3'] = 'Huom: Täällä olevat tiedostot näkyvät kaikille, jotka tietävät (tai osaavat arvata) osoitteen. Turvallisuussyistä kaikki varmuuskopiotiedostot kannattaa tallentaa vain salaisiin varmuuskopiointikansioihin.';
$string['publish'] = 'Julkaise';
$string['question'] = 'Kysymys';
$string['questionsinthequestionbank'] = 'Kysymyspankin kysymykset';
$string['readinginfofrombackup'] = 'Luetaan dataa varmuuskopiosta';
$string['readme'] = 'LUEMINUT';
$string['recentactivity'] = 'Tuoreimmat tapahtumat';
$string['recentactivityreport'] = 'Viimeisimpien tapahtumien kattava raportti';
$string['recipientslist'] = 'Vastaanottajat';
$string['recreatedcategory'] = 'Luotiin uudelleen kategoria {$a}';
$string['redirect'] = 'Uudelleenohjaa';
$string['reducesections'] = 'Vähennä osioiden määrää';
$string['refresh'] = 'Päivitä';
$string['refreshingevents'] = 'Päivitetään tapahtumia';
$string['registration'] = 'Rekisteröi Moodle';
$string['registrationcontact'] = 'Yhteydenotto yleisöltä';
$string['registrationcontactno'] = 'Ei, en halua yhteydenottolomaketta näkyviin verkkosivuille';
$string['registrationcontactyes'] = 'Kyllä, tarjoa mahdollisille uusille Moodlen käyttäjille lomake, jolla ottaa yhteyttä minuun';
$string['registrationemail'] = 'Tietoa sähköpostitse';
$string['registrationinfo'] = '<p>Tällä sivulla voi ilmaiseksi rekisteröidä Moodlen moodle.org sivulle. Rekisteröity käyttäjä lisätään postituslistaan tärkeitä tiedotuksia varten. Aiheena voi olla esim. tietoturva-aukon löytyminen ja uusista versioista tiedottaminen.</p>
<p>Oletuksena tietojasi ei anneta muiden käyttöön, eikä niitä myydä eteenpäin. Näitä tietoja kerätään vain tukea varten ja jotta saadaan tilastollista tietoa Moodlen käyttäjistä kokonaisuutena.</p>
<p>Voit halutessasi antaa sivustosi nimen, maan ja http-osoitteen muiden nähtäväksi.</p>
<p>Kaikki uudet rekisteröinnit tarkistetaan käsin, ennen kuin ne lisätään listaan, mutta tietoja voi päivittää ja tietosi voidaan halutessasi milloin tahansa ottaa pois kaikkien nähtävillä olevasta listasta.</p>';
$string['registrationinfotitle'] = 'Rekisteröintitiedot';
$string['registrationno'] = 'En halua vastaanottaa sähköpostia';
$string['registrationsend'] = 'Lähetä rekisteröintitiedot sivulle moodle.org';
$string['registrationyes'] = 'Kyllä, tiedottakaa tärkeistä asioista';
$string['reject'] = 'Hylkää';
$string['rejectdots'] = 'Hylkää...';
$string['reload'] = 'Lataa uudelleen';
$string['remoteappuser'] = 'Etäkäyttäjä {$a}';
$string['remove'] = 'Poista';
$string['removeadmin'] = 'Poista ylläpitäjä';
$string['removecreator'] = 'Poista kurssiylläpitäjä';
$string['removestudent'] = 'Poista opiskelija';
$string['removeteacher'] = 'Poista opettaja';
$string['rename'] = 'Nimeä uudelleen';
$string['renamefileto'] = 'Nimeä tiedosto <b>{$a}</b> tiedostoksi';
$string['report'] = 'Raportti';
$string['reports'] = 'Raportit';
$string['repositories'] = 'Repositoriot';
$string['requestcourse'] = 'Tilaa kurssialue';
$string['requestedby'] = 'Kurssialueen tilaaja';
$string['requestedcourses'] = 'Tilatut kurssialueet';
$string['requestreason'] = 'Kurssialuetilauksen perustelut';
$string['required'] = 'Vaadittu';
$string['requirespayment'] = 'Tämä kurssi vaatii osallistumismaksun';
$string['reset'] = 'Nollaa';
$string['resetcomponent'] = 'Komponentti';
$string['resetcourse'] = 'Nollaa kurssi';
$string['resetinfo'] = 'Tällä sivulla voit nollata eli tyhjentää kurssialueen osallistujatiedoista siten, että kurssin aktiviteetit ja muut asetukset säilyvät. Huomaathan, että poistamalla tällä sivulla valitsemasi sisällöt tuhoat ko. käyttäjätiedot peruuttamattomasti!';
$string['resetnotimplemented'] = 'Nollausta ei ole toteutettu';
$string['resetstartdate'] = 'Nollauksen aloituspäiväys';
$string['resetstatus'] = 'Tila';
$string['resettask'] = 'Tehtävä';
$string['resettodefaults'] = 'Palauta oletusasetukset';
$string['resortcourses'] = 'Järjestä kurssit';
$string['resortsubcategoriesbyidnumber'] = 'Järjestä alikurssit id-numeron mukaan';
$string['resortsubcategoriesbyname'] = 'Järjestä alikurssit nimen mukaan';
$string['resource'] = 'Aineisto';
$string['resourcedisplayauto'] = 'Automaattinen';
$string['resourcedisplaydownload'] = 'Pakota lataus';
$string['resourcedisplayembed'] = 'Upota';
$string['resourcedisplayframe'] = 'Kehyksessä';
$string['resourcedisplaynew'] = 'Uusi ikkuna';
$string['resourcedisplayopen'] = 'Avaa';
$string['resourcedisplaypopup'] = 'Ponnahdusikkunassa';
$string['resources'] = 'Aineistot';
$string['resources_help'] = 'Aineistot ovat opettajien jakamia materiaaleja muille osallistujille, eli aineistojen lisääminen kurssialueelle vaatii opettajan oikeudet. Aineistoja ovat verkkolinkit, tiedostot, kurssialueen sisäiset sivut ja erilaiset muilla ohjelmilla tuotetut materiaalipaketit kuten IMS tai Scorm-standardien mukaan tuotetut tiedostot.';
$string['restore'] = 'Palauta';
$string['restorecancelled'] = 'Palautus peruutettu';
$string['restorecannotassignroles'] = 'Palautus tarvitsee roolien muutosta ja sinulla ei ole oikeuksia siihen.';
$string['restorecannotcreateorassignroles'] = 'Palautus tarvitsee roolin muutoksen tai sen luomisen ja sinulla ei ole oikeuksia tehdä sitä.';
$string['restorecannotcreateuser'] = 'palautus tarvitsee uuden käyttäjän luomisenj \'{$a}\' varmuuskopioista ja sinulla ei ole oikeuksia tehdä sitä.';
$string['restorecannotoverrideperms'] = 'Palautus tarvitsee oikeustason ohituksen ja sinulla ei ole oikeuksia tehdä sitä.';
$string['restorecoursenow'] = 'Palauta kurssi nyt';
$string['restoredaccount'] = 'Palautettu käyttäjätili';
$string['restoredaccountinfo'] = 'Tämä käyttäjätili siirrettiin toiselta palvelimelta ja salasana hukkui siinä prosessissa. Saadaksesi uuden salasanan sähköpostiisi paina "Jatka"';
$string['restorefinished'] = 'Kurssin palautus tehty';
$string['restoreto'] = 'Palauta kohtaan';
$string['restoretositeadding'] = 'Varoitus: Olet juuri palauttamassa sivuston pääsivua lisäämällä siihen tietoa!';
$string['restoretositedeleting'] = 'Varoitus: Olet juuri palauttamassa sivuston pääsivua poistamalla siitä tietoa!';
$string['restoreuserconflict'] = 'Yrittämällä palauttaa käyttäjää \'{$a}\' varmuuskopiosta aiheuttaa tietojen ristiriidan';
$string['restoreuserinfofailed'] = 'Palautusprosessi pysähtyi koska sinulla ei ole oikeuksia palauttaa käyttäjätietoa.';
$string['restoreusersprecheck'] = 'Tarkastetaan käyttäjätietoja';
$string['restoreusersprecheckerror'] = 'Käyttäjätietojen tarkastuksessa ilmeni joitain ongelmia';
$string['restricted'] = 'Rajoitettu';
$string['returningtosite'] = 'Kirjaudu:';
$string['returntooriginaluser'] = 'Palaa {$a}';
$string['revert'] = 'Peruuta';
$string['role'] = 'Rooli';
$string['rolemappings'] = 'Roolien jako';
$string['rolerenaming'] = 'Roolien uudelleennimeäminen';
$string['rolerenaming_help'] = 'Tällä asetuksella voit vaihtaa kurssialueen rooleista käytetyt nimet. Jos esimerkiksi kurssialueesi on suomenkielinen, voit tässä antaa rooleille suomenkieliset nimet. Myös nimien monikielisyys eli multilang-filtteröinti on mahdollista.

Roolien nimet näkyvät osallistujille kurssialueen osallistujalistan otsikoina, opettajan roolille myös muualla kurssialueella ja ylläpitäjille kurssilistauksissa.

Kurssialueen varmuuskopioon roolien uudelleennimeäminen lisätään vain jos mukaan otetaan myös käyttäjätiedot.';
$string['roles'] = 'Roolit';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Viimeisimpien RSS-artikkelien määrä';
$string['rsserror'] = 'Virhe RSS-tietoja luettaessa';
$string['rsserrorauth'] = 'RSS-linkkisi ei sisällä oikeaa autentikointiavainta.';
$string['rsserrorguest'] = 'Tämä syöte käyttää vierailijatunnusta saadakseen pääsyn tietoihin vaikka vierailijatunnuksella ei ole oikeutta tiedon lukemiseen. Käy alkuperäisessä syötteen osoitteessa (URL) tunnistautumassa oikeaksi käyttäjäksi ja hae uusi RSS-linkki sieltä.';
$string['rsskeyshelp'] = 'Turvallisuuden ja yksityisyydensuojan varmistamiseksi RSS-syötteen URL sisältää erityisen avaimen, joka tunnistaa käyttäjän. Tämä estää muita käyttäjiä pääsemästä RSS-syötteen kautta minne heillä ei ole oikeuksia päästä.</p><p> Tämä avain luodaan automaattisesti ensimmäisellä kerralla kun kirjaudut sisään Moodlen RSS-työkaluun. Jos epäilet RSS-syötteen avaimen murtoa voit pyytää uuden painamalla painiketta Luo uusi RSS-syöte. Huomioi, että tällöin nykyinen RSS-syötteen URL ei enää toimi.';
$string['rsstype'] = 'RSS-syöte tästä aktiviteetista';
$string['saveandnext'] = 'Tallenna ja näytä seuraava';
$string['savechanges'] = 'Tallenna muutokset';
$string['savechangesanddisplay'] = 'Tallenna ja näytä';
$string['savechangesandreturntocourse'] = 'Tallenna ja palaa kurssille';
$string['savecomment'] = 'Tallenna kommentti';
$string['savedat'] = 'Tallennettu:';
$string['savepreferences'] = 'Tallenna asetukset';
$string['saveto'] = 'Tallenna';
$string['scale'] = 'Asteikko';
$string['scale_help'] = 'Opettajat voivat luoda omia asteikoitaan käytettäväksi kurssin arvioinnissa. Asteikon nimen tulee kuvata asteikkoa selkeästi, sillä asteikon nimi näkyy asteikon valinta -kentissä, kuten myös tapauskohtaisissa ohjepainikkeissa.

Asteikko määritellään listan avulla siten, että luetellaan skaala negatiivisesta positiiviseen, ja erotellaan pilkuilla. Esimerkiksi:

* Riittämätön, Välttävä, Tyydyttävä, Hyvä, Kiitettävä, Erinomainen
* Pettymys, Ei tarpeeksi hyvä, Keskiverto, Hyvä, Erittäin hyvä, Loistava!

Asteikon tulee myös sisältää hyvä kuvaus siitä, mitä se tarkoittaa ja miten sitä käytetään. Kuvaus tulee näkyviin ohjesivuilla opettajille ja opiskelijoille.

Sivustollasi saattaa olla yksi tai useampi asteikko valmiina ylläpitäjän määrittelemänä. Nämä ovat käytettävissä kaikilla kursseilla.';
$string['scales'] = 'Asteikot';
$string['scalescustom'] = 'Omat asteikot';
$string['scalescustomcreate'] = 'Lisää uusi asteikko';
$string['scalescustomno'] = 'Omia asteikkoja ei ole vielä tehty';
$string['scalesstandard'] = 'Vakioasteikot';
$string['scalestandard'] = 'Vakioasteikko';
$string['scalestandard_help'] = 'Vakioasteikkona annat asteikon käyttöön julkisesti kaikille kurssialueille. Usein vakioasteikkoja voivat luoda vain organisaatiosi Moodle-ylläpitäjät.';
$string['scalestip'] = 'Luodaksesi omia asteikkoja käytä \'Asteikot\' -linkkiä kurssin ylläpitovalikossa.';
$string['scalestip2'] = 'Luodaksesi omia asteikkoja klikkaa \'Arvosanat\' -linkkiä kurssin ylläpitovalikossa ja valitse sitten Muokkaa, Asteikot.';
$string['schedule'] = 'Ajoita';
$string['screenshot'] = 'Ruudunkaappaus';
$string['search'] = 'Hae';
$string['searchagain'] = 'Hae uudelleen';
$string['searchbyemail'] = 'Etsi sähköpostiosoitteen perusteella';
$string['searchbyusername'] = 'Etsi käyttäjätunnuksen perusteella';
$string['searchcourses'] = 'Etsi kursseja';
$string['searchhelp'] = 'Voit hakea useampaa sanaa kerrallaan. <br  /><br />sana : etsi mikä tahansa täsmäävä sana.<br />+sana : kaikkien sanojen tulee löytyä.<br />-sana : jätä pois kyseisen sanan sisältävät.';
$string['search_help'] = 'Tekstin perushaussa (yksi tai useampi sana) kirjoita sanoja erottamalla ne välilyönnillä. Kaikki kahta merkkiä pidemmät sanat ovat haun kohteena.

Halutessasi päästä edistyneeseen hakuun paina haku-painiketta kirjoittamatta hakuikkunaan mitään niin lomake hakuun aukeaa.';
$string['searchoptions'] = 'Hakuasetukset';
$string['searchresults'] = 'Hakutulokset';
$string['sec'] = 'sekunti';
$string['seconds'] = 'sekuntia';
$string['secondstotime172800'] = '2 päivää';
$string['secondstotime259200'] = '3 päivää';
$string['secondstotime345600'] = '4 päivää';
$string['secondstotime432000'] = '5 päivää';
$string['secondstotime518400'] = '6 päivää';
$string['secondstotime604800'] = '1 viikko';
$string['secondstotime86400'] = '1 päivä';
$string['secretalreadyused'] = 'Salasanan vaihtamisen vahvistuslinkkiä oli jo käytetty, salasanaa ei vaihdettu.';
$string['secs'] = 'sekuntia';
$string['section'] = 'Osa';
$string['sectionname'] = 'Osion nimi';
$string['sections'] = 'Osiot';
$string['sectionusedefaultname'] = 'Käytä osion oletusnimeä';
$string['seealsostats'] = 'Katso myös: tilastot';
$string['selctauser'] = 'Valitse käyttäjä';
$string['select'] = 'Valittu';
$string['selectacountry'] = 'Valitse maa';
$string['selectacourse'] = 'Valitse kurssi';
$string['selectacoursesite'] = 'Valitse kurssi tai sivusto';
$string['selectagroup'] = 'Valitse ryhmä';
$string['selectall'] = 'Valitse kaikki';
$string['selectamodule'] = 'Ole hyvä ja valitse aktiviteettimoduuli';
$string['selectanaction'] = 'Valitse toiminto';
$string['selectanoptions'] = 'Valitse vaihtoehdot';
$string['selectaregion'] = 'Valitse alue';
$string['selectcategorysort'] = 'Mitä kategorioita haluat järjestää';
$string['selectcategorysortby'] = 'Valitse kuinka haluat järjestää kategoriat';
$string['selectcoursesortby'] = 'Valitse miten haluat järjestää kurssit';
$string['selectdefault'] = 'Valitse oletus';
$string['selectedcategories'] = 'Valitut kategoriat';
$string['selectedfile'] = 'Valittu tiedosto';
$string['selectednowmove'] = '{$a} tiedostoa valittu. Siirry nyt kohdehakemistoon ja valitse \'Siirrä tiedostot tänne\'';
$string['selectfiles'] = 'Valitse tiedostoja';
$string['selectmoduletoviewhelp'] = 'Valitse vasemmalta aineisto tai aktiviteetti, jolloin tässä näytetään siihen liittyviä ohjeita.

Voit myös lisätä aineiston tai aktiviteetin tuplaklikkaamalla sen nimeä.';
$string['selectnos'] = 'Valitse kaikki "ei"';
$string['selectperiod'] = 'Valitse ajanjakso';
$string['senddetails'] = 'Lähetä tiedot sähköpostilla';
$string['separate'] = 'Erilliset';
$string['separateandconnected'] = 'Eristyvä ja sosiaalinen oppiminen';
$string['separateandconnectedinfo'] = 'Arviointiaseikko perustuu teoriaan erillisestä ja yhdistetystä oppimisesta. Tämä teoria kuvaa kahta tapaa evaluoida ja oppia näkemiämme ja kuulemiamme asioita. <ul><li><strong>Eriyttävät oppijat</strong> pyrkivät pysymään niin objektiivisina kuin mahdollista ilman tunteita ja emootioita. Keskustellessaan muiden kanssa pyrkivät tällaiset oppijat puolustamaan omia ideoitaan ja ajatuksiaan käyttämällä logiikkaa ja etsimällä loogisia virheitä vastapuolen ajatuksista ja ideoista.</li><li>
<strong>Yhdistävät oppijat</strong> ovat herkkiä toisten ihnmisten tunteille ja ajatuksille. He tuntevat empatiaa ja omaavat kyvyn kuunnella ja kysyä kysymyksiä kunnes he kokevat pystyvänsä ymmärtämään asioita vastapuolen tarkoittamalla tavalla. he oppivat pyrkimällä jakamaan kokemuksia, jotka tuottavat tietoa ja osaamista. He omaksuvat toisilta ihmisiltä tietoa ja sen pohjalla olevia kokemuksia. </li></ul>';
$string['servererror'] = 'Palvelimen kanssa kommunikoinnissa tapahtui virhe';
$string['serverlocaltime'] = 'Palvelimen aika';
$string['setcategorytheme'] = 'Aseta kategorian teema';
$string['settings'] = 'Asetukset';
$string['shortname'] = 'Lyhenne';
$string['shortnamecollisionwarning'] = '[*] = Tämä kurssin lyhenne on jo toisen kurssin käytössä. Lyhenne on muutettava kun kurssi hyväksytään.';
$string['shortnamecourse'] = 'Kurssin lyhenne';
$string['shortnamecourse_help'] = 'Lyhenne on se teksti, joka näkyy kurssialueen yläpalkin hakemistopolussa kuvaamassa kurssialueesi pääsivua. samoin lyhenne näkyy kurssialueelta sähköpostiin lähtevien viestien otsikkokentässä [hakasulkeissa]. Lyhenteen on oltava uniikki eli erottava kaikkien muiden kurssialueiden lyhenteistä.';
$string['shortnametaken'] = 'Valitsemasi kurssin lyhenne on jo käytössä toisella kurssialueella.';
$string['shortnameuser'] = 'Käyttäjän lyhyt nimi';
$string['shortsitename'] = 'Lyhyt nimi sivustolle (esim. yksi sana)';
$string['show'] = 'Näytä';
$string['showactions'] = 'Näytä toiminnot';
$string['showadvancedsettings'] = 'Näytä lisäasetukset';
$string['showall'] = 'Näytä kaikki {$a}';
$string['showallcourses'] = 'Näytä kaikki kurssit';
$string['showallusers'] = 'Näytä kaikki käyttäjät';
$string['showblockcourse'] = 'Näytä kurssit, jotka sisältävät lohkon';
$string['showcomments'] = 'Näytä/piilota kommentit';
$string['showcommentsnonjs'] = 'Näytä kommentit';
$string['showdescription'] = 'Näytä kuvaus kurssisivulla';
$string['showdescription_help'] = 'Jos tämä asetus on käytössä, yllä oleva kuvausteksti näytetään kurssisivulla ko. aktiviteetti- tai aineistolinkin alapuolella.';
$string['showgrades'] = 'Näytä arvioinnit opiskelijalle';
$string['showgrades_help'] = 'Opiskelijoiden arviointi on mahdollista useimmissa Moodlen aktiviteeteista.

Oletuksena kurssialueen kaikki arvioitavat aktiviteetit ovat nähtävissä Arvioinnit-sivulla eli Arviointikirjassa, jonne pääsee kurssialueelta Ylläpito-lohkon kautta.

Jos et halua käyttää arviointia kurssillasi tai haluat piilottaa arvoioinnin opiskelijoilta, niiden näkymisen voi estää kurssin asetuksissa. Tämä ei estä yksittäisiä aktiviteetteja käyttämästä arviointia, annetut arvioinnit vain eivät näy opiskelijoille.';
$string['showlistofcourses'] = 'Näytä kurssilista';
$string['showmodulecourse'] = 'Näytä kurssit, jotka käyttävät aktiviteettia';
$string['showonly'] = 'Näytä vain';
$string['showperpage'] = 'Näytä {$a} sivulla';
$string['showrecent'] = 'Näytä tapahtumat';
$string['showreports'] = 'Näytä tapahtumaraportti';
$string['showreports_help'] = 'Tapahtumaraportti näkyy kunkin osallistujan osalta osallistujalle itselleen, jotta he voivat seurata omaa kurssiaktiivisuuttaan. Raportissa näkyy osallistumisen, kuten keskustelualueviestien ja tehtäväpalautusten lisäksi myös kirjautumisloki. Tällä asetuksella määrittelet, saako opiskelija nähdä oman tapahtumaraporttinsa oman profiilisivunsa kautta.';
$string['showsettings'] = 'Näytä asetukset';
$string['showtheselogs'] = 'Näytä nämä tapahtumat';
$string['showthishelpinlanguage'] = 'Näytä tämä apu kielellä: {$a}';
$string['since'] = 'Alkaen';
$string['sincelast'] = 'viime kirjautumisen jälkeen';
$string['site'] = 'Sivusto';
$string['sitedefault'] = 'Sivuston oletus';
$string['siteerrors'] = 'Sivuston virheet';
$string['sitefiles'] = 'Sivuston tiedostot';
$string['sitefilesused'] = 'Kurssilla käytetyt sivuston tiedostot';
$string['sitehome'] = 'Sivuston etusivu';
$string['sitelegacyfiles'] = 'Perinteiset sivuston tiedostot';
$string['sitelogs'] = 'Sivuston tapahtumat';
$string['sitenews'] = 'Sivuston uutiset';
$string['sitepages'] = 'Sivuston seuranta';
$string['sitepartlist'] = 'Sinulla ei ole oikeuksia nähdä osallistujaluetteloa';
$string['sitepartlist0'] = 'Vain sivuston opettajat voivat selata käyttäjälistaa';
$string['sitepartlist1'] = 'Vain opettajat voivat selata sivuston käyttäjälistaa';
$string['sites'] = 'Sivustot';
$string['sitesection'] = 'Lisää aihealue';
$string['sitesettings'] = 'Sivuston asetukset';
$string['siteteachers'] = 'Sivuston opettajat';
$string['size'] = 'Koko';
$string['sizeb'] = 'tavua';
$string['sizegb'] = 'Gt';
$string['sizekb'] = 'Kt';
$string['sizemb'] = 'Mt';
$string['skipped'] = 'Ohitettu';
$string['skypeid'] = 'Skypen ID';
$string['socialheadline'] = 'Keskustelu - viimeisimmät aiheet';
$string['someallowguest'] = 'Jotkut kurssit saattavat sallia pääsyn vierailijatunnuksella.';
$string['someerrorswerefound'] = 'Joitain tietoja puuttui tai ne olivat vääränlaisia. Katso tarkemmat tiedot alta.';
$string['sort'] = 'Järjestä uudelleen';
$string['sortby'] = 'Lajittele';
$string['sortbyx'] = 'Lajittele {$a} nousevasti';
$string['sortbyxreverse'] = 'Lajittele {$a} laskevasti';
$string['sortcategoriesbyidnumber'] = 'Järjestä kategoriat ID-numeron mukaan';
$string['sortcategoriesbyname'] = 'Järjestä kategoriat nimen mukaan';
$string['sortcoursesbyfullname'] = 'Järjestä kurssit nimen mukaan';
$string['sortcoursesbyidnumber'] = 'Järjestä kurssit id-tunnisteen mukaan';
$string['sortcoursesbyshortname'] = 'Järjestä kurssit lyhytnimen mukaan';
$string['sorting'] = 'Järjestys';
$string['sourcerole'] = 'Lähderooli';
$string['specifyname'] = 'Määrittele nimi';
$string['standard'] = 'Vakio';
$string['starpending'] = '([*] = kurssi odottaa hyväksyntää)';
$string['startdate'] = 'Kurssin aloituspäivämäärä';
$string['startdate_help'] = 'Tällä asetuksella määrittelet kurssisi alkamispäivän, joka viikkomuotoisella kurssialueella myös aloittaa ensimmäisen kurssiviikon. Lisäksi kurssialueen raportit alkavat tallentua tästä päivästä alkaen.';
$string['startingfrom'] = 'Alkaen';
$string['startsignup'] = 'Aloita nyt luomalla uusi käyttäjätunnus!';
$string['state'] = 'Maakunta';
$string['statistics'] = 'Tilastot';
$string['statisticsgraph'] = 'Tilastojen kuvaaja';
$string['stats'] = 'Tilastot';
$string['statslogins'] = 'Kirjautumiset';
$string['statsmodedetailed'] = 'Tarkennettu (käyttäjän) näkymä';
$string['statsmodegeneral'] = 'Yleisnäkymä';
$string['statsnodata'] = 'Ei tietoja valitulle kurssille ja ajanjaksolle.';
$string['statsnodatauser'] = 'Ei tietoja valitulle kurssin, käyttäjän ja ajanjakson yhdistelmälle.';
$string['statsoff'] = 'Tilastot eivät ole tällä hetkellä käytössä';
$string['statsreads'] = 'Sivulataukset';
$string['statsreport1'] = 'Kirjautumiset';
$string['statsreport10'] = 'Käyttäjäaktiviteetti';
$string['statsreport11'] = 'Aktiivisimmat kurssit';
$string['statsreport12'] = 'Aktiivisimmat kurssit (painotettuna)';
$string['statsreport13'] = 'Eniten osallistujia';
$string['statsreport14'] = 'Aktiivisimmat osallistujat';
$string['statsreport2'] = 'Käyntejä  (kaikki roolit)';
$string['statsreport3'] = 'Viestit  (kaikki roolit)';
$string['statsreport4'] = 'Kaikki aktiivisuus (kaikki roolit)';
$string['statsreport5'] = 'Kaikki aktiivisuus (lataukset ja viestit)';
$string['statsreport7'] = 'Käyttäjien aktiivisuus (lataukset ja viestit)';
$string['statsreport8'] = 'Kaikki käyttäjien aktiivisuus';
$string['statsreport9'] = 'Kirjautumiset';
$string['statsreportactivity'] = 'Kaikki aktiivisuus (kaikki roolit)';
$string['statsreportactivitybyrole'] = 'Kaikki aktiivisuus';
$string['statsreportforuser'] = 'kohteelle';
$string['statsreportlogins'] = 'Kirjautumiset';
$string['statsreportreads'] = 'Sivulataukset (kaikki roolit)';
$string['statsreporttype'] = 'Raportin tyyppi';
$string['statsreportwrites'] = 'Viestit (kaikki roolit)';
$string['statsstudentactivity'] = 'Opiskelijoiden aktiivisuus';
$string['statsstudentreads'] = 'Opiskelijoiden sivulataukset';
$string['statsstudentwrites'] = 'Opiskelijoiden viestit';
$string['statsteacheractivity'] = 'Opettajien aktiivisuus';
$string['statsteacherreads'] = 'Opettajien sivulataukset';
$string['statsteacherwrites'] = 'Opettajien viestit';
$string['statstimeperiod'] = 'Ajanjakso - viimeisin:';
$string['statsuniquelogins'] = 'Käyttäjät (unique logins)';
$string['statsuseractivity'] = 'Kaikki aktiivisuus';
$string['statsuserlogins'] = 'Kirjautumiset';
$string['statsuserreads'] = 'Sivulataukset';
$string['statsuserwrites'] = 'Viestit';
$string['statswrites'] = 'Viestit';
$string['status'] = 'Tilanne';
$string['stringsnotset'] = 'Seuraavat merkkijonot eivät ole määriteltynä tiedostossa {$a}';
$string['studentnotallowed'] = 'Valitettavasti et voi liittyä kurssille tunnuksella \'{$a}\'';
$string['students'] = 'Opiskelijat';
$string['studentsandteachers'] = 'Opiskelijat ja opettajat';
$string['subcategories'] = 'Alakategoriat';
$string['subcategory'] = 'Alikategoria';
$string['subcategoryof'] = 'Kategorian {$a} alikategoria';
$string['submit'] = 'Lähetä';
$string['success'] = 'Valmis!';
$string['summary'] = 'Yhteenveto';
$string['summary_help'] = 'Aiheyhteenvedon idea on, että teksti valmistelee opiskelijoita aiheen tai viikon sisällä oleviin toimintoihin. Yhteenvetojen kannattaa olla lyhyitä, jotta kurssisivu ei veny liikaa.

Jos huomaat haluavasi sanoa enemmän kuin pari lausetta, harkitse sivun kirjoittamista aiheesta.';
$string['summaryof'] = '{$a} Yhteenveto';
$string['supplyinfo'] = 'Lisätietoja';
$string['switchdevicedefault'] = 'Vaihda standardi-teemaan';
$string['switchdevicerecommended'] = 'Vaihda päätelaitteellesi suositeltuun teemaan.';
$string['switchrolereturn'] = 'Palaa omaan rooliisi';
$string['switchroleto'] = 'Vaihda roolia...';
$string['tag'] = 'Tunniste';
$string['tagalready'] = 'Tunniste on jo käytössä';
$string['tagmanagement'] = 'Lisää/Poista tunnisteita';
$string['tags'] = 'Tunnisteet';
$string['targetrole'] = 'Kohderooli';
$string['teacheronly'] = 'vain {$a} :lle';
$string['teacherroles'] = 'Roolit';
$string['teachers'] = 'Opettajat';
$string['textediting'] = 'Kun muokkaat tekstiä';
$string['texteditor'] = 'Käytä tekstieditoria';
$string['textformat'] = 'Teksti';
$string['thanks'] = 'Kiitokset';
$string['theme'] = 'Teema';
$string['themes'] = 'Teemat';
$string['themesaved'] = 'Uusi teema tallennettu';
$string['therearecourses'] = 'Yhteensä {$a} kurssia';
$string['thereareno'] = 'Tällä kurssilla ei ole {$a}:ta';
$string['thiscategorycontains'] = 'Tämä kategoria sisältää';
$string['time'] = 'Aika';
$string['timezone'] = 'Aikavyöhyke';
$string['to'] = 'Päättyen';
$string['tocreatenewaccount'] = 'Ohita luodaksesi uuden tilin';
$string['today'] = 'Tänään';
$string['todaylogs'] = 'Päivän tapahtumat';
$string['toeveryone'] = 'kaikille';
$string['toomanybounces'] = 'Kyseiseen sähköpostiosoitteeseen lähetetyt viestit eivät ole päässeet perille. Sinun <b>täytyy</b> muuttaa sähköpostiosoitetta jatkaaksesi.';
$string['toomanytoshow'] = 'Liian paljon käyttäjiä näytettäväksi';
$string['toomanyusersmatchsearch'] = 'Liian paljon käyttäjiä ({$a->count}) täsmää hakuun \'{$a->search}';
$string['toomanyuserstoshow'] = 'Liian paljon käyttäjiä ({$a}) näytettäväksi';
$string['toonly'] = 'vain {$a}:lle';
$string['top'] = 'Ylös';
$string['topic'] = 'Aihe';
$string['topichide'] = 'Piilota tämä aihe';
$string['topicoutline'] = 'Aiheen kuvaus';
$string['topicshow'] = 'Näytä tämä aihe';
$string['total'] = 'Yhteensä';
$string['trackforums'] = 'Keskustelualueen seuranta';
$string['trackforumsno'] = 'Ei: älä pidä kirjaa näkemistäni viesteistä';
$string['trackforumsyes'] = 'Kyllä: korosta uudet viestit kurssialueella';
$string['trysearching'] = 'Kokeile hakutoimintoa.';
$string['turneditingoff'] = 'Muokkaustila pois';
$string['turneditingon'] = 'Muokkaustila päälle';
$string['undecided'] = 'Valitsematon';
$string['unfinished'] = 'Kesken';
$string['unknowncategory'] = 'Tuntematon kategoria';
$string['unlimited'] = 'Rajoittamaton';
$string['unpacking'] = 'Puretaan {$a}';
$string['unsafepassword'] = 'Liian helposti arvattava tai muuten huono salasana. Kokeile jotain muuta';
$string['untilcomplete'] = 'Kunnes valmis';
$string['unusedaccounts'] = 'Käyttäjätunnukset, jotka ovat olleet käyttämättä yli {$a} päivää, poistetaan automaattisesti.';
$string['unzip'] = 'Pura';
$string['unzippingbackup'] = 'Puretaan varmuuskopiota';
$string['up'] = 'Ylös';
$string['update'] = 'Päivitä';
$string['updated'] = 'Päivitetty {$a}';
$string['updatemymoodleoff'] = 'Lopeta tämän sivun muokkaus';
$string['updatemymoodleon'] = 'Muokkaa tätä sivua haluamaksesi';
$string['updatemyprofile'] = 'Tallenna tiedot';
$string['updatesevery'] = 'Päivitä joka {$a} sekunti';
$string['updatethis'] = 'Asetukset';
$string['updatethiscourse'] = 'Päivitä tämä kurssi';
$string['updatinga'] = 'Päivitetään {$a}';
$string['updatingain'] = 'Päivitetään {$a->what} (kohdassa {$a->in})';
$string['upload'] = 'Lähetä';
$string['uploadafile'] = 'Hae tiedosto';
$string['uploadcantwrite'] = 'Tiedoston tallentaminen levylle ei onnistunut';
$string['uploadedfile'] = 'Tiedoston lähetys onnistui';
$string['uploadedfileto'] = 'Tiedosto {$a->file} lähetetty hakemistoon {$a->directory}';
$string['uploadedfiletoobig'] = 'Tiedosto on liian suuri (raja on {$a} tavua)';
$string['uploadextension'] = 'Tiedoston pääte PHP esti tiedoston lataamisen';
$string['uploadfailednotrecovering'] = 'Tiedoston lähettäminen ei onnistunut koska tiedostossa "{$a->name}" oli ongelmia. <br /> Havaitut ongelmat olivat: <br /> {$a->problem} <br />';
$string['uploadfilelog'] = 'Tiedoston {$a} lähetystapahtumat';
$string['uploadformlimit'] = 'Lähetetyn tiedoston {$a} koko ylitti lomakkeen asettamat rajat';
$string['uploadlabel'] = 'Otsikko';
$string['uploadlimitwithsize'] = '{$a->contextname}-tasoinen tiedostokoon yläraja {$a->displaysize}';
$string['uploadnewfile'] = 'Lähetä uusi tiedosto';
$string['uploadnofilefound'] = 'Tiedostoa ei löytynyt, valitsitko varmasti lähetettävän tiedoston?';
$string['uploadnotallowed'] = 'Tiedostojen latausta sivustolle ei sallita.';
$string['uploadnotempdir'] = 'Väliaikaishakemistoa ei löydy';
$string['uploadoldfilesdeleted'] = 'Vanhat tiedostot on poistettu tiedostoalueelta.';
$string['uploadpartialfile'] = 'Tiedoston lähetys onnistui vain osittain';
$string['uploadproblem'] = 'Tuntematon virhe tallennettaessa tiedostoa \'{$a}\'. (Ehkä se oli liian suuri?)';
$string['uploadrenamedchars'] = 'Tiedosto nimettiin uudelleen "{$a->oldname}" > "{$a->newname}" nimessä olleiden kiellettyjen merkkien vuoksi.';
$string['uploadrenamedcollision'] = 'Tiedosto nimettiin uudelleen "{$a->oldname}" > "{$a->newname}" koska samanniminen tiedosto oli jo olemassa.';
$string['uploadserverlimit'] = 'Lähetyksen koko oli suurempi kuin www-palvelimelle asetettu maksimikoko.';
$string['uploadthisfile'] = 'Lähetä tämä tiedosto';
$string['url'] = 'Verkko-osoite';
$string['used'] = 'Käytössä';
$string['usedinnplaces'] = 'Käytössä {$a} paikassa';
$string['usemessageform'] = 'tai käytä alla olevaa lomaketta lähettääksesi viestin valituille opiskelijoille';
$string['user'] = 'Käyttäjä';
$string['userconfirmed'] = 'Vahvistettu {$a}';
$string['usercurrentsettings'] = 'Omat profiiliasetukseni';
$string['userdata'] = 'Käyttäjän tiedot';
$string['userdeleted'] = 'Tämä tunnus on poistettu';
$string['userdescription'] = 'Kuvaus';
$string['userdescription_help'] = 'Voit kirjoittaa tähän laatikkoon itsestäsi. Teksti näytetään profiilisivullasi.';
$string['userdetails'] = 'Käyttäjätiedot';
$string['userfiles'] = 'Käyttäjän tiedostot';
$string['userlist'] = 'Osallistujalista';
$string['username'] = 'Käyttäjätunnus';
$string['usernameemailmatch'] = 'Käyttäjätunnus ja osoite eivät kuulu samalle käyttäjälle';
$string['usernameexists'] = 'Tämä käyttäjätunnus on jo käytössä, valitse joku muu.';
$string['usernamelowercase'] = 'Käytä vain pieniä kirjaimia';
$string['usernamenotfound'] = 'Käyttäjätunnusta ei löytynyt tietokannasta';
$string['usernameoremail'] = 'Kirjoita joko käyttäjätunnus tai sähköpostiosoite';
$string['usernotconfirmed'] = '{$a} ei voida vahvistaa';
$string['userpic'] = 'Käyttäjän kuva';
$string['users'] = 'Käyttäjähallinta';
$string['userselectorautoselectunique'] = 'Jos vain yksi käyttäjä täsmää hakutuloksiin, valitse hänet automaattisesti';
$string['userselectorpreserveselected'] = 'Pidä valitut käyttäjät vaikka he eivät enää täsmäisi hakuun';
$string['userselectorsearchanywhere'] = 'Hae tekstiä kaikista näytetyistä kentistä';
$string['usersnew'] = 'Uudet käyttäjät';
$string['usersnoaccesssince'] = 'Passiivinen kauemmin kuin';
$string['userswithfiles'] = 'Käyttäjät, joilla on tiedostoja';
$string['useruploadtype'] = 'Käyttäjän upload-tyyppi: {$a}';
$string['userviewingsettings'] = 'Profiiliasetukset {$a}';
$string['userzones'] = 'Käyttäjien alueet';
$string['usetheme'] = 'Käytä teemaa';
$string['usingexistingcourse'] = 'Käytä olemassa olevaa kurssia';
$string['valuealreadyused'] = 'Arvo on jo käytetty';
$string['version'] = 'Versio';
$string['view'] = 'Näkymä';
$string['viewallcourses'] = 'Näytä kaikki kurssit';
$string['viewallcoursescategories'] = 'Näytä kaikki kurssit ja kategoriat';
$string['viewallsubcategories'] = 'Näytä kaikki alikategoriat';
$string['viewfileinpopup'] = 'Näytä tiedosto ponnahdusikkunassa';
$string['viewing'] = 'Näytetään:';
$string['viewmore'] = 'Näytä lisää';
$string['viewprofile'] = 'Näytä profiili';
$string['views'] = 'Katselut';
$string['viewsolution'] = 'Katso vastaus';
$string['virusfound'] = 'Ylläpitäjä huomio! Clam AV löysi viruksen käyttäjän {$a->user} kurssille {$a->course} lähettämästä tiedostosta. Tässä on Clam AV:n  tiedot tapahtuneesta:';
$string['virusfoundlater'] = 'Kurssille {$a->course}  {$a->date} lähettämästäsi tiedostosta {$a->filename} on löytynyt virus. Tiedostollesi on tapahtunut seuraavaa:

{$a->action}

Jos tämä on tehtävän palautus, uudelleenlähetys saattaa olla tarpeen jotta arviointi voidaan suorittaa.';
$string['virusfoundlateradmin'] = 'Ylläpitäjä huomio! Käyttäjän {$a->user} kurssille {$a->course}  {$a->date} lähettämästä tiedostosta {$a->filename} on löytynyt virus. Tiedostolle on tapahtunut seuraavaa:

{$a->action}

Käyttäjälle on ilmoitettu tapahtuneesta.';
$string['virusfoundlateradminnolog'] = 'Ylläpitäjä huomio! Lähetetystä tiedostosta {$a->filename} on löytynyt virus. Moodle ei voinut selvittää tiedoston lähettäjää.

Tiedostolle on tapahtunut seuraavaa:

{$a->action}';
$string['virusfoundsubject'] = '{$a} : Viruksen saastuttama!';
$string['virusfounduser'] = 'Tiedosto {$a}, jonka lähetit, on viruksen saastuttama. Tiedoston lähetys ei onnistunut.';
$string['virusplaceholder'] = 'Lähetetty tiedosto oli viruksen saastuttama ja tiedosto on eristetty tai tuhottu. Käyttäjälle on ilmoitettu asiasta.';
$string['visible'] = 'Näytetään opiskelijoille';
$string['visible_help'] = 'Jos kurssi on suljettu opiskelijoilta, se ei näy kurssilistoissa eikä kurssille pääse kirjautumaan edes kurssialueen suoralla osoitteella. Kurssin näkevät vain sille lisätyt opettajat sekä ylläpito. Kurssialue näkyy listassa harmaana.

Muista siis käydä vaihtamassa tämä asetus muotoon <b>Tämä kurssi on avoinna opiskelijolle</b> ennen kuin opetus alkaa. Voit lisätä opiskelijoita jo valmiiksi myös suljetulle alueelle, mutta he eivät pääse sille ennen kuin käyt muuttamassa asetuksen.';
$string['visibletostudents'] = 'Näytetään roolille';
$string['warning'] = 'Varoitus';
$string['warningdeleteresource'] = 'Varoitus: Kohteeseen {$a} on viittauksia aineistossa. Haluatko päivittää aineiston?';
$string['webpage'] = 'Verkkosivu';
$string['week'] = 'Viikko';
$string['weekhide'] = 'Piilota tämä viikko';
$string['weeklyoutline'] = 'Viikkonäkymä';
$string['weeks'] = 'viikkoja';
$string['weekshow'] = 'Näytä tämä viikko';
$string['welcometocourse'] = 'Tervetuloa kurssille {$a}';
$string['welcometocoursetext'] = 'Tervetuloa kurssille {$a->coursename}!

Ensimmäiseksi sinun kannattaa muokata käyttäjätietojasi, jotta muut voivat tutustua sinuun:

  {$a->profileurl}';
$string['whattocallzip'] = 'Miksi haluat kutsuttavan zip-tiedostoa?';
$string['whattodo'] = 'Mitä tehdä';
$string['windowclosing'] = 'Tämän ikkunan pitäisi sulkeutua automaattisesti. Jos ei, niin sulje se nyt.';
$string['withchosenfiles'] = 'Valituilla tiedostoilla';
$string['withdisablednote'] = '{$a} (ei käytössä)';
$string['withoutuserdata'] = 'ilman käyttäjien tiedostoja';
$string['withselectedusers'] = 'Valituille käyttäjille...';
$string['withselectedusers_help'] = '* Lähetä viesti - Yhdelle tai useammalle osallistujalle
* Lisää uusi merkintä - Lisää merkinnän yhdelle valitulle osallistujalle
* Lisää yleinen merkintä - Sama merkitä useammalle kuin yhdelle osallistujalle';
$string['withuserdata'] = 'käyttäjien tiedostojen kanssa';
$string['wordforstudent'] = 'Sana opiskelijalle';
$string['wordforstudenteg'] = 'esim. opiskelija, osallistuja jne...';
$string['wordforstudents'] = 'Sana opiskelijoille';
$string['wordforstudentseg'] = 'esim. opiskelijat, osallistujat jne...';
$string['wordforteacher'] = 'Sana opettajalle';
$string['wordforteachereg'] = 'esim. opettaja, ohjaaja jne...';
$string['wordforteachers'] = 'Sana opettajille';
$string['wordforteacherseg'] = 'esim. opettajat, ohjaajat jne...';
$string['writingblogsinfo'] = 'Kirjoitetaan blogien tietoja';
$string['writingcategoriesandquestions'] = 'Kirjoitetaan kategorioita ja kysymyksiä';
$string['writingcoursedata'] = 'Kirjoitetaan kurssidataa';
$string['writingeventsinfo'] = 'Kirjoitetaan tapahtumien tietoja';
$string['writinggeneralinfo'] = 'Kirjoitetaan yleistietoja';
$string['writinggradebookinfo'] = 'Kirjoitetaan arviointikirjan tietoja';
$string['writinggroupingsgroupsinfo'] = 'Kirjoitetaan ryhmitysten-ryhmien tietoja';
$string['writinggroupingsinfo'] = 'Kirjoitetaan ryhmitysten tietoja';
$string['writinggroupsinfo'] = 'Kirjoitetaan ryhmien tietoja';
$string['writingheader'] = 'Kirjoitetaan otsikkoa';
$string['writingloginfo'] = 'Kirjoitetaan lokitietoja';
$string['writingmessagesinfo'] = 'Kirjoitetaan viestien tietoja';
$string['writingmoduleinfo'] = 'Kirjoitetaan moduulitietoja';
$string['writingscalesinfo'] = 'Kirjoitetaan asteikkotietoja';
$string['writinguserinfo'] = 'Kirjoitetaan käyttäjätietoja';
$string['wrongpassword'] = 'Väärä salasana';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'vuosi';
$string['years'] = 'vuotta';
$string['yes'] = 'Kyllä';
$string['youareabouttocreatezip'] = 'Olet aikeissa luoda zip-tiedoston, joka sisältää';
$string['youaregoingtorestorefrom'] = 'Olet aikeissa aloittaa palautusprosessin kurssille';
$string['youneedtoenrol'] = 'Toiminnon suorittaminen vaatii liittymisen tälle kurssille.';
$string['yourlastlogin'] = 'Viimeisin kirjautumisesi oli:';
$string['yourself'] = 'sinä itse';
$string['yourteacher'] = '{$a}si';
$string['yourwordforx'] = 'Sanavalintasi \'{$a}\'';
$string['zippingbackup'] = 'Pakataan varmuuskopiota';
