<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Ylläpitohakemisto on määritetty väärin';
$string['admindirname'] = 'Ylläpitohakemisto';
$string['admindirsetting'] = 'Jotkut web-palvelut käyttävät /admin hakemistoa ylläpitotarkoituksiin tms. Valitettavasti tämä on ristiriidassa Moodlen ylläpitosivujen normaalin paikan kanssa. Voit korjata tämän nimeämällä asennuksesi ylläpitohakemiston uudelleen ja laittamalla uuden nimen tähän. Esimerkiksi:
<br /> <br /><b>moodleadmin</b><br /> <br />
Tämä korjaa ylläpitolinkit Moodlessa.';
$string['admindirsettinghead'] = 'Asetetaan ylläpitohakemisto';
$string['admindirsettingsub'] = 'Jotkut sivustot käyttävät /admin-hakemistoa omiin tarkoituksiinsa. Tämä on ristiriidassa moodlen /admin-kansion kanssa.
Voit korjata tämän nimeämällä moodlen admin-kansion uudelleen antamalla uuden nimen tähän.Esimerkiksi:
<br /> <br /><b>moodleadmin</b><br /> <br />
Tämä korjaa ylläpitolinkit Moodlessa.';
$string['availablelangs'] = 'Saatavilla olevat kielipaketit';
$string['caution'] = 'Varoitus';
$string['chooselanguage'] = 'Valitse kieli';
$string['chooselanguagehead'] = 'Valitse kieli';
$string['chooselanguagesub'] = 'Valitse kieli asennusohjelmaa varten. Tätä kieltä käytetään sivuston oletuskielenä, jonka voi vaihtaa tarpeen mukaan. Myöhemmin voit myös lisätä käyttöön muitakin kieliä.';
$string['cliadminpassword'] = 'Uusi ylläpitäjän salasana';
$string['cliadminusername'] = 'Ylläpitäjätilin käyttäjätunnus';
$string['clialreadyconfigured'] = 'Tiedosto config.php on jo olemassa, käytä admin/cli/install_database.php -tiedostoa jos haluat asentaa tämän sivuston.';
$string['clialreadyinstalled'] = 'Tiedosto config.php on jo olemassa, ole hyvä ja käytä admin/cli/upgrade.php:ta jos haluat päivittää sivustosi';
$string['cliinstallfinished'] = 'Asennus suoritettu onnistuneesti.';
$string['cliinstallheader'] = 'Moodlen {$a} komentoriviasennusohjelma';
$string['climustagreelicense'] = 'Ei-interaktiivisessa moodissa sinun täytyy hyväksyä lisenssi valitsemalla --agree-license';
$string['clitablesexist'] = 'Tietokantataulut on jo luotu, cli-asennusta ei voida jatkaa.';
$string['compatibilitysettings'] = 'Tarkistetaan PHP:n asetukset';
$string['compatibilitysettingshead'] = 'Tarkistetaan PHP:n asetukset';
$string['compatibilitysettingssub'] = 'Palvelimesi pitää läpäistä kaikki testit jotta moodle toimisi oikein.';
$string['configfilenotwritten'] = 'Asennus ei pystynyt luomaan automaattisesti config.php -tiedostoa, joka olisi sisältänyt valitsemasi asetukset, todennäköisesti koska Moodlen hakemisto on kirjoitussuojattu. Voit manuaalisesti kopioida seuraavan koodin tiedostoon nimeltä config.php Moodlen päähakemiston sisällä.';
$string['configfilewritten'] = 'config.php on luotu.';
$string['configurationcomplete'] = 'Asetukset suoritettu';
$string['configurationcompletehead'] = 'Asetukset suoritettu';
$string['configurationcompletesub'] = 'Moodle yritti tallentaa asetustiedostoa "config.php" moodlen asennuskansioon.';
$string['database'] = 'Tietokanta';
$string['databasehead'] = 'Tietokannan asetukset';
$string['databasehost'] = 'Tietokannan isäntä';
$string['databasename'] = 'Tietokannan nimi';
$string['databasepass'] = 'Tietokannan salasana';
$string['databasesocket'] = 'Unix-kanta';
$string['databasetypehead'] = 'Valitse tietokannan ajuri';
$string['databasetypesub'] = 'Moodle tukee useita eri tyyppisiä tietokantapalvelimia. Ole hyvä ja ota yhteyttä palvelimen ylläpitäjään jos ei tiedä mitä tyyppiä käyttää.';
$string['databaseuser'] = 'Tietokannan käyttäjä';
$string['dataroot'] = 'Datahakemisto';
$string['datarooterror'] = 'Tietohakemistoa, jonka määrittelit, ei löydetty, eikä sitä voitu luoda. Korjaa polku tai luo hakemisto manuaalisesti.';
$string['datarootpermission'] = 'Datahakemistojen oikeudet';
$string['datarootpublicerror'] = 'Määrittelemääsi \'datahakemistoon\' on suora yhteys verkosta, sinun täytyy käyttää toista hakemistoa.';
$string['dbconnectionerror'] = 'Emme pystyneet kytkeytymään tietokantaan, jonka määrittelit. Tarkista tietokanta-asetuksesi.';
$string['dbcreationerror'] = 'Tietokannan luomisvirhe. Ei pystytty luomaan annettua tietokannan nimeä tarjotuilla asetuksilla.';
$string['dbhost'] = 'Isäntäpalvelin';
$string['dbpass'] = 'Salasana';
$string['dbport'] = 'Portti';
$string['dbprefix'] = 'Taulukon etumerkki';
$string['dbtype'] = 'Tyyppi';
$string['directorysettings'] = '<p>Vahvista tämän Moodle asennuksen sijainti.</p>

<p><b>Web-osoite:</b>
Määritä koko Web osoite, josta Moodlea käytetään.
Jos websivustoosi päästään monen URL:n kautta, valitse kaikkein luonnollisin vaihtoehto, se jota oppilaasikin käyttäisivät. Älä sisällytä kenoviivaa.</p>

<p><b>Moodle-hakemisto:</b>
Määritä koko hakemistopolku tähän asennukseen. Varmista, että isot/pienet kirjaimet ovat oikein.</p>

<p><b>Data-hakemisto:</b>
Tarvitset paikan, jonne Moodle voi tallentaa ladatut tiedostot. Tämän hakemiston pitäisi olla luettavissa ja kirjoitettavissa web palvelin käyttäjän taholta (usein \'nobody\' tai \'apache\'), mutta sen ei pitäisi olla käytettävissä suoraan web:in kautta. Asennusohjelma yrittää luoda hakemiston ellei sitä ole olemassa.</p>';
$string['directorysettingshead'] = 'Vahvista tämän Moodle asennuksen sijainti';
$string['directorysettingssub'] = '<p><b>Verkko-osoite:</b>
Määritä koko verkko-osoite, josta Moodlea käytetään.
Jos sivustoosi päästään monen osoitteen kautta, valitse luontevin vaihtoehto, jota opiskelijatkin käyttäisivät. Älä sisällytä kenoviivaa.</p>

<p><b>Moodle-hakemisto:</b>
Määritä koko hakemistopolku tähän asennukseen. Varmista, että isot/pienet kirjaimet ovat oikein.</p>

<p><b>Tietohakemisto:</b>
Tarvitset paikan, jonne Moodle voi tallentaa ladatut tiedostot. Tämän hakemiston pitäisi olla palvelinkäyttäjän (usein \'nobody\' tai \'apache\') luettavissa ja kirjoitettavissa, mutta sen ei pitäisi olla käytettävissä suoraan verkon kautta. Asennusohjelma yrittää luoda hakemiston ellei sitä ole olemassa.</p>';
$string['dirroot'] = 'Moodle-hakemisto';
$string['dirrooterror'] = 'Asetus \'Moodle-hakemisto\' -asetus näyttäisi olevan väärin - Moodle-asennusta ei löytynyt. Arvo alapuolella on nollattu.';
$string['download'] = 'Lataa';
$string['downloadlanguagebutton'] = 'Lataa "{$a}"  kielipaketti';
$string['downloadlanguagehead'] = 'Lataa kielipaketti';
$string['downloadlanguagenotneeded'] = 'Voit jatkaa asennusta oletuskielellä, "{$a}"';
$string['downloadlanguagesub'] = 'Sinulla on mahdollisuus ladata kielipaketti ja jatkaa asennusprosessia tämmä kielellä.<br /><br />Jos et pysty lataamaan kielipakettia, asennusta jatketaan englanniksi. (Kun asennus on valmis sinulla on mahdollisuus ladata ja asentaa muita kielipaketteja.)';
$string['doyouagree'] = 'Hyväksytkö? (yes/no):';
$string['environmenthead'] = 'Ympäristön tarkistus';
$string['environmentsub'] = 'Asennusohjelma tarkistaa että järjestelmäsi vastaa moodlen vaatimuksia';
$string['environmentsub2'] = 'Jokaisessa Moodle-julkaisussa on joitakin vähimmäisvaatimuksia PHP-versiolta sekä joitakin pakollisia PHP-lisäosia.
Ennen jokaista asennusta ja päivitystä suoritetaan täysi ympäristön tarkistus. Ole hyvä ja ota yhteyttä palvelimen ylläpitoon jos et tiedä kuinka asentaa uutta versiota tai PHP-lisäosia.';
$string['errorsinenvironment'] = 'Ympäristön tarkastus epäonnistui!';
$string['fail'] = 'Virhe';
$string['fileuploads'] = 'Tiedostojen lähettäminen';
$string['fileuploadserror'] = 'Tämän pitäisi olla päällä';
$string['fileuploadshelp'] = '<p>Tiedostojen lähettäminen ei näyttäisi olevan käytössä palvelimellasi.</p>

<p>Moodle voidaan silti asentaa, mutta ilman tätä ominaisuutta et pysty lataamaan kurssitiedostoja tai uuden käyttäjän profiilikuvia.</p>

<p>Mahdollistaaksesi tiedostojen latauksen sinun (tai järjestelmän ylläpitäjän) täytyy muokata php.ini -tiedostoa ja muuttaa asetukseksi kohtaan <b>file_uploads</b>  \'1\'.</p>';
$string['inputdatadirectory'] = 'Datahakemisto:';
$string['inputwebadress'] = 'Web-osoite:';
$string['inputwebdirectory'] = 'Moodle-hakemisto:';
$string['installation'] = 'Asennus';
$string['langdownloaderror'] = 'Valitettavasti kieltä "{$a}" ei voitu ladata. Asennus jatkuu englanniksi.';
$string['langdownloadok'] = 'Kilei "{$a}" asennettiin onnistuneesti. Asennus jatkuu tällä kielellä.';
$string['magicquotesruntime'] = 'Magic quotes ajoaika';
$string['magicquotesruntimeerror'] = 'Tämän pitäisi olla poissa päältä';
$string['magicquotesruntimehelp'] = '<p>Magic quotes ajoajan pitäisi olla pois päältä, jotta Moodle voi toimia kunnolla.</p>

<p>Normaalisti se on pois päältä oletuksena... Katso asetukset
<b>magic_quotes_runtime</b> php.ini -tiedostosta.</p>

<p>Jos sinulla ei ole pääsyä php.ini:isi, saatat pystyä asettamaan seuraavan rivin tiedostoon nimeltä .htaccess Moodlen hakemiston sisällä:
<blockquote>php_value magic_quotes_runtime Off</blockquote>
</p>';
$string['memorylimit'] = 'Muistiraja';
$string['memorylimiterror'] = 'PHP muistiraja on asetettu aika alas... Se saattaa aiheuttaa ongelmia myöhemmin.';
$string['memorylimithelp'] = '<p>PHP muistiraja palvelimellesi on tällä hetkellä asetettu {$a}:han.</p>

<p>Tämä saattaa aiheuttaa Moodlelle muistiongelmia myöhemmin, varsinkin jos sinulla on paljon mahdollisia moduuleita ja/tai paljon käyttäjiä.</p>

<p>Suosittelemme, että valitset asetuksiksi PHP:n korkeimmalla mahdollisella raja-arvolla, esimerkiksi 40M.
On olemassa monia tapoja joilla voit yrittää tehdä tämän:</p>
<ol>
<li>Jos pystyt, uudelleenkäännä PHP <i>--enable-memory-limit</i>. :llä.
Tämä sallii Moodlen asettaa muistirajan itse.</li>
<li>Jos sinulla on pääsy php.ini tiedostoosi, voit muuttaa <b>memory_limit</b> asetuksen siellä johonkin kuten 40M. Jos sinulla ei ole pääsyoikeutta, voit kenties pyytää ylläpitäjää tekemään tämän puolestasi.</li>
<li>Joillain PHP palvelimilla voit luoda a .htaccess tiedoston Moodle hakemistossa, sisältäen tämän rivin:
<p><blockquote>php_value memory_limit 40M</blockquote></p>
<p>Kuitenkin, joillain palvelimilla tämä estää  <b>kaikkia</b> PHP sivuja toimimasta (näet virheet, kun katsot sivuja), joten sinun täytyy poistaa .htaccess tiedosto.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP:ta ei ole oikein konfiguroitu MSSQL-lisäosan kanssa, jotta se voisi kommunnikoida SQL*Palvelimen kanssa. Ole hyvä ja tarkasta php.ini -tiedostosi tai käännä PHP uudestaan.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP:ta ei ole oikein konfiguroitu MySQLi-lisäosan kanssa, jotta se voisi kommunnikoida MySQL:n kanssa. Ole hyvä ja tarkasta php.ini -tiedostosi tai käännä PHP uudestaan. MySQLi-lisäosaa ei ole saatavilla PHP-versiolle 4.';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Nyt sinun tulee konfiguroida tietokanta, jossa suurin osa Moodlen tiedoista säilytetään. Tämän tietokannan, sekä käyttäjätunnuksen ja salasanan sille, tulee olla jo luotu. Taulun etuliite on pakollinen.';
$string['nativemysqli'] = 'Parannettu MySQL (native/mysqli)';
$string['nativemysqlihelp'] = 'Nyt sinun tulee konfiguroida tietokanta, jossa suurin osa Moodlen tiedoista säilytetään. Tietokanta voidaan luoda jos tietokannan käyttäjällä on tarvittavat oikeudet, käyttäjätunnuksen ja salasanan tulee olla jo luotu. Taulun etuliite on valinnainen.';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Nyt sinun tulee konfiguroida tietokanta, jossa suurin osa Moodlen tiedoista säilytetään. Tämän tietokannan, sekä käyttäjätunnuksen ja salasanan sille, tulee olla jo luotu. Taulun etuliite on pakollinen.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = 'Nyt sinun tulee konfiguroida tietokanta, jossa suurin osa Moodlen tiedoista säilytetään. Tämän tietokannan, sekä käyttäjätunnuksen ja salasanan sille, tulee olla jo luotu. Taulun etuliite on pakollinen.';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Nyt sinun tulee konfiguroida tietokanta, jossa suurin osa Moodlen tiedoista säilytetään. Tämän tietokannan, sekä käyttäjätunnuksen ja salasanan sille, tulee olla jo luotu. Taulun etuliite on pakollinen.';
$string['ociextensionisnotpresentinphp'] = 'PHP:ta ei ole oikein konfiguroitu OCI8-lisäosan kanssa, jotta se voisi kommunnikoida Oraclen kanssa. Ole hyvä ja tarkasta php.ini -tiedostosi tai käännä PHP uudestaan.';
$string['pass'] = 'Tarkastettu';
$string['paths'] = 'Polut';
$string['pathserrcreatedataroot'] = 'Asennusohjelma ei voi luoda datahakemistoa ({$a->dataroot}).';
$string['pathshead'] = 'Varmista polut';
$string['pathsrodataroot'] = 'Dataroot-hakemisto ei ole kirjoitettavissa.';
$string['pathsroparentdataroot'] = 'Ylähakemisto ({$a->parent}) ei ole kirjoitettavissa. Asennusohjelma ei voi luoda datahakemistoa ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Jotkut sivustot käyttävät /admin URL-osoitetta hallintapaneelille tai vastaavalle. Tämä on valitettavasti ristiriidassa Moodlen normaalin admin-sivun sijainnin kanssa.
Voit korjata tämän nimeämällä asennuksesi admin-hakemiston uudelleen, antamalla uuden nimen tähän. Esimerkiksi: <em>moodleadmin</em>. Tämä korjaa admin-linkit Moodlessa.';
$string['pathssubdataroot'] = 'Tarvitset paikan, jonne Moodle voi tallentaa ladatut tiedostot. Tämän hakemiston pitäisi olla luettavissa ja kirjoitettavissa web-palvelimen käyttäjän taholta (yleensä "nobody" tai "apache"), mutta se ei saa olla käytettävissä suoraan web:in kautta. Jos hakemistoa ei ole, asennusohjelma yrittää luoda sen.';
$string['pathssubdirroot'] = 'Koko hakemistopolku Moodle-asennukseen.';
$string['pathssubwwwroot'] = 'Moodlen koko verkko-osoite.
Moodleen ei ole mahdollista päästä käyttäen useita osoitteita.
Jos sivustollasi on useita julkisisa osoitteita, sinun täytyy asettaa pysyvät ohjaukset kaikkiin niistä lukuunottamatta tätä.
Jos sivustollesi on pääsy sekä Intranetistä että Internetistä, käytä tässä julkista osoitetta ja aseta DNS niin, että myös Intranet-käyttäjät voivat käyttää julkista osoitetta.
Jos osoite ei ole oikea, muuta URL-osoitetta selaimessasi aloittaaksesi asennuksen uudelleen eri arvolla.';
$string['pathsunsecuredataroot'] = 'Dataroot-sijainti on turvallinen';
$string['pathswrongadmindir'] = 'Admin-hakemistoa ei ole';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP:ta ei ole oikein konfiguroitu PGSQL-lisäosan kanssa, jotta se voisi kommunnikoida PostgreSQL:n kanssa. Ole hyvä ja tarkasta php.ini -tiedostosi tai käännä PHP uudestaan.';
$string['phpextension'] = '{$a} PHP-lisäosa';
$string['phpversion'] = 'PHP versio';
$string['phpversionhelp'] = '<p>Moodle vaatii vähintään PHP-version 4.3.0 tai 5.1.0 (5.0.x sisältää monia tunnettuja ongelmia).</p> <p>Käytössäsi on versio {$a}</p> <p>Sinun pitää päivittää PHP tai siirtää palvelimelle jossa on uudempi PHP.<br /> (Jos käytössäsi on 5.0.x voit myös päivittää alaspäin 4.4.x -versioon)</p>';
$string['releasenoteslink'] = 'Halutessasi lisätietoa tästä Moodle-versiosta, katso julkaisutiedot osoitteessa {$a}';
$string['safemode'] = 'Safe mode';
$string['safemodeerror'] = 'Moodlella saattaa olla ongelmia PHP:n  Safe Moden ollessa päällä';
$string['safemodehelp'] = '<p>Moodlella saattaa olla lukuisia ongelmia Safe Moden ollessa päällä, joista vähäisin ei ole se, ettei se todennäköisesti pysty luomaan uusia tiedostoja.</p>
<p>Turvatila on yleensä aktivoinut paranoidinen web-palvelun pitäjä, joten sinun ehkä täytyy vaihtaa palveluntarjoajaa Moodlen ylläpitoa varten.</p>

<p>Voit yrittää jatkaa asennusta, mutta varaudu ongelmiin myöhemmin.</p>';
$string['sessionautostart'] = 'Istunnon automaattinen aloitus';
$string['sessionautostarterror'] = 'Tämän pitäisi olla pois päältä';
$string['sessionautostarthelp'] = '<p>Moodle vaatii istuntotukea, eikä toimi ilman sitä.</p>

<p>istunto voidaan mahdollistaa php.ini tiedostossa... Etsi istuntoa varten.auto_start parameter.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP:ta ei ole oikein konfiguroitu SQLite-lisäosan kanssa. Ole hyvä ja tarkasta php.ini -tiedostosi tai käännä PHP uudestaan.';
$string['upgradingqtypeplugin'] = 'Päivitetään kysymys/tyyppi -moduuli';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Näet tämän sivun koska olet onnistuneesti asentanut ja käynnistänyt <strong>{$a->packname} {$a->packversion}</strong> paketin tietokoneellasi.
Onnittelut!';
$string['welcomep30'] = 'Tämä julkaisu <strong>{$a->installername}</strong> sisältää sovellukset ympäristön luomiseen, jossa <strong>Moodle</strong> toimii:';
$string['welcomep40'] = 'Tämä paketti sisältää myös <strong>Moodlen {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Kaikkia tämän paketin sovelluksia hallitsevat niihin liittyvät lisenssit. Koko <strong>{$a->installername}</strong> paketti on <a href="http://www.opensource.org/docs/definition_plain.html">avointa lähdekoodia</a> ja sitä jaellaan <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> lisenssin alla.';
$string['welcomep60'] = 'Seuraavat sivut opastavat sinua helposti seurattavien vaiheiden läpi <strong>Moodlen</strong> konfiguroinnissa koneellesi. Voit hyväksyä oletusasetukset tai vaihtoehtoisesti muuttaa niitä tarvitsemallasi tavalla.';
$string['welcomep70'] = 'Napsauta "Seuraava"-painiketta jatkaaksesi moodlen asennusta';
$string['wwwroot'] = 'Web-osoite';
$string['wwwrooterror'] = 'Web-osoite ei näyttäisi olevan voimassa- tämä Moodle asennus ei näyttäisi olevan siellä.';
