<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktiviteetit';
$string['addcategory'] = 'Lisää kategoria';
$string['addcategoryerror'] = 'Kategoriaa ei voitu lisätä';
$string['addexceptionerror'] = 'Virhe yritettäessä lisätä poikkeusta userid:gradeitem';
$string['addfeedback'] = 'Lisää palaute';
$string['addgradeletter'] = 'Lisää arvosana kirjaimena';
$string['addidnumbers'] = 'Lisää tunnisteet';
$string['additem'] = 'Lisää arviointikohde';
$string['addoutcome'] = 'Lisää oppimistavoite';
$string['addoutcomeitem'] = 'Lisää tavoitesarake';
$string['addscale'] = 'Lisää asteikko';
$string['aggregateextracreditmean'] = 'Arvosanan keskiarvo (lisäsaavutuksilla)';
$string['aggregatemax'] = 'Ylin arvosana';
$string['aggregatemean'] = 'Arvosanojen keskiarvo';
$string['aggregatemedian'] = 'Arvosanojen mediaani';
$string['aggregatemin'] = 'Alin arvosana';
$string['aggregatemode'] = 'Arvosanojen moodi';
$string['aggregateonlygraded'] = 'Kokoa yhteen vain täytetyt arvosanat';
$string['aggregateonlygraded_help'] = 'Tyhjä arvosana on arviointikirjasta puuttuva arvosana. Syynä voi olla esim. arvioimaton tehtäväpalautus tai vielä tekemätön tentti.

Tämä asetus määrittelee, käsitelläänkö puuttuvia arvosanoja arvosanakoosteessa minimiarvosanoina vai eikö niitä huomioida ollenkaan.';
$string['aggregateoutcomes'] = 'Sisällytä tulos kokonaispistemäärään';
$string['aggregateoutcomes_help'] = 'Tavoitesarakkeen sisällyttäminen kokonaispisrtemäärään ei välttämättä johda tavoiteltuun lopputulokseen, joten sen voi halutessaan jättää pois kokonaispistemäärän laskemisesta.';
$string['aggregatesonly'] = 'Vain yhteenveto';
$string['aggregatesubcats'] = 'Kokoa yhteen alakategoriat sisällytettynä';
$string['aggregatesubcats_help'] = 'Tämä asetus määrittelee otetaanko alakategorioiden arvosanoja mukaan arvosanakoosteeseen.';
$string['aggregatesum'] = 'Arvosanojen summa';
$string['aggregateweightedmean'] = 'Arvosanojen painotettu keskiarvo';
$string['aggregateweightedmean2'] = 'Arvosanojen yksinkertainen painotettu keskiarvo';
$string['aggregation'] = 'Yhteenveto';
$string['aggregationcoef'] = 'Kokonaispistemäärän kerroin';
$string['aggregationcoefextra'] = 'Lisäpisteet';
$string['aggregationcoefextra_help'] = 'Jos arvosanakooste on Arvosanojen summa tai Yksinkertainen painotettu keskiarvo ja lisäpisteet -valintalaatikko on valittuna, arvosanakohteiden ylintä arvosanaa ei lisätä kategorian ylimpään arvosanaan, jolloin on mahdollista saavuttaa ylin arvosana (tai arvosanat yli maksimin, jos sallittu ylläpitäjän toimesta) kategoriassa ilman että kaikissa arvosanakohteissa olisi ylintä arvosanaa.

Jos arvosanakooste on Arvosanojen keskiarvo (lisäpisteillä) ja lisäpisteiden painotus on asetettu suuremmaksi kuin nolla, lisäpiste on kerroin, jolla arvosana kerrotaan ennen sen lisäämistä kokonaismäärään keskiarvon laskemisen jälkeen.';
$string['aggregationcoefextrasum'] = 'Lisäpisteet';
$string['aggregationcoefextrasum_help'] = 'Jos lisäpisteet -valintalaatikko on valittuna, arvosanakohteiden ylintä arvosanaa ei lisätä kategorian ylimpään arvosanaan, jolloin on mahdollista saavuttaa ylin arvosana (tai arvosanat yli maksimin, jos sallittu ylläpitäjän toimesta) kategoriassa ilman että kaikissa arvosanakohteissa olisi ylintä arvosanaa.';
$string['aggregationcoefextraweight'] = 'Lisäpisteiden paino';
$string['aggregationcoefextraweight_help'] = 'Jos lisäpisteiden painotus on asetettu suuremmaksi kuin nolla, arvosana toimii lisäpisteenä yhteisarvosanaa koostettaessa. Numero on kerroin, jolla arvosana kerrotaan ennen sen lisäämistä kokonaismäärään keskiarvon laskemiseksi.';
$string['aggregationcoefweight'] = 'Kohteen painotus';
$string['aggregationcoefweight_help'] = 'Kohteen painoa käytetään kategoriakoosteessa ilmaisemaan kohteen tärkeyttä verrattaen muihin arvosanakohteisiin samassa kategoriassa.';
$string['aggregation_help'] = 'Koostaminen määrittää kuinka kategorian arvosanat on yhdistetty

* Arvosanojen keskiarvo - Kaikkien arvosanojen summa jaettuna niiden määrällä
* Arvosanojen mediaani - Keskimmäinen arvo kun arvosanat ovat kokojärjestyksessä
* Alin arvosana
* Ylin arvosana
* Arvosanojen moodi - Arvosana joka esiintyy useiten
* Arvosanojen summa - Kaikkien arvosanojen summa, jossa arvosana-asteikot jätetään pois';
$string['aggregationposition'] = 'Yhteenvedon paikka';
$string['aggregationposition_help'] = 'Tämä asetus määrittelee näytetäänkö kategorian ja kurssin yhteispistesarakkeet ensimmäisenä vai viimeisenä arvioinnit-raporteissa.';
$string['aggregationsvisible'] = 'Käytettävissä olevat koostetyypit';
$string['aggregationsvisiblehelp'] = 'Valitse kaikki koostetyypit, joiden pitäisi olla käytettävissä. Pidä alhaalla Ctrl-näppäintä valitaksesi useita kohteita.';
$string['allgrades'] = 'Kaikki arvosanat kategoriassa';
$string['allstudents'] = 'Kaikki opiskelijat';
$string['allusers'] = 'Kaikki käyttäjät';
$string['autosort'] = 'Automaattinen järjestys';
$string['availableidnumbers'] = 'Saatavilla olevat id numerot';
$string['average'] = 'Keskiarvo';
$string['averagesdecimalpoints'] = 'Desimaaleja sarakkeen keskiarvoissa';
$string['averagesdecimalpoints_help'] = 'Tämä asetus määrittelee käytetäänkö jokaiselle keskiarvolle tässä määriteltyä desimaalien määrää vai käytetäänkö (peri) kategorian tai arvosanakohteen desimaalimäärän asetusta.';
$string['averagesdisplaytype'] = 'Sarakkeen keskiarvojen näyttötyyppi';
$string['averagesdisplaytype_help'] = 'Tämä asetus määrittelee näytetäänkö keskiarvo oikeana arvosanana, prosenttina tai kirjaimena, vai käytetäänkö (peri) kategorian tai arvosanakohteen näyttötyyppiä.';
$string['backupwithoutgradebook'] = 'Varmuuskopioon ei oteta mukaan arviointikirjan asetuksia';
$string['badgrade'] = 'Virhe annetussa arvosanassa';
$string['badlyformattedscale'] = 'Anna lista arvoista pilkuilla erotettuna (vähintään kaksi arvoa vaaditaan).';
$string['baduser'] = 'Virhe annetussa käyttäjässä';
$string['bonuspoints'] = 'Lisäpisteet';
$string['bulkcheckboxes'] = 'Täydennä asetusnapit';
$string['calculatedgrade'] = 'Laskettu arvosana';
$string['calculation'] = 'Laskentatapa';
$string['calculationadd'] = 'Lisää laskentatapa';
$string['calculationedit'] = 'Muokkaa laskentatapaa';
$string['calculation_help'] = 'Arvosanan laskenta on kaava, jota käytetään arvosanojen määrittämiseen. Kaavan tulisi alkaa yhtäsuuri kuin (=) -merkillä ja se voi käyttää yleisiä matemaattisia toimintoja kuten max, min, ja summa. Haluttaessa voidaan muita arvosanakohteita sisällyttää laskentaan kirjoittamalla ID-numerot kaksiin hakasulkeisiin.';
$string['calculationsaved'] = 'Laskentatapa tallennettiin';
$string['calculationview'] = 'Näytä laskentatapa';
$string['cannotaccessgroup'] = 'Valitun ryhmän arvosanoja ei voi näyttää.';
$string['categories'] = 'Kategoriat';
$string['categoriesanditems'] = 'Kategoriat ja kohteet';
$string['categoriesedit'] = 'Muokkaa kategoriat ja kohteet';
$string['category'] = 'Kategoria';
$string['categoryedit'] = 'Muokkaa kategoriaa';
$string['categoryname'] = 'Kategorian nimi';
$string['categorytotal'] = 'Kategorian yhteenveto';
$string['categorytotalfull'] = '{$a->category} yhteensä';
$string['categorytotalname'] = 'Kategorian yhteissumman nimi';
$string['changedefaults'] = 'Muuta oletuksia';
$string['changereportdefaults'] = 'Muuta raportin oletusarvoja';
$string['chooseaction'] = 'Valitse toiminta ...';
$string['choosecategory'] = 'Valitse kategoria';
$string['combo'] = 'Välilehdet ja pudotusvalikko';
$string['compact'] = 'Tiivistetty';
$string['componentcontrolsvisibility'] = 'Arvosanan piilotusasetukset on määritelty aktiviteetin asetuksissa.';
$string['contract'] = 'Supista kategoria';
$string['controls'] = 'Toiminnot';
$string['courseavg'] = 'Kurssin keskiarvo';
$string['coursegradecategory'] = 'Kurssin arviointikategoria';
$string['coursegradedisplaytype'] = 'Kurssin arviointinäkymän tyyppi';
$string['coursegradedisplayupdated'] = 'Kurssin arviointinäkymän tyyppiä on päivitetty.';
$string['coursegradesettings'] = 'Kurssin arvosana-asetukset';
$string['coursename'] = 'Kurssin nimi';
$string['coursescales'] = 'Kurssin asteikot';
$string['coursesettings'] = 'Kurssin asetukset';
$string['coursesettingsexplanation'] = 'Kurssin asetuksissa määritellään, miltä arviointikirja näyttää kurssin osallistujille.';
$string['coursetotal'] = 'Kurssiyhteenveto';
$string['createcategory'] = 'Tee kategoria';
$string['createcategoryerror'] = 'Uuden kategorian luonti ei onnistunut';
$string['creatinggradebooksettings'] = 'Luodaan arviointikirjan asetukset';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Nykyinen yhteenvetotapa';
$string['curveto'] = 'Pyöristä';
$string['decimalpoints'] = 'Desimaaleja näytetään';
$string['decimalpoints_help'] = 'Tämä asetus määrittelee näytettävien desimaalien määrän jokaiselle arvosanalle. Tällä ei ole vaikutusta arvosanojen laskentaan, mikä suoritetaan viiden desimaalin tarkkuudella.';
$string['default'] = 'Oletus';
$string['defaultprev'] = 'Oletus ({$a})';
$string['deletecategory'] = 'Poista kategoria';
$string['disablegradehistory'] = 'Poista arvosanojen historia käytöstä';
$string['disablegradehistory_help'] = 'Kytke pois arvosanoihin liittyvien taulukoiden muutosten historian jäljitys.';
$string['displaylettergrade'] = 'Näytä arvosanamerkinnät';
$string['displaypercent'] = 'Näytä prosentit';
$string['displaypoints'] = 'Näytä pisteet';
$string['displayweighted'] = 'Näytä painotetut arvosanat';
$string['dropdown'] = 'Pudotusvalikko';
$string['droplow'] = 'Pudota alin';
$string['droplow_help'] = 'Tämä asetus mahdollistaa määritellyn määrän alimpia arvosanoja jätettäväksi pois arvosanakoosteesta.';
$string['dropped'] = 'Pudotettu';
$string['dropxlowest'] = 'Pudota X alinta';
$string['dropxlowestwarning'] = 'Huomioi: Jos käytät ´Pudota X alinta´-asetusta, arviointi olettaa, että kaikkien pisteiden arvo on sama. Jos pisteiden arvo vaihtelee, voivat tulokset olla vääriä';
$string['duplicatescale'] = 'Kopioi asteikko';
$string['edit'] = 'Muokkaa';
$string['editcalculation'] = 'Muokkaa laskentatapaa';
$string['editcalculationverbose'] = 'Muokkaa laskutoimituksia kohteelle {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Muokkaa palautetta';
$string['editgrade'] = 'Muokkaa arvosanaa';
$string['editgradeletters'] = 'Muokkaa arvosanakirjaimia';
$string['editoutcome'] = 'Muokkaa tavoitetta';
$string['editoutcomes'] = 'Muokkaa tavoitteita';
$string['editscale'] = 'Muokkaa asteikkoa';
$string['edittree'] = 'Kategoriat ja kohteet';
$string['editverbose'] = 'Muokkaa {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Käytä AJAXia';
$string['enableajax_help'] = 'Lisää kerroksen AJAX toimivuutta arvosanaraporttiin, yksinkertaistaen ja nopeuttaen yleisiä toimia. Riippuen onko käyttäjä kytkenyt Javascriptit päälle selaimessaan.';
$string['enableoutcomes'] = 'Käytä tavoitteita';
$string['enableoutcomes_help'] = 'Lopputuloksien tuki tarkoittaa että voimme arvottaa asioita käyttäen yhtä tai useampaa asteikkoa, jotka ovat liitetty lopputulos lauseeseen.';
$string['encoding'] = 'Merkistö';
$string['errorcalculationbroken'] = 'Todennäköisesti kehäviittaus tai rikkinäinen laskukaava';
$string['errorcalculationnoequal'] = 'Kaavan pitää alkaa yhtäsuuruusmerkillä (=1+2)';
$string['errorcalculationunknown'] = 'Tuntematon kaava';
$string['errorgradevaluenonnumeric'] = 'Saatiin ei-numeerinen arvo matalalle tai korkealle arvosanalle seuraavalle';
$string['errornocalculationallowed'] = 'Laskelmat eivät ole sallittuja tälle yksikölle.';
$string['errornocategorisedid'] = 'Ei pystynyt saamaan kategoriatonta tunnusta!';
$string['errornocourse'] = 'Ei voitu noutaa kurssitietoja';
$string['errorreprintheadersnonnumeric'] = 'Vastaanotettujen ei-numeraalisien arvo otsakkeiden päivitystä varten.';
$string['errorsavegrade'] = 'Arvosanaa ei voitu tallentaa.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Virhe päivitettäessä arvosanakategoria ID:n {$a->id} "Tee kooste vain ei-tyhjistä arvosanoista" -asetusta';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Virhe päivitettäessä arvosanakategoria ID:n {$a->id} "Sisällytä tulokset koosteeseen" -asetusta';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Virhe päivitettäessä arvosanakategoria ID:n {$a->id} "Tee kooste sisällyttäen alakategoriat" -asetusta';
$string['errorupdatinggradecategoryaggregation'] = 'Virhe päivitettäessä arvosanakategoria ID:n {$a->id} koostetyyppiä';
$string['errorupdatinggradeitemaggregationcoef'] = 'Virhe päivitettäessä arvosanakohde ID:n {$a->id} koosteen kerroin (painotus tai lisäpisteet)';
$string['excluded'] = 'Jätetty pois';
$string['excluded_help'] = 'Jos valittu, arvosanaa ei oteta mukaan mihinkään koosteeseen.';
$string['expand'] = 'Laajenna kategoria';
$string['export'] = 'Vie';
$string['exportalloutcomes'] = 'Viet kaikki tavoitteet';
$string['exportfeedback'] = 'Sisällytä tiedostoon sanallinen palaute';
$string['exportonlyactive'] = 'Vaadi aktiivista ilmoittautumista';
$string['exportonlyactive_help'] = 'Sisällytä vain ne opiskelijat, joiden rekisteröityminen on voimassa.';
$string['exportplugins'] = 'Vie laajennukset';
$string['exportsettings'] = 'Vie asetukset';
$string['exportto'] = 'Vie muotoon';
$string['extracreditvalue'] = 'Lisäpisteitä opiskelijalle {$a}';
$string['extracreditwarning'] = 'Huomioi: Kaikkien kohteitten muuttaminen ylimääräisiksi suorituksiksi jossain kategoriassa käytännössä poistaa ne arvosanan laskennasta, koska kategorian kokonaispistemääräksi tulee nolla.';
$string['feedback'] = 'Palaute';
$string['feedbackadd'] = 'Anna palautetta';
$string['feedbackedit'] = 'Muokkaa palautetta';
$string['feedback_help'] = 'Tämä kenttä mahdollistaa kommentit arvosanasta.';
$string['feedbacksaved'] = 'Palaute tallennettu';
$string['feedbackview'] = 'Näytä palaute';
$string['finalgrade'] = 'Lopullinen arviointi';
$string['finalgrade_help'] = 'Jos \'ohitettu\' -valintaruutu on valittu, arvosana voidaan lisätä tai muuttaa.';
$string['fixedstudents'] = 'Staattinen opiskelijat-sarake';
$string['fixedstudents_help'] = 'Mahdollistaa arvosanojen vierittämisen vaakatasossa ilman että opiskelijat-sarake häviää.';
$string['forceoff'] = 'Pakotus: pois';
$string['forceon'] = 'Pakotus: päällä';
$string['forelementtypes'] = 'valituille {$a}';
$string['forstudents'] = 'Opiskelijoille';
$string['full'] = 'Täydellinen';
$string['fullmode'] = 'Täydellinen näkymä';
$string['fullview'] = 'Täydellinen näkymä';
$string['generalsettings'] = 'Yleiset asetukset';
$string['grade'] = 'Arvosana';
$string['gradeadministration'] = 'Arvosanojen hallinta';
$string['gradeanalysis'] = 'Arvosanojen analyysi';
$string['gradebook'] = 'Arviointikirja';
$string['gradebookhiddenerror'] = 'Arviointikirja ei näytä mitään tietoja opiskelijoille';
$string['gradebookhistories'] = 'Arvosanojen historia';
$string['gradeboundary'] = 'Kirjain arvosanan raja';
$string['gradeboundary_help'] = 'Tämä asetus määrittelee prosentuaalisen alarajan, jonka ylimeneville arvosanoille annetaan arvosanakirjain.';
$string['gradecategories'] = 'Arvosanojen kategoriat';
$string['gradecategory'] = 'Arvosanojen kategoria';
$string['gradecategoryonmodform'] = 'Arvosanojen kategoria';
$string['gradecategoryonmodform_help'] = 'Tämä asetus määrittää kategorian, johon aktiviteetin arvosanat sijoitetaan Arvioinneissa.';
$string['gradecategorysettings'] = 'Arvosanakategorian asetukset';
$string['gradedisplay'] = 'Arvioinnin näyttö';
$string['gradedisplaytype'] = 'Arvioinnin näyttö';
$string['gradedisplaytype_help'] = 'Tämä asetus määrittää kuinka arvosanat näytetään arvioijan ja käyttäjän raporteissa.

* Todellinen - Todelliset arvosanat
* Prosentuaalinen
* Kirjain - Kirjaimia tai sanoja käytetään ilmaisemaan arvosanarajoja';
$string['gradedon'] = 'Arvosteltu: {$a}';
$string['gradeexport'] = 'Arvosanojen vienti';
$string['gradeexportdecimalpoints'] = 'Desimaalien määrä';
$string['gradeexportdecimalpoints_desc'] = 'Näytettävien desimaalien määrä tehtäessä vientiä tiedostoon. Tämä asetus voidaan muuttaa vientiä tehtäessä.';
$string['gradeexportdisplaytype'] = 'Näytä arvosanat';
$string['gradeexportdisplaytype_desc'] = 'Arvosanat voidaan näyttää arvosanoina, prosentteina(referrenssinä minimi- ja maksimimäärät) tai kirjaimina (A, B, C..) ulostuomisen aikana. Tämä voidaan ylittää ulsotuomisen aikana.';
$string['gradeexportuserprofilefields'] = 'Arvosanojen viennissä käytettävät käyttäjätietokentät';
$string['gradeexportuserprofilefields_desc'] = 'Sisällytä nämä käyttäjätietokentät pilkuilla erotettuina arvosanojen vientitiedostoon';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Arvioinnin ohje';
$string['gradehistorylifetime'] = 'Arvosanojen historian ikä';
$string['gradehistorylifetime_help'] = 'Tämä määrittelee arvosanojen taulukoiden muutoksien historian ajan. On suositeltavaa pitää se mahdollisemman pitkänä. Jos tulee suoritusongelmia tai sinulla on rajallinen tietokannan tila, koeta alhaisempaa arvoa.';
$string['gradeimport'] = 'Arvosanojen tuonti';
$string['gradeitem'] = 'Arviointikohde';
$string['gradeitemaddusers'] = 'Jätä pois arvioinnista';
$string['gradeitemadvanced'] = 'Arvosananimikkeen lisäominaisuudet';
$string['gradeitemadvanced_help'] = 'Valitse kaikki elementit, joiden haluat olevan edistyneitä, kun muokkaat arvosanoja.';
$string['gradeitemislocked'] = 'Tämä aktiviteetti on lukittu arviointikirjassa. Muutoksia ei lisätä arvosanasarakkeeseen ennen kuin se on avattu.';
$string['gradeitemlocked'] = 'Arviointi lukittu';
$string['gradeitemmembersselected'] = 'Jätetään pois arvioinnista';
$string['gradeitemnonmembers'] = 'Mukana arvioinnissa';
$string['gradeitemremovemembers'] = 'Ota mukaan arviointiin';
$string['gradeitems'] = 'Arviointikohteet';
$string['gradeitemsettings'] = 'Arviointikohteiden asetukset';
$string['gradeitemsinc'] = 'Sisällytettävät arviointikohteet';
$string['gradeletter'] = 'Arvosana kirjaimena';
$string['gradeletter_help'] = 'Arvosanakirjaimet ovat kirjaimia, A, B, C, ..., tai sanoja, esimerkiksi Kiitettävä, Hyvä, Välttävä, ..., joita käytetään kuvaamaan arvosanaa.';
$string['gradeletternote'] = 'Poistaaksesi arvosanakirjaimen sinun tarvitsee vain  tyhjentää jokin sen arvosanakirjaimen kolmesta tekstialueesta ja napsauttaa lähetyspainiketta.';
$string['gradeletters'] = 'Kirjainarvosanat';
$string['gradelocked'] = 'Arvosana lukittu';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Arvosana-asteikon yläraja';
$string['grademax_help'] = 'Numeerisia arvosanoja käytettäessä arvosana-asteikon yläraja voidaan määritellä. Tämä asetus määrittää arvosana-asteikon ylimmän mahdollisen arvosanan. Arvosana-asteikon yläraja aktiviteettipohjaiselle arvosanalle määritetään aktiviteetin asetussivulla.';
$string['grademin'] = 'Arvosana-asteikon alaraja';
$string['grademin_help'] = 'Tämä asetus määrittää arvosana-asteikon alarajan eli alimman mahdollisen arvosanan käytettäessä numeerisia arvosanoja.';
$string['gradeoutcomeitem'] = 'Arvosanan tavoitenimike';
$string['gradeoutcomes'] = 'Tavoitteet';
$string['gradeoutcomescourses'] = 'Kurssin tavoitteet';
$string['gradepass'] = 'Hyväksymisraja';
$string['gradepass_help'] = 'Tämä asetus määrittää läpäisemiseen vaadittavan minimiarvosanan. Arvoa käytetään aktiviteettien ja kurssisuoritusten seurannassa sekä Arvioinneissa, jossa läpäisyyn riittäneet arvosanat ovat vihreitä ja hylätyt arvosanat punaisia.';
$string['gradepreferences'] = 'Arvosanan asetukset';
$string['gradepreferenceshelp'] = 'Ohje arvosanojen asetuksiin';
$string['gradepublishing'] = 'Ota julkaiseminen käyttöön';
$string['gradepublishing_help'] = 'Kun otat julkaisemisen käyttöön tuoduissa ja viedyissä arvosanoissa: Silloin vietyihin arvosanoihin pääsee erillisellä verkko-osoitteella ilman Moodleen kirjautumista. Samoin arvosanat voidaan tuoda menemällä ulkopuoliselle verkkosivulle, tarkoittaen, että Moodle -sivustoon voi tuoda toisen sivuston julkaisemia arvosanoja. Oletuksena vain ylläpitäjät voivat käyttää tätä ominaisuutta. Neuvokaa käyttäjiä ennen kuin lisäätte näitä kykyjä muille rooleille!';
$string['gradereport'] = 'Arvosanaraportti';
$string['graderreport'] = 'Arvioijan raportti';
$string['grades'] = 'Arvioinnit';
$string['gradesforuser'] = 'Arvosanat käyttäjälle {$a->user}';
$string['gradesonly'] = 'Vain arvioinnit';
$string['gradessettings'] = 'Arviointien asetukset';
$string['gradetype'] = 'Arviointityyppi';
$string['gradetype_help'] = 'Arvosanatyyppejä on neljä erilaista:

* Ei mitään - Arviointi ei ole mahdollista
* Arvo - Numeerinen arvo maksimilla ja minimillä
* Asteikko - Vaihtoehto listasta
* Teksti - Vain palaute

Vain Arvo- ja Asteikko-tyyppisistä arvosanoista voidaan tehdä kooste. Arvosanatyyppi aktiviteettipohjaiselle arvosanalle määritellään aktiviteetin asetussivulla.';
$string['gradeview'] = 'Näytä arvosana';
$string['gradeweighthelp'] = 'Ohje arvosanan painotukseen';
$string['groupavg'] = 'Ryhmän keskiarvo';
$string['hidden'] = 'Piilotettu';
$string['hiddenasdate'] = 'Näytä piilotettujen arvosanojen päivämäärä';
$string['hiddenasdate_help'] = 'Jos käyttäjä ei pysty näkemään piiloitettuja arvosanoja, näytä alistamisen päivämäärä, kuin "-".';
$string['hidden_help'] = 'Jos valittu, arvosanat piilotetaan opiskelijoilta. Haluttaessa voidaan asettaa päivämäärä, jonka jälkeen arvosanat näytetään.';
$string['hiddenuntil'] = 'Piilossa kunnes';
$string['hiddenuntildate'] = 'Piilossa kunnes: {$a}';
$string['hideadvanced'] = 'Piilota lisäominaisuudet';
$string['hideaverages'] = 'Piilota keskiarvot';
$string['hidecalculations'] = 'Piilota laskut';
$string['hidecategory'] = 'Piilotettu';
$string['hideeyecons'] = 'Piilota näytä/piilota-kuvakkeet';
$string['hidefeedback'] = 'Piilota palaute';
$string['hideforcedsettings'] = 'Piilota pakotetut asetukset';
$string['hideforcedsettings_help'] = 'Älä näytä pakotettuja asetuksia arviointikäyttöliittymässä.';
$string['hidegroups'] = 'Piilota ryhmät';
$string['hidelocks'] = 'Piilota lukot';
$string['hidenooutcomes'] = 'Näytä tavoitteet';
$string['hidequickfeedback'] = 'Piilota pikapalaute';
$string['hideranges'] = 'Piilota vaihteluvälit';
$string['hidetotalifhiddenitems'] = 'Piilota yhteispisteet jos ne sisältävät piilotettuja kohteita';
$string['hidetotalifhiddenitems_help'] = 'Tämä asetus määrittelee, näytetäänkö piilotettuja kohteita sisältävät loppuarvosanat opiskelijoille vai korvataanko ne väliviivalla (-). Jos näytetään, voidaan loppuarvosana laskea joko pois jättäen tai sisällyttäen piilotetut kohteet. Jos piilotetut kohteet jätetään pois, loppuarvosana on eri kuin se, joka näkyy opettajalle arviointiraportissa, koska opettaja näkee aina yhteissummat kaikista näkyvistä sekä piilotetuista kohteista. Jos piilotetut kohteet on sisällytetty, opiskelijat saattavat pystyä laskemaan piilotetut kohteet.';
$string['hidetotalshowexhiddenitems'] = 'Näytä yhteispisteet ilman piilotettuja kohteita';
$string['hidetotalshowinchiddenitems'] = 'Näytä yhteispisteet mukaanlukien piilotetut kohteet';
$string['hideverbose'] = 'Piilota {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Lajittele nousevasti korkean arvosanan mukaan';
$string['highgradedescending'] = 'Lajittele laskevasti korkean arvosanan mukaan';
$string['highgradeletter'] = 'Yläraja';
$string['identifier'] = 'Tunnista käyttäjä';
$string['idnumbers'] = 'Tunnisteet';
$string['import'] = 'Tuo';
$string['importcsv'] = 'Tuo CSV';
$string['importcustom'] = 'Tuo kustomoituna lopputuloksena (vain tämä kurssi)';
$string['importerror'] = 'Virhe! Tätä skriptiä ei kutsuttu oikeille parametreillä.';
$string['importfailed'] = 'Tuonti epäonnistui';
$string['importfeedback'] = 'Tuonnin palaute';
$string['importfile'] = 'Tuo tiedosto';
$string['importfilemissing'] = 'Tiedoston lähetys ei onnistunut. Palaa takaisin lomakkeeseen ja varmista, että lähetit oikean tiedoston.';
$string['importfrom'] = 'Tuo muodossa';
$string['importoutcomenofile'] = 'Tuotu tiedosto on tyhjä tai korruptoitunut. Ole hyvä ja varmista tämä tiedosto. Ongelma löytyi rivillä {$a}; tämän aloitti datarivit joilla ei ole yhtä monta saraketta kuin ensimmäisellä rivillä (otsakerivi) tai tuodulla tiedostolla ei ole odotettua otsakeriviä. Katso esimerkkitiedostoa, jossa on oikeellinen otsake.';
$string['importoutcomes'] = 'Tuo tavoitteet';
$string['importoutcomes_help'] = 'Tulokset voidaan tuoda csv-tiedostosta sekä viedä csv-tiedostoon.';
$string['importoutcomesuccess'] = 'Tuotu lopputulos "{$a->name}" ID:lle #{$a->id}';
$string['importplugins'] = 'Tuo laajennukset';
$string['importpreview'] = 'Tuo esikatselu';
$string['importsettings'] = 'Tuo asetukset';
$string['importskippednomanagescale'] = 'Sinulla ei ole oikeuksia lisätä uutta asteikkoa, joten tavoitetta "{$a}" ei käsitelty, koska se vaatii uuden asteikon luonnin.';
$string['importskippedoutcome'] = 'Tavoite nimellä "{$a}" on jo olemassa tässä kontekstissa. Tiedostosta luettua tavoitetta ei tuotu.';
$string['importstandard'] = 'Tuo standarditavoitteina.';
$string['importsuccess'] = 'Arvosanan tuonnin onnistuminen';
$string['importxml'] = 'Tuo XML';
$string['includescalesinaggregation'] = 'Sisällytä asteikot yhteenlaskussa';
$string['includescalesinaggregation_help'] = 'Voit vaihtaa suhteita jotka ovat liitetty numeroina kaikkiin kokonaispisteisiin kaikkien kurssien kaikissa arvosanakirjoissa. VAROITUS: tämän asetuksen vaihtaminen pakottaa kaikki kokonaispisteet uudelleen laskettavaksi.';
$string['incorrectcourseid'] = 'Kurssin ID oli väärä';
$string['incorrectcustomscale'] = '(Asteikko ei ole toimiva, sitä pitää muuttaa.)';
$string['incorrectminmax'] = 'Minimiarvon pitää olla pienempi kuin maksimiarvo';
$string['inherit'] = 'Peri';
$string['intersectioninfo'] = 'Opiskelija/Arvosana';
$string['item'] = 'Kohde';
$string['iteminfo'] = 'Kohteen tiedot';
$string['iteminfo_help'] = 'Tämä asetus tarjoaa paikan, johon voidaan kirjoittaa tietoa kohteesta. Tietoa ei näytetä missään muualla.';
$string['itemname'] = 'Kohteen nimi';
$string['itemnamehelp'] = 'Tämän kohteen nimi';
$string['items'] = 'Kohteet';
$string['itemsedit'] = 'Muokkaa arvosanakohdetta';
$string['keephigh'] = 'Säilytä korkeimmat';
$string['keephigh_help'] = 'Jos päällä, tämä optio pitää vain X korkeimmat arvosanat, X on valittu arvo tälle vaihtoehdolle.';
$string['keymanager'] = 'Avainmanageri';
$string['lessthanmin'] = 'Lisätty arvosana {$a->itemname} :sta {$a->username} :lle on pienempi kuin sallittu minimi';
$string['letter'] = 'Kirjain';
$string['lettergrade'] = 'Kirjainarvosana';
$string['lettergradenonnumber'] = 'Matala ja/tai korkea arvosana olivat ei-numeerisia seuraavalle';
$string['letterpercentage'] = 'Kirjain (prosentti)';
$string['letterreal'] = 'Kirjain (todellinen)';
$string['letters'] = 'Kirjaimet';
$string['linkedactivity'] = 'Linkitetty toiminta';
$string['linkedactivity_help'] = 'Määrittää aktiviteetin, johon tämä tavoitesarake on linkitetty. Tätä käytetään opiskelijan suoriutumisen arviointiin sellaisten kriteerien kautta, joita aktiviteetin varsinainen arvosana ei huomioi.';
$string['linktoactivity'] = 'Linkki aktiviteettiin {$a->name}';
$string['lock'] = 'Lukitse';
$string['locked'] = 'Lukittu';
$string['locked_help'] = 'Jos valittu, arvosanaan liittyvä aktiviteetti ei voi enää päivittää sitä automaattisesti.';
$string['locktime'] = 'Lukitaan';
$string['locktimedate'] = 'Lukitaan: {$a}';
$string['lockverbose'] = 'Lukitse {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Matalin';
$string['lowgradeletter'] = 'Alaraja';
$string['manualitem'] = 'Käsikirjanimike';
$string['mapfrom'] = 'Sarake tiedostossa';
$string['mappings'] = 'Arvosananimikkeet';
$string['mapto'] = 'Henkilötieto Moodlessa';
$string['max'] = 'Korkein';
$string['maxgrade'] = 'Korkein arvosana';
$string['meanall'] = 'Kaikki arvosanat';
$string['meangraded'] = 'Muut kuin tyhjät arvosanat';
$string['meanselection'] = 'Arvosanat sarakkeiden keskiarvoissa';
$string['meanselection_help'] = 'Mitkä solut, joissa ei ole arvosanaa pitäisi lisätä kun lasketaan keskiarvoa jokaiselle palstalle.';
$string['median'] = 'Mediaani';
$string['min'] = 'Matalin';
$string['missingscale'] = 'Asteikko pitää olla valittuna';
$string['mode'] = 'Tila';
$string['morethanmax'] = 'Arvosana joa annettiin {$a->itemname} :sta {$a->username} :lle on suurempi kuin sallittu maksimi.';
$string['moveselectedto'] = 'Siirrä valitut';
$string['movingelement'] = 'Siirretään {$a}';
$string['multfactor'] = 'Kerroin';
$string['multfactor_help'] = 'Kertoja on kerroin, jolla kaikki tämän arvosanakohteen arvosanat kerrotaan maksimiarvosanan maksimiarvon kanssa. Esimerkiksi jos kertoja on 2 ja maksimiarvosana on 100, silloin kaikki alle 50 arvosanat kerrotaan kahdella ja kaikki arvosanat yli 50:n muutetaan sadaksi.';
$string['multfactorvalue'] = 'Kerroin opiskelijalle {$a}';
$string['mypreferences'] = 'Omat asetukset';
$string['myreportpreferences'] = 'Omat raportin asetukset';
$string['navmethod'] = 'Navigointitapa';
$string['neverdeletehistory'] = 'Älä koskaan poista historiaa';
$string['newcategory'] = 'Uusi kategoria';
$string['newitem'] = 'Uusi arviointikohde';
$string['newoutcomeitem'] = 'Uusi tavoitesarake';
$string['no'] = 'Ei';
$string['nocategories'] = 'Arvosanakategorioita ei voitu lisätä tai löytää tätä kurssia varten';
$string['nocategoryname'] = 'Kategorian nimeä ei annettu';
$string['nocategoryview'] = 'Ei kategorioita katsottavaksi';
$string['nocourses'] = 'Kursseja ei ole vielä olemassa';
$string['noforce'] = 'Älä pakota';
$string['nogradeletters'] = 'Arvosanamerkintöjä ei asetettu';
$string['nogradesreturned'] = 'Ei tuotu arvosanoja';
$string['noidnumber'] = 'Ei tunnistetta';
$string['nolettergrade'] = 'Ei arvosanamerkintää seuraavalle';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Saatiin ei-numeerinen arvo seuraavalle';
$string['nonunlockableverbose'] = 'Arvosanan lukitusta ei voida poistaa ennen kuin kohteen {$a->itemname} lukitus on poistettu.';
$string['nonweightedpct'] = 'Painottamaton %';
$string['nooutcome'] = 'Ei tavoitetta';
$string['nooutcomes'] = 'Tavoitesarakkeet täytyy linkittää kurssin tavoitteisiin, mutta tälle kurssille ei ole määritelty tavoitteita. Haluatko lisätä kurssille tavoitteen?';
$string['nopublish'] = 'Älä julkaise';
$string['norolesdefined'] = 'Ei määriteltyjä rooleja kohteessa Sivuston hallinta > Arvioinnit > Yleiset asetukset > Arvioitavat roolit';
$string['noscales'] = 'Tavoitteet pitää linkittää asteikkoon, mutta niitä ei ole määritelty. Haluatko lisätä asteikon?';
$string['noselectedcategories'] = 'Ei valittua kategoriaa.';
$string['noselecteditems'] = 'Ei valittua kohdetta.';
$string['notteachererror'] = 'Vain opettajat voivat käyttää tätä toimintoa';
$string['nousersloaded'] = 'Ei ladattuja käyttäjiä';
$string['numberofgrades'] = 'Arvosanojen lukumäärä';
$string['onascaleof'] = 'asteikolla {$a->grademin} - {$a->grademax}';
$string['operations'] = 'Operaatiot';
$string['options'] = 'Optiot';
$string['outcome'] = 'Tavoite';
$string['outcomeassigntocourse'] = 'Lisää kurssille uusi tavoite';
$string['outcomecategory'] = 'Luo tavoitteet kategoriaan';
$string['outcomecategorynew'] = 'Uusi kategoria';
$string['outcomeconfirmdelete'] = 'Haluatko varmasti poistaa tavoitteen "{$a}"?';
$string['outcomecreate'] = 'Lisää uusi tavoite';
$string['outcomedelete'] = 'Poista tavoite';
$string['outcomefullname'] = 'Koko nimi';
$string['outcome_help'] = 'Määrittelee tavoitteen, jota tämä arvosana vastaa arviointikirjassa.';
$string['outcomeitem'] = 'Tavoitesarake';
$string['outcomeitemsedit'] = 'Muokkaa tavoitesaraketta';
$string['outcomereport'] = 'Tavoitteiden raportti';
$string['outcomes'] = 'Tavoitteet';
$string['outcomescourse'] = 'Kurssilla käytetyt tavoitteet';
$string['outcomescoursecustom'] = 'Kustomoi käytettyjä';
$string['outcomescoursenotused'] = 'Käyttämätön standardi';
$string['outcomescourseused'] = 'Käytetty standardi';
$string['outcomescustom'] = 'Mukautetut tavoitteet';
$string['outcomeshortname'] = 'Lyhenne';
$string['outcomesstandard'] = 'Vakiotavoitteet';
$string['outcomesstandardavailable'] = 'Saatavilla olevat vakiotavoitteet';
$string['outcomestandard'] = 'Vakiotavoite';
$string['outcomestandard_help'] = 'Vakiotavoite on käytettävissä koko sivustolla kaikilla kursseilla.';
$string['overallaverage'] = 'Kaikkien keskiarvo';
$string['overridden'] = 'Ylitetty';
$string['overridden_help'] = 'Jos valittu, arvosanaa ei voida enää muuttaa arvosanaan liittyvästä aktiviteetista. Kun arvosanaa muokataan arviointiraportissa, \'ohitettu\' -valintalaatikko on valittuna automaattisesti. Valinta voidaan kuitenkin poistaa jolloin arvosanan muuttaminen aktiviteetista on mahdollista.';
$string['overriddennotice'] = 'Sinun arvosanasi tältä aktiviteetilta käsiteltiin manuaalisesti.';
$string['overridesitedefaultgradedisplaytype'] = 'Ylitä sivuston oletukset';
$string['overridesitedefaultgradedisplaytype_help'] = 'Jos valittu, kurssille voidaan asettaa arvosanakirjaimia ja rajoja sivuston oletusten käyttämisen sijaan.';
$string['parentcategory'] = 'Yläkategoria';
$string['pctoftotalgrade'] = 'prosenttia kokonaisarvosanasta';
$string['percent'] = 'Prosentti';
$string['percentage'] = 'Prosenttia';
$string['percentageletter'] = 'Prosenttia (kirjain)';
$string['percentagereal'] = 'Prosenttia (todellinen)';
$string['percentascending'] = 'Lajittele nousevasti prosentin mukaan';
$string['percentdescending'] = 'Lajittele laskevasti prosentin mukaan';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Hyvitys';
$string['plusfactor_help'] = 'Hyvitys on luku joka lisätään jokaiseen tämän arvosanakohteen arvosanaan kertojan käyttämisen jälkeen.';
$string['points'] = 'pisteet';
$string['pointsascending'] = 'Lajittele nousevasti pisteiden mukaan';
$string['pointsdescending'] = 'Lajittele laskevasti pisteiden mukaan';
$string['positionfirst'] = 'Ensimmäinen';
$string['positionlast'] = 'Viimeinen';
$string['preferences'] = 'Asetukset';
$string['prefgeneral'] = 'Yleiset';
$string['prefletters'] = 'Arvosanamerkit ja rajat';
$string['prefrows'] = 'Erityisrivit';
$string['prefshow'] = 'Näytä/piilota valinnat';
$string['previewrows'] = 'Esikatsele rivejä';
$string['profilereport'] = 'Käyttäjäprofiili raportti';
$string['profilereport_help'] = 'Käyttäjän profiilissa käytetty arvosanaraportti.';
$string['publishing'] = 'Julkaistaan';
$string['quickfeedback'] = 'Pikapalaute';
$string['quickgrading'] = 'Pika-arviointi';
$string['quickgrading_help'] = 'Jos sallittu, kun muokkaus laitetaan päälle, ilmestyy jokaiselle arvosanalle tekstikenttä, jotka mahdollistavat useiden arvosanojen muokkaamisen yhtä aikaa. Muutokset tallennetaan ja korostetaan kun päivitä -painiketta klikataan.

Huomaa että kun arvosanaa muokataan arviontiraportissa, asetetaan ohitettu merkintä, joka tarkoittaa että arvosanaa ei voida enää muuttaa arvosanaan liittyvässä aktiviteetissa.';
$string['range'] = 'Vaihteluväli';
$string['rangedecimals'] = 'Vaihteluvälin desimaalit';
$string['rangedecimals_help'] = 'Vaihteluvälille näytettävien desimaalien määrä.';
$string['rangesdecimalpoints'] = 'Desimaaleja vaihteluväleissä';
$string['rangesdecimalpoints_help'] = 'Määrittää desimaalien määrän jokaiselle asteikolle. Tämä asetus voidaan ylittää jokaisella asteittamisella.';
$string['rangesdisplaytype'] = 'Vaihteluvälin näyttötyyppi';
$string['rangesdisplaytype_help'] = 'Tämä asetus määrittelee näytetäänkö vaihteluväli oikeina arvosanoina, prosentteina tai kirjaimina vai käytetäänkö (peri) kategorian tai arvosanakohteen näyttötyyppiä.';
$string['rank'] = 'Sijoitus';
$string['rawpct'] = 'Raaka %';
$string['real'] = 'Todellinen';
$string['realletter'] = 'Todellinen (kirjain)';
$string['realpercentage'] = 'Todellinen (prosenttia)';
$string['recovergradesdefault'] = 'Palauta arvosanojen oletukset';
$string['recovergradesdefault_help'] = 'Palauta vanhat arvosanat oletusarvoisesti kun opiskelija palautetaan kurssialueelle.';
$string['regradeanyway'] = 'Arvioi uudelleen joka tapauksessa';
$string['removeallcoursegrades'] = 'Poista kaikki arvosanat';
$string['removeallcourseitems'] = 'Poista kaikki nimikkeet ja kategoriat';
$string['report'] = 'Raportti';
$string['reportdefault'] = 'Raportin oletus ({$a})';
$string['reportplugins'] = 'Raportti lisäosat';
$string['reportsettings'] = 'Raportin asetukset';
$string['reprintheaders'] = 'Otsakkeiden päivitys';
$string['respectingcurrentdata'] = 'jättää nykyisen asemoinnin muuttamattomaksi';
$string['rowpreviewnum'] = 'Esikatselun rivejä';
$string['savechanges'] = 'Tallenna muutokset';
$string['savepreferences'] = 'Tallenna asetukset';
$string['scaleconfirmdelete'] = 'Haluatko varmasti poistaa asteikon "{$a}"?';
$string['scaledpct'] = 'Asteikko %';
$string['seeallcoursegrades'] = 'Näytä kaikki kurssin arvioinnit';
$string['select'] = 'Valitse {$a}';
$string['selectalloroneuser'] = 'Valitse kaikki tai yksi käyttäjä';
$string['selectauser'] = 'Valitse käyttäjä';
$string['selectdestination'] = 'Valitse {$a} :n kohde';
$string['separator'] = 'Erotin';
$string['sepcomma'] = 'Pilkku';
$string['septab'] = 'Tabulaattori';
$string['setcategories'] = 'Aseta kategoriat';
$string['setcategorieserror'] = 'Sinun täytyy ensin asettaa kategoriat kurssillesi ennen kuin voit antaa niille painotukset';
$string['setgradeletters'] = 'Määritä kirjainarvosanat';
$string['setpreferences'] = 'Muokkaa asetuksia';
$string['setting'] = 'Asetus';
$string['settings'] = 'Asetukset';
$string['setweights'] = 'Aseta painotukset';
$string['showactivityicons'] = 'Näytä aktiviteettikuvakkeet';
$string['showactivityicons_help'] = 'Näytetäänkö aktiviteettikuvakkeet aktiviteetin nimen vieressä.';
$string['showallhidden'] = 'Näytä piilotetut';
$string['showallstudents'] = 'Näytä kaikki opiskelijat';
$string['showanalysisicon'] = 'Näytä arviointianalyysin kuvake';
$string['showanalysisicon_desc'] = 'Näytetäänkö arviointianalyysin kuvake oletusarvoisesti vai ei. Jos aktiviteetti tukee toimintoa, ko. kuvake linkittyy sivulle, josta kustakin arvosanasta kerrotaan lisäperusteluja.';
$string['showanalysisicon_help'] = 'Jos aktiviteetti tukee toimintoa, ko. kuvake linkittyy sivulle, josta kustakin arvosanasta kerrotaan lisäperusteluja.';
$string['showaverage'] = 'Näytä keskiarvo';
$string['showaverage_help'] = 'Näytä keskiarvosarake? Opiskelijat saattavat pystyä arvioimaan muiden opiskelijoiden arvosanoja jos keskiarvo lasketaan pienestä määrästä arvosanoja. Suoritussyistä keskiarvo on likiarvo jos se on riippuvainen yhdestäkään piilotetusta kohteesta.';
$string['showaverages'] = 'Näytä keskiarvot';
$string['showaverages_help'] = 'Näyttää jokaisen palstan keskiarvo.';
$string['showcalculations'] = 'Näytä laskut';
$string['showcalculations_help'] = 'Näytetäänkö laskimen kuvakkeet jokaisella arvosanalla ja kategorialla, tooltipit laskettujen yllä ja visuaalinen merkki että palsta on laskettu.';
$string['showeyecons'] = 'Näytä näytä/piilota-kuvakkeet';
$string['showeyecons_help'] = 'Näytetäänkä näytä/piilota -kuvake jokaisen arvosanan lähellä.';
$string['showfeedback'] = 'Näytä palaute';
$string['showfeedback_help'] = 'Näytä palautesarake?';
$string['showgrade'] = 'Näytä arvosanat';
$string['showgrade_help'] = 'Näytä arvosanasarake?';
$string['showgroups'] = 'Näytä ryhmät';
$string['showhiddenitems'] = 'Näytä piilotetut kohteet';
$string['showhiddenitems_help'] = 'Määrittelee kuinka piilotetut arvosanat näytetään. Jos Piilota on valittu, ne ovat kokonaan piilossa.

* Näytä piilotetut - Piilotettu arvosana-kenttä näytetään mutta opiskelijan arvosanat piilotetaan
* Piilotettu saakka - Arvosanat jotka  on määritelty asetus "piilotettu saakka", näytetään vasta määriteltynä päivänä
* Älä näytä - Piilotetut arvosanat on kokonaan piilossa';
$string['showhiddenuntilonly'] = 'Vain piilossa';
$string['showlettergrade'] = 'Näytä arvosanakirjaimet';
$string['showlettergrade_help'] = 'Näytä arvosanakirjainten sarake';
$string['showlocks'] = 'Näytä lukot';
$string['showlocks_help'] = 'Näytetäänkö lukitse/avaa -kuvake arvosanan lähellä.';
$string['shownohidden'] = 'Älä näytä';
$string['shownooutcomes'] = 'Piilota tavoitteet';
$string['shownumberofgrades'] = 'Näytä arvosanojen määrä keskiarvoissa';
$string['shownumberofgrades_help'] = 'Näytetäänkö arvosanojen määrä sulkumerkkien sisällä laskiessa keskiarvoa jokaisen keskimäärän jälkeen, esim. 45 (34).';
$string['showpercentage'] = 'Näytä prosenttiosuus';
$string['showpercentage_help'] = 'Näytä jokaisen arvosanakohteen prosenttiarvo?';
$string['showquickfeedback'] = 'Näytä pikapalaute';
$string['showquickfeedback_help'] = 'Pikapalaute lisää tekstinsyöttöelementin arvioijan raportin arviointisoluihin. Kenttien avulla voit muokata monia palautteita yhtä aikaa. Napsauta Päivitä -nappia tallentaaksesi syötetyt palautteet kerralla.';
$string['showrange'] = 'Näytä vaihteluvälit';
$string['showrange_help'] = 'Näytä vaihteluvälisarake?';
$string['showranges'] = 'Näytä vaihteluvälit';
$string['showranges_help'] = 'Näytetäänkö jokaisen palstan arvosanojen asteikko erillisellä rivillä.';
$string['showrank'] = 'Näytä sijoitus';
$string['showrank_help'] = 'Näytetäänkö opiskelijan suoritus  kustakin arviointikohteesta suhteutettuna muihin kurssilaisiin?';
$string['showuserimage'] = 'Näytä käyttäjäprofiilien kuvat';
$string['showuserimage_help'] = 'Näytetäänkö käyttäjän profiilikuva nimen vieressä arviointiraportissa.';
$string['showverbose'] = 'Näytä {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Näytä painotukset';
$string['showweight_help'] = 'Näytä arvosanan painotussarake?';
$string['simpleview'] = 'Yksinkertainen näkymä';
$string['sitewide'] = 'Sivuston kattava';
$string['sort'] = 'lajittele';
$string['sortasc'] = 'Lajittele nousevaan järjestykseen';
$string['sortbyfirstname'] = 'Lajittele etunimen mukaan';
$string['sortbylastname'] = 'Lajittele sukunimen mukaan';
$string['sortdesc'] = 'Lajittele laskevaan järjestykseen';
$string['standarddeviation'] = 'Keskihajonta';
$string['stats'] = 'Tilastot';
$string['statslink'] = 'Tilastot';
$string['student'] = 'Opiskelija';
$string['studentsperpage'] = 'Opiskelijoita sivulla';
$string['studentsperpage_help'] = 'Yhdellä sivulla näytettävien opiskelijoiden lukumäärä arviointiraportissa.';
$string['subcategory'] = 'Normaali kategoria';
$string['submissions'] = 'Palautukset';
$string['submittedon'] = 'Palauttanut: {$a}';
$string['switchtofullview'] = 'Vaihda täyteen näkymään';
$string['switchtosimpleview'] = 'Vaihda yksinkertaiseen näkymään';
$string['tabs'] = 'Välilehdet';
$string['topcategory'] = 'Super kategoria';
$string['total'] = 'Kokonaistulos';
$string['totalweight100'] = 'Kokonaispainotus on yhteensä 100';
$string['totalweightnot100'] = 'Kokonaispainotus ei ole yhteensä 100';
$string['turnfeedbackoff'] = 'Poista palaute käytöstä';
$string['turnfeedbackon'] = 'Ota palaute käyttöön';
$string['typenone'] = 'Ei mitään';
$string['typescale'] = 'Asteikko';
$string['typescale_help'] = 'Tämä asetus määrittelee käytettävän asteikon kun käytetään asteikko -arvosanatyyppiä. Aktiviteettipohjaiselle arviointikohteelle asetetaan asteikko aktiviteetin asetussivulla.';
$string['typetext'] = 'Teksti';
$string['typevalue'] = 'Arvo';
$string['uncategorised'] = 'Kategorioimaton';
$string['unchangedgrade'] = 'Muuttumaton arvosana';
$string['unenrolledusersinimport'] = 'Tämä tuonti sisälsi seuraavat arvosanat käyttäjille jotka eivät ole ilmoittautuneet tälle kurssille: {$a}';
$string['unlimitedgrades'] = 'Rajoittamattomat arvosanat';
$string['unlimitedgrades_help'] = 'Oletuksena arvosanat on rajoitettu arvosanakohteen maksimi ja minimiarvojen välille. Tämän asetuksen salliminen poistaa nämä rajat, ja sallii yli 100%:n arvosanojen antamisen suoraan Arvioinnit-sivulle. On suositeltavaa, että tämä asetus sallitaan silloin, kun palvelimella ei ole suurta rasitetta, koska kaikki arvosanat lasketaan uudelleen, mikä voi johtaa palvelimen suureen rasitukseen.';
$string['unlock'] = 'Avaa lukitus';
$string['unlockverbose'] = 'Avaa {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Käyttämätön';
$string['updatedgradesonly'] = 'Vie vain uudet tai päivitetyt arvosanat';
$string['uploadgrades'] = 'Siirrä arvosanat';
$string['useadvanced'] = 'Käytä laajennettuja ominaisuuksia';
$string['usedcourses'] = 'Käytetyt kurssit';
$string['usedgradeitem'] = 'Käytetty arviointikohde';
$string['usenooutcome'] = 'Älä käytä lopputulosta';
$string['usenoscale'] = 'Älä käytä asteikkoa';
$string['usepercent'] = 'Käytä prosenttia';
$string['user'] = 'Käyttäjä';
$string['userenrolmentsuspended'] = 'Käyttäjän kirjautuminen keskeytetty';
$string['usergrade'] = 'Käyttäjä {$a->fullname} ({$a->useridnumber}) kohteessa {$a->gradeidnumber}';
$string['userpreferences'] = 'Käyttäjän preferenssit';
$string['useweighted'] = 'Käytä painotusta';
$string['verbosescales'] = 'Sanalliset asteikot';
$string['viewbygroup'] = 'Ryhmä';
$string['viewgrades'] = 'Näytä arvosanat';
$string['warningexcludedsum'] = 'Varoitus: arvosanojen ohittaminen ei ole yhteensopiva summatyypin yhteenvedon kanssa.';
$string['weight'] = 'painotus';
$string['weightcourse'] = 'Käytä kurssilla painotettuja arvosanoja';
$string['weightedascending'] = 'Lajittele nousevasti painotetun prosentin mukaan';
$string['weighteddescending'] = 'Lajittele laskevasti painotetun prosentin mukaan';
$string['weightedpct'] = 'painotettu %';
$string['weightedpctcontribution'] = 'painotettu %-jakauma';
$string['weightorextracredit'] = 'Lisäpisteiden painotus';
$string['weights'] = 'Painotukset';
$string['weightsedit'] = 'Muokkaa painotuksia ja lisäpisteitä';
$string['weightuc'] = 'Painotus';
$string['writinggradebookinfo'] = 'Kirjoitetaan arviointikirjan asetuksia';
$string['xml'] = 'XML';
$string['yes'] = 'Kyllä';
$string['yourgrade'] = 'Arvosanasi';
