<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   error
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alreadyloggedin'] = 'Olet kirjautunut nimellä {$a}, sinun täytyy kirjautua ulos ennen kuin voit kirjautua toisena käyttäjänä.';
$string['authnotexisting'] = 'Auktorisointimoduulia ei ole';
$string['backupcontainexternal'] = 'Tämä varmuuskopiotiedosto sisältää ulkoisia Moodle-verkoston Isäntiä, joita ei ole konfiguroitu paikallisesti';
$string['backuptablefail'] = 'Varmuuskopion taulujen asettaminen EI onnistunut!';
$string['blockcannotconfig'] = 'Tämä lohko ei tue globaalia konfiguraatiota';
$string['blockcannotinistantiate'] = 'Ongelma lohko-objektin ilmentymän luomisessa';
$string['blockcannotread'] = 'Ei voitu lukea tieto lohko-id:lle= {$a}';
$string['blockdoesnotexist'] = 'Lohkoa ei ole olemassa';
$string['blockdoesnotexistonpage'] = 'Tätä lohkoa (id={$a->instanceid}) ei ole tällä sivulla ({$a->url}).';
$string['blocknameconflict'] = 'Nimeämisristiriita: lohkolla {$a->name} on sama otsikko olemassa olevan lohkon kanssa: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Kommentin kutsupyyntö hylkäsi tämän kommentin.';
$string['cannotaddcoursemodule'] = 'Ei voitu lisätä uutta kurssimoduulia';
$string['cannotaddcoursemoduletosection'] = 'Ei voitu lisätä uutta kurssimoduulia kyseiseen osaan';
$string['cannotaddmodule'] = '{$a} -moduulia ei voitu lisätä tälle moduulilistalle!';
$string['cannotaddnewmodule'] = 'Ei voitu lisätä uutta moduulia {$a}';
$string['cannotaddrss'] = 'Sinulla ei ole oikeuksia lisätä rss-syötteitä';
$string['cannotaddthisblocktype'] = 'Et voi lisätä {$a} -lohkoa tälle sivulle.';
$string['cannotassignrole'] = 'Ei voi jakaa roolia kurssilla';
$string['cannotassignrolehere'] = 'Et voi jakaa roolia (id = {$a->roleid}) tässä kontekstissa ({$a->context})';
$string['cannotassignselfasparent'] = 'Ei voida asettaa itseä emo-objektiksi!';
$string['cannotcallscript'] = 'Et voi kutsua tätä skriptiä näin';
$string['cannotcallusgetselecteduser'] = 'Et voi kutsua user_selector::get_selected_user jos monivalinta on true.';
$string['cannotcreatebackupdir'] = 'Ei voitu luoda varmuuskopiokansiota. Sivuston ylläpitäjän täytyy korjata tiedosto-oikeudet';
$string['cannotcreatecategory'] = 'Kategoriaa ei syötetty';
$string['cannotcreategroup'] = 'Virhe ryhmän luomisessa';
$string['cannotcreatelangbase'] = 'Virhe: Ei voitu luoda ensisijaista kielihakemistoa';
$string['cannotcreatelangdir'] = 'Kielihakemistoa ei voida luoda';
$string['cannotcreateorfindstructs'] = 'Virhe löydettäessä tai luotaessa osiorakenteita tälle kurssille';
$string['cannotcreatepopupwin'] = 'Määrittelemätön elementti - ei voida luoda ponnahdusikkunaa';
$string['cannotcreatesitedir'] = 'Ei voida luoda sivustokansiota. Sivuston ylläpitäjän täytyy korjata tiedosto-oikeudet.';
$string['cannotcreatetempdir'] = 'Temp-hakemistoa ei voitu luoda';
$string['cannotcreateuploaddir'] = 'Ei voida luoda latauskansiota. Sivuston ylläpitäjän täytyy korjata tiedosto-oikeudet.';
$string['cannotcustomisefiltersblockuser'] = 'Et voi räätälöidä suotimien asetuksia käyttäjä- tai lohkokonteksteissa.';
$string['cannotdeletebackupids'] = 'Ei voitu poistaa aiempia varmuuskopio-id:itä';
$string['cannotdeletecategorycourse'] = 'Kurssia \'{$a}\' ei voitu poistaa.';
$string['cannotdeletecategoryquestions'] = 'Ei voitu poistaa kysymyksiä kategoriasta \'{$a}\'';
$string['cannotdeletecourse'] = 'Sinulla ei ole oikeutta poistaa tätä kurssia';
$string['cannotdeletecustomfield'] = 'Virhe poistettaessa räätälöityä kenttätietoa';
$string['cannotdeletedir'] = 'Ei voida poistaa ({$a})';
$string['cannotdeletefile'] = 'Tiedostoa ei voi poistaa.';
$string['cannotdeleterole'] = 'Sitä ei voida poistaa koska {$a}';
$string['cannotdeleterolewithid'] = 'Ei voitu poistaa roolia ID:llä {$a}';
$string['cannotdeletethisrole'] = 'Et voi poistaa tätä roolia koska järjestelmä käyttää sitä tai se on viimeinen rooli ylläpitäjän oikeuksilla.';
$string['cannotdownloadcomponents'] = 'Komponentteja ei voitu ladata';
$string['cannotdownloadlanguageupdatelist'] = 'Ei voida ladata listaa kielipäivityksistä osoitteesta download.moodle.org';
$string['cannotdownloadzipfile'] = 'ZIP-tiedostoa ei voitu ladata';
$string['cannoteditcomment'] = 'Et voi muokata kommenttia!';
$string['cannoteditcommentexpired'] = 'Et voi muokata tätä. Erääntymisaika umpeutui!';
$string['cannoteditpostorblog'] = 'Et voi kirjoittaa tai muokata blogeja';
$string['cannoteditsiteform'] = 'Et voi muokata sivustokurssia käyttäen tätä lomaketta';
$string['cannotedityourprofile'] = 'Et voi muokata omaa profiiliasi';
$string['cannotfindcategory'] = 'Ei löydetä kategoriamerkintää tietokannasta ID:llä - {$a}';
$string['cannotfindcomponent'] = 'Komponenttia ei löytynyt';
$string['cannotfindcontext'] = 'Ei löydetty kontekstia';
$string['cannotfindcourse'] = 'Ei löydetä kurssia';
$string['cannotfinddocs'] = 'Ei löydetä "{$a}" kielen docs-tiedostoja';
$string['cannotfindgradeitem'] = 'Ei löydetä kohdetta grade_item';
$string['cannotfindgroup'] = 'Ei löydetä ryhmää';
$string['cannotfindhelp'] = 'Ei löydetä "{$a}" kielen help-tiedostoja';
$string['cannotfindinfo'] = 'Ei löydetä tietoa kohteelle: "{$a}"';
$string['cannotfindlang'] = 'Ei löydetä "{$a}" kielipakettia!';
$string['cannotfindteacher'] = 'Ei löydetä opettajaa';
$string['cannotfinduser'] = 'Ei löydetä käyttäjää "{$a}"';
$string['cannotgeoplugin'] = 'Ei voitu yhdistää geoPlugin-palvelimelle osoitteessa: http://www.geoplugin.com, tarkista proxy-asetukset tai asenna MaxMind GeoLite City -datatiedosto';
$string['cannotgetblock'] = 'Ei voitu hakea lohkoja tietokannasta';
$string['cannotgetcats'] = 'Ei saada kategoriamerkintää';
$string['cannotgetdata'] = 'Ei saada dataa';
$string['cannotgradeuser'] = 'Tätä käyttäjää ei voida arvioida';
$string['cannothaveparentcate'] = 'Kurssikategorialla ei voi olla yläkategoriaa!';
$string['cannotimport'] = 'Tuontivirhe';
$string['cannotimportformat'] = 'Valitettavasti tähän formaattiin tuontia ei ole vielä toteutettu!';
$string['cannotimportgrade'] = 'Arvosanan tuontivirhe';
$string['cannotinsertgrade'] = 'Ei voida syöttää arvosanaa ilman kurssi-id:tä!';
$string['cannotinsertrate'] = 'Ei voitu syöttää uutta arviota ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Ei voitu syöttää uutta merkintää ID:llä {$a}';
$string['cannotmailconfirm'] = 'Virhe lähetettäessä varmistussähköpostia salasanan muutoksesta';
$string['cannotmanualctrack'] = 'Aktiviteetti ei tarjoa manuaalista suoritusten seurantaa';
$string['cannotmapfield'] = 'Linkitysristiriita havaittu - kaksi kenttää on yhdistetty samaan arvosanaan {$a}';
$string['cannotmarktopic'] = 'Ei voitu merkitä aihetta tälle kurssille';
$string['cannotmigratedatacomments'] = 'Ei voida siirtää datamoduulin kommentteja';
$string['cannotmodulename'] = 'Ei saada moduulin nimeä navigaation rakentamisessa';
$string['cannotmoduletype'] = 'Ei saada moduulin tyyppiä navigaation rakentamisessa';
$string['cannotmoverolewithid'] = 'Ei voida siirtää roolia ID:llä {$a}';
$string['cannotopencsv'] = 'CSV-tiedostoa ei voi avata';
$string['cannotopenfile'] = 'Ei voida avata tiedostoa ({$a})';
$string['cannotopenforwrit'] = 'Ei voida avata kirjoittamista varten: {$a}';
$string['cannotopentemplate'] = 'Ei voida avata mallipohjatiedostoa ({a})';
$string['cannotopenzip'] = 'Ei voida avata zip-tiedostoa, luultavasti zip-laajennuksen bugi 64bit käyttöjärjestelmässä';
$string['cannotoverridebaserole'] = 'Ei voida ohittaa kantaroolin kykyjä';
$string['cannotoverriderolehere'] = 'Et voi ohittaa tätä roolia (id = {$a->roleid}) tässä kontekstissa ({$a->context})';
$string['cannotreadfile'] = 'Tiedostoa ei voida lukea ({$a})';
$string['cannotreadtmpfile'] = 'Virhe luettaessa väliaikaista tiedostoa';
$string['cannotreaduploadfile'] = 'Ei voitu lukea ladattua tiedostoa';
$string['cannotremovefrommeta'] = 'Ei voitu poistaa valittua kurssia tältä metakurssilta!';
$string['cannotresetguestpwd'] = 'Et voi nollata vierailijan salasanaa';
$string['cannotresetmail'] = 'Virhe nollattaessa salasanaa ja lähetettäessä sinulle postia';
$string['cannotresetthisrole'] = 'Ei voida nollata tätä roolia';
$string['cannotrestore'] = 'Tapahtui virhe eikä palautusta voitu suorittaa loppuun!';
$string['cannotrestoreadminorcreator'] = 'Palauttaaksesi uudeksi kurssiksi sinun täytyy olla kurssiylläpitäjä tai ylläpitäjä!';
$string['cannotrestoreadminoredit'] = 'Palauttaaksesi valitulle kurssille sinun täytyy olla opettaja (muokkaava) tai ylläpitäjä!';
$string['cannotsaveagreement'] = 'Ei voitu tallentaa valintaasi';
$string['cannotsaveblock'] = 'Virhe tallennettaessa lohkon konfiguraatiota';
$string['cannotsavecomment'] = 'Kommenttia ei voi tallentaa';
$string['cannotsavedata'] = 'Ei voida tallentaa dataa';
$string['cannotsavefile'] = 'Ei voida tallentaa tiedostoa "{$a}"!';
$string['cannotsavemd5file'] = 'MD5-tiedostoa ei voitu tallentaa';
$string['cannotsavezipfile'] = 'Zip-tiedostoa ei voitu tallentaa';
$string['cannotservefile'] = 'Ei voida tarjota tiedostoa - palvelimen konfiguraatio-ongelma';
$string['cannotsetparentforcatoritem'] = 'Ei voida asettaa yläkategoriaa kategorialle tai kurssille!';
$string['cannotsetpassword'] = 'Käyttäjän salasanaa ei voida asettaa!';
$string['cannotsetprefgrade'] = 'Ei voitu asettaa ensisijaista kokoomanäkymää valinnaksi {$a} tälle arvosanakategorialle';
$string['cannotsettheme'] = 'Teemaa ei voida asettaa!';
$string['cannotsetupblock'] = 'Lohkotauluja EI voitu asettaa oikein!';
$string['cannotsetupcapformod'] = 'Ei voitu asettaa kykyjä kohteelle {$a}';
$string['cannotsetupcapforplugin'] = 'Ei voitu asettaa kykyjä kohteelle {$a}';
$string['cannotshowhidecoursesincategory'] = 'Ei voida näyttää/piilottaa kursseja kategoriassa {$a}.';
$string['cannotunassigncap'] = 'Ei voitu poistaa vanhentuneen kyvyn {$a->cap} jakoa roolista {$a->role}';
$string['cannotunassignrolefrom'] = 'Ei voitu poistaa käyttäjältä roolin jakoa id:llä: {$a}';
$string['cannotunzipfile'] = 'Zip-tiedostoa ei voitu purkaa';
$string['cannotupdatemod'] = 'Ei voitu päivittää {$a}';
$string['cannotupdatepasswordonextauth'] = 'Ei voitu päivittää salasanaa ulkoisessa autentikoinnissa: {$a}. Katso palvelimen lokeista lisätietoa.';
$string['cannotupdateprofile'] = 'Virhe päivitettäessä käyttäjämerkintää';
$string['cannotupdaterecord'] = 'Ei voitu päivittää merkintää ID:llä {$a}';
$string['cannotupdaterss'] = 'Ei voida päivittää RSS-syötettä';
$string['cannotupdatesubcourse'] = 'Ei voitu päivittää alakurssia!';
$string['cannotupdateusermsgpref'] = 'Ei voida päivittää käyttäjän viestiasetuksia';
$string['cannotupdateuseronexauth'] = 'Ei voitu päivittää käyttäjätietoja ulkoisessa autentikoinnissa: {$a}. Katso palvelimen lokeista lisätietoa.';
$string['cannotuploadfile'] = 'Virhe käsiteltäessä ladattua tiedostoa';
$string['cannotuseadmin'] = 'Sinun täytyy olla ylläpitäjä käyttääksesi tätä sivua';
$string['cannotuseadminadminorteacher'] = 'Sinun täytyy olla opettaja tai ylläpitäjä käyttääksesi tätä sivua';
$string['cannotusepage'] = 'Vain opettajat ja ylläpitäjät voivat käyttää tätä sivua';
$string['cannotusepage2'] = 'Valitettavasti et voi käyttää tätä sivua';
$string['cannotviewprofile'] = 'Et voi katsella tämän käyttäjän profiilia';
$string['cannotviewreport'] = 'Et voi katsella tätä raporttia';
$string['cannotwritefile'] = 'Ei voida kirjoittaa tiedostoon ({$a})';
$string['categoryerror'] = 'Kategoriavirhe';
$string['categorytoolong'] = 'Liian pitkä kategorian nimi';
$string['commentmisconf'] = 'Kommentti-ID on väärin konfiguroitu';
$string['componentisuptodate'] = 'Komponentti on ajan tasalla';
$string['confirmsesskeybad'] = 'Valitettavasti istuntoavaintasi ei voitu varmistaa tämän toiminnon toteuttamiseksi. Tämä turvaominaisuus ehkäisee vahingossa tapahtuvaa tai tahallista ilkivaltaista tärkeiden toimintojen suoritusta nimelläsi. Varmista, että todella haluat suorittaa tämän toiminnon.';
$string['couldnotassignrole'] = 'Vakava mutta määrittelemätön virhe tapahtui kun roolia yritettiin liittää tunnukseesi';
$string['couldnotupdatenoexistinguser'] = 'Ei voida päivittää käyttäjää - käyttäjää ei ole olemassa';
$string['countriesphpempty'] = 'Virhe: Tiedosto countries.php tiedostopaketissa {$a} on tyhjä tai se puuttuu.';
$string['coursedoesnotbelongtocategory'] = 'Kurssi ei kuulu tähän kategoriaan';
$string['courseformatnotfound'] = 'Kurssiformaattia \'{$a}\' ei ole tai sitä ei tunnisteta';
$string['coursegroupunknown'] = 'Ryhmää {$a} vastaavaa kurssia  ei ole määritetty.';
$string['courseidnotfound'] = 'Kurssin id ei ole olemassa';
$string['coursemisconf'] = 'Kurssi on väärin konfiguroitu';
$string['courserequestdisabled'] = 'Valitettavasti ylläpitäjä on estänyt kurssipyynnöt';
$string['csvcolumnduplicates'] = 'Sarakkeiden kaksoiskappaleita havaittu';
$string['csvemptyfile'] = 'CSV-tiedosto on tyhjä';
$string['csvfewcolumns'] = 'Ei tarpeeksi sarakkeita, ole hyvä ja varmista erotinmerkin asetukset';
$string['csvinvalidcols'] = '<b>Virheellinen CSV-tiedosto:</b> Ensimmäisellä rivillä täytyy olla "Otsikkokentät" ja tiedoston pitää olla tyyppiä <br />"Expanded Fields/Comma Separated"<br />tai<br /> "Expanded Fields with CAVV Result Code/Comma Separated"';
$string['csvinvalidcolsnum'] = 'Virheellinen CSV-tiedosto - joka rivillä pitää olla 49 tai 70 kenttää';
$string['csvloaderror'] = 'Tapahtui virhe ladattaessa CSV-tiedostoa';
$string['csvweirdcolumns'] = 'Virheellinen CSV-tiedoston muoto - sarakkeiden määrä ei ole vakio!';
$string['dbconnectionfailed'] = '<p>Virhe: Tietokantayhteys katkesi</p>
<p>On mahdollista että tietokanta on ylikuormitettu tai ei muuten toimi oikein.</p>
<p>Sivuston ylläpitäjän tulisi myös tarkistaa että tietokannan tiedot ovat oikein tiedostossa config.php</p>';
$string['dbdriverproblem'] = '<p>Virhe: tietokanta-ajurin ongelma havaittu</p>
<p>Sivuston ylläpitäjän tulisi varmistaa palvelimen asetukset</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Vakava tietokantasession virhe havaittu.<br /><br />Ole hyvä ja ilmoita palvelimen ylläpitäjälle.';
$string['dbsessionhandlerproblem'] = 'Tietokantasession perustaminen epäonnistui.<br /><br />Ole hyvä ja ilmoita palvelimen ylläpitäjälle.';
$string['dbsessionmysqlpacketsize'] = 'Vakava sessiovirhe havaittu.<br /><br />Ole hyvä ja ilmoita ylläpitäjälle, luultavimmin tämä virhe johtuu pienestä arvosta MySQL asetuksessa max_allowed_packet.';
$string['dbupdatefailed'] = 'Tietokannan päivitys epäonnistui';
$string['ddldependencyerror'] = 'Kohdetta {$a->targettype} "{$a->targetname}" ei voida muokata. Riippuvuus löydetty kohteesta {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'DDL sql suoritusvirhe';
$string['ddlfieldalreadyexists'] = 'Kenttä "{$a}" on jo olemassa';
$string['ddlfieldnotexist'] = 'Kenttää "{$a->fieldname}" ei ole olemassa taulussa "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Taulu "{$a}" on jo olemassa';
$string['ddltablenotexist'] = 'Taulua "{$a}" ei ole olemassa';
$string['ddlunknownerror'] = 'Tuntematon DLL-kirjaston virhe';
$string['ddlxmlfileerror'] = 'Löydettiin XML-tietokannan tiedostovirheitä';
$string['ddsequenceerror'] = 'Väärä taulun "{$a}" määritelmä; voi olla vain yksi automaattinen sarake ja se pitää määritellä avaimeksi.';
$string['destinationcmnotexit'] = 'Kohdekurssimoduulia ei ole';
$string['detectedbrokenplugin'] = 'Moduuli "{$a}" on viallinen tai vanhentunut, ei voida jatkaa.';
$string['dmlreadexception'] = 'Tietokannasta lukemisessa tapahtui virhe';
$string['dmltransactionexception'] = 'Tietokannan siirtovirhe';
$string['dmlwriteexception'] = 'Tietokantaan kirjoittamisessa tapahtui virhe';
$string['downgradedcore'] = 'VIRHE!!! Koodi jota käytät on vanhempaa kuin versio, jolla tietokannat on tehty.';
$string['downloadedfilecheckfailed'] = 'Ladatun tiedoston tarkistus epäonnistui';
$string['duplicatefieldname'] = 'Havaittiin kentän nimen "{$a}" kaksoiskappale';
$string['duplicateparaminsql'] = 'VIRHE: parametrin nimen kaksoiskappale kyselyssä';
$string['duplicaterolename'] = 'Tällä nimellä on jo rooli!';
$string['duplicateroleshortname'] = 'Tällä lyhytnimellä on jo rooli!';
$string['duplicateusername'] = 'Käyttäjänimen kaksoiskappale - ohitetaan merkintä';
$string['emailfail'] = 'Sähköpostin lähetys epäonnistui';
$string['error'] = 'Virhe tapahtui';
$string['errorcleaningdirectory'] = 'Hakemiston puhdistamisessa tapahtui virhe: {$a}';
$string['errorcopyingfiles'] = 'Tiedostojen kopioinnissa tapahtui virhe';
$string['errorcreatingdirectory'] = 'Hakemiston luonnissa tapahtui virhe: {$a}';
$string['errorcreatingfile'] = 'Tiedoston luonnissa tapahtui virhe: {$a}';
$string['errorcreatingrole'] = 'Virhe roolin luomisessa';
$string['errorfetchingrssfeed'] = 'Virhe haettaessa RSS-syötettä';
$string['erroronline'] = 'Virhe rivillä {$a}';
$string['errorparsingxml'] = 'Virhe jäsenneltäessä XML: {$a->errorstring} rivillä {$a->errorline}, merkki {$a->errorchar}';
$string['errorreadingfile'] = 'Tiedoston lukemisessa tapahtui virhe: {$a}';
$string['errorsavingrequest'] = 'Tapahtui virhe tallennettaessa pyyntöäsi.';
$string['errorsettinguserpref'] = 'Virhe asetettaessa käyttäjän preferenssiä';
$string['errorunzippingfiles'] = 'Virhe tiedoston purkamisessa';
$string['expiredkey'] = 'Vanhentunut avain';
$string['externalauthpassworderror'] = 'Ei-tyhjä salasana ulkoiselle autentikoinnille';
$string['externalfilenolocation'] = 'Ulkoisella tiedostolla ei ole sijaintipolkua';
$string['failtoloadblocks'] = 'Yksi tai useampi lohko on rekisteröity tietokannassa mutta yksikään niistä ei latautunut!';
$string['fieldrequired'] = 'Kenttä "{$a}" vaaditaan';
$string['fileexists'] = 'Tiedosto on olemassa';
$string['filemismatch'] = 'Ei-ydin -tiedostonimi ei täsmää. Tiedoston "{$a->current}" pitäisi olla {$a->file}';
$string['filenotfound'] = 'Valitettavasti pyydettyä tiedostoa ei löydy';
$string['filenotreadable'] = 'Tiedostoa ei voi lukea';
$string['filterdoesnothavelocalconfig'] = 'Suodatin {$a} ei salli paikallista asetusten säätämistä.';
$string['filternotactive'] = 'Tiedosto {$a} ei ole tällä hetkellä aktiivinen';
$string['filternotenabled'] = 'Suodatinta ei sallittu!';
$string['filternotinstalled'] = 'Suodatinta {$a} ei ole asennettu';
$string['forumblockingtoomanyposts'] = 'Olet ylittänyt postitusrajan tällä keskustelualueella';
$string['generalexceptionmessage'] = 'Poikkeus - {$a}';
$string['gradepubdisable'] = 'Arvosanojen julkaisu estetty';
$string['groupalready'] = 'Käyttäjä kuuluu jo ryhmään {$a}';
$string['groupexistforcourse'] = 'Tällä kurssilla on jo ryhmä "{$a}"';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Ryhmä "{$a->name}" id-numerolla "{$a->idnumber}" on jo olemassa tällä kurssilla';
$string['grouphasidnumber'] = 'Ryhmällä "{$a}" on id-numero ja se on mahdollisesti luotu automaattisesti ulkoisen järjestelmän toimesta. Et voi poistaa tätä ryhmää.';
$string['groupinghasidnumber'] = 'Ryhmittelyllä "{$a}" on id-numero ja se on mahdollisesti luotu automaattisesti ulkoisen järjestelmän toimesta. Et voi poistaa tätä ryhmittelyä.';
$string['groupnotaddederror'] = 'Ryhmää "{$a}" ei lisätty';
$string['groupunknown'] = 'Ryhmä {$a} ei kuulu  kurssille';
$string['groupusernotmember'] = 'Käyttäjä ei ole tämän ryhmän jäsen.';
$string['guestnocomment'] = 'Vieraat eivät voi lähettää kommentteja!';
$string['guestnoeditprofile'] = 'Vierailijat eivät voi muokata käyttäjätietojaan';
$string['guestnoeditprofileother'] = 'Vierailijan käyttäjätietoja ei voi muokata';
$string['guestnorate'] = 'Vieraat eivät voi arvioida merkintöjä';
$string['guestsarenotallowed'] = 'Vierailijana ei voi tehdä tätä';
$string['hackdetected'] = 'Hakkerointihyökkäys havaittu!';
$string['hashpoolproblem'] = 'Väärä pooli-tiedoston sisältö {$a}.';
$string['headersent'] = 'Otsikot jo lähetetty';
$string['idnumbertaken'] = 'ID-numero on jo toisen kurssin käytössä';
$string['idnumbertoolong'] = 'ID-numero on liian pitkä';
$string['importformatnotimplement'] = 'Valitettavasti tässä formaatissa tuontia ei ole vielä toteutettu!';
$string['incorrectext'] = 'Tiedostolla on virheellinen tiedostopääte';
$string['installproblem'] = 'Yleensä ei ole mahdollista palautua asennuksen aikana tulleista virheistä, sinun pitää ehkä luoda uusi tietokanta tai käyttää eri tietokannan etuliitettä jos haluat yrittää asennusta uudelleen.';
$string['internalauthpassworderror'] = 'Puuttuva salasana tai virheellinen salasanakäytäntö sisäiselle autentikoinnille';
$string['invalidaccess'] = 'Tälle sivulle ei tultu oikein';
$string['invalidaccessparameter'] = 'Virheellinen pääsyparametri';
$string['invalidaction'] = 'Virheellinen toimintoparametri';
$string['invalidactivityid'] = 'Virheellinen aktiviteetin ID';
$string['invalidadminsettingname'] = 'Virheellinen ylläpitoasetus ({$a})';
$string['invalidargorconf'] = 'Ei annettu valideja argumentteja tai palvelimella on virheellinen konfiguraatio';
$string['invalidarguments'] = 'Ei annettu valideja argumentteja';
$string['invalidblockinstance'] = 'Virheellinen lohkoinstanssi: {$a}';
$string['invalidbulkenrolop'] = 'Pyydettiin virheellinen joukkokirjautumisoperaatio.';
$string['invalidcategory'] = 'Väärä kategoria!';
$string['invalidcategoryid'] = 'Väärä kategorian id!';
$string['invalidcomment'] = 'Virheellinen kommentti';
$string['invalidcommentarea'] = 'Virheellinen kommenttialue';
$string['invalidcommentid'] = 'Virheellinen kommentti-id';
$string['invalidcommentitemid'] = 'Virheellinen kommentti-id';
$string['invalidcommentparam'] = 'Virheelliset kommenttiparametrit';
$string['invalidcomponent'] = 'Virheellinen komponentin nimi';
$string['invalidconfirmdata'] = 'Virheellinen varmistustieto';
$string['invalidcontext'] = 'Virheellinen konteksti';
$string['invalidcourse'] = 'Virheellinen kurssi';
$string['invalidcourseid'] = 'Yrität käyttää virheellistä kurssin ID:tä';
$string['invalidcourselevel'] = 'Väärä kontekstitaso';
$string['invalidcoursemodule'] = 'Virheellinen kurssimoduulin ID';
$string['invalidcoursenameshort'] = 'Virheellinen kurssin lyhytnimi';
$string['invaliddata'] = 'Lähetetty data on virheellistä';
$string['invaliddatarootpermissions'] = 'Virheellisiä oikeuksia havaittu hakemistossa $CFG->dataroot, ylläpitäjän täytyy korjata oikeudet.';
$string['invaliddevicetype'] = 'Virheellinen laitteen tyyppi';
$string['invalidelementid'] = 'Väärä elementin id!';
$string['invalidentry'] = 'Tämä ei ole kelvollinen merkintä!';
$string['invalidevent'] = 'Virheellinen tapahtuma';
$string['invalidfieldname'] = '"{$a}" ei ole kelvollinen kentän nimi';
$string['invalidfiletype'] = '"{$a}" ei ole kelvollinen tiedostotyyppi';
$string['invalidformatpara'] = 'Väärä formaatti valitseparametrille';
$string['invalidformdata'] = 'Väärä lomaketieto';
$string['invalidfunction'] = 'Virheellinen funktio';
$string['invalidgradeitemid'] = 'Virheellinen arvosanan id';
$string['invalidgroupid'] = 'Virheellinen ryhmän id määritelty';
$string['invalidipformat'] = 'Virheellinen IP-osoiteformaatti';
$string['invaliditemid'] = 'Väärä kohteen id';
$string['invalidkey'] = 'Väärä avain';
$string['invalidlegacy'] = 'Väärä perinteisen roolin määritelmä tyypille: {$a}';
$string['invalidmd5'] = 'Tarkistusmuuttuja oli väärin - yritä uudelleen';
$string['invalidmode'] = 'Virheellinen moodi ({$a})';
$string['invalidmodule'] = 'Virheellinen moduuli';
$string['invalidmoduleid'] = 'Virheellinen moduulin ID: {$a}';
$string['invalidmodulename'] = 'Virheellinen moduulin nimi: {$a}';
$string['invalidnum'] = 'Virheellinen numeerinen arvo';
$string['invalidnumkey'] = '$conditions -taulu ei ehkä sisällä numeerisia avaimia, ole hyvä ja korjaa koodi!';
$string['invalidoutcome'] = 'Väärä tuloksen id';
$string['invalidpagesize'] = 'Virheellinen sivun koko';
$string['invalidpasswordpolicy'] = 'Virheellinen salasanakäytäntö';
$string['invalidpaymentmethod'] = 'Virheellinen maksutapa: {$a}';
$string['invalidqueryparam'] = 'VIRHE: Virheellinen määrä kyselyparametrejä. Odotettiin {$a->expected}, saatiin {$a->actual}.';
$string['invalidratingarea'] = 'Virheellinen arviointialue';
$string['invalidrecord'] = 'Ei löydetä merkintää tietokantataulusta {$a}.';
$string['invalidrecordunknown'] = 'Ei löydetä merkintää tietokannasta.';
$string['invalidrequest'] = 'Virheellinen pyyntö';
$string['invalidrole'] = 'Virheellinen rooli';
$string['invalidroleid'] = 'Virheellinen roolin ID';
$string['invalidscaleid'] = 'Väärä skaalan id';
$string['invalidsection'] = 'Kurssimoduulimerkintä sisältää virheellisen osion';
$string['invalidsesskey'] = 'Annettiin väärä sesskey, lomaketta ei hyväksytty!';
$string['invalidshortname'] = 'Virheellinen kurssin lyhytnimi';
$string['invalidsourcefield'] = 'Luonnostiedoston lähde on virheellinen';
$string['invalidstatedetected'] = 'Jossakin tapahtui virhe: {$a}. Tätä ei normaalisti pitäisi tapahtua.';
$string['invalidurl'] = 'Virheellinen web-osoite';
$string['invaliduser'] = 'Virheellinen käyttäjä';
$string['invaliduserfield'] = 'Virheellinen käyttäjätietokenttä: {$a}';
$string['invaliduserid'] = 'Virheellinen käyttäjän id';
$string['invalidxmlfile'] = '"{$a}" ei ole kelvollinen xml-tiedosto';
$string['iplookupfailed'] = 'Ei löydetä maantieteellistä tietoa tästä IP-osoitteesta {$a}';
$string['iplookupprivate'] = 'Ei voida näyttää yksityisen IP-osoitteen hakua';
$string['ipmismatch'] = 'Asiakkaan IP-osoite ei täsmää';
$string['listcantmovedown'] = 'Ei voitu siirtää kohdetta alas koska se on vertaisistaan viimeinen';
$string['listcantmoveleft'] = 'Ei voitu siirtää kohdetta vasemmalle koska sillä ei ole emo-objektia';
$string['listcantmoveright'] = 'Ei voitu siirtää kohdetta oikealle koska siellä ei ole vertaista, jonka lapsiobjekti se voisi olla. Siirrä kohde toisen kohteen alle, jonka jälkeen voit siirtää sen oikealle.';
$string['listcantmoveup'] = 'Ei voitu siirtää kohdetta ylös koska se on vertaisistaan ensimmäinen';
$string['listnochildren'] = 'Kohteen lapsiobjekteja ei löytynyt';
$string['listnoitem'] = 'Kohdetta ei löytynyt';
$string['listnopeers'] = 'Kohteen vertaisia ei löytynyt';
$string['listupdatefail'] = 'Tietokantaoperaatio epäonnistui muokattaessa listan hierarkiaa';
$string['logfilenotavailable'] = 'Lokeja ei saatavilla';
$string['loginasnoenrol'] = 'Et voi käyttää \'liity\' tai \'poistu\' -toimintoja kun olet kirjautuneena toisena käyttäjänä';
$string['loginasonecourse'] = 'Et voi kirjautua kurssille.<br />Sinun täytyy lopettaa "Kirjaudu käyttäjänä" -sessio ennen muille kursseille pääsyä.';
$string['maxbytes'] = 'Tiedosto on suurempi kuin suurin sallittu tiedostokoko';
$string['messagingdisable'] = 'Viestit on estetty tällä sivustolla';
$string['mimetexisnotexist'] = 'Järjestelmääsi ei ole kofiguroitu ajamaan mimeTeX:iä. Sinun täytyy ladata oikea versio PHP_OS alustallesi osoitteesta <a href="http://moodle.org/download/mimetex/">http://moodle.org/download/mimetex/</a>, tai hankkia C-lähde osoitteesta <a href="http://www.forkosh.com/mimetex.zip"> http://www.forkosh.com/mimetex.zip</a>, käännä se ja laita suoritettava tiedosto hakemistoon moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'Räätälöity mimetex ei ole suoritettavissa!';
$string['missingfield'] = 'Kenttä "{$a}" puuttuu';
$string['missingkeyinsql'] = 'VIRHE: kyselystä puuttuu parametri "{$a}"';
$string['missing_moodle_backup_xml_file'] = 'Varmuuskopiosta puuttuu XML-tiedosto: {$a}';
$string['missingparam'] = 'Vaadittu parametri ({$a}) puuttui';
$string['missingparameter'] = 'Parametri puuttuu';
$string['missingrequiredfield'] = 'Joitakin vaadituista kentistä puuttuu';
$string['missinguseranditemid'] = 'Puuttuva käyttäjän id sekä kohteen id';
$string['missingvarname'] = 'Vaadittu muuttujan nimi puuttuu';
$string['mixedtypesqlparam'] = 'VIRHE: Sql-kyselyn parametreissä on eri tyyppejä!!';
$string['mnetdisable'] = 'MNET on estetty';
$string['mnetlocal'] = 'MNET etäkäyttäjät eivät voi kirjautua paikallisesti';
$string['moduledisable'] = 'Tämä moduuli ({$a}) on estetty tältä kurssilta';
$string['moduledoesnotexist'] = 'Tätä moduulia ei ole olemassa';
$string['moduleinstancedoesnotexist'] = 'Tämän moduulin instanssia ei ole olemassa';
$string['modulemissingcode'] = 'Moduuli "{$a}" ei pysty suorittamaan pyydettyä toimintoa';
$string['movecatcontentstoroot'] = 'Kategorian sisällön siirtäminen päätasolle on estetty. Sisältö pitää siirtää olemassa olevaan kategoriaan.';
$string['multiplerecordsfound'] = 'Löydettiin useita merkintöjä, odotettiin vain yhtä.';
$string['multiplerestorenotallow'] = 'Useita palautussuorituksia ei sallita!';
$string['mustbeloggedin'] = 'Sinun täytyy kirjautua sisään voidaksesi tehdä tämän';
$string['mustbeteacher'] = 'Sinun pitäisi olla opettaja käyttääksi tätä sivua';
$string['myisamproblem'] = 'Tietokantataulut käyttävät MyISAM tietokantamoottoria, on suositeltavaa käyttää ACID-sopivaa moottoria täydellä siirtotuella, kuten InnoDB.';
$string['needcopy'] = 'Sinun täytyy ensin kopioida jotain!';
$string['needcoursecategroyid'] = 'Joko kurssi-id tai kategoria täytyy olla määritelty';
$string['needphpext'] = 'Sinun täytyy lisätä {$a} -tuki PHP-asennukseesi';
$string['noadmins'] = 'Ei ylläpitäjiä!';
$string['noblocks'] = 'Ei löydetty lohkoja!';
$string['nocapabilitytousethisservice'] = 'Käyttäjällä ei ole vaadittua kykyä tämän palvelun käyttämiseen';
$string['nocategorydelete'] = 'Kategoriaa \'{$a}\' ei voida poistaa!';
$string['nocontext'] = 'Valitettavasti kyseinen kurssi ei ole sopiva konteksti';
$string['nodata'] = 'Ei dataa';
$string['noexistingcategory'] = 'Ei olemassaolevaa kategoriaa';
$string['nofile'] = 'Tiedostoa ei määritelty';
$string['nofiltersenabled'] = 'Suotimia ei ole sallittu.';
$string['nofolder'] = 'Pyydettyä hakemistoa ei ole';
$string['noformdesc'] = 'formslib-lomakkeen kuvausta ei löydetty tälle aktiviteetille.';
$string['noguest'] = 'Ei vieraita täällä!';
$string['noinstances'] = 'Kurssilla ei ole instasseja "{$a}":sta';
$string['nologinas'] = 'Et voi kirjautua kyseisenä käyttäjänä';
$string['nonmeaningfulcontent'] = 'Merkityksetön sisältö';
$string['noparticipants'] = 'Tälle kurssille ei löytynyt osallistujia';
$string['noparticipatorycms'] = 'Valitettavasti sinulla ei ole osallistumiselle avoimia kurssimoduuleita, joista raportoida';
$string['nopermissions'] = 'Sinulla ei ole oikeutta tehdä kyseistä operaatiota ({$a})';
$string['nopermissiontocomment'] = 'Et voi lisätä kommentteja';
$string['nopermissiontodelentry'] = 'Et voi poistaa muiden merkintöjä!';
$string['nopermissiontoeditcomment'] = 'Et voi muokata muiden kommentteja!';
$string['nopermissiontohide'] = 'Ei lupaa piilottaa!';
$string['nopermissiontoimportact'] = 'Sinulla ei ole vaadittuja oikeuksia tuoda aktiviteetteja tälle kurssille';
$string['nopermissiontolock'] = 'Ei oikeutta lukita!';
$string['nopermissiontomanagegroup'] = 'Sinulla ei ole vaadittua oikeutta hallita ryhmiä';
$string['nopermissiontorate'] = 'Kohteiden arviointi ei sallittu!';
$string['nopermissiontoshow'] = 'Ei oikeutta nähdä tätä!';
$string['nopermissiontounlock'] = 'Ei oikeutta poistaa lukitusta!';
$string['nopermissiontoupdatecalendar'] = 'Valitettavasti sinulla ei ole oikeuksia päivittää kalenterimerkintää';
$string['nopermissiontoviewgrades'] = 'Ei voida näyttää arvosanoja.';
$string['nopermissiontoviewletergrade'] = 'Puuttuva oikeus kirjainarvosanojen katseluun';
$string['nopermissiontoviewpage'] = 'Et voi katsella tätä sivua';
$string['nosite'] = 'Ei löydetty ylimmän tason kurssia!';
$string['nositeid'] = 'Ei sivuston ID:tä';
$string['nostatstodisplay'] = 'Valitettavasti ei ole näytettävää tietoa';
$string['notallowedtoupdateprefremotely'] = 'Et voi päivittää tätä käyttäjäasetusta etänä';
$string['notavailable'] = 'Ominaisuus ei ole tällä hetkellä käytettävissä.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Et ole tämän kurssiryhmän jäsen';
$string['notownerofkey'] = 'Et ole tämän avaimen omistaja';
$string['nousers'] = 'Ei kyseistä käyttäjää!';
$string['onlyadmins'] = 'Vain ylläpitäjät voivat tehdä tämän';
$string['onlyeditingteachers'] = 'Vain opettajat voivat tehdä tämän';
$string['onlyeditown'] = 'Voit muokata vain omia tietojasi.';
$string['orderidnotfound'] = 'Tilaus ID:tä ei löytynyt';
$string['pagenotexist'] = 'Odottamaton virhe (haluttua sivua ei löydy)';
$string['pathdoesnotstartslash'] = 'Ei annettu valideja argumentteja, polku ei ala kauttaviivalla!';
$string['pleasereport'] = 'Jos sinulla on aikaa, ole hyvä ja kerro mitä yritit tehdä kun virhe ilmaantui:';
$string['pluginrequirementsnotmet'] = 'Pluginia "{$a->pluginname}" ({$a->pluginversion}) ei voitu asentaa. Se vaatii uudemman Moodle-version (nykyinen versiosi on {$a->currentmoodle}, tarvitset version {$a->requiremoodle}).';
$string['prefixcannotbeempty'] = '<p>Virhe: tietokantataulun etuliite ei voi olla tyhjä ({$a})</p> <p>Sivuston ylläpitäjän täytyy korjata tämä ongelma.</p>';
$string['prefixtoolong'] = '<p>Virhe: tietokantataulun etuliite on liian pitkä ({$a->dbfamily})</p> <p>Sivuston ylläpitäjän täytyy korjata tämä ongelma. Maximipituus etuliitteille tietokannassa {$a->dbfamily} on {$a->maxlength} merkkiä.</p>';
$string['processingstops'] = 'Käsittely loppuu tähän. Jäljelle jääneet merkinnät jätetään huomiotta.';
$string['protected_cc_not_supported'] = 'Suojattuja kasetteja ei tueta.';
$string['redirecterrordetected'] = 'Ei-tuettu uudelleenohjaus havaittu, skriptin suoritus lopetettiin';
$string['refoundto'] = 'Voidaan palauttaa arvoon {$a}';
$string['refoundtoorigi'] = 'Palautettiin alkuperäiseen arvoon: {$a}';
$string['remotedownloaderror'] = 'Komponentin lataaminen palvelimelle epäonnistui, ole hyvä ja varmista välityspalvelimen asetukset, PHP cURL -laajennus on suositeltu.<br /><br />Sinun täytyy ladata <a href="{$a->url}">{$a->url}</a> -tiedosto manuaalisesti, kopioi se kohteeseen "{$a->dest}" serverilläsi ja pura se sinne.';
$string['remotedownloadnotallowed'] = 'Komponenttien lataaminen palvelimellesi ei ole sallittu (allow_url_fopen on estetty).<br /><br />Sinun täytyy ladata <a href="{$a->url}">{$a->url}</a> -tiedosto manuaalisesti, kopioida se kohteeseen "{$a->dest}" palvelimellasi ja purkaa se sinne.';
$string['reportnotavailable'] = 'Tämän tyyppinen raportti on saatavilla vain sivustokurssilla';
$string['requireloginerror'] = 'Kurssille tai aktiviteettiin ei päästä.';
$string['restorechecksumfailed'] = 'Sessioosi tallennetussa palautustiedossa tapahtui jokin virhe. Ole hyvä ja tarkista PHP muisti/tietokannan paketin kokorajat. Palautus lopetettiin.';
$string['restore_path_element_missingmethod'] = 'Palautusmetodi {$a} puuttuu. Kehittäjän pitää määritellä se.';
$string['restore_path_element_noobject'] = 'Palautusobjekti {$a} ei ole objekti.';
$string['restrictedcontextexception'] = 'Valitettavasti ulkoisen funktion suorittaminen rikkoo kontekstirajoitusta.';
$string['restricteduser'] = 'Käyttäjätiliäsi "{$a}" on rajoitettu tämän toiminnon osalta.';
$string['reverseproxyabused'] = 'Käänteinen välityspalvelin käytössä, palvelimelle ei valitettavasti päästä suoraan.<br />Ota yhteyttä palvelimen ylläpitäjään.';
$string['rpcerror'] = 'Hups! MNET-kommunikaatiosi katkesi! Tässä virheilmoitus, jonka voit ohjata ylläpitäjälle: {$a}';
$string['scheduledbackupsdisabled'] = 'Ajoitetut varmuuskopiot on estetty palvelimen ylläpidon toimesta';
$string['secretalreadyused'] = 'Muuta salasanaa -varmistuksen linkki oli jo käytetty, salasanaa ei muutettu';
$string['sectionnotexist'] = 'Tätä osiota ei ole';
$string['sendmessage'] = 'Lähetä viesti';
$string['serverconnection'] = 'Virhe yhdistettäessä palvelimelle';
$string['servicedonotexist'] = 'Palvelua ei ole olemassa';
$string['sessioncookiesdisable'] = 'Väärin käytetty require_key_login() - session evästeet täytyy olla estetty!';
$string['sessiondiskfull'] = 'Session osio on täynnä. Sisäänkirjautuminen ei ole tällä hetkellä mahdollista.<br /><br />Ole hyvä ja ilmoita palvelimen ylläpitäjälle.';
$string['sessionerroruser'] = 'Olet kirjautunut ulos tai istuntosi on suljettu aikarajan takia.<br />Ole hyvä ja kirjaudu uudestaan.';
$string['sessionerroruser2'] = 'Palvelimella on tapahtunut virhe, joka vaikuttaa istuntoosi. Kirjaudu uudestaan tai käynnistä selaimesi uudelleen.';
$string['sessionipnomatch'] = 'Valitettavasti IP-numerosi näyttää muuttuneen siitä, kun aluksi kirjauduit sisään. Tämä turvatoiminto estää hakkereita varastamasta identiteettiäsi sillä välin kun olet rekisteröityneenä tällä sivulla. Normaalien käyttäjien ei pitäisi nähdä tätä viestiä - pyydä sivuston hallinnolta apua.';
$string['sessionipnomatch2'] = 'Valitettavasti IP-osoitteesi näyttää muuttuneen sen jälkeen kun kirjauduit sisään. Tämä turvaominaisuus estää identiteettivarkauden kun olet kirjautuneena tälle sivustolle. Saatat nähdä tämän virheen jos käytät langatonta verkkoa tai jos vaihdat eri verkkojen välillä. Ole hyvä ja kysy sivuston ylläpitäjältä lisäapua.<br /><br />Jos haluat jatkaa paina F5-painiketta päivittääksesi sivun.';
$string['sessionwaiterr'] = 'Aikakatkaisu session lukkoa odotettaessa.<br />Odota nykyisten pyyntöjesi valmistumista ja yritä myöhemmin uudelleen.';
$string['shortnametaken'] = 'Lyhyt nimi on jo käytössä toisella kurssilla';
$string['socksnotsupported'] = 'SOCKS5-välityspalvelin ei ole tuettu PHP4:ssä';
$string['spellcheckernotconf'] = 'Oikolukua ei konfiguroitu';
$string['sslonlyaccess'] = 'Turvallisuussyistä vain https-yhteydet sallitaan.';
$string['statscatchupmode'] = 'Tilastot ovat catchup-moodissa. Toistaiseksi {$a->daysdone} päivä(ä) käsitelty ja {$a->dayspending} päivä(ä) vireillä. Tarkista pian uudelleen!';
$string['statsdisable'] = 'Tilastoja ei sallittu';
$string['statsnodata'] = 'Ei tietoa saatavilla kyseiselle kurssille ja ajanjaksolle';
$string['storedfilecannotcreatefiledirs'] = 'Ei voida luoda paikallisia tiedostojoukon hakemistoja, ole hyvä ja varmista oikeudet juuressa.';
$string['storedfilecannotread'] = 'Ei voida lukea tiedostoa, joko tiedostoa ei ole tai oikeuksissa on ongelmia';
$string['storedfilenotcreated'] = 'Ei voida luoda tiedostoa "{$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}/{$a->filepath}/{$a->filename}"';
$string['storedfileproblem'] = 'Tuntematon paikallisiin tiedostoihin liittyvä poikkeus ({$a})';
$string['tagdisabled'] = 'Tunnisteet on estetty!';
$string['tagnotfound'] = 'Määriteltyä tunnistetta ei löytynyt tietokannasta';
$string['targetdatabasenotempty'] = 'Kohdetietokanta ei ole tyhjä. Siirto katkaistu turvallisuussyistä.';
$string['textconditionsnotallowed'] = 'Tekstisarakeolosuhteiden vertailua ei ole sallittu. Ole hyvä ja käytä sql_compare_text() -funktiota haussasi.';
$string['themenotinstall'] = 'Teemaa ei ole asennettu!';
$string['TODO'] = 'Tehtävälista';
$string['tokengenerationfailed'] = 'Ei voida generoida uutta avainta.';
$string['transactionvoid'] = 'Siirtoa ei voida mitätöidä koska se on jo mitätöity';
$string['unenrolerror'] = 'Tapahtui virhe yritettäessä kirjata henkilöä pois';
$string['unicodeupgradeerror'] = 'Valitettavasti tietokantasi ei ole Unicode-muodossa, eikä tämä Moodle-versio pysty muuttamaan tietokantaasi Unicode-muotoon. Ole hyvä ja päivitä ensin Moodle-versioon 1.7.x ja suorita Unicode-muutos Ylläpitosivulta. Tämän jälkeen sinun pitäisi pystyä siirtymään Moodle-versioon {$a}';
$string['unknowaction'] = 'Tuntematon toiminto!';
$string['unknowcategory'] = 'Kategoriaa ei tunneta!';
$string['unknowcontext'] = 'Tämä on tuntematon konteksti ({$a}) kohteessa get_child_contexts!';
$string['unknowformat'] = 'Muotoa ei tunneta ({$a})';
$string['unknownbackupexporterror'] = 'Tuntematon virhe valmisteltaessa tietoa tuotavaksi';
$string['unknownblockregion'] = 'Lohkoaluetta \'{$a}\' ei tunnisteta tällä sivulla.';
$string['unknowncontext'] = 'Tämä on tuntematon konteksti.';
$string['unknowncourse'] = 'Tuntematon kurssi nimeltään "{$a}"';
$string['unknowncourseidnumber'] = 'Tuntematon kurssi-ID "{$a}"';
$string['unknowncourserequest'] = 'Tuntematon kurssipyyntö';
$string['unknowncoursesection'] = 'Virheellinen kurssin osio kurssilla "{$a}"';
$string['unknownfiletype'] = 'Tuntematon suodatintyyppi';
$string['unknowngroup'] = 'Tuntematon ryhmä "{$a}"';
$string['unknownhelp'] = 'Tuntematon help-aihe {$a}';
$string['unknownjsinrequirejs'] = 'Ei löydetä JS-kirjastoa: {$a}';
$string['unknownmodulename'] = 'Tuntematon moduulin nimi lomakkeelle';
$string['unknownrole'] = 'Tuntematon rooli "{$a}"';
$string['unknownsortcolumn'] = 'Tuntematon lohkon järjestely {$a}';
$string['unknownuseraction'] = 'Valitettavasti en ymmärrä tätä käyttäjätoimintoa.';
$string['unknownuserselector'] = 'Tuntematon käyttäjän valitsin';
$string['unknoworder'] = 'Tuntematon järjestely';
$string['unknowparamtype'] = 'Tuntematon parametrityyppi: {$a}';
$string['unknowquestiontype'] = 'Ei-tuettu kysymystyyppi {$a}';
$string['unknowuploadaction'] = 'Virhe: Tuntematon lataustoiminto ({$a})';
$string['unspecifycourseid'] = 'Täytyy määritellä kurssi-id, lyhytnimi tai id-numero';
$string['unsupportedevent'] = 'Ei-tuettu tapahtumatyyppi';
$string['unsupportedstate'] = 'Ei-tuettu suorituksen tila';
$string['unsupportedwebserver'] = 'Verkkopalvelimen ohjelmistoa ({$a}) ei valitettavasti tueta.';
$string['upgraderequires19'] = 'Virhe: Palvelimelle asennettiin uusi Moodle-versio, valitettavasti päivitystä aiemmasta versiosta ei tueta.<br />Ole hyvä ja päivitä ensin uusimpaan 1.9.x julkaisuun. Voit myös palata edelliseen versioon asentamalla alkuperäiset tiedostot uudelleen.';
$string['upgraderunning'] = 'Sivustoa päivitetään, ole hyvä ja yritä myöhemmin uudelleen.';
$string['urlnotdefinerss'] = 'Web-osoitetta ei määritelty RSS-syötteelle';
$string['useradmineditadmin'] = 'Vain ylläpitäjät voivat muokata muita ylläpitäjien tilejä';
$string['useradminodelete'] = 'Ylläpitäjä-tilejä ei voida poistaa';
$string['userautherror'] = 'Tuntematon autentikointiplugini';
$string['userauthunsupported'] = 'Autentikointipluginia ei tueta täällä';
$string['useremailduplicate'] = 'Osoitteen kaksoiskappale';
$string['usermustbemnet'] = 'MNET pääsynhallintaluettelossa olevien käyttäjien täytyy olla MNET etäkäyttäjiä';
$string['usernotaddederror'] = 'Käyttäjää ei lisätty - virhe';
$string['usernotaddedregistered'] = 'Osallistujaa ei lisätty - on jo liittynyt';
$string['usernotavailable'] = 'Et voi tarkastella kyseisen käyttäjän tietoja';
$string['usernotdeletedadmin'] = 'Käyttäjää ei poistettu - ei voida poistaa ylläpidon tilejä';
$string['usernotdeletederror'] = 'Käyttäjää ei poistettu - virhe';
$string['usernotdeletedmissing'] = 'Käyttäjää ei poistettu - ei löydetty käyttäjänimeä';
$string['usernotdeletedoff'] = 'Käyttäjää ei poistettu - poistaminen ei sallittu';
$string['usernotincourse'] = 'Tämä käyttäjä ei ole tällä kurssilla!';
$string['usernotrenamedadmin'] = 'Ylläpidon tilejä ei voida nimetä uudelleen';
$string['usernotrenamedexists'] = 'Käyttäjää ei nimetty uudelleen - uusi käyttäjätunnus on jo käytössä';
$string['usernotrenamedmissing'] = 'Käyttäjää ei nimetty uudelleen - ei löydetty vanhaa käyttäjätunnusta';
$string['usernotrenamedoff'] = 'Käyttäjää ei nimetty uudelleen - uudelleennimeäminen ei sallittu';
$string['usernotupdatedadmin'] = 'Ei voida päivittää ylläpidon tilejä';
$string['usernotupdatederror'] = 'Käyttäjää ei päivitetty - virhe';
$string['usernotupdatednotexists'] = 'Käyttäjää ei päivitetty - ei olemassa';
$string['userquotalimit'] = 'Olet saavuttanut tiedostokiintiörajasi.';
$string['userselectortoomany'] = 'user_selector sai useamman kuin yhden valitun käyttäjän, vaikka multiselect on false';
$string['wrongcall'] = 'Tämä skripti on kutsuttu väärin';
$string['wrongcontextid'] = 'Konteksti-id oli väärä (sitä ei löydetä)';
$string['wrongdestpath'] = 'Virheellinen kohdekansio';
$string['wrongroleid'] = 'Väärä roolin ID!';
$string['wrongsourcebase'] = 'Väärä lähteen web-osoitteen kanta';
$string['wrongusernamepassword'] = 'Väärä käyttäjä/salasana';
$string['wrongzipfilename'] = 'Virheellinen zip-tiedoston nimi';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Ei voitu luoda kurssia - Ei oikeutta';
$string['wwwrootmismatch'] = 'Virheellinen pääsy havaittu, tälle palvelimelle päästään valitettavasti vain osoitteesta "{$a}".<br />Ole hyvä ja ilmoita palvelimen ylläpidolle.';
$string['wwwrootslash'] = 'Havaittiin väärä $CFG->wwwroot tiedostossa config.php, se ei voi sisältää kauttamerkkiä lopussa.<br />Ole hyvä ja ilmoita palvelimen ylläpitäjälle.';
$string['xmldberror'] = 'XMLDB-virhe!';
$string['youcannotdeletecategory'] = 'Et voi poistaa kategoriaa \'{$a}\' koska et voi poistaa sen sisältöä, etkä siirtää sitä muualle.';
