<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'fi', branch 'MOODLE_26_STABLE'
 *
 * @package   editor_tinymce
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Osoite';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Lisää/Muokkaa ankkuri';
$string['advanced:backcolor_desc'] = 'Valitse taustan väri';
$string['advanced:block'] = 'Muotoilu';
$string['advanced:blockquote'] = 'Pitkä lainaus';
$string['advanced:blockquote_desc'] = 'Pitkä lainaus';
$string['advanced:bold_desc'] = 'Lihavoitu (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Lisää/poista järjestämätön lista';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Lisää erikoismerkki';
$string['advanced:cleanup_desc'] = 'Siisti sekainen koodi';
$string['advanced:clipboard_msg'] = 'Kopioi-, Leikkaa- ja Liitä-painikkeet eivät toimi Mozilla ja Firefox -selaimilla. Voit kuitenkin käyttää näppäinyhdistelmiä kopioimiseen (Ctrl+c), leikkaamiseen (Ctrl+x) ja liittämiseen (Ctrl+v). Tarvitsetko lisää tietoa?';
$string['advanced:code'] = 'Koodi';
$string['advanced:code_desc'] = 'Muokkaa HTML-koodia';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopioi';
$string['advanced:custom1_desc'] = 'Oma kuvauksesi tähän';
$string['advanced:cut_desc'] = 'Leikkaa';
$string['advanced:dd'] = 'Määrittelyn kuvaus';
$string['advanced:div'] = 'DIV';
$string['advanced_dlg:about_author'] = 'Kirjoittaja';
$string['advanced_dlg:about_general'] = 'Tietoja';
$string['advanced_dlg:about_help'] = 'Ohje';
$string['advanced_dlg:about_license'] = 'Lisenssi';
$string['advanced_dlg:about_loaded'] = 'Ladatut lisäosat';
$string['advanced_dlg:about_plugin'] = 'Lisäosa';
$string['advanced_dlg:about_plugins'] = 'Lisäosat';
$string['advanced_dlg:about_title'] = 'Tietoja TinyMCE:stä';
$string['advanced_dlg:about_version'] = 'Versio';
$string['advanced_dlg:accessibility_help'] = 'Esteettömyysohje';
$string['advanced_dlg:accessibility_usage_title'] = 'Yleinen käyttö';
$string['advanced_dlg:anchor_invalid'] = 'Anna olemassa oleva ankkurin nimi';
$string['advanced_dlg:anchor_name'] = 'Ankkurin nimi';
$string['advanced_dlg:anchor_title'] = 'Liitä/muokkaa ankkuria';
$string['advanced_dlg:charmap_title'] = 'Valitse erikoismerkki';
$string['advanced_dlg:charmap_usage'] = 'Käytä nuolia vasemmalle ja oikealle navigoidaksesi.';
$string['advanced_dlg:code_title'] = 'Tekstin muokkaus';
$string['advanced_dlg:code_wordwrap'] = 'Tekstin rivitys';
$string['advanced_dlg:colorpicker_color'] = 'Väri:';
$string['advanced_dlg:colorpicker_name'] = 'Nimi:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Nimetty';
$string['advanced_dlg:colorpicker_named_title'] = 'Nimetyt värit';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paletti';
$string['advanced_dlg:colorpicker_palette_title'] = 'Väripaletti';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Valitsin';
$string['advanced_dlg:colorpicker_picker_title'] = 'Värin valitsin';
$string['advanced_dlg:colorpicker_title'] = 'Valitse väri';
$string['advanced_dlg:image_align'] = 'Tasaus';
$string['advanced_dlg:image_align_baseline'] = 'Tekstin tasossa';
$string['advanced_dlg:image_align_bottom'] = 'Alas';
$string['advanced_dlg:image_align_left'] = 'Vasemmalle';
$string['advanced_dlg:image_align_middle'] = 'Keskelle';
$string['advanced_dlg:image_align_right'] = 'Oikealle';
$string['advanced_dlg:image_align_textbottom'] = 'Tekstin alaosaan';
$string['advanced_dlg:image_align_texttop'] = 'Tekstin yläosaan';
$string['advanced_dlg:image_align_top'] = 'Ylös';
$string['advanced_dlg:image_alt'] = 'Kuvan kuvaus';
$string['advanced_dlg:image_border'] = 'Reunus';
$string['advanced_dlg:image_dimensions'] = 'Mitat';
$string['advanced_dlg:image_hspace'] = 'Vaakasuuntainen tila';
$string['advanced_dlg:image_list'] = 'Kuvalista';
$string['advanced_dlg:image_src'] = 'Kuvan verkko-osoite';
$string['advanced_dlg:image_title'] = 'Lisää/muokkaa kuvaa';
$string['advanced_dlg:image_vspace'] = 'Pystysuuntainen tila';
$string['advanced_dlg:invalid_color_value'] = 'Virheellinen väriarvo';
$string['advanced_dlg:link_is_email'] = 'Antamasi osoite näyttää olevan sähköpostiosoite. Haluatko lisätä siihen mailto:-etuliitteen?';
$string['advanced_dlg:link_is_external'] = 'Antamasi osoite näyttää johtavan ulkopuoliselle sivustolle. Haluatko lisätä linkin eteen http://-etuliitteen? (suositus)';
$string['advanced_dlg:link_list'] = 'Linkkilista';
$string['advanced_dlg:link_target'] = 'Kohde';
$string['advanced_dlg:link_target_blank'] = 'Avaa linkki uuteen ikkunaan';
$string['advanced_dlg:link_target_same'] = 'Avaa linkki samassa ikkunassa';
$string['advanced_dlg:link_title'] = 'Lisää/muuta linkki';
$string['advanced_dlg:link_titlefield'] = 'Otsikko';
$string['advanced_dlg:link_url'] = 'Linkin verkko-osoite';
$string['advanced:dt'] = 'Määrittelyn ehto';
$string['advanced:fontdefault'] = 'Kirjasin';
$string['advanced:font_size'] = 'Kirjasinkoko';
$string['advanced:forecolor_desc'] = 'Valitse tekstin väri';
$string['advanced:h1'] = 'Otsikko 1';
$string['advanced:h2'] = 'Otsikko 2';
$string['advanced:h3'] = 'Otsikko 3';
$string['advanced:h4'] = 'Otsikko 4';
$string['advanced:h5'] = 'Otsikko 5';
$string['advanced:h6'] = 'Otsikko 6';
$string['advanced:help_desc'] = 'Ohje';
$string['advanced:help_shortcut'] = 'Näppäinyhdistelmällä ALT-F10 saat työkalupalkin, ALT-0 on ohje.';
$string['advanced:hr_desc'] = 'Lisää vaakasuora viiva';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Lisää/muuta kuva';
$string['advanced:image_props_desc'] = 'Kuvan ominaisuudet';
$string['advanced:indent_desc'] = 'Lisää sisennystä';
$string['advanced:italic_desc'] = 'Kursivoitu (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Keskitetty';
$string['advanced:justifyfull_desc'] = 'Tasattu';
$string['advanced:justifyleft_desc'] = 'Tasaus vasemmalle';
$string['advanced:justifyright_desc'] = 'Tasaus oikealle';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Lisää/muuta linkki';
$string['advanced:more_colors'] = 'Lisää värejä';
$string['advanced:newdocument'] = 'Haluatko varmasti tyhjentää kaiken sisällön?';
$string['advanced:newdocument_desc'] = 'Uusi tiedosto';
$string['advanced:numlist_desc'] = 'Lisää/poista järjestetty lista';
$string['advanced:outdent_desc'] = 'Vähennä sisennystä';
$string['advanced:paragraph'] = 'Kappale';
$string['advanced:paste_desc'] = 'Liitä';
$string['advanced:path'] = 'Polku';
$string['advanced:pre'] = 'Esimuotoiltu';
$string['advanced:redo_desc'] = 'Tee uudelleen (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Poista muotoilu';
$string['advanced:rich_text_area'] = 'Tekstinmuotoilualue';
$string['advanced:samp'] = 'Koodiesimerkki';
$string['advanced:striketrough_desc'] = 'Yliviivattu';
$string['advanced:style_select'] = 'Tyylit';
$string['advanced:sub_desc'] = 'Alaindeksi';
$string['advanced:sup_desc'] = 'Yläindeksi';
$string['advanced:toolbar'] = 'Kuvakepalkki';
$string['advanced:toolbar_focus'] = 'Siirry työkalukuvakkeisiin - Alt+Q, Siirry tekstieditoriin - Alt-Z, Siirry elementtipolkuun - Alt-X';
$string['advanced:underline_desc'] = 'Alleviivattu (Ctrl+U)';
$string['advanced:undo_desc'] = 'Peru (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Poista linkki';
$string['advanced:visualaid_desc'] = 'Näytä/piilota suuntaviivat/näkymättömät elementit';
$string['advhr:advhr_desc'] = 'Lisää vaakaviiva';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:noshade'] = 'Ei varjoa';
$string['advhr_dlg:size'] = 'Korkeus';
$string['advhr_dlg:width'] = 'Leveys';
$string['advhr_dlg:widthunits'] = 'Yksikköä';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage_dlg:align'] = 'Tasaus';
$string['advimage_dlg:align_baseline'] = 'Rivillä';
$string['advimage_dlg:align_bottom'] = 'Alhaalla';
$string['advimage_dlg:align_left'] = 'Vasemmalla';
$string['advimage_dlg:align_middle'] = 'Keskellä';
$string['advimage_dlg:align_right'] = 'Oikealla';
$string['advimage_dlg:align_textbottom'] = 'Teksti alhaalla';
$string['advimage_dlg:align_texttop'] = 'Teksti ylhäällä';
$string['advimage_dlg:align_top'] = 'Ylhäällä';
$string['advimage_dlg:alt'] = 'Kuvan kuvaus';
$string['advimage_dlg:alt_image'] = 'Vaihtoehtoinen kuva';
$string['advimage_dlg:border'] = 'Kehys';
$string['advimage_dlg:classes'] = 'Luokat';
$string['advimage_dlg:constrain_proportions'] = 'Säilytä mittasuhteet';
$string['advimage_dlg:dialog_title'] = 'Lisää/muokkaa kuvaa';
$string['advimage_dlg:dimensions'] = 'Mitat';
$string['advimage_dlg:example_img'] = 'Ulkoasun esikatselukuva';
$string['advimage_dlg:general'] = 'Yleiset';
$string['advimage_dlg:height'] = 'Korkeus';
$string['advimage_dlg:hspace'] = 'vaakasuora tila';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Kuvalista';
$string['advimage_dlg:langcode'] = 'Kielen koodi';
$string['advimage_dlg:langdir'] = 'Kielen suunta';
$string['advimage_dlg:list'] = 'Kuvalista';
$string['advimage_dlg:long_desc'] = 'Pitkän kuvauksen linkki';
$string['advimage_dlg:ltr'] = 'Vasemmalta oikealle';
$string['advimage_dlg:map'] = 'Kuvakartta';
$string['advimage_dlg:misc'] = 'Sekalaiset';
$string['advimage_dlg:missing_alt'] = 'Haluatko varmasti jatkaa lisäämättä kuvausta? Kuvauksen puuttuminen saattaa häiritä sellaisia, jotka käyttävät tekstipohjaista selainta tai ovat kytkeneet kuvien näkymisen pois päältä.';
$string['advimage_dlg:mouseout'] = 'mouseoutille';
$string['advimage_dlg:mouseover'] = 'mouseoverille';
$string['advimage_dlg:preview'] = 'Esikatselu';
$string['advimage_dlg:rtl'] = 'Oikealta vasemmalle';
$string['advimage_dlg:src'] = 'Kuvan verkko-osoite';
$string['advimage_dlg:style'] = 'Tyyli';
$string['advimage_dlg:swap_image'] = 'Vaihda kuva';
$string['advimage_dlg:tab_advanced'] = 'Edistynyt';
$string['advimage_dlg:tab_appearance'] = 'Näkyminen';
$string['advimage_dlg:tab_general'] = 'Yleiset';
$string['advimage_dlg:title'] = 'Otsikko';
$string['advimage_dlg:vspace'] = 'pystysuora tila';
$string['advimage_dlg:width'] = 'Leveys';
$string['advimage:image_desc'] = 'Lisää/muokkaa kuvaa';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink_dlg:accesskey'] = 'Pikanäppäin';
$string['advlink_dlg:advanced_props'] = 'Edistyneet asetukset';
$string['advlink_dlg:advanced_tab'] = 'Edistynyt';
$string['advlink_dlg:anchor_names'] = 'Ankkurit';
$string['advlink_dlg:classes'] = 'Luokat';
$string['advlink_dlg:encoding'] = 'Kohteen merkistökoodaus';
$string['advlink_dlg:event_props'] = 'Tapahtumat (events)';
$string['advlink_dlg:events_tab'] = 'Tapahtumat';
$string['advlink_dlg:general_props'] = 'Yleiset asetukset';
$string['advlink_dlg:general_tab'] = 'Yleiset';
$string['advlink_dlg:height'] = 'Korkeus';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Syöttämäsi verkko-osoite vaikuttaa olevan sähköpostiosoite. Haluatko lisätä mailto:-etuliitteen?';
$string['advlink_dlg:is_external'] = 'Syöttämäsi verkko-osoite vaikuttaa osoittavan Moodlen ulkopuolelle. Haluatko lisätä http://-etuliitteen?';
$string['advlink_dlg:langcode'] = 'Kielen koodi';
$string['advlink_dlg:langdir'] = 'Kielen suunta';
$string['advlink_dlg:link_list'] = 'Linkkilista';
$string['advlink_dlg:list'] = 'Linkkilista';
$string['advlink_dlg:ltr'] = 'Vasemmalta oikealle';
$string['advlink_dlg:mime'] = 'Kohteen MIME-tyyppi';
$string['advlink_dlg:popup'] = 'Javascript ponnahdusikkuna';
$string['advlink_dlg:popup_dependent'] = 'Riippuvainen (vain Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Näytä sijaintipalkki';
$string['advlink_dlg:popup_menubar'] = 'Näytä valikkopalkki';
$string['advlink_dlg:popup_name'] = 'Ikkunan nimi';
$string['advlink_dlg:popup_opts'] = 'Valinta';
$string['advlink_dlg:popup_position'] = 'Sijainti (X/Y)';
$string['advlink_dlg:popup_props'] = 'Ponnahdusikkunan asetukset';
$string['advlink_dlg:popup_resizable'] = 'Tee ikkunan koko muokattavaksi';
$string['advlink_dlg:popup_return'] = 'Lisää \'return false\'';
$string['advlink_dlg:popup_scrollbars'] = 'Näytä vierityspalkit';
$string['advlink_dlg:popup_size'] = 'Koko';
$string['advlink_dlg:popup_statusbar'] = 'Näytä tilapalkki';
$string['advlink_dlg:popup_tab'] = 'Ponnahdusikkuna';
$string['advlink_dlg:popup_toolbar'] = 'Näytä työkalut';
$string['advlink_dlg:popup_url'] = 'Ponnahdusikkunan verkko-osoite';
$string['advlink_dlg:rel'] = 'Sivun suhde kohteeseen';
$string['advlink_dlg:rev'] = 'Kohteen suhde sivuun';
$string['advlink_dlg:rtl'] = 'Oikealta vasemmalle';
$string['advlink_dlg:style'] = 'Tyyli';
$string['advlink_dlg:tabindex'] = 'Sarkainjärjestys';
$string['advlink_dlg:target'] = 'Kohde (target)';
$string['advlink_dlg:target_blank'] = 'Avaa uudessa ikkunassa';
$string['advlink_dlg:target_langcode'] = 'Kohteen kieli';
$string['advlink_dlg:target_name'] = 'Kohteen nimi';
$string['advlink_dlg:target_parent'] = 'Avaa ylemmässä ikkunassa';
$string['advlink_dlg:target_same'] = 'Avaa tässä ikkunassa';
$string['advlink_dlg:target_top'] = 'Avaa ylimmässä ruudussa (korvaa kaikki ruudut)';
$string['advlink_dlg:title'] = 'Lisää/muokkaa linkkiä';
$string['advlink_dlg:titlefield'] = 'Otsikko';
$string['advlink_dlg:url'] = 'Linkin verkko-osoite';
$string['advlink_dlg:width'] = 'Leveys';
$string['advlink:link_desc'] = 'Lisää/muokkaa linkkiä';
$string['advlist:circle'] = 'Ympyrä';
$string['advlist:def'] = 'Oletusarvo';
$string['advlist:disc'] = 'Levy';
$string['advlist:lower_alpha'] = 'Alempi alfa';
$string['advlist:lower_greek'] = 'Alempi kreikkalainen';
$string['advlist:lower_roman'] = 'Alempi roomalainen';
$string['advlist:square'] = 'Neliö';
$string['advlist:types'] = 'Tyypit';
$string['advlist:upper_alpha'] = 'Ylempi alfa';
$string['advlist:upper_roman'] = 'Ylempi roomalainen';
$string['aria:rich_text_area'] = 'Tekstinmuotoilualue';
$string['autosave:restore_content'] = 'Palauta automaattisesti tallennettu sisältö';
$string['autosave:unload_msg'] = 'Tekemäsi muutokset menetetään jos poistut tältä sivulta.';
$string['autosave:warning_message'] = 'Jos palautat tallennetun sisällön, menetät kaiken sisällön, joka on tällä hetkellä editorissa.

Oletko varma että haluat palauttaa tallennetun sisällön?';
$string['availablebuttons'] = 'Olemassa olevat painikkeet';
$string['colors:000000'] = 'Musta';
$string['colors:000080'] = 'Laivastonsininen';
$string['colors:0000FF'] = 'Sininen';
$string['colors:003300'] = 'Tummanvihreä';
$string['colors:003366'] = 'Asuurinsininen';
$string['colors:008000'] = 'Vihreä';
$string['colors:008080'] = 'Tumma turkoosi';
$string['colors:00CCFF'] = 'Taivaansininen';
$string['colors:00FF00'] = 'Lime';
$string['colors:00FFFF'] = 'Aqua';
$string['colors:333300'] = 'Tumma oliivi';
$string['colors:333333'] = 'Hyvin tumman harmaa';
$string['colors:333399'] = 'Indigonsininen';
$string['colors:3366FF'] = 'Kuninkaallisen sininen';
$string['colors:339966'] = 'Merenvihreä';
$string['colors:33CCCC'] = 'Turkoosi';
$string['colors:666699'] = 'Siniharmaa';
$string['colors:800000'] = 'Pähkinänruskea';
$string['colors:800080'] = 'Sinipunainen';
$string['colors:808000'] = 'Oliivi';
$string['colors:808080'] = 'Harmaa';
$string['colors:993300'] = 'Palanut oranssi';
$string['colors:993366'] = 'Ruskea';
$string['colors:999999'] = 'Keskiharmaa';
$string['colors:99CC00'] = 'Kellanvihreä';
$string['colors:99CCFF'] = 'Vaalea taivaansininen';
$string['colors:C0C0C0'] = 'Hopea';
$string['colors:CC99FF'] = 'Luumu';
$string['colors:CCFFCC'] = 'Vaaleanvihreä';
$string['colors:CCFFFF'] = 'Vaalea turkoosi';
$string['colors:FF0000'] = 'Punainen';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Oranssi';
$string['colors:FF9900'] = 'Meripihka';
$string['colors:FF99CC'] = 'Pinkki';
$string['colors:FFCC00'] = 'Kulta';
$string['colors:FFCC99'] = 'Persikka';
$string['colors:FFFF00'] = 'Keltainen';
$string['colors:FFFF99'] = 'Vaaleankeltainen';
$string['colors:FFFFFF'] = 'Valkoinen';
$string['common:apply'] = 'Käytä';
$string['common:browse'] = 'Selaa';
$string['common:cancel'] = 'Peruuta';
$string['common:class_name'] = 'Luokka';
$string['common:clipboard_msg'] = 'AKopioi-, Leikkaa- ja Liitä-toiminnot eivät ole käytettävissä Mozilla- ja Firefox-selaimilla. Haluatko lisätietoa tästä ongelmasta?';
$string['common:clipboard_no_support'] = 'Selaimesi ei ole tuettu, käytä sen sijaan näppäinoikoteitä.';
$string['common:close'] = 'Sulje';
$string['common:edit_confirm'] = 'Haluatko käyttää WYSIWYG-tilaa tässä tekstikentässä?';
$string['common:insert'] = 'Lisää';
$string['common:invalid_data'] = 'Virhe: Syötit virheellisiä arvoja, ne näkyvät punaisina.';
$string['common:invalid_data_min'] = 'kentän {#field} on oltava numero, joka on suurempi kuin {#min}';
$string['common:invalid_data_number'] = 'kentän {#field} on oltava numero';
$string['common:invalid_data_size'] = 'kentän {#field} on oltava numero tai prosenttiosuus';
$string['common:more_colors'] = 'Lisää värejä';
$string['common:not_set'] = '-- Ei määritetty --';
$string['common:popup_blocked'] = 'Sinulla on käytössäsi ohjelma, joka estää ponnahdusikkunoiden näytön. Sinun täytyy kytkeä ponnahdusikkunoiden esto pois päältä voidaksesi hyödyntää täysin tätä työkalua.';
$string['common:update'] = 'Päivitä';
$string['common:value'] = '(arvo)';
$string['contextmenu:align'] = 'Tasaus';
$string['contextmenu:center'] = 'Keskelle';
$string['contextmenu:full'] = 'Molemmille puolille';
$string['contextmenu:left'] = 'Vasemmalle';
$string['contextmenu:right'] = 'Oikealle';
$string['customconfig'] = 'Omat asetukset';
$string['customtoolbar'] = 'Editorin työkalupalkki';
$string['directionality:ltr_desc'] = 'Suunta vasemmalta oikealle';
$string['directionality:rtl_desc'] = 'Suunta oikealta vasemmalle';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Itku';
$string['emotions_dlg:desc'] = 'Hymiöt';
$string['emotions_dlg:embarassed'] = 'Nolostunut';
$string['emotions_dlg:foot_in_mouth'] = 'Jalka suussa';
$string['emotions_dlg:frown'] = 'Otsan rypistys';
$string['emotions_dlg:innocent'] = 'Viaton';
$string['emotions_dlg:kiss'] = 'Pusu';
$string['emotions_dlg:laughing'] = 'Nauru';
$string['emotions_dlg:money_mouth'] = 'Klink Klink (raha)';
$string['emotions_dlg:sealed'] = 'Tukittu';
$string['emotions_dlg:smile'] = 'Hymy';
$string['emotions_dlg:surprised'] = 'Yllättynyt';
$string['emotions_dlg:title'] = 'Lisää hymiö';
$string['emotions_dlg:tongue_out'] = 'Kieli ulkona';
$string['emotions_dlg:undecided'] = 'Päättämätön';
$string['emotions_dlg:usage'] = 'Käytä navigointiin nuolia oikealle ja vasemmalle';
$string['emotions_dlg:wink'] = 'Silmänisku';
$string['emotions_dlg:yell'] = 'Huuto';
$string['emotions:emotions_desc'] = 'Hymiöt';
$string['fontselectlist'] = 'Saatavilla olevien fonttien lista';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Tiedoston asetukset';
$string['fullpage_dlg:active_color'] = 'Aktiivinen väri';
$string['fullpage_dlg:add'] = 'Lisää uusi elementti';
$string['fullpage_dlg:add_base'] = 'Base-elementti';
$string['fullpage_dlg:add_comment'] = 'Yleinen elementti';
$string['fullpage_dlg:add_link'] = 'Linkkielementti';
$string['fullpage_dlg:add_meta'] = 'Meta-elementti';
$string['fullpage_dlg:add_script'] = 'Script-elementti';
$string['fullpage_dlg:add_style'] = 'Tyylielementti';
$string['fullpage_dlg:add_title'] = 'Otsikkoelementti';
$string['fullpage_dlg:advanced_props'] = 'Edistynyt';
$string['fullpage_dlg:advanced_tab'] = 'Edistynyt';
$string['fullpage_dlg:appearance_bgprops'] = 'Taustan asetukset';
$string['fullpage_dlg:appearance_linkprops'] = 'Linkkien värit';
$string['fullpage_dlg:appearance_marginprops'] = 'Body marginaalit';
$string['fullpage_dlg:appearance_style'] = 'Tyylitiedosto ja tyylin asetukset';
$string['fullpage_dlg:appearance_tab'] = 'Ulkoasu';
$string['fullpage_dlg:appearance_textprops'] = 'Tekstin asetukset';
$string['fullpage_dlg:author'] = 'Kirjoittaja';
$string['fullpage_dlg:base_element'] = 'Base-elementti';
$string['fullpage_dlg:bgcolor'] = 'Taustan väri';
$string['fullpage_dlg:bgimage'] = 'Taustakuva';
$string['fullpage_dlg:bottom_margin'] = 'Alamarginaali';
$string['fullpage_dlg:charset'] = 'Kirjasintyyppi';
$string['fullpage_dlg:comment_element'] = 'Kommentti';
$string['fullpage_dlg:content'] = 'Sisältö';
$string['fullpage_dlg:copyright'] = 'Copyright';
$string['fullpage_dlg:defer'] = 'Mukautuminen';
$string['fullpage_dlg:doctypes'] = 'Dokumenttityypit';
$string['fullpage_dlg:encoding'] = 'Tekstin koodaus';
$string['fullpage_dlg:fontface'] = 'Fontti';
$string['fullpage_dlg:font_face'] = 'Fontti';
$string['fullpage_dlg:fontsize'] = 'Fonttikoko';
$string['fullpage_dlg:font_size'] = 'Fonttikoko';
$string['fullpage_dlg:general_props'] = 'Yleinen';
$string['fullpage_dlg:head_elements'] = 'Pääelementti';
$string['fullpage_dlg:hover_color'] = 'Hover väri';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF lang';
$string['fullpage_dlg:info'] = 'Informaatio';
$string['fullpage_dlg:langcode'] = 'Kielen koodi';
$string['fullpage_dlg:langdir'] = 'Kielen suunta';
$string['fullpage_dlg:langprops'] = 'Kieli ja koodaus';
$string['fullpage_dlg:language'] = 'Kieli';
$string['fullpage_dlg:left_margin'] = 'Vasen marginaali';
$string['fullpage_dlg:link_color'] = 'Linkin väri';
$string['fullpage_dlg:link_element'] = 'Linkkielementti';
$string['fullpage_dlg:ltr'] = 'Vasemmalta oikealle';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'Kuvaus';
$string['fullpage_dlg:meta_element'] = 'Meta-elementti';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksoi ja seuraa linkkejä';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksoi, mutta älä seuraa linkkejä';
$string['fullpage_dlg:meta_keywords'] = 'Avainsanat';
$string['fullpage_dlg:meta_noindex_follow'] = 'Älä indeksoi, mutta seuraa linkkejä.';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Älä indeksoi, äläkä seuraa linkkejä';
$string['fullpage_dlg:meta_props'] = 'Meta tiedot';
$string['fullpage_dlg:meta_robots'] = 'Robotit';
$string['fullpage_dlg:meta_tab'] = 'Yleinen';
$string['fullpage_dlg:meta_title'] = 'Otsikko';
$string['fullpage_dlg:movedown'] = 'Siirrä valittua elementtiä alas';
$string['fullpage_dlg:moveup'] = 'Siirrä valittua elementtiä ylös';
$string['fullpage_dlg:name'] = 'Nimi';
$string['fullpage_dlg:properties'] = 'Asetukset';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Poista valittu elementti';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Oikea marginaali';
$string['fullpage_dlg:rtl'] = 'Oikealta vasemmalle';
$string['fullpage_dlg:script_element'] = 'Script-elementti';
$string['fullpage_dlg:src'] = 'Lähde';
$string['fullpage_dlg:style'] = 'Tyyli';
$string['fullpage_dlg:style_element'] = 'Tyylielementti';
$string['fullpage_dlg:stylesheet'] = 'Tyylitiedosto';
$string['fullpage_dlg:target'] = 'Kohde';
$string['fullpage_dlg:textcolor'] = 'Väri';
$string['fullpage_dlg:text_color'] = 'Tekstin väri';
$string['fullpage_dlg:title'] = 'Tiedoston asetukset';
$string['fullpage_dlg:title_element'] = 'Otsikkoelementti';
$string['fullpage_dlg:top_margin'] = 'Ylämarginaali';
$string['fullpage_dlg:type'] = 'Tyyppi';
$string['fullpage_dlg:value'] = 'Arvo';
$string['fullpage_dlg:visited_color'] = 'Vierailtu väri';
$string['fullpage_dlg:xml_pi'] = 'XML Ilmoitus';
$string['fullscreen:desc'] = 'Kokoruututila';
$string['iespell:download'] = 'ieSpell-ohjelmaa ei havaittu. Haluatko asentaa sen nyt?';
$string['iespell:iespell_desc'] = 'Oikeinkirjoituksen tarkistus';
$string['insertdatetime:date_fmt'] = '%d.%m.%Y';
$string['insertdatetime:day_long'] = 'sunnuntai,maanantai,tiistai,keskiviikko,torstai,perjantai,lauantai,sunnuntai';
$string['insertdatetime:day_short'] = 'su,ma,ti,ke,to,pe,la,su';
$string['insertdatetime:insertdate_desc'] = 'Lisää päivämäärä';
$string['insertdatetime:inserttime_desc'] = 'Lisää kellonaika';
$string['insertdatetime:months_long'] = 'Tammikuu,Helmikuu,Maaliskuu,Huhtikuu,Toukokuu,Kesäkuu,Heinäkuu,Elokuu,Syyskuu,Lokakuu,Marraskuu,Joulukuu';
$string['insertdatetime:months_short'] = 'Tammi,Helmi,Maalis,Huhti,Touko,Kesä,Heinä,Elo,Syys,Loka,Marras,Joulu';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Absoluuttinen sijainti';
$string['layer:backward_desc'] = 'Siirrä taaksepäin';
$string['layer:content'] = 'Uusi taso...';
$string['layer:forward_desc'] = 'Siirrä eteenpäin';
$string['layer:insertlayer_desc'] = 'Lisää uusi taso';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Lisää/muokkaa upotettua mediaa';
$string['media_dlg:advanced'] = 'Edistyneet';
$string['media_dlg:align'] = 'Tasaus';
$string['media_dlg:align_bottom'] = 'Alhaalla';
$string['media_dlg:align_bottom_left'] = 'Ala-vasemmalla';
$string['media_dlg:align_bottom_right'] = 'Ala-oikealla';
$string['media_dlg:align_center'] = 'Keskellä';
$string['media_dlg:align_left'] = 'Vasemmalla';
$string['media_dlg:align_right'] = 'Oikealla';
$string['media_dlg:align_top'] = 'Ylhäällä';
$string['media_dlg:align_top_left'] = 'Ylä-vasemmalla';
$string['media_dlg:align_top_right'] = 'Ylä-oikealla';
$string['media_dlg:altsource1'] = 'Vaihtoehtoinen lähde 1';
$string['media_dlg:altsource2'] = 'Vaihtoehtoinen lähde 2';
$string['media_dlg:autogotourl'] = 'Mene automaattisesti verkko-osoitteeseen';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Automaattinen aloitus';
$string['media_dlg:balance'] = 'Tasapaino';
$string['media_dlg:base'] = 'Perusta';
$string['media_dlg:baseurl'] = 'Perusosoite';
$string['media_dlg:bgcolor'] = 'Tausta';
$string['media_dlg:cache'] = 'Välimuisti';
$string['media_dlg:captioningid'] = 'Otsikointi-id';
$string['media_dlg:center'] = 'Keskitä';
$string['media_dlg:class_name'] = 'Luokka';
$string['media_dlg:console'] = 'Konsolie';
$string['media_dlg:constrain_proportions'] = 'Säilytä mittasuhteet';
$string['media_dlg:controller'] = 'Ohjain';
$string['media_dlg:controls'] = 'Kontrollit';
$string['media_dlg:correction'] = 'Ei korjausta';
$string['media_dlg:currentmarker'] = 'Tämänhetkinen merkki';
$string['media_dlg:currentposition'] = 'Tämänhetkinen sijainti';
$string['media_dlg:defaultframe'] = 'Oletusruutu';
$string['media_dlg:embeddedaudio'] = 'Upotettu äänitiedosto';
$string['media_dlg:embedded_audio_options'] = 'Upotetun äänitiedoston asetukset';
$string['media_dlg:enabled'] = 'Päällä';
$string['media_dlg:enablejavascript'] = 'Salli JavaScript';
$string['media_dlg:endtime'] = 'Lopetusaika';
$string['media_dlg:file'] = 'Tiedosto/verkko-osoite';
$string['media_dlg:flash_options'] = 'Flashin asetukset';
$string['media_dlg:flashvars'] = 'Flash-muuttujat';
$string['media_dlg:fullscreen'] = 'Koko näyttö';
$string['media_dlg:general'] = 'Yleiset';
$string['media_dlg:hidden'] = 'Piilotettu';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Vaakatason tila';
$string['media_dlg:html5_audio_options'] = 'Ääniasetukset';
$string['media_dlg:html5_video_options'] = 'HTML5 videoasetukset';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:imagestatus'] = 'Kuvan tila';
$string['media_dlg:invokeurls'] = 'Kutsu verkko-osoitteet';
$string['media_dlg:kioskmode'] = 'Kioskitila';
$string['media_dlg:list'] = 'Lista';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Silmukka';
$string['media_dlg:maintainaspect'] = 'Säilytä kuvasuhde';
$string['media_dlg:menu'] = 'Näytä valikko';
$string['media_dlg:mute'] = 'Hiljennys';
$string['media_dlg:name'] = 'Nimi';
$string['media_dlg:nojava'] = 'Ei Javaa';
$string['media_dlg:numloop'] = 'Toistojen määrä';
$string['media_dlg:play'] = 'Automaattinen toisto';
$string['media_dlg:playcount'] = 'Toistolaskin';
$string['media_dlg:playeveryframe'] = 'Toista jokainen ruutu';
$string['media_dlg:poster'] = 'Posteri';
$string['media_dlg:prefetch'] = 'Esinouda';
$string['media_dlg:preload'] = 'Esikatsele video';
$string['media_dlg:preload_auto'] = 'Anna selaimen valita';
$string['media_dlg:preload_metadata'] = 'Esikatsele videon metadata';
$string['media_dlg:preload_none'] = 'Älä esikatsele';
$string['media_dlg:preview'] = 'Esikatselu';
$string['media_dlg:progress'] = 'Eteneminen';
$string['media_dlg:qt_options'] = 'Quicktimen asetukset';
$string['media_dlg:qtsrc'] = 'QT source';
$string['media_dlg:qtsrcchokespeed'] = 'Choke-nopeus';
$string['media_dlg:qt_stream_warn'] = 'Streamatut rtsp-resurssit tulisi lisätä QT Src -kenttään edistynyt-välilehdelle.nSinun kannattaa lisätä myös ei-streamattu versio Src-kenttään.';
$string['media_dlg:quality'] = 'Laatu';
$string['media_dlg:rate'] = 'Rate';
$string['media_dlg:rmp_options'] = 'Real media playerin asetukset';
$string['media_dlg:salign'] = 'SAlign';
$string['media_dlg:scale'] = 'Skaala';
$string['media_dlg:scriptcallbacks'] = 'Skriptin takaisinkutsut';
$string['media_dlg:shockwave_options'] = 'Shockwaven asetukset';
$string['media_dlg:shuffle'] = 'Sekoita';
$string['media_dlg:size'] = 'Mitat';
$string['media_dlg:sound'] = 'Ääni';
$string['media_dlg:source'] = 'Lähde';
$string['media_dlg:starttime'] = 'Aloitusaika';
$string['media_dlg:stretchtofit'] = 'Venytä sopimaan';
$string['media_dlg:swstretchhalign'] = 'Venytä horisontaalisesti';
$string['media_dlg:swstretchstyle'] = 'Venytystyyli';
$string['media_dlg:swstretchvalign'] = 'Venytä vertikaalisesti';
$string['media_dlg:target'] = 'Kohde';
$string['media_dlg:targetcache'] = 'Kohteen välimuisti';
$string['media_dlg:title'] = 'Lisää/muokkaa upotettua mediaa';
$string['media_dlg:type'] = 'Tyyppi';
$string['media_dlg:uimode'] = 'UI-moodi';
$string['media_dlg:volume'] = 'Äänen voimakkuus';
$string['media_dlg:vspace'] = 'Pystytason tila';
$string['media_dlg:windowlessvideo'] = 'Ikkunaton video';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Windows media playerin asetukset';
$string['media:edit'] = 'Muokkaa upotettua mediaa';
$string['nonbreaking:nonbreaking_desc'] = 'Lisää tyhjä merkki (nbsp)';
$string['pagebreak:desc'] = 'Lisää sivunvaihto';
$string['paste_dlg:text_linebreaks'] = 'Säilytä rivinvaihdot';
$string['paste_dlg:text_title'] = 'Liitä sisältö ikkunaan näppäinyhdistelmällä Ctrl+v.';
$string['paste_dlg:word_title'] = 'Liitä sisältö ikkunaan näppäinyhdistelmällä Ctrl+v.';
$string['paste:paste_text_desc'] = 'Liitä pelkkänä tekstinä';
$string['paste:paste_word_desc'] = 'Liitä Wordistä';
$string['paste:plaintext_mode'] = 'Sisällön liittäminen on nyt tilassa, jossa liitetään pelkkää tekstiä. Vaihda takaisin monipuolisempaan perustilaan klikkaamalla uudestaan. Kun olet liittänyt sisältöä, palaat takaisin perustilaan.';
$string['paste:plaintext_mode_stick'] = 'Sisällön liittäminen on nyt tilassa, jossa liitetään pelkkää tekstiä. Vaihda takaisin monipuolisempaan perustilaan klikkaamalla uudestaan.';
$string['paste:selectall_desc'] = 'Valitse kaikki';
$string['pluginname'] = 'TinyMCE HTML-editori';
$string['preview:preview_desc'] = 'Esikatselu';
$string['print:print_desc'] = 'Tulosta';
$string['save:cancel_desc'] = 'Peruuta kaikki muutokset';
$string['save:save_desc'] = 'Tallenna';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace_dlg:allreplaced'] = 'Kaikki löydetyt merkkijonot korvattiin.';
$string['searchreplace_dlg:direction'] = 'Suunta';
$string['searchreplace_dlg:down'] = 'Alas';
$string['searchreplace_dlg:findnext'] = 'Etsi seuraavaa';
$string['searchreplace_dlg:findwhat'] = 'Etsitään';
$string['searchreplace_dlg:mcase'] = 'Huomioi isot ja pienet kirjaimet';
$string['searchreplace_dlg:notfound'] = 'Haku on valmis. Haettua tekstiä ei löytynyt.';
$string['searchreplace_dlg:replace'] = 'Korvaa';
$string['searchreplace_dlg:replaceall'] = 'Korvaa kaikki';
$string['searchreplace_dlg:replace_title'] = 'Etsi ja korvaa';
$string['searchreplace_dlg:replacewith'] = 'Korvataan';
$string['searchreplace_dlg:searchnext_desc'] = 'Etsi uudestaan';
$string['searchreplace_dlg:search_title'] = 'Haku';
$string['searchreplace_dlg:up'] = 'Ylös';
$string['searchreplace:replace_desc'] = 'Etsi ja korvaa';
$string['searchreplace:search_desc'] = 'Etsi';
$string['settings'] = 'Yleiset asetukset';
$string['simple:bold_desc'] = 'Lihavointi (Ctrl+B)';
$string['simple:bullist_desc'] = 'Lisää/poista järjestämätön lista';
$string['simple:cleanup_desc'] = 'Siisti sekainen koodi';
$string['simple:italic_desc'] = 'Kursivointi (Ctrl+I)';
$string['simple:numlist_desc'] = 'Lisää/poista järjestetty lista';
$string['simple:redo_desc'] = 'Tee uudestaan (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Yliviivaus';
$string['simple:underline_desc'] = 'Alleviivaus (Ctrl+U)';
$string['simple:undo_desc'] = 'Peru (Ctrl+Z)';
$string['spellchecker:desc'] = 'Oikeinkirjoituksen tarkistus';
$string['spellchecker:ignore_word'] = 'Ohita sana';
$string['spellchecker:ignore_words'] = 'Ohita kaikki';
$string['spellchecker:langs'] = 'Kielet';
$string['spellchecker:menu'] = 'Oikeinkirjoituksen asetukset';
$string['spellchecker:no_mpell'] = 'Virheitä ei löytynyt.';
$string['spellchecker:no_sug'] = 'Ei ehdotuksia';
$string['spellchecker:sug'] = 'Ehdotukset';
$string['spellchecker:wait'] = 'Odota ole hyvä...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Muokkaa CSS-tyylejä';
$string['style_dlg:apply'] = 'Käytä';
$string['style_dlg:background'] = 'Tausta';
$string['style_dlg:background_attachment'] = 'Liite';
$string['style_dlg:background_color'] = 'Taustaväri';
$string['style_dlg:background_hpos'] = 'Vaaka-asettelu';
$string['style_dlg:background_image'] = 'Taustakuva';
$string['style_dlg:background_repeat'] = 'Toistuvuus';
$string['style_dlg:background_tab'] = 'Tausta';
$string['style_dlg:background_vpos'] = 'Pystyasettelu';
$string['style_dlg:block'] = 'Lohko';
$string['style_dlg:block_display'] = 'Näyttö';
$string['style_dlg:block_letterspacing'] = 'Kirjainten välistys';
$string['style_dlg:block_tab'] = 'Palkki';
$string['style_dlg:block_text_align'] = 'Tekstin asettelu';
$string['style_dlg:block_text_indent'] = 'Tekstin sisennys';
$string['style_dlg:block_vertical_alignment'] = 'Pystyasettelu';
$string['style_dlg:block_whitespace'] = 'Tyhjä tila';
$string['style_dlg:block_wordspacing'] = 'Sanojen välistys';
$string['style_dlg:border'] = 'Reunaviiva';
$string['style_dlg:border_tab'] = 'Kehys';
$string['style_dlg:bottom'] = 'Alhaalla';
$string['style_dlg:box'] = 'Kenttä';
$string['style_dlg:box_clear'] = 'Nollaus';
$string['style_dlg:box_float'] = 'Kellunta';
$string['style_dlg:box_height'] = 'Korkeus';
$string['style_dlg:box_tab'] = 'Laatikko';
$string['style_dlg:box_width'] = 'Leveys';
$string['style_dlg:bullet_image'] = 'Listauskuva';
$string['style_dlg:clip'] = 'Leike';
$string['style_dlg:color'] = 'Väri';
$string['style_dlg:height'] = 'Korkeus';
$string['style_dlg:left'] = 'Vasemmalla';
$string['style_dlg:list'] = 'Lista';
$string['style_dlg:list_tab'] = 'Lista';
$string['style_dlg:list_type'] = 'Tyyppi';
$string['style_dlg:margin'] = 'Marginaali';
$string['style_dlg:overflow'] = 'Ylivuoto';
$string['style_dlg:padding'] = 'Tyhjä tila';
$string['style_dlg:placement'] = 'Sijoittelu';
$string['style_dlg:position'] = 'Sijainti';
$string['style_dlg:positioning_tab'] = 'Sijainti';
$string['style_dlg:positioning_type'] = 'Tyyppi';
$string['style_dlg:right'] = 'Oikealla';
$string['style_dlg:same'] = 'Sama kaikille';
$string['style_dlg:style'] = 'Tyyli';
$string['style_dlg:text'] = 'Teksti';
$string['style_dlg:text_blink'] = 'Välähdys';
$string['style_dlg:text_case'] = 'Isot/pienet kirjaimet';
$string['style_dlg:text_color'] = 'Väri';
$string['style_dlg:text_decoration'] = 'Koristelu';
$string['style_dlg:text_font'] = 'Kirjasin';
$string['style_dlg:text_lineheight'] = 'Rivin korkeus';
$string['style_dlg:text_none'] = 'ei mitään';
$string['style_dlg:text_overline'] = 'Ylleviivattu';
$string['style_dlg:text_props'] = 'Teksti';
$string['style_dlg:text_size'] = 'Koko';
$string['style_dlg:text_striketrough'] = 'Yliviivattu';
$string['style_dlg:text_style'] = 'Tyyli';
$string['style_dlg:text_tab'] = 'Teksti';
$string['style_dlg:text_underline'] = 'Alleviivattu (Ctrl+U)';
$string['style_dlg:text_variant'] = 'Variantti';
$string['style_dlg:text_weight'] = 'Paino';
$string['style_dlg:title'] = 'Muokkaa CSS-tyyliä';
$string['style_dlg:toggle_insert_span'] = '';
$string['style_dlg:top'] = 'Ylhäällä';
$string['style_dlg:visibility'] = 'Näkyvyys';
$string['style_dlg:width'] = 'Leveys';
$string['style_dlg:zindex'] = 'Z-indeksi';
$string['subplugintype_tinymce_plural'] = 'Lisäosat';
$string['table:cell'] = 'Solu';
$string['table:cell_desc'] = 'Taulukon solun asetukset';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '80';
$string['table:col'] = 'Sarake';
$string['table:col_after_desc'] = 'Lisää sarake jälkeen';
$string['table:col_before_desc'] = 'Lisää sarake ennen';
$string['table:copy_row_desc'] = 'Kopioi taulukon rivi';
$string['table:cut_row_desc'] = 'Leikkaa taulukon rivi';
$string['table:del'] = 'Poista taulukko';
$string['table:delete_col_desc'] = 'Poista sarake';
$string['table:delete_row_desc'] = 'Poista rivi';
$string['table:desc'] = 'Lisää taulukko/muokkaa sitä';
$string['table_dlg:advanced_props'] = 'Edistyneet asetukset';
$string['table_dlg:advanced_tab'] = 'Edistynyt';
$string['table_dlg:align'] = 'Tasaus';
$string['table_dlg:align_bottom'] = 'Alas';
$string['table_dlg:align_default'] = 'Oletus';
$string['table_dlg:align_left'] = 'Vasen';
$string['table_dlg:align_middle'] = 'Keskitetty';
$string['table_dlg:align_right'] = 'Oikea';
$string['table_dlg:align_top'] = 'Ylös';
$string['table_dlg:bgcolor'] = 'Taustan väri';
$string['table_dlg:bgimage'] = 'Taustakuva';
$string['table_dlg:border'] = 'Kehys';
$string['table_dlg:bordercolor'] = 'Kehyksen väri';
$string['table_dlg:caption'] = 'Taulukon seloste';
$string['table_dlg:cell_all'] = 'Päivitä kaikki taulukon solut';
$string['table_dlg:cell_cell'] = 'Päivitä solu';
$string['table_dlg:cell_col'] = 'Päivitä kaikki sarakkeen solut';
$string['table_dlg:cell_limit'] = 'Olet ylittänyt suurimman sallitun määrän soluja {$cells}.';
$string['table_dlg:cellpadding'] = 'Solun reunus';
$string['table_dlg:cell_row'] = 'Päivitä kaikki rivin solut';
$string['table_dlg:cellspacing'] = 'Solun välitys';
$string['table_dlg:cell_title'] = 'Taulukon solun asetukset';
$string['table_dlg:cell_type'] = 'Solun tyyppi';
$string['table_dlg:colgroup'] = 'Sarakeryhmä';
$string['table_dlg:col_limit'] = 'Olet ylittänyt suurimman sallitun määrän sarakkeita {$cols}.';
$string['table_dlg:cols'] = 'Sarakkeet';
$string['table_dlg:frame'] = 'kehys';
$string['table_dlg:frame_all'] = 'kaikki';
$string['table_dlg:frame_cols'] = 'sarakkeet';
$string['table_dlg:frame_groups'] = 'ryhmät';
$string['table_dlg:frame_none'] = 'ei mitään';
$string['table_dlg:frame_rows'] = 'rivit';
$string['table_dlg:general_props'] = 'Yleiset asetukset';
$string['table_dlg:general_tab'] = 'Yleiset';
$string['table_dlg:height'] = 'Korkeus';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Kielen koodi';
$string['table_dlg:langdir'] = 'Kielen suunta';
$string['table_dlg:ltr'] = 'Vasemmalta oikealle';
$string['table_dlg:merge_cells_title'] = 'Yhdistä taulukon solut';
$string['table_dlg:mime'] = 'Kohteen MIME-tyyppi';
$string['table_dlg:missing_scope'] = 'Haluatko varmasti jatkaa määrittämättä tilaa tälle taulukon otsakesolulle? Ilman sitä joidenkin käyttäjien voi olla vaikea ymmärtää taulukon sisältämää informaatiota.';
$string['table_dlg:row_all'] = 'Päivitä kaikki taulukon rivit';
$string['table_dlg:row_even'] = 'Päivitä taulukon parilliset rivit';
$string['table_dlg:rowgroup'] = 'Riviryhmä';
$string['table_dlg:row_limit'] = 'Olet ylittänyt suurimman sallitun määrän rivejä {$rows}.';
$string['table_dlg:row_odd'] = 'Päivitä taulukon parittomat rivit';
$string['table_dlg:row_row'] = 'Päivitä rivi';
$string['table_dlg:rows'] = 'Rivit';
$string['table_dlg:row_title'] = 'Taulukon rivin asetukset';
$string['table_dlg:rowtype'] = 'Rivityyppi';
$string['table_dlg:rtl'] = 'Oikealta vasemmalle';
$string['table_dlg:rules'] = 'Säännöt';
$string['table_dlg:rules_above'] = 'yläpuoli';
$string['table_dlg:rules_below'] = 'alapuoli';
$string['table_dlg:rules_border'] = 'kehys';
$string['table_dlg:rules_box'] = 'laatikko';
$string['table_dlg:rules_hsides'] = 'vaakasuorat reunat';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'tyhjä';
$string['table_dlg:rules_vsides'] = 'pystysuorat reunat';
$string['table_dlg:scope'] = 'Tila';
$string['table_dlg:style'] = 'Tyyli';
$string['table_dlg:summary'] = 'Yhteenveto';
$string['table_dlg:tbody'] = 'Taulukon runko';
$string['table_dlg:td'] = 'Tietue';
$string['table_dlg:tfoot'] = 'Alatunniste';
$string['table_dlg:th'] = 'Otsake';
$string['table_dlg:thead'] = 'Ylätunniste';
$string['table_dlg:title'] = 'Lisää/muokkaa taulukkoa';
$string['table_dlg:valign'] = 'Pystysuunnan tasaus';
$string['table_dlg:width'] = 'Leveys';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Yhdistä taulukon solut';
$string['table:paste_row_after_desc'] = 'Liitä taulukon rivi jälkeen';
$string['table:paste_row_before_desc'] = 'Liitä taulukon rivi ennen';
$string['table:props_desc'] = 'Taulukon asetukset';
$string['table:row'] = 'Rivi';
$string['table:row_after_desc'] = 'Lisää rivi jälkeen';
$string['table:row_before_desc'] = 'Lisää rivi ennen';
$string['table:row_desc'] = 'Taulukon rivin asetukset';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Jaa yhdistetyt taulukon solut';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['template:desc'] = 'Lisää esimääritettyä sivupohjasisältöä';
$string['template_dlg:cdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:day_long'] = 'sunnuntai,maanantai,tiistai,keskiviikko,torstai,perjantai,lauantai,sunnuntai';
$string['template_dlg:day_short'] = 'su,ma,ti,ke,to,pe,la,su';
$string['template_dlg:desc'] = 'Lisää esimääritettyä sivupohjasisältöä';
$string['template_dlg:desc_label'] = 'Kuvaus';
$string['template_dlg:label'] = 'Sivupohja';
$string['template_dlg:mdate_format'] = '%d.%m.%Y %H:%M:%S';
$string['template_dlg:months_long'] = 'Tammikuu,Helmikuu,Maaliskuu,Huhtikuu,Toukokuu,Kesäkuu,Heinäkuu,Elokuu,Syyskuu,Lokakuu,Marraskuu,Joulukuu';
$string['template_dlg:months_short'] = 'Tammi,Helmi,Maalis,Huhti,Touko,Kesä,Heinä,Elo,Syys,Loka,Marras,Joulu';
$string['template_dlg:preview'] = 'Esikatselu';
$string['template_dlg:select'] = 'Valitse sivupohja';
$string['template_dlg:title'] = 'Sivupohjat';
$string['template_dlg:warning'] = 'Varoitus: Sivupohjan päivittäminen toisella saattaa aiheuttaa tiedon menetyksen.';
$string['visualblocks:desc'] = 'Näytä/piilota lohkon sisältö';
$string['visualchars:desc'] = 'Näytä/piilota muotoilumerkit.';
$string['wordcount:words'] = 'Sanoja:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Lyhenne';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Kirjainlyhenne';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Lisää/muokkaa attribuutteja';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Sitaatti';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Poisto';
$string['xhtmlxtras_dlg:attribs_title'] = 'Lisää/muokkaa attribuutteja';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Attribuutit';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Attribuutit';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Tapahtumat';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'AccessKey';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Sitaatti';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Luokka';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Päivä/aika';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Kieli';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Tekstin suunta';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Tyyli';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'TabIndex';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Otsikko';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Vasemmalta oikealle';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Oikealta vasemmalle';
$string['xhtmlxtras_dlg:events_tab'] = 'Tapahtumat';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elementin attribuutit';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elementin tapahtumat';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Yleiset asetukset';
$string['xhtmlxtras_dlg:general_tab'] = 'Yleiset';
$string['xhtmlxtras_dlg:insert_date'] = 'Lisää tämänhetkinen päivä/aika';
$string['xhtmlxtras_dlg:option_ltr'] = 'Vasemmalta oikealle';
$string['xhtmlxtras_dlg:option_rtl'] = 'Oikealta vasemmalle';
$string['xhtmlxtras_dlg:remove'] = 'Poista';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Lyhenne-elementti';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Kirjainlyhenne-elementti';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Sitaatti-elementti';
$string['xhtmlxtras_dlg:title_del_element'] = 'Poisto-elementti';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Lisäys-elementti';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Lisäys';
