<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'cs', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'připraveno k instalaci';
$string['action'] = 'Akce';
$string['actionchoice'] = 'Co chcete dělat se souborem "{$a}"?';
$string['actions'] = 'Akce';
$string['active'] = 'Aktivní';
$string['activeusers'] = 'Aktivní uživatelé';
$string['activities'] = 'Činnosti';
$string['activities_help'] = 'Činnosti, jako jsou fóra, testy a wiki, umožňují vkládat do kurzu interaktivní obsah.';
$string['activity'] = 'Činnost';
$string['activityclipboard'] = 'Přesun činnosti: {$a}';
$string['activityiscurrentlyhidden'] = 'Bohužel, tato činnost je momentálně skrytá';
$string['activitymodule'] = 'Modul činnosti';
$string['activitymodules'] = 'Moduly činností';
$string['activityreport'] = 'Sestava o činnosti';
$string['activityreports'] = 'Sestavy o činnosti';
$string['activityselect'] = 'Vybrat tuto činnost k přesunu';
$string['activitysince'] = 'Výpis od {$a}';
$string['activityweighted'] = 'Výpis podle uživatele';
$string['add'] = 'Přidat';
$string['addactivity'] = 'Přidat činnost...';
$string['addactivitytosection'] = 'Přidat činnost do sekce "{$a}"';
$string['addadmin'] = 'Přidat správce';
$string['addblock'] = 'Přidat blok';
$string['addcomment'] = 'Přidat komentář...';
$string['addcountertousername'] = 'Vytvořit uživatele a přidat číslo k uživatelskému jménu';
$string['addcreator'] = 'Přidat tvůrce kurzů';
$string['adddots'] = 'Přidat...';
$string['added'] = 'Přidána činnost ({$a})';
$string['addedrecip'] = 'Přidán {$a} nový příjemce';
$string['addedrecips'] = 'Přidáno nových příjemců: {$a}';
$string['addedtogroup'] = 'Přidán do skupiny {$a}';
$string['addedtogroupnot'] = 'Nepřidán do skupiny {$a}';
$string['addedtogroupnotenrolled'] = 'Nepřidán do skupiny {$a}, protože není zapsán do kurzu';
$string['addfilehere'] = 'Přidat soubor';
$string['addinganew'] = 'Přidání nové činnosti ({$a})';
$string['addinganewto'] = 'Přidání nové činnosti ({$a->what} - {$a->to})';
$string['addingdatatoexisting'] = 'Přidání údajů ke stávajícím';
$string['additionalnames'] = 'Další jména';
$string['addlinkhere'] = 'Přidat odkaz';
$string['addnewcategory'] = 'Přidat novou kategorii';
$string['addnewcourse'] = 'Přidat nový kurz';
$string['addnewuser'] = 'Přidat nového uživatele';
$string['addnousersrecip'] = 'Přidat na seznam příjemců uživatele, kteří si ještě neotevřeli toto {$a}';
$string['addpagehere'] = 'Přidat text';
$string['addresource'] = 'Přidat studijní materiál...';
$string['addresourceoractivity'] = 'Přidat činnost nebo studijní materiál';
$string['addresourcetosection'] = 'Přidat materiál do sekce "{$a}"';
$string['address'] = 'Adresa';
$string['addstudent'] = 'Přidat studenta';
$string['addsubcategory'] = 'Přidat podkategorii';
$string['addteacher'] = 'Přidat učitele';
$string['admin'] = 'Správa';
$string['adminhelpaddnewuser'] = 'Manuální vytvoření nového uživatelského účtu';
$string['adminhelpassignadmins'] = 'Správci mají kamkoliv přístup a mohou provádět nastavení systému';
$string['adminhelpassigncreators'] = 'Tvůrci mohou zakládat nové kurzy';
$string['adminhelpassignsiteroles'] = 'Aplikovat definované role pro website na konkrétní uživatele';
$string['adminhelpassignstudents'] = 'Vstupte do kurzu, v nabídce Správa vyberte položku Studenti a zapište je';
$string['adminhelpauthentication'] = 'Způsob vytváření a autorizace uživatelů';
$string['adminhelpbackup'] = 'Nastavení automatického zálohování a jeho časový plán';
$string['adminhelpconfiguration'] = 'Nastavte, jak budou stránky vypadat a pracovat';
$string['adminhelpconfigvariables'] = 'Obecné parametry ovlivňující funkci systému';
$string['adminhelpcourses'] = 'Seznam dostupných kurzů a kategorií, úprava kurzů čekajících na schválení';
$string['adminhelpeditorsettings'] = 'Základní nastavení HTML editoru';
$string['adminhelpedituser'] = 'Úpravy uživatelských účtů (seznam všech účtů)';
$string['adminhelpenvironment'] = 'Kontrola stávajících a budoucích požadavků na váš server';
$string['adminhelpfailurelogs'] = 'Zobrazit protokol o neúspěšných přihlášeních';
$string['adminhelplanguage'] = 'Kontrola a úpravy instalovaných lokalizací';
$string['adminhelplogs'] = 'Procházet protokol o činnosti na stránkách';
$string['adminhelpmanageblocks'] = 'Správa nainstalovaných bloků a jejich nastavení';
$string['adminhelpmanagedatabase'] = 'Přímý přístup do databáze (hlavně opatrně!)';
$string['adminhelpmanagefilters'] = 'Správa textových filtrů a jejich nastavení';
$string['adminhelpmanagemodules'] = 'Správa nainstalovaných modulů a jejich nastavení';
$string['adminhelpmanageroles'] = 'Vytvořit a definovat role, které lze aplikovat na uživatele.';
$string['adminhelpmymoodle'] = 'Nastavení uživatelských bloků "Můj Moodle"';
$string['adminhelpreports'] = 'Sestavy na úrovni celých stránek';
$string['adminhelpsitefiles'] = 'Obecně použitelné soubory a místo pro upload externích záloh';
$string['adminhelpsitesettings'] = 'Nastavení vzhledu titulní stránky';
$string['adminhelpstickyblocks'] = 'Nastavení povinných bloků';
$string['adminhelpthemes'] = 'Nastavení vzhledu stránek (barvy, fonty apod.)';
$string['adminhelpuploadusers'] = 'Import uživatelských účtů z textového souboru';
$string['adminhelpusers'] = 'Správa uživatelů a nastavení autentizace';
$string['adminhelpxmldbeditor'] = 'Rozhraní pro úpravu XMLDB souborů. Jen pro vývojáře.';
$string['administration'] = 'Správa';
$string['administrationsite'] = 'Správa stránek';
$string['administrator'] = 'Správce';
$string['administratordescription'] = 'Správci obvykle mohou na stránkách dělat cokoli a ve všech kurzech.';
$string['administrators'] = 'Správci';
$string['administratorsall'] = 'Všichni správci';
$string['administratorsandteachers'] = 'Správci a učitelé';
$string['advanced'] = 'Pokročilé';
$string['advancedfilter'] = 'Pokročilé hledání';
$string['advancedsettings'] = 'Pokročilá nastavení';
$string['afterresource'] = 'Za materiál  "{$a}"';
$string['aftersection'] = 'Za sekci  "{$a}"';
$string['again'] = 'znovu';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX a Javascript';
$string['all'] = 'Vše';
$string['allactions'] = 'Všechny akce';
$string['allactivities'] = 'Všechny činnosti';
$string['allcategories'] = 'Všechny kategorie';
$string['allchanges'] = 'Všechny změny';
$string['alldays'] = 'Všechny dny';
$string['allfieldsrequired'] = 'Všechna pole jsou požadována';
$string['allfiles'] = 'Všechny soubory';
$string['allgroups'] = 'Všechny skupiny';
$string['alllogs'] = 'Všechny protokoly';
$string['allmods'] = 'Všechny {$a}';
$string['allow'] = 'Povolit';
$string['allowinternal'] = 'Povolit také interní metody';
$string['allownone'] = 'Nepovolit žádné';
$string['allownot'] = 'Nepovolit';
$string['allparticipants'] = 'Všichni účastníci';
$string['allteachers'] = 'Všichni učitelé';
$string['alphanumerical'] = 'Může obsahovat jen znaky abecedy, číslice, pomlčku (-) a tečku (.)';
$string['alreadyconfirmed'] = 'Registrace již byla potvrzena';
$string['alternatename'] = 'Alternativní jméno';
$string['always'] = 'Vždy';
$string['and'] = '{$a->one} a {$a->two}';
$string['answer'] = 'Odpověď';
$string['any'] = 'Jakýkoliv';
$string['appearance'] = 'Vzhled';
$string['approve'] = 'Schválit';
$string['areyousure'] = 'Opravdu?';
$string['areyousuretorestorethis'] = 'Přejete si pokračovat?';
$string['areyousuretorestorethisinfo'] = 'Později v procesu obnovy kurzu se budete moci rozhodnout, zda chcete data ze zálohy přidat k již existujícímu kurzu, nebo z nich vytvořit nový kurz.';
$string['asc'] = 'Sestupně';
$string['assessment'] = 'Hodnocení';
$string['assignadmins'] = 'Přiřadit správce';
$string['assigncreators'] = 'Přiřadit tvůrce kurzů';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Přiřadit role pro celou website';
$string['authenticateduser'] = 'Registrovaný uživatel';
$string['authenticateduserdescription'] = 'Všichni uživatelé, kteří mají účet';
$string['authentication'] = 'Metoda ověřování';
$string['authenticationplugins'] = 'Autentizační moduly';
$string['autosubscribe'] = 'Automatické odebírání příspěvků e-mailem';
$string['autosubscribeno'] = 'Ne: nenastavovat automaticky odebírání';
$string['autosubscribeyes'] = 'Ano: pokud pošlu příspěvek, chci fórum odebírat';
$string['availability'] = 'Dostupnost';
$string['availablecourses'] = 'Dostupné kurzy';
$string['back'] = 'Zpět';
$string['backto'] = 'Zpět k {$a}';
$string['backtocourselisting'] = 'Zpět na seznam kurzů';
$string['backtopageyouwereon'] = 'Zpět na původní stránku';
$string['backtoparticipants'] = 'Zpět na seznam účastníků';
$string['backup'] = 'Záloha';
$string['backupactivehelp'] = 'Zvolte, zda provádět automatické zálohování';
$string['backupcancelled'] = 'Zálohování přerušeno';
$string['backupcoursefileshelp'] = 'Zahrnout do automatických záloh soubory z kurzů';
$string['backupdate'] = 'Datum zálohy';
$string['backupdatenew'] = '{$a->TAG} nyní je {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bylo {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Podrobnosti zálohy';
$string['backupexecuteathelp'] = 'Zvolte, v jakém čase se má provádět automatická záloha';
$string['backupfailed'] = 'Některé z kurzů nebyly uloženy!!!';
$string['backupfilename'] = 'zaloha';
$string['backupfinished'] = 'Záloha úspěšně ukončena';
$string['backupfromthissite'] = 'Záloha vytvořena na těchto stránkách?';
$string['backupgradebookhistoryhelp'] = 'Je-li povoleno, bude historie známek zahrnuta v automaticky vytvářených zálohách. Zkontrolujte si také, že nemáte historii známek zakázánu v nastavení serveru (proměnná  disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Vyberte, zda chcete do automatických záloh zahrnout moduly kurzu, s daty uživatelů nebo bez nich';
$string['backupincludemoduleuserdatahelp'] = 'Zvolte, zda do automatických záloh chcete zahrnout data modulu';
$string['backupkeephelp'] = 'Kolik posledních záloh každého kurzu chcete uchovat? (Všechny starší budou automaticky odstraňovány.)';
$string['backuplogdetailed'] = 'Podrobný protokol';
$string['backuploglaststatus'] = 'Poslední protokol';
$string['backupmissinguserinfoperms'] = 'Poznámka: Tato záloha neobsahuje data uživatelů. Modul Workshop (a případně Cvičení) nebude do zálohy zahrnut, protože není s tímto typem zálohy kompatibilní.';
$string['backupnext'] = 'Příští záloha';
$string['backupnonisowarning'] = 'Upozornění: Tato záloha pochází z verze Moodlu, která ještě nepodporovala kódování Unicode (toto kódování je podporováno od verze 1.6). Pokud tato záloha obsahuje ne-ASCII znaky (např. česká písmena), mohou být texty při obnově do Unicode verze Moodlu POŠKOZENY. Více informací o korektním způsobu obnovy takové zálohy najdete na stránce <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>.';
$string['backupnotyetrun'] = 'Čekání na automatické zálohování';
$string['backuporiginalname'] = 'Název zálohy';
$string['backuproleassignments'] = 'Zálohovat přiřazení rolí pro tyto role';
$string['backupsavetohelp'] = 'Úplná cesta k adresáři, do něhož chcete ukládat soubory záloh<br />(ponecháte-li pole prázdné, budou se soubory ukládat do vlastního adresáře daného kurzu)';
$string['backupsitefileshelp'] = 'Je-li povoleno, budou soubory stránek použité v kurzech zahrnuty v zálohách kurzů';
$string['backuptakealook'] = 'Zkontrolujte prosím protokoly záloh: {$a}';
$string['backupuserfileshelp'] = 'Zahrnout do automatických záloh soubory uživatelů (např. jejich fotografie)';
$string['backupversion'] = 'Verze zálohy';
$string['badges'] = 'Odznaky';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurace bloku {$a}';
$string['blockconfigbad'] = 'Tento blok nebyl korektně implementován a nemá proto  konfigurační rozhraní';
$string['blocks'] = 'Bloky';
$string['blocksaddedit'] = 'Přidat/Upravit bloky';
$string['blockseditoff'] = 'Vypnout úpravu bloků';
$string['blocksediton'] = 'Zapnout úpravu bloků';
$string['blocksetup'] = 'Nastavení bloků';
$string['blocksuccess'] = 'Tabulky bloku \'{$a}\' byly korektně nastaveny';
$string['brief'] = 'Stručný';
$string['bulkactions'] = 'Hromadné akce';
$string['bulkactionselect'] = '{$a} výběr hromadné operace';
$string['bulkmovecoursessuccess'] = 'Úspěšně přesunuto {$a->courses} kurzů do {$a->category}';
$string['bycourseorder'] = 'Pořadí v kurzu';
$string['byname'] = 'od {$a}';
$string['bypassed'] = 'Přeskočeno';
$string['cachecontrols'] = 'Řízení mezipaměti';
$string['cancel'] = 'Zrušit';
$string['cancelled'] = 'Zrušeno';
$string['categories'] = 'Kategorie kurzů';
$string['categoriesandcoures'] = 'Kategorie kurzů a kurzy';
$string['category'] = 'Kategorie';
$string['categoryadded'] = 'Kategorie \'{$a}\' byla přidána';
$string['categorybulkaction'] = 'Hromadné operace pro vybrané kategorie';
$string['categorycontents'] = 'Podkategorie a kurzy';
$string['categorycurrentcontents'] = 'Obsah kategorie {$a}';
$string['categorydeleted'] = 'Kategorie \'{$a}\' byla odstraněna';
$string['categoryduplicate'] = 'Kategorie \'{$a}\' již existuje!';
$string['categorymodifiedcancel'] = 'Kategorie byla změněna! Prosíme, zrušte momentální operaci a zkuste ji znovu.';
$string['categoryname'] = 'Název kategorie';
$string['categorysubcategoryof'] = '{$a->category} - podkategorie v {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorie \'{$a}\' byla aktualizována';
$string['changedpassword'] = 'Heslo změněno';
$string['changepassword'] = 'Změnit heslo';
$string['changesmadereallygoaway'] = 'Provedli jste změny. Jste si jisti, že chcete odejít pryč a ztratit všechny změny?';
$string['changessaved'] = 'Změny uloženy';
$string['check'] = 'Prověřit';
$string['checkall'] = 'Prověřit vše';
$string['checkingbackup'] = 'Prověřuji zálohu';
$string['checkingcourse'] = 'Prověřuji kurzy';
$string['checkingforbbexport'] = 'Prověřuji BlackBoard export';
$string['checkinginstances'] = 'Prověřuji instance';
$string['checkingsections'] = 'Prověřuji sekce';
$string['checklanguage'] = 'Prověřit jazyk';
$string['checknone'] = 'Neprověřovat nic';
$string['childcoursenotfound'] = 'Asociovaný kurz nenalezen!';
$string['childcourses'] = 'Asociované kurzy';
$string['choose'] = 'Vybrat';
$string['choosecourse'] = 'Vyberte kurz';
$string['choosedots'] = 'Vyberte...';
$string['chooselivelogs'] = 'Online sledování probíhající činnosti';
$string['chooselogs'] = 'Zobrazení protokolu o činnosti';
$string['choosereportfilter'] = 'Vyberte filtr sestavy';
$string['choosetheme'] = 'Vyberte motiv';
$string['chooseuser'] = 'Vyberte uživatele';
$string['city'] = 'Město/obec';
$string['clambroken'] = 'Váš správce povolil na serveru kontrolu virů u nahrávaných souborů, ale její nastavení není v pořádku.<br />Nahrání vašeho souboru NEBYLO ÚSPĚŠNÉ! Váš správce byl na problém upozorněn e-mailem.<br />Pokuste se nahrát soubor později.';
$string['clamdeletedfile'] = 'Tento soubor byl odstraněn';
$string['clamdeletedfilefailed'] = 'Tento soubor nemůže být odstraněn';
$string['clamemailsubject'] = '{$a} :: Upozorneni Clam AV';
$string['clamfailed'] = 'Nepodařilo se spustit Clam AV. Vrácená chybová zpráva zněla: {$a}. Zde je výstup z Clam AV:';
$string['clamlost'] = 'Moodle je nastaven tak, aby spouštěl antivirový program Clam AV při nahrávání souborů. Uvedená cesta ({$a}) ale není platná.';
$string['clamlostandactinglikevirus'] = 'Navíc je Moodle nastaven tak, že pokud se Clam AV nepodaří spustit, jsou všechny nahrávané soubory považovány za viry. To v důsledku znamená, že dokud tento problém neopravíte, nebudou moci uživatelé nahrávat žádné soubory (např. studenti jejich úkoly apod.).';
$string['clammovedfile'] = 'Tento soubor byl přesunut do určeného karanténního adresáře. Nové umístění je {$a}';
$string['clammovedfilebasic'] = 'Tento soubor byl přesunut do karantény.';
$string['clamquarantinedirfailed'] = 'Nelze přesunout soubor do určeného karanténního adresáře {$a}. Tuto chybu byste měli rychle opravit, protože infikované soubory jsou jinak odstraňovány.';
$string['clamunknownerror'] = 'Vyskytla se neznámá chyba v programu Clam AV.';
$string['cleaningtempdata'] = 'Odstraňování dočasných údajů';
$string['clear'] = 'Vyčistit';
$string['clickhelpiconformoreinfo'] = '... pokračuje ... Klikněte na nápovědu pro více informací';
$string['clickhere'] = 'Klikněte zde...';
$string['clicktochangeinbrackets'] = '{$a} (Klikněte pro změnu)';
$string['clicktohideshow'] = 'Klikněte pro rozbalení nebo sbalení';
$string['closebuttontitle'] = 'Zavřít';
$string['closewindow'] = 'Zavřít toto okno';
$string['collapse'] = 'Sbalit';
$string['collapseall'] = 'Sbalit vše';
$string['collapsecategory'] = 'Sbalit {$a}';
$string['commentincontext'] = 'Najít tento komentář v kontextu';
$string['comments'] = 'Komentáře';
$string['commentsnotenabled'] = 'Komentáře nejsou povoleny';
$string['commentsrequirelogin'] = 'Pro zobrazení komentářů musíte být přihlášeni';
$string['comparelanguage'] = 'Porovnat a upravit současný jazyk';
$string['complete'] = 'Podrobný';
$string['completereport'] = 'Podrobná sestava';
$string['configuration'] = 'Nastavení';
$string['confirm'] = 'Potvrdit';
$string['confirmcheckfull'] = 'Jste si jisti, že chcete potvrdit {$a}?';
$string['confirmcoursemove'] = 'Jste si jisti, že chcete přesunout kurz ({$a->course}) do kategorie ({$a->category})?';
$string['confirmed'] = 'Vaše registrace byla potvrzena';
$string['confirmednot'] = 'Vaše registrace ještě nebyla potvrzena!';
$string['content'] = 'Obsah';
$string['continue'] = 'Pokračovat';
$string['continuetocourse'] = 'Klikněte zde pro vstup do kurzu';
$string['convertingwikitomarkdown'] = 'Převádím formát Wiki na Markdown';
$string['cookiesenabled'] = 'Musíte povolit cookies ve svém prohlížeči';
$string['cookiesenabled_help'] = '<p>Tyto stránky používají dva soubory cookie.</p>

<p>Hlavním používaným souborem cookie je soubor relace, který se obvykle nazývá
<b>MoodleSession</b>. Tento soubor cookie je třeba povolit v prohlížeči,
zajišťuje kontinuitu vaší práce v systému a udržuje informace o vašem
přihlášení. Při odhlášení nebo ukončení prohlížeče je tento soubor cookie
odstraněn jak z prohlížeče, tak ze serveru.</p>

<p>Druhý soubor cookie pouze usnadňuje uživateli práci, obvykle se nazývá
<b>MOODLEID</b>. Slouží k zapamatování vašeho uživatelského jména v prohlížeči.
To znamená, že při návratu na tyto stránky bude pole s uživatelským jménem na
stránce přihlášení již vyplněno. Tento soubor cookie je možné zakázat. Při
každém přihlášení však budete muset zadat své uživatelské jméno.</p>';
$string['cookiesnotenabled'] = 'Bohužel, ve vašem prohlížeči nejsou momentálně povolena cookies.';
$string['copy'] = 'kopírovat';
$string['copyasnoun'] = 'kopie';
$string['copyingcoursefiles'] = 'Kopíruji soubory kurzu';
$string['copyingsitefiles'] = 'Kopírování souborů stránek použitých v kurzech';
$string['copyinguserfiles'] = 'Kopíruji soubory uživatele';
$string['copyingzipfile'] = 'Kopíruji soubor ZIP';
$string['copyrightnotice'] = 'Autorská práva';
$string['coresystem'] = 'Základní systém';
$string['cost'] = 'Cena';
$string['costdefault'] = 'Výchozí cena';
$string['counteditems'] = '{$a->items}: {$a->count}';
$string['country'] = 'Země';
$string['course'] = 'Kurz';
$string['courseadministration'] = 'Správa kurzu';
$string['courseapprovedemail'] = 'Vas pozadavek na zalozeni kurzu {$a->name} byl schvalen; v kurzu vam byla prirazena role {$a->teacher}. Svuj novy kurz najdete na adrese:
{$a->url}';
$string['courseapprovedemail2'] = 'Vámi požadovaný kurz {$a->name} byl schválen. Pro přístup do vašeho nového kurzu můžete použít adresu {$a->url}';
$string['courseapprovedfailed'] = 'Selhalo uložení kurzu jako schváleného!';
$string['courseapprovedsubject'] = 'Vas kurz byl schvalen';
$string['courseavailable'] = 'Tento kurz je studentům dostupný';
$string['courseavailablenot'] = 'Tento kurz není studentům dostupný';
$string['coursebackup'] = 'Zálohovat kurz';
$string['coursebulkaction'] = 'Hromadné operace pro vybrané kurzy';
$string['coursecategories'] = 'Kategorie kurzů';
$string['coursecategory'] = 'Kategorie kurzu';
$string['coursecategorydeleted'] = 'Odstraněná kategorie kurzů {$a}';
$string['coursecategory_help'] = '<p>Správce těchto stránek může nastavit několik kategorií čili skupin
kurzů.</p>

<p>Například "Volitelné kurzy" nebo "Povinné kurzy" apod.</p>

<p>Vyberte nejvhodnější kategorii pro váš kurz. Tato volba ovlivňuje umístění
vašeho kurzu v seznamu kurzů a pomůže studentům váš kurz najít.</p>';
$string['coursecatmanagement'] = 'Správa kurzů a kategorií';
$string['coursecompletion'] = 'Absolvování kurzu';
$string['coursecompletions'] = 'Absolvování kurzů';
$string['coursecreators'] = 'Tvůrce kurzu';
$string['coursecreatorsdescription'] = 'Tvůrci kurzu mohou zakládat nové kurzy.';
$string['coursedeleted'] = 'Odstraněný kurz {$a}';
$string['coursedisplay'] = 'Vzhled kurzu';
$string['coursedisplay_help'] = 'Zda se má celý kurz zobrazit na jedné stránce nebo zde se mají jednotlivé sekce (např. týdny či témata) zobrazovat na samostatných stránkách.';
$string['coursedisplay_multi'] = 'Zobrazit jedno téma na stránku';
$string['coursedisplay_single'] = 'Zobrazit všechna témata na stránku';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Soubory kurzu';
$string['coursefilesedit'] = 'Upravit soubory kurzu';
$string['coursefileswarning'] = 'Soubory kurzu jsou zastaralé';
$string['coursefileswarning_help'] = 'Soubory kurzu byly ve verzi Moodle 2.0 nahrazeny systémem externích repozitářů. Prosím, používejte přednostně tento nový přístup.';
$string['courseformatdata'] = 'Formát dat kurzu';
$string['courseformatoptions'] = 'Volby formátování pro {$a}';
$string['courseformats'] = 'Uspořádání kurzu';
$string['courseformatudpate'] = 'Aktualizace formátu';
$string['coursegrades'] = 'Známky kurzu';
$string['coursehelpcategory'] = 'Ovlivňuje umístění kurzu v seznamu všech kurzů a pomáhá studentům najít správný kurz.';
$string['coursehelpforce'] = 'Vnutit režim skup nastavený v kurzu pro všechny moduly činností';
$string['coursehelpformat'] = 'V tomto uspořádání se zobrazí hlavní stránka kurzu.';
$string['coursehelphiddensections'] = 'Jak se mají zobrazovat skryté sekce kurzu (např. témata či týdny) studentům.';
$string['coursehelpmaximumupload'] = 'Určuje maximální velikost souboru, který budou moci studenti vložit do tohoto kurzu. Velikost je limitována nastavením serveru.';
$string['coursehelpnewsitemsnumber'] = 'Počet posledních novinek zobrazovaných na domovské stránce kurzu v postranním bloku vpravo (0 znamená, že se blok vůbec nezobrazí).';
$string['coursehelpnumberweeks'] = 'Počet sekcí kurzu (platí pouze pro některá uspořádání)';
$string['coursehelpshowgrades'] = 'Povolit zobrazení modulu klasifikace v nabídce Správa > Známky. Tímto se neovlivňuje zobrazování známek v rámci dílčích modulů činností.';
$string['coursehidden'] = 'Tento kurz není momentálně studentům dostupný.';
$string['courseinfo'] = 'Informace o kurzu';
$string['courselegacyfiles'] = 'Soubory kurzu';
$string['courselegacyfiles_help'] = 'Oblast Soubory kurzu poskytuje zpětnou kompatibilitu se správou souborů v Moodle 1.9 a dřívějších verzích. Všechny soubory v této oblasti jsou vždy dostupné všem účastníkům kurzu, ať už je někde v kurzu skutečně používáte či ne. Neexistuje způsob, jak zjistit, které z těchto souborů jsou používány.

Pokud se rozhodnete i nadále používat tento zastaralý způsob práce se soubory, vystavujete se řadě nebezpečí neoprávněného přístupu k osobním informacím a bezpečnostním rizikům. Můžete též zaznamenat chybějící soubory v zálohách kurzů, chyby při importu jiných kurzů a vůbec kdykoliv, kdy je obsah kurzu sdílen a/nebo kopírován. Je proto silně doporučováno tuto oblast nepoužívat, dokud si nejste zcela jisti, co děláte.

Následující odkaz vám poskytne další informace a alternativní přístupy ke správě souborů v Moodle 2.x';
$string['courselegacyfilesofcourse'] = 'Soubory kurzu: {$a}';
$string['coursemessage'] = 'Zpráva pro účastníky kurzu';
$string['coursenotaccessible'] = 'Tento kurz není veřejně přístupný';
$string['courseoverview'] = 'Přehled kurzů';
$string['courseoverviewfiles'] = 'Soubory v souhrnu kurzu';
$string['courseoverviewfilesext'] = 'Přípony souborů v souhrnu kurzu';
$string['courseoverviewfiles_help'] = 'Soubory souhrnu, například obrázky, jsou zobrazeny v seznamu kurzů společně se souhrnem kurzu.';
$string['courseoverviewfileslimit'] = 'Limit počtu souborů v souhrnu kurzu';
$string['courseoverviewgraph'] = 'Graf přehledu kurzu';
$string['courseprofiles'] = 'Profily v kurzu';
$string['coursereasonforrejecting'] = 'Důvod pro zamítnutí této žádosti';
$string['coursereasonforrejectingemail'] = 'Bude odesláno e-mailem žadateli';
$string['coursereject'] = 'Zamítnout požadavek';
$string['courserejected'] = 'Kurz byl zamítnut a žadatel byl informován.';
$string['courserejectemail'] = 'Je mi lito, ale vas pozadavek na zalozeni kurzu byl zamitnut z nasledujicich duvodu:

{$a}';
$string['courserejectreason'] = 'Uveďte důvody pro zamítnutí tohoto požadavku. Důvody budou odeslány na e-mail žadatele.<br />(Doporučujeme nepoužívat české znaky.)';
$string['courserejectsubject'] = 'Vas kurz byl zamitnut';
$string['coursereport'] = 'Sestava o kurzu';
$string['coursereports'] = 'Sestavy kurzu';
$string['courserequest'] = 'Žádost o založení kurzu';
$string['courserequestdetails'] = 'Podrobnosti o požadovaném kurzu';
$string['courserequestfailed'] = 'Z nějakého důvodu se nepodařilo uložit vaši žádost o založení kurzu.';
$string['courserequestintro'] = 'Pomocí tohoto formuláře požádejte o založení kurzu.<br />Uveďte prosím co nejvíce informací, tak aby správcům stránek bylo<br />zřejmé, jaké jsou vaše důvody pro založení tohoto kurzu.';
$string['courserequestreason'] = 'Důvody požadavku na založení kurzu';
$string['courserequestsuccess'] = 'Váš požadavek byl úspěšně uložen. Vyčkejte prosím několik dní na e-mail s rozhodnutím.';
$string['courserequestsupport'] = 'Doplňující informace, které pomohou správcům posoudit vaši žádost';
$string['courserestore'] = 'Obnova kurzu';
$string['courses'] = 'Kurzy';
$string['coursesectionsummaries'] = 'Úvodní texty sekcí kurzu';
$string['coursesettings'] = 'Výchozí nastavení kurzu';
$string['coursesmovedout'] = 'Kurzy přesunuty z {$a}';
$string['coursespending'] = 'Kurzy čekající na schválení';
$string['coursestart'] = 'Začátek kurzu';
$string['coursesummary'] = 'Shrnutí kurzu';
$string['coursesummary_help'] = 'Tato anotace je zobrazována spolu s názve kurzu v seznamu kurzů. Při hledání kurzů je prohledáván i tento text.';
$string['courseupdates'] = 'Aktualizace kurzu';
$string['create'] = 'Vytvořit';
$string['createaccount'] = 'Vytvořit můj nový účet';
$string['createcategory'] = 'Vytvořit kategorii';
$string['createfolder'] = 'Vytvořit složku v \'{$a}\'';
$string['createnew'] = 'Vytvořit novou';
$string['createnewcategory'] = 'Vytvořit novou kategorii';
$string['createnewcourse'] = 'Vytvořit nový kurz';
$string['createnewsubcategory'] = 'Vytvořit novou podkategorii';
$string['createsubcategoryof'] = 'Vytvořit podkategorii v {$a}';
$string['createuser'] = 'Vytvořit uživatele';
$string['createuserandpass'] = 'Vytvořit nové uživatelské jméno a heslo pro přihlášení';
$string['createziparchive'] = 'Vytvořit ZIP archív';
$string['creatingblocks'] = 'Vytvářím bloky';
$string['creatingblocksroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni bloků';
$string['creatingblogsinfo'] = 'Vytvářím informace blogů';
$string['creatingcategoriesandquestions'] = 'Vytvářím kategorie a otázky';
$string['creatingcoursemodules'] = 'Vytvářím moduly kurzu';
$string['creatingcourseroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni kurzu';
$string['creatingevents'] = 'Vytvářím události';
$string['creatinggradebook'] = 'Vytvářím klasifikaci';
$string['creatinggroupings'] = 'Vytvářím seskupení';
$string['creatinggroupingsgroups'] = 'Přidávám skupiny do seskupení';
$string['creatinggroups'] = 'Vytvářím skupiny';
$string['creatinglogentries'] = 'Vytvářím položky protokolu';
$string['creatingmessagesinfo'] = 'Vytvářím informace o zprávách';
$string['creatingmodroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni modulu';
$string['creatingnewcourse'] = 'Vytvářím nový kurz';
$string['creatingrolesdefinitions'] = 'Vytvářím definice rolí';
$string['creatingscales'] = 'Vytvářím škály';
$string['creatingsections'] = 'Vytvářím sekce';
$string['creatingtemporarystructures'] = 'Vytvářím dočasné struktury';
$string['creatinguserroles'] = 'Přiřazení rolí a lokálních přenastavení na úrovni uživatele';
$string['creatingusers'] = 'Vytvářím uživatele';
$string['creatingxmlfile'] = 'Vytvářím XML soubor';
$string['currency'] = 'Měna';
$string['currentcourse'] = 'Aktuální kurz';
$string['currentcourseadding'] = 'Tento kurz, přidávám data do něj';
$string['currentcoursedeleting'] = 'Tento kurz, nejprve jej odstraňuji';
$string['currentlanguage'] = 'Současný jazyk';
$string['currentlocaltime'] = 'váš momentální místní čas';
$string['currentlyselectedusers'] = 'Momentálně vybraní uživatelé';
$string['currentpicture'] = 'Stávající obrázek';
$string['currentrelease'] = 'Údaje o stávajícím vydání';
$string['currentversion'] = 'Stávající verze';
$string['databasechecking'] = 'Aktualizuji databázi Moodle z verze {$a->oldversion} na {$a->newversion}';
$string['databaseperformance'] = 'Výkon databáze';
$string['databasesetup'] = 'Nastavování databáze';
$string['databasesuccess'] = 'Databáze úspěšně aktualizována';
$string['databaseupgradebackups'] = 'Verze zálohy je nyní {$a}';
$string['databaseupgradeblocks'] = 'Verze bloků je nyní {$a}';
$string['databaseupgradegroups'] = 'Verze skupin je teď {$a}';
$string['databaseupgradelocal'] = 'Verze místních úprav databáze je nyní {$a}';
$string['databaseupgrades'] = 'Aktualizuji databázi';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum změněno';
$string['datemostrecentfirst'] = 'Datum - nejnovější první';
$string['datemostrecentlast'] = 'Datum - nejnovější poslední';
$string['day'] = 'den';
$string['days'] = 'dny';
$string['decodinginternallinks'] = 'Dekódování interních odkazů';
$string['default'] = 'Výchozí';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenti obvykle v kurzu mají méně oprávnění';
$string['defaultcoursestudents'] = 'Studenti';
$string['defaultcoursesummary'] = 'Napište stručný a zajímavý odstavec, který popisuje, o čem pojednává tento kurz.';
$string['defaultcourseteacher'] = 'Učitel';
$string['defaultcourseteacherdescription'] = 'Učitelé mohou v rámci kurzu dělat všechno, včetně změn aktivit a známkování studentů';
$string['defaultcourseteachers'] = 'Učitelé';
$string['defaulteditor'] = 'Výchozí editor';
$string['delete'] = 'Odstranit';
$string['deleteablock'] = 'Odstranit block';
$string['deleteall'] = 'Odstranit vše';
$string['deleteallcannotundo'] = 'Odstranit vše - nelze vzít zpět';
$string['deleteallcomments'] = 'Odstranit všechny komentáře';
$string['deleteallratings'] = 'Odstranit všechna hodnocení';
$string['deletecategory'] = 'Odstranit kategorii: {$a}';
$string['deletecategorycheck'] = 'Jste si úplně jisti, že chcete kompletně odstranit kategorii <b>\'{$a}\'</b>?<br />Kurzy budou přesunuty do nadřazené kategorie, případně do kategorie Různé.';
$string['deletecategorycheck2'] = 'Pokud odstraníte tuto kategorii , musíte se rozhodnout, co se má stát s kurzy a podkategoriemi, které obsahuje.';
$string['deletecategoryempty'] = 'Tato kategorie je prázdná';
$string['deletecheck'] = 'Odstranit {$a}?';
$string['deletecheckfiles'] = 'Jste si absolutně jisti, že chcete odstranit tyto soubory?';
$string['deletecheckfull'] = 'Jste si absolutni jisti, že chcete kompletně odstranit {$a}?';
$string['deletechecktype'] = 'Jste si jisti, že chcete smazat {$a->type}?';
$string['deletechecktypename'] = 'Jste si jisti, že chcete smazat {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Chystáte se odstranit tyto soubory';
$string['deletecomment'] = 'Odstranit tento komentář';
$string['deletecompletely'] = 'Kompletně odstranit';
$string['deletecourse'] = 'Odstranit kurz';
$string['deletecoursecheck'] = 'Jste si absolutně jisti, že chcete kompletně odstranit tento kurz a všechna data, která obsahuje?';
$string['deleted'] = 'Odstraněno';
$string['deletedactivity'] = 'Odstraněno {$a}';
$string['deletedcourse'] = '{$a} byl kompletně odstraněn';
$string['deletednot'] = '{$a} nelze odstranit!';
$string['deletelogs'] = 'Odstranit protokoly';
$string['deleteselected'] = 'Odstranit vybrané';
$string['deleteselectedkey'] = 'Odstranit vybraný klíč';
$string['deletingcourse'] = 'Odstraňuji {$a}';
$string['deletingexistingcoursedata'] = 'Odstraňování stávajících údajů v kurzu';
$string['deletingolddata'] = 'Odstraňování starých údajů';
$string['department'] = 'Oddělení';
$string['desc'] = 'Sestupně';
$string['description'] = 'Popis';
$string['deselectall'] = 'Odznačit vše';
$string['detailedless'] = 'Méně podrobností';
$string['detailedmore'] = 'Více podrobností';
$string['directory'] = 'Adresář';
$string['disable'] = 'Zakázat';
$string['disabledcomments'] = 'Komentáře jsou vypnuté';
$string['displayingfirst'] = 'Zobrazeno je pouze prvních {$a->count} {$a->things}';
$string['displayingrecords'] = 'Zobrazení {$a} záznamů';
$string['displayingusers'] = 'Zobrazení uživatelů {$a->start} až {$a->end}';
$string['displayonpage'] = 'Zobrazit na stránce';
$string['dndcourse'] = 'Kurz můžete přetáhnout a změnit jeho řazení nebo přesunout do jiné kategorie.';
$string['dndenabled_inbox'] = 'Pro nahrání souborů z vašeho počítače je přetáhněte sem.';
$string['dndnotsupported'] = 'Přetahování souborů není podporováno';
$string['dndnotsupported_help'] = 'Váš prohlížeč nepodporuje funkci přetahování souborů.<br />Tato funkce je dostupná ve všech posledních verzích prohlížečů Chrome, Firefox a Safari, stejně jako v Internet Exploreru verze 10 a vyšší.';
$string['dndnotsupported_insentence'] = 'přetahování souborů není podporováno';
$string['dnduploadwithoutcontent'] = 'Toto nahrávání nemá žádný obsah';
$string['dndworkingfile'] = 'Pro nahrání souborů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingfilelink'] = 'Pro nahrání souborů nebo odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingfiletext'] = 'Pro nahrání souborů nebo textu je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingfiletextlink'] = 'Pro nahrání souborů, textu nebo odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkinglink'] = 'Pro nahrání  odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingtext'] = 'Pro nahrání  textu je stačí přetáhnout do příslušné sekce kurzu';
$string['dndworkingtextlink'] = 'Pro nahrání textu nebo odkazů je stačí přetáhnout do příslušné sekce kurzu';
$string['documentation'] = 'Dokumentace Moodlu';
$string['dontsortcategories'] = 'Neřadit kategorie';
$string['dontsortcourses'] = 'Neřadit kurzy';
$string['down'] = 'Dolů';
$string['download'] = 'Stáhnout';
$string['downloadall'] = 'Stáhnout vše';
$string['downloadexcel'] = 'Stáhnout ve formátu Excel';
$string['downloadfile'] = 'Stáhnout soubor';
$string['downloadods'] = 'Stáhnout ve formátu ODS';
$string['downloadtext'] = 'Stáhnout v textovém formátu';
$string['doyouagree'] = 'Přečetli jste si tyto podmínky a rozumíte jim?';
$string['droptoupload'] = 'Pro nahrání souborů je přitáhněte sem';
$string['duplicate'] = 'Duplikovat';
$string['duplicateconfirm'] = 'Skutečně chcete nakopírovat {$a->modtype} "{$a->modname}" ?';
$string['duplicatecontcourse'] = 'Vrátit se do kurzu';
$string['duplicatecontedit'] = 'Upravit novou kopii modulu';
$string['duplicatesuccess'] = 'Modul {$a->modtype} "{$a->modname}" byl úspěšně nakopírován';
$string['duplicatinga'] = 'Duplikuje se: {$a}';
$string['edhelpaspellpath'] = 'Chcete-li v editoru používat kontrolu pravopisu, MUSÍTE mit na serveru nainstalován <strong>aspell 0.50</strong> nebo vyšší a musíte správně nastavit cestu ke spustitelnému souboru aspell. V systémech Unix/Linux bývá tato cesta obvykle <strong>/usr/bin/aspell</strong>, ale nemusí to platit vždy.';
$string['edhelpbgcolor'] = 'Určete barvu pozadí editačního okna. Platné hodnoty jsou např. \'#ffffff\' nebo \'white\'.';
$string['edhelpcleanword'] = 'Zapnout filtrování formátu dokumentu Word';
$string['edhelpenablespelling'] = 'Zapnout kontrolu pravopisu. Vyžaduje, aby byl na serveru nainstalován <strong>aspell</strong>.<br />Druhý parametr určuje <strong>výchozí slovník</strong>. Tato hodnota se použije, pokud aspell nemá k dispozici slovník pro jazyk vybraný uživatelem.';
$string['edhelpfontfamily'] = 'Vlastnost font-family je seznam názvů skupin (rodin) fontů a/nebo obecných skupin. Názvy skupin musí být odděleny čárkou.';
$string['edhelpfontlist'] = 'Určete fonty nabízené v editoru v rozbalovacím seznamu';
$string['edhelpfontsize'] = 'Výchozí font-size definuje velikost fontu. Platné hodnoty jsou např. medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Upravit';
$string['edita'] = 'Upravit {$a}';
$string['editcategorysettings'] = 'Upravit nastavení kategorie';
$string['editcategorythis'] = 'Upravit tuto kategorii';
$string['editcoursesettings'] = 'Upravit nastavení kurzu';
$string['editfiles'] = 'Upravit soubory';
$string['editgroupprofile'] = 'Upravit profil skupiny';
$string['editinga'] = 'Upravuji {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Tuto hodnotu nelze upravovat!';
$string['editmyprofile'] = 'Upravit profil';
$string['editorbgcolor'] = 'Barva pozadí (background-color)';
$string['editorcleanonpaste'] = 'Vyčistit HTML při vložení z Wordu';
$string['editorcommonsettings'] = 'Společná nastavení';
$string['editordefaultfont'] = 'Výchozí font';
$string['editorenablespelling'] = 'Povolit kontrolu pravopisu';
$string['editorfontlist'] = 'Seznam fontů (font-family)';
$string['editorfontsize'] = 'Výchozí velikost font (font-size)';
$string['editorresettodefaults'] = 'Nastavit výchozí hodnoty';
$string['editorsettings'] = 'Nastavení editoru';
$string['editorshortcutkeys'] = 'Klávesové zkratky editoru';
$string['editsettings'] = 'Upravit nastavení';
$string['editsummary'] = 'Upravit souhrn';
$string['editthisactivity'] = 'Upravit tuto činnost';
$string['editthiscategory'] = 'Upravit tuto kategorii';
$string['edittitle'] = 'Upravit název';
$string['edittitleinstructions'] = 'Pro zrušení zvolte Escape, pro dokončení Enter';
$string['edituser'] = 'Upravit uživatelské účty';
$string['email'] = 'E-mailová adresa';
$string['emailactive'] = 'E-mail aktivován';
$string['emailagain'] = 'E-mail (znovu)';
$string['emailalreadysent'] = 'E-mail s obnovením hesla  byl odeslán. Zkontrolujte prosím Váš e-mail.';
$string['emailcharset'] = 'Znaková sada e-mailu';
$string['emailconfirm'] = 'Potvrďte váš účet';
$string['emailconfirmation'] = 'Zdravicko, vy budete asi {$a->firstname}, ze?

Na strance \'{$a->sitename}\' byl zadan pozadavek na zrizeni noveho uzivatelskeho uctu s vasi e-mailovou adresou.

Potvrdte prosim tuto zadost na webove adrese:
{$a->link}

Ve vetsine e-mailovych programu by se vam tato adresa mela zobrazit jako odkaz, na ktery staci kliknout. Pokud tomu tak neni, zkopirujte si adresu do schranky a vlozte ji do adresniho radku ve svem webovem prohlizeci.

Toto je automaticky generovany e-mail. Neni nutne na nej odpovidat jeho odesilateli. Potrebujete-li pomoc, spojte se se spravcem stranek.

S pozdravem,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: potvrzeni uctu';
$string['emailconfirmsent'] = '<p>Na vaši adresu <b>{$a}</b> byl odeslán e-mail s jednoduchými pokyny k dokončení vaší registrace.</p><p>Narazíte-li na nějaké obtíže, spojte se se správcem těchto stránek.</p>';
$string['emaildigest'] = 'Typ souhrnných e-mailů';
$string['emaildigestcomplete'] = 'Kompletní (denně e-mail s plným textem příspěvků)';
$string['emaildigest_help'] = 'Toto je denni souhrn novych prispevku nastavenývh v diskusnich forech jako výchozí.

* Bez souhrnu - obdržíte e-mail při každém příspěvku;
* Souhrn -  kompletní příspěvky - obdržíte jeden souhrnný e-mail denně obsahující kompletní obsah každého příspěvku do fóra;
 * Souhrn - pouze předměty - obdržíte  jeden souhrnný e-mail denně obsahující pouze předmět každého příspěvku do fóra.

Pokud si budete přát, můžete si v každém fóru vybrat jiné nastavení.';
$string['emaildigestoff'] = 'Nepoužívat souhrny (jeden e-mail na každý příspěvek)';
$string['emaildigestsubjects'] = 'Předměty (denně e-mail pouze s předměty příspěvků)';
$string['emaildisable'] = 'E-mailová adresa zakázána';
$string['emaildisableclick'] = 'Chcete-li zamezit odesílání e-mailů na tuto adresu, klikněte sem';
$string['emaildisplay'] = 'Zobrazit e-mail';
$string['emaildisplaycourse'] = 'Zobrazovat e-mail pouze dalším účastníkům kurzu';
$string['emaildisplayhidden'] = 'Skrytý email';
$string['emaildisplayno'] = 'Nezobrazovat mou e-mailovou adresu nikomu';
$string['emaildisplayyes'] = 'Zobrazovat mou e-mailovou adresu komukoliv';
$string['emailenable'] = 'E-mailová adresa povolena';
$string['emailenableclick'] = 'Chcete-li znovu povolit odesílání e-mailů na tuto adresu, klikněte sem';
$string['emailexists'] = 'Tato e-mailová adresa je již registrována.';
$string['emailformat'] = 'Formát e-mailu';
$string['emailmustbereal'] = 'Poznámka: zadávaná e-mailová adresa nesmí být fiktivní.';
$string['emailnotallowed'] = 'E-mailové adresy v těchto doménách nejsou povoleny ({$a})';
$string['emailnotfound'] = 'E-mailová adresa nebyla nalezena v databázi';
$string['emailonlyallowed'] = 'Tento e-mail nepatří k těm, které jsou povoleny ({$a})';
$string['emailpasswordchangeinfo'] = 'Zdravicko {$a->firstname},

Nekdo (pravdepodobne vy) pozaduje zmenu hesla k vasemu uctu na strankach  \'{$a->sitename}\'.
Vase heslo zmenite na strance:

{$a->link}

Ve vetsine e-mailovych programu by se vam tato adresa mela zobrazit jako odkaz, na ktery staci kliknout. Pokud tomu tak neni, zkopirujte si adresu do schranky a vlozte ji do adresniho radku ve svem webovem prohlizeci.
Pokud narazite na problemy, obratte se na spravce techto stranek:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Zdravicko {$a->firstname},

Nekdo (pravdepodobne vy) pozaduje zmenu hesla k vasemu uctu na strankach  \'{$a->sitename}\'.

Vas ucet je ale bohuzel na techto strankach zablokovan a heslo nemuze byt zmeneno. Spojte se se správcem:
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Zdravím {$a->firstname},

Někdo (pravděpodobně vy) požaduje změnu hesla k vašemu účtu na stránkách  \'{$a->sitename}\'.

Na těchto stránkách bohužel nelze změnit heslo, spojte se se správcem:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Změnit informaci hesla';
$string['emailpasswordconfirmation'] = 'Zdravicko, vy budete asi {$a->firstname}, ze?

Nekdo (pravdepodobne vy) pozaduje zmenu hesla k vasemu uctu na strankach \'{$a->sitename}\'.

Prejete-li si tuto zmenu potvrdit a obdrzet nove heslo e-mailem, navstivte nasledujici stranku:
{$a->link}

Ve vetsine e-mailovych programu by se vam tato adresa mela zobrazit jako odkaz, na ktery staci kliknout. Pokud tomu tak neni, zkopirujte si adresu do schranky a vlozte ji do adresniho radku ve svem webovem prohlizeci.

Toto je automaticky generovany e-mail. Neni nutne na nej odpovidat jeho odesilateli.

Pokud narazite na problemy, obratte se na spravce techto stranek:
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: potvrzení změny hesla';
$string['emailpasswordconfirmmaybesent'] = '<p>Pokud jste zadali správné uživatelské jméno nebo adresu, byl vám odeslán email.</p>
<p>Obsahuje jednoduché instrukce k potvrzení a dokončení změny hesla. Pokud máte nadále potíže, kontaktujte správce těchto stránek.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> Zadaný uživatelský účet nemá zadanou e-mailovou adresu. </p><p> Obraťte se na správce webu. </p>';
$string['emailpasswordconfirmnotsent'] = '<p> Detail uživatele, který jste zadali neoznačuje existující uživatelský účet. </p><p> Zkontrolujte prosím zadané údaje a zkuste to znovu. Pokud potíže přetrvávají, obraťte se na správce webu. </p>';
$string['emailpasswordconfirmsent'] = 'Na vaši adresu <b>{$a}</b> byl odeslán e-mail obsahující jednoduché pokyny k potvrzení a dokončení změny vašeho hesla. <br />Pokud narazíte na problémy, obraťte se na správce těchto stránek.';
$string['emailpasswordsent'] = 'Děkujeme za potvrzení změny vašeho hesla.<p>Vaše nové heslo bylo odesláno na adresu <br /><b>{$a->email}</b>.<p><br />Toto heslo bylo vygenerováno automaticky, můžete si je kdykoliv <a href="{$a->link}">změnit</a> na nějaké snadněji zapamatovatelné.';
$string['emailresetconfirmation'] = 'Zdravicko, vy budete asi {$a->firstname}, že?

U vašeho účtu \'{$a->username} "na {$a->sitename} bylo požadováno vymazání hesla.

Pro potvrzení této žádosti a nastavení nového hesla k vašemu účtu, přejděte na stránku:
{$a->link}

(Tento odkaz je platný {$a->resetminutes} minut od okamžiku, kdy bylo poprvé vyžádáno vymazání)

Jestliže požadavek na vymazání hesla nebyl od vás, neprovádějte žádnou akci.

Pokud potřebujete pomoc, obraťte se na správce webu, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: žádost o změnu hesla';
$string['emailresetconfirmsent'] = 'E-mail byl odeslán na vaši adresu  <b>{$a}.</b> <br /> Obsahuje jednoduché instrukce k potvrzení a dokončení změny hesla. Pokud potíže přetrvávají, obraťte se na správce webu.';
$string['emptydragdropregion'] = 'prázdná oblast';
$string['enable'] = 'Povolit';
$string['encryptedcode'] = 'Šifrovaný kód';
$string['english'] = 'Angličtina';
$string['enrolmentmethods'] = 'Metody zápisu';
$string['entercourse'] = 'Klikněte pro vstup do kurzu';
$string['enteremail'] = 'Zadejte vaši e-mailovou adresu';
$string['enteremailaddress'] = 'Zadejte svou e-mailovou adresu, na kterou vám bude zasláno nové heslo.';
$string['enterusername'] = 'Zadejte své uživatelské jméno';
$string['entries'] = 'Položky';
$string['error'] = 'Chyba';
$string['errorcreatingactivity'] = 'Nelze vytvořit instanci činnosti "{$a}"';
$string['errorfiletoobig'] = 'Soubor byl větší než nejvýše dovolených {$a} bytů';
$string['errornouploadrepo'] = 'Pro tuto stránku není povolen žádný repositář';
$string['errorwhenconfirming'] = 'Omlouváme se, ale objevila se chyba a vaše registrace nebyla dokončena. Pokud jste se na tuto stránku dostali po kliknutí na odkaz v e-mailové zprávě, zkontrolujte, zda řádek s HTTP odkazem není v e-mailu zalomen nebo zkrácen. V případě potřeby odkaz rekonstruujte pomocí obvyklých funkcí Kopírovat a Vložit.';
$string['eventcontentviewed'] = 'Zobrazený obsah';
$string['eventcoursecategorydeleted'] = 'Kategorie odstraněna';
$string['eventcoursecontentdeleted'] = 'Obsah kurzu odstraněn';
$string['eventcoursecreated'] = 'Kurz vytvořen';
$string['eventcoursedeleted'] = 'Kurz odstraněn';
$string['eventcoursemodulecreated'] = 'Modul kurzu vytvořen';
$string['eventcoursemoduledeleted'] = 'Modul kurzu odstraněn';
$string['eventcoursemoduleupdated'] = 'Modul kurzu aktualizován';
$string['eventcourseresetended'] = 'Resetování kurzu ukončeno';
$string['eventcourseresetstarted'] = 'Zahájeno resetování kurzu';
$string['eventcourserestored'] = 'Kurz obnoven';
$string['eventcoursesectionupdated'] = 'Sekce kurzu aktualizována';
$string['eventcourseupdated'] = 'Kurz aktualizován';
$string['eventusercreated'] = 'Uživatel vytvořen';
$string['eventuserdeleted'] = 'Uživatel odstraněn';
$string['eventuserlistviewed'] = 'Zobrazen seznam uživatelů';
$string['eventuserloggedout'] = 'Uživatel odhlášen';
$string['eventuserprofileviewed'] = 'Zobrazen uživatelský profil';
$string['eventuserupdated'] = 'Uživatel aktualizován';
$string['everybody'] = 'Všichni';
$string['executeat'] = 'Spustit v';
$string['existing'] = 'Stávající';
$string['existingadmins'] = 'Stávající správci';
$string['existingcourse'] = 'Existující kurz';
$string['existingcourseadding'] = 'Existující kurz, přidávám do něj údaje';
$string['existingcoursedeleting'] = 'Existující kurz, nejprve jej odstraňuji';
$string['existingcreators'] = 'Stávající tvůrci kurzů';
$string['existingstudents'] = 'Zapsaní studenti';
$string['existingteachers'] = 'Stávající učitelé';
$string['expand'] = 'Rozbalit';
$string['expandall'] = 'Rozbalit vše';
$string['expandcategory'] = 'Rozbalit {$a}';
$string['explanation'] = 'Vysvětlení';
$string['extendenrol'] = 'Prodloužit platnost zápisu (individuálně)';
$string['extendperiod'] = 'Délka prodloužení';
$string['failedloginattempts'] = '{$a->attempts} neúspěšných pokusů o přihlášení od posledního přihlášení';
$string['failedloginattemptsall'] = '{$a->attempts} neúspěšných pokusů o přihlášení u {$a->accounts} uživatelských účtů';
$string['feedback'] = 'Komentář';
$string['file'] = 'Soubor';
$string['fileexists'] = 'Již zde existuje soubor se stejným názvem: {$a}';
$string['filemissing'] = '{$a} chybí';
$string['files'] = 'Soubory';
$string['filesanduploads'] = 'Soubory a nahrávání';
$string['filesfolders'] = 'Soubory/složky';
$string['filetoolarge'] = 'soubor je příliš veliký';
$string['fileuploadwithcontent'] = 'Neočekávaný parametr "content" při nahrávání souboru.';
$string['filloutallfields'] = 'Vyplňte prosím všechna pole v tomto formuláři';
$string['filter'] = 'Filtr';
$string['findmorecourses'] = 'Najít více kurzů...';
$string['first'] = 'První';
$string['firstaccess'] = 'První přihlášení';
$string['firstname'] = 'Křestní jméno';
$string['firstnamephonetic'] = 'Jméno - foneticky';
$string['firstsiteaccess'] = 'První přihlášení';
$string['firsttime'] = 'Jste tady poprvé?';
$string['folder'] = 'Složka';
$string['folderclosed'] = 'Zavřená složka';
$string['folderopened'] = 'Otevřená složka';
$string['followingoptional'] = 'Následující položky jsou volitelné';
$string['followingrequired'] = 'Následující položky jsou povinné';
$string['for'] = 'Pro';
$string['force'] = 'Vnucovat';
$string['forcelanguage'] = 'Vnutit jazyk';
$string['forceno'] = 'Nevnucovat';
$string['forcepasswordchange'] = 'Vnutit změnu hesla';
$string['forcepasswordchangecheckfull'] = 'Jste si jistí, že chcete vynutit změnu hesla u {$a} ?';
$string['forcepasswordchange_help'] = '<p>Při svém příštím přihlášení bude uživatel vyzván ke změně hesla.</p>';
$string['forcepasswordchangenot'] = 'Nelze vynutit změnu hesla u {$a}';
$string['forcepasswordchangenotice'] = 'Před pokračováním si musíte změnit heslo.';
$string['forcetheme'] = 'Vnutit motiv';
$string['forgotaccount'] = 'Zapomněli jste heslo?';
$string['forgotten'] = 'Zapomněli jste své uživatelské jméno či heslo?';
$string['forgottenduplicate'] = 'Tato emailová adresa je sdílena několika účty, prosím použijte uživatelské jméno';
$string['forgotteninvalidurl'] = 'Neplatné heslo - reset URL';
$string['format'] = 'Uspořádání';
$string['format_help'] = 'Uspořádání kurzu určuje vzhled hlavní stránky kurzu.

* Jedna činnost - Pro zobrazení jediné činnosti nebo studijního materiálu (např. Test nebo SCORM balíček)
* Diskusní uspořádání - Na stránce kurzu je zobrazeno diskusní fórum
* Tematické uspořádání - Obsah je uspořádán v sekcích, z nichž každá představuje jedno téma
* Týdenní uspořádání - Obsah je uspořádání v sekcích, z nichž každá představuje jeden týden. První týden začíná dnem začátku kurzu.';
$string['formathtml'] = 'Formát HTML';
$string['formatmarkdown'] = 'Formát Markdown';
$string['formatplain'] = 'Čistě textový formát';
$string['formattext'] = 'Moodle auto-formát';
$string['formattexttype'] = 'Formátování';
$string['framesetinfo'] = 'Dokument v rámcích obsahuje:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Kategorizovaný seznam kurzů';
$string['frontpagecategorynames'] = 'Seznam kategorií';
$string['frontpagecourselist'] = 'Seznam kurzů';
$string['frontpagecoursesearch'] = 'Pole pro vyhledávání kurzu';
$string['frontpagedescription'] = 'Popis titulní strany';
$string['frontpagedescriptionhelp'] = 'Tento popis lze zobrazit na titulní stránce pomocí bloku Popis kurzu/stránek nebo zobrazením úvodní sekce na titulní stránce.';
$string['frontpageenrolledcourselist'] = 'Zapsané kurzy';
$string['frontpageformat'] = 'Uspořádání titulní strany';
$string['frontpageformatloggedin'] = 'Uspořádání titulní strany po přihlášení';
$string['frontpagenews'] = 'Novinky';
$string['frontpagesettings'] = 'Nastavení titulní stránky';
$string['fulllistofcourses'] = 'Všechny kurzy';
$string['fullname'] = 'Celý název';
$string['fullnamecourse'] = 'Celý název';
$string['fullnamecourse_help'] = 'Úplný název kurzu se zobrazuje v horní části každé stránky v kurzu a v seznamech kurzů.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Celý název';
$string['fullprofile'] = 'Celý profil';
$string['fullsitename'] = 'Celý název stránek';
$string['functiondisabled'] = 'Tato funkce je momentálně vypnutá';
$string['general'] = 'Obecné';
$string['geolocation'] = 'zeměpisná šířka - délka';
$string['gettheselogs'] = 'Zobrazit protokol';
$string['go'] = 'Proveď';
$string['gpl'] = 'Copyright (C) 1999 a dále Martin Dougiamas  (http://moodle.com)

Tento program je volný software; můžete jej šířit a modifikovat podle ustanovení Obecné veřejné licence GNU, vydávané Free Software Foundation; a to buď podle verze 2 této licence anebo (podle vašeho uvážení) kterékoli pozdější verze.

Tento program je rozšiřován v naději, že bude užitečný, avšak BEZ JAKÉKOLI ZÁRUKY; neposkytují se ani odvozené záruky PRODEJNOSTI anebo VHODNOSTI PRO URČITÝ ÚČEL. Další podrobnosti hledejte na stránce
http://docs.moodle.org/dev/License a v Obecné veřejné licenci GNU:

http://www.gnu.cz/
http://www.gnu.org/copyleft/gpl.html';
$string['gpl3'] = 'Copyright (C) 1999 a dále Martin Dougiamas (http://moodle.com)

Tento program je svobodný software: můžete jej šířit a upravovat
podle ustanovení Obecné veřejné licence GNU (GNU General
Public Licence), vydávané Free Software Foundation a to buď
podle 3. verze této Licence, nebo (podle vašeho uvážení)
kterékoli pozdější verze.

Tento program je rozšiřován v naději, že bude užitečný, avšak
BEZ JAKÉKOLIV ZÁRUKY. Neposkytují se ani odvozené záruky
PRODEJNOSTI anebo VHODNOSTI PRO URČITÝ ÚČEL. Další podrobnosti hledejte na stránce
http://docs.moodle.org/dev/License

Kopii Obecné veřejné licence GNU jste měli obdržet spolu s tímto
programem. Pokud se tak nestalo, najdete ji na
http://www.gnu.org/licenses/ a její český překlad na
http://www.gnugpl.cz/.';
$string['gpllicense'] = 'GPL licence';
$string['grade'] = 'Známka';
$string['grades'] = 'Známky';
$string['gravatarenabled'] = 'Pokud máte svůj profilový obrázek umístěný na serveru <a href="http://www.gravatar.com/">Gravatar</a>, může být použít i na těchto stránkách.';
$string['group'] = 'Skupina';
$string['groupadd'] = 'Přidat novou skupinu';
$string['groupaddusers'] = 'Přidat vybrané do skupiny';
$string['groupextendenrol'] = 'Prodloužit platnost zápisu všem';
$string['groupfor'] = 'pro skupinu';
$string['groupinfo'] = 'Informace o vybrané skupině';
$string['groupinfoedit'] = 'Upravit nastavení skupiny';
$string['groupinfomembers'] = 'Informace o vybraných členech';
$string['groupinfopeople'] = 'Informace o vybraných lidech';
$string['groupmembers'] = 'Členové skupiny';
$string['groupmemberssee'] = 'Zobrazit seznam členů skupiny';
$string['groupmembersselected'] = 'Členové vybrané skupiny';
$string['groupmode'] = 'Režim skupin';
$string['groupmodeforce'] = 'Vnutit režim skupin';
$string['groupmy'] = 'Moje skupina';
$string['groupnonmembers'] = 'Lidé mimo skupinu';
$string['groupnotamember'] = 'Je mi líto, ale nejste členy této skupiny';
$string['grouprandomassign'] = 'Náhodně rozdělit do skupin';
$string['groupremove'] = 'Odstranit vybrané skupiny';
$string['groupremovemembers'] = 'Odstranit vybrané členy';
$string['groups'] = 'Skupiny';
$string['groupsnone'] = 'Žádné skupiny';
$string['groupsseparate'] = 'Oddělené skupiny';
$string['groupsvisible'] = 'Viditelné skupiny';
$string['guest'] = 'Host';
$string['guestdescription'] = 'Hosti mají minimální práva a obvykle nemohou nikam vkládat texty';
$string['guestskey'] = 'Povolit hostům s klíčem';
$string['guestsno'] = 'Zakázat hostům';
$string['guestsnotallowed'] = 'Je mi líto, \'{$a}\' neumožňuje vstup pro hosty.';
$string['guestsyes'] = 'Povolit hostům i bez klíče';
$string['guestuser'] = 'Nepřihlášený host';
$string['guestuserinfo'] = 'Tomuto zvláštnímu uživateli je umožněno vstupovat do některých kurzů s přístupovými právy čtenáře.';
$string['help'] = 'Nápověda';
$string['helpprefix2'] = 'Pomoc s  {$a}';
$string['helpwiththis'] = 'Pomoc s tímto';
$string['hiddenassign'] = 'Skryté přidělení rolí';
$string['hiddenfromstudents'] = 'Skryté před studenty';
$string['hiddensections'] = 'Skryté sekce';
$string['hiddensectionscollapsed'] = 'Skryté sekce se zobrazují ve sbalené formě';
$string['hiddensections_help'] = '<p>Tato volba umožňuje nastavit, jak se budou studentům zobrazovat skryté sekce
kurzu.</p>

<p>Ve výchozím nastavení se studentům zobrazí malá (obvykle šedá) plocha, která
označuje umístění skryté sekce, neobsahuje však ani odkazy na činnosti, ani
texty vepsané přímo do těla sekce. Tento způsob je výhodný především u
týdenního uspořádání kurzu, protože umožňuje zřetelně označit týdny, v nichž se
nekoná výuka.</p>

<p>Druhou možností je skrýt sekce úplně, takže studenti nebudou o jejich
umístění v kurzu vůbec vědět.</p>';
$string['hiddensectionsinvisible'] = 'Skryté sekce se nezobrazují vůbec';
$string['hide'] = 'Skrýt';
$string['hideadvancedsettings'] = 'Skrýt pokročilá nastavení';
$string['hidepicture'] = 'Skrýt obrázek';
$string['hidesection'] = 'Skrýt sekci {$a}';
$string['hidesettings'] = 'Skrýt nastavení';
$string['hideshowblocks'] = 'Skrýt nebo ukázat postranní bloky';
$string['hits'] = 'Četnost přístupů';
$string['hitsoncourse'] = 'Četnost přístupů uživatele {$a->username} do kurzu {$a->coursename}';
$string['hitsoncoursetoday'] = 'Dnešní četnost přístupů uživatele {$a->username} do kurzu {$a->coursename}';
$string['home'] = 'Titulní stránka';
$string['hour'] = 'hodina';
$string['hours'] = 'hodin';
$string['howtomakethemes'] = 'Jak vytvářet nové motivy';
$string['htmleditor'] = 'Použít HTML editor';
$string['htmleditoravailable'] = 'HTML editor je k dispozici';
$string['htmleditordisabled'] = 'Používání HTML editoru máte zakázáno ve svém uživatelském profilu.';
$string['htmleditordisabledadmin'] = 'Správce zakázal používání HTML editoru na těchto stránkách.';
$string['htmleditordisabledbrowser'] = 'HTML editor není k dispozici, protože nepoužíváte podporovaný prohlížeč.';
$string['htmlfilesonly'] = 'Pouze HTML soubory';
$string['htmlformat'] = 'Formát HTML';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'ICQ';
$string['idnumber'] = 'ID';
$string['idnumbercourse'] = 'Identifikátor (ID) kurzu';
$string['idnumbercoursecategory'] = 'Identifikátor kategorie';
$string['idnumbercoursecategory_help'] = 'Identifikátor kategorie kurzů slouží pro účely případné synchronizace s externími systémy a párování dat. Tento identifikátor se nikde nezobrazuje. Pokud nevíte, ponechte pole prázdné.';
$string['idnumbercourse_help'] = '<p>Identifikační číslo kurzu (ID) se používá pouze v případě propojení kurzu
s externím systémem, v Moodlu se ID nikde nezobrazuje. Pokud má váš kurz
přidělen oficiální kód, napište jej zde. Nebo ponechte pole nevyplněné.</p>';
$string['idnumbergroup'] = 'ID číslo skupiny';
$string['idnumbergroup_help'] = 'Tento identifikátor skupiny se používá pouze při komunikaci s externími systémy a není zobrazován nikde na těchto stránkách. Pokud má tato skupina nějaké jednoznačné kódové označení, můžete je sem vložit. Jinak ponechte pole prázdné.';
$string['idnumbergrouping'] = 'ID číslo seskupení';
$string['idnumbergrouping_help'] = 'Tento identifikátor seskupení se používá pouze při komunikaci s externími systémy a není zobrazován nikde na těchto stránkách. Pokud má toto seskupení nějaké jednoznačné kódové označení, můžete je sem vložit. Jinak ponechte pole prázdné.';
$string['idnumbermod'] = 'Identifikátor';
$string['idnumbermod_help'] = 'Identifikátor umožňuje pracovat se známkou za činnost při výpočtu souhrnných známek. Není-li činnost zahrnuta do výpočtu známek, lze nechat pole pro identifikátor prázdné.

Identifikátor lze definovat také na stránce pro zadání/změnu výpočtu známky, upravovat jej však lze pouze na stránce pro úpravu činnosti.';
$string['idnumbertaken'] = 'Tento identifikátor (ID) již někdo používá';
$string['imagealt'] = 'Popis obrázku';
$string['import'] = 'Importovat';
$string['importdata'] = 'Importovat data kurzu';
$string['importdataexported'] = 'Data úspěšně exportována z kurzu \'Z\'.<br />Pokračujte importem do vašeho kurzu \'DO\'.';
$string['importdatafinished'] = 'Import dokončen! Přejděte do vašeho kurzu';
$string['importdatafrom'] = 'Najděte kurz,  Z něhož chcete importovat data:';
$string['inactive'] = 'Neaktivní';
$string['include'] = 'Zahrnout';
$string['includeallusers'] = 'Zahrnout všechny uživatele';
$string['includecoursefiles'] = 'Zahrnout soubory v kurzu';
$string['includecourseusers'] = 'Zahrnout uživatele v kurzu';
$string['included'] = 'Zahrnuto';
$string['includelogentries'] = 'Zahrnout protokoly';
$string['includemodules'] = 'Zahrnout moduly';
$string['includemoduleuserdata'] = 'Zahrnout uživatelská data modulu';
$string['includeneededusers'] = 'Zahrnout nezbytné uživatele';
$string['includenoneusers'] = 'Nezahrnout žádné uživatele';
$string['includeroleassignments'] = 'Zahrnout přiřazení rolí';
$string['includesitefiles'] = 'Zahrnout soubory stránek použité v tomto kurzu';
$string['includeuserfiles'] = 'Zahrnout soubory uživatelů';
$string['increasesections'] = 'Zvýšit počet témat';
$string['info'] = 'Informace';
$string['institution'] = 'Instituce';
$string['instudentview'] = 'v pohledu studenta';
$string['interests'] = 'Zájmy';
$string['interestslist'] = 'Zájmy a koníčky';
$string['interestslist_help'] = 'Zadejte své zájmy, oddělené čárkami. Vaše zájmy budou zobrazeny na stránce vašeho profilu jako štítky.';
$string['invalidemail'] = 'Neplatná e-mailová adresa';
$string['invalidlogin'] = 'Neplatné přihlášení, zkuste znovu';
$string['invalidusername'] = 'Uživatelské jméno může obsahovat pouze malá písmena, číslice, podtržítko (_), pomlčku (-), tečku (.) nebo zavináč (@)';
$string['invalidusernameupload'] = 'Neplatné uživatelské jméno';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Přejít';
$string['jumpto'] = 'Přejít na...';
$string['keep'] = 'Uchovat';
$string['keepsearching'] = 'Pokračujte v hledání příjemců';
$string['langltr'] = 'Psát zleva doprava';
$string['langrtl'] = 'Psát zprava doleva';
$string['language'] = 'Jazyk';
$string['languagegood'] = 'Tento jazykový balíček je aktuální. :-)';
$string['last'] = 'Poslední';
$string['lastaccess'] = 'Poslední přístup';
$string['lastcourseaccess'] = 'Poslední přístup do kurzu';
$string['lastedited'] = 'Naposledy upraveno';
$string['lastlogin'] = 'Poslední přihlášení';
$string['lastmodified'] = 'Naposledy změněno';
$string['lastname'] = 'Příjmení';
$string['lastnamephonetic'] = 'Příjmení - foneticky';
$string['lastsiteaccess'] = 'Poslední přístup';
$string['lastyear'] = 'Poslední rok';
$string['latestlanguagepack'] = 'Zkontrolovat poslední verzi jazykového balíčku na moodle.org';
$string['layouttable'] = 'Uspořádání tabulky';
$string['leavetokeep'] = 'Ponechte prázdné, chcete-li zachovat dosavadní heslo.';
$string['legacythemeinuse'] = 'Tyto stránky se vám zobrazují v režimu kompatibility, protože používáte zastaralý prohlížeč.';
$string['license'] = 'Licence';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Chcete se nyní přihlásit jako plnohodnotný uživatel?';
$string['list'] = 'Seznam';
$string['listfiles'] = 'Seznam souborů v {$a}';
$string['listofallpeople'] = 'Seznam všech osob';
$string['listofcourses'] = 'Seznam kurzů';
$string['loadinghelp'] = 'Nahrávám ...';
$string['local'] = 'Lokální';
$string['localplugins'] = 'Lokální moduly';
$string['localpluginsmanage'] = 'Správa lokálních modulů';
$string['location'] = 'Umístění';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Jste přihlášeni jako {$a}';
$string['loggedinasguest'] = 'Momentálně na stránky přistupujete s právy hosta.';
$string['loggedinnot'] = 'Nejste přihlášeni';
$string['login'] = 'Přihlásit se';
$string['loginalready'] = 'Již jste přihlášeni jako';
$string['loginas'] = 'Přihlásit se jako';
$string['loginaspasswordexplain'] = '<p>Pro použití této funkce musíte zadat speciální heslo.<br />Pokud toto heslo neznáte, vyžádejte si jej od správce těchto stránek.</p>';
$string['login_failure_logs'] = 'Protokoly o neúspěšných pokusech o přihlášení';
$string['loginguest'] = 'Přihlásit se jako host';
$string['loginsite'] = 'Přihlásit se na stránky';
$string['loginsteps'] = 'Zdravím! K plnému přístupu do kurzů budete muset strávit minutku vytvořením svého uživatelského účtu. Jednotlivé kurzy mohou rovněž požadovat tzv. "klíč k zápisu", ale ten budete potřebovat až později. Postupujte podle následujících kroků:
<ol>
<li>Vyplňte formulář <a href="{$a}">Nový účet</a>.</li>
<li>Na vaši adresu bude zaslán e-mail s vygenerovaným webovým odkazem.</li>
<li>Navštivte webovou adresu, která je vám zaslána.</li>
<li>Váš účet tím bude potvrzen a vy budete přihlášeni.</li>
<li>Poté si vyberte kurz, jehož se chcete účastnit.</li>
<li>Pokud budete vyzváni k vložení "klíče k zápisu", zadejte text, který jste dostali od učitele kurzu. Tím se "zapíšete" do kurzu.</li>
<li>Pak již máte přístup k celému kurzu. Pro přihlášení a přístup do všech kurzů, v nichž jste zapsáni, budete napříště zadávat už jenom své uživatelské jméno a heslo (do formuláře na této stránce).</li>
</ol>';
$string['loginstepsnone'] = '<p>Zdravím!</p>
<p>K plnému přístupu do kurzů si budete muset vytvořit uživatelský účet.</p>
<p>Stačí vám pouze vymyslet si uživatelské jméno a heslo a zadat jej do formuláře na této stránce!</p>
<p>Pokud vás někdo předběhl a vaše uživatelské jméno si již zaregistroval, budete to muset zkusit znovu s jiným jménem.</p>';
$string['loginto'] = 'Zapsat se do {$a}';
$string['logout'] = 'Odhlásit se';
$string['logoutconfirm'] = 'Opravdu se chcete odhlásit?';
$string['logs'] = 'Protokoly';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">více</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">více</a> ]';
$string['lookback'] = 'Zpětně';
$string['mailadmins'] = 'Informuj správce';
$string['mailstudents'] = 'Informuj studenty';
$string['mailteachers'] = 'Informuj učitele';
$string['maincoursepage'] = 'Hlavní stránka kurzu';
$string['makeafolder'] = 'Vytvořit složku';
$string['makeeditable'] = 'Nastavíte-li práva k \'{$a}\' tak, aby do něj mohl zapisovat proces webového serveru (např. apache), budete moci upravovat tento soubor přímo na této stránce.';
$string['makethismyhome'] = 'Vytvořit z tohoto moji defaultní domovskou stránku';
$string['manageblocks'] = 'Bloky';
$string['managecategorythis'] = 'Spravovat tuto kategorii';
$string['managecourses'] = 'Správa kurzů';
$string['managedatabase'] = 'Správa databáze';
$string['manageeditorfiles'] = 'Spravovat soubory používané editorem';
$string['managefilters'] = 'Filtry';
$string['managemodules'] = 'Moduly';
$string['manageroles'] = 'Role a oprávnění';
$string['markedthistopic'] = 'Toto téma je zvýrazněno jako aktuální';
$string['markthistopic'] = 'Označit toto téma jako aktuální';
$string['matchingsearchandrole'] = 'Odpovídá \'{$a->search}\' a {$a->role}';
$string['maxareabytesreached'] = 'Velikost souboru (nebo celková velikost všech souborů) převyšuje nastavený limit pro tuto oblast.';
$string['maxbytesforfile'] = 'Velikost souboru {$a} převyšuje nastavený limit.';
$string['maxfilesize'] = 'Maximální velikost nových souborů: {$a}';
$string['maxfilesreached'] = 'K této položce máto povoleno připojit maximálně {$a} souborů';
$string['maximumchars'] = 'Maximálně {$a} znaků';
$string['maximumgrade'] = 'Nejlepší známka';
$string['maximumgradex'] = 'Nejvyšší známka: {$a}';
$string['maximumshort'] = 'Max';
$string['maximumupload'] = 'Maximální velikost nahrávaných souborů';
$string['maximumupload_help'] = '<p>Toto nastavení určuje maximální velikost souboru, který mohou do kurzu
vložit studenti. Učitel je při jejím stanovování omezen tím, jakou maximální
velikost souboru pro celý systém nastavil správce.</p>

<p>Velikost souboru můžete dále omezit nastavením u jednotlivých modulů
činností.</p>';
$string['maxnumberweeks'] = 'Nejvyšší možný počet sekcí kurzu';
$string['maxnumberweeks_desc'] = 'Tímto nastavíte nejvyšší hodnotu, která se zobrazí v nabídce pro nastavení počtu sekcí kurzu (platí pouze pro některá uspořádání kurzu).';
$string['maxnumcoursesincombo'] = 'Zobrazit <a href="{$a->link}">seznam všech {$a->numberofcourses} kurzů</a>';
$string['maxsize'] = 'Maximální velikost: {$a}';
$string['maxsizeandareasize'] = 'Maximální velikost pro nové soubory: {$a->size}, celkový limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximální velikost nových souborů: {$a->size}, maximální přílohy: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximální velikost pro nové soubory: {$a->size}, maximální počet příloh: {$a->attachments}, celkový limit: {$a->areasize}';
$string['memberincourse'] = 'Lidé v kurzu';
$string['messagebody'] = 'Tělo zprávy';
$string['messagedselectedusers'] = 'Zpráva byla odeslána vybraným uživatelům a seznam příjemců byl resetován.';
$string['messagedselectedusersfailed'] = 'Objevily se problémy při odesílání zprávy vybraným uživatelům. Někteří z nich mohou obdržet e-mail.';
$string['messageprovider:availableupdate'] = 'Jsou dostupná oznámení o aktualizacích';
$string['messageprovider:backup'] = 'Zprávy o záloze';
$string['messageprovider:badgecreatornotice'] = 'Oznámení tvůrce Odznaku';
$string['messageprovider:badgerecipientnotice'] = 'Oznámení příjemce Odznaku';
$string['messageprovider:courserequestapproved'] = 'Schválení žádosti o založení kurzu';
$string['messageprovider:courserequested'] = 'Nová žádost o založení kurzu';
$string['messageprovider:courserequestrejected'] = 'Zamítnutí žádosti o založení kurzu';
$string['messageprovider:errors'] = 'Důležité chyby stránek';
$string['messageprovider:errors_help'] = 'Toto jsou důležité chyby, o kterých by měl vědět správce';
$string['messageprovider:instantmessage'] = 'Osobní vzkazy mezi uživateli';
$string['messageprovider:instantmessage_help'] = 'Tato sekce obsahuje nastavení toho, co se děje se zprávami, které Vám byly poslány jinými uživateli těchto stránek. ';
$string['messageprovider:notices'] = 'Upozornění na menší problémy';
$string['messageprovider:notices_help'] = 'Toto jsou různá upozornění, která by mohla zajímat správce.';
$string['messageselect'] = 'Vybrat uživatele jako příjemce e-mailu';
$string['messageselectadd'] = 'Poslat zprávu';
$string['middlename'] = 'Druhé jméno';
$string['migratinggrades'] = 'Migrace známek';
$string['min'] = 'min.';
$string['mins'] = 'min.';
$string['minute'] = 'minuta';
$string['minutes'] = 'minuty';
$string['miscellaneous'] = 'Různé';
$string['missingcategory'] = 'Musíte vybrat kategorii';
$string['missingcity'] = 'Chybí město/obec';
$string['missingcountry'] = 'Chybí země';
$string['missingdescription'] = 'Chybí popis';
$string['missingemail'] = 'Chybí e-mailová adresa';
$string['missingfirstname'] = 'Chybí křestní jméno';
$string['missingfromdisk'] = 'Chybí na disku';
$string['missingfullname'] = 'Chybí celý název';
$string['missinglastname'] = 'Chybí příjmení';
$string['missingname'] = 'Chybí název';
$string['missingnewpassword'] = 'Chybí nové heslo';
$string['missingpassword'] = 'Chybí heslo';
$string['missingrecaptchachallengefield'] = 'Chybí pole s výzvou reCAPTCHA';
$string['missingreqreason'] = 'Chybí důvod';
$string['missingshortname'] = 'Chybí krátký název';
$string['missingshortsitename'] = 'Chybí krátký název stránek';
$string['missingsitedescription'] = 'Chybí popis stránek';
$string['missingsitename'] = 'Chybí název stránek';
$string['missingstrings'] = 'Najít nepřeložené texty';
$string['missingstudent'] = 'Musíte někoho vybrat';
$string['missingsummary'] = 'Chybí souhrn';
$string['missingteacher'] = 'Musíte někoho vybrat';
$string['missingurl'] = 'Chybí URL';
$string['missingusername'] = 'Chybí uživatelské jméno';
$string['modchooserdisable'] = 'Vypnout průvodce přidáním obsahu';
$string['modchooserenable'] = 'Zapnout průvodce přidáním obsahu';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} nepodporuje nahrávání souboru typu {$a->type}';
$string['modified'] = 'Změněno';
$string['moduleintro'] = 'Popis';
$string['modulesetup'] = 'Nastavování tabulek modulů';
$string['modulesuccess'] = 'Tabulky modulu \'{$a}\' byly korektně nastaveny';
$string['modulesused'] = 'Použité moduly';
$string['month'] = 'Měsíc';
$string['months'] = 'Měsíce';
$string['moodledocs'] = 'Dokumentace Moodle';
$string['moodledocslink'] = 'Dokumentace k této stránce';
$string['moodlerelease'] = 'Vydání Moodlu';
$string['moodleversion'] = 'Verze Moodlu';
$string['more'] = 'více';
$string['morehelp'] = 'Podrobnější nápověda';
$string['moreinformation'] = 'Více informací o této chybě';
$string['moreprofileinfoneeded'] = 'Prosíme, sdělte nám o sobě něco bližšího';
$string['mostrecently'] = 'nejnovější';
$string['move'] = 'Přesunout';
$string['movecategoriessuccess'] = 'Úspěšně přesunuty {$a->count} kategorie do kategorie  "{$a->to}"';
$string['movecategoriestotopsuccess'] = 'Úspěšně přesunuto {$a->count} kategorií do nejvyšší úrovně';
$string['movecategorycontentto'] = 'Přesunout do';
$string['movecategorysuccess'] = 'Kategorie "{$a->moved}" úspěšně přesunuta do kategorie "{$a->to}"';
$string['movecategoryto'] = 'Přesunout kategorii do:';
$string['movecategorytotopsuccess'] = 'Kategorie "{$a->moved}" úspěšně přesunuta do nejvyšší úrovně';
$string['movecontent'] = 'Přesun {$a}';
$string['movecontentstoanothercategory'] = 'Přesunout obsah do jiné kategorie';
$string['movecoursemodule'] = 'Přesunout materiál';
$string['movecoursesection'] = 'Přesunout sekci';
$string['movecourseto'] = 'Přesunout kurz do:';
$string['movedown'] = 'Přesunout dolů';
$string['movefilestohere'] = 'Přesunout soubory sem';
$string['movefull'] = 'Přesunout {$a} do tohoto umístění';
$string['movehere'] = 'Přesunout sem';
$string['moveleft'] = 'Přesunout doleva';
$string['moveright'] = 'Přesunout doprava';
$string['movesection'] = 'Přesunout sekci {$a}';
$string['moveselectedcategoriesto'] = 'Přesun vybraných kategorií do';
$string['moveselectedcoursesto'] = 'Přesunout vybrané kurzy do...';
$string['movetoanotherfolder'] = 'Přesunout do jiné složky';
$string['moveup'] = 'Přesunout nahoru';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Nové heslo musí být jiné než stávající';
$string['mustconfirm'] = 'Musíte potvrdit vaše přihlášení';
$string['mycourses'] = 'Moje kurzy';
$string['myfiles'] = 'Osobní soubory';
$string['myfilesmanage'] = 'Spravovat osobní soubory';
$string['myhome'] = 'Moje stránka';
$string['mymoodledashboard'] = 'Moje osobní stránka';
$string['myprofile'] = 'Můj profil';
$string['name'] = 'Název';
$string['nameforlink'] = 'Jak chcete nazvat tento odkaz?';
$string['nameforpage'] = 'Název';
$string['navigation'] = 'Navigace';
$string['needed'] = 'Potřebné';
$string['never'] = 'Nikdy';
$string['neverdeletelogs'] = 'Nikdy nemazat protokoly';
$string['new'] = 'Nový';
$string['newaccount'] = 'Nový účet';
$string['newcourse'] = 'Nový kurz';
$string['newpassword'] = 'Nové heslo';
$string['newpasswordfromlost'] = '<strong>Poznámka:</strong> Vaše <strong>stávající heslo</strong> vám bude zasláno v <strong>druhém</strong> ze dvou e-mailů zaslaných v rámci procesu obnovy zapomenutého hesla. Než budete pokračovat, ujistěte se, že jste obdrželi své náhradní heslo.';
$string['newpassword_help'] = 'Vložte nové heslo nebo ponechte prázdné pro zachování stávajícího';
$string['newpasswordtext'] = 'Zdravicko, vy budete asi {$a->firstname}, ze?

Vase stare heslo na strankach \'{$a->sitename}\' bylo vymazano a bylo vam prideleno nove docasne heslo.

Pri prihlaseni nyni zadejte
uzivatelske jmeno: {$a->username}
heslo: {$a->newpassword}

Heslo si muzete zmenit na teto strance:
{$a->link}

Ve vetsine e-mailovych programu by se vam tato adresa mela zobrazit jako odkaz, na ktery staci kliknout. Pokud tomu tak neni, zkopirujte si adresu do schranky a vlozte ji do adresniho radku ve svem webovem prohlizeci.

S pozdravem spravce stranek \'{$a->sitename}\',
{$a->signoff}';
$string['newpicture'] = 'Nový obrázek';
$string['newpicture_help'] = '<p>Zde můžete na svém počítači vybrat svoji fotografii a uložit ji na server.
Tato fotografie vás potom bude reprezentovat na různých místech těchto
stránek.</p>

<p>Z tohoto důvodu je nejlepší fotografie vašeho obličeje, ale můžete použít i
jiný obrázek.</p>

<p>Obrázek musí být ve formátu JPEG nebo PNG (nejčastěji tedy bude mít příponu
.jpg nebo .png).</p>

<p>Soubor s obrázkem lze získat různými způsoby:</p>

<ol>
  <li>Můžete použít digitální fotoaparát, ten již většinou ukládá fotografie v
  požadovaném formátu.</li>

  <li>Můžete si naskenovat svoji klasickou, papírovou fotografii. Výsledný
  obrázek uložte ve formátu JPEG nebo PNG.</li>

  <li>Obrázek můžete nakreslit v některém z grafických editorů.</li>

  <li>Poslední možností je vyhledat obrázky na webu. <a target="google" href=
  "http://images.google.com/">http://images.google.com</a> je skvělé místo, kde
  můžete obrázky vyhledávat. Pokud se vám některý zalíbí, klikněte na něj
  pravým tlačítkem myši a v nabídce zvolte "Uložit obrázek jako..." (různé
  prohlížeče se mohou v textu nabídky mírně lišit).</li>
</ol>

<p>Pro uložení obrázku na server klikněte na tlačítko "Procházet" na této
stránce a vyberte soubor s vaším obrázkem.</p>

<p>Poznámka: Ujistěte se, že soubor není větší než maximální dovolená velikost,
jinak nebude moci být na server uložen.</p>

<p>Poté klikněte na tlačítko "Aktualizovat profil". Váš obrázek bude oříznut na
čtvercový tvar a zmenšen na velikost 100 x 100 pixelů.</p>

<p>Až se vrátíte zpět na stránku s vaším profilem, možná budete muset kliknout
na tlačítko "Aktualizovat"/"Obnovit", aby prohlížeč znovu načetl stránku s
novou fotografií..</p>';
$string['newsitem'] = 'novinka';
$string['newsitems'] = 'novinek';
$string['newsitemsnumber'] = 'Kolik novinek ukazovat';
$string['newsitemsnumber_help'] = '<p>Zvláštní fórum nazývané "Novinky" se objevuje v kurzech s týdenním a
tematickým uspořádáním. Zde je možno umístit aktuální zprávy pro všechny
studenty. (Ve výchozím nastavení jsou všichni studenti přihlášeni k odebírání
příspěvků z tohoto fóra e-mailem, budou tudíž dostávat vaše zprávy.)</p>

<p>Toto nastavení určuje, kolik nejnovějších položek se objeví na stránce kurzu
vpravo ve sloupci "Poslední novinky".</p>

<p>Pokud nastavíte "0 novinek", sloupec novinek se nezobrazí.</p>';
$string['newuser'] = 'Nový uživatel';
$string['newusernewpasswordsubj'] = 'Novy uzivatelsky ucet';
$string['newusernewpasswordtext'] = 'Zdravím, vy budete asi {$a->firstname}, že?

Na stránkách \'{$a->sitename}\' vám byl zřízen nový uživatelský účet a bylo vám přiděleno nové dočasné heslo.

Při přihlášení nyní zadejte
  uživatelské jméno: {$a->username}
  heslo: {$a->newpassword}
(Po prvním přihlášení si budete muset toto heslo změnit)

Přihlasit na stránky "{$a->sitename}" se můžete na adrese:
{$a->link}

Ve většině e-mailových programů by se vám tato adresa mela zobrazit jako odkaz, na který stačí kliknout. Pokud tomu tak není, zkopírujte si adresu do schránky a vložte ji do adresního řádku ve svém webovém prohlížeči.

Toto je automaticky generovaný e-mail. Není nutné na něj odpovídat jeho odesílateli. Potřebujete-li pomoc, spojte se se správcem stránek.

S pozdravem
{$a->signoff}
správce stránek "{$a->sitename}"';
$string['newusers'] = 'Noví uživatelé';
$string['newwindow'] = 'nové okno';
$string['next'] = 'Další';
$string['nextsection'] = 'Další sekce';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Neexistují bloky, které by mohly být přidány na tuto stránku.';
$string['nobody'] = 'Nikdo';
$string['nochange'] = 'Beze změny';
$string['nocomments'] = 'Bez komentářů';
$string['nocourses'] = 'Žádné kurzy';
$string['nocoursesfound'] = 'Nebyly nalezeny žádné kurzy obsahující \'{$a}\'';
$string['nocoursesyet'] = 'Žádný kurz v této kategorii';
$string['nodstpresets'] = 'Správce nepovolil podporu letního a zimního času (DST).';
$string['nofilesselected'] = 'Nebyly vybrány žádné soubory k obnově';
$string['nofilesyet'] = 'Do kurzu ještě nebyly vloženy žádné soubory.';
$string['nograde'] = 'Bez známky';
$string['nohelpforactivityorresource'] = 'Pro tuto činnost nebo studijní materiál není k dispozici žádný popis.';
$string['noimagesyet'] = 'Do kurzu ještě nebyly vloženy žádné obrázky.';
$string['nologsfound'] = 'Nebyly nalezeny žádné protokoly';
$string['nomatchingusers'] = 'Žádní uživatelé neodpovídají \'{$a}\'';
$string['nomorecourses'] = 'Nebylo možno najít více odpovídajících kurzů.';
$string['nomoreidnumber'] = 'Z důvodu předcházení kolizí se již nepoužívá idnumber.';
$string['none'] = 'Žádný';
$string['noneditingteacher'] = 'Učitel bez práva upravovat';
$string['noneditingteacherdescription'] = 'Učitelé bez práva upravovat mohou učit v kurzech a známkovat studenty, nemohou však měnit činnosti.';
$string['nonstandard'] = 'Nestandardní';
$string['nopendingcourses'] = 'Žádné kurzy čekající na schválení';
$string['nopotentialadmins'] = 'Žádní správci k dispozici';
$string['nopotentialcreators'] = 'Žádní tvůrci kurzů k dispozici';
$string['nopotentialstudents'] = 'Žádní studenti k dispozici';
$string['nopotentialteachers'] = 'Žádní učitelé k dispozici';
$string['norecentactivity'] = 'Žádná nedávná činnost';
$string['noreplybouncemessage'] = 'Odpoveděli jste na adresu, na kterou nelze zasílat e-maily. Pokud jste se pokoušeli odpovídat na příspěvek v diskusním fóru, zašlete vaši odpověď přímo do příslušného diskusního fóra na stránkách "{$a}".

Následuje obsah vašeho e-mailu:';
$string['noreplybouncesubject'] = '{$a} - vraceny e-mail';
$string['noreplyname'] = 'Nedpovidejte na tento e-mail';
$string['noresetrecord'] = 'Neexistuje žádný záznam žádosti o obnovu hesla. Prosím, znovu zažádejte o resetování hesla.';
$string['noresults'] = 'Bez výsledků';
$string['normal'] = 'Normalní';
$string['normalfilter'] = 'Normální vyhledávání';
$string['nosite'] = 'Nelze najít kurzy na úrovni stránek';
$string['nostudentsfound'] = 'Nenalezeni žádní {$a}';
$string['nostudentsingroup'] = 'V této skupině dosud nejsou žádní studenti.';
$string['nostudentsyet'] = 'Do kurzu ještě nejsou zapsáni žádní studenti.';
$string['nosuchemail'] = 'Taková e-mailová adresa není registrována';
$string['notavailable'] = 'Není dostupné';
$string['noteachersyet'] = 'V tomto kurzu ještě nejsou žádní učitelé.';
$string['notenrolled'] = '{$a} není zapsán(a) do tohoto kurzu.';
$string['notenrolledprofile'] = 'Profil není dostupný, protože úživatel není zapsán v tomto kurzu';
$string['noteusercannotrolldatesoncontext'] = '<strong>Poznámka:</strong> Možnost posunu termínů při obnově této zálohy byla zakázána, protože nemáte potřebné oprávnění.';
$string['noteuserschangednonetocourse'] = '<strong>Poznámka:</strong> Pokud obnovujete uživatelské údaje, je nutné obnovit také uživatele kurzu. Toto nastavení bylo za vás změněno.';
$string['nothingnew'] = 'Nic nového od vašeho posledního přihlášení.';
$string['nothingtodisplay'] = 'Nic k zobrazení';
$string['notice'] = 'Poznámka';
$string['noticenewerbackup'] = 'Tato záloha byla vytvořena v Moodlu {$a->backuprelease} ({$a->backupversion}) a je novější, než vaše stávající instalace Moodlu {$a->serverrelease} ({$a->serverversion}). To může vést k nekonzistencím, protože u záloh nelze zaručit zpětnou kompatibilitu.';
$string['notifications'] = 'Informace';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Uzivatel: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Tyto protokoly si můžete prohlednout zde: {$a}/report/log/index.php?id=1&chooselog=1&modid=site_errors';
$string['notifyloginfailuresmessagestart'] = 'Zde je seznam neuspesnych pokusu o prihlaseni na {$a} od doby zaslani predchoziho upozorneni';
$string['notifyloginfailuressubject'] = '{$a} :: Upozorneni na neuspesna prihlaseni';
$string['notincluded'] = 'Nezahrnuto';
$string['notingroup'] = 'Je mi líto, ale pro přístup k této činnosti musíte být členem skupiny.';
$string['notpublic'] = 'Neveřejné!';
$string['nousersfound'] = 'Nenalezeni žádní uživatelé';
$string['nousersmatching'] = 'Na dotaz \'{$a}\' nebyl nalezen žádný uživatel.';
$string['nousersyet'] = 'Ještě nejsou k dispozici žádní uživatelé.';
$string['novalidcourses'] = 'Žádné kurzy k zobrazení';
$string['now'] = 'nyní';
$string['numattempts'] = '{$a} neúspěšných pokusů o přihlášení';
$string['numberofcourses'] = 'Počet kurzů ';
$string['numberweeks'] = 'Počet sekcí';
$string['numdays'] = '{$a} dnů';
$string['numhours'] = '{$a} hodin';
$string['numletters'] = '{$a} znaků';
$string['numminutes'] = '{$a} minut';
$string['nummonths'] = '{$a} měsíců';
$string['numseconds'] = '{$a} sekund';
$string['numviews'] = '{$a} zobrazení';
$string['numweeks'] = '{$a} týdnů';
$string['numwords'] = '{$a} slov';
$string['numyears'] = '{$a} roků';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Stávající heslo';
$string['olduserdirectory'] = 'Toto je STARÝ adresář uživatelů, který již není používán. Můžete jej bezpečně odstranit. Soubory, které obsahoval, byly zkopírovány do NOVÉHO adresáře uživatelů.';
$string['opentoguests'] = 'Přístup pro hosty';
$string['optional'] = 'volitelné';
$string['options'] = 'možnosti';
$string['order'] = 'Pořadí';
$string['originalpath'] = 'Původní umístění';
$string['orphanedactivitiesinsectionno'] = 'Osiřené činnosti (sekce {$a})';
$string['other'] = 'Jiný';
$string['outline'] = 'Stručný';
$string['outlinereport'] = 'Stručná sestava';
$string['page'] = 'Stránka';
$string['pagea'] = 'Stránka {$a}';
$string['pageheaderconfigablock'] = 'Konfigurace bloku v {$a->fullname}';
$string['pagepath'] = 'Cesta ke stránce';
$string['pageshouldredirect'] = 'Tato stránka by vás měla automaticky přesměrovat. Pokud se tak nestalo, použijte, prosím, následující odkaz.';
$string['parentcategory'] = 'Nadřazená kategorie';
$string['parentcoursenotfound'] = 'Nadřazený kurz nenalezen!';
$string['parentfolder'] = 'Nadřazená složka';
$string['participants'] = 'Účastníci';
$string['participantslist'] = 'Seznam účastníků';
$string['participationratio'] = 'Poměr participace';
$string['participationreport'] = 'Protokol participace';
$string['password'] = 'Heslo';
$string['passwordchanged'] = 'Heslo bylo změněno';
$string['passwordconfirmchange'] = 'Potvrďte změnu hesla';
$string['passwordextlink'] = 'Pomocí následujícího odkazu můžete obnovit své zapomenuté heslo. Kliknutím na odkaz opustíte stránky Moodlu.';
$string['passwordforgotten'] = 'Zapomenuté heslo';
$string['passwordforgotteninstructions'] = 'Nejprve je potřeba vyhledat údaje o vašem účtu v databázi uživatelů. Prosím, zadejte <strong>buď</strong> své uživatelské jméno, <strong>nebo</strong> registrovaný e-mail. Není potřeba vyplňovat obě pole.';
$string['passwordforgotteninstructions2'] = 'Pro resetování hesla níže vložte vaše uživatelské jméno nebo emailovou adresu. Pokud se podaří Vás najít v databázi, bude na Vaší e-mailovou adresu odeslán mail s instrukcemi, jak znova získat přístup.';
$string['passwordnohelp'] = 'Pro nalezení vašeho zapomenutého hesla není k dispozici žádná další pomoc. Obraťte se prosím na správce těchto stránek.';
$string['passwordrecovery'] = 'Ano, pomoz mi se přihlásit';
$string['passwordsdiffer'] = 'Tato hesla nejsou shodná.';
$string['passwordsent'] = 'Heslo bylo odesláno';
$string['passwordsenttext'] = '<p>
Na vaši adresu {$a->email} byl odeslán e-mail
<p>
<b>s vaším novým heslem.</b>
<p>
Nové heslo bylo vygenerováno automaticky, pokud budete chtít, můžete si je kdykoliv <a href={$a->link}>změnit</a>.';
$string['passwordset'] = 'Vaše heslo bylo nastaveno.';
$string['path'] = 'Cesta';
$string['pathnotexists'] = 'Taková cesta na serveru neexistuje!!';
$string['pathslasherror'] = 'Cesta nesmí končit lomítkem!!';
$string['paymentinstant'] = 'Pomocí tlačítka níže můžete provést platbu a během několika minut se zapsat do kurzu!';
$string['paymentpending'] = '(<small><strong><u>{$a}</u></strong> čeká</small>)';
$string['paymentrequired'] = 'Tento kurz je placený';
$string['payments'] = 'Platby';
$string['paymentsorry'] = 'Díky za vaši platbu! Naneštěstí však ještě úplně neproběhla a dosud nejste registrováni pro vstup do kurzu "{$a->fullname}". Zkuste ještě chvíli počkat a vstupte do kurzu znovu. Pokud problémy přetrvají, kontaktujte vašeho {$a->teacher} nebo správce těchto stránek';
$string['paymentthanks'] = 'Děkujeme za vaši platbu! Nyní jste zapsáni do kurzu:<br />"{$a}"';
$string['pendingrequests'] = 'Čekající žádosti';
$string['periodending'] = 'Období do ({$a})';
$string['perpage'] = 'Na stránku';
$string['perpagea'] = 'Na stránku: {$a}';
$string['personal'] = 'Osobní';
$string['personalprofile'] = 'Osobní profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobilní telefon';
$string['phpinfo'] = 'PHP info';
$string['pictureof'] = 'Obrázek: {$a}';
$string['pictureofuser'] = 'Profilové foto';
$string['pleaseclose'] = 'Prosím zavřete toto okno';
$string['pleasesearchmore'] = 'Prosím, hledejte dál';
$string['pleaseusesearch'] = 'Prosím, použijte vyhledávání';
$string['plugin'] = 'Modul';
$string['plugincheck'] = 'Kontrola zásuvných modulů';
$string['plugindeletefiles'] = 'Všechna data náležící modulu "{$a->name}" byla odstraněna z databáze. Nyní byste měli odstranit adresář "{$a->directory}" na vašem serveru a zabránit tak reinstalace tohoto modulu.';
$string['pluginsetup'] = 'Nastavení tabulek zásuvných modulů';
$string['policyaccept'] = 'Rozumím a souhlasím';
$string['policyagree'] = 'Před dalším používáním těchto stránek musíte souhlasit s těmito pravidly. Souhlasíte s nimi?';
$string['policyagreement'] = 'Souhlas s pravidly používání stránek';
$string['policyagreementclick'] = 'Odkaz na Souhlas s pravidly používání těchto stránek';
$string['popup'] = 'nové okno';
$string['popupwindow'] = 'Otevřít soubor v novém okně';
$string['popupwindowname'] = 'Nové okno';
$string['post'] = 'Příspěvek';
$string['posts'] = 'Příspěvky';
$string['potentialadmins'] = 'Správci k dispozici';
$string['potentialcreators'] = 'Tvůrci k dispozici';
$string['potentialstudents'] = 'Studenti k dispozici';
$string['potentialteachers'] = 'Učitelé k dispozici';
$string['preferences'] = 'Předvolby';
$string['preferredlanguage'] = 'Upřednostňovaný jazyk';
$string['preferredtheme'] = 'Upřednostňovaný motiv';
$string['preprocessingbackupfile'] = 'Předpříprava souboru zálohy';
$string['prev'] = 'Předchozí';
$string['preview'] = 'Náhled';
$string['previewhtml'] = 'Náhled ve formátu HTML';
$string['previeworchoose'] = 'Vybrat motiv';
$string['previous'] = 'Předchozí';
$string['previouslyselectedusers'] = 'Naposledy vyhledaní uživatelé, kteří neodpovídají "{$a}"';
$string['previoussection'] = 'Předchozí sekce';
$string['primaryadminsetup'] = 'Nastavení účtu správce';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Popis se nezobrazí, dokud nebude tento uživatel zapsán alespoň v jednom kurzu.';
$string['publicprofile'] = 'Veřejný profil';
$string['publicsitefileswarning'] = 'Poznámka: sem umístěné soubory jsou přístupné komukoliv';
$string['publicsitefileswarning2'] = 'Poznámka: sem umístěné soubory jsou dostupné každému, kdo zná (nebo uhádne) jejich URL. Z bezpečnostních důvodů se doporučuje odstranit všechny soubory záloh ihned po jejich obnově.';
$string['publicsitefileswarning3'] = 'Poznámka: sem umístěné soubory jsou dostupné každému, kdo zná (nebo uhádne) jejich URL.<br />Z bezpečnostních důvodů by měly být soubory se zálohou ukládány pouze do složek backupdata, ke kterým mají přístup pouze oprávnění uživatelé.';
$string['publish'] = 'Zveřejnit';
$string['question'] = 'Otázka';
$string['questionsinthequestionbank'] = 'Úlohy v bance úloh';
$string['readinginfofrombackup'] = 'Čtení informací ze zálohy';
$string['readme'] = 'README';
$string['recentactivity'] = 'Nedávná činnost';
$string['recentactivityreport'] = 'Úplná sestava o nedávné činnosti...';
$string['recipientslist'] = 'Seznam příjemců';
$string['recreatedcategory'] = 'Přetvořená kategorie {$a}';
$string['redirect'] = 'Přesměrovat';
$string['reducesections'] = 'Snížit počet témat';
$string['refresh'] = 'Obnovit';
$string['refreshingevents'] = 'Obnovování událostí';
$string['registration'] = 'Registrace';
$string['registrationcontact'] = 'Kontakt';
$string['registrationcontactno'] = 'Ne, nechci kontaktní formulář na seznamu stránek.';
$string['registrationcontactyes'] = 'Ano, chci poskytnout případným zájemcům o Moodle kontaktní formulář, aby se na mě mohli obrátit.';
$string['registrationemail'] = 'Upozorňování e-mailem';
$string['registrationinfo'] = '<p>Zde si můžete zaregistrovat vaše stránky na moodle.org. Registrace je zdarma. Hlavní výhodou registrace je, že budete zařazeni do seznamu odběratelů občasných důležitých oznámení (upozornění týkající se bezpečnosti či informace o nových verzích Moodlu).<p>Poskytnuté informace jsou považovány za důvěrné a nebudou nikdy a nikomu prodány nebo předány. Jediným důvodem pro jejich shromažďování je snaha o podporu uživatelů, a lepší statistické zachycení komunity uživatelů Moodle jako celku.<p>Budete-li si to přát, mohou být název vaší stránky, země a URL umístěny na veřejný seznam stránek používajících Moodle.<p>Před umístěním na tento seznam je vaše nová registrace ručně ověřena. Jste-li jednou na seznam zařazeni, můžete jak registraci, tak i zveřejněné údaje kdykoliv sami aktualizovat prostým opětovným odesláním tohoto formuláře.';
$string['registrationinfotitle'] = 'Registrace';
$string['registrationno'] = 'Ne, nechci dostávat zprávy e-mailem';
$string['registrationsend'] = 'Odeslat údaje o registraci na moodle.org';
$string['registrationyes'] = 'Ano, chci být upozorňován e-mailem';
$string['reject'] = 'Odmítnout';
$string['rejectdots'] = 'Odmítnout...';
$string['reload'] = 'Obnovit';
$string['remoteappuser'] = 'Vzdálený uživatel {$a}';
$string['remove'] = 'Odstranit';
$string['removeadmin'] = 'Odstranit správce';
$string['removecreator'] = 'Odstranit tvůrce kurzů';
$string['removestudent'] = 'Odstranit studenta';
$string['removeteacher'] = 'Odstranit učitele';
$string['rename'] = 'Přejmenovat';
$string['renamefileto'] = 'Přejmenovat <b>{$a}</b> na';
$string['report'] = 'Sestava';
$string['reports'] = 'Sestavy';
$string['repositories'] = 'Repozitáře';
$string['requestcourse'] = 'Požádat o založení kurzu';
$string['requestedby'] = 'Žadatel';
$string['requestedcourses'] = 'Požadované kurzy';
$string['requestreason'] = 'Důvody pro založení';
$string['required'] = 'Vyžadováno';
$string['requirespayment'] = 'Přístup do tohoto kurzu je placený';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Resetovat kurz';
$string['resetinfo'] = 'Na této stránce můžete z kurzu odstranit data uživatelů, a přitom zachovat všechny moduly činností a další nastavení. UPOZORNĚNÍ: Položky vybrané níže budou po odeslání formuláře z kurzu odstraněny NATRVALO.';
$string['resetnotimplemented'] = 'Reset není implementován';
$string['resetrecordexpired'] = 'Použili jste odkaz na resetování hesla, který je více než {$a} minut starý a je již neplatný. Vytvořte prosím novou žádost o resetování hesla.';
$string['resetstartdate'] = 'Nastavit datum začátku na';
$string['resetstatus'] = 'Stav';
$string['resettask'] = 'Úloha';
$string['resettodefaults'] = 'Nastavit na výchozí hodnoty';
$string['resortbyfullname'] = 'Podle celého názvu';
$string['resortbyidnumber'] = 'Podle čísla id';
$string['resortbyshortname'] = 'Podle krátkého názvu';
$string['resortcourses'] = 'Uspořádat kurzy';
$string['resortsubcategoriesbyidnumber'] = 'Uspořádat podkategorie podle identifikátoru (idnumber)';
$string['resortsubcategoriesbyname'] = 'Uspořádat podkategorie podle názvu';
$string['resource'] = 'Studijní materiál';
$string['resourcedisplayauto'] = 'Automaticky';
$string['resourcedisplaydownload'] = 'Vynutit stažení';
$string['resourcedisplayembed'] = 'Vsadit do stránky';
$string['resourcedisplayframe'] = 'V rámci';
$string['resourcedisplaynew'] = 'Nové okno';
$string['resourcedisplayopen'] = 'Otevřít';
$string['resourcedisplaypopup'] = 'Pop-up okno';
$string['resources'] = 'Studijní materiály';
$string['resources_help'] = 'Různé typy studijních materiálů umožňují vkládat do kurzu téměř jakýkoliv webový obsah.';
$string['restore'] = 'Obnovit';
$string['restorecancelled'] = 'Obnova přerušena';
$string['restorecannotassignroles'] = 'Pro obnovení této zálohy by bylo potřeba přiřadit uživatelské role, ale na to nemáte dostatečná oprávnění';
$string['restorecannotcreateorassignroles'] = 'Pro obnovení této zálohy by bylo potřeba vytvořit nebo přiřadit uživatelské role, ale na to nemáte dostatečná oprávnění';
$string['restorecannotcreateuser'] = 'Pro obnovení této zálohy by bylo potřeba vytvořit nového uživatele "{$a}", ale na to nemáte dostatečná oprávnění';
$string['restorecannotoverrideperms'] = 'Pro obnovení této zálohy by bylo potřeba lokálně přenastavit pravomoci rolí, ale na to nemáte dostatečná oprávnění';
$string['restorecoursenow'] = 'Obnovit tento kurz!';
$string['restoredaccount'] = 'Obnovený účet';
$string['restoredaccountinfo'] = 'Tento uživatelský účet byl importován z jiného serveru a je potřeba u něj znovu nastavit heslo. Pro nastavení nového hesla pomocí emailu zvolte "Pokračovat"';
$string['restorefinished'] = 'Obnova úspěšně dokončena';
$string['restoreto'] = 'Obnovit do';
$string['restoretositeadding'] = 'Upozornění: Obnova přidá data na vaši titulní stránku!';
$string['restoretositedeleting'] = 'Upozornění: Obnova odstraní stávající obsah z vaší titulní stránky a nahradí jej novým!';
$string['restoreuserconflict'] = 'Obnovení uživatele "{$a}" ze zálohy by vedlo ke konfliktu v seznamu uživatelů';
$string['restoreuserinfofailed'] = 'Proces obnovy byl přerušen, nemáte oprávnění obnovovat data uživatelů.';
$string['restoreusersprecheck'] = 'Kontrola uživatelských účtů';
$string['restoreusersprecheckerror'] = 'Při kontrole uživatelských účtů byly zjištěny problémy';
$string['restricted'] = 'Nedostupné';
$string['returningtosite'] = 'Vracíte se na tyto stránky?';
$string['returntooriginaluser'] = 'Zpět k {$a}';
$string['revert'] = 'Vrátit změny';
$string['role'] = 'Role';
$string['roleassignments'] = 'Přiřazení rolí';
$string['rolemappings'] = 'Mapování rolí';
$string['rolerenaming'] = 'Přejmenování rolí';
$string['rolerenaming_help'] = 'Tato volba vám umožňuje změnit názvy rolí použitých v kurzu, např. přejmenovat roli „Učitel“ na roli „Lektor“ nebo „Tutor“. Mění se pouze zobrazovaný název role, oprávnění zůstávají nedotčena.

Změněný název role bude zobrazen na stránce se seznamem účastníků kurzu, na stránce pro přiřazení rolí a na dalších místech v kurzu. Pokud patří přejmenovaná role k rolím, které správce zařadil mezi role správce kurzů, bude název role vypisován také v seznamu kurzů.';
$string['roles'] = 'Role';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Počet posledních RSS článků';
$string['rsserror'] = 'Chyba při čtení RSS údajů';
$string['rsserrorauth'] = 'Váš RSS odkaz neobsahuje platný autentizační řetězec.';
$string['rsserrorguest'] = 'K tomuto zdroji zpráv přistupujete jako anonymní hosté, ale ti nemají oprávnění číst zdrojová data. Navštivte stránku, na které se nachází tento RSS zdroj jako přihlášený uživatel a získejte nové URL pro tento zdroj.';
$string['rsskeyshelp'] = 'Z důvodu vyššího zabezpečení a ochrany osobních údajů obsahují URL adresy poskytovaných RSS zdrojů speciální řetězec, který identifikuje daného uživatele. Tím je ostatním uživatelům zabráněno v neoprávněném přístupu do těch oblastí Moodle, kam by neměli mít přístup přes RSS. Tento autentizační řetězec je pro vás automaticky vytvořen v okamžiku, kdy poprvé navštívíte oblast Moodle, která produkuje RSS kanál. Máte-li podezření, že došlo k vyzrazení tohoto řetězce, můžete si nechat vygenerovat nový pomocí odkazu "Reset". Stávající adresy URL k daným RSS kanálům se tímto zneplatní.';
$string['rsstype'] = 'RSS kanál pro tuto aktivitu';
$string['saveandnext'] = 'Uložit a ukázat další';
$string['savechanges'] = 'Uložit změny';
$string['savechangesanddisplay'] = 'Uložit a zobrazit';
$string['savechangesandreturntocourse'] = 'Uložit a vrátit se do kurzu';
$string['savecomment'] = 'Uložit komentář';
$string['savedat'] = 'Uloženo jako';
$string['savepreferences'] = 'Uložit předvolby';
$string['saveto'] = 'Ukládat do';
$string['scale'] = 'Škála';
$string['scale_help'] = '<p>Učitelé mohou vytvářet pro hodnocení jednotlivých činností v kurzu vlastní
škály.</p>

<p>Názvem škály by mělo být slovní spojení, které ji jasně popisuje; název se
zobrazuje v seznamech pro výběr škály a rovněž na tlačítkách kontextové
nápovědy.</p>

<p>Škála sama o sobě je definována vzestupným žebříčkem hodnocení, v němž jsou
jednotlivé položky odděleny čárkami. Příklad:</p>

<blockquote>
  <i>Neuspokojivý, Dostatečný, Průměrný, Dobrý, Velmi dobrý, Vynikající</i>
</blockquote>

<p>Škály by měly obsahovat také popis jednotlivých stupňů hodnocení a jejich
užití v praxi. Tento popis se bude zobrazovat na stránkách nápovědy.</p>

<p>Vaše stránky mohou také mít jednu či více „standardních“ škál, které pro
celý systém definuje správce. Tyto škály budou k dispozici ve všech
kurzech.</p>';
$string['scales'] = 'Škály';
$string['scalescustom'] = 'Vlastní škály';
$string['scalescustomcreate'] = 'Přidat novou škálu';
$string['scalescustomno'] = 'Zatím nebyly vytvořeny žádné škály';
$string['scalesstandard'] = 'Standardní škály';
$string['scalestandard'] = 'Standardní škála';
$string['scalestandard_help'] = '<p>Standardní škála je dostupná ve všech kurzech na tomto serveru.</p>';
$string['scalestip'] = 'K vytvoření vlastních škál použijte odkaz \'Škály\' v panelu Správa ve svém kurzu.';
$string['scalestip2'] = 'Chcete-li si vytvořit vlastní škálu, jděte na hlavní stránce kurzu do nabídky Správa > Známky a tam zvolte akci Upravit > Škály.';
$string['schedule'] = 'Časový plán';
$string['screenshot'] = 'Náhled';
$string['search'] = 'Hledat';
$string['searchagain'] = 'Hledat znovu';
$string['searchbyemail'] = 'Vyhledat podle mailové adresy';
$string['searchbyusername'] = 'Vyhledat podle uživatelského jména';
$string['searchcourses'] = 'Vyhledat kurzy';
$string['searchhelp'] = 'Můžete vyhledávat i několik slov najednou.<br /><br />slovo : hledej v textu jakoukoliv shodu s tímto slovem.<br />+slovo : bude nalezena pouze přesná shoda.<br />-slovo : nezobrazuj výsledky s tímto slovem.';
$string['search_help'] = 'Pro základní hledávání jednoho nebo více slov v textu pouze napište tato slova oddělená mezerami. K vyhledání jsou použita pouze slova delší než dva znaky.

Pro pokročilé hledání klikněte na tlačítko Hledat, aniž byste do textového boxu cokoliv psali, čímž se Vám zobrazí formulář pro pokročilé hledávání.   ';
$string['searchoptions'] = 'Možnosti hledání';
$string['searchresults'] = 'Výsledky hledání';
$string['sec'] = 'sek.';
$string['seconds'] = 'sekundy';
$string['secondstotime172800'] = '2 dny';
$string['secondstotime259200'] = '3 dny';
$string['secondstotime345600'] = '4 dny';
$string['secondstotime432000'] = '5 dnů';
$string['secondstotime518400'] = '6 dnů';
$string['secondstotime604800'] = '1 týden';
$string['secondstotime86400'] = '1 den';
$string['secretalreadyused'] = 'Odkaz na potvrzení změny hesla již byl použit. Heslo nebylo změněno.';
$string['secs'] = 'sekund';
$string['section'] = 'Sekce';
$string['sectionname'] = 'Název sekce';
$string['sections'] = 'Sekce';
$string['sectionusedefaultname'] = 'Použít výchozí název sekce';
$string['seealsostats'] = 'Viz také: statistiky';
$string['selctauser'] = 'Vyberte uživatele';
$string['select'] = 'Výběr';
$string['selectacategory'] = 'Vyberte kategorii';
$string['selectacountry'] = 'Vyberte zemi';
$string['selectacourse'] = 'Vyberte kurz';
$string['selectacoursesite'] = 'Vyberte kurz nebo stránky';
$string['selectagroup'] = 'Vyberte skupinu';
$string['selectall'] = 'Vybrat vše';
$string['selectamodule'] = 'Prosím, vyberte modul činnosti';
$string['selectanaction'] = 'Vyberte akci';
$string['selectanoptions'] = 'Vyberte možnost';
$string['selectaregion'] = 'Vyberte oblast';
$string['selectcategorysort'] = 'Které kategorie si přejete řadit';
$string['selectcategorysortby'] = 'Vyberte, jak chcete seřadit kategorie';
$string['selectcoursesortby'] = 'Vyberte, jak chcete seřadit kurzy';
$string['selectdefault'] = 'Vyberte výchozí';
$string['selectedcategories'] = 'Vybrané kategorie';
$string['selectedfile'] = 'Vybraný soubor';
$string['selectednowmove'] = '{$a} souborů označeno k přesunu. Nyní přejděte do cílového umístění a stiskněte tlačítko \'Přesunout soubory sem\'';
$string['selectfiles'] = 'Vybrat soubory';
$string['selectmoduletoviewhelp'] = 'Vyberte modul činnosti či typ studijního materiálu z nabídky pro zobrazení jeho popisu a nápovědy.

Dvojím kliknutím na název činnosti či studijního materiálu jej můžete rychle přidat do kurzu.';
$string['selectnos'] = 'Vybrat všechna NE';
$string['selectperiod'] = 'Vybrat období';
$string['senddetails'] = 'Odeslat mé údaje e-mailem';
$string['separate'] = 'Individuální';
$string['separateandconnected'] = 'Individuální a Kolektivní způsoby poznávání';
$string['separateandconnectedinfo'] = 'Tato škála je založena na teorii individuálního a vztahového poznávání a učení. Tato teorie popisuje dva rozdílné způsoby, jimiž lidé usuzují a učí se o věcech kolem sebe.
<ul>
<li>Lidé s převažujícím <strong>individuálním poznáváním</strong> zůstávají objektivní a do poznávání nezapojují pocity a emoce. Když diskutují s lidmi odlišných názorů, rádi obhajují svůj vlastní pohled na věc a snaží se v názorech svých oponentů najít logické mezery. Jsou kritičtí k novým myšlenkám, pokud to nejsou ověřená fakta z uznávaných zdrojů, jako jsou učebnice, respektovaní učitelé nebo jejich vlastní přímá zkušenost.</li>
<li>Lidé s převažujícím <strong>vztahovým poznáváním</strong>
jsou nadáni empatií a obvykle naslouchají a kladou otázky, dokud necítí, že jsou schopni se "napojit na myšlení druhých" a rozumět věcem z jejich pohledu. Učí se tak, že se snaží sdílet zkušenosti, které vedly k získání určité znalosti u ostatních lidí. V diskusi se vyhýbají střetům a jsou připraveni logickými argumenty podpořit návrhy ostatních.</li>
</ul>';
$string['servererror'] = 'V komunikace se serverem se vyskytla chyba';
$string['serverlocaltime'] = 'Místní čas serveru';
$string['setcategorytheme'] = 'Nastavit motiv kategorie';
$string['setpassword'] = 'Nastavit heslo';
$string['setpasswordinstructions'] = 'Zadejte prosím nové heslo do obou polí a stiskněte tlačítko "Nastavit heslo".<br />Vaše nové heslo bude uloženo a vy budete přihlášeni.';
$string['settings'] = 'Nastavení';
$string['shortname'] = 'Krátký název';
$string['shortnamecollisionwarning'] = '[*] = Tento krátký název je již používán pro jiný kurz a bude potřeba jej změnit okamžitě po schválení.';
$string['shortnamecourse'] = 'Krátký název kurzu';
$string['shortnamecourse_help'] = '<p>Mnoho institucí používá zkratky či kódová označení svých kurzů (například
MAT1 nebo K022). I když váš kurz žádnou takovou zkratku nemá, nějakou mu
vytvořte. Bude použita tam, kde není vhodné uvádět celý dlouhý název kurzu
(například v záhlaví e-mailu).</p>';
$string['shortnametaken'] = 'Krátký název je již použit pro jiný kurz ({$a}).';
$string['shortnameuser'] = 'Krátké jméno uživatele';
$string['shortsitename'] = 'Krátký název stránek (např. jedno slovo)';
$string['show'] = 'Ukázat';
$string['showactions'] = 'Zobrazit akce';
$string['showadvancedsettings'] = 'Ukázat pokročilá nastavení';
$string['showall'] = 'Ukázat všechny {$a}';
$string['showallcourses'] = 'Ukázat všechny kurzy';
$string['showallusers'] = 'Ukázat všechny uživatele';
$string['showblockcourse'] = 'Ukázat blok s kurzy';
$string['showcategory'] = 'Zobrazit {$a}';
$string['showcomments'] = 'Ukázat/schovat komentáře';
$string['showcommentsnonjs'] = 'Ukázat komentáře';
$string['showdescription'] = 'Zobrazit popis na titulní straně kurzu';
$string['showdescription_help'] = 'Zda se má výše vložený úvodní popis zobrazit v osnově kurzu pod názvem příslušné činnosti nebo studijního materiálu.';
$string['showgrades'] = 'Ukázat známky';
$string['showgrades_help'] = '<p>Většinu činností v kurzu lze známkovat.</p>
<p>Ve výchozím nastavení lze všechny známky v kurzu najít na stránce &quot;Známky&quot;, dostupné z hlavní stránky kurzu.</p>
<p>Jestliže učitel nehodlá studenty v daném kurzu známkovat, nebo nechce, aby studenti známky viděli, může volbu &quot;Ukázat známky&quot; v nastavení kurzu vypnout. Toto nastavení nebrání učiteli, aby jednotlivé činnosti známkoval, pouze neumožňuje studentům, aby si známky mohli prohlížet.</p>';
$string['showingacourses'] = 'Ukázat všechny {$a} kurzy';
$string['showingxofycourses'] = 'Ukázat kurzy od {$a->start} do {$a->end} z {$a->total} kurzů';
$string['showlistofcourses'] = 'Ukázat seznam kurzů';
$string['showmodulecourse'] = 'Ukázat seznam kurzů, obsahujících činnost';
$string['showonly'] = 'Zobrazit pouze';
$string['showperpage'] = 'Ukázat {$a} na stránce';
$string['showrecent'] = 'Ukázat nedávnou činnost';
$string['showreports'] = 'Ukázat sestavu o činnosti';
$string['showreports_help'] = '<p>Pro každého účastníka kurzu je veden "Protokol o činnosti", který zachycuje
jeho aktivitu v kurzu. Vedle přehledu jeho příspěvků do kurzu obsahuje tento
protokol také podrobné záznamy o jeho přihlášeních a přístupech k jednotlivým
částem kurzu.</p>

<p>Přístup k těmto údajům je učiteli umožněn přes tlačítko umístěné na stránce
osobního profilu každého studenta.</p>

<p>O přístupu studenta k jeho záznamům rozhoduje učitel v nastavení kurzu. U
některých kurzů může být protokol o činnosti pro studenta přínosný, protože mu
umožní sledovat jeho zapojení do činnosti v kurzu; u jiných kurzů není jeho
zpřístupnění nezbytné.</p>

<p>Dalším možným důvodem pro vypnutí této funkce je zvýšené zatížení systému
při vytváření protokolu. Je-li v kurzu velký počet studentů nebo probíhá-li
kurz dlouho, je lépe tuto funkci vypnout.</p>

<p> </p>';
$string['showsettings'] = 'Ukázat nastavení';
$string['showtheselogs'] = 'Ukázat tyto protokoly';
$string['showthishelpinlanguage'] = 'Zobrazit tuto nápovědu v jazyce: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'Od posledního přihlášení';
$string['site'] = 'Stránky';
$string['sitedefault'] = 'Výchozí';
$string['siteerrors'] = 'Chyby na stránkách';
$string['sitefiles'] = 'Soubory stránek';
$string['sitefilesused'] = 'Soubory stránek použité v tomto kurzu';
$string['sitehome'] = 'Titulní stránka';
$string['sitelegacyfiles'] = 'Soubory stránek';
$string['sitelogs'] = 'Protokoly stránek';
$string['sitemessage'] = 'Uživatelé zprávy';
$string['sitenews'] = 'Novinky stránek';
$string['sitepages'] = 'Hlavní nabídka';
$string['sitepartlist'] = 'Nemáte oprávnění potřebná k prohlížení seznamu účastníků';
$string['sitepartlist0'] = 'Pro zobrazení seznamu uživatelů musíte mít přidělenu roli vyučujícího na hlavní stránce.';
$string['sitepartlist1'] = 'Pro zobrazení seznamu uživatelů musíte mít přidělenu roli vyučujícího.';
$string['sites'] = 'Stránky';
$string['sitesection'] = 'Zahrnout úvodní sekci';
$string['sitesettings'] = 'Nastavení stránek';
$string['siteteachers'] = 'Vyučující na hlavní stránce';
$string['size'] = 'Velikost';
$string['sizeb'] = 'bytů';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['skipped'] = 'Přeskočeno';
$string['skiptocategorylisting'] = 'Přejít na seznam kategorií';
$string['skiptocoursedetails'] = 'Přejít na podrobné informace o kurzu';
$string['skiptocourselisting'] = 'Přejít na seznam kurzů';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Společná diskuse -- nejnovější témata';
$string['someallowguest'] = 'Některé kurzy umožňují vstup pro hosty';
$string['someerrorswerefound'] = 'Některé informace chyběly nebo nebyly správné. Podrobnosti jsou uvedeny níže.';
$string['sort'] = 'Setřídit';
$string['sortby'] = 'Třídit podle';
$string['sortbyx'] = 'Třídit dle {$a} vzestupně';
$string['sortbyxreverse'] = 'Třídit dle {$a} sestupně';
$string['sortcategoriesbyidnumber'] = 'Řazení kategorií podle identifikátoru kategorie';
$string['sortcategoriesbyname'] = 'Řazení kategorií podle názvu';
$string['sortcoursesbyfullname'] = 'Řazení kurzu podle celého názvu';
$string['sortcoursesbyidnumber'] = 'Řazení kurzu podle ID kurzu';
$string['sortcoursesbyshortname'] = 'Řazení kategorií podle krátkého názvu';
$string['sorting'] = 'Řazení';
$string['sourcerole'] = 'Zdrojová role';
$string['specifyname'] = 'Musíte určit název';
$string['standard'] = 'Standardní';
$string['starpending'] = '([*] = kurz čeká na schválení)';
$string['startdate'] = 'Datum začátku kurzu';
$string['startdate_help'] = 'Pokud používáte týdenní uspořádání kurzu, bude první týden kurzu začínat dnem, který uvedete zde. Od tohoto dne budou též zobrazovány protokoly o činnosti v kurzu.';
$string['startingfrom'] = 'Začíná od';
$string['startsignup'] = 'Začněte nyní vytvořením nového účtu!';
$string['state'] = 'Stát/Kraj';
$string['statistics'] = 'Statistiky';
$string['statisticsgraph'] = 'Graf statistiky';
$string['stats'] = 'Statistiky';
$string['statslogins'] = 'Přihlášení';
$string['statsmodedetailed'] = 'Podrobný pohled';
$string['statsmodegeneral'] = 'Obecný pohled';
$string['statsnodata'] = 'Pro tento kurz nejsou v uvedeném období k dispozici žádná data.';
$string['statsnodatauser'] = 'Pro tento kurz a uživatele nejsou v uvedeném období k dispozici žádná data.';
$string['statsoff'] = 'Statistiky nejsou momentálně povoleny';
$string['statsreads'] = 'Pohledy';
$string['statsreport1'] = 'Přihlášení';
$string['statsreport10'] = 'Činnost uživatele';
$string['statsreport11'] = 'Kurzy s nejvyšší aktivitou';
$string['statsreport12'] = 'Kurzy s nejvyšší aktivitou (váženo)';
$string['statsreport13'] = 'Kurzy s nejvyšší participací (podle zapsaných uživatelů)';
$string['statsreport14'] = 'Kurzy s nejvyšší participací (podle poměru prohlížení/příspěvky)';
$string['statsreport2'] = 'Prohlížení (všechny role)';
$string['statsreport3'] = 'Příspěvky (všechny role)';
$string['statsreport4'] = 'Veškerá činnost (všechny role)';
$string['statsreport5'] = 'Veškerá činnost (prohlížení a příspěvky)';
$string['statsreport7'] = 'Činnost uživatelů (prohlížení a příspěvky)';
$string['statsreport8'] = 'Veškerá činnost uživatelů';
$string['statsreport9'] = 'Přihlášení (na stránky)';
$string['statsreportactivity'] = 'Veškerá činnost (všechny role)';
$string['statsreportactivitybyrole'] = 'Veškerá činnost  (prohlížení a příspěvky)';
$string['statsreportforuser'] = 'pro';
$string['statsreportlogins'] = 'Přihlášení';
$string['statsreportreads'] = 'Prohlížení (všechny role)';
$string['statsreporttype'] = 'Typ sestavy';
$string['statsreportwrites'] = 'Příspěvky (všechny role)';
$string['statsstudentactivity'] = 'Činnost studentů';
$string['statsstudentreads'] = 'Prohlížení studenty';
$string['statsstudentwrites'] = 'Příspěvky studentů';
$string['statsteacheractivity'] = 'Činnost učitelů';
$string['statsteacherreads'] = 'Prohlížení učiteli';
$string['statsteacherwrites'] = 'Příspěvky učitelů';
$string['statstimeperiod'] = 'Během posledních:';
$string['statsuniquelogins'] = 'Unikátních přihlášení';
$string['statsuseractivity'] = 'Veškerá činnost';
$string['statsuserlogins'] = 'Přihlášení';
$string['statsuserreads'] = 'Prohlížení';
$string['statsuserwrites'] = 'Příspěvky';
$string['statswrites'] = 'Příspěvky';
$string['status'] = 'Stav';
$string['stringsnotset'] = 'Následující texty nejsou přeloženy v {$a}';
$string['studentnotallowed'] = 'Je mi líto, ale do tohoto kurzu nemůžete vstoupit jako \'{$a}\'.';
$string['students'] = 'Studenti';
$string['studentsandteachers'] = 'Studenti a učitelé';
$string['subcategories'] = 'Podkategorie';
$string['subcategory'] = 'Podkategorie';
$string['subcategoryof'] = 'Podkategorie v {$a}';
$string['submit'] = 'Odeslat';
$string['success'] = 'Úspěch';
$string['summary'] = 'Souhrn';
$string['summary_help'] = '<p>Souhrn je krátký text, který by měl připravit studenty na činnost v rámci
daného tématu/týdne.</p>

<p>Souhrn by měl být co nejkratší, aby se hlavní stránka kurzu neúměrně
neprodlužovala.</p>

<p>Pokud se domníváte, že dané téma vyžaduje podrobnější popis, může být
vhodnější uložit jej jako samostatný materiál a do tématu vložit pouze
odkaz.</p>';
$string['summaryof'] = 'Souhrn - {$a}';
$string['supplyinfo'] = 'Více informací';
$string['suspended'] = 'Pozastaveno';
$string['suspendedusers'] = 'Pozastavení uživatelé';
$string['switchdevicedefault'] = 'Přepnout do standardního motivu';
$string['switchdevicerecommended'] = 'Přepnout do motivu pro vaše zařízení';
$string['switchrolereturn'] = 'Vrátit se k mé obvyklé roli';
$string['switchroleto'] = 'Přepnout roli na...';
$string['tag'] = 'Štítek';
$string['tagalready'] = 'Tento štítek již existuje';
$string['tagmanagement'] = 'Přidat/odebrat štítky';
$string['tags'] = 'Štítky';
$string['targetrole'] = 'Cílová role';
$string['teacheronly'] = 'pouze pro {$a}';
$string['teacherroles'] = '{$a} rolí';
$string['teachers'] = 'Učitelé';
$string['textediting'] = 'Při úpravě textu';
$string['texteditor'] = 'Použít standardní webové formuláře';
$string['textformat'] = 'Prostý neformátovaný text';
$string['thanks'] = 'Díky';
$string['theme'] = 'Motiv';
$string['themes'] = 'Motivy';
$string['themesaved'] = 'Nový motiv uložen';
$string['therearecourses'] = 'Existuje {$a} kurzů';
$string['thereareno'] = 'V tomto kurzu nejsou žádní {$a}';
$string['thiscategory'] = 'Tato kategorie';
$string['thiscategorycontains'] = 'Tato kategorie obsahuje';
$string['time'] = 'Čas';
$string['timezone'] = 'Časové pásmo';
$string['to'] = 'Do';
$string['tocontent'] = 'Na položku "{$a}"';
$string['tocreatenewaccount'] = 'Přeskočit na vytvoření nového účtu';
$string['today'] = 'Dnes';
$string['todaylogs'] = 'Dnešní protokol';
$string['toeveryone'] = 'komukoliv';
$string['toomanybounces'] = 'Z této adresy se vrátilo příliš mnoho e-mailů jako nedoručitelných. <strong>MUSÍTE</strong> si ji změnit, pokud chcete pokračovat.';
$string['toomanytoshow'] = 'Příliš mnoho uživatelů k zobrazení';
$string['toomanyusersmatchsearch'] = 'Příliš mnoho uživatelů ({$a->count}) odpovídajících "{$a->search}"';
$string['toomanyuserstoshow'] = 'Příliš mnoho uživatelů ({$a}) pro zobrazení';
$string['toonly'] = 'pouze pro {$a}';
$string['top'] = 'Nahoru';
$string['topic'] = 'Téma';
$string['topichide'] = 'Skrýt toto téma pro {$a}';
$string['topicoutline'] = 'Osnova témat';
$string['topicshow'] = 'Ukázat toto téma pro {$a}';
$string['toplevelcategory'] = 'Nejvyšší úroveň kategorie';
$string['total'] = 'Celkem';
$string['totopofsection'] = 'Na začátek sekce "{$a}"';
$string['trackforums'] = 'Zvýraznění nepřečtených příspěvků';
$string['trackforumsno'] = 'Ne: nechci zvýrazňovat nepřečtené příspěvky';
$string['trackforumsyes'] = 'Ano: chci zvýrazňovat nepřečtené příspěvky';
$string['trysearching'] = 'Zkuste raději vyhledávání.';
$string['turneditingoff'] = 'Vypnout režim úprav';
$string['turneditingon'] = 'Zapnout režim úprav';
$string['undecided'] = 'Nerozhodnuto';
$string['unfinished'] = 'Nedokončeno';
$string['unknowncategory'] = 'Neznámá kategorie';
$string['unknownerror'] = 'Neznámá chyba';
$string['unlimited'] = 'Neomezeno';
$string['unpacking'] = 'Rozbaluji {$a}';
$string['unsafepassword'] = 'Příliš snadné heslo -- zkuste nějaké jiné';
$string['untilcomplete'] = 'Dokud není hotovo';
$string['unusedaccounts'] = 'Účty nepoužité po dobu delší než {$a} dnů jsou automaticky vyškrtnuty.';
$string['unzip'] = 'Rozbalit';
$string['unzippingbackup'] = 'Rozbaluji zálohu';
$string['up'] = 'Nahoru';
$string['update'] = 'Aktualizovat';
$string['updated'] = 'Aktualizováno {$a}';
$string['updatemymoodleoff'] = 'Vypnout úpravy této stránky';
$string['updatemymoodleon'] = 'Upravit tuto stránku';
$string['updatemyprofile'] = 'Aktualizovat profil';
$string['updatesevery'] = 'Aktualizovat každých {$a} vteřin';
$string['updatethis'] = 'Upravit tuto činnost - {$a}';
$string['updatethiscourse'] = 'Aktualizovat tento kurz';
$string['updatinga'] = 'Aktualizace: {$a}';
$string['updatingain'] = 'Aktualizace: {$a->what}, {$a->in}';
$string['upload'] = 'Vložit';
$string['uploadafile'] = 'Vložit soubor';
$string['uploadcantwrite'] = 'Selhal zápis souboru na disk';
$string['uploadedfile'] = 'Soubor byl úspěšně uložen';
$string['uploadedfileto'] = '{$a->file} uložen do {$a->directory}';
$string['uploadedfiletoobig'] = 'Je mi líto, ale tento soubor je příliš velký (limit je {$a} bytů).';
$string['uploadextension'] = 'Nahrávání souboru bylo zastaveno nějakým PHP rozšířením';
$string['uploadfailednotrecovering'] = 'Nahrávání souborů selhalo, protože se vyskytl problém s jedním ze souborů: {$a->name}.<br />Zde je protokol s popisem chyby:<br />{$a->problem}<br />Zotavení z chyby se neprovádí.';
$string['uploadfilelog'] = 'Protokol o nahrávání souboru {$a}';
$string['uploadformlimit'] = 'Nahrávaný soubor {$a} přesáhl nastavenou maximální možnou velikost.';
$string['uploadlabel'] = 'Název:';
$string['uploadlimitwithsize'] = 'Stejný limit jako pro: {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Nahrát nový soubor';
$string['uploadnofilefound'] = 'Soubor nenalezen -- určitě jste vybrali soubor k vložení?';
$string['uploadnotallowed'] = 'Nahrávání souborů není povoleno.';
$string['uploadnotempdir'] = 'Chybí dočasná složka';
$string['uploadoldfilesdeleted'] = 'Staré soubory v nahrávací oblasti byly odstraněny.';
$string['uploadpartialfile'] = 'Soubor byl nahrán pouze částečně';
$string['uploadproblem'] = 'Objevily se neznámé problémy při vkládání souboru \'{$a}\' (možná je příliš velký nebo se v jeho názvu vyskytují nedovolené znaky).';
$string['uploadrenamedchars'] = 'Soubor byl přejmenován z {$a->oldname} na {$a->newname} kvůli neplatným znakům.';
$string['uploadrenamedcollision'] = 'Soubor byl přejmenován z {$a->oldname} na {$a->newname} kvůli konfliktu názvů.';
$string['uploadserverlimit'] = 'Nahrávaný soubor přesáhl maximální možnou velikost nastavenou serverem.';
$string['uploadthisfile'] = 'Vložit tento soubor';
$string['url'] = 'URL';
$string['used'] = 'Použito';
$string['usedinnplaces'] = 'Použito na {$a} místech';
$string['usemessageform'] = 'nebo pošlete zprávu vybraným uživatelům pomocí následujícího formuláře';
$string['user'] = 'Uživatel';
$string['userconfirmed'] = 'Potvrzeno {$a}';
$string['usercurrentsettings'] = 'Nastavení mého profilu';
$string['userdata'] = 'Data uživatele';
$string['userdeleted'] = 'Uživatelský účet byl odstraněn';
$string['userdescription'] = 'Další podrobnosti o uživateli';
$string['userdescription_help'] = 'Údaje vložené do tohoto pole budou zobrazeny dalším uživatelům na stránce s vaším uživatelským profilem.';
$string['userdetails'] = 'Detaily uživatele';
$string['userfiles'] = 'Soubory uživatele';
$string['userlist'] = 'Seznam uživatelů';
$string['username'] = 'Uživatelské jméno';
$string['usernameemailmatch'] = 'Uživatelské jméno a e-mailová adresa se nevztahují ke stejnému uživateli.';
$string['usernameexists'] = 'Toto uživatelské jméno již existuje, zvolte si jiné.';
$string['usernamelowercase'] = 'Jsou povolena pouze písmena malé abecedy';
$string['usernamenotfound'] = 'Uživatelské jméno nebylo nalezeno v databázi.';
$string['usernameoremail'] = 'Uživatelské jméno nebo emailová adresa';
$string['usernotconfirmed'] = 'Nelze potvrdit {$a}';
$string['userpic'] = 'Obrázek uživatele';
$string['users'] = 'Uživatelé';
$string['userselectorautoselectunique'] = 'Pokud je nalezen jediný uživatel, automaticky jej označit';
$string['userselectorpreserveselected'] = 'Ponechat označené uživatele, i když už neodpovídají masce';
$string['userselectorsearchanywhere'] = 'Hledat text kdekoliv v zobrazených polích';
$string['usersnew'] = 'Noví uživatelé';
$string['usersnoaccesssince'] = 'Ukázat uživatele, kteří nebyli aktivní déle než';
$string['userswithfiles'] = 'Uživatelé se soubory';
$string['useruploadtype'] = 'Režim nahrávání uživatelů: {$a}';
$string['userviewingsettings'] = 'Nastavení profilu pro {$a}';
$string['userzones'] = 'Časové pásmo uživatele';
$string['usetheme'] = 'Použít motiv';
$string['usingexistingcourse'] = 'Používám existující kurz';
$string['valuealreadyused'] = 'Tato hodnota je již použita';
$string['version'] = 'Verze';
$string['view'] = 'Zobrazit';
$string['viewallcourses'] = 'Zobrazit všechny kurzy';
$string['viewallcoursescategories'] = 'Zobrazit všechny kurzy a kategorie';
$string['viewallsubcategories'] = 'Zobrazit všechny podkategorie';
$string['viewfileinpopup'] = 'Zobrazit soubor v novém okně';
$string['viewing'] = 'Přehled';
$string['viewmore'] = 'Zobrazit více';
$string['viewprofile'] = 'Zobrazit profil';
$string['views'] = 'Zobrazení';
$string['viewsolution'] = 'zobrazit řešení';
$string['virusfound'] = 'Pozor! Clam AV nalezl virus v souboru nahrávaném uživatelem {$a->user} v kurzu {$a->course}. Zde je výstup programu clamscan:';
$string['virusfoundlater'] = 'V souboru {$a->filename}, který jste dne {$a->date} nahrávali do kurzu {$a->course}, byl nalezen virus. Zde je souhrn toho, co se stalo s vaším souborem:

{$a->action}

Pokud byl soubor odevzdávaná práce, budete ji zřejmě muset odevzdat znovu, aby ji váš učitel mohl přečíst.';
$string['virusfoundlateradmin'] = 'Pozor! V souboru {$a->filename}, který dne {$a->date} nahrával uživatel {$a->user} do kurzu {$a->course}, byl nalezen virus. Zde je souhrn toho, co se se souborem stalo:

{$a->action}

Uživatel byl rovněž upozorněn.';
$string['virusfoundlateradminnolog'] = 'Pozor! V souboru nahraném pod názvem {$a->filename} byl nalezen virus. Systému se nepodařilo kontaktovat uživatele, který soubor nahrával.

Zde je souhrn toho, co se se souborem stalo:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Nalezen virus!';
$string['virusfounduser'] = 'Vámi nahrávaný soubor {$a->filename} byl kontrolován antivirovým programem a byl v něm nalezen virus! Váš soubor NEBYL úspěšně uložen.';
$string['virusplaceholder'] = 'V tomto nahrávaném souboru byl nalezen virus a soubor byl proto přesunut nebo odstraněn. Uživateli bylo zasláno upozornění.';
$string['visible'] = 'Viditelný';
$string['visible_help'] = 'Tato volba určuje, zda se bude kurz objevovat v seznamu dostupných kurzů. Pouze správci serveru a učitelé v daném kurzu mohou vstoupit do takto skrytého kurzu.';
$string['visibletostudents'] = 'Viditelný pro {$a}';
$string['warning'] = 'Varování';
$string['warningdeleteresource'] = 'Upozornění: {$a} je odkazován ve studijním materiálu. Chcete tento studijní materiál aktualizovat?';
$string['webpage'] = 'Webová stránka';
$string['week'] = 'Týden';
$string['weekhide'] = 'Skrýt tento týden pro {$a}';
$string['weeklyoutline'] = 'Osnova týdnů';
$string['weeks'] = 'týdnů';
$string['weekshow'] = 'Ukázat tento týden pro {$a}';
$string['welcometocourse'] = 'Vítejte v kurzu {$a}';
$string['welcometocoursetext'] = 'Vitejte v kurzu {$a->coursename}!

Pokud jste tak ještě neučinili, vyplňte si svůj profil na následující stránce:

{$a->profileurl}';
$string['whatforlink'] = 'Co se má provést s tímto odkazem?';
$string['whatforpage'] = 'Co se má provést s tímto textem?';
$string['whattocallzip'] = 'Jak chcete pojmenovat nový soubor ZIP?';
$string['whattodo'] = 'Co udělat';
$string['windowclosing'] = 'Toto okno by se mělo samo zavřít. Pokud se tak nestalo, prosím, zavřete jej vy.';
$string['withchosenfiles'] = 'S vybranými soubory';
$string['withdisablednote'] = '{$a} (vypnuto)';
$string['withoutuserdata'] = 'bez dat uživatele';
$string['withselectedusers'] = 'S vybranými uživateli...';
$string['withselectedusers_help'] = '* Odeslat zprávu - slouží k hromadnému zasílání zpráv
* Přidat novou poznámku - pro přidání poznámky k vybranému uživateli
* Přidat společnou poznámku - pro hromadné přidání poznámky k vícero uživatelům';
$string['withuserdata'] = 's daty uživatele';
$string['wordforstudent'] = 'Jak říkáte studentovi';
$string['wordforstudenteg'] = 'např. Student, Žák, Účastník atd.';
$string['wordforstudents'] = 'Jak říkáte studentům';
$string['wordforstudentseg'] = 'např. Studenti, Žáci, Účastníci atd.';
$string['wordforteacher'] = 'Jak říkáte učiteli';
$string['wordforteachereg'] = 'např. Školitel, Instruktor, Konzultant apod.';
$string['wordforteachers'] = 'Jak říkáte učitelům';
$string['wordforteacherseg'] = 'např. Školitelé, Instruktoři, Konzultanti apod.';
$string['writingblogsinfo'] = 'Zapisuji informace blogů';
$string['writingcategoriesandquestions'] = 'Zapisuji kategorie a otázky';
$string['writingcoursedata'] = 'Zapisuji údaje kurzu';
$string['writingeventsinfo'] = 'Zapisuji informace o událostech';
$string['writinggeneralinfo'] = 'Zapisuji obecné informace';
$string['writinggradebookinfo'] = 'Zapisuji informace o klasifikaci';
$string['writinggroupingsgroupsinfo'] = 'Zapisuji informace o seskupeních a skupinách';
$string['writinggroupingsinfo'] = 'Zapisuji informace o seskupeních';
$string['writinggroupsinfo'] = 'Zapisuji informace o skupinách';
$string['writingheader'] = 'Zapisuji hlavičky';
$string['writingloginfo'] = 'Zapisuji protokoly';
$string['writingmessagesinfo'] = 'Zapisuji informace o zprávách';
$string['writingmoduleinfo'] = 'Zapisuji informace o modulech';
$string['writingscalesinfo'] = 'Zapisuji informace o škálách';
$string['writinguserinfo'] = 'Zapisuji informace o uživatelích';
$string['wrongpassword'] = 'Špatné heslo k tomuto uživatelskému jménu';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'rok';
$string['years'] = 'roky';
$string['yes'] = 'Ano';
$string['youareabouttocreatezip'] = 'Chystáte se vytvořit soubor ZIP obsahující';
$string['youaregoingtorestorefrom'] = 'Chystáte se zahájit proces obnovy';
$string['youneedtoenrol'] = 'K provedení této akce se musíte zapsat do kurzu';
$string['yourlastlogin'] = 'Vaše poslední přihlášení';
$string['yourself'] = 'vy';
$string['yourteacher'] = 'váš {$a}';
$string['yourwordforx'] = 'Vámi použivaný termín pro "{$a}"';
$string['zippingbackup'] = 'Komprimuji (ZIP) zálohu';
