<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'cs', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Máte jeden či více nových úkolů (klikněte zde pro zobrazení).';
$string['addattempt'] = 'Povolit další pokus';
$string['addnewattempt'] = 'Přidat nový pokus';
$string['addnewattemptfromprevious'] = 'Přidat nový pokus na základě posledního odevzdání';
$string['addnewattemptfromprevious_help'] = 'Tímto se vytvoří kopie předchozího odevzdání, na které budete moci dále pracovat.';
$string['addnewattempt_help'] = 'Tímto se vytvoří nový čistý formulář, na kterém můžete začít pracovat od začátku.';
$string['addsubmission'] = 'Přidat řešení úkolu';
$string['allocatedmarker'] = 'Přidělení hodnotitelé';
$string['allocatedmarker_help'] = 'Hodnotitelé přidělené tomuto řešení úkolu';
$string['allowsubmissions'] = 'Povolit uživateli pokračování v hodnocení odevzdaného úkolu.';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Detaily úkolu a formulář pro odevzdání bude dostupný od <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Povolit odevzdání úkolů od';
$string['allowsubmissionsfromdate_help'] = 'Je-li povoleno, studenti nebudou moci odevzdat svá řešení před nastaveným okamžikem. Není-li povoleno, studenti mohou odevzdávat okamžitě.';
$string['allowsubmissionsfromdatesummary'] = 'Odevzdat úkol bude možné od <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Povolit změny odevzdaného úkolu';
$string['alwaysshowdescription'] = 'Povolit zobrazení popisu';
$string['alwaysshowdescription_help'] = 'Je-li zakázáno, bude se popis úkol zobrazovat až poté, co je povoleno odevzdávání.';
$string['applytoteam'] = 'Použít hodnocení pro celou skupinu';
$string['assign:addinstance'] = 'Přidat nový úkol';
$string['assign:exportownsubmission'] = 'Exportovat vlastní řešení do portfolia';
$string['assignfeedback'] = 'Modul hodnocení';
$string['assignfeedbackpluginname'] = 'Modul hodnocení';
$string['assign:grade'] = 'Známkovat úkoly';
$string['assign:grantextension'] = 'Poskytnout prodloužení';
$string['assign:manageallocations'] = 'Správa přidělení hodnotitelů k odevzdaným úkolům';
$string['assign:managegrades'] = 'Revize a zveřejnění známek';
$string['assignmentisdue'] = 'Úkol je zpožděn';
$string['assignmentmail'] = '{$a->grader} ohodnotil  vaše řešení úkolu  "{$a->assignment}".

Hodnocení naleznete u svého úkolu na adrese:
{$a->url}.';
$string['assignmentmailhtml'] = '{$a->grader} ohodnotil  vaše řešení úkolu  <i>"{$a->assignment}"</i>. <br /><br />Hodnocení naleznete u <a href="{$a->url}">svého úkolu</a>.';
$string['assignmentmailsmall'] = '{$a->grader} ohodnotil vaše řešení úkolu "{$a->assignment}". Více informací najdete na stránce s vaším řešením.';
$string['assignmentname'] = 'Název úkolu';
$string['assignmentplugins'] = 'Rozšíření typu úkol';
$string['assignmentsperpage'] = 'Úkolů na stránku';
$string['assign:releasegrades'] = 'Zveřejnění známek';
$string['assign:revealidentities'] = 'Ukázat identitu studentů';
$string['assign:reviewgrades'] = 'Přezkoumání známek';
$string['assignsubmission'] = 'Rozšíření typu odevzdaný úkol';
$string['assignsubmissionpluginname'] = 'Rozšíření typu odevzdaný úkol';
$string['assign:submit'] = 'Odevzdávat úkoly';
$string['assign:view'] = 'Prohlížet úkoly';
$string['attemptheading'] = 'Pokus č. {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Předchozí pokusy';
$string['attemptnumber'] = 'Číslo pokusu';
$string['attemptreopenmethod'] = 'Opětovné otevření pokusů';
$string['attemptreopenmethod_help'] = 'Určuje, zda a za jakých podmínek dojde k opětovnému otevření pokusů.

* Nikdy - Jednou odevzdané řešení nelze znovu otevřít pro úpravy.
* Ručně - Vyučující může odevzdaná řešení znovu otevřít pro úpravy.
* Automaticky dokud neuspěje - Odevzdané řešení je automaticky otevřeno pro další úpravy, dokud za něj není udělena známka potřebná pro splnění úkolu (hodnotu této potřebné známky lze nastavit v Klasifikaci).';
$string['attemptreopenmethod_manual'] = 'Ručně';
$string['attemptreopenmethod_none'] = 'Nikdy';
$string['attemptreopenmethod_untilpass'] = 'Automaticky dokud neuspěje';
$string['attemptsettings'] = 'Nastavení pokusů';
$string['availability'] = 'Dostupnost';
$string['backtoassignment'] = 'Zpět k úkolu';
$string['batchoperationconfirmaddattempt'] = 'Povolit další pokus pro označená odevzdaná řešení?';
$string['batchoperationconfirmgrantextension'] = 'Poskytnout prodloužení pro všechny vybrané odevzdané úkoly?';
$string['batchoperationconfirmlock'] = 'Zamknout všechny vybrané odevzdané úkoly?';
$string['batchoperationconfirmreverttodraft'] = 'Vrátit vybrané odevzdané úkoly do stavu návrh?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Nastavit přidělení známek všech vybraných odevzdaných úkolech?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Nastavit zpracování známek všech vybraných odevzdaných úkolech?';
$string['batchoperationconfirmunlock'] = 'Odemknout všechny vybrané odevzdané úkoly?';
$string['batchoperationlock'] = 'zamknout odevzdané úkoly';
$string['batchoperationreverttodraft'] = 'vrátit odevzdaný úkol do stavu návrh';
$string['batchoperationsdescription'] = 'Provést s označenými ...';
$string['batchoperationunlock'] = 'odemknout odevzdané úkoly';
$string['batchsetallocatedmarker'] = 'Nastavit přidělení hodnotitele pro {$a} vybrané uživatele.';
$string['batchsetmarkingworkflowstateforusers'] = 'Nastavit zpracování známky pro {$a} vybrané uživatele.';
$string['blindmarking'] = 'Známkování naslepo';
$string['blindmarking_help'] = 'Známkování naslepo skryje pro hodnotitele identitu studentů. Nastavení anonymního známkování bude zamčeno po odevzdání úkolu nebo hodnocení úkolu.';
$string['changegradewarning'] = 'Tento úkol již obsahuje oznámkovaná řešení. Změna známky neovlivní tato již oznámkovaná řešení. Bude potřeba znovu ohodnotit všechna odevzdaná řešení, chcete-li změnit i stávající známky.';
$string['choosegradingaction'] = 'Akce oznámkování';
$string['choosemarker'] = 'Výběr ...';
$string['chooseoperation'] = 'Vyberte operaci';
$string['comment'] = 'Komentář';
$string['completionsubmit'] = 'Pro dokončení této činnosti musí student odevzdat úkol';
$string['configshowrecentsubmissions'] = 'Všem zobrazovat upozornění o odevzdaných úkolech v přehledu nedávné činnosti.';
$string['confirmbatchgradingoperation'] = 'Jste si jist, že chcete {$a->operation} pro {$a->count} studenty?';
$string['confirmsubmission'] = 'Jste si jisti, že chcete odeslat svou práci k hodnocení? Nebudete moci provádět žádné další změny.';
$string['conversionexception'] = 'Nelze konvertovat úkol. Výjimka je: {$a}.';
$string['couldnotconvertgrade'] = 'Nelze konvertovat hodnocení úkolu uživatele {$a}.';
$string['couldnotconvertsubmission'] = 'Nelze konvertovat odevzdaný úkol uživatele {$a}.';
$string['couldnotcreatecoursemodule'] = 'Nelze vytvořit modul kurzu.';
$string['couldnotcreatenewassignmentinstance'] = 'Nelze vytvořit novou instanci úkolu.';
$string['couldnotfindassignmenttoupgrade'] = 'Nelze nalézt staré instance úkolů k aktualizaci.';
$string['currentattempt'] = 'Toto je pokus č. {$a}.';
$string['currentattemptof'] = 'Toto je pokus č. {$a->attemptnumber} (celkem je povoleno {$a->maxattempts} pokusů).';
$string['currentgrade'] = 'Momentální známka v klasifikaci kurzu';
$string['cutoffdate'] = 'Datum ukončení';
$string['cutoffdatefromdatevalidation'] = 'Datum ukončení musí být po datu, kterým bylo umožněno odevzdávat úkoly';
$string['cutoffdate_help'] = 'Je-li nastaveno, nebude povoleno odevzdání úkolu po tomto datu, bez prodloužení termínu';
$string['cutoffdatevalidation'] = 'Datum ukončení nesmí předcházet termínu odevzdání.';
$string['defaultsettings'] = 'Výchozí nastavení úkolu';
$string['defaultsettings_help'] = 'Tato nastavení definují výchozí hodnoty pro nové úkoly.';
$string['defaultteam'] = 'Výchozí skupina';
$string['deleteallsubmissions'] = 'Odstranit všechna řešení úkolu';
$string['description'] = 'Popis';
$string['downloadall'] = 'Uložit odevzdané úkoly';
$string['duedate'] = 'Termín odevzdání';
$string['duedate_help'] = 'Ke kdy mají být řešení úkolu odevzdána. Řešení je možno odevzdat i po tomto termínu, ale budou v tom případě označena jako pozdní odevzdání. Pro úplné zabránění odevzdávání po určitém termínu nastavte datum ukončení.';
$string['duedateno'] = 'Bez termínu odevzdání';
$string['duedatereached'] = 'Termín pro odevzdání tohoto úkolu vypršel';
$string['duedatevalidation'] = 'Datum ukončení musí být po datu povolující odevzdání úkolu';
$string['editaction'] = 'Akce ...';
$string['editattemptfeedback'] = 'Úprava hodnocení pro pokus č. {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Upravujete hodnocení k odevzdanému řešení, které není nejnovější. Toto je pokus č. {$a->attemptnumber} z celkového počtu {$a->totalattempts}.';
$string['editingstatus'] = 'Stav úprav';
$string['editsubmission'] = 'Upravit řešení úkolu';
$string['editsubmission_help'] = 'Zde můžete provést změny ve vašem odevzdaném řešení úkolu.';
$string['enabled'] = 'Povoleno';
$string['errornosubmissions'] = 'Žádná odevzdaná řešení ke stažení.';
$string['errorquickgradingvsadvancedgrading'] = 'Hodnocení nebylo uloženo, neboť tento úkol v současné době využívá pokročilé hodnocení';
$string['errorrecordmodified'] = 'Hodnocení nebylo uloženo, protože někdo změnil jeden nebo více záznamů poté, co jste načetli tuto stránku.';
$string['event_all_submissions_downloaded'] = 'Všechny odevzdané úkoly se stahují';
$string['event_assessable_submitted'] = 'Úkol byl odeslán.';
$string['event_extension_granted'] = 'Bylo poskytnuto prodloužení termínu.';
$string['event_identities_revealed'] = 'Identita studentů byla odhalena.';
$string['event_marker_updated'] = 'Přidělený hodnotitel byl aktualizován.';
$string['event_statement_accepted'] = 'Uživatel přijal prohlášení o odevzdaném úkolu.';
$string['event_submission_duplicated'] = 'Uživatel zopakoval své řešení úkolu.';
$string['event_submission_graded'] = 'Odevzdaný úkol byl známkován.';
$string['event_submission_locked'] = 'Odevzdaný úkol byl pro uživatele zamčen.';
$string['event_submission_status_updated'] = 'Stav odevzdaného úkolu byl aktualizován.';
$string['event_submission_unlocked'] = 'Odevzdaný úkol byl uživateli odemčen.';
$string['event_submission_updated'] = 'Uživatel uložit svůj úkol.';
$string['event_workflow_state_updated'] = 'Stav zpracování byl aktualizován.';
$string['extensionduedate'] = 'Prodloužený termín odevzdání';
$string['extensionnotafterduedate'] = 'Prodloužený termín odevzdání musí být po termínu odevzdání';
$string['extensionnotafterfromdate'] = 'Prodloužený termín odevzdání musí být po datu umožňující odevzdání úkolu';
$string['feedback'] = 'Hodnocení';
$string['feedbackavailablehtml'] = '{$a->username} ohodnotil váš odevzdaný úkol "<i>{$a->assignment}</i>".<br /><br />
Hodnocení si můžete zobrazit u svého <a href="{$a->url}">odevzdaného úkolu</a>.';
$string['feedbackavailablesmall'] = '{$a->username} ohodnotil úkol {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} ohodnotil váš odevzdaný úkol "{$a->assignment}".

Hodnocení si můžete zobrazit u svého odevzdaného úkolu:

    {$a->url}';
$string['feedbackplugin'] = 'Modul hodnocení';
$string['feedbackpluginforgradebook'] = 'Modul, který vkládá hodnocení do klasifikace';
$string['feedbackpluginforgradebook_help'] = 'Pouze jeden z modulů hodnocení může vkládat údaje do klasifikace kurzu.';
$string['feedbackplugins'] = 'Moduly hodnocení';
$string['feedbacksettings'] = 'Nastavení hodnocení';
$string['feedbacktypes'] = 'Typy hodnocení';
$string['filesubmissions'] = 'Soubor odevzdaných úkolů';
$string['filter'] = 'Filtr';
$string['filternone'] = 'Bez filtru';
$string['filterrequiregrading'] = 'Požadováno hodnocení';
$string['filtersubmitted'] = 'Odevzdáno';
$string['gradeabovemaximum'] = 'Hodnocení musí být menší nebo rovno {$a}.';
$string['gradebelowzero'] = 'Hodnocení musí být větší nebo rovno nule.';
$string['gradecanbechanged'] = 'Známka může být změněna';
$string['graded'] = 'Udělena známka';
$string['gradedby'] = 'Hodnoceno';
$string['gradedon'] = 'Hodnoceno na';
$string['gradelocked'] = 'Známka je v klasifikaci zamčena nebo přepsána.';
$string['gradeoutof'] = 'Hodnoceno z {$a}';
$string['gradeoutofhelp'] = 'Hodnocení';
$string['gradeoutofhelp_help'] = 'Zde zadejte známku za úkol studenta. Může obsahovat desetetinná místa.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} upravil(a) své vypracování úkolu <em>"{$a->assignment}"</em> (upraveno {$a->timeupdated}).<br /><br />Aktualizované řešení je <a href="{$a->url}">dostupné zde</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} aktualizoval svůj odevzdaný úkol {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = '{$a->username} upravil(a) své vypracování úkolu "{$a->assignment}" (upraveno {$a->timeupdated}).

Aktualizované řešení je dostupné na:

{$a->url}.';
$string['gradestudent'] = 'Hodnocení studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Hodnocení {$a}';
$string['grading'] = 'Hodnocení';
$string['gradingchangessaved'] = 'Změny známek byly uloženy';
$string['gradingmethodpreview'] = 'Kriteria hodnocení';
$string['gradingoptions'] = 'Možnosti';
$string['gradingstatus'] = 'Stav hodnocení';
$string['gradingstudent'] = 'Hodnocený student';
$string['gradingsummary'] = 'Celkem hodnocení';
$string['grantextension'] = 'Poskytnout prodloužení';
$string['grantextensionforusers'] = 'Poskytnout prodloužení pro {$a} studentů';
$string['groupsubmissionsettings'] = 'Nastavení skupinového řešení';
$string['hiddenuser'] = 'Účastník';
$string['hideshow'] = 'Skrýt/zobrazit';
$string['instructionfiles'] = 'Soubory s návody';
$string['invalidfloatforgrade'] = 'Neplatné hodnocení: {$a}';
$string['invalidgradeforscale'] = 'Pro aktuální škálu není poskytnuté hodnocení správné.';
$string['lastmodifiedgrade'] = 'Poslední změna (hodnocení)';
$string['lastmodifiedsubmission'] = 'Poslední změna (odevzdaný úkol)';
$string['latesubmissions'] = 'Zpožděné odevzdané úkoly';
$string['latesubmissionsaccepted'] = 'Pouze studenti, kterým byl prodloužen termín, mohou stále odevzdat úkol';
$string['locksubmissionforstudent'] = 'Zamezit odevzdání úkolu studenta: (id={$a->id}, celé jméno={$a->fullname}).';
$string['locksubmissions'] = 'Zamknout odevzdání úkolů';
$string['manageassignfeedbackplugins'] = 'Správa modulů pro hodnocení';
$string['manageassignsubmissionplugins'] = 'Správa modulů pro odevzdání úkolů';
$string['marker'] = 'Hodnotitel';
$string['markerfilter'] = 'Filtr hodnotitele';
$string['markingallocation'] = 'Použijte přidělení známek';
$string['markingallocation_help'] = 'Je-li povoleno, mohou být hodnotitelé přiděleni studentům - vyžaduje, aby byl povolen postup známkování.';
$string['markingworkflow'] = 'Použít postup známkování';
$string['markingworkflow_help'] = 'Je-li povoleno, musí známky, než jsou studentům zveřejněny, projít řadou stavů postupu. To dovoluje více kol známkováni a umožňuje, aby všechny známky byly studentům zveřejněny najednou.';
$string['markingworkflowstate'] = 'Stav postupu známkování';
$string['markingworkflowstate_help'] = 'Seznam stavů postupu, které si můžete vybrat, jsou nastaveny podle vašeho oprávnění v tomto úkolu. Úplný seznam platných stavů je následující: <br><ul><li> Známkováno - Odevzdané úkoly jsou aktuálně známkovány </li></ul> ...';
$string['markingworkflowstateinmarking'] = 'Známkováno';
$string['markingworkflowstateinreview'] = 'Revidováno';
$string['markingworkflowstatenotmarked'] = 'Bez známky';
$string['markingworkflowstatereadyforrelease'] = 'Připraveno ke zveřejnění';
$string['markingworkflowstatereadyforreview'] = 'Známkování dokončeno';
$string['markingworkflowstatereleased'] = 'Zveřejněno';
$string['maxattempts'] = 'Nejvyšší počet pokusů';
$string['maxattempts_help'] = 'Nejvyšší možný počet pokusů na řešení úkolu pro každého studenta. Po dosažení tohoto počtu již nebude možno opětovně otevřít odevzdané řešení pro další úpravy.';
$string['maxgrade'] = 'Maximální známka';
$string['messageprovider:assign_notification'] = 'Oznámení úkolu';
$string['modulename'] = 'Úkol';
$string['modulename_help'] = 'Úkoly umožňují učiteli zadat úkoly, hodnotit odevzdané řešení a komentovat je.

Studenti mohou odevzdat libovolný soubor, jako  dokumenty textových aplikací, tabulky, obrázky nebo audio a video. Alternativně nebo současně může úkol požadovat, aby studenti napsali text přímo do textového pole. Úkol může být použit také pro připomenutí jiných povinností studentů, které neprobíhají přímo v Moodle - např. odevzdání výkresu.

Učitel může zobrazit odevzdané úkoly, připojit zpětnou vazbu a soubor, komentáře nebo nahrát audio odpověď.

Úkoly mohou být hodnoceny jednoduchým přímým hodnocením, případně pokročilou metodou. Výsledná známka je zapsána do klasifikace.';
$string['modulenameplural'] = 'Úkoly';
$string['moreusers'] = '{$a} více ...';
$string['mysubmission'] = 'Můj odevzdaný úkol:';
$string['newsubmissions'] = 'Odevzdané úkoly';
$string['noattempt'] = 'Neodevzdáno';
$string['nofiles'] = 'Žádný soubor.';
$string['nograde'] = 'Žádné hodnocení.';
$string['nolatesubmissions'] = 'Nelze odevzdat zpožděné úkoly';
$string['nomoresubmissionsaccepted'] = 'Nelze odevzdat žádné úkoly';
$string['noonlinesubmissions'] = 'Tento úkol nevyžaduje odpověď online';
$string['nosavebutnext'] = 'Další';
$string['nosubmission'] = 'K tomuto úkolu nebylo nic odevzdáno';
$string['nosubmissionsacceptedafter'] = 'Ukončení odevzdávání';
$string['notgraded'] = 'Nehodnoceno';
$string['notgradedyet'] = 'Zatím neudělena známka';
$string['notifications'] = 'Oznámení';
$string['notsubmittedyet'] = 'Zatím neodevzdáno';
$string['nousersselected'] = 'Nevybrán uživatel';
$string['numberofdraftsubmissions'] = 'Návrhy';
$string['numberofparticipants'] = 'Účastníci';
$string['numberofsubmissionsneedgrading'] = 'Nutno ohodnotit';
$string['numberofsubmittedassignments'] = 'Odevzdáno';
$string['numberofteams'] = 'Týmy';
$string['offline'] = 'Nejsou požadovány odpovědi online';
$string['open'] = 'Otevřeno';
$string['outlinegrade'] = 'Hodnocení: {$a}';
$string['outof'] = '{$a->current} ze {$a->total}';
$string['overdue'] = '<font color="red">Úkol má zpoždění: {$a}</font>';
$string['page-mod-assign-view'] = 'Hlavní stránka úkolu';
$string['page-mod-assign-x'] = 'Jakákoliv stránka úkolu';
$string['participant'] = 'Účastník';
$string['pluginadministration'] = 'Správa úkolu';
$string['pluginname'] = 'Úkol';
$string['preventsubmissions'] = 'Zabránit uživateli provést další odevzdání k tomuto úkolu.';
$string['preventsubmissionsshort'] = 'Zabránit změnám v odevzdaných úkolech';
$string['previous'] = 'Předchozí';
$string['quickgrading'] = 'Rychlé hodnocení';
$string['quickgradingchangessaved'] = 'Změny hodnocení uloženy';
$string['quickgrading_help'] = 'Rychlé hodnocení umožňuje známkovat úkoly (a očekávané výstupy) v tabulce hodnocení odevzdaných úkolů. Není kompatibilní s pokročilým známkováním a není doporučeno hodnocení více hodnotiteli.';
$string['quickgradingresult'] = 'Rychlé hodnocení';
$string['recordid'] = 'Identifikátor';
$string['requireallteammemberssubmit'] = 'Požadováno potvrzení všech členů týmu';
$string['requiresubmissionstatement'] = 'Požadovat, aby studenti přijali předložené prohlášení';
$string['requiresubmissionstatement_help'] = 'Požadovat, aby studenti pro řešení tohoto úkolu přijali předložené prohlášení';
$string['revealidentities'] = 'Odhalit identitu studentů';
$string['revealidentitiesconfirm'] = 'Jste si jisti, že chcete v úkolu zobrazit identitu studentů? Tuto operaci nelze vrátit zpět. Poté, co bude zobrazena identita studentů, budou známky uvolněny do přehledu známek.';
$string['reverttodraft'] = 'Vrátit úkol do stavu návrh.';
$string['reverttodraftforstudent'] = 'Vrátit úkol do stavu návrh pro studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Vrátit úkol do stavu návrh';
$string['reviewed'] = 'Revidováno';
$string['saveallquickgradingchanges'] = 'Uložit všechny změny hodnocení';
$string['savechanges'] = 'Uložit změny';
$string['savegradingresult'] = 'Známka';
$string['savenext'] = 'Uložit a zobrazit další';
$string['scale'] = 'Měřítko';
$string['selectedusers'] = 'Vybraní uživatelé';
$string['selectlink'] = 'Vybrat ...';
$string['selectuser'] = 'Vybrat  {$a}';
$string['sendlatenotifications'] = 'Zaslat oznámení hodnotitelům o pozdním odevzdání úkolu';
$string['sendnotifications'] = 'Zaslat oznámení hodnotitelům';
$string['sendstudentnotifications'] = 'Upozornit studenty';
$string['sendstudentnotifications_help'] = 'Je-li je povoleno, studenti obdrží upozornění o aktualizaci známky nebo komentáře.';
$string['sendsubmissionreceipts'] = 'Zaslat potvrzení o odevzdání úkolu studentům';
$string['setmarkerallocationforlog'] = 'Nastavit přidělení hodnotitelů: (id = {$a->id}, jméno = {$a->fullname}, hodnotitel = {$a->marker}).';
$string['setmarkingallocation'] = 'Nastavit přidělení hodnotitele';
$string['setmarkingworkflowstate'] = 'Nastavení postupu známkování';
$string['setmarkingworkflowstateforlog'] = 'Nastavení postupu známkování: (id = {$a->id}, jméno = {$a->fullname}, stav = {$a->state}).';
$string['settings'] = 'Nastavení úkolu';
$string['showrecentsubmissions'] = 'Zobrazovat nedávná odevzdání';
$string['status'] = 'Stav';
$string['submission'] = 'Odevzdané úkoly';
$string['submissioncopiedhtml'] = 'Vytvořili jste kopii odevzdaného úkolu <i>"{$a->assignment}".</i><br /><br />
Stav vašeho řešení si můžete <a href="{$a->url}">prohlédnout zde</a>.';
$string['submissioncopiedsmall'] = 'Zkopírovali jste předchozí odevzdaný úkol {$a->assignment}';
$string['submissioncopiedtext'] = 'Zkopírovali jste předchozí odevzdaný úkol "{$a->assignment}"

Stav odevzdaného úkolu si můžete prohlédnout:

    {$a->url}';
$string['submissiondrafts'] = 'Požadovat, aby studenti klikli na tlačítko Odeslat';
$string['submissioneditable'] = 'Student může upravit tento úkol';
$string['submissionempty'] = 'Nic nebylo odevzdáno';
$string['submissionnotcopiedinvalidstatus'] = 'Řešení úkolu nelze zkopírovat, protože bylo novým otevřením upraveno.';
$string['submissionnoteditable'] = 'Student nemůže upravit tento úkol';
$string['submissionnotready'] = 'Tento úkol není připraven k odevzdání:';
$string['submissionplugins'] = 'Rozšířený typu odevzdání úkolu';
$string['submissionreceipthtml'] = 'Odeslali jste řešení úkolu "<i>{$a->assignment}</i>"<br /><br />
Stav vašeho odevzdaného úkolu <a href="{$a->url}">si můžete zobrazit</a>.';
$string['submissionreceipts'] = 'Odeslat potvrzení o odevzdání';
$string['submissionreceiptsmall'] = 'Odeslali jste řešení úkolu {$a->assignment}';
$string['submissionreceipttext'] = 'Odeslali jste
řešení úkolu "{$a->assignment}"

Stav vašeho odevzdaného úkolu můžete zobrazit na:

    {$a->url}';
$string['submissions'] = 'Odevzdané úkoly';
$string['submissionsclosed'] = 'Odevzdávání uzavřeno';
$string['submissionsettings'] = 'Nastavení odevzdávání úkolů';
$string['submissionslocked'] = 'V tomto úkolu nelze odevzdat práci';
$string['submissionslockedshort'] = 'Změny odevzdaných úkolů nejsou povoleny';
$string['submissionsnotgraded'] = 'Nehodnocené odpovědi: {$a}';
$string['submissionstatement'] = 'Prohlášení';
$string['submissionstatementacceptedlog'] = 'Prohlášení přijaté uživatelem {$a}';
$string['submissionstatementdefault'] = 'Tento úkol je moje vlastní práce, s výjimkou uvedeného užití děl jiných lidí.';
$string['submissionstatement_help'] = 'Potvrzené prohlášení úkolu';
$string['submissionstatus'] = 'Stav odevzdání úkolu';
$string['submissionstatus_'] = 'Neodesláno';
$string['submissionstatus_draft'] = 'Návrh (neodesláno)';
$string['submissionstatusheading'] = 'Stav odevzdání úkolu';
$string['submissionstatus_marked'] = 'Udělena známka';
$string['submissionstatus_new'] = 'Nová odevzdání úkolu';
$string['submissionstatus_reopened'] = 'Znovu otevřeno';
$string['submissionstatus_submitted'] = 'Odesláno k hodnocení';
$string['submissionsummary'] = '{$a->status}. Poslední změna {$a->timemodified}';
$string['submissionteam'] = 'Tým';
$string['submissiontypes'] = 'Typy úkolů';
$string['submitaction'] = 'Odeslat';
$string['submitassignment'] = 'Odevzdat úkol';
$string['submitassignment_help'] = 'Po odevzdání úkolu nebudete moci provádět žádné změny';
$string['submitted'] = 'Odevzdáno';
$string['submittedearly'] = 'Úkoly byly odevzdány {$a} včas';
$string['submittedlate'] = 'Úkoly byly odevzdány {$a} po termínu';
$string['submittedlateshort'] = '{$a} po termínu';
$string['subplugintype_assignfeedback'] = 'Doplněk komentáře';
$string['subplugintype_assignfeedback_plural'] = 'Doplňky komentáře';
$string['subplugintype_assignsubmission'] = 'Doplněk řešení úkolu';
$string['subplugintype_assignsubmission_plural'] = 'Doplňky řešení úkolu';
$string['teamsubmission'] = 'Studenti odevzdávají úkol ve skupinách';
$string['teamsubmissiongroupingid'] = 'Seskupení pro studentské skupiny';
$string['teamsubmissionstatus'] = 'Status skupinového odevzdávání';
$string['textinstructions'] = 'Návod k úkolu';
$string['timemodified'] = 'Naposledy změněno';
$string['timeremaining'] = 'Zbývá';
$string['unlimitedattempts'] = 'Bez omezení';
$string['unlimitedattemptsallowed'] = 'Počet pokusů není omezen.';
$string['unlocksubmissionforstudent'] = 'Povolit odevzdání studentům: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Odemknout odevzdané úkoly';
$string['updategrade'] = 'Aktualizovat hodnocení';
$string['updatetable'] = 'Uložit a aktualizovat tabulku';
$string['upgradenotimplemented'] = 'Aktualizace není implementována pro modul ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Prodloužení poskytnuto do: {$a}';
$string['usergrade'] = 'Známka uživatele';
$string['userswhoneedtosubmit'] = 'Uživatelé, kteří potřebují odevzdat úkol:  {$a}';
$string['validmarkingworkflowstates'] = 'Platné stavy postupu známkování';
$string['viewbatchmarkingallocation'] = 'Zobrazena stránka přidělených hodnotitelů';
$string['viewbatchsetmarkingworkflowstate'] = 'Zobrazena stránka nastavení zpracování známek';
$string['viewfeedback'] = 'Zobrazit hodnocení';
$string['viewfeedbackforuser'] = 'Zobrazit hodnocení pro uživatele: {$a}';
$string['viewfull'] = 'Kompletní zobrazení';
$string['viewfullgradingpage'] = 'Otevřít stránku pro kompletní hodnocení';
$string['viewgradebook'] = 'Zobrazit známky';
$string['viewgrading'] = 'Zobrazit/hodnotit všechny odevzdané úkoly';
$string['viewgradingformforstudent'] = 'Zobrazit známky studenta: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Zobrazit stránku s vlastním odevzdaným úkolem.';
$string['viewownsubmissionstatus'] = 'Zobrazit stránku se stavem vlastního odevzdaného úkolu.';
$string['viewrevealidentitiesconfirm'] = 'Zobrazit stránku s potvrzením odhalené identity studentů';
$string['viewsubmission'] = 'Zobrazit odevzdané úkoly';
$string['viewsubmissionforuser'] = 'Zobrazit odevzdané úkoly uživatele: {$a}';
$string['viewsubmissiongradingtable'] = 'Zobrazit tabulku hodnocení odevzdaných úkolů.';
$string['viewsummary'] = 'Zobrazit přehled';
$string['workflowfilter'] = 'Filtr postupu';
