<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'hub', language 'pt_br', branch 'MOODLE_26_STABLE'
 *
 * @package   hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addscreenshots'] = 'Acrescentar imagem de tela';
$string['advertise'] = 'Anuncie este curso para pessoas se inscreverem';
$string['advertised'] = 'Anunciados';
$string['advertiseon'] = 'Anuncie este curso em {$a}';
$string['advertiseonhub'] = 'Anuncie este curso em um hub';
$string['advertiseonmoodleorg'] = 'Anuncie esse curso em moodle.org';
$string['advertisepublication_help'] = 'Anunciar seu curso em um servidor de hub da comunidade permite que as pessoas encontrem o seu curso e possam se inscrever nele.';
$string['all'] = 'Todos';
$string['allowglobalsearch'] = 'Publicar este hub e permitir uma pesquisa global de todos os cursos';
$string['allowpublicsearch'] = 'Publicar este hub para que as pessoas podem associar-se';
$string['audience'] = 'Público-alvo';
$string['audienceadmins'] = 'Administradores Moodle';
$string['audienceeducators'] = 'Educadores';
$string['audience_help'] = 'Selecionar a público-alvo do curso.';
$string['audiencestudents'] = 'Alunos';
$string['badgesnumber'] = 'Número de emblemas ({$a})';
$string['badurlformat'] = 'Formato da URL incorreto';
$string['cannotsearchcommunity'] = 'Desculpe, você não tem as permissões corretas para ver esta página';
$string['community'] = 'Comunidade';
$string['communityremoved'] = 'O link para este curso foi removido de sua lista';
$string['confirmregistration'] = 'Confirma registro';
$string['contactable'] = 'Contato ao público';
$string['contactable_help'] = 'Definindo como "sim" o hub vai mostrar o seu endereço de e-mail.';
$string['contactemail'] = 'E-mail para contato';
$string['contactname'] = 'Nome para contato';
$string['contactphone'] = 'Telefone';
$string['contactphone_help'] = 'Números de telefone são mostrados apenas para o administrador do Hub e não são mostrados publicamente.';
$string['continue'] = 'Continue';
$string['contributornames'] = 'Outros colaboradores';
$string['contributornames_help'] = 'Você pode usar este campo para listar os nomes de qualquer outra pessoa que contribuiu para este curso.';
$string['coursemap'] = 'Mapa do curso';
$string['coursename'] = 'Nome';
$string['courseprivate'] = 'Privado';
$string['coursepublic'] = 'Público';
$string['coursepublished'] = 'Este curso foi publicado com sucesso em \'{$a}\'.';
$string['courseshortname'] = 'Nome curto';
$string['courseshortname_help'] = 'Insira um nome curto para seu curso. Ele não precisa ser único';
$string['coursesnumber'] = 'Número de cursos ({$a})';
$string['courseunpublished'] = 'O curso {$a->courseshortname} já não é publicado em {$a->hubname}.';
$string['courseurl'] = 'URL do curso';
$string['courseurl_help'] = 'Este é o URL do seu curso. Este URL é mostrado como um link nos resultados de busca.';
$string['creatorname'] = 'Criador';
$string['creatorname_help'] = 'O criador é o criador de cursos.';
$string['creatornotes'] = 'Anotações sobre o criador';
$string['creatornotes_help'] = 'Notas do criador são um guia para professores sobre como usar o curso.';
$string['deletescreenshots'] = 'Excluir estes screenshots';
$string['deletescreenshots_help'] = 'Excluir todas as imagens atualmente subidas.';
$string['demourl'] = 'URL demonstração';
$string['demourl_help'] = 'Entre com o URL do demo do seu curso. Por padrão este é o URL do seu curso. O URL do demo é mostrado como um link no resultado de buca.';
$string['description'] = 'Descrição';
$string['description_help'] = 'Este texto descritivo será mostrado na lista de cursos no hub.';
$string['detectednotexistingpublication'] = '{$a->hubname} está listando um curso que não existe mais. Inorme ao administrador deste hub que a publicação {$a->id} deve ser removida.';
$string['downloadable'] = 'Downloadable';
$string['educationallevel'] = 'Nível de escolaridade';
$string['educationallevel_help'] = 'Selecione o nível educacional mais adequado para o curso.';
$string['edulevelassociation'] = 'Associação';
$string['edulevelcorporate'] = 'Corporativo';
$string['edulevelgovernment'] = 'Governo';
$string['edulevelother'] = 'Outros';
$string['edulevelprimary'] = 'Primário';
$string['edulevelsecondary'] = 'Secundário';
$string['eduleveltertiary'] = 'Terciário';
$string['emailalert'] = 'Avisdos de e-mail';
$string['emailalert_help'] = 'Se esta opção for ativada, o administrador do hub irá lhe enviar e-mails com notas sobre segurança e outras notícias importantes.';
$string['enrollable'] = 'Aceita inscrições';
$string['errorbadimageheightwidth'] = 'A imagem deve ter um tamanho máximo de {$a->width} X {$a->height}';
$string['errorcourseinfo'] = 'Um erro ocorreu ao receber os metadados do curso a partir do hub ({$a}). Por favor, tente novamente para acessar os metadados curso do hub acessando esta página mais tarde. Caso contrário, você pode decidir continuar o processo de inscrição com os metadados padrão a seguir.';
$string['errorcoursepublish'] = 'Ocorreu um erro durante a publicação do curso ({$a}). Por favor, tente novamente mais tarde.';
$string['errorcoursewronglypublished'] = 'Ocorreu um erro recebido pela publicação pelo hub. Por favor tente novamente mais tarde.';
$string['errorcron'] = 'Ocorreu um erro durante a atualização do registro no "{$a->hubname}" ({$a->errormessage})';
$string['errorcronnoxmlrpc'] = 'XML-RPC deve ser ativado para atualizar o registro.';
$string['errorhublisting'] = 'Um erro ocorreu no recebimento da lista de hubs do Moodle.org, por favor tente novamente mais tarde ({$a})';
$string['errorlangnotrecognized'] = 'Esta linguagem não é reconhecida pelo Moodle. Por favor, entre em contato com {$a}';
$string['errorregistration'] = 'Um errou ocorrou durante o registro. Por favor, tente denovo. ({$a})';
$string['errorunpublishcourses'] = 'Devido um erro inesperado, os cursos não podem ser excluídos do hub. Tente novamente mais tarde (recomendado) ou entre em contato com o administrador do hub.';
$string['existingscreenshotnumber'] = '{$a} screenshots existentes. Você será capaz de ver essas imagens nesta página, somente se o administrador do hub permitir em seu curso.';
$string['existingscreenshots'] = 'Screenshots existentes';
$string['forceunregister'] = 'Sim, limpe os dados de registro';
$string['forceunregisterconfirmation'] = 'Seu site não consegue localizar {$a}. Este hub pode estar temporariamente fora do ar. A menos que você tenha certeza que quer continuar a remover registro localmente, cancele esta operação e tente novamente mais tarde.';
$string['geolocation'] = 'Geolocalização';
$string['geolocation_help'] = 'No futuro poderemos fornecer pesquisa baseado na localização. Se você quiser especificar a localização do seu curso use um valor latitude/longitude aqui (Exemplo: -31.947884,115.871285). Uma forma de descobrir isto é utilizar o Google Maps.';
$string['hub'] = 'Hub';
$string['imageurl'] = 'Link da imagem';
$string['imageurl_help'] = 'Esta imagem será exibida no hub. Esta imagem deve estar disponível a partir do hub em qualquer momento. A imagem deve ter um tamanho máximo de {$a->width} X {$a->height}';
$string['information'] = 'Informação';
$string['issuedbadgesnumber'] = 'Número de emblemas emitidos ({$a})';
$string['language'] = 'Idioma';
$string['language_help'] = 'O idioma principal do curso.';
$string['lasttimechecked'] = 'Última verificação';
$string['licence'] = 'Licença';
$string['licence_help'] = 'Selecione a licença com a qual você deseja distribuir o seu curso.';
$string['logourl'] = 'Link do logo';
$string['modulenumberaverage'] = 'Número médio de módulos do curso ({$a})';
$string['moodleorg'] = 'Moodle.org';
$string['mustselectsubject'] = 'Você deve selecionar um assunto';
$string['name'] = 'Nome';
$string['name_help'] = 'Esse nome será exibido na listagem do curso.';
$string['neverchecked'] = 'Nunca verificada';
$string['next'] = 'Próximo';
$string['no'] = 'Não';
$string['nocheckstatusfromunreghub'] = 'O site não está registrado no hub, o status não pode ser verificado.';
$string['nohubselected'] = 'Nenhum hub selecionado';
$string['none'] = 'Nenhum';
$string['nosearch'] = 'Não publique hub ou cursos';
$string['notregisteredonhub'] = 'O administrador precisa registrar este site em pelo menos um hub para que você possa publicar um curso. Entre em contato com o administrador do site.';
$string['notregisteredonmoodleorg'] = 'O administrador precisa registrar este site no moodle.org.';
$string['operation'] = 'Ações';
$string['orenterprivatehub'] = 'Alternativamente, insira a URL de um hub privado:';
$string['participantnumberaverage'] = 'Número médio de participantes ({$a})';
$string['postaladdress'] = 'Endereço postal';
$string['postaladdress_help'] = 'Endereço postal deste site, ou da entidade representada por este site.';
$string['postsnumber'] = 'Número de posts ({$a})';
$string['previousregistrationdeleted'] = 'O registro anterior foi removido do {$a}. You pode recomeçar o processo de registro. Obrigado.';
$string['prioritise'] = 'Priorizar';
$string['privacy'] = 'Privacidade';
$string['privacy_help'] = 'O hub pode querer exibir uma lista de sites cadastrados. Você pode escolher se deseja ou não aparecer na lista, caso isso aconteça.';
$string['private'] = 'Privado';
$string['privatehuburl'] = 'URL do hub privado';
$string['publicationinfo'] = 'Informações sobre publicação de curso';
$string['publichub'] = 'Hub public';
$string['publishcourse'] = 'Publicar {$a}';
$string['publishcourseon'] = 'Publicar em {$a}';
$string['publishedon'] = 'Publicado em';
$string['publisheremail'] = 'Email do editor';
$string['publisheremail_help'] = 'O endereço de e-mail do editor permite que o administrador do hub possa alertar o editor sobre todas as alterações no status do curso publicado.';
$string['publishername'] = 'Editor';
$string['publishername_help'] = 'O editor é a pessoa ou organização que é editora oficial do curso. A menos que você esteja publicando o curso em nome de outra pessoa, usualmente o editor é você mesmo.';
$string['publishon'] = 'Publicar em';
$string['publishonspecifichub'] = 'Publicar em outro Hub';
$string['questionsnumber'] = 'Número de peguntas ({$a})';
$string['readvertiseon'] = 'Atualize as informações do anúncio no {$a}';
$string['registeredcourses'] = 'Cursos registrados';
$string['registeredmoodleorg'] = 'Moodle.org ({$a})';
$string['registeredon'] = 'Hubs com os quais você está registrado';
$string['registeredsites'] = 'Sites registrados';
$string['registermoochtips'] = 'Para se registrar no Moodle.org Open Community Hub (MOOCH), o site deve estar registrado no Moodle.org.';
$string['registersite'] = 'Registrar com {$a}';
$string['registerwith'] = 'Registrar em um hub';
$string['registrationconfirmed'] = 'Registro do site confirmado';
$string['registrationconfirmedon'] = 'Agora você está registrado no hub {$a}. Agora você pode publicar cursos neste hub, utilizando o link "Publicar" nos menus administrativos.';
$string['registrationinfo'] = 'Informações de registro';
$string['registrationupdated'] = 'O registro foi atualizado.';
$string['registrationupdatedfailed'] = 'A atualização de registro falhou.';
$string['removefromhub'] = 'Remover do hub';
$string['renewregistration'] = 'Renovar o registro';
$string['resourcesnumber'] = 'Número de recursos ({$a})';
$string['restartregistration'] = 'Recomeçar o registro';
$string['roleassignmentsnumber'] = 'Número de papéis atribuídos ({$a})';
$string['screenshots'] = 'Screenshots';
$string['screenshots_help'] = 'Quaisquer screenshots do curso serão exibidos nos resultados de busca.';
$string['search'] = 'Buscar';
$string['selecthub'] = 'Seleciona hub';
$string['selecthubforadvertise'] = 'Selecione hub para publicidade';
$string['selecthubforsharing'] = 'Selecione hub para upload';
$string['selecthubinfo'] = 'Um hub comunidade é um servidor que lista os cursos. Você só pode publicar seus cursos em hubs que este site está registrado com Moodle. Se o hub que você deseja não estiver listado abaixo, entre em contato com o administrador do site.';
$string['sendfollowinginfo'] = 'Mais informações';
$string['sendfollowinginfo_help'] = 'A informação seguinte será enviada apenas para contribuir com as estatísticas globais. Ela não será divulgada em nenhuma lista do site.';
$string['sendingcourse'] = 'Enviando curso';
$string['sendingsize'] = 'Por favor, aguarde o envio do arquivo do curso ({$a->total}Mb)...';
$string['sent'] = '...terminado';
$string['settings'] = 'Configurações';
$string['settingsupdated'] = 'As configurações foram atualizadas.';
$string['share'] = 'Permitir o download deste curso';
$string['shared'] = 'Compartilhado';
$string['shareon'] = 'Enviar este curso para  {$a}';
$string['shareonhub'] = 'Enviar este curso para o hub';
$string['sharepublication_help'] = 'Subindo este curso para o servidor de hub da comunidade será possível para outras pessoas baixá-lo e ou instalá-lo em seus próprios sites Moodle.';
$string['siteadmin'] = 'Administrador';
$string['siteadmin_help'] = 'O nome completo do administrador do site.';
$string['sitecountry'] = 'País';
$string['sitecountry_help'] = 'O pais em que sua organização está.';
$string['sitecreated'] = 'Site criado';
$string['sitedesc'] = 'Descrição';
$string['sitedesc_help'] = 'Esta descrição do seu site será mostrada na lista de sites. Por favor, use apenas texto simples.';
$string['siteemail'] = 'Endereço de email';
$string['siteemail_help'] = 'Você deve informar um endereço de email para que o administrador do HUB possa entrar em contato caso seja necessário. Este email não será utilizado para nenhum outro propósito. É recomendado fornecer um endereço de e-mail relacionado a uma função/cargo (exemplo: gerentedosite@exemplo.com) e não diretamente para uma pessoa.';
$string['sitegeolocation'] = 'Localização geográfica';
$string['sitegeolocation_help'] = 'No futuro nós providenciaremos nos hubs buscas baseadas na localização geográfica. Se você deseja especificar a localização do seu site, use valores de latitude e longitude (ex. -31.947884,115.871285). Uma forma de encontrar essa localização é usar o Google Maps.';
$string['sitelang'] = 'Idioma';
$string['sitelang_help'] = 'O idioma do seu site será exibido na lista de sites.';
$string['sitename'] = 'Nome';
$string['sitename_help'] = 'O nome do site será mostrado na listagem de sites se o hub permitir isso.';
$string['sitephone'] = 'Telefone';
$string['sitephone_help'] = 'Seu número de telefone será visível apenas para o administrador do hub.';
$string['siteprivacy'] = 'Privacidade';
$string['siteprivacylinked'] = 'Publicar o nome do site com link';
$string['siteprivacynotpublished'] = 'Não publicar este site';
$string['siteprivacypublished'] = 'Publicar apenas o nome do site';
$string['siteregconfcomment'] = 'Seu site precisa de uma confirmação final sobre {$a} (para evitar spam em {$a})';
$string['siteregistrationcontact'] = 'Formulário de contato';
$string['siteregistrationcontact_help'] = 'Se você permitir isso, outras pessoas poderão contactar você por meio de um formulário de contato no hub. Elas nunca poderão ver o seu endereço de e-mail.';
$string['siteregistrationemail'] = 'Notificações de email';
$string['siteregistrationemail_help'] = 'Se você ativar essa opção o administrador do hub poderá lhe enviar e-mails para lhe informar sobre notícias importantes, como questões de segurança.';
$string['siteregistrationupdated'] = 'Registro do site atualizado';
$string['siterelease'] = 'Versão do Moodle';
$string['siterelease_help'] = 'Número da versão do Moodle desse site.';
$string['siteupdatedcron'] = 'Registro do site atualizado em "{$a}"';
$string['siteupdatesend'] = 'Concluída a atualização do registro nos hubs.';
$string['siteupdatesstart'] = 'Iniciando a atualização do registro nos hubs...';
$string['siteurl'] = 'URL do site';
$string['siteurl_help'] = 'O URL é o endereço desse site. Se as preferências de privacidade permitirem que as pessoas vejam o endereço do site, então este URL será mostrado.';
$string['siteversion'] = 'Versão do Moodle';
$string['siteversion_help'] = 'A versão do Moodle deste site.';
$string['specifichubregistrationdetail'] = 'Você também pode registrar o seu site em outros hubs da comunidade.';
$string['statistics'] = 'Estatístísticas de privacidade';
$string['status'] = 'Listagem de hubs';
$string['statuspublished'] = 'Listado';
$string['statusunpublished'] = 'Não listado';
$string['subject'] = 'Assunto';
$string['subject_help'] = 'Selecione o tema principal abordado pelo curso.';
$string['tags'] = 'Tags';
$string['tags_help'] = 'Tags ajudam a classificar melhor o seu curso e também a encontrá-lo nas buscas. Por favor use palavras simples e significativas, e separe-as com uma vírgula. Exemplo: matemática, álgebra, geometria.';
$string['trustme'] = 'Confie';
$string['type'] = 'Publicado / compartilhado';
$string['unknownstatus'] = 'Desconhecido';
$string['unlistedurl'] = 'Não listar a URL do hub';
$string['unprioritise'] = 'Adiar';
$string['unpublish'] = 'Remover a publicação';
$string['unpublishalladvertisedcourses'] = 'Remover todos os cursos publicados em um hub';
$string['unpublishalluploadedcourses'] = 'Removido todos os cursos que foram enviados a um hub';
$string['unpublishconfirmation'] = 'Você realmente deseja remover o curso "{$a->courseshortname}" do hub "{$a->hubname}"';
$string['unpublishcourse'] = 'Remover a publicação {$a}';
$string['unregister'] = 'Cancelar o registro';
$string['unregisterconfirmation'] = 'Você está prestes a cancelar este site a partir do {$a} hub. Uma vez que você desligá-lo, você não será capaz de gerenciar todos os cursos que você deixou lá. Tem certeza que deseja cancelar o registro?';
$string['unregisterfrom'] = 'Remover o registro com {$a}';
$string['unregistrationerror'] = 'Ocorreu um erro ao remover o registro com o hub: {$a}';
$string['untrustme'] = 'Não confiável';
$string['update'] = 'Atualizar';
$string['updatesite'] = 'Atualizar o registro no {$a}';
$string['updatestatus'] = 'Verificar agora.';
$string['uploaded'] = 'Enviado';
$string['url'] = 'URL do hub';
$string['urlalreadyregistered'] = 'Seu site parece ser já registrado neste hub, o que significa que algo deu errado. Entre em contato com o administrador do hub para redefinir o seu registro para que você possa tentar novamente.';
$string['usersnumber'] = 'Número de usuários ({$a})';
$string['warning'] = 'CUIDADO';
$string['wrongtoken'] = 'O registro falhou por uma razão desconhecida (rede?). Por favor, tente novamente.';
$string['wrongurlformat'] = 'Formato errado do URL';
$string['xmlrpcdisabledcommunity'] = 'A extensão XML-PRC não está habilitada no servidor. Você não pode buscar e baixar cursos.';
$string['xmlrpcdisabledpublish'] = 'A extensão XML-RPC não está habilitada no servidor. Você não pode publicar cursos ou gerenciar cursos publicados.';
$string['xmlrpcdisabledregistration'] = 'A extensão XML-RPC não está habilitada no servidor. Você não poderá desregistrar ou atualizar seu registro até que você habilite a extensão.';
