<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'data', language 'pt_br', branch 'MOODLE_26_STABLE'
 *
 * @package   data
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Ação';
$string['add'] = 'Acrescentar Item';
$string['addcomment'] = 'Acrescentar Comentário';
$string['addentries'] = 'Acrescentar itens';
$string['addtemplate'] = 'Modelo para inserção';
$string['advancedsearch'] = 'Busca avançada';
$string['allowcomments'] = 'Permitir comentários';
$string['alttext'] = 'Texto alternativo';
$string['approve'] = 'Aprovar';
$string['approved'] = 'Aprovado';
$string['areacontent'] = 'Campos';
$string['ascending'] = 'Crescente';
$string['asearchtemplate'] = 'Modelo de busca avançada';
$string['atmaxentry'] = 'Você atingiu o limite de itens inseridos permitido!';
$string['authorfirstname'] = 'Nome do autor';
$string['authorlastname'] = 'Sobrenome do autor';
$string['autogenallforms'] = 'Criar todos os modelos padrão';
$string['autolinkurl'] = 'Criar link automático à URL';
$string['availablefromdate'] = 'Disponível a partir de';
$string['availabletags'] = 'Tags disponíveis';
$string['availabletags_help'] = '<p align="center"><strong>Tags disponíveis</strong></p>
<p>As tags indicam, no modelo, os lugares em que serão posicionados os campos e botões quando os itens forem editados ou acessados.</p>
<p>Os campos tem o seguinte formato: [[fieldname]]</p>
<p>Os botões tem o seguinte formato: ##somebutton##</p>
<p>Apenas as tags presentes na lista de  "Tags disponíveis" podem ser utilizadas neste modelo.</p>';
$string['availabletodate'] = 'Disponível até';
$string['blank'] = 'Vazio';
$string['buttons'] = 'Botões';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['cancel'] = 'Cancelar';
$string['cannotaccesspresentsother'] = 'Você não tem permissão para acessar pré-ajustes de outros usuários';
$string['cannotadd'] = 'Não foi possível adicionar entradas!';
$string['cannotdeletepreset'] = 'Erro ao excluir a pré-definição!';
$string['cannotoverwritepreset'] = 'Erro ao sobrescrever configuração';
$string['cannotunziptopreset'] = 'Não foi possível descompactar no diretório selecionado';
$string['checkbox'] = 'Caixa de seleção';
$string['chooseexportfields'] = 'Escolher os campos que você quer exportar:';
$string['chooseexportformat'] = 'Escolher o formato de exportação:';
$string['chooseorupload'] = 'Selecionar arquivo';
$string['columns'] = 'Colunas';
$string['comment'] = 'Comentário';
$string['commentdeleted'] = 'Comentário cancelado';
$string['commentempty'] = 'O comentário estava em branco';
$string['comments'] = 'Comentários';
$string['commentsaved'] = 'Comentário gravado';
$string['commentsn'] = '{$a} comentário(s)';
$string['commentsoff'] = 'O recurso de comentários não está habilitado';
$string['configenablerssfeeds'] = 'Esta opção habilita a possibilidade de criação de feeds RSS em todas as bases de dados. Para que os feeds sejam criados é necessário habilitar manualmente a opção em cada base de dados.';
$string['confirmdeletefield'] = 'Tem certeza que quer excluir este campo?';
$string['confirmdeleterecord'] = 'Tem certeza que quer excluir este item?';
$string['confirmdeleterecords'] = 'Tem certeza de que deseja excluir essas entradas?';
$string['csstemplate'] = 'Modelo CSS';
$string['csvfailed'] = 'Impossível ler os dados deste arquivo CSV';
$string['csvfile'] = 'Arquivo CSV';
$string['csvimport'] = 'Importação de arquivo CSV';
$string['csvimport_help'] = '<p align="center"><strong>Importar de um arquivo CSV</strong></p>

<p>CSV significa, em português, Valores Separados por Vírgulas (Comma-Separated-Values
   em inglês). É um formato comum para intercâmbio de textos envolvendo dados.</p>

<p>O formato é um arquivo de texto simples, com uma lista de nomes de
   campos na primeira linha. Os dados vem em seguida, um registro por linha.</p>

<p>O separador de campo padrão é a virgula e a delimitação de campo não é definida por padrão
   (os delimitadores de campo são caracteres que marcam o começo e o fim do campo).

<p>Os registros devem ser delimitados por novas linhas (normalmente geradas quando se
   pressiona RETURN ou ENTER no seu editor de texto). As tabulações podem ser especificadas
   usando-se t e novas linhas ou mudança de linha por n. </p>

<p>Arquivo de Exemplo:</p>
<pre>
  nome,altura,peso
  Kai,180cm,80kg
  Kim,170cm,60kg
  Koo,190cm,20kg
</pre>
</p>

<p>Atenção: Alguns tipos de campos podem não estar de acordo com os formatos suportados.</p>';
$string['csvwithselecteddelimiter'] = '<acronym title="Valores separados por vírgulas">CSV</acronym> texto com valores separados por vírgulas:';
$string['data:addinstance'] = 'Adicionar nova base de dados';
$string['data:approve'] = 'Aprovar itens pendentes';
$string['data:comment'] = 'Escrever comentário';
$string['data:exportallentries'] = 'Exportar todas as entradas da base de dados';
$string['data:exportentry'] = 'Exportar uma entrada da base de dados';
$string['data:exportownentry'] = 'Exportar uma própria entrada da base de dados';
$string['data:exportuserinfo'] = 'Exportar informações do usuário';
$string['data:managecomments'] = 'Gerenciar comentários';
$string['data:manageentries'] = 'Gerenciar itens';
$string['data:managetemplates'] = 'Gerenciar modelos';
$string['data:manageuserpresets'] = 'Gerenciar todos os modelos padrâo';
$string['data:rate'] = 'Avaliar itens';
$string['data:readentry'] = 'Ler itens';
$string['data:viewallratings'] = 'Ver a pontuação total recebida';
$string['data:viewalluserpresets'] = 'Ver os modelos padrão de todos os usuários';
$string['data:viewanyrating'] = 'Ver total de avaliações recebidas por todos';
$string['data:viewentry'] = 'Ver itens';
$string['data:viewrating'] = 'Ver avaliações';
$string['data:writeentry'] = 'Escrever itens';
$string['date'] = 'Data';
$string['dateentered'] = 'Data de inserção';
$string['defaultfielddelimiter'] = '(o padrão é a vírgula)';
$string['defaultfieldenclosure'] = '(o padrão é nenhum)';
$string['defaultsortfield'] = 'Campo de ordenação padrão';
$string['delcheck'] = 'Exclusão em massa de Checkbox';
$string['delete'] = 'Cancelar';
$string['deleteallentries'] = 'Excluir todos os itens';
$string['deletecomment'] = 'Tem certeza que quer excluir este comentário?';
$string['deleted'] = 'cancelado';
$string['deletefield'] = 'Cancelar um campo existente';
$string['deletenotenrolled'] = 'Excluir itens de usuários não inscritos';
$string['deletewarning'] = 'Tem certeza que quer excluir estes modelos padrão?';
$string['descending'] = 'Decrescente';
$string['directorynotapreset'] = '{$a->directory} não é un conjunto de modelos: arquivos faltando: {$a->missing_files}';
$string['disapprove'] = 'Desfazer aprovação';
$string['download'] = 'Baixar';
$string['edit'] = 'Editar';
$string['editcomment'] = 'Editar comentário';
$string['editentry'] = 'Editar item';
$string['editordisable'] = 'Desabilitar editor';
$string['editorenable'] = 'Habilitar editor';
$string['emptyadd'] = 'O modelo está vazio, usando um formulário padrão...';
$string['emptyaddform'] = 'Você não completou nenhum campo!';
$string['entries'] = 'Itens';
$string['entrieslefttoadd'] = 'Você precisa adicionar mais {$a->entriesleft} item(ns) para completar esta atividade';
$string['entrieslefttoaddtoview'] = 'Você precisa adicionar mais {$a->entrieslefttoview} item(ns) antes de poder ver os itens dos outros participantes.';
$string['entry'] = 'Item';
$string['entrysaved'] = 'O seu item foi gravado';
$string['errormustbeteacher'] = 'Apenas os professores podem usar esta página!';
$string['errorpresetexists'] = 'Já existe um pré-ajuste com o nome selecionado';
$string['example'] = 'Exemplo de Base de dados';
$string['excel'] = 'Excel';
$string['expired'] = 'Sinto muito, mas esta atividade foi fechada em {$a} e não está mais disponível';
$string['export'] = 'Exportar';
$string['exportaszip'] = 'Exportar como zip';
$string['exportaszip_help'] = '<p align="center"><strong>Exportar como Zip</strong></p>
<p>Isso permite que você baixe os modelos para seu computador, que podem ser enviados mais tarde para outro banco de dados, com o comando de importar arquivos zip.</p>';
$string['exportedtozip'] = 'Exportar em zip provisório';
$string['exportentries'] = 'Exportar conteúdo';
$string['exportownentries'] = 'Exportar somente as suas próprias entradas? ({$a->mine}/{$a->all})';
$string['failedpresetdelete'] = 'Erro apagando conjunto de modelos padrão';
$string['fieldadded'] = 'Campo acrescentado';
$string['fieldallowautolink'] = 'Permitir link automático';
$string['fielddeleted'] = 'Campo cancelado';
$string['fielddelimiter'] = 'Delimitador do campo';
$string['fielddescription'] = 'Descrição do campo';
$string['fieldenclosure'] = 'Anexo do campo';
$string['fieldheight'] = 'Altura';
$string['fieldheightlistview'] = 'Altura das listas';
$string['fieldheightsingleview'] = 'Altura de item único';
$string['fieldids'] = 'IDs dos campos';
$string['fieldmappings'] = 'Mapeamento dos campos';
$string['fieldmappings_help'] = '<p align="center"><strong>Mapeamento de Campos</strong></p>
<p>Esse menu permite guardar os dados de um banco de dados existente. Para preservar os dados em um campo, você deve mapeá-lo para um novo campo, onde os dados aparecerão. Os campos também podem ficar em branco, para que nenhuma informação seja copiada nele. Os campos antigos não mapeados para um novo serão perdidos e os dados, removidos.</p>
<p>
Você só pode mapear campos de um mesmo tipo, em modo que cada caixa de seleção tenha campos diferentes. Também tenha cuidado para não tentar mapear um campo antigo para mais de um campo novo.
</p>';
$string['fieldname'] = 'Nome do Campo';
$string['fieldnotmatched'] = 'Os seguintes campos do seu arquivo não são conhecidos neste database: {$a}';
$string['fieldoptions'] = 'Opções (uma por linha)';
$string['fields'] = 'Campos';
$string['fieldupdated'] = 'Campos atualizados';
$string['fieldwidth'] = 'Largura';
$string['fieldwidthlistview'] = 'Largura das listas';
$string['fieldwidthsingleview'] = 'Largura de item único';
$string['file'] = 'Arquivo';
$string['fileencoding'] = 'Codificação';
$string['filesnotgenerated'] = 'Alguns arquivos não foram criados: {$a}';
$string['filtername'] = 'Link automático à base de dados';
$string['footer'] = 'Pé de página';
$string['forcelinkname'] = 'Nome obrigatório do link';
$string['foundnorecords'] = 'Nenhum conteúdo encontrado (<a href="{$a->reseturl}">Reconfigurar filtros</a>)';
$string['foundrecords'] = 'Encontrados: {$a->num}/{$a->max} (<a href="{$a->reseturl}">Reconfigurar filtros</a>)';
$string['fromfile'] = 'Importar de arquivo zip';
$string['fromfile_help'] = '<p align=\'center\'><strong>Importar predefinições de um Zip</strong></p>
<p>Use isso para enviar predefinições que foram salvas no seu computador usando a opção de exportar.</p>';
$string['generateerror'] = 'Nem todos os arquivos gerados!';
$string['header'] = 'Cabeçalho';
$string['headeraddtemplate'] = 'Define a interface para inserção de novos itens';
$string['headerasearchtemplate'] = 'Define a interface de buscas avançadas';
$string['headercsstemplate'] = 'Define os estilos CSS locais para os outros modelos';
$string['headerjstemplate'] = 'Define o padrão javascript para outros modelos';
$string['headerlisttemplate'] = 'Define a interface de navegação para listas de itens';
$string['headerrsstemplate'] = 'Define a aparência de itens em feeds RSS';
$string['headersingletemplate'] = 'Define a interface de navegação de um item único';
$string['importentries'] = 'Importar conteúdo';
$string['importsuccess'] = 'O conjunto de modelos foi aplicado com sucesso';
$string['includeapproval'] = 'Incluir estado de aprovação';
$string['includetime'] = 'Incluir tempo adicionado / modificado';
$string['includeuserdetails'] = 'Incluir detalhes do usuário';
$string['insufficiententries'] = 'mais itens necessários antes de visualizar esta base de dados';
$string['intro'] = 'Descrição';
$string['invalidaccess'] = 'Esta página não foi acessada corretamente';
$string['invalidfieldid'] = 'O ID do campo está incorreto';
$string['invalidfieldname'] = 'Escolha um outro nome para este campo';
$string['invalidfieldtype'] = 'Tipo de campo está incorreto';
$string['invalidid'] = 'ID de dados incorreta';
$string['invalidpreset'] = '	
{$a} não é um pré-ajuste';
$string['invalidrecord'] = 'Registro incorreto';
$string['invalidurl'] = 'A URL inserida não é válida';
$string['jstemplate'] = 'Modelo Javascript';
$string['latitude'] = 'Latitude';
$string['latlong'] = 'Latitude/longitude';
$string['latlongdownloadallhint'] = 'Baixar link de todos os itens como KML';
$string['latlongkmllabelling'] = 'Como adicionar descrição a itens em arquivos KML (Google Earth)';
$string['latlonglinkservicesdisplayed'] = 'Serviços Link-out visualizados';
$string['latlongotherfields'] = 'Outros campos';
$string['list'] = 'Ver lista';
$string['listtemplate'] = 'Modelo de Lista';
$string['longitude'] = 'Longitude';
$string['mapexistingfield'] = '	
Mapear para {$a}';
$string['mapnewfield'] = 'Criar um novo campo';
$string['mappingwarning'] = 'Todos os campos antigos que não forem mapeados para um novo campo serão perdidos e todos os dados naquele campo serão removidos.';
$string['maxentries'] = 'Número máximo de entradas';
$string['maxentries_help'] = '<p align="center"><strong>Número Máximo Itens</strong></p>

<p>O número máximo de itens que um aluno pode criar nesta atividade.</p>';
$string['maxsize'] = 'Tamanho máximo';
$string['menu'] = 'Menu';
$string['menuchoose'] = 'Selecionar...';
$string['missingdata'] = 'Identificação de dados ou objeto deve ser fornecida para a classe de campo';
$string['missingfield'] = 'Erro de programação: você deve especificar um campo e/ou dados quando estiver definindo a classe do campo.';
$string['modulename'] = 'Base de dados';
$string['modulename_help'] = 'O módulo de atividades de banco de dados permite aos participantes criar, manter e pesquisar em um banco de entradas de registros. O formato e a estrutura dessas entradas são quase ilimitados, incluindo imagens, arquivos, URLs, números e texto, entre outras coisas.';
$string['modulenameplural'] = 'Bases de dados';
$string['more'] = 'Mais';
$string['moreurl'] = 'Mais URL';
$string['movezipfailed'] = 'Impossível mover arquivo zip';
$string['multientry'] = 'Repetir item';
$string['multimenu'] = 'Menu (múltipla-escolha)';
$string['multipletags'] = 'Tags multiplos! O Modelo não foi gravado';
$string['namecheckbox'] = 'Campo Checkbox';
$string['namedate'] = 'Campo Data';
$string['namefile'] = 'Campo Arquivo';
$string['namelatlong'] = 'Campo de latitude/longitude';
$string['namemenu'] = 'Campo Menu';
$string['namemultimenu'] = 'Campo Menu múltipla-escolha';
$string['namenumber'] = 'Campo número';
$string['namepicture'] = 'Campo imagem';
$string['nameradiobutton'] = 'Campo botão radio';
$string['nametext'] = 'Campo Texto';
$string['nametextarea'] = 'Campo de área de texto';
$string['nameurl'] = 'Campo URL';
$string['newentry'] = 'Novo item';
$string['newfield'] = 'Criar novo campo';
$string['newfield_help'] = '<p align="center"><strong>Campos</strong></p>

<p>Nesta tela você pode criar os campos que serão parte de sua base de dados.</p>

<p>Cada campo permite diferentes tipos de dados, com diferentes interfaces.</p>';
$string['noaccess'] = 'Você não tem permissão de acesso a esta página';
$string['nodefinedfields'] = 'O novo conjunto de modelos não tem campos definidos!';
$string['nofieldcontent'] = 'Conteúdo do campo não encontrado';
$string['nofieldindatabase'] = 'Nenhum campo definido nesta base de dados.';
$string['nolisttemplate'] = 'O modelo da lista ainda não foi definido';
$string['nomatch'] = 'Nenhum item correspondente encontrado!';
$string['nomaximum'] = 'Nenhum máximo';
$string['norecords'] = 'Nenhum item na base de dados';
$string['nosingletemplate'] = 'O modelo para item único ainda não foi definido';
$string['notapproved'] = 'O item ainda não foi aprovado';
$string['notinjectivemap'] = 'Não é um mapa injetivo';
$string['notopenyet'] = 'Desculpe, esta atividade não está disponível até {$a}';
$string['number'] = 'Número';
$string['numberrssarticles'] = 'Artigos RSS';
$string['numnotapproved'] = 'Pendente';
$string['numrecords'] = '{$a} itens';
$string['ods'] = '<acronym title="Planilha OpenDocument">ODS</acronym>(OpenOffice)';
$string['optionaldescription'] = 'Descrição breve (opcional)';
$string['optionalfilename'] = 'Nome do arquivo (opcional)';
$string['other'] = 'Outro';
$string['overrwritedesc'] = 'Subscrever se isto já existir ';
$string['overwrite'] = 'Substituir';
$string['overwritesettings'] = 'Substituir configurações atuais';
$string['page-mod-data-x'] = 'Qualquer página de banco de dados';
$string['pagesize'] = 'Itens por página';
$string['participants'] = 'Participantes';
$string['picture'] = 'Imagem';
$string['pleaseaddsome'] = 'Por favor crie alguns ou <a href="{$a}">escolha um novo conjunto-padrão</a> antes de iniciar.';
$string['pluginadministration'] = 'Administração de banco de dados de atividade';
$string['pluginname'] = 'Base de dados';
$string['portfolionotfile'] = 'Exportar um portfólio ao invés de um arquivo (somente CSV e leap2a)';
$string['presetinfo'] = 'Salvar como conjunto-padrão para que os modelos sejam públicos. Outros usuários poderão usar estes modelos.';
$string['presets'] = 'Conjuntos de modelos padrão';
$string['radiobutton'] = 'Botões de opção';
$string['recordapproved'] = 'Item aprovado';
$string['recorddeleted'] = 'Item cancelado';
$string['recorddisapproved'] = 'Entrada não aprovada';
$string['recordsnotsaved'] = 'Nenhum item foi registrado. Por favor controle o formato do arquivo carregado no servidor.';
$string['recordssaved'] = 'Item gravado';
$string['requireapproval'] = 'Aprovação necessária';
$string['requireapproval_help'] = '<p align="center"><strong>Exigir aprovação</strong></p>

<p>As entradas devem ser aprovadas pelo professor antes que sejam acessíveis aos estudantes? Isto é útil para moderar a publicação de conteúdos que podem ser potencialmente ofensivos ou impróprios.</p>';
$string['requiredentries'] = 'Entradas necessárias para a conclusão';
$string['requiredentries_help'] = '<p align="center"><strong>Itens Obrigatórios</strong></p>

<p>O número de itens obrigatórios que um participante deve enviar. Os usuários verão um lembrete se eles não submeteram o número requerido de itens.</p>

<p>A atividade não será considerada completa antes que o usuário tenha enviado o número requerido de itens</p>';
$string['requiredentriestoview'] = 'Itens obrigatórios antes da visualização';
$string['requiredentriestoview_help'] = '<p align="center"><strong>Itens Obrigatórios antes da Permissão de Visualização</strong><p>

<p>O número de itens que um participante deve enviar antes que lhe seja permitido acessar itens criados por outros usuários nesta atividade de banco de dados.</p>';
$string['resetsettings'] = 'Reconfigurar filtros';
$string['resettemplate'] = 'Restaurar modelo';
$string['resizingimages'] = 'Redimensionando imagem minimizada...';
$string['rows'] = 'linhas';
$string['rssglobaldisabled'] = 'Desabilitado. Ver configuração das variáveis do site.';
$string['rsstemplate'] = 'Modelo do RSS';
$string['rsstitletemplate'] = 'Modelo do título do RSS';
$string['save'] = 'Gravar';
$string['saveandadd'] = 'Gravar e acrescentar outro';
$string['saveandview'] = 'Gravar e mostrar';
$string['saveaspreset'] = 'Salvar como modelo';
$string['saveaspreset_help'] = '<p align="center"><strong>Salvar como Predefinição</strong></p>
<p>Isto publica os modelos atuais como uma predefinição que qualquer um no site pode ver ou usar. Ela aparecerá na lista de predefinições. Você será habilitado a removê-la a qualquer momento.</p>';
$string['savesettings'] = 'Gravar configuração';
$string['savesuccess'] = 'Arquivado com sucesso. O seu conjunto-padrão foi compartilhado.';
$string['savetemplate'] = 'Gravar modelo';
$string['search'] = 'Busca';
$string['selectedrequired'] = 'Todos os itens selecionados são obrigatórios';
$string['showall'] = 'Mostrar todos os itens';
$string['single'] = 'Ver item único';
$string['singletemplate'] = 'Modelo de item único';
$string['subplugintype_datafield'] = 'Tipo de campo do banco de dados';
$string['subplugintype_datafield_plural'] = 'Tipos de campos do banco de dados';
$string['subplugintype_datapreset'] = 'Pré-configurado';
$string['subplugintype_datapreset_plural'] = 'Conjuntos de modelos padrão';
$string['teachersandstudents'] = '{$a->teachers} e {$a->students}';
$string['templates'] = 'Modelos';
$string['templatesaved'] = 'Modelo gravado';
$string['text'] = 'Texto';
$string['textarea'] = 'Area de texto';
$string['timeadded'] = 'Tempo adicionado';
$string['timemodified'] = 'Tempo modificado';
$string['todatabase'] = 'nesta base de dados';
$string['type'] = 'Tipo de campo';
$string['undefinedprocessactionmethod'] = 'Nenhuma ação definida em Data_Preset para lidar com a ação "{$a}".';
$string['unsupportedexport'] = '({$a->fieldtype}) não pode ser exportado.';
$string['updatefield'] = 'Atualizar campo existente';
$string['uploadfile'] = 'Carregar arquivo';
$string['uploadrecords'] = 'Carregar itens a partir de um arquivo';
$string['uploadrecords_help'] = 'É possível fazer o upload de registros via arquivos de texto. O formato do arquivo deve ser da seguinte forma:

* Cada linha do arquivo contém um registro
* Cada registro é uma série de dados separados por vírgula (ou outros delimitadores)
* O primeiro registro contém uma lista dos nomes dos campos definindo o formato do restante do arquivo

O limitador de campo é um caractere que envolve cada campo em cada registro. Ele pode ser normalmente deixado indefinido.';
$string['url'] = 'Url';
$string['usedate'] = 'Incluir na pesquisa.';
$string['usestandard'] = 'Usar um conjunto';
$string['usestandard_help'] = '<p align="center"><strong>Usar Predefinição</strong></p>
<p> Usar um modelo disponível para o site inteiro.</p>
<p> Se você adicionou a predefinição à biblioteca usando a opção \'Salvar como Predefinição\', você pode apagá-la.</p>';
$string['viewfromdate'] = 'Visível a partir de';
$string['viewtodate'] = 'Visível até';
$string['wrongdataid'] = 'ID de dados errado';
