<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'pt_br', branch 'MOODLE_26_STABLE'
 *
 * @package   assign
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityoverview'] = 'Você tem tarefas que precisam de atenção';
$string['addattempt'] = 'Permitir outra tentativa';
$string['addnewattempt'] = 'Adicionar uma nova tentativa';
$string['addnewattemptfromprevious'] = 'Adicionar uma nova tentativa baseada na tentativa anterior';
$string['addnewattemptfromprevious_help'] = 'Isto irá copiar o conteúdo de sua tentativa anterior para uma nova tentativa para você trabalhar.';
$string['addnewattempt_help'] = 'Isto irá criar uma nova tentativa em branco para você trabalhar.';
$string['addsubmission'] = 'Adicionar tarefa';
$string['allocatedmarker'] = 'Marcador Atribuído';
$string['allocatedmarker_help'] = 'Marcador atribuído a este envio';
$string['allowsubmissions'] = 'Permitir que usuário continue realizando envios para esta tarefa';
$string['allowsubmissionsanddescriptionfromdatesummary'] = 'Os detalhes da tarefa e formulário de envio ficarão disponíveis a partir de <strong>{$a}</strong>';
$string['allowsubmissionsfromdate'] = 'Permite envios a partir de';
$string['allowsubmissionsfromdate_help'] = 'Caso habilitado, estudantes não terão disponibilidade para enviar antes desta data. Caso desabilitado, estudantes poderão enviar.';
$string['allowsubmissionsfromdatesummary'] = 'Esta tarefa aceitará envios a partir de <strong>{$a}</strong>';
$string['allowsubmissionsshort'] = 'Permite mudanças no envio';
$string['alwaysshowdescription'] = 'Sempre exibir descrição';
$string['alwaysshowdescription_help'] = 'Se desabilitado a descrição acima somente ficará visível aos alunos a partir da data configurada em "Permitir envios a partir de".';
$string['applytoteam'] = 'Habilitar notas e feedback para todo grupo';
$string['assign:addinstance'] = 'Adicionar uma nova tarefa';
$string['assign:exportownsubmission'] = 'Exportar a própria apresentação';
$string['assignfeedback'] = 'Plugin de feedback';
$string['assignfeedbackpluginname'] = 'Plugin de feedback';
$string['assign:grade'] = 'Avaliar tarefa';
$string['assign:grantextension'] = 'Conceder prorrogação';
$string['assign:manageallocations'] = 'Gerenciar marcadores atribuídos para envios';
$string['assign:managegrades'] = 'Revisar e liberar notas';
$string['assignmentisdue'] = 'Tarefa encerrada';
$string['assignmentmail'] = '{$a->grader} escreveu comentários sobre a seguinte tarefa que você envioiu em \'{$a->assignment}\'

Leia os comentários anexos à tarefa:

{$a->url}';
$string['assignmentmailhtml'] = '{$a->grader} escreveu comentários sobre a tarefa que você enviou: \'<i>{$a->assignment}</i>\'<br /><br />
Você pode vê-lo anexado à <a href="{$a->url}">tarefa enviada</a>.';
$string['assignmentmailsmall'] = '{$a->grader} publicou alguns comentários na tarefa enviada em \'{$a->assignment}\'. Você pode visualizar estes comentários incluídos em sua tarefa';
$string['assignmentname'] = 'Nome da tarefa';
$string['assignmentplugins'] = 'Plugins de tarefas';
$string['assignmentsperpage'] = 'Tarefas por página';
$string['assign:releasegrades'] = 'Liberar notas';
$string['assign:revealidentities'] = 'Revelar identidade dos estudantes';
$string['assign:reviewgrades'] = 'Revisar notas';
$string['assignsubmission'] = 'Plugin para envio';
$string['assignsubmissionpluginname'] = 'Plugin para envio';
$string['assign:submit'] = 'Enviar tarefa em definitivo';
$string['assign:view'] = 'Ver tarefa';
$string['attemptheading'] = 'Tentativa {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Tentativas anteriores';
$string['attemptnumber'] = 'Número da tentativa';
$string['attemptreopenmethod'] = 'Tentativas reabertas';
$string['attemptreopenmethod_help'] = 'Determina como as tentativas de envio do estudante são reabertas.
As opções disponíveis são: <ul><li>Nunca - O envio do estudante não pode ser reaberto.</li><li>Manualmente -  O envio do estudante pode ser reaberto por um professor.</li> Automaticamente até passar - O envio do estudante é automaticamente reaberto até o estudante obter a nota para passar, este valor é definido na grade de notas (Categorias e seção itens) para esta tarefa.</li></ul>';
$string['attemptreopenmethod_manual'] = 'Manualmente';
$string['attemptreopenmethod_none'] = 'Nunca';
$string['attemptreopenmethod_untilpass'] = 'Automaticamente até que passe';
$string['attemptsettings'] = 'Configurações de tentativa';
$string['availability'] = 'Disponibilidade';
$string['backtoassignment'] = 'Voltar para tarefa';
$string['batchoperationconfirmaddattempt'] = 'Permitir uma outra tentativa para os envios selecionados?';
$string['batchoperationconfirmgrantextension'] = 'Conceder uma prorrogação para todos os envios selecionados?';
$string['batchoperationconfirmlock'] = 'Travar todos os envios selecionados?';
$string['batchoperationconfirmreverttodraft'] = 'Reverter envios selecionados para rascunho?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Definir a alocação de notas para todos os envios selecionados?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Definir estado no fluxo de avaliação para todos os envios selecionados?';
$string['batchoperationconfirmunlock'] = 'Destravar todos os envios selecionados ?';
$string['batchoperationlock'] = 'Travar envios';
$string['batchoperationreverttodraft'] = 'Reverter envios para rascunho';
$string['batchoperationsdescription'] = 'Com selecionados...';
$string['batchoperationunlock'] = 'desbloquear envios';
$string['batchsetallocatedmarker'] = 'Definir avaliador alocado para {$a} usuário(s) selecionado(s).';
$string['batchsetmarkingworkflowstateforusers'] = 'Definir estado de fluxo de avaliação para {$a} usuário(s) selecionado(s).';
$string['blindmarking'] = 'Avaliação anônima';
$string['blindmarking_help'] = 'A avaliação anônima oculta a identidade dos alunos para os avaliadores. As configurações de avaliação anônima serão travadas assim que um envio ou uma avaliação seja feito nesta tarefa.';
$string['changegradewarning'] = 'Esta atribuição foi classificado inscrições e alterar a nota não será automaticamente re-calcular os graus de submissão existentes. Você deve reavaliar todas as propostas existentes, se você quiser alterar a nota.';
$string['choosegradingaction'] = 'Ação de avaliação';
$string['choosemarker'] = 'Escolha ...';
$string['chooseoperation'] = 'Escolha operação';
$string['comment'] = 'Comentário';
$string['completionsubmit'] = 'Aluno deverá apresentar a esta atividade para completá-la';
$string['configshowrecentsubmissions'] = 'Todos podem ver listas de novos envios no relatório de atividades recentes';
$string['confirmbatchgradingoperation'] = 'Você tem certeza que quer {$a->operation} para {$a->count} aluno(s)?';
$string['confirmsubmission'] = 'Tem certeza de que deseja enviar seu trabalho para a classificação? Você não será capaz de fazer mais modificações.';
$string['conversionexception'] = 'Não foi possível converter tarefa. O problema foi: {$a}';
$string['couldnotconvertgrade'] = 'Não foi possível converter a nota da tarefa para o usuário {$a}';
$string['couldnotconvertsubmission'] = 'Não foi possível converter o envio de tarefa para o usuário {$a}';
$string['couldnotcreatecoursemodule'] = 'Não foi possível criar o módulo do curso.';
$string['couldnotcreatenewassignmentinstance'] = 'Não foi possível criar uma nova instância de tarefa.';
$string['couldnotfindassignmenttoupgrade'] = 'Não foi possível encontrar a antiga instância para fazer a migração.';
$string['currentattempt'] = 'Esta é a tentativa  {$a} .';
$string['currentattemptof'] = 'Esta é a tentativa {$a->attemptnumber} ({$a->maxattempts} tentativas permitidas).';
$string['currentgrade'] = 'Nota atual no livro de notas';
$string['cutoffdate'] = 'Data limite';
$string['cutoffdatefromdatevalidation'] = 'Data de corte deve ser após a permitir inscrições de data.';
$string['cutoffdate_help'] = 'Se configurado, a tarefa não aceitará envios após a data escolhida sem prorrogação.';
$string['cutoffdatevalidation'] = 'A data limite não pode ser anterior à data de vencimento.';
$string['defaultsettings'] = 'Configuração padrão de tarefa';
$string['defaultsettings_help'] = 'Estas configurações definem os padrões para todas as novas tarefas.';
$string['defaultteam'] = 'Grupo padrão';
$string['deleteallsubmissions'] = 'Apagar todos os envios';
$string['description'] = 'Descrição';
$string['downloadall'] = 'Fazer o download de todas as tarefas enviadas';
$string['duedate'] = 'Data de entrega';
$string['duedate_help'] = 'Isso acontece quando a tarefa está encerrada. Se envios atrasados são permitidos, qualquer envio depois dessa dada é marcado como atrasado. Para impedir envios após uma determinada data - definir a data limite para envio da tarefa.';
$string['duedateno'] = 'Nenhuma data de entrega';
$string['duedatereached'] = 'A data de encerramento para essa tarefa já foi atingida';
$string['duedatevalidation'] = 'Data de encerramento precisa ser depois do início da tarefa.';
$string['editaction'] = 'Ações ...';
$string['editattemptfeedback'] = 'Edite a nota e feedback para a tentativa número {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Você está editando o feedback para uma tentativa anterior. Esta é a tentativa {$a->attemptnumber}  de {$a->totalattempts} permitidas.';
$string['editingstatus'] = 'Editar estado';
$string['editsubmission'] = 'Editar envio';
$string['editsubmission_help'] = 'Fazer alterações em seu envio';
$string['enabled'] = 'Habilitado';
$string['errornosubmissions'] = 'Não existem submissões para download.';
$string['errorquickgradingvsadvancedgrading'] = 'As avaliações não foram salvas pois esta tarefa está atualmente usando avaliação avançada';
$string['errorrecordmodified'] = 'As avaliações não foram salvas pois alguém modificou um ou mais registros após você ter carregado a página.';
$string['event_all_submissions_downloaded'] = 'Todos os envios estão sendo baixados.';
$string['event_assessable_submitted'] = 'Um envio foi submetido.';
$string['event_extension_granted'] = 'Uma prorrogação foi concedida.';
$string['event_identities_revealed'] = 'As identidades foram reveladas.';
$string['event_marker_updated'] = 'O avaliador alocado foi atualizado.';
$string['event_statement_accepted'] = 'O usuário aceitou o acordo da tarefa.';
$string['event_submission_duplicated'] = 'O usuário duplicou seu envio.';
$string['event_submission_graded'] = 'O envio foi avaliado.';
$string['event_submission_locked'] = 'Os envios foram travados para um usuário.';
$string['event_submission_status_updated'] = 'O status do seu envio foi atualizado';
$string['event_submission_unlocked'] = 'O envio foi destravado para um usuário.';
$string['event_submission_updated'] = 'O usuário salvou um envio.';
$string['event_workflow_state_updated'] = 'O stado do workflow foi atualizado.';
$string['extensionduedate'] = 'Extensão do prazo de entrega';
$string['extensionnotafterduedate'] = 'A data de extensão deve ser posterior à data de encerramento';
$string['extensionnotafterfromdate'] = 'A data extendida deve ser posterior à data de encerramento';
$string['feedback'] = 'Feedback';
$string['feedbackavailablehtml'] = '{$a->username} postou feedback em seu envio de tarefa para \'<i>{$a->assignment}</i>\' <br/><br/>
Você pode visualizar em seu <a href="{$a->url}">envio</a>.';
$string['feedbackavailablesmall'] = '{$a->username} retornou feedback para a tarefa {$a->assignment}';
$string['feedbackavailabletext'] = '{$a->username} postou feedback em seu envio de tarefa para \'<i>{$a->assignment}</i>\'


Você pode visualizar em seu envio:

{$a->url}';
$string['feedbackplugin'] = 'Plugin Feedback';
$string['feedbackpluginforgradebook'] = 'Plugin de feedback que publicará comentários no livro de notas';
$string['feedbackpluginforgradebook_help'] = 'Apenas um plugin de feedback para tarefa pode enviar feedback na grade de notas';
$string['feedbackplugins'] = 'Plugins de Feedback';
$string['feedbacksettings'] = 'Configurações de Feedback';
$string['feedbacktypes'] = 'Tipos de feedback';
$string['filesubmissions'] = 'Envio de arquivos';
$string['filter'] = 'Filtro';
$string['filternone'] = 'Sem filtro';
$string['filterrequiregrading'] = 'Requer notas';
$string['filtersubmitted'] = 'Enviada';
$string['gradeabovemaximum'] = 'Notas precisam ser menores ou iguais a {$a}.';
$string['gradebelowzero'] = 'Notas precisam ser maiores ou iguais a zero.';
$string['gradecanbechanged'] = 'Nota pode ser alterada';
$string['graded'] = 'Avaliado';
$string['gradedby'] = 'Avaliado por';
$string['gradedon'] = 'Avaliado em';
$string['gradelocked'] = 'Esta nota está bloqueada ou sobreposta no quadro de notas.';
$string['gradeoutof'] = 'Nota de um total de {$a}';
$string['gradeoutofhelp'] = 'Nota';
$string['gradeoutofhelp_help'] = 'Entre com a nota para o envio do aluno aqui. Você pode incluir decimas.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} atualizou a sua tarefa <i>\'{$a->assignment}\' em{$a->timeupdated} </i><br /><br />
Esta pode ser acessada <a href="{$a->url}">no site</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} alterou seu envio para tarefa {$a->assignment}';
$string['gradersubmissionupdatedtext'] = '{$a->username} atualizou a sua tarefa \'{$a->assignment}\' em {$a->timeupdated}

Para acessar a nova versão:

{$a->url}';
$string['gradestudent'] = 'Avaliar aluno: (id={$a->id}, fullname={$a->fullname}).';
$string['gradeuser'] = 'Nota {$a}';
$string['grading'] = 'Avaliação';
$string['gradingchangessaved'] = 'As mudanças de nota foram salvas';
$string['gradingmethodpreview'] = 'Critério de pontuação';
$string['gradingoptions'] = 'Opções';
$string['gradingstatus'] = 'Status da avaliação';
$string['gradingstudent'] = 'Avaliando aluno';
$string['gradingsummary'] = 'Sumário de avaliação';
$string['grantextension'] = 'Atribuir extensão';
$string['grantextensionforusers'] = 'Atribuir extensão para o usuário {$a}';
$string['groupsubmissionsettings'] = 'Configurações de envio em grupo';
$string['hiddenuser'] = 'Participante';
$string['hideshow'] = 'Ocultar/Mostrar';
$string['instructionfiles'] = 'Aquivos de instrução';
$string['invalidfloatforgrade'] = 'A nota inserida não pode ser compreendida: {$a}';
$string['invalidgradeforscale'] = 'A nota fornecida não é válida para a escala atual';
$string['lastmodifiedgrade'] = 'Última modificação (nota)';
$string['lastmodifiedsubmission'] = 'Última modificação (envio)';
$string['latesubmissions'] = 'Submissões atrasadas';
$string['latesubmissionsaccepted'] = 'Somente aluno(s) contemplados com uma extensão ainda pode enviar a tarefa';
$string['locksubmissionforstudent'] = 'Inpedir envio para o aluno: (id={$a->id}, fullname={$a->fullname}).';
$string['locksubmissions'] = 'Travar envios';
$string['manageassignfeedbackplugins'] = 'Gerenciar plugins de feedback de tarefa';
$string['manageassignsubmissionplugins'] = 'Gerenciar plugins de envio de tarefa';
$string['marker'] = 'Marcador';
$string['markerfilter'] = 'Filtro por marcador';
$string['markingallocation'] = 'Usar alocação de avaliação';
$string['markingallocation_help'] = 'Se habilitado, permite que avaliadores sejam alocados a alunos individuais - requer ativação do fluxo de avaliação.';
$string['markingworkflow'] = 'Usar fluxo de avaliação';
$string['markingworkflow_help'] = 'Se habilitado, avaliações estarão sujeitas a uma série de estágios antes de ficarem disponíveis aos usuários.';
$string['markingworkflowstate'] = 'Estado do fluxo de avaliação';
$string['markingworkflowstate_help'] = 'A lista de estados do fluxo de estados que você pode escolher são controladas por suas permissões em tarefas. A lista completa de estados validos é:<br><ul><li>Em avaliação - Os envios estão sendo avaliados</li></ul>...';
$string['markingworkflowstateinmarking'] = 'Em avaliação';
$string['markingworkflowstateinreview'] = 'Em revisão';
$string['markingworkflowstatenotmarked'] = 'Não avaliado';
$string['markingworkflowstatereadyforrelease'] = 'Pronto para liberação';
$string['markingworkflowstatereadyforreview'] = 'Avaliação concluída';
$string['markingworkflowstatereleased'] = 'Liberadas';
$string['maxattempts'] = 'Máximo de tentativas';
$string['maxattempts_help'] = 'O número máximo de tentativas de inscrições que podem ser feitas por um estudante. Depois de esgotado este número de tentativas de envio do estudante não poderá ser reaberto.';
$string['maxgrade'] = 'Nota máxima';
$string['messageprovider:assign_notification'] = 'Notificações de tarefa';
$string['modulename'] = 'Tarefa';
$string['modulename_help'] = 'O módulo de atividade permite a atribuição de um professor para comunicar tarefas, recolher o trabalho e fornecer notas e comentários.

Os alunos podem apresentar qualquer conteúdo digital (arquivos), como documentos de word-processados, planilhas, imagens ou áudio e videoclipes. Alternativamente, ou adicionalmente, a atribuição pode exigir dos estudantes a digitação do conteúdo diretamente no editor de texto. Uma tarefa também pode ser usada para lembrar aos alunos das atribuições \'mundo real\' que eles precisam para completar off-line, tais como obras de arte e, portanto, não necessita de qualquer conteúdo digital. Os estudantes podem submeter trabalhos, individualmente ou como membro de um grupo.

Ao analisar os trabalhos, os professores podem deixar comentários de feedback e fazer upload de arquivos, como marcar apresentações dos alunos, documentos com comentários ou feedback de áudio falado. Atribuições podem ser classificadas de acordo com uma escala numérica ou customizada ou um método de classificação avançada, como uma rubrica. Notas finais são registradas no diário de classe.';
$string['modulenameplural'] = 'Tarefas';
$string['moreusers'] = '{$a} mais...';
$string['mysubmission'] = 'Minha submissão :';
$string['newsubmissions'] = 'Tarefas apresentadas';
$string['noattempt'] = 'Nenhuma tentativa';
$string['nofiles'] = 'Não há arquivos';
$string['nograde'] = 'Não há nota';
$string['nolatesubmissions'] = 'Não são aceitas submissões atrasadas';
$string['nomoresubmissionsaccepted'] = 'Não são aceitas novas submissões';
$string['noonlinesubmissions'] = 'Esta tarefa não requer o envio online';
$string['nosavebutnext'] = 'Próximo';
$string['nosubmission'] = 'Nada foi enviado para esta tarefa';
$string['nosubmissionsacceptedafter'] = 'Nenhum envio aceito depois de';
$string['notgraded'] = 'Não há notas';
$string['notgradedyet'] = 'Ainda não avaliada';
$string['notifications'] = 'Notificações';
$string['notsubmittedyet'] = 'Ainda não apresentadas';
$string['nousersselected'] = 'Não foi selecionado usuário';
$string['numberofdraftsubmissions'] = 'Rascunhos';
$string['numberofparticipants'] = 'Participantes';
$string['numberofsubmissionsneedgrading'] = 'Precisa de avaliação';
$string['numberofsubmittedassignments'] = 'Enviado';
$string['numberofteams'] = 'Grupos';
$string['offline'] = 'Não há envios online solicitados';
$string['open'] = 'Aberto';
$string['outlinegrade'] = 'Nota: {$a}';
$string['outof'] = '{$a->current} de {$a->total}';
$string['overdue'] = '<font color="red">A tarefa está atrasada há: {$a}</font>';
$string['page-mod-assign-view'] = 'Página principal da tarefa';
$string['page-mod-assign-x'] = 'Qualquer página de tarefa';
$string['participant'] = 'Participante';
$string['pluginadministration'] = 'Administração de tarefas';
$string['pluginname'] = 'Tarefa';
$string['preventsubmissions'] = 'Impede o usuário de fazer outros envios para essa tarefa.';
$string['preventsubmissionsshort'] = 'Impedir modificações no envio';
$string['previous'] = 'Anterior';
$string['quickgrading'] = 'Avaliação rápida';
$string['quickgradingchangessaved'] = 'A nota alterada foi salva';
$string['quickgrading_help'] = 'A avaliação rápida permite atribuir notas (e resultados) diretamente na tabela de envios. A avaliação rápida não é compatível com avaliação avançada e não é recomendada quando há vários avaliadores.';
$string['quickgradingresult'] = 'Avaliação rápida';
$string['recordid'] = 'Identificador';
$string['requireallteammemberssubmit'] = 'Exigir que todos os membros do grupo enviem';
$string['requireallteammemberssubmit_help'] = 'Se habilitado, todos os membros do grupo devem clicar no botão de confirmação desta tarefa antes que ela seja considerada enviada. Se desabilitada, o envio do grupo será considerado enviado assim que qualquer membro do grupo clicar no botão de envio.';
$string['requiresubmissionstatement'] = 'Exigir aceite da declaração de não plágio ao enviar';
$string['requiresubmissionstatement_help'] = 'Exigir que os alunos aceitem a declaração indicando que o trabalho é seu (não plágio) em todos os envios desta tarefa.';
$string['revealidentities'] = 'Revelar identidades dos estudantes';
$string['revealidentitiesconfirm'] = 'Você tem certeza de que deseja revelar as identidades dos estudantes para esta tarefa? Esta operação não pode ser desfeita. Uma vez que as identidades dos estudantes foram reveladas, as notas serão liberadas para o livro de notas.';
$string['reverttodraft'] = 'Reverter para rascunho.';
$string['reverttodraftforstudent'] = 'Reverter envio para rascunho para o aluno: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Reverter o envio para rescunho';
$string['reviewed'] = 'Revisado';
$string['saveallquickgradingchanges'] = 'Salvar todas as alterações de avaliação rápida';
$string['savechanges'] = 'Salvar mudanças';
$string['savegradingresult'] = 'Nota';
$string['savenext'] = 'Salvar e exibir o próximo';
$string['scale'] = 'Escala';
$string['selectedusers'] = 'Usuários selecionados';
$string['selectlink'] = 'Selecionar ...';
$string['selectuser'] = 'Selecione {$a}';
$string['sendlatenotifications'] = 'Notificar avaliadores sobre submissões atrasadas';
$string['sendlatenotifications_help'] = 'Se habilitado, avaliadores (normalmente professores) recebem uma mensagem quando o aluno envia uma tarefa atrasada. Métodos de envio de mensagem são configuráveis.';
$string['sendnotifications'] = 'Notificar avaliador a respeito de novos envios';
$string['sendnotifications_help'] = 'Se habilitado, avaliadores (geralmente professores) recebem uma mensagem quando o aluno envia uma tarefa. Métodos de mensagem são configuráveis.';
$string['sendstudentnotifications'] = 'Notificar alunos';
$string['sendstudentnotifications_help'] = 'Se ativado, os alunos recebem uma mensagem sobre a nota atualizada ou feedback.';
$string['sendsubmissionreceipts'] = 'Enviar comprovante de entrega a estudantes';
$string['sendsubmissionreceipts_help'] = 'Esta opção habilita o envio de comprovantes para alunos. Alunos receberão uma notificação toda a vez que enviar com sucesso uma tarefa';
$string['setmarkerallocationforlog'] = 'Definir alocação de avaliação : (id={$a->id}, fullname={$a->fullname}, marker={$a->marker}).';
$string['setmarkingallocation'] = 'Definir avaliador alocado';
$string['setmarkingworkflowstate'] = 'Definir estado no fluxo de avaliação';
$string['setmarkingworkflowstateforlog'] = 'Definir estado no fluxo de avaliação :  (id={$a->id}, fullname={$a->fullname}, state={$a->state}).';
$string['settings'] = 'Configurações da tarefa';
$string['showrecentsubmissions'] = 'Mostrar envios recentes';
$string['status'] = 'Status';
$string['submission'] = 'Envio de tarefas';
$string['submissioncopiedhtml'] = 'Você fez uma cópia do seu envio anterior \'<i>{$a->assignment}</i>\'<br /><br />
Você pode ver o status do seu <a href="{$a->url}">envio</a>.';
$string['submissioncopiedsmall'] = 'abs';
$string['submissioncopiedtext'] = 'Você fez uma cópia do seu envio anterior para \'{$a->assignment}\'

Você pode ver o status de seu envio:
{$a->url}';
$string['submissiondrafts'] = 'Exigir que os alunos cliquem no botão enviar';
$string['submissiondrafts_help'] = 'Se habilitado, alunos terão que clicar no botão "Enviar" para declarar seu envio como final. Isto possibilita aos alunos manter uma versão de rascunho no sistema. Se esta configuração for alterada de "Não" para "Sim" depois que os estudantes já tiverem enviado suas tarefas, este envios serão considerados como finais.';
$string['submissioneditable'] = 'Estudantes podem editar essa submissão';
$string['submissionempty'] = 'Sem submissões';
$string['submissionnotcopiedinvalidstatus'] = 'O envio foi copiado pois foi editado após ser reaberto.';
$string['submissionnoteditable'] = 'Estudante não pode editar este envio';
$string['submissionnotready'] = 'Essa tarefa não está pronta para envios:';
$string['submissionplugins'] = 'Plugins de envio';
$string['submissionreceipthtml'] = 'Você enviou uma tarefa em <i>{$a->assignment}</i>\'<br /><br />
Você pode ver aqui o status da sua <a href="{$a->url}">tarefa enviada</a>.';
$string['submissionreceipts'] = 'Destinatário do envio de tarefas';
$string['submissionreceiptsmall'] = 'Você enviou sua tarefa para {$a->assignment}';
$string['submissionreceipttext'] = 'Você enviou uma tarefa para \'{$a->assignment}\'

Você pode ver o estado do seu envio:

  {$a->url}';
$string['submissions'] = 'Tarefas enviadas';
$string['submissionsclosed'] = 'Envios encerrados';
$string['submissionsettings'] = 'Configurações de envio';
$string['submissionslocked'] = 'A tarefa não está aceitando envios';
$string['submissionslockedshort'] = 'Alteração de envio não permitida';
$string['submissionsnotgraded'] = 'Envios não avaliados: {$a}';
$string['submissionstatement'] = 'Declaração de envio';
$string['submissionstatementacceptedlog'] = 'Declaração de envio aceita pelo usuário {$a}';
$string['submissionstatementdefault'] = 'Esta tarefa é meu próprio trabalho, exceto onde eu reconheço o uso do trabalho de outras pessoas.';
$string['submissionstatement_help'] = 'Confirmação da declaração do envio da tarefa';
$string['submissionstatus'] = 'Status de envio';
$string['submissionstatus_'] = 'Nenhum envio';
$string['submissionstatus_draft'] = 'Rascunho (não enviado)';
$string['submissionstatusheading'] = 'Status de envio';
$string['submissionstatus_marked'] = 'Avaliado';
$string['submissionstatus_new'] = 'Novo envio';
$string['submissionstatus_reopened'] = 'Reaberto';
$string['submissionstatus_submitted'] = 'Enviado para avaliação';
$string['submissionsummary'] = '{$a->status}. Última modificação em {$a->timemodified}';
$string['submissionteam'] = 'Grupo';
$string['submissiontypes'] = 'Tipos de envio';
$string['submitaction'] = 'Enviar';
$string['submitassignment'] = 'Enviar tarefa em definitivo';
$string['submitassignment_help'] = 'Uma vez que a tarefa for enviada você não poderá mais fazer alterações.';
$string['submitted'] = 'Enviada';
$string['submittedearly'] = 'A tarefa foi enviada {$a} adiantado';
$string['submittedlate'] = 'A tarefa foi enviada {$a} atrasada';
$string['submittedlateshort'] = '{$a} atrasado';
$string['subplugintype_assignfeedback'] = 'Plugin de Feedback';
$string['subplugintype_assignfeedback_plural'] = 'Plugins de Feedback';
$string['subplugintype_assignsubmission'] = 'Plugin de submissão';
$string['subplugintype_assignsubmission_plural'] = 'Plugins de submissão';
$string['teamsubmission'] = 'Envio em grupos de estudantes';
$string['teamsubmissiongroupingid'] = 'Agrupamento para grupos de estudantes';
$string['teamsubmissiongroupingid_help'] = 'Este é o grupo que a atribuição irá usar para encontrar grupos para grupos de estudantes. Se não definido - o conjunto padrão de grupos será usado.';
$string['teamsubmission_help'] = 'Se habilitado, os estudantes serão divididos em grupos com base no conjunto padrão de grupos ou de um agrupamento personalizado. A apresentação do grupo será compartilhada entre os membros do grupo e de todos os membros do grupo vão ver cada outras mudanças para a apresentação.';
$string['teamsubmissionstatus'] = 'Estado do envio do grupo';
$string['textinstructions'] = 'Instruções da tarefa';
$string['timemodified'] = 'Última modificação';
$string['timeremaining'] = 'Tempo restante';
$string['unlimitedattempts'] = 'Ilimitado';
$string['unlimitedattemptsallowed'] = 'Tentativas Ilimitadas permitidas.';
$string['unlocksubmissionforstudent'] = 'Permitir envio para o aluno: (id={$a->id}, fullname={$a->fullname}).';
$string['unlocksubmissions'] = 'Desbloquear envios';
$string['updategrade'] = 'Atualizar nota';
$string['updatetable'] = 'Salvar e atualizar tabela';
$string['upgradenotimplemented'] = 'Atualização não implementada no plugin ({$a->type} {$a->subtype})';
$string['userextensiondate'] = 'Prorrogação concedida até: {$a}';
$string['usergrade'] = 'Nota do usuário';
$string['userswhoneedtosubmit'] = 'Usuários que precisam enviar: {$a}';
$string['validmarkingworkflowstates'] = 'Estados de fluxo de avaliação válidos';
$string['viewbatchmarkingallocation'] = 'Ver página de alocação de avaliação em lote.';
$string['viewbatchsetmarkingworkflowstate'] = 'Ver página de alteração em lote do estado do fluxo de avaliação.';
$string['viewfeedback'] = 'Ver  avaliação e feedback';
$string['viewfeedbackforuser'] = 'Ver feedback para o usuário {$a}';
$string['viewfull'] = 'Ver completo';
$string['viewfullgradingpage'] = 'Abrir a página de avaliação completa para enviar feedback';
$string['viewgradebook'] = 'Ver livro de notas';
$string['viewgrading'] = 'Ver/Avaliar todos os envios';
$string['viewgradingformforstudent'] = 'Ver página de avaliação para o aluno: (id={$a->id}, fullname={$a->fullname}).';
$string['viewownsubmissionform'] = 'Ver própria página de envio de tarefa.';
$string['viewownsubmissionstatus'] = 'Ver própria página de status de envio.';
$string['viewrevealidentitiesconfirm'] = 'Ver identidade do estudante na página de confirmação';
$string['viewsubmission'] = 'Ver envio';
$string['viewsubmissionforuser'] = 'Ver envio para usuário: {$a}';
$string['viewsubmissiongradingtable'] = 'Ver tabela de avaliação de tarefas.';
$string['viewsummary'] = 'Ver resumo';
$string['workflowfilter'] = 'Filtro de fluxo de avaliação';
