<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'question', language 'pl', branch 'MOODLE_26_STABLE'
 *
 * @package   question
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Akcja';
$string['addanotherhint'] = 'Dodaj kolejną podpowiedź';
$string['addcategory'] = 'Dodaj kategorię';
$string['addmorechoiceblanks'] = 'Pola na {no} więcej odpowiedzi';
$string['adminreport'] = 'Raportuj o możliwych problemach w twojej bazie pytań.';
$string['answer'] = 'Odpowiedź';
$string['answers'] = 'Odpowiedzi';
$string['answersaved'] = 'Odpowiedź zapisana';
$string['attemptfinished'] = 'Próba zakończona';
$string['attemptfinishedsubmitting'] = 'Próba zakończona przesłaniem:';
$string['attemptoptions'] = 'Opcje próby';
$string['availableq'] = 'Dostępny?';
$string['badbase'] = 'Niewłaściwa podstawa potęgi przed **: {$a}**';
$string['behaviour'] = 'Tryb';
$string['behaviourbeingused'] = 'zachowanie użyte: {$a}';
$string['broken'] = 'To jest nieprawidłowe łącze, wskazuje na nieistniejący plik.';
$string['byandon'] = 'przez <em>{$a->user}</em> o <em>{$a->time}</em>';
$string['cannotcopybackup'] = 'Nie można skopiować pliku kopii zapasowej';
$string['cannotcreate'] = 'Nie można utworzyć nowego wpisu w tabeli question_attempts';
$string['cannotcreatepath'] = 'Nie udało się utworzyć ścieżki: {$a}';
$string['cannotdeletebehaviourinuse'] = 'Nie można usunąć trybu \'{$a} &quot;. Jest on używany w pytaniach.';
$string['cannotdeletecate'] = 'Nie można usunąć tej kategorii. Jest to kategoria domyślna dla tego kontekstu.';
$string['cannotdeleteneededbehaviour'] = 'Nie można usunąć trybu &quot;{$a}&quot;. Istnieją inne tryby, które od niego zależą.';
$string['cannotdeleteqtypeinuse'] = 'Nie można usunąć pytania typu \'{$a}\'. W bazie pytań znajdują się pytania tego typu.';
$string['cannotdeleteqtypeneeded'] = 'Nie można usunąć pytanie typu \'{$a}\'. Istnieją inne rodzaje zainstalowanych pytań, które są od niego zależne.';
$string['cannotenable'] = 'Nie można bezpośrednio utworzyć pytania typu: {$a}.';
$string['cannotenablebehaviour'] = 'Tryb {$a} nie może być stosowany bezpośrednio. Jest tylko do użytku wewnętrznego.';
$string['cannotfindcate'] = 'Nie można odnaleźć rekordu kategorii';
$string['cannotfindquestionfile'] = 'Nie można znaleźć danych pytania w pliku zip';
$string['cannotgetdsfordependent'] = 'Nie można pobrać określonego zestawu danych niezbędnego w pytaniu! (Pytanie: {$a->id}, zestaw danych: {$a->item})';
$string['cannotgetdsforquestion'] = 'Nie można pobrać zestawu danych dla pytania obliczeniowego! (Pytanie: {$a})';
$string['cannothidequestion'] = 'Nie był w stanie ukryć pytania';
$string['cannotimportformat'] = 'Przepraszamy, nie zaimplementowano jeszcze możliwości importu tego formatu!';
$string['cannotinsertquestion'] = 'Nie można wstawić nowego pytania!';
$string['cannotinsertquestioncatecontext'] = 'Nie można wstawić nowej kategorii {$a->cat}. Niedozwolony kontekst {$a->ctx}';
$string['cannotloadquestion'] = 'Nie można załadować pytania';
$string['cannotmovequestion'] = 'Nie można użyć tego skryptu, aby przenosić pytania, które są związane z plikami z różnych obszarów.';
$string['cannotopenforwriting'] = 'Nie można otworzyć do zapisu: {$a}';
$string['cannotpreview'] = 'Nie można wyświetlić podglądu tego pytania!';
$string['cannotread'] = 'Nie można odczytać pliku do importu (lub plik jest pusty)';
$string['cannotretrieveqcat'] = 'Nie można pobrać kategorii pytania';
$string['cannotunhidequestion'] = 'Nie udało się odkryć pytania.';
$string['cannotunzip'] = 'Nie można rozpakować pliku.';
$string['cannotwriteto'] = 'Nie można zapisać wyeksportowanych pytań do {$a}';
$string['category'] = 'Kategoria';
$string['categorycurrent'] = 'Bieżąca kategoria';
$string['categorycurrentuse'] = 'Użyj tej kategorii';
$string['categorydoesnotexist'] = 'Ta kategoria nie istnieje';
$string['categoryinfo'] = 'Informacje na temat kategorii';
$string['categorymove'] = 'Kategoria \'{$a->name}\' zawiera {$a->count} pytań. Wybierz kategorię, do której mają one zostać przeniesione';
$string['categorymoveto'] = 'Zapisz w kategorii';
$string['categorynamecantbeblank'] = 'Nazwa kategorii nie może być pusta.';
$string['changeoptions'] = 'Zmiana opcji';
$string['changepublishstatuscat'] = 'Status współdzielenia <a href="{$a->caturl}">Kategorii "{$a->name}"</a> z kursu "{$a->coursename}" zostanie zmieniony z <strong>{$a->changefrom} na {$a->changeto}</strong>.';
$string['check'] = 'Sprawdź';
$string['chooseqtypetoadd'] = 'Wybierz rodzaj nowego pytania';
$string['clearwrongparts'] = 'Wyczyść nieprawidłowe odpowiedzi';
$string['clickflag'] = 'Oflaguj pytanie';
$string['clicktoflag'] = 'Zaznacz to pytanie flagą';
$string['clicktounflag'] = 'Usuń flagę';
$string['clickunflag'] = 'Usuń flagę';
$string['closepreview'] = 'Zamknij podgląd';
$string['combinedfeedback'] = 'Złożona informacja zwrotna';
$string['comment'] = 'Komentarz';
$string['commented'] = 'Skomentował: {$a}';
$string['commentormark'] = 'Utwórz komentarz lub zastąp punktację';
$string['comments'] = 'Komentarze';
$string['commentx'] = 'Komentarz: {$a}';
$string['complete'] = 'Zakończone';
$string['contexterror'] = 'Nie powinieneś się tu znaleźć, chyba że przenosisz kategorię do innego kontekstu.';
$string['copy'] = 'Skopiuj z {$a} i zmień łącza';
$string['correct'] = 'Poprawnie';
$string['correctfeedback'] = 'Dla każdej poprawnej odpowiedzi';
$string['correctfeedbackdefault'] = 'Twoja odpowiedź jest poprawna.';
$string['created'] = 'Utworzony';
$string['createdby'] = 'Utworzony przez';
$string['createdmodifiedheader'] = 'Utworzony / ostatnio zapisany';
$string['createnewquestion'] = 'Utwórz nowe pytanie ...';
$string['cwrqpfs'] = 'Losowe pytania wybierające pytania z podkategorii.';
$string['cwrqpfsinfo'] = 'Podczas aktualizacji do Moodle 1.9 podzielimy kategorie pytań na różne konteksty. Status współdzielenia niektórych kategorii i pytań będzie musiał zostać zmieniony. Jest to konieczne w rzadkim przypadku, kiedy jedno lub więcej \'losowych\' pytań wybiera pytania z mieszanki kategorii współdzielonych i niewspółdzielonych (tak jak w przypadku tej strony). Zdarza się tak, kiedy \'losowe\' pytanie wybiera pytania z podkategorii i jedna lub więcej podkategorii ma status współdzielenia różny od kategorii nadrzędnej, w której zawiera się pytanie losowe.</p>
<p>Podczas aktualizacji do Moodle 1.9 status współdzielenia poniższych kategorii pytań (z których \'losowe\' pytania kategorii nadrzędnej wybierają pytania) zostanie zmieniony na taki, jaki jest status kategorii zawierającej pytanie losowe. Poniższe kategorie będą miały zmieniony status współdzielenia. Wszystkie pytania we wszystkich quizach będą nadal działać (dopóki ich nie usuniesz).</p>';
$string['cwrqpfsnoprob'] = 'Problem "losowych pytań wybierających pytania z podkategorii" nie dotyczy żadnego z istniejących pytań.';
$string['decimalplacesingrades'] = 'Miejsca dziesiętne w ocenach';
$string['defaultfor'] = 'Domyślnie dla {$a}';
$string['defaultinfofor'] = 'Domyślna kategoria dla pytań współdzielonych w kontekście \'{$a}\'.';
$string['defaultmark'] = 'Domyślna punktacja';
$string['defaultmarkmustbepositive'] = 'Domyślna ocena musi być pozytywna,';
$string['deletecoursecategorywithquestions'] = 'Istnieją pytania w tej kategorii w banku pytań. Jeśli będziesz kontynuować, zostaną one usunięte. Może lepiej przenieść je najpierw za pomocą interfejsu bazy pytań.';
$string['deletequestioncheck'] = 'Czy na pewno chcesz usunąć \'{$a}\'?';
$string['deletequestionscheck'] = 'Czy na pewno chcesz usunąć następujące pytania? <br /> <br />{$a}';
$string['deletingbehaviour'] = 'Usuwanie trybu \'{$a}\'';
$string['deletingqtype'] = 'Usuwanie pytania typu: \'{$a}\'';
$string['didnotmatchanyanswer'] = '[Nie pasuje to żadnej odpowiedzi]';
$string['disabled'] = 'Wyłączone';
$string['displayoptions'] = 'Opcje wyświetlania';
$string['disterror'] = 'Dystrybucja {$a} spowodowała problemy';
$string['donothing'] = 'Nie kopiuj, nie przenoś plików ani nie zmieniaj łączy.';
$string['editcategories'] = 'Edytuj kategorie';
$string['editcategories_help'] = 'Pytania mogą być zorganizowane w kategorie i podkategorie, zamiast trzymać je wszystkie na jednej, wielkiej liście. Każda kategoria ma kontekst, w którym pytania mogą być używane:
* kontekst aktywności - Pytania dostępne tylko w module aktywności (quizie)
* kontekst kursu - Pytania dostępne we wszystkich elementach kursu
* kontekst kategorii kursu - Pytania dostępne we wszystkich modułach i kursach w kategorii
* kontekst systemu - Pytania dostępne we wszystkich kursach i modułach w witrynie
Kategorie maja związek z  pytaniami losowymi, bo pytania losowe są wybierane właśnie z określonej kategorii.';
$string['editcategory'] = 'Edytuj kategorię';
$string['editingcategory'] = 'Edycja kategorii';
$string['editingquestion'] = 'Edycja pytania';
$string['editquestion'] = 'Edytuj pytanie';
$string['editquestions'] = 'Edytuj pytania';
$string['editthiscategory'] = 'Edytuj tą kategorię';
$string['emptyxml'] = 'Nieznany błąd - pusty imsmanifest.xml';
$string['enabled'] = 'Włączony';
$string['erroraccessingcontext'] = 'Nie można uzyskać dostępu do kontekstu';
$string['errordeletingquestionsfromcategory'] = 'Błąd podczas usuwania pytań z kategorii {$a}.';
$string['errorduringpost'] = 'Wystąpił błąd podczas post-processingu!';
$string['errorduringpre'] = 'Wystąpił błąd podczas post-processingu!';
$string['errorduringproc'] = 'Wystąpił błąd podczas przetwarzania!';
$string['errorduringregrade'] = 'Nie można przeliczyć oceny pytania {$a->qid}. Ustawiam stan {$a->stateid}.';
$string['errorfilecannotbecopied'] = 'Błąd podczas kopiowania pliku {$a}.';
$string['errorfilecannotbemoved'] = 'Błąd podczas przenoszenia pliku {$a}.';
$string['errorfileschanged'] = 'Błąd: pliki związane z pytaniami zostały zmienione w czasie, gdy  formatka jest wyświetlona.';
$string['errormanualgradeoutofrange'] = 'Ocena {$a->grade} pytania {$a->name} nie mieści się w przedziale od  0 do {$a->maxgrade}. Ocena i komentarz nie zostały zapisane.';
$string['errormovingquestions'] = 'Błąd podczas przesuwania pytań z identyfikatorami {$a}.';
$string['errorpostprocess'] = 'Wystąpił błąd podczas przetwarzania końcowego!';
$string['errorpreprocess'] = 'Wystąpił błąd podczas przetwarzania wstępnego!';
$string['errorprocess'] = 'Wystąpił błąd podczas przetwarzania!';
$string['errorprocessingresponses'] = 'Wystąpił błąd podczas przetwarzania twojej odpowiedzi ({$a}). Kliknij przycisk Kontynuuj, aby powrócić do poprzedniej strony i spróbuj ponownie.';
$string['errorsavingcomment'] = 'Błąd podczas zapisywania komentarza dla pytania {$a->name} w bazie danych.';
$string['errorsavingflags'] = 'Błąd podczas zapisywania stanu flagi.';
$string['errorupdatingattempt'] = 'Błąd podczas aktualizacji {$a->id}. podejścia w bazie danych.';
$string['exportcategory'] = 'Eksportuj kategorię';
$string['exportcategory_help'] = 'Kategoria, z której eksportowane będą pytania.
Niektóre formaty importu, takie jak GIFT i Moodle XML, zapisują również kategorię i kontekst w pliku eksportu, dzięki czemu mogą być one (opcjonalnie) odtworzone podczas importu. Jeśli tego chcemy, odpowiednie pola wyboru powinny być zaznaczone.';
$string['exporterror'] = 'Wystąpiły błędy podczas eksportu!';
$string['exportfilename'] = 'pytania';
$string['exportnameformat'] = '%Y%m%d-%H%M';
$string['exportquestions'] = 'Eksportuj pytania do pliku';
$string['exportquestions_help'] = '<P ALIGN=CENTER><B>Eksportowanie pytań danej kategorii</B></P>

<P>Ta funkcja eksportuje całą kategorię do pliku tekstowego.

<p>Zwracamy uwagę na to, że wiele formatów nie obsługuje wszystkich
informacji o pytaniach i te informacje zostaną utracone. Nie należy
się spodziewać, że wyeksportowanie kategorii i późniejsze zaimportowanie
da zestaw takich samych pytań. Ponadto niektóre typy pytań mogą się zupełnie nie wyeksportować, jeśli nie są obsługiwane w danym formacie.</p>

<P>Obecnie wspierane formaty to:</p>

<P><B>Format GIFT</B></P>
<ul>
<p>Format GIFT jest najbardziej wszechstronnym formatem. Został zaprojektowany jako prosta metoda dla nauczycieli tworzacych pytania jako plik tekstowy. GIFT obsługuje pytania Wielokrotnego wyboru, Prawda-Fałsz, Krótkie odpowiedzi, Dopasuj odpowiedź, Numeryczne jak i zadania typu "wstaw brakujące słowo".</p>

<p>Kilka typów pytań może być użyytych w jednym pliku tekstowym. Ponadto format ten zezwala na umieszczanie komentarzy, nazw pytań, informacji zwrotnych i ważenie ocen. </p>

<p>Oto kilka przykładów:</p>

<pre>
CzasNaE-Biznes to?{~codzienna gazeta ~książka =serwis www i e-zin}

CzasNaE-Biznes to {~codzienna gazeta ~książka =serwis www} o marketingu i biznesie.

CzasNaE-Biznes to codzienna gazeta.{FALSE}

CzasNaE-Biznes to?{=serwis www =e-zin}

Kiedy powstał CzasNaE-Biznes?{#2000}
</pre>

<p align=right><a href="help.php?file=formatgift.html&module=quiz">Więcej o formacie GIFT</a></p>
</ul>

<P>Tworzymy już nowe formaty: WebCT, IMS QTI i cokolwiek jeszcze zapragną członkowie społeczności Moodle! </p>';
$string['feedback'] = 'Informacja zwrotna';
$string['filecantmovefrom'] = 'Pliki pytań nie mogą być przeniesione, ponieważ nie masz uprawnień do usuwania plików z miejsca, skąd próbujesz je przenieść.';
$string['filecantmoveto'] = 'Pliki nie mogą być przeniesione lub skopiowane, ponieważ nie masz uprawnień do dodawania plików w miejscu, dokąd próbujesz się przenieść.';
$string['fileformat'] = 'Format pliku';
$string['filesareacourse'] = 'Obszar plików kursu';
$string['filesareasite'] = 'Obszar plików witryny';
$string['filestomove'] = 'Przenieść / skopiować pliki do {$a}?';
$string['fillincorrect'] = 'Wypełnij poprawnymi odpowiedziami';
$string['flagged'] = 'Zaznaczone flagą';
$string['flagthisquestion'] = 'Oflaguj to pytanie';
$string['formquestionnotinids'] = 'Formularz zawierał pytanie, któredo nie ma w questionids';
$string['fractionsnomax'] = 'Jedna z odpowiedzi powinna być warta 100%, aby można było otrzymać całą ocenę za to pytanie.';
$string['generalfeedback'] = 'Ogólna informacja zwrotna';
$string['generalfeedback_help'] = 'Ogólna informacja zwrotna jest wyświetlana dla studenta, gdy odpowiedział już na pytanie. W przeciwieństwie do Informacji zwrotnej, która zależy od typu pytania i udzielonej odpowiedzi , ta sama Ogólna informacja zwrotna jest wyświetlana wszystkim studentom.
Możesz użyć Ogólnej informacji zwrotnej, aby dać studentom wskazówkę, jakiej dziedziny dotyczyło pytanie, lub dać im link do dodatkowych informacji, które mogą wykorzystać, jeśli nie zrozumieli pytania.';
$string['getcategoryfromfile'] = 'Pobierz kategorię z pliku';
$string['getcontextfromfile'] = 'Pobierz kontekst z pliku';
$string['hidden'] = 'Ukryty';
$string['hintn'] = 'Wskazówka {no}';
$string['hintnoptions'] = 'Opcje wskazówki {no}';
$string['hinttext'] = 'Tekst wskazówki';
$string['howquestionsbehave'] = 'Jak zachowują się pytania';
$string['howquestionsbehave_help'] = 'Studenci mogą korzystać z pytań w quizie w wielu trybach. Na przykład studenci będą  wpisywać odpowiedzi na wszystkie pytania, a następnie zatwierdzać cały quiz, zanim  dostaną ocenę czy komentarz. To będzie "Opóźniona informacja zwrotna.
Z kolei można spowodować, że od razu po odpowiedzi student otrzymuje punktację, a w przypadku pomyłki ma szansę skorygować odpowiedź, z tym że otrzyma mniej punktów za powtórkę. Ten tryb nazywa się "Interaktywny z powtórzeniami".';
$string['ignorebroken'] = 'Ignoruj niedziałające łącza';
$string['importcategory'] = 'Import do kategorii';
$string['importcategory_help'] = 'Kategoria, w której pojawią się importowane pytania.
Niektóre formaty importu, takie jak GIFT i Moodle XML, zapisują również kategorię i kontekst w pliku. Aby skorzystać z tych danych, a nie z wybranej tu kategorii, należy zaznaczyć odpowiednie pola wyboru. Jeśli kategorie określone w pliku importu nie istnieją, zostaną one stworzone.';
$string['importerror'] = 'Wystąpił błąd podczas przetwarzania importu';
$string['importerrorquestion'] = 'Błąd podczas importowania pytania';
$string['importfromcoursefiles'] = '... lub wybierz plik kursu do zaimportowania.';
$string['importfromupload'] = 'Wybierz plik do przesłania ...';
$string['importingquestions'] = 'Importowanie {$a} pytań z pliku';
$string['importparseerror'] = 'Stwierdzono błąd podczas analizowania pliku importu. Żadne pytania nie zostały zaimportowane.  Aby zaimportować te pytania, które są prawidłowe, spróbuj ponownie, ustawiwszy "Zatrzymaj na błędzie" na "Nie"';
$string['importquestions'] = 'Importuj pytania z pliku';
$string['importquestions_help'] = 'Funkcja ta pozwala na importowanie pytań z różnych formatów plików tekstowych. Zauważ, że należy używać kodowania UTF-8.';
$string['importwrongfiletype'] = 'Typ wybranego pliku ({$a->actualtype}) nie jest typem oczekiwanym przez ten format importu ({$a->expectedtype})';
$string['impossiblechar'] = 'Niepoprawny znak {$a} wykryty w roli  nawiasu';
$string['includesubcategories'] = 'Pokaż także pytania z podkategorii';
$string['incorrect'] = 'Niepoprawny(a)';
$string['incorrectfeedback'] = 'Dla każdej niepoprawnej odpowiedzi';
$string['incorrectfeedbackdefault'] = 'Twoja odpowiedź jest niepoprawna.';
$string['information'] = 'Informacja';
$string['invalidanswer'] = 'Niekompletna odpowiedź';
$string['invalidarg'] = 'Nie dostarczono prawidłowych argumentów lub nieprawidłowa konfiguracja serwera';
$string['invalidcategoryidforparent'] = 'Nieprawidłowy identyfikator kategorii nadrzędnej!';
$string['invalidcategoryidtomove'] = 'Nieprawidłowy identyfikator przenoszonej kategorii!';
$string['invalidconfirm'] = 'Ciąg potwierdzający był nieprawidłowy';
$string['invalidcontextinhasanyquestions'] = 'Nieprawidłowy kontekst przekazany do question_context_has_any_questions';
$string['invalidgrade'] = 'Oceny ({$a}) nie pasują do opcji ocen - pominięto pytanie.';
$string['invalidpenalty'] = 'Niewłaściwa kara';
$string['invalidwizardpage'] = 'Nieprawidłowa lub nieokreślona strona kreatora!';
$string['lastmodifiedby'] = 'Ostatnio zmieniony przez';
$string['linkedfiledoesntexist'] = 'Powiązany plik {$a} nie istnieje';
$string['makechildof'] = 'Utwórz potomka dla \'{$a}\'';
$string['makecopy'] = 'Utwórz kopię';
$string['maketoplevelitem'] = 'Przesuń na poziom nadrzędny';
$string['manualgradeoutofrange'] = 'Ocena jest poza dozwolonym zakresem';
$string['manuallygraded'] = 'Ręcznie ocenione na {$a->mark} z komentarzem: {$a->comment}';
$string['mark'] = 'Ocena';
$string['markedoutof'] = 'Punkty';
$string['markedoutofmax'] = 'Punkty: {$a}';
$string['markoutofmax'] = 'Oceniono na {$a->mark} z {$a->max}';
$string['marks'] = 'Punkty';
$string['matchgrades'] = 'Pasujący stopień';
$string['matchgradeserror'] = 'Błąd, ocena spoza listy';
$string['matchgrades_help'] = 'Importowane oceny muszą być zgodne z ustaloną listą poprawnych ocen: 100, 90, 80, 75, 70, 66,666, 60, 50, 40, 33,333, 30, 25, 20, 16,666, 14,2857, 12,5, 11,111, 10, 5 , 0 (również wartości ujemne). Jeśli nie, to są dwie opcje:
* błąd, ocena spoza listy - Jeżeli pytanie zawiera ocenę, które nie występuje na liście, wyświetlany jest błąd i pytanie to nie zostanie zaimportowane
* zaokrąglij do najbliższej - Jeśli ocena nie pasuje do wartości na liście, jest ona zaokrąglana do najbliższej pasującej wartości na liście';
$string['matchgradesnearest'] = 'Zaokrąglij do najbliższej';
$string['missingcourseorcmid'] = 'print_question wymaga courseid lub cmid .';
$string['missingcourseorcmidtolink'] = 'get_question_edit_link wymaga courseid lub cmid .';
$string['missingimportantcode'] = 'W pytaniu brakuje istotnego kodu: {$a}.';
$string['missingoption'] = 'W pytaniu Cloze {$a} brakuje opcji';
$string['modified'] = 'Ostatnio zapisano';
$string['move'] = 'Przenieś z {$a} i zmień łącza';
$string['movecategory'] = 'Przenieś kategorię';
$string['movedquestionsandcategories'] = 'Przeniesione pytania i kategorie pytań z {$a->oldplace} do {$a->newplace}.';
$string['movelinksonly'] = 'Tylko zmień adres docelowy łączy, nie przesuwaj ani nie kopiuj plików.';
$string['moveq'] = 'Przesuń pytanie(a)';
$string['moveqtoanothercontext'] = 'Przesuń pytanie do innego kontekstu';
$string['moveto'] = 'Przenieś do >>';
$string['movingcategory'] = 'Przenoszenie kategorii';
$string['movingcategoryandfiles'] = 'Czy jesteś pewien, że chcesz przenieść kategorię {$a->name} ze wszystkimi podkategoriami do kontekstu "{$a->contextto}"?<br /> {$a->urlcount} plików jest powiązanych z pytaniami w {$a->fromareaname}. Czy chcesz skopiować lub przesunąć te pliki do {$a->toareaname}?';
$string['movingcategorynofiles'] = 'Czy jesteś pewien, że chcesz przesunąć kategorię "{$a->name}" wraz ze wszystkimi podkategoriami do kontekstu "{$a->contextto}"?';
$string['movingquestions'] = 'Przenoszenie pytań i plików';
$string['movingquestionsandfiles'] = 'Czy jesteś pewien, że chcesz przenieść pytanie(a) {$a->questions} do kontekstu <strong>"{$a->tocontext}"</strong>?<br /> <strong>{$a->urlcount} plików</strong> jest powiązanych z tym(i) pytaniem(ami) w {$a->fromareaname}. Czy chcesz skopiować lub przesunąć te pliki do {$a->toareaname}?';
$string['movingquestionsnofiles'] = 'Czy jesteś pewien, że chcesz przenieść pytanie(a) {$a->questions} do kontekstu <strong>"{$a->tocontext}"</strong>?<br /> <strong>Nie ma plików</strong> powiązanych z tymi pytaniami w {$a->fromareaname}.';
$string['needtochoosecat'] = 'Wybierz kategorię, do której przesunąć to pytanie lub wciśnij \'Anuluj\'.';
$string['nocate'] = 'Nie ma takiej kategorii: {$a}';
$string['nopermissionadd'] = 'Nie masz uprawnień do dodawania tutaj pytań.';
$string['nopermissionmove'] = 'Nie masz uprawnień do przeniesienia pytania tutaj. Musisz zapisać pytanie w tej kategorii lub zapisać je jako nowe pytanie.';
$string['noprobs'] = 'Nie wykryto błędów w bazie danych zapytań.';
$string['noquestions'] = 'Brak pytań do eksportowania. Upewnij się, że wybrano kategorię, który zawiera pytania.';
$string['noquestionsinfile'] = 'Nie ma pytań w importowanym pliku';
$string['noresponse'] = '[Brak odpowiedzi]';
$string['notanswered'] = 'Nie udzielono odpowiedzi';
$string['notchanged'] = 'Nie zmienione od ostatniego podejścia';
$string['notenoughanswers'] = 'Ten typ pytania wymaga co najmniej {$a} odpowiedzi';
$string['notenoughdatatoeditaquestion'] = 'Ani ID pytania ani ID kategorii i typ pytania nie zostały określone.';
$string['notenoughdatatomovequestions'] = 'Podaj id pytań, które chcesz przesunąć.';
$string['notflagged'] = 'Nie oznaczony flagą';
$string['notgraded'] = 'Nie oceniono';
$string['notshown'] = 'Nie pokazano';
$string['notyetanswered'] = 'Nie udzielono odpowiedzi';
$string['notyourpreview'] = 'Ten podgląd nie należy do ciebie';
$string['novirtualquestiontype'] = 'Brak wirtualnego typu pytania dla typu pytania {$a}';
$string['numqas'] = 'Liczba podejść do pytania';
$string['numquestions'] = 'Liczba pytań';
$string['numquestionsandhidden'] = '{$a->numquestions} (+{$a->numhidden} ukrytych)';
$string['options'] = 'Opcje';
$string['orphanedquestionscategory'] = 'Pytania z usuniętych kategorii';
$string['orphanedquestionscategoryinfo'] = 'Sporadycznie, zazwyczaj ze względu na stare błędy oprogramowania, pytania mogą pozostać w bazie danych, pomimo że ich kategoria została usunięta. Oczywiście, to nie powinno się zdarzyć, ale się zdarzyło w przeszłości. Ta kategoria została stworzona automatycznie na takie pytania, aby można było nimi zarządzać. Należy pamiętać, że wszystkie zdjęcia i pliki multimedialne użyte przez te pytania prawdopodobnie zostały utracone.';
$string['page-question-category'] = 'Strona kategorii pytań';
$string['page-question-edit'] = 'Strona edycji pytania';
$string['page-question-export'] = 'Strona eksportu pytań';
$string['page-question-import'] = 'Strona importu pytań';
$string['page-question-x'] = 'Dowolna strona pytania';
$string['parent'] = 'Nadrzędny';
$string['parentcategory'] = 'Kategoria nadrzędna';
$string['parentcategory_help'] = 'Kategoria nadrzędna to ta, w której  zostanie umieszczona nowa kategoria. "Top" oznacza, że ta kategoria nie jest zawarta w żadnej innej. Konteksty Konteksty kategorii są wyświetlane pogrubioną czcionką. Musi być co najmniej jedna kategoria (Default) w każdym kontekście.';
$string['parenthesisinproperclose'] = 'Nawias przed ** nie jest prawidłowo zamknięty w {$a}**';
$string['parenthesisinproperstart'] = 'Nawias przed ** nie jest prawidłowo otwarty w {$a}**';
$string['parsingquestions'] = 'Wczytywanie pytań z pliku importu.';
$string['partiallycorrect'] = 'Częściowo poprawnie';
$string['partiallycorrectfeedback'] = 'Dla każdej częściowo poprawnej odpowiedzi';
$string['partiallycorrectfeedbackdefault'] = 'Twoja odpowiedź jest częściowo poprawna.';
$string['penaltyfactor'] = 'Mnożnik kary';
$string['penaltyfactor_help'] = '<p>Możesz określić ile ma zostać odjęte za każdym razem od nieprawidłowej odpowiedzi. To działa tylko gdy quiz jest w trybie adaptacyjnym w którym student może wielekrotnie odpowiadać na pytanie. Współczynnik kary może być liczbą od 0 do 1. Współczynnik kary równy 1 oznacza że student musi udzielić poprawnej odpowiedzi za 1 razem. Współczynnik kary równy 0 oznacza ze student może próbować odpowiadać dowolną liczbę razy i wciąż dostanie maksymalną ilość punktów za pytanie. </p>';
$string['penaltyforeachincorrecttry'] = 'Kara dla każdej błędnej próby';
$string['penaltyforeachincorrecttry_help'] = 'Po uruchomieniu na pytania w trybie "Interaktywny z powtórzeniami" lub "adaptacyjny" zachowanie, w których student ma kilka prób, aby prawidłowo odpowiedzieć na pytanie, ta opcja decyduje, jakie są następstwa każdej nieudanej próby.
Kara wyrażana jest jako ułamek całkowitej oceny za pytanie, więc jeśli pytanie jest warte 3 punkty, a kara wynosi 0.3333333, to uczeń zdobędzie 3 p, jeśli odpowie dobrze za pierwszym razem, 2 p - jeśli za drugim, a 1 p - jeśli dopiero w trzeciej próbie.';
$string['permissionedit'] = 'Edytuj to pytanie.';
$string['permissionmove'] = 'Przesuń to pytanie.';
$string['permissionsaveasnew'] = 'Zapisz to pytanie jako nowe.';
$string['permissionto'] = 'Masz uprawnienia do:';
$string['previewquestion'] = 'Podgląd pytania: {$a}';
$string['published'] = 'współdzielony';
$string['qtypeveryshort'] = 'T';
$string['questionaffected'] = '<a href="{$a->qurl}">Pytanie "{$a->name}" ({$a->qtype})</a> istnieje w tej kategorii pytań, ale także jest używane w <a href="{$a->qurl}">quizie "{$a->quizname}"</a> w innym kursie "{$a->coursename}".';
$string['questionbank'] = 'Baza pytań';
$string['questionbehaviouradminsetting'] = 'Ustawienia trybu działania quizu';
$string['questionbehavioursdisabled'] = 'Tryby działania quizu do wyłączenia';
$string['questionbehavioursdisabledexplained'] = 'Wpisz rozdzieloną przecinkami listę trybów, których nie chcesz wyświetlić w menu rozwijanym';
$string['questionbehavioursorder'] = 'Kolejność trybów testowania';
$string['questionbehavioursorderexplained'] = 'Wpisz rozdzieloną przecinkami listę trybów, które chcesz wyświetlić w menu rozwijanym';
$string['questioncategory'] = 'Kategoria pytań';
$string['questioncatsfor'] = 'Kategorie pytań dla \'{$a}\'';
$string['questiondoesnotexist'] = 'To pytanie nie istnieje';
$string['questionidmismatch'] = 'Niezgodność id pytań';
$string['questionname'] = 'Nazwa pytania';
$string['questionno'] = 'Pytanie {$a}';
$string['questionpreviewdefaults'] = 'Domyślny podgląd pytania';
$string['questionpreviewdefaults_desc'] = 'Te domyślne wartości są używane, gdy użytkownik pierwszy raz  przegląda pytanie w banku pytań. Gdy użytkownik zobaczy pytanie, jego osobiste ustawienia są przechowywane jako preferencje użytkownika.';
$string['questions'] = 'Pytania';
$string['questionsaveerror'] = 'Wystąpiły błędy podczas zapisywania pytania - ({$a})';
$string['questionsinuse'] = '(* Pytania oznaczone gwiazdką są już w użyciu w niektórych quizach. Te pytania nie zostaną usunięte z tych quizów, a tylko z listy kategorii.)';
$string['questionsmovedto'] = 'Pytania będące nadal w użyciu, przeniesiono do "{$a}" w nadrzędnej kategorii.*';
$string['questionsrescuedfrom'] = 'Zachowane pytania z kontekstu {$a} .';
$string['questionsrescuedfrominfo'] = 'Te pytania (niektóre z nich mogą być ukryte) zostały zachowane, gdy kontekst {$a} został usunięty, ponieważ są one nadal używane w niektórych quizach lub innych aktywnościach.';
$string['questiontext'] = 'Treść pytania';
$string['questiontype'] = 'Typ pytania';
$string['questionuse'] = 'Użyj pytania w tej aktywności';
$string['questionvariant'] = 'Wariant pytania';
$string['questionx'] = 'Pytanie {$a}';
$string['requiresgrading'] = 'Wymaga oceny';
$string['responsehistory'] = 'Historia odpowiedzi';
$string['restart'] = 'Rozpocznij ponownie';
$string['restartwiththeseoptions'] = 'Rozpocznij ponownie z tymi opcjami';
$string['reviewresponse'] = 'Przeglądaj odpowiedzi';
$string['rightanswer'] = 'Prawidłowa odpowiedź';
$string['rightanswer_help'] = 'Automatycznie wygenerowane podsumowanie poprawnych odpowiedzi. Może to być ograniczone, więc możesz rozważyć wyjaśnienie poprawnego rozwiązania w ogólnej zwrotnej odpowiedzi dla pytania, i wyłączenie tej opcji.';
$string['save'] = 'Zapisz';
$string['saved'] = 'Zapisano: {$a}';
$string['saveflags'] = 'Zapisz stan flag';
$string['selectacategory'] = 'Wybierz kategorię:';
$string['selectaqtypefordescription'] = 'Wybierz rodzaj pytania, aby zobaczyć jego opis.';
$string['selectcategoryabove'] = 'Wybierz jedną z powyższych kategorii';
$string['selectquestionsforbulk'] = 'Wybierz pytania do czynności zbiorczej';
$string['settingsformultipletries'] = 'Ustawienia dla wielu prób';
$string['shareincontext'] = 'Udostępnij w kontekście {$a}*';
$string['showhidden'] = 'Pokaż także stare pytania';
$string['showmarkandmax'] = 'Pokaż punkty i maksimum';
$string['showmaxmarkonly'] = 'Pokaż tylko maksymalną ilość punktów';
$string['shown'] = 'Pokazano';
$string['shownumpartscorrect'] = 'Pokaż liczbę poprawnych odpowiedzi';
$string['shownumpartscorrectwhenfinished'] = 'Pokaż liczbę poprawnych odpowiedzi po zakończeniu pytania';
$string['showquestiontext'] = 'Pokaż tekst pytania na liście pytań';
$string['specificfeedback'] = 'Szczegółowa informacja zwrotna';
$string['specificfeedback_help'] = 'Informacja zwrotna zależy od odpowiedzi udzielonej przez studenta.';
$string['started'] = 'Rozpoczęto';
$string['state'] = 'Stan';
$string['step'] = 'Krok';
$string['stoponerror'] = 'Zatrzymaj na błędzie';
$string['stoponerror_help'] = 'To ustawienie określa, czy proces importowania ma się zatrzymać, gdy zostanie wykryty błąd (wtedy żadne pytanie nie zostanie zaimportowane), czy pytania zawierające błędy mają być ignorowane, ale pozostałe - importowane.';
$string['submissionoutofsequence'] = 'Zaburzona poprawna sekwencja stron quizu. Nie klikaj przycisku Wstecz podczas pracy z quizem.';
$string['submissionoutofsequencefriendlymessage'] = 'Próbujesz wprowadzić dane poza normalną sekwencją stron. Taka sytuacja może wystąpić, jeśli używasz w swojej przeglądarce przycisków Wstecz lub Do przodu; proszę ich nie używać w trakcie quizu. Może się to również zdarzyć, jeśli klikniesz na coś podczas ładowania strony. Kliknij przycisk <strong>Kontynuuj,</strong>, aby wznowić.';
$string['submit'] = 'Zatwierdź';
$string['submitandfinish'] = 'Zatwierdź i zakończ';
$string['submitted'] = 'Zatwierdź: {$a}';
$string['technicalinfo'] = 'Dane techniczne';
$string['technicalinfo_help'] = 'Niniejsza informacja techniczna jest prawdopodobnie tylko użyteczna dla programistów pracujących nad nowymi typami pytań. Może to również być pomocne przy diagnozowaniu problemów z pytaniami.';
$string['technicalinfomaxfraction'] = 'Maksymalna część: {$a}';
$string['technicalinfominfraction'] = 'Minimalna część: {$a}';
$string['technicalinfoquestionsummary'] = 'Podsumowanie pytania: {$a}';
$string['technicalinforesponsesummary'] = 'Podsumowanie odpowiedzi: {$a}';
$string['technicalinforightsummary'] = 'Podsumowanie poprawnej odpowiedzi: {$a}';
$string['technicalinfostate'] = 'Stan pytania: {$a}';
$string['technicalinfovariant'] = 'Wariant pytania: {$a}';
$string['tofilecategory'] = 'Zapisz kategorię do pliku';
$string['tofilecontext'] = 'Zapisz kontekst do pliku';
$string['uninstallbehaviour'] = 'Odinstaluj ten tryb';
$string['uninstallqtype'] = 'Odinstaluj ten typ pytania.';
$string['unknown'] = 'Nieznany';
$string['unknownbehaviour'] = 'Nieznany tryb: {$a}.';
$string['unknownorunhandledtype'] = 'Nieznany lub nieobsługiwany typ pytania: {$a}';
$string['unknownquestion'] = 'Nieznane pytanie: {$a}.';
$string['unknownquestioncatregory'] = 'Nieznana kategoria pytań: {$a}.';
$string['unknownquestiontype'] = 'Nieznany typ pytania: {$a}.';
$string['unknowntolerance'] = 'Nieznany typ tolerancji {$a}';
$string['unpublished'] = 'nieudostępniony';
$string['updatedisplayoptions'] = 'Aktualizuj opcje wyświetlania';
$string['upgradeproblemcategoryloop'] = 'Wykryto problem podczas aktualizacji kategorii pytań. Jest pętli w drzewie kategorii. Dotyczy kategorii id: {$a}.';
$string['upgradeproblemcouldnotupdatecategory'] = 'Nie można zaktualizować kategorii {$a->name} ({$a->id}).';
$string['upgradeproblemunknowncategory'] = 'Wykryto problem podczas aktualizacji kategorii pytań. Kategoria {$a->id} odwołuje się do kategorii nadrzędnej {$a->parent}, która nie istnieje. Zmieniono kategorię nadrzędną, aby naprawić problem.';
$string['whethercorrect'] = 'Czy poprawnie';
$string['whethercorrect_help'] = 'To obejmuje zarówno opis tekstowy \'Poprawny\', \'Częściowo poprawny\' lub \'Niepoprawny\' i każde podkolorowane podświetlenie, które przekazuje te same informacje.';
$string['withselected'] = 'Z zaznaczonymi';
$string['wrongprefix'] = 'Błędnie sformatowany nameprefix {$a}';
$string['xoutofmax'] = '{$a->mark} z {$a->max}';
$string['yougotnright'] = 'Poprawnie wybrałeś {$a->num}.';
$string['youmustselectaqtype'] = 'Musisz wybrać typ pytania.';
$string['yourfileshoulddownload'] = 'Pobranie pliku eksportu powinno wkrótce się rozpocząć. Jeśli nie, proszę <a href="{$a}">kliknąć tutaj</a>.';
