<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Možete pregledati ovaj test, ali ako je ovo stvarni pokušaj rešavanja, bićete blokirani jer:';
$string['action'] = 'Akcija';
$string['activityoverview'] = 'Približava se rok za rešavanje testova';
$string['adaptive'] = 'Adaptivni režim';
$string['adaptive_help'] = 'Ako je omogućen adaptivni režim, onda je polazniku dozvljeno da unutar istog pokušaja rešavanja testa više puta odgovori na pitanje. Na primer, ako je odgovor označen kao netačan, polazniku će biti dozvoljeno da odmah ponovo odgovori. Međutim, zavisno od podešavanja "Primeni kaznene poene", za svaki pogrešan odgovor obično će biti oduzet odgovarajući broj kaznenih poena.';
$string['addaquestion'] = 'Dodaj pitanje...';
$string['addarandomquestion'] = 'Dodaj nasumično odabrano pitanje';
$string['addarandomquestion_help'] = 'Kada se dodaju nasumična pitanja, to rezultira time da se u test dodaju nasumično odabrana pitanja iz kategorije. Ovo znači da će svaki polaznik verovatno dobiti različit skup pitanja, a kada test dozvoljava ponovne pokušaje onda je verovatno da će svaki pokušaj sadržati novi skup pitanja.';
$string['adddescriptionlabel'] = 'Dodaj opis/natpis';
$string['addingquestion'] = 'Dodavanje pitanja';
$string['addingquestions'] = '<p>Ovaj deo stranice je mesto na kojem uređujete svoju bazu pitanja. Pitanja se čuvaju u kategorijama koje vam pomažu da pitanja ih organizujete. Pitanja se mogu koristiti u bilo kom testu vašeg kursa ili. čak, u drugim kursevima, ako odlučite da ih \'objavite\'. </p>
<p>Nakon što izaberete ili kreirate kategoriju pitanja, možete da pravite nova ili uređujete postojeća pitanja. Možete da izaberete bilo koje od ovih pitanja i dodate ih u vaš test koji se nalazi na suprotnoj strani ove stranice. </p>';
$string['addmoreoverallfeedbacks'] = 'Dodaj još {no} polja za povratne informacije';
$string['addnewgroupoverride'] = 'Dodaj promenu pravila za grupu';
$string['addnewpagesafterselected'] = 'Dodaj nove stranice posle odabranih pitanja';
$string['addnewquestionsqbank'] = 'Dodaj pitanja u kategoriju {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj promenu pravila za korisnika';
$string['addpagehere'] = 'Dodaj stranicu ovde';
$string['addquestion'] = 'Dodaj pitanje';
$string['addquestions'] = 'Dodaj pitanja';
$string['addquestionstoquiz'] = 'Dodaj pitanja u tekući test';
$string['addrandom'] = 'Dodaj {$a} slučajnih pitanja';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'slučajna pitanja';
$string['addrandomfromcategory'] = 'Dodaj nasumično odabrana pitanja iz kategorije';
$string['addrandomquestion'] = 'Dodaj nasumično odabrana pitanja';
$string['addrandomquestiontoquiz'] = 'Dodaj nasumično odabrana pitanja u test {$a}';
$string['addselectedtoquiz'] = 'Dodaj odabrano u test';
$string['addtoquiz'] = 'Dodaj u test';
$string['affectedstudents'] = 'Uticalo je na {$a}';
$string['aftereachquestion'] = 'Nakon dodavanja svakog pitanja';
$string['afternquestions'] = 'Nakon dodavanja {$a} pitanja';
$string['age'] = 'starost';
$string['allattempts'] = 'Svi pokušaji';
$string['allinone'] = 'Neograničeno';
$string['allowreview'] = 'Dozvoli pregled';
$string['alreadysubmitted'] = 'Verovatno ste već predali test.';
$string['alternativeunits'] = 'Alternativne merne jedinice';
$string['alwaysavailable'] = 'Uvek dostupno';
$string['analysisoptions'] = 'Opcije analize';
$string['analysistitle'] = 'Tabela analize pitanja';
$string['answer'] = 'Odgovor';
$string['answered'] = 'Odgovoreno';
$string['answerhowmany'] = 'Jedan ili više tačnih odgovora?';
$string['answers'] = 'Odgovori';
$string['answersingleno'] = 'Dozvoljeno je više tačnih odgovora';
$string['answersingleyes'] = 'Samo jedan odgovor je tačan';
$string['answertoolong'] = 'Odgovor je predugačak nakon linije {$a} (maks. 255 znakova)';
$string['aon'] = 'AON format';
$string['areyousureremoveselected'] = 'Da li ste sigurni da želite da obrišete sva izabrana pitanja?';
$string['asshownoneditscreen'] = 'Kao što je prikazano na stranici za uređivanje';
$string['attempt'] = 'Pokušaj broj {$a}';
$string['attemptalreadyclosed'] = 'Ovaj pokušaj je već završen.';
$string['attemptclosed'] = 'Pokušaj još uvek nije zatvoren';
$string['attemptduration'] = 'Utrošeno vreme';
$string['attemptedon'] = 'Datum predaje testa';
$string['attempterror'] = 'Trenutno vam nije dozvoljeno da pokušate ovaj test zbog  {$a}';
$string['attemptfirst'] = 'Prvi pokušaj';
$string['attemptincomplete'] = 'Ovaj pokušaj (korisnika: {$a}) još nije završen.';
$string['attemptlast'] = 'Poslednji pokušaj';
$string['attemptnumber'] = 'Pokušaj';
$string['attemptquiznow'] = 'Započni test';
$string['attempts'] = 'Pokušaji';
$string['attemptsallowed'] = 'Dozvoljen broj pokušaja';
$string['attemptsdeleted'] = 'Broj izbrisanih pokušaja';
$string['attemptselection'] = 'Izaberite koje pokušaje treba analizirati po korisniku:';
$string['attemptsexist'] = 'Test je već u upotrebi, ne možete više dodavati ili brisati pitanja.';
$string['attemptsnum'] = 'Ukupan broj pokušaja: {$a}';
$string['attemptsnumthisgroup'] = 'Ukupan broj pokušaja: {$a->total} ({$a->group} iz ove grupe)';
$string['attemptsnumyourgroups'] = 'Ukupan broj pokušaja: {$a->total} ({$a->group} iz vaše grupe)';
$string['attemptsonly'] = 'Prikaži samo polaznike sa pokušajima';
$string['attemptstate'] = 'Stanje';
$string['attemptstillinprogress'] = 'Pokušaj je još u toku';
$string['attemptsunlimited'] = 'Neograničen broj pokušaja';
$string['autosaveperiod'] = 'Vremenski period za automatsko čuvanje odgovora';
$string['autosaveperiod_desc'] = 'U toku rešavanja testa odgovori studenata mogu da se automatski snimaju svakih nekoliko minuta. Ovo podrazumeva kompromis: s jedne strane snimanje odgovora povećava opterećenje servera, ali s druge smanjuje mogućnost da studenti izgube svoje odgovore.';
$string['back'] = 'Nazad na pregled pitanja';
$string['backtocourse'] = 'Nazad na kurs';
$string['backtoquestionlist'] = 'Nazad na spisak pitanja';
$string['backtoquiz'] = 'Nazad na uređivanje testa';
$string['basicideasofquiz'] = 'Osnovne ideje pravljenja testa';
$string['bestgrade'] = 'Najviša ocena';
$string['bothattempts'] = 'Prikaži polaznike sa i bez pokušaja';
$string['browsersecurity'] = 'Bezbednost prozora Web čitača';
$string['browsersecurity_help'] = 'Ako je izabrano "Iskačući prozor preko celog ekrana sa delimično uključenim JavaScript opcijama za bezbednost",

* test će se pokrenuti samo ako polaznik ima Web čitač sa uključenom podrškom za JavaScript
* test će se pojaviti u iskačućem prozoru preko celog ekrana, koji pokriva sve ostale prozore i koji nema dugmad za navigaviju
* polaznicima će, koliko je god to moguće, biti onemogućeno da koriste komande poput "kopiraj" i "nalepi"';
$string['calculated'] = 'Računsko';
$string['calculatedquestion'] = 'Računsko pitanje nije podržano u liniji {$a}. Pitanje će biti ignorisano.';
$string['cannotcreatepath'] = 'Ne može se kreirati putanja ({$a})';
$string['cannoteditafterattempts'] = 'Ne možete da dodate ili uklonite pitanja zbog toga što već ima pokušaja rešavanja testa. ({$a})';
$string['cannotfindprevattempt'] = 'Nije moguće pronaći prethodni pokušaj';
$string['cannotfindquestionregard'] = 'Nije bilo moguće dobiti pitanja za ponovno ocenjivanje';
$string['cannotinsert'] = 'Ne može se umetnuti pitanje';
$string['cannotinsertrandomquestion'] = 'Nije bilo moguće ubaciti novo nasumično odabrano pitanje';
$string['cannotloadquestion'] = 'Nije bilo moguće učitati opcije pitanja';
$string['cannotloadtypeinfo'] = 'Nije moguće učitati informacije vezane za tip pitanja';
$string['cannotopen'] = 'Ne može se otvoriti izvozna datoteka ({$a})';
$string['cannotrestore'] = 'Nije bilo moguće vratiti podatke za sesije pitanja';
$string['cannotreviewopen'] = 'Ne možete da pregledate ovaj pokušaj, još uvek je otvoren';
$string['cannotsavelayout'] = 'Nije bilo moguće sačuvati';
$string['cannotsavenumberofquestion'] = 'Nije bilo moguće sačuvati broj pitanja po jedno stranici';
$string['cannotsavequestion'] = 'Ne može se sačuvati spisak pitanja';
$string['cannotsetgrade'] = 'Nije bilo moguće postaviti novu maksimalnu ocenu za test';
$string['cannotsetsumgrades'] = 'Pokušaj da se podesi suma ocena nije uspeo';
$string['cannotstartgradesmismatch'] = 'Nije moguće započeti pokušaj rešavanja ovog testa. Ocena testa je podešena na {$a->grade}, ali nijedno od pitanja u testu nema podešenu ocenu. Ovo može biti popravljeno na stranici \'Uredi test\'.';
$string['cannotstartmissingquestion'] = 'Ne možete da započnete rešavanje ovog testa. U test je uključueno pitanje koje ne postoji.';
$string['cannotstartnoquestions'] = 'Nije moguće započeti pokušaj rešavanja ovog testa. Test još uvek nije podešen. Nijedno pitanje nije dodato.';
$string['cannotwrite'] = 'Ne može se upisivati u izvoznu datoteku ({$a})';
$string['caseno'] = 'Ne treba voditi računa o malim i velikim slovima';
$string['casesensitive'] = 'Vođenje računa o malim i velikim slovima';
$string['caseyes'] = 'Da, moraju se poklapati čak i mala i velika slova';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Kategorija \'{$a}\' je dodata';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je obrisana';
$string['categorynoedit'] = 'Nemate ovlašćenja za menjanje kategorije \'{$a}\'.';
$string['categoryupdated'] = 'Kategorija je uspešno izmenjena';
$string['close'] = 'Zatvori prozor';
$string['closebeforeopen'] = 'Nije moguće ažurirati test. Odredili ste datum zatvaranja pre datuma otvaranja.';
$string['closed'] = 'Zatvoreno';
$string['closepreview'] = 'Zatvori pregled';
$string['closereview'] = 'Zatvori pregled';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Komentarišite ili promennite ocenu';
$string['comments'] = 'Komentari';
$string['completedon'] = 'Završeno dana';
$string['configadaptive'] = 'Ukoliko izaberete \'Da\' za ovu opciju onda će polazniku biti dozvoljeno da više puta odgovori na pitanje, čak u okviru istog pokušaja rešavanja testa.';
$string['configattemptsallowed'] = 'Ograničenje u broju pokušaja koji su polaznicima dozvoljeni na testu';
$string['configdecimaldigits'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocene.';
$string['configdecimalplaces'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocene za test.';
$string['configdecimalplacesquestion'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocene za pojedinačna pitanja.';
$string['configdelay1'] = 'Ukoliko podesite vremenski razmak, onda će polaznik nakon prvog pokušaja morati toliko vremena da sačeka pre nego što bude mogao ponovo da pokuša da uradi test.';
$string['configdelay1st2nd'] = 'Ukoliko ovde podesite vremenski razmak, polaznici ne mogu da drugi put urade test pre nego što ne protekne toliko vremene od njihovog prvog pokušaja.';
$string['configdelay2'] = 'Ukoliko ovde podesite vremenski razmak, onda polaznik mora da sačeka toliko vremene da prođe pre nego što započne svoj treći (i svaki naredni) pokušaj rešavanja testa.';
$string['configdelaylater'] = 'Ukoliko ovde podesite vremenski razmak, onda polaznik ne može da započne treći, četvrti,... pokušaj pre nego toliko vremena ne prođe od kraja prethodnog pokušaja rešavanja testa.';
$string['configeachattemptbuildsonthelast'] = 'Ukoliko su dozvoljeni višestruki pokušaji onda svaki novi pokušaj sadrži rezultate prethodnog pokušaja.';
$string['configgrademethod'] = 'Kada su višestruki pokušaji dozvoljeni koji metod treba koristiti za izračunavanje polaznikove završne ocene za test.';
$string['configintro'] = 'Vrednosti koje ste ovde podesili definiše podrazumevane vrednosti koje se koriste u obrascu za podešavanje kada kreirate novi test. Možete, takođe, da konfigurišete koja podešavanja testa se smatraju naprednim.';
$string['configmaximumgrade'] = 'Podrazumevana ocena na osnovu koje će se gradirati ocene na testu';
$string['confignavmethod'] = 'Kod slobodne navigacije na pitanja se može odgovarati bilo kojim redosledom, Kod sekvencijalne navigacije na pitanja se mora odgovarati strogo utvrđenim redosledom';
$string['confignewpageevery'] = 'Kod dodavanja pitanja u test, prekid stranice će automatski biti ubačen prema podešavanju koje odve odaberete,';
$string['configoutcomesadvanced'] = 'Ako je ova opcija uključena onda će \'Ishodi\' u obrascu za uređivanje testa biti smešteni u delu za napredna podešavanja.';
$string['configpenaltyscheme'] = 'Kazneni poeni koji se oduzimaju za svaki pogrešan odgovor u adaptivnom modu.';
$string['configpopup'] = 'Prinudno otvaranje testa u iskačućem prozoru, uz korišćenje JavaScript opcija, koje će pokušati da ograniče korišćenje komandi "kopiraj", "nalepi" itd., u toku rešavanja testa.';
$string['configrequirepassword'] = 'Polaznici moraju da unesu ovu lozinku pre nego što pokušaju da reše test.';
$string['configrequiresubnet'] = 'Polaznici mogu da pokušaju da reše test samo sa ovih računara.';
$string['configreviewoptions'] = 'Ove opcije kontrolišu koje informacije će korisnici moći da vide kada budu pregledali pokušaj ili kada budu gledali izveštaje o testu.';
$string['configshowblocks'] = 'Prikaži blokove tokom rešavanja testa.';
$string['configshowuserpicture'] = 'Prikaži sliku korisnika na ekranu tokom pokušaja rešavanja testa.';
$string['configshufflequestions'] = 'Ukoliko omogućite ovu opciju, onda će redosled pitanja u testu će nasumično izmešan svaki put kada polaznik pokuša da reši test.';
$string['configshufflewithin'] = 'Ako omogućite ovu opciju, onda će delovi koji sačinjavaju pojedinačno pitanje biti nasumično izmešani svaki put kada polaznik započne da rešava ovaj test. Ponuđena opcija je takođe uključena u podešavanjima pitanja.';
$string['configtimelimit'] = 'Podrazumevano vremensko ograničenje za testove u minutima. 0 znači da nema vremenskog ograničenja.';
$string['configtimelimitsec'] = 'Podraumevano vremensko ogrničenje za testove u sekundama. 0 znači da nema vremenskog ograničenja.';
$string['configurerandomquestion'] = 'Konfiguriši pitanje';
$string['confirmclose'] = 'Kada predate test nećete više biti u mogućnosti da menjate svoje odgovore.';
$string['confirmserverdelete'] = 'Da li ste sigurni da želite da uklonite server <b>{$a}</b> sa spiska?';
$string['confirmstartattemptlimit'] = 'Broj dozvoljenih pokušaja: {$a}. Upravo se spremate da započnete novi pokušaj. Da li želite da nastavite?';
$string['confirmstartattempttimelimit'] = 'Test ima vremensko ograničenje, a moguće ga je raditi {$a} put(a). Svaki pristup testu se računa kao pokušaj njegovog rešavanja. Da li želite da nastavite?';
$string['confirmstarttimelimit'] = 'Test ima vremensko ograničenje. Da li ste sigurni da želite da počnete?';
$string['connectionerror'] = 'Mrežna veza je izgubljena. (Automatsko čuvanje nije uspelo).

Zapišite sve odgovora unetih na ovoj stranici u poslednjih nekoliko minuta, a zatim pokušajte ponovo da se povežete.

Kada se veza ponovo uspostavi vaši odgovori bi trebalo da budu sačuvani a ova poruka će nestati.';
$string['connectionok'] = 'Mrežna veza je ponovo uspostavljena. Možete bezbedno da nastavite.';
$string['containercategorycreated'] = 'Ova kategorija je kreirana sa ciljem da se u nju smeste sve originalne kategorije koje se pomere na nivo sajta iz dole navedenih razloga.';
$string['continueattemptquiz'] = 'Nastavite poslednji pokušaj';
$string['continuepreview'] = 'Nastavi poslednji pregled';
$string['copyingfrom'] = 'Kreiranje kopije pitanja \'{$a}\'';
$string['copyingquestion'] = 'Kopiranje pitanja';
$string['correct'] = 'Tačno';
$string['correctanswer'] = 'Tačan odgovor';
$string['correctanswerformula'] = 'Formula tačnih odgovora';
$string['correctansweris'] = 'Tačan odgovor: {$a}';
$string['correctanswerlength'] = 'Značajne cifre';
$string['correctanswers'] = 'Tačni odgovori';
$string['correctanswershows'] = 'Prikaz tačnih odgovora';
$string['corrresp'] = 'Tačan odgovor';
$string['countdown'] = 'Brojač';
$string['countdownfinished'] = 'Test se uskoro zatvara, vreme je da predate svoje odgovore.';
$string['countdowntenminutes'] = 'Test se zatvara za deset minuta.';
$string['coursetestmanager'] = 'Test Menadžer format';
$string['createcategoryandaddrandomquestion'] = 'Kreiraj kategoriju i dodaj nasumičnо odabranо pitanjе';
$string['createfirst'] = 'Morate prvo kreirati neka pitanja sa kratkim odgovorima.';
$string['createmultiple'] = 'Dodajte testu nekoliko slučajnih pitanja';
$string['createnewquestion'] = 'Kreiraj novo pitanje';
$string['createquestionandadd'] = 'Kreiraj novo pitanje i dodaj ga testu.';
$string['custom'] = 'Proizvoljan format';
$string['dataitemneed'] = 'Morate dodati bar jedan skup stavki podataka da biste dobili validno pitanje';
$string['datasetdefinitions'] = 'Ponovo upotrebljene definicije seta podataka za kategoriju {$a}';
$string['datasetnumber'] = 'Broj';
$string['daysavailable'] = 'Dostupni dani';
$string['decimaldigits'] = 'Broj decimala u ocenama';
$string['decimalplaces'] = 'Decimalna mesta u ocenama';
$string['decimalplaces_help'] = 'Ovo podešavanje određuje broj cifara koji treba prikazati iza decimalne tačke kada se prikazuju ocena. Ovo utiče samo na prikaz ocena, ali ne i na ocene sačuvane u bazi podataka, niti na interna izračunavanja koja se izvode sa punom preciznošću.';
$string['decimalplacesquestion'] = 'Decimalna mesta u ocenama pitanja';
$string['decimalplacesquestion_help'] = 'Ovo podešavanje određuje broj cifara koji treba prikazati iza decimalne tačke kada se prikazuju ocene za pojedinačna pitanja.';
$string['decimalpoints'] = 'Decimalna mesta';
$string['default'] = 'Podrazumevano';
$string['defaultgrade'] = 'Podrazumevana ocena pitanja';
$string['defaultinfo'] = 'Podrazumevana kategorija za pitanja';
$string['delay1'] = 'Vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd'] = 'Prinudni vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd_help'] = '<p>Ukoliko podesite vremenski razmak, polaznik mora nakon svog prvog pokušaja da sačeka da toliko vremena prođe pre nego što mu bude dozvoljeno da ponovo pokuša da reši test.</p>';
$string['delay2'] = 'Vremenski razmak između svih ostalih pokušaja';
$string['delaylater'] = 'Prinudni vremenski razmak između naknadni pokušaja';
$string['delaylater_help'] = '<p>Ukoliko ovde podesite vremenski razmak, polaznik mora da sačeka da toliko vremena prođe pre nego što započne svoj treći i svaki naredni pokušaj rešavanja testa.</p>';
$string['deleteattemptcheck'] = 'Da li ste apsolutno sigurni da želite da obrišete ove pokušaje?';
$string['deleteselected'] = 'Obriši označeno';
$string['deletingquestionattempts'] = 'Obriši pokušaje pitanja';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogućeno';
$string['displayoptions'] = 'Opcije za prikaz';
$string['donotuseautosave'] = 'Ne koristi opciju za automatsko čuvanje';
$string['download'] = 'Kliknite za preuzimanje izvezene datoteke sa kategorijama';
$string['downloadextra'] = '(datoteka se čuva i među datotekama kursa u /backupdata/quiz direktorijumu)';
$string['duplicateresponse'] = 'Ovaj odgovor je ignorisan zato što je jednak odgovoru koji ste dali ranije.';
$string['eachattemptbuildsonthelast'] = 'Svaki pokušaj se nastavlja na prethodni';
$string['eachattemptbuildsonthelast_help'] = '<p>Ako je dozvoljeno više pokušaja rešavanja testa i ovo podešavanje je postavljeno na <b>Da</b>, onda će svaki novi pokušaj sadržati rezultate prethodnog. To dozvoljava da se rešavanje testa završi u više pokušaja.</p>

<p>Da bi se prikazao novi primerak testa pri svakom pokušaju, izaberite vrednost <b>Ne</b> za ovo podešavanje.</p>';
$string['editcategories'] = 'Uređivanje kategorija';
$string['editcategory'] = 'Uređivanje kategorije';
$string['editcatquestions'] = 'Uređivanje pitanja u kategoriji';
$string['editingquestion'] = 'Uređivanje pitanja';
$string['editingquiz'] = 'Uređivanje testa';
$string['editingquiz_help'] = 'Prilikom kreiranja testa, osnovni pojmovi su:

* Test, koji sadrži pitanja na jednoj ili više stranica
* Banka pitanja, koja sadrži kopije svih pitanja organizovanih u kategorije
* Nasumično odabrano pitanje - polaznik dobija različita pitanja svaki put kada pokuša da rešava test, odnosno različiti polaznici mogu da dobiju različita pitanja tj. test.';
$string['editingquizx'] = 'Uređivanje testa: {$a}';
$string['editoverride'] = 'Uredi izmene podešavanja';
$string['editqcats'] = 'Uređivanje kategorija pitanja';
$string['editquestions'] = 'Uređivanje pitanja';
$string['editquiz'] = 'Uredi test';
$string['editquizquestions'] = 'Uredi pitanja testa';
$string['emailconfirmbody'] = 'Dragi/a {$a->username},

Hvala što ste poslali svoje odgovore na test \'{$a->quizname}\'
na kursu \'{$a->coursename}\'
u {$a->submissiontime}.

Ova poruka je potvrda da smo bezbedno primili vaše odgovore.

Ovom testu možete da pristupite na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Hvala što se predali svoje odogovore za test \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potvrda o slanju testa: {$a->quizname}';
$string['emailnotifybody'] = 'Poštovani/a {$a->username},

{$a->studentname} je završio/la test \'{$a->quizname}\' ({$a->quizurl})
na kursu \'{$a->coursename}\'.

Ovaj pokušaj možete pregledati na  {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} je završio/la test {$a->quizname}. Pogledajte na {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} je završio/la test {$a->quizname}';
$string['emailoverduebody'] = 'Poštovani/a {$a->username},

Započeli ste rešavanje testa \'{$a->quizname}\'
na kursu \'{$a->coursename}\', ali ga niste poslali.

Ako, još uvek. želite da pošaljete svoje odgovore, molimo vas da odete na {$a->attemptsummaryurl} i kliknete na dugme \'Predaj\'.
Ovo morate da uradite pre {$a->attemptgraceend}, u suprotnom vaš pokušaj rešavanja testa se neće računati.';
$string['emailoverduesmall'] = 'Niste predali svoj pokušaj rešavanja testa {$a->quizname}. Molimo vas da odete na {$a->attemptsummaryurl} pre {$a->attemptgraceend}, ako još uvek želite da predate svoje odgovore.';
$string['emailoverduesubject'] = 'Pokušaj rešavanja testa {$a->quizname} kasni';
$string['empty'] = 'Prazno';
$string['enabled'] = 'Omogućeno';
$string['endtest'] = 'Završi pokušaj...';
$string['erroraccessingreport'] = 'Ne možete da pristupite ovom izveštaju';
$string['errorinquestion'] = 'Greška u pitanju';
$string['errormissingquestion'] = 'Greška: Sistem ne može da pronađe pitanje čiji je identifikator {$a}';
$string['errornotnumbers'] = 'Greška - odgovori moraju biti numerički';
$string['errorunexpectedevent'] = 'Neočekivani kod događaja {$a->event} pronađen za šitanje {$a->questionid} u pokušaju {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Pitanja';
$string['eventquizattemptabandoned'] = 'Pokušaj rešavanja testa napušten';
$string['eventquizattemptstarted'] = 'Pokušaj rešavanja testa započet';
$string['eventquizattemptsubmitted'] = 'Pokušaj rešavanja testa predat';
$string['eventquizattempttimelimitexceeded'] = 'Vreme za rešavanje testa prekoračeno';
$string['everynquestions'] = 'Svaka/ih {$a} pitanja';
$string['everyquestion'] = 'Svako pitanje';
$string['everythingon'] = 'Sve na';
$string['export'] = 'Izvoz';
$string['exportcategory'] = 'izvezi kategoriju';
$string['exporterror'] = 'Došlo je do greške prilikom procesiranja izvoza';
$string['exportingquestions'] = 'Pitanja se izvoze u datoteku';
$string['exportname'] = 'Naziv datoteke';
$string['exportquestions'] = 'Izvezi pitanja u datoteku';
$string['extraattemptrestrictions'] = 'Dodatna ograničenja prilikom pokušaja';
$string['false'] = 'Pogrešno';
$string['feedback'] = 'Povratne informacije';
$string['feedbackerrorboundaryformat'] = 'Granične vrednosti ocene za povratne informacije moraju biti procenti ili brojevi. Vrednost koju ste uneli za granicu {$a} nije prepoznata.';
$string['feedbackerrorboundaryoutofrange'] = 'Granične vrednosti ocene za povratne informacije moraju biti između 0% i 100%. Vrednost koju ste uneli za granicu {$a} je van dozvoljenog opsega.';
$string['feedbackerrorjunkinboundary'] = 'Morate popuniti polja za granične vrednosti ocena za povratne informacije. Nemojte preskakati polja, već ih redom popunjavajte.';
$string['feedbackerrorjunkinfeedback'] = 'Morate popuniti polja povratnih informacija. Nemojte preskakati polja, već ih redom popunjavajte.';
$string['feedbackerrororder'] = 'Granične vrednosti ocena za povratne informacije moraju biti poređane počevši od najviše. Vrednost koju ste uneli za granicu {$a} je izvan niza.';
$string['file'] = 'Datoteka';
$string['fileformat'] = 'Format datoteke';
$string['fillcorrect'] = 'Unesite tačan odgovor';
$string['filloutnumericalanswer'] = 'Obezbedite bar jedan mogući odgovor i odstupanje. Prvi odgovor koji se poklapa biće korišćen za utvrđivanje ocene i povratnih informacija. Ako postavite povratne informacije bez odgovora na kraju, one će biti prikazane polaznicima čiji se odgovori ne poklapaju ni sa jednim od ostalih odgovora.';
$string['filloutoneanswer'] = 'Morate ponuditi najmanje jedan mogući odgovor. Odgovori koji se ne popune neće se koristiti. \'*\' se može koristiti kao džoker znak koji zamenjuje bilo koji niz karaktera. Prvi odgovor koji se poklopi sa datim koristiće se za određivanje rezultata i povratnih informacija.';
$string['filloutthreequestions'] = 'Morate ispuniti bar tri pitanja sa odgovarajućim rešenjima. Možete dodati još netačnih odgovora davanjem rešenja uz prazna pitanja. Stavke u kojima su i pitanje i odgovor prazni neće se uzimati u obzir.';
$string['fillouttwochoices'] = 'Morate ispuniti bar dva odgovora. Prazni odgovori se neće koristiti.';
$string['finishattemptdots'] = 'Završi pokušaj...';
$string['finishreview'] = 'Završi pregled';
$string['forceregeneration'] = 'Obavezno obnavljanje';
$string['formatnotfound'] = 'Nije pronađen format {$a} za uvoz/izvoz';
$string['formatnotimplemented'] = 'Ovaj format nije ispravno implementiran, molimo podnesite izveštaj o grešci';
$string['formulaerror'] = 'Greška u formuli!';
$string['fractionsaddwrong'] = 'Pozitivne ocene koje ste odabrali u zbiru ne daju 100%<br />Naime njihov zbir je {$a}%<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fractionsnomax'] = 'Jedan od odgovora bi trebao nositi 100% ocene, tako da je <br />moguće dobiti maksimalnu ocenu za ovo pitanje.<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fromfile'] = 'iz datoteke:';
$string['functiondisabledbysecuremode'] = 'Ova funkcionalnost je trenutno onemogućena';
$string['generalfeedback'] = 'Opšte povratne informacije';
$string['generalfeedback_help'] = 'Opšte povratne informacije predstavljaju tekst koji se prikazuje nakon davanja odgovora na pitanje. Za razliku od povratnih informacija za pojedinačno pitanje koje zavise od datog odgovora, opšte povratne informacije su uvek iste.';
$string['graceperiod'] = 'Dodatno vreme za predaju testa';
$string['graceperiod_desc'] = 'Ako je opcija \'Šta raditi kada vreme istekne\' podešeno na \'Dozvoli dodatno vreme za predaju testa, ali ne i za promenu odgovora\', ovo će biti podrazumevano dodatno vreme (u sekundama) koje se dozvoljava za predaju.';
$string['graceperiod_help'] = 'Ako je opcija \'Šta raditi kada vreme istekne\' podešeno na \'Dozvoli dodatno vreme za predaju testa, ali ne i za promenu odgovora\', ovo će biti podrazumevano dodatno vreme (u sekundama) koje se dozvoljava za predaju.';
$string['graceperiodmin'] = 'Dodatno vreme za konačnu predaju';
$string['graceperiodmin_desc'] = 'Postoji potencijalni problem na samom kraju testa. Sa jedne strane, želimo da polaznici nastave da rade test sve do poslednje sekunde - uz pomoć tajmera koji automatski predaje test kada vreme istekne. Sa druge strane, server može biti preopterećen pa će mu biti potrebno neko vreme da obradi odgovore. Dakle, prihvatićemo odgovore nakon što rok za predaju istekne, unutar ovog dodatnog vremena (u sekundama), tako da polaznici neće biti oštećeni zbog toga što je server spor. Međutim, polaznici ovo mogu da zloupotrebe tako što će u toku ovog dodatnog vremena odgovarati na pitanja. Morate da napravite kompromis na osnovu toga koliko imate poverenja u performanse svog servera u toku rešavanja testa.';
$string['graceperiodtoosmall'] = 'Dodatno vreme mora biti veće od {$a}.';
$string['grade'] = 'Ocena';
$string['gradeall'] = 'Oceni sve';
$string['gradeaverage'] = 'Prosečna ocena';
$string['gradeboundary'] = 'Granična vrednost ocene';
$string['gradeessays'] = 'Oceni eseje';
$string['gradehighest'] = 'Najviša ocena';
$string['grademethod'] = 'Metod ocenjivanja';
$string['grademethod_help'] = 'Kada je dozvoljen veći broj pokušaja rešavanja testa, postoje različiti načini za izračunavanje polaznikove konačne ocene.

* Najviša ocena od svih pokušaja
* Prosečna (srednja) ocena svih pokušaja
* Prvi pokušaj (svi ostali pokušaji se ignorišu)
* Poslednji pokušaj (svi ostali pokušaji se ignorišu)';
$string['gradesdeleted'] = 'Izbrisano ocena testa:';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradingdetails'] = 'Ocena za ovaj odgovor je: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Sa prethodnim kaznenim bodovima ocena je <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Ovim odgovorom ste zaradili {$a} kaznenih bodova.';
$string['gradingdetailszeropenalty'] = 'Niste zaradili kaznene bodove za ovaj odgovor';
$string['gradingmethod'] = 'Metod ocenjivanja: {$a}';
$string['groupoverrides'] = 'Izmene za grupe';
$string['groupsnone'] = 'Nema grupa na ovom kursu';
$string['guestsno'] = 'Nažalost, gosti ne mogu ni da vide ni da rešavaju testove';
$string['hidebreaks'] = 'Sakrij prekide stranica';
$string['hidereordertool'] = 'Sakrij alatku za reorganizaciju';
$string['history'] = 'Istorijat odziva sistema:';
$string['howquestionsbehave_desc'] = 'Podrazumevano podešavanje za to kako se pitanja ponašaju u testu';
$string['imagedisplay'] = 'Slika za prikaz';
$string['import'] = 'Uvoz';
$string['importcategory'] = 'kategorija uvoza';
$string['importerror'] = 'Došlo je do greške prilikom procesiranja uvoza';
$string['importfilearea'] = 'Uvoz iz datoteke koja je već među datotekama kursa';
$string['importfileupload'] = 'Uvoz iz novoučitane datoteke...';
$string['importfromthisfile'] = 'Uvoz iz ove datoteke';
$string['import_help'] = 'Ova funkcija Vam omogućava da pitanja uvezete iz eksternih tekstualnih datoteka.

Ako Vaša datoteka sadrži tzv. non-ascii karaktere onda ona mora da koristi UTF-8 kodni raspored. Posebno budite oprezni sa datotekama koje su generisale Microsoft Office aplikacije, pošto one obično koriste specijalan kodni raspored koji neće biti ispravno obrađen.

Formati za uvoz i izvoz prilagodljivi resursi. Drugi, opcioni, formati mogu se pronaći u bazi "Modules and Plugins" na sajtu moodle.org.';
$string['importingquestions'] = 'Uvoz {$a} pitanja iz datoteke';
$string['importmax10error'] = 'Postoji greška u pitanju. Ne može biti više od deset odgovora';
$string['importmaxerror'] = 'Postoji greška u pitanju. Ima previše odgovora.';
$string['importquestions'] = 'Uvoz pitanja iz datoteke';
$string['inactiveoverridehelp'] = '* Polaznik nema ispravnu grupu ili ulogu da bi mogao da rešava ovaj test';
$string['incorrect'] = 'Netačno';
$string['indivresp'] = 'Odgovori pojedinaca na svako pitanje';
$string['info'] = 'Informacije';
$string['infoshort'] = 'i';
$string['inprogress'] = 'U toku';
$string['introduction'] = 'Opis';
$string['invalidattemptid'] = 'Takav id pokušaja ne postoji';
$string['invalidcategory'] = 'Identifikator kategorije nije valjan';
$string['invalidnumericanswer'] = 'Jedan od odgovora koji ste uneli nije ispravan broj.';
$string['invalidnumerictolerance'] = 'Jedna od tolerancija koji ste uneli nije ispravan broj.';
$string['invalidoverrideid'] = 'Neispravan identifikator izmene';
$string['invalidquestionid'] = 'Neispravan id pitanja';
$string['invalidquizid'] = 'Neispravan identifikator testa';
$string['invalidsource'] = 'Izvor nije prihvaćen kao validan.';
$string['invalidsourcetype'] = 'Nije validan tip izvora';
$string['invalidstateid'] = 'Neispravan id stanja';
$string['lastanswer'] = 'Vaš odgovor je bio';
$string['layout'] = 'Izgled (raspored pitanja)';
$string['layoutasshown'] = 'Izgled stranice kao što je prikazano.';
$string['layoutasshownwithpages'] = 'Izgled stranice kao što je prikazano. <small>(Nova stranica automatski na svakih  {$a} pitanja.)</small>';
$string['layoutshuffledandpaged'] = 'Pitanja su nasumično izmešana sa {$a} pitanja po stranici.';
$string['layoutshuffledsinglepage'] = 'Pitanja nasumično izmešana, sva prikazana na jednoj stranici.';
$string['link'] = 'Link';
$string['listitems'] = 'Lista stavki u testu';
$string['literal'] = 'Znak';
$string['loadingquestionsfailed'] = 'Broj neuspelih učitavanja pitanja: {$a}';
$string['makecopy'] = 'Sačuvaj kao novo pitanje';
$string['managetypes'] = 'Upravljanje tipovima pitanja i serverima';
$string['manualgrading'] = 'Ocenjivanje';
$string['mark'] = 'Predajte';
$string['markall'] = 'Predajte stranicu';
$string['marks'] = 'Ocene';
$string['marks_help'] = 'Numeričke ocene za svako pitanje, kao i sveukupni rezultat pokušaja';
$string['match'] = 'Sparivanje';
$string['matchanswer'] = 'Sparivanje odgovora';
$string['matchanswerno'] = 'Sparivanje odgovora {$a}';
$string['max'] = 'Maksimalno';
$string['messageprovider:attempt_overdue'] = 'Upozorenje kada vaš pokušaj rešavanja testa kasni';
$string['messageprovider:confirmation'] = 'Potvrda o predaji vaših pokušaja rešavanja testa';
$string['messageprovider:submission'] = 'Obaveštenje o predatim testovima';
$string['min'] = 'Minimalno';
$string['minutes'] = 'Minut(a)';
$string['missingcorrectanswer'] = 'Morate zadati tačan odgovor';
$string['missingitemtypename'] = 'Nedostaje naziv';
$string['missingquestion'] = 'Nedostaje naziv pitanja nakon linije {$a}';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Modul \'Test\' omogućava predavačima da dizajniraju testove koji se sastoje od različitih tipova pitanja, uključujući višestruki izbor, sparivanje, kratak odgovor, numerička pitanja itd.

Predavač može da dozvoli da se test rešava više puta, sa izmešanim redosledom pitanja ili nasumično izabranim pitanjima iz banke, prilikom svakog pokušaja. Takođe, moguće je podesiti vremensko ograničenje za rešavanje testa.

Svaki pokušaj se automatski ocenjuje, sa izuzetkom esejskog tipa pitanja, a ocena se beleži u knjigu ocena.

Predavač može da izabere da li će i kada polaznicima biti prikazni saveti, povratne informacije i tačni odgovori

Testovi mogu da se koriste:

* kao završni ispiti
* kao mini testovi nakon što polaznici imaju zadatak da pročitaju određeni tekst, ili na kraju neke teme (oblasti)
* kao priprema za završni ispit, koristeći pitanja sa prethodnih  ispita
* za pružanje neposrednih povratnih informacija o postignućima
* za samostalnu procenu znanja';
$string['modulenameplural'] = 'Testovi';
$string['moveselectedonpage'] = 'Premesti izabrana pitanja na stranicu: {$a}';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswers'] = 'Odaberite bar jedan odgovor.';
$string['multiplier'] = 'Množitelj';
$string['mustbesubmittedby'] = 'Ovaj pokušaj mora biti predat do {$a}.';
$string['name'] = 'Naziv';
$string['navmethod'] = 'Metod navigacije';
$string['navmethod_free'] = 'Slobodna navigacija';
$string['navmethod_help'] = 'Kada je uključena sekvencijalna navigacija polaznici moraju da odgovaraju na pitanja onim redosledom kako su ona poređana u testu, i ne mogu da se vraćaju na prethodne ili preskaču stranice.';
$string['navmethod_seq'] = 'Sekvencijalna navigacija';
$string['navnojswarning'] = 'Upozorenje: ovi linkovi neće sačuvati vaše odgovore. Koristite dugme "Sledeće" na dnu stranice.';
$string['neverallononepage'] = 'Nikad, sva pitanja na jednu stranicu';
$string['newattemptfail'] = 'Greška: Nije bilo moguće započeti novi pokušaj rešavanja testa';
$string['newpage'] = 'Nova stranica';
$string['newpageevery'] = 'Automatski staruj novu stranicu';
$string['newpage_help'] = '<p>Kod testove sa puno pitanja ima smisla podeliti test na nekoliko stranica tako što će se ograničiti broj pitanja po jednoj stranici. Kada se testu dodaju pitanja, prekidi stranica biće automatski umetniti shodno podešavanju koje ste ovde izabrali. Ipak, takođe je moguće da kasnije, tokom uređivanja stranice, ručno premeštate prekide stranica.
</p>';
$string['noanswers'] = 'Nijedan odgovor nije odabran!';
$string['noattempts'] = 'Nije bilo pokušaja da se reši ovaj test';
$string['noattemptsfound'] = 'Nije pronađen nijedan pokušaj.';
$string['noattemptstoshow'] = 'Nema pokušaja za prikaz';
$string['nocategory'] = 'Pogrešna ili nespecificirana kategorija';
$string['noclose'] = 'Nema datuma zatvaranja testa';
$string['nocommentsyet'] = 'Još nema komentara';
$string['noconnection'] = 'Trenutno nije uspostavljena veza sa Web servisom koji može da obradi ovo pitanje. Molimo kontaktirajte svog administratora';
$string['nodataset'] = 'ništa - nije džoker znak';
$string['nodatasubmitted'] = 'Nijedan podatak nije poslat.';
$string['noessayquestionsfound'] = 'Nisu pronađena pitanja koja se ručno ocenjuju';
$string['nogradewarning'] = 'Ovaj test se ne ocenjuje, tako da ne možete da podesite sveobuhvatnu povratnu informaciju.';
$string['nomoreattempts'] = 'Nemate više pravo da pokušavate da rešite test';
$string['none'] = 'Nema';
$string['noopen'] = 'Nema datuma otvaranja testa';
$string['nooverridedata'] = 'Morate da promenite najmanje jedno od podešavanja testa';
$string['nopossibledatasets'] = 'Nema mogućih skupova podataka';
$string['noquestionintext'] = 'Tekst pitanja ne sadrži umetnuta pitanja';
$string['noquestions'] = 'Nijedno pitanje još nije dodato';
$string['noquestionsfound'] = 'Nema pitanja';
$string['noquestionsinquiz'] = 'Ne postoje pitanja u ovom testu';
$string['noquestionsnotinuse'] = 'Ovo nasumično odrabrano pitanje nije u upotrebi jer je njegova kategorija prazna';
$string['noquestionsonpage'] = 'Prazna stranica';
$string['noresponse'] = 'Bez odgovora';
$string['noreview'] = 'Nije Vam dozvoljen pregled ovog testa';
$string['noreviewattempt'] = 'Nije Vam dozvoljeno da pregledate ovaj pokušaj';
$string['noreviewshort'] = 'Nije dozvoljeno';
$string['noreviewuntil'] = 'Nije Vam dozvoljen pregled ovog testa do {$a}';
$string['noreviewuntilshort'] = 'Dostupno {$a}';
$string['noscript'] = 'JavaScript mora biti omogućen da biste nastavili dalje!';
$string['notavailabletostudents'] = 'Napomena: Ovaj test nije još dostupan Vašim polaznicima.';
$string['notenoughrandomquestions'] = 'Nema dovoljno pitanja u kategoriji {$a->category} za kreiranje pitanja {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nije definisano dovoljno potpitanja!<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['notimedependentitems'] = 'Modul za testove trenutno ne podržava vremenski ograničena pitanja. Podesite vremenko ograničenje za čitav test. Da li želite da izaberete drugo pitanje (ili da ipak upotrebite trenutno pitanje)?';
$string['notyetgraded'] = 'Još nije ocenjeno';
$string['notyetviewed'] = 'Još nije pregledano';
$string['notyourattempt'] = 'Ovo nije Vaš pokušaj!';
$string['noview'] = 'Prijavljenom korisniku nije dozvoljeno da pregleda ovaj test';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} su načinili {$a->attemptnum} pokušaja';
$string['numattemptsmade'] = '{$a} učinjenih pokušaja rešavanja ovog testa';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeričko';
$string['numquestionsx'] = 'Pitanja: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Samo predavači mogu da izvoze pitanja';
$string['onlyteachersimport'] = 'Samo predavači sa pravima uređivanja mogu da uvoze pitanja';
$string['onthispage'] = 'Ova stranica';
$string['open'] = 'Nije odgovoreno';
$string['openclosedatesupdated'] = 'Ažurirani su datumi otvaranja i zatvaranja testa';
$string['optional'] = 'opciono';
$string['orderandpaging'] = 'Redosled pitanja i organizacija stranica';
$string['orderandpaging_help'] = 'Brojevi 10, 20, 30... pored svakog pitanja ukazuju na redosled pitanja u testu. Brojevi se povećavaju u koracima po 10 kako bi se ostavio prostor za ubacivanje dodatnih pitanja. Da biste promenili redosled pitanja, promenite broj a onda kliknite na dugme "Promeni redosled pitanja".

Da biste dodali prelom stranice nakon određenog pitanja, označite polje za potvrdu odmah pored samog pitanja a zatim kliknite na dugme "Dodaj nove stranice posle izabranih pitanja"

Da biste orgranizovali pitanja na više stranica kliknite na dugme "Reoraganizuj stranice" i izaberite željeni broj pitanja po stranici.';
$string['orderingquiz'] = 'Redosled pitanja i organizacija stranica';
$string['orderingquizx'] = 'Redosled i prelom stranica: {$a}';
$string['outcomesadvanced'] = 'Ishodi su napredna podešavanja';
$string['outof'] = '{$a->grade} od {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} od {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['overallfeedback_help'] = 'Sveobuhvatne povratne informacije predstavljaju tekst koji se prikazuje nakon rešavnja testa. Ako se dodatno odrede granične vrednosti ocena (kao procenti ili brojevi), tekst koji će biti prikazan zavisi od dobijene ocene.';
$string['overdue'] = 'Zakasneli';
$string['overduehandling'] = 'Kada vreme istekne';
$string['overduehandlingautoabandon'] = 'Pokušaji moraju biti predati pre nego što vreme istekne, ili se neće računati';
$string['overduehandlingautosubmit'] = 'Započeti pokušaji se automatski predaju';
$string['overduehandling_desc'] = 'Šta se obično događa ako polaznik ne preda test pre nego što vreme istekne.';
$string['overduehandlinggraceperiod'] = 'Postoji dodatan rok u kom se otvoreni pokušaj rešavanja može predati, ali se više ne može odgovarati na pitanja';
$string['overduehandling_help'] = 'Ovo podešavanje kontroliše šta se događa ako polaznik ne uspe da preda svoj pokušaj rešenja testa pre nego što vreme istekne. Ako polaznik aktivno rade na testu u tom trenutku, onda će tajmer automatski predati pokušaj umesto njega, ali ako je odjavljen sa sistema, onda ovo podešavanje kontroliše šta će se desiti.';
$string['overduemustbesubmittedby'] = 'Vreme za ovaj pokušaj rešavanje testa je isteklo. Pokušaj je već trebalo predati. Ako želite da ovaj test bude ocenjen morate ga predati do {$a}. Ako to ne uradite do navedenog roka, ocene za ovaj pokušaj se neće računati.';
$string['override'] = 'Izmena podešavanja testa';
$string['overridedeletegroupsure'] = 'Da li ste sigurni da želite da obrišete izmene za grupu {$a}?';
$string['overridedeleteusersure'] = 'Da li ste sigurni da želite da obrišete izmene za korisnika {$a}?';
$string['overridegroup'] = 'Izmeni podešavanja za grupu';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Izmene';
$string['overrideuser'] = 'Izmeni podešavanja za korisnika';
$string['overrideusereventname'] = '{$a->quiz} - Izmene';
$string['page-mod-quiz-attempt'] = 'Stranica pokušaja rešavanja testa';
$string['page-mod-quiz-edit'] = 'Uredi stranu testa';
$string['page-mod-quiz-report'] = 'Bilo koja stranica izveštaja o testu';
$string['page-mod-quiz-review'] = 'Pregledaj stranicu pokušaja rešavanja testa';
$string['page-mod-quiz-summary'] = 'Stranica rezimea pokušaja';
$string['page-mod-quiz-view'] = 'Stranica sa informacijama o testu';
$string['page-mod-quiz-x'] = 'Bilo koja strana test modula';
$string['pagesize'] = 'Veličina stranice';
$string['parent'] = 'Nadređeni';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parsingquestions'] = 'Parsiranje pitanja iz uvozne datoteke.';
$string['partiallycorrect'] = 'Delimično tačno';
$string['penalty'] = 'Kazneni bodovi';
$string['penaltyscheme'] = 'Primeni kaznene poene';
$string['penaltyscheme_help'] = '<p>Ako je test pokrenut u adaptivnom modu onda je polaznicima dozvoljeno da, nakon pogrešnog odgovora, pokušaju ponovo. U tom slučaju možda ćete poželeti da uvedete kaznene poene za svaki pogrešan odgovor kako biste umanjili finalnu ocenu. Vrednost kaznenih poena se određuje pojedinačno za svako pitanje prilikom podešavanja i uređivanja pitanja.</p>

<p>Ovo podešavanje je bez uticaja ukoliko test nije pokrenut u adaptivnom modu.</p>';
$string['percentcorrect'] = 'Procenat tačnosti';
$string['pleaseclose'] = 'Vaš zahtev je prosleđen. Možete da zatvorite prozor';
$string['pluginadministration'] = 'Administracija testa';
$string['pluginname'] = 'Test';
$string['popup'] = 'Prikaži test u \'sigurnom\' prozoru';
$string['popupblockerwarning'] = 'Ovaj deo testa se radi u bezbednom modu, što znači da morate rešavati test u bezbednom prozoru. Molimo isključite sve alate za sprečavanje pojave iskačućih prozora. Hvala.';
$string['popupnotice'] = 'Polaznici će videti test u \'sigurnom\' prozoru';
$string['preprocesserror'] = 'Došlo je do greške u toku preprocesiranja!';
$string['preview'] = 'Pregled';
$string['previewquestion'] = 'Pregled pitanja';
$string['previewquiz'] = 'Pregledaj {$a}';
$string['previewquiznow'] = 'Pregledaj test sada';
$string['previous'] = 'Prethodno stanje';
$string['publish'] = 'Objavi';
$string['publishedit'] = 'Da bi ste dodali ili uredili pitanja u ovoj kategoriji morate imati odgovarajuće pravo pristupa';
$string['qbrief'] = 'P. {$a}';
$string['qname'] = 'naziv';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'tip, naziv';
$string['question'] = 'Pitanje';
$string['questionbankcontents'] = 'Sadržaj banke pitanja';
$string['questionbankmanagement'] = 'Upravljanje bankom pitanja';
$string['questionbehaviour'] = 'Karakteristike pitanja';
$string['questioncats'] = 'Kategorije pitanja';
$string['questiondeleted'] = 'Ovo pitanje je obrisano. Molimo kontaktirajte svog predavača.';
$string['questioninuse'] = 'Pitanje \'{$a->questionname}\' se trenutno koristi u <br />{$a->quiznames}<br />Pitanje neće biti obrisano iz ovih testova, već samo sa spiska kategorije.';
$string['questionmissing'] = 'Nedostaje pitanje za ovu sesiju';
$string['questionname'] = 'Naziv pitanja';
$string['questionnonav'] = '<span class="accesshide">Pitanje </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pitanje {$a} nije učitano iz baze podataka';
$string['questionorder'] = 'Redosled pitanja';
$string['questionposition'] = 'Nova pozicija u redosledu za pitanje {$a}';
$string['questions'] = 'Pitanja';
$string['questionsinclhidden'] = 'Pitanja (uključujući i skrivena)';
$string['questionsinthisquiz'] = 'Pitanja u ovom testu';
$string['questionsperpage'] = 'Broj pitanja po stranici';
$string['questionsperpageselected'] = 'Broj pitanja po stranici je podešen, tako da je trenutno broj stranica fiksiran. Usled toga kontrole za reorganiѕaciju stranica su isključene. Ovo možete da promenite na {$a}.';
$string['questionsperpagex'] = 'Pitanja po jednoj stranici: {$a}';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontextisempty'] = '[Nema teksta pitanja]';
$string['questiontype'] = 'Tip pitanja {$a}';
$string['questiontypesetupoptions'] = 'Opcije podešavanja za tipove pitanja:';
$string['quiz:addinstance'] = 'Dodaj novi test';
$string['quiz:attempt'] = 'Pokušaj rešavanja testova';
$string['quizavailable'] = 'Test je dostupan do: {$a}';
$string['quizclose'] = 'Test dostupan do:';
$string['quizclosed'] = 'Test je zatvoren dana {$a}';
$string['quizcloses'] = 'Test se zatvara';
$string['quizcloseson'] = 'Ovaj test se zatvara {$a}';
$string['quiz:deleteattempts'] = 'Brisanje pokušaja rešavanja testova';
$string['quiz:emailconfirmsubmission'] = 'Dobijanje poruke sa potvrdom o predaji testa';
$string['quiz:emailnotifysubmission'] = 'Dobijanje poruke sa obaveštenjem o predaji testa';
$string['quiz:emailwarnoverdue'] = 'Dobijanje poruke sa obaveštenjem da pokušaj rešavanja testa kasni i da treba da se preda.';
$string['quiz:grade'] = 'Oceni testove ručno';
$string['quiz:ignoretimelimits'] = 'Ignoriše vremenska ograničenja testova';
$string['quizisclosed'] = 'Ovaj test je ѕatvoren';
$string['quizisclosedwillopen'] = 'Test je zatvoren (otvara se {$a})';
$string['quizisopen'] = 'Ovaj test je otvoren';
$string['quizisopenwillclose'] = 'Test je otvoren (zatvara se {$a})';
$string['quiz:manage'] = 'Upravljanje testovima';
$string['quiz:manageoverrides'] = 'Uređivanje izmena podešavanja testa';
$string['quiznavigation'] = 'Navigacija testa';
$string['quizopen'] = 'Test dostupan od:';
$string['quizopenclose'] = 'Datumi otvaranja i zatvaranja';
$string['quizopenclose_help'] = 'Polaznici mogu samo da započnu svoje pokušaje rešavanja testa nakon datuma otvaranja i moraju da ih završe pre datuma zatvaranja.';
$string['quizopened'] = 'Ovaj test je otvoren';
$string['quizopenedon'] = 'Ovaj test otvoren u {$a}';
$string['quizopens'] = 'Test se otvara dana';
$string['quizopenwillclose'] = 'Ovaj test je otvoren, biće zatovoren {$a}';
$string['quizordernotrandom'] = 'Redosled testa nije izmešan';
$string['quizorderrandom'] = '* Redosled testa je izmešan';
$string['quiz:preview'] = 'Pregledaj testova';
$string['quiz:regrade'] = 'Ponovo oceni pokušaje';
$string['quiz:reviewmyattempts'] = 'Pregledaj sopstvene pokušaje';
$string['quizsettings'] = 'Podešavanja testa';
$string['quiztimer'] = 'Praćenje utrošenog vremena';
$string['quiz:view'] = 'Pregled informacija o testu';
$string['quiz:viewreports'] = 'Pregled izveštaja o testu';
$string['quizwillopen'] = 'Ovaj test se otvara {$a}';
$string['random'] = 'Nasumično odabrano pitanje';
$string['randomcreate'] = 'Kreiraj nasumično odabrana pitanja';
$string['randomfromcategory'] = 'Nasumično odabrano pitanje iz kategorije';
$string['randomfromexistingcategory'] = 'Nasumično odabrano pitanje iz postojeće kategorije';
$string['randomnosubcat'] = 'Pitanja samo iѕ ove kategorije, ne i njenih podkategorija';
$string['randomquestionusinganewcategory'] = 'Nasumično odabrano pitanje korišćenjem nove kategorije';
$string['randomwithsubcat'] = 'Pitanja iz ove kategorije i njenih podkategorija';
$string['readytosend'] = 'Upravo ćete poslati svoje rešenje testa na ocenjivanje. Da li ste sigurni da želite da nastavite?';
$string['reattemptquiz'] = 'Ponovni pokušaj rešavanja testa';
$string['recentlyaddedquestion'] = 'Nedavno dodato pitanje!';
$string['recurse'] = 'Uključi i pitanja iz potkategorija';
$string['regrade'] = 'Ponovo oceni sve pokušaje';
$string['regradecomplete'] = 'Svi pokušaji su ponovo ocenjeni';
$string['regradecount'] = '{$a->changed} od ukupno {$a->attempt} ocena je promenjeno';
$string['regradedisplayexplanation'] = 'Pokušaji koji se menjaju tokom ponovnog ocenjivanja se prikazuju kao linkovi na prozor za pregled pitanja';
$string['regradenotallowed'] = 'Nemate dozvolu za ponovno ocenjivanje ovog testa';
$string['regradingquestion'] = 'Ponovno ocenjivanje "{$a}".';
$string['regradingquiz'] = 'Ponovno ocenjivanje testa "{$a}"';
$string['remove'] = 'Ukloni';
$string['removeallquizattempts'] = 'Izbriši sve pokušaje rešavanja testa';
$string['removeemptypage'] = 'Ukloni praznu stranicu';
$string['removeselected'] = 'Ukloni izabrane';
$string['rename'] = 'Preimenuj';
$string['renderingserverconnectfailed'] = 'Server {$a} nije uspeo da obradi RQP zahtev. Proverite da li je URL adresa tačna.';
$string['reorderquestions'] = 'Promeni redosled pitanja';
$string['reordertool'] = 'Prikaži alat za reorganizovanje';
$string['repaginate'] = 'Reorganizuj stranice sa {$a} pitanja po jednoj stranici';
$string['repaginatecommand'] = 'Reorganizuj stranice';
$string['repaginatenow'] = 'Reorganizuj stranice sad';
$string['replace'] = 'Zameni';
$string['replacementoptions'] = 'Opcije za zamenu';
$string['report'] = 'Izveštaji';
$string['reportanalysis'] = 'Analiza stavki';
$string['reportattemptsfrom'] = 'Pokušaji od';
$string['reportattemptsthatare'] = 'Pokušaji koji su';
$string['reportdisplayoptions'] = 'Opcije prikaza';
$string['reportfullstat'] = 'Detaljna statistika';
$string['reportmulti_percent'] = 'Procenti';
$string['reportmulti_q_x_student'] = 'Odgovori polaznika';
$string['reportmulti_resp'] = 'Individualni odgovori';
$string['reportmustselectstate'] = 'Morate da izaberete bar jedno stanje';
$string['reportnotfound'] = 'Izveštaj nije poznat ({$a})';
$string['reportoverview'] = 'Pregled';
$string['reportregrade'] = 'Ponovna ocena pokušaja rešavanja testa';
$string['reportresponses'] = 'Detaljni odgovori';
$string['reports'] = 'Izveštaji';
$string['reportshowonly'] = 'Prikaži samo pokušaje';
$string['reportshowonlyfinished'] = 'Prikaz najviše jednog završenog pokušaja po korisniku ({$a})';
$string['reportsimplestat'] = 'Jednostavna statistika';
$string['reportusersall'] = 'svi korisnici koji su rešavali test';
$string['reportuserswith'] = 'upisani korisnici koji su rešavali test';
$string['reportuserswithorwithout'] = 'upisani korisnici koji jesu ili nisu rešavali test';
$string['reportuserswithout'] = 'upisani korisnici koji nisu rešavali test';
$string['reportwhattoinclude'] = 'Šta uključiti u izveštaj';
$string['requirepassword'] = 'Neophodna je lozinka';
$string['requirepassword_help'] = '<p>Ovo polje nije obavezno</p>

<p>Ako ovde odredite lozinku od učesnika će se zahtevati da istu unesu pre nego što im se dozvoli da pokušaju da reše test.</p>';
$string['requiresubnet'] = 'Zahtevana mrežna adresa';
$string['requiresubnet_help'] = '<p>Ovo polje nije obavezno.</p>

<p>Možete ograničiti pristup testu samo na neke podmreže u okviru LAN mreže ili Interneta navođenjem spiska parcijalnih ili potpunih IP adresnih brojeva odvojenih zarezima.</p>

<p>To je posebno korisno za nadgledane testove, kada želite da budete sigurni da samo prisutni u određenoj prostoriji mogu da pristupe testu.</p>

<p>Na primer:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Postoje tri tipa IP brojeva koje možete koristiti (ne možete upotrebiti tekstualna imena domena, kao što je recimo primer.com):
<ol>
<li>Potpune IP adrese, kao što je <b>192.168.10.1</b>, koje će označavati pojedinačne računare (ili proxy servere).</li>
<li>Parcijalne adrese, kao što je <b>192.168</b>, koje će obuhvatati sve adrese koje počinju tim brojevima.</li>
<li>CIDR notacija, kao što je <b>231.54.211.0/20</b>, koja dozvoljava detaljniju specifikaciju podmreža.</li>
</ol>
</p>

<p>Praznine se ignorišu.</p>';
$string['response'] = 'Odgovor';
$string['responses'] = 'Odgovori polaznika';
$string['results'] = 'Rezultati';
$string['returnattempt'] = 'Povratak na pokušaj';
$string['reuseifpossible'] = 'ponovo iskoristi prethodno uklonjeno';
$string['reverttodefaults'] = 'Vrati na podrazumevana podešavanja testa';
$string['review'] = 'Pregled';
$string['reviewafter'] = 'Dozvoliti pregled nakon što se test zatvori';
$string['reviewalways'] = 'Dozvoliti pregled u bilo koje vreme';
$string['reviewattempt'] = 'Pregledaj pokušaj';
$string['reviewbefore'] = 'Dozvoliti pregled dok je test otvoren';
$string['reviewclosed'] = 'Nakon što se test zatvori';
$string['reviewduring'] = 'Tokom pokušaja rešavanja';
$string['reviewimmediately'] = 'Odmah nakon pokušaja';
$string['reviewnever'] = 'Nikad nemoj dozvoliti pregled';
$string['reviewofattempt'] = 'Pregled pokušaja {$a}';
$string['reviewofpreview'] = 'Pregled prikaza';
$string['reviewopen'] = 'Kasnije, dok je test još uvek otvoren';
$string['reviewoptions'] = 'Polaznici mogu da pregledaju';
$string['reviewoptionsheading'] = 'Opcije za pregled';
$string['reviewoptionsheading_help'] = 'Ova opcije kontrolišu koje informacije polaznici mogu da vide kada pregledaju pokušaj rešavanja testa odnosno kada gledaju izveštaj sa testa.

**U toku pokušaja** - ovo podešavanje je relevantno samo za neka ponašanja, kao što je \'interaktivno sa višestrukim pokušajima\',  koje može da prikazuje povratne informacije u toku pokušaja.

**Odmah nakon pokušaja** - ovo podešavanje se primenjuje u prva dva minuta nakon što je polaznik kliknuo na dugme \'Predaj sve i završi\'.

**Kasnije, dok je test još uvek otvoren** - ovo podešavanje se primenjuje, nakon ta prva dva minuta pa sve dok je test otvoren.

**Nakon što je test zatvoren** - ovo podešavanje se primenjuje nakon što prođe datum zatvaranja testa. Ako test nema datum zatvaranja, ovaj uslov nikada neće biti postignut.';
$string['reviewoverallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['reviewoverallfeedback_help'] = 'Povratne informacije koje se daju na kraju pokušaja rešavanja testa, u zavisnosti od ukupne ocene polaznika.';
$string['reviewresponse'] = 'Pregled odgovora';
$string['reviewresponsetoq'] = 'Pregledaj odgovore (pitanje {$a})';
$string['reviewthisattempt'] = 'Pregledaj svoj odgovor na ovaj pokušaj';
$string['rqp'] = 'Udaljeno pitanje';
$string['rqps'] = 'Udaljena pitanja';
$string['sameasoverall'] = 'Isto kao i za sveukupne ocene';
$string['save'] = 'Sačuvaj';
$string['saveandedit'] = 'Sačuvaj promene i uredi pitanja';
$string['saveattemptfailed'] = 'Neuspelo čuvanje aktuelnog pokušaja rešenja testa.';
$string['savedfromdeletedcourse'] = 'Sačuvano sa kursa "{$a}" koji je obrisan';
$string['savegrades'] = 'Sačuvaj ocene';
$string['savemyanswers'] = 'Sačuvaj moje odgovore';
$string['savenosubmit'] = 'Sačuvaj bez predavanja';
$string['saveoverrideandstay'] = 'Sačuvaj i unesi novu izmenu podešavanja';
$string['savequiz'] = 'Sačuvaj ceo test';
$string['saving'] = 'Čuvanje';
$string['savingnewgradeforquestion'] = 'Čuvanje nove ocene za pitanjе sa identifikatorom {$a}.';
$string['savingnewmaximumgrade'] = 'Čuvanje nove maksimalne ocene';
$string['score'] = 'Neobrađeni rezultat';
$string['scores'] = 'Rezultati';
$string['select'] = 'Selektuj';
$string['selectall'] = 'Selektuj sve';
$string['selectcategory'] = 'Izaberi kategoriju';
$string['selectedattempts'] = 'Izabrani pokušaji...';
$string['selectnone'] = 'Deselektuj sve';
$string['selectquestiontype'] = '-- Izbaeri tip pitanja --';
$string['serveradded'] = 'Server je dodat';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Informacije o serveru';
$string['servers'] = 'Serveri';
$string['serverurl'] = 'URL servera';
$string['settingsoverrides'] = 'Izmene podešavanja';
$string['shortanswer'] = 'Pitanje sa kratkim odgovorom';
$string['show'] = 'Prikaži';
$string['showall'] = 'Prikaži sva pitanja na jednoj stranici';
$string['showblocks'] = 'Prikaži blokove tokom rešavanja testa';
$string['showblocks_help'] = 'Ako je podešeno na \'da\', onda će u toku rešavanja testa biti prikazani  uobičajeni blokovi.';
$string['showbreaks'] = 'Prikaži prekide između stranica';
$string['showcategorycontents'] = 'Prikaži sadržaj kategorija {$a->arrow}';
$string['showcorrectanswer'] = 'Da li da se uz povratne informacije prikažu i tačni odgovori?';
$string['showdetailedmarks'] = 'Prikaži detalje ocene';
$string['showeachpage'] = 'Prikaži jednu po jednu stranicu';
$string['showfeedback'] = 'Da li da se prikažu i povratne informacije nakon davanja odgovora na pitanja?';
$string['showinsecurepopup'] = 'Upotrebiti \'bezbedni\' iskačući prozor za pokušaje';
$string['showlargeimage'] = 'Velika slika';
$string['shownoattempts'] = 'Prikaži polaznike bez pokušaja';
$string['shownoattemptsonly'] = 'Prikaži samo polaznike bez pokušaja';
$string['shownoimage'] = 'Bez slike';
$string['showreport'] = 'Prikaži izveštaj';
$string['showsmallimage'] = 'Mala slika';
$string['showteacherattempts'] = 'Prikaži pokušaje predavača da reši test';
$string['showuserpicture'] = 'Prikaži sliku korisnika';
$string['showuserpicture_help'] = 'Ako je ova opcija omogućena, ime i slika polaznika biće prikazana na ekranu tokom rešavanja testa, kao i prilikom pregleda. Ovo olakšava proveru identiteta prijavljenog polaznika, na testovima koji se rade u učionici (npr. na završnom testu).';
$string['shuffle'] = 'Izmešaj';
$string['shuffleanswers'] = 'Izmešaj odgovore';
$string['shuffledrandomly'] = 'Nasumično izmešano';
$string['shufflequestions'] = 'Izmešaj pitanja';
$string['shufflequestionsselected'] = 'S obzirom da je opcija za mešanje pitanja uključena, neke akcije koje se tiču stranica nisu dostupne. Za promenu opcije mešanja, {$a}.';
$string['shufflewithin'] = 'Izmešaj u okviru pitanja';
$string['shufflewithin_help'] = 'Ako omogućite ovu opciju, delovi od kojih se sastoje pojedinačna pitanja biće nasumično izmešani svaki put kad polaznik pokuša da reši ovaj test, pod uslovom da je ista opcija omogućena i u podešavanjima samih pitanja. Ovo podešavanje se primenjuje samo na pitanja koja se sastoje iz više delova, kao što su pitanja tipa višestrukog izbora ili pitanja sa sparivanjem odgovora.';
$string['singleanswer'] = 'Odaberite jedan odgovor';
$string['sortage'] = 'Sortiraj po vremenu kreiranja';
$string['sortalpha'] = 'Sortiraj po imenu';
$string['sortquestionsbyx'] = 'Poređaj pitanja po {$a}';
$string['sortsubmit'] = 'Sortiraj pitanja';
$string['sorttypealpha'] = 'Sortiraj po tipu, imenu';
$string['specificapathnotonquestion'] = 'Zadata putanja datoteke nije na datom pitanju';
$string['specificquestionnotonquiz'] = 'Zadato pitanje nije u datom testu';
$string['startagain'] = 'Počni ponovo';
$string['startattempt'] = 'Započni pokušaj rešavanja';
$string['startedon'] = 'Započeto';
$string['startnewpreview'] = 'Započnite novi pregled';
$string['stateabandoned'] = 'Nikad predato';
$string['statefinished'] = 'Završeno';
$string['statefinisheddetails'] = 'Predato {$a}';
$string['stateinprogress'] = 'U toku';
$string['statenotloaded'] = 'Stanje za pitanje  {$a} nije učitano iz baze podataka';
$string['stateoverdue'] = 'Zakasnela predaja';
$string['stateoverduedetails'] = 'Mora se predati do {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stani pri pojavi greške';
$string['submitallandfinish'] = 'Predaj sve odgovore i završi test';
$string['subneterror'] = 'Nažalost, ovaj test je zaključan, odnosno dostupan je samo sa pojedinih lokacija. Trenutno Vaš računar nije jedan od onih kojima je dozvoljeno da koriste ovaj test.';
$string['subnetnotice'] = 'Ovom testu se može pristupiti samo sa određenih mesta. Vaš računar se ne nalazi u mreži sa koje je pristup dozvoljen. Ipak, kao predavač svakako možete da pregledate test.';
$string['subplugintype_quiz'] = 'Izveštaj';
$string['subplugintype_quizaccess'] = 'Pravilo za pristup testu';
$string['subplugintype_quizaccess_plural'] = 'Pravila za pristup testu';
$string['subplugintype_quiz_plural'] = 'Izveštaji';
$string['substitutedby'] = 'biće zamenjeno sa';
$string['summaryofattempt'] = 'Rezime pokušaja';
$string['summaryofattempts'] = 'Rezime vaših prethodnih pokušaja';
$string['temporaryblocked'] = 'Privremeno Vam nije dozvoljeno da ponovo pokušate da rešite test.<br /> Moći ćete ponovo da mu pristupite dana:';
$string['theattempt'] = 'Pokušaj rešavanja';
$string['theattempt_help'] = 'Da li polaznik uopšte može da pregleda pokušaj.';
$string['time'] = 'Vreme';
$string['timecompleted'] = 'Završeno';
$string['timedelay'] = 'Nije Vam dozvoljeno da radite test jer još nije prošao zadati razmak od Vašeg poslednjeg do sledećeg mogućeg pokušaja rešavanja drugog testa.';
$string['timeleft'] = 'Preostalo vreme';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimitexeeded'] = 'Nažalost, vreme za rešavanje testa je isteklo!';
$string['timelimit_help'] = 'Ako je ova opcija omogućena, na početnoj stranici testa biće navedeno vremensko ograničenje, a u bloku za navigaciju testa biće prikazan tajmer.';
$string['timelimitmin'] = 'Vremensko ograničenje (u minutima)';
$string['timelimitsec'] = 'Vremensko ograničenje (sekunde)';
$string['timestr'] = '%H:%M:%S dana %d.%m.%y.';
$string['timesup'] = 'Vreme je isteklo!';
$string['timetaken'] = 'Utrošeno vreme';
$string['timing'] = 'Podešavanje vremena';
$string['tofile'] = 'u datoteku';
$string['tolerance'] = 'Tolerancija';
$string['toomanyrandom'] = 'Broj slučajnih pitanja potrebnih za test je veći od ukupnog broja pitanja raspoloživih u zadatoj kategoriji!';
$string['top'] = 'Najviši nivo';
$string['totalmarksx'] = 'Ukupno ocena: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Ukupno {$a} pitanja u kategoriji.';
$string['true'] = 'Tačno';
$string['truefalse'] = 'Tačno/Netačno';
$string['type'] = 'Tip';
$string['unfinished'] = 'otvoreno';
$string['ungraded'] = 'Neocenjeno';
$string['unit'] = 'Jedinica';
$string['unknowntype'] = 'Tip pitanja koji nije podržan u liniji {$a}. Ovo pitanje će biti ignorisano.';
$string['unusedcategorydeleted'] = 'Nakon brisanja kursa, ova kategorija je, takođe, obrisana, zbog toga što se pitanja iz ove kategorija ne koriste u testovima drugih kurseva.';
$string['updatesettings'] = 'Ažuriraj podešavanja testa';
$string['updatingatttemptgrades'] = 'Ažuriranje ocena pokušaja';
$string['updatingfinalgrades'] = 'Ažuriranje konačnih ocena';
$string['updatingthegradebook'] = 'Ažuriranje knjige ocena';
$string['upgradesure'] = '<div>Modul \'Test\' će izvesti obimne promene tabela sa testovima u bazi podataka. Ova nadogradnja još uvek nije dovoljno testirana. Pre nego što nastavite strogo vam preporučujemo da napravite rezervnu kopiju vaše baze podataka.</div>';
$string['upgradingquizattempts'] = 'Nadogradnja pokušaja rešavanja testa: test {$a->done}/{$a->outof} (Identifikator testa {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Nadogradnja vrlo starih pokušaja rešavanja testa: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Nakon brisanja kursa, ova kategorija je sačuvana i premeštena na nivo sajta, zbog toga što se pitanja iz ove kategorije koriste u testovima drugih kurseva.';
$string['useroverrides'] = 'Izmene za korisnike';
$string['usersnone'] = 'Nijedan polaznik nema pristup ovom testu';
$string['validate'] = 'Proveri';
$string['viewallanswers'] = 'Prikaz {$a} pokušaja rešavanja testa';
$string['viewallreports'] = 'Pogledaj izveštaje za {$a} pokušaja';
$string['viewed'] = 'Pregledano';
$string['warningmissingtype'] = '<b>Ovo pitanje pripada tipu koji još uvek nije instaliran na vašem Moodleu.<br />Molimo obavestite svog Moodle administratora.</b>';
$string['wheregrade'] = 'Gde je moja ocena?';
$string['wildcard'] = 'Džoker znak';
$string['windowclosing'] = 'Ovaj prozor će se ubrzo zatvoriti.';
$string['withsummary'] = 'sa sumarnom statistikom';
$string['wronguse'] = 'Ne možete tako da koristite ovu stranicu';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Potrebno je da se upišete na ovaj kurs pre nego što pokušate rešavanje ovog testa';
$string['yourfinalgradeis'] = 'Vaša konačna ocena na ovom testu je {$a}.';
