<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   moodle
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'će upravo biti instalirano';
$string['action'] = 'Akcija';
$string['actionchoice'] = 'Šta želite da uradite sa datotekom \'{$a}\'?

&strings=1';
$string['actions'] = 'Akcije';
$string['active'] = 'Aktivan';
$string['activeusers'] = 'Aktivni korisnici';
$string['activities'] = 'Aktivnosti';
$string['activities_help'] = 'Aktivnosti, kao što su forumi, testovi i viki dokumenti omogućavaju da kursu bude dodat interaktivni sadržaj.';
$string['activity'] = 'Aktivnost';
$string['activityclipboard'] = 'Premeštanje ove aktivnosti: {$a}';
$string['activityiscurrentlyhidden'] = 'Nažalost, ova aktivnost trenutno nije dostupna';
$string['activitymodule'] = 'Modul aktivnosti';
$string['activitymodules'] = 'Moduli aktivnosti';
$string['activityreport'] = 'Izveštaj o aktivnosti';
$string['activityreports'] = 'Izveštaji o aktivnostima';
$string['activityselect'] = 'Odaberite ovu aktivnost kako biste je premestili na drugu lokaciju';
$string['activitysince'] = 'Aktivnost od {$a}';
$string['activityweighted'] = 'Aktivnost po korisniku';
$string['add'] = 'Dodaj';
$string['addactivity'] = 'Dodaj aktivnost...';
$string['addactivitytosection'] = 'Dodaj aktivnost u sekciju \'{$a}\'';
$string['addadmin'] = 'Dodaj administratora';
$string['addblock'] = 'Dodaj blok';
$string['addcomment'] = 'Dodaj komentar...';
$string['addcountertousername'] = 'Kreiraj korisnika dodavanjem broja korisničkom imenu';
$string['addcreator'] = 'Dodaj kreatora kursa';
$string['adddots'] = 'Dodaj...';
$string['added'] = 'Dodato {$a}';
$string['addedrecip'] = 'Dodat je novi primalac: {$a}';
$string['addedrecips'] = 'Broj novih primalaca: {$a}';
$string['addedtogroup'] = 'Dodat(а) grupi {$a}';
$string['addedtogroupnot'] = 'Nije dodat(а) grupi {$a}';
$string['addedtogroupnotenrolled'] = 'Nije dodat(a) grupi {$a}, jer nije upisan(a) na kurs';
$string['addfilehere'] = 'Dodaj datoteku/e ovde';
$string['addinganew'] = 'Dodavanje aktivnosti: {$a}';
$string['addinganewto'] = 'Dodavanje aktivnosti u {$a->to}';
$string['addingdatatoexisting'] = 'Dodavanje podataka postojećim';
$string['additionalnames'] = 'Dodatna imena';
$string['addlinkhere'] = 'Dodaj link ovde';
$string['addnewcategory'] = 'Dodaj novu kategoriju';
$string['addnewcourse'] = 'Dodaj novi kurs';
$string['addnewuser'] = 'Dodaj novog korisnika';
$string['addnousersrecip'] = 'Dodavanje korisnika koji nije pristupio ovome {$a} na listu primalaca';
$string['addpagehere'] = 'Dodaj tekst ovde';
$string['addresource'] = 'Dodaj resurs...';
$string['addresourceoractivity'] = 'Dodaj aktivnost ili resurs';
$string['addresourcetosection'] = 'Dodaj resurs u sekciju \'{$a}\'';
$string['address'] = 'Adresa';
$string['addstudent'] = 'Dodaj polaznika';
$string['addsubcategory'] = 'Dodaj potkategoriju';
$string['addteacher'] = 'Dodaj predavača';
$string['admin'] = 'Administracija';
$string['adminhelpaddnewuser'] = 'Ručno kreiranje novog korisničkog naloga';
$string['adminhelpassignadmins'] = 'Administratori imaju potpuna ovlašćenja na ovom sajtu';
$string['adminhelpassigncreators'] = 'Kreatori mogu kreirati nove kurseve i predavati unutar istih';
$string['adminhelpassignsiteroles'] = 'Primena definisanih uloga na sajtu na specificirane korisnike';
$string['adminhelpassignstudents'] = 'Idite na kurs i dodajte nove polaznike iz administratorskog menija';
$string['adminhelpauthentication'] = 'Možete koristiti interne korisničke naloge ili eksterne baze podataka';
$string['adminhelpbackup'] = 'Konfigurišite automatsko kreiranje rezervnih kopija i vremenski raspored njihovog izvršavanja';
$string['adminhelpconfiguration'] = 'Konfigurišite kako sajt izgleda i funkcioniše';
$string['adminhelpconfigvariables'] = 'Konfigurišite promenljive koje utiču na opštu funkcionalnost sajta';
$string['adminhelpcourses'] = 'Odredite kurseve i kategorije i upišite polaznike u njih, uredite kurseve na čekanju';
$string['adminhelpeditorsettings'] = 'Definišite osnovna podešavanja HTML editora';
$string['adminhelpedituser'] = 'Pretražite listu korisničkih naloga i uredite bilo koji od njih';
$string['adminhelpenvironment'] = 'Proverite kako Vaš server zadovoljava trenutne i buduće preduslove za uspešnu instalaciju';
$string['adminhelpfailurelogs'] = 'Pregledajte zapise o neuspešnim prijavama na sistem';
$string['adminhelplanguage'] = 'Provera i uređivanje važećeg jezičkog paketa';
$string['adminhelplogs'] = 'Pregledajte zapise o svim aktivnostima na sajtu';
$string['adminhelpmanageblocks'] = 'Upravljanje instaliranim blokovima i njihovim podešavanjima';
$string['adminhelpmanagedatabase'] = 'Direktno pristupite bazi podataka (ali oprezno!)';
$string['adminhelpmanagefilters'] = 'Izbor tekstualnih filtera i njihova podešavanja';
$string['adminhelpmanagemodules'] = 'Upravljanje instaliranim modulima i njihovim podešavanjima';
$string['adminhelpmanageroles'] = 'Kreiranje i definisanje uloga koje se mogu primeniti na korisnike';
$string['adminhelpmymoodle'] = 'Konfigurišite "Moj Moodle" blokove za korisnike';
$string['adminhelpreports'] = 'Izveštaji na nivou sajta';
$string['adminhelpsitefiles'] = 'Služi za objavljivanje opštih datoteka ili postavljanje rezervnih kopija';
$string['adminhelpsitesettings'] = 'Definišite kako izgleda početna stranica sajta';
$string['adminhelpstickyblocks'] = 'Konfigurišite fiksne blokove na čitavom sajtu';
$string['adminhelpthemes'] = 'Izaberite kako da izgleda sajt (boje, fontovi i sl.)';
$string['adminhelpuploadusers'] = 'Uvezite nove korisničke naloge iz tekstualne datoteke';
$string['adminhelpusers'] = 'Odredite svoje korisnike i podesite način provere identiteta';
$string['adminhelpxmldbeditor'] = 'Interfejs za uređivanje XMLDB datoteka. Samo za korisnike sa uređivačkim pravima.';
$string['administration'] = 'Administracija';
$string['administrationsite'] = 'Administracija sajta';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratori obično mogu da rade šta god žele u okviru sajta, na bilo kom kursu.';
$string['administrators'] = 'Administratori';
$string['administratorsall'] = 'Svi administratori';
$string['administratorsandteachers'] = 'Administratori i predavači';
$string['advanced'] = 'Napredno';
$string['advancedfilter'] = 'Napredno pretraživanje';
$string['advancedsettings'] = 'Napredna podešavanja';
$string['afterresource'] = 'Posle resursa "{$a}"';
$string['aftersection'] = 'Posle sekcije "{$a}"';
$string['again'] = 'ponovo';
$string['aimid'] = 'AIM ID';
$string['ajaxuse'] = 'AJAX i Javascript';
$string['all'] = 'Sve';
$string['allactions'] = 'Sve akcije';
$string['allactivities'] = 'Sve aktivnosti';
$string['allcategories'] = 'Sve kategorije';
$string['allchanges'] = 'Sve promene';
$string['alldays'] = 'Svi dani';
$string['allfieldsrequired'] = 'Sva polja su obavezna';
$string['allfiles'] = 'Sve datoteke';
$string['allgroups'] = 'Sve grupe';
$string['alllogs'] = 'Svi zapisi o aktivnostima';
$string['allmods'] = 'Svi {$a}';
$string['allow'] = 'Dozvoliti';
$string['allowinternal'] = 'Dozvoliti i interne načine autorizacije';
$string['allownone'] = 'Ne dozvoliti ništa';
$string['allownot'] = 'Ne dozvoliti';
$string['allparticipants'] = 'Svi učesnici';
$string['allteachers'] = 'Svi predavači';
$string['alphanumerical'] = 'Može jedino da sadrži alfanumeričke karaktere (slova i brojeve), crticu (-) ili tačku (.)';
$string['alreadyconfirmed'] = 'Registracija je već potvrđena';
$string['alternatename'] = 'Alternativno ime';
$string['always'] = 'Uvek';
$string['and'] = '{$a->one} i {$a->two}';
$string['answer'] = 'Odgovor';
$string['any'] = 'Bilo koje';
$string['appearance'] = 'Izgled';
$string['approve'] = 'Odobri';
$string['areyousure'] = 'Da li ste sigurni?';
$string['areyousuretorestorethis'] = 'Želite li da nastavite?';
$string['areyousuretorestorethisinfo'] = 'Tokom ovog postupka moći ćete odabrati da li želite da dodate ovu datoteku sa rezervnim kopijama već postojećem kursu ili da kreirate potpuno novi kurs.';
$string['asc'] = 'Rastući';
$string['assessment'] = 'Procena';
$string['assignadmins'] = 'Određivanje administratora';
$string['assigncreators'] = 'Određivanje kreatora';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Određivanje uloga na nivou sajta';
$string['authenticateduser'] = 'Autorizovani korisnik';
$string['authenticateduserdescription'] = 'Svi trenutno prijavljeni korisnici';
$string['authentication'] = 'Provera identiteta';
$string['authenticationplugins'] = 'Dodaci za autentikaciju';
$string['autosubscribe'] = 'Automatska prijava na forum';
$string['autosubscribeno'] = 'Ne: ne želim automatsku prijavu na forume';
$string['autosubscribeyes'] = 'Da: kad pošaljem poruku, prijavi me na taj forum';
$string['availability'] = 'Dostupnost';
$string['availablecourses'] = 'Dostupni kursevi';
$string['back'] = 'Nazad';
$string['backto'] = 'Nazad na {$a}';
$string['backtocourselisting'] = 'Povratak na listu kurseva';
$string['backtopageyouwereon'] = 'Povratak na stranicu na kojoj ste bili';
$string['backtoparticipants'] = 'Povratak na listu učesnika';
$string['backup'] = 'Kreiranje rezervne kopije';
$string['backupactivehelp'] = 'Izaberite da li treba ili ne treba automatski kreirati rezervne kopije.';
$string['backupcancelled'] = 'Kreiranje rezervne kopije je otkazano';
$string['backupcoursefileshelp'] = 'Ako je ovo podešavanje omogućeno,  datoteke kursa će biti uključene u automatski kreirane rezervne kopije';
$string['backupdate'] = 'Datum kreiranja rezervne kopije';
$string['backupdatenew'] = '&nbsp; {$a->TAG} sada je {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bio je {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detalji o rezervnoj kopiji';
$string['backupexecuteathelp'] = 'Izaberite vreme za automatsko kreiranje rezervnih kopija.';
$string['backupfailed'] = 'Neki od Vaših kurseva nisu sačuvani!';
$string['backupfilename'] = 'rezervna kopija';
$string['backupfinished'] = 'Kreiranje rezervne kopije je uspešno završeno';
$string['backupfromthissite'] = 'Da li je rezervna kopija kreirana na ovom sajtu?';
$string['backupgradebookhistoryhelp'] = 'Ako je ovo podešavanje omogućeno, onda će istorija knjige ocena biti uključena u automatsku rezervnu kopiju. Imajte u vidu, da istorija ocena ne sme biti onemogućena u podešavanjima servera (disablegradehistory) kako bi ovo moglo da funkcioniše.';
$string['backupincludemoduleshelp'] = 'Odaberite želite li u automatsku proceduru kreiranja rezervnih kopija da uključite i module kursa, sa ili bez korisničkih podataka';
$string['backupincludemoduleuserdatahelp'] = 'Izaberite da li želite da uključite podatke korisnika modula u automatski kreirane rezervne kopije.';
$string['backupkeephelp'] = 'Koliki broj skorašnjih rezervnih kopija za svaki kurs želite da čuvate? (Starije kopije biće automatski obrisane po isteku navedenog roka)';
$string['backuplogdetailed'] = 'Detaljni izveštaj o izvršavanju';
$string['backuploglaststatus'] = 'Izveštaj o poslednjem izvršavanju';
$string['backupmissinguserinfoperms'] = 'Napomena: ova rezervna kopija podataka ne sadrži korisničke podatke. Aktivnosti kao što su Vežba i Radionica neće biti uključene u rezervnu kopiju, s obzirom da ovi moduli nisu kompatibilni sa ovim tipom rezervne kopije podataka.';
$string['backupnext'] = 'Sledeća rezervna kopija';
$string['backupnonisowarning'] = 'Upozorenje: ova rezervna kopija je kreirana u verziji Moodle sistema koja nije podržavala Unicode (pre verzije 1.6). Ako ova rezervna kopija sadrži tekstove koji se ne slažu sa ISO-8859-1 može biti OŠTEĆENA ako pokušate da je restaurirate u ovoj Unicode Moodle verziji. Pogledajte <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a>za više informacija o tome kako da pravilno uradite oporavak ove rezervne kopije.';
$string['backupnotyetrun'] = 'Automatska rezervna kopije na čekanju';
$string['backuporiginalname'] = 'Naziv rezervne kopije';
$string['backuproleassignments'] = 'Napravi rezervnu kopiju dodele ovih uloga';
$string['backupsavetohelp'] = 'Puna putanja do direktorijuma u kojem želite da sačuvate datoteke sa rezervnim kopijama<br /> (ostavite ovo polje prazno kako biste podatke sačuvali u podrazumevani direktorijum za čuvanje svih podataka vezanih za ovaj kurs)';
$string['backupsitefileshelp'] = 'Ako je ovo podešavanje omogućeno, onda će datoteke sajta korišćene u kursevima biti uključeni u automatsku rezervnu kopiju.';
$string['backuptakealook'] = 'Molimo pregledajte svoje izveštaje o kreiranju rezervnih kopija u: {$a}';
$string['backupuserfileshelp'] = 'Odaberite da li bi trebalo da se korisničke datoteke (npr. slike za lične profile korisnika) uključe u automatski kreirane rezervne kopije';
$string['backupversion'] = 'Verzija rezervne kopije';
$string['badges'] = 'Bedževi';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurisanje bloka {$a}';
$string['blockconfigbad'] = 'Ovaj blok nije pravilno implementiran i zato ne možete koristiti konfiguracioni interfejs';
$string['blocks'] = 'Blokovi';
$string['blocksaddedit'] = 'Dodaj/Uredi blokove';
$string['blockseditoff'] = 'Isključi uređivanje blokova';
$string['blocksediton'] = 'Uključi uređivanje blokova';
$string['blocksetup'] = 'Podešavanje tabela blokova';
$string['blocksuccess'] = '{$a} tabela je ispravno podešena';
$string['brief'] = 'Ukratko';
$string['bulkactions'] = 'Masovne akcije';
$string['bulkactionselect'] = 'Odabir zbirne akcije {$a}';
$string['bulkmovecoursessuccess'] = 'Uspešno je premešteno {$a->courses} kurs(ev)a u {$a->category}';
$string['bycourseorder'] = 'Poredak po kursevima';
$string['byname'] = 'od {$a}';
$string['bypassed'] = 'Izbegnuto';
$string['cachecontrols'] = 'Kontrola keširanja';
$string['cancel'] = 'Odustani';
$string['cancelled'] = 'Otkazano';
$string['categories'] = 'Kategorije kurseva';
$string['categoriesandcoures'] = 'Kategorije kurseva i kursevi';
$string['category'] = 'Kategorija';
$string['categoryadded'] = 'Dodata je kategorija \'{$a}\'';
$string['categorybulkaction'] = 'Masovne akcije za izabrane kategorije';
$string['categorycontents'] = 'Podkategorije i kursevi';
$string['categorycurrentcontents'] = 'Sadržaji kategorije {$a}';
$string['categorydeleted'] = 'Obrisana je kategorija \'{$a}\'';
$string['categoryduplicate'] = 'Kategorija pod nazivom \'{$a}\' već postoji';
$string['categorymodifiedcancel'] = 'Kategorija je izmenjena! Molimo Vas da izađete i pokušate ponovo.';
$string['categoryname'] = 'Naziv kategorije';
$string['categorysubcategoryof'] = '{$a->category} - potkategorija kategorije {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorija \'{$a}\' je ažurirana';
$string['changedpassword'] = 'Lozinka je promenjena';
$string['changepassword'] = 'Promena lozinke';
$string['changesmadereallygoaway'] = 'Napravili ste promene. Da li ste sigurni da želite da odete odavde  i izgubiti svoje promene?';
$string['changessaved'] = 'Promene su sačuvane';
$string['check'] = 'Proveri';
$string['checkall'] = 'Proveri sve';
$string['checkingbackup'] = 'Provera rezervne kopije';
$string['checkingcourse'] = 'Provera kursa';
$string['checkingforbbexport'] = 'Provera BlackBoard izvoza podataka';
$string['checkinginstances'] = 'Provera instanci';
$string['checkingsections'] = 'Provera sekcija';
$string['checklanguage'] = 'Provera jezika';
$string['checknone'] = 'Bez provera';
$string['childcoursenotfound'] = 'Podređeni kurs nije pronađen!';
$string['childcourses'] = 'Podređeni kursevi';
$string['choose'] = 'Izaberi';
$string['choosecourse'] = 'Izbor kursa';
$string['choosedots'] = 'Izaberi...';
$string['chooselivelogs'] = 'Ili nadgledajte trenutnu aktivnost';
$string['chooselogs'] = 'Izbor zapisa o aktivnostima koji želite da vidite';
$string['choosereportfilter'] = 'Izbor filtera za izveštaj';
$string['choosetheme'] = 'Izaberite grafičku temu';
$string['chooseuser'] = 'Izbor korisnika';
$string['city'] = 'Mesto';
$string['clambroken'] = 'Vaš administrator je uključio antivirusnu proveru pri postavljanju datoteka, ali je nažalost nešto pogrešno konfigurisao.<br /> Postavljanje Vaše datoteke NIJE bilo uspešno. Administratoru je upućena automatska e-poruka od strane sistema i očekujemo negove ispravke podešavanja. <br /> Molimo pokušajte učitavanje te datoteke nešto kasnije.';
$string['clamdeletedfile'] = 'Datoteka je obrisana';
$string['clamdeletedfilefailed'] = 'Datoteka nije mogla biti obrisana';
$string['clamemailsubject'] = '{$a} :: Clam AV obaveštenje';
$string['clamfailed'] = 'Clam AV se nije mogao pokrenuti. Obaveštenje o grešci je sledeće: {$a}. Sledi Clam AV izlaz:';
$string['clamlost'] = 'Moodle je konfigurisan tako da proverava postavljanje datoteka s Clam AV alatom, ali je podešena putanja ({$a}) do Clam AV alata netačna.';
$string['clamlostandactinglikevirus'] = 'Pored toga, Moodle je konfigurisan tako da ukoliko Clam AV ne uspe da bude pokrenut, datoteke će biti tretirane kao virusi. Ovo u praksi znači da NIJEDAN polaznik ne može poslati datoteku na server sve dok ne rešite ovaj problem.';
$string['clammovedfile'] = 'Datoteka je premeštena u specificirani karantinski direktorijum, nova lokacija je {$a}';
$string['clammovedfilebasic'] = 'Datoteka je premeštena u karantinski direktorijum.';
$string['clamquarantinedirfailed'] = 'Nije bilo moguće premestiti datoteku u specificirani karantinski direktorijum {$a}. Trebali biste ovo popraviti jer se datoteke automatski brišu ako se pronađu kao zaražene.';
$string['clamunknownerror'] = 'Nepoznata greška pri korišćenju Clam-a.';
$string['cleaningtempdata'] = 'Brisanje privremenih podataka';
$string['clear'] = 'Obriši';
$string['clickhelpiconformoreinfo'] = '... nastavlja se... Kliknite na ikonicu za pomoć kako biste pročitali ceo članak';
$string['clickhere'] = 'Klikni ovde ...';
$string['clicktochangeinbrackets'] = '{$a} (Klikni za promenu)';
$string['clicktohideshow'] = 'Kliknite da biste raširili ili skupili';
$string['closebuttontitle'] = 'Zatvori';
$string['closewindow'] = 'Zatvorite ovaj prozor';
$string['collapse'] = 'Skupi';
$string['collapseall'] = 'Skupi sve';
$string['collapsecategory'] = 'Skupi {$a}';
$string['commentincontext'] = 'Pronađi ovaj komentar u kontekstu';
$string['comments'] = 'Komentari';
$string['commentsnotenabled'] = 'Komentarisanje nije omogućeno';
$string['commentsrequirelogin'] = 'Potrebno je da se prijavite na sistem kako biste videli komentare';
$string['comparelanguage'] = 'Uporedite i uredite trenutno odabrani jezik';
$string['complete'] = 'Potpuno';
$string['completereport'] = 'Potpuni izveštaj';
$string['configuration'] = 'Konfiguracija';
$string['confirm'] = 'Potvrdi';
$string['confirmcheckfull'] = 'Da li ste apsolutni sigurni da želite da potvrdite {$a}?';
$string['confirmcoursemove'] = 'Da li ste sigurni da želite da premestite kurs ({$a->course}) u ovu kategoriju ({$a->category})?';
$string['confirmed'] = 'Vaša registracija je potvrđena';
$string['confirmednot'] = 'Vaša registracija još nije potvrđena!';
$string['content'] = 'Sadržaj';
$string['continue'] = 'Nastavi';
$string['continuetocourse'] = 'Kliknite ovde da biste ušli na svoj kurs';
$string['convertingwikitomarkdown'] = 'Pretvaranje wiki formata u Markdown format';
$string['cookiesenabled'] = 'Vaš Web čitač mora imati omogućene "kolačiće"';
$string['cookiesenabled_help'] = 'Na ovom sajtu se koriste dva kolačića (<i>cookies</i>):

Osnovni je kolačić sesije (<i>session cookie</i>), koji se obično zove MoodleSession. U vašem Web čitaču morate dozvoliti upotrebu ovog kolačića, kako biste obezbedili kontinuiranu prijavu na sistem pri prelasku sa jedne na drugu stranicu sajta. Kada se odjavite sa sistema ili zatvorite Web čitač kolačić se uništava (i u vašem Web čitaču i na serveru).

Drugi kolačić je tu čisto zbog komfora u radu i obično se naziva MOODLEID. On samo pamti vaše korisničko ime unutar Web čitača. To znači, da će, kada se bude vratili na ovaj sajt, polje za unos korisničkog imena na stranicu za prijavu, automatski biti popunjeno Vašim korisničkim imenom. Iz razloga bezbednosti (naročito kada Internetu pristupate sa javnog računara) bolje je da odbijete ovaj kolačić - u tom slučaju ćete morati da unesete svoje korisničko ime svaki put kada se budete prijavljivali na sistem.';
$string['cookiesnotenabled'] = 'Nažalost, "kolačići" nisu omogućeni u Vašem Web čitaču';
$string['copy'] = 'kopiranje';
$string['copyasnoun'] = 'kopiranje';
$string['copyingcoursefiles'] = 'Kopiranje datoteka kursa';
$string['copyingsitefiles'] = 'Kopiranje fajlova sa sajta koji su korišćeni u kursu';
$string['copyinguserfiles'] = 'Kopiranje korisničkih datoteka';
$string['copyingzipfile'] = 'Kopiranje zip datoteka';
$string['copyrightnotice'] = 'Napomena o zaštiti autorskih prava';
$string['coresystem'] = 'Sistem';
$string['cost'] = 'Cena';
$string['costdefault'] = 'Podrazumevana cena';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Država';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Administracija kursa';
$string['courseapprovedemail'] = 'Zahtev za kursom, {$a->name}, koji ste podneli je odobren, kurs je kreiran i Vama je dodeljena sledeća uloga na njemu: {$a->teacher}. Da biste pristupili svom novom kursu, idite na {$a->url}';
$string['courseapprovedemail2'] = 'Kurs koji ste tražili, {$a->name}, je odobren. Da biste pristupili Vašem novom kursu idite na {$a->url}';
$string['courseapprovedfailed'] = 'Nije uspelo čuvanje kursa onako kako je odobreno!';
$string['courseapprovedsubject'] = 'Vaš kurs je odobren!';
$string['courseavailable'] = 'Ovaj kurs je dostupan polaznicima';
$string['courseavailablenot'] = 'Ovaj kurs nije dostupan polaznicima';
$string['coursebackup'] = 'Rezervna kopija kursa';
$string['coursebulkaction'] = 'Masovne akcije za izabrane kurseve';
$string['coursecategories'] = 'Kategorije kurseva';
$string['coursecategory'] = 'Kategorija kursa';
$string['coursecategorydeleted'] = 'Obrisana kategorija {$a}';
$string['coursecategory_help'] = 'Ovo podešavanje određuje kategoriju u kojoj će se kurs pojaviti na spisku kurseva.';
$string['coursecatmanagement'] = 'Upravljanje kursom i kategorijom';
$string['coursecompletion'] = 'Završenost kursa';
$string['coursecompletions'] = 'Završenost kurseva';
$string['coursecreators'] = 'Kreator kursa';
$string['coursecreatorsdescription'] = 'Kreatori kurseva mogu da kreiraju nove kurseve i predaju na njima.';
$string['coursedeleted'] = 'Obrisan kurs {$a}';
$string['coursedisplay'] = 'Prelom stranice kursa';
$string['coursedisplay_help'] = 'Ova podešavanje određuje da li će ceo kurs biti prikazan na jednoj stranici ili će biti podeljen na nekoliko stranica.';
$string['coursedisplay_multi'] = 'Prikaži jednu sekciju po stranici';
$string['coursedisplay_single'] = 'Prikaži sve sekcije na jednoj stranici';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Nasleđene datoteke kursa';
$string['coursefilesedit'] = 'Uredi nasleđene datoteke kursa';
$string['coursefileswarning'] = 'Datoteke kursa su zastarele';
$string['coursefileswarning_help'] = 'Opcija \'Datoteke kursa\' se ne koristi od verzije Moodle 2.0, Molimo da umesto toga koristite spoljašnje repozitorijume što je više moguće.';
$string['courseformatdata'] = 'Podaci o formatu kursa';
$string['courseformatoptions'] = 'Opcije za formatiranje - {$a}';
$string['courseformats'] = 'Formati kursa';
$string['courseformatudpate'] = 'Ažuriraj format';
$string['coursegrades'] = 'Ocene na kursu';
$string['coursehelpcategory'] = 'Postavite kurs na listi kurseva tako da polaznici mogu lakše da ga pronađu.';
$string['coursehelpforce'] = 'Obavezan grupni mod za sve aktivnosti na kursu';
$string['coursehelpformat'] = 'Glavna stranica kursa biće prikazana u ovom formatu.';
$string['coursehelphiddensections'] = 'Kako će skrivene sekcije kursa biti prikazane polaznicima';
$string['coursehelpmaximumupload'] = 'Odredite maksimalnu veličinu datoteke koja se može postaviti u okviru kursa. Ova veličina je ograničena podešavanjem na nivou sajta.';
$string['coursehelpnewsitemsnumber'] = 'Broj najnovijih vesti koji će se pojaviti na početnoj stranici kursa, u bloku Vesti. Ako je podešeno na  0, blok sa najnovijim vestima neće biti prikazan.';
$string['coursehelpnumberweeks'] = 'Broj sekcija unutar kursa (važi samo za određene formate kursa).';
$string['coursehelpshowgrades'] = 'Omogući prikaz knjige sa ocenama. Ovo ne sprečava da ocene budu prikazane unutar pojedinačnih aktivnosti.';
$string['coursehidden'] = 'Ovaj kurs trenutno nije dostupan polaznicima';
$string['courseinfo'] = 'Informacije o kursu';
$string['courselegacyfiles'] = 'Izvorne datoteke kursa';
$string['courselegacyfiles_help'] = 'Područje datoteka kursa obezbeđuje izvesnu kompatibilnost sa Moodle 1.9 i starijim verzijama. Sve datoteke u ovom području uvek su dostupne svim učesnicima kursa (nezavisno od toga da li su povezani sa kursom ili ne) i ne postoji način da se sazna gde je bilo koja od ovih datoteka korišćena u Moodleu.

Ako ovo područje koristite da bi ste u njemu čuvali datoteke kursa, možete sebe da izložite brojnim problemima koji se tiču privatnosti i bezbdnosti sistema. Isto tako može doći do gubitka datoteka pri kreiranju rezervnih kopija, uvozu podataka iz jednog u drugi kurs, kao i svaki put kada sadržaj delite ili ponovo koristite. Zbog toga preporučujemo da ne koristite ovo područje, osim ako niste sasvim sigurni da znate šta radite.';
$string['courselegacyfilesofcourse'] = 'Nasleđene datoteke kursa: {$a}';
$string['coursemessage'] = 'Slanje poruke korisnicima kursa';
$string['coursenotaccessible'] = 'Kurs ne dozvoljava javni pristup';
$string['courseoverview'] = 'Pregled kurseva';
$string['courseoverviewfiles'] = 'Datoteke rezimea kurseva';
$string['courseoverviewfilesext'] = 'Ekstenzije datoteka rezimea kurseva';
$string['courseoverviewfiles_help'] = 'Datoteke rezimea kurseva, kao što su slike, prikazuju se na spisku kurseva zajedno sa rezimeom';
$string['courseoverviewfileslimit'] = 'Ograničenje za datoteke rezimea kurseva';
$string['courseoverviewgraph'] = 'Grafikon pregleda kurseva';
$string['courseprofiles'] = 'Profili kurseva';
$string['coursereasonforrejecting'] = 'Vašo razlozi za odbijanje ovog zahteva';
$string['coursereasonforrejectingemail'] = 'Ovo će biti poslato e-poštom podnosiocu zahteva.';
$string['coursereject'] = 'Odbacite zahtev za otvaranje kursa';
$string['courserejected'] = 'Kurs je odbijen i podnosilac zahteva je obavešten o tome.';
$string['courserejectemail'] = 'Žao nam je, ali vaš zahtev za otvaranje kursa je odbijen. Evo obrazloženja takve odluke:

{$a}';
$string['courserejectreason'] = 'Navedite svoje razloge za odbijanje ovog kursa<br />(ovo će biti poslato e-porukom podnosiocu zahteva)';
$string['courserejectsubject'] = 'Vaš kurs je odbijen';
$string['coursereport'] = 'Izveštaj o kursu';
$string['coursereports'] = 'Iveštaji kursa';
$string['courserequest'] = 'Zahtev za pokretanje novog kursa';
$string['courserequestdetails'] = 'Detaljnije informacije o kursu čije pokretanje tražite';
$string['courserequestfailed'] = 'Iz nekog razloga nije moguće sačuvati vaš zahtev za pokretanje kursa';
$string['courserequestintro'] = 'Upotrebite ovaj obrazac kako biste zatražili da bude kreiran novi kurs za vas.<br />Pokušajte da popunite obrazac sa što više informacija, kako biste pomogli<br />administratorima da bolje razumeju vaše razloge zbog kojih želite ovaj kurs.';
$string['courserequestreason'] = 'Razlozi za pokretanje ovog kursa';
$string['courserequestsuccess'] = 'Vaš zahtev za pokretanje novog kursa uspešno je sačuvan. Biće Vam poslata elektronska poruka da biste bili informisani o tome da li je Vaš zahtev odobren.';
$string['courserequestsupport'] = 'Dodatne informacije koje će pomoći administratoru da proceni ovaj zahtev';
$string['courserestore'] = 'Restauriranje kursa';
$string['courses'] = 'Kursevi';
$string['coursesectionsummaries'] = 'Rezime sekcija kursa';
$string['coursesettings'] = 'Podrazumevana podešavanja kursa';
$string['coursesmovedout'] = 'Kurs pomeren iz {$a}';
$string['coursespending'] = 'Kursevi koji čekaju na odobrenje';
$string['coursestart'] = 'Početak kursa';
$string['coursesummary'] = 'Rezime kursa';
$string['coursesummary_help'] = 'Sažetak kursa se prikazuje u okviru liste kurseva. Pretraga kurseva pretražuje i tekst sažetaka uz pregledanje naziva kurseva.';
$string['courseupdates'] = 'Ažuriranja kursa';
$string['create'] = 'Kreiraj';
$string['createaccount'] = 'Kreiraj moj novi korisnički nalog';
$string['createcategory'] = 'Kreiraj kategoriju';
$string['createfolder'] = 'Kreiranje direktorijuma u {$a}';
$string['createnew'] = 'Kreiraj novi';
$string['createnewcategory'] = 'Kreiraj novu kategoriju';
$string['createnewcourse'] = 'Kreiraj novi kurs';
$string['createnewsubcategory'] = 'Kreiraj novu potkategoriju';
$string['createsubcategoryof'] = 'Kreiraj novu potkategoriju za {$a}';
$string['createuser'] = 'Kreiraj korisnika';
$string['createuserandpass'] = 'Izaberite svoje korisničko ime i lozinku za pristup sistemu';
$string['createziparchive'] = 'Kreiranje zip arhive';
$string['creatingblocks'] = 'Kreiranje blokova';
$string['creatingblocksroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou bloka';
$string['creatingblogsinfo'] = 'Kreiranje informacija o blogovima';
$string['creatingcategoriesandquestions'] = 'Kreiranje kategorija i pitanja';
$string['creatingcoursemodules'] = 'Kreiranje modula kursa';
$string['creatingcourseroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou kursa';
$string['creatingevents'] = 'Kreiranje događaja';
$string['creatinggradebook'] = 'Kreiranje knjige ocena';
$string['creatinggroupings'] = 'Kreiranje grupisanja';
$string['creatinggroupingsgroups'] = 'Dodavanje grupa u grupisanja';
$string['creatinggroups'] = 'Kreiranje grupa';
$string['creatinglogentries'] = 'Kreiranje stavki izveštaja o aktivnostima';
$string['creatingmessagesinfo'] = 'Kreiranje informacija o porukama';
$string['creatingmodroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou modula';
$string['creatingnewcourse'] = 'Kreiranje novog kursa';
$string['creatingrolesdefinitions'] = 'Kreiranje definicija uloga';
$string['creatingscales'] = 'Kreiranje skala za ocenjivanje';
$string['creatingsections'] = 'Kreiranje sekcija';
$string['creatingtemporarystructures'] = 'Kreiranje privremenih struktura';
$string['creatinguserroles'] = 'Kreiranje zadataka i prepisivanja uloga na nivou korisnika';
$string['creatingusers'] = 'Kreiranje korisnika';
$string['creatingxmlfile'] = 'Kreiranje XML datoteke';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Tekući kurs';
$string['currentcourseadding'] = 'Tekući kurs, dodavanje podataka već postojećima';
$string['currentcoursedeleting'] = 'Tekući kurs, uz prethodno brisanje postojećih podataka';
$string['currentlanguage'] = 'Trenutno važeći jezik';
$string['currentlocaltime'] = 'Vaše trenutno lokalno vreme';
$string['currentlyselectedusers'] = 'Trenutno odabrani korisnici';
$string['currentpicture'] = 'Trenutna slika';
$string['currentrelease'] = 'Informacija o trenutnoj verziji programa';
$string['currentversion'] = 'Trenutna verzija';
$string['databasechecking'] = 'Nadogradnja baze podataka sa verzije {$a->oldversion} na verziju {$a->newversion}';
$string['databaseperformance'] = 'Performanse baze podataka';
$string['databasesetup'] = 'Podešavanje baze podataka';
$string['databasesuccess'] = 'Baza podataka je uspešno nadograđena';
$string['databaseupgradebackups'] = 'Trenutna verzija rezervne kopije je {$a}';
$string['databaseupgradeblocks'] = 'Trenutna verzija blokova je {$a}';
$string['databaseupgradegroups'] = 'Verzija grupe sada je {$a}';
$string['databaseupgradelocal'] = 'Trenutna verzija prilagođavanja lokalne baze podataka je {$a}';
$string['databaseupgrades'] = 'Nadogradnja baze podataka';
$string['date'] = 'Datum';
$string['datechanged'] = 'Datum promene';
$string['datemostrecentfirst'] = 'Datum - prvo najnoviji';
$string['datemostrecentlast'] = 'Datum - prvo najstariji';
$string['day'] = 'dan';
$string['days'] = 'dan/a';
$string['decodinginternallinks'] = 'Dekodiranje unutrašnjih linkova';
$string['default'] = 'Podrazumevano';
$string['defaultcoursestudent'] = 'Polaznici';
$string['defaultcoursestudentdescription'] = 'Polaznici u opštem slučaju imaju manje privilegije u okviru kursa.';
$string['defaultcoursestudents'] = 'Polaznici';
$string['defaultcoursesummary'] = 'Napišite kratak i zanimljiv rezime koji objašnjava koje teme pokriva Vaš kurs.';
$string['defaultcourseteacher'] = 'Predavač';
$string['defaultcourseteacherdescription'] = 'Predavači mogu da rade bilo šta u okviru kursa, uključujući promenu aktivnosti i ocenjivanje polaznika.';
$string['defaultcourseteachers'] = 'Predavači';
$string['defaulteditor'] = 'Podrazumevani editor';
$string['delete'] = 'Obriši';
$string['deleteablock'] = 'Obriši blok';
$string['deleteall'] = 'Obriši sve';
$string['deleteallcannotundo'] = 'Obriši sve - ova akcija je nepovratna';
$string['deleteallcomments'] = 'Obriši sve komentare';
$string['deleteallratings'] = 'Obriši sva ocenjivanja';
$string['deletecategory'] = 'Obriši kategoriju: {$a}';
$string['deletecategorycheck'] = 'Jeste li apsolutno sigurni da želite da obrišete kategoriju pod nazivom <b>\'{$a}\'</b>?<br /> Ovo će premestiti sve kurseve koji se nalaze u toj kategoriji u nadređenu kategoriju (ako ista postoji), ili u kategoriju Razno.';
$string['deletecategorycheck2'] = 'Ako obrišete ovu kategoriju, morate izabrati šta uraditi sa kursevima i podkategorijama koje ona sadrži.';
$string['deletecategoryempty'] = 'Ova kategorija je prazna';
$string['deletecheck'] = 'Obrisati {$a} ?';
$string['deletecheckfiles'] = 'Jeste li u potpunosti sigurni da želite da obrišete ove datoteke?';
$string['deletecheckfull'] = 'Jeste li sigurni da želite da potpuno obrišete {$a}?';
$string['deletechecktype'] = 'Da li ste sigurni da želite da obrišete ovaj {$a->type}?';
$string['deletechecktypename'] = 'Da li ste sigurni da želite da obrišete {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Upravo ćete obrisati ove datoteke';
$string['deletecomment'] = 'Obriši ovaj komentar';
$string['deletecompletely'] = 'Kompletno brisanje';
$string['deletecourse'] = 'Brisanje kursa';
$string['deletecoursecheck'] = 'Jeste li sigurni da želite potpuno da obrišete ovaj kurs i sve podatke koje on sadrži?';
$string['deleted'] = 'Obrisano';
$string['deletedactivity'] = 'Obrisano {$a}';
$string['deletedcourse'] = '{$a} je potpuno obrisan';
$string['deletednot'] = '{$a} se ne može obrisati!';
$string['deletelogs'] = 'Obriši zapise';
$string['deleteselected'] = 'Obrisati izabrano';
$string['deleteselectedkey'] = 'Obriši izabrani ključ';
$string['deletingcourse'] = 'Brisanje {$a}';
$string['deletingexistingcoursedata'] = 'Brisanje postojećih podataka kursa';
$string['deletingolddata'] = 'Brisanje starih podataka';
$string['department'] = 'Departman/Odsek';
$string['desc'] = 'Opadajuće';
$string['description'] = 'Opis';
$string['deselectall'] = 'Poništi izbor svega';
$string['detailedless'] = 'Manje detaljno';
$string['detailedmore'] = 'Detaljnije';
$string['directory'] = 'Direktorijum';
$string['disable'] = 'Onemogući';
$string['disabledcomments'] = 'Komentarisanje je onemogućeno';
$string['displayingfirst'] = 'Prikazano je samo prvih(a) {$a->count} {$a->things}';
$string['displayingrecords'] = 'Prikaz {$a} zapisa';
$string['displayingusers'] = 'Prikaz korisnika od {$a->start} do {$a->end}';
$string['displayonpage'] = 'Prikaži na stranici';
$string['dndcourse'] = 'Možete da prevučete i spustiti ovaj kurs kako biste promenili njegovo sortiranje ili ga premestili u drugu kategoriju.';
$string['dndenabled_inbox'] = 'Prevucite i spustite datoteke ovde kako biste ih dodali';
$string['dndnotsupported'] = 'Nije podržano postavljanje prevlačenjem';
$string['dndnotsupported_help'] = 'Vaš čitač ne podržava postavljanje prevlačenjem.<br />Ova mogućnost vam je na raspolaganju u skorijim verzijama čitača Chrome, Firefox i Safari, kao i u čitaču Internet Explorer od verzije 10.';
$string['dndnotsupported_insentence'] = 'prevlačenje nije podržano';
$string['dnduploadwithoutcontent'] = 'Ovo postavljanje nema nikakav sadržaj';
$string['dndworkingfile'] = 'Prevucite i spustite datoteke na sekciju kursa kako biste ih postavili';
$string['dndworkingfilelink'] = 'Prevucite i spustite datoteke ili linkove na sekciju kursa kako biste ih postavili';
$string['dndworkingfiletext'] = 'Prevucite i spustite datoteke ili tekst na sekciju kursa kako biste ih postavili';
$string['dndworkingfiletextlink'] = 'Prevucite i spustite datoteke, tekst ili linkove na sekciju kursa kako biste ih postavili';
$string['dndworkinglink'] = 'Prevucite i spustite linkove na sekciju kursa kako biste ih postavili';
$string['dndworkingtext'] = 'Prevucite i spustite tekst na sekciju kursa kako biste ga postavili';
$string['dndworkingtextlink'] = 'Prevucite i spustite tekst ili linkove na sekciju kursa kako biste ih postavili';
$string['documentation'] = 'Moodle dokumentacija';
$string['dontsortcategories'] = 'Ne sortiraj kategorije';
$string['dontsortcourses'] = 'Ne sortiraj kurseve';
$string['down'] = 'Dole';
$string['download'] = 'Preuzmi';
$string['downloadall'] = 'Preuzmi sve';
$string['downloadexcel'] = 'Preuzmi u Excel formatu';
$string['downloadfile'] = 'Preuzmi datoteku';
$string['downloadods'] = 'Preuzmi u ODS formatu';
$string['downloadtext'] = 'Preuzmi u tekstualnom formatu';
$string['doyouagree'] = 'Jeste li pročitali navedene uslove i razumeli ih u potpunosti?';
$string['droptoupload'] = 'Spusti ovde datoteke za slanje';
$string['duplicate'] = 'Dupliraj';
$string['duplicateconfirm'] = 'Da li ste sigurni da želite da duplirate {$a->modtype} \'{$a->modname}\' ?';
$string['duplicatecontcourse'] = 'Povratak na kurs';
$string['duplicatecontedit'] = 'Uredi novu kopiju';
$string['duplicatesuccess'] = '{$a->modtype} \'{$a->modname}\' je uspešno dupliran/a';
$string['duplicatinga'] = 'Dupliranje: {$a}';
$string['edhelpaspellpath'] = 'Da biste koristili proveru pravopisa u editoru, MORATE imati <strong>aspell 0.50</strong> ili noviji instaliran na Vašem serveru, i morate specificirati tačnu putanju za pristup aspell binarnoj datoteci. Na Unix/Linux sistemima, ova putanja je obično <strong>/usr/bin/aspell</strong>, ali može biti i neka druga.';
$string['edhelpbgcolor'] = 'Odredite pozadinsku boju polja za uređivanje.<br />Primer vrednosti koje se mogu zadati su: #ffffff ili white';
$string['edhelpcleanword'] = 'Ovo podešavanje omogućava ili onemogućava filtriranje Word-specifičnog formata.';
$string['edhelpenablespelling'] = 'Uključite ili isključite proveru pravopisa (spell-checking). Ako je provera uključena, <strong>aspell</strong> mora biti instaliran na serveru. Druga vrednost je <strong>podrazumevani rečnik</strong>. Ova vrednost će biti korišćena ako aspell nema rečnik za jezik koji koristi korisnik.';
$string['edhelpfontfamily'] = 'Karakteristika familija fontova je lista naziva grupa fontova srodnih jezika i/ili generičkih naziva grupa srodnih fontova. Imena grupa srodnih jezika moraju biti odvojena zarezom.';
$string['edhelpfontlist'] = 'Odredite fontove koji će se koristiti u padajućem meniju.';
$string['edhelpfontsize'] = 'Podrazumevana veličina veličina fonta. <br />Primeri vrednosti koje se mogu zadati su: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Uredi';
$string['edita'] = 'Uredi {$a}';
$string['editcategorysettings'] = 'Uredi podešavanja kategorije';
$string['editcategorythis'] = 'Uredi ovu kategoriju';
$string['editcoursesettings'] = 'Uređivanje podešavanja kursa';
$string['editfiles'] = 'Uređivanje datoteka';
$string['editgroupprofile'] = 'Uređivanje profila grupe';
$string['editinga'] = 'Uređivanje';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Ova vrednost se ne može promeniti!';
$string['editmyprofile'] = 'Uređivanje profila';
$string['editorbgcolor'] = 'Boja pozadine';
$string['editorcleanonpaste'] = 'Obriši Word HTML oznake prilikom kopiranja';
$string['editorcommonsettings'] = 'Opšta podešavanja';
$string['editordefaultfont'] = 'Podrazumevani font';
$string['editorenablespelling'] = 'Omogući proveru pravopisa';
$string['editorfontlist'] = 'Spisak fontova';
$string['editorfontsize'] = 'Podrazumevana veličina fonta';
$string['editorresettodefaults'] = 'Vrati na podrazumevane vrednosti';
$string['editorsettings'] = 'Podešavanja editora';
$string['editorshortcutkeys'] = 'Prečice sa tastature editora';
$string['editsettings'] = 'Uredi podešavanja';
$string['editsummary'] = 'Uređivanje rezimea';
$string['editthisactivity'] = 'Uređivanje ove aktivnosti';
$string['editthiscategory'] = 'Uređivanje ove kategorije';
$string['edittitle'] = 'Uredi naslov';
$string['edittitleinstructions'] = 'Pritisnite taster \'Escape\' za otkazivanje, a taster \'Enter\' kada završite';
$string['edituser'] = 'Uređivanje korisničkih naloga';
$string['email'] = 'Adresa e-pošte';
$string['emailactive'] = 'Adresa e-pošte je aktivirana';
$string['emailagain'] = 'Adresa e-pošte (ponovo)';
$string['emailalreadysent'] = 'Elektronska poruka za resetovanje lozinke je već poslata.
Molimo vas da proverite svoju elektronsku poštu.';
$string['emailcharset'] = 'Skup karaktera korišćen za e-poštu';
$string['emailconfirm'] = 'Potvrdite svoj korisnički nalog';
$string['emailconfirmation'] = 'Poštovana/i {$a->firstname},

Zatraženo je otvaranje korisničkog naloga na sajtu \'{$a->sitename}\' koristeći vašu adresu e-pošte.

Da biste potvrdili svoj novi nalog, molimo vas idite na sledeću veb adresu

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['emailconfirmationsubject'] = '{$a}: potvrda registracije korisničkog naloga';
$string['emailconfirmsent'] = '<p>Uskoro biste trebali primiti e-poruku na Vašu adresu <b>{$a}</b></p>
   <p>Poruka sadrži jednostavna uputstva o daljem postupku registracije.</p>
   <p>Ako imate tehničkih problema s registracijom ili pitanja u vezi iste, kontaktirajte administratora sistema.</p>';
$string['emaildigest'] = 'Način obaveštavanja putem e-poruka';
$string['emaildigestcomplete'] = 'Kompletno (jedna e-poruka dnevno sa kompletnim sadržajem svih poruka na forumima)';
$string['emaildigest_help'] = 'Ovo je podešavanje određuje kako će kopije poruka sa foruma bit slate na vašu e-adresu.

* Bez skraćivanja - dobijaćete po jednu elektronsku poruku za svaku poruku (post) objavljenu na forumima;
* Sažetak - kompletan pregled svih poruka - dobijaćete jednu elektronsku poruku dnevno sa kompletnim sadržajem svih poruka (postova) objavljenih u toku 24 sata;
* Sažetak - samo teme poruka - dobijaćete jednu elektronsku poruku dnevno koja će sadržati samo teme svih poruka (postova) objavljenih u toku 24 sata (bez sadržaja samih postova).

Ako želite možete odabrati drugačije podešavanje za svaki forum.';
$string['emaildigestoff'] = 'Bez skraćivanja (po jedna e-poruka za svaku poruku objavljenu na forumima)';
$string['emaildigestsubjects'] = 'Teme poruka (jedna e-poruka dnevno samo, sa temama poruka objavljenih na forumima)';
$string['emaildisable'] = 'Ova adresa e-pošte nije dostupna';
$string['emaildisableclick'] = 'Kliknite ovde za onemogućavanje slanja bilo kakve e-poruke na ovu adresu.';
$string['emaildisplay'] = 'Prikaz adrese e-pošte';
$string['emaildisplaycourse'] = 'Dozvoli jedino drugim polaznicima kursa (polaznicima i predavaču) da vide moju adresu e-pošte.';
$string['emaildisplayhidden'] = 'Elektronska adresa je sakrivena';
$string['emaildisplayno'] = 'Sakrij moju adresu e-pošte od svih';
$string['emaildisplayyes'] = 'Dozvoli svima da vide moju adresu e-pošte';
$string['emailenable'] = 'Ova adresa e-pošte je dostupna';
$string['emailenableclick'] = 'Kliknite ovde za ponovno omogućavanje slanja svih  e-poruka na ovu adresu';
$string['emailexists'] = 'Ova adresa e-pošte je već registrovana.';
$string['emailformat'] = 'Format e-pošte';
$string['emailmustbereal'] = 'Napomena: Vaša adresa e-pošte mora biti stvarna.';
$string['emailnotallowed'] = 'Elektronske adrese koje pripadaju ovim domenima nisu dozvoljene ({$a})';
$string['emailnotfound'] = 'Adresa e-pošte nije nađena u bazi podataka';
$string['emailonlyallowed'] = 'Ova adrese e-pošte nije jedna od dozvoljenih ({$a})';
$string['emailpasswordchangeinfo'] = 'Poštovana/i {$a->firstname},

Neko (verovatno vi) je zatražio novu lozinku za vaš korisnički nalog na sajtu \'{$a->sitename}\'.

Da biste promenili svoju lozinku idite na sledeću veb adresu:

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Poštovana/i {$a->firstname},

Neko (verovatno Vi) je tražio novu šifru za Vaš korisnički nalog na \'{$a->sitename}\'.

Na žalost, Vaš nalog na ovoj lokaciji je nedostupan i ne može biti ponovo aktiviran, molimo kontaktirajte svog administratora, {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Poštovana/i {$a->firstname},

Neko (verovatno Vi) je tražio novu šifru za Vaš korisnički nalog na \'{$a->sitename}\'.

Na žalost, šifre se ne mogu menjati na ovoj lokaciji, molimo kontaktirajte svog administratora, {$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Informacije o promeni šifre';
$string['emailpasswordconfirmation'] = 'Poštovana/i {$a->firstname},

Neko (verovatno vi) je zatražio novu lozinku za vaš korisnički nalog na sajtu \'{$a->sitename}\'.

Da biste potvrdili zahtev i dobili novu lozinku putem e-pošte, idite na sledeću veb adresu:

{$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Ukoliko vam je potrebna tehnička pomoć, molimo vas da kontaktirate administratora,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Potvrda promene lozinke';
$string['emailpasswordconfirmmaybesent'] = '<p>Ako ste naveli tačno korisničko ime ili adresu e-pošte, trebalo bi da vam je poslata elektronska poruka.</p>
<p>Ona sadrži jednostavna uputstva za potvrdu i završetak procesa promene lozinke.
Ako budete i dalje imali poteškoće, molimo kontaktirajte administratora svog sajta.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Korisnički nalog koji ste naveli nema zabeleženu elektronsku adresu.</p>
   <p>Molimo vas da kontaktirate administratora.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Korisnički podaci koje ste naveli se ne odnosi ni na jedan korisniki nalog.</p>
   <p>Molimo vas da proveerite informaciju koju ste naveli i da pokušate ponovo.
Ako i dalje imate problema, molimo vas da kontaktirate administratora.</p>';
$string['emailpasswordconfirmsent'] = 'Trebali biste primiti e-poruku poslatu na Vašu adresu <b>{$a}</b>.
<p>Poruka sadrži jednostavna uputstva za potvrđianje i kompletiranje promene Vaše lozinke.
Ako budete imali poteškoća prilikom ovog procesa, možete se obratiti administratoru.';
$string['emailpasswordsent'] = 'Zahvaljujemo na potvrdi zahteva za promenu lozinke.
<p>E-poruka koja sadrži Vašu novu lozinku je poslata na Vašu adresu <b>{$a->email}</b>.</p>
<p>Nova lozinka je automatski generisana - preporučujemo da je <a href="{$a->link}"<promenite </a> čim je dobijete u neku drugu koju ćete lakše zapamtiti.</p>';
$string['emailresetconfirmation'] = 'Zdravo {$a->firstname},

Zatražena je nova lozinka za vaš korisnički nalog \'{$a->username}\' na sajtu {$a->sitename}.

Kako biste potvrdili ovaj zahtev i podesili novu lozinku za svoj nalog, molimo vas da posetite sledeću veb adresu:

{$a->link}
(Ovaj link je aktivan sledećih {$a->resetminutes} minuta od trenutka kada je zahtev za novom lozinkom prvi put zatražen)

Ako niste zahtevali promenu lozinke ignorišite ovu elektronsku poruku.

Ako vam je potrebna pomoć molimo vas da kontaktirate administratora,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Zahtev za promenu lozinke';
$string['emailresetconfirmsent'] = 'Elektronska poruka je poslata na vašu adresu <b>{$a}</b>.
<br />Poruka sadrži jednostavna uputstva kako da potvrditi i završiti promenu lozinke.
Ako i dalje imate problema, molimo vas da kontaktirate administratora sajta.';
$string['emptydragdropregion'] = 'prazan region';
$string['enable'] = 'Omogući';
$string['encryptedcode'] = 'Šifrovani kod';
$string['english'] = 'Engleski';
$string['enrolmentmethods'] = 'Način upisa';
$string['entercourse'] = 'Kliknite za pristup kursu';
$string['enteremail'] = 'Unesite svoju elektronsku adresu';
$string['enteremailaddress'] = 'Da biste poništili trenutnu lozinku i dobili novu, treba da unesete Vašu važeću adresu elektronske pošte, na koju će Vam biti poslata nova lozinka.';
$string['enterusername'] = 'Unesite svoje korisničko ime';
$string['entries'] = 'Ulazi';
$string['error'] = 'Greška';
$string['errorcreatingactivity'] = 'Nije moguće kreirati instancu aktivnosti \'{$a}\'';
$string['errorfiletoobig'] = 'Datoteka je bila veća od ograničenja od {$a} bajta (bajtova)';
$string['errornouploadrepo'] = 'Na ovom sajtu ne postoji repozitorijum za postavljanje datoteka koji je omogućen';
$string['errorwhenconfirming'] = 'Vaš korisnički nalog još nije još potvrđen zbog greške koja se dogodila. Ako ste kliknuli na link koji ste dobili u e-poruci, molimo proverite je li linija u kojoj se nalazi navedeni link ispravna (odnosno, je da je nije Vaš klijent e-pošte možda formatirao u dva reda, čime je deo linka završio u drugom redu). Postoji mogućnost da ćete morati ručnim kopiranjem i unosom rekonstruisati originalni link.';
$string['eventcontentviewed'] = 'Sadržaj prikazan';
$string['eventcoursecategorydeleted'] = 'Kategorija obrisana';
$string['eventcoursecontentdeleted'] = 'Sadržaj kursa obrisan';
$string['eventcoursecreated'] = 'Kurs kreiran';
$string['eventcoursedeleted'] = 'Kurs obrisan';
$string['eventcoursemodulecreated'] = 'Modul kursa kreiran';
$string['eventcoursemoduledeleted'] = 'Modul kursa obrisan';
$string['eventcoursemoduleupdated'] = 'Modul kursa ažuriran';
$string['eventcourseresetended'] = 'Resetovanje kursa završeno';
$string['eventcourseresetstarted'] = 'Resetovanje kursa pokrenuto';
$string['eventcourserestored'] = 'Kurs restauriran';
$string['eventcoursesectionupdated'] = 'Sekcija kursa ažurirana';
$string['eventcourseupdated'] = 'Kurs ažuriran';
$string['eventusercreated'] = 'Korisnik kreiran';
$string['eventuserdeleted'] = 'Korisnik kreiran';
$string['eventuserlistviewed'] = 'Spisak korisnika prikazan';
$string['eventuserloggedout'] = 'Korisnik se odjavio';
$string['eventuserprofileviewed'] = 'Profil korisnika prikazan';
$string['eventuserupdated'] = 'Korisnik ažuriran';
$string['everybody'] = 'Svi';
$string['executeat'] = 'Izvršiti u';
$string['existing'] = 'Postojeći';
$string['existingadmins'] = 'Postojeći administratori';
$string['existingcourse'] = 'Postojeći kurs';
$string['existingcourseadding'] = 'Postojeći kurs - dodavanje podataka postojećim';
$string['existingcoursedeleting'] = 'Postojeći kurs - prethodno brisanje kursa';
$string['existingcreators'] = 'Postojeći kreatori kursa';
$string['existingstudents'] = 'Upisani polaznici';
$string['existingteachers'] = 'Postojeći predavači';
$string['expand'] = 'Proširi';
$string['expandall'] = 'Proširi sve';
$string['expandcategory'] = 'Proširi {$a}';
$string['explanation'] = 'Objašnjenje';
$string['extendenrol'] = 'Produži (pojedinačno) trajanje članstva';
$string['extendperiod'] = 'Produženi period';
$string['failedloginattempts'] = '{$a->attempts} neuspešnih pristupa sistemu od Vaše poslednje prijave';
$string['failedloginattemptsall'] = '{$a->attempts} neuspešnih pristupa sistemu za {$a->accounts} korisničke naloge';
$string['feedback'] = 'Povratne informacije';
$string['file'] = 'Datoteka';
$string['fileexists'] = 'Već postoji datoteka pod nazivom {$a}';
$string['filemissing'] = '{$a} nedostaje';
$string['files'] = 'Datoteke';
$string['filesanduploads'] = 'Datoteke i postavljene datoteke';
$string['filesfolders'] = 'Datoteke/Direktorijumi';
$string['filetoolarge'] = 'je prevelika za postavljanje';
$string['fileuploadwithcontent'] = 'Postavljanje datoteka ne treba uključuje parametre sadržaja';
$string['filloutallfields'] = 'Molimo ispunite sva polja u ovoj formi';
$string['filter'] = 'Filter';
$string['findmorecourses'] = 'Pronađite još kurseva...';
$string['first'] = 'Prvi';
$string['firstaccess'] = 'Prvi pristup';
$string['firstname'] = 'Ime';
$string['firstnamephonetic'] = 'Ime - fonetički';
$string['firstsiteaccess'] = 'Prvi pristup sajtu';
$string['firsttime'] = 'Da li ste ovde prvi put?';
$string['folder'] = 'Direktorijum';
$string['folderclosed'] = 'Zatvoren direktorijum';
$string['folderopened'] = 'Otvoren direktorijum';
$string['followingoptional'] = 'Sledeća polja su opciona';
$string['followingrequired'] = 'Sledeća polja su obavezna';
$string['for'] = 'Za';
$string['force'] = 'Obavezno';
$string['forcelanguage'] = 'Obavezan jezik';
$string['forceno'] = 'Nije obavezno';
$string['forcepasswordchange'] = 'Primoraj na promenu lozinke';
$string['forcepasswordchangecheckfull'] = 'Jeste li apsolutno sigurni da želite da prisilite na promenu lozinke korisnika {$a}?';
$string['forcepasswordchange_help'] = 'Ako je ovo polje za potvrdu označeno, od korisnika će se tražiti da promene lozinku kada se naredni put budu prijavili na sistem';
$string['forcepasswordchangenot'] = 'Nije bilo moguće prisiliti {$a} na promenu lozinke.';
$string['forcepasswordchangenotice'] = 'Morate promeniti svoju lozinku da biste nastavili';
$string['forcetheme'] = 'Obavezna grafička tema';
$string['forgotaccount'] = 'Zaboravili ste lozinku?';
$string['forgotten'] = 'Zaboravili ste svoje korisničko ime ili lozinku?';
$string['forgottenduplicate'] = 'email adresu deli više korisničkih naloga, molim Vas unesite korisničko ime umesto iste';
$string['forgotteninvalidurl'] = 'Ponovno postavljanje adrese u slučaju pogrešne šifre';
$string['format'] = 'Format';
$string['format_help'] = 'Format kursa određuje izgled naslovne stranice kursa.
* Format jedne aktivnosti - koristi se za prikaz jedne aktivnosti ili resursa (kao što je Test ili SCORM paket) na naslovnoj stranici kursa
* Društveni format - na naslovnoj stranici kursa se prikazuje forum
* Tematski format - naslovna stranica kursa je organizovana u tematske sekcije
* Sedmični format - naslovna stranica kursa je organizovana u nedeljne sekcije, pri čemu prva nedelja odgovara datumu početka kursa';
$string['formathtml'] = 'HTML format';
$string['formatmarkdown'] = 'Markdown format';
$string['formatplain'] = 'Tekstualni format';
$string['formattext'] = 'Moodle auto-format';
$string['formattexttype'] = 'Formatiranje';
$string['framesetinfo'] = 'Ovaj skup okvira sadrži:';
$string['from'] = 'Od';
$string['frontpagecategorycombo'] = 'Kombinovani spisak';
$string['frontpagecategorynames'] = 'Spisak kategorija';
$string['frontpagecourselist'] = 'Spisak kurseva';
$string['frontpagecoursesearch'] = 'Polje za pretraživanje kurseva';
$string['frontpagedescription'] = 'Rezime naslovne stranice';
$string['frontpagedescriptionhelp'] = 'Ovaj rezime sajta će biti prikazan na naslovnoj stranici sajta korišćenjem bloka \'Rezime kursa/sajta\' ili uključivanjem tematske sekcije na naslovnoj stranici.';
$string['frontpageenrolledcourselist'] = 'Upisani kursevi';
$string['frontpageformat'] = 'Format naslovne stranice';
$string['frontpageformatloggedin'] = 'Format naslovne stranice kada je korisnik prijavljen';
$string['frontpagenews'] = 'Vesti';
$string['frontpagesettings'] = 'Podešavanja naslovne stranice';
$string['fulllistofcourses'] = 'Svi kursevi';
$string['fullname'] = 'Pun naziv';
$string['fullnamecourse'] = 'Pun naziv kursa';
$string['fullnamecourse_help'] = 'Pun naziv kursa se prikazuje na vrhu svake stranice kursa kao i na spisku kurseva.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Puno ime korisnika';
$string['fullprofile'] = 'Potpuni profil';
$string['fullsitename'] = 'Puno ime sajta';
$string['functiondisabled'] = 'Navedena funkcionalnost trenutno nije dostupna';
$string['general'] = 'Opšte';
$string['geolocation'] = 'širina - dužina';
$string['gettheselogs'] = 'Preuzmi ove zapise o aktivnostima';
$string['go'] = 'Dalje';
$string['gpl'] = 'Autorska prava 1999-2004 Martin Dougiamas  (http://dougiamas.com)

Ovaj program je besplatan softver; možete vršiti njegovu distribuciju i/ili menjati ga samo pod uslovima GNU General Public License koju je objavila Free Software Foundation, verzija 2 ili (po Vašem izboru) bilo koja novija verzija.

Ovaj program se distribuira u nadi da će biti koristan, ali BEZ IKAKVIH GARANCIJA; čak i bez impriciranih garancija ISPLATIVOSTI ili POGODNOSTI ZA KONKRETNU PRIMENU.

Pogledajte Moodle License stranicu sa informacijama za više detalja:

http://docs.moodle.org/dev/License';
$string['gpl3'] = 'Autorska prava od 1999 pa nadalje Martin Dugiamas  (http://moodle.com)

Ovaj program je besplatan softver; možete vršiti njegovu redistribuciju i/ili menjati ga samo pod uslovima GNU General Public License koju je objavila Free Software Foundation, verzija 3 ili (po vašem izboru) bilo koja novija verzija.

Ovaj program se distribuira u nadi da će biti koristan, ali BEZ IKAKVIH GARANCIJA; čak i bez implicitnih garancija ISPLATIVOSTI ili POGODNOSTI ZA KONKRETNU PRIMENU.

Pogledajte Moodle License stranicu sa informacijama za više detalja: http://docs.moodle.org/en/License';
$string['gpllicense'] = 'GPL licenca';
$string['grade'] = 'Ocena';
$string['grades'] = 'Ocene';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je omogućen za ovaj sajt. Ako sami ne postavite svoju sliku Moodle će pokušati da je umesto vas učita sa Gravatara.';
$string['group'] = 'Grupa';
$string['groupadd'] = 'Dodavanje nove grupe';
$string['groupaddusers'] = 'Dodavanje izabranih polaznika grupi';
$string['groupextendenrol'] = 'Produži trajanje članstva svim polaznicima';
$string['groupfor'] = 'za grupu';
$string['groupinfo'] = 'Informacije o izabranoj grupi';
$string['groupinfoedit'] = 'Uređivanje podešavanja grupe';
$string['groupinfomembers'] = 'Informacije o izabranim članovima';
$string['groupinfopeople'] = 'Informacije o izabranim ljudima';
$string['groupmembers'] = 'Članovi grupe';
$string['groupmemberssee'] = 'Prikaz članova grupe';
$string['groupmembersselected'] = 'Članovi izabrane grupe';
$string['groupmode'] = 'Grupni mod';
$string['groupmodeforce'] = 'Obavezan grupni mod';
$string['groupmy'] = 'Moja grupa';
$string['groupnonmembers'] = 'Polaznici koji nisu u grupi';
$string['groupnotamember'] = 'Žao nam je, niste član te grupe';
$string['grouprandomassign'] = 'Slučajnim odabirom rasporedi sve polaznike u grupe';
$string['groupremove'] = 'Ukloni izabranu grupu';
$string['groupremovemembers'] = 'Uklanjanje izabranih članova';
$string['groups'] = 'Grupe';
$string['groupsnone'] = 'Nema grupa';
$string['groupsseparate'] = 'Odvojene grupe';
$string['groupsvisible'] = 'Vidljive grupe';
$string['guest'] = 'Gost';
$string['guestdescription'] = 'Gosti imaju minimalne privilegije i obično nigde ne mogu da unesu tekst.';
$string['guestskey'] = 'Dozvoljen pristup gostima koji imaju lozinku kursa';
$string['guestsno'] = 'Zabranjen pristup gostima';
$string['guestsnotallowed'] = 'Nažalost, kurs \'{$a}\' ne dozvoljava pristup gostima.';
$string['guestsyes'] = 'Dozvoljen pristup gostima bez lozinke kursa';
$string['guestuser'] = 'Korisnik u ulozi gosta';
$string['guestuserinfo'] = 'Ovaj korisnik je poseban koji dozvoljava pristup nekim kursevima samo za čitanje.';
$string['help'] = 'Pomoć';
$string['helpprefix2'] = 'Pomoć za {$a}';
$string['helpwiththis'] = 'Pomoć za ovo';
$string['hiddenassign'] = 'Sakriveni zadaci';
$string['hiddenfromstudents'] = 'Sakriveno od polaznika';
$string['hiddensections'] = 'Skrivene sekcije';
$string['hiddensectionscollapsed'] = 'Skrivene sekcije su prikazane u skupljenom obliku';
$string['hiddensections_help'] = 'Ovo podešavanje određuje da li će polaznicima skrivene sekcije kursa biti prikazane u sažetom obliku (npr. za kurseve u sedmičnom formatu, da bi se označili praznici ili raspust između dva semestra), ili će biti u potpunosti sakrivene.';
$string['hiddensectionsinvisible'] = 'Skrivene sekcije su u potpunosti nevidljive';
$string['hide'] = 'Sakrij';
$string['hideadvancedsettings'] = 'Sakrij napredna podešavanja';
$string['hidepicture'] = 'Sakrij sliku';
$string['hidesection'] = 'Sakrij sekciju {$a}';
$string['hidesettings'] = 'Sakrij podešavanja';
$string['hideshowblocks'] = 'Sakrij ili prikaži blokove';
$string['hits'] = 'Posete';
$string['hitsoncourse'] = 'Posete korisnika {$a->username} kursu {$a->coursename}';
$string['hitsoncoursetoday'] = 'Današnje posete korisnika {$a->username} kursu {$a->coursename}';
$string['home'] = 'Početna strana';
$string['hour'] = 'h';
$string['hours'] = 'sat/a/i';
$string['howtomakethemes'] = 'Kako napraviti nove grafičke teme';
$string['htmleditor'] = 'Koristi HTML editor';
$string['htmleditoravailable'] = 'HTML editor je dostupan';
$string['htmleditordisabled'] = 'Isključili ste upotrebu HTML editora za Vaš korisnički profil';
$string['htmleditordisabledadmin'] = 'Administrator sistema je isključio uportrebu HTML editora na nivou celog sistema';
$string['htmleditordisabledbrowser'] = 'HTML editor nije dostupan jer vaš veb čitač nije kompatibilan sa njim';
$string['htmlfilesonly'] = 'Samo HTML datoteke';
$string['htmlformat'] = 'Ulepšani HTML format';
$string['icon'] = 'Ikona';
$string['icqnumber'] = 'ICQ broj';
$string['idnumber'] = 'Identifikacioni broj';
$string['idnumbercourse'] = 'Identifikacioni broj kursa';
$string['idnumbercoursecategory'] = 'ID broj kategorije';
$string['idnumbercoursecategory_help'] = 'ID broj kategorije kursa se koristi samo za poređenje sa eksternim sistemom ID brojeva, i nigde se ne prikazuje na sajtu. Ako kategorija ima zvaničan kodni naziv, on može biti unet, u suprotnom polje može biti ostavljeno prazno.';
$string['idnumbercourse_help'] = 'Identifikacioni broj kursa se koristi samo prilikom upoređivanja sa eksternim sistemima i ne prikazuje se nigde na sajtu. Ako kurs ima neku oficijelnu šifru, ona može ovde biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbergroup'] = 'ID broj grupe';
$string['idnumbergroup_help'] = 'Identifikacioni (ID) broj grupe se koristi samo prilikom upoređivanja sa eksternim sistemima i ne prikazuje se nigde na sajtu. Ako grupa ima neku oficijelnu šifru, ona može ovde biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbergrouping'] = 'ID broj grupisanja';
$string['idnumbergrouping_help'] = 'Identifikacioni (ID) broj grupisanja se koristi samo prilikom upoređivanja sa eksternim sistemima i ne prikazuje se nigde na sajtu. Ako grupisanje ima neku oficijelnu šifru, ona može ovde biti upisana, u suprotnom polje može ostati prazno.';
$string['idnumbermod'] = 'ID broj';
$string['idnumbermod_help'] = 'Postavljanje identifikacionog broja omogućuje identifikaciju aktivnosti u svrhu računanja ocena. Ako aktivnost nije uključena u neko od ocenjivanja, polje za identifikacioni broj može ostati prazno.

Identifikacioni broj se, takođe, može postaviti u knjizi ocena, ali se jedino može uređivati na stranici za podešavanje aktivnosti.';
$string['idnumbertaken'] = 'Ovaj ID broj je već zauzet';
$string['imagealt'] = 'Opis slike';
$string['import'] = 'Uvoz';
$string['importdata'] = 'Uvoz podataka kursa';
$string['importdataexported'] = 'Izvoz podataka iz izvornog kursa prošao je uspešno. <br /> Sledi uvoz podataka u odredišni kurs';
$string['importdatafinished'] = 'Uvoz podataka je uspešno završen! Nastavite prema Vašem kursu';
$string['importdatafrom'] = 'Pronađite kurs iz kog želite da uvezete podatke:';
$string['inactive'] = 'Neaktivan';
$string['include'] = 'Uključujući';
$string['includeallusers'] = 'Uključujući sve korisnike';
$string['includecoursefiles'] = 'Uključujući datoteke kursa';
$string['includecourseusers'] = 'Uključujući polaznike kursa';
$string['included'] = 'Uključeni';
$string['includelogentries'] = 'Uključujući stavke izveštaja o aktivnostima';
$string['includemodules'] = 'Uključujući module';
$string['includemoduleuserdata'] = 'Uključujući podatke korisnika modula';
$string['includeneededusers'] = 'Uključujući potrebne korisnike';
$string['includenoneusers'] = 'Bez uključivanja korisnika';
$string['includeroleassignments'] = 'Obuhvati dodelu uloga';
$string['includesitefiles'] = 'Uključujući fajlove korišćene u ovom kursu';
$string['includeuserfiles'] = 'Uključi korisničke datoteke';
$string['increasesections'] = 'Povećaj broj sekcija';
$string['info'] = 'Informacija';
$string['institution'] = 'Institucija';
$string['instudentview'] = 'u polazničkom pogledu';
$string['interests'] = 'Interesovanja';
$string['interestslist'] = 'Lista interesovanja';
$string['interestslist_help'] = 'Unesite svoja interesovanja odvojena zarezima. Vaša interesovanja će biti prikazana na Vašem profilu kao oznake (tagovi).';
$string['invalidemail'] = 'Nevažeća elektronske adresa';
$string['invalidlogin'] = 'Pogrešno korisničko ime ili lozinka. Molimo pokušajte ponovo.';
$string['invalidusername'] = 'Korisničko ime može sadržati samo mala slova i/ili brojeve, donju crtu (_), crticu (-), tačku (.) ili simbol @';
$string['invalidusernameupload'] = 'Neispravno korisničko ime';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Prelaz';
$string['jumpto'] = 'Prelaz na...';
$string['keep'] = 'Zadržite';
$string['keepsearching'] = 'Nastavi s pretragom';
$string['langltr'] = 'Smer pisanja s leva na desno';
$string['langrtl'] = 'Smer pisanja s desna na levo';
$string['language'] = 'Jezik';
$string['languagegood'] = 'Ovaj jezički paket je ažuran! :-)';
$string['last'] = 'Poslednji';
$string['lastaccess'] = 'Poslednji pristup';
$string['lastcourseaccess'] = 'Poslednji pristup kursu';
$string['lastedited'] = 'Poslednji put uređeno';
$string['lastlogin'] = 'Poslednji pristup sistemu';
$string['lastmodified'] = 'Poslednja izmena';
$string['lastname'] = 'Prezime';
$string['lastnamephonetic'] = 'Prezime - fonetički';
$string['lastsiteaccess'] = 'Poslednji pristup sajtu';
$string['lastyear'] = 'Prošle godine';
$string['latestlanguagepack'] = 'Pogledajte najnovije jezičke pakete na moodle.org';
$string['layouttable'] = 'Raspored u tabeli';
$string['leavetokeep'] = 'Ostavite prazno polje da zadržite trenutnu lozinku';
$string['legacythemeinuse'] = 'Ovaj sajt vam se prikazuje u tzv. kompatibilnom modu zato što je vaš veb čitač zastareo.';
$string['license'] = 'Licenca';
$string['licenses'] = 'Licence';
$string['liketologin'] = 'Želite li sad da pristupite sistemu s pravim korisničim nalogom?';
$string['list'] = 'Spisak';
$string['listfiles'] = 'Spisak datoteka u {$a}';
$string['listofallpeople'] = 'Spisak svih korisnika';
$string['listofcourses'] = 'Spisak kurseva';
$string['loadinghelp'] = 'Učitavanje ...';
$string['local'] = 'Lokalno';
$string['localplugins'] = 'Lokalni dodaci';
$string['localpluginsmanage'] = 'Uredi lokalne dodatke';
$string['location'] = 'Lokacija';
$string['log_excel_date_format'] = 'd mmmm yyyy h:mm';
$string['loggedinas'] = 'Prijavljeni ste kao {$a}';
$string['loggedinasguest'] = 'Trenutno pristupate kao gost';
$string['loggedinnot'] = 'Niste prijavljeni.';
$string['login'] = 'Prijava';
$string['loginalready'] = 'Već ste prijavljeni na sistem';
$string['loginas'] = 'Pristup sistemu kao';
$string['loginaspasswordexplain'] = '<p>Morate uneti specijalnu "pristupi sistemu kao" lozinku da biste koristili ovu mogućnost.<br />Ako ne znate tu lozinku, pitajte administratora svog servera.</p>';
$string['login_failure_logs'] = 'Zapisi o neuspešnim prijavama';
$string['loginguest'] = 'Prijavite se kao gost';
$string['loginsite'] = 'Pristup sistemu';
$string['loginsteps'] = 'Dobrodošli! Kako biste imali puni pristup kursevima na ovom veb sajtu, morate kreirati novi korisnički nalog.
Svaki od pojedinih kurseva može takođe imati jednokratnu "lozinku kursa", koju treba da dobijete od svog predavača i koja se unosi samo prilikom prvog prijavljivanja na kurs. Sledite ova uputstva:
   <ol size="2">
   <li>Ispunite obrazac <a href="{$a}">Novi korisnički nalog</a> svojim ličnim podacima.</li>
   <li>Odmah ćete na svoju elektronsku adresu dobiti naša dalja uputstva.</li>
   <li>Pažljivo pročitajte poruku i kliknite na link koji se nalazi u njoj.</li>
   <li>Vaš korisnički nalog će time biti potvrđen i bićete prijavljeni na sistem.</li>
   <li>Potom odaberite kurs u kojem želite da učestvujete.</li>
   <li>Ako vam sistem zatraži "lozinku kursa" - upotrebite onu koju vam je dao vaš predavač na navedenom kursu. Tako ćete se upisati na kurs</li>
   <li>Nakon unosa ispravne "lozinke kursa" možete pristupiti kursu (odnosno, od tog trenutka ste upisani na isti). Ubuduće, pri dolasku na sajt, biće potrebno da unesete samo svoje korisničko ime i lozinku (u obrazac na ovoj strani) kako biste pristupili svim kursevima koje ste upisali.</li>
</ol>';
$string['loginstepsnone'] = '<p>Poštovani budući korisniče!</p>
<p>Za potpuni pristup kursevima morate kreirati korisnički nalog.</p>
<p>Sve što treba da uradite je da smislite korisničko ime i lozinku i unesete ih u za to određena polja u obrascu na ovoj stranici!</p>
<p>Ako je neko pre Vas već odabrao identično korisničko ime, morate odabrati neko drugo i pokušati ponovo.</p>';
$string['loginto'] = 'Prijava na {$a}';
$string['logout'] = 'Odjava';
$string['logoutconfirm'] = 'Da li zaista želite da se odjavite?';
$string['logs'] = 'Zapisi o aktivnostima';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">više</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">više</a> ]';
$string['lookback'] = 'Pogledaj unazad';
$string['mailadmins'] = 'Obavestiti administratore';
$string['mailstudents'] = 'Obavestiti polaznike';
$string['mailteachers'] = 'Obavestiti predavače';
$string['maincoursepage'] = 'Glavna stranica kursa';
$string['makeafolder'] = 'Kreiraj direktorijum';
$string['makeeditable'] = 'Ako podesite \'{$a}\' da se može urediti procesom Web servera, onda možete menjati ovu datoteku direktno sa ove stranice';
$string['makethismyhome'] = 'Postavi ovo kao moju podrazumevanu početnu stranivu';
$string['manageblocks'] = 'Blokovi';
$string['managecategorythis'] = 'Upravljanje ovom kategorijom';
$string['managecourses'] = 'Upravljanje kursevima';
$string['managedatabase'] = 'Baza podataka';
$string['manageeditorfiles'] = 'Uredi datoteke korišćene od strane editora';
$string['managefilters'] = 'Filteri';
$string['managemodules'] = 'Moduli';
$string['manageroles'] = 'Uloge i prava pristupa';
$string['markedthistopic'] = 'Ova tema je označena kao trenutna tema';
$string['markthistopic'] = 'Označite ovu temu kao trenutnu temu';
$string['matchingsearchandrole'] = 'Sparivanje \'{$a->search}\' i {$a->role}';
$string['maxareabytesreached'] = 'Datoteka (ili ukupna veličina nekoliko datoteka) je veća od mesta koji je preostalo u ovom prostoru.';
$string['maxbytesforfile'] = 'Datoteka {$a} je veća od maksimalne dozvoljene veličine.';
$string['maxfilesize'] = 'Maksimalna veličina za nove datoteke {$a}';
$string['maxfilesreached'] = 'Dozvoljeno vam je da uz ovu stavku priložite najviše {$a} datoteku/e/a';
$string['maximumchars'] = 'Maksimalno {$a} karaktera';
$string['maximumgrade'] = 'Maksimalna ocena';
$string['maximumgradex'] = 'Najveća ocena: {$a}';
$string['maximumshort'] = 'Maks.';
$string['maximumupload'] = 'Maksimalna veličina datoteka za postavljanje';
$string['maximumupload_help'] = 'Ovo podešavanja određuje najveću veličinu datoteke koja se može postaviti na kurs, a ograničeno je podešavanjem na nivou celog sajta koje određuje administrator. Moduli aktivnosti takođe sadrže podešavanje kojima se određuje i dodatno ograničiva najveća dozvoljena veličina datoteke za postavljanje.';
$string['maxnumberweeks'] = 'Maksimalan broj sekcija';
$string['maxnumberweeks_desc'] = 'Maksimalna vrednost u padajućem meniju  "Broj sekcija" (važi samo za određene formate kursa)';
$string['maxnumcoursesincombo'] = 'Pretraži <a href="{$a->link}">{$a->numberofcourses} kurseve</a>';
$string['maxsize'] = 'Maks. veličina: {$a}';
$string['maxsizeandareasize'] = 'Maksimalna veličina za nove datoteke: {$a->size}, globalno ograničenje: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maksimalna veličina za nove datoteke: {$a->size}, makisimalan broj priloga: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maksimalna veličina za nove datoteke: {$a->size}, makisimalan broj priloga: {$a->attachments}';
$string['memberincourse'] = 'Učesnici u kursu';
$string['messagebody'] = 'Telo poruke';
$string['messagedselectedusers'] = 'Izabranim polaznicima je poslata poruka i resetovan je spisak primalaca.';
$string['messagedselectedusersfailed'] = 'Nešto nije bilo u redu pri slanju poruke izabranim korisnicima. Neki od njih su ipak možda primili poslatu poruku.';
$string['messageprovider:availableupdate'] = 'Dostupna obaveštenja o ažuriranju';
$string['messageprovider:backup'] = 'Obaveštenja o kreiranju rezervne kopije';
$string['messageprovider:badgecreatornotice'] = 'Obaveštenje o kreatoru bedža';
$string['messageprovider:badgerecipientnotice'] = 'Obaveštenje o primaocu bedža';
$string['messageprovider:courserequestapproved'] = 'Obaveštenje o odobrenju zahteva za kreiranje kursa';
$string['messageprovider:courserequested'] = 'Obaveštenje o zahtevu za kreiranje kursa';
$string['messageprovider:courserequestrejected'] = 'Obaveštenje o odbijanju zahteva za kreiranje kursa';
$string['messageprovider:errors'] = 'Važne greške u vezi sa sajtom';
$string['messageprovider:errors_help'] = 'Ovo su važne greške o kojima administrator mora da bude upoznat';
$string['messageprovider:instantmessage'] = 'Lične poruke između korisnika';
$string['messageprovider:instantmessage_help'] = 'Ova sekcija konfiguriše šta se događa sa porukama koji su vam direktno poslate od strane drugih korisnika na ovom sajtu.';
$string['messageprovider:notices'] = 'Obaveštenja o manjim problemima';
$string['messageprovider:notices_help'] = 'Ovo su obaveštenja koja bi mogla da interesuju administratora da ih pogleda.';
$string['messageselect'] = 'Izaberite ovog korisnika kao primaoca poruke';
$string['messageselectadd'] = 'Pošalji poruku';
$string['middlename'] = 'Srednje ime';
$string['migratinggrades'] = 'Premeštanje ocena';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minut';
$string['minutes'] = 'minut/a';
$string['miscellaneous'] = 'Razno';
$string['missingcategory'] = 'Morate odabrati kategoriju';
$string['missingcity'] = 'Nedostaje grad/naselje';
$string['missingcountry'] = 'Nedostaje država';
$string['missingdescription'] = 'Nedostaje opis';
$string['missingemail'] = 'Nedostaje adresa e-pošte';
$string['missingfirstname'] = 'Nedostaje ime';
$string['missingfromdisk'] = 'Nedostaje na disku';
$string['missingfullname'] = 'Nedostaje puno ime';
$string['missinglastname'] = 'Nedostaje prezime';
$string['missingname'] = 'Nedostaje ime';
$string['missingnewpassword'] = 'Nedostaje nova lozinka';
$string['missingpassword'] = 'Nedostaje lozinka';
$string['missingrecaptchachallengefield'] = 'Nedostaje polje za reCAPTCHA';
$string['missingreqreason'] = 'Nedostaje razlog';
$string['missingshortname'] = 'Nedostaje kratki naziv';
$string['missingshortsitename'] = 'Nedostaje kratki naziv sajta';
$string['missingsitedescription'] = 'Nedostaje opis sajta';
$string['missingsitename'] = 'Nedostaje naziv sajta';
$string['missingstrings'] = 'Provera neprevedenih reči ili izraza';
$string['missingstudent'] = 'Morate nešto odabrati';
$string['missingsummary'] = 'Nedostaje rezime';
$string['missingteacher'] = 'Morate nešto odabrati';
$string['missingurl'] = 'Nedostaje URL';
$string['missingusername'] = 'Nedostaje korisničko ime';
$string['modchooserdisable'] = 'Isključi birač aktivnosti';
$string['modchooserenable'] = 'Uključi birač aktivnost';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} ne podržava postavljanja tipa {$a->type}';
$string['modified'] = 'Izmenjeno';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Podešavanje tabela modula';
$string['modulesuccess'] = '{$a} tabela je ispravno podešeno';
$string['modulesused'] = 'Korišćeni moduli';
$string['month'] = 'Mesec';
$string['months'] = 'Meseci';
$string['moodledocs'] = 'Moodle dokumentacija';
$string['moodledocslink'] = 'Moodle dokumentacija za ovu stranicu';
$string['moodlerelease'] = 'Moodle verzija';
$string['moodleversion'] = 'Moodle verzija';
$string['more'] = 'još';
$string['morehelp'] = 'Više pomoći';
$string['moreinformation'] = 'Više informacija o ovoj grešci';
$string['moreprofileinfoneeded'] = 'Molimo recite nam nešto više o sebi';
$string['mostrecently'] = 'najnovije';
$string['move'] = 'Premesti';
$string['movecategoriessuccess'] = 'Uspešno premešteno  {$a->count} kategorija/e u kategoriju \'{$a->to}\'';
$string['movecategoriestotopsuccess'] = 'Uspešno premešteno {$a->count} kategorija/e na najviši nivo';
$string['movecategorycontentto'] = 'Premesti u:';
$string['movecategorysuccess'] = 'Kategorije \'{$a->moved}\' je uspešno premeštena  u kategoriju \'{$a->to}\'';
$string['movecategoryto'] = 'Premesti kategoriju u:';
$string['movecategorytotopsuccess'] = 'Kategorije \'{$a->moved}\' je uspešno premeštena na najviši nivo';
$string['movecontent'] = 'Premesti {$a}';
$string['movecontentstoanothercategory'] = 'Premesti sadržaj u drugu kategoriju';
$string['movecoursemodule'] = 'Premesti resurs';
$string['movecoursesection'] = 'Premesti sekciju';
$string['movecourseto'] = 'Premesti kurs u:';
$string['movedown'] = 'Premesti dole';
$string['movefilestohere'] = 'Premesti datoteke ovde';
$string['movefull'] = 'Premesti {$a} na ovu lokaciju';
$string['movehere'] = 'Premesti ovamo';
$string['moveleft'] = 'Pomakni ulevo';
$string['moveright'] = 'Pomakni udesno';
$string['movesection'] = 'Premesti sekciju {$a}';
$string['moveselectedcategoriesto'] = 'Premesti izabrane kategorije u';
$string['moveselectedcoursesto'] = 'Premesti izabrane kurseve u...';
$string['movetoanotherfolder'] = 'Premesti u drugi direktorijum';
$string['moveup'] = 'Premesti gore';
$string['msnid'] = 'MSN ID';
$string['mustchangepassword'] = 'Nova lozinka mora biti različita od trenutne';
$string['mustconfirm'] = 'Morate potvrditi svoju prijavu na sistem';
$string['mycourses'] = 'Moji kursevi';
$string['myfiles'] = 'Moje privatne datoteke';
$string['myfilesmanage'] = 'Uredi moje privatne datoteke';
$string['myhome'] = 'Moja početna stranica';
$string['mymoodledashboard'] = 'Moj Moodle komandna tabla';
$string['myprofile'] = 'Moj profil';
$string['name'] = 'Ime';
$string['nameforlink'] = 'Kako želite da nazovete ovaj link?';
$string['nameforpage'] = 'Naziv';
$string['navigation'] = 'Navigacija';
$string['needed'] = 'Potrebno';
$string['never'] = 'Nikad';
$string['neverdeletelogs'] = 'Nikada ne briši  zapise o aktivnostima';
$string['new'] = 'Novo';
$string['newaccount'] = 'Novi korisnički nalog';
$string['newcourse'] = 'Novi kurs';
$string['newpassword'] = 'Nova lozinka';
$string['newpasswordfromlost'] = '<strong>OBAVEŠTENjE:</strong> Vaša <strong>trenutna lozinka</strong> biće vam poslata u <strong>drugoj</strong> od dve poruke poslate u toku postupka  za ponovnog dobijanja izgubljene lozinke. Proverite da li ste primili zamenu lozinke pre nego što nastavite sa ovim ekranom.';
$string['newpassword_help'] = 'Unesite novu lozinku ili ostavite polje prazno kako biste zadržali tekuću lozinku.';
$string['newpasswordtext'] = 'Poštovana/i {$a->firstname},

Lozinka vašeg naloga na sajtu \'{$a->sitename}\' je resetovana i dodeljena vam je nova privremena lozinka.

Vaši trenutni podaci za pristup sistemu su:
   korisničko ime: {$a->username}
   lozinka: {$a->newpassword}

Molimo vas da posetite ovu stranicu kako biste promenili svoju lozinku:
   {$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Pozdrav,
\'{$a->sitename}\' administrator,
{$a->signoff}';
$string['newpicture'] = 'Nova slika';
$string['newpicture_help'] = 'Da biste dodali novu sliku, pronađite i odaberite jednu (u JPG ili PNG formatu) i kliknite na "Ažuriraj profil". Slika će biti isečena u obliku kvadrata a njena veličina smanjena na 100x100 piksela.';
$string['newsitem'] = 'vest';
$string['newsitems'] = 'vesti';
$string['newsitemsnumber'] = 'Broj vesti koje treba prikazati';
$string['newsitemsnumber_help'] = 'Ovo podešavanje određuje koliko će se skorašnjih vesti pojaviti u bloku Najnovije vesti, na stranici kursa. Ako podesite na "0 vesti" ovaj blok neće biti prikazan.';
$string['newuser'] = 'Novi korisnik';
$string['newusernewpasswordsubj'] = 'Novi korisnički nalog';
$string['newusernewpasswordtext'] = 'Poštovana/i {$a->firstname},

Otvoren vam je novi korisnički nalog na sajtu \'{$a->sitename}\' i dodeljena vam je nova privremena lozinka.

Vaše trenutne informacije za pristup sajtu su:
korisničko ime: {$a->username}
lozinka: {$a->newpassword}
(moraćete da promenite lozinku kada se prvi put prijavite na sistemu)

Da biste počeli da koristite sajt \'{$a->sitename}\', prijavite se na {$a->link}

U većini programa za elektronsku poštu, ovo bi trebalo da se pojavi kao plavo obojeni link na koji je potrebno samo kliknuti. Ako ta opcija ne funkcioniše, kopirajte navedenu adresu u adresnu liniju na vrhu prozora vašeg veb čitača.

Pozdrav,
\'{$a->sitename}\' administrator,
{$a->signoff}';
$string['newusers'] = 'Novi korisnici';
$string['newwindow'] = 'Novi prozor';
$string['next'] = 'Sledeći';
$string['nextsection'] = 'Sledeća sekcija';
$string['no'] = 'Ne';
$string['noblockstoaddhere'] = 'Ne postoje blokovi koje možete dodati ovoj stranici.';
$string['nobody'] = 'Niko';
$string['nochange'] = 'Bez promena';
$string['nocomments'] = 'Nema komentara';
$string['nocourses'] = 'Nema kursreva';
$string['nocoursesfound'] = 'Nijedan kurs ne sadrži pojam \'{$a}\'';
$string['nocoursesyet'] = 'Nema kurseva u ovoj kategoriji';
$string['nodstpresets'] = 'Administrator sistema nije omogućio podršku za Daylight Savings Time.';
$string['nofilesselected'] = 'Nije izabrana nijedna datoteka za restauriranje.';
$string['nofilesyet'] = 'Unutar ovog kursa još nije postavljena nijedna datoteka';
$string['nograde'] = 'Nema ocene';
$string['nohelpforactivityorresource'] = 'Trenutno ne postoji pomoć vezana za ovaj resurs ili aktivnost';
$string['noimagesyet'] = 'Unutar ovog kursa još nije postavljena nijedna slika';
$string['nologsfound'] = 'Logovi nisu nađeni';
$string['nomatchingusers'] = 'Nijedan korisnik se ne poklapa sa \'{$a}\'';
$string['nomorecourses'] = 'Nije pronađeno više kurseva koji se uklapaju sa zadatim kriterijumima';
$string['nomoreidnumber'] = 'Ne koristi se idnumber da bi se izbegle kolizije';
$string['none'] = 'Nijedan';
$string['noneditingteacher'] = 'Predavač bez uređivačkih prava';
$string['noneditingteacherdescription'] = 'Predavači bez uređivačkih prava mogu da predaju na kursevima i ocenjuju polaznike, ali ne mogu da menjaju aktivnosti.';
$string['nonstandard'] = 'Nestandardno';
$string['nopendingcourses'] = 'Nema kurseva koji čekaju na odobrenje';
$string['nopotentialadmins'] = 'Nema potencijalnih administratora';
$string['nopotentialcreators'] = 'Nema potencijalnih kreatora kursa';
$string['nopotentialstudents'] = 'Nema potencijalnih polaznika';
$string['nopotentialteachers'] = 'Nema potencijalnih predavača';
$string['norecentactivity'] = 'Nema nedavnih aktivnosti';
$string['noreplybouncemessage'] = 'Odgovorili ste na adresu elektronske pošte sa koje se poruke samo šalju (no-reply email address). Ako ste pokušavali da odgovorite na poruku sa foruma, molimo da to učinite direktno koristeći {$a} forume.

Sledi sadržaj vaše poruke:';
$string['noreplybouncesubject'] = '{$a} - vraćena e-poruka.';
$string['noreplyname'] = 'Nemojte odgovarati na ovu e-poruku';
$string['noresetrecord'] = 'Ne postoji zapis o ovom zahtevu za promenu lozinke. Molimo vas da pokrenete nov zahtev za promenu lozinke.';
$string['noresults'] = 'Nema rezultata';
$string['normal'] = 'Normalno';
$string['normalfilter'] = 'Normalna pretraga';
$string['nosite'] = 'Nije pronađen kurs na nivou sajta';
$string['nostudentsfound'] = '{$a} nije pronađen';
$string['nostudentsingroup'] = 'Još nema polaznika u ovoj grupi';
$string['nostudentsyet'] = 'Nijedan polaznik još nije upisan na ovaj kurs';
$string['nosuchemail'] = 'Nema takve adrese e-pošte';
$string['notavailable'] = 'Nije dostupno';
$string['noteachersyet'] = 'Još uvek nema predavača na ovom kursu';
$string['notenrolled'] = '{$a} nije upisan/a na ovaj kurs.';
$string['notenrolledprofile'] = 'Ovaj profil nije dostupan jer korisnik nije prijavljen za ovaj kurs.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Napomena:</strong> Mogućnost menjanja datuma prilikom obnavljanja ove rezervne kopije je onemogućena jer nemate potrebna ovlašćenja.';
$string['noteuserschangednonetocourse'] = 'Napomena: Kada restaurirate korisničke podatke (u aktivnostima, datotekama ili porukama) morate da restaurirate i korisnike kursa. Ovo podešavanje je promenjeno za vas.';
$string['nothingnew'] = 'Nema novosti od Vaše poslednje posete';
$string['nothingtodisplay'] = 'Nema ničega za prikaz';
$string['notice'] = 'Napomena';
$string['noticenewerbackup'] = 'Ova datoteka sa rezervnom kopijom je napravljena pomoću Moodle verzije {$a->backuprelease} ({$a->backupversion}) i novija je od Vašeg trenutno instaliranog sistema Moodle {$a->serverrelease} ({$a->serverversion}). Ovo bi moglo uzrokovati određene nedoslednosti zbog toga što kompatibilnost sistema sa rezervnim kopijama kreiranim pomoću ranijih verzija ne može biti garantovana.';
$string['notifications'] = 'Obaveštenja';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Korisnik: {$a->info}';
$string['notifyloginfailuresmessageend'] = 'Ove izveštaje o aktivnostima možete videti na adresi {$a}/course/report/log/index.php?id=1&chooselog=1&modid=site_errors.';
$string['notifyloginfailuresmessagestart'] = 'Ovo je spisak grešaka pri pristupu sistemu na {$a} od poslednjeg obaveštenja koje ste primili';
$string['notifyloginfailuressubject'] = '{$a} :: Obaveštenje o greškama pri pristupu sistemu';
$string['notincluded'] = 'Nije uključeno';
$string['notingroup'] = 'Nažalost, morate biti član grupe kako biste videli ovu aktivnost.';
$string['notpublic'] = 'Nije javno!';
$string['nousersfound'] = 'Nije pronađen nijedan korisnik';
$string['nousersmatching'] = 'Nije pronađen nijedan korisnik koji se podudara sa \'{$a}\'';
$string['nousersyet'] = 'Još nema korisnika';
$string['novalidcourses'] = 'Nema važećih kurseva koji bi bili prikazani';
$string['now'] = 'sada';
$string['numattempts'] = '{$a} neuspešnih pristupa sistemu';
$string['numberofcourses'] = 'Broj kurseva';
$string['numberweeks'] = 'Broj sekcija';
$string['numdays'] = '{$a} dan(a)';
$string['numhours'] = '{$a} h';
$string['numletters'] = '??? slovo(a)';
$string['numminutes'] = '{$a} min';
$string['nummonths'] = '{$a} mesec(a)';
$string['numseconds'] = '{$a} s';
$string['numviews'] = '{$a} pregled(a)';
$string['numweeks'] = '{$a} sedmica(e)';
$string['numwords'] = '{$a} reč(i)';
$string['numyears'] = '{$a} godina(e)';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Trenutna lozinka';
$string['olduserdirectory'] = 'Ovo je STARI korisnički direktorijum koji više nije potreban. Možete ga slobodno obrisati. Datoteke iz ovog direktorijuma su kopirane u NOVI korisnički direktorijum.';
$string['opentoguests'] = 'Pristup gostima';
$string['optional'] = 'opciono';
$string['options'] = 'opcije';
$string['order'] = 'Poredak';
$string['originalpath'] = 'Originalna putanja';
$string['orphanedactivitiesinsectionno'] = 'Aktivnosti siročići (sekcija {$a})';
$string['other'] = 'Ostali';
$string['outline'] = 'Kratak pregled';
$string['outlinereport'] = 'Skraćeni izveštaj';
$string['page'] = 'Stranica';
$string['pagea'] = 'Stranica {$a}';
$string['pageheaderconfigablock'] = 'Konfigurisanje bloka u {$a->fullname}';
$string['pagepath'] = 'Putanja do stranice';
$string['pageshouldredirect'] = 'Ova stranica bi trebalo da vas automatski preusmeri. Ukoliko se ništa ne događa molimo vas da za nastavak upotrebite donji link.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parentcoursenotfound'] = 'Nadređeni kurs nije pronađen!';
$string['parentfolder'] = 'Nadređeni direktorijum';
$string['participants'] = 'Učesnici';
$string['participantslist'] = 'Spisak učesnika';
$string['participationratio'] = 'Odnos učešća';
$string['participationreport'] = 'Izveštaj o učešću';
$string['password'] = 'Lozinka';
$string['passwordchanged'] = 'Lozinka je promenjena';
$string['passwordconfirmchange'] = 'Potvrdite promenu lozinke';
$string['passwordextlink'] = 'Sledeći link Vam je na raspolaganju za oporavak Vaše izgubljene lozinke. Klik na njega će Vas izvesti iz Moodle sistema.';
$string['passwordforgotten'] = 'Zaboravljena lozinka';
$string['passwordforgotteninstructions'] = 'Vaši podaci prvo moraju biti pronađeni u bazi podataka korisnika. Molimo unesite <strong>ili</strong> svoje korisničko ime ili prijavljenu elektronsku adresu u odgovarajuće polje. Nema potrebe da unosite oba podatka.';
$string['passwordforgotteninstructions2'] = 'Za resetovanje Vaše lozinke upišite svoje korisničko ime ili elektronsku adresu. Ukoliko ti podaci postoje u bazi podataka, biće Vam poslata poruka na elektronsku adresu sa uputstvom kako ponovo da dobijete pristup.';
$string['passwordnohelp'] = 'Nije na raspolaganju nikakva pomoć za pronalaženje Vaše izgubljenje lozinke. Molimo kontaktirajte Vašeg Moodle administratora.';
$string['passwordrecovery'] = 'Da, treba mi pomoć za pristup sistemu';
$string['passwordsdiffer'] = 'Lozinke se ne poklapaju';
$string['passwordsent'] = 'Lozinka je poslata';
$string['passwordsenttext'] = '<p>E-poruka je poslata na Vašu adresu e-pošte {$a->email}.</p>
   <p><b>Molimo proverite Vašu e-poštu kako biste primili novu lozinku</b></p>
   <p>Nova lozinka je automatski generisana, pa biste je možda želeli
   <a href="{$a->link}">promeniti u nešto što ćete moći lakše da zapamtite</A>.</p>';
$string['passwordset'] = 'Vaša lozinka je podešena.';
$string['path'] = 'Putanja';
$string['pathnotexists'] = 'Putanja ne postoji na Vašem serveru!';
$string['pathslasherror'] = 'Putanja se ne može završavati kosom crtom!';
$string['paymentinstant'] = 'Upotrebite dugme ispod kako biste izvršili uplatu i upisali kurs u roku od nekoliko minuta!';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> na čekanju</small>)';
$string['paymentrequired'] = 'Ovaj kurs nije besplatan.';
$string['payments'] = 'Uplate';
$string['paymentsorry'] = 'Hvala Vam na Vašoj uplati! Nažalost Vaša uplata još nije potpuno obrađena, te još niste registrovani za pristup kursu "{$a->fullname}". Molimo Vas pokušajte nastaviti sa pristupom kursu za nekoliko sekundi, ali ako se problemi nastave, molimo obavestite predavača {$a->teacher} ili administratora sajta';
$string['paymentthanks'] = 'Hvala Vam na Vašoj uplati! Sada ste upisani na kurs:<br />"{$a}"';
$string['pendingrequests'] = 'Zahtevi na čekanju';
$string['periodending'] = 'Završetak perioda ({$a})';
$string['perpage'] = 'Po stranici';
$string['perpagea'] = 'Po stranici: {$a}';
$string['personal'] = 'Lično';
$string['personalprofile'] = 'Lični profil';
$string['phone'] = 'Telefon';
$string['phone2'] = 'Mobilni telefon';
$string['phpinfo'] = 'PHP informacije';
$string['pictureof'] = 'Slika {$a}';
$string['pictureofuser'] = 'Slika korisnika';
$string['pleaseclose'] = 'Molim Vas zatvorite sada ovaj prozor.';
$string['pleasesearchmore'] = 'Nastavite pretragu';
$string['pleaseusesearch'] = 'Upotrebite pretragu';
$string['plugin'] = 'Dodatak';
$string['plugincheck'] = 'Provera dodataka';
$string['plugindeletefiles'] = 'Svi podaci povezani sa dodatkom: \'{$a->name}\' su obrisani iz baze podataka. Da biste sprečili automatsku reinstalaciju dodatka,  potrebno je da sada sa servera obrišete ovaj direktorijum: {$a->directory}';
$string['pluginsetup'] = 'Podešavanje tabele dodataka';
$string['policyaccept'] = 'Razumem i pristajem';
$string['policyagree'] = 'Da bi ste nastavili korišćenje ovog sajta morate se složiti sa pravilima korišćenja. Da li se slažete?';
$string['policyagreement'] = 'Saglasnost sa pravilnikom o korišćenju sajta';
$string['policyagreementclick'] = 'Link ka pravilniku o korišćenju sajta';
$string['popup'] = 'iskačući prozor';
$string['popupwindow'] = 'Otvori datoteku u novom prozoru';
$string['popupwindowname'] = 'Iskačući prozor';
$string['post'] = 'Poruka';
$string['posts'] = 'Poruke';
$string['potentialadmins'] = 'Potencijalni administratori';
$string['potentialcreators'] = 'Potencijalni kreatori kursa';
$string['potentialstudents'] = 'Potencijalni polaznici';
$string['potentialteachers'] = 'Potencijalni predavači';
$string['preferences'] = 'Parametri';
$string['preferredlanguage'] = 'Preferirani jezik';
$string['preferredtheme'] = 'Preferirana grafička tema';
$string['preprocessingbackupfile'] = 'Preprocesiranje datoteke rezervne kopije';
$string['prev'] = 'Prethodno';
$string['preview'] = 'Pregled';
$string['previewhtml'] = 'Pregled u HTML formatu';
$string['previeworchoose'] = 'Pregled ili izbor šeme izgleda sajta';
$string['previous'] = 'Prethodni';
$string['previouslyselectedusers'] = 'Prethodno izabrani korisnik se ne poklapa sa \'{$a}\'';
$string['previoussection'] = 'Prethodna sekcija';
$string['primaryadminsetup'] = 'Podesi nalog administratora';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Ovaj opis korisničkog profila neće biti prikazan sve dok se korisnik ne upiše barem na jedan kurs.';
$string['publicprofile'] = 'Javni profil';
$string['publicsitefileswarning'] = 'Napomena: Datotekama koje su ovde smeštene svi mogu pristupiti.';
$string['publicsitefileswarning2'] = 'Napomena: Datotekam koje su ovde smeštene može da pristupi svako ko zna (ili pogodi) URL. Iz razloga bezbednosti, preporučuje se brisanje datoteka rezervne kopije odmah nakon nakon zavšetka njihovog restauriranja.';
$string['publicsitefileswarning3'] = 'Napomena: Datotekama koje su ovde postavljene može da pristupi svako ko zna (ili može da pogodi) URL.<br /> Iz razloga bezbednosti, datoteke rezervne kopije bi trebalo da budu čuvane samo u zato predviđenom direktorijumu (backupdata).';
$string['publish'] = 'Objavi';
$string['question'] = 'Pitanje';
$string['questionsinthequestionbank'] = 'Pitanja u banci pitanja';
$string['readinginfofrombackup'] = 'Učitavanje informacija iz rezervne kopije';
$string['readme'] = 'Pročitaj me';
$string['recentactivity'] = 'Nedavna aktivnost';
$string['recentactivityreport'] = 'Potpuni izveštaj o nedavnim aktivnostima...';
$string['recipientslist'] = 'Spisak primalaca';
$string['recreatedcategory'] = 'Ponovno kreirana kategorija {$a}';
$string['redirect'] = 'Preusmeri';
$string['reducesections'] = 'Smanji broj sekcija';
$string['refresh'] = 'Osveži';
$string['refreshingevents'] = 'Osvežavanje događaja';
$string['registration'] = 'Moodle registracija';
$string['registrationcontact'] = 'Javni kontakt';
$string['registrationcontactno'] = 'Ne, ne želim kontaktnu formu na spisku sajtova';
$string['registrationcontactyes'] = 'Da, prikažite formu kako bi me drugi Moodle korisnici mogli kontaktirati';
$string['registrationemail'] = 'Obaveštenja putem e-pošte';
$string['registrationinfo'] = '<p>Ova strana Vam omogućava da registrujete Vaš Moodle sajt na moodle.org. Registracija je besplatna.
Glavna korist registracije je u tome što ćete biti dodati na listu za primanje važnih obaveštenja putem elektronske pošte, kao što su sigurnosna upozorenja i nova izdanja Moodle CMS-a. Ova lista se koristi vrlo razumno i štedljivo, odnosno samo za zaista važne informacije.</p>
<p>Podrazumeva se da će sve informacije koje nam dostavite biti poverljive, i da neće biti prosleđene dalje, prodate ili na bilo koji drugi način zloupotrebljene.
Jedini razlog prikupljanja informacija je u svrhu podrške i pomoći u izgradnji statističke slike Moodle zajednice u celini.</p>
<p>Ako želite, ime Vašeg sajta, državu i URL možete dodati na javnu listu Moodle sajtova.
</p><p>Sve nove registracije se ručno proveravaju pre dodavanja na listu.
Kad se jednom nađete na listi, možete ažurirati Vašu registraciju (i informacije na javnoj listi) u bilo koje vreme, tako što ćete nam ponovo poslati ovu formu.</p>';
$string['registrationinfotitle'] = 'Informacija o registraciji';
$string['registrationno'] = 'Ne, ne želim da primam obaveštenja putem e-pošte';
$string['registrationsend'] = 'Slanje registracionih informacija na moodle.org';
$string['registrationyes'] = 'Da, molim obaveštavajte me o važnim dešavanjima';
$string['reject'] = 'Odbaci';
$string['rejectdots'] = 'Odbaci';
$string['reload'] = 'Učitaj ponovo';
$string['remoteappuser'] = 'Udaljeni {$a} Korisnik';
$string['remove'] = 'Ukloni';
$string['removeadmin'] = 'Ukloni administratora';
$string['removecreator'] = 'Ukloni kreatora kursa';
$string['removestudent'] = 'Ukloni polaznika';
$string['removeteacher'] = 'Ukloni predavača';
$string['rename'] = 'Preimenovanje';
$string['renamefileto'] = 'Preimenovanje <b>{$a}</b> u';
$string['report'] = 'Izveštaj';
$string['reports'] = 'Izveštaji';
$string['repositories'] = 'Repozitorijum';
$string['requestcourse'] = 'Zahtevaj kurs';
$string['requestedby'] = 'Zahtevan od stane';
$string['requestedcourses'] = 'Zahtevani kursevi';
$string['requestreason'] = 'Razlog za zahtevanje kursa';
$string['required'] = 'Obavezno';
$string['requirespayment'] = 'Ovaj kurs zahteva plaćanje za pristup';
$string['reset'] = 'Resetovanje';
$string['resetcomponent'] = 'Komponenta';
$string['resetcourse'] = 'Resetovanje kursa';
$string['resetinfo'] = 'Ova stranica Vam dozvoljava da iz kursa izbrišete sve podatke o korisnicima, zadržavajući aktivnosti i druga podešavanja. Molimo budite obazrivi jer izborom stavki ispod i potvrđivanjem ove forme trajno brišete izabrane korisnike i sve podatke vezane za njih sa ovog kursa!';
$string['resetnotimplemented'] = 'Resetovanje nije izvršeno';
$string['resetrecordexpired'] = 'Link za promenu lozinke koji ste koristi je istekao jer je stariji od {$a} minuta. Molimo vas da ponovo pokrenete zahtev za promenu lozinku.';
$string['resetstartdate'] = 'Resetuj datuma početka';
$string['resetstatus'] = 'Status';
$string['resettask'] = 'Zadatak';
$string['resettodefaults'] = 'Vraćanje na podrazumevane vrednosti';
$string['resortbyfullname'] = 'Po punom nazivu';
$string['resortbyidnumber'] = 'Po id broju';
$string['resortbyshortname'] = 'Po skraćenom nazivu';
$string['resortcourses'] = 'Sortiraj kurseve';
$string['resortsubcategoriesbyidnumber'] = 'Sortiraj potkategorije po id broju';
$string['resortsubcategoriesbyname'] = 'Sortiraj potkategorije po nazivu';
$string['resource'] = 'Resurs';
$string['resourcedisplayauto'] = 'Automatski';
$string['resourcedisplaydownload'] = 'Primoraj na preuzimanje';
$string['resourcedisplayembed'] = 'Ugradi (Embed)';
$string['resourcedisplayframe'] = 'U okviru (frame)';
$string['resourcedisplaynew'] = 'Novi prozor';
$string['resourcedisplayopen'] = 'Otvori';
$string['resourcedisplaypopup'] = 'U iskačućem prozoru';
$string['resources'] = 'Resursi';
$string['resources_help'] = 'Resursi omogućavaju dodavanje bilo koje vrste Web sadržaja na Vaš kurs.';
$string['restore'] = 'Restauriranje rezervne kopije';
$string['restorecancelled'] = 'Restauriranje je otkazano';
$string['restorecannotassignroles'] = 'Procedura obnavljanja rezervne kopije podataka mora da dodeli uloge, a Vi nemate ovlašćenje za to';
$string['restorecannotcreateorassignroles'] = 'Procedura obnavljanja rezervne kopije podataka mora da kreira ili dodeli uloge, a Vi nemate ovlašćenje za to';
$string['restorecannotcreateuser'] = 'Procedura obnavljanja rezervne kopije podataka mora da kreira korisnika \'{$a}\', a Vi nemate ovlašćenje za to';
$string['restorecannotoverrideperms'] = 'Procedura obnavljanja rezervne kopije podataka mora da izmeni ovlašćenja, a Vi nemate ovlašćenje za to';
$string['restorecoursenow'] = 'Restaurirajte ovaj kurs upravo sada!';
$string['restoredaccount'] = 'Obnovljeni korisnički nalog';
$string['restoredaccountinfo'] = 'Ovaj korisnički nalog je uvezen sa drugog servera i lozinka je izgubljena. Kako biste zadali novu lozinku pomoću e-pošte, kliknite na "Nastavi"';
$string['restorefinished'] = 'Restauriranje je uspešno završeno';
$string['restoreto'] = 'Restaurirati u';
$string['restoretositeadding'] = 'Upozorenje! Želite da restaurirate rezervnu kopiju na naslovnu stranicu sajta, tako što ćete postojećem pridodati novi sadržaj!';
$string['restoretositedeleting'] = 'Upozorenje! Želite da restaurirate rezervnu kopiju na naslovnu stranicu sajta, tako što ćete prvo obrisati postojeći sadržaj sa nje!';
$string['restoreuserconflict'] = 'Pokušaj restauriranja korisnika \'{$a}\' iz rzervene kopije podataka će prouzrokovati konflikt';
$string['restoreuserinfofailed'] = 'Proces restauriranja podataka je zaustavljen jer nemate ovlašćenja za restauriranje korisničkih podataka.';
$string['restoreusersprecheck'] = 'Provera korisničkih podataka';
$string['restoreusersprecheckerror'] = 'Uočeni su određeni problemi prilikom provere korisničkih podataka';
$string['restricted'] = 'Ograničeno';
$string['returningtosite'] = 'Već posedujete korisnički nalog?';
$string['returntooriginaluser'] = 'Vrati se na {$a}';
$string['revert'] = 'Vratite se nazad';
$string['role'] = 'Uloga';
$string['roleassignments'] = 'Dodela uloge';
$string['rolemappings'] = 'Mapiranja uloga';
$string['rolerenaming'] = 'Preimenovanje uloge';
$string['rolerenaming_help'] = 'Ovo podešavanje omogućava promenu prikazanih naziva za uloge koje se koriste na kursu. Menja se samo prikazani naziv  uloge - ovlašćenja uloge ostaju ista. Novi nazivi uloga će se pojaviti na stranici sa učesnicima kursa i svim ostalim mestima unutar kursa. Ukoliko je uloga kojoj je promenjen naziv jedna od onih koju je administrator izabrao kao "menadžer kursa", novi naziv uloge će se, takođe, pojaviti i kao deo spiska kurseva.';
$string['roles'] = 'Uloge';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Broj novih RSS članaka';
$string['rsserror'] = 'Greška u čitanju RSS podataka';
$string['rsserrorauth'] = 'RSS link ne sadrži ispravan token za proveru identiteta.';
$string['rsserrorguest'] = 'Ovaj RSS izvor vesti koristi anonimni  (kao gost) pristup podacima, ali gosti ovde nemaju ovlašćenje za  čitanje podataka. Posetite izvornu lokaciju sa koje ovaj izvor vesti dolazi (URL) kao registrovani korisnik i preuzmite odatle novi RSS link.';
$string['rsskeyshelp'] = 'Da bi se obezbedila sigurnost i privatnost, URL adresa RSS izvora sadrži specijalni token koji identifikuje korisnika za koga je token kreiran. Ovo će sprečiti druge korisnike da preko RSS izvora pristupe onim delovima Moodlea kojima to ne bi smeli.
Ovaj token se automatski kreira kada prvi put pristupate delu Moodlea koji proizvodi RSS izvor. Ako mislite da je je vaš token RSS izvora na neki način kompromitovan možete zatražiti novi token tako što ćete ovde kliknuti na link \'Resetuj\'. Molimo vas, imajte u vidu da će trenutna URL adresa RSS izvora postati nevažeća.';
$string['rsstype'] = 'RSS servis za ovu aktivnost';
$string['saveandnext'] = 'Sačuvaj i prikaži sledeće';
$string['savechanges'] = 'Sačuvaj promene';
$string['savechangesanddisplay'] = 'Sačuvaj i prikaži';
$string['savechangesandreturntocourse'] = 'Sačuvaj i vrati se na kurs';
$string['savecomment'] = 'Sačuvaj komentar';
$string['savedat'] = 'Sačuvano u:';
$string['savepreferences'] = 'Sačuvaj svojstva';
$string['saveto'] = 'Sačuvaj u';
$string['scale'] = 'Skala za ocenjivanje';
$string['scale_help'] = 'Skala pruža način za evaluaciju ili ocenjivanja postignuća u aktivnosti. Definisana je kao uređena lista vrednosti, u rasponu od negativnih do pozitivnih, odvojenih zarezima. Na primer: "Razočaravajuće, Nedovoljno dobro, Prosečno, Dobro, Vrlo dobro, Odlično!"';
$string['scales'] = 'Skale za ocenjivanje';
$string['scalescustom'] = 'Prilagođene skale za ocenjivanje';
$string['scalescustomcreate'] = 'Dodaj novu skalu za ocenjivanje';
$string['scalescustomno'] = 'Prilagođene skale za ocenjivanje još uvek nisu kreirane';
$string['scalesstandard'] = 'Standardne skale za ocenjivanje';
$string['scalestandard'] = 'Standardna skala';
$string['scalestandard_help'] = 'Standardna skala je dostupna na nivou celog sajta, za sve kurseve.';
$string['scalestip'] = 'Kako biste kreirali sopstvene, prilagođene skale za ocenjivanje, upotrebite link \'Skale...\' u meniju za administraciju kursa.';
$string['scalestip2'] = 'Da bi ste kreirali prilagođene skale, kliknite na link Ocene u administrativnom meniju kursa, a onda izaberite Uredi Skale';
$string['schedule'] = 'Raspored';
$string['screenshot'] = 'Snimak ekrana';
$string['search'] = 'Pretraga';
$string['searchagain'] = 'Ponovna pretraga';
$string['searchbyemail'] = 'Pretraživanje po adresi e-pošte';
$string['searchbyusername'] = 'Pretraživanje po korisničkom imenu';
$string['searchcourses'] = 'Pretraži kurseve';
$string['searchhelp'] = '<p> Možete da pretražujete više reči odjednom. kao i da  precizirate svoju pretragu na sledeći način:</p>
<ul>
<li>reč- nalazi bilo koje pojavljivanje ove reči unutar teksta koji se pretražuje (pa i u sklopu drugih reči).</li>
<li>+reč – biće pronađena samo reči koje se potpuno poklapaju.</li>
<li>-reč – u rezultate pretrage se ne uključuje ova reč.</li>
</ul>';
$string['search_help'] = 'Za osnovno pretraživanje jedne ili više reči bilo gde u tekstu, samo ih upišite odvojene razmacima. Mogu se pretraživati sve reči duže od 2 znaka.

Za napredno pretraživanje, kliknite na dugme za pretragu bez upisivanja pojmova u polje za pretragu, kako biste pristupili obrascu za napredno pretraživanje.';
$string['searchoptions'] = 'Opcije za pretragu';
$string['searchresults'] = 'Rezultati pretrage';
$string['sec'] = 'sek';
$string['seconds'] = 'sekund/e';
$string['secondstotime172800'] = '2 dana';
$string['secondstotime259200'] = '3 dana';
$string['secondstotime345600'] = '4 dana';
$string['secondstotime432000'] = '5 dana';
$string['secondstotime518400'] = '6 dana';
$string['secondstotime604800'] = '1 sedmica';
$string['secondstotime86400'] = '1 dan';
$string['secretalreadyused'] = 'Link za potvrdu promene šifre je već korišten, šifra nije bila promenjena.';
$string['secs'] = 's';
$string['section'] = 'Sekcija';
$string['sectionname'] = 'Naziv sekcije';
$string['sections'] = 'Sekcije';
$string['sectionusedefaultname'] = 'Koristi podrazumevano ime sekcije';
$string['seealsostats'] = 'Pogledajte i statistiku';
$string['selctauser'] = 'Izaberi korisnika';
$string['select'] = 'Izaberite';
$string['selectacategory'] = 'Molimo vas da izaberete kategoriju';
$string['selectacountry'] = 'Izaberi državu';
$string['selectacourse'] = 'Izaberi kurs';
$string['selectacoursesite'] = 'Izaberi kurs  ili sajt';
$string['selectagroup'] = 'Izaberi grupu';
$string['selectall'] = 'Izaberi sve';
$string['selectamodule'] = 'Molimo izaberite modul aktivnosti';
$string['selectanaction'] = 'Izaberi akciju';
$string['selectanoptions'] = 'Izaberi opciju';
$string['selectaregion'] = 'Izaberi region';
$string['selectcategorysort'] = 'Koje kategorije želite da sortirate?';
$string['selectcategorysortby'] = 'Izaberite kako želite da sortirate kategorije';
$string['selectcoursesortby'] = 'Izaberite kako želite da poređate kurseve';
$string['selectdefault'] = 'Izaberi podrazumevano';
$string['selectedcategories'] = 'Izabrane kategorije';
$string['selectedfile'] = 'Izabrana datoteka';
$string['selectednowmove'] = '{$a} datoteka označeno za premeštanje. Sada idite na mesto gde želite da premestite datoteke i kliknite na \'Premesti datoteke ovde\'';
$string['selectfiles'] = 'Odaberite datoteke';
$string['selectmoduletoviewhelp'] = 'Izaberite aktivnost ili resurs kako biste videli pomoćne informacije o njima.

Da biste brzo dodali aktivnost ili resurs kliknite dva puta na naziv odgovarajuće aktivnosti odnosno resursa.';
$string['selectnos'] = 'Izaberite \'Ne\' za sve';
$string['selectperiod'] = 'Izaberite period';
$string['senddetails'] = 'Pošalji moje lične podatke e-poštom';
$string['separate'] = 'Odvoji';
$string['separateandconnected'] = 'Odvojeni i povezani načini saznavanja';
$string['separateandconnectedinfo'] = 'Ova skala se zasniva na teoriji odvojenog i povezanog saznavanja. Ova teorija opisuje dva različita načina na koje možemo da učimo o stvarima koje vidimo i čujemo. <ul> <li><strong>Odvojeni način učenja</strong> - polaznici ostaju objektivni što je više moguće bez uključivanja osećanja. U diskusiji sa drugim ljudima, oni vole da brane svoje ideje i stavove, koristeći logiku kako bi pronašli nedostatke u idejama svojih oponenata.</li> <li><strong>Povezani način učenja</strong> - učenici su više osetljivi na druge ljude. Oni imaju razvijenu sposobnost empatije i pokazuju tendenciju da slušaju i postavljaju pitanja dok ne osete da mogu "razumeti stvari iz ugla gledanja svojih sagovornika". Oni uče tako što pokušavaju da dele iskustva koja vode znanju koje pronalaze kod drugih ljudi.</li></ul>';
$string['servererror'] = 'Došlo je do greške u toku komunikacije sa serverom';
$string['serverlocaltime'] = 'Lokalno vreme servera';
$string['setcategorytheme'] = 'Podesi grafičku temu kategorije';
$string['setpassword'] = 'Podesi lozinku';
$string['setpasswordinstructions'] = 'Molimo vas da unesete i ponovite svoju novu lozinku ispod i potom kliknete na "Podesi lozinku". <br />Vaša nova lozinka biće sačuvana a vi ćete biti prijavljeni';
$string['settings'] = 'Podešavanja';
$string['shortname'] = 'Kratki naziv';
$string['shortnamecollisionwarning'] = '[*] = Ovaj kratki naziv već koristi neki drugi kurs, te će morati biti promenjen po odobravanju';
$string['shortnamecourse'] = 'Skraćeni naziv kursa';
$string['shortnamecourse_help'] = 'Skraćen naziv kursa se prikazuje u navigaciji i kao deo naslova elektronske poruke koja se šalje sa sa kursa.';
$string['shortnametaken'] = 'Navedena skraćenica je već u upotrebi za neki drugi kurs ({$a})';
$string['shortnameuser'] = 'Kraće ime korisnika';
$string['shortsitename'] = 'Kratki naziv sajta (npr. jedna reč)';
$string['show'] = 'Prikaži';
$string['showactions'] = 'Prikaži akcije';
$string['showadvancedsettings'] = 'Prikaži naprednih podešavanja';
$string['showall'] = 'Prikaži svih {$a}';
$string['showallcourses'] = 'Prikaži sve kurseve';
$string['showallusers'] = 'Prikaži sve korisnike';
$string['showblockcourse'] = 'Prikaži spisak kurseva koji sadrže blokove';
$string['showcategory'] = 'Prikaži {$a}';
$string['showcomments'] = 'Prikaži/sakrij komentare';
$string['showcommentsnonjs'] = 'Prikaži komentare';
$string['showdescription'] = 'Prikaži opis na stranici kursa';
$string['showdescription_help'] = 'Ako je ovo podešavanje omogućeno, gornji opis biće prikazan na stranici kursa odmah ispod linka aktivnosti ili resursa.';
$string['showgrades'] = 'Prikaži ocene polaznika';
$string['showgrades_help'] = 'Mnoge aktivnosti na kursu se mogu ocenjivati. Ovo podešavanje određuje da li polaznik može da vidi spisak svih svojih ocena na kursu preko linka Ocene u bloku za administraciju kursa.';
$string['showingacourses'] = 'Prikaz svih {$a} kurs(ev)a';
$string['showingxofycourses'] = 'Prikaz kurseva {$a->start} do {$a->end} od ukupno {$a->total} kurs(ev)a';
$string['showlistofcourses'] = 'Prikaži spisak kurseva';
$string['showmodulecourse'] = 'Prikaži spiska kurseva koji sadrže aktivnosti';
$string['showonly'] = 'Prikaži samo';
$string['showperpage'] = 'Prikaži {$a} po stranici';
$string['showrecent'] = 'Prikaži nedavne aktivnosti';
$string['showreports'] = 'Prikaži izveštaja o aktivnostima';
$string['showreports_help'] = 'Izveštaji o aktivnostima prikazuju aktivnost svakog učesnika na kursu. Osim popisa njihovih doprinosa, poput poruka na forumima ili predatih radova za zadatke, ovi izveštaji, takođe, uključuju zapise o pristupima. Ovo podešavanje određuje da li polaznici mogu da vide izveštaje o svojoj aktivnosti, preko njihovih stranica sa profilom.';
$string['showsettings'] = 'Prikaži podešavanja';
$string['showtheselogs'] = 'Prikaži ove zapise o aktivnostima';
$string['showthishelpinlanguage'] = 'Prikaži ovu pomoć na jeziku: {$a}';
$string['since'] = 'Od';
$string['sincelast'] = 'od poslednjeg pristupa sistemu';
$string['site'] = 'Sajt';
$string['sitedefault'] = 'Podrazumevano za sajt';
$string['siteerrors'] = 'Greške na sajtu';
$string['sitefiles'] = 'Datoteke sajta';
$string['sitefilesused'] = 'Datoteke sajta korišćeni u ovom kursu';
$string['sitehome'] = 'Naslovna strana sajta';
$string['sitelegacyfiles'] = 'Izvorne datoteke sajta';
$string['sitelogs'] = 'Zapisi o aktivnostima na sajtu';
$string['sitemessage'] = 'Pošalji poruku korisnicima';
$string['sitenews'] = 'Novosti';
$string['sitepages'] = 'Stranice sajta';
$string['sitepartlist'] = 'Nemate odgovarajuće dozvole za pregled spiska učesnika';
$string['sitepartlist0'] = 'Morate biti predavač sajta da bi Vam bilo dozvoljeno da vidite spisak učesnika sajta.';
$string['sitepartlist1'] = 'Morate biti predavač da bi Vam bilo dozvoljeno da vidite spisak učesnika sajta.';
$string['sites'] = 'Sajtovi';
$string['sitesection'] = 'Uključi i tematsku sekciju';
$string['sitesettings'] = 'Podešavanja sajta';
$string['siteteachers'] = 'Predavači sajta';
$string['size'] = 'Veličina';
$string['sizeb'] = 'bajta';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['skipped'] = 'Preskočeno';
$string['skiptocategorylisting'] = 'Pređi na spisak kategorija';
$string['skiptocoursedetails'] = 'Pređi na detaljne informacije o kursu';
$string['skiptocourselisting'] = 'Pređi na spisak kurseva';
$string['skypeid'] = 'Skype ID';
$string['socialheadline'] = 'Društveni forum - najnovije teme';
$string['someallowguest'] = 'Neki od kurseva mogu dozvoliti pristup gostima (anonimnim korisnicima)';
$string['someerrorswerefound'] = 'Pojedine informacije nedostaju ili su netačne. Pogledajte detalje ispod.';
$string['sort'] = 'Sortiraj';
$string['sortby'] = 'Sortiraj po';
$string['sortbyx'] = 'Sortiraj po {$a} rastućim redosledom';
$string['sortbyxreverse'] = 'Sortiraj po {$a} rastućim redosledom';
$string['sortcategoriesbyidnumber'] = 'Sortiraj kategorije po ID broju';
$string['sortcategoriesbyname'] = 'Sortiraj kategorije po nazivu';
$string['sortcoursesbyfullname'] = 'Sortiraj kategorije po punom nazivu';
$string['sortcoursesbyidnumber'] = 'Sortiraj kurseve po ID broju';
$string['sortcoursesbyshortname'] = 'Sortiraj kurseve po skraćenom nazivu';
$string['sorting'] = 'Sortiranje';
$string['sourcerole'] = 'Izvorna uloga';
$string['specifyname'] = 'Morate navesti ime.';
$string['standard'] = 'Standardno';
$string['starpending'] = '([*] = kurs čeka na odobrenje)';
$string['startdate'] = 'Datum početka kursa';
$string['startdate_help'] = 'Ovo podešavanje određuje početak prve nedelje za kurs u nedeljnom formatu. Ono takođe određuje najraniji datum za koji će biti dostupni izveštaji o aktivnostima na kursu.';
$string['startingfrom'] = 'Počni od';
$string['startsignup'] = 'Kreiraj novi nalog';
$string['state'] = 'Država/Republika';
$string['statistics'] = 'Statistika';
$string['statisticsgraph'] = 'Grafikon statistike';
$string['stats'] = 'Statistika';
$string['statslogins'] = 'Pristupi sistemu';
$string['statsmodedetailed'] = 'Detaljni (korisnički) prikaz';
$string['statsmodegeneral'] = 'Opšti prikaz';
$string['statsnodata'] = 'Nema dostupnih podataka za tu kombinaciju kursa i vremenskog perioda.';
$string['statsnodatauser'] = 'Nema dostupnih podataka za tu kombinaciju kursa, korisnika i vremenskog perioda.';
$string['statsoff'] = 'Statistika trenutno nije omogućeno';
$string['statsreads'] = 'Pregledi';
$string['statsreport1'] = 'Pristupi sistemu';
$string['statsreport10'] = 'Aktivnost korisnika';
$string['statsreport11'] = 'Najaktivniji kursevi';
$string['statsreport12'] = 'Najaktivniji kursevi (vrednosno)';
$string['statsreport13'] = 'Kursevi sa najviše učešća (upisa)';
$string['statsreport14'] = 'Kursevi sa najviše učešća (prikaza/poruka)';
$string['statsreport2'] = 'Prikazi (sve uloge)';
$string['statsreport3'] = 'Poruke (sve uloge)';
$string['statsreport4'] = 'Ukupna aktivnost (sve uloge)';
$string['statsreport5'] = 'Ukupna aktivnost (prikazi i poruke)';
$string['statsreport7'] = 'Polaznička aktivnost (prikazi i poruke)';
$string['statsreport8'] = 'Sve aktivnosti korisnika';
$string['statsreport9'] = 'Pristupi (sajtu/kursu)';
$string['statsreportactivity'] = 'Ukupna aktivnost (sve uloge)';
$string['statsreportactivitybyrole'] = 'Ukupna aktivnost (pregledi i poruke)';
$string['statsreportforuser'] = 'za';
$string['statsreportlogins'] = 'Pristupi sistemu';
$string['statsreportreads'] = 'Prikazi (sve uloge)';
$string['statsreporttype'] = 'Tip izveštaja';
$string['statsreportwrites'] = 'Poruke (sve uloge)';
$string['statsstudentactivity'] = 'Aktivnost polaznika';
$string['statsstudentreads'] = 'Pregledi polaznika';
$string['statsstudentwrites'] = 'Objave polaznika';
$string['statsteacheractivity'] = 'Aktivnost predavača';
$string['statsteacherreads'] = 'Prikazi predavača';
$string['statsteacherwrites'] = 'Poruke predavača';
$string['statstimeperiod'] = 'Vremenski period - trajanje:';
$string['statsuniquelogins'] = 'Različiti pristupi sistemu';
$string['statsuseractivity'] = 'Sve aktivnosti';
$string['statsuserlogins'] = 'Pristupi sistemu';
$string['statsuserreads'] = 'Prikazi';
$string['statsuserwrites'] = 'Poruke';
$string['statswrites'] = 'Poruke';
$string['status'] = 'Status';
$string['stringsnotset'] = 'Sledeći izrazi nisu definisani u {$a}';
$string['studentnotallowed'] = 'Nažalost, ne možete pristupiti ovom kursu kao \'{$a}\'';
$string['students'] = 'Polaznici';
$string['studentsandteachers'] = 'Polaznici i predavači';
$string['subcategories'] = 'Potkategorije';
$string['subcategory'] = 'Potkategorija';
$string['subcategoryof'] = 'Potkategorija od {$a}';
$string['submit'] = 'Prosledi';
$string['success'] = 'Uspešno';
$string['summary'] = 'Rezime';
$string['summary_help'] = 'Sažetak je kratаk tekst koji priprema polaznike za aktivnosti unutar određene teme odnosno nedelje. Tekst se prikazuje na stranici kursa ispod naziva sekcije.';
$string['summaryof'] = 'Rezime za {$a}';
$string['supplyinfo'] = 'Više detalja';
$string['suspended'] = 'Suspendovan';
$string['suspendedusers'] = 'Suspendovani korisnici';
$string['switchdevicedefault'] = 'Prelazak na standardnu grafičku temu';
$string['switchdevicerecommended'] = 'Prelazak na preporučenu grafičku temu za vaš uređaj';
$string['switchrolereturn'] = 'Povratak na moju normalnu ulogu';
$string['switchroleto'] = 'Promeni ulogu u...';
$string['tag'] = 'Oznaka';
$string['tagalready'] = 'Oznaka već postoji';
$string['tagmanagement'] = 'Dodaj/obriši oznake...';
$string['tags'] = 'Oznake';
$string['targetrole'] = 'Ciljna uloga';
$string['teacheronly'] = 'samo za {$a}';
$string['teacherroles'] = '{$a} uloge';
$string['teachers'] = 'Predavači';
$string['textediting'] = 'Editor teksta';
$string['texteditor'] = 'Koristiti standardne Web forme';
$string['textformat'] = 'Običan tekstualni format';
$string['thanks'] = 'Hvala';
$string['theme'] = 'Grafička tema';
$string['themes'] = 'Grafičke teme';
$string['themesaved'] = 'Nova grafička tema je sačuvana';
$string['therearecourses'] = 'Postoji {$a} kurs/a/eva';
$string['thereareno'] = 'Ne postoje {$a} u ovom kurs';
$string['thiscategory'] = 'Ova kategorija';
$string['thiscategorycontains'] = 'Ova kategorija sadrži';
$string['time'] = 'Vreme';
$string['timezone'] = 'Vremenska zona';
$string['to'] = 'Do';
$string['tocontent'] = 'Odredišna stavka "{$a}"';
$string['tocreatenewaccount'] = 'Preskoči za kreiranje novog korisničkog naloga';
$string['today'] = 'Danas';
$string['todaylogs'] = 'Današnji zapisi o aktivnostima';
$string['toeveryone'] = 'svima';
$string['toomanybounces'] = 'Sa ove elektronske adrese vratilo se previše poruka. <b>Morate</b> je promeniti da biste nastavili.';
$string['toomanytoshow'] = 'Previše korisnika za prikaz';
$string['toomanyusersmatchsearch'] = 'Previše korisnika ({$a->count}) se poklapa sa\'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Previše korisnika za prikaz ({$a}) to show';
$string['toonly'] = 'samo za {$a}';
$string['top'] = 'Vrh';
$string['topic'] = 'Tema';
$string['topichide'] = 'Sakrivanje ove teme od {$a}';
$string['topicoutline'] = 'Pregled teme';
$string['topicshow'] = 'Prikaz ove teme za {$a}';
$string['toplevelcategory'] = 'Kategorija najvišeg nivoa';
$string['total'] = 'Ukupno';
$string['totopofsection'] = 'Na početak sekcije "{$a}"';
$string['trackforums'] = 'Praćenje foruma';
$string['trackforumsno'] = 'NE: ne beleži informacije o tome koje sam poruke prethodno pročitao/la';
$string['trackforumsyes'] = 'DA: istakni nove poruke';
$string['trysearching'] = 'Pokušajte sa pretraživanjem.';
$string['turneditingoff'] = 'Isključi uređivanje';
$string['turneditingon'] = 'Uključi uređivanje';
$string['undecided'] = 'Neodlučni';
$string['unfinished'] = 'Nedovršeno';
$string['unknowncategory'] = 'Nepoznata kategorija';
$string['unknownerror'] = 'Nepoznata greška';
$string['unlimited'] = 'Neograničeno';
$string['unpacking'] = 'Raspakuje se {$a}';
$string['unsafepassword'] = 'Nesigurna lozinka - probajte nešto kompleksnije';
$string['untilcomplete'] = 'Dok se ne završi';
$string['unusedaccounts'] = 'Korisnički nalozi koji se ne koriste {$a} dana se automatski ispisuju';
$string['unzip'] = 'Raspakuj';
$string['unzippingbackup'] = 'Raspakuje se rezervna kopija';
$string['up'] = 'Gore';
$string['update'] = 'Ažuriranje';
$string['updated'] = 'Ažurirano {$a}';
$string['updatemymoodleoff'] = 'Prestani sa uređivanjem ove stranice';
$string['updatemymoodleon'] = 'Uredi ovu stranicu';
$string['updatemyprofile'] = 'Ažuriraj profil';
$string['updatesevery'] = 'Ažuriranje na svakih {$a} sekundi';
$string['updatethis'] = 'Ažuriraj';
$string['updatethiscourse'] = 'Ažuriraj ovaj kurs';
$string['updatinga'] = 'Ažuriranje: {$a}';
$string['updatingain'] = 'Ažuriranje {$a->what} u {$a->in}';
$string['upload'] = 'Postavi';
$string['uploadafile'] = 'Postavljanje datoteke';
$string['uploadcantwrite'] = 'Neuspešno upisivanje datoteke na disk';
$string['uploadedfile'] = 'Datoteka je uspešno postavljena';
$string['uploadedfileto'] = 'Datoteka {$a->file} je postavljena u direktorijum {$a->directory}';
$string['uploadedfiletoobig'] = 'Nažalost, navedena datoteka je prevelika (ograničenje iznosi {$a} bajta)';
$string['uploadextension'] = 'Postavljanje datoteke prekinuto od strane PHP  ekstenzije';
$string['uploadfailednotrecovering'] = 'Postavljanje Vaših datoteka nije uspelo jer je uočen problem sa jednom od njih, {$a->name}.<br /> Ovde je izveštaj o uočenim problemima:<br />{$a->problem}<br />Nema oporavka.';
$string['uploadfilelog'] = 'Izveštaj o postavljanju datoteke {$a}';
$string['uploadformlimit'] = 'Postavljena datoteka {$a} je premašila ograničenje za maksimalnu veličinu određenu obrascem';
$string['uploadlabel'] = 'Naslov:';
$string['uploadlimitwithsize'] = '{$a->contextname} - ograničenje za postavljanje datoteka ({$a->displaysize})';
$string['uploadnewfile'] = 'Postavi novu datoteku';
$string['uploadnofilefound'] = 'Datoteka nije pronađena - jeste li sigurni da ste odabrali datoteku za postavljanje?';
$string['uploadnotallowed'] = 'Postavljanje nije dozvoljeno';
$string['uploadnotempdir'] = 'Nedostaje privremeni direktorijum';
$string['uploadoldfilesdeleted'] = 'Stare datoteke u Vašem odeljku za postavljanje su obrisane';
$string['uploadpartialfile'] = 'Postavljanje datoteke nije izvršeno u potpunosti';
$string['uploadproblem'] = 'Prilikom postavljanja datoteke \'{$a}\' dogodila se nepoznata greška (možda je navedena datoteka bila prevelika?)';
$string['uploadrenamedchars'] = 'Datoteka je preimenovana sa {$a->oldname} na {$a->newname} jer je njen naziv sadržao nedozvoljene karaktere.';
$string['uploadrenamedcollision'] = 'Datoteka je preimenovana sa {$a->oldname} na {$a->newname} jer je došlo do konflikta sa nazivom neke druge datoteke.';
$string['uploadserverlimit'] = 'Datoteka koja je postavljena je veća od maksimalne veličine dozovoljene ograničenjem ovog servera';
$string['uploadthisfile'] = 'Postavi datoteku';
$string['url'] = 'URL';
$string['used'] = 'Korišćeno';
$string['usedinnplaces'] = 'Koristi se na {$a} mesta';
$string['usemessageform'] = 'ili koristite formu ispod da pošaljete poruku izabranim polaznicima';
$string['user'] = 'Korisnik';
$string['userconfirmed'] = 'Potvrđen {$a}';
$string['usercurrentsettings'] = 'Podešavanja mog profila';
$string['userdata'] = 'Podaci o korisniku';
$string['userdeleted'] = 'Ovaj korisnički nalog je obrisan';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'Ovdе možete uneti podatke o sebi koji će biti prikazani na stranici Vašeg profila i koje će moći da vide drugi korisnici.';
$string['userdetails'] = 'Detalji o korisniku';
$string['userfiles'] = 'Korisničke datoteke';
$string['userlist'] = 'Spisak korisnika';
$string['username'] = 'Korisničko ime';
$string['usernameemailmatch'] = 'Korisničko ime i adresa e-pošte se ne odnose na istog korisnika';
$string['usernameexists'] = 'Navedeno korisničko ime već postoji, izaberite neko drugo';
$string['usernamelowercase'] = 'Dozvoljena su samo mala slova';
$string['usernamenotfound'] = 'Korisničko ime nije pronađeno u bazi podataka';
$string['usernameoremail'] = 'Unesite ili korisničko ime ili adresu e-pošte';
$string['usernotconfirmed'] = 'Nije se moglo potvrditi {$a}';
$string['userpic'] = 'Slika korisnika';
$string['users'] = 'Korisnici';
$string['userselectorautoselectunique'] = 'Ako samo jedan korisnik odgovara kriterijumima pretragе neka automatski bude izabran';
$string['userselectorpreserveselected'] = 'Zadrži izabrane korisnike, čak i ako se više ne odgovaraju kriterijumima pretrage';
$string['userselectorsearchanywhere'] = 'Pronađi traženi tekst bilo gde u prikazanim poljima';
$string['usersnew'] = 'Novi korisnici';
$string['usersnoaccesssince'] = 'Neaktivni više od';
$string['userswithfiles'] = 'Korisnici sa datotekama';
$string['useruploadtype'] = 'Tip postavljanja korisnika: {$a}';
$string['userviewingsettings'] = 'Podešavanja profila za korsinika: {$a}';
$string['userzones'] = 'Korisničke zone';
$string['usetheme'] = 'Upotrebi ovu temu';
$string['usingexistingcourse'] = 'Koristeći postojeći kurs';
$string['valuealreadyused'] = 'Ova vrednost je već iskorišćena';
$string['version'] = 'Verzija';
$string['view'] = 'Prikaz';
$string['viewallcourses'] = 'Pogledaj sve kurseve';
$string['viewallcoursescategories'] = 'Pogledaj sve kurseve i kategorije';
$string['viewallsubcategories'] = 'Pogledaj sve potkategorije';
$string['viewfileinpopup'] = 'Pogledaj datoteku u iskačućem prozoru';
$string['viewing'] = 'Pregled:';
$string['viewmore'] = 'Pogledaj još';
$string['viewprofile'] = 'Pregledaj profil';
$string['views'] = 'Prikazi';
$string['viewsolution'] = 'vidi rešenje';
$string['virusfound'] = 'Upozorenje za administratora! Clam AV je našao virus u datoteci koju je korisnik {$a->user} postavio u okviru kursa {$a->course}. Evo rezultata Clam skeniranja:';
$string['virusfoundlater'] = 'U datoteci koja je postavljena dana {$a->date} pod imenom {$a->filename} za kurs {$a->course} je u međuvremenu pronađen virus. Ovde je sažeti izveštaj o tome šta se tokom vremena dešavalo sa datotekom:

{$a->action}

Ako je to bio predati rad, možda želite ponovo da ga predate da bi ga Vaš predavač mogao pregledati.';
$string['virusfoundlateradmin'] = 'Upozorenje za administratora! U datoteci koju je korisnik {$a->user} postavio dana {$a->date} pod imenom {$a->filename} za kurs {$a->course} je u međuvremenu pronađen virus. Ovde je sažeti izveštaj o tome šta se tokom vremena dešavalo sa datotekom:

{$a->action}

Korisnik koji je učitao datoteku je takođe obavešten o tome šta se dogodilo.';
$string['virusfoundlateradminnolog'] = 'Upozorenje za administratora! U datoteci koja je ranije postavljena pod imenom {$a->filename} je u međuvremenu pronađen virus. Moodle nije uspeo da prepravi ovu datoteku u njenu prvobitnu verziju u kakvoj ju je korisnik postavio.

Ovde je sažeti izveštaj o tome šta se tokom vremena dešavalo sa datotekom:

{$a->action}';
$string['virusfoundsubject'] = '{$a}: Pronađen virus!';
$string['virusfounduser'] = 'Datoteka koju ste postavili, {$a->filename}, je skenirana antivirusnim softverom i pronađeno je da je zaražena! Učitavanje Vaše datoteke NIJE uspelo.';
$string['virusplaceholder'] = 'Pronađeno je da je datoteka koja je postavljena sadržala virus, pa je premeštena ili obrisana, a korisnik je o tome obavešten.';
$string['visible'] = 'Vidljivo';
$string['visible_help'] = 'Ovo podešavanje određuje da li će se kurs pojaviti na popisu kurseva. Za razliku od nastavnika i administratora, korisnicima nije dozvoljen ulazak na kurs.';
$string['visibletostudents'] = 'Vidljivo za {$a}';
$string['warning'] = 'Upozorenje';
$string['warningdeleteresource'] = 'Upozorenje: na {$a} se odnosi resurs. Da li želite da ažurirate taj resurs?';
$string['webpage'] = 'Web stranica';
$string['week'] = 'Sedmica';
$string['weekhide'] = 'Sakrij ovu sedmicu od {$a}';
$string['weeklyoutline'] = 'Sedmični pregled dešavanja';
$string['weeks'] = 'nedelja/e';
$string['weekshow'] = 'Prikaz ove sedmice do {$a}';
$string['welcometocourse'] = 'Dobrodošli na kurs {$a}';
$string['welcometocoursetext'] = 'Dobrodošli na kurs {$a->coursename}!

Ukoliko to već niste uradili, trebalo bi da urediti stranicu svog profila, tako da možemo da saznamo nešto više o vama:

{$a->profileurl}';
$string['whatforlink'] = 'Šta želite da uradite sa linkom?';
$string['whatforpage'] = 'Šta želite da uradite sa linkom?';
$string['whattocallzip'] = 'Kako želite da nazovete arhiviranu datoteku?';
$string['whattodo'] = 'Šta uraditi';
$string['windowclosing'] = 'Ovaj prozor bi trebalo da se automatski zatvori. Ako se to nije dogodilo molim vas da ga sada zatvorite.';
$string['withchosenfiles'] = 'Sa izabranim datotekama';
$string['withdisablednote'] = '{$a} (onemogućeno)';
$string['withoutuserdata'] = 'bez korisničkih podataka';
$string['withselectedusers'] = 'Sa izabranim korisnicima...';
$string['withselectedusers_help'] = '* Pošalji poruku - za slanje poruke jednom ili više korisnika
* Dodaj novu belešku - za dodavanje beleške o odabranom korisniku
* Dodaj zajedničku belešku - za dodavanje iste beleške o više korisnika';
$string['withuserdata'] = 's korisničkim podacima';
$string['wordforstudent'] = 'Vaša reč za polaznika';
$string['wordforstudenteg'] = 'npr. polaznik, učesnik, kandidat i sl.';
$string['wordforstudents'] = 'Vaša reč za polaznike';
$string['wordforstudentseg'] = 'npr. polaznici, učesnici, kandidati i sl.';
$string['wordforteacher'] = 'Vaša reč za predavača';
$string['wordforteachereg'] = 'npr. predavač, profesor, moderator i sl.';
$string['wordforteachers'] = 'Vaša reč za predavače';
$string['wordforteacherseg'] = 'npr. predavači, profesori, moderatori i sl.';
$string['writingblogsinfo'] = 'Upisivanje informacija o blogovima';
$string['writingcategoriesandquestions'] = 'Zapisivanje kategorija i pitanja';
$string['writingcoursedata'] = 'Zapisivanje podataka kursa';
$string['writingeventsinfo'] = 'Zapisivanje informacija o događajima';
$string['writinggeneralinfo'] = 'Zapisivanje opštih informacija';
$string['writinggradebookinfo'] = 'Zapisivanje informacija o ocenjivanju';
$string['writinggroupingsgroupsinfo'] = 'Zapisivanje informacija o grupisanjima-grupama';
$string['writinggroupingsinfo'] = 'Zapisivanje informacija o grupacijama';
$string['writinggroupsinfo'] = 'Zapisivanje informacija o grupama';
$string['writingheader'] = 'Zapisivanje zaglavlja';
$string['writingloginfo'] = 'Zapisivanje izveštaja o aktivnostima';
$string['writingmessagesinfo'] = 'Zapisivanje informacija o porukama';
$string['writingmoduleinfo'] = 'Zapisivanje informacija o modulima';
$string['writingscalesinfo'] = 'Zapisivanje informacija o skalama ocenjivanja';
$string['writinguserinfo'] = 'Zapisivanje informacija o korisnicima';
$string['wrongpassword'] = 'Pogrešna lozinka za ovo korisničko ime';
$string['yahooid'] = 'Yahoo ID';
$string['year'] = 'godina';
$string['years'] = 'godina';
$string['yes'] = 'Da';
$string['youareabouttocreatezip'] = 'Upravo ćete započeti kreiranje zip arhive koja sadrži';
$string['youaregoingtorestorefrom'] = 'Upravo ćete započeti restauracioni proces za';
$string['youneedtoenrol'] = 'Da biste izvršili ovu akciju morate se prijaviti na kurs.';
$string['yourlastlogin'] = 'Vaš poslednji pristup sistemu';
$string['yourself'] = 'sebe';
$string['yourteacher'] = 'Vaš {$a}';
$string['yourwordforx'] = 'Vaša reč za \'{$a}\'';
$string['zippingbackup'] = 'Kreira se arhiva sa rezervnom kopijom';
