<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lti', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   lti
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Prihvati';
$string['accept_grades'] = 'Prihvati ocene alata';
$string['accept_grades_admin'] = 'Prihvati ocene alata';
$string['accept_grades_admin_help'] = 'Navedite da li provajder alata može da dodaje, ažurira. čita i briše ocene povezane sa instancama ovog tipa alata.

Neki provajderi podržavaju mogućnost slanja ocena nazad u Moodle na osnovu akcija koje su preduzete u okviru alata, stvarajući na taj način doživljaj veće integrisanosti Moodlea i eksternog alata.';
$string['accept_grades_help'] = 'Navedite da li provajder alata može da dodaje, ažurira. čita i briše ocene povezane sa instancama ovog tipa alata.

Neki provajderi podržavaju mogućnost slanja ocena nazad u Moodle na osnovu akcija koje su preduzete u okviru alata, stvarajući na taj način doživljaj veće integrisanosti Moodlea i eksternog alata.

Imajte u vidu da se ova podešavanja mogu izmeniti u konfiguraciji alata.';
$string['action'] = 'Akcija';
$string['active'] = 'Aktivan';
$string['activity'] = 'Aktivnost';
$string['addnewapp'] = 'Omogući eksternu aplikaciju';
$string['addserver'] = 'Dodaj novi pouzdani server';
$string['addtype'] = 'Dodaj konfiguraciju eksternog alata';
$string['allow'] = 'Dozvoli';
$string['allowinstructorcustom'] = 'Dozvoli predavačima da dodaju prilagođene parametre';
$string['allowsetting'] = 'Dozvoli da alat unutar Moodlea  sačuva 8K podešavanja';
$string['always'] = 'Uvek';
$string['automatic'] = 'Automatski, na osnovu inicijalne URL adrese';
$string['baseurl'] = 'Osnovna URL adresa';
$string['basiclti'] = 'LTI';
$string['basicltiactivities'] = 'LTI aktivnosti';
$string['basiclti_base_string'] = 'LTI OAuth osnovni string';
$string['basiclti_endpoint'] = 'LTI krajnja tačka startovanja';
$string['basicltifieldset'] = 'Prilagođeni primer skupa polja';
$string['basiclti_in_new_window'] = 'Vaša aktivnost je otvorena u novom prozoru';
$string['basicltiintro'] = 'Opis aktivnosti';
$string['basicltiname'] = 'Naziv aktivnosti';
$string['basiclti_parameters'] = 'LTI parametri startovanja';
$string['basicltisettings'] = 'Osnovna LTI podešavanja';
$string['cannot_delete'] = 'Ne možete da obrišete ovu konfiguraciju alata';
$string['cannot_edit'] = 'Ne možete da uredite ovu konfiguraciju alata';
$string['comment'] = 'Komentar';
$string['configpassword'] = 'Podrazumevana lozinka udaljenog alata';
$string['configpreferheight'] = 'Standardna preferirana visina';
$string['configpreferwidget'] = 'Postavi dodatak za podrazumevano pokretanje';
$string['configpreferwidth'] = 'Standardna preferirana širina';
$string['configresourceurl'] = 'Podrazumevana URL adresa resursa';
$string['configtoolurl'] = 'Podrazumevana URL adresa udaljenog alata';
$string['configtypes'] = 'Omogući LTI  aplikacije';
$string['courseid'] = 'ID broj kursa';
$string['coursemisconf'] = 'Kurs je pogrešno konfigurisan';
$string['course_tool_types'] = 'Tipovi alata na nivou kursa';
$string['createdon'] = 'Kreirano dana';
$string['curllibrarymissing'] = 'PHP Curl biblioteka mora da bude instalirana kako biste mogli da koristite LTI';
$string['custom'] = 'Prilagođeni parametri';
$string['custom_config'] = 'Korišćenje prilagođene konfiguracije alata';
$string['custom_help'] = 'Namenski prilagođeni parametri su podešavanja koje koristi provajder alata. Na primer, prilagođeni parametri se mogu koristiti za prikaz određenih resursa od strane provajdera.

Najsigurnije je ne menjati ovo polje, osim ako to ne učini sam provajder alata.';
$string['custominstr'] = 'Prilagođeni parametri';
$string['debuglaunch'] = 'Opcija za otklanjanje grešaka';
$string['debuglaunchoff'] = 'Normalno pokretanje';
$string['debuglaunchon'] = 'Pokretanje sa otklanjanjem grešaka';
$string['default'] = 'Podrazumevano';
$string['default_launch_container'] = 'Podrazumevani inicijalni kontejner';
$string['default_launch_container_help'] = 'Inicijalni kontejner utiče na prikaz alata prilikom njegovog pokretanja unutar kursa. Neki kontejneri pružaju veći broj mogućnosti, dok drugi obezbeđuju veći stepen integracije sa Moodleom.

* **Podrazumevano** - koristi inicijalni kontejner naveden u konfiguracije alata.
* **Umetnuto** - alat se prikazuje unutar postojećeg prozora Moodlea, na način sličan većini drugih tipova aktivnosti.
* **Umetnuto, bez blokova** - alat se prikazuje unutar postojećeg prozora Moodlea, ali samo sa navigacionom trakom na vrhu stranice.
* **Novi prozor** - Alat se otvara u novom prozoru, zauzimajući sav njegov rapoloživ prostor.
      Zavisno od veb čitača, alat će se otvoriti u novoj kartici čitača ili u iskačućem prozoru. Postoji mogućnost da veb čitač neće dozvoliti otvaranje novog prozora.';
$string['delegate'] = 'Delegiraj predavaču';
$string['delete'] = 'Obriši';
$string['delete_confirmation'] = 'Da li ste sigurni da želite da obrišete ovu konfiguraciju eksternog alata?';
$string['deletetype'] = 'Obriši konfiguraciju eksternog alata';
$string['display_description'] = 'Prikaži opis aktivnosti prilikom njenog startovanja';
$string['display_description_help'] = 'Ako je izabrana ova opcija, opis aktivnosti (gore naveden) biće prikazan iznad sadržaja eksternog alata.

Opis se može koristiti kako bi se pružile dodatne instrukcije onima koji pokreću alat, ali nije neophodan.

Opis se nikada ne prikazuje kada se eksterni alat pokreće u novom prozoru.';
$string['display_name'] = 'Prikaži naziv aktivnosti kada se pokrene';
$string['display_name_help'] = 'Ako je izabrana ova opcija, naziv aktivnosti (gore naveden) biće prikazan iznad sadržaja eksternog alata.

Moguće je da provajder alata, takođe, može da prikaže naslov. Ova opcija sprečava da naslov aktivnosti bude prikazan dvaput.

Naslov se nikada ne prikazuje ako se inicijalni kontejner alata pokreće u novom prozoru.';
$string['domain_mismatch'] = 'Domen inicijalne URL adrese se ne poklapa sa konfiguracijom alata.';
$string['donot'] = 'Nemoj slati';
$string['donotaccept'] = 'Nemoj prihvatiti';
$string['donotallow'] = 'Nemoj dozvoliti';
$string['edittype'] = 'Uredi konfiguraciju eksternog alata';
$string['embed'] = 'Ugradi';
$string['embed_no_blocks'] = 'Ugradi, bez blokova';
$string['enableemailnotification'] = 'Pošalji obaveštenja e-poštom';
$string['enableemailnotification_help'] = 'Ako je omogućena ova opcija, polaznici će e-poštom dobiti obaveštenje kada bude ocenjena njihova aktivnost u okviru eksternog alata..';
$string['errormisconfig'] = 'Pogrešno  konfigurisan alat. Zamolite svog Moodle administratora da popravi konfiguraciju alata.';
$string['extensions'] = 'Servisi LTI proširenja';
$string['external_tool_type'] = 'Tip eksternog alata';
$string['external_tool_type_help'] = 'Osnovna namena konfiguracije alata je uspostavljanje bezbednog kanala komunikacije između Moodlea i provajdera alata. Konfiguracija alata, takođe, pruža mogućnost da se podese kako podrazumevane vrednosti, tako i dodatni servise koje pruža sam alat.

* ** Automatski, na osnovu inicijalne URL adrese** - ovo podešavanja treba koristiti u skoro svim slučajevima. Moodle će izabrati najprikladniju konfiguraciju alata koja se zasniva na inicijalnoj URL adresi. Biće korišćen alat koji je konfigurisan bilo od strane administratora ili unutar ovoga kursa.
Kada je navedena inicijalna URL adresa, Moodle će dati povratnu informaciju o tome da li je prepoznao adresu ili ne. Ako Moodle nije prepoznao .inicijalnu URL adresu, možda će biti potrebno da ručno unesete podatke o konfiguraciji alata.
* **Specifičan tip alata** - ako izaberete specifičan tip alata, možete da naterate Moodle da u komunikaciji sa provajderom eksternog alata koristi tu konfiguraciju alata. Ukoliko se ispostavi da inicijalna URL adresa ne pripada provajderu, pojaviće se upozorenje. U nekim slučajevima, nije potrebno da se unese inicijalna URL adresa kada se obezbeđuje specifični tip alata (ako se ne pokreće tačno određeni resurs unutar samog provajdera alata).
* **Namenski prilagođena konfiguracija** - da biste podesili prilagođenu konfiguracije alata, samo za ovu instancu, otkrijte ‘Napredne opcije’ i unesite korisnički ključ i tajni deljeni kôd. Ako nemate korisnički ključ i tajni deljeni kôd možda ćete moći da ih zatražite od provajdera alata.
Ne zahtevaju svi alati korisnički ključ i tajni deljeni kôd. U tom slučaju ova polja možete ostaviti prazna.

### Uređivanje tipa alata 

Odmah iza padajućeg menija ‘Tip eksternog alata’ dostupne su tri ikonice:

* **Dodaj** - kreirajte konfiguraciju alata na nivou kursa. Sve instance eksternog alata na ovom kursu moći će da koriste konfiguraciju alata.
* **Uredi** - izaberite tip alata na nivou kursa iz padajućeg menija, a zatim kliknite na ovu ikonicu. Mogu se uređivati detalji konfiguracije alata.
* **Obriši** - uklonite izabrani tip alata na nivou kursa.';
$string['external_tool_types'] = 'Tipovi eksternih alata';
$string['failedtoconnect'] = 'Moodle nije mogao da uspostavi komunikaciju sa"{$a}" sistemom';
$string['filter_basiclti_configlink'] = 'Конфигуришите своје префериране сајтове и њихове лозинке';
$string['filter_basiclti_password'] = 'Lozinka je obavezna';
$string['filterconfig'] = 'LTI administracija';
$string['filtername'] = 'LTI';
$string['fixexistingconf'] = 'Iskoristite postojeću konfiguraciju za pogrešno konfigurisanu instancu';
$string['fixnew'] = 'Nova konfiguracija';
$string['fixnewconf'] = 'Definiši novu konfiguraciju za pogrešno konfigurisanu instancu';
$string['fixold'] = 'Koristi postojeću';
$string['forced_help'] = 'Ovo podešavanje je postavljeno kao obavezno u konfiguraciji alata na nivou kursa ili sajta. Ne možete da ga menjate u ovom interfejsu.';
$string['force_ssl'] = 'Obavezan SSL';
$string['force_ssl_help'] = 'Izborom ove opcije, svako pokretanje alata ovog provajdera će obavezno koristiti SSL protokol.

Osim toga, i svi zahtevi veb servisa provajdera alata će koristiti SSL protokol.

Ako se koristi ova opcija, proverite da li ovaj Moodle sajt i provajder alata podržavaju SSL protokol.';
$string['generaltool'] = 'Opšti alat';
$string['global_tool_types'] = 'Globalni tipovi alata';
$string['grading'] = 'Usmeravanje ocena';
$string['icon_url'] = 'URL adresa ikonice';
$string['icon_url_help'] = 'Ikonica URL adrese, omogućava da se izmeni ikonica koja se pojavljuje na spisku kurseva za ova aktivnost. Umesto da koristite podrazumevanu LTI ikonicu, može se definisati ikonica koja odražava tip aktivnosti.';
$string['id'] = 'id';
$string['invalidid'] = 'LTI ID je pogrešan';
$string['launch_in_moodle'] = 'Pokreni alat unutar Moodlea';
$string['launchinpopup'] = 'Inicijalni kontejner';
$string['launch_in_popup'] = 'Pokreni alat u iskačućem prozoru';
$string['launchinpopup_help'] = 'Inicijalni kontejner utiče na prikaz alata prilikom njegovog pokretanja unutar kursa. Neki kontejneri pružaju veći broj mogućnosti, dok drugi obezbeđuju veći stepen integracije sa Moodleom.

* **Podrazumevano** - koristi kontejner pokretanja naveden u konfiguraciji alata.
* **Umetnuto** - alat se prikazuje unutar postojećeg prozora Moodlea, na način sličan većini drugih tipova aktivnosti.
* **Umetnuto, bez blokova** - alat se prikazuje unutar postojećeg prozora Moodlea, ali samo sa navigacionom trakom na vrhu stranice.
* **Novi prozor** - Alat se otvara u novom prozoru, zauzimajući sav njegov rapoloživ prostor.
      Zavisno od veb čitača, alat će se otvoriti u novoj kartici čitača ili u iskačućem prozoru. Postoji mogućnost da veb čitač neće dozvoliti otvaranje novog prozora.';
$string['launchoptions'] = 'Opcije za pokretanje';
$string['launch_url'] = 'Inicijalna URL adresa';
$string['launch_url_help'] = 'Inicijalna URL adresa označava veb adresu eksternog alata. i može da sadrži dodatne informacije, kao što je resurs koji će biti prikazan.
Ako niste sigurni šta da upišete kao inicijalnu URL adresu, molimo vas potražite više informacije kod provajdera alata.

Ako ste izabrali specifičan tip alata, možda nećete morati da upišete inicijalnu URL adresu. To će najverovatnije biti slučaj, ako se link alata koristi samo za ulazak na sistem provajdera, a ne za odlazak na neki određeni resurs.';
$string['lti'] = 'LTI';
$string['lti:addcoursetool'] = 'Dodaj za kurs specifična podešavanja alata';
$string['lti:addinstance'] = 'Dodaj nove aktivnosti eksternog alata';
$string['lti_administration'] = 'LTI administracija';
$string['lti_errormsg'] = 'Alat je vratio sledeću poruku o grešci: "{$a}"';
$string['lti:grade'] = 'Pogledaj ocene dobijene od eksternog alata';
$string['lti_launch_error'] = 'Dogodila se greška prilikom pokretanja eksternog alata:';
$string['lti_launch_error_tool_request'] = '<p> Da biste poslali zahtev administratoru da završi konfigurisanje alata, kliknite<a href="{$a->admin_request_url}" target="_top">ovde</a>. </p>';
$string['lti_launch_error_unsigned_help'] = '<p>Ova greška može biti rezultat nedostatka korisničkog ključa i zajedničkog tajnog ključa za provajdera alata.</p>
<p> Ako imate korisnički ključ i zajednički tajni ključ, možete ih uneti prilikom uređivanja instance eksternog alata (proverite da li su vidljive napredne opcije).</p>
</p>Alternativno, možete da <a href="{$a->course_tool_editor}"> kreirate konfiguraciju alata na nivou kursa </a>.</p>';
$string['lti:manage'] = 'Budi instruktor kad se pokrene alat';
$string['lti:requesttooladd'] = 'Zahtevaj da se alat podesi na nivou sajta';
$string['lti_tool_request_added'] = 'Zahtev za konfigurisanje alata je uspešno poslat. Možda ćete morati da se obratite administratoru da biste dovršili konfigurisanje.';
$string['lti_tool_request_existing'] = 'Konfiguracija alata za domen alata je već poslata.';
$string['ltiunknownserviceapicall'] = 'API poziv LTI nepoznatog servisa.';
$string['lti:view'] = 'Pokreni aktivnosti eksternog alata';
$string['main_admin'] = 'Opšta pomoć';
$string['main_admin_help'] = 'Eksterni alati dozvoljavaju korisnicima Moodlea da neprimetno stupaju u interakciju sa resursima koji se nalaze na udaljenim sajtovima.
Koristeći specijalne protokole udaljeni alat će imati pristup nekim opštim informacijama o korisniku koji je pokrenuo alat. Na primer, naziv institucije, id kursa, id korisnika, i druge informacije, kao što su ime korisnika ili njegova e-adresa. 

Tipovi alata prikazani na ovoj stranici su podeljeni u tri kategorije:

* **Aktivni** - ove provajdere alata je administrator odobrio i konfigurisao. Oni mogu da se koriste unutar bilo kog kursa ove instance Moodlea. Ako su uneti korisnički ključ i tajni deljeni kôd, uspostavljena je pouzdana veza između instance Moodlea i udaljenog alata, što obezbeđuje bezbedan kanal komunikacije.
* **Na čekanju** - ovi provajderi alata su uvezeni, ali ih administrator još uvek nije konfigurisao. Predavači i dalje mogu da koriste alate ovih provajdera ako imaju korisnički ključ i tajni deljeni kôd, ili ako oni nisu potrebni.
* **Odbijeni** - ovi provajderi alata su označeni kao oni koje administrator ne namerava da učini dostupnim svima unutar instance Moodlea. Predavači i dalje mogu da koriste alate ovih provajdera ako imaju korisnički ključ i tajni deljeni kod, ili ako oni nisu potrebni.';
$string['miscellaneous'] = 'Razno';
$string['misconfiguredtools'] = 'Otkrivene su pogrešno konfigurisane instance alata';
$string['missingparameterserror'] = 'Stranica je pogrešno konfigurisana: "{$a}"';
$string['module_class_type'] = 'Tip Moodle modula';
$string['modulename'] = 'Eksterni alat';
$string['modulename_help'] = 'Eksterni alati dozvoljavaju korisnicima Moodlea da stupaju u interakciju sa resursima i aktivnostima za učenje na drugim veb sajtovima. Na primer, eksterni alat može da obezbedi pristup novom tipu aktivnosti ili obrazovnim materijalima koje nude izdavači.

Kako biste podesili instancu eksternog alata, neophodno je da provajder alata podržava LTI (Learning Tools Interoperability) standard.
Ako pronađete provajdera alata koji podržava LTI standard, on treba da obezbedi uputstvo o tome kako da se konfiguriše instanca eksternog alata. Dodatno, biće dostupni za upotrebu i tipovi alata koje konfigurisao administrator sajta.

Eksterni alati se razlikuju od resursa \'URL adresa\' na nekoliko načina:
* **Kontekst** - eksterni alati imaju pristup informacijama o korisniku koji je pokrenuo alat, kao što je naziv institucije i kursa, ime korisnika i dr.
* **Duboka integracija** - eksterni alati podržavaju čitanje, ažuriranje i brisanje ocena koje su povezane sa instancom aktivnosti. Za buduća izdanja planira se veći stepen integracije.
* **Bezbednost** - konfiguracije eksternog alata kreiraju pouzdanu vezu između Moodlea i provajdera alata, što omogućava bezbednu komunikaciju između njih.';
$string['modulenameplural'] = 'Eksterni alati';
$string['modulenamepluralformatted'] = 'LTI instance';
$string['never'] = 'Nikada';
$string['new_window'] = 'Novi prozor';
$string['noattempts'] = 'Još nije bilo pokušaja u okviru ove instance alata';
$string['no_lti_configured'] = 'Ne postoje aktivni eksterni alati koji su konfigurisani.';
$string['no_lti_pending'] = 'Nema eksternih alata na čekanju.';
$string['no_lti_rejected'] = 'Nema odbijenih eksternih alata.';
$string['noltis'] = 'Ne postoje instance eksternih alata';
$string['noservers'] = 'Nisu pronađeni serveri';
$string['notypes'] = 'Trenutno ne postoje podešavanja LTI alata u Moodleu. Kliknite na gornji link za instalaciju kako biste ih dodali.';
$string['noviewusers'] = 'Nisu pronađeni korisnici koji imaju ovlašćenja da koriste ovaj alat';
$string['optionalsettings'] = 'Opciona podešavanja';
$string['organization'] = 'Informacije o organizaciji';
$string['organizationdescr'] = 'Opis organizacije';
$string['organizationid'] = 'ID organizacije';
$string['organizationid_help'] = 'Jedinstveni identifikator ove instance Moodlea. Obično se koristi DNS naziv organizacije.

Ako ovo polje ostane prazno, koristiće se naziv servera ovog Moodle sajta, kao podrazumevana vrednost.';
$string['organizationurl'] = 'URL adresa organizacije';
$string['organizationurl_help'] = 'Osnovna URL adresa ove instance Moodlea';
$string['pagesize'] = 'Broj pristupa alatu prikazanih po stranici';
$string['password'] = 'Tajni deljeni kôd';
$string['password_admin'] = 'Tajni deljeni kôd';
$string['password_admin_help'] = 'Tajni deljeni kôd može da se posmatra kao lozinka koja se koristi za proveru identiteta prilikom pristupa alatu. Kôd treba da obezbedi provajder alata zajedno sa korisničkim ključem.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju tajni deljeni kôd.';
$string['password_help'] = 'Za prethodno konfigurisane alate, nije neophodno da se ovde unese tajni deljeni kôd, pošto će on već biti obezbeđen kao deo procesa konfiguracije.

Ovo polje treba popuniti ako se kreira veza ka provajderu alata koji nije prethodno konfigurisan. Ako provajder alata treba da se koristi više puta na ovom kursu, dodavanje konfiguracije alata je dobra ideja.

Tajni deljeni kôd može da se posmatra kao lozinka koja se koristi za proveru identiteta prilikom pristupa alatu. Kôd treba da obezbedi provajder alata zajedno sa korisničkim ključem.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju tajni deljeni kôd.';
$string['pending'] = 'Ne čekanju';
$string['pluginadministration'] = 'LTI administracija';
$string['pluginname'] = 'LTI';
$string['preferheight'] = 'Preferirana visina';
$string['preferwidget'] = 'Preferirano pokretanje dodatka';
$string['preferwidth'] = 'Preferirana širina';
$string['press_to_submit'] = 'Pritisnite da bisti pokrenuli ovu aktivnost';
$string['privacy'] = 'Privatnost';
$string['quickgrade'] = 'Dozvoli brzo ocenjivanje';
$string['quickgrade_help'] = 'Ako je omogućena ova opcija, više alata može da se ocenjuje na jednoj stranici. Dodajte ocene i komentare a zatim kliknite na dugme "Sačuvaj sve moje povratne informacije" kako biste sačuvali sve promene na toj stranici.';
$string['redirect'] = 'Bićete preusmereni za nekoliko sekundi. Ako se to ne dogodi pritisnite dugme.';
$string['reject'] = 'Odbij';
$string['rejected'] = 'Odbijeno';
$string['resource'] = 'Resurs';
$string['resourcekey'] = 'Korisnički ključ';
$string['resourcekey_admin'] = 'Korisnički ključ';
$string['resourcekey_admin_help'] = 'Korisnički ključ može da se posmatra kao korisničko ime koje se koristi za proveru identiteta prilikom pristupa alatu. 
Provajder alata može koristiti ključ kako bi obezbedio jedinstvenu identifikaciju Moodle sajta sa kojeg korisnici pokreću alat.

Korisnički ključ mora da obezbedi provajder alata. Način dobijanja ključa se razlikuje među provajderima. To može biti automatizovani proces ili može zahtevati dijalog sa provajderom alata.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju korisnički ključ.';
$string['resourcekey_help'] = 'Za prethodno konfigurisane alate, nije neophodno da se ovde unese ključ resursa, pošto će on već biti obezbeđen kao deo procesa konfiguracije.

Ovo polje treba popuniti ako se kreira veza ka provajderu alata koji nije prethodno konfigurisan. Ako provajder alata treba da se koristi više puta na ovom kursu, dodavanje konfiguracije alata je dobra ideja.

Korisnički ključ može da se posmatra kao korisničko ime koje se koristi za proveru identiteta prilikom pristupa alatu. 
Provajder alata može koristiti ključ kako bi obezbedio jedinstvenu identifikaciju Moodle sajta sa kojeg korisnici pokreću alat.

Korisnički ključ mora da obezbedi provajder alata. Način dobijanja ključa se razlikuje među provajderima. To može biti automatizovani proces ili može zahtevati dijalog sa provajderom alata.

Alati koji ne traže bezbednu komunikaciju sa Moodeom i ne pružaju dodatne servise (kao što je izveštaj o ocenama), ne moraju da zahtevaju korisnički ključ.';
$string['resourceurl'] = 'URL adresa resursa';
$string['return_to_course'] = 'Klikni na <a href="{$a->link}" target="_top">here</a> za povratak na kurs';
$string['saveallfeedback'] = 'Sačuvaj sve moje povratne informacije';
$string['secure_icon_url'] = 'Bezbedna ikonica URL adrese';
$string['secure_icon_url_help'] = 'Slično ikonici URL adrese, ali se koristi ako korisnik pristupa Moodleu putem SSL protokola. Glavna namena ovog polja je da spreči veb čitač da шalje upozorenja korisniku, ako stranici pristupa putem SSL-a, a pri tome se zahteva prikaz nebezbedne slike.';
$string['secure_launch_url'] = 'Bezbedna inicijalna URL adresa';
$string['secure_launch_url_help'] = 'Iako slična običnoj, bezbedna inicijalna URL adresa se koristi ako je neophodan viši nivo bezbednosti. Moodle će koristiti bezbednu inicijalnu URL adresu ukoliko se Moodle sajtu pristupa preko SSL protokola, ili ako je konfiguracija alata podešena tako da se ona uvek pokreće putem SSL-a.

Inicijalna URL adresa se može, takođe, podesiti kao https adresa, kako bi se eksterni alat primorao na pokretanje putem SSL protokola. U tom slučaju ovo polje može ostati prazno.';
$string['send'] = 'Pošalji';
$string['setupoptions'] = 'Opcije za podešavanje';
$string['share_email'] = 'Podeli e-adresu korisnika sa provajderom alata';
$string['share_email_admin'] = 'Podeli e-adresu korisnika sa provajderom alata';
$string['share_email_admin_help'] = 'Navedite da li e-adresu korisnika koji pokreće alat treba deliti sa provajderom..
Provajder može da traži e-adrese korisnika koji su pokrenuli alat kako bi razlikovao korisnike sa istim imenom ili kako bi korisnicima slao e-poštu zavisno od akcija unutar alata.';
$string['share_email_help'] = 'Navedite da li e-adresu korisnika koji pokreće alat treba deliti sa provajderom..
Provajder može da traži e-adrese korisnika koji su pokrenuli alat kako bi razlikovao korisnike sa istim imenom ili kako bi korisnicima slao e-poštu zavisno od akcija unutar alata.

Imajte u vidu da se ovo podešavanje može izmeniti u konfiguraciji alata.';
$string['share_name'] = 'Podeli ime korisnika sa provajderom alata';
$string['share_name_admin'] = 'Podeli ime korisnika sa provajderom alata';
$string['share_name_admin_help'] = 'Navedite da li treba da se deli puno ime korisnika, koji pokreće alat, sa provajderom alata.
Provajder može da traži ime korisnika koji je pokrenuo alat, kako bi prikazao smislene informacije unutar alata.';
$string['share_name_help'] = 'Navedite da li treba da se deli puno ime korisnika, koji pokreće alat, sa provajderom alata.
Provajder može da traži ime korisnika koji je pokrenuo alat, kako bi prikazao smislene informacije unutar alata.

Imajte u vidu da se ovo podešavanje može izmeniti u konfiguraciji alata.';
$string['share_roster'] = 'Dozvoli alatu pristup spisku učesnika kursa';
$string['share_roster_admin'] = 'Alat može da pristupi spisku učesnika kursa';
$string['share_roster_admin_help'] = 'Navedite da li alat može da pristupi spisku učesnika upisanih na kurseve, u okviru kojih se ovaj tip alata koristi.';
$string['share_roster_help'] = 'Navedite da li alat može da pristupi spisku učesnika upisanih na ovaj kurs.

Imajte u vidu da se ovo podešavanje može izmeniti u konfiguraciji alata..';
$string['show_in_course'] = 'Prikaži tip alata prilikom kreiranja instance alata';
$string['show_in_course_help'] = 'Ako je izabrano, ova konfiguracija alata će se pojaviti u padajućem meniju "Tip eksternog alata" kada predavači konfigurišu eksterni alat unutar kurseva.

U većini slučajeva, ova opcija ne treba da bude izabrana. Predavači mogu da koriste ovu konfiguraciju alata, baziranu na inicijalnoj URL adresi, koja se poklapa sa osnovnom URL adresom, što je preferirani metod.

Jedini slučaj, u kojem bi trebalo da se izabere ova opcija, je onaj kada je konfiguracija alata namenjena jednokratnom prijavljivanju (Single Sign on). Na primer, ako sva pokretanja alata vode korisnika na unutrašnju stranicu provajdera, umesto na određeni resurs.';
$string['size'] = 'Parametri veličine';
$string['submission'] = 'Aktivnost na eksternom alatu';
$string['submissions'] = 'Predato';
$string['submissionsfor'] = 'Predati radovi za {$a}';
$string['subplugintype_ltisource'] = 'LTI izvor';
$string['subplugintype_ltisource_plural'] = 'LTI izvori';
$string['toggle_debug_data'] = 'Promena stanja podataka o otklanjanju grešaka';
$string['tool_config_not_found'] = 'Za ovu URL adresu nije pronađena konfiguracija alata.';
$string['tool_settings'] = 'Podešavanja alata';
$string['toolsetup'] = 'Konfiguracija eksternog alata';
$string['toolurl'] = 'Osnovna URL adresa alata';
$string['toolurl_help'] = 'Osnovna URL adresa se koristi kako bi se inicijalna URL adresa uparile sa ispravnom konfiguracijom alata. Upotreba prefiksa http(s), na početku adresu, nije obavezna.

Osim toga, osnovna URL adresa se koristi kao inicijalna URL adresa ako ova nije navedena u instanci eksternog alata.

Na primer, osnovna URL adresa za *tool.com* treba da odgovara nekoj od sledećih adresa:

* tool.com
* tool.com/quizzes
* tool.com/quizzes/quiz.php?id=10
* www.tool.com/quizzes

Osnovna URL adresa za *www.tool.com/quizzes* treba da odgovara nekoj od sledećih adresa:

* www.tool.com/quizzes
* tool.com/quizzes
* tool.com/quizzes/take.php?id=10

Osnovna URL adresa za *quiz.tool.com* treba da odgovara nekoj od sledećih adresa:

* quiz.tool.com
* quiz.tool.com/take.php?id=10

Ukoliko postoje dve različite konfiguracije alata za isti domen, koristiće se ona sa najpreciznijom adresom.';
$string['typename'] = 'Naziv alata';
$string['typename_help'] = 'Naziv alata se koristi za identifikaciju provajdera alata unutar Moodlea. Naziv koji se unese biće vidljiv predavačima kada dodaju eksterne alate unutar kursa.';
$string['types'] = 'Tipovi';
$string['update'] = 'Ažuriraj';
$string['using_tool_configuration'] = 'Korišćenje konfiguracije alata';
$string['validurl'] = 'Ispravna URL adresa mora početi sa http(s)://';
$string['viewsubmissions'] = 'Prikaz predatih rešenja i ekrana za ocenjivanje';
