<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   lesson
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Kontrola pristupa';
$string['actionaftercorrectanswer'] = 'Akcija nakon tačnog odgovora';
$string['actionaftercorrectanswer_help'] = '<p>Nakon tačnog odgovora na pitanje postoje 3 mogućnosti za prelazak na naredni stranicu:<p><br />

<ul>
<li>Normalan - sledi tok lekcije</li>
<li>Prikaži neprikazanu stranicu - stranice se prikazuju nasumično s tim da se svaka stranica prikazuje samo jedanput</li>
<li>Prikaži neodgovorenu stranicu - stranice su prikazuju nasumično s tim da se stranice sa pitanjem na koje nije odgovoreno ponavljaju</li>
</ul>
';
$string['actions'] = 'Akcije';
$string['activitylink'] = 'Link do sledeće aktivnosti';
$string['activitylink_help'] = 'Ukoliko želite da na kraju lekcije prikažete link ka drugoj aktivnosti na kursu, izaberite aktivnost iz padajuće liste.';
$string['activitylinkname'] = 'Idi na {$a}';
$string['activityoverview'] = 'Približava se rok za završetak lekcija';
$string['addabranchtable'] = 'Dodaj stranicu sa sadržajem/grananjem';
$string['addanendofbranch'] = 'Dodaj kraj grane';
$string['addanewpage'] = 'Dodaj novu stranicu';
$string['addaquestionpage'] = 'Dodaj stranicu sa pitanjem';
$string['addaquestionpagehere'] = 'Dodaj ovde stranicu sa pitanjem';
$string['addbranchtable'] = 'Dodaj stranicu sa sadržajem i grananjem';
$string['addcluster'] = 'Dodaj grupu pitanja';
$string['addedabranchtable'] = 'Dodata je stranica sa sadržajem i grananjem';
$string['addedanendofbranch'] = 'Dodat je kraj grane';
$string['addedaquestionpage'] = 'Dodata je stranica sa pitanjem';
$string['addedcluster'] = 'Dodata je grupa pitanja';
$string['addedendofcluster'] = 'Dodat je kraj grupe pitanja';
$string['addendofcluster'] = 'Dodaj kraj grupe pitanja';
$string['addpage'] = 'Dodaj stranicu';
$string['anchortitle'] = 'Početak glavnog sadržaja';
$string['and'] = 'i';
$string['answer'] = 'Odgovor';
$string['answeredcorrectly'] = 'je tačno odgovorilo';
$string['answersfornumerical'] = 'Odgovori za numerička pitanja treba da budu uklopljeni parovi minimalnih i maksimalnih vrednosti';
$string['arrangebuttonshorizontally'] = 'Da li da dugmad u tabeli grananja budu postavljena horizontalno?';
$string['attempt'] = 'Pokušaj: {$a}';
$string['attempts'] = 'Pokušaji';
$string['attemptsdeleted'] = 'Obrisani pokušaji';
$string['attemptsremaining'] = 'Ostalo Vam je još {$a} pokušaja';
$string['available'] = 'Datum od kog će biti dostupno:';
$string['averagescore'] = 'Prosečan broj bodova';
$string['averagetime'] = 'Prosečno vreme';
$string['branch'] = 'Sadržaj sa grananjem';
$string['branchtable'] = 'Sadržaj sa grananjem';
$string['cancel'] = 'Odustani';
$string['cannotfindanswer'] = 'Greška: nije pronađen odgovor';
$string['cannotfindattempt'] = 'Greška: nije pronađen pokušaj';
$string['cannotfindessay'] = 'Greška: nije pronađen esej';
$string['cannotfindfirstgrade'] = 'Greška: nije moguće pronaći ocene';
$string['cannotfindfirstpage'] = 'Nije moguće naći prvu stranu';
$string['cannotfindgrade'] = 'Nije moguće naći dosje sa ocenama';
$string['cannotfindnewestgrade'] = 'Greška: nije moguće naći najnoviju ocenu';
$string['cannotfindnextpage'] = 'Rezervna kopija lekcije: Sledeća strana nije pronađena!';
$string['cannotfindpagerecord'] = 'Dodaj kraj grane: zapis o strani nije pronađen';
$string['cannotfindpages'] = 'Nije moguće naći stranice lekcije';
$string['cannotfindpagetitle'] = 'Potvrda brisanja: nije pronađen naslov strane';
$string['cannotfindpreattempt'] = 'Zapis o prethodnom pokušaju nije pronađen!';
$string['cannotfindrecords'] = 'Greška: nisu pronađeni slogovi u tabeli lesson';
$string['cannotfindtimer'] = 'Greška: nije moguće pronaći zapise iz tabele lesson_timer';
$string['cannotfinduser'] = 'Greška: nisu pronađeni slogovi u tabeli lesson_timer';
$string['canretake'] = '{$a} može ponovo da pogleda lekciju';
$string['casesensitive'] = 'Koristi regularne izraze';
$string['casesensitive_help'] = 'Označite polje za potvrdu ako želite da koristite regularne izraze za analizu odgovora';
$string['checkbranchtable'] = 'Provera stranice sa sadržajem i grananjem';
$string['checkedthisone'] = 'je izabralo ovaj odgovor.';
$string['checknavigation'] = 'Proveri navigaciju';
$string['checkquestion'] = 'Proveri pitanje';
$string['classstats'] = 'Statistički pregled rezultata svih učesnika kursa';
$string['clicktodownload'] = 'Kliknite na sledeći link da biste preuzeli datoteku.';
$string['clicktopost'] = 'Kliknite ovde da pošaljete svoju ocenu na listu najboljih rezultata.';
$string['cluster'] = 'Grupa pitanja';
$string['clusterjump'] = 'Još neprikazano pitanje iz grupe pitanja';
$string['clustertitle'] = 'Grupa pitanja';
$string['collapsed'] = 'Skupljeno';
$string['comments'] = 'Vaši komentari';
$string['completed'] = 'Završeno';
$string['completederror'] = 'Završite lekciju';
$string['completethefollowingconditions'] = 'Morate da ispunite sledeće uslove u lekciji <b>{$a}</b> da biste mogli da nastavite.';
$string['conditionsfordependency'] = 'Uslovi zavisnosti';
$string['configactionaftercorrectanswer'] = 'Podrazumevana akcija koja će se izvršiti nakon tačnog odgovora';
$string['configmaxanswers'] = 'Podrazumevani maksimalan broj odgovora po strani';
$string['configmaxhighscores'] = 'Broj prikazanih najboljih rezultata';
$string['configmediaclose'] = 'Prikaži dugme za zatvaranje na iskačućem prozoru koji sadrži link ka multimedijalnj datoteci';
$string['configmediaheight'] = 'Određuje visinu iskačućeg prozora koji prikazuje link ka multimedijalnoj datoteci';
$string['configmediawidth'] = 'Određuje širinu iskačućeg prozora koji prikazuje link ka multimedijalnoj datoteci';
$string['configslideshowbgcolor'] = 'Boja pozadine za slajd-šou ukoliko je uključen';
$string['configslideshowheight'] = 'Određuje visinu za slajd-šou ukoliko je omogućen';
$string['configslideshowwidth'] = 'Određuje širinu za slajd-šou ukoliko je omogućen';
$string['confirmdelete'] = 'Obriši stranicu';
$string['confirmdeletionofthispage'] = 'Potvrdi brisanje ove stranice';
$string['congratulations'] = 'Čestitamo - stigli ste do kraja lekcije';
$string['continue'] = 'Nastavi';
$string['continuetoanswer'] = 'Nastavite da biste promenili odgovore.';
$string['continuetonextpage'] = 'Idite na sledeću stranicu';
$string['correctanswerjump'] = 'Tačan odgovor vodi do';
$string['correctanswerscore'] = 'Broj bodova koji se dobija za tačan odgovor';
$string['correctresponse'] = 'Povratne informacije za tačan odgovor';
$string['createaquestionpage'] = 'Kreiraj stranicu sa pitanjem';
$string['credit'] = 'Bodovi';
$string['customscoring'] = 'Prilagođeno bodovanje';
$string['customscoring_help'] = 'Ako je ova opcija omogućena. onda se svakom odgovoru može dodeliti numerička vrednost (pozitivna ili negativna)';
$string['deadline'] = 'Krajnji rok';
$string['defaultessayresponse'] = 'Predavač će oceniti vaš esej.';
$string['deleteallattempts'] = 'Obriši sve pokušaje prolaska kroz lekciju';
$string['deletedefaults'] = 'Obrisano {$a} x podrazumevano za lekciju';
$string['deletedpage'] = 'Stranica je obrisana';
$string['deleting'] = 'Brisanje';
$string['deletingpage'] = 'Brisanje stranice: {$a}';
$string['dependencyon'] = 'Zavisno od';
$string['dependencyon_help'] = 'Ovo podešavanje dopušta da pristup ovoj lekciji zavisi od rezultata polaznika u drugoj lekciji istog kursa. Može se koristiti bilo koja kombinacija sledećih uslova: utrošenog vremena (vreme koje je polaznik potrošio da bi uradio lekciju), završenosti (da li je polaznik završio navedenu lekciju) i dobijene ocene (da li je polaznik dobio ocenu veću od navedene).';
$string['description'] = 'Opis';
$string['detailedstats'] = 'Detaljna statistika';
$string['didnotanswerquestion'] = 'Niste odgovorili na ovo pitanje.';
$string['didnotreceivecredit'] = 'Niste dobili bodove';
$string['displaydefaultfeedback'] = 'Koristi podrazumevane povratne informacije';
$string['displaydefaultfeedback_help'] = 'Ako je ova opcija omogućena, onda će, u situaciji kada za neko pitanje ne postoji povratna informacija, biti prikazana podrazumevana povratna informacija: "Tačan odgovor" odnosno "Pogrešan odgovor"';
$string['displayhighscores'] = 'Prikaz najboljih rezultata';
$string['displayinleftmenu'] = 'Prikaz u meniju sa leve strane?';
$string['displayleftif'] = 'Minimalna ocena za prikaz menija';
$string['displayleftif_help'] = 'Ovo podešavanje određuje da li polaznik mora da dobije određenu ocenu kako bi video meni sa leve strane. Ovo podešavanje tera polaznika da prođe kroz celu lekciju prilikom prvog pokušaja. Tek nakon što polaznik dobije potrebnu ocenu može da koristi meni sa leve strane za pregled lekcije.';
$string['displayleftmenu'] = 'Prikaz menija sa leve strane';
$string['displayleftmenu_help'] = 'Ako je ova opcija omogućena, biće prikazan spisak stranica lekcije.';
$string['displayofgrade'] = 'Prikaz ocena (samo za polaznike)';
$string['displayreview'] = 'Obezbedite mogućnost za ponovni pokušaj';
$string['displayreview_help'] = 'Ako je ova opcija omogućena, u situaciji kada polaznik pogrešno odgovori na pitanje, biće mu ponuđeno da pokuša ponovo da odgovori (bez mogućnosti da dobije poen) ili da nastavi sa lekcijom.';
$string['displayscorewithessays'] = '<p>Osvojili ste {$a->score} od maksimalnih {$a->tempmaxgrade} bodova za pitanja koja se automatski ocenjuju.</p>
<p>Vaš {$a->essayquestions} odgovor na pitanja  u formi eseja biće uskoro pregledan i ocenjen, a ocena će kasnije biti dodata<br />u vaš finalni rezultat.</p>
<p>Vaša trenutna ocena bez eseja je {$a->score} od {$a->grade}</p>';
$string['displayscorewithoutessays'] = 'Vaš rezultat je {$a->score} (od mogućih {$a->grade}).';
$string['edit'] = 'Uredi';
$string['editingquestionpage'] = 'Uređivanje {$a} stranice pitanja';
$string['editlessonsettings'] = 'Uredi podešavanja lekcije';
$string['editpage'] = 'Uredi sadržaj stranice';
$string['editpagecontent'] = 'Uredi sadržaj stranice';
$string['email'] = 'E-pošta';
$string['emailallgradedessays'] = 'Pošalji SVE ocenjene eseje';
$string['emailgradedessays'] = 'Pošalji ocenjene eseje e-poštom';
$string['emailsuccess'] = 'E-pošta je uspešno poslata';
$string['emptypassword'] = 'Polje za lozinku ne može biti prazno';
$string['endofbranch'] = 'Kraj grane';
$string['endofcluster'] = 'Kraj grupe pitanja';
$string['endofclustertitle'] = 'Kraj grupe pitanja';
$string['endoflesson'] = 'Kraj lekcije';
$string['enteredthis'] = 'je odabralo/unelo ovaj odgovor';
$string['entername'] = 'Unesite nadimak koji će biti prikazan na listi najboljih rezultata';
$string['enterpassword'] = 'Molimo unesite lozinku:';
$string['eolstudentoutoftime'] = 'Upozorenje! Isteklo vam je vreme za ovu lekciju. Vaš poslednji odgovor možda nije uračunat ako je dat nakon što je vreme isteklo.';
$string['eolstudentoutoftimenoanswers'] = 'Niste odgovorili ni na jedno pitanje. Vaša ocena za ovu lekciju je 0.';
$string['essay'] = 'Esej';
$string['essayemailmessage'] = '<p>Esej:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentar predavača ({$a->teacher}\'s):<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste ocenu {$a->earned} od maksimalno {$a->outof} za  ovaj esej.</p><p>Vaša ocena za ovu lekciju je promenjena na {$a->newgrade}%.</p>';
$string['essayemailmessage2'] = '<p>Esej:<blockquote>{$a->question}</blockquote></p><p>Vaš odgovor:<blockquote><em>{$a->response}</em></blockquote></p><p>Komentrar ocenjivača:<blockquote><em>{$a->comment}</em></blockquote></p><p>Dobili ste {$a->earned} od maksimalnih {$a->outof} za ovaj esej.</p><p>Vaša ocena za ovu lekciju je promenjena na {$a->newgrade}&#37;.</p>';
$string['essayemailsubject'] = 'Vaša ocena za pitanje {$a}';
$string['essays'] = 'Eseji';
$string['essayscore'] = 'Rezultat eseja';
$string['fileformat'] = 'Format datoteke';
$string['finish'] = 'Završi';
$string['firstanswershould'] = 'Prvi odgovor bi trebalo do vodi na stranicu "Tačno"';
$string['firstwrong'] = 'Nažalost, ne možete da osvojite ovaj bod, zato što je Vaš odgovor netačan. Želite li da pokušate ponovo kako biste učili (ali bez mogućnosti da osvojite neke bodove)';
$string['flowcontrol'] = 'Kontrola toka lekcije';
$string['full'] = 'Prošireno';
$string['general'] = 'Opšta podešavanja';
$string['gotoendoflesson'] = 'Idi na kraj lekcije';
$string['grade'] = 'Ocena';
$string['gradebetterthan'] = 'Ocena viša od (%)';
$string['gradebetterthanerror'] = 'Osvojite ocenu veću od {$a} procenata';
$string['gradeessay'] = 'Oceni odgovore na esejski tip pitanja({$a->notgradedcount} još nije ocenjeno, a {$a->notsentcount} nije poslato)';
$string['gradeis'] = 'Ocena je {$a}';
$string['gradeoptions'] = 'Opcije za ocenjivanje';
$string['handlingofretakes'] = 'Tretman ponovnih pokušaja';
$string['handlingofretakes_help'] = 'Ako su ponovni pokušaji dozvoljeni, ovo podešavanje određuje da li je ocena za lekciju jednaka prosečnoj oceni svih pokušaja ili najvećoj oceni.';
$string['havenotgradedyet'] = 'Još nije ocenjeno.';
$string['here'] = 'ovde';
$string['highscore'] = 'Najbolji rezultat';
$string['highscores'] = 'Lista najboljih rezultata';
$string['hightime'] = 'Najbolje vreme';
$string['importcount'] = 'Uvozi se {$a} pitanja';
$string['importquestions'] = 'Uvoz pitanja';
$string['importquestions_help'] = 'Ovo svojstvo omogućava da pitanja u različitim formatima, budu uvezena putem tekstualne datoteke.';
$string['insertedpage'] = 'Stranica je umetnuta';
$string['invalidfile'] = 'Neispravna datoteka';
$string['invalidid'] = 'Nije prosleđen ID modula ili lekcije';
$string['invalidlessonid'] = 'ID lekcije nije bio tačan';
$string['invalidpageid'] = 'Neispravan ID stranice';
$string['jump'] = 'Prelaz';
$string['jumps'] = 'Prelazi';
$string['jumps_help'] = 'Svaki odgovor (za stranicu sa pitanjem) ili opis (za stranicu sa sadržajem) ima odgovarajući prelaz. Prelaz može biti relativan, kao na primer "tekuća stranica" ili "sledeća stranica", ili apsolutan tj. prelaz na bilo koju stranicu u lekciji.';
$string['jumpsto'] = 'Prelazi na <em>{$a}</em>';
$string['leftduringtimed'] = 'Napustili ste lekciju koja je vremenski ograničena.<br />Pritisnite taster za nastavak da biste pogledali lekciju od početka.';
$string['leftduringtimednoretake'] = 'Napustili ste lekciju koja je vremenski ograničena i nije Vam <br /> dozvoljeno da nastavite ili počnete lekciju iz početka.';
$string['leftduringtimedsession'] = 'Izašli ste tokom lekcije koja ima vremensko ograničenje.';
$string['lesson:addinstance'] = 'Dodaj novu lekciju';
$string['lessonattempted'] = 'Lekciji je pristupano';
$string['lessonclosed'] = 'Ova lekcija je zatvorena dana {$a}.';
$string['lessoncloses'] = 'Lekcija se zatvara';
$string['lessoncloseson'] = 'Vreme zatvaranja lekcije: {$a}';
$string['lesson:edit'] = 'Uredi lekciju';
$string['lessonformating'] = 'Formatiranje lekcije';
$string['lesson:manage'] = 'Upravljaj lekcijom';
$string['lessonmenu'] = 'Meni lekcije';
$string['lessonnotready'] = 'Ova lekcija još nije spremna za korišćenje. Molimo kontaktirajte svog {$a}.';
$string['lessonnotready2'] = 'Ova lekcija još nije spremna za korišćenje';
$string['lessonopen'] = 'Ova lekcija će biti dostupna od {$a}.';
$string['lessonopens'] = 'Lekcija se otvara';
$string['lessonpagelinkingbroken'] = 'Nije pronađena prva stranica. Mora da je došlo do prekida linkova između stranica lekcije. Molimo kontaktirajte administratora.';
$string['lessonstats'] = 'Statistika lekcije';
$string['linkedmedia'] = 'Povezani mediji';
$string['loginfail'] = 'Pogrešna prijava, molimo pokušajte ponovo...';
$string['lowscore'] = 'Naslabiji rezultat';
$string['lowtime'] = 'Najslabije vreme';
$string['manualgrading'] = 'Oceni eseje';
$string['matchesanswer'] = 'Poklapa se sa odgovorom';
$string['matching'] = 'Uparivanje';
$string['matchingpair'] = 'Uparivanje para {$a}';
$string['maxgrade'] = 'Maksimalna ocena';
$string['maxgrade_help'] = 'Ovo podešavanje određuje najveću ocenu za lekciju. Ukoliko je vrednost podešena na 0 lekcija se neće pojaviti na stranici sa ocenama.';
$string['maxhighscores'] = 'Broj najboljih rezultata koji treba prikazati';
$string['maximumnumberofanswersbranches'] = 'Maksimalan broj odgovora';
$string['maximumnumberofanswersbranches_help'] = 'Ova vrednost određuje maksimalni broj odgovora koji se mogu koristiti u lekciji. Ako se koriste samo TAČNO/NETAČNO pitanja tada je razumno postaviti ovu vrednost na 2. Podešavanje se može promeniti bilo kada, pošto utiče samo na način prikaza podataka nastavniku, ne i na same podatke.';
$string['maximumnumberofattempts'] = 'Maksimalan broj pokušaja';
$string['maximumnumberofattempts_help'] = 'Ovo podešavanje određuje maksimalan broj dozvoljenih pokušaja za svako pitanje. Ukoliko se netačni odgovori ponavljaju, kada se dostigne maksimalan broj pokušaja, biće prikazana sledeća stranica lekcije.';
$string['maximumnumberofattemptsreached'] = 'Dostignut je maksimalan broj pokušaja - prelazi se na sledeću stranicu';
$string['maxtime'] = 'Vremensko ograničenje (u minutima)';
$string['maxtimewarning'] = 'Imate još {$a} minut(a) da završite lekciju.';
$string['mediaclose'] = 'Prikaz dugmeta za zatvaranje';
$string['mediafile'] = 'Iskačući prozor za prikaz datoteke';
$string['mediafile_help'] = 'Da biste na početku lekcije uključili iskačući prozor odaberite odgovarajuću datoteku za prikaz. Svaka stranica lekcije će sadržati link za ponovno otvaranje iskačućeg prozora, ukoliko je to potrebno.';
$string['mediafilepopup'] = 'Kliknite ovde za prikaz';
$string['mediaheight'] = 'Visina iskačućeg prozora:';
$string['mediawidth'] = 'Širina iskačućeg prozora:';
$string['messageprovider:graded_essay'] = 'Obaveštenje o ocenjenom eseju';
$string['minimumnumberofquestions'] = 'Minimalan broj pitanja';
$string['minimumnumberofquestions_help'] = 'Ova podešavanje određuje najmanji broj pitanja koji će se koristiti za izračunavanje ocene za aktivnost. Ukoliko lekcija sadrži jednu ili više stranica sadržaja (tabele grananja) minimalnu vrednost bi trebalo postaviti na 0.

Ukoliko postavite vrednost na, recimo, 20 na uvodnoj stranici lekcije će se pojaviti sledeći tekst: "U ovoj lekciji se očekuje da odgovorite na najmanje 20 pitanja. Ukoliko želite možete odgovoriti i na više. Međutim, ukoliko odgovorite na manje od 20 pitanja, Vaša ocena će se računati kao da ste odgovorili na svih 20 pitanja."';
$string['missingname'] = 'Molimo unesite nadimak';
$string['modattempts'] = 'Dozvolite polaznicima pregled';
$string['modattempts_help'] = 'Ako je ova opcija omogućena, polaznici će moći ponovo da pogledaju lekciju od početka.';
$string['modattemptsnoteacher'] = 'Polaznički pregled funkcioniše samo za polaznike';
$string['modulename'] = 'Lekcija';
$string['modulename_help'] = 'Modul \'Lekcija\' omogućava predavaču da  prezentuje sadržaj i/ili praktične aktivnosti na interesantan i fleksibilan način. Predavač može da koristi lekciju kako bi kreirao linearni niz stranica sa sadržajem ili instrukcije koje nude različite putanje ili opcije za korisnika. U oba slučaj predavači mogu da povećaju angažman polaznika i da obezbede razumevanje gradiva, tako što će na kraju stranice dodati različite tipove pitanja, uključujući višestruki izbor, sparivanje, kratak odgovor i dr. Zavisno od izabranog odgovora, kao i od toga kako je predavač organizovao lekciju, polaznici mogu da napreduju na sledeću stranicu, budu vraćeni na prethodnu ili preusmereni na neku drugu stranicu lekcije.

Lekcije mogu da se ocenjuju, a ocene upisuju u knjigu ocena.

Lekcija može da se koristi:

* za samostalno učenje novih sadržaja
* za scenarija ili simulacije/vežbe donošenje odluka
* za ispravku naučenog gradiva, sa različitim setovima pitanja u zavisnosti od odgovora datih na početna pitanja';
$string['modulenameplural'] = 'Lekcije';
$string['move'] = 'Premesti stranicu';
$string['movedpage'] = 'Stranica je premeštena';
$string['movepagehere'] = 'Ovde premesti stranicu';
$string['moving'] = 'Premeštanje stranice: {$a}';
$string['multianswer'] = 'Višestruki odgovor';
$string['multianswer_help'] = 'Označite ukoliko postoji više tačnih osgovora.';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswer'] = 'Višestruki odgovor';
$string['nameapproved'] = 'Naziv je odobren';
$string['namereject'] = 'Nažalost, Vaše ime je odbijeno.<br />Molimo pokušajte sa drugim imenom.';
$string['new'] = 'novo';
$string['nextpage'] = 'Sledeća stranica';
$string['noanswer'] = 'Na jedno ili više pitanja nije dat odgovor. Molimo vratite se nazad i dajte svoj odgovor.';
$string['noattemptrecordsfound'] = 'Nema zabeleženih pokušaja: nije data nijedna ocena';
$string['nobranchtablefound'] = 'Nije pronađena nijedna stranica sadržaja (tabela grananja)';
$string['nocommentyet'] = 'Još nema komentara.';
$string['nocoursemods'] = 'Nije pronađena nijedna aktivnost';
$string['nocredit'] = 'Bez bodova';
$string['nodeadline'] = 'Bez roka';
$string['noessayquestionsfound'] = 'U ovoj lekciji nisu pronađena pitanja koja zahtevaju odgovor u formi eseja.';
$string['nohighscores'] = 'Nema najboljih rezultata';
$string['nolessonattempts'] = 'Niko još nije pokušao da prođe kroz ovu lekciju.';
$string['nooneansweredcorrectly'] = 'Niko nije tačno odgovorio.';
$string['nooneansweredthisquestion'] = 'Niko nije odgovorio na ovo pitanje.';
$string['noonecheckedthis'] = 'Niko nije izabrao ovaj odgovor.';
$string['nooneenteredthis'] = 'Niko nije ovo pokušao.';
$string['noonehasanswered'] = 'Niko još nije odgovorio na esejsko pitanje.';
$string['noretake'] = 'Nije Vam dozvoljeno da ponovo pokušate ovu lekciju.';
$string['normal'] = 'Normalno - pratite putanju lekcije';
$string['notcompleted'] = 'Nije završeno';
$string['notdefined'] = 'Nije definisano';
$string['nothighscore'] = 'Vaš rezultat nije među prvih {$a} na listi najboljih rezultata.';
$string['notitle'] = 'Nema naslova';
$string['numberofcorrectanswers'] = 'Broj tačnih odgovora: {$a}';
$string['numberofcorrectmatches'] = 'Broj tačnih podudaranja: {$a}';
$string['numberofpagestoshow'] = 'Broj stranica koje treba prikazati';
$string['numberofpagestoshow_help'] = '<p>Ovaj parametar se koristi samo u tipu lekcija sa Fleš Karticama. Podrazumevana vrednost je nula, što znači da su sve stranice/kartice prikazane u lekciji. Postavljanje ovog parametra na ne-nula vrednost prikazuje taj broj stranica. Nakon što je dosegnut taj broj stranica/kartica, dolazi se do završetka lekcije i polazniku se prikazuje njegova ocena.</p>

<p>Ukoliko se ovaj parametar podesi na broj veći od broja stranica u lekciji onda se kraj lekcije dostiže kada se sve stranice prikažu.</p>';
$string['numberofpagesviewed'] = 'Broj pregledanih stranica: {$a}';
$string['numberofpagesviewednotice'] = 'Broj pitanja na koje je dat odgovor: {$a->nquestions}; (Trebalo bi ih biti bar: {$a->minquestions})';
$string['numerical'] = 'Brojčani';
$string['ongoing'] = 'Prikaz trenutnog rezultata';
$string['ongoingcustom'] = 'Do sada ste osvojili {$a->score} od maksimalno {$a->currenthigh} bodova.';
$string['ongoing_help'] = 'Ako je ova opcija omogućena, na svakoj stranica će biti prikazan trenutni broj bodova od ukupnog broja koje je polaznik do tada mogao da postigne.';
$string['ongoingnormal'] = 'Tačno ste odgovorili na {$a->correct} od {$a->viewed} pitanja koja ste videli.';
$string['onpostperpage'] = 'Samo jedna poruka po oceni';
$string['options'] = 'Opcije';
$string['or'] = 'ILI';
$string['ordered'] = 'Poređano';
$string['other'] = 'Ostalo';
$string['outof'] = 'Od {$a}';
$string['overview'] = 'Pregled';
$string['overview_help'] = 'Lekcija se sastoji od određenog broja stranica i, opciono, stranica sa sadržajem (tabelom grananja). Stranica sadrži  proizvoljnu količinu teksta i odgovarajućih ilustracija, i obično se završava pitanjem. Uz svaki odgovor na pitanje vezan je tzv. prelaz. Prelazi mogu biti relativni, kao na primer “tekuća stranica” ili “sledeća stranica”, ili apsolutni kada se tačno navodi neka od stranica unutar lekciji. Stranica sa sadržajem (tabela grananja) je stranica koja sadrži niz linkova ka drugim stranicama lekcije, kao na primer "Tabela sadržaja".';
$string['page'] = 'Stranica: {$a}';
$string['pagecontents'] = 'Sadržaj stranice';
$string['page-mod-lesson-edit'] = 'Stranica za uređivanje lekcije';
$string['page-mod-lesson-view'] = 'Prikaži ili pregledaj stranicu lekcije';
$string['page-mod-lesson-x'] = 'Bilo koja stranica lekcije';
$string['pages'] = 'Stranice';
$string['pagetitle'] = 'Naslov stranice';
$string['password'] = 'Lozinka';
$string['passwordprotectedlesson'] = '{$a} je lekcija zaštićena lozinkom.';
$string['pleasecheckoneanswer'] = 'Izaberite jedan odgovor';
$string['pleasecheckoneormoreanswers'] = 'Izaberite jedan ili više odgovora';
$string['pleaseenteryouranswerinthebox'] = 'Unesite svoj odgovor u polje za unos';
$string['pleasematchtheabovepairs'] = 'Spojite parove';
$string['pluginadministration'] = 'Administracija lekcije';
$string['pluginname'] = 'Lekcija';
$string['pointsearned'] = 'Osvojeni bodovi';
$string['postprocesserror'] = 'Došlo je do greške tokom postprocesiranja!';
$string['postsuccess'] = 'Uspešno poslato';
$string['practice'] = 'Lekcija za vežbanje';
$string['practice_help'] = 'Lekcija za vežbu se ne prikazuje u dnevniku ocena.';
$string['preprocesserror'] = 'Došlo je do greške tokom pretprocesiranja!';
$string['prerequisitelesson'] = 'Lekcija preduslov';
$string['preview'] = 'Pregled';
$string['previewlesson'] = 'Pregled {$a}';
$string['previouspage'] = 'Prethodna stranica';
$string['processerror'] = 'Došlo je do greške tokom procesiranja!';
$string['progressbar'] = 'Traka napredovanja kroz lekciju';
$string['progressbar_help'] = 'Ako je ova opcija omogućena, na dnu stranice biće prikazana traka koja prikazuje približan procenat završenosti lekcije (napredovanje polaznika kroz lekciju).';
$string['progressbarteacherwarning'] = 'Traka napredovanja kroz lekciju se ne prikazuje za {$a}';
$string['progressbarteacherwarning2'] = 'Nećete videti traku napredovanja zato što možete da uređujete ovu lekciju';
$string['progresscompleted'] = 'Završili ste {$a}% lekcije';
$string['qtype'] = 'Vrsta stranice';
$string['question'] = 'Pitanje';
$string['questionoption'] = 'Pitanje';
$string['questiontype'] = 'Vrsta pitanja';
$string['randombranch'] = 'Nasumično odabrana strana sa sadržajem i grananjem';
$string['randompageinbranch'] = 'Nasumično odabrano pitanje unutar stranice sadržaja (grane)';
$string['rank'] = 'Rang';
$string['rawgrade'] = 'Neobrađena ocena';
$string['receivedcredit'] = 'Dobijeni bodovi';
$string['redisplaypage'] = 'Osvežavanje prikaza stranice';
$string['report'] = 'Izveštaj';
$string['reports'] = 'Izveštaji';
$string['response'] = 'Povratne informacije';
$string['retakesallowed'] = 'Ponovni pregled lekcije je dozvoljen';
$string['retakesallowed_help'] = 'Ako je ova opcija omogućena, polaznik može više puta da pogleda lekciju.';
$string['returnto'] = 'Vrati se na {$a}';
$string['returntocourse'] = 'Vrati se na kurs';
$string['review'] = 'Pregled';
$string['reviewlesson'] = 'Pregled lekcije';
$string['reviewquestionback'] = 'Da, voleo/la bih da ponovo pokušam';
$string['reviewquestioncontinue'] = 'Ne, želim da pređem na sledeće pitanje';
$string['sanitycheckfailed'] = 'Provera nije uspela. Pokušaj je izbrisan.';
$string['savechanges'] = 'Sačuvaj promene';
$string['savechangesandeol'] = 'Sačuvaj sve promene i idi na kraj lekcije.';
$string['savepage'] = 'Sačuvaj stranicu';
$string['score'] = 'Rezultat';
$string['score_help'] = 'Rezultat se koristi samo kada je prilagođeno bodovanje omogućeno. Svakom odgovoru zatim može biti data numerička vrednost (pozitivna ili negativna).';
$string['scores'] = 'Rezultati';
$string['secondpluswrong'] = 'Nije baš. Da li želite da pokušate ponovo?';
$string['selectaqtype'] = 'Odaberite tip pitanja';
$string['shortanswer'] = 'Kratak odgovor';
$string['showanunansweredpage'] = 'Prikaži stranicu sa neodgovorenim pitanjem';
$string['showanunseenpage'] = 'Prikaži nepregledanu stranicu';
$string['singleanswer'] = 'Jedan odgovor';
$string['skip'] = 'Preskoči navigaciju';
$string['slideshow'] = 'Prikaz slajd po slajd';
$string['slideshowbgcolor'] = 'Pozadinska boja pri prikazu slajdova';
$string['slideshowheight'] = 'Visina dela za prikaz slajdova';
$string['slideshow_help'] = 'Ukoliko je podešavanje omogućeno, lekcija se prikazuje slajd po slajd, sa fiksnom širinom i visinom.';
$string['slideshowwidth'] = 'Širina dela za prikaz slajdova';
$string['startlesson'] = 'Počnite lekciju';
$string['studentattemptlesson'] = '{$a->attempt} pokušaj korisnika {$a->lastname}, {$a->firstname}';
$string['studentname'] = '{$a} Ime';
$string['studentoneminwarning'] = 'Upozorenje: imate manje od jednog minuta da završite lekciju.';
$string['studentresponse'] = 'Odgovor polaznika {$a}';
$string['submit'] = 'Pošalji';
$string['submitname'] = 'Pošalji ime';
$string['teacherjumpwarning'] = 'U ovoj lekciji se koriste {$a->cluster} ili {$a->unseen} prelaz između stranica. Prelaz "Sledeća stranica" će se koristiti umesto njih tokom ovog prikaza. Za testiranje ovih prelaza prijavite se na sistem u ulozi polaznika.';
$string['teacherongoingwarning'] = 'Trenutni rezultat tokom pregleda lekcije se prikazuje samo polaznicima. Prijavite se na sistem u ulozi polaznika da biste testirali ovu mogućnost.';
$string['teachertimerwarning'] = 'Merač vremena mogu da vide samo polaznici. Kako biste testirali merač vremena prijavite se na sistem u ulozi polaznika.';
$string['thatsthecorrectanswer'] = 'Tačan odgovor';
$string['thatsthewronganswer'] = 'Pogrešan odgovor';
$string['thefollowingpagesjumptothispage'] = 'Sledeće stranice vode do ove stranice';
$string['thispage'] = 'Ova stranica';
$string['timeisup'] = 'Време је истекло';
$string['timeremaining'] = 'Preostalo vreme';
$string['timespenterror'] = 'Provedite bar {$a} minuta pregledajući sadržaj lekcije';
$string['timespentminutes'] = 'Potrošeno vreme (u minutima)';
$string['timetaken'] = 'Potrošeno vreme';
$string['topscorestitle'] = '{$a} najboljih rezultata';
$string['truefalse'] = 'Tačno/netačno';
$string['unabledtosavefile'] = 'Nije moguće sačuvati datoteku koji ste poslali.';
$string['unknownqtypesnotimported'] = 'Broj pitanja, sa nepodržanim tipom pitanja, koja nisu uvezena: {$a}';
$string['unseenpageinbranch'] = 'Još neprikazano pitanje unutar strane sa sadržajem i grananjem';
$string['unsupportedqtype'] = 'Tip pitanja koji nije podržan {$a}!';
$string['updatedpage'] = 'Stranica je ažurirana';
$string['updatefailed'] = 'Ažuriranje nije uspelo';
$string['usemaximum'] = 'Koristi maksimalnu vrednost';
$string['usemean'] = 'Koristi prosečnu vrednost';
$string['usepassword'] = 'Lekcija zaštićena lozinkom';
$string['usepassword_help'] = 'Ukoliko je uključeno, za pristup lekciji neophodna je lozinka';
$string['viewgrades'] = 'Prikaz ocena';
$string['viewhighscores'] = 'Prikaz liste najboljih rezultata';
$string['viewreports'] = 'Prikaz {$a->attempts} kompletnih pokušaja polaznika {$a->student}';
$string['viewreports2'] = 'Pogledaj {$a} završenih pokušaja';
$string['welldone'] = 'Bravo!';
$string['whatdofirst'] = 'Šta želite prvo da uradite?';
$string['wronganswerjump'] = 'Stranica koja će se prikazati nakon pogrešnog odgovora';
$string['wronganswerscore'] = 'Broj bodova koji nosi pogrešan odgovor';
$string['wrongresponse'] = 'Povratne informacije za pogrešan odgovor';
$string['xattempts'] = '{$a} pokušaj(a)';
$string['youhaveseen'] = 'Već ste videli više od jedne stranice ove lekcije.<br /> Želite li početi od poslednje stranice koju ste videli?';
$string['youmadehighscore'] = 'Dospeli ste na listu {$a} najboljih rezultata.';
$string['youranswer'] = 'Vaš odgovor';
$string['yourcurrentgradeis'] = 'Vaša trenutna ocena je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša trenutna ocena je {$a->grade} od mogućih {$a->total}';
$string['youshouldview'] = 'Trebalo bi da odgovorite na barem: {$a}';
