<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   install
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Specificirani administratorski direktorijum je netačan';
$string['admindirname'] = 'Administratorski direktorijum';
$string['admindirsetting'] = 'Vrlo mali broj veb servera koristi /admin kao specijalni URL za pristup raznim podešavanjima (kontrolni panel i sl.). Nažalost, to dovodi do konflikta sa standardnom lokacijom za administratorske stranice u Moodleu. Ovaj problem možete rešiti tako što ćete promeniti ime administratorskog direktorijuma u vašoj instalaciji, i ovde upisati to novo ime. Na primer: <br /> <br /><b>moodleadmin</b><br /> <br />
Ovo podešavanje će prepraviti administratorske linkove u Moodle sistemu.';
$string['admindirsettinghead'] = 'Podešavanje administratorskog direktorijuma';
$string['admindirsettingsub'] = 'Vrlo mali broj veb servera koristi /admin kao specijalni URL za pristup raznim podešavanjima (kontrolni panel i sl.). Nažalost, to dovodi do konflikta sa standardnom lokacijom za administratorske stranice u Moodleu. Ovaj problem možete rešiti tako što ćete promeniti ime administratorskog direktorijuma u vašoj instalaciji, i ovde upisati to novo ime. Na primer: <br /> <br /><b>moodleadmin</b><br /> <br />
Ovo podešavanje će prepraviti administratorske linkove u Moodle sistemu.';
$string['availablelangs'] = 'Dostupni jezički paketi';
$string['caution'] = 'Oprez';
$string['chooselanguage'] = 'Izaberi jezik';
$string['chooselanguagehead'] = 'Izaberite jezik';
$string['chooselanguagesub'] = 'Molimo izaberite jezik koji će se koristiti tokom instalacije. Ovaj jezik će, takođe, biti korišćen na nivou sajta kao podrazumevani, mada to naknadno može biti promenjeno.';
$string['cliadminpassword'] = 'Nova lozinka za administratora';
$string['cliadminusername'] = 'Korisničko ime administratora';
$string['clialreadyconfigured'] = 'Datoteka config.php već postoji. Molimo, upotrebite komandu admin/cli/install_database.php ako želite da instalirate Moodle na ovaj sajt.';
$string['clialreadyinstalled'] = 'Datoteka config.php već postoji. Molimo upotrebite admin/cli/upgrade.php ako želite da nadogradite ovaj sajt.';
$string['cliinstallfinished'] = 'Instalacija je uspešno završena';
$string['cliinstallheader'] = 'Moodle {$a} program za instalaciju iz komandne linije';
$string['climustagreelicense'] = 'U neinteraktivnom modu morate prihvatiti licencu navodeći opciju --agree-license';
$string['clitablesexist'] = 'Baza podtaka već postoji. Nije moguće nastaviti instalaciju iz komandne linije.';
$string['compatibilitysettings'] = 'Provera Vaših PHP podešavanja...';
$string['compatibilitysettingshead'] = 'Provera Vaših PHP podešavanja...';
$string['compatibilitysettingssub'] = 'Vaš server bi trebao proći sve ove testove da bi Moodle na njemu uspešno funkcionisao';
$string['configfilenotwritten'] = 'Instalacioni skript nije bio u mogućnosti da automatski kreira datoteku config.php koja bi sadržavala Vaša odabrana podešavanja, verojatno zbog toga što nema prava na pisanje (menjanje sadržaja) u Vašem Moodle direktorijumu. Ako to želite, možete ručno kopirati kod u datoteku config.php u osnovnom direktorijumu Vaše Moodle instalacije.';
$string['configfilewritten'] = 'config.php je uspešno kreiran';
$string['configurationcomplete'] = 'Konfiguracija je završena';
$string['configurationcompletehead'] = 'Konfiguracija je završena';
$string['configurationcompletesub'] = 'Moodle je pokušao da sačuva Vašu konfiguraciju u datoteci smeštenoj u korenskom direktorijumu Moodle instalacije.';
$string['database'] = 'Baza podataka';
$string['databasehead'] = 'Podešavanja baze podataka';
$string['databasehost'] = 'Server baze podataka';
$string['databasename'] = 'Ime baze podataka';
$string['databasepass'] = 'Lozinka za pristup bazi podataka';
$string['databaseport'] = 'Prebacivanje baze';
$string['databasesocket'] = 'Unix soket';
$string['databasetypehead'] = 'Izaberite drajver baze podataka';
$string['databasetypesub'] = 'Moodle podržava nekoliko tipova baza podataka. Ukoliko ne znate koji tip da koristite kontaktirajte administratora servera.';
$string['databaseuser'] = 'Korisničko ime za pristup bazi podataka';
$string['dataroot'] = 'Direktorijum podataka';
$string['datarooterror'] = '\'Direktorijum podataka\' koji ste naveli ne može biti pronađen ili kreiran. Unesite tačnu putanju ili kreirajte taj direktorijum ručno.';
$string['datarootpermission'] = 'Ovlašćenja nad direktorijumom podataka';
$string['datarootpublicerror'] = '\'Direktorijuma podataka\' koji ste podesili je direktno dostupan preko veba, morate koristiti drugi direktorijum.';
$string['dbconnectionerror'] = 'Nemoguće je uspostaviti vezu sa bazom podataka koju ste naveli. Molimo proverite podešavanja baze podataka.';
$string['dbcreationerror'] = 'Greška pri kreiranju baze podataka. Nije bilo moguće kreirati bazu navedenog imena uz zadata podešavanja';
$string['dbhost'] = 'Server';
$string['dbpass'] = 'Lozinka';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Prefiks tabele';
$string['dbtype'] = 'Tip';
$string['directorysettings'] = '<p>Molimo potvrdite lokacije ove Moodle instalacije</p>

<p><b>Veb adresa:</b>
Navedite punu veb adresu putem koje će se pristupati Moodleu.
Ako se vašem veb sajtu može pristupiti preko više URL adresa, izaberite onu koju će vaši polaznici najverovatnije koristiti. Nemojte u adresi navoditi krajnju kosu crtu.</p>

<p><b>Moodle direktorijum:</b>
Navedite punu putanju do ove instalacije.
Vodite računa o velikim i malim slovima.</p>

<p><b>Direktorijum podataka:</b>
Morate odrediti mesto na kom će Moodle moći da sačuva postavljene datoteke. Korisnik veb servera (obično \'nobody\' ili \'apache\') treba da ima mogućnost da čita podatke iz tog direktorijuma, kao i da UPISUJE podatke u njega, ali direktorijum podataka ne sme biti dostupan direktno preko veba. Program za instalaciju će pokušati da kreira ovaj direktorijum ukoliko on ne postoji.</p>';
$string['directorysettingshead'] = 'Molimo potvrdite lokacije ove Moodle instalacije';
$string['directorysettingssub'] = '<b>Veb adresa:</b>
Navedite punu veb adresu putem koje će se pristupati Moodleu.
Ako se vašem veb sajtu može pristupiti preko više URL adresa, izaberite onu koju će vaši polaznici najverovatnije koristiti. Nemojte u adresi navoditi krajnju kosu crtu.
<br />
<br />
<b>Moodle direktorijum:</b>
Navedite punu putanju do ove instalacije.
Vodite računa o velikim i malim slovima.
<br />
<br />
<b>Direktorijum podataka:</b>
Morate odrediti mesto na kom će Moodle moći da sačuva postavljene datoteke. Korisnik veb servera (obično \'nobody\' ili \'apache\') treba da ima mogućnost da čita podatke iz tog direktorijuma, kao i da UPISUJE podatke u njega, ali direktorijum podataka ne sme biti dostupan direktno preko veba. Program za instalaciju će pokušati da kreira ovaj direktorijum ukoliko on ne postoji.';
$string['dirroot'] = 'Moodle direktorijum';
$string['dirrooterror'] = 'Izgleda da je podešavanje \'Moodle direktorijuma pogrešno - na navedenoj adresi nije moguće pronaći Moodle instalaciju. Donja vrednost je resetovana.';
$string['download'] = 'Preuzeti';
$string['downloadlanguagebutton'] = 'Preuzmi "{$a}" jezički paket';
$string['downloadlanguagehead'] = 'Preuzmi jezički paket';
$string['downloadlanguagenotneeded'] = 'Možete nastaviti proces instalacije korišćenjem podrazumevanog jezičkog paketa, "{$a}".';
$string['downloadlanguagesub'] = 'Sada imate mogućnost preuzimanja željenog jezičkog paketa i nastavka instalacionog procesa na tom jeziku.<br /><br />Ako niste u mogućnosti da preuzmete jezički paket, instalacioni proces će se nastaviti na engleskom jeziku. (Kada se instalacija završi, imaćete mogućnost da preuzmete i instalirate dodatne jezičke pakete.)';
$string['doyouagree'] = 'Da li se slažete? (da/ne)';
$string['environmenthead'] = 'Proveravanje Vašeg okruženja...';
$string['environmentsub'] = 'Proverava se da li razne komponente Vašeg sistema zadovoljavaju sistemske zahteve';
$string['environmentsub2'] = 'Svako izdanje Moodlea ima minimum zahteva po pitanju odgovarajuće PHP verzije i nekoliko obaveznih PHP ekstenzija.
Kompletna provera okruženja se vrši pre svake instalacije i nadogradnje postojeće verzije. Ukoliko ne znate kako da instalirate novu verziju ili omogućite PHP ekstenzije kontaktirajte svog administratora servera.';
$string['errorsinenvironment'] = 'Provera okruženja nije prošla!';
$string['fail'] = 'Nije prošlo';
$string['fileuploads'] = 'Postavljanje datoteka';
$string['fileuploadserror'] = 'Ova opcija bi trebala biti uključena';
$string['fileuploadshelp'] = '<p>Izgleda da je postavljanje datoteka na vašem serveru onemogućeno.</p>

<p>Moodle još uvek može biti instaliran, ali bez ove mogućnosti, nećete moći da postavite datoteke kursa ili nove slike za korisničke profile.</p>

<p>Da biste omogućili postavljanje datoteka vi, ili vaš sistem administrator, ćete morati da uredite datoteku php.ini na svom sistemu i da promenite podešavanje za <b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Direktorijum podatka:';
$string['inputwebadress'] = 'Web adresa :';
$string['inputwebdirectory'] = 'Moodle direktorijum:';
$string['installation'] = 'Instalacija';
$string['langdownloaderror'] = 'Nažalost, jezik "{$a}" se ne može preuzeti. Proces instalacije biće nastavljen na engleskom jeziku.';
$string['langdownloadok'] = 'Jezik "{$a}" je uspešno instaliran. Instalacioni proces će biti nastavljen na ovom jeziku.';
$string['magicquotesruntime'] = 'Magic Quotes vreme izvršavanja';
$string['magicquotesruntimeerror'] = 'Ova opcija bi trebala biti isključena';
$string['magicquotesruntimehelp'] = '<p>Magic quotes vreme izvršavanja treba da bude isključeno kako bi Moodle ispravno funkcionisao.</p>

<p>Normalno, ovo je isključeno prema podrazumevanoj vrednosti... pogledajte podešavanje <b>magic_quotes_runtime</b> u svojoj php.ini datoteci.</p>

<p>Ako nemate pristup svojoj php.ini datoteci, možda ćete moći da stavite sledeći red u datoteku pod nazivom .htaccess, unutar vašeg Moodle direktorijuma: <blocquote>php_value magic_quotes_runtime Off</blockquote>
</p>';
$string['memorylimit'] = 'Ograničenje memorije';
$string['memorylimiterror'] = 'PHP ograničenje memorije je podešeno na prilično nizak nivo... kasnije može doći do problema.';
$string['memorylimithelp'] = '<p>PHP ograničenje memorije za vaš server je trenutno podešeno na {$a}.</p>

<p>Ovo podešavanje može kasnije da prouzrokuje da Moodle ima problema sa memorijom, posebno ako imate mnogo aktiviranih modula i/ili mnogo korisnika.</p>

<p>Preporučujemo da konfigurišete PHP sa višim ograničenjem ako je moguće, recimo 40M. Postoji nekoliko načina na koje to može da se to uradi:</p><ol>
<li>Ako možete, rekompajlirajte PHP sa <i>--enable-memory-limit</i>. Ovo će omogućiti Moodle sistemu da sam postavi memorijsko ograničenje.</li>
<li>Ako imate pristup svojoj php.ini datoteci, možete promeniti vrednost za <b>memory_limit</b> na, recimo, 40M. Ako nemate pristup toj datoteci možete pitati svog administratora da to uradi umesto vas.</li>
<li>Na nekim PHP serverima možete da kreirate .htaccess datoteku u Moodle direktorijumu koja sadrži red:
<blockquote><div>php_value memory_limit 40M</div></blockquote>
<p>Međutim, na nekim serverima to će sprečiti prikazivanje <b>svih</b> PHP stranica (videćete poruku o grešci kada budete gledali stranice), pa ćete sa tih servera morati da uklonite .htaccess datoteku.</p></li>
</ol>';
$string['mssqlextensionisnotpresentinphp'] = 'PHP nije bio propisno konfigurisan sa MSSQL ekstenzijom tako da može komunicirati sa SQL* Serverom. Molimo Vas da proverite svoju php.ini datoteku ili opet kompajlirate PHP.';
$string['mysqliextensionisnotpresentinphp'] = 'PHP nije pravilno podešen za rad sa MySQLi ekstenzijom da bi mogao da komunicira sa MySQL. Molimo, proverite svoju php.ini datoteku ili ponovo kompajlirajte PHP.';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Sada je neophodno da konfigurišete bazu podatka gde će najveći deo podataka iz Moodlea biti smešten.</p>
<p>Naziv baze, korisničko ime i lozinka su obavezna polja. Prefiks tabela je opcioni.</p>
<p>Ako baza trenutno ne postoji, ali dati korisnik ima potrebna ovlašćenja biće pokušano kreiranje nove baze sa odgovarajućim pravima i podešavanjima.</p>
<p>Upravljački program nije kompatibilan sa starim MyISAM mehanizmom.</p>';
$string['nativemssql'] = 'SQL*Server FreeTDS (native/mssql)';
$string['nativemssqlhelp'] = 'Sada je neophodno da konfigurišete bazu podataka u koju će Moodle pohranjivati većinu podataka..
Ova baza podataka, kao i korisničko ime i lozinka za pristup bazi, moraju biti prethodno već kreirani. Prefiks tabele je obavezan.';
$string['nativemysqli'] = 'Unapređen MySQL(native/mysqli)';
$string['nativemysqlihelp'] = '<p>Sada je neophodno da konfigurišete bazu podatka gde će najveći deo podataka iz Moodlea biti smešten.</p>
<p>Naziv baze, korisničko ime i lozinka su obavezna polja. Prefiks tabela je opcioni.</p>
<p>Ako baza trenutno ne postoji, ali dati korisnik ima potrebna ovlašćenja biće pokušano kreiranje nove baze sa odgovarajućim pravima i podešavanjima.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Sada je neophodno da konfigurišete bazu podataka u koju će Moodle pohranjivati većinu podataka.
Ova baza podataka, kao i korisničko ime i lozinka za pristup bazi, moraju biti prethodno već kreirani. Prefiks tabele je obavezan.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Sada je neophodno da konfigurišete bazu podatka gde će najveći deo podataka iz Moodlea biti smešten.</p>
<p>Naziv baze, korisničko ime, lozinka i prefiks tabele su obavezna polja.</p>
<p>Baza mora već postojati i korisnik mora imati ovlašćenja za čitanje iz nje i pisanje u nju.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Sada je neophodno da konfigurišete bazu podataka u koju će Moodle pohranjivati većinu podataka.
Ova baza podataka, kao i korisničko ime i lozinka za pristup bazi, moraju biti prethodno već kreirani.
Prefiks tabele je obavezan.';
$string['nativesqlsrvnodriver'] = 'Microsoft drajveri za SQL server za PHP nisu instalirani ili nisu pravilno konfigurisani.';
$string['nativesqlsrvnonwindows'] = 'Microsoft drajveri za SQL server za PHP dostupni su samo za Windows OS..';
$string['ociextensionisnotpresentinphp'] = 'PHP nije bio propisno konfigurisan sa OCI8 ekstenzijom tako da može komunicirati sa Oracle-om. Molimo Vas da proverite svoju php.ini datoteku ili opet kompajlirate PHP.';
$string['pass'] = 'Prošlo';
$string['paths'] = 'Putanje';
$string['pathserrcreatedataroot'] = 'Instalaciona procedura ne može da kreira direktorijum baze podataka ({$a->dataroot}).';
$string['pathshead'] = 'Potvrdi putanje';
$string['pathsrodataroot'] = 'U direktorijum za podatke nije moguć upis';
$string['pathsroparentdataroot'] = 'Nije moguć upis u nadređeni direktorijum ({$a->parent}).  Instalacioni program ne može da kreira direktorijum za podatke ({$a->dataroot}).';
$string['pathssubadmindir'] = 'Vrlo mali broj veb servera koristi /admin kao specijalni URL za pristup raznim podešavanjima (kontrolni panel i sl.). Nažalost, to dovodi do konflikta sa standardnom lokacijom za administratorske stranice u Moodleu. Ovaj problem možete rešiti tako što ćete promeniti ime administratorskog direktorijuma u vašoj instalaciji, i ovde upisati to novo ime. Na primer <em>moodleadmin</em>. Ovo podešavanje će prepraviti administratorske linkove u Moodle sistemu.';
$string['pathssubdataroot'] = '<p>Potreban vam je prostor gde će Moodle čuvati postavljene datoteke.</p><p>Ovaj direktorijum treba da bude podešen tako da se može čitati i u njega upisivati od strane korisnika Web servera (obično \'www-data\', \'nobody\' ili \'apache\').</p><p>Istovremeno ne sme biti dostupan direktno preko Weba.</p><p>Ukoliko ovaj direktorijum ne postoji Moodle će pokušati da ga kreira tokom instalacije.</p>';
$string['pathssubdirroot'] = '<p>Puna putanja do direktorijuma koji sadrži kod Moodlea.</p>';
$string['pathssubwwwroot'] = '<p>Puna adresa putem koje će se pristupati platformi.</p>
<p>Nije moguće pristupati joj koristeći više adresa. Ako vaš sajt ima više javnih adresa odaberite najjednostavniju i na ostalim podesite permanentne redirekcije na nju.</p>
<p>Ako je vaš sajt dostupan sa Interneta ali i iz intranet okruženja ovde upotrebite javnu adresu.</p>
<p>Ako je adresa netačna promenite URL u svom Web čitaču da biste ponovo pokrenuli instalaciju sa drugačijom vrednošću.</p>';
$string['pathsunsecuredataroot'] = 'Dataroot lokacija nije bezbedna';
$string['pathswrongadmindir'] = 'Admin direktorijum ne postoji';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP nije bio propisno konfigurisan sa  PGSQL ekstenzijom tako da može komunicirati sa PostgreSQLom. Molimo Vas da proverite svoju php.ini datoteku ili opet kompajlirate PHP.';
$string['phpextension'] = '{$a} PHP ekstenѕija';
$string['phpversion'] = 'PHP verzija';
$string['phpversionhelp'] = '<p>Moodle zahteva najmanje PHP verziju 4.3.0 ili 5.1.0 (5.0.x ima  brojne uočene probleme).</p>
<p>Trenutno koristite verziju {$a}</p>
<p>Morate nadograditi PHP ili premestiti Moodle na veb server sa novijom verzijom PHP-a!</br>
(U slučaju verzije 5.0.x možete, takođe, da se vratite na 4.4.x verziju)</p>';
$string['releasenoteslink'] = 'Za više informaciji o ovoj verziji Moodlea, pogledajte napomene uz izdanje na {$a}';
$string['safemode'] = 'Bezbedni režim';
$string['safemodeerror'] = 'Moodle može imati problema sa uključenim bezbednim modom rada';
$string['safemodehelp'] = '<p>Moodle može imati različite probleme ako je uključen bezbedni režim rada. Jedan od bitnijih je taj što mu verovatno neće biti dozvoljeno da kreira nove datoteke.</p>

<p>Bezbedni režim rada je obično omogućen jedino na paranoidnim javnim veb serverima, tako da ćete možda morati da za svoj Moodle sajt nađete novi veb server kod neke druge kompanije.</p>

<p>Možete pokušati da nastavite sa instalacijom, ako želite, ali očekujte nekoliko problema kasnije.</p>';
$string['sessionautostart'] = 'Automatski početak sesije';
$string['sessionautostarterror'] = 'Ova opcija bi trebala biti isključena';
$string['sessionautostarthelp'] = '<p>Moodle zahteva podršku za sesije i neće funcionisati bez nje.</p>

<p>Rad sa sesijama se može omogućiti u php.ini datoteci... potražite session.auto_start parametar.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP nije pravilno podešen sa ekstenzijom SQLite. Molimo proverite Vašu datoteku php.ini ili ponovo kompajlirajte PHP.';
$string['upgradingqtypeplugin'] = 'Nadogradnja dodatka za pitanja/tipove';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Ovu stranicu vidite zato što ste uspešno instalirali i pokrenuli <strong>{$a->packname} {$a->packversion}</strong> paket na svom serveru. Čestitamo!';
$string['welcomep30'] = 'Ovo izdanje <strong>{$a->installername}</strong> uključuje aplikacije za kreiranje okruženja u kojem će <strong>Moodle</strong> uspešno funkcionisati, konkretno:';
$string['welcomep40'] = 'Ovaj paket obuhvata i <strong>Moodle {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Korišćenje svih aplikacija ovog paketa je uređeno njihovim licencama. Kompletan<strong>{$a->installername}</strong> paket je <a href="http://www.opensource.org/docs/definition_plain.html">otvorenog koda</a> i distribuira se pod <a href="http://www.gnu.org/copyleft/gpl.html">GPL</a> licencom.';
$string['welcomep60'] = 'Naredne stranice će vas provesti kroz nekoliko jednostavnih koraka tokom kojih ćete konfigurisati i podesiti <strong>Moodle</strong> na svom računaru. Možete prihvatiti podrazumevana podešavanja ili ih, opciono, prilagoditi sopstvenim potrebama.';
$string['welcomep70'] = 'Kliknite na dugme za nastavak da biste dalje podešavali <strong>Moodle</strong>.';
$string['wwwroot'] = 'Web adresa';
$string['wwwrooterror'] = 'Navedena \'Web adresa\' se čini nevalidnom - ova Moodle instalacija izgleda nije na njoj. Vrednost navedena ispod je resetovana.';
