<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   grades
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Aktivnosti';
$string['addcategory'] = 'Dodaj kategoriju';
$string['addcategoryerror'] = 'Nije moguće dodati kategoriju';
$string['addexceptionerror'] = 'Došlo je do greške tokom dodavanja izuzetka za userid:gradeitem';
$string['addfeedback'] = 'Dodaj povratne informacije';
$string['addgradeletter'] = 'Dodaj slovnu ocenu';
$string['addidnumbers'] = 'Dodaj ID brojeve';
$string['additem'] = 'Dodaj stavku za ocenjivanje';
$string['addoutcome'] = 'Dodaj ishod učenja';
$string['addoutcomeitem'] = 'Dodaj stavku ishoda učenja';
$string['addscale'] = 'Dodaj skalu';
$string['aggregateextracreditmean'] = 'Srednja vrednost ocena (sa dodatnim bodovima)';
$string['aggregatemax'] = 'Najveća ocena';
$string['aggregatemean'] = 'Srednja vrednost ocena';
$string['aggregatemedian'] = 'Medijana ocena';
$string['aggregatemin'] = 'Najniža ocena';
$string['aggregatemode'] = 'Mod ocena (najčešća ocena)';
$string['aggregateonlygraded'] = 'Sumirati samo upisane ocene';
$string['aggregateonlygraded_help'] = '"Prazna" ocena je ocena koja nedostaje u knjizi ocena. To može biti predati zadatka koji još nije ocenjen ili test koji polaznik još uvek nije pokušao da reši itd.

Ovo podešavanje određuje  da li će ove "prazne" ocene biti uključene u zbirnu ocenu ili će se računati kao minimalna ocena, na primer 0 za zadatak koji se ocenjuje od 0 do 100.';
$string['aggregateoutcomes'] = 'Uključi ishode učenja u sumiranje';
$string['aggregateoutcomes_help'] = 'Ako je ova opcija omogućena, ishodi učenja su uključeni u zbirni rezultat. Ovo može da rezultira neočekivanom ukupnom ocenom za kategoriju.';
$string['aggregatesonly'] = 'Samo zbirne ocene';
$string['aggregatesubcats'] = 'Sumiraj uključujući potkategorije';
$string['aggregatesubcats_help'] = 'Ovo podešavanje određuje da li su ocene u potkategorijama uključene u izračunavanje sumarne ocene.';
$string['aggregatesum'] = 'Zbir ocena';
$string['aggregateweightedmean'] = 'Ponderisana srednja vrednost ocena';
$string['aggregateweightedmean2'] = 'Prosta ponderisana srednja vrednost ocena';
$string['aggregation'] = 'Sumiranje ocena';
$string['aggregationcoef'] = 'Koeficijent sumiranja';
$string['aggregationcoefextra'] = 'Dodatni bodovi';
$string['aggregationcoefextra_help'] = 'Ako je metod sumiranja \'Zbir ocena\' ili \'Jednostavna ponderisana srednja vrednost\' i ako je označeno polje za dodatne bodove, maksimalna ocena stavke se ne dodaje najvećoj ukupnoj oceni kategorije, što rezultira mogućnošću da maksimalna ocena u kategoriji bude dostignuta (ili čak prekoračena, ako je administrator sajta omogućio tu opciju), a da pri tome nema nijedne maksimalne ocene za bilo koju od stavki koje se ocenjuju.

Ako je metod sumiranja ‘Srednja vrednost ocena’ (sa dodatnim bodovima) i ako je vrednost za dodatne bodove veća od nule, onda dodatni bodovi postaju faktor kojim se ocena množi pre njenog dodavanja ukupnoj oceni nakon izračunavanja srednje vrednosti.';
$string['aggregationcoefextrasum'] = 'Dodatni bodovi';
$string['aggregationcoefextrasum_help'] = 'Ako je polje za dodatne bodove označeno maksimalna ocena za stavku se ne dodaje maksimalnoj oceni kategorije, što rezultira mogućnošću da maksimalna ocena u kategoriji bude dostignuta (ili čak prekoračena, ako je administrator sajta omogućio tu opciju), a da pri tome nema nijedne maksimalne ocene za bilo koju od stavki koje se ocenjuju.';
$string['aggregationcoefextraweight'] = 'Ponder dodatnih bodova';
$string['aggregationcoefextraweight_help'] = 'Ako je ponder dodatnih bodova postavljen tako da bude veći od 0, onda se ocena ponaša kao dodatni kredit u toku sumiranja. Broj je faktor kojim se ocena množi pre nego što se doda ukupnoj vrednosti za izračunavanje srednje vrednosti.';
$string['aggregationcoefweight'] = 'Ponder stavke';
$string['aggregationcoefweight_help'] = 'Ponder stavke se koristi u izračunavanju sumarne ocene kategorije kako bi odredio važnost stavke, u poređenju sa drugim stavkama koje se ocenjuju unutar iste kategorije.';
$string['aggregation_help'] = 'Način sumiranja određuje kako se kombinuju ocene u pojedinoj kategoriji, a mogući načini su:

* Srednja vrednost ocena - zbir svih ocena podeljen sa ukupnim brojem ocena
* Medijana ocena - središnja ocena u rasponu od najveće do najmanje ocene
* Najniža ocena
* Najviša ocena
* Mod ocena - ocena koja se najčešće pojavljuje
* Zbir ocena - zbir svih vrednosti ocena, nezavisno od skala ocena';
$string['aggregationposition'] = 'Pozicija sumarne ocene';
$string['aggregationposition_help'] = 'Ovo podešavanje određuje da li će  kolone sa ocenama za kategorije i kolona sa ukupnom ocenom na kursu biti prikazane prve ili poslednje u izveštajima iz knjige ocena.';
$string['aggregationsvisible'] = 'Dostupni načini sumiranja';
$string['aggregationsvisiblehelp'] = 'Izaberite sve načine sumiranja ocena koji bi trebalo da su dostupni. Držite CTRL taster za izbor više načina.';
$string['allgrades'] = 'Sve ocene po kategorijama';
$string['allstudents'] = 'Svi polaznici';
$string['allusers'] = 'Svi korisnici';
$string['autosort'] = 'Automatsko sortiranje';
$string['availableidnumbers'] = 'Raspoloživi identifikacioni brojevi';
$string['average'] = 'Prosek';
$string['averagesdecimalpoints'] = 'Broj decimala u prosecima kolona';
$string['averagesdecimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mesta koji će biti prikazana za svaki prosek odnosno da li će se koristiti podešavanje broja decimalnih mesta za kategoriju ili za stavku ocene (nasleđeno).';
$string['averagesdisplaytype'] = 'Tip prikaza kolone sa srednjim ocenam';
$string['averagesdisplaytype_help'] = 'Ovo podešavanje određuje da li se prosek (srednja vrednost) prikazuje kao broj, procenat ili slovo, odnosno, da li će se koristiti tip prikaza za kategoriju ili za stavku ocene (nasleđeno).';
$string['backupwithoutgradebook'] = 'Rezervna kopija ne sadrži podatke o konfiguraciji knjige ocena';
$string['badgrade'] = 'Data ocena je neispravna';
$string['badlyformattedscale'] = 'Molimo vas unesite spisak vrednosti razdvojenih zarezom (neophodne su najmanje dve vrednosti).';
$string['baduser'] = 'Dati korisnik je neispravan';
$string['bonuspoints'] = 'Dodatni bodovi';
$string['bulkcheckboxes'] = 'Opsežna polja za potvrdu';
$string['calculatedgrade'] = 'Izračunata ocena';
$string['calculation'] = 'Proračun';
$string['calculationadd'] = 'Dodaj proračun';
$string['calculationedit'] = 'Uredi proračun';
$string['calculation_help'] = 'Izračunavanje ocene predstavlja formulu koja se koristi kako bi se odredile ocene. Formula treba da počinje znakom jednakosti (=), i može da koristi uobičajene matematičke operatore, kao što su max, min i sum. Ako želite, druge stavke za ocenjivanje mogu biti uključene u izračunavanje tako što ćete upisati ID brojeva tih stavki unutar dvostrukih uglastih zagrada.';
$string['calculationsaved'] = 'Proračun sačuvan';
$string['calculationview'] = 'Pogledaj proračun';
$string['cannotaccessgroup'] = 'Oprostite, ali ne možete da pristupite ocenama izabrave grupe.';
$string['categories'] = 'Kategorije';
$string['categoriesanditems'] = 'Kategorije i stavke';
$string['categoriesedit'] = 'Uredi kategorije i stavke';
$string['category'] = 'Kategorija';
$string['categoryedit'] = 'Uredi  kategoriju';
$string['categoryname'] = 'Naziv kategorije';
$string['categorytotal'] = 'Ukupna ocena za kategoriju';
$string['categorytotalfull'] = '{$a->category} ukupno';
$string['categorytotalname'] = 'Naziv za ukupnu ocenu kategorije';
$string['changedefaults'] = 'Promeni podrazumevana podešavanja';
$string['changereportdefaults'] = 'Promeni podrazumevana podešavanja izveštaja';
$string['chooseaction'] = 'Izaberi akciju...';
$string['choosecategory'] = 'Izaberi kategoriju';
$string['combo'] = 'Tabovi i Padajući meni';
$string['compact'] = 'Kompaktno';
$string['componentcontrolsvisibility'] = 'Podešavanja aktivnosti kontrolišu da li je ova stavka ocene sakrivena.';
$string['contract'] = 'Skupi kategoriju';
$string['controls'] = 'Kontrole';
$string['courseavg'] = 'Prosek na nivou kursa';
$string['coursegradecategory'] = 'Kategorija ocena kursa';
$string['coursegradedisplaytype'] = 'Tip prikazivanja ocena na kursu';
$string['coursegradedisplayupdated'] = 'Tip prikaza ocena na kursu je ažuriran.';
$string['coursegradesettings'] = 'Podešavanje ocena kursa';
$string['coursename'] = 'Naziv kursa';
$string['coursescales'] = 'Skale kursa';
$string['coursesettings'] = 'Podešavanja kursa';
$string['coursesettingsexplanation'] = 'Podešavanja kursa određuju kako se knjiga ocena prikazuje svim učesnicima kursa.';
$string['coursetotal'] = 'Ukupno za kurs';
$string['createcategory'] = 'Kreiraj kategoriju';
$string['createcategoryerror'] = 'Kreiranje nove kategorije nemoguće';
$string['creatinggradebooksettings'] = 'Kreiranje podešavanja knjige ocena';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Trenutno nadređeno sumiranje';
$string['curveto'] = 'Prilagodi na';
$string['decimalpoints'] = 'Broj decimalnih mesta';
$string['decimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mesta koja će biti prikazana za svaku ocenu. Ono ne utiče na izračunavanja ocena, koja se vrše sa preciznošću od 5 decimalnih mesta.';
$string['default'] = 'Podrazumevano';
$string['defaultprev'] = 'Podrazumevano ({$a})';
$string['deletecategory'] = 'Obriši kategoriju';
$string['disablegradehistory'] = 'Onemogući istoriju ocena';
$string['disablegradehistory_help'] = 'Onemogući praćenje istorije promena u tabelama koje se odnose na ocene. Ovo može malo da ubrza server i sačuva prostor u bazi podataka.';
$string['displaylettergrade'] = 'Prikaži slovne ocene (A, B, C...)';
$string['displaypercent'] = 'Prikaži procente';
$string['displaypoints'] = 'Prikaži bodove';
$string['displayweighted'] = 'Prikaži ponderisane ocene';
$string['dropdown'] = 'Padajući meni';
$string['droplow'] = 'Odbaci najniže';
$string['droplowestvalue'] = 'Podesite broj najnižih ocene za odbacivanje';
$string['droplow_help'] = 'Ovo podešavanje omogućuje da određeni broj najnižih ocena bude isključen iz sumiranja.';
$string['dropped'] = 'Odbačeno';
$string['dropxlowest'] = 'Odbaci X najnižih';
$string['dropxlowestwarning'] = 'Napomena: Ako koristite opciju \'odbaci X najnižih ocena\' ocenjivanje pretpostavlja da sve stavke unutar kategorije imaju istu vrednost boda. Ukoliko se vrednosti boda razlikuju rezultati će biti nepredvidljivi';
$string['duplicatescale'] = 'Dupliraj skalu';
$string['edit'] = 'Uredi';
$string['editcalculation'] = 'Uredi proračun';
$string['editcalculationverbose'] = 'Uredi izračunavanje za {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Uredi povratne informacije';
$string['editgrade'] = 'Uredi ocenu';
$string['editgradeletters'] = 'Uredi slovne ocene';
$string['editoutcome'] = 'Uredi ishod učenja';
$string['editoutcomes'] = 'Uredi ishode učenja';
$string['editscale'] = 'Uredi skalu';
$string['edittree'] = 'Kategorije';
$string['editverbose'] = 'Uredi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Omogući AJAX';
$string['enableajax_help'] = 'Dodaje AJAX funkcionalnost izveštaju ocenjivača, čime pojednostavljuje i ubrzava uobičajene operacije. Zavisi od toga da li je korisnik uključio Javascript u svom veb čitaču.';
$string['enableoutcomes'] = 'Omogući ishode učenja';
$string['enableoutcomes_help'] = 'Podrška za ishode učenja (tj. kompetencije, ciljeve, standarde, ili kriterijume) znači da se aktivnosti mogu ocenjivati korišćenjem jedne ili više skala koje su povezane sa iskazima ishoda. Korišćenje ishoda učenja tako omogućava specifično ocenjivanje na nivou čitavog sajta.';
$string['encoding'] = 'Kodiranje';
$string['errorcalculationbroken'] = 'Verovatno postoji kružna referenca ili je formula za izračunavanje oštećena';
$string['errorcalculationnoequal'] = 'Formula mora početi znakom jednakosti (=1+2)';
$string['errorcalculationunknown'] = 'Neispravna formula';
$string['errorgradevaluenonnumeric'] = 'Dobijena je nenumerička vrednost za visoku ili nisku ocenu za';
$string['errornocalculationallowed'] = 'Izračunavanja nisu dozvoljena za ovu stavku';
$string['errornocategorisedid'] = 'Nije moguće dobiti nekategorisan id!';
$string['errornocourse'] = 'Nije moguće dobiti informacije o kursu';
$string['errorreprintheadersnonnumeric'] = 'Dobijena je nenumerička vrednost za ponovni ispis zaglavlja';
$string['errorsavegrade'] = 'Oprostite, nije moguće sačuvati ocenu.';
$string['errorsettinggrade'] = 'Greška pri pokušaju da se sačuva "{$a->itemname}" ocena za korisnički id {$a->userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Greška pri ažuriranju podešavanja "Sumiraj samo upisane ocene" za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Greška pri ažuriranju podešavanja "Uključi ishode učenja u sumiranje" za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradecategoryaggregatesubcats'] = 'Greška pri ažuriranju podešavanja "Sumiraj ocene uključujući potkategorije" za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Greška pri ažuriranju načina sumiranja za kategoriju ocena čiji je ID {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Greška pri ažuriranju koeficijenta sumiranja (pondera ili dodatnih bodova) stavke koja se ocenjuje čiji je ID {$a->id}';
$string['excluded'] = 'Isključeno';
$string['excluded_help'] = 'Ako je označeno, ocena neće biti uključena u bilo koje sumiranje.';
$string['expand'] = 'Proširi kategoriju';
$string['export'] = 'Izvoz';
$string['exportalloutcomes'] = 'Izvezi sve ishode učenja';
$string['exportfeedback'] = 'Uključi povratne informacije u izvoz';
$string['exportonlyactive'] = 'Isključi suspendovane korisnike';
$string['exportonlyactive_help'] = 'Prilikom izvoza biće uključeni samo studenti koji su aktivni na kursu i nisu suspendovani';
$string['exportplugins'] = 'Izvezi dodatke';
$string['exportsettings'] = 'Izvezi podešavanja';
$string['exportto'] = 'Izvezi u';
$string['extracreditvalue'] = 'Dodatni bodovi za {$a}';
$string['extracreditwarning'] = 'Napomena: Podešavanje dodatnih bodova za sve stavke u kategoriji će ih ukloniti iz proračuna ocene, te neće biti ukupnog broja bodova';
$string['feedback'] = 'Povratne informacije';
$string['feedbackadd'] = 'Dodaj povratne informacije';
$string['feedbackedit'] = 'Uredi povratne informacije';
$string['feedbackforgradeitems'] = 'Povratna informacija za {$a}';
$string['feedback_help'] = 'Ovo polje omogućava dodavanje bilo kakvog komentara o oceni.';
$string['feedbacks'] = 'Povratne informacije';
$string['feedbacksaved'] = 'Povratne informacije su sačuvane';
$string['feedbackview'] = 'Pogledaj povratne informacije';
$string['finalgrade'] = 'Konačna ocena';
$string['finalgrade_help'] = 'Ako je polje za izmenu označeno, ocena može da bude dodata ili izmenjena.';
$string['fixedstudents'] = 'Statična kolona sa polaznicima';
$string['fixedstudents_help'] = 'Ova opcija fiksira kolonu sa imenima polaznika i na taj način omogućava da se kolone sa ocenama pomeraju horizontalno, a da se pri tome kolona sa imenima polaznika uvek vidi.';
$string['forceoff'] = 'Obavezno: Isključeno';
$string['forceon'] = 'Obavezno: Uključeno';
$string['forelementtypes'] = 'za izabrani {$a}';
$string['forstudents'] = 'Za polaznike';
$string['full'] = 'Pun';
$string['fullmode'] = 'Puni prikaz';
$string['fullview'] = 'Puni prikaz';
$string['generalsettings'] = 'Opšta podešavanja';
$string['grade'] = 'Ocena';
$string['gradeadministration'] = 'Administracija ocena';
$string['gradeanalysis'] = 'Analiza ocena';
$string['gradebook'] = 'Knjiga ocena';
$string['gradebookhiddenerror'] = 'Knjiga ocena je trenutno podešena tako da sve skriva od polaznika';
$string['gradebookhistories'] = 'Istorije ocena';
$string['gradeboundary'] = 'Granice slovnih ocena';
$string['gradeboundary_help'] = 'Ovo podešavanje određuje minimalni procenat iznad kojeg će biti dodeljena slovna ocena.';
$string['gradecategories'] = 'Kategorije ocena';
$string['gradecategory'] = 'Kategorija ocena';
$string['gradecategoryonmodform'] = 'Kategorija ocena';
$string['gradecategoryonmodform_help'] = 'Ovo podešavanje kontroliše kategoriju u koju se smeštaju ocene za ovu aktivnost unutar knjige ocena.';
$string['gradecategorysettings'] = 'Podešavanja kategorije ocena';
$string['gradedisplay'] = 'Prikaz ocena';
$string['gradedisplaytype'] = 'Tip prikaza ocena';
$string['gradedisplaytype_help'] = 'Ovo podešavanje određuje način na koji će ocene biti prikazane u izveštajima ocenjivača i korisnika.

* Broj - prave ocene
* Procenat
* Slovo - slova ili reči se koriste za prikaz raspona ocena';
$string['gradedon'] = 'Ocenjeno: $a';
$string['gradeexport'] = 'Izvoz ocena';
$string['gradeexportcustomprofilefields'] = 'Prilagođena polja profila uključena u izvoz ocena';
$string['gradeexportcustomprofilefields_desc'] = 'Uključite u izvoz ocena ova prilagođena polja profila, razdvojena zarezima.';
$string['gradeexportdecimalpoints'] = 'Broj decimalnih mesta pri izvozu ocena';
$string['gradeexportdecimalpoints_desc'] = 'Broj decimalnih mesta za prikaz pri izvozu. Ova vrednost može biti promenjena tokom izvoza.';
$string['gradeexportdisplaytype'] = 'Tip prikaza za izvoz ocena';
$string['gradeexportdisplaytype_desc'] = 'Ocene mogu biti prikazane kao celi brojevi, kao procenti (u odnosu na najmanje i najveće ocene) ili kao slova (A, B, C itd.). Ovo može biti promenjeno tokom eksportovanja.';
$string['gradeexportuserprofilefields'] = 'Polja korisničkog profila uključena u izvoz ocena';
$string['gradeexportuserprofilefields_desc'] = 'Uključite u izvoz ocena ova polja korisničkog profila, razdvojena zarezima.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradehelp'] = 'Pomoć za ocene';
$string['gradehistorylifetime'] = 'Trajanje istorije ocena';
$string['gradehistorylifetime_help'] = 'Ovo određuje koliko dugo želite da čuvate istoriju promena u tabelama koje su povezane sa ocenama. Preporučeno je da istoriju čuvate što je duže moguće. Ukoliko budete imali problema sa performansama sistema ili ako imate ograničen prostor za bazu podataka, pokušajte da postavite nižu vrednost.';
$string['gradeimport'] = 'Uvoz ocena';
$string['gradeimportfailed'] = 'Увоз оцена није успео. Више информација:';
$string['gradeitem'] = 'Moguća ocena';
$string['gradeitemaddusers'] = 'Isključi iz ocenjivanja';
$string['gradeitemadvanced'] = 'Napredne opcije za stavke ocenjivanja';
$string['gradeitemadvanced_help'] = 'Izaberi sve elemente koje treba prikazati kao napredne kada se uređuju stavke ocenjivanja.';
$string['gradeitemislocked'] = 'Ova aktivnost je zaključana u knjizi ocena. Promene koje su načinjene u okviru ove aktivnosti neće biti kopirane u knjigu ocena sve dok se ista ne otključa.';
$string['gradeitemlocked'] = 'Ocenjivanje zaključano';
$string['gradeitemmembersselected'] = 'Isključeno iz ocenjivanja';
$string['gradeitemnonmembers'] = 'Uključeno u ocenjivanje';
$string['gradeitemremovemembers'] = 'Uključi u ocenjivanje';
$string['gradeitems'] = 'Stavke ocenjivanja';
$string['gradeitemsettings'] = 'Podešavanja stavki ocenjivanja';
$string['gradeitemsinc'] = 'Stavke ocenjivanja koje treba uključiti';
$string['gradeletter'] = 'Slovna ocena';
$string['gradeletter_help'] = 'Slovne ocene su A, B, C... ili reči, npr. odličan, dobar, dovoljan,... koje se koriste da predstave raspon ocena.';
$string['gradeletternote'] = 'Da biste izbrisali slovnu ocenu samo obrišite bilo koje od <br /> tri tekstulna polja za dato slovo i pritisnite taster za čuvanje podešavanja.';
$string['gradeletters'] = 'Slovne ocene';
$string['gradelocked'] = 'Ocena je zaključana';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Najveća ocena';
$string['grademax_help'] = 'Ovo podešavanje određuje maksimalnu ocenu kada se kao tip ocene koristi brojčana vrednost. Maksimalna ocena za aktivnost se određuje na stranici za podešavanje te aktivnosti.';
$string['grademin'] = 'Najmanja ocena';
$string['grademin_help'] = 'Ovo podešavanje određuje minimalnu ocenu kada se kao tip ocene koristi brojčana vrednost.';
$string['gradeoutcomeitem'] = 'Oceni stavku ishoda učenja';
$string['gradeoutcomes'] = 'Ishodi učenja';
$string['gradeoutcomescourses'] = 'Ishodi učenja kursa';
$string['gradepass'] = 'Ocena za prolaz';
$string['gradepass_help'] = 'Ovo podešavanje određuje minimalnu ocenu potrebnu za prolaz. Vrednost se koristi za procenu završenost aktivnosti i kursa, kao i u knjizi ocena gde su prelazne ocene označene zelenom, a neprelazne crvenom bojom.';
$string['gradepreferences'] = 'Parametri ocene';
$string['gradepreferenceshelp'] = 'Pomoć za parametre ocene';
$string['gradepublishing'] = 'Omogući objavljivanje';
$string['gradepublishing_help'] = 'Omogućite objavljivanje u izvozima i uvozima podataka: Izvezenim ocenama može se pristupiti preko URL-a, bez obavezne prijave na Moodle sajt. Ocene se mogu uvoziti pristupom takvom URL-u (što znači da se na Moodle sajt mogu uvoziti ocene objavljene na drugom sajtu). Standardno, samo administratori mogu koristiti ovo svojstvo. Molimo vas da detaljno obavestite korisnike pre nego što ovu mogućnost dodelite drugim ulogama tj. korisnicima - upozorite ih na opasnost deljenja obeleženih ("bukmarkovanih") stranica, korišćenje program za preuzimanje datoteka (Flash Get i sličnih programa), ograničenja IP adresa itd.';
$string['gradereport'] = 'Izveštaj o ocenama';
$string['graderreport'] = 'Izveštaj ocenjivača';
$string['grades'] = 'Ocene';
$string['gradesforuser'] = 'Ocene za {$a->user}';
$string['gradesonly'] = 'Samo ocene';
$string['gradessettings'] = 'Podešavanja ocena';
$string['gradetype'] = 'Tip ocene';
$string['gradetype_help'] = 'Postoje 4 tipa ocena:

* Ništa - ocenjivanje nije moguće
* Vrednost - brojčana vrednost sa maksimalnom i minimalnom vrednošću
* Skala - stavka na spisku
* Tekst - samo povratne informacije

Samo vrednosti i skale mogu da se sumiraju. Tip ocene za pojedinu aktivnost se određuje na stranici za podešavanja te aktivnosti.';
$string['gradeview'] = 'Pogledaj ocenu';
$string['gradewasmodifiedduringediting'] = 'Ocena uneta pod stavkom {$a->itemname} za polaznika sa korisničkim imenom {$a->username} je ignorisana jer ju je kasnije ažurirao neko drugi.';
$string['gradeweighthelp'] = 'Pomoć za ponder ocena';
$string['groupavg'] = 'Prosek grupe';
$string['hidden'] = 'Sakriveno';
$string['hiddenasdate'] = 'Prikaži datum za skrivene ocene';
$string['hiddenasdate_help'] = 'Ukoliko korisnik ne može da vidi sakrivene ocene prikažite datum kada je ocena postavljena umesto znaka \'-\'.';
$string['hidden_help'] = 'Ako je označeno, ocene su sakrivene od polaznika. Ako želite možete postaviti opciju \'sakriveno do dana\' kako bi se ocene objavile nakon što je ocenjivanje završeno.';
$string['hiddenuntil'] = 'Sakriven do';
$string['hiddenuntildate'] = 'Sakriven do: {$a}';
$string['hideadvanced'] = 'Sakrij napredne opcije';
$string['hideaverages'] = 'Sakrij proseke';
$string['hidecalculations'] = 'Sakrij proračune';
$string['hidecategory'] = 'Sakriveno';
$string['hideeyecons'] = 'Sakrij ikonice prikaži/sakrij';
$string['hidefeedback'] = 'Sakrij povratne informacije';
$string['hideforcedsettings'] = 'Sakrij prinudna podešavanja';
$string['hideforcedsettings_help'] = 'Ne prikazuj prinudna podešavanja u korisničkom interfejsu za ocenjivanje';
$string['hidegroups'] = 'Sakrij grupe';
$string['hidelocks'] = 'Sakrij zaključavanja';
$string['hidenooutcomes'] = 'Prikaži ishode učenja';
$string['hidequickfeedback'] = 'Sakrij brze povratne informacije';
$string['hideranges'] = 'Sakrij opsege';
$string['hidetotalifhiddenitems'] = 'Sakrij ukupne ocene ako sadrže skrivene stavke';
$string['hidetotalifhiddenitems_help'] = 'Ovo podešavanje određuje da li se ukupne ocene koje sadrže sakrivene stavke prikazuju polaznicima ili se zamenjuju crticom (-). Ako se prikazuju, ukupna ocena može biti izračunata ili bez ili sa sakrivenim stavkama.

Ako su sakrivene stavke isključene, ukupna ocena će biti različita od ukupne ocene koju vidi predavač u izveštaju ocenjivača, zato što predavač uvek vidi ukupnu ocenu za sve stavke, bez obzira jesu li one sakrivene ili ne. Ako su sakrivene stavke uključene u ukupnu ocenu, polaznici mogu da izračunaju ocene za sakrivene stavke.';
$string['hidetotalshowexhiddenitems'] = 'Prikaži ukupne ocene bez sakrivenih stavki';
$string['hidetotalshowinchiddenitems'] = 'Prikaži ukupne ocene uključujući sakrivene stavke';
$string['hideverbose'] = 'Sakrij {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sortiraj po visini ocene - rastući niz';
$string['highgradedescending'] = 'Sortiraj po visini ocene - opadajući niz';
$string['highgradeletter'] = 'Gornja granica';
$string['identifier'] = 'Identifikuj korisnika prema';
$string['idnumbers'] = 'ID brojevi';
$string['ignore'] = 'Ignoriši';
$string['import'] = 'Uvezi';
$string['importcsv'] = 'Uvezi CSV';
$string['importcustom'] = 'Uvezi kao namenski prilagođene ishode učenja (samo za ovaj kurs)';
$string['importerror'] = 'Došlo je do greške, ovaj skript nije bio pozvan sa pravim parametrima';
$string['importfailed'] = 'Uvoz nije uspeo. Ništa od podataka nije uvezeno.';
$string['importfeedback'] = 'Uvezi povratne informacije';
$string['importfile'] = 'Uvezi datoteku';
$string['importfilemissing'] = 'Nijedna datoteka nije primljena, vratite se na obrazac i uverite se da ste prosledili ispravnu datoteku.';
$string['importfrom'] = 'Uvezi iz';
$string['importoutcomenofile'] = 'Postavljena datoteka je prazna ili oštećena. Molimo, proverite da li je datoteka ispravna. Problem je otkriven u redu {$a}; ovo je pokrenuto zbog redova sa podacima koji nisu imali jednak broj kolona kao prvi (naslovni) red, ili ukoliko su nedostajala očekivana zaglavlja u uvezenoj datoteci. Pogledajte izvezenu datoteku za primer datoteke ispravnim zaglavljem.';
$string['importoutcomes'] = 'Uvezi ishode učenja';
$string['importoutcomes_help'] = 'Ishodi učenja mogu biti uvezeni iz CSV datoteke koja ima format kao i CSV datoteka za izvoz ishoda učenja.';
$string['importoutcomesuccess'] = 'Uvezen ishod učenja "{$a->name}" sa ID #{$a->id}';
$string['importplugins'] = 'Uvezi dodatke';
$string['importpreview'] = 'Pregled uvezenih ocena';
$string['importsettings'] = 'Podešavanja uvoza';
$string['importskippednomanagescale'] = 'Nemate ovlašćenje za dodavanje nove skale ocenjivanja, tako da je ishod učenja"{$a}" preskočen jer je zahtevao kreiranje nove skale';
$string['importskippedoutcome'] = 'Ishod sa kraćim nazivom "{$a}" već postoji u ovom kontekstu, onaj iz uvezene datoteke je preskočen.';
$string['importstandard'] = 'Uvezi kao standardne ishode učenja';
$string['importsuccess'] = 'Uspešan uvoz ocena';
$string['importxml'] = 'Uvezi XML';
$string['includescalesinaggregation'] = 'Uključi skale u sumiranje';
$string['includescalesinaggregation_help'] = 'Možete promeniti da se skale za ocenjivanje uključe kao brojevi u svim zbirnim ocenama u svim knjigama ocena na svim kursevima. UPOZORENЈE: promena ovog podešavanja pokrenuće ponovno izračunavanje svih zbirnih ocena.';
$string['incorrectcourseid'] = 'ID kursa je netačan';
$string['incorrectcustomscale'] = '(Neispravna prilagođena skala, molimo promenite.)';
$string['incorrectminmax'] = 'Minimalna vrednost mora biti manja od maksimalne';
$string['inherit'] = 'Nasleđeno';
$string['intersectioninfo'] = 'Polaznik/Ocena info';
$string['item'] = 'Stavka';
$string['iteminfo'] = 'Informacije o stavci';
$string['iteminfo_help'] = 'Ovo podešavanje obezbeđuje prostor za unos informacija o stavci. Informacije se nigde drugde ne prikazuju.';
$string['itemname'] = 'Naziv stavke';
$string['itemnamehelp'] = 'Naziv ove stavke dobijen od modula.';
$string['items'] = 'Stavke';
$string['itemsedit'] = 'Uredi stavku ocene';
$string['keephigh'] = 'Zadrži najveću';
$string['keephigh_help'] = 'Ako je ova opcija podešena, čuvaće se samo X najviših ocena, gde je X odabrana vrednost za ovu opciju.';
$string['keymanager'] = 'Upravljanje ključevima';
$string['lessthanmin'] = 'Ocena uneta za {$a->itemname} za korisnika {$a->username} je manja od minimalno dozvoljene';
$string['letter'] = 'Slovo';
$string['lettergrade'] = 'Slovna ocena';
$string['lettergradenonnumber'] = 'Najniža i/ili najviša ocena nisu bile numeričke za';
$string['letterpercentage'] = 'Slovo (procenat)';
$string['letterreal'] = 'Slovo (realna vrednost)';
$string['letters'] = 'Slova';
$string['linkedactivity'] = 'Linkovana aktivnost';
$string['linkedactivity_help'] = 'Ovo podešavanje određuje aktivnost sa kojom je ovaj ishod učenja povezan. Ovo se može koristiti za merenje postignuća polaznika koja se ne procenjuju pomoću ocena aktivnosti.';
$string['linktoactivity'] = 'Link ka aktivnosti {$a->name}';
$string['lock'] = 'Zaključaj';
$string['locked'] = 'Zaključano';
$string['locked_help'] = 'Ako je označeno, ocene su zaključane i više ne mogu biti automatski ažurirane od strane pripadajuće aktivnosti.';
$string['locktime'] = 'Zaključano nakon';
$string['locktimedate'] = 'Zaključaj nakon: {$a}';
$string['lockverbose'] = 'Zaključaj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Najniže';
$string['lowgradeletter'] = 'Donja granica';
$string['manualitem'] = 'Ručne stavke';
$string['mapfrom'] = 'Preslikaj iz';
$string['mappings'] = 'Preslikavanje stavki ocena';
$string['mapto'] = 'Preslikaj u';
$string['max'] = 'Najviše';
$string['maxgrade'] = 'Maksimalna ocena';
$string['meanall'] = 'Sve ocene';
$string['meangraded'] = 'Upisane ocene';
$string['meanselection'] = 'Ocene odabrane za računanje proseka kolone';
$string['meanselection_help'] = 'Ovo podešavanje odredite da li  polja bez upisane ocene treba da budu uključene u računanje proseka (srednje vrednosti) za svaku kategoriju ili stavku ocene.';
$string['median'] = 'Medijana';
$string['min'] = 'Najniže';
$string['missingscale'] = 'Skala za ocenjivanje mora biti izabrana';
$string['mode'] = 'Mod';
$string['morethanmax'] = 'Ocena uneta za {$a->itemname} za korisnika {$a->username} je veća od maksimalno dozvoljene';
$string['moveselectedto'] = 'Premesti izabrane stavke u';
$string['movingelement'] = 'Pomeranje {$a}';
$string['multfactor'] = 'Multiplikator';
$string['multfactor_help'] = 'Multiplikator je faktor kojim će sve ocene za ovu stavku biti pomnožene, sa najvećom vrednošću maksimalne ocene. Na primer, ako je multiplikator 2 a maksimalna ocena 100, onda će sve ocene manje od 50 biti pomnožene sa 2, a sve ocene iznad 50 promenjene u 100.';
$string['multfactorvalue'] = 'Vrednost multiplikatora za {$a}';
$string['mypreferences'] = 'Moja podešavanja';
$string['myreportpreferences'] = 'Moj izveštaj - podešavanja';
$string['navmethod'] = 'Metod navigacije';
$string['neverdeletehistory'] = 'Nikada ne briši istoriju';
$string['newcategory'] = 'Nova kategorija';
$string['newitem'] = 'Nova stavka ocene';
$string['newoutcomeitem'] = 'Novi ishod učenja';
$string['no'] = 'Ne';
$string['nocategories'] = 'Kategorije ocena za ovaj kurs ne mogu biti dodate ili pronađene';
$string['nocategoryname'] = 'Nije dat naziv kategorije';
$string['nocategoryview'] = 'Nema kategorije za prikaz';
$string['nocourses'] = 'Još uvek nema kurseva';
$string['noforce'] = 'Ne forsiraj podešavanja';
$string['nogradeletters'] = 'Nema podešenih slovnih ocena';
$string['nogradesreturned'] = 'Nema dobijenih ocena';
$string['noidnumber'] = 'Nema ID broja';
$string['nolettergrade'] = 'Nema slovne ocene za';
$string['nomode'] = 'Nije primenljivo';
$string['nonnumericweight'] = 'Dobijena je nenumerička vrednost za';
$string['nonunlockableverbose'] = 'Ova ocena ne može se otključati dok se ne otključa {$a->itemname}.';
$string['nonweightedpct'] = 'neponderisani %';
$string['nooutcome'] = 'Bez ishoda učenja';
$string['nooutcomes'] = 'Stavke ishoda učenja moraju biti povezane sa ishodom kursa, ali za ovaj kurs ne postoje ishoda . Da li želite da dodate ishod učenja?';
$string['nopublish'] = 'Ne objavljivati';
$string['norolesdefined'] = 'Nijedna uloga nije definisana u Administracija > Ocene > Opšta podešavanja > Uloge koje se ocenjuju';
$string['noscales'] = 'Ishodi moraju biti povezani sa skalom kursa ili globalnom skalom';
$string['noselectedcategories'] = 'nije izabrana nijedna kategorija.';
$string['noselecteditems'] = 'nije izabrana nijedna stavka.';
$string['notteachererror'] = 'Morate biti predavač da biste koristili ovu opciju.';
$string['nousersloaded'] = 'Nisu učitani korisnici';
$string['numberofgrades'] = 'Broj ocena';
$string['onascaleof'] = 'na skali od {$a->grademin} do {$a->grademax}';
$string['operations'] = 'Operacije';
$string['options'] = 'Opcije';
$string['others'] = 'Ostalo';
$string['outcome'] = 'Ishod učenja';
$string['outcomeassigntocourse'] = 'Dodeli drugi ishod učenja ovom kursu';
$string['outcomecategory'] = 'Kreiraj ishode u kategoriji';
$string['outcomecategorynew'] = 'Nova kategorija';
$string['outcomeconfirmdelete'] = 'Da li ste sigurni da želite da obrišete ishod učenja "{$a}"?';
$string['outcomecreate'] = 'Dodaj novi ishod učenja';
$string['outcomedelete'] = 'Obriši ishod učenja';
$string['outcomefullname'] = 'Puno ime';
$string['outcome_help'] = 'Ovo podešavanje određuje ishod učenja koji će ova stavka ocenjivanja predstavljati u knjizi ocena.';
$string['outcomeitem'] = 'Stavka ishoda učenja';
$string['outcomeitemsedit'] = 'Uredi stavku ishoda učenja';
$string['outcomereport'] = 'Izveštaj o ishodima učenja';
$string['outcomes'] = 'Ishodi učenja';
$string['outcomescourse'] = 'Ishodi učenja korišćeni na kursu';
$string['outcomescoursecustom'] = 'Koriste se nestandardni ishodi učenja (ne mogu se ukloniti)';
$string['outcomescoursenotused'] = 'Ne koriste se standardni ishodi učenja';
$string['outcomescourseused'] = 'Koriste se standardni ishodi učenja (ne mogu se ukloniti)';
$string['outcomescustom'] = 'Nestandardni ishodi učenja';
$string['outcomeshortname'] = 'Skraćeni naziv';
$string['outcomesstandard'] = 'Standardni ishodi učenja';
$string['outcomesstandardavailable'] = 'Raspoloživi standardni ishodi učenja';
$string['outcomestandard'] = 'Standardni ishod učenja';
$string['outcomestandard_help'] = 'Standardni ishod učenja je dostupan u svim kursevima na sajtu.';
$string['overallaverage'] = 'Sveukupan prosek';
$string['overridden'] = 'Poništeno';
$string['overridden_help'] = 'Ako je označeno, ocene ne mogu više da se menjaju unutar pripadajuće aktivnosti.

Kada se ocena menja unutar izveštaja ocenjivača, polje za izmenu ocene je automatski označeno.
Međutim, oznaka se može ukloniti kako bi se se dozvolilo da ocena bude promenjena unutar pripadajuće aktivnosti.';
$string['overriddennotice'] = 'Vaša završna ocena za ovu aktivnost je ručno podešena';
$string['overridesitedefaultgradedisplaytype'] = 'Poništi podrazumevane vrednosti na nivou sajta';
$string['overridesitedefaultgradedisplaytype_help'] = 'Ako je označeno, mogu se podešavati slovne ocene i njihovi opsezi na nivou kursa, umesto da se koriste podrazumevana podešavanja na nivou sajta.';
$string['parentcategory'] = 'Nadređena kategorija';
$string['pctoftotalgrade'] = '% od ukupne ocene';
$string['percent'] = 'Procenat';
$string['percentage'] = 'Procenat';
$string['percentageletter'] = 'Procenat (slovo)';
$string['percentagereal'] = 'Procenat (realna vrednost)';
$string['percentascending'] = 'Sortiraj po procentima - rastući niz';
$string['percentdescending'] = 'Sortiraj po procentima - opadajući niz';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Pomak';
$string['plusfactor_help'] = 'Pomak je broj koji se dodaje svakoj oceni za ovu stavku, nakon primene multiplikatora.';
$string['plusfactorvalue'] = 'Ofset (dodatna) vrednost za {$a}';
$string['points'] = 'bodova';
$string['pointsascending'] = 'Sortiraj po bodovima - rastući niz';
$string['pointsdescending'] = 'Sortiraj po bodovima - opadajući niz';
$string['positionfirst'] = 'Prvi';
$string['positionlast'] = 'Poslednji';
$string['preferences'] = 'Podešavanja';
$string['prefgeneral'] = 'Opšta podešavanja';
$string['prefletters'] = 'Slovne ocene i granice';
$string['prefrows'] = 'Specijalni redovi';
$string['prefshow'] = 'Prekidači prikaži/sakrij';
$string['previewrows'] = 'Pregled redova';
$string['profilereport'] = 'Izveštaj korisničkog profila';
$string['profilereport_help'] = 'Izveštaj o ocenama koji se koristi na stranici sa profilom korisnika.';
$string['publishing'] = 'Objavljivanje';
$string['quickfeedback'] = 'Brze povratne informacije';
$string['quickgrading'] = 'Brzo ocenjivanje';
$string['quickgrading_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno , za svaku ocenu se pojavljuje polje za unos teksta, što omogućava da se istovremeno uređuje veći broj ocena. Kada se klikne da na dugme za ažuriranje, promene su sačuvane i istaknute.

Imajte u vidu da je, prilikom uređivanja ocene u izveštaju ocenjivača, postavljena zastavica (indikator) izmene, što znači da ocena ne može više da se menja unutar pripadajuće aktivnosti.';
$string['range'] = 'Opseg';
$string['rangedecimals'] = 'Broj decimalnih mesta opsega';
$string['rangedecimals_help'] = 'Broj decimalnih mesta koje treba prikazati za opseg .';
$string['rangesdecimalpoints'] = 'Decimale prikazane u opsezima';
$string['rangesdecimalpoints_help'] = 'Ovo podešavanje određuje broj decimalnih mesta koji će biti prikazan za svaki opseg, odnosno da li će biti korišćeno podešavanje broja decimalnih mesta za kategoriju ili za stavku ocene (nasleđeno)';
$string['rangesdisplaytype'] = 'Tip prikaza opsega';
$string['rangesdisplaytype_help'] = 'Ovo podešavanje određuje da li se opseg prikazuje kao broj, procenat ili slovo, odnosno, da li će se koristiti tip prikaza za kategoriju ili za stavku ocene (nasleđeno).';
$string['rank'] = 'Rang';
$string['rawpct'] = 'Neobrađeni %';
$string['real'] = 'Realna vrednost';
$string['realletter'] = 'Realna vrednost (slovo)';
$string['realpercentage'] = 'Realna vrednost (procenat)';
$string['recovergradesdefault'] = 'Povrati podrazumevane ocene';
$string['recovergradesdefault_help'] = 'Standardno, vraća stare ocene kada ponovo upisujete korisnika na kurs.';
$string['regradeanyway'] = 'Ipak ponovo oceni';
$string['removeallcoursegrades'] = 'Obriši sve ocene';
$string['removeallcourseitems'] = 'Obriši sve stavke i kategorije';
$string['report'] = 'Izveštaj';
$string['reportdefault'] = 'Podrazumevani izveštaj ({$a})';
$string['reportplugins'] = 'Dodaci za izveštaj';
$string['reportsettings'] = 'Podešavanje izveštaja';
$string['reprintheaders'] = 'Ponovni ispis zaglavlja';
$string['respectingcurrentdata'] = 'ostavljajući trenutna podešavanja neizmenjena';
$string['rowpreviewnum'] = 'Broj redova za pregled';
$string['savechanges'] = 'Sačuvaj promene';
$string['savepreferences'] = 'Sačuvaj parametre';
$string['scaleconfirmdelete'] = 'Da li ste sigurni da želite da obrišete skalu "{$a}"?';
$string['scaledpct'] = 'Skalirani %';
$string['seeallcoursegrades'] = 'Pogledaj sve ocene kursa';
$string['select'] = 'Izaberi {$a}';
$string['selectalloroneuser'] = 'Izaberi sve ili nijednog korisnika';
$string['selectauser'] = 'Izaberi korisnika';
$string['selectdestination'] = 'Izaberi odredište za {$a}';
$string['separator'] = 'Graničnik';
$string['sepcolon'] = 'Dvotačka';
$string['sepcomma'] = 'Zarez';
$string['sepsemicolon'] = 'Tačka i zarez';
$string['septab'] = 'Tabulator';
$string['setcategories'] = 'Podesi kategorije';
$string['setcategorieserror'] = 'Prvo morate da podesite kategorije za svoj kurs pre nego što im odredite pondere.';
$string['setgradeletters'] = 'Podesi slovne ocene';
$string['setpreferences'] = 'Podesi parametre';
$string['setting'] = 'Podešavanje';
$string['settings'] = 'Podešavanja';
$string['setweights'] = 'Podesi pondere';
$string['showactivityicons'] = 'Prikaži ikonice aktivnosti';
$string['showactivityicons_help'] = 'Ako je ova opcija omogućena, ikonice aktivnosti će biti prikazane pored naziva aktivnosti.';
$string['showallhidden'] = 'Prikaži skrivene';
$string['showallstudents'] = 'Prikaži sve polaznike';
$string['showanalysisicon'] = 'Prikaži ikonicu za analizu ocena';
$string['showanalysisicon_desc'] = 'Da li, standardno, prikazati ikonicu za analizu ocena. Ako modul aktivnost to podržava, ikonica za analizu ocena je povezana sa stranicom sa detaljnijim objašnjenjem ocene i kako je ona dobijena.';
$string['showanalysisicon_help'] = 'Ako modul aktivnost to podržava, ikonica za analizu ocena je povezana sa stranicom sa detaljnijim objašnjenjem ocene i kako je ona dobijena.';
$string['showaverage'] = 'Prikaži prosek';
$string['showaverage_help'] = 'Prikaži prosek kolone? Polaznici bi mogli da procene ocene drugih polaznika ako se prosek računa na osnovu manjeg broja ocena. Zbog brzine izvođenja, prosek je približan ukoliko zavisi od skrivenih stavki.';
$string['showaverages'] = 'Prikaži prosečne vrednosti kolona';
$string['showaverages_help'] = 'Ako je ova opcija omogućena, izvještaj ocenjivača će sadržati dodatni red u kojem će biti prikazan prosek (srednja vrednost) za svaku kategoriju i svaku stavku koja se ocenjuje.';
$string['showcalculations'] = 'Prikaži proračune';
$string['showcalculations_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, za svaku stavku ocene i kategoriju ocenjivanja  prikazuje se kalkulator, zajedno sa kratkim uputstvom, koje se pojavljuje kada se mišem pređe preko izračunate stavke, kao i sa vizuelnim indikatorom da je kolona izračunata.';
$string['showeyecons'] = 'Prikaži ikonice prikaži/sakrij';
$string['showeyecons_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, pored svake ocene se pojavljuje ikonica prikaži/sakrij, čime se kontroliše da li će polaznik moći da vidi svoje ocene.';
$string['showfeedback'] = 'Prikaži povratne informacije';
$string['showfeedback_help'] = 'Da li prikazati kolonu sa povratnim informacijama?';
$string['showgrade'] = 'Prikaži ocene';
$string['showgrade_help'] = 'Da li prikazati kolonu sa ocenama?';
$string['showgroups'] = 'Prikaži grupe';
$string['showhiddenitems'] = 'Prikaži sakrivene stavke';
$string['showhiddenitems_help'] = 'Da li su sakrivene stavke ocena sakrivene u potpunosti ili su nazivi tih stavki vidljivi polaznicima?

* Prikaži sakriveno - nazivi sakrivenih stavki su prikazani, ali ocene polaznika nisu
* Sakriveno do - stavke su potpuno sakrivene do navedenog datuma nakon čega su u potpunosti vidljive.
* Ne prikazuj - sakrivene stavke su u potpunosti sakrivene';
$string['showhiddenuntilonly'] = 'Sakriveno do';
$string['showlettergrade'] = 'Prikaži slovne ocene';
$string['showlettergrade_help'] = 'Da li prikazati kolonu sa slovnim ocenama?';
$string['showlocks'] = 'Prikaži zaključavanja';
$string['showlocks_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, pored svake ocene se prikazuje ikonica zaključaj/otključaj kojom se kontroliše da li ocene mogu automatski da se ažuriraju od strane pripadajuće aktivnosti.';
$string['shownohidden'] = 'Ne prikazuj';
$string['shownooutcomes'] = 'Sakrij ishode učenja';
$string['shownumberofgrades'] = 'Prikaži broj ocena u prosecima';
$string['shownumberofgrades_help'] = 'Ako je omogućena ova opcija, broj ocena, korišćenih prilikom izračunavanja proseka (srednje vrednosti), prikazan je u zagradi pored svakog proseka.';
$string['showonlyactiveenrol'] = 'Prikaži samo aktivne upise';
$string['showonlyactiveenrol_help'] = 'Ovo podešavanje određuje da li će u izveštaju iz knjige ocena biti vidljivi samo upisani korisnici koji su aktivni. Ako je podešavanje omogućeno suspendovani korisnici neće biti prikazani u knjizi ocena.';
$string['showpercentage'] = 'Prikaži procenat';
$string['showpercentage_help'] = 'Da li prikazati procentualnu vrednost za svaku stavku ocene?';
$string['showquickfeedback'] = 'Prikaži brze povratne informacije';
$string['showquickfeedback_help'] = 'Ako je ova opcija omogućena, kada je uređivanje uključeno, pored svake ocene prikazuje se polje, sa isprekidanim ivicama, za unos povratnih informacija. što omogućava da se istovremeno uređuju povratne informacije za veći broj ocena. Kada se klikne da na dugme za ažuriranje, promene su sačuvane i istaknute.

Imajte u vidu da je, prilikom uređivanja povratnih informacija u izveštaju ocenjivača, postavljena zastavica (indikator) izmene, što znači da povratne informacije ne mogu više da se menjaju unutar pripadajuće aktivnosti';
$string['showrange'] = 'Prikaži opsege';
$string['showrange_help'] = 'Da li prikazati kolonu sa opsegom?';
$string['showranges'] = 'Prikaži opsege';
$string['showranges_help'] = 'Ako je ova opcija omogućena, izveštaj ocenjivača će sadržati dodatni red u kojem će biti prikazan opseg za svaku kategoriju i stavku koja se ocenjuje.';
$string['showrank'] = 'Prikaži rang';
$string['showrank_help'] = 'Da li prikazati poziciju polaznika u odnosu na ostale učesnike za svaku stavku ocene?';
$string['showuserimage'] = 'Prikaži slike iz korisničkih profila';
$string['showuserimage_help'] = 'Da li prikazati sliku korisnika pored njegovog imena u izvešataju ocenjivača?';
$string['showverbose'] = 'Prikaži {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Prikaži pondere';
$string['showweight_help'] = 'Da li prikazati kolonu sa ponderima ocena?';
$string['simpleview'] = 'Jednostavan prikaz';
$string['sitewide'] = 'Na celom sajtu';
$string['sort'] = 'sortiraj';
$string['sortasc'] = 'Sortiraj u rastućem nizu';
$string['sortbyfirstname'] = 'Sortiraj po imenu';
$string['sortbylastname'] = 'Sortiraj po prezimenu';
$string['sortdesc'] = 'Sortiraj u opadajućem nizu';
$string['standarddeviation'] = 'Standardna devijacija';
$string['stats'] = 'Statistika';
$string['statslink'] = 'Statistika';
$string['student'] = 'Polaznik';
$string['studentsperpage'] = 'Broj polaznika po strani';
$string['studentsperpage_help'] = 'Ovo podešavanje određuje broj polaznika koji će biti prikazan na svakoj stranici izveštaja ocenjivača';
$string['studentsperpagereduced'] = 'Maksimalan broj polaznika po stranici je smanjen sa {$a->originalstudentsperpage} na {$a->studentsperpage}. Razmislite o povećanju vrednosti za PHP podešavanje max_input_vars iz {$a->maxinputvars}.';
$string['subcategory'] = 'Normalna kategorija';
$string['submissions'] = 'Predato';
$string['submittedon'] = 'Predato: {$a}';
$string['switchtofullview'] = 'Pređi na potpun prikaz';
$string['switchtosimpleview'] = 'Pređi na jednostavan prikaz';
$string['tabs'] = 'Tabulatori';
$string['topcategory'] = 'Nadkategorija';
$string['total'] = 'Ukupno';
$string['totalweight100'] = 'Ukupni ponder je jednak 100';
$string['totalweightnot100'] = 'Ukupni ponder nije jednak 100';
$string['turnfeedbackoff'] = 'Isključi povratne informacije';
$string['turnfeedbackon'] = 'Uključi povratne informacije';
$string['typenone'] = 'Nijedan';
$string['typescale'] = 'Skala';
$string['typescale_help'] = 'Ovo podešavanje određuje skalu koja se koristi kada se ocenjivanje vrši pomoću skala. Skala za ocenjivanje aktivnosti se postavlja na stranici za podešavanje te aktivnosti.';
$string['typetext'] = 'Tekst';
$string['typevalue'] = 'Vrednost';
$string['uncategorised'] = 'Nekategorisano';
$string['unchangedgrade'] = 'Ocena je nepromenjena';
$string['unenrolledusersinimport'] = 'Ovaj uvoz je uključio sledeće ocene za korisnike koji trenutno nisu upisani na ovaj kursu: {$a}';
$string['unlimitedgrades'] = 'Neograničene ocene';
$string['unlimitedgrades_help'] = 'Standardno, ocene su ograničene maksimalnom i minimalnom vrednošću stavke koja se ocenjuje. Ako se omogući ovo podešavanja ukida se to ograničenje i dozvoljava se da ocene veće od 100% budu direktno unete u knjigu ocena. Preporučuje se da ovo podešavanje bude uključeno u vreme smanjene aktivnosti na sajtu, pošto će sve ocene biti preračunate, što može da  rezultira velikim opterećenjem servera.';
$string['unlock'] = 'Otključaj';
$string['unlockverbose'] = 'Otključaj {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Nekorišćeno';
$string['updatedgradesonly'] = 'Izvezi samo nove ili ažurirane ocene';
$string['uploadgrades'] = 'Pošalji ocene';
$string['useadvanced'] = 'Koristi napredne opcije';
$string['usedcourses'] = 'Korišćeni kursevi';
$string['usedgradeitem'] = 'Korišćena stavka ocenjivanja';
$string['usenooutcome'] = 'Ne koristi ishode učenja';
$string['usenoscale'] = 'Bez skala';
$string['usepercent'] = 'Koristi procente';
$string['user'] = 'Korisnik';
$string['userenrolmentsuspended'] = 'Upis korisnika je suspendovan';
$string['usergrade'] = 'Korisnik {$a->fullname} ({$a->useridnumber}) za stavku {$a->gradeidnumber}';
$string['userid'] = 'Identifikator korisnika';
$string['usermappingerror'] = 'Грешка приликом мапирања корисника: није могуће пронаћи корисника са пољем {$a->field} које има вредност "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Korisnik nije član tekuće grupe.';
$string['usermappingerrorusernotfound'] = 'Грешка приликом мапирања корисника: Није могуће пронаћи корисника,';
$string['userpreferences'] = 'Korisnička podešavanja';
$string['useweighted'] = 'Koristi ponderisane vrednosti';
$string['verbosescales'] = 'Detaljne skale';
$string['viewbygroup'] = 'Grupa';
$string['viewgrades'] = 'Pogledaj ocene';
$string['warningexcludedsum'] = 'Upozorenje: isključivanje ocena nije kompatibilno sa sumiranjem.';
$string['weight'] = 'ponder';
$string['weightcourse'] = 'Koristi ponderisane ocene za kurs';
$string['weightedascending'] = 'Sortiraj prema ponderisanom procentu - rastući niz';
$string['weighteddescending'] = 'Sortiraj prema ponderisanom procentu - opadajući niz';
$string['weightedpct'] = 'ponderisani %';
$string['weightedpctcontribution'] = 'doprinos ponderisanih % u ukupnoj oceni';
$string['weightorextracredit'] = 'Ponder ili dodatni bodovi';
$string['weights'] = 'Ponderi';
$string['weightsedit'] = 'Uredi ponder i dodatne bodove';
$string['weightuc'] = 'Ponder';
$string['writinggradebookinfo'] = 'Zapisivanje podešavanja knjige ocena';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Vaša ocena';
