<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'sr_lt', branch 'MOODLE_26_STABLE'
 *
 * @package   glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcomment'] = 'Dodaj komentar';
$string['addentry'] = 'Dodaj novi pojam';
$string['addingcomment'] = 'Dodaj komentara';
$string['alias'] = 'Ključna reč';
$string['aliases'] = 'Ključne reči';
$string['aliases_help'] = 'Svaki pojam u rečniku može imati pridruženi spisak ključnih reči (ili alijasa). Ako koristite filter za automatsko povezivanje pojmova, onda će i sve ključne reči, pridružene pojmu, biti automatski povezane.

Svaku ključnu reč unesite u novi red (nemojte ih razdvajati zarezima).';
$string['allcategories'] = 'Sve kategorije';
$string['allentries'] = 'SVE';
$string['allowcomments'] = 'Dozvolite komentarisanje pojmova';
$string['allowcomments_help'] = '<p>Polaznicima može biti dozvoljeno da unose komentare za pojmove u rečniku.</p>

<p>Možete odabrati želite li da ova opcija bude uključena ili isključena.</p>

<p>Predavači uvek mogu da dodaju komentare za pojmove u  rečniku.</p>';
$string['allowduplicatedentries'] = 'Dozvoljeni su duplikati pojmova';
$string['allowduplicatedentries_help'] = '<p>Ako uključite ovu opciju, biće dozvoljeno da višestruki pojmovi imaju isto konceptualno ime.</p>';
$string['allowprintview'] = 'Dozvoliti prikaz verzije za štampu';
$string['allowprintview_help'] = 'Ako je ova opcija omogućena, polaznicima će biti dostupan link ka verziji rečnika koja je prilagođena za štampanje. Ovaj link je uvek dostupan predavačima.';
$string['andmorenewentries'] = 'i još {$a} novih pojmova.';
$string['answer'] = 'Odgovor';
$string['approvaldisplayformat'] = 'Format prikaza prilikom odobravanja';
$string['approvaldisplayformat_help'] = 'Prilikom odobravanja novih stavki u rečniku možda ćete hteti da koristite drugačiji format prikaza';
$string['approve'] = 'Odobri';
$string['areaattachment'] = 'Prilozi';
$string['areaentry'] = 'Definicije';
$string['areyousuredelete'] = 'Jeste li sigurni da želite da obrišete ovaj pojam?';
$string['areyousuredeletecomment'] = 'Jeste li sigurni da želite da obrišete ovaj komentar?';
$string['areyousureexport'] = 'Jeste li sigurni da želite da izvezete ovaj pojam u';
$string['ascending'] = '(rastući)';
$string['attachment'] = 'Prilog';
$string['attachment_help'] = '<p>Možete opciono zakačiti JEDAN fajl sa svog kompjutera bilo kojem pojmu u rečniku. Taj fajl se upload-uje na server i čuva se sa pomenutim pojmom.</p>

<p>Ovo je korisno kada želite da delite sliku, recimo, ili Word dokument.</p>

<p>Ovaj fajl može biti bilo kog tipa, ali je strogo preporučljivo da je ime fajla sa standardnim za internet sufiksima od tri slova, kao što su .doc za Word dokumente, .jpg ili .png za slike, itd. Ovo će olakšati drugima da skinu sa mreže i vide Vaše priloge na svojim browser-ima.</p>

<p>Ako ponovo izmenite pojam i zakačite novi fajl, ranije zakačen prilog biće zamenjen.</p>

<p>Ako ponovo izmenite pojam i prilog i ostavite ovo mesto prazno, originalni prilog će biti vraćen.</p>';
$string['author'] = 'autor';
$string['authorview'] = 'Pregled po autorima';
$string['back'] = 'Nazad';
$string['cantinsertcat'] = 'Ne može se umetnuti kategorija';
$string['cantinsertrec'] = 'Ne može se umetnuti pojam';
$string['cantinsertrel'] = 'Ne može se umetnuti relacija kategorija - pojam';
$string['casesensitive'] = 'Uz razlikovanje malih i velikih slova';
$string['casesensitive_help'] = '<p>Ova opcija određuje da li je neophodno tačno podudaranje u velikim i malim slovima prilikom automatskog linkovanja pojmova.</p>

<p>Na primer, ako je ova opcija uključena, tada se reč "html" u poruci na forumu NEĆE linkovati na pojam "HTML" u rečniku.</p>';
$string['cat'] = 'kategorija';
$string['categories'] = 'Kategorije';
$string['category'] = 'Kategorija';
$string['categorydeleted'] = 'Kategorija je obrisana';
$string['categoryview'] = 'Pregled po kategorijama';
$string['changeto'] = 'promena u <b>{$a}</b>';
$string['cnfallowcomments'] = 'Definiše da li se podrazumeva da će rečnik prihvatati komentare pojmova';
$string['cnfallowdupentries'] = 'Definiše da li se podrazumeva da će rečnik prihvatati duplikate pojmova';
$string['cnfapprovalstatus'] = 'Definiše podrazumevani status za odobravanje unosa novih pojmova poslatih od strane polaznika';
$string['cnfcasesensitive'] = 'Definiše da li da novi pojam, kad je linkovan, po podrazumevanoj vrednosti razlikuje mala i velika slova';
$string['cnfdefaulthook'] = 'Izaberite način za prikaz rečnika viđenog po prvi put';
$string['cnfdefaultmode'] = 'Izaberite podrazumevani okvir za prikaz rečnika viđenog po prvi put.';
$string['cnffullmatch'] = 'Definiše da se pojam, ako je linkovan, apsolutno poklapa sa ciljanim tekstom';
$string['cnflinkentry'] = 'Definiše da li novi pojam treba da bude automatski linkovan';
$string['cnflinkglossaries'] = 'Definiše da li rečnik treba da bude automatski linkovan';
$string['cnfrelatedview'] = 'Izaberite format prikaza koji će biti korišćen za automatsko linkovanje i prikaz pojomova.';
$string['cnfshowgroup'] = 'Odlučite da li grupna pauza treba da bude prikazana ili ne.';
$string['cnfsortkey'] = 'Izaberite podrazumevani ključ za sortiranje.';
$string['cnfsortorder'] = 'Odaberite podrazumevani redosled sortiranja.';
$string['cnfstudentcanpost'] = 'Definiše da li polaznici po podrazumevanim opcijama mogu ili ne mogu da unose pojmove u rečnik';
$string['comment'] = 'Komentar';
$string['commentdeleted'] = 'Komentar je obrisan.';
$string['comments'] = 'Komentari';
$string['commentson'] = 'Komentari su uključeni';
$string['commentupdated'] = 'Komentar je ažuriran.';
$string['completionentries'] = 'Broj pojmova koje polaznik mora da unese:';
$string['completionentriesgroup'] = 'Zahtevaj unos pojmova';
$string['concept'] = 'Pojam';
$string['concepts'] = 'Pojmovi';
$string['configenablerssfeeds'] = 'Ovaj prekidač će omogućiti korišćenja RSS servisa za sve rečnike. Ipak, moraćete ručno da uključite RSS podršku u podešavanjima za svaki rečnik posebno.';
$string['current'] = 'Trenutno sortirano <b>{$a}</b>';
$string['currentglossary'] = 'Trenutni rečnik';
$string['date'] = 'datum';
$string['dateview'] = 'Pregled po datumu';
$string['defaultapproval'] = 'Podrazumevani status za odobrenja';
$string['defaultapproval_help'] = '<p>Ova opcija omogućava predavaču da definiše šta će biti sa novim pojmovima koje su dodali polaznici. Oni mogu biti automatski dostupni svima, ili, sa druge strane, predavač mora svaki od njih da odobri.</p>';
$string['defaulthook'] = 'Podrazumevani način';
$string['defaultmode'] = 'podrazumevani prikaz';
$string['defaultsortkey'] = 'podrazumevani ključ za sortiranje';
$string['defaultsortorder'] = 'podrazumevani redosled sortiranja';
$string['definition'] = 'Definicija';
$string['definitions'] = 'Definicije';
$string['deleteentry'] = 'Obriši pojam';
$string['deletenotenrolled'] = 'Obriši pojmove učesnika koji nisu upisani na kurs';
$string['deletingcomment'] = 'Brisanje komentara';
$string['deletingnoneemptycategory'] = 'Brisanjem ove kategorije, nećete obrisati pojmove koje sadrži - oni će biti označeni kao nekategorizovani.';
$string['descending'] = '(opadajući)';
$string['destination'] = 'Odredište uvezenih pojmova';
$string['destination_help'] = '<p>Možete navesti gde želite da uvezete pojmove:</p>

</p><ul><li><strong>Tekući rečnik:</strong> Pojmove koje uvozite biće dodati u trenutno otvoren rečnik.
</li>
<li><strong>Novi rečnik:</strong> Kreiraće novi rečnik baziran na informacijama pronađenim u odabranom fajlu koji se uvozi i dodaće nove pojmove u njega.</li>
</ul>';
$string['disapprove'] = 'Poništi odobrenje';
$string['displayformat'] = 'Format prikaza';
$string['displayformatcontinuous'] = 'Produžen bez autora';
$string['displayformatdefault'] = 'Standardno, isto kao i format prikaza';
$string['displayformatdictionary'] = 'Jednostavan, u stilu rečnika';
$string['displayformatencyclopedia'] = 'Enciklopedija';
$string['displayformatentrylist'] = 'Lista pojmova';
$string['displayformatfaq'] = 'Često postavljana pitanja';
$string['displayformatfullwithauthor'] = 'Puni format sa autorom';
$string['displayformatfullwithoutauthor'] = 'Puni format bez navođenja autora';
$string['displayformat_help'] = 'Postoji 7 različitih formata za prikaz pojmova:

* Jednostavan, u stilu rečnika - izgleda kao konvencionalan rečnik sa odvojenim pojmovima. Autori nisu prikazani, a prilozi se prikazaju kao linkovi
* Kontinuirani bez imena autora - prikazuje pojmove jedan za drugim, koji su razdvojeni samo ikonicama za uređivanje
* Puni format sa imenom autora - ovaj format je sličan izgledu foruma i prikazuje podatke o autoru, dok su prilozi prikazani kao linkovi
* Puni format bez imena autora - ovaj format je, takođe, sličan izgledu foruma, ali ne prikazuje podatke o autoru, dok su prilozi prikazani kao linkovi
* Enciklopedija - ovaj format je isti kao "Puni format sa imenom autora" osim što se priložene slike prikazuju unutar teksta (definicije pojma)
* Lista pojmova - pojmovi su navedeni kao linkovi
* FAQ (<i>Frequently Asked Questions</i> - često postavljana pitanja) - u ovom formatu kao pojam se prikazuje PITANjE, a definicija kao ODGOVOR.';
$string['displayformats'] = 'Formati prikaza';
$string['displayformatssetup'] = 'Prikaz podešavanja formata';
$string['duplicatecategory'] = 'Duplikat kategorije';
$string['duplicateentry'] = 'Duplikat pojma';
$string['editalways'] = 'Uvek dozvoli uređivanje';
$string['editalways_help'] = '<p>Ova opcija Vam daje mogućnost da odlučite da li će polaznici moći da uređuju svoje pojmove u bilo kom momentu.</p>

<p>Možete izabrati:</p>

<ul>
<li><b>Da:</b> Pojmovi se uvek mogu uređivati.</li>

<li><b>Ne:</b> Pojmovi se mogu uređivati dok ne istekne vreme predviđeno za to.</li>
</ul>';
$string['editcategories'] = 'Uredi kategorije';
$string['editentry'] = 'Uredi pojam';
$string['editingcomment'] = 'Uređivanje komentara';
$string['entbypage'] = 'Broj pojmova po stranici';
$string['entries'] = 'Pojmovi';
$string['entrieswithoutcategory'] = 'Pojmovi van kategorija';
$string['entry'] = 'Pojam';
$string['entryalreadyexist'] = 'Pojam već postoji';
$string['entryapproved'] = 'Ovaj pojam je odobren';
$string['entrydeleted'] = 'Pojam je obrisan';
$string['entryexported'] = 'Pojam je uspešno izvezen';
$string['entryishidden'] = '(ovaj pojam je trenutno sakriven)';
$string['entryleveldefaultsettings'] = 'Podrazumevana podešavanja na nivou pojma';
$string['entrysaved'] = 'Pojam je sačuvan';
$string['entryupdated'] = 'Pojam je ažuriran';
$string['entryusedynalink'] = 'Ovaj pojam treba da bude automatski linkovan';
$string['entryusedynalink_help'] = '<p align="center"><b>Omogući automatsko linkovvanje u pojmu</b></p>
<p></p>
<p>Uključivanje ove opcije će omogućiti pojmu da bude automatski linkovan kad god se taj popjam ili izraz pojavi negde u okviru istog kursa. To podrazumeva poruke na forumima, unutrašnje resurse, nedeljne preglede itd.</p>

<p>Ako ne želite da određeni tekst bude linkovan (u porukama na forumima, recimo), onda treba da dodate &lt;nolink&gt; ispred i &lt;/nolink&gt; iza tog teksta.</p>

<p>Da bi ova opcija mogla da se uključi mora biti omogućeno auto linkovanje na nivou rečnika.</p>';
$string['errcannoteditothers'] = 'Ne možete uređivati pojmove drugih korisnika.';
$string['errconceptalreadyexists'] = 'Ovaj pojam već postoji. Duplikati nisu dozvoljeni u ovom rečniku.';
$string['errdeltimeexpired'] = 'Ne možete ovo obrisati. Vreme je isteklo!';
$string['erredittimeexpired'] = 'Isteklo je vreme za uređivanje ovog pojma.';
$string['errorparsingxml'] = 'Pojavile su se greške pri parsiranju datoteke. Proverite validnost XML sintakse.';
$string['explainaddentry'] = 'Dodaj novi pojam trenutnom rečniku.<br />Pojam i definicija su obavezna polja.';
$string['explainall'] = 'Prikazivanje SVIH pojmova na jednoj stranici';
$string['explainalphabet'] = 'Pregled rečnika korišćenjem ovog indeksa';
$string['explainexport'] = 'Datoteka je napravljena.<br />Preuzmite je i sačuvajte. Možete je uvek kad to želite uvesti u ovaj ili drugi kurs.<p>Imajte na umu da prilozi (npr. slike) i autori nisu izvezeni.</p>';
$string['explainimport'] = 'Morate da odredite datoteku za uvoz i da definišete kriterijume za taj proces.<br />Priložite zahtev i pregledajte rezultate.';
$string['explainspecial'] = 'Prikaži pojmove koji ne počinju slovom';
$string['exportedentry'] = 'Izvezen pojam';
$string['exportentries'] = 'Izvezi pojmove';
$string['exportentriestoxml'] = 'Izvezi pojmove u XML datoteku';
$string['exportfile'] = 'Izvezi pojmove u datoteku';
$string['exportglossary'] = 'Izvezi rečnik';
$string['exporttomainglossary'] = 'Izvezi u glavni rečnik';
$string['filetoimport'] = 'Datoteka za uvoz';
$string['filetoimport_help'] = '<p>Odaberite na svom kompjuteru XML datoteku koja sadrži pojmove za uvoz.</p>';
$string['fillfields'] = 'Pojam i definicija su obavezna polja.';
$string['filtername'] = 'Automatsko linkovanje rečnika';
$string['fullmatch'] = 'Ako se podudaraju isključivo cele reči';
$string['fullmatch_help'] = '<p>Ako je omogućeno automatsko linkovanje, onda će uključivanje ove opcije forsirati samo cele reči za linkovanje.</p>

<p>Na primer, pojam "construct" u rečniku neće napraviti link unutar reči "constructivism".</p>';
$string['glossary:addinstance'] = 'Dodaj novi rečnik';
$string['glossary:approve'] = 'Odobri neodobrene pojmove, ili poništi odobrenje odobrenih';
$string['glossary:comment'] = 'Napiši komentar';
$string['glossary:export'] = 'Izvoz pojmova';
$string['glossary:exportentry'] = 'Izvoz jednog pojma';
$string['glossary:exportownentry'] = 'Izvoz jednog sopstvenog pojma';
$string['glossary:import'] = 'Uvoz pojmova';
$string['glossaryleveldefaultsettings'] = 'Podrazumevana podešavanja na nivou rečnika';
$string['glossary:managecategories'] = 'Upravljanje kategorijama';
$string['glossary:managecomments'] = 'Upravljanje komentarima';
$string['glossary:manageentries'] = 'Upravljanje pojmovima';
$string['glossary:rate'] = 'Oceni pojmova';
$string['glossarytype'] = 'Vrsta rečnika';
$string['glossarytype_help'] = '<p>Sistem rečnika dozvoljava izvoz pojmova iz bilo kojeg sporednog rečnika u glavni rečnik kursa.</p>

<p>Da biste to uradili, potrebno je da definišete koji je glavni rečnik kursa.</p>

<p>Primedba: Možete imati samo jedan glavni rečnik u okviru kursa i jedino je predavačima dozvoljeno da ga nadograđuju.</p>';
$string['glossary:view'] = 'Pogledaj rečnik';
$string['glossary:viewallratings'] = 'Pogledajte sve neobrađene ocene date od strane pojedinaca';
$string['glossary:viewanyrating'] = 'Pogledajte ukupne ocene koje je bilo ko dobio';
$string['glossary:viewrating'] = 'Pogledajte ukupnu ocenu koju ste dobili';
$string['glossary:write'] = 'Kreiranje novih pojmova';
$string['guestnoedit'] = 'Gostima nije dozvoljeno da uređuju rečnike';
$string['importcategories'] = 'Uvezi kategorije';
$string['importedcategories'] = 'Uvezene kategorije';
$string['importedentries'] = 'Uvezeni pojmovi';
$string['importentries'] = 'Uvezi pojmove';
$string['importentriesfromxml'] = 'Uvezi pojmove iz XML datoteke';
$string['includegroupbreaks'] = 'Uključi prelaze grupa';
$string['isglobal'] = 'Da li je ovo opšti rečnik?';
$string['isglobal_help'] = '<p>Administratori mogu da odrede rečnik koji će biti osnovni.</p>

<p>Ovi rečnici mogu biti deo bilo kojeg kursa (but particulary front page).</p>

<p>Razlika između normalnog lokalnog rečnika i osnovnog rečnika je da se u osnovnom rečniku pojmovi koriste za kreiranje automatskih linkova na nivou celog sajta (a ne samo na nivou kursa kome rečnik pripada).</p>';
$string['letter'] = 'slovo';
$string['linkcategory'] = 'Automatski linkuj ovu kategoriju';
$string['linkcategory_help'] = '<p>Možete podesiti želite li da kategorije budu automatski linkovane, ili ne.</p>

<p>Primedba: Kategorije se linkuju bazirano na podudaranju celih reči sa razlikovanjem velikih i malih slova.</p>';
$string['linking'] = 'Automatsko linkovanje';
$string['mainglossary'] = 'Glavni rečnik';
$string['maxtimehaspassed'] = 'Nažalost, maksimalno dopušteno vreme za uređivanje/izmenu ovog komentara ({$a}) je isteklo!';
$string['modulename'] = 'Rečnik';
$string['modulename_help'] = 'Modul \'Rečnik\' omogućava učesnicima da kreiraju i održavaju liste pojmova i njihovih definicija, ili da sakupljaju i oragnizuju resurse i informacije.

Predavač može da dozvoli da se uz pojmove u rečniku dodaju datoteke kao prilog. Priložene slike se prikazuju unutar definicije pojma. Pojmovi u rečniku mogu da se pretražuju ili pregledaju po azbučnom (abecednom) redosledu ili po kategorijama, datumu ili autoru. Uneti pojmovi mogu biti automatski odobreni za objavljivanje, ili ih predavač mora odobriti pre nego što postanu svima vidljivi.

Ako je filter za automatsko linkovanje rečnika omogućen, pojmovi će automatski biti povezani gde god da se unutar kursa pojavljuju reči i/ili fraze iz pojma (ili ključnih reči kojima se pojam dodatno definiše).

Predavač može da dozvoli komentarisanje pojmove, kao i njihovo ocenjivanje kako od strane predavača, tako i od strane polaznika (vršnjačka evaluacija). Ocene mogu da se sabiraju kako bi se formirala finalna ocena koja se beleži u knjigu ocena.

Rečnici mogu da se koriste na različit načine, kao na primer:

* kolaborativno kreirana banka ključnih termina
* prostor za upoznavanje gde novi polaznici dodaju svoja imena i lične podatke
* \'korisni saveti\' - katalog primera najbolje prakse o praktičnim temama
* prostor za deljenje korisnih video klipova, slika ili audio datoteka
* katalog činjenica koje treba zapamtiti';
$string['modulenameplural'] = 'Rečnici';
$string['newentries'] = 'Novi pojmovi u rečniku';
$string['newglossary'] = 'Novi rečnik';
$string['newglossarycreated'] = 'Novi rečnik je kreiran.';
$string['newglossaryentries'] = 'Novi pojmovi u rečniku:';
$string['nocomment'] = 'Nisu pronađeni komentari';
$string['nocomments'] = '(Nema komentara ovog pojma)';
$string['noconceptfound'] = 'Nisu pronađeni koncepti ili definicije.';
$string['noentries'] = 'Nisu pronađeni pojmovi u ovom odeljku';
$string['noentry'] = 'Nije pronađen nijedan pojam.';
$string['nopermissiontodelcomment'] = 'Ne možete obrisati komentare drugih korisnika!';
$string['nopermissiontodelinglossary'] = 'Ne možete brisati komentare u ovom rečniku!';
$string['nopermissiontoviewresult'] = 'Možete pregledati rezultate samo za sopstvene unose';
$string['notapproved'] = 'Pojam još uvek nije odobren';
$string['notcategorised'] = 'Nije kategorisano';
$string['numberofentries'] = 'Broj pojmova';
$string['onebyline'] = '(jedan po liniji)';
$string['page-mod-glossary-edit'] = 'Ulazna stranica rečnika za dodavanje/uređivanje pojmova';
$string['page-mod-glossary-view'] = 'Stranica za pregled rečnika';
$string['page-mod-glossary-x'] = 'Bilo koja stranica modula \'Rečnik\'';
$string['pluginadministration'] = 'Administracija rečnika';
$string['pluginname'] = 'Rečnik';
$string['popupformat'] = 'Format za popup prozor';
$string['print'] = 'Štampaj';
$string['printerfriendly'] = 'Verzija za štampu';
$string['printviewnotallowed'] = 'Prikaz verzije za štampu nije dozvoljen';
$string['question'] = 'Pitanje';
$string['rejectedentries'] = 'Odbačeni pojmovi';
$string['rejectionrpt'] = 'Izveštaj o odbačenim pojmovima';
$string['resetglossaries'] = 'Obriši pojmove iz';
$string['resetglossariesall'] = 'Obriši pojmove iz svih rečnika';
$string['rssarticles'] = 'Broj skorašnjih RSS članaka (pojmova)';
$string['rssarticles_help'] = '<p>Ova opcija vam daje mogućnost da odaberete broj članova koji želite da uključite u RSS izvor vesti.</p>

<p>Broj između 5 i 20 je za većinu rečnika normalan. Ako rečnik često nadograđujete, povećajte ovaj broj.</p>';
$string['rsssubscriberss'] = 'Prikazati RSS podršku za \'{$a}\' koncepte';
$string['rsstype'] = 'RSS izvor za ovu aktivnost';
$string['rsstype_help'] = '<p>Ova opcija Vam dopušta da omogućite RSS izvor vesti za tekući rečnik.</p>

<p>Možete birati između dve vrste podrški:</p>

</p><ul><li><b>Sa autorom:</b> Generisani izvori vesti će uključiti ime autora u svakom članu.
</li><li><b>Bez autora:</b>Generisani izvori vesti neće uključiti ime autora u svaki član.</li>
</ul>';
$string['searchindefinition'] = 'Pretraži kompletan tekst';
$string['secondaryglossary'] = 'Sekundarni rečnik';
$string['showall'] = 'Prikaži link \'SVE\'';
$string['showall_help'] = '<p>Možete prilagoditi na koji način želite da omogućite da korisnik pregleda rečnik. Pregledanje i pretraživanje su uvek dostupni, a možete da odredite i još tri opcije:</p>

<p><b>PRIKAŽI SPECIJALNE</b> Omogući ili onemogući prikazivanje po specijalnim karakterima kao što su @, #, itd. </p>

<p><b>PRIKAŽI ABECEDU</b> Omogući ili onemogući abecedno prikazivanje.</p>

<p><b>PRIKAŽI SVE</b> Omogući ili onemogući prikazivanje svih pojmova odjednom.</p>';
$string['showalphabet'] = 'Prikaži linkove azbuke/abecede';
$string['showalphabet_help'] = '<p>Možete prilagoditi na koji način želite da omogućite da korisnik pregleda rečnik. Pregledanje i pretraživanje su uvek dostupni, a možete da odredite i još tri opcije:</p>

<p><b>PRIKAŽI SPECIJALNE</b> Omogući ili onemogući prikazivanje po specijalnim karakterima kao što su @, #, itd. </p>

<p><b>PRIKAŽI ABECEDU</b> Omogući ili onemogući abecedno prikazivanje.</p>

<p><b>PRIKAŽI SVE</b> Omogući ili onemogući prikazivanje svih pojmova odjednom.</p>';
$string['showspecial'] = 'Prikaži link \'Specijalno\'';
$string['showspecial_help'] = '<p>Možete prilagoditi na koji način želite da omogućite da korisnik pregleda rečnik. Pregledanje i pretraživanje su uvek dostupni, a možete da odredite i još tri opcije:</p>

<p><b>PRIKAŽI SPECIJALNE</b> Omogući ili onemogući prikazivanje po specijalnim karakterima kao što su @, #, itd. </p>

<p><b>PRIKAŽI ABECEDU</b> Omogući ili onemogući abecedno prikazivanje.</p>

<p><b>PRIKAŽI SVE</b> Omogući ili onemogući prikazivanje svih pojmova odjednom.</p>';
$string['sortby'] = 'Sortiraj';
$string['sortbycreation'] = 'Po datumu kreiranja';
$string['sortbylastupdate'] = 'Po datumu poslednje izmene';
$string['sortchronogically'] = 'Hronološki';
$string['special'] = 'Specijalno';
$string['standardview'] = 'Pregled po abecedi';
$string['studentcanpost'] = 'Polaznici mogu dodavati pojmove';
$string['totalentries'] = 'Ukupno pojmova';
$string['usedynalink'] = 'Automatski linkuj pojmove iz rečnika';
$string['usedynalink_help'] = '<p>Uključivanje ove opcije omogućuje pojedinačnim pojmovima u tekućem rečniku da budu automatski linkovani kad god se taj pojam ili izraz pojavi negde u okviru tog kursa. To podrazumeva poruke na forumima, unutrašnje resurse, nedeljne preglede itd.</p>

<p>Obratite pažnju na to da omogućavanje linkovanja za rečnik ne uključuje automatski i linkovanje za svaki pojam - linkovanje mora biti podešeno za svaki pojam posebno.</p>

<p>Ako ne želite da određeni tekst bude linkovan (u porukama na forumu, recimo) onda treba da dodate &lt;nolink&gt; ispred i &lt;/nolink&gt; iza teksta. </p>

<p>Zapamtite da se i imena kategorija takođe linkuju.</p>';
$string['waitingapproval'] = 'Čeka na odobrenje';
$string['warningstudentcapost'] = '(Važi samo ako rečnik nije glavni)';
$string['withauthor'] = 'Pojmovi uz navođenje autora';
$string['withoutauthor'] = 'Pojmovi bez navođenja autora';
$string['writtenby'] = 'od';
$string['youarenottheauthor'] = 'Vi niste autor ovog komentara, pa Vam nije dozvoljeno da ga menjate.';
